/*
 * Decompiled with CFR 0.152.
 */
package com.lxinet.jeesns.service.cms.impl;

import com.lxinet.jeesns.core.dto.ResultModel;
import com.lxinet.jeesns.core.enums.MessageType;
import com.lxinet.jeesns.core.exception.OpeErrorException;
import com.lxinet.jeesns.core.exception.ParamException;
import com.lxinet.jeesns.core.model.Page;
import com.lxinet.jeesns.core.service.impl.BaseServiceImpl;
import com.lxinet.jeesns.core.utils.HtmlUtil;
import com.lxinet.jeesns.core.utils.StringUtils;
import com.lxinet.jeesns.core.utils.ValidUtill;
import com.lxinet.jeesns.dao.cms.IArticleDao;
import com.lxinet.jeesns.model.cms.Article;
import com.lxinet.jeesns.model.member.Member;
import com.lxinet.jeesns.service.cms.IArticleCommentService;
import com.lxinet.jeesns.service.cms.IArticleFavorService;
import com.lxinet.jeesns.service.cms.IArticleService;
import com.lxinet.jeesns.service.member.IMemberService;
import com.lxinet.jeesns.service.member.IMessageService;
import com.lxinet.jeesns.service.member.IScoreDetailService;
import com.lxinet.jeesns.service.system.IActionLogService;
import com.lxinet.jeesns.service.system.IConfigService;
import com.lxinet.jeesns.utils.ActionLogType;
import com.lxinet.jeesns.utils.ActionUtil;
import com.lxinet.jeesns.utils.ScoreRuleConsts;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="articleService")
public class ArticleServiceImpl
extends BaseServiceImpl<Article>
implements IArticleService {
    @Resource
    private IArticleDao articleDao;
    @Resource
    private IConfigService configService;
    @Resource
    private IArticleCommentService articleCommentService;
    @Resource
    private IActionLogService actionLogService;
    @Resource
    private IScoreDetailService scoreDetailService;
    @Resource
    private IMessageService messageService;
    @Resource
    private IMemberService memberService;
    @Resource
    private IArticleFavorService articleFavorService;

    public Article findById(Integer id) {
        return this.findById(id, null);
    }

    @Override
    public Article findById(int id, Member loginMember) {
        int loginMemberId = loginMember == null ? 0 : loginMember.getId();
        Article article = this.articleDao.findById(id, loginMemberId);
        this.atFormat(article);
        return article;
    }

    @Override
    @Transactional
    public boolean save(Member member, Article article) {
        boolean result;
        Map<String, String> config = this.configService.getConfigToMap();
        if (member.getIsAdmin() == 0 && "0".equals(config.get("cms_post"))) {
            throw new OpeErrorException("\u6295\u7a3f\u529f\u80fd\u5df2\u5173\u95ed");
        }
        if (article.getCateId() == null || article.getCateId() == 0) {
            throw new ParamException("\u680f\u76ee\u4e0d\u80fd\u4e3a\u7a7a");
        }
        article.setMemberId(member.getId());
        if (member.getIsAdmin() == 0 && "0".equals(config.get("cms_post_review"))) {
            article.setStatus(0);
        } else {
            article.setStatus(1);
        }
        if (article.getViewCount() == null) {
            article.setViewCount(0);
        }
        if (article.getViewRank() == null) {
            article.setViewRank(0);
        }
        if (StringUtils.isEmpty((String)article.getDescription())) {
            String contentStr = HtmlUtil.delHTMLTag((String)article.getContent());
            if (contentStr.length() > 200) {
                article.setDescription(contentStr.substring(0, 200));
            } else {
                article.setDescription(contentStr);
            }
        }
        if (StringUtils.isEmpty((String)article.getThumbnail())) {
            Document doc = Jsoup.parseBodyFragment((String)article.getContent());
            Elements elements = doc.select("img[src]");
            if (elements.size() > 0) {
                String imgsrc = ((Element)elements.get(0)).attr("src");
                article.setThumbnail(imgsrc);
            } else {
                article.setThumbnail(null);
            }
        }
        if (result = super.save((Object)article)) {
            this.messageService.atDeal(member.getId(), article.getContent(), 1, MessageType.CMS_ARTICLE_REFER, article.getId());
            if (article.getStatus() == 1) {
                this.scoreDetailService.scoreBonus(article.getMemberId(), ScoreRuleConsts.ARTICLE_SUBMISSIONS, article.getId());
            }
            this.actionLogService.save(member.getCurrLoginIp(), member.getId(), ActionUtil.POST_ARTICLE, "", ActionLogType.ARTICLE.getValue(), article.getId());
        }
        return true;
    }

    @Override
    public ResultModel listByPage(Page page, String key, int cateid, int status, int memberId) {
        if (StringUtils.isNotBlank((String)key)) {
            key = "%" + key + "%";
        }
        List<Article> list = this.articleDao.list(page, key, cateid, status, memberId);
        ResultModel model = new ResultModel(0, page);
        model.setData(list);
        return model;
    }

    @Override
    public void updateViewCount(int id) {
        this.articleDao.updateViewCount(id);
    }

    @Override
    public boolean audit(int id) {
        if (this.articleDao.audit(id) == 0) {
            throw new OpeErrorException();
        }
        Article article = this.findById(id);
        if (article != null && article.getStatus() == 1) {
            this.scoreDetailService.scoreBonus(article.getMemberId(), ScoreRuleConsts.ARTICLE_SUBMISSIONS, article.getId());
        }
        return true;
    }

    @Override
    public ResultModel favor(Member loginMember, int articleId) {
        String message;
        Article article = this.findById(articleId);
        ValidUtill.checkIsNull((Object)article, (String)"\u6587\u7ae0\u4e0d\u5b58\u5728");
        int favor = article.getFavor();
        if (this.articleFavorService.find(articleId, loginMember.getId()) == null) {
            this.articleDao.favor(articleId, 1);
            this.articleFavorService.save(articleId, loginMember.getId());
            message = "\u559c\u6b22\u6210\u529f";
            ++favor;
            this.scoreDetailService.scoreBonus(loginMember.getId(), ScoreRuleConsts.ARTICLE_RECEIVED_LIKE, articleId);
            this.messageService.diggDeal(loginMember.getId(), article.getMemberId(), 1, MessageType.CMS_ARTICLE_LIKE, article.getId());
        } else {
            this.articleDao.favor(articleId, -1);
            this.articleFavorService.delete(articleId, loginMember.getId());
            message = "\u53d6\u6d88\u559c\u6b22\u6210\u529f";
            --favor;
            this.scoreDetailService.scoreCancelBonus(loginMember.getId(), ScoreRuleConsts.ARTICLE_RECEIVED_LIKE, articleId);
        }
        ResultModel resultModel = new ResultModel(0, message);
        resultModel.setData((Object)favor);
        return resultModel;
    }

    @Override
    public List<Article> listByCustom(int cid, String sort, int num, int day, int thumbnail) {
        return this.articleDao.listByCustom(cid, sort, num, day, thumbnail);
    }

    @Override
    @Transactional
    public boolean update(Member member, Article article) {
        Article findArticle = this.findById(article.getId(), member);
        ValidUtill.checkIsNull((Object)article, (String)"\u6587\u7ae0\u4e0d\u5b58\u5728");
        Map<String, String> config = this.configService.getConfigToMap();
        if (member.getIsAdmin() == 0 && "0".equals(config.get("cms_post_review"))) {
            findArticle.setStatus(0);
        } else {
            findArticle.setStatus(1);
        }
        findArticle.setCateId(article.getCateId());
        findArticle.setTitle(article.getTitle());
        findArticle.setThumbnail(article.getThumbnail());
        findArticle.setContent(article.getContent());
        findArticle.setDescription(article.getDescription());
        findArticle.setKeywords(article.getKeywords());
        if (member.getIsAdmin() == 0) {
            if (member.getId().intValue() != findArticle.getMemberId().intValue()) {
                return false;
            }
        } else {
            findArticle.setSource(article.getSource());
            if (article.getViewCount() != null && article.getViewCount() > 0) {
                findArticle.setViewCount(article.getViewCount());
            }
            findArticle.setWriter(article.getWriter());
            if (article.getViewRank() != null && article.getViewRank() > 0) {
                findArticle.setViewRank(article.getViewRank());
            }
        }
        if (findArticle.getViewCount() == null) {
            findArticle.setViewCount(0);
        }
        if (findArticle.getViewRank() == null) {
            findArticle.setViewRank(0);
        }
        if (StringUtils.isEmpty((String)findArticle.getDescription())) {
            String contentStr = HtmlUtil.delHTMLTag((String)findArticle.getContent());
            if (contentStr.length() > 200) {
                findArticle.setDescription(contentStr.substring(0, 200));
            } else {
                findArticle.setDescription(contentStr);
            }
        }
        if (StringUtils.isEmpty((String)findArticle.getThumbnail())) {
            Document doc = Jsoup.parseBodyFragment((String)findArticle.getContent());
            Elements elements = doc.select("img[src]");
            if (elements.size() > 0) {
                String imgsrc = ((Element)elements.get(0)).attr("src");
                findArticle.setThumbnail(imgsrc);
            } else {
                findArticle.setThumbnail(null);
            }
        }
        this.articleDao.updateObj(findArticle);
        return true;
    }

    @Override
    @Transactional
    public boolean delete(Member member, int id) {
        Article article = this.findById(id);
        ValidUtill.checkIsNull((Object)article, (String)"\u6587\u7ae0\u4e0d\u5b58\u5728");
        boolean result = super.deleteById(Integer.valueOf(id));
        if (!result) {
            throw new OpeErrorException();
        }
        this.scoreDetailService.scoreCancelBonus(member.getId(), ScoreRuleConsts.ARTICLE_SUBMISSIONS, id);
        this.articleCommentService.deleteByArticle(id);
        this.actionLogService.save(member.getCurrLoginIp(), member.getId(), ActionUtil.DELETE_ARTICLE, "ID\uff1a" + article.getId() + "\uff0c\u6807\u9898\uff1a" + article.getTitle());
        return true;
    }

    public Article atFormat(Article article) {
        article.setContent(this.memberService.atFormat(article.getContent()));
        return article;
    }
}

