/*
 * Decompiled with CFR 0.152.
 */
package com.lxinet.jeesns.service.common.impl;

import com.lxinet.jeesns.core.dto.ResultModel;
import com.lxinet.jeesns.core.utils.HtmlUtil;
import com.lxinet.jeesns.core.utils.StringUtils;
import com.lxinet.jeesns.dao.common.IArchiveDao;
import com.lxinet.jeesns.model.common.Archive;
import com.lxinet.jeesns.model.member.Member;
import com.lxinet.jeesns.service.common.IArchiveFavorService;
import com.lxinet.jeesns.service.common.IArchiveService;
import javax.annotation.Resource;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="archiveService")
public class ArchiveServiceImpl
implements IArchiveService {
    @Resource
    private IArchiveDao archiveDao;
    @Resource
    private IArchiveFavorService archiveFavorService;

    @Override
    public Archive findByArchiveId(int id) {
        return this.archiveDao.findByArchiveId(id);
    }

    @Override
    public boolean save(Member member, Archive archive) {
        Document doc;
        Elements elements;
        archive.setMemberId(member.getId());
        if (archive.getViewCount() == null) {
            archive.setViewCount(0);
        }
        if (archive.getViewRank() == null) {
            archive.setViewRank(0);
        }
        if (StringUtils.isEmpty((String)archive.getDescription())) {
            String contentStr = HtmlUtil.delHTMLTag((String)archive.getContent());
            if (contentStr.length() > 200) {
                archive.setDescription(contentStr.substring(0, 200));
            } else {
                archive.setDescription(contentStr);
            }
        }
        if (StringUtils.isEmpty((String)archive.getThumbnail()) && (elements = (doc = Jsoup.parseBodyFragment((String)archive.getContent())).select("img[src]")).size() > 0) {
            String imgsrc = ((Element)elements.get(0)).attr("src");
            archive.setThumbnail(imgsrc);
        }
        return this.archiveDao.save(archive) == 1;
    }

    @Override
    public void updateViewCount(int id) {
        this.archiveDao.updateViewCount(id);
    }

    @Override
    @Transactional
    public ResultModel favor(Member loginMember, int archiveId) {
        ResultModel resultModel;
        if (this.archiveFavorService.find(archiveId, loginMember.getId()) == null) {
            this.archiveDao.favor(archiveId, 1);
            this.archiveFavorService.save(archiveId, loginMember.getId());
            String message = "\u559c\u6b22\u6210\u529f";
            resultModel = new ResultModel(0, message);
        } else {
            this.archiveDao.favor(archiveId, -1);
            this.archiveFavorService.delete(archiveId, loginMember.getId());
            String message = "\u53d6\u6d88\u559c\u6b22\u6210\u529f";
            resultModel = new ResultModel(1, message);
        }
        Archive findArchive = this.findByArchiveId(archiveId);
        resultModel.setData((Object)findArchive.getFavor());
        return resultModel;
    }

    @Override
    public boolean update(Member member, Archive archive) {
        Document doc;
        Elements elements;
        Archive findArchive = this.findByArchiveId(archive.getArchiveId());
        if (findArchive == null) {
            return false;
        }
        findArchive.setTitle(archive.getTitle());
        findArchive.setThumbnail(archive.getThumbnail());
        findArchive.setContent(archive.getContent());
        findArchive.setDescription(archive.getDescription());
        findArchive.setKeywords(archive.getKeywords());
        if (member.getIsAdmin() == 0) {
            if (member.getId().intValue() != findArchive.getMemberId().intValue()) {
                return false;
            }
        } else {
            findArchive.setSource(archive.getSource());
            findArchive.setViewCount(archive.getViewCount());
            findArchive.setWriter(archive.getWriter());
            findArchive.setViewRank(archive.getViewRank());
        }
        if (findArchive.getViewCount() == null) {
            findArchive.setViewCount(0);
        }
        if (findArchive.getViewRank() == null) {
            findArchive.setViewRank(0);
        }
        if (StringUtils.isEmpty((String)findArchive.getDescription())) {
            String contentStr = HtmlUtil.delHTMLTag((String)findArchive.getContent());
            if (contentStr.length() > 200) {
                findArchive.setDescription(contentStr.substring(0, 200));
            } else {
                findArchive.setDescription(contentStr);
            }
        }
        if (StringUtils.isEmpty((String)findArchive.getThumbnail()) && (elements = (doc = Jsoup.parseBodyFragment((String)findArchive.getContent())).select("img[src]")).size() > 0) {
            String imgsrc = ((Element)elements.get(0)).attr("src");
            findArchive.setThumbnail(imgsrc);
        }
        return this.archiveDao.update(findArchive) == 1;
    }

    @Override
    @Transactional
    public boolean delete(int id) {
        return this.archiveDao.delete(id) == 1;
    }
}

