/*
 * Decompiled with CFR 0.152.
 */
package com.lxinet.jeesns.service.group.impl;

import com.lxinet.jeesns.core.dto.ResultModel;
import com.lxinet.jeesns.core.exception.OpeErrorException;
import com.lxinet.jeesns.core.model.Page;
import com.lxinet.jeesns.core.service.impl.BaseServiceImpl;
import com.lxinet.jeesns.dao.group.IGroupFansDao;
import com.lxinet.jeesns.model.group.Group;
import com.lxinet.jeesns.model.group.GroupFans;
import com.lxinet.jeesns.model.member.Member;
import com.lxinet.jeesns.service.group.IGroupFansService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Service;

@Service(value="groupFansService")
public class GroupFansServiceImpl
extends BaseServiceImpl<GroupFans>
implements IGroupFansService {
    @Resource
    private IGroupFansDao groupFansDao;

    @Override
    public ResultModel listByPage(Page page, Integer groupId) {
        List<GroupFans> list = this.groupFansDao.list(page, groupId);
        ResultModel model = new ResultModel(0, page);
        model.setData(list);
        return model;
    }

    @Override
    public GroupFans findByMemberAndGroup(@Param(value="groupId") Integer groupId, @Param(value="memberId") Integer memberId) {
        return this.groupFansDao.findByMemberAndGroup(groupId, memberId);
    }

    @Override
    public boolean save(Member loginMember, Integer groupId) {
        if (null != this.groupFansDao.findByMemberAndGroup(groupId, loginMember.getId())) {
            throw new OpeErrorException("\u5df2\u7ecf\u5173\u6ce8");
        }
        return this.groupFansDao.save(groupId, loginMember.getId()) == 1;
    }

    @Override
    public boolean delete(Member loginMember, Integer groupId) {
        return this.groupFansDao.delete(groupId, loginMember.getId()) > 0;
    }

    @Override
    public ResultModel listByMember(Page page, Integer memberId) {
        List<Group> list = this.groupFansDao.listByMember(page, memberId);
        ResultModel model = new ResultModel(0, page);
        model.setData(list);
        return model;
    }
}

