/*
 * Decompiled with CFR 0.152.
 */
package com.lxinet.jeesns.service.group.impl;

import com.lxinet.jeesns.core.exception.OpeErrorException;
import com.lxinet.jeesns.core.service.impl.BaseServiceImpl;
import com.lxinet.jeesns.core.utils.StringUtils;
import com.lxinet.jeesns.core.utils.ValidUtill;
import com.lxinet.jeesns.dao.group.IGroupDao;
import com.lxinet.jeesns.model.group.Group;
import com.lxinet.jeesns.model.member.Financial;
import com.lxinet.jeesns.model.member.Member;
import com.lxinet.jeesns.model.system.ScoreRule;
import com.lxinet.jeesns.service.group.IGroupFansService;
import com.lxinet.jeesns.service.group.IGroupService;
import com.lxinet.jeesns.service.member.IFinancialService;
import com.lxinet.jeesns.service.member.IMemberService;
import com.lxinet.jeesns.service.member.IScoreDetailService;
import com.lxinet.jeesns.service.system.IActionLogService;
import com.lxinet.jeesns.service.system.IConfigService;
import com.lxinet.jeesns.service.system.IScoreRuleService;
import com.lxinet.jeesns.utils.ActionUtil;
import com.lxinet.jeesns.utils.ScoreRuleConsts;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="groupService")
@Transactional
public class GroupServiceImpl
extends BaseServiceImpl<Group>
implements IGroupService {
    @Resource
    private IGroupDao groupDao;
    @Resource
    private IGroupFansService groupFansService;
    @Resource
    private IMemberService memberService;
    @Resource
    private IConfigService configService;
    @Resource
    private IActionLogService actionLogService;
    @Resource
    private IScoreDetailService scoreDetailService;
    @Resource
    private IScoreRuleService scoreRuleService;
    @Resource
    private IFinancialService financialService;

    @Override
    public List<Group> list(int status, String key) {
        if (StringUtils.isNotBlank((String)key)) {
            key = "%" + key.trim() + "%";
        }
        List<Group> list = this.groupDao.list(status, key);
        return list;
    }

    @Override
    public boolean follow(Member loginMember, Integer groupId, int type) {
        Group group = (Group)this.findById(groupId);
        ValidUtill.checkIsNull((Object)group, (String)"\u7fa4\u7ec4\u4e0d\u5b58\u5728");
        if (type == 0) {
            if (group.getFollowPay() == 1) {
                Date date = new Date();
                if ((loginMember = (Member)this.memberService.findById(loginMember.getId())).getMoney() < group.getPayMoney()) {
                    throw new OpeErrorException("\u60a8\u7684\u8d26\u6237\u4f59\u989d\u4e0d\u8db3\uff0c\u65e0\u6cd5\u52a0\u5165\u8be5\u7fa4\uff0c\u52a0\u5165\u7fa4\u9700\u8981\u6536\u8d39" + group.getPayMoney() + "\u5143\uff0c\u60a8\u7684\u8d26\u6237\u4f59\u989d" + loginMember.getMoney() + "\u5143");
                }
                loginMember.setMoney(loginMember.getMoney() - group.getPayMoney());
                this.memberService.update(loginMember);
                Financial financial = new Financial();
                financial.setBalance(loginMember.getMoney());
                financial.setCreateTime(date);
                financial.setForeignId(group.getId());
                financial.setMemberId(loginMember.getId());
                financial.setMoney(group.getPayMoney());
                financial.setType(1);
                financial.setPaymentId(1);
                financial.setRemark("\u52a0\u5165\u7fa4\uff1a" + group.getName());
                financial.setOperator(loginMember.getName());
                this.financialService.save(financial);
                Member findMember = (Member)this.memberService.findById(group.getCreator());
                findMember.setMoney(findMember.getMoney() + group.getPayMoney());
                this.memberService.update(findMember);
                Financial creFinancial = new Financial();
                creFinancial.setBalance(findMember.getMoney());
                creFinancial.setCreateTime(date);
                creFinancial.setForeignId(group.getId());
                creFinancial.setMemberId(findMember.getId());
                creFinancial.setMoney(group.getPayMoney());
                creFinancial.setType(0);
                creFinancial.setPaymentId(1);
                creFinancial.setRemark("\u4f1a\u5458\u52a0\u7fa4\uff1a" + group.getName());
                creFinancial.setOperator(loginMember.getName());
                this.financialService.save(creFinancial);
            }
            return this.groupFansService.save(loginMember, groupId);
        }
        if (loginMember.getId().intValue() == group.getCreator().intValue()) {
            throw new OpeErrorException("\u7ba1\u7406\u5458\u4e0d\u80fd\u9000\u51fa");
        }
        return this.groupFansService.delete(loginMember, groupId);
    }

    @Override
    public boolean changeStatus(int id) {
        return this.groupDao.changeStatus(id) == 1;
    }

    @Override
    public List<Group> listByCustom(int status, int num, String sort) {
        return this.groupDao.listByCustom(status, num, sort);
    }

    @Override
    public Group findById(int id) {
        return this.groupDao.findById(id);
    }

    @Override
    @Transactional
    public boolean save(Member loginMember, Group group) {
        boolean result;
        loginMember = (Member)this.memberService.findById(loginMember.getId());
        Map<String, String> config = this.configService.getConfigToMap();
        group.setCreator(loginMember.getId());
        if (loginMember.getIsAdmin() > 0) {
            group.setStatus(1);
        } else {
            if ("0".equals(config.get("group_apply"))) {
                throw new OpeErrorException("\u7fa4\u7ec4\u7533\u8bf7\u529f\u80fd\u5df2\u5173\u95ed");
            }
            ScoreRule scoreRule = this.scoreRuleService.findById(ScoreRuleConsts.APPLY_GROUP);
            if (scoreRule != null && loginMember.getScore() < Math.abs(scoreRule.getScore())) {
                throw new OpeErrorException("\u8d26\u6237\u79ef\u5206\u4e0d\u8db3\u65e0\u6cd5\u7533\u8bf7\u7fa4\u7ec4\uff0c\u7533\u8bf7\u7fa4\u7ec4\u9700\u8981\u79ef\u5206\uff1a" + Math.abs(scoreRule.getScore()) + "\uff0c\u5f53\u524d\u79ef\u5206\u4f59\u989d\u4e3a\uff1a" + loginMember.getScore());
            }
            if ("0".equals(config.get("group_apply_review"))) {
                group.setStatus(0);
            } else {
                group.setStatus(1);
            }
        }
        if (StringUtils.isEmpty((String)group.getLogo())) {
            group.setLogo("/res/common/images/nopic.png");
        }
        String managerIds = String.valueOf(loginMember.getId());
        group.setManagers(managerIds);
        group.setCanPost(1);
        group.setTopicReview(0);
        if (group.getFollowPay() == 0) {
            group.setPayMoney(0.0);
        }
        boolean bl = result = this.groupDao.save(group) == 1;
        if (result) {
            this.groupFansService.save(loginMember, group.getId());
            this.scoreDetailService.scoreBonus(loginMember.getId(), ScoreRuleConsts.APPLY_GROUP, group.getId());
        }
        return result;
    }

    @Override
    public boolean update(Member loginMember, Group group) {
        Group findGroup = (Group)this.findById(group.getId());
        ValidUtill.checkIsNull((Object)findGroup, (String)"\u7fa4\u7ec4\u4e0d\u5b58\u5728");
        if (loginMember.getId().intValue() != findGroup.getCreator().intValue()) {
            throw new OpeErrorException("\u6ca1\u6709\u6743\u9650");
        }
        String managerNames = group.getManagers();
        String managerIds = "";
        String[] names = managerNames.split(",");
        if (names.length > 10) {
            throw new OpeErrorException("\u7ba1\u7406\u5458\u4e0d\u80fd\u8d85\u8fc710\u4e2a");
        }
        for (String name : names) {
            Member member = this.memberService.findByName(name.trim());
            if (member == null) continue;
            managerIds = managerIds + member.getId() + ",";
        }
        if (managerIds.length() > 0) {
            managerIds = managerIds.substring(0, managerIds.length() - 1);
        }
        if (StringUtils.isNotEmpty((String)group.getLogo())) {
            findGroup.setLogo(group.getLogo());
        }
        findGroup.setManagers(managerIds);
        findGroup.setName(group.getName());
        findGroup.setTags(group.getTags());
        findGroup.setCanPost(group.getCanPost());
        findGroup.setTopicReview(group.getTopicReview());
        findGroup.setIntroduce(group.getIntroduce());
        findGroup.setTypeId(group.getTypeId());
        findGroup.setPayMoney(group.getPayMoney());
        return this.groupDao.update(findGroup) == 1;
    }

    @Override
    public boolean delete(Member loginMember, int id) {
        boolean result;
        Group findGroup = this.findById(id);
        ValidUtill.checkIsNull((Object)findGroup, (String)"\u7fa4\u7ec4\u4e0d\u5b58\u5728");
        boolean bl = result = this.groupDao.delete(id) == 1;
        if (result) {
            this.actionLogService.save(loginMember.getCurrLoginIp(), loginMember.getId(), ActionUtil.DELETE_GROUP, "ID\uff1a" + findGroup.getId() + "\uff0c\u540d\u5b57\uff1a" + findGroup.getName());
        }
        return result;
    }
}

