/*
 * Decompiled with CFR 0.152.
 */
package com.lxinet.jeesns.service.group.impl;

import com.lxinet.jeesns.core.dto.ResultModel;
import com.lxinet.jeesns.core.enums.MessageType;
import com.lxinet.jeesns.core.model.Page;
import com.lxinet.jeesns.core.service.impl.BaseServiceImpl;
import com.lxinet.jeesns.core.utils.ValidUtill;
import com.lxinet.jeesns.dao.group.IGroupTopicCommentDao;
import com.lxinet.jeesns.model.group.GroupTopic;
import com.lxinet.jeesns.model.group.GroupTopicComment;
import com.lxinet.jeesns.model.member.Member;
import com.lxinet.jeesns.service.group.IGroupTopicCommentService;
import com.lxinet.jeesns.service.group.IGroupTopicService;
import com.lxinet.jeesns.service.member.IMemberService;
import com.lxinet.jeesns.service.member.IMessageService;
import com.lxinet.jeesns.service.member.IScoreDetailService;
import com.lxinet.jeesns.service.system.IActionLogService;
import com.lxinet.jeesns.utils.ActionUtil;
import com.lxinet.jeesns.utils.ScoreRuleConsts;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="groupTopicCommentService")
public class GroupTopicCommentServiceImpl
extends BaseServiceImpl<GroupTopicComment>
implements IGroupTopicCommentService {
    @Resource
    private IGroupTopicCommentDao groupTopicCommentDao;
    @Resource
    private IGroupTopicService groupTopicService;
    @Resource
    private IActionLogService actionLogService;
    @Resource
    private IScoreDetailService scoreDetailService;
    @Resource
    private IMessageService messageService;
    @Resource
    private IMemberService memberService;

    @Override
    public GroupTopicComment findById(int id) {
        return this.atFormat(this.groupTopicCommentDao.findById(id));
    }

    @Override
    public boolean save(Member loginMember, String content, Integer groupTopicId, Integer commentId) {
        GroupTopic groupTopic = this.groupTopicService.findById(groupTopicId, loginMember);
        ValidUtill.checkIsNull((Object)groupTopic, (String)"\u5e16\u5b50\u4e0d\u5b58\u5728");
        ValidUtill.checkIsNull((Object)content, (String)"\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        GroupTopicComment groupTopicComment = new GroupTopicComment();
        groupTopicComment.setMemberId(loginMember.getId());
        groupTopicComment.setGroupTopicId(groupTopicId);
        groupTopicComment.setContent(content);
        groupTopicComment.setCommentId(commentId);
        int result = this.groupTopicCommentDao.saveObj(groupTopicComment);
        if (result == 1) {
            GroupTopicComment replyGroupTopicComment;
            this.messageService.atDeal(loginMember.getId(), content, 3, MessageType.GROUP_TOPIC_COMMENT_REFER, groupTopicComment.getId());
            this.messageService.diggDeal(loginMember.getId(), groupTopic.getMemberId(), content, 3, MessageType.GROUP_TOPIC_REPLY, groupTopic.getId());
            if (commentId != null && (replyGroupTopicComment = (GroupTopicComment)this.findById(commentId)) != null) {
                this.messageService.diggDeal(loginMember.getId(), replyGroupTopicComment.getMemberId(), content, 3, MessageType.GROUP_TOPIC_REPLY_REPLY, replyGroupTopicComment.getId());
            }
            this.scoreDetailService.scoreBonus(loginMember.getId(), ScoreRuleConsts.GROUP_TOPIC_COMMENTS, groupTopicComment.getId());
        }
        return result == 1;
    }

    @Override
    public ResultModel listByGroupTopic(Page page, int groupTopicId) {
        List<GroupTopicComment> list = this.groupTopicCommentDao.listByGroupTopic(page, groupTopicId);
        this.atFormat(list);
        ResultModel model = new ResultModel(0, page);
        model.setData(list);
        return model;
    }

    @Override
    public void deleteByTopic(int groupTopicId) {
        this.groupTopicCommentDao.deleteByTopic(groupTopicId);
    }

    @Override
    public boolean delete(Member loginMember, int id) {
        GroupTopicComment groupTopicComment = this.findById(id);
        ValidUtill.checkIsNull((Object)groupTopicComment, (String)"\u8bc4\u8bba\u4e0d\u5b58\u5728");
        boolean result = super.deleteById(Integer.valueOf(id));
        if (result) {
            this.scoreDetailService.scoreCancelBonus(loginMember.getId(), ScoreRuleConsts.GROUP_TOPIC_COMMENTS, id);
            this.actionLogService.save(loginMember.getCurrLoginIp(), loginMember.getId(), ActionUtil.DELETE_GROUP_TOPIC_COMMENT, "ID\uff1a" + groupTopicComment.getId() + "\uff0c\u5185\u5bb9\uff1a" + groupTopicComment.getContent());
        }
        return result;
    }

    public GroupTopicComment atFormat(GroupTopicComment groupTopicComment) {
        groupTopicComment.setContent(this.memberService.atFormat(groupTopicComment.getContent()));
        return groupTopicComment;
    }

    public List<GroupTopicComment> atFormat(List<GroupTopicComment> groupTopicCommentList) {
        for (GroupTopicComment groupTopicComment : groupTopicCommentList) {
            this.atFormat(groupTopicComment);
        }
        return groupTopicCommentList;
    }
}

