/*
 * Decompiled with CFR 0.152.
 */
package com.lxinet.jeesns.service.group.impl;

import com.lxinet.jeesns.core.dto.ResultModel;
import com.lxinet.jeesns.core.enums.MessageType;
import com.lxinet.jeesns.core.exception.OpeErrorException;
import com.lxinet.jeesns.core.exception.ParamException;
import com.lxinet.jeesns.core.model.Page;
import com.lxinet.jeesns.core.service.impl.BaseServiceImpl;
import com.lxinet.jeesns.core.utils.HtmlUtil;
import com.lxinet.jeesns.core.utils.StringUtils;
import com.lxinet.jeesns.core.utils.ValidUtill;
import com.lxinet.jeesns.dao.group.IGroupTopicDao;
import com.lxinet.jeesns.model.group.Group;
import com.lxinet.jeesns.model.group.GroupTopic;
import com.lxinet.jeesns.model.member.Member;
import com.lxinet.jeesns.service.group.IGroupFansService;
import com.lxinet.jeesns.service.group.IGroupService;
import com.lxinet.jeesns.service.group.IGroupTopicCommentService;
import com.lxinet.jeesns.service.group.IGroupTopicFavorService;
import com.lxinet.jeesns.service.group.IGroupTopicService;
import com.lxinet.jeesns.service.member.IMemberService;
import com.lxinet.jeesns.service.member.IMessageService;
import com.lxinet.jeesns.service.member.IScoreDetailService;
import com.lxinet.jeesns.service.system.IActionLogService;
import com.lxinet.jeesns.utils.ActionLogType;
import com.lxinet.jeesns.utils.ActionUtil;
import com.lxinet.jeesns.utils.ScoreRuleConsts;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="groupTopicService")
public class GroupTopicServiceImpl
extends BaseServiceImpl<GroupTopic>
implements IGroupTopicService {
    @Resource
    private IGroupTopicDao groupTopicDao;
    @Resource
    private IGroupService groupService;
    @Resource
    private IGroupTopicCommentService groupTopicCommentService;
    @Resource
    private IGroupFansService groupFansService;
    @Resource
    private IActionLogService actionLogService;
    @Resource
    private IScoreDetailService scoreDetailService;
    @Resource
    private IMessageService messageService;
    @Resource
    private IMemberService memberService;
    @Resource
    private IGroupTopicFavorService groupTopicFavorService;

    @Override
    public GroupTopic findById(int id) {
        return this.findById(id, null);
    }

    @Override
    public GroupTopic findById(int id, Member loginMember) {
        int loginMemberId = loginMember == null ? 0 : loginMember.getId();
        return this.atFormat(this.groupTopicDao.findById(id, loginMemberId));
    }

    @Override
    @Transactional
    public boolean save(Member member, GroupTopic groupTopic) {
        if (groupTopic.getGroupId() == null || groupTopic.getGroupId() == 0) {
            throw new ParamException();
        }
        Group group = (Group)this.groupService.findById(groupTopic.getGroupId());
        ValidUtill.checkIsNull((Object)group, (String)"\u7fa4\u7ec4\u4e0d\u5b58\u5728");
        if (this.groupFansService.findByMemberAndGroup(group.getId(), member.getId()) == null) {
            throw new OpeErrorException("\u5fc5\u987b\u5173\u6ce8\u8be5\u7fa4\u7ec4\u540e\u624d\u80fd\u53d1\u5e16");
        }
        if (group.getCanPost() == 0) {
            throw new OpeErrorException("\u7fa4\u7ec4\u5df2\u5173\u95ed\u53d1\u5e16\u529f\u80fd");
        }
        groupTopic.setMemberId(member.getId());
        groupTopic.setStatus(group.getTopicReview() == 0 ? 1 : 0);
        int result = this.groupTopicDao.saveObj(groupTopic);
        if (result == 1) {
            this.messageService.atDeal(member.getId(), groupTopic.getContent(), 3, MessageType.GROUP_TOPIC_REFER, groupTopic.getId());
            this.scoreDetailService.scoreBonus(member.getId(), ScoreRuleConsts.GROUP_POST, groupTopic.getId());
            this.actionLogService.save(member.getCurrLoginIp(), member.getId(), ActionUtil.POST_GROUP_TOPIC, "", ActionLogType.GROUP_TOPIC.getValue(), groupTopic.getId());
        }
        return result == 1;
    }

    @Override
    public ResultModel listByPage(Page page, String key, int groupId, int status, int memberId, int typeId) {
        if (StringUtils.isNotBlank((String)key)) {
            key = "%" + key + "%";
        }
        List<GroupTopic> list = this.groupTopicDao.list(page, key, groupId, status, memberId, typeId);
        ResultModel model = new ResultModel(0, page);
        model.setData(list);
        return model;
    }

    @Override
    public boolean update(Member member, GroupTopic groupTopic) {
        GroupTopic findGroupTopic = this.findById(groupTopic.getId(), member);
        ValidUtill.checkIsNull((Object)findGroupTopic, (String)"\u5e16\u5b50\u4e0d\u5b58\u5728");
        if (member.getId().intValue() != findGroupTopic.getMember().getId().intValue()) {
            throw new OpeErrorException("\u6ca1\u6709\u6743\u9650");
        }
        if (groupTopic.getTypeId() != null && !groupTopic.getTypeId().equals(findGroupTopic.getTypeId())) {
            this.groupTopicDao.updateType(groupTopic.getId(), groupTopic.getTypeId());
        }
        findGroupTopic.setTitle(groupTopic.getTitle());
        findGroupTopic.setThumbnail(groupTopic.getThumbnail());
        findGroupTopic.setContent(groupTopic.getContent());
        findGroupTopic.setDescription(groupTopic.getDescription());
        findGroupTopic.setKeywords(groupTopic.getKeywords());
        if (member.getIsAdmin() == 0) {
            if (member.getId().intValue() != findGroupTopic.getMemberId().intValue()) {
                return false;
            }
        } else {
            findGroupTopic.setSource(groupTopic.getSource());
            if (groupTopic.getViewCount() != null && groupTopic.getViewCount() > 0) {
                findGroupTopic.setViewCount(groupTopic.getViewCount());
            }
            findGroupTopic.setWriter(groupTopic.getWriter());
            if (groupTopic.getViewRank() != null && groupTopic.getViewRank() > 0) {
                findGroupTopic.setViewRank(groupTopic.getViewRank());
            }
        }
        if (findGroupTopic.getViewCount() == null) {
            findGroupTopic.setViewCount(0);
        }
        if (findGroupTopic.getViewRank() == null) {
            findGroupTopic.setViewRank(0);
        }
        if (StringUtils.isEmpty((String)findGroupTopic.getDescription())) {
            String contentStr = HtmlUtil.delHTMLTag((String)findGroupTopic.getContent());
            if (contentStr.length() > 200) {
                findGroupTopic.setDescription(contentStr.substring(0, 200));
            } else {
                findGroupTopic.setDescription(contentStr);
            }
        }
        if (StringUtils.isEmpty((String)findGroupTopic.getThumbnail())) {
            Document doc = Jsoup.parseBodyFragment((String)findGroupTopic.getContent());
            Elements elements = doc.select("img[src]");
            if (elements.size() > 0) {
                String imgsrc = ((Element)elements.get(0)).attr("src");
                findGroupTopic.setThumbnail(imgsrc);
            } else {
                findGroupTopic.setThumbnail(null);
            }
        }
        return this.groupTopicDao.updateObj(findGroupTopic) == 1;
    }

    @Override
    @Transactional
    public boolean delete(Member loginMember, int id) {
        GroupTopic groupTopic = this.findById(id);
        ValidUtill.checkIsNull((Object)groupTopic, (String)"\u5e16\u5b50\u4e0d\u5b58\u5728");
        int result = this.groupTopicDao.delete(id);
        if (result == 1) {
            this.scoreDetailService.scoreCancelBonus(loginMember.getId(), ScoreRuleConsts.GROUP_POST, id);
            this.groupTopicCommentService.deleteByTopic(id);
            this.actionLogService.save(loginMember.getCurrLoginIp(), loginMember.getId(), ActionUtil.DELETE_GROUP_TOPIC, "ID\uff1a" + groupTopic.getId() + "\uff0c\u6807\u9898\uff1a" + groupTopic.getTitle());
        }
        return result == 1;
    }

    @Override
    @Transactional
    public boolean indexDelete(HttpServletRequest request, Member loginMember, int id) {
        GroupTopic groupTopic = this.findById(id, loginMember);
        ValidUtill.checkIsNull((Object)groupTopic, (String)"\u5e16\u5b50\u4e0d\u5b58\u5728");
        Group group = (Group)this.groupService.findById(groupTopic.getGroup().getId());
        ValidUtill.checkIsNull((Object)group);
        String groupManagers = group.getManagers();
        String[] groupManagerArr = groupManagers.split(",");
        boolean isManager = false;
        for (String manager : groupManagerArr) {
            if (loginMember.getId() != Integer.parseInt(manager)) continue;
            isManager = true;
        }
        if (loginMember.getId().intValue() == groupTopic.getMember().getId().intValue() || loginMember.getIsAdmin() > 0 || isManager || loginMember.getId().intValue() == group.getCreator().intValue()) {
            boolean flag = this.delete(loginMember, id);
            return flag;
        }
        throw new OpeErrorException("\u6ca1\u6709\u6743\u9650");
    }

    @Override
    public boolean audit(Member member, int id) {
        GroupTopic groupTopic = this.findById(id, member);
        ValidUtill.checkIsNull((Object)groupTopic, (String)"\u5e16\u5b50\u4e0d\u5b58\u5728");
        Group group = (Group)this.groupService.findById(groupTopic.getGroup().getId());
        ValidUtill.checkIsNull((Object)group);
        String groupManagers = group.getManagers();
        String[] groupManagerArr = groupManagers.split(",");
        boolean isManager = false;
        for (String manager : groupManagerArr) {
            if (member.getId() != Integer.parseInt(manager)) continue;
            isManager = true;
        }
        if (member.getId().intValue() == groupTopic.getMember().getId().intValue() || member.getIsAdmin() > 0 || isManager || member.getId().intValue() == group.getCreator().intValue()) {
            return this.groupTopicDao.audit(id) == 1;
        }
        throw new OpeErrorException("\u6ca1\u6709\u6743\u9650");
    }

    @Override
    public boolean top(Member member, int id, int top) {
        GroupTopic groupTopic = this.findById(id, member);
        ValidUtill.checkIsNull((Object)groupTopic, (String)"\u5e16\u5b50\u4e0d\u5b58\u5728");
        Group group = (Group)this.groupService.findById(groupTopic.getGroup().getId());
        ValidUtill.checkIsNull((Object)group);
        String groupManagers = group.getManagers();
        String[] groupManagerArr = groupManagers.split(",");
        boolean isManager = false;
        for (String manager : groupManagerArr) {
            if (member.getId() != Integer.parseInt(manager)) continue;
            isManager = true;
        }
        if (member.getId().intValue() == groupTopic.getMember().getId().intValue() || member.getIsAdmin() > 0 || isManager || member.getId().intValue() == group.getCreator().intValue()) {
            return this.groupTopicDao.top(id, top) == 1;
        }
        throw new OpeErrorException("\u6ca1\u6709\u6743\u9650");
    }

    @Override
    public boolean essence(Member member, int id, int essence) {
        GroupTopic groupTopic = this.findById(id, member);
        ValidUtill.checkIsNull((Object)groupTopic, (String)"\u5e16\u5b50\u4e0d\u5b58\u5728");
        Group group = (Group)this.groupService.findById(groupTopic.getGroup().getId());
        ValidUtill.checkIsNull((Object)group);
        String groupManagers = group.getManagers();
        String[] groupManagerArr = groupManagers.split(",");
        boolean isManager = false;
        for (String manager : groupManagerArr) {
            if (member.getId() != Integer.parseInt(manager)) continue;
            isManager = true;
        }
        if (member.getId().intValue() == groupTopic.getMember().getId().intValue() || member.getIsAdmin() > 0 || isManager || member.getId().intValue() == group.getCreator().intValue()) {
            return this.groupTopicDao.essence(id, essence) == 1;
        }
        throw new OpeErrorException("\u6ca1\u6709\u6743\u9650");
    }

    @Override
    public ResultModel favor(Member loginMember, int id) {
        String message;
        GroupTopic groupTopic = this.findById(id);
        ValidUtill.checkIsNull((Object)groupTopic, (String)"\u5e16\u5b50\u4e0d\u5b58\u5728");
        int favor = groupTopic.getFavor();
        if (this.groupTopicFavorService.find(id, loginMember.getId()) == null) {
            this.groupTopicDao.favor(id, 1);
            this.groupTopicFavorService.save(id, loginMember.getId());
            message = "\u559c\u6b22\u6210\u529f";
            ++favor;
            this.scoreDetailService.scoreBonus(loginMember.getId(), ScoreRuleConsts.GROUP_TOPIC_RECEIVED_LIKE, id);
            this.messageService.diggDeal(loginMember.getId(), groupTopic.getMemberId(), 3, MessageType.GROUP_TOPIC_LIKE, groupTopic.getId());
        } else {
            this.groupTopicDao.favor(id, -1);
            this.groupTopicFavorService.delete(id, loginMember.getId());
            message = "\u53d6\u6d88\u559c\u6b22\u6210\u529f";
            --favor;
            this.scoreDetailService.scoreCancelBonus(loginMember.getId(), ScoreRuleConsts.GROUP_TOPIC_RECEIVED_LIKE, id);
        }
        ResultModel resultModel = new ResultModel(0, message);
        resultModel.setData((Object)favor);
        return resultModel;
    }

    @Override
    public List<GroupTopic> listByCustom(int gid, String sort, int num, int day, int thumbnail) {
        return this.groupTopicDao.listByCustom(gid, sort, num, day, thumbnail);
    }

    @Override
    public void updateViewCount(int id) {
        this.groupTopicDao.updateViewCount(id);
    }

    public GroupTopic atFormat(GroupTopic groupTopic) {
        groupTopic.setContent(this.memberService.atFormat(groupTopic.getContent()));
        return groupTopic;
    }
}

