/*
 * Decompiled with CFR 0.152.
 */
package com.lxinet.jeesns.service.member.impl;

import com.lxinet.jeesns.core.exception.OpeErrorException;
import com.lxinet.jeesns.core.model.Page;
import com.lxinet.jeesns.core.service.impl.BaseServiceImpl;
import com.lxinet.jeesns.dao.member.ICheckinDao;
import com.lxinet.jeesns.model.member.Checkin;
import com.lxinet.jeesns.service.member.ICheckinService;
import com.lxinet.jeesns.service.member.IScoreDetailService;
import com.lxinet.jeesns.utils.ScoreRuleConsts;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CheckinServiceImpl
extends BaseServiceImpl<Checkin>
implements ICheckinService {
    @Resource
    private ICheckinDao checkinDao;
    @Resource
    private IScoreDetailService scoreDetailService;

    @Override
    public List<Checkin> list(Page page, Integer memberId) {
        List<Checkin> list = this.checkinDao.list(page, memberId);
        return list;
    }

    @Override
    public List<Checkin> todayList(Page page) {
        List<Checkin> list = this.checkinDao.todayList(page);
        return list;
    }

    @Override
    public List<Checkin> todayContinueList() {
        return this.checkinDao.todayContinueList();
    }

    @Override
    public Checkin todayCheckin(Integer memberId) {
        return this.checkinDao.todayCheckin(memberId);
    }

    @Override
    public Checkin yesterdayCheckin(Integer memberId) {
        return this.checkinDao.yesterdayCheckin(memberId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public boolean save(Integer memberId) {
        CheckinServiceImpl checkinServiceImpl = this;
        synchronized (checkinServiceImpl) {
            boolean result;
            if (null != this.todayCheckin(memberId)) {
                throw new OpeErrorException("\u4eca\u5929\u5df2\u7ecf\u7b7e\u5230\u8fc7\u4e86");
            }
            Checkin checkin = new Checkin();
            checkin.setMemberId(memberId);
            Checkin yesterdayCheckin = this.yesterdayCheckin(memberId);
            if (null != yesterdayCheckin) {
                checkin.setContinueDay(yesterdayCheckin.getContinueDay() + 1);
            } else {
                checkin.setContinueDay(1);
            }
            boolean bl = result = this.checkinDao.saveObj(checkin) == 1;
            if (result) {
                this.scoreDetailService.scoreBonus(memberId, ScoreRuleConsts.CHECKIN, checkin.getId());
            }
            return result;
        }
    }
}

