/*
 * Decompiled with CFR 0.152.
 */
package com.lxinet.jeesns.service.member.impl;

import com.lxinet.jeesns.core.dto.ResultModel;
import com.lxinet.jeesns.core.exception.NotLoginException;
import com.lxinet.jeesns.core.exception.OpeErrorException;
import com.lxinet.jeesns.core.model.Page;
import com.lxinet.jeesns.core.service.impl.BaseServiceImpl;
import com.lxinet.jeesns.core.utils.AtUtil;
import com.lxinet.jeesns.core.utils.IpUtil;
import com.lxinet.jeesns.core.utils.Md5Util;
import com.lxinet.jeesns.core.utils.RandomCodeUtil;
import com.lxinet.jeesns.core.utils.StringUtils;
import com.lxinet.jeesns.dao.member.IMemberDao;
import com.lxinet.jeesns.model.member.Member;
import com.lxinet.jeesns.model.member.ValidateCode;
import com.lxinet.jeesns.service.member.IFinancialService;
import com.lxinet.jeesns.service.member.IMemberFansService;
import com.lxinet.jeesns.service.member.IMemberService;
import com.lxinet.jeesns.service.member.IScoreDetailService;
import com.lxinet.jeesns.service.member.IValidateCodeService;
import com.lxinet.jeesns.service.system.IActionLogService;
import com.lxinet.jeesns.service.system.IConfigService;
import com.lxinet.jeesns.utils.ActionUtil;
import com.lxinet.jeesns.utils.EmailSendUtil;
import com.lxinet.jeesns.utils.MemberUtil;
import com.lxinet.jeesns.utils.ScoreRuleConsts;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="memberService")
public class MemberServiceImpl
extends BaseServiceImpl<Member>
implements IMemberService {
    @Resource
    private IMemberDao memberDao;
    @Resource
    private IValidateCodeService validateCodeService;
    @Resource
    private IConfigService configService;
    @Resource
    private IActionLogService actionLogService;
    @Resource
    private IMemberFansService memberFansService;
    @Resource
    private IScoreDetailService scoreDetailService;
    @Resource
    private IFinancialService financialService;

    @Override
    public boolean login(Member member, HttpServletRequest request) {
        Map<String, String> config = this.configService.getConfigToMap();
        if ("0".equals(config.get("member_login_open"))) {
            throw new OpeErrorException("\u767b\u5f55\u529f\u80fd\u5df2\u5173\u95ed");
        }
        String password = member.getPassword();
        member.setPassword(Md5Util.getMD5Code((String)member.getPassword()));
        Member findMember = this.memberDao.login(member);
        if (null == findMember) {
            this.actionLogService.save(IpUtil.getIpAddress((HttpServletRequest)request), null, ActionUtil.MEMBER_LOGIN_ERROR, "\u767b\u5f55\u7528\u6237\u540d\uff1a" + member.getName() + "\uff0c\u767b\u5f55\u5bc6\u7801\uff1a" + password);
            throw new OpeErrorException("\u7528\u6237\u540d\u6216\u8005\u5bc6\u7801\u9519\u8bef");
        }
        if (findMember.getStatus() == -1) {
            throw new OpeErrorException("\u8d26\u53f7\u5df2\u88ab\u7981\u7528");
        }
        this.memberDao.loginSuccess(findMember.getId(), IpUtil.getIpAddress((HttpServletRequest)request));
        findMember = this.findById(findMember.getId());
        MemberUtil.setLoginMember(request, findMember);
        this.actionLogService.save(findMember.getCurrLoginIp(), findMember.getId(), ActionUtil.MEMBER_LOGIN);
        this.scoreDetailService.scoreBonus(findMember.getId(), ScoreRuleConsts.LOGIN);
        return true;
    }

    @Override
    public Member manageLogin(Member member, HttpServletRequest request) {
        String password = member.getPassword();
        member.setPassword(Md5Util.getMD5Code((String)member.getPassword()));
        Member findMember = this.memberDao.manageLogin(member);
        if (findMember != null) {
            this.memberDao.loginSuccess(findMember.getId(), IpUtil.getIpAddress((HttpServletRequest)request));
            findMember = this.findById(findMember.getId());
        } else {
            this.actionLogService.save(IpUtil.getIpAddress((HttpServletRequest)request), null, ActionUtil.MEMBER_LOGIN_ERROR, "\u767b\u5f55\u7528\u6237\u540d\uff1a" + member.getName() + "\uff0c\u767b\u5f55\u5bc6\u7801\uff1a" + password);
        }
        return findMember;
    }

    public Member findById(Integer id) {
        return this.memberDao.findById(id);
    }

    @Override
    @Transactional
    public ResultModel register(Member member, HttpServletRequest request) {
        if (this.memberDao.findByName(member.getName()) != null) {
            throw new OpeErrorException("\u7528\u6237\u540d\u5df2\u5b58\u5728");
        }
        if (this.memberDao.findByEmail(member.getEmail()) != null) {
            throw new OpeErrorException("\u90ae\u7bb1\u5df2\u5b58\u5728");
        }
        member.setRegip(IpUtil.getIpAddress((HttpServletRequest)request));
        member.setPassword(Md5Util.getMD5Code((String)member.getPassword()));
        member.setAvatar("/res/common/images/default-avatar.png");
        if (this.memberDao.register(member) == 1) {
            this.actionLogService.save(member.getRegip(), member.getId(), ActionUtil.MEMBER_REG);
            this.scoreDetailService.scoreBonus(member.getId(), ScoreRuleConsts.REG_INIT);
            return new ResultModel(2, "\u6ce8\u518c\u6210\u529f", request.getServletContext().getContextPath() + "/member/login");
        }
        return new ResultModel(-1, "\u6ce8\u518c\u5931\u8d25");
    }

    @Override
    public ResultModel delete(int id) {
        if (super.deleteById(Integer.valueOf(id))) {
            return new ResultModel(1, "\u5220\u9664\u6210\u529f");
        }
        return new ResultModel(-1, "\u5220\u9664\u5931\u8d25");
    }

    @Override
    public ResultModel<Member> listByPage(Page page, String key) {
        if (StringUtils.isNotBlank((String)key)) {
            key = "%" + key.trim() + "%";
        }
        List<Member> list = this.memberDao.list(page, key);
        ResultModel model = new ResultModel(0, page);
        model.setData(list);
        return model;
    }

    @Override
    public ResultModel<Member> managerList(Page page, String key) {
        if (StringUtils.isNotBlank((String)key)) {
            key = "%" + key.trim() + "%";
        }
        List<Member> list = this.memberDao.managerList(page, key);
        ResultModel model = new ResultModel(0, page);
        model.setData(list);
        return model;
    }

    @Override
    public ResultModel managerAdd(Member loginMember, String name) {
        int isAdmin = 1;
        Member findMember = this.findByName(name);
        if (findMember == null) {
            return new ResultModel(-1, "\u4f1a\u5458[" + name + "]\u4e0d\u5b58\u5728");
        }
        if (findMember.getId() == 1 && findMember.getIsAdmin() == 1) {
            isAdmin = 2;
        }
        if (isAdmin == 1 && loginMember.getId().intValue() == findMember.getId().intValue()) {
            return new ResultModel(-1, "\u4e0d\u80fd\u64cd\u4f5c\u81ea\u5df1\u7684\u8d26\u53f7");
        }
        if (isAdmin != 2 && findMember.getIsAdmin() > 0) {
            return new ResultModel(-1, "\u4f1a\u5458[" + name + "]\u5df2\u7ecf\u662f\u7ba1\u7406\u5458\uff0c\u65e0\u9700\u518d\u6388\u6743");
        }
        this.memberDao.managerAddAndCancel(isAdmin, findMember.getId());
        if (isAdmin == 2) {
            loginMember.setIsAdmin(isAdmin);
        }
        return new ResultModel(3, "\u64cd\u4f5c\u6210\u529f");
    }

    @Override
    public ResultModel managerCancel(Member loginMember, int id) {
        Member findMember = this.findById(id);
        if (loginMember.getId().intValue() == findMember.getId().intValue()) {
            return new ResultModel(-1, "\u4e0d\u80fd\u64cd\u4f5c\u81ea\u5df1\u7684\u8d26\u53f7");
        }
        if (findMember == null) {
            return new ResultModel(-1, "\u4f1a\u5458\u4e0d\u5b58\u5728");
        }
        this.memberDao.managerAddAndCancel(0, findMember.getId());
        return new ResultModel(1, "\u64cd\u4f5c\u6210\u529f");
    }

    @Override
    public ResultModel isenable(int id) {
        if (this.memberDao.isenable(id) == 1) {
            return new ResultModel(1, "\u64cd\u4f5c\u6210\u529f");
        }
        return new ResultModel(-1, "\u64cd\u4f5c\u5931\u8d25");
    }

    @Override
    public ResultModel changepwd(Member loginMember, int id, String password) {
        if (StringUtils.isBlank((String)password)) {
            throw new OpeErrorException("\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (password.length() < 6) {
            return new ResultModel(-1, "\u5bc6\u7801\u4e0d\u80fd\u5c11\u4e8e6\u4e2a\u5b57\u7b26");
        }
        password = Md5Util.getMD5Code((String)password);
        if (this.memberDao.changepwd(id, password) == 1) {
            this.actionLogService.save(loginMember.getCurrLoginIp(), loginMember.getId(), ActionUtil.CHANGE_PWD);
            return new ResultModel(3, "\u5bc6\u7801\u4fee\u6539\u6210\u529f");
        }
        return new ResultModel(-1, "\u5bc6\u7801\u4fee\u6539\u5931\u8d25");
    }

    @Override
    public ResultModel changepwd(Member loginMember, String oldPassword, String newPassword) {
        Member member;
        if (StringUtils.isBlank((String)newPassword)) {
            throw new OpeErrorException("\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (newPassword.length() < 6) {
            return new ResultModel(-1, "\u5bc6\u7801\u4e0d\u80fd\u5c11\u4e8e6\u4e2a\u5b57\u7b26");
        }
        if (!(oldPassword = Md5Util.getMD5Code((String)oldPassword)).equals((member = (Member)super.findById(loginMember.getId())).getPassword())) {
            return new ResultModel(-1, "\u65e7\u5bc6\u7801\u9519\u8bef");
        }
        return this.changepwd(loginMember, member.getId(), newPassword);
    }

    @Override
    public ResultModel updateAvatar(Member member, String oldAvatar, HttpServletRequest request) {
        int result = this.memberDao.updateAvatar(member.getId(), member.getAvatar());
        if (result == 1) {
            String realPath;
            File file;
            if (StringUtils.isNotEmpty((String)oldAvatar) && !"/res/common/images/default-avatar.png".equals(oldAvatar) && (file = new File(realPath = request.getServletContext().getRealPath(oldAvatar))).exists()) {
                file.delete();
            }
            return new ResultModel(0, "\u5934\u50cf\u4fee\u6539\u6210\u529f");
        }
        return new ResultModel(-1, "\u5934\u50cf\u4fee\u6539\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
    }

    @Override
    public ResultModel editBaseInfo(Member member, String name, String sex, String introduce) {
        if (!StringUtils.checkNickname((String)member.getName())) {
            return new ResultModel(-1, "\u6635\u79f0\u53ea\u80fd\u7531\u4e2d\u6587\u3001\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf(_)\u6216\u8005\u77ed\u6a2a\u7ebf(-)\u7ec4\u6210");
        }
        if (name != null && !name.equals(member.getName()) && this.findByName(name) != null) {
            return new ResultModel(-1, "\u6635\u79f0\u5df2\u88ab\u5360\u7528\uff0c\u8bf7\u66f4\u6362\u4e00\u4e2a");
        }
        member.setName(name);
        member.setSex(sex);
        member.setIntroduce(introduce);
        if (this.memberDao.editBaseInfo(member) == 1) {
            return new ResultModel(0, "\u4fee\u6539\u6210\u529f");
        }
        return new ResultModel(-1, "\u4fee\u6539\u5931\u8d25");
    }

    @Override
    public ResultModel editOtherInfo(Member loginMember, String birthday, String qq, String wechat, String contactPhone, String contactEmail, String website) {
        loginMember.setBirthday(birthday);
        loginMember.setQq(qq);
        loginMember.setWechat(wechat);
        loginMember.setContactPhone(contactPhone);
        loginMember.setContactEmail(contactEmail);
        loginMember.setWebsite(website);
        if (this.memberDao.editOtherInfo(loginMember) == 1) {
            return new ResultModel(0, "\u4fee\u6539\u6210\u529f");
        }
        return new ResultModel(-1, "\u4fee\u6539\u5931\u8d25");
    }

    @Override
    public Member findByName(String name) {
        return this.memberDao.findByName(name);
    }

    @Override
    public ResultModel sendEmailActiveValidCode(Member loginMember, HttpServletRequest request) {
        if ((loginMember = this.findById(loginMember.getId())).getIsActive() == 1) {
            return new ResultModel(-1, "\u60a8\u7684\u8d26\u53f7\u5df2\u7ecf\u6fc0\u6d3b\uff0c\u65e0\u9700\u91cd\u590d\u6fc0\u6d3b");
        }
        String randomCode = RandomCodeUtil.randomCode6();
        ValidateCode validateCode = new ValidateCode(loginMember.getEmail(), randomCode, 2);
        if (this.validateCodeService.save(validateCode) && EmailSendUtil.activeMember(request, loginMember.getEmail(), randomCode)) {
            return new ResultModel(0, "\u90ae\u4ef6\u53d1\u9001\u6210\u529f");
        }
        return new ResultModel(-1, "\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
    }

    @Override
    @Transactional
    public ResultModel active(Member loginMember, String randomCode, HttpServletRequest request) {
        try {
            loginMember = this.findById(loginMember.getId());
            if (loginMember.getIsActive() == 1) {
                return new ResultModel(-1, "\u60a8\u7684\u8d26\u53f7\u5df2\u7ecf\u6fc0\u6d3b\uff0c\u65e0\u9700\u91cd\u590d\u6fc0\u6d3b");
            }
            ValidateCode validateCode = this.validateCodeService.valid(loginMember.getEmail(), randomCode, 2);
            if (validateCode == null) {
                return new ResultModel(-1, "\u9a8c\u8bc1\u7801\u9519\u8bef");
            }
            if (this.validateCodeService.used(validateCode.getId()) && this.memberDao.active(loginMember.getId()) == 1) {
                loginMember.setIsActive(1);
                MemberUtil.setLoginMember(request, loginMember);
                this.scoreDetailService.scoreBonus(loginMember.getId(), ScoreRuleConsts.EMAIL_AUTHENTICATION);
                return new ResultModel(2, "\u6fc0\u6d3b\u6210\u529f\uff0c\u6b63\u5728\u8fdb\u5165\u4f1a\u5458\u4e2d\u5fc3...", request.getContextPath() + "/member/");
            }
            return new ResultModel(-1, "\u6fc0\u6d3b\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResultModel(-1, "\u6fc0\u6d3b\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
        }
    }

    @Override
    public Member findByNameAndEmail(String name, String email) {
        return this.memberDao.findByNameAndEmail(name, email);
    }

    @Override
    public ResultModel forgetpwd(String name, String email, HttpServletRequest request) {
        Member member = this.findByNameAndEmail(name, email);
        if (member == null) {
            return new ResultModel(-1, "\u4f1a\u5458\u4e0d\u5b58\u5728");
        }
        String randomCode = RandomCodeUtil.uuid();
        ValidateCode validateCode = new ValidateCode(email, randomCode, 1);
        if (this.validateCodeService.save(validateCode) && EmailSendUtil.forgetpwd(request, email, randomCode)) {
            return new ResultModel(0, "\u90ae\u4ef6\u53d1\u9001\u6210\u529f");
        }
        return new ResultModel(-1, "\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
    }

    @Override
    @Transactional
    public ResultModel resetpwd(String email, String token, String password, HttpServletRequest request) {
        Member member = this.memberDao.findByEmail(email);
        if (member == null) {
            return new ResultModel(-1, "\u4f1a\u5458\u4e0d\u5b58\u5728");
        }
        ValidateCode validateCode = this.validateCodeService.valid(email, token, 1);
        if (validateCode == null) {
            return new ResultModel(-1, "\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        password = Md5Util.getMD5Code((String)password);
        if (this.memberDao.changepwd(member.getId(), password) == 1) {
            this.validateCodeService.used(validateCode.getId());
            this.actionLogService.save(IpUtil.getIpAddress((HttpServletRequest)request), member.getId(), ActionUtil.FIND_PWD);
            return new ResultModel(2, "\u5bc6\u7801\u91cd\u7f6e\u6210\u529f", request.getContextPath() + "/member/login");
        }
        return new ResultModel(-1, "\u5bc6\u7801\u91cd\u7f6e\u5931\u8d25");
    }

    @Override
    @Transactional
    public ResultModel follows(Member loginMember, Integer followWhoId) {
        if (loginMember == null) {
            throw new NotLoginException();
        }
        if (this.findById(followWhoId) == null) {
            return new ResultModel(-1, "\u5173\u6ce8\u7684\u4f1a\u5458\u4e0d\u5b58\u5728");
        }
        if (loginMember.getId().intValue() == followWhoId.intValue()) {
            return new ResultModel(-1, "\u4e0d\u80fd\u5173\u6ce8\u81ea\u5df1");
        }
        if (this.memberFansService.find(loginMember.getId(), followWhoId) == null) {
            this.memberFansService.save(loginMember.getId(), followWhoId);
            this.memberDao.follows(loginMember.getId());
            this.memberDao.fans(followWhoId);
            return new ResultModel(1, "\u5173\u6ce8\u6210\u529f");
        }
        this.memberFansService.delete(loginMember.getId(), followWhoId);
        this.memberDao.follows(loginMember.getId());
        this.memberDao.fans(followWhoId);
        return new ResultModel(0, "\u53d6\u6d88\u5173\u6ce8\u6210\u529f");
    }

    @Override
    public ResultModel isFollowed(Member loginMember, Integer followWhoId) {
        int loginMemberId = 0;
        if (loginMember != null) {
            loginMemberId = loginMember.getId();
        }
        if (this.memberFansService.find(loginMemberId, followWhoId) == null) {
            return new ResultModel(0, "\u672a\u5173\u6ce8");
        }
        return new ResultModel(1, "\u5df2\u5173\u6ce8");
    }

    @Override
    public List<Member> listContactMemberIds(Page page, Integer memberId) {
        List<Member> list = this.memberDao.listContactMemberIds(page, memberId);
        return list;
    }

    @Override
    public ResultModel<Member> listContactMembers(Page page, Integer memberId) {
        List<Member> memberIdList = this.listContactMemberIds(page, memberId);
        List<Object> list = new ArrayList();
        if (memberIdList.size() > 0) {
            ArrayList<Integer> idList = new ArrayList<Integer>();
            String idString = "";
            for (Member member : memberIdList) {
                if (member == null) continue;
                idList.add(member.getId());
                idString = idString + member.getId() + ",";
            }
            if (idString.length() > 0) {
                idString = idString.substring(0, idString.length() - 1);
            }
            if (StringUtils.isNotEmpty((String)idString)) {
                list = this.memberDao.listContactMembers(memberId, idList, idString);
            }
        }
        ResultModel model = new ResultModel(0, page);
        model.setData(list);
        return model;
    }

    @Override
    public boolean updateScore(Integer score, Integer memberId) {
        return this.memberDao.updateScore(score, memberId) == 1;
    }

    @Override
    public boolean updateMoney(Double money, Integer memberId) {
        return this.memberDao.updateMoney(money, memberId) == 1;
    }

    @Override
    public String atFormat(String content) {
        List nameList = AtUtil.getAtNameList((String)content);
        for (String name : nameList) {
            Member member = this.findByName(name);
            if (member == null) continue;
            content = AtUtil.replaceAt((String)content, (String)name, (int)member.getId());
        }
        return content;
    }
}

