/*
 * Decompiled with CFR 0.152.
 */
package com.lxinet.jeesns.service.member.impl;

import com.lxinet.jeesns.core.dto.ResultModel;
import com.lxinet.jeesns.core.enums.MessageType;
import com.lxinet.jeesns.core.model.Page;
import com.lxinet.jeesns.core.service.impl.BaseServiceImpl;
import com.lxinet.jeesns.core.utils.AtUtil;
import com.lxinet.jeesns.dao.member.IMessageDao;
import com.lxinet.jeesns.model.member.Member;
import com.lxinet.jeesns.model.member.Message;
import com.lxinet.jeesns.service.member.IMemberService;
import com.lxinet.jeesns.service.member.IMessageService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="messageService")
public class MessageServiceImpl
extends BaseServiceImpl<Message>
implements IMessageService {
    @Resource
    private IMessageDao messageDao;
    @Resource
    private IMemberService memberService;

    @Override
    public ResultModel sentMsg(Integer fromMemberId, Integer toMemberId, String content) {
        if (fromMemberId.intValue() == toMemberId.intValue()) {
            return new ResultModel(-1, "\u4e0d\u80fd\u53d1\u4fe1\u606f\u7ed9\u81ea\u5df1");
        }
        Message message = new Message();
        message.setFromMemberId(fromMemberId);
        message.setToMemberId(toMemberId);
        message.setContent(content);
        if (this.messageDao.sentMsg(message) == 1) {
            return new ResultModel(0, "\u4fe1\u606f\u53d1\u9001\u6210\u529f");
        }
        return new ResultModel(-1, "\u4fe1\u606f\u53d1\u9001\u5931\u8d25");
    }

    @Override
    public ResultModel systemMsgSave(Integer toMemberId, String content, Integer appTag, Integer type, Integer relateKeyId, Integer loginMemberId, String description) {
        Message message = new Message();
        message.setToMemberId(toMemberId);
        message.setContent(content);
        message.setAppTag(appTag);
        message.setRelateKeyId(relateKeyId);
        message.setType(type);
        message.setMemberId(loginMemberId);
        message.setDescription(description);
        if (this.messageDao.systemMsgSave(message) == 1) {
            return new ResultModel(0, "\u4fe1\u606f\u53d1\u9001\u6210\u529f");
        }
        return new ResultModel(-1, "\u4fe1\u606f\u53d1\u9001\u5931\u8d25");
    }

    @Override
    public ResultModel<Message> listByPage(Page page, Integer fromMemberId, Integer toMemberId) {
        List<Message> list = this.messageDao.list(page, fromMemberId, toMemberId);
        ResultModel model = new ResultModel(0, page);
        model.setData(list);
        return model;
    }

    @Override
    public ResultModel<Message> messageRecords(Page page, Integer fromMemberId, Integer toMemberId) {
        List<Message> list = this.messageDao.messageRecords(page, fromMemberId, toMemberId);
        ResultModel model = new ResultModel(0, page);
        model.setData(list);
        this.setRead(fromMemberId, toMemberId);
        return model;
    }

    @Override
    public ResultModel<Message> systemMessage(Page page, Integer toMemberId, String basePath) {
        List<Message> list = this.messageDao.systemMessage(page, toMemberId, basePath);
        ResultModel model = new ResultModel(0, page);
        model.setData(list);
        this.setRead(null, toMemberId);
        return model;
    }

    @Override
    public int deleteByMember(Integer memberId) {
        return this.messageDao.deleteByMember(memberId);
    }

    @Override
    public int clearMessageByMember(Integer fromMemberId, Integer toMemberId) {
        return this.messageDao.clearMessageByMember(fromMemberId, toMemberId);
    }

    @Override
    public int countUnreadNum(int memberId) {
        return this.messageDao.countUnreadNum(memberId);
    }

    @Override
    public int countSystemUnreadNum(int memberId) {
        return this.messageDao.countSystemUnreadNum(memberId);
    }

    @Override
    public int setRead(Integer fromMemberId, Integer toMemberId) {
        return this.messageDao.setRead(fromMemberId, toMemberId);
    }

    @Override
    public void atDeal(int loginMemberId, String content, int appTag, MessageType messageType, int relateKeyId) {
        List atMemberList = AtUtil.getAtNameList((String)content);
        if (atMemberList.size() > 0) {
            for (String name : atMemberList) {
                Member findAtMember = this.memberService.findByName(name);
                if (findAtMember == null || loginMemberId == findAtMember.getId()) continue;
                this.systemMsgSave(findAtMember.getId(), content, appTag, messageType.getCode(), relateKeyId, loginMemberId, messageType.getContent());
            }
        }
    }

    @Override
    public void diggDeal(int loginMemberId, int toMemberId, String content, int appTag, MessageType messageType, int relateKeyId) {
        if (loginMemberId != toMemberId) {
            this.systemMsgSave(toMemberId, content, appTag, messageType.getCode(), relateKeyId, loginMemberId, messageType.getContent());
        }
    }

    @Override
    public void diggDeal(int loginMemberId, int toMemberId, int appTag, MessageType messageType, int relateKeyId) {
        this.diggDeal(loginMemberId, toMemberId, null, appTag, messageType, relateKeyId);
    }
}

