/*
 * Decompiled with CFR 0.152.
 */
package com.lxinet.jeesns.service.picture.impl;

import com.lxinet.jeesns.core.dto.ResultModel;
import com.lxinet.jeesns.core.enums.Messages;
import com.lxinet.jeesns.core.model.Page;
import com.lxinet.jeesns.core.utils.ValidUtill;
import com.lxinet.jeesns.dao.picture.IPictureAlbumCommentDao;
import com.lxinet.jeesns.model.member.Member;
import com.lxinet.jeesns.model.picture.PictureAlbum;
import com.lxinet.jeesns.model.picture.PictureAlbumComment;
import com.lxinet.jeesns.service.member.IMemberService;
import com.lxinet.jeesns.service.picture.IPictureAlbumCommentService;
import com.lxinet.jeesns.service.picture.IPictureAlbumService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="pictureAlbumCommentService")
public class PictureAlbumCommentServiceImpl
implements IPictureAlbumCommentService {
    @Resource
    private IPictureAlbumCommentDao pictureAlbumCommentDao;
    @Resource
    private IPictureAlbumService pictureAlbumService;
    @Resource
    private IMemberService memberService;

    @Override
    public PictureAlbumComment findById(int id) {
        PictureAlbumComment pictureAlbumComment = this.pictureAlbumCommentDao.findById(id);
        this.atFormat(pictureAlbumComment);
        return pictureAlbumComment;
    }

    @Override
    public boolean save(Member loginMember, String content, Integer pictureAlbumId) {
        PictureAlbum pictureAlbum = this.pictureAlbumService.findById(pictureAlbumId);
        ValidUtill.checkIsNull((Object)pictureAlbum, (Messages)Messages.PICTURE_ALBUM_NOT_EXISTS);
        PictureAlbumComment pictureAlbumComment = new PictureAlbumComment();
        pictureAlbumComment.setMemberId(loginMember.getId());
        pictureAlbumComment.setPictureAlbumId(pictureAlbumId);
        pictureAlbumComment.setContent(content);
        int result = this.pictureAlbumCommentDao.saveObj(pictureAlbumComment);
        return result == 1;
    }

    @Override
    public ResultModel listByPictureAlbum(Page page, int pictureAlbumId) {
        List<PictureAlbumComment> list = this.pictureAlbumCommentDao.listByPictureAlbum(page, pictureAlbumId);
        this.atFormat(list);
        ResultModel model = new ResultModel(0, page);
        model.setData(list);
        return model;
    }

    @Override
    public void deleteByPictureAlbum(Integer pictureAlbumId) {
        this.pictureAlbumCommentDao.deleteByPictureAlbum(pictureAlbumId);
    }

    @Override
    public boolean delete(Member loginMember, int id) {
        PictureAlbumComment pictureAlbumComment = this.findById(id);
        ValidUtill.checkIsNull((Object)pictureAlbumComment, (String)"\u8bc4\u8bba\u4e0d\u5b58\u5728");
        int result = this.pictureAlbumCommentDao.deleteById(id, PictureAlbumComment.class);
        return result == 1;
    }

    public PictureAlbumComment atFormat(PictureAlbumComment pictureAlbumComment) {
        pictureAlbumComment.setContent(this.memberService.atFormat(pictureAlbumComment.getContent()));
        return pictureAlbumComment;
    }

    public List<PictureAlbumComment> atFormat(List<PictureAlbumComment> pictureAlbumCommentList) {
        for (PictureAlbumComment pictureAlbumComment : pictureAlbumCommentList) {
            this.atFormat(pictureAlbumComment);
        }
        return pictureAlbumCommentList;
    }
}

