/*
 * Decompiled with CFR 0.152.
 */
package com.lxinet.jeesns.service.picture.impl;

import com.lxinet.jeesns.core.dto.ResultModel;
import com.lxinet.jeesns.core.enums.MessageType;
import com.lxinet.jeesns.core.enums.Messages;
import com.lxinet.jeesns.core.model.Page;
import com.lxinet.jeesns.core.utils.ValidUtill;
import com.lxinet.jeesns.dao.picture.IPictureCommentDao;
import com.lxinet.jeesns.model.member.Member;
import com.lxinet.jeesns.model.picture.Picture;
import com.lxinet.jeesns.model.picture.PictureComment;
import com.lxinet.jeesns.service.member.IMemberService;
import com.lxinet.jeesns.service.member.IMessageService;
import com.lxinet.jeesns.service.picture.IPictureCommentService;
import com.lxinet.jeesns.service.picture.IPictureService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="pictureCommentService")
public class PictureCommentServiceImpl
implements IPictureCommentService {
    @Resource
    private IPictureCommentDao pictureCommentDao;
    @Resource
    private IPictureService pictureService;
    @Resource
    private IMessageService messageService;
    @Resource
    private IMemberService memberService;

    @Override
    public PictureComment findById(int id) {
        PictureComment PictureComment2 = this.pictureCommentDao.findById(id);
        this.atFormat(PictureComment2);
        return PictureComment2;
    }

    @Override
    public boolean save(Member loginMember, String content, Integer pictureId) {
        Picture picture = this.pictureService.findById(pictureId, loginMember.getId());
        ValidUtill.checkIsNull((Object)picture, (Messages)Messages.PICTURE_NOT_EXISTS);
        PictureComment pictureComment = new PictureComment();
        pictureComment.setMemberId(loginMember.getId());
        pictureComment.setPictureId(pictureId);
        pictureComment.setContent(content);
        int result = this.pictureCommentDao.saveObj(pictureComment);
        if (result == 1) {
            this.messageService.atDeal(loginMember.getId(), content, 4, MessageType.PICTURE_COMMENT_REFER, picture.getId());
            this.messageService.diggDeal(loginMember.getId(), picture.getMemberId(), content, 4, MessageType.PICTURE_REPLY, picture.getId());
        }
        return result == 1;
    }

    @Override
    public ResultModel listByPicture(Page page, int pictureId) {
        List<PictureComment> list = this.pictureCommentDao.listByPicture(page, pictureId);
        this.atFormat(list);
        ResultModel model = new ResultModel(0, page);
        model.setData(list);
        return model;
    }

    @Override
    public void deleteByPicture(Integer pictureId) {
        this.pictureCommentDao.deleteByPicture(pictureId);
    }

    @Override
    public boolean delete(Member loginMember, int id) {
        PictureComment pictureComment = this.findById(id);
        ValidUtill.checkIsNull((Object)pictureComment, (String)"\u8bc4\u8bba\u4e0d\u5b58\u5728");
        int result = this.pictureCommentDao.deleteById(id, PictureComment.class);
        return result == 1;
    }

    public PictureComment atFormat(PictureComment pictureComment) {
        pictureComment.setContent(this.memberService.atFormat(pictureComment.getContent()));
        return pictureComment;
    }

    public List<PictureComment> atFormat(List<PictureComment> pictureCommentList) {
        for (PictureComment pictureComment : pictureCommentList) {
            this.atFormat(pictureComment);
        }
        return pictureCommentList;
    }
}

