/*
 * Decompiled with CFR 0.152.
 */
package com.lxinet.jeesns.service.picture.impl;

import com.lxinet.jeesns.core.dto.ResultModel;
import com.lxinet.jeesns.core.enums.MessageType;
import com.lxinet.jeesns.core.model.Page;
import com.lxinet.jeesns.core.utils.StringUtils;
import com.lxinet.jeesns.dao.picture.IPictureDao;
import com.lxinet.jeesns.model.member.Member;
import com.lxinet.jeesns.model.picture.Picture;
import com.lxinet.jeesns.service.member.IMessageService;
import com.lxinet.jeesns.service.picture.IPictureFavorService;
import com.lxinet.jeesns.service.picture.IPictureService;
import com.lxinet.jeesns.utils.PictureUtil;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PictureServiceImpl
implements IPictureService {
    @Resource
    private IPictureDao pictureDao;
    @Resource
    private IPictureFavorService pictureFavorService;
    @Resource
    private IMessageService messageService;

    @Override
    public List<Picture> find(Integer foreignId) {
        return this.pictureDao.find(foreignId);
    }

    @Override
    public Picture findById(Integer pictureId, int loginMemberId) {
        return this.pictureDao.findById(pictureId, loginMemberId);
    }

    @Override
    public ResultModel<Picture> listByPage(Page page, int loginMemberId) {
        List<Picture> list = this.pictureDao.list(page, loginMemberId);
        ResultModel model = new ResultModel(0, page);
        model.setData(list);
        return model;
    }

    @Override
    public ResultModel<Picture> listByAlbum(Page page, Integer pictureAlbumId, int loginMemberId) {
        List<Picture> list = this.pictureDao.listByAlbum(page, pictureAlbumId, loginMemberId);
        ResultModel model = new ResultModel(0, page);
        model.setData(list);
        return model;
    }

    @Override
    public int deleteByForeignId(HttpServletRequest request, Integer foreignId) {
        List<Picture> pictures = this.find(foreignId);
        PictureUtil.delete(request, pictures);
        return this.pictureDao.deleteByForeignId(foreignId);
    }

    @Override
    public boolean delete(HttpServletRequest request, Integer pictureId) {
        Picture picture = this.findById(pictureId, 0);
        PictureUtil.delete(request, picture);
        return this.pictureDao.deleteById(pictureId, Picture.class) == 1;
    }

    @Override
    public int save(Picture picture) {
        return this.pictureDao.saveObj(picture);
    }

    @Override
    public int update(Integer foreignId, String ids, String description) {
        if (StringUtils.isNotEmpty((String)ids)) {
            String[] idsArr = ids.split(",");
            return this.pictureDao.update(foreignId, idsArr, description);
        }
        return 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ResultModel favor(Member loginMember, int pictureId) {
        ResultModel resultModel;
        Picture picture = this.findById(pictureId, loginMember.getId());
        if (this.pictureFavorService.find(pictureId, loginMember.getId()) == null) {
            this.pictureDao.favor(pictureId, 1);
            picture.setFavorCount(picture.getFavorCount() + 1);
            this.pictureFavorService.save(pictureId, loginMember.getId());
            String message = "\u70b9\u8d5e\u6210\u529f";
            resultModel = new ResultModel(0, message);
            this.messageService.diggDeal(loginMember.getId(), picture.getMemberId(), 4, MessageType.PICTURE_ZAN, pictureId);
        } else {
            this.pictureDao.favor(pictureId, -1);
            picture.setFavorCount(picture.getFavorCount() - 1);
            this.pictureFavorService.delete(pictureId, loginMember.getId());
            String message = "\u53d6\u6d88\u8d5e\u6210\u529f";
            resultModel = new ResultModel(1, message);
        }
        resultModel.setData((Object)picture.getFavorCount());
        return resultModel;
    }
}

