/*
 * Decompiled with CFR 0.152.
 */
package com.lxinet.jeesns.service.question.impl;

import com.lxinet.jeesns.core.dto.ResultModel;
import com.lxinet.jeesns.core.exception.OpeErrorException;
import com.lxinet.jeesns.core.service.impl.BaseServiceImpl;
import com.lxinet.jeesns.core.utils.PageUtil;
import com.lxinet.jeesns.dao.question.IAnswerDao;
import com.lxinet.jeesns.model.member.Member;
import com.lxinet.jeesns.model.question.Answer;
import com.lxinet.jeesns.service.question.IAnswerService;
import com.lxinet.jeesns.service.question.IQuestionService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="answerService")
public class AnswerServiceImpl
extends BaseServiceImpl<Answer>
implements IAnswerService {
    @Resource
    private IAnswerDao answerDao;
    @Resource
    private IQuestionService questionService;

    public ResultModel<Answer> listByQuestion(Integer questionId) {
        List<Answer> list = this.answerDao.listByQuestion(PageUtil.getPage(), questionId);
        ResultModel model = new ResultModel(0, PageUtil.getPage());
        model.setData(list);
        return model;
    }

    public Answer findById(Integer id) {
        return this.answerDao.findById(id);
    }

    public boolean save(Answer answer) {
        super.save((Object)answer);
        this.questionService.updateAnswerCount(answer.getQuestionId());
        return true;
    }

    @Override
    public boolean update(Member loginMember, Answer answer) {
        return super.update((Object)answer);
    }

    @Override
    public boolean delete(Member loginMember, Integer id) {
        Answer findAnswer = this.findById(id);
        if (loginMember.getId().intValue() == findAnswer.getMember().getId().intValue() || loginMember.getIsAdmin() > 0) {
            return super.deleteById(id);
        }
        throw new OpeErrorException("\u6ca1\u6709\u6743\u9650");
    }
}

