/*
 * Decompiled with CFR 0.152.
 */
package com.lxinet.jeesns.service.question.impl;

import com.lxinet.jeesns.core.dto.ResultModel;
import com.lxinet.jeesns.core.exception.OpeErrorException;
import com.lxinet.jeesns.core.service.impl.BaseServiceImpl;
import com.lxinet.jeesns.core.utils.HtmlUtil;
import com.lxinet.jeesns.core.utils.PageUtil;
import com.lxinet.jeesns.core.utils.StringUtils;
import com.lxinet.jeesns.core.utils.ValidUtill;
import com.lxinet.jeesns.dao.question.IQuestionDao;
import com.lxinet.jeesns.model.member.Financial;
import com.lxinet.jeesns.model.member.Member;
import com.lxinet.jeesns.model.member.ScoreDetail;
import com.lxinet.jeesns.model.question.Answer;
import com.lxinet.jeesns.model.question.Question;
import com.lxinet.jeesns.model.question.QuestionType;
import com.lxinet.jeesns.service.member.IFinancialService;
import com.lxinet.jeesns.service.member.IMemberService;
import com.lxinet.jeesns.service.member.IScoreDetailService;
import com.lxinet.jeesns.service.question.IAnswerService;
import com.lxinet.jeesns.service.question.IQuestionService;
import com.lxinet.jeesns.service.question.IQuestionTypeService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="questionService")
public class QuestionServiceImpl
extends BaseServiceImpl<Question>
implements IQuestionService {
    @Resource
    private IQuestionDao questionDao;
    @Resource
    private IQuestionTypeService questionTypeService;
    @Resource
    private IMemberService memberService;
    @Resource
    private IFinancialService financialService;
    @Resource
    private IScoreDetailService scoreDetailService;
    @Resource
    private IAnswerService answerService;

    public ResultModel<Question> list(Integer typeId, String statusName) {
        Integer status = -2;
        if ("close".equalsIgnoreCase(statusName)) {
            status = -1;
        } else if ("unsolved".equalsIgnoreCase(statusName)) {
            status = 0;
        } else if ("solved".equalsIgnoreCase(statusName)) {
            status = 1;
        }
        List<Question> list = this.questionDao.list(PageUtil.getPage(), typeId, status);
        ResultModel model = new ResultModel(0, PageUtil.getPage());
        model.setData(list);
        return model;
    }

    public Question findById(Integer id) {
        return this.questionDao.findById(id);
    }

    @Transactional
    public boolean save(Question question) {
        ValidUtill.checkParam((Boolean)(question.getMemberId() == null ? 1 : 0), (String)"\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a");
        ValidUtill.checkParam((Boolean)(question.getTypeId() == null ? 1 : 0), (String)"\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        ValidUtill.checkParam((Boolean)(question.getTitle() == null ? 1 : 0), (String)"\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a");
        ValidUtill.checkParam((Boolean)(question.getBonus() < 0 ? 1 : 0), (String)"\u60ac\u8d4f\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0");
        QuestionType questionType = (QuestionType)this.questionTypeService.findById(question.getTypeId());
        ValidUtill.checkIsNull((Object)questionType, (String)"\u95ee\u7b54\u5206\u7c7b\u4e0d\u5b58\u5728");
        Member member = (Member)this.memberService.findById(question.getMemberId());
        if (StringUtils.isEmpty((String)question.getDescription())) {
            String contentStr = HtmlUtil.delHTMLTag((String)question.getContent());
            if (contentStr.length() > 200) {
                question.setDescription(contentStr.substring(0, 200));
            } else {
                question.setDescription(contentStr);
            }
        }
        super.save((Object)question);
        if (question.getBonus() > 0) {
            if (questionType.getBonusType() == 0) {
                ValidUtill.checkParam((Boolean)(member.getScore() < question.getBonus() ? 1 : 0), (String)("\u8d26\u6237\u79ef\u5206\u4e0d\u8db3\uff0c\u65e0\u6cd5\u60ac\u8d4f\uff0c\u8d26\u6237\u79ef\u5206\u4f59\u989d\u4e3a\uff1a" + member.getScore()));
                this.memberService.updateScore(-question.getBonus().intValue(), member.getId());
                ScoreDetail scoreDetail = new ScoreDetail();
                scoreDetail.setType(1);
                scoreDetail.setMemberId(member.getId());
                scoreDetail.setForeignId(question.getId());
                scoreDetail.setScore(-question.getBonus().intValue());
                scoreDetail.setRemark("\u95ee\u7b54\u60ac\u8d4f\uff1a" + question.getTitle() + "#" + question.getId());
                this.scoreDetailService.save(scoreDetail);
            } else if (questionType.getBonusType() == 1) {
                ValidUtill.checkParam((Boolean)(member.getMoney() < (double)question.getBonus().intValue() ? 1 : 0), (String)("\u8d26\u6237\u4f59\u989d\u4e0d\u8db3\uff0c\u65e0\u6cd5\u60ac\u8d4f\uff0c\u8d26\u6237\u4f59\u989d\u4e3a\uff1a" + member.getMoney()));
                this.memberService.updateMoney(-((double)question.getBonus().intValue()), member.getId());
                Financial financial = new Financial();
                financial.setBalance(member.getMoney() - (double)question.getBonus().intValue());
                financial.setForeignId(question.getId());
                financial.setMemberId(member.getId());
                financial.setMoney((double)question.getBonus());
                financial.setType(1);
                financial.setPaymentId(1);
                financial.setRemark("\u95ee\u7b54\u60ac\u8d4f\uff1a" + question.getTitle() + "#" + question.getId());
                financial.setOperator(member.getName());
                this.financialService.save(financial);
            }
        }
        return true;
    }

    @Override
    public boolean update(Member loginMember, Question question) {
        Question findQuestion = this.findById(question.getId());
        ValidUtill.checkIsNull((Object)findQuestion, (String)"\u95ee\u9898\u4e0d\u5b58\u5728");
        ValidUtill.checkParam((Boolean)(question.getTitle() == null ? 1 : 0), (String)"\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isEmpty((String)question.getDescription())) {
            String contentStr = HtmlUtil.delHTMLTag((String)question.getContent());
            if (contentStr.length() > 200) {
                findQuestion.setDescription(contentStr.substring(0, 200));
            } else {
                findQuestion.setDescription(contentStr);
            }
        }
        findQuestion.setTitle(question.getTitle());
        findQuestion.setContent(question.getContent());
        return super.update((Object)findQuestion);
    }

    @Override
    public boolean delete(Member loginMember, Integer id) {
        Question findQuestion = this.findById(id);
        ValidUtill.checkParam((Boolean)(findQuestion.getAnswerCount() > 0 ? 1 : 0), (String)"\u8be5\u95ee\u9898\u5df2\u6709\u4eba\u56de\u590d\uff0c\u65e0\u6cd5\u5220\u9664");
        if (loginMember.getId().intValue() == findQuestion.getMember().getId().intValue() || loginMember.getIsAdmin() > 0) {
            return super.deleteById(id);
        }
        throw new OpeErrorException("\u6ca1\u6709\u6743\u9650");
    }

    @Override
    public void close(Member loginMember, Integer id) {
        Question question = this.findById(id);
        ValidUtill.checkParam((Boolean)(question.getAnswerCount() > 0 ? 1 : 0), (String)"\u8be5\u95ee\u9898\u5df2\u6709\u4eba\u56de\u590d\uff0c\u65e0\u6cd5\u5173\u95ed");
        if (loginMember.getId().intValue() == question.getMember().getId().intValue() || loginMember.getIsAdmin() > 0) {
            this.updateStatus(-1, question);
            if (question.getBonus() > 0) {
                if (question.getQuestionType().getBonusType() == 0) {
                    this.memberService.updateScore(question.getBonus(), question.getMemberId());
                    ScoreDetail scoreDetail = new ScoreDetail();
                    scoreDetail.setType(1);
                    scoreDetail.setMemberId(question.getMemberId());
                    scoreDetail.setForeignId(question.getId());
                    scoreDetail.setScore(question.getBonus());
                    scoreDetail.setRemark("\u95ee\u7b54\u5173\u95ed\uff0c\u60ac\u8d4f\u8fd4\u8fd8\uff1a" + question.getTitle() + "#" + question.getId());
                    this.scoreDetailService.save(scoreDetail);
                } else if (question.getQuestionType().getBonusType() == 1) {
                    this.memberService.updateMoney((double)question.getBonus(), question.getMemberId());
                    Member member = (Member)this.memberService.findById(question.getMemberId());
                    Financial financial = new Financial();
                    financial.setBalance(member.getMoney() + (double)question.getBonus().intValue());
                    financial.setForeignId(question.getId());
                    financial.setMemberId(member.getId());
                    financial.setMoney((double)question.getBonus());
                    financial.setType(0);
                    financial.setPaymentId(1);
                    financial.setRemark("\u95ee\u7b54\u5173\u95ed\uff0c\u60ac\u8d4f\u8fd4\u8fd8\uff1a" + question.getTitle() + "#" + question.getId());
                    financial.setOperator(member.getName());
                    this.financialService.save(financial);
                }
            }
        } else {
            throw new OpeErrorException("\u6ca1\u6709\u6743\u9650");
        }
    }

    @Override
    @Transactional
    public void bestAnswer(Member loginMember, Integer answerId, Integer id) {
        Question question = this.findById(id);
        ValidUtill.checkParam((Boolean)(question.getStatus() == 1 ? 1 : 0), (String)"\u8be5\u95ee\u9898\u5df2\u89e3\u51b3\uff0c\u65e0\u6cd5\u91cd\u65b0\u91c7\u7528\u6700\u4f73\u7b54\u6848");
        ValidUtill.checkParam((Boolean)(question.getStatus() == -1 ? 1 : 0), (String)"\u8be5\u95ee\u9898\u5df2\u5173\u95ed\uff0c\u65e0\u6cd5\u64cd\u4f5c");
        if (loginMember.getId().intValue() == question.getMember().getId().intValue()) {
            Answer answer = (Answer)this.answerService.findById(answerId);
            ValidUtill.checkParam((Boolean)(answer.getQuestionId().intValue() != id.intValue() ? 1 : 0), (String)"\u975e\u6cd5\u64cd\u4f5c");
            ValidUtill.checkParam((Boolean)(answer.getMemberId().intValue() == question.getMemberId().intValue() ? 1 : 0), (String)"\u6700\u4f73\u7b54\u6848\u4e0d\u80fd\u662f\u81ea\u5df1\u7684\u56de\u7b54");
            this.setBestAnswer(answerId, id);
            if (question.getBonus() > 0) {
                if (question.getQuestionType().getBonusType() == 0) {
                    this.memberService.updateScore(question.getBonus(), answer.getMemberId());
                    ScoreDetail scoreDetail = new ScoreDetail();
                    scoreDetail.setType(1);
                    scoreDetail.setMemberId(answer.getMemberId());
                    scoreDetail.setForeignId(answer.getId());
                    scoreDetail.setScore(question.getBonus());
                    scoreDetail.setRemark("\u56de\u7b54\u88ab\u91c7\u7528\uff1a" + question.getTitle() + "#" + question.getId());
                    this.scoreDetailService.save(scoreDetail);
                } else if (question.getQuestionType().getBonusType() == 1) {
                    this.memberService.updateMoney((double)question.getBonus(), answer.getMemberId());
                    Member member = (Member)this.memberService.findById(answer.getMemberId());
                    Financial financial = new Financial();
                    financial.setBalance(member.getMoney() + (double)question.getBonus().intValue());
                    financial.setForeignId(answer.getId());
                    financial.setMemberId(member.getId());
                    financial.setMoney((double)question.getBonus());
                    financial.setType(0);
                    financial.setPaymentId(1);
                    financial.setRemark("\u56de\u7b54\u88ab\u91c7\u7528\uff1a" + question.getTitle() + "#" + question.getId());
                    financial.setOperator(member.getName());
                    this.financialService.save(financial);
                }
            }
        } else {
            throw new OpeErrorException("\u6ca1\u6709\u6743\u9650");
        }
    }

    @Override
    public void updateStatus(Integer status, Question question) {
        ValidUtill.checkParam((Boolean)(question.getStatus() != 0 ? 1 : 0), (String)"\u8be5\u95ee\u9898\u5f53\u524d\u72b6\u6001\u65e0\u6cd5\u6539\u53d8");
        this.questionDao.updateStatus(status, question.getId());
    }

    @Override
    public Integer updateAnswerCount(Integer id) {
        return this.questionDao.updateAnswerCount(id);
    }

    @Override
    public Integer setBestAnswer(Integer answerId, Integer id) {
        return this.questionDao.setBestAnswer(answerId, id);
    }

    @Override
    public void updateViewCount(Integer id) {
        this.questionDao.updateViewCount(id);
    }
}

