/*
 * Decompiled with CFR 0.152.
 */
package com.lxinet.jeesns.service.weibo.impl;

import com.lxinet.jeesns.core.dto.ResultModel;
import com.lxinet.jeesns.core.enums.MessageType;
import com.lxinet.jeesns.core.exception.ParamException;
import com.lxinet.jeesns.core.model.Page;
import com.lxinet.jeesns.core.service.impl.BaseServiceImpl;
import com.lxinet.jeesns.core.utils.ValidUtill;
import com.lxinet.jeesns.dao.weibo.IWeiboCommentDao;
import com.lxinet.jeesns.model.member.Member;
import com.lxinet.jeesns.model.weibo.Weibo;
import com.lxinet.jeesns.model.weibo.WeiboComment;
import com.lxinet.jeesns.service.member.IMemberService;
import com.lxinet.jeesns.service.member.IMessageService;
import com.lxinet.jeesns.service.member.IScoreDetailService;
import com.lxinet.jeesns.service.system.IActionLogService;
import com.lxinet.jeesns.service.weibo.IWeiboCommentService;
import com.lxinet.jeesns.service.weibo.IWeiboService;
import com.lxinet.jeesns.utils.ActionUtil;
import com.lxinet.jeesns.utils.ScoreRuleConsts;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="weiboCommentService")
public class WeiboCommentServiceImpl
extends BaseServiceImpl<WeiboComment>
implements IWeiboCommentService {
    @Resource
    private IWeiboCommentDao weiboCommentDao;
    @Resource
    private IWeiboService weiboService;
    @Resource
    private IActionLogService actionLogService;
    @Resource
    private IScoreDetailService scoreDetailService;
    @Resource
    private IMessageService messageService;
    @Resource
    private IMemberService memberService;

    @Override
    public WeiboComment findById(int id) {
        WeiboComment weiboComment = this.weiboCommentDao.findById(id);
        this.atFormat(weiboComment);
        return weiboComment;
    }

    @Override
    public boolean save(Member loginMember, String content, Integer weiboId, Integer weiboCommentId) {
        Weibo weibo = this.weiboService.findById(weiboId, loginMember.getId());
        ValidUtill.checkIsNull((Object)weibo, (String)"\u5fae\u535a\u4e0d\u5b58\u5728");
        ValidUtill.checkIsNull((Object)content, (String)"\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        if (content.length() > 500) {
            throw new ParamException("\u8bc4\u8bba\u5185\u5bb9\u4e0d\u80fd\u8d85\u8fc7500");
        }
        WeiboComment weiboComment = new WeiboComment();
        weiboComment.setMemberId(loginMember.getId());
        weiboComment.setWeiboId(weiboId);
        weiboComment.setContent(content);
        weiboComment.setCommentId(weiboCommentId);
        int result = this.weiboCommentDao.saveObj(weiboComment);
        if (result == 1) {
            WeiboComment replyWeiboComment;
            this.messageService.atDeal(loginMember.getId(), content, 2, MessageType.WEIBO_COMMENT_REFER, weibo.getId());
            this.messageService.diggDeal(loginMember.getId(), weibo.getMemberId(), content, 2, MessageType.WEIBO_REPLY, weibo.getId());
            if (weiboCommentId != null && (replyWeiboComment = (WeiboComment)this.findById(weiboCommentId)) != null) {
                this.messageService.diggDeal(loginMember.getId(), replyWeiboComment.getMemberId(), content, 2, MessageType.WEIBO_REPLY_REPLY, replyWeiboComment.getId());
            }
            this.scoreDetailService.scoreBonus(loginMember.getId(), ScoreRuleConsts.COMMENT_WEIBO, weiboComment.getId());
        }
        return result == 1;
    }

    @Override
    public ResultModel listByWeibo(Page page, int weiboId) {
        List<WeiboComment> list = this.weiboCommentDao.listByWeibo(page, weiboId);
        this.atFormat(list);
        ResultModel model = new ResultModel(0, page);
        model.setData(list);
        return model;
    }

    @Override
    public void deleteByWeibo(Integer weiboId) {
        this.weiboCommentDao.deleteByWeibo(weiboId);
    }

    @Override
    public boolean delete(Member loginMember, int id) {
        WeiboComment weiboComment = this.findById(id);
        boolean result = super.deleteById(Integer.valueOf(id));
        if (result) {
            this.actionLogService.save(loginMember.getCurrLoginIp(), loginMember.getId(), ActionUtil.DELETE_WEIBO_COMMENT, "ID\uff1a" + weiboComment.getId() + "\u5185\u5bb9\uff1a" + weiboComment.getContent());
        }
        return result;
    }

    public WeiboComment atFormat(WeiboComment weiboComment) {
        weiboComment.setContent(this.memberService.atFormat(weiboComment.getContent()));
        return weiboComment;
    }

    public List<WeiboComment> atFormat(List<WeiboComment> weiboCommentList) {
        for (WeiboComment weiboComment : weiboCommentList) {
            this.atFormat(weiboComment);
        }
        return weiboCommentList;
    }
}

