/*
 * Decompiled with CFR 0.152.
 */
package com.lxinet.jeesns.service.weibo.impl;

import com.lxinet.jeesns.core.dto.ResultModel;
import com.lxinet.jeesns.core.enums.MessageType;
import com.lxinet.jeesns.core.exception.OpeErrorException;
import com.lxinet.jeesns.core.exception.ParamException;
import com.lxinet.jeesns.core.model.Page;
import com.lxinet.jeesns.core.service.impl.BaseServiceImpl;
import com.lxinet.jeesns.core.utils.StringUtils;
import com.lxinet.jeesns.core.utils.TopicUtil;
import com.lxinet.jeesns.core.utils.ValidUtill;
import com.lxinet.jeesns.dao.weibo.IWeiboDao;
import com.lxinet.jeesns.model.member.Member;
import com.lxinet.jeesns.model.weibo.Weibo;
import com.lxinet.jeesns.model.weibo.WeiboTopic;
import com.lxinet.jeesns.service.member.IMemberService;
import com.lxinet.jeesns.service.member.IMessageService;
import com.lxinet.jeesns.service.member.IScoreDetailService;
import com.lxinet.jeesns.service.picture.IPictureService;
import com.lxinet.jeesns.service.system.IActionLogService;
import com.lxinet.jeesns.service.weibo.IWeiboFavorService;
import com.lxinet.jeesns.service.weibo.IWeiboService;
import com.lxinet.jeesns.service.weibo.IWeiboTopicService;
import com.lxinet.jeesns.utils.ActionLogType;
import com.lxinet.jeesns.utils.ActionUtil;
import com.lxinet.jeesns.utils.ScoreRuleConsts;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="weiboService")
public class WeiboServiceImpl
extends BaseServiceImpl<Weibo>
implements IWeiboService {
    @Resource
    private IWeiboDao weiboDao;
    @Resource
    private IWeiboFavorService weiboFavorService;
    @Resource
    private IActionLogService actionLogService;
    @Resource
    private IPictureService pictureService;
    @Resource
    private IScoreDetailService scoreDetailService;
    @Resource
    private IMessageService messageService;
    @Resource
    private IMemberService memberService;
    @Resource
    private IWeiboTopicService weiboTopicService;

    @Override
    public Weibo findById(int id, int memberId) {
        Weibo weibo = this.weiboDao.findById(id, memberId);
        return weibo;
    }

    @Override
    @Transactional
    public boolean save(HttpServletRequest request, Member loginMember, String content, String pictures) {
        int result;
        if ("0".equals(request.getServletContext().getAttribute("weibo_post".toUpperCase()))) {
            throw new OpeErrorException("\u5fae\u535a\u5df2\u5173\u95ed");
        }
        ValidUtill.checkIsBlank((String)content, (String)"\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        if (content.length() > Integer.parseInt((String)request.getServletContext().getAttribute("weibo_post_maxcontent".toUpperCase()))) {
            throw new ParamException("\u5185\u5bb9\u4e0d\u80fd\u8d85\u8fc7" + request.getServletContext().getAttribute("weibo_post_maxcontent".toUpperCase()) + "\u5b57");
        }
        String topicName = TopicUtil.getTopicName((String)content);
        WeiboTopic weiboTopic = null;
        if (StringUtils.isNotBlank((String)topicName) && (weiboTopic = this.weiboTopicService.findByName(topicName)) == null) {
            weiboTopic = new WeiboTopic();
            weiboTopic.setName(topicName);
            this.weiboTopicService.save(weiboTopic);
        }
        Weibo weibo = new Weibo();
        weibo.setMemberId(loginMember.getId());
        weibo.setContent(content);
        weibo.setStatus(1);
        if (StringUtils.isEmpty((String)pictures)) {
            weibo.setType(0);
        } else {
            weibo.setType(1);
        }
        if (weiboTopic != null) {
            weibo.setTopicId(weiboTopic.getId());
        }
        if ((result = this.weiboDao.saveObj(weibo)) == 1) {
            this.messageService.atDeal(loginMember.getId(), content, 2, MessageType.WEIBO_REFER, weibo.getId());
            this.pictureService.update(weibo.getId(), pictures, content);
            this.actionLogService.save(loginMember.getCurrLoginIp(), loginMember.getId(), ActionUtil.POST_WEIBO, "", ActionLogType.WEIBO.getValue(), weibo.getId());
            this.scoreDetailService.scoreBonus(loginMember.getId(), ScoreRuleConsts.RELEASE_WEIBO, weibo.getId());
        }
        return result == 1;
    }

    @Override
    public ResultModel<Weibo> listByPage(Page page, int memberId, int loginMemberId, String key) {
        if (StringUtils.isNotBlank((String)key)) {
            key = "%" + key.trim() + "%";
        }
        List<Weibo> list = this.weiboDao.list(page, memberId, loginMemberId, key);
        list = this.formatWeibo(list);
        ResultModel model = new ResultModel(0, page);
        model.setData(list);
        return model;
    }

    @Override
    @Transactional
    public boolean delete(HttpServletRequest request, Member loginMember, int id) {
        Weibo weibo = this.findById(id, loginMember.getId());
        ValidUtill.checkIsNull((Object)weibo, (String)"\u5fae\u535a\u4e0d\u5b58\u5728");
        this.weiboDao.delete(id);
        this.scoreDetailService.scoreCancelBonus(loginMember.getId(), ScoreRuleConsts.RELEASE_WEIBO, id);
        this.pictureService.deleteByForeignId(request, id);
        this.actionLogService.save(loginMember.getCurrLoginIp(), loginMember.getId(), ActionUtil.DELETE_WEIBO, "ID\uff1a" + weibo.getId() + "\uff0c\u5185\u5bb9\uff1a" + weibo.getContent());
        return true;
    }

    @Override
    @Transactional
    public boolean userDelete(HttpServletRequest request, Member loginMember, int id) {
        Weibo weibo = this.findById(id, loginMember.getId());
        ValidUtill.checkIsNull((Object)weibo, (String)"\u5fae\u535a\u4e0d\u5b58\u5728");
        if (loginMember.getIsAdmin() == 0 && loginMember.getId().intValue() != weibo.getMember().getId().intValue()) {
            throw new OpeErrorException("\u6ca1\u6709\u6743\u9650");
        }
        return this.delete(request, loginMember, id);
    }

    @Override
    public List<Weibo> hotList(int loginMemberId) {
        List<Weibo> hotList = this.weiboDao.hotList(loginMemberId);
        hotList = this.formatWeibo(hotList);
        return hotList;
    }

    @Override
    @Transactional
    public ResultModel favor(Member loginMember, int weiboId) {
        ValidUtill.checkParam((Boolean[])new Boolean[]{weiboId == 0});
        Weibo weibo = this.findById(weiboId, loginMember.getId());
        ResultModel resultModel = new ResultModel(0);
        if (this.weiboFavorService.find(weiboId, loginMember.getId()) == null) {
            this.weiboDao.favor(weiboId, 1);
            weibo.setFavor(weibo.getFavor() + 1);
            this.weiboFavorService.save(weiboId, loginMember.getId());
            this.scoreDetailService.scoreBonus(loginMember.getId(), ScoreRuleConsts.WEIBO_RECEIVED_THUMBUP, weiboId);
            this.messageService.diggDeal(loginMember.getId(), weibo.getMemberId(), 2, MessageType.WEIBO_ZAN, weibo.getId());
        } else {
            this.weiboDao.favor(weiboId, -1);
            weibo.setFavor(weibo.getFavor() - 1);
            this.weiboFavorService.delete(weiboId, loginMember.getId());
            this.scoreDetailService.scoreCancelBonus(loginMember.getId(), ScoreRuleConsts.WEIBO_RECEIVED_THUMBUP, weiboId);
            resultModel.setCode(1);
        }
        resultModel.setData((Object)weibo.getFavor());
        return resultModel;
    }

    @Override
    public List<Weibo> listByCustom(int loginMemberId, String sort, int num, int day) {
        List<Weibo> list = this.weiboDao.listByCustom(loginMemberId, sort, num, day);
        list = this.formatWeibo(list);
        return list;
    }

    @Override
    public ResultModel<Weibo> listByTopic(Page page, int loginMemberId, String topicName) {
        List<Weibo> list;
        WeiboTopic weiboTopic = this.weiboTopicService.findByName(topicName);
        if (weiboTopic == null) {
            weiboTopic = new WeiboTopic();
            weiboTopic.setName(topicName);
            this.weiboTopicService.save(weiboTopic);
            list = new ArrayList<Weibo>();
        } else {
            list = this.weiboDao.listByTopic(page, loginMemberId, weiboTopic.getId());
            list = this.formatWeibo(list);
        }
        ResultModel model = new ResultModel(0, page);
        model.setData(list);
        return model;
    }

    public Weibo formatWeibo(Weibo weibo) {
        weibo.setContent(this.memberService.atFormat(weibo.getContent()));
        weibo.setContent(TopicUtil.formatTopic((String)weibo.getContent()));
        return weibo;
    }

    public List<Weibo> formatWeibo(List<Weibo> weiboList) {
        for (Weibo weibo : weiboList) {
            this.formatWeibo(weibo);
        }
        return weiboList;
    }
}

