/*
 * Decompiled with CFR 0.152.
 */
package com.lxinet.jeesns.core.service.impl;

import com.lxinet.jeesns.core.conditions.SqlWrapper;
import com.lxinet.jeesns.core.dao.BaseMapper;
import com.lxinet.jeesns.core.model.Page;
import com.lxinet.jeesns.core.service.IBaseService;
import com.lxinet.jeesns.core.utils.PageUtil;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseServiceImpl<T>
implements IBaseService<T> {
    @Autowired
    private BaseMapper<T> baseMapper;

    @Override
    public T findById(Integer id) {
        return this.baseMapper.getById(id, this.getTClass());
    }

    @Override
    public List<T> listAll() {
        SqlWrapper<Class<T>> sqlWrapper = new SqlWrapper<Class<T>>(this.getTClass());
        return this.baseMapper.listAll(sqlWrapper);
    }

    @Override
    public List<T> listAll(SqlWrapper<T> sqlWrapper) {
        return this.baseMapper.listAll(sqlWrapper);
    }

    @Override
    public List<T> listByPage() {
        SqlWrapper<Class<T>> sqlWrapper = new SqlWrapper<Class<T>>(this.getTClass());
        return this.baseMapper.listByPage(PageUtil.getPage(), sqlWrapper);
    }

    @Override
    public List<T> listByPage(Page page, SqlWrapper<T> sqlWrapper) {
        return this.baseMapper.listByPage(page, sqlWrapper);
    }

    @Override
    public boolean save(T t) {
        return this.baseMapper.saveObj(t) > 0;
    }

    @Override
    public boolean update(T t) {
        return this.baseMapper.updateObj(t) > 0;
    }

    @Override
    public boolean delete(T t) {
        return this.baseMapper.deleteObj(t) > 0;
    }

    @Override
    public boolean deleteById(Integer id) {
        return this.baseMapper.deleteById(id, this.getTClass()) > 0;
    }

    private Class<T> getTClass() {
        Class tClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        return tClass;
    }
}

