/*
 * Decompiled with CFR 0.152.
 */
package com.lxinet.jeesns.core.utils;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Arrays;
import javax.imageio.ImageIO;

public class ImageUtil {
    public static final String THUMB_DEFAULT_PREVFIX = "thumb_";
    public static final String SMALL_DEFAULT_PREVFIX = "small_";
    private static final int DEFAULT_WIDTH = 260;
    private static final int DEFAULT_HEIGHT = 160;
    private static final int THUMB_DEFAULT_WIDTH = 160;
    private static final int THUMB_DEFAULT_HEIGHT = 160;
    private File targetFile;

    public String dealImage(File imgFile) {
        this.thumbnailImage(imgFile);
        return this.cutImage(this.targetFile);
    }

    private String thumbnailImage(File imgFile, String prevfix) {
        String thumbPath = "";
        String fileName = "";
        if (imgFile.exists()) {
            try {
                int w;
                int h;
                int height;
                String types = Arrays.toString(ImageIO.getReaderFormatNames());
                String suffix = null;
                if (imgFile.getName().indexOf(".") > -1) {
                    suffix = imgFile.getName().substring(imgFile.getName().lastIndexOf(".") + 1);
                }
                if (suffix == null || types.toLowerCase().indexOf(suffix.toLowerCase()) < 0) {
                    return thumbPath;
                }
                BufferedImage img = ImageIO.read(imgFile);
                int width = ((Image)img).getWidth(null);
                if (width > (height = ((Image)img).getHeight(null))) {
                    h = 160;
                    w = (int)((double)(width * h) * 1.0 / ((double)height * 1.0));
                } else {
                    w = 260;
                    h = (int)((double)(height * w) * 1.0 / ((double)width * 1.0));
                }
                BufferedImage bi = new BufferedImage(w, h, 1);
                Graphics g = bi.getGraphics();
                g.drawImage(img, 0, 0, w, h, Color.LIGHT_GRAY, null);
                g.dispose();
                fileName = prevfix + imgFile.getName();
                String p = imgFile.getPath();
                thumbPath = p.substring(0, p.lastIndexOf(File.separator)) + File.separator + fileName;
                this.targetFile = new File(thumbPath);
                ImageIO.write((RenderedImage)bi, suffix, this.targetFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return fileName;
    }

    private String thumbnailImage(File imgFile) {
        return this.thumbnailImage(imgFile, SMALL_DEFAULT_PREVFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String cutImage(File imgFile) {
        String suffix;
        String thumbPath;
        String fileName;
        block10: {
            fileName = "";
            thumbPath = "";
            String types = Arrays.toString(ImageIO.getReaderFormatNames());
            suffix = null;
            if (imgFile.getName().indexOf(".") > -1) {
                suffix = imgFile.getName().substring(imgFile.getName().lastIndexOf(".") + 1);
            }
            if (suffix != null && types.toLowerCase().indexOf(suffix.toLowerCase()) >= 0) break block10;
            String string = thumbPath;
            return string;
        }
        try {
            int h;
            int y;
            int w;
            int x;
            BufferedImage img = ImageIO.read(imgFile);
            int width = ((Image)img).getWidth(null);
            int height = ((Image)img).getHeight(null);
            if (width > 160) {
                x = (width - 160) / 2;
                w = 160 + x;
            } else {
                w = width;
                x = 0;
            }
            if (height > 160) {
                y = (height - 160) / 2;
                h = 160 + y;
            } else {
                h = height;
                y = 0;
            }
            BufferedImage bi = new BufferedImage(160, 160, 1);
            Graphics g = bi.getGraphics();
            g.drawImage(img, 0, 0, w, h, x, y, x + w, y + h, null);
            g.dispose();
            String name = imgFile.getName();
            name = name.replaceAll(SMALL_DEFAULT_PREVFIX, "");
            fileName = THUMB_DEFAULT_PREVFIX + name;
            String p = imgFile.getPath();
            thumbPath = p.substring(0, p.lastIndexOf(File.separator)) + File.separator + fileName;
            this.targetFile = new File(thumbPath);
            ImageIO.write((RenderedImage)bi, suffix, this.targetFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileName;
    }
}

