<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>申请${GROUP_ALIAS} - ${SITE_NAME} - Powered By JEESNS</title>
    <link href="${basePath}/res/common/css/zui.min.css" rel="stylesheet">
    <link href="${basePath}/res/front/css/app.css" rel="stylesheet">
    <link href="${basePath}/res/plugins/webuploader/webuploader.css" rel="stylesheet">
    <link href="${basePath}/res/plugins/layer/skin/layer.css" rel="stylesheet">
    <!--[if lt IE 9]>
    <script src="${basePath}/res/common/js/html5shiv.js"></script>
    <script src="${basePath}/res/common/js/respond.min.js"></script>
    <![endif]-->
    <script src="${basePath}/res/common/js/jquery-2.1.1.min.js"></script>
    <script src="${basePath}/res/common/js/jquery.form.js"></script>
    <script src="${basePath}/res/common/js/zui.min.js"></script>
    <script src="${basePath}/res/plugins/layer/layer.js"></script>
    <script src="${basePath}/res/front/js/jeesns.js?v1.4"></script>
    <script src="${basePath}/res/plugins/webuploader/webuploader.min.js"></script>
    <script src="${basePath}/res/plugins/jquerytags/js/jquery.tags.js"></script>
    <script type="text/javascript">
        var basePath = "${basePath}";
        var uploadServer = "${basePath}/uploadImage";

        function applySuccess() {
            localStorage.setItem("message","申请成功，请等待审核");
            window.location.href = "index";
        }
    </script>
    <script src="${basePath}/res/plugins/webuploader/upload.js"></script>
</head>
<body class="gray-bg">
<#include "/${frontTemplate}/common/header.ftl"/>
<div class="container">
    <div class="main-content">
        <div class="row">
            <div class="col-sm-22 col-xs-12">
                <div class="article-detail">
                    <form class="form-horizontal jeesns_form" role="form" action="${groupPath}/apply" method="post" callback="applySuccess">
                        <div class="form-group">
                            <label class="col-sm-2 control-label">名称</label>
                            <div class="col-sm-8">
                                <input type="text" class="form-control" id="name" name="name" placeholder="名称" data-type="require">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-2 control-label">所属分类</label>
                            <div class="col-sm-3">
                                <select class="form-control" name="typeId">
                                <#list groupTypeList as groupType>
                                    <option value="${groupType.id}">${groupType.name}</option>
                                </#list>
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-2 control-label">缩略图</label>
                            <div class="col-sm-20">
                                <div id="uploader" class="wu-example">
                                    <!--用来存放文件信息-->
                                    <input type="hidden" id="thumbnail" name="logo">
                                    <div id="preview" class="uploader-list"></div>
                                    <div id="imagesList" class="uploader-list"></div>
                                    <div class="btns">
                                        <div id="picker">选择文件</div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label">付费加入</label>
                            <div class="col-sm-3">
                                <select class="form-control" name="followPay" id="followPay">
                                    <option value="0">免费</option>
                                    <option value="1">收费</option>
                                </select>
                            </div>
                            <div class="col-sm-3">
                                申请后无法再修改
                            </div>

                        </div>
                        <div class="form-group pay-money-line" style="display: none">
                            <label class="col-sm-2 control-label">加入收费金额</label>
                            <div class="col-sm-8">
                                <input type="text" class="form-control" id="payMoney" name="payMoney" placeholder="加入收费金额">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-2 control-label">介绍</label>
                            <div class="col-sm-8">
                                <textarea class="form-control" rows="3" name="introduce" alt="介绍"></textarea>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-2 control-label">标签</label>
                            <div class="col-sm-8">
                                <input type="text" class="form-control" id="inputtags">每个标签用空格结束
                                <input type="hidden" class="form-control" id="tags" name="tags"/>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="col-sm-offset-2 col-sm-20">
                                <button type="submit" class="btn btn-info jeesns-submit">申请${GROUP_ALIAS}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<#include "/${frontTemplate}/common/footer.ftl"/>
<script>
    $(function () {
        $('#inputmanagers').tags();
        setInterval(function () {
            $('#managers').val($('#inputmanagers').val());
        }, 500);
        $('#inputtags').tags();
        setInterval(function () {
            $('#tags').val($('#inputtags').val());

        }, 500);
        $("#followPay").change(function () {
           var val = $(this).val();
           if (val == 0){
               $(".pay-money-line").hide();
               $("#payMoney").attr("data-type","");
           } else {
               $(".pay-money-line").show();
               $("#payMoney").attr("data-type","require,double");
           }
        });
    });
</script>
</body>
</html>