/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0;

import com.mchange.v2.c3p0.C3P0Registry;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.mchange.v2.c3p0.PooledDataSource;
import com.mchange.v2.c3p0.impl.C3P0ImplUtils;
import com.mchange.v2.c3p0.impl.C3P0PooledConnectionPoolManager;
import com.mchange.v2.c3p0.impl.IdentityTokenized;
import com.mchange.v2.c3p0.impl.PoolBackedDataSourceBase;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public final class PoolBackedDataSource
extends PoolBackedDataSourceBase
implements PooledDataSource {
    static final MLogger logger = MLog.getLogger(class$com$mchange$v2$c3p0$PoolBackedDataSource == null ? (class$com$mchange$v2$c3p0$PoolBackedDataSource = PoolBackedDataSource.class$("com.mchange.v2.c3p0.PoolBackedDataSource")) : class$com$mchange$v2$c3p0$PoolBackedDataSource);
    static final String NO_CPDS_ERR_MSG = "Attempted to use an uninitialized PoolBackedDataSource. Please call setConnectionPoolDataSource( ... ) to initialize.";
    ComboPooledDataSource parent;
    transient C3P0PooledConnectionPoolManager poolManager;
    transient boolean is_closed = false;
    private static final long serialVersionUID = 1L;
    private static final short VERSION = 1;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$PoolBackedDataSource;

    public PoolBackedDataSource() {
        this(null);
    }

    PoolBackedDataSource(ComboPooledDataSource parent) {
        this.parent = parent;
        PropertyChangeListener l = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                PoolBackedDataSource.this.resetPoolManager();
            }
        };
        this.addPropertyChangeListener(l);
        C3P0Registry.register(this);
    }

    ComboPooledDataSource owner() {
        return this.parent;
    }

    public Connection getConnection() throws SQLException {
        PooledConnection pc = this.getPoolManager().getPool().checkoutPooledConnection();
        return pc.getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        PooledConnection pc = this.getPoolManager().getPool(username, password).checkoutPooledConnection();
        return pc.getConnection();
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.assertCpds().getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.assertCpds().setLogWriter(out);
    }

    public int getLoginTimeout() throws SQLException {
        return this.assertCpds().getLoginTimeout();
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.assertCpds().setLoginTimeout(seconds);
    }

    public int getNumConnections() throws SQLException {
        return this.getPoolManager().getPool().getNumConnections();
    }

    public int getNumIdleConnections() throws SQLException {
        return this.getPoolManager().getPool().getNumIdleConnections();
    }

    public int getNumBusyConnections() throws SQLException {
        return this.getPoolManager().getPool().getNumBusyConnections();
    }

    public int getNumUnclosedOrphanedConnections() throws SQLException {
        return this.getPoolManager().getPool().getNumUnclosedOrphanedConnections();
    }

    public int getNumConnectionsDefaultUser() throws SQLException {
        return this.getNumConnections();
    }

    public int getNumIdleConnectionsDefaultUser() throws SQLException {
        return this.getNumIdleConnections();
    }

    public int getNumBusyConnectionsDefaultUser() throws SQLException {
        return this.getNumBusyConnections();
    }

    public int getNumUnclosedOrphanedConnectionsDefaultUser() throws SQLException {
        return this.getNumUnclosedOrphanedConnections();
    }

    public void softResetDefaultUser() throws SQLException {
        this.getPoolManager().getPool().reset();
    }

    public int getNumConnections(String username, String password) throws SQLException {
        return this.getPoolManager().getPool(username, password).getNumConnections();
    }

    public int getNumIdleConnections(String username, String password) throws SQLException {
        return this.getPoolManager().getPool(username, password).getNumIdleConnections();
    }

    public int getNumBusyConnections(String username, String password) throws SQLException {
        return this.getPoolManager().getPool(username, password).getNumBusyConnections();
    }

    public int getNumUnclosedOrphanedConnections(String username, String password) throws SQLException {
        return this.getPoolManager().getPool(username, password).getNumUnclosedOrphanedConnections();
    }

    public void softReset(String username, String password) throws SQLException {
        this.getPoolManager().getPool(username, password).reset();
    }

    public int getNumBusyConnectionsAllUsers() throws SQLException {
        return this.getPoolManager().getNumBusyConnectionsAllAuths();
    }

    public int getNumIdleConnectionsAllUsers() throws SQLException {
        return this.getPoolManager().getNumIdleConnectionsAllAuths();
    }

    public int getNumConnectionsAllUsers() throws SQLException {
        return this.getPoolManager().getNumConnectionsAllAuths();
    }

    public int getNumUnclosedOrphanedConnectionsAllUsers() throws SQLException {
        return this.getPoolManager().getNumUnclosedOrphanedConnectionsAllAuths();
    }

    public void softResetAllUsers() throws SQLException {
        this.getPoolManager().softResetAllAuths();
    }

    public int getNumUserPools() throws SQLException {
        return this.getPoolManager().getNumManagedAuths();
    }

    public synchronized void hardReset() {
        C3P0PooledConnectionPoolManager forceDestroyMe = this.poolManager;
        this.resetPoolManager();
        forceDestroyMe.forceDestroy();
    }

    public void close() {
        this.close(false);
    }

    public synchronized void close(boolean force_destroy) {
        C3P0PooledConnectionPoolManager forceDestroyMe = force_destroy ? this.poolManager : null;
        this.resetPoolManager();
        if (force_destroy) {
            forceDestroyMe.forceDestroy();
        }
        this.is_closed = true;
        if (logger.isLoggable(MLevel.FINEST)) {
            logger.log(MLevel.FINEST, this.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(this)) + " has been closed. force_destroy == " + force_destroy, new Exception("DEBUG STACK TRACE for PoolBackedDataSource.close()."));
        }
    }

    public synchronized void resetPoolManager() {
        if (this.poolManager != null) {
            this.poolManager.unregisterActiveClient(this);
            this.poolManager = null;
        }
    }

    private synchronized ConnectionPoolDataSource assertCpds() throws SQLException {
        if (this.is_closed) {
            throw new SQLException(this + " has been closed() -- you can no longer use it.");
        }
        ConnectionPoolDataSource out = this.getConnectionPoolDataSource();
        if (out == null) {
            throw new SQLException(NO_CPDS_ERR_MSG);
        }
        return out;
    }

    private synchronized C3P0PooledConnectionPoolManager getPoolManager() throws SQLException {
        if (this.poolManager == null) {
            ConnectionPoolDataSource cpds = this.assertCpds();
            String cpdsIdTkn = cpds instanceof IdentityTokenized ? ((IdentityTokenized)((Object)cpds)).getIdentityToken() : C3P0ImplUtils.identityToken(cpds);
            this.poolManager = C3P0PooledConnectionPoolManager.find(this.getIdentityToken(), cpds, cpdsIdTkn, this.getNumHelperThreads());
            this.poolManager.registerActiveClient(this);
            if (logger.isLoggable(MLevel.INFO)) {
                logger.info("Initializing c3p0 pool... " + (this.parent == null ? this.toString() : this.parent.toString()));
            }
        }
        return this.poolManager;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeShort(1);
        oos.writeObject(this.parent);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        short version = ois.readShort();
        switch (version) {
            case 1: {
                this.parent = (ComboPooledDataSource)ois.readObject();
                break;
            }
            default: {
                throw new IOException("Unsupported Serialized Version: " + version);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

