/*
SQLyog Ultimate v11.4 (64 bit)
MySQL - 5.5.28 : Database - te_employee
*********************************************************************
*/


/*!40101 SET NAMES utf8 */;

/*!40101 SET SQL_MODE=''*/;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
CREATE DATABASE /*!32312 IF NOT EXISTS*/`te_employee` /*!40100 DEFAULT CHARACTER SET utf8 */;

USE `te_employee`;

/*Table structure for table `te_account` */

DROP TABLE IF EXISTS `te_account`;

CREATE TABLE `te_account` (
  `acctId` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '账户ID',
  `acctName` varchar(64) DEFAULT NULL COMMENT '账户名',
  `acctNickname` varchar(64) DEFAULT NULL COMMENT '名称',
  `acctPassword` varchar(64) DEFAULT NULL COMMENT '密码',
  `acctState` int(2) DEFAULT '0' COMMENT '帐号状态',
  `acctSuper` tinyint(1) DEFAULT '0' COMMENT '是否为超级管理员',
  `acctDeleteState` tinyint(1) DEFAULT '0' COMMENT '删除状态',
  `createTime` datetime DEFAULT NULL COMMENT '创建时间',
  `creator` varchar(64) DEFAULT NULL COMMENT '创建人',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`acctId`),
  UNIQUE KEY `acctName` (`acctName`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

/*Data for the table `te_account` */

LOCK TABLES `te_account` WRITE;

insert  into `te_account`(`acctId`,`acctName`,`acctNickname`,`acctPassword`,`acctState`,`acctSuper`,`acctDeleteState`,`createTime`,`creator`,`timestamp`) values (1,'admin','admin','0992544eb78868cc056dee57947b2947',0,1,0,'2015-09-03 16:52:04','admin','2015-09-03 16:52:09'),(2,'Kiro','TE.Kiro','0992544eb78868cc056dee57947b2947',0,0,0,'2016-07-03 14:06:55','admin','2016-07-03 14:06:55'),(3,'department','部门管理员','0992544eb78868cc056dee57947b2947',0,0,0,'2016-07-03 14:10:48','admin','2016-07-03 14:10:48');

UNLOCK TABLES;

/*Table structure for table `te_account_role` */

DROP TABLE IF EXISTS `te_account_role`;

CREATE TABLE `te_account_role` (
  `aoId` bigint(20) NOT NULL AUTO_INCREMENT,
  `acctName` varchar(64) DEFAULT NULL COMMENT '账户名',
  `roleLabel` varchar(64) DEFAULT NULL COMMENT '角色标识',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`aoId`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

/*Data for the table `te_account_role` */

LOCK TABLES `te_account_role` WRITE;

insert  into `te_account_role`(`aoId`,`acctName`,`roleLabel`,`timestamp`) values (1,'Kiro','09b5320a-b337-4240-86fc-f260fb343b2d','2016-07-03 14:08:45'),(2,'department','9251431b-7451-4f92-86e0-b3cae977046a','2016-07-03 14:10:53');

UNLOCK TABLES;

/*Table structure for table `te_address` */

DROP TABLE IF EXISTS `te_address`;

CREATE TABLE `te_address` (
  `adsId` bigint(20) NOT NULL AUTO_INCREMENT,
  `adsType` int(2) DEFAULT '0',
  `adsProvince` bigint(20) DEFAULT '0' COMMENT '省份ID',
  `adsCity` bigint(20) DEFAULT '0' COMMENT '市级ID',
  `adsCounty` bigint(20) DEFAULT '0' COMMENT '县级ID',
  `adsTownship` bigint(20) DEFAULT NULL,
  `adsVillage` bigint(20) DEFAULT NULL,
  `adsDetailed` varchar(512) DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`adsId`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

/*Data for the table `te_address` */

LOCK TABLES `te_address` WRITE;

insert  into `te_address`(`adsId`,`adsType`,`adsProvince`,`adsCity`,`adsCounty`,`adsTownship`,`adsVillage`,`adsDetailed`,`timestamp`) values (1,1,23,250,2335,32425,581212,'','2016-07-03 14:48:25'),(2,2,16,161,1581,20533,380733,'','2016-07-03 14:48:25');

UNLOCK TABLES;

/*Table structure for table `te_choose_education` */

DROP TABLE IF EXISTS `te_choose_education`;

CREATE TABLE `te_choose_education` (
  `eduId` bigint(20) NOT NULL AUTO_INCREMENT,
  `eduName` varchar(64) DEFAULT NULL COMMENT '学历名称',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`eduId`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

/*Data for the table `te_choose_education` */

LOCK TABLES `te_choose_education` WRITE;

insert  into `te_choose_education`(`eduId`,`eduName`,`timestamp`) values (1,'不识字','2015-09-12 20:34:35'),(2,'小学','2015-09-12 20:34:38'),(3,'初中','2015-09-12 20:34:41'),(4,'技工','2015-09-12 20:34:47'),(5,'高中','2015-09-12 20:34:51'),(6,'大学','2015-09-12 20:34:54'),(7,'硕士','2015-09-12 20:35:02'),(8,'博士及以上','2015-09-12 22:34:36');

UNLOCK TABLES;

/*Table structure for table `te_choose_marriage` */

DROP TABLE IF EXISTS `te_choose_marriage`;

CREATE TABLE `te_choose_marriage` (
  `marId` bigint(20) NOT NULL AUTO_INCREMENT,
  `marName` varchar(64) DEFAULT NULL COMMENT '婚姻状况名称',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`marId`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

/*Data for the table `te_choose_marriage` */

LOCK TABLES `te_choose_marriage` WRITE;

insert  into `te_choose_marriage`(`marId`,`marName`,`timestamp`) values (1,'未婚','2015-09-12 20:36:07'),(2,'已婚','2015-09-12 20:36:11'),(3,'离婚','2015-09-12 20:36:41'),(4,'丧偶','2015-09-12 20:36:42'),(5,'其他','2015-09-12 20:36:19');

UNLOCK TABLES;

/*Table structure for table `te_choose_national` */

DROP TABLE IF EXISTS `te_choose_national`;

CREATE TABLE `te_choose_national` (
  `natId` bigint(20) NOT NULL AUTO_INCREMENT,
  `natName` varchar(64) DEFAULT NULL COMMENT '名称',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`natId`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

/*Data for the table `te_choose_national` */

LOCK TABLES `te_choose_national` WRITE;

insert  into `te_choose_national`(`natId`,`natName`,`timestamp`) values (1,'汉族','2015-09-12 22:23:20'),(2,'藏族','2015-09-12 22:23:24'),(3,'彝族','2015-09-12 22:23:25'),(4,'回族','2015-09-12 22:23:28'),(5,'维族','2015-09-12 22:23:32'),(6,'苗族','2015-09-12 22:23:37'),(7,'其他','2015-09-12 22:23:41');

UNLOCK TABLES;

/*Table structure for table `te_choose_politics` */

DROP TABLE IF EXISTS `te_choose_politics`;

CREATE TABLE `te_choose_politics` (
  `polId` bigint(20) NOT NULL AUTO_INCREMENT,
  `polName` varchar(64) DEFAULT NULL COMMENT '名称',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`polId`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

/*Data for the table `te_choose_politics` */

LOCK TABLES `te_choose_politics` WRITE;

insert  into `te_choose_politics`(`polId`,`polName`,`timestamp`) values (1,'无党派民主人士','2015-09-12 20:36:57'),(2,'中共党员','2015-09-12 20:37:03'),(3,'共青团员','2015-09-12 20:37:08'),(4,'民革党员','2015-09-12 20:38:11'),(5,'民盟盟员','2015-09-12 20:38:17'),(6,'农工党党员','2015-09-12 20:38:22'),(7,'群众','2015-09-12 20:38:27');

UNLOCK TABLES;

/*Table structure for table `te_city` */

DROP TABLE IF EXISTS `te_city`;

CREATE TABLE `te_city` (
  `cityId` bigint(11) NOT NULL,
  `cityName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `cityCode` varchar(3) COLLATE utf8_unicode_ci NOT NULL,
  `provinceId` bigint(11) NOT NULL,
  PRIMARY KEY (`cityId`),
  KEY `provinceId` (`provinceId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `te_city` */

LOCK TABLES `te_city` WRITE;

insert  into `te_city`(`cityId`,`cityName`,`cityCode`,`provinceId`) values (1,'市辖区','01',1),(2,'县','02',1),(3,'市辖区','01',2),(4,'市辖县','02',2),(5,'石家庄市','01',3),(6,'唐山市','02',3),(7,'秦皇岛市','03',3),(8,'邯郸市','04',3),(9,'邢台市','05',3),(10,'保定市','06',3),(11,'张家口市','07',3),(12,'承德市','08',3),(13,'沧州市','09',3),(14,'廊坊市','10',3),(15,'衡水市','11',3),(16,'太原市','01',4),(17,'大同市','02',4),(18,'阳泉市','03',4),(19,'长治市','04',4),(20,'晋城市','05',4),(21,'朔州市','06',4),(22,'晋中市','07',4),(23,'运城市','08',4),(24,'忻州市','09',4),(25,'临汾市','10',4),(26,'吕梁市','11',4),(27,'呼和浩特市','01',5),(28,'包头市','02',5),(29,'乌海市','03',5),(30,'赤峰市','04',5),(31,'通辽市','05',5),(32,'鄂尔多斯市','06',5),(33,'呼伦贝尔市','07',5),(34,'巴彦淖尔市','08',5),(35,'乌兰察布市','09',5),(36,'兴安盟','22',5),(37,'锡林郭勒盟','25',5),(38,'阿拉善盟','29',5),(39,'沈阳市','01',6),(40,'大连市','02',6),(41,'鞍山市','03',6),(42,'抚顺市','04',6),(43,'本溪市','05',6),(44,'丹东市','06',6),(45,'锦州市','07',6),(46,'营口市','08',6),(47,'阜新市','09',6),(48,'辽阳市','10',6),(49,'盘锦市','11',6),(50,'铁岭市','12',6),(51,'朝阳市','13',6),(52,'葫芦岛市','14',6),(53,'长春市','01',7),(54,'吉林市','02',7),(55,'四平市','03',7),(56,'辽源市','04',7),(57,'通化市','05',7),(58,'白山市','06',7),(59,'松原市','07',7),(60,'白城市','08',7),(61,'延边朝鲜族自治州','24',7),(62,'哈尔滨市','01',8),(63,'齐齐哈尔市','02',8),(64,'鸡西市','03',8),(65,'鹤岗市','04',8),(66,'双鸭山市','05',8),(67,'大庆市','06',8),(68,'伊春市','07',8),(69,'佳木斯市','08',8),(70,'七台河市','09',8),(71,'牡丹江市','10',8),(72,'黑河市','11',8),(73,'绥化市','12',8),(74,'大兴安岭地区','27',8),(75,'市辖区','01',9),(76,'县','02',9),(77,'南京市','01',10),(78,'无锡市','02',10),(79,'徐州市','03',10),(80,'常州市','04',10),(81,'苏州市','05',10),(82,'南通市','06',10),(83,'连云港市','07',10),(84,'淮安市','08',10),(85,'盐城市','09',10),(86,'扬州市','10',10),(87,'镇江市','11',10),(88,'泰州市','12',10),(89,'宿迁市','13',10),(90,'杭州市','01',11),(91,'宁波市','02',11),(92,'温州市','03',11),(93,'嘉兴市','04',11),(94,'湖州市','05',11),(95,'绍兴市','06',11),(96,'金华市','07',11),(97,'衢州市','08',11),(98,'舟山市','09',11),(99,'台州市','10',11),(100,'丽水市','11',11),(101,'合肥市','01',12),(102,'芜湖市','02',12),(103,'蚌埠市','03',12),(104,'淮南市','04',12),(105,'马鞍山市','05',12),(106,'淮北市','06',12),(107,'铜陵市','07',12),(108,'安庆市','08',12),(109,'黄山市','10',12),(110,'滁州市','11',12),(111,'阜阳市','12',12),(112,'宿州市','13',12),(113,'巢湖市','14',12),(114,'六安市','15',12),(115,'亳州市','16',12),(116,'池州市','17',12),(117,'宣城市','18',12),(118,'福州市','01',13),(119,'厦门市','02',13),(120,'莆田市','03',13),(121,'三明市','04',13),(122,'泉州市','05',13),(123,'漳州市','06',13),(124,'南平市','07',13),(125,'龙岩市','08',13),(126,'宁德市　','09',13),(127,'南昌市','01',14),(128,'景德镇市','02',14),(129,'萍乡市','03',14),(130,'九江市','04',14),(131,'新余市','05',14),(132,'鹰潭市','06',14),(133,'赣州市','07',14),(134,'吉安市','08',14),(135,'宜春市','09',14),(136,'抚州市','10',14),(137,'上饶市','11',14),(138,'济南市','01',15),(139,'青岛市','02',15),(140,'淄博市','03',15),(141,'枣庄市','04',15),(142,'东营市','05',15),(143,'烟台市','06',15),(144,'潍坊市','07',15),(145,'济宁市','08',15),(146,'泰安市','09',15),(147,'威海市','10',15),(148,'日照市','11',15),(149,'莱芜市','12',15),(150,'临沂市','13',15),(151,'德州市','14',15),(152,'聊城市','15',15),(153,'滨州市','16',15),(154,'菏泽市','17',15),(155,'郑州市','01',16),(156,'开封市','02',16),(157,'洛阳市','03',16),(158,'平顶山市','04',16),(159,'安阳市','05',16),(160,'鹤壁市','06',16),(161,'新乡市','07',16),(162,'焦作市','08',16),(163,'濮阳市','09',16),(164,'许昌市','10',16),(165,'漯河市','11',16),(166,'三门峡市','12',16),(167,'南阳市','13',16),(168,'商丘市','14',16),(169,'信阳市','15',16),(170,'周口市','16',16),(171,'驻马店市','17',16),(172,'武汉市','01',17),(173,'黄石市','02',17),(174,'十堰市','03',17),(175,'宜昌市','05',17),(176,'襄樊市','06',17),(177,'鄂州市','07',17),(178,'荆门市','08',17),(179,'孝感市','09',17),(180,'荆州市','10',17),(181,'黄冈市','11',17),(182,'咸宁市','12',17),(183,'随州市','13',17),(184,'恩施州','28',17),(185,'省直辖行政单位','90',17),(186,'长沙市','01',18),(187,'株洲市','02',18),(188,'湘潭市','03',18),(189,'衡阳市','04',18),(190,'邵阳市','05',18),(191,'岳阳市','06',18),(192,'常德市','07',18),(193,'张家界市','08',18),(194,'益阳市','09',18),(195,'郴州市','10',18),(196,'永州市','11',18),(197,'怀化市','12',18),(198,'娄底市','13',18),(199,'湘西土家族苗族自治州','31',18),(200,'广州市','01',19),(201,'韶关市','02',19),(202,'深圳市','03',19),(203,'珠海市','04',19),(204,'汕头市','05',19),(205,'佛山市','06',19),(206,'江门市','07',19),(207,'湛江市','08',19),(208,'茂名市','09',19),(209,'肇庆市','12',19),(210,'惠州市','13',19),(211,'梅州市','14',19),(212,'汕尾市','15',19),(213,'河源市','16',19),(214,'阳江市','17',19),(215,'清远市','18',19),(216,'东莞市','19',19),(217,'中山市','20',19),(218,'潮州市','51',19),(219,'揭阳市','52',19),(220,'云浮市','53',19),(221,'南宁市','01',20),(222,'柳州市','02',20),(223,'桂林市','03',20),(224,'梧州市','04',20),(225,'北海市','05',20),(226,'防城港市','06',20),(227,'钦州市','07',20),(228,'贵港市','08',20),(229,'玉林市','09',20),(230,'百色市','10',20),(231,'贺州市','11',20),(232,'河池市','12',20),(233,'来宾市','13',20),(234,'崇左市','14',20),(235,'海口市','01',21),(236,'三亚市','02',21),(237,'省属虚拟市','90',21),(238,'市辖区','01',22),(239,'县','02',22),(240,'成都市','01',23),(241,'自贡市','03',23),(242,'攀枝花市','04',23),(243,'泸州市','05',23),(244,'德阳市','06',23),(245,'绵阳市','07',23),(246,'广元市','08',23),(247,'遂宁市','09',23),(248,'内江市','10',23),(249,'乐山市','11',23),(250,'南充市','13',23),(251,'眉山市','14',23),(252,'宜宾市','15',23),(253,'广安市','16',23),(254,'达州市','17',23),(255,'雅安市','18',23),(256,'巴中市','19',23),(257,'资阳市','20',23),(258,'阿坝州','32',23),(259,'甘孜藏族自治州','33',23),(260,'凉山州','34',23),(261,'贵阳市','01',24),(262,'六盘水市','02',24),(263,'遵义市','03',24),(264,'安顺市','04',24),(265,'铜仁地区','22',24),(266,'黔西南州','23',24),(267,'毕节地区','24',24),(268,'黔东南苗族侗族自治州','26',24),(269,'黔南布依族苗族自治州','27',24),(270,'昆明市','01',25),(271,'曲靖市','03',25),(272,'玉溪市','04',25),(273,'保山市','05',25),(274,'昭通市','06',25),(275,'丽江市','07',25),(276,'思茅市','08',25),(277,'临沧市','09',25),(278,'楚雄州','23',25),(279,'红河州','25',25),(280,'文山州','26',25),(281,'西双版纳州','28',25),(282,'大理州','29',25),(283,'德宏州','31',25),(284,'怒江州','33',25),(285,'迪庆州','34',25),(286,'拉萨市','01',26),(287,'昌都地区','21',26),(288,'山南地区','22',26),(289,'日喀则地区','23',26),(290,'那曲地区','24',26),(291,'阿里地区','25',26),(292,'林芝地区','26',26),(293,'西安市','01',27),(294,'铜川市','02',27),(295,'宝鸡市','03',27),(296,'咸阳市','04',27),(297,'渭南市','05',27),(298,'延安市','06',27),(299,'汉中市','07',27),(300,'榆林市','08',27),(301,'安康市','09',27),(302,'商洛市','10',27),(303,'兰州市','01',28),(304,'嘉峪关市','02',28),(305,'金昌市','03',28),(306,'白银市','04',28),(307,'天水市','05',28),(308,'武威市','06',28),(309,'张掖市','07',28),(310,'平凉市','08',28),(311,'酒泉市','09',28),(312,'庆阳市','10',28),(313,'定西市','11',28),(314,'陇南市','12',28),(315,'临夏州','29',28),(316,'甘南州','30',28),(317,'西宁市','01',29),(318,'海东地区','21',29),(319,'海北州','22',29),(320,'黄南州','23',29),(321,'海南州','25',29),(322,'果洛州','26',29),(323,'玉树州','27',29),(324,'海西州','28',29),(325,'银川市','01',30),(326,'石嘴山市','02',30),(327,'吴忠市','03',30),(328,'固原市','04',30),(329,'中卫市','05',30),(330,'乌鲁木齐市','01',31),(331,'克拉玛依市','02',31),(332,'吐鲁番地区','21',31),(333,'哈密地区','22',31),(334,'昌吉州','23',31),(335,'博尔塔拉蒙古自治州','27',31),(336,'巴音郭楞蒙古自治州','28',31),(337,'阿克苏地区','29',31),(338,'克州','30',31),(339,'喀什地区','31',31),(340,'和田地区','32',31),(341,'伊犁州','40',31),(342,'塔城地区','42',31),(343,'阿勒泰地区','43',31),(344,'省直辖行政单位','90',31);

UNLOCK TABLES;

/*Table structure for table `te_county` */

DROP TABLE IF EXISTS `te_county`;

CREATE TABLE `te_county` (
  `countyId` bigint(11) NOT NULL,
  `countyName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `countyCode` varchar(3) COLLATE utf8_unicode_ci NOT NULL,
  `cityId` bigint(11) NOT NULL,
  PRIMARY KEY (`countyId`),
  KEY `cityId` (`cityId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `te_county` */

LOCK TABLES `te_county` WRITE;

insert  into `te_county`(`countyId`,`countyName`,`countyCode`,`cityId`) values (1,'东城区','01',1),(2,'西城区','02',1),(3,'崇文区','03',1),(4,'宣武区','04',1),(5,'朝阳区','05',1),(6,'丰台区','06',1),(7,'石景山区','07',1),(8,'海淀区','08',1),(9,'门头沟区','09',1),(10,'房山区','11',1),(11,'通州区','12',1),(12,'顺义区','13',1),(13,'昌平区','14',1),(14,'大兴区','15',1),(15,'怀柔区','16',1),(16,'平谷区','17',1),(17,'密云县','28',2),(18,'延庆县','29',2),(19,'和平区','01',3),(20,'河东区','02',3),(21,'河西区','03',3),(22,'南开区','04',3),(23,'河北区','05',3),(24,'红桥区','06',3),(25,'塘沽区','07',3),(26,'汉沽区','08',3),(27,'大港区','09',3),(28,'东丽区','10',3),(29,'西青区','11',3),(30,'津南区','12',3),(31,'北辰区','13',3),(32,'武清区','14',3),(33,'宝坻区','15',3),(34,'宁河县','21',4),(35,'静海县','23',4),(36,'蓟县','25',4),(37,'市辖区','01',5),(38,'长安区','02',5),(39,'桥东区','03',5),(40,'桥西区','04',5),(41,'新华区','05',5),(42,'井陉矿区','07',5),(43,'裕华区','08',5),(44,'井陉县','21',5),(45,'正定县','23',5),(46,'栾城县','24',5),(47,'行唐县','25',5),(48,'灵寿县','26',5),(49,'高邑县','27',5),(50,'深泽县','28',5),(51,'赞皇县','29',5),(52,'无极县','30',5),(53,'平山县','31',5),(54,'元氏县','32',5),(55,'赵县','33',5),(56,'辛集市','81',5),(57,'藁城市','82',5),(58,'晋州市','83',5),(59,'新乐市','84',5),(60,'鹿泉市','85',5),(61,'市辖区','01',6),(62,'路南区','02',6),(63,'路北区','03',6),(64,'古冶区','04',6),(65,'开平区','05',6),(66,'丰南区','07',6),(67,'丰润区','08',6),(68,'滦县','23',6),(69,'滦南县','24',6),(70,'乐亭县','25',6),(71,'迁西县','27',6),(72,'玉田县','29',6),(73,'唐海县','30',6),(74,'遵化市','81',6),(75,'迁安市','83',6),(76,'市辖区','01',7),(77,'海港区','02',7),(78,'山海关区','03',7),(79,'北戴河区','04',7),(80,'青龙满族自治县','21',7),(81,'昌黎县','22',7),(82,'抚宁县','23',7),(83,'卢龙县','24',7),(84,'市辖区','01',8),(85,'邯山区','02',8),(86,'丛台区','03',8),(87,'复兴区','04',8),(88,'峰峰矿区','06',8),(89,'邯郸县','21',8),(90,'临漳县','23',8),(91,'成安县','24',8),(92,'大名县','25',8),(93,'涉县','26',8),(94,'磁县','27',8),(95,'肥乡县','28',8),(96,'永年县','29',8),(97,'邱县','30',8),(98,'鸡泽县','31',8),(99,'广平县','32',8),(100,'馆陶县','33',8),(101,'魏县','34',8),(102,'曲周县','35',8),(103,'武安市','81',8),(104,'市辖区','01',9),(105,'桥东区','02',9),(106,'桥西区','03',9),(107,'邢台县','21',9),(108,'临城县','22',9),(109,'内邱县','23',9),(110,'柏乡县','24',9),(111,'隆尧县','25',9),(112,'任县','26',9),(113,'南和县','27',9),(114,'宁晋县','28',9),(115,'巨鹿县','29',9),(116,'新河县','30',9),(117,'广宗县','31',9),(118,'平乡县','32',9),(119,'威县','33',9),(120,'清河县','34',9),(121,'临西县','35',9),(122,'南宫市','81',9),(123,'沙河市','82',9),(124,'市辖区','01',10),(125,'新市区','02',10),(126,'北市区','03',10),(127,'南市区','04',10),(128,'满城县','21',10),(129,'清苑县','22',10),(130,'涞水县','23',10),(131,'阜平县','24',10),(132,'徐水县','25',10),(133,'定兴县','26',10),(134,'唐县','27',10),(135,'高阳县','28',10),(136,'容城县','29',10),(137,'涞源县','30',10),(138,'望都县','31',10),(139,'安新县','32',10),(140,'易县','33',10),(141,'曲阳县','34',10),(142,'蠡县','35',10),(143,'顺平县','36',10),(144,'博野县','37',10),(145,'雄县','38',10),(146,'涿州市','81',10),(147,'定州市','82',10),(148,'安国市','83',10),(149,'高碑店市','84',10),(150,'市辖区','01',11),(151,'桥东区','02',11),(152,'桥西区','03',11),(153,'宣化区','05',11),(154,'下花园区','06',11),(155,'宣化县','21',11),(156,'张北县','22',11),(157,'康保县','23',11),(158,'沽源县','24',11),(159,'尚义县','25',11),(160,'蔚县','26',11),(161,'阳原县','27',11),(162,'怀安县','28',11),(163,'万全县','29',11),(164,'怀来县','30',11),(165,'涿鹿县','31',11),(166,'赤城县','32',11),(167,'崇礼县','33',11),(168,'市辖区','01',12),(169,'双桥区','02',12),(170,'双滦区','03',12),(171,'鹰手营子矿区','04',12),(172,'承德县','21',12),(173,'兴隆县','22',12),(174,'平泉县','23',12),(175,'滦平县','24',12),(176,'隆化县','25',12),(177,'丰宁满族自治县','26',12),(178,'宽城满族自治县','27',12),(179,'围场满族蒙古族自治县','28',12),(180,'市辖区','01',13),(181,'新华区','02',13),(182,'运河区','03',13),(183,'沧县','21',13),(184,'青县','22',13),(185,'东光县','23',13),(186,'海兴县','24',13),(187,'盐山县','25',13),(188,'肃宁县','26',13),(189,'南皮县','27',13),(190,'吴桥县','28',13),(191,'献县','29',13),(192,'孟村回族自治县','30',13),(193,'泊头市','81',13),(194,'任邱市','82',13),(195,'黄骅市','83',13),(196,'河间市','84',13),(197,'市辖区','01',14),(198,'安次区','02',14),(199,'广阳区','03',14),(200,'固安县','22',14),(201,'永清县','23',14),(202,'香河县','24',14),(203,'大城县','25',14),(204,'文安县','26',14),(205,'大厂回族自治县','28',14),(206,'霸州市','81',14),(207,'三河市','82',14),(208,'市辖区','01',15),(209,'桃城区','02',15),(210,'枣强县','21',15),(211,'武邑县','22',15),(212,'武强县','23',15),(213,'饶阳县','24',15),(214,'安平县','25',15),(215,'故城县','26',15),(216,'景县','27',15),(217,'阜城县','28',15),(218,'冀州市','81',15),(219,'深州市','82',15),(220,'市辖区','01',16),(221,'小店区(人口含高新经济区)','05',16),(222,'迎泽区','06',16),(223,'杏花岭区','07',16),(224,'尖草坪区','08',16),(225,'万柏林区','09',16),(226,'晋源区','10',16),(227,'清徐县','21',16),(228,'阳曲县','22',16),(229,'娄烦县','23',16),(230,'古交市','81',16),(231,'市辖区','01',17),(232,'大同市城区','02',17),(233,'矿区','03',17),(234,'南郊区','11',17),(235,'新荣区','12',17),(236,'阳高县','21',17),(237,'天镇县','22',17),(238,'广灵县','23',17),(239,'灵丘县','24',17),(240,'浑源县','25',17),(241,'左云县','26',17),(242,'大同县','27',17),(243,'市辖区','01',18),(244,'城区','02',18),(245,'矿区','03',18),(246,'郊区','11',18),(247,'平定县','21',18),(248,'盂县','22',18),(249,'市辖区','01',19),(250,'长治市城区','02',19),(251,'长治市郊区','11',19),(252,'长治县','21',19),(253,'襄垣县','23',19),(254,'屯留县','24',19),(255,'平顺县','25',19),(256,'黎城县','26',19),(257,'壶关县','27',19),(258,'长子县','28',19),(259,'武乡县','29',19),(260,'沁县','30',19),(261,'沁源县','31',19),(262,'潞城市','81',19),(263,'市辖区','01',20),(264,'晋城市城区','02',20),(265,'沁水县','21',20),(266,'阳城县','22',20),(267,'陵川县','24',20),(268,'泽州县','25',20),(269,'高平市','81',20),(270,'市辖区','01',21),(271,'朔城区','02',21),(272,'平鲁区','03',21),(273,'山阴县','21',21),(274,'应县','22',21),(275,'右玉县','23',21),(276,'怀仁县','24',21),(277,'市辖区','01',22),(278,'榆次区','02',22),(279,'榆社县','21',22),(280,'左权县','22',22),(281,'和顺县','23',22),(282,'昔阳县','24',22),(283,'寿阳县','25',22),(284,'太谷县','26',22),(285,'祁县','27',22),(286,'平遥县','28',22),(287,'灵石县','29',22),(288,'介休市','81',22),(289,'市辖区','01',23),(290,'盐湖区','02',23),(291,'临猗县','21',23),(292,'万荣县','22',23),(293,'闻喜县','23',23),(294,'稷山县','24',23),(295,'新绛县','25',23),(296,'绛县','26',23),(297,'垣曲县','27',23),(298,'夏县','28',23),(299,'平陆县','29',23),(300,'芮城县','30',23),(301,'永济市','81',23),(302,'河津市','82',23),(303,'市辖区','01',24),(304,'忻府区','02',24),(305,'定襄县','21',24),(306,'五台县','22',24),(307,'代县','23',24),(308,'繁峙县','24',24),(309,'宁武县','25',24),(310,'静乐县','26',24),(311,'神池县','27',24),(312,'五寨县','28',24),(313,'岢岚县','29',24),(314,'河曲县','30',24),(315,'保德县','31',24),(316,'偏关县','32',24),(317,'原平市','81',24),(318,'市辖区','01',25),(319,'尧都区','02',25),(320,'曲沃县','21',25),(321,'翼城县','22',25),(322,'襄汾县','23',25),(323,'洪洞县','24',25),(324,'古县','25',25),(325,'安泽县','26',25),(326,'浮山县','27',25),(327,'吉县','28',25),(328,'乡宁县','29',25),(329,'大宁县','30',25),(330,'隰县','31',25),(331,'永和县','32',25),(332,'蒲县','33',25),(333,'汾西县','34',25),(334,'侯马市','81',25),(335,'霍州市','82',25),(336,'市辖区','01',26),(337,'离石区','02',26),(338,'文水县','21',26),(339,'交城县','22',26),(340,'兴县','23',26),(341,'临县','24',26),(342,'柳林县','25',26),(343,'石楼县','26',26),(344,'岚县','27',26),(345,'方山县','28',26),(346,'中阳县','29',26),(347,'交口县','30',26),(348,'孝义市','81',26),(349,'汾阳市','82',26),(350,'市辖区','01',27),(351,'新城区','02',27),(352,'回民区','03',27),(353,'玉泉区','04',27),(354,'赛罕区','05',27),(355,'土左旗','21',27),(356,'托克托县','22',27),(357,'和林格尔县','23',27),(358,'清水河县','24',27),(359,'武川县','25',27),(360,'市辖区','01',28),(361,'东河区','02',28),(362,'昆都仑区','03',28),(363,'青山区','04',28),(364,'石拐区','05',28),(365,'白云鄂博矿区','06',28),(366,'九原区','07',28),(367,'土默特右旗','21',28),(368,'固阳县','22',28),(369,'达茂联合旗','23',28),(370,'乌海市辖区','01',29),(371,'海勃湾区','02',29),(372,'海南区','03',29),(373,'乌达区','04',29),(374,'市辖区','01',30),(375,'红山区','02',30),(376,'元宝山区','03',30),(377,'松山区','04',30),(378,'阿鲁科尔沁旗','21',30),(379,'巴林左旗','22',30),(380,'巴林右旗','23',30),(381,'林西县','24',30),(382,'克什克腾旗','25',30),(383,'翁牛特旗','26',30),(384,'喀喇沁旗','28',30),(385,'宁城县','29',30),(386,'敖汉旗','30',30),(387,'市辖区','01',31),(388,'科尔沁区','02',31),(389,'科尔沁左翼中旗','21',31),(390,'科左后旗','22',31),(391,'开鲁县','23',31),(392,'库伦旗','24',31),(393,'奈曼旗','25',31),(394,'扎鲁特旗','26',31),(395,'霍林郭勒市','81',31),(396,'东胜区','02',32),(397,'达拉特旗','21',32),(398,'准格尔旗','22',32),(399,'鄂托克前旗','23',32),(400,'鄂托克旗','24',32),(401,'杭锦旗','25',32),(402,'乌审旗','26',32),(403,'伊金霍洛旗','27',32),(404,'市辖区','01',33),(405,'海拉尔区','02',33),(406,'阿荣旗','21',33),(407,'莫力达瓦达斡尔族自治旗','22',33),(408,'鄂伦春自治旗','23',33),(409,'鄂温克族自治旗','24',33),(410,'陈巴尔虎旗镇','25',33),(411,'新巴尔虎左旗','26',33),(412,'新巴尔虎右旗','27',33),(413,'满洲里市','81',33),(414,'牙克石市','82',33),(415,'扎兰屯市','83',33),(416,'额尔古纳市','84',33),(417,'根河市','85',33),(418,'市辖区','01',34),(419,'临河区','02',34),(420,'五原县','21',34),(421,'磴口县','22',34),(422,'乌拉特前旗','23',34),(423,'乌拉特中旗','24',34),(424,'乌拉特后旗','25',34),(425,'杭锦后旗','26',34),(426,'市辖区','01',35),(427,'集宁区','02',35),(428,'卓资县','21',35),(429,'化德县','22',35),(430,'商都县','23',35),(431,'兴和县','24',35),(432,'凉城县','25',35),(433,'察哈尔右翼前旗','26',35),(434,'察右中旗','27',35),(435,'察哈尔右翼后旗','28',35),(436,'四子王旗','29',35),(437,'丰镇市','81',35),(438,'乌兰浩特市','01',36),(439,'阿尔山市','02',36),(440,'科右前旗','21',36),(441,'科右中旗','22',36),(442,'扎赉特旗','23',36),(443,'突泉县','24',36),(444,'二连浩特市','01',37),(445,'锡林浩特市','02',37),(446,'阿巴嘎旗','22',37),(447,'苏尼特左旗','23',37),(448,'苏尼特右旗','24',37),(449,'东乌珠穆沁旗','25',37),(450,'西乌珠穆沁旗','26',37),(451,'太仆寺旗','27',37),(452,'镶黄旗','28',37),(453,'正镶白旗','29',37),(454,'正蓝旗','30',37),(455,'多伦县','31',37),(456,'阿拉善左旗','21',38),(457,'阿拉善右旗','22',38),(458,'额济纳旗','23',38),(459,'市辖区','01',39),(460,'和平区','02',39),(461,'沈河区','03',39),(462,'大东区','04',39),(463,'皇姑区','05',39),(464,'铁西区','06',39),(465,'苏家屯区','11',39),(466,'东陵区','12',39),(467,'新城子区','13',39),(468,'于洪区','14',39),(469,'辽中县','22',39),(470,'康平县','23',39),(471,'法库县','24',39),(472,'新民市','81',39),(473,'市辖区','01',40),(474,'中山区','02',40),(475,'西岗区','03',40),(476,'沙河口区','04',40),(477,'甘井子区','11',40),(478,'旅顺口区','12',40),(479,'金州区','13',40),(480,'长海县','24',40),(481,'瓦房店市','81',40),(482,'普兰店市','82',40),(483,'庄河市','83',40),(484,'市辖区','01',41),(485,'铁东区','02',41),(486,'铁西区','03',41),(487,'立山区','04',41),(488,'千山区','11',41),(489,'台安县','21',41),(490,'岫岩县','23',41),(491,'海城市','81',41),(492,'市辖区','01',42),(493,'新抚区','02',42),(494,'东洲区','03',42),(495,'望花区','04',42),(496,'顺城区','11',42),(497,'抚顺县','21',42),(498,'新宾满族自治县','22',42),(499,'清原满族自治县','23',42),(500,'市辖区','01',43),(501,'平山区','02',43),(502,'溪湖区','03',43),(503,'明山区','04',43),(504,'南芬区','05',43),(505,'本溪满族自治县','21',43),(506,'桓仁满族自治县','22',43),(507,'市辖区','01',44),(508,'元宝区','02',44),(509,'振兴区','03',44),(510,'振安区','04',44),(511,'宽甸满族自治县','24',44),(512,'东港市','81',44),(513,'凤城市','82',44),(514,'市辖区','01',45),(515,'古塔区','02',45),(516,'凌河区','03',45),(517,'太和区','11',45),(518,'黑山县','26',45),(519,'义县','27',45),(520,'凌海市','81',45),(521,'北镇市','82',45),(522,'市辖区','01',46),(523,'站前区','02',46),(524,'西市区','03',46),(525,'鲅鱼圈区','04',46),(526,'老边区','11',46),(527,'盖州市','81',46),(528,'大石桥市','82',46),(529,'市辖区','01',47),(530,'海州区','02',47),(531,'新邱区','03',47),(532,'太平区','04',47),(533,'清河门区','05',47),(534,'细河区','11',47),(535,'阜新蒙古族自治县','21',47),(536,'彰武县','22',47),(537,'市辖区','01',48),(538,'白塔区','02',48),(539,'文圣区','03',48),(540,'宏伟区','04',48),(541,'弓长岭区','05',48),(542,'太子河区','11',48),(543,'辽阳县','21',48),(544,'灯塔市','81',48),(545,'市辖区','01',49),(546,'双台子区','02',49),(547,'兴隆台区','03',49),(548,'大洼县','21',49),(549,'盘山县','22',49),(550,'市辖区','01',50),(551,'银州区','02',50),(552,'清河区','04',50),(553,'铁岭县','21',50),(554,'西丰县','23',50),(555,'昌图县','24',50),(556,'调兵山市','81',50),(557,'开原市','82',50),(558,'市辖区','01',51),(559,'双塔区','02',51),(560,'龙城区','03',51),(561,'朝阳县','21',51),(562,'建平县','22',51),(563,'喀喇沁左翼蒙古族自治县','24',51),(564,'北票市','81',51),(565,'凌源市','82',51),(566,'市辖区','01',52),(567,'连山区','02',52),(568,'龙港区','03',52),(569,'南票区','04',52),(570,'绥中县','21',52),(571,'建昌县','22',52),(572,'兴城市','81',52),(573,'长春市辖区','01',53),(574,'南关区','02',53),(575,'宽城区','03',53),(576,'朝阳区','04',53),(577,'二道区','05',53),(578,'绿园区','06',53),(579,'双阳区','12',53),(580,'农安县','22',53),(581,'九台市','81',53),(582,'榆树市','82',53),(583,'德惠市','83',53),(584,'吉林市辖区','01',54),(585,'昌邑区','02',54),(586,'龙潭区','03',54),(587,'船营区','04',54),(588,'丰满区','11',54),(589,'永吉县','21',54),(590,'蛟河市','81',54),(591,'桦甸市','82',54),(592,'舒兰市','83',54),(593,'磐石市','84',54),(594,'四平市辖区','01',55),(595,'铁西区','02',55),(596,'铁东区','03',55),(597,'梨树县','22',55),(598,'伊通满族自治县','23',55),(599,'公主岭市','81',55),(600,'双辽市','82',55),(601,'辽源市辖区','01',56),(602,'龙山区','02',56),(603,'西安区','03',56),(604,'东丰县','21',56),(605,'东辽县','22',56),(606,'通化市辖区','01',57),(607,'东昌区','02',57),(608,'二道江区','03',57),(609,'通化县','21',57),(610,'辉南县','23',57),(611,'柳河县','24',57),(612,'梅河口市','81',57),(613,'集安市','82',57),(614,'白山市辖区','01',58),(615,'八道江区','02',58),(616,'江源区','04',58),(617,'抚松县','21',58),(618,'靖宇县','22',58),(619,'长白朝鲜族自治县','23',58),(620,'临江市','81',58),(621,'松原市辖区','01',59),(622,'宁江区','02',59),(623,'前郭尔罗斯蒙古族自治县','21',59),(624,'长岭县','22',59),(625,'乾安县','23',59),(626,'扶余县','24',59),(627,'白城市辖区','01',60),(628,'洮北区','02',60),(629,'镇赉县','21',60),(630,'通榆县','22',60),(631,'洮南市','81',60),(632,'大安市','82',60),(633,'延吉市','01',61),(634,'图们市','02',61),(635,'敦化市','03',61),(636,'珲春市','04',61),(637,'龙井市','05',61),(638,'和龙市','06',61),(639,'汪清县','24',61),(640,'安图县','26',61),(641,'市辖区','01',62),(642,'道里区','02',62),(643,'南岗区','03',62),(644,'道外区','04',62),(645,'平房区','08',62),(646,'松北区','09',62),(647,'香坊区','10',62),(648,'呼兰区','11',62),(649,'阿城区','12',62),(650,'依兰县','23',62),(651,'方正县','24',62),(652,'宾县','25',62),(653,'巴彦县','26',62),(654,'木兰县','27',62),(655,'通河县','28',62),(656,'延寿县','29',62),(657,'双城市','82',62),(658,'尚志市','83',62),(659,'五常市','84',62),(660,'市辖区','01',63),(661,'龙沙区','02',63),(662,'建华区','03',63),(663,'铁锋区','04',63),(664,'昂昂溪区','05',63),(665,'富拉尔基区','06',63),(666,'碾子山区','07',63),(667,'梅里斯达斡尔族区','08',63),(668,'龙江县','21',63),(669,'依安县','23',63),(670,'泰来县','24',63),(671,'甘南县','25',63),(672,'富裕县','27',63),(673,'克山县','29',63),(674,'克东县','30',63),(675,'拜泉县','31',63),(676,'讷河市','81',63),(677,'市辖区','01',64),(678,'鸡冠区','02',64),(679,'恒山区','03',64),(680,'滴道区','04',64),(681,'梨树区','05',64),(682,'城子河区','06',64),(683,'麻山区','07',64),(684,'鸡东县','21',64),(685,'虎林市','81',64),(686,'密山市','82',64),(687,'市辖区','01',65),(688,'向阳区','02',65),(689,'工农区','03',65),(690,'南山区','04',65),(691,'兴安区','05',65),(692,'东山区','06',65),(693,'兴山区','07',65),(694,'萝北县','21',65),(695,'绥滨县','22',65),(696,'市辖区','01',66),(697,'尖山区','02',66),(698,'岭东区','03',66),(699,'四方台区','05',66),(700,'宝山区','06',66),(701,'集贤县','21',66),(702,'友谊县','22',66),(703,'宝清县','23',66),(704,'饶河县','24',66),(705,'市辖区','01',67),(706,'萨尔图区','02',67),(707,'龙凤区','03',67),(708,'让胡路区','04',67),(709,'红岗区','05',67),(710,'大同区','06',67),(711,'肇州县','21',67),(712,'肇源县','22',67),(713,'林甸县','23',67),(714,'杜尔伯特县','24',67),(715,'市辖区','01',68),(716,'伊春区','02',68),(717,'南岔区','03',68),(718,'友好区','04',68),(719,'西林区','05',68),(720,'翠峦区','06',68),(721,'新青区','07',68),(722,'美溪区','08',68),(723,'金山屯区','09',68),(724,'五营区','10',68),(725,'乌马河区','11',68),(726,'汤旺河区','12',68),(727,'带岭区','13',68),(728,'乌伊岭区','14',68),(729,'红星区','15',68),(730,'上甘岭区','16',68),(731,'嘉荫县','22',68),(732,'铁力市','81',68),(733,'市辖区','01',69),(734,'向阳区','03',69),(735,'前进区','04',69),(736,'东风区','05',69),(737,'郊区','11',69),(738,'桦南县','22',69),(739,'桦川县','26',69),(740,'汤原县','28',69),(741,'抚远县','33',69),(742,'同江市','81',69),(743,'富锦市','82',69),(744,'市辖区','01',70),(745,'新兴区','02',70),(746,'桃山区','03',70),(747,'茄子河区','04',70),(748,'勃利县','21',70),(749,'市辖区','01',71),(750,'东安区','02',71),(751,'阳明区','03',71),(752,'爱民区','04',71),(753,'西安区','05',71),(754,'东宁县','24',71),(755,'林口县','25',71),(756,'绥芬河市','81',71),(757,'海林市','83',71),(758,'宁安市','84',71),(759,'穆棱市','85',71),(760,'市辖区','01',72),(761,'爱辉区','02',72),(762,'嫩江县','21',72),(763,'逊克县','23',72),(764,'孙吴县','24',72),(765,'北安市','81',72),(766,'五大连池市','82',72),(767,'市辖区','01',73),(768,'北林区','02',73),(769,'望奎县','21',73),(770,'兰西县','22',73),(771,'青冈县','23',73),(772,'庆安县','24',73),(773,'明水县','25',73),(774,'绥棱县','26',73),(775,'安达市','81',73),(776,'肇东市','82',73),(777,'海伦市','83',73),(778,'加格达奇区','01',74),(779,'松岭区','02',74),(780,'新林区','03',74),(781,'呼中区','04',74),(782,'呼玛县','21',74),(783,'塔河县','22',74),(784,'漠河县','23',74),(785,'黄浦区','01',75),(786,'卢湾区','03',75),(787,'徐汇区','04',75),(788,'长宁区','05',75),(789,'静安区','06',75),(790,'普陀区','07',75),(791,'闸北区','08',75),(792,'虹口区','09',75),(793,'杨浦区','10',75),(794,'闵行区','12',75),(795,'宝山区','13',75),(796,'嘉定区','14',75),(797,'浦东新区','15',75),(798,'金山区','16',75),(799,'松江区','17',75),(800,'青浦区','18',75),(801,'南汇区','19',75),(802,'奉贤区','20',75),(803,'崇明县','30',76),(804,'市辖区','01',77),(805,'玄武区','02',77),(806,'白下区','03',77),(807,'秦淮区','04',77),(808,'建邺区','05',77),(809,'鼓楼区','06',77),(810,'下关区','07',77),(811,'浦口区','11',77),(812,'栖霞区','13',77),(813,'雨花台区','14',77),(814,'江宁区','15',77),(815,'六合区','16',77),(816,'溧水县','24',77),(817,'高淳县','25',77),(818,'市辖区','01',78),(819,'崇安区','02',78),(820,'南长区','03',78),(821,'北塘区','04',78),(822,'锡山区','05',78),(823,'惠山区','06',78),(824,'滨湖区','11',78),(825,'江阴市','81',78),(826,'宜兴市','82',78),(827,'市辖区','01',79),(828,'鼓楼区','02',79),(829,'云龙区','03',79),(830,'九里区','04',79),(831,'贾汪区','05',79),(832,'泉山区','11',79),(833,'丰县','21',79),(834,'沛县','22',79),(835,'铜山县','23',79),(836,'睢宁县','24',79),(837,'新沂市','81',79),(838,'邳州市','82',79),(839,'常州市区','01',80),(840,'天宁区','02',80),(841,'钟楼区','04',80),(842,'戚墅堰区','05',80),(843,'新北区','11',80),(844,'武进区','12',80),(845,'溧阳市','81',80),(846,'金坛市','82',80),(847,'市辖区','01',81),(848,'沧浪区','02',81),(849,'平江区','03',81),(850,'金阊区','04',81),(851,'苏州高新区虎丘区','05',81),(852,'吴中区','06',81),(853,'相城区','07',81),(854,'常熟市','81',81),(855,'张家港市','82',81),(856,'昆山市','83',81),(857,'吴江市','84',81),(858,'太仓市','85',81),(859,'市辖区','01',82),(860,'崇川区','02',82),(861,'港闸区','11',82),(862,'海安县','21',82),(863,'如东','23',82),(864,'启东市','81',82),(865,'如皋市','82',82),(866,'通州市','83',82),(867,'海门市','84',82),(868,'市辖区','01',83),(869,'连云区','03',83),(870,'新浦区','05',83),(871,'海州区','06',83),(872,'赣榆县','21',83),(873,'东海县','22',83),(874,'灌云县','23',83),(875,'灌南县','24',83),(876,'市辖区','01',84),(877,'清河区','02',84),(878,'楚州区','03',84),(879,'淮阴区','04',84),(880,'清浦区','11',84),(881,'涟水县','26',84),(882,'洪泽县','29',84),(883,'盱眙县','30',84),(884,'金湖县','31',84),(885,'市辖区','01',85),(886,'亭湖区','02',85),(887,'盐都区','03',85),(888,'响水县','21',85),(889,'滨海县','22',85),(890,'阜宁县','23',85),(891,'射阳县','24',85),(892,'建湖县','25',85),(893,'东台市','81',85),(894,'大丰市','82',85),(895,'市辖区','01',86),(896,'广陵区','02',86),(897,'邗江区','03',86),(898,'维扬区','11',86),(899,'宝应县','23',86),(900,'仪征市','81',86),(901,'高邮市','84',86),(902,'江都市','88',86),(903,'市区','01',87),(904,'京口区','02',87),(905,'润州区','11',87),(906,'丹徒区','12',87),(907,'丹阳市','81',87),(908,'扬中市','82',87),(909,'句容市','83',87),(910,'市辖区','01',88),(911,'海陵区','02',88),(912,'高港区','03',88),(913,'兴化市','81',88),(914,'靖江市','82',88),(915,'泰兴市','83',88),(916,'姜堰市','84',88),(917,'市辖区','01',89),(918,'宿城区','02',89),(919,'宿豫区','11',89),(920,'沭阳县','22',89),(921,'泗阳县','23',89),(922,'泗洪县','24',89),(923,'市辖区','01',90),(924,'上城区','02',90),(925,'下城区','03',90),(926,'江干区','04',90),(927,'拱墅区','05',90),(928,'西湖区','06',90),(929,'滨江区','08',90),(930,'萧山区','09',90),(931,'余杭区','10',90),(932,'桐庐县','22',90),(933,'淳安县','27',90),(934,'建德市','82',90),(935,'富阳市','83',90),(936,'临安市','85',90),(937,'市辖区','01',91),(938,'海曙区','03',91),(939,'江东区','04',91),(940,'江北区','05',91),(941,'北仑区','06',91),(942,'镇海区','11',91),(943,'鄞州区','12',91),(944,'象山县','25',91),(945,'宁海县','26',91),(946,'余姚市','81',91),(947,'慈溪市','82',91),(948,'奉化市','83',91),(949,'市辖区','01',92),(950,'鹿城区','02',92),(951,'龙湾区','03',92),(952,'瓯海区','04',92),(953,'洞头县','22',92),(954,'永嘉县','24',92),(955,'平阳县','26',92),(956,'苍南县','27',92),(957,'文成县','28',92),(958,'泰顺县','29',92),(959,'瑞安市','81',92),(960,'乐清市','82',92),(961,'市辖区','01',93),(962,'南湖区','02',93),(963,'秀洲区','11',93),(964,'嘉善县','21',93),(965,'海盐县','24',93),(966,'海宁市','81',93),(967,'平湖市','82',93),(968,'桐乡市','83',93),(969,'市辖区','01',94),(970,'吴兴区','02',94),(971,'南浔区','03',94),(972,'德清县','21',94),(973,'长兴县','22',94),(974,'安吉县','23',94),(975,'市辖区','01',95),(976,'越城区','02',95),(977,'绍兴县','21',95),(978,'新昌县','24',95),(979,'诸暨市','81',95),(980,'上虞市','82',95),(981,'嵊州市','83',95),(982,'市辖区','01',96),(983,'婺城区','02',96),(984,'金东区','03',96),(985,'武义县','23',96),(986,'浦江县','26',96),(987,'磐安县','27',96),(988,'兰溪市','81',96),(989,'义乌市','82',96),(990,'东阳市','83',96),(991,'永康市','84',96),(992,'市辖区','01',97),(993,'柯城区','02',97),(994,'衢江区','03',97),(995,'常山县','22',97),(996,'开化县','24',97),(997,'龙游县','25',97),(998,'江山市','81',97),(999,'市辖区','01',98),(1000,'定海区','02',98),(1001,'普陀区','03',98),(1002,'岱山县','21',98),(1003,'嵊泗县','22',98),(1004,'市辖区','01',99),(1005,'椒江区','02',99),(1006,'黄岩区','03',99),(1007,'路桥区','04',99),(1008,'玉环县','21',99),(1009,'三门县','22',99),(1010,'天台县','23',99),(1011,'仙居县','24',99),(1012,'温岭市','81',99),(1013,'临海市','82',99),(1014,'市辖区','01',100),(1015,'莲都区','02',100),(1016,'青田县','21',100),(1017,'缙云县','22',100),(1018,'遂昌县','23',100),(1019,'松阳县','24',100),(1020,'云和县','25',100),(1021,'庆元县','26',100),(1022,'景宁畲族自治县','27',100),(1023,'龙泉市','81',100),(1024,'市辖区','01',101),(1025,'瑶海区','02',101),(1026,'庐阳区','03',101),(1027,'蜀山区','04',101),(1028,'包河区','11',101),(1029,'长丰县','21',101),(1030,'肥东县','22',101),(1031,'肥西县','23',101),(1032,'市辖区','01',102),(1033,'镜湖区','02',102),(1034,'弋江区','03',102),(1035,'鸠江区','07',102),(1036,'三山区','08',102),(1037,'芜湖县','21',102),(1038,'繁昌县','22',102),(1039,'南陵县','23',102),(1040,'市辖区','01',103),(1041,'龙子湖区','02',103),(1042,'蚌山区','03',103),(1043,'禹会区','04',103),(1044,'淮上区','11',103),(1045,'怀远县','21',103),(1046,'五河县','22',103),(1047,'固镇县','23',103),(1048,'市辖区','01',104),(1049,'大通区','02',104),(1050,'田家庵区','03',104),(1051,'谢家集区','04',104),(1052,'八公山区','05',104),(1053,'潘集区','06',104),(1054,'凤台县','21',104),(1055,'市辖区','01',105),(1056,'金家庄区','02',105),(1057,'花山区','03',105),(1058,'雨山区','04',105),(1059,'当涂县','21',105),(1060,'市辖区','01',106),(1061,'杜集区','02',106),(1062,'相山区','03',106),(1063,'烈山区','04',106),(1064,'濉溪县','21',106),(1065,'市辖区','01',107),(1066,'铜官山区','02',107),(1067,'狮子山区','03',107),(1068,'铜陵市郊区','11',107),(1069,'铜陵县','21',107),(1070,'市辖区','01',108),(1071,'迎江区','02',108),(1072,'大观区','03',108),(1073,'宜秀区','11',108),(1074,'怀宁县','22',108),(1075,'枞阳县','23',108),(1076,'潜山县','24',108),(1077,'太湖县','25',108),(1078,'宿松县','26',108),(1079,'望江县','27',108),(1080,'岳西县','28',108),(1081,'桐城市','81',108),(1082,'市辖区','01',109),(1083,'屯溪区','02',109),(1084,'黄山区','03',109),(1085,'徽州区','04',109),(1086,'歙县','21',109),(1087,'休宁县','22',109),(1088,'黟县','23',109),(1089,'祁门县','24',109),(1090,'市辖区','01',110),(1091,'琅琊区','02',110),(1092,'南谯区','03',110),(1093,'来安县','22',110),(1094,'全椒县','24',110),(1095,'定远县','25',110),(1096,'凤阳县','26',110),(1097,'天长市','81',110),(1098,'明光市','82',110),(1099,'市辖区','01',111),(1100,'颍州区','02',111),(1101,'颍东区','03',111),(1102,'颍泉区','04',111),(1103,'临泉县','21',111),(1104,'太和县','22',111),(1105,'阜南县','25',111),(1106,'颍上县','26',111),(1107,'界首市','82',111),(1108,'市辖区','01',112),(1109,'墉桥区','02',112),(1110,'砀山县','21',112),(1111,'萧县','22',112),(1112,'灵璧县','23',112),(1113,'泗县','24',112),(1114,'市辖区','01',113),(1115,'居巢区','02',113),(1116,'庐江县','21',113),(1117,'无为县','22',113),(1118,'含山县','23',113),(1119,'和县','24',113),(1120,'市辖区','01',114),(1121,'金安区','02',114),(1122,'裕安区','03',114),(1123,'寿县','21',114),(1124,'霍邱县','22',114),(1125,'舒城县','23',114),(1126,'金寨县','24',114),(1127,'霍山县','25',114),(1128,'市辖区','01',115),(1129,'谯城区','02',115),(1130,'涡阳县','21',115),(1131,'蒙城县','22',115),(1132,'利辛县','23',115),(1133,'市辖区','01',116),(1134,'贵池区','02',116),(1135,'东至县','21',116),(1136,'石台县','22',116),(1137,'青阳县','23',116),(1138,'市辖区','01',117),(1139,'宣州区','02',117),(1140,'郎溪县','21',117),(1141,'广德县','22',117),(1142,'泾县','23',117),(1143,'绩溪县','24',117),(1144,'旌德县','25',117),(1145,'宁国市','81',117),(1146,'市辖区','01',118),(1147,'鼓楼区','02',118),(1148,'台江区','03',118),(1149,'仓山区','04',118),(1150,'马尾区','05',118),(1151,'晋安区','11',118),(1152,'闽侯县','21',118),(1153,'连江县','22',118),(1154,'罗源县','23',118),(1155,'闽清县','24',118),(1156,'永泰县','25',118),(1157,'平潭县','28',118),(1158,'福清市','81',118),(1159,'长乐市','82',118),(1160,'市辖区','01',119),(1161,'思明区','03',119),(1162,'海沧区','05',119),(1163,'湖里区','06',119),(1164,'集美区','11',119),(1165,'同安区','12',119),(1166,'翔安区','13',119),(1167,'市辖区','01',120),(1168,'城厢区','02',120),(1169,'涵江区','03',120),(1170,'荔城区','04',120),(1171,'秀屿区','05',120),(1172,'仙游县','22',120),(1173,'市辖区','01',121),(1174,'梅列区','02',121),(1175,'三元区','03',121),(1176,'明溪县','21',121),(1177,'清流县','23',121),(1178,'宁化县','24',121),(1179,'大田县','25',121),(1180,'尤溪县','26',121),(1181,'沙县','27',121),(1182,'将乐县','28',121),(1183,'泰宁县','29',121),(1184,'建宁县','30',121),(1185,'永安市','81',121),(1186,'市辖区','01',122),(1187,'鲤城区','02',122),(1188,'丰泽区','03',122),(1189,'洛江区','04',122),(1190,'泉港区','05',122),(1191,'惠安县','21',122),(1192,'安溪县','24',122),(1193,'永春县','25',122),(1194,'德化县','26',122),(1195,'金门县','27',122),(1196,'石狮市','81',122),(1197,'晋江市','82',122),(1198,'南安市','83',122),(1199,'市辖区','01',123),(1200,'芗城区','02',123),(1201,'龙文区','03',123),(1202,'云霄县','22',123),(1203,'漳浦县','23',123),(1204,'诏安县','24',123),(1205,'长泰县','25',123),(1206,'东山县','26',123),(1207,'南靖县','27',123),(1208,'平和县','28',123),(1209,'华安县','29',123),(1210,'龙海市','81',123),(1211,'市辖区','01',124),(1212,'延平区','02',124),(1213,'顺昌县','21',124),(1214,'浦城县','22',124),(1215,'光泽县','23',124),(1216,'松溪县','24',124),(1217,'政和县','25',124),(1218,'邵武市','81',124),(1219,'武夷山市','82',124),(1220,'建瓯市','83',124),(1221,'建阳市','84',124),(1222,'市辖区','01',125),(1223,'新罗区','02',125),(1224,'长汀县','21',125),(1225,'永定县','22',125),(1226,'上杭县','23',125),(1227,'武平县','24',125),(1228,'连城县','25',125),(1229,'漳平市','81',125),(1230,'市辖区','01',126),(1231,'蕉城区','02',126),(1232,'霞浦县','21',126),(1233,'古田县','22',126),(1234,'屏南县','23',126),(1235,'寿宁县','24',126),(1236,'周宁县','25',126),(1237,'柘荣县','26',126),(1238,'福安市','81',126),(1239,'福鼎市','82',126),(1240,'市辖区','01',127),(1241,'东湖区','02',127),(1242,'西湖区','03',127),(1243,'青云谱区','04',127),(1244,'湾里区','05',127),(1245,'青山湖区','11',127),(1246,'南昌县','21',127),(1247,'新建县','22',127),(1248,'安义县','23',127),(1249,'进贤县','24',127),(1250,'市辖区','01',128),(1251,'昌江区','02',128),(1252,'珠山区','03',128),(1253,'浮梁县','22',128),(1254,'乐平市','81',128),(1255,'市辖区','01',129),(1256,'安源区','02',129),(1257,'湘东区','13',129),(1258,'莲花县','21',129),(1259,'上栗县','22',129),(1260,'芦溪县','23',129),(1261,'市辖区','01',130),(1262,'庐山区','02',130),(1263,'浔阳区','03',130),(1264,'九江县','21',130),(1265,'武宁县','23',130),(1266,'修水县','24',130),(1267,'永修县','25',130),(1268,'德安县','26',130),(1269,'星子县','27',130),(1270,'都昌县','28',130),(1271,'湖口县','29',130),(1272,'彭泽县','30',130),(1273,'瑞昌市','81',130),(1274,'市辖区','01',131),(1275,'渝水区','02',131),(1276,'分宜县','21',131),(1277,'市辖区','01',132),(1278,'月湖区','02',132),(1279,'余江县','22',132),(1280,'贵溪市','81',132),(1281,'市辖区','01',133),(1282,'章贡区','02',133),(1283,'赣县','21',133),(1284,'信丰县','22',133),(1285,'大余县','23',133),(1286,'上犹县','24',133),(1287,'崇义县','25',133),(1288,'安远县','26',133),(1289,'龙南县','27',133),(1290,'定南县','28',133),(1291,'全南县','29',133),(1292,'宁都县','30',133),(1293,'于都县','31',133),(1294,'兴国县','32',133),(1295,'会昌县','33',133),(1296,'寻乌县','34',133),(1297,'石城县','35',133),(1298,'瑞金市','81',133),(1299,'南康市','82',133),(1300,'市辖区','01',134),(1301,'吉州区','02',134),(1302,'青原区','03',134),(1303,'吉安县','21',134),(1304,'吉水县','22',134),(1305,'峡江县','23',134),(1306,'新干县','24',134),(1307,'永丰县','25',134),(1308,'泰和县','26',134),(1309,'遂川县','27',134),(1310,'万安县','28',134),(1311,'安福县','29',134),(1312,'永新县','30',134),(1313,'井冈山市','81',134),(1314,'市辖区','01',135),(1315,'袁州区','02',135),(1316,'奉新县','21',135),(1317,'万载县','22',135),(1318,'上高县','23',135),(1319,'宜丰县','24',135),(1320,'靖安县','25',135),(1321,'铜鼓县','26',135),(1322,'丰城市','81',135),(1323,'樟树市','82',135),(1324,'高安市','83',135),(1325,'市辖区','01',136),(1326,'临川区','02',136),(1327,'南城县','21',136),(1328,'黎川县','22',136),(1329,'南丰县','23',136),(1330,'崇仁县','24',136),(1331,'乐安县','25',136),(1332,'宜黄县','26',136),(1333,'金溪县','27',136),(1334,'资溪县','28',136),(1335,'东乡县','29',136),(1336,'广昌县','30',136),(1337,'市辖区','01',137),(1338,'信州区','02',137),(1339,'上饶县','21',137),(1340,'广丰县','22',137),(1341,'玉山县','23',137),(1342,'铅山县','24',137),(1343,'横峰县','25',137),(1344,'弋阳县','26',137),(1345,'余干县','27',137),(1346,'鄱阳县','28',137),(1347,'万年县','29',137),(1348,'婺源县','30',137),(1349,'德兴市','81',137),(1350,'市辖区','01',138),(1351,'历下区','02',138),(1352,'市中区','03',138),(1353,'槐荫区','04',138),(1354,'天桥区','05',138),(1355,'历城区','12',138),(1356,'长清区','13',138),(1357,'平阴县','24',138),(1358,'济阳县','25',138),(1359,'商河县','26',138),(1360,'章丘市','81',138),(1361,'市辖区','01',139),(1362,'市南区','02',139),(1363,'市北区','03',139),(1364,'四方区','05',139),(1365,'黄岛区','11',139),(1366,'崂山区','12',139),(1367,'李沧区','13',139),(1368,'城阳区','14',139),(1369,'胶州市','81',139),(1370,'即墨市','82',139),(1371,'平度市','83',139),(1372,'胶南市','84',139),(1373,'莱西市','85',139),(1374,'市辖区','01',140),(1375,'淄川区','02',140),(1376,'张店区','03',140),(1377,'博山区','04',140),(1378,'临淄区','05',140),(1379,'周村区','06',140),(1380,'桓台县','21',140),(1381,'高青县','22',140),(1382,'沂源县','23',140),(1383,'市辖区','01',141),(1384,'市中区','02',141),(1385,'薛城区','03',141),(1386,'峄城区','04',141),(1387,'台儿庄区','05',141),(1388,'山亭区','06',141),(1389,'滕州市','81',141),(1390,'市辖区','01',142),(1391,'东营区','02',142),(1392,'河口区','03',142),(1393,'垦利县','21',142),(1394,'利津县','22',142),(1395,'广饶县','23',142),(1396,'市辖区','01',143),(1397,'芝罘区','02',143),(1398,'福山区','11',143),(1399,'牟平区','12',143),(1400,'莱山区','13',143),(1401,'长岛县','34',143),(1402,'龙口市','81',143),(1403,'莱阳市','82',143),(1404,'莱州市','83',143),(1405,'蓬莱市','84',143),(1406,'招远市','85',143),(1407,'栖霞市','86',143),(1408,'海阳市','87',143),(1409,'市辖区','01',144),(1410,'潍城区','02',144),(1411,'寒亭区','03',144),(1412,'坊子区','04',144),(1413,'奎文区','05',144),(1414,'临朐县','24',144),(1415,'昌乐县','25',144),(1416,'青州市','81',144),(1417,'诸城市','82',144),(1418,'寿光市','83',144),(1419,'安丘市','84',144),(1420,'高密市','85',144),(1421,'昌邑市','86',144),(1422,'市辖区','01',145),(1423,'市中区','02',145),(1424,'任城区','11',145),(1425,'微山县','26',145),(1426,'鱼台县','27',145),(1427,'金乡县','28',145),(1428,'嘉祥县','29',145),(1429,'汶上县','30',145),(1430,'泗水县','31',145),(1431,'梁山县','32',145),(1432,'曲阜市','81',145),(1433,'兖州市','82',145),(1434,'邹城市','83',145),(1435,'市辖区','01',146),(1436,'泰山区','02',146),(1437,'岱岳区','03',146),(1438,'宁阳县','21',146),(1439,'东平县','23',146),(1440,'新泰市','82',146),(1441,'肥城市','83',146),(1442,'市辖区','01',147),(1443,'环翠区','02',147),(1444,'文登市','81',147),(1445,'荣成市','82',147),(1446,'乳山市','83',147),(1447,'市辖区','01',148),(1448,'东港区','02',148),(1449,'岚山区','03',148),(1450,'五莲县','21',148),(1451,'莒县','22',148),(1452,'市辖区','01',149),(1453,'莱城区','02',149),(1454,'钢城区','03',149),(1455,'临沂市辖区','01',150),(1456,'兰山区','02',150),(1457,'罗庄区','11',150),(1458,'河东区','12',150),(1459,'沂南县','21',150),(1460,'郯城县','22',150),(1461,'沂水县','23',150),(1462,'苍山县','24',150),(1463,'费县','25',150),(1464,'平邑县','26',150),(1465,'莒南县','27',150),(1466,'蒙阴县','28',150),(1467,'临沭县','29',150),(1468,'市辖区','01',151),(1469,'德城区','02',151),(1470,'陵县','21',151),(1471,'宁津县','22',151),(1472,'庆云县','23',151),(1473,'临邑县','24',151),(1474,'齐河县','25',151),(1475,'平原县','26',151),(1476,'夏津县','27',151),(1477,'武城县','28',151),(1478,'乐陵市','81',151),(1479,'禹城市','82',151),(1480,'市辖区','01',152),(1481,'东昌府区','02',152),(1482,'阳谷县','21',152),(1483,'莘县','22',152),(1484,'茌平县','23',152),(1485,'东阿县','24',152),(1486,'冠县','25',152),(1487,'高唐县','26',152),(1488,'临清市','81',152),(1489,'市辖区','01',153),(1490,'滨城区','02',153),(1491,'惠民县','21',153),(1492,'阳信县','22',153),(1493,'无棣县','23',153),(1494,'沾化县','24',153),(1495,'博兴县','25',153),(1496,'邹平县','26',153),(1497,'市辖区','01',154),(1498,'牡丹区','02',154),(1499,'曹县','21',154),(1500,'单县','22',154),(1501,'成武县','23',154),(1502,'巨野县','24',154),(1503,'郓城县','25',154),(1504,'鄄城县','26',154),(1505,'定陶县','27',154),(1506,'东明县','28',154),(1507,'市辖区','01',155),(1508,'中原区','02',155),(1509,'二七区','03',155),(1510,'管城回族区','04',155),(1511,'金水区','05',155),(1512,'上街区','06',155),(1513,'惠济区','08',155),(1514,'中牟县','22',155),(1515,'巩义市','81',155),(1516,'荥阳市','82',155),(1517,'新密市','83',155),(1518,'新郑市','84',155),(1519,'登封市','85',155),(1520,'市辖区','01',156),(1521,'龙亭区','02',156),(1522,'顺河区','03',156),(1523,'鼓楼区','04',156),(1524,'禹王台区','05',156),(1525,'金明区','11',156),(1526,'杞县','21',156),(1527,'通许县','22',156),(1528,'尉氏县','23',156),(1529,'开封县','24',156),(1530,'兰考县','25',156),(1531,'市辖区','01',157),(1532,'老城区','02',157),(1533,'西工区','03',157),(1534,'廛河回族区','04',157),(1535,'涧西区','05',157),(1536,'吉利区','06',157),(1537,'洛龙区','07',157),(1538,'孟津县','22',157),(1539,'新安县','23',157),(1540,'栾川县','24',157),(1541,'嵩县','25',157),(1542,'汝阳县','26',157),(1543,'宜阳县','27',157),(1544,'洛宁县','28',157),(1545,'伊川县','29',157),(1546,'偃师市','81',157),(1547,'市辖区','01',158),(1548,'新华区','02',158),(1549,'卫东区','03',158),(1550,'石龙区','04',158),(1551,'湛河区','11',158),(1552,'宝丰县','21',158),(1553,'叶','22',158),(1554,'鲁山县','23',158),(1555,'郏','25',158),(1556,'舞钢市','81',158),(1557,'汝州市','82',158),(1558,'市辖区','01',159),(1559,'文峰区','02',159),(1560,'北关区','03',159),(1561,'殷都区','05',159),(1562,'龙安区','06',159),(1563,'安阳县','22',159),(1564,'汤阴县','23',159),(1565,'滑县','26',159),(1566,'内黄县','27',159),(1567,'林州市','81',159),(1568,'市辖区','01',160),(1569,'鹤山区','02',160),(1570,'山城区','03',160),(1571,'淇滨区','11',160),(1572,'浚县','21',160),(1573,'淇县','22',160),(1574,'市辖区','01',161),(1575,'红旗区','02',161),(1576,'卫滨区','03',161),(1577,'凤泉区','04',161),(1578,'牧野区','11',161),(1579,'新乡县','21',161),(1580,'获嘉县','24',161),(1581,'原阳县','25',161),(1582,'延津县','26',161),(1583,'封丘县','27',161),(1584,'长垣县','28',161),(1585,'卫辉市','81',161),(1586,'辉县市','82',161),(1587,'市辖区','01',162),(1588,'解放区','02',162),(1589,'中站区','03',162),(1590,'马村区','04',162),(1591,'山阳区','11',162),(1592,'修武县','21',162),(1593,'博爱县','22',162),(1594,'武陟县','23',162),(1595,'温县','25',162),(1596,'济源市','81',162),(1597,'沁阳市','82',162),(1598,'孟州市','83',162),(1599,'市辖区','01',163),(1600,'华龙区','02',163),(1601,'清丰县','22',163),(1602,'南乐县','23',163),(1603,'范县','26',163),(1604,'台前县','27',163),(1605,'濮阳县','28',163),(1606,'市辖区','01',164),(1607,'魏都区','02',164),(1608,'许昌县','23',164),(1609,'鄢陵县','24',164),(1610,'襄城县','25',164),(1611,'禹州市','81',164),(1612,'长葛市','82',164),(1613,'市辖区','01',165),(1614,'源汇区','02',165),(1615,'郾城区','03',165),(1616,'召陵区','04',165),(1617,'舞阳县','21',165),(1618,'临颖县','22',165),(1619,'市辖区','01',166),(1620,'湖滨区','02',166),(1621,'渑池县','21',166),(1622,'陕县','22',166),(1623,'卢氏县','24',166),(1624,'义马市','81',166),(1625,'灵宝市','82',166),(1626,'市辖区','01',167),(1627,'宛城区','02',167),(1628,'卧龙区','03',167),(1629,'南召县','21',167),(1630,'方城县','22',167),(1631,'西峡县','23',167),(1632,'镇平县','24',167),(1633,'内乡县','25',167),(1634,'淅川县','26',167),(1635,'社旗县','27',167),(1636,'唐河县','28',167),(1637,'新野县','29',167),(1638,'桐柏县','30',167),(1639,'邓州市','81',167),(1640,'市辖区','01',168),(1641,'梁园区','02',168),(1642,'睢阳区','03',168),(1643,'民权县','21',168),(1644,'睢县','22',168),(1645,'宁陵县','23',168),(1646,'柘城县','24',168),(1647,'虞城县','25',168),(1648,'夏邑县','26',168),(1649,'永城市','81',168),(1650,'市辖区','01',169),(1651,'平桥区','03',169),(1652,'罗山县','21',169),(1653,'光山县','22',169),(1654,'新县','23',169),(1655,'商城县','24',169),(1656,'固始县','25',169),(1657,'潢川县','26',169),(1658,'淮滨县','27',169),(1659,'息县','28',169),(1660,'市辖区','01',170),(1661,'川汇区','02',170),(1662,'扶沟县','21',170),(1663,'西华县','22',170),(1664,'商水县','23',170),(1665,'沈丘县','24',170),(1666,'郸城县','25',170),(1667,'淮阳县','26',170),(1668,'太康县','27',170),(1669,'鹿邑县','28',170),(1670,'项城市','81',170),(1671,'市辖区','01',171),(1672,'驿城区','02',171),(1673,'西平县','21',171),(1674,'上蔡县','22',171),(1675,'平舆县','23',171),(1676,'正阳县','24',171),(1677,'确山县','25',171),(1678,'泌阳县','26',171),(1679,'汝南县','27',171),(1680,'遂平县','28',171),(1681,'新蔡县','29',171),(1682,'市辖区','01',172),(1683,'江岸区','02',172),(1684,'江汉区','03',172),(1685,'汉阳区','05',172),(1686,'武昌区','06',172),(1687,'青山区','07',172),(1688,'洪山区','11',172),(1689,'东西湖区','12',172),(1690,'汉南区','13',172),(1691,'蔡甸区','14',172),(1692,'江夏区','15',172),(1693,'黄陂区','16',172),(1694,'武汉市新洲区','17',172),(1695,'市辖区','01',173),(1696,'黄石港区','02',173),(1697,'西塞山区','03',173),(1698,'下陆区','04',173),(1699,'铁山区','05',173),(1700,'阳新县','22',173),(1701,'大冶市','81',173),(1702,'市辖区','01',174),(1703,'茅箭区','02',174),(1704,'张湾区','03',174),(1705,'郧县','21',174),(1706,'郧西县','22',174),(1707,'竹山县','23',174),(1708,'竹溪县','24',174),(1709,'房县','25',174),(1710,'丹江口市','81',174),(1711,'市辖区','01',175),(1712,'西陵区','02',175),(1713,'伍家岗区','03',175),(1714,'点军区','04',175),(1715,'夷陵区','06',175),(1716,'远安县','25',175),(1717,'兴山县','26',175),(1718,'秭归县','27',175),(1719,'长阳土家族自治县','28',175),(1720,'五峰土家族自治县','29',175),(1721,'宜都市','81',175),(1722,'当阳市','82',175),(1723,'枝江市','83',175),(1724,'市辖区','01',176),(1725,'襄城区','02',176),(1726,'樊城区','06',176),(1727,'襄阳区','07',176),(1728,'南漳县','24',176),(1729,'谷城县','25',176),(1730,'保康县','26',176),(1731,'老河口市','82',176),(1732,'枣阳市','83',176),(1733,'宜城市','84',176),(1734,'市辖区','01',177),(1735,'粱子湖区','02',177),(1736,'华容区','03',177),(1737,'鄂城区','04',177),(1738,'市辖区','01',178),(1739,'东宝区','02',178),(1740,'掇刀区','04',178),(1741,'京山县','21',178),(1742,'沙洋县','22',178),(1743,'钟祥市','81',178),(1744,'市辖区','01',179),(1745,'孝南区','02',179),(1746,'孝昌县','21',179),(1747,'大悟县','22',179),(1748,'云梦县','23',179),(1749,'应城市','81',179),(1750,'安陆市','82',179),(1751,'汉川市','84',179),(1752,'市辖区','01',180),(1753,'沙市区','02',180),(1754,'荆州区','03',180),(1755,'公安县','22',180),(1756,'监利县','23',180),(1757,'江陵县','24',180),(1758,'石首市','81',180),(1759,'洪湖市','83',180),(1760,'松滋市','87',180),(1761,'市辖区','01',181),(1762,'黄州区','02',181),(1763,'团风县','21',181),(1764,'红安县','22',181),(1765,'罗田县','23',181),(1766,'英山县','24',181),(1767,'浠水县','25',181),(1768,'蕲春县','26',181),(1769,'黄梅县','27',181),(1770,'麻城市','81',181),(1771,'武穴市','82',181),(1772,'市辖区','01',182),(1773,'咸安区','02',182),(1774,'嘉鱼县','21',182),(1775,'通城县','22',182),(1776,'崇阳县','23',182),(1777,'通山县','24',182),(1778,'赤壁市','81',182),(1779,'市辖区','01',183),(1780,'曾都区','02',183),(1781,'广水市','81',183),(1782,'恩施市','01',184),(1783,'利川市','02',184),(1784,'建始县','22',184),(1785,'巴东县','23',184),(1786,'宣恩县','25',184),(1787,'咸丰县','26',184),(1788,'来凤县','27',184),(1789,'鹤峰县','28',184),(1790,'仙桃市','04',185),(1791,'潜江市','05',185),(1792,'天门市','06',185),(1793,'神农架林区','21',185),(1794,'市辖区','01',186),(1795,'芙蓉区','02',186),(1796,'天心区','03',186),(1797,'岳麓区','04',186),(1798,'开福区','05',186),(1799,'雨花区','11',186),(1800,'长沙县','21',186),(1801,'望城县','22',186),(1802,'宁乡县','24',186),(1803,'浏阳市','81',186),(1804,'市辖区','01',187),(1805,'荷塘区','02',187),(1806,'芦淞区','03',187),(1807,'石峰区','04',187),(1808,'天元区','11',187),(1809,'株洲县','21',187),(1810,'攸县','23',187),(1811,'茶陵县','24',187),(1812,'炎陵县','25',187),(1813,'醴陵市','81',187),(1814,'市辖区','01',188),(1815,'雨湖区','02',188),(1816,'岳塘区','04',188),(1817,'湘潭县','21',188),(1818,'湘乡市','81',188),(1819,'韶山市','82',188),(1820,'市辖区','01',189),(1821,'珠晖区','05',189),(1822,'雁峰区','06',189),(1823,'石鼓区','07',189),(1824,'蒸湘区','08',189),(1825,'南岳区','12',189),(1826,'衡阳县','21',189),(1827,'衡南县','22',189),(1828,'衡山县','23',189),(1829,'衡东县','24',189),(1830,'祁东县','26',189),(1831,'耒阳市','81',189),(1832,'常宁市','82',189),(1833,'市辖区','01',190),(1834,'双清区','02',190),(1835,'大祥区','03',190),(1836,'北塔区','11',190),(1837,'邵东县','21',190),(1838,'新邵县','22',190),(1839,'邵阳县','23',190),(1840,'隆回县','24',190),(1841,'洞口县','25',190),(1842,'绥宁县','27',190),(1843,'新宁县','28',190),(1844,'城步苗族自治县','29',190),(1845,'武冈市','81',190),(1846,'市辖区','01',191),(1847,'岳阳楼区','02',191),(1848,'云溪区','03',191),(1849,'君山区','11',191),(1850,'岳阳县','21',191),(1851,'华容县','23',191),(1852,'湘阴县','24',191),(1853,'平江县','26',191),(1854,'汩罗市','81',191),(1855,'临湘市','82',191),(1856,'市辖区','01',192),(1857,'武陵区','02',192),(1858,'鼎城区','03',192),(1859,'安乡县','21',192),(1860,'汉寿县','22',192),(1861,'澧县','23',192),(1862,'临澧县','24',192),(1863,'桃源县','25',192),(1864,'石门县','26',192),(1865,'津市市','81',192),(1866,'市辖区','01',193),(1867,'永定区','02',193),(1868,'武陵源区','11',193),(1869,'慈利县','21',193),(1870,'桑植县','22',193),(1871,'市辖区','01',194),(1872,'资阳区','02',194),(1873,'赫山区','03',194),(1874,'南县','21',194),(1875,'桃江县','22',194),(1876,'安化县','23',194),(1877,'沅江市','81',194),(1878,'市辖区','01',195),(1879,'北湖区','02',195),(1880,'苏仙区','03',195),(1881,'桂阳县','21',195),(1882,'宜章县','22',195),(1883,'永兴县','23',195),(1884,'嘉禾县','24',195),(1885,'临武县','25',195),(1886,'汝城县','26',195),(1887,'桂东县','27',195),(1888,'安仁县','28',195),(1889,'资兴市','81',195),(1890,'市辖区','01',196),(1891,'零陵区','02',196),(1892,'冷水滩区','03',196),(1893,'祁阳县','21',196),(1894,'东安县','22',196),(1895,'双牌县','23',196),(1896,'道县','24',196),(1897,'江永县','25',196),(1898,'宁远县','26',196),(1899,'蓝山县','27',196),(1900,'新田县','28',196),(1901,'江华县','29',196),(1902,'市辖区','01',197),(1903,'鹤城区','02',197),(1904,'中方县','21',197),(1905,'沅陵县','22',197),(1906,'辰溪县','23',197),(1907,'溆浦县','24',197),(1908,'会同县','25',197),(1909,'麻阳苗族自治县','26',197),(1910,'新晃侗族自治县','27',197),(1911,'芷江侗族自治县','28',197),(1912,'靖州苗族侗族县','29',197),(1913,'通道侗族自治县','30',197),(1914,'洪江市','81',197),(1915,'市辖区','01',198),(1916,'娄星区','02',198),(1917,'双峰县','21',198),(1918,'新化县','22',198),(1919,'冷水江市','81',198),(1920,'涟源市','82',198),(1921,'吉首市','01',199),(1922,'泸溪县','22',199),(1923,'凤凰县','23',199),(1924,'花垣县','24',199),(1925,'保靖县','25',199),(1926,'古丈县','26',199),(1927,'永顺县','27',199),(1928,'龙山县','30',199),(1929,'荔湾区','03',200),(1930,'越秀区','04',200),(1931,'海珠区','05',200),(1932,'天河区','06',200),(1933,'白云区','11',200),(1934,'黄埔区','12',200),(1935,'番禺区','13',200),(1936,'花都区','14',200),(1937,'南沙区','15',200),(1938,'萝岗区','16',200),(1939,'增城市','83',200),(1940,'从化市','84',200),(1941,'武江区','03',201),(1942,'浈江区','04',201),(1943,'曲江区','05',201),(1944,'始兴县','22',201),(1945,'仁化县','24',201),(1946,'翁源县','29',201),(1947,'乳源瑶族自治县','32',201),(1948,'新丰县','33',201),(1949,'乐昌市','81',201),(1950,'南雄市','82',201),(1951,'罗湖区','03',202),(1952,'福田区','04',202),(1953,'南山区','05',202),(1954,'宝安区','06',202),(1955,'龙岗区','07',202),(1956,'盐田区','08',202),(1957,'香洲区','02',203),(1958,'斗门区','03',203),(1959,'金湾区','04',203),(1960,'龙湖区','07',204),(1961,'金平区','11',204),(1962,'濠江区','12',204),(1963,'潮阳区','13',204),(1964,'潮南区','14',204),(1965,'澄海区','15',204),(1966,'南澳县','23',204),(1967,'禅城区','04',205),(1968,'南海区','05',205),(1969,'顺德区','06',205),(1970,'三水区','07',205),(1971,'高明区','08',205),(1972,'蓬江区','03',206),(1973,'江海区','04',206),(1974,'新会区','05',206),(1975,'台山市','81',206),(1976,'开平市','83',206),(1977,'鹤山市','84',206),(1978,'恩平市','85',206),(1979,'湛江市赤坎区','02',207),(1980,'湛江市霞山区','03',207),(1981,'湛江市坡头区','04',207),(1982,'湛江市麻章区','11',207),(1983,'遂溪县','23',207),(1984,'徐闻县','25',207),(1985,'廉江市','81',207),(1986,'雷州市','82',207),(1987,'吴川市','83',207),(1988,'茂南区','02',208),(1989,'茂港区','03',208),(1990,'电白县','23',208),(1991,'高州市','81',208),(1992,'化州市','82',208),(1993,'信宜市','83',208),(1994,'端州区','02',209),(1995,'鼎湖区','03',209),(1996,'广宁县','23',209),(1997,'怀集县','24',209),(1998,'封开县','25',209),(1999,'德庆县','26',209),(2000,'高要市','83',209),(2001,'四会市','84',209),(2002,'惠城区','02',210),(2003,'惠阳区','03',210),(2004,'博罗县','22',210),(2005,'惠东县','23',210),(2006,'龙门县','24',210),(2007,'梅江区','02',211),(2008,'梅县','21',211),(2009,'大埔县','22',211),(2010,'丰顺县','23',211),(2011,'五华县','24',211),(2012,'平远县','26',211),(2013,'蕉岭县','27',211),(2014,'兴宁市','81',211),(2015,'市辖区','01',212),(2016,'城区','02',212),(2017,'海丰县','21',212),(2018,'陆河县','23',212),(2019,'陆丰市','81',212),(2020,'源城区','02',213),(2021,'紫金县','21',213),(2022,'龙川县','22',213),(2023,'连平县','23',213),(2024,'和平县','24',213),(2025,'东源县','25',213),(2026,'江城区','02',214),(2027,'阳西县','21',214),(2028,'阳东县','23',214),(2029,'阳春市','81',214),(2030,'清城区','02',215),(2031,'佛冈县','21',215),(2032,'阳山县','23',215),(2033,'连山县','25',215),(2034,'连南瑶族自治县','26',215),(2035,'清新县','27',215),(2036,'英德市','81',215),(2037,'连州市','82',215),(2038,'潮州市湘桥区','02',218),(2039,'潮州市潮安县','21',218),(2040,'潮州市饶平县','22',218),(2041,'榕城区','02',219),(2042,'揭东县','21',219),(2043,'揭西县','22',219),(2044,'惠来县','24',219),(2045,'普宁市','81',219),(2046,'云城区','02',220),(2047,'新兴县','21',220),(2048,'郁南县','22',220),(2049,'云安县','23',220),(2050,'罗定市','81',220),(2051,'市辖区','01',221),(2052,'兴宁区','02',221),(2053,'青秀区','03',221),(2054,'江南区','05',221),(2055,'西乡塘区','07',221),(2056,'良庆区','08',221),(2057,'邕宁区','09',221),(2058,'武鸣县','22',221),(2059,'隆安县','23',221),(2060,'马山县','24',221),(2061,'上林县','25',221),(2062,'宾阳县','26',221),(2063,'横县','27',221),(2064,'市辖区','01',222),(2065,'城中区','02',222),(2066,'鱼峰区','03',222),(2067,'柳南区','04',222),(2068,'柳北区','05',222),(2069,'柳江县','21',222),(2070,'柳城县','22',222),(2071,'鹿寨县','23',222),(2072,'融安县','24',222),(2073,'融水苗族自治县','25',222),(2074,'三江侗族自治县','26',222),(2075,'市辖区','01',223),(2076,'秀峰区','02',223),(2077,'叠彩区','03',223),(2078,'象山区','04',223),(2079,'七星区','05',223),(2080,'雁山区','11',223),(2081,'阳朔县','21',223),(2082,'临桂县','22',223),(2083,'灵川县','23',223),(2084,'全州县','24',223),(2085,'兴安县','25',223),(2086,'永福县','26',223),(2087,'灌阳县','27',223),(2088,'龙胜各族自治县','28',223),(2089,'资源县','29',223),(2090,'平乐县','30',223),(2091,'荔浦县','31',223),(2092,'恭城县','32',223),(2093,'市辖区','01',224),(2094,'万秀区','03',224),(2095,'蝶山区','04',224),(2096,'长洲区','05',224),(2097,'苍梧县','21',224),(2098,'藤县','22',224),(2099,'蒙山县','23',224),(2100,'岑溪市','81',224),(2101,'市辖区','01',225),(2102,'海城区','02',225),(2103,'银海区','03',225),(2104,'铁山港区','12',225),(2105,'合浦县','21',225),(2106,'市辖区','01',226),(2107,'港口区','02',226),(2108,'防城区','03',226),(2109,'上思县','21',226),(2110,'东兴市','81',226),(2111,'市辖区','01',227),(2112,'钦南区','02',227),(2113,'钦北区','03',227),(2114,'灵山县','21',227),(2115,'浦北县','22',227),(2116,'市辖区','01',228),(2117,'港北区','02',228),(2118,'港南区','03',228),(2119,'覃塘区','04',228),(2120,'平南县','21',228),(2121,'桂平市','81',228),(2122,'市辖区','01',229),(2123,'玉州区','02',229),(2124,'容县','21',229),(2125,'陆川县','22',229),(2126,'博白县','23',229),(2127,'兴业县','24',229),(2128,'北流市','81',229),(2129,'市辖区','01',230),(2130,'右江区','02',230),(2131,'田阳县','21',230),(2132,'田东县','22',230),(2133,'平果县','23',230),(2134,'德保县','24',230),(2135,'靖西县','25',230),(2136,'那坡县','26',230),(2137,'凌云县','27',230),(2138,'乐业县','28',230),(2139,'田林县','29',230),(2140,'西林县','30',230),(2141,'隆林各族自治县','31',230),(2142,'市辖区','01',231),(2143,'八步区','02',231),(2144,'昭平县','21',231),(2145,'钟山县','22',231),(2146,'富川瑶族自治县','23',231),(2147,'市辖区','01',232),(2148,'金城江区','02',232),(2149,'南丹县','21',232),(2150,'天峨县','22',232),(2151,'凤山县','23',232),(2152,'东兰县','24',232),(2153,'罗城仫佬族自治县','25',232),(2154,'环江毛南族自治县','26',232),(2155,'巴马瑶族自治县','27',232),(2156,'都安瑶族自治县','28',232),(2157,'大化瑶族自治县','29',232),(2158,'宜州市','81',232),(2159,'市辖区','01',233),(2160,'兴宾区','02',233),(2161,'忻城县','21',233),(2162,'象州县','22',233),(2163,'武宣县','23',233),(2164,'金秀瑶族自治县','24',233),(2165,'合山市','81',233),(2166,'市辖区','01',234),(2167,'江州区','02',234),(2168,'扶绥县','21',234),(2169,'宁明县','22',234),(2170,'龙州县','23',234),(2171,'大新县','24',234),(2172,'天等县','25',234),(2173,'凭祥市','81',234),(2174,'市辖区','01',235),(2175,'秀英区','05',235),(2176,'龙华区','06',235),(2177,'琼山区','07',235),(2178,'美兰区','08',235),(2179,'市辖区','01',236),(2180,'五指山市','01',237),(2181,'琼海市','02',237),(2182,'儋州市','03',237),(2183,'文昌市','05',237),(2184,'万宁市','06',237),(2185,'东方市','07',237),(2186,'定安县','25',237),(2187,'屯昌县','26',237),(2188,'澄迈县','27',237),(2189,'临高县','28',237),(2190,'白沙黎族自治县','30',237),(2191,'昌江黎族自治县','31',237),(2192,'乐东黎族自治县','33',237),(2193,'陵水黎族自治县','34',237),(2194,'保亭黎族苗族自治县','35',237),(2195,'琼中黎族苗族自治县','36',237),(2196,'西沙群岛','37',237),(2197,'南沙群岛','38',237),(2198,'中沙群岛的岛礁及其海域','39',237),(2199,'万州区','01',238),(2200,'涪陵区','02',238),(2201,'渝中区','03',238),(2202,'大渡口区','04',238),(2203,'江北区','05',238),(2204,'沙坪坝区','06',238),(2205,'九龙坡区','07',238),(2206,'南岸区','08',238),(2207,'北碚区','09',238),(2208,'万盛区','10',238),(2209,'双桥区','11',238),(2210,'渝北区','12',238),(2211,'巴南区','13',238),(2212,'黔江区','14',238),(2213,'长寿区','15',238),(2214,'江津区','16',238),(2215,'合川区','17',238),(2216,'永川区','18',238),(2217,'南川区','19',238),(2218,'綦江县','22',239),(2219,'潼南县','23',239),(2220,'铜梁县','24',239),(2221,'大足县','25',239),(2222,'荣昌县','26',239),(2223,'璧山县','27',239),(2224,'梁平县','28',239),(2225,'城口县','29',239),(2226,'丰都县','30',239),(2227,'垫江县','31',239),(2228,'武隆县','32',239),(2229,'忠县','33',239),(2230,'开县','34',239),(2231,'云阳县','35',239),(2232,'奉节县','36',239),(2233,'巫山县','37',239),(2234,'巫溪县','38',239),(2235,'石柱县','40',239),(2236,'秀山土家族苗族自治县','41',239),(2237,'酉阳土家族苗族自治县','42',239),(2238,'彭水苗族土家族自治县','43',239),(2239,'市辖区','01',240),(2240,'锦江区','04',240),(2241,'青羊区','05',240),(2242,'金牛区','06',240),(2243,'武侯区','07',240),(2244,'成华区','08',240),(2245,'龙泉驿区','12',240),(2246,'青白江区','13',240),(2247,'新都区','14',240),(2248,'温江区','15',240),(2249,'金堂县','21',240),(2250,'双流县','22',240),(2251,'郫县','24',240),(2252,'大邑县','29',240),(2253,'蒲江县','31',240),(2254,'新津县','32',240),(2255,'都江堰市','81',240),(2256,'彭州市','82',240),(2257,'邛崃市','83',240),(2258,'崇州市','84',240),(2259,'市辖区','01',241),(2260,'自流井区','02',241),(2261,'贡井区','03',241),(2262,'大安区','04',241),(2263,'沿滩区','11',241),(2264,'荣县','21',241),(2265,'富顺县','22',241),(2266,'市辖区','01',242),(2267,'攀枝花东区','02',242),(2268,'西区','03',242),(2269,'仁和区','11',242),(2270,'米易县','21',242),(2271,'盐边县','22',242),(2272,'市辖区','01',243),(2273,'江阳区','02',243),(2274,'纳溪区','03',243),(2275,'龙马潭区','04',243),(2276,'泸县','21',243),(2277,'合江县','22',243),(2278,'叙永县','24',243),(2279,'古蔺县','25',243),(2280,'市辖区','01',244),(2281,'旌阳区','03',244),(2282,'中江县','23',244),(2283,'罗江县','26',244),(2284,'广汉市','81',244),(2285,'什邡市','82',244),(2286,'绵竹市','83',244),(2287,'市辖区','01',245),(2288,'涪城区','03',245),(2289,'游仙区','04',245),(2290,'三台县','22',245),(2291,'盐亭县','23',245),(2292,'安县','24',245),(2293,'梓潼县','25',245),(2294,'北川羌族自治县','26',245),(2295,'平武县','27',245),(2296,'江油市','81',245),(2297,'市辖区','01',246),(2298,'市中区','02',246),(2299,'元坝区','11',246),(2300,'朝天区','12',246),(2301,'旺苍县','21',246),(2302,'青川县','22',246),(2303,'剑阁县','23',246),(2304,'苍溪县','24',246),(2305,'市辖区','01',247),(2306,'船山区','03',247),(2307,'安居区','04',247),(2308,'蓬溪县','21',247),(2309,'射洪县','22',247),(2310,'大英县','23',247),(2311,'市辖区','01',248),(2312,'市中区','02',248),(2313,'东兴区','11',248),(2314,'威远县','24',248),(2315,'资中县','25',248),(2316,'隆昌县','28',248),(2317,'市辖区','01',249),(2318,'市中区','02',249),(2319,'沙湾区','11',249),(2320,'五通桥区','12',249),(2321,'金口河区','13',249),(2322,'犍为县','23',249),(2323,'井研县','24',249),(2324,'夹江县','26',249),(2325,'沐川县','29',249),(2326,'峨边彝族自治县','32',249),(2327,'马边彝族自治县','33',249),(2328,'峨眉山市','81',249),(2329,'市辖区','01',250),(2330,'顺庆区','02',250),(2331,'高坪区','03',250),(2332,'嘉陵区','04',250),(2333,'南部县','21',250),(2334,'营山县','22',250),(2335,'蓬安县','23',250),(2336,'仪陇县','24',250),(2337,'西充县','25',250),(2338,'阆中市','81',250),(2339,'市辖区','01',251),(2340,'东坡区','02',251),(2341,'仁寿县','21',251),(2342,'彭山县','22',251),(2343,'洪雅县','23',251),(2344,'丹棱县','24',251),(2345,'青神县','25',251),(2346,'市辖区','01',252),(2347,'翠屏区','02',252),(2348,'宜宾县','21',252),(2349,'南溪县','22',252),(2350,'江安县','23',252),(2351,'长宁县','24',252),(2352,'高县','25',252),(2353,'珙县','26',252),(2354,'筠连县','27',252),(2355,'兴文县','28',252),(2356,'屏山县','29',252),(2357,'市辖区','01',253),(2358,'广安区','02',253),(2359,'岳池县','21',253),(2360,'武胜县','22',253),(2361,'邻水县','23',253),(2362,'华蓥市','81',253),(2363,'市辖区','01',254),(2364,'通川区','02',254),(2365,'达县','21',254),(2366,'宣汉县','22',254),(2367,'开江县','23',254),(2368,'大竹县','24',254),(2369,'渠县','25',254),(2370,'万源市','81',254),(2371,'市辖区','01',255),(2372,'雨城区','02',255),(2373,'名山县','21',255),(2374,'荥经县','22',255),(2375,'汉源县','23',255),(2376,'石棉县','24',255),(2377,'天全县','25',255),(2378,'芦山县','26',255),(2379,'宝兴县','27',255),(2380,'市辖区','01',256),(2381,'巴州区','02',256),(2382,'通江县','21',256),(2383,'南江县','22',256),(2384,'平昌县','23',256),(2385,'市辖区','01',257),(2386,'雁江区','02',257),(2387,'安岳县','21',257),(2388,'乐至县','22',257),(2389,'简阳市','81',257),(2390,'汶川县','21',258),(2391,'理县','22',258),(2392,'茂县','23',258),(2393,'松潘县','24',258),(2394,'九寨沟县','25',258),(2395,'金川县','26',258),(2396,'小金县','27',258),(2397,'黑水县','28',258),(2398,'马尔康县','29',258),(2399,'壤塘县','30',258),(2400,'阿坝县','31',258),(2401,'若尔盖县','32',258),(2402,'红原县','33',258),(2403,'康定县','21',259),(2404,'泸定县','22',259),(2405,'丹巴县','23',259),(2406,'九龙县','24',259),(2407,'雅江县','25',259),(2408,'道孚县','26',259),(2409,'炉霍县','27',259),(2410,'甘孜县','28',259),(2411,'新龙县','29',259),(2412,'德格县','30',259),(2413,'白玉县','31',259),(2414,'石渠县','32',259),(2415,'色达县','33',259),(2416,'理塘县','34',259),(2417,'巴塘县','35',259),(2418,'乡城县','36',259),(2419,'稻城县','37',259),(2420,'得荣县','38',259),(2421,'西昌市','01',260),(2422,'木里藏族自治县','22',260),(2423,'盐源县','23',260),(2424,'德昌','24',260),(2425,'会理县','25',260),(2426,'会东县','26',260),(2427,'宁南县','27',260),(2428,'普格县','28',260),(2429,'布拖县','29',260),(2430,'金阳县','30',260),(2431,'昭觉县','31',260),(2432,'喜德县','32',260),(2433,'冕宁县','33',260),(2434,'越西县','34',260),(2435,'甘洛县','35',260),(2436,'美姑县','36',260),(2437,'雷波县','37',260),(2438,'市辖区','01',261),(2439,'南明区','02',261),(2440,'云岩区','03',261),(2441,'花溪区','11',261),(2442,'乌当区','12',261),(2443,'白云区','13',261),(2444,'小河区','14',261),(2445,'开阳县','21',261),(2446,'息烽县','22',261),(2447,'修文县','23',261),(2448,'清镇市','81',261),(2449,'钟山区','01',262),(2450,'六枝特区','03',262),(2451,'水城县','21',262),(2452,'盘县','22',262),(2453,'市辖区','01',263),(2454,'红花岗区','02',263),(2455,'汇川区','03',263),(2456,'遵义县','21',263),(2457,'桐梓县','22',263),(2458,'绥阳县','23',263),(2459,'正安县','24',263),(2460,'道真仡佬族苗族自治县','25',263),(2461,'务川仡佬族苗族自治县','26',263),(2462,'凤冈县','27',263),(2463,'湄潭县','28',263),(2464,'余庆县','29',263),(2465,'习水县','30',263),(2466,'赤水市','81',263),(2467,'仁怀市','82',263),(2468,'市辖区','01',264),(2469,'西秀区','02',264),(2470,'平坝县','21',264),(2471,'普定县','22',264),(2472,'镇宁布依族苗族自治县','23',264),(2473,'关岭自治县','24',264),(2474,'紫云苗族布依族自治县','25',264),(2475,'铜仁市','01',265),(2476,'江口县','22',265),(2477,'玉屏侗族自治县','23',265),(2478,'石阡县','24',265),(2479,'思南县　','25',265),(2480,'印江土家族苗族自治县','26',265),(2481,'德江县','27',265),(2482,'沿河土家族自治县','28',265),(2483,'松桃苗族自治县','29',265),(2484,'万山特区','30',265),(2485,'兴义市','01',266),(2486,'兴仁县','22',266),(2487,'普安县','23',266),(2488,'晴隆县','24',266),(2489,'贞丰县','25',266),(2490,'望谟县','26',266),(2491,'册亨县','27',266),(2492,'安龙县','28',266),(2493,'毕节市','01',267),(2494,'大方县','22',267),(2495,'黔西县','23',267),(2496,'金沙县','24',267),(2497,'织金县','25',267),(2498,'纳雍县','26',267),(2499,'威宁彝族回族苗族自治县','27',267),(2500,'赫章县','28',267),(2501,'凯里市','01',268),(2502,'黄平县','22',268),(2503,'施秉县','23',268),(2504,'三穗县','24',268),(2505,'镇远县','25',268),(2506,'岑巩县','26',268),(2507,'天柱县','27',268),(2508,'锦屏县','28',268),(2509,'剑河县','29',268),(2510,'台江县','30',268),(2511,'黎平县','31',268),(2512,'榕江县','32',268),(2513,'从江县','33',268),(2514,'雷山县','34',268),(2515,'麻江县','35',268),(2516,'丹寨县','36',268),(2517,'都匀市','01',269),(2518,'福泉市','02',269),(2519,'荔波县','22',269),(2520,'贵定县','23',269),(2521,'瓮安县','25',269),(2522,'独山县','26',269),(2523,'平塘县','27',269),(2524,'罗甸县','28',269),(2525,'长顺县','29',269),(2526,'龙里县','30',269),(2527,'惠水县','31',269),(2528,'三都水族自治县','32',269),(2529,'市辖区','01',270),(2530,'五华区','02',270),(2531,'盘龙区','03',270),(2532,'官渡区','11',270),(2533,'西山区','12',270),(2534,'东川区','13',270),(2535,'呈贡县','21',270),(2536,'晋宁县','22',270),(2537,'富民县','24',270),(2538,'宜良县','25',270),(2539,'石林县','26',270),(2540,'嵩明县','27',270),(2541,'禄劝县','28',270),(2542,'寻甸县','29',270),(2543,'安宁市','81',270),(2544,'市辖区','01',271),(2545,'麒麟区','02',271),(2546,'马龙县','21',271),(2547,'陆良县','22',271),(2548,'师宗县','23',271),(2549,'罗平县','24',271),(2550,'富源县','25',271),(2551,'会泽县','26',271),(2552,'沾益县','28',271),(2553,'宣威市','81',271),(2554,'市辖区','01',272),(2555,'红塔区','02',272),(2556,'江川县','21',272),(2557,'澄江县','22',272),(2558,'通海县','23',272),(2559,'华宁县','24',272),(2560,'易门县','25',272),(2561,'峨山县','26',272),(2562,'新平县','27',272),(2563,'元江县','28',272),(2564,'市辖区','01',273),(2565,'隆阳区','02',273),(2566,'施甸县','21',273),(2567,'腾冲县','22',273),(2568,'龙陵县','23',273),(2569,'昌宁县','24',273),(2570,'市辖区','01',274),(2571,'昭阳区','02',274),(2572,'鲁甸县','21',274),(2573,'巧家县','22',274),(2574,'盐津县','23',274),(2575,'大关县','24',274),(2576,'永善县','25',274),(2577,'绥江县','26',274),(2578,'镇雄县','27',274),(2579,'彝良县','28',274),(2580,'威信县','29',274),(2581,'水富县','30',274),(2582,'市辖区','01',275),(2583,'古城区','02',275),(2584,'玉龙县','21',275),(2585,'永胜县','22',275),(2586,'华坪县','23',275),(2587,'宁蒗县','24',275),(2588,'市辖区','01',276),(2589,'翠云区','02',276),(2590,'普洱县','21',276),(2591,'墨江县','22',276),(2592,'景东县','23',276),(2593,'景谷县','24',276),(2594,'镇沅县','25',276),(2595,'江城县','26',276),(2596,'孟连县','27',276),(2597,'澜沧县','28',276),(2598,'西盟县','29',276),(2599,'市辖区','01',277),(2600,'临翔区','02',277),(2601,'凤庆县','21',277),(2602,'云县','22',277),(2603,'永德县','23',277),(2604,'镇康县','24',277),(2605,'双江县','25',277),(2606,'耿马县','26',277),(2607,'沧源县','27',277),(2608,'楚雄市','01',278),(2609,'双柏县','22',278),(2610,'牟定县','23',278),(2611,'南华县','24',278),(2612,'姚安县','25',278),(2613,'大姚县','26',278),(2614,'永仁县','27',278),(2615,'元谋县','28',278),(2616,'武定县','29',278),(2617,'禄丰县','31',278),(2618,'个旧市','01',279),(2619,'开远市','02',279),(2620,'蒙自县','22',279),(2621,'屏边县','23',279),(2622,'建水县','24',279),(2623,'石屏县','25',279),(2624,'弥勒县','26',279),(2625,'泸西县','27',279),(2626,'元阳县','28',279),(2627,'红河县','29',279),(2628,'金平县','30',279),(2629,'绿春县','31',279),(2630,'河口县','32',279),(2631,'文山县','21',280),(2632,'砚山县','22',280),(2633,'西畴县','23',280),(2634,'麻栗坡县','24',280),(2635,'马关县','25',280),(2636,'丘北县','26',280),(2637,'广南县','27',280),(2638,'富宁县','28',280),(2639,'景洪市','01',281),(2640,'勐海县','22',281),(2641,'勐腊县','23',281),(2642,'大理市','01',282),(2643,'漾濞县','22',282),(2644,'祥云县','23',282),(2645,'宾川县','24',282),(2646,'弥渡县','25',282),(2647,'南涧县','26',282),(2648,'巍山县','27',282),(2649,'永平县','28',282),(2650,'云龙县','29',282),(2651,'洱源县','30',282),(2652,'剑川县','31',282),(2653,'鹤庆县','32',282),(2654,'瑞丽市','02',283),(2655,'潞西市','03',283),(2656,'梁河县','22',283),(2657,'盈江县','23',283),(2658,'陇川县','24',283),(2659,'泸水县','21',284),(2660,'福贡县','23',284),(2661,'贡山县','24',284),(2662,'兰坪县','25',284),(2663,'香格里拉县','21',285),(2664,'德钦县','22',285),(2665,'维西县','23',285),(2666,'城关区','02',286),(2667,'林周县','21',286),(2668,'当雄县','22',286),(2669,'尼木县','23',286),(2670,'曲水县','24',286),(2671,'堆龙德庆','25',286),(2672,'达孜县','26',286),(2673,'墨竹工卡县','27',286),(2674,'昌都县','21',287),(2675,'江达县','22',287),(2676,'贡觉县','23',287),(2677,'类乌齐县','24',287),(2678,'丁青县','25',287),(2679,'察亚县','26',287),(2680,'八宿县','27',287),(2681,'左贡县','28',287),(2682,'芒康县','29',287),(2683,'洛隆县','32',287),(2684,'边坝县','33',287),(2685,'乃东县','21',288),(2686,'扎囊县','22',288),(2687,'贡嘎县','23',288),(2688,'桑日县','24',288),(2689,'琼结县','25',288),(2690,'曲松县','26',288),(2691,'措美县','27',288),(2692,'洛扎县','28',288),(2693,'加查县','29',288),(2694,'隆子县','31',288),(2695,'错那县','32',288),(2696,'浪卡子县','33',288),(2697,'日喀则市','01',289),(2698,'南木林县','22',289),(2699,'江孜县','23',289),(2700,'定日县','24',289),(2701,'萨迦县','25',289),(2702,'拉孜县','26',289),(2703,'昂仁县','27',289),(2704,'谢通门县','28',289),(2705,'白朗县','29',289),(2706,'仁布县','30',289),(2707,'康马县','31',289),(2708,'定结县','32',289),(2709,'仲巴县','33',289),(2710,'亚东县','34',289),(2711,'吉隆县','35',289),(2712,'聂拉木县','36',289),(2713,'萨嘎县','37',289),(2714,'岗巴县','38',289),(2715,'那曲县','21',290),(2716,'嘉黎县','22',290),(2717,'比如县','23',290),(2718,'聂荣县','24',290),(2719,'安多县','25',290),(2720,'申扎县','26',290),(2721,'索县','27',290),(2722,'班戈县','28',290),(2723,'巴青县','29',290),(2724,'尼玛县','30',290),(2725,'普兰县','21',291),(2726,'札达县','22',291),(2727,'噶尔县','23',291),(2728,'日土县','24',291),(2729,'革吉县','25',291),(2730,'改则县','26',291),(2731,'措勤县','27',291),(2732,'林芝县','21',292),(2733,'工布江达县','22',292),(2734,'米林县','23',292),(2735,'墨脱县','24',292),(2736,'波密县','25',292),(2737,'察隅县','26',292),(2738,'朗县','27',292),(2739,'市辖区','01',293),(2740,'新城区','02',293),(2741,'碑林区','03',293),(2742,'莲湖区','04',293),(2743,'灞桥区','11',293),(2744,'未央区','12',293),(2745,'雁塔区','13',293),(2746,'阎良区','14',293),(2747,'临潼区','15',293),(2748,'长安区','16',293),(2749,'蓝田县','22',293),(2750,'周至县','24',293),(2751,'户县','25',293),(2752,'高陵县','26',293),(2753,'市辖区','01',294),(2754,'王益区','02',294),(2755,'印台区','03',294),(2756,'耀州区','04',294),(2757,'宜君县','22',294),(2758,'市辖区','01',295),(2759,'渭滨区','02',295),(2760,'金台区','03',295),(2761,'陈仓区','04',295),(2762,'凤翔县','22',295),(2763,'岐山县','23',295),(2764,'扶风县','24',295),(2765,'眉县','26',295),(2766,'陇县','27',295),(2767,'千阳县','28',295),(2768,'麟游县','29',295),(2769,'凤县','30',295),(2770,'太白县','31',295),(2771,'市辖区','01',296),(2772,'秦都区','02',296),(2773,'杨凌区','03',296),(2774,'渭城区','04',296),(2775,'三原县','22',296),(2776,'泾阳县','23',296),(2777,'乾县','24',296),(2778,'礼泉县','25',296),(2779,'永寿县','26',296),(2780,'彬县','27',296),(2781,'长武县','28',296),(2782,'旬邑县','29',296),(2783,'淳化县','30',296),(2784,'武功县','31',296),(2785,'兴平市','81',296),(2786,'市辖区','01',297),(2787,'临渭区','02',297),(2788,'华县','21',297),(2789,'潼关县','22',297),(2790,'大荔县','23',297),(2791,'合阳县','24',297),(2792,'澄城县','25',297),(2793,'蒲城县','26',297),(2794,'白水县','27',297),(2795,'富平县','28',297),(2796,'韩城市','81',297),(2797,'华阴市','82',297),(2798,'市辖区','01',298),(2799,'宝塔区','02',298),(2800,'延长县','21',298),(2801,'延川县','22',298),(2802,'子长县','23',298),(2803,'安塞县','24',298),(2804,'志丹县','25',298),(2805,'吴起县','26',298),(2806,'甘泉县','27',298),(2807,'富县','28',298),(2808,'洛川县','29',298),(2809,'宜川县','30',298),(2810,'黄龙县','31',298),(2811,'黄陵县','32',298),(2812,'市辖区','01',299),(2813,'汉台区','02',299),(2814,'南郑县','21',299),(2815,'城固县','22',299),(2816,'洋县','23',299),(2817,'西乡县','24',299),(2818,'勉县','25',299),(2819,'宁强县','26',299),(2820,'略阳县','27',299),(2821,'镇巴县','28',299),(2822,'留坝县','29',299),(2823,'佛坪县','30',299),(2824,'市辖区','01',300),(2825,'榆阳区','02',300),(2826,'神木县','21',300),(2827,'府谷县','22',300),(2828,'横山县','23',300),(2829,'靖边县','24',300),(2830,'定边县','25',300),(2831,'绥德县','26',300),(2832,'米脂县','27',300),(2833,'佳县','28',300),(2834,'吴堡县','29',300),(2835,'清涧县','30',300),(2836,'子洲县','31',300),(2837,'市辖区','01',301),(2838,'汉滨区','02',301),(2839,'汉阴县','21',301),(2840,'石泉县','22',301),(2841,'宁陕县','23',301),(2842,'紫阳县','24',301),(2843,'岚皋县','25',301),(2844,'平利县','26',301),(2845,'镇坪县','27',301),(2846,'旬阳县','28',301),(2847,'白河县','29',301),(2848,'市辖区','01',302),(2849,'商州区','02',302),(2850,'洛南县','21',302),(2851,'丹凤县','22',302),(2852,'商南县','23',302),(2853,'山阳县','24',302),(2854,'镇安县','25',302),(2855,'柞水县','26',302),(2856,'市辖区','01',303),(2857,'城关区','02',303),(2858,'七里河区','03',303),(2859,'兰州市西固区','04',303),(2860,'安宁区','05',303),(2861,'红古区','11',303),(2862,'永登县','21',303),(2863,'皋兰县','22',303),(2864,'榆中县','23',303),(2865,'市辖','01',304),(2866,'市辖区','01',305),(2867,'金川区','02',305),(2868,'永昌县','21',305),(2869,'市辖区','01',306),(2870,'白银区','02',306),(2871,'平川区','03',306),(2872,'靖远县','21',306),(2873,'会宁县','22',306),(2874,'景泰县','23',306),(2875,'市辖区','01',307),(2876,'秦州区','02',307),(2877,'麦积区','03',307),(2878,'清水县','21',307),(2879,'秦安县','22',307),(2880,'甘谷县','23',307),(2881,'武山县','24',307),(2882,'张家川县','25',307),(2883,'市辖区','01',308),(2884,'凉州区','02',308),(2885,'民勤县','21',308),(2886,'古浪县','22',308),(2887,'天祝县','23',308),(2888,'市辖区','01',309),(2889,'甘州区','02',309),(2890,'肃南裕固族自治县','21',309),(2891,'民乐县','22',309),(2892,'临泽县','23',309),(2893,'高台县','24',309),(2894,'山丹县','25',309),(2895,'市辖区','01',310),(2896,'崆峒区','02',310),(2897,'泾川县','21',310),(2898,'灵台县','22',310),(2899,'崇信县','23',310),(2900,'华亭县','24',310),(2901,'庄浪县','25',310),(2902,'静宁县','26',310),(2903,'市辖区','01',311),(2904,'肃州区','02',311),(2905,'金塔县','21',311),(2906,'瓜州县','22',311),(2907,'肃北蒙古族自治县','23',311),(2908,'阿克塞县','24',311),(2909,'玉门市','81',311),(2910,'敦煌市','82',311),(2911,'市辖区','01',312),(2912,'西峰区','02',312),(2913,'庆城县','21',312),(2914,'环县','22',312),(2915,'华池县','23',312),(2916,'合水县','24',312),(2917,'正宁县','25',312),(2918,'宁县','26',312),(2919,'镇原县','27',312),(2920,'市辖区','01',313),(2921,'安定区','02',313),(2922,'通渭县','21',313),(2923,'陇西县','22',313),(2924,'渭源县','23',313),(2925,'临洮县','24',313),(2926,'漳县','25',313),(2927,'岷县','26',313),(2928,'市辖区','01',314),(2929,'武都区','02',314),(2930,'成县','21',314),(2931,'文县','22',314),(2932,'宕昌县','23',314),(2933,'康县','24',314),(2934,'西和县','25',314),(2935,'礼县','26',314),(2936,'徽县','27',314),(2937,'两当县','28',314),(2938,'临夏市','01',315),(2939,'临夏县','21',315),(2940,'康乐县','22',315),(2941,'永靖县','23',315),(2942,'广河县','24',315),(2943,'和政县','25',315),(2944,'东乡族自治县','26',315),(2945,'积石山县','27',315),(2946,'合作市','01',316),(2947,'临潭县','21',316),(2948,'卓尼县','22',316),(2949,'舟曲县','23',316),(2950,'迭部县','24',316),(2951,'玛曲县','25',316),(2952,'碌曲县','26',316),(2953,'夏河县','27',316),(2954,'城东区','02',317),(2955,'城中区','03',317),(2956,'城西区','04',317),(2957,'城北区','05',317),(2958,'大通回族土族自治县','21',317),(2959,'湟中县','22',317),(2960,'湟源县','23',317),(2961,'平安县','21',318),(2962,'民和县','22',318),(2963,'乐都县','23',318),(2964,'互助县','26',318),(2965,'化隆回族自治县','27',318),(2966,'循化县','28',318),(2967,'门源县','21',319),(2968,'祁连县','22',319),(2969,'海晏县','23',319),(2970,'刚察县','24',319),(2971,'同仁县','21',320),(2972,'尖扎县','22',320),(2973,'泽库县','23',320),(2974,'河南县','24',320),(2975,'共和县','21',321),(2976,'同德县','22',321),(2977,'贵德县','23',321),(2978,'兴海县','24',321),(2979,'贵南县','25',321),(2980,'玛沁县','21',322),(2981,'班玛县','22',322),(2982,'甘德县','23',322),(2983,'达日县','24',322),(2984,'久治县','25',322),(2985,'玛多县','26',322),(2986,'玉树县','21',323),(2987,'杂多县','22',323),(2988,'称多县','23',323),(2989,'治多县','24',323),(2990,'囊谦县','25',323),(2991,'曲麻莱县','26',323),(2992,'格尔木市','01',324),(2993,'德令哈市','02',324),(2994,'乌兰县','21',324),(2995,'都兰县','22',324),(2996,'天峻县','23',324),(2997,'市辖区','01',325),(2998,'兴庆区','04',325),(2999,'西夏区','05',325),(3000,'金凤区','06',325),(3001,'永宁县','21',325),(3002,'贺兰县','22',325),(3003,'灵武市','81',325),(3004,'市辖区','01',326),(3005,'大武口区','02',326),(3006,'惠农区','05',326),(3007,'平罗县','21',326),(3008,'市辖区','01',327),(3009,'利通区','02',327),(3010,'盐池县','23',327),(3011,'同心县','24',327),(3012,'青铜峡市','81',327),(3013,'市辖区','01',328),(3014,'原州区','02',328),(3015,'西吉县','22',328),(3016,'隆德县','23',328),(3017,'泾源县','24',328),(3018,'彭阳县','25',328),(3019,'市辖区','01',329),(3020,'沙坡头区','02',329),(3021,'中宁县','21',329),(3022,'海原县','22',329),(3023,'市辖区','01',330),(3024,'天山区','02',330),(3025,'沙依巴克区','03',330),(3026,'新市区','04',330),(3027,'水磨沟区','05',330),(3028,'头屯河区','06',330),(3029,'达坂城区','07',330),(3030,'东山区','08',330),(3031,'乌鲁木齐县','21',330),(3032,'市辖区','01',331),(3033,'独山子区','02',331),(3034,'克拉玛依区','03',331),(3035,'白碱滩区','04',331),(3036,'乌尔禾区','05',331),(3037,'吐鲁番市','01',332),(3038,'鄯善县','22',332),(3039,'托克逊县','23',332),(3040,'哈密市','01',333),(3041,'巴里坤县','22',333),(3042,'伊吾县','23',333),(3043,'昌吉市','01',334),(3044,'阜康市','02',334),(3045,'米泉市','03',334),(3046,'呼图壁县','23',334),(3047,'玛纳斯','24',334),(3048,'奇台县','25',334),(3049,'吉木萨尔县','27',334),(3050,'木垒县','28',334),(3051,'博乐市','01',335),(3052,'精河县','22',335),(3053,'温泉县','23',335),(3054,'库尔勒市','01',336),(3055,'轮台县','22',336),(3056,'尉犁县','23',336),(3057,'若羌县','24',336),(3058,'且末县','25',336),(3059,'焉耆县','26',336),(3060,'和静县','27',336),(3061,'和硕县','28',336),(3062,'博湖县','29',336),(3063,'阿克苏市','01',337),(3064,'温宿县','22',337),(3065,'库车县','23',337),(3066,'沙雅县','24',337),(3067,'新和县','25',337),(3068,'拜城县','26',337),(3069,'乌什县','27',337),(3070,'阿瓦提县','28',337),(3071,'柯坪县','29',337),(3072,'阿图什市','01',338),(3073,'阿克陶县','22',338),(3074,'阿合奇县','23',338),(3075,'乌恰县','24',338),(3076,'喀什市','01',339),(3077,'疏附县','21',339),(3078,'疏勒县','22',339),(3079,'英吉沙县','23',339),(3080,'泽普县','24',339),(3081,'莎车县','25',339),(3082,'叶城县','26',339),(3083,'麦盖提县','27',339),(3084,'岳普湖县','28',339),(3085,'伽师县','29',339),(3086,'巴楚县','30',339),(3087,'塔什库尔干县','31',339),(3088,'和田市','01',340),(3089,'和田县','21',340),(3090,'墨玉县','22',340),(3091,'皮山县','23',340),(3092,'洛浦县','24',340),(3093,'策勒县','25',340),(3094,'于田县','26',340),(3095,'民丰县','27',340),(3096,'伊宁市','02',341),(3097,'奎屯市','03',341),(3098,'伊宁县','21',341),(3099,'察布查尔县','22',341),(3100,'霍城县','23',341),(3101,'巩留县','24',341),(3102,'新源县','25',341),(3103,'昭苏县','26',341),(3104,'特克斯县','27',341),(3105,'尼勒克县','28',341),(3106,'塔城市','01',342),(3107,'乌苏市','02',342),(3108,'额敏县','21',342),(3109,'沙湾县','23',342),(3110,'托里县','24',342),(3111,'裕民县','25',342),(3112,'和布克赛尔蒙古自治县','26',342),(3113,'阿勒泰市','01',343),(3114,'布尔津县','21',343),(3115,'富蕴县','22',343),(3116,'福海县','23',343),(3117,'哈巴河县','24',343),(3118,'青河县','25',343),(3119,'吉木乃县','26',343),(3120,'石河子市','01',344),(3121,'阿拉尔市','02',344),(3122,'图木舒克市','03',344),(3123,'五家渠市','04',344),(3124,'高新区','09',240);

UNLOCK TABLES;

/*Table structure for table `te_department` */

DROP TABLE IF EXISTS `te_department`;

CREATE TABLE `te_department` (
  `deptId` bigint(20) NOT NULL AUTO_INCREMENT,
  `deptName` varchar(64) DEFAULT NULL COMMENT '部门名称',
  `createTime` datetime DEFAULT NULL COMMENT '创建时间',
  `creator` varchar(64) DEFAULT NULL COMMENT '创建人',
  `deptDescription` varchar(1024) DEFAULT NULL COMMENT '部门简介',
  `deptPrincipal` bigint(20) DEFAULT '0' COMMENT '负责人ID',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`deptId`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

/*Data for the table `te_department` */

LOCK TABLES `te_department` WRITE;

insert  into `te_department`(`deptId`,`deptName`,`createTime`,`creator`,`deptDescription`,`deptPrincipal`,`timestamp`) values (1,'财务部','2016-07-03 14:11:12','admin','根据公司资金运作情况，合理调配资金，确保公司资金正常运转。',0,'2016-07-03 14:20:22'),(2,'技术研发部','2016-07-03 14:11:28','admin','研发部是公司的核心部门，肩负着研制、开发新产品，完善产品功能的任务。',0,'2016-07-03 14:22:39'),(3,'产品设计部','2016-07-03 14:12:02','admin','负责公司策划设计制作、公司展览会议布置； ',0,'2016-07-03 14:23:05'),(4,'行政部','2016-07-03 14:19:15','admin','公司行政部门广义上包括行政事务、办公事务、人力资源、财产会计四个方面；',0,'2016-07-03 14:19:15'),(5,'人事部','2016-07-03 14:19:49','admin','负责制定公司人事管理制度，实施并提出合理化意见和建议；',0,'2016-07-03 14:29:06'),(6,'采购部','2016-07-03 14:20:46','admin','直接对分管领导、公司负责，全面主持采购部工作，确保各项任务的顺利完成；',0,'2016-07-03 14:29:13'),(7,'数据分析部','2016-07-03 14:21:30','admin','做出科学、合理的分析、以便正确决策；',0,'2016-07-03 14:21:30'),(8,'软件测试部','2016-07-03 14:24:40','admin','负责以解决客户业务测试问题为目的的测试解决方案架构和研发工作；',0,'2016-07-03 14:29:01'),(9,'前台接待部','2016-07-03 14:26:14','admin','负责公司前台接待工作、公司电话接转、收发传真、文档复印等工作。',0,'2016-07-03 14:26:14'),(10,'产品运营部','2016-07-03 14:26:52','admin','收集经营信息，掌握市场动态，深入调查研究，为集团决策提供依据。',0,'2016-07-03 14:26:52'),(11,'市场部','2016-07-03 14:27:47','admin','解决市场对企业产品的需求问题；',0,'2016-07-03 14:28:55'),(12,'公关部','2016-07-03 14:28:12','admin','建立与维护公司与社区、公众媒介、行业协会、政府部门的公众关系；',0,'2016-07-03 14:28:22');

UNLOCK TABLES;

/*Table structure for table `te_employees_basic` */

DROP TABLE IF EXISTS `te_employees_basic`;

CREATE TABLE `te_employees_basic` (
  `emId` bigint(20) NOT NULL AUTO_INCREMENT,
  `emState` int(2) DEFAULT '0' COMMENT '员工状态',
  `emPhoto` varchar(64) DEFAULT NULL COMMENT '头像',
  `emFullName` varchar(64) DEFAULT NULL COMMENT '员工姓名',
  `emSex` tinyint(1) DEFAULT '0' COMMENT '性别',
  `emIdentity` varchar(32) DEFAULT NULL COMMENT '身份证号码',
  `emBirthday` varchar(16) DEFAULT NULL COMMENT '出生日期',
  `emParticipateTime` varchar(12) DEFAULT NULL COMMENT '入职时间',
  `emPhone` varchar(32) DEFAULT NULL COMMENT '联系电话',
  `emSocialSecurity` varchar(32) DEFAULT NULL COMMENT '社保卡号',
  `emDeparemtn` bigint(20) DEFAULT '0' COMMENT '部门',
  `emPosition` bigint(20) DEFAULT '0' COMMENT '职位',
  `emEducation` bigint(20) DEFAULT '0' COMMENT '文化程度',
  `emMarriage` bigint(20) DEFAULT '0' COMMENT '婚姻状况',
  `emPolitics` bigint(20) DEFAULT '0' COMMENT '政治面貌',
  `emNational` bigint(20) DEFAULT '0' COMMENT '民族',
  `emCurrentAddress` bigint(20) DEFAULT '0' COMMENT '现居住地址',
  `emCensusRegister` bigint(20) DEFAULT '0' COMMENT '户籍地址',
  `createTime` datetime DEFAULT NULL COMMENT '添加时间',
  `creator` varchar(64) DEFAULT NULL COMMENT '创建者',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`emId`),
  UNIQUE KEY `emIdentity` (`emIdentity`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8;

/*Data for the table `te_employees_basic` */

LOCK TABLES `te_employees_basic` WRITE;

insert  into `te_employees_basic`(`emId`,`emState`,`emPhoto`,`emFullName`,`emSex`,`emIdentity`,`emBirthday`,`emParticipateTime`,`emPhone`,`emSocialSecurity`,`emDeparemtn`,`emPosition`,`emEducation`,`emMarriage`,`emPolitics`,`emNational`,`emCurrentAddress`,`emCensusRegister`,`createTime`,`creator`,`timestamp`) values (1,1,'./images/defaultphoto.jpg','安子隐',0,'350105198011037735','2016-07-03','2016-07-06','13412452222','35010519801',2,2,7,5,3,5,2,1,'2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(2,1,'./images/defaultphoto.jpg','魏仁毅',0,'511126198902132771','2016-07-03','2016-07-06','13412452222','35010519801',2,2,7,5,3,5,2,1,'2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(3,4,'./images/defaultphoto.jpg','董秉纯',0,'420683197608069094','2016-07-03','2016-07-06','13412452222','35010519801',2,2,7,5,3,5,2,1,'2016-07-03 14:48:48','admin','2016-07-03 15:06:43'),(4,1,'./images/defaultphoto.jpg','阮山彤',0,'451123198208127897','2016-07-03','2016-07-06','13412452222','35010519801',2,2,7,5,3,5,2,1,'2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(5,4,'./images/defaultphoto.jpg','彭熙骋',0,'440781198406061159','2016-07-03','2016-07-06','13412452222','35010519801',2,2,7,5,3,5,2,1,'2016-07-03 14:48:48','admin','2016-07-03 15:06:50'),(6,1,'./images/defaultphoto.jpg','经茗卓',0,'530326198106071836','2016-07-03','2016-07-06','13412452222','35010519801',2,2,7,5,3,5,2,1,'2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(7,1,'./images/defaultphoto.jpg','殷准辰',0,'150501197805088977','2016-07-03','2016-07-06','13412452222','35010519801',2,2,7,5,3,5,2,1,'2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(8,4,'./images/defaultphoto.jpg','贲悠洋',0,'522625198505132296','2016-07-03','2016-07-06','13412452222','35010519801',2,2,7,5,3,5,2,1,'2016-07-03 14:48:48','admin','2016-07-03 15:06:47'),(9,1,'./images/defaultphoto.jpg','包鲁郎',0,'371623197801261133','2016-07-03','2016-07-06','13412452222','35010519801',2,2,7,5,3,5,2,1,'2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(10,1,'./images/defaultphoto.jpg','邬讯波',0,'430724198612287416','2016-07-03','2016-07-06','13412452222','35010519801',2,2,7,5,3,5,2,1,'2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(11,1,'./images/defaultphoto.jpg','罗延秋',0,'210311199204206998','2016-07-03','2016-07-06','13412452222','35010519801',2,2,7,5,3,5,2,1,'2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(12,1,'./images/defaultphoto.jpg','蒋资龙',0,'610402197504215655','2016-07-03','2016-07-06','13412452222','35010519801',2,2,7,5,3,5,2,1,'2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(13,1,'./images/defaultphoto.jpg','邱松帆',0,'150221199109164735','2016-07-03','2016-07-06','13412452222','35010519801',2,2,7,5,3,5,2,1,'2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(14,1,'./images/defaultphoto.jpg','明雄民',0,'510501199012229297','2016-07-03','2016-07-06','13412452222','35010519801',2,2,7,5,3,5,2,1,'2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(15,1,'./images/defaultphoto.jpg','吕葛琢',0,'621102198808266073','2016-07-03','2016-07-06','13412452222','35010519801',2,2,7,5,3,5,2,1,'2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(16,1,'./images/defaultphoto.jpg','云绍焱',0,'469003197508062451','2016-07-03','2016-07-06','13412452222','35010519801',2,2,7,5,3,5,2,1,'2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(17,2,'./images/defaultphoto.jpg','诸勋庚',0,'231025198003089897','2016-07-03','2016-07-06','13412452222','35010519801',2,2,7,5,3,5,2,1,'2016-07-03 14:48:48','admin','2016-07-03 15:06:22'),(18,1,'./images/defaultphoto.jpg','昌荔依',0,'141032199207188316','2016-07-03','2016-07-06','13412452222','35010519801',2,2,7,5,3,5,2,1,'2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(19,1,'./images/defaultphoto.jpg','鲁勋庚',0,'610821199301036518','2016-07-03','2016-07-06','13412452222','35010519801',2,2,7,5,3,5,2,1,'2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(20,4,'./images/defaultphoto.jpg','贾盎德',0,'140932198911269818','2016-07-03','2016-07-06','13412452222','35010519801',2,2,7,5,3,5,2,1,'2016-07-03 14:48:48','admin','2016-07-03 15:06:36'),(21,1,'./images/defaultphoto.jpg','金宇澄',0,'150402198511016471','2016-07-03','2016-07-06','13412452222','35010519801',2,2,7,5,3,5,2,1,'2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(22,2,'./images/defaultphoto.jpg','湛讯波',0,'450981198404124331','2016-07-03','2016-07-06','13412452222','35010519801',2,2,7,5,3,5,2,1,'2016-07-03 14:48:48','admin','2016-07-03 15:06:11'),(23,4,'./images/defaultphoto.jpg','时锋滕',0,'370883197708183034','2016-07-03','2016-07-06','13412452222','35010519801',2,2,7,5,3,5,2,1,'2016-07-03 14:48:48','admin','2016-07-03 15:06:39'),(24,1,'./images/defaultphoto.jpg','狄政航',0,'451323198008244715','2016-07-03','2016-07-06','13412452222','35010519801',2,2,7,5,3,5,2,1,'2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(25,1,'./images/defaultphoto.jpg','邱依波',0,'420528199312056568','2016-07-03','2016-07-06','13412452222','35010519801',2,2,7,5,3,5,2,1,'2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(26,1,'./images/defaultphoto.jpg','卜冷菱',0,'450804198303159043','2016-07-03','2016-07-06','13412452222','35010519801',2,2,7,5,3,5,2,1,'2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(27,1,'./images/defaultphoto.jpg','戚孤晴',0,'420981197609277825','2016-07-03','2016-07-06','13412452222','35010519801',2,2,7,5,3,5,2,1,'2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(28,1,'./images/defaultphoto.jpg','明凡桃',0,'450621198210129182','2016-07-03','2016-07-06','13412452222','35010519801',2,2,7,5,3,5,2,1,'2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(29,2,'./images/defaultphoto.jpg','倪又夏',0,'511824198505152707','2016-07-03','2016-07-06','13412452222','35010519801',2,2,7,5,3,5,2,1,'2016-07-03 15:11:32','admin','2016-07-03 15:11:32'),(30,1,'./images/defaultphoto.jpg','邱尔风',0,'140821199204194845','2016-07-03','2016-07-06','13412452222','35010519801',2,2,7,5,3,5,2,1,'2016-07-03 15:05:17','admin','2016-07-03 15:05:17');

UNLOCK TABLES;

/*Table structure for table `te_employees_company` */

DROP TABLE IF EXISTS `te_employees_company`;

CREATE TABLE `te_employees_company` (
  `comId` bigint(20) NOT NULL AUTO_INCREMENT,
  `emplNo` bigint(20) DEFAULT NULL COMMENT '员工ID号',
  `comName` varchar(256) DEFAULT NULL COMMENT '单位名称',
  `comParticipateTime` varchar(12) DEFAULT NULL COMMENT '入职时间',
  `comLeaveTime` varchar(12) DEFAULT NULL COMMENT '离职时间',
  `comPosition` varchar(128) DEFAULT NULL COMMENT '岗位',
  `comReason` varchar(1024) DEFAULT NULL COMMENT '离职原因',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `te_employees_company` */

LOCK TABLES `te_employees_company` WRITE;

UNLOCK TABLES;

/*Table structure for table `te_employees_detail` */

DROP TABLE IF EXISTS `te_employees_detail`;

CREATE TABLE `te_employees_detail` (
  `emId` bigint(20) NOT NULL AUTO_INCREMENT,
  `emplNo` bigint(20) DEFAULT NULL COMMENT '员工编号',
  `emContact` varchar(1024) DEFAULT NULL COMMENT '其他联系方式',
  `emEmergencyContact` varchar(64) DEFAULT NULL COMMENT '紧急联系人',
  `emEmergencyPhone` varchar(1024) DEFAULT NULL COMMENT '紧急联系方式',
  `emSchool` varchar(1024) DEFAULT NULL COMMENT '毕业校院',
  `emProfessional` varchar(1024) DEFAULT NULL COMMENT '就读专业',
  `emGraduationTime` varchar(12) DEFAULT NULL COMMENT '毕业时间',
  `emSchooling` varchar(256) DEFAULT NULL COMMENT '学历',
  `emDegree` varchar(256) DEFAULT NULL COMMENT '学位',
  `emIsSocialSecurity` tinyint(1) DEFAULT NULL COMMENT '是否缴纳社保',
  `emNote` text COMMENT '备注',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`emId`),
  UNIQUE KEY `emolNo` (`emplNo`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8;

/*Data for the table `te_employees_detail` */

LOCK TABLES `te_employees_detail` WRITE;

insert  into `te_employees_detail`(`emId`,`emplNo`,`emContact`,`emEmergencyContact`,`emEmergencyPhone`,`emSchool`,`emProfessional`,`emGraduationTime`,`emSchooling`,`emDegree`,`emIsSocialSecurity`,`emNote`,`timestamp`) values (1,1,'www.TE5L.com','张三','13412452222','','','','','',0,'','2016-07-03 14:48:25'),(2,2,'www.TE5L.com','张三','13412452222','','','','','',0,'','2016-07-03 14:48:25'),(3,3,'www.TE5L.com','张三','13412452222','','','','','',0,'','2016-07-03 14:48:25'),(4,4,'www.TE5L.com','张三','13412452222','','','','','',0,'','2016-07-03 14:48:25'),(5,5,'www.TE5L.com','张三','13412452222','','','','','',0,'','2016-07-03 14:48:25'),(6,6,'www.TE5L.com','张三','13412452222','','','','','',0,'','2016-07-03 14:48:25'),(7,7,'www.TE5L.com','张三','13412452222','','','','','',0,'','2016-07-03 14:48:25'),(8,8,'www.TE5L.com','张三','13412452222','','','','','',0,'','2016-07-03 14:48:25'),(9,9,'www.TE5L.com','张三','13412452222','','','','','',0,'','2016-07-03 14:48:25'),(10,10,'www.TE5L.com','张三','13412452222','','','','','',0,'','2016-07-03 14:48:25'),(11,11,'www.TE5L.com','张三','13412452222','','','','','',0,'','2016-07-03 14:48:25'),(12,12,'www.TE5L.com','张三','13412452222','','','','','',0,'','2016-07-03 14:48:25'),(13,13,'www.TE5L.com','张三','13412452222','','','','','',0,'','2016-07-03 14:48:25'),(14,14,'www.TE5L.com','张三','13412452222','','','','','',0,'','2016-07-03 14:48:25'),(15,15,'www.TE5L.com','张三','13412452222','','','','','',0,'','2016-07-03 14:48:25'),(16,16,'www.TE5L.com','张三','13412452222','','','','','',0,'','2016-07-03 14:48:25'),(17,17,'www.TE5L.com','张三','13412452222','','','','','',0,'','2016-07-03 14:48:25'),(18,18,'www.TE5L.com','张三','13412452222','','','','','',0,'','2016-07-03 14:48:25'),(19,19,'www.TE5L.com','张三','13412452222','','','','','',0,'','2016-07-03 14:48:25'),(20,20,'www.TE5L.com','张三','13412452222','','','','','',0,'','2016-07-03 14:48:25'),(21,21,'www.TE5L.com','张三','13412452222','','','','','',0,'','2016-07-03 14:48:25'),(22,22,'www.TE5L.com','张三','13412452222','','','','','',0,'','2016-07-03 14:48:25'),(23,23,'www.TE5L.com','张三','13412452222','','','','','',0,'','2016-07-03 14:48:25'),(24,24,'www.TE5L.com','张三','13412452222','','','','','',0,'','2016-07-03 14:48:25'),(25,25,'www.TE5L.com','张三','13412452222','','','','','',0,'','2016-07-03 14:48:25'),(26,26,'www.TE5L.com','张三','13412452222','','','','','',0,'','2016-07-03 14:48:25'),(27,27,'www.TE5L.com','张三','13412452222','','','','','',0,'','2016-07-03 14:48:25'),(28,28,'www.TE5L.com','张三','13412452222','','','','','',0,'','2016-07-03 14:48:25'),(29,29,'www.TE5L.com','张三','13412452222','','','','','',0,'','2016-07-03 14:48:25'),(30,30,'www.TE5L.com','张三','13412452222','','','','','',0,'','2016-07-03 14:48:25');

UNLOCK TABLES;

/*Table structure for table `te_employees_log` */

DROP TABLE IF EXISTS `te_employees_log`;

CREATE TABLE `te_employees_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `emplId` bigint(20) DEFAULT '0' COMMENT '员工ID号',
  `type` int(2) DEFAULT '0' COMMENT '记录类型',
  `note` varchar(1024) DEFAULT NULL COMMENT '备注',
  `createTime` datetime DEFAULT NULL COMMENT '操作时间',
  `creator` varchar(128) DEFAULT NULL COMMENT '创建人',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=71 DEFAULT CHARSET=utf8;

/*Data for the table `te_employees_log` */

LOCK TABLES `te_employees_log` WRITE;

insert  into `te_employees_log`(`id`,`emplId`,`type`,`note`,`createTime`,`creator`,`timestamp`) values (1,1,1,'','2016-07-03 14:48:25','admin','2016-07-03 14:48:25'),(2,1,2,'','2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(3,2,1,'','2016-07-03 14:48:25','admin','2016-07-03 14:48:25'),(4,2,2,'','2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(5,3,1,'','2016-07-03 14:48:25','admin','2016-07-03 14:48:25'),(6,3,2,'','2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(7,4,1,'','2016-07-03 14:48:25','admin','2016-07-03 14:48:25'),(8,4,2,'','2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(9,5,1,'','2016-07-03 14:48:25','admin','2016-07-03 14:48:25'),(10,5,2,'','2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(11,6,1,'','2016-07-03 14:48:25','admin','2016-07-03 14:48:25'),(12,6,2,'','2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(13,7,1,'','2016-07-03 14:48:25','admin','2016-07-03 14:48:25'),(14,7,2,'','2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(15,8,1,'','2016-07-03 14:48:25','admin','2016-07-03 14:48:25'),(16,8,2,'','2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(17,9,1,'','2016-07-03 14:48:25','admin','2016-07-03 14:48:25'),(18,9,2,'','2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(19,10,1,'','2016-07-03 14:48:25','admin','2016-07-03 14:48:25'),(20,10,2,'','2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(21,11,1,'','2016-07-03 14:48:25','admin','2016-07-03 14:48:25'),(22,11,2,'','2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(23,12,1,'','2016-07-03 14:48:25','admin','2016-07-03 14:48:25'),(24,12,2,'','2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(25,13,1,'','2016-07-03 14:48:25','admin','2016-07-03 14:48:25'),(26,13,2,'','2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(27,14,1,'','2016-07-03 14:48:25','admin','2016-07-03 14:48:25'),(28,14,2,'','2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(29,15,1,'','2016-07-03 14:48:25','admin','2016-07-03 14:48:25'),(30,15,2,'','2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(31,16,1,'','2016-07-03 14:48:25','admin','2016-07-03 14:48:25'),(32,16,2,'','2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(33,17,1,'','2016-07-03 14:48:25','admin','2016-07-03 14:48:25'),(34,17,2,'','2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(35,18,1,'','2016-07-03 14:48:25','admin','2016-07-03 14:48:25'),(36,18,2,'','2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(37,19,1,'','2016-07-03 14:48:25','admin','2016-07-03 14:48:25'),(38,19,2,'','2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(39,20,1,'','2016-07-03 14:48:25','admin','2016-07-03 14:48:25'),(40,20,2,'','2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(41,21,1,'','2016-07-03 14:48:25','admin','2016-07-03 14:48:25'),(42,21,2,'','2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(43,22,1,'','2016-07-03 14:48:25','admin','2016-07-03 14:48:25'),(44,22,2,'','2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(45,23,1,'','2016-07-03 14:48:25','admin','2016-07-03 14:48:25'),(46,23,2,'','2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(47,24,1,'','2016-07-03 14:48:25','admin','2016-07-03 14:48:25'),(48,24,2,'','2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(49,25,1,'','2016-07-03 14:48:25','admin','2016-07-03 14:48:25'),(50,25,2,'','2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(51,26,1,'','2016-07-03 14:48:25','admin','2016-07-03 14:48:25'),(52,26,2,'','2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(53,27,1,'','2016-07-03 14:48:25','admin','2016-07-03 14:48:25'),(54,27,2,'','2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(55,28,1,'','2016-07-03 14:48:25','admin','2016-07-03 14:48:25'),(56,28,2,'','2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(57,29,1,'','2016-07-03 14:48:25','admin','2016-07-03 14:48:25'),(58,29,2,'','2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(59,30,1,'','2016-07-03 14:48:25','admin','2016-07-03 14:48:25'),(60,30,2,'','2016-07-03 14:48:48','admin','2016-07-03 14:48:48'),(61,30,2,'','2016-07-03 15:05:17','admin','2016-07-03 15:05:17'),(62,29,3,'','2016-07-03 15:05:49','admin','2016-07-03 15:05:49'),(63,22,3,'','2016-07-03 15:06:11','admin','2016-07-03 15:06:11'),(64,17,3,'','2016-07-03 15:06:22','admin','2016-07-03 15:06:22'),(65,20,4,'实习期间表现极差','2016-07-03 15:06:36','admin','2016-07-03 15:06:36'),(66,23,4,'实习期间表现极差','2016-07-03 15:06:39','admin','2016-07-03 15:06:39'),(67,3,4,'实习期间表现极差','2016-07-03 15:06:43','admin','2016-07-03 15:06:43'),(68,8,4,'实习期间表现极差','2016-07-03 15:06:47','admin','2016-07-03 15:06:47'),(69,5,4,'实习期间表现极差','2016-07-03 15:06:50','admin','2016-07-03 15:06:50'),(70,29,2,'','2016-07-03 15:11:32','admin','2016-07-03 15:11:32');

UNLOCK TABLES;

/*Table structure for table `te_employees_training_log` */

DROP TABLE IF EXISTS `te_employees_training_log`;

CREATE TABLE `te_employees_training_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `state` int(2) DEFAULT NULL COMMENT '培训记录状态',
  `emplId` bigint(20) DEFAULT '0' COMMENT '员工ID',
  `trainingItemId` bigint(20) DEFAULT '0' COMMENT '培训项目ID',
  `applyTime` varchar(12) DEFAULT NULL COMMENT '报名时间',
  `note` varchar(1024) DEFAULT NULL COMMENT '备注',
  `createTime` datetime DEFAULT NULL COMMENT '记录创建时间',
  `creator` varchar(128) DEFAULT NULL COMMENT '创建者',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

/*Data for the table `te_employees_training_log` */

LOCK TABLES `te_employees_training_log` WRITE;

insert  into `te_employees_training_log`(`id`,`state`,`emplId`,`trainingItemId`,`applyTime`,`note`,`createTime`,`creator`,`timestamp`) values (1,1,27,3,'2016-07-03','','2016-07-03 15:09:35','admin','2016-07-03 15:09:35'),(2,1,29,3,'2016-07-03','','2016-07-03 15:09:36','admin','2016-07-03 15:09:36'),(3,1,23,3,'2016-07-03','','2016-07-03 15:09:37','admin','2016-07-03 15:09:37'),(4,1,26,1,'2016-07-03','','2016-07-03 15:09:47','admin','2016-07-03 15:09:47'),(5,1,27,1,'2016-07-03','','2016-07-03 15:09:48','admin','2016-07-03 15:09:48'),(6,1,23,1,'2016-07-03','','2016-07-03 15:09:49','admin','2016-07-03 15:09:49'),(7,1,30,1,'2016-07-03','','2016-07-03 15:09:51','admin','2016-07-03 15:09:51'),(8,1,10,1,'2016-07-03','','2016-07-03 15:09:53','admin','2016-07-03 15:09:53');

UNLOCK TABLES;

/*Table structure for table `te_module` */

DROP TABLE IF EXISTS `te_module`;

CREATE TABLE `te_module` (
  `moduleId` bigint(20) NOT NULL AUTO_INCREMENT,
  `moduleName` varchar(64) DEFAULT NULL COMMENT '模块名称',
  `moduleCode` varchar(12) DEFAULT '0' COMMENT '模块编号',
  `moduleSuperCode` varchar(12) DEFAULT NULL,
  `modulePage` varchar(128) DEFAULT NULL,
  `moduleLevel` int(1) DEFAULT '0' COMMENT '等级',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`moduleId`),
  UNIQUE KEY `moduleCode` (`moduleCode`),
  UNIQUE KEY `moduleName` (`moduleName`),
  UNIQUE KEY `modulePage` (`modulePage`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;

/*Data for the table `te_module` */

LOCK TABLES `te_module` WRITE;

insert  into `te_module`(`moduleId`,`moduleName`,`moduleCode`,`moduleSuperCode`,`modulePage`,`moduleLevel`,`timestamp`) values (1,'员工信息管理','01','0',NULL,0,'2015-09-03 22:09:32'),(2,'实习员工','01001','01','employees_internship.html',1,'2015-09-05 18:25:42'),(3,'正式员工','01002','01','employees_formal.html',1,'2015-09-05 23:39:30'),(4,'培训项目','01003','01','employees_training.html',1,'2015-09-05 23:39:31'),(5,'离职员工','01004','01','employees_departure.html',1,'2015-09-05 23:39:33'),(6,'考勤及薪酬','02','0',NULL,0,'2015-09-03 22:16:30'),(7,'员工考勤','02001','02','employees_attendance.html',1,'2015-09-06 00:00:36'),(8,'员工薪酬','02002','02','employees_emolument.html',1,'2015-09-06 00:00:37'),(9,'部门与职位','03','0',NULL,0,'2015-09-03 22:16:42'),(10,'部门管理','03001','03','company_department.html',1,'2015-09-05 23:42:47'),(11,'职位管理','03002','03','company_position.html',1,'2015-09-05 23:42:48'),(12,'权限管理','04','0',NULL,0,'2015-09-13 11:26:50'),(13,'帐号管理','04001','04','system_account.html',1,'2015-09-13 11:27:26'),(14,'角色管理','04002','04','system_role.html',1,'2015-09-13 11:27:52');

UNLOCK TABLES;

/*Table structure for table `te_position` */

DROP TABLE IF EXISTS `te_position`;

CREATE TABLE `te_position` (
  `poId` bigint(20) NOT NULL AUTO_INCREMENT,
  `poDepartment` bigint(20) DEFAULT NULL,
  `poName` varchar(128) DEFAULT NULL COMMENT '职位名称',
  `poDescription` varchar(1024) DEFAULT NULL COMMENT '职位简介',
  `creator` varchar(64) DEFAULT NULL COMMENT '操作人',
  `createTime` datetime DEFAULT NULL COMMENT '添加时间',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`poId`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8;

/*Data for the table `te_position` */

LOCK TABLES `te_position` WRITE;

insert  into `te_position`(`poId`,`poDepartment`,`poName`,`poDescription`,`creator`,`createTime`,`timestamp`) values (1,2,'软件工程师','软件工程师是最基本的IT软件职位，但是他做的是最重要的底层的代码编写。','admin','2016-07-03 14:29:46','2016-07-03 14:29:46'),(2,2,'软件设计师','软件设计师以前称呼为软件高级工程师','admin','2016-07-03 14:30:49','2016-07-03 14:40:49'),(3,2,'架构师','架构师主要负责系统底层的分层分类，以及系统的众多接口问题','admin','2016-07-03 14:31:13','2016-07-03 14:40:55'),(4,2,'技术经理','技术经理主要负责项目的各层次的方方面面','admin','2016-07-03 14:31:39','2016-07-03 14:31:39'),(5,2,'技术总监','制定公司的技术体系，架构设计，各类规范，形成公司自己的技术方案标准等等。','admin','2016-07-03 14:32:06','2016-07-03 14:32:06'),(6,1,'财务总监','负责整个财务的运作和公司的财务管理','admin','2016-07-03 14:33:26','2016-07-03 14:33:26'),(7,1,'财务经理','负责公司的整个财务经营状况','admin','2016-07-03 14:33:45','2016-07-03 14:33:45'),(8,1,'财务副经理','协助财务经理工作','admin','2016-07-03 14:33:56','2016-07-03 14:33:56'),(9,1,'财务主管','负责总账等主要财务工作','admin','2016-07-03 14:34:08','2016-07-03 14:34:08'),(10,1,'会计','应收会计、应付会计、材料会计、成本会计、税务会计、费用会计等等','admin','2016-07-03 14:34:24','2016-07-03 14:40:01'),(11,1,'出纳','负责现金和银行的日记账','admin','2016-07-03 14:34:41','2016-07-03 14:34:41'),(12,4,'行政主管','行政负责单位的直接工作，人事是分管人员安排，档案和人力资源的有效利用。','admin','2016-07-03 14:38:19','2016-07-03 14:39:52'),(13,4,'行政经理','计划、指导和协调机构的支持性服务。','admin','2016-07-03 14:38:39','2016-07-03 14:40:27'),(14,5,'人事部总监','定期与相关部门经理/总监审核并修订公司的组织结构图和人员编制','admin','2016-07-03 14:39:19','2016-07-03 14:41:32'),(15,5,'人事部经理','组织并督促部门人员全面完成本部职责范围内各项工作任务;','admin','2016-07-03 14:39:29','2016-07-03 14:42:02'),(16,5,'人事部主管','负责人事工作制度的制定与完善','admin','2016-07-03 14:39:39','2016-07-03 14:42:23'),(17,6,'采购部部长','负责部门的相关方案拟定、检查、监督、控制与执行。','admin','2016-07-03 14:43:40','2016-07-03 14:43:40'),(18,6,'采购部经理','负责汇总设计部的申请采购，编制采购计划，经过采购总监的审核后组织实施;','admin','2016-07-03 14:44:21','2016-07-03 14:44:28');

UNLOCK TABLES;

/*Table structure for table `te_province` */

DROP TABLE IF EXISTS `te_province`;

CREATE TABLE `te_province` (
  `provinceId` bigint(11) NOT NULL AUTO_INCREMENT,
  `provinceName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `provinceCode` varchar(3) COLLATE utf8_unicode_ci NOT NULL,
  `language` varchar(12) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`provinceId`),
  KEY `stateId` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `te_province` */

LOCK TABLES `te_province` WRITE;

insert  into `te_province`(`provinceId`,`provinceName`,`provinceCode`,`language`) values (1,'北京市','11','zh'),(2,'天津市','12','zh'),(3,'河北省','13','zh'),(4,'山西','14','zh'),(5,'内蒙古自治区','15','zh'),(6,'辽宁省','21','zh'),(7,'吉林省','22','zh'),(8,'黑龙江省','23','zh'),(9,'上海市','31','zh'),(10,'江苏省','32','zh'),(11,'浙江省','33','zh'),(12,'安徽省','34','zh'),(13,'福建省','35','zh'),(14,'江西省','36','zh'),(15,'山东省','37','zh'),(16,'河南省','41','zh'),(17,'湖北省','42','zh'),(18,'湖南省','43','zh'),(19,'广东省','44','zh'),(20,'广西壮族自治区','45','zh'),(21,'海南省','46','zh'),(22,'重庆市','50','zh'),(23,'四川省','51','zh'),(24,'贵州省','52','zh'),(25,'云南省','53','zh'),(26,'西藏自治区','54','zh'),(27,'陕西省','61','zh'),(28,'甘肃省','62','zh'),(29,'青海省','63','zh'),(30,'宁夏回族自治区','64','zh'),(31,'新疆维吾尔自治区','65','zh'),(32,'台湾','71','zh'),(33,'香港特别行政区','81','zh'),(34,'澳门特别行政区','82','zh');

UNLOCK TABLES;

/*Table structure for table `te_role` */

DROP TABLE IF EXISTS `te_role`;

CREATE TABLE `te_role` (
  `roleId` bigint(20) NOT NULL AUTO_INCREMENT,
  `roleName` varchar(128) DEFAULT NULL COMMENT '角色名称',
  `roleDescription` varchar(1024) DEFAULT NULL,
  `roleLabel` varchar(64) DEFAULT NULL COMMENT '角色唯一标识',
  `createTime` datetime DEFAULT NULL,
  `creator` varchar(64) DEFAULT NULL COMMENT '创建人',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`roleId`),
  UNIQUE KEY `roleLabel` (`roleLabel`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8;

/*Data for the table `te_role` */

LOCK TABLES `te_role` WRITE;

insert  into `te_role`(`roleId`,`roleName`,`roleDescription`,`roleLabel`,`createTime`,`creator`,`timestamp`) values (21,'TE5L.COM 管理员','管理员角色,  拥有系统所有权限','09b5320a-b337-4240-86fc-f260fb343b2d','2016-07-03 14:06:09','admin','2016-07-03 14:06:09'),(22,'TE5L.COM 部门与职位管理员','TE5L.COM 部门与职位管理员, 只能使用部门与职位模块','9251431b-7451-4f92-86e0-b3cae977046a','2016-07-03 14:09:09','admin','2016-07-03 14:09:27');

UNLOCK TABLES;

/*Table structure for table `te_role_module` */

DROP TABLE IF EXISTS `te_role_module`;

CREATE TABLE `te_role_module` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `roleLabel` varchar(64) DEFAULT NULL COMMENT '唯一角色标识',
  `moduleCode` varchar(12) DEFAULT NULL,
  `mosuleSuperCode` varchar(12) DEFAULT NULL COMMENT '上级',
  `finds` tinyint(1) DEFAULT '0',
  `adds` tinyint(1) DEFAULT '0',
  `deletes` tinyint(1) DEFAULT '0',
  `modifys` tinyint(1) DEFAULT '0',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

/*Data for the table `te_role_module` */

LOCK TABLES `te_role_module` WRITE;

insert  into `te_role_module`(`id`,`roleLabel`,`moduleCode`,`mosuleSuperCode`,`finds`,`adds`,`deletes`,`modifys`,`timestamp`) values (1,'09b5320a-b337-4240-86fc-f260fb343b2d','04002','04',1,1,1,1,'2016-07-03 14:06:14'),(2,'09b5320a-b337-4240-86fc-f260fb343b2d','04001','04',1,1,1,1,'2016-07-03 14:06:15'),(3,'09b5320a-b337-4240-86fc-f260fb343b2d','03002','03',1,1,1,1,'2016-07-03 14:06:18'),(4,'09b5320a-b337-4240-86fc-f260fb343b2d','03001','03',1,1,1,1,'2016-07-03 14:06:18'),(5,'09b5320a-b337-4240-86fc-f260fb343b2d','02002','02',1,1,1,1,'2016-07-03 14:06:21'),(6,'09b5320a-b337-4240-86fc-f260fb343b2d','02001','02',1,1,1,1,'2016-07-03 14:06:22'),(7,'09b5320a-b337-4240-86fc-f260fb343b2d','01003','01',1,1,1,1,'2016-07-03 14:06:29'),(8,'09b5320a-b337-4240-86fc-f260fb343b2d','01004','01',1,1,1,1,'2016-07-03 14:06:30'),(9,'09b5320a-b337-4240-86fc-f260fb343b2d','01001','01',1,1,1,1,'2016-07-03 14:06:30'),(10,'09b5320a-b337-4240-86fc-f260fb343b2d','01002','01',1,1,1,1,'2016-07-03 14:06:29'),(11,'9251431b-7451-4f92-86e0-b3cae977046a','03002','03',1,1,1,1,'2016-07-03 14:09:35'),(12,'9251431b-7451-4f92-86e0-b3cae977046a','03001','03',1,1,1,1,'2016-07-03 14:09:34');

UNLOCK TABLES;

/*Table structure for table `te_township` */

DROP TABLE IF EXISTS `te_township`;

CREATE TABLE `te_township` (
  `townshipId` bigint(11) NOT NULL,
  `townshipName` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `townshipCode` varchar(3) COLLATE utf8_unicode_ci NOT NULL,
  `countyId` bigint(11) NOT NULL,
  PRIMARY KEY (`townshipId`),
  KEY `countyId` (`countyId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*Data for the table `te_township` */

LOCK TABLES `te_township` WRITE;

insert  into `te_township`(`townshipId`,`townshipName`,`townshipCode`,`countyId`) values (1,'东华门街道办事处','001',1),(2,'景山街道办事处','002',1),(3,'交道口街道办事处','003',1),(4,'安定门街道办事处','004',1),(5,'北新桥街道办事处','005',1),(6,'东四街道办事处','006',1),(7,'朝阳门街道办事处','007',1),(8,'建国门街道办事处','008',1),(9,'东直门街道办事处','009',1),(10,'和平里街道办事处','010',1),(11,'西长安街街道办事处','001',2),(12,'新街口街道办事处','003',2),(13,'月坛街道办事处','007',2),(14,'展览路街道办事处','009',2),(15,'德胜街道办事处','010',2),(16,'金融街街道办事处','011',2),(17,'什刹海街道办事处','012',2),(18,'前门街道办事处','001',3),(19,'崇文门外街道办事处','002',3),(20,'东花市街道办事处','003',3),(21,'龙潭街道办事处','004',3),(22,'体育馆路街道办事处','005',3),(23,'天坛街道办事处','006',3),(24,'永定门外街道办事处','007',3),(25,'大栅栏街道办事处','001',4),(26,'天桥街道办事处','002',4),(27,'椿树街道办事处','003',4),(28,'陶然亭街道办事处','004',4),(29,'广安门内街道办事处','005',4),(30,'牛街街道办事处','006',4),(31,'白纸坊街道办事处','007',4),(32,'广安门外街道办事处','008',4),(33,'建外街道办事处','001',5),(34,'朝外街道办事处','002',5),(35,'呼家楼街道办事处','003',5),(36,'三里屯街道办事处','004',5),(37,'左家庄街道办事处','005',5),(38,'香河园街道办事处','006',5),(39,'和平街街道办事处','007',5),(40,'安贞街道办事处','008',5),(41,'亚运村街道办事处','009',5),(42,'小关街道办事处','010',5),(43,'酒仙桥街道办事处','011',5),(44,'麦子店街道办事处','012',5),(45,'团结湖街道办事处','013',5),(46,'六里屯街道办事处','014',5),(47,'八里庄街道办事处','015',5),(48,'双井街道办事处','016',5),(49,'劲松街道办事处','017',5),(50,'潘家园街道办事处','018',5),(51,'垡头街道办事处','019',5),(52,'南磨房地区办事处','021',5),(53,'高碑店地区办事处','022',5),(54,'将台地区办事处','023',5),(55,'太阳宫地区办事处','024',5),(56,'大屯街道办事处','025',5),(57,'望京街道办事处','026',5),(58,'小红门地区办事处','027',5),(59,'十八里店地区办事处','028',5),(60,'平房地区办事处','029',5),(61,'东风地区办事处','030',5),(62,'奥运村地区办事处','031',5),(63,'来广营地区办事处','032',5),(64,'常营回族地区办事处','033',5),(65,'三间房地区办事处','034',5),(66,'管庄地区办事处','035',5),(67,'金盏地区办事处','036',5),(68,'孙河地区办事处','037',5),(69,'崔各庄地区办事处','038',5),(70,'东坝地区办事处','039',5),(71,'黑庄户地区办事处','040',5),(72,'豆各庄地区办事处','041',5),(73,'王四营地区办事处','042',5),(74,'首都机场街道办事处','400',5),(75,'望京开发街道办事处','501',5),(76,'右安门街道办事处','001',6),(77,'太平桥街道办事处','002',6),(78,'西罗园街道办事处','003',6),(79,'大红门街道办事处','004',6),(80,'南苑街道办事处','005',6),(81,'东高地街道办事处','006',6),(82,'东铁匠营街道办事处','007',6),(83,'卢沟桥街道办事处','008',6),(84,'丰台街道办事处','009',6),(85,'新村街道办事处','010',6),(86,'长辛店街道办事处','011',6),(87,'云岗街道办事处','012',6),(88,'方庄地区办事处','013',6),(89,'宛平城地区办事处','014',6),(90,'马家堡街道办事处','015',6),(91,'和义街道办事处','016',6),(92,'长辛店镇','100',6),(93,'王佐镇','101',6),(94,'卢沟桥乡','201',6),(95,'花乡','202',6),(96,'南苑乡','203',6),(97,'八宝山街道办事处','001',7),(98,'老山街道办事处','002',7),(99,'八角街道办事处','003',7),(100,'古城街道办事处','004',7),(101,'苹果园街道办事处','005',7),(102,'金顶街街道办事处','006',7),(103,'广宁街道办事处','009',7),(104,'五里坨街道办事处','010',7),(105,'鲁谷社区行政事务管理中心','011',7),(106,'万寿路街道办事处','001',8),(107,'永定路街道办事处','002',8),(108,'羊坊店街道办事处','003',8),(109,'甘家口街道办事处','004',8),(110,'八里庄街道办事处','005',8),(111,'紫竹院街道办事处','006',8),(112,'北下关街道办事处','007',8),(113,'北太平庄街道办事处','008',8),(114,'学院路街道办事处','010',8),(115,'中关村街道办事处','011',8),(116,'海淀街道办事处','012',8),(117,'青龙桥街道办事处','013',8),(118,'清华园街道办事处','014',8),(119,'燕园街道办事处','015',8),(120,'香山街道办事处','016',8),(121,'清河街道办事处','017',8),(122,'花园路街道办事处','018',8),(123,'西三旗街道办事处','019',8),(124,'马连洼街道办事处','020',8),(125,'田村路街道办事处','021',8),(126,'上地街道办事处','022',8),(127,'万柳地区办事处','023',8),(128,'东升地区办事处','024',8),(129,'曙光街道办事处','025',8),(130,'温泉镇','101',8),(131,'四季青镇','102',8),(132,'西北旺镇','103',8),(133,'苏家坨镇','104',8),(134,'上庄镇','105',8),(135,'大峪街道办事处','001',9),(136,'城子街道办事处','002',9),(137,'东辛房街道办事处','003',9),(138,'大台街道办事处','004',9),(139,'王平地区办事处','005',9),(140,'潭柘寺镇','101',9),(141,'永定镇','102',9),(142,'龙泉镇','103',9),(143,'军庄镇','104',9),(144,'雁翅镇','105',9),(145,'斋堂镇','106',9),(146,'清水镇','107',9),(147,'妙峰山镇','108',9),(148,'城关街道办事处','001',10),(149,'新镇街道办事处','002',10),(150,'向阳街道办事处','004',10),(151,'东风街道办事处','005',10),(152,'迎风街道办事处','006',10),(153,'星城街道办事处','007',10),(154,'良乡地区办事处','008',10),(155,'周口店地区办事处','009',10),(156,'琉璃河地区办事处','010',10),(157,'拱辰街道办事处','011',10),(158,'西潞街道办事处','012',10),(159,'阎村镇','101',10),(160,'窦店镇','103',10),(161,'石楼镇','104',10),(162,'长阳镇','105',10),(163,'河北镇','107',10),(164,'长沟镇','108',10),(165,'大石窝镇','109',10),(166,'张坊镇','110',10),(167,'十渡镇','111',10),(168,'青龙湖镇','112',10),(169,'韩村河镇','115',10),(170,'霞云岭乡','208',10),(171,'南窖乡','209',10),(172,'佛子庄乡','210',10),(173,'大安山乡','211',10),(174,'史家营乡','212',10),(175,'蒲洼乡','213',10),(176,'中仓街道办事处','001',11),(177,'新华街道办事处','002',11),(178,'北苑街道办事处','003',11),(179,'玉桥街道办事处','004',11),(180,'永顺地区办事处','005',11),(181,'梨园地区办事处','006',11),(182,'宋庄镇','104',11),(183,'张家湾镇','105',11),(184,'马驹桥镇','109',11),(185,'西集镇','110',11),(186,'台湖镇','114',11),(187,'永乐店镇','117',11),(188,'潞城镇','119',11),(189,'于家务回族乡','209',11),(190,'胜利街道办事处','001',12),(191,'光明街道办事处','002',12),(192,'仁和地区办事处','003',12),(193,'后沙峪地区办事处','004',12),(194,'天竺地区办事处','005',12),(195,'杨镇地区办事处','006',12),(196,'牛栏山地区办事处','007',12),(197,'南法信地区办事处','008',12),(198,'马坡地区办事处','009',12),(199,'石园街道办事处','010',12),(200,'高丽营镇','101',12),(201,'李桥镇','104',12),(202,'李遂镇','105',12),(203,'南彩镇','106',12),(204,'北务镇','108',12),(205,'大孙各庄镇','109',12),(206,'张镇','110',12),(207,'龙湾屯镇','111',12),(208,'木林镇','112',12),(209,'北小营镇','113',12),(210,'北石槽镇','115',12),(211,'赵全营镇','116',12),(212,'城北街道办事处','001',13),(213,'南口地区办事处','002',13),(214,'马池口地区办事处','003',13),(215,'沙河地区办事处','004',13),(216,'城南街道办事处','005',13),(217,'回龙观地区办事处','006',13),(218,'东小口地区办事处','007',13),(219,'阳坊镇','104',13),(220,'小汤山镇','110',13),(221,'南邵镇','111',13),(222,'崔村镇','112',13),(223,'百善镇','113',13),(224,'北七家镇','115',13),(225,'兴寿镇','116',13),(226,'长陵镇','117',13),(227,'流村镇','118',13),(228,'十三陵镇','119',13),(229,'兴丰街道办事处','001',14),(230,'林校路街道办事处','002',14),(231,'清源街道办事处','003',14),(232,'亦庄地区办事处','004',14),(233,'黄村地区办事处','005',14),(234,'旧宫地区办事处','006',14),(235,'西红门地区办事处','007',14),(236,'青云店镇','103',14),(237,'采育镇','104',14),(238,'安定镇','105',14),(239,'礼贤镇','106',14),(240,'榆垡镇','107',14),(241,'庞各庄镇','108',14),(242,'北臧村镇','109',14),(243,'魏善庄镇','110',14),(244,'长子营镇','111',14),(245,'瀛海镇','112',14),(246,'亦庄开发区','403',14),(247,'泉河街道办事处','001',15),(248,'龙山街道办事处','002',15),(249,'怀柔地区办事处','003',15),(250,'雁栖地区办事处','004',15),(251,'庙城地区办事处','005',15),(252,'北房镇','102',15),(253,'杨宋镇','103',15),(254,'桥梓镇','105',15),(255,'怀北镇','106',15),(256,'汤河口镇','107',15),(257,'渤海镇','108',15),(258,'九渡河镇','109',15),(259,'琉璃庙镇','110',15),(260,'宝山镇','111',15),(261,'长哨营满族乡','211',15),(262,'喇叭沟门满族乡','213',15),(263,'滨河街道办事处','001',16),(264,'兴谷街道办事处','002',16),(265,'渔阳地区办事处','003',16),(266,'峪口地区办事处','004',16),(267,'马坊地区办事处','005',16),(268,'金海湖地区办事处','006',16),(269,'东高村镇','101',16),(270,'山东庄镇','102',16),(271,'南独乐河镇','104',16),(272,'大华山镇','105',16),(273,'夏各庄镇','106',16),(274,'马昌营镇','108',16),(275,'王辛庄镇','110',16),(276,'大兴庄镇','111',16),(277,'刘家店镇','112',16),(278,'镇罗营镇','114',16),(279,'黄松峪乡','213',16),(280,'熊儿寨乡','214',16),(281,'鼓楼街道办事处','001',17),(282,'果园街道办事处','002',17),(283,'檀营地区办事处','003',17),(284,'密云镇','100',17),(285,'溪翁庄镇','101',17),(286,'西田各庄镇','102',17),(287,'十里堡镇','103',17),(288,'河南寨镇','104',17),(289,'巨各庄镇','105',17),(290,'穆家峪镇','106',17),(291,'太师屯镇','107',17),(292,'高岭镇','108',17),(293,'不老屯镇','109',17),(294,'冯家峪镇','110',17),(295,'古北口镇','111',17),(296,'大城子镇','112',17),(297,'东邵渠镇','113',17),(298,'北庄镇','114',17),(299,'新城子镇','115',17),(300,'石城镇','116',17),(301,'延庆镇','100',18),(302,'康庄镇','101',18),(303,'八达岭镇','102',18),(304,'永宁镇','103',18),(305,'旧县镇','104',18),(306,'张山营镇','105',18),(307,'四海镇','106',18),(308,'千家店镇','107',18),(309,'沈家营镇','108',18),(310,'大榆树镇','109',18),(311,'井庄镇','110',18),(312,'大庄科乡','207',18),(313,'刘斌堡乡','209',18),(314,'香营乡','210',18),(315,'珍珠泉乡','214',18),(316,'劝业场街道','001',19),(317,'小白楼街道','002',19),(318,'体育馆街道','003',19),(319,'新兴街道','004',19),(320,'南营门社区街道','005',19),(321,'南市街道','006',19),(322,'大王庄街道','001',20),(323,'大直沽街道','002',20),(324,'中山门街道','003',20),(325,'富民路街道','004',20),(326,'二号桥街道','005',20),(327,'春华街道','006',20),(328,'唐家口街道','007',20),(329,'向阳楼街道','008',20),(330,'常州道街道','009',20),(331,'上杭路街道','010',20),(332,'东新街道','011',20),(333,'鲁山道街道','012',20),(334,'天津铁厂街道','013',20),(335,'大营门街道','001',21),(336,'下瓦房街道','002',21),(337,'桃园街道','003',21),(338,'挂甲寺街道','004',21),(339,'马场街道','005',21),(340,'越秀路街道','006',21),(341,'友谊路街道','007',21),(342,'天塔街道','008',21),(343,'尖山街道','009',21),(344,'陈塘庄街道','010',21),(345,'柳林街道','011',21),(346,'东海街道','012',21),(347,'梅江虚拟街道','400',21),(348,'长虹街道','001',22),(349,'鼓楼街道','002',22),(350,'兴南街道','003',22),(351,'广开街道','004',22),(352,'万兴街道','005',22),(353,'学府街道','006',22),(354,'向阳路街道','007',22),(355,'嘉陵道街道','008',22),(356,'王顶堤街道','009',22),(357,'水上公园街道','010',22),(358,'体育中心街道','011',22),(359,'华苑街道','012',22),(360,'光复道街道','001',23),(361,'望海楼街道','002',23),(362,'鸿顺里街道','003',23),(363,'新开河街道','004',23),(364,'铁东路街道','005',23),(365,'建昌道街道','006',23),(366,'宁园街道','007',23),(367,'王串场街道','008',23),(368,'江都路街道','009',23),(369,'月牙河街道','010',23),(370,'西于庄街道','001',24),(371,'双环村街道','002',24),(372,'咸阳北路街道','003',24),(373,'丁字沽街道','004',24),(374,'西沽街道','005',24),(375,'三条石街道','006',24),(376,'邵公庄街道','008',24),(377,'芥园街道','009',24),(378,'铃铛阁街道','010',24),(379,'大胡同街道','011',24),(380,'新村街道','001',25),(381,'解放路街道','002',25),(382,'三槐路街道','003',25),(383,'新港街道','004',25),(384,'向阳街道','005',25),(385,'杭州道街道','006',25),(386,'新河街道','007',25),(387,'大沽街道','008',25),(388,'北塘街道','009',25),(389,'渤海石油街道','010',25),(390,'胡家园街道','011',25),(391,'新城镇','100',25),(392,'开发区虚拟街道','400',25),(393,'保税区虚拟街道','401',25),(394,'汉沽街道','001',26),(395,'寨上街道','002',26),(396,'河西街道','003',26),(397,'盐场街道','005',26),(398,'大田镇','100',26),(399,'杨家泊镇','101',26),(400,'茶淀镇','102',26),(401,'营城镇','103',26),(402,'开发区汉沽化工小区虚拟街道','400',26),(403,'迎宾街道','001',27),(404,'胜利街道','002',27),(405,'古林街道','003',27),(406,'海滨街道','004',27),(407,'港西街道','005',27),(408,'太平镇','100',27),(409,'小王庄镇','101',27),(410,'中塘镇','102',27),(411,'北大港农场虚拟镇','450',27),(412,'张贵庄街道','001',28),(413,'丰年村街道','002',28),(414,'万新街道','003',28),(415,'无瑕街道','004',28),(416,'新立街道','005',28),(417,'华明街道','006',28),(418,'军粮城镇','102',28),(419,'大毕庄镇','105',28),(420,'么六桥乡','200',28),(421,'开发区西区虚拟街道','400',28),(422,'保税区空港国际物流区虚拟街道','401',28),(423,'保税区空港国际物流加工区虚拟街道','402',28),(424,'东丽区开发区虚拟街道','403',28),(425,'东丽湖虚拟街道','404',28),(426,'西营门街道','001',29),(427,'李七庄街道','002',29),(428,'中北镇','100',29),(429,'杨柳青镇','101',29),(430,'辛口镇','102',29),(431,'张家窝镇','103',29),(432,'南河镇','104',29),(433,'大寺镇','105',29),(434,'王稳庄镇','106',29),(435,'开发区西青微电子小区虚拟街道','400',29),(436,'新技术产业园区虚拟街','401',29),(437,'西青区开发区虚拟街道','450',29),(438,'咸水沽镇','100',30),(439,'葛沽镇','101',30),(440,'小站镇','102',30),(441,'双港镇','103',30),(442,'辛庄镇','104',30),(443,'双桥河镇','106',30),(444,'八里台镇','107',30),(445,'北闸口镇','108',30),(446,'双林农场虚拟街','400',30),(447,'铁路十八局虚拟街','401',30),(448,'津南国家农业园区虚拟街','402',30),(449,'长青办事处虚拟街','403',30),(450,'津南开发区东区虚拟居街','404',30),(451,'津南开发区西区虚拟居街','405',30),(452,'果园新村街道','001',31),(453,'集贤里街道','002',31),(454,'普东街道','003',31),(455,'佳荣里街道','004',31),(456,'天穆镇','100',31),(457,'北仓镇','101',31),(458,'双街镇','102',31),(459,'双口镇','103',31),(460,'青光镇','104',31),(461,'宜兴埠镇','106',31),(462,'小淀镇','107',31),(463,'大张庄镇','108',31),(464,'西堤头镇','111',31),(465,'红旗农场','451',31),(466,'曙光农场','452',31),(467,'杨村街道','001',32),(468,'下朱庄街道','002',32),(469,'东蒲洼街道','003',32),(470,'黄庄街道','004',32),(471,'徐官屯街道','005',32),(472,'运河西街道','006',32),(473,'梅厂镇','101',32),(474,'大碱厂镇','102',32),(475,'崔黄口镇','103',32),(476,'大良镇','104',32),(477,'下伍旗镇','105',32),(478,'南蔡村镇','106',32),(479,'大孟庄镇','107',32),(480,'泗村店镇','108',32),(481,'河西务镇','109',32),(482,'城关镇','110',32),(483,'东马圈镇','111',32),(484,'黄花店镇','112',32),(485,'石各庄镇','113',32),(486,'王庆坨镇','114',32),(487,'汊沽港镇','115',32),(488,'河北屯镇','116',32),(489,'上马台镇','117',32),(490,'大王古庄镇','118',32),(491,'陈咀镇','119',32),(492,'豆张庄乡','203',32),(493,'曹子里乡','206',32),(494,'大黄堡乡','207',32),(495,'高村乡','213',32),(496,'白古屯乡','214',32),(497,'开发区武清逸仙园小区虚拟街道','400',32),(498,'武清区开发区虚拟街道','401',32),(499,'武清农场虚拟镇','450',32),(500,'海滨街道','001',33),(501,'宝平街道','002',33),(502,'钰华街道','003',33),(503,'大口屯镇','101',33),(504,'大白庄镇','102',33),(505,'王卜庄镇','103',33),(506,'方家庄镇','104',33),(507,'林亭口镇','105',33),(508,'八门城镇','106',33),(509,'大钟庄镇','107',33),(510,'新安镇','108',33),(511,'马家店镇','110',33),(512,'霍各庄镇','111',33),(513,'新开口镇','113',33),(514,'大唐庄镇','115',33),(515,'高家庄镇','117',33),(516,'口东镇','118',33),(517,'牛道口镇','119',33),(518,'史各庄镇','120',33),(519,'郝各庄镇','121',33),(520,'周良庄镇','122',33),(521,'牛家牌乡','204',33),(522,'尔王庄乡','207',33),(523,'黄庄乡','210',33),(524,'里自沽农场虚拟镇','450',33),(525,'黄庄农场虚拟镇','451',33),(526,'大钟农场虚拟镇','452',33),(527,'天宝工业园区虚拟街','453',33),(528,'九园工业园区虚拟街','454',33),(529,'京津新城虚拟街','455',33),(530,'芦台镇','100',34),(531,'宁河镇','102',34),(532,'苗庄镇','103',34),(533,'丰台镇','104',34),(534,'岳龙镇','105',34),(535,'板桥镇','106',34),(536,'潘庄镇','107',34),(537,'造甲城镇','109',34),(538,'七里海镇','110',34),(539,'大北涧沽镇','111',34),(540,'东棘坨镇','112',34),(541,'北淮淀乡','204',34),(542,'廉庄子乡','206',34),(543,'潘庄农场虚拟镇','450',34),(544,'静海镇','100',35),(545,'唐官屯镇','101',35),(546,'独流镇','102',35),(547,'王口镇','103',35),(548,'台头镇','104',35),(549,'子牙镇','105',35),(550,'陈官屯镇','106',35),(551,'中旺镇','107',35),(552,'大邱庄镇','108',35),(553,'蔡公庄镇','109',35),(554,'梁头镇','110',35),(555,'团泊镇','111',35),(556,'双塘镇','112',35),(557,'大丰堆镇','113',35),(558,'沿庄镇','114',35),(559,'西翟庄镇','115',35),(560,'良王庄乡','200',35),(561,'杨成庄乡','201',35),(562,'天津静海经济开发区虚拟街','400',35),(563,'天津子牙工业园区虚拟街','402',35),(564,'中国石油天然气总公司地调一处虚拟街','403',35),(565,'文昌街道办事处','001',36),(566,'城关镇','100',36),(567,'洇溜镇','101',36),(568,'官庄镇','102',36),(569,'马伸桥镇','103',36),(570,'下营镇','104',36),(571,'邦均镇','105',36),(572,'别山镇','106',36),(573,'尤古庄镇','108',36),(574,'上仓镇','109',36),(575,'下仓镇','111',36),(576,'罗庄子镇','112',36),(577,'白涧镇','113',36),(578,'五百户镇','114',36),(579,'侯家营镇','115',36),(580,'桑梓镇','116',36),(581,'东施古镇','117',36),(582,'下窝头镇','118',36),(583,'杨津庄镇','119',36),(584,'出头岭镇','120',36),(585,'西龙虎峪镇','121',36),(586,'穿芳峪乡','202',36),(587,'孙各庄乡','203',36),(588,'东二营乡','208',36),(589,'许家台乡','210',36),(590,'礼明庄乡','212',36),(591,'东赵各庄乡','219',36),(592,'建北街道办事处','001',38),(593,'青园街道办事处','002',38),(594,'广安街道办事处','003',38),(595,'育才街道办事处','004',38),(596,'跃进街道办事处','005',38),(597,'河东街道办事处','007',38),(598,'长丰街道办事处','010',38),(599,'谈固街道办事处','011',38),(600,'西兆通镇','100',38),(601,'南村镇','101',38),(602,'高营镇','102',38),(603,'中山东路街道办事处','001',39),(604,'彭后街道办事处','002',39),(605,'东风街道办事处','003',39),(606,'东华街道办事处','004',39),(607,'休门街道办事处','005',39),(608,'阜康街道办事处','006',39),(609,'建安街道办事处','007',39),(610,'胜利北街道办事处','008',39),(611,'汇通街道办事处','009',39),(612,'桃园镇','101',39),(613,'东里街道办事处','001',40),(614,'中山路街道办事处','002',40),(615,'南长街道办事处','004',40),(616,'维明街道办事处','005',40),(617,'裕西街道办事处','006',40),(618,'友谊街道办事处','007',40),(619,'红旗街道办事处','008',40),(620,'新石街道办事处','009',40),(621,'苑东街道办事处','010',40),(622,'西里街道办事处','011',40),(623,'振头街道办事处','012',40),(624,'留营乡','201',40),(625,'革新街街道办事处','001',41),(626,'新华路街道办事处','003',41),(627,'宁安路街道办事处','004',41),(628,'东焦街道办事处','005',41),(629,'西苑街道办事处','006',41),(630,'合作路街道办事处','007',41),(631,'联盟路街道办事处','008',41),(632,'石岗大街街道办事处','009',41),(633,'五七路街道办事处','010',41),(634,'天苑街道办事处','011',41),(635,'北苑街道办事处','012',41),(636,'大郭镇','100',41),(637,'赵陵铺镇','101',41),(638,'西三庄乡','201',41),(639,'杜北乡','202',41),(640,'矿市街街道办事处','001',42),(641,'四微街道办事处','002',42),(642,'贾庄镇','100',42),(643,'凤山镇','101',42),(644,'横涧乡','200',42),(645,'裕兴街道办事处','001',43),(646,'裕强街道办事处','002',43),(647,'东苑街道办事处','003',43),(648,'建通街道办事处','004',43),(649,'槐底街道办事处','005',43),(650,'裕华路街道办事处','006',43),(651,'裕东街道办事处','007',43),(652,'长江街道办事处(高新区)','010',43),(653,'宋营镇','100',43),(654,'方村镇','101',43),(655,'微水镇','100',44),(656,'上安镇','101',44),(657,'天长镇','102',44),(658,'秀林镇','103',44),(659,'南峪镇','104',44),(660,'威州镇','105',44),(661,'小作镇','106',44),(662,'南障城镇','107',44),(663,'苍岩山镇','108',44),(664,'测鱼镇','109',44),(665,'吴家窑乡','200',44),(666,'北正乡','201',44),(667,'于家乡','202',44),(668,'孙庄乡','203',44),(669,'南陉乡','204',44),(670,'辛庄乡','205',44),(671,'南王庄乡','206',44),(672,'正定镇','100',45),(673,'诸福屯镇','101',45),(674,'新城铺镇','102',45),(675,'新安镇','103',45),(676,'南牛乡','200',45),(677,'南楼乡','201',45),(678,'西平乐乡','202',45),(679,'北早现乡','203',45),(680,'曲阳桥乡','204',45),(681,'栾城镇','100',46),(682,'郄马镇','101',46),(683,'冶河镇','103',46),(684,'窦妪镇','104',46),(685,'楼底镇','105',46),(686,'南高乡','200',46),(687,'柳林屯乡','201',46),(688,'西营乡','202',46),(689,'龙州镇','100',47),(690,'南桥镇','101',47),(691,'上碑镇','102',47),(692,'口头镇','103',47),(693,'独羊岗乡','200',47),(694,'安香乡','201',47),(695,'只里乡','202',47),(696,'市同乡','203',47),(697,'翟营乡','204',47),(698,'城寨乡','205',47),(699,'上方乡','206',47),(700,'玉亭乡','207',47),(701,'北河乡','208',47),(702,'上闫庄乡','209',47),(703,'九口子乡','210',47),(704,'灵寿镇','100',48),(705,'青同镇','101',48),(706,'塔上镇','102',48),(707,'陈庄镇','103',48),(708,'慈峪镇','104',48),(709,'岔头镇','105',48),(710,'三圣院乡','200',48),(711,'北洼乡','201',48),(712,'牛城乡','202',48),(713,'狗台乡','203',48),(714,'南寨乡','204',48),(715,'南燕川乡','205',48),(716,'北谭庄乡','206',48),(717,'寨头乡','207',48),(718,'南营乡','208',48),(719,'高邑镇','100',49),(720,'大营乡','200',49),(721,'中韩乡','201',49),(722,'万城乡','202',49),(723,'西富村乡','203',49),(724,'深泽镇','100',50),(725,'铁杆镇','101',50),(726,'白庄乡','200',50),(727,'留村乡','201',50),(728,'赵八乡','202',50),(729,'桥头乡','203',50),(730,'赞皇镇','100',51),(731,'院头镇','101',51),(732,'西龙门乡','200',51),(733,'南邢郭乡','201',51),(734,'南清河乡','202',51),(735,'西阳泽乡','203',51),(736,'土门乡','204',51),(737,'黄北坪乡','205',51),(738,'嶂石岩乡','206',51),(739,'许亭乡','207',51),(740,'张楞乡','208',51),(741,'无极镇','100',52),(742,'七汲镇','101',52),(743,'张段固镇','102',52),(744,'北苏镇','103',52),(745,'郭庄镇','104',52),(746,'大陈镇','105',52),(747,'高头乡','200',52),(748,'郝庄乡','201',52),(749,'东侯坊乡','202',52),(750,'里城道乡','203',52),(751,'南流乡','204',52),(752,'平山镇','100',53),(753,'东回舍镇','101',53),(754,'温塘镇','102',53),(755,'南甸镇','103',53),(756,'岗南镇','104',53),(757,'中古月镇','105',53),(758,'下槐镇','106',53),(759,'孟家庄镇','107',53),(760,'小觉镇','108',53),(761,'蛟潭庄镇','109',53),(762,'西柏坡镇','110',53),(763,'下口镇','111',53),(764,'西大吾乡','200',53),(765,'上三汲乡','201',53),(766,'两河乡','202',53),(767,'东王坡乡','203',53),(768,'苏家庄乡','204',53),(769,'宅北乡','205',53),(770,'北冶乡','207',53),(771,'上观音堂乡','209',53),(772,'杨家桥乡','210',53),(773,'营里乡','211',53),(774,'合河口乡','212',53),(775,'槐阳镇','100',54),(776,'因村镇','101',54),(777,'南佐镇','102',54),(778,'宋曹镇','103',54),(779,'南因镇','104',54),(780,'姬村镇','105',54),(781,'马村乡','200',54),(782,'东张乡','201',54),(783,'赵同乡','202',54),(784,'北褚乡','203',54),(785,'苏村乡','204',54),(786,'苏阳乡','205',54),(787,'北正乡','206',54),(788,'前仙乡','207',54),(789,'黑水河乡','208',54),(790,'赵州镇','100',55),(791,'范庄镇','101',55),(792,'北王里镇','102',55),(793,'新寨店镇','103',55),(794,'韩村镇','104',55),(795,'南柏舍镇','105',55),(796,'沙河店镇','106',55),(797,'前大章乡','200',55),(798,'谢庄乡','201',55),(799,'高村乡','202',55),(800,'王西章乡','203',55),(801,'辛集镇','100',56),(802,'旧城镇','101',56),(803,'张古庄镇','102',56),(804,'位伯镇','103',56),(805,'新垒头镇','104',56),(806,'新城镇','105',56),(807,'南智丘镇','106',56),(808,'王口镇','107',56),(809,'天宫营乡','200',56),(810,'前营乡','201',56),(811,'马庄乡','202',56),(812,'和睦井乡','203',56),(813,'田家庄乡','204',56),(814,'中里厢乡','205',56),(815,'小辛庄乡','206',56),(816,'廉州镇','100',57),(817,'兴安镇','101',57),(818,'贾市庄镇','102',57),(819,'南营镇','103',57),(820,'梅花镇','104',57),(821,'岗上镇','105',57),(822,'邱头镇','106',57),(823,'南董镇','107',57),(824,'张家庄镇','108',57),(825,'南孟镇','109',57),(826,'增村镇','110',57),(827,'小常安镇','111',57),(828,'前西关镇','112',57),(829,'九门回族乡','200',57),(830,'石家庄经济技术开发区虚拟乡','500',57),(831,'晋州镇','100',58),(832,'总十庄镇','101',58),(833,'营里镇','102',58),(834,'桃园镇','103',58),(835,'东卓宿镇','104',58),(836,'马于镇','105',58),(837,'小樵镇','106',58),(838,'槐树镇','107',58),(839,'东里庄乡','200',58),(840,'周家庄乡','201',58),(841,'长寿街道办事处','001',59),(842,'化皮镇','101',59),(843,'承安镇','102',59),(844,'正莫镇','103',59),(845,'南大岳镇','104',59),(846,'杜固镇','105',59),(847,'邯邰镇','106',59),(848,'东王镇','107',59),(849,'马头铺镇','108',59),(850,'协神乡','200',59),(851,'木村乡','201',59),(852,'彭家庄乡','202',59),(853,'获鹿镇','100',60),(854,'铜冶镇','101',60),(855,'寺家庄镇','102',60),(856,'上庄镇','103',60),(857,'李村镇','104',60),(858,'宜安镇','105',60),(859,'黄壁庄镇','106',60),(860,'大河镇','107',60),(861,'石井乡','200',60),(862,'白鹿泉乡','201',60),(863,'上寨乡','202',60),(864,'山尹村乡','203',60),(865,'高新技术产业园区虚拟乡','500',60),(866,'学院南路办事处','001',62),(867,'友谊办事处','002',62),(868,'广场办事处','003',62),(869,'永红桥街道办事处','004',62),(870,'小山街道办事处','005',62),(871,'文北办事处','006',62),(872,'钱营办事处','007',62),(873,'芦台开发区海北镇','100',62),(874,'汉沽管理区汉丰镇','101',62),(875,'女织寨乡','200',62),(876,'芦台开发区街道办事处','450',62),(877,'汉沽管理区兴农办事处','451',62),(878,'汉沽管理区振兴街道办事处','452',62),(879,'乔屯街道办事处','001',63),(880,'文化路街道办事处','002',63),(881,'钓鱼台街道办事处','003',63),(882,'东新村街道办事处','004',63),(883,'缸窑街道办事处','005',63),(884,'机场路街道办事处','006',63),(885,'河北路街道办事处','007',63),(886,'龙东街道办事处','008',63),(887,'大里街道办事处','009',63),(888,'光明街道办事处','010',63),(889,'果园乡','200',63),(890,'河北唐山高新技术产业园区','450',63),(891,'林西街道','001',64),(892,'唐家庄街道','002',64),(893,'古冶街道','003',64),(894,'赵各庄街道','004',64),(895,'吕家坨街道','005',64),(896,'南范各庄街道','006',64),(897,'卑家店乡','200',64),(898,'王辇庄乡','201',64),(899,'习家套乡','202',64),(900,'大庄坨乡','203',64),(901,'范各庄乡','204',64),(902,'马家沟办事处','001',65),(903,'开平办事处','002',65),(904,'税务庄办事处','003',65),(905,'陡电办事处','005',65),(906,'荆各庄办事处','006',65),(907,'开平镇','100',65),(908,'栗园镇','101',65),(909,'越河乡','200',65),(910,'双桥乡','201',65),(911,'郑庄子乡','202',65),(912,'洼里乡','203',65),(913,'稻地镇','102',66),(914,'小集镇','103',66),(915,'黄各庄镇','104',66),(916,'西葛镇','105',66),(917,'大新庄镇','106',66),(918,'钱营镇','107',66),(919,'唐坊镇','108',66),(920,'王兰庄镇','109',66),(921,'柳树','110',66),(922,'黑沿子镇','111',66),(923,'滨海镇','112',66),(924,'丰南镇','113',66),(925,'大齐镇','114',66),(926,'南孙庄乡','201',66),(927,'东田庄乡','202',66),(928,'尖字沽乡','203',66),(929,'河北唐山南堡经济开发区','450',66),(930,'太平路办事处','001',67),(931,'燕山路办事处','002',67),(932,'丰润镇','100',67),(933,'老庄子镇','101',67),(934,'任各庄镇','102',67),(935,'左家坞镇','103',67),(936,'泉河头镇','104',67),(937,'王官营镇','105',67),(938,'火石营镇','106',67),(939,'韩城镇','107',67),(940,'岔河镇','108',67),(941,'新军屯镇','109',67),(942,'小张各庄镇','110',67),(943,'丰登坞镇','111',67),(944,'李钊庄镇','112',67),(945,'白官屯镇','113',67),(946,'石各庄镇','114',67),(947,'沙流河镇','115',67),(948,'七树庄镇','116',67),(949,'杨官林镇','117',67),(950,'姜家营乡','202',67),(951,'欢喜庄乡','205',67),(952,'银城铺乡','207',67),(953,'刘家营乡','208',67),(954,'常庄乡','209',67),(955,'城区街道办事处','001',68),(956,'滦州镇','100',68),(957,'响堂镇','101',68),(958,'东安各庄镇','102',68),(959,'雷庄镇','103',68),(960,'茨榆坨镇','104',68),(961,'榛子镇','105',68),(962,'杨柳庄镇','106',68),(963,'油榨镇','107',68),(964,'古马镇','108',68),(965,'小马庄镇','109',68),(966,'九百户镇','110',68),(967,'王店子镇','111',68),(968,'奔城街道办事处','001',69),(969,'奔城镇','100',69),(970,'宋道口镇','101',69),(971,'长凝镇','102',69),(972,'胡各庄镇','103',69),(973,'坨里镇','104',69),(974,'姚王庄镇','105',69),(975,'司各庄镇','106',69),(976,'安各庄镇','107',69),(977,'扒齿港镇','108',69),(978,'程庄镇','109',69),(979,'青坨营镇','110',69),(980,'柏各庄镇','111',69),(981,'柳赞镇','113',69),(982,'南堡镇','114',69),(983,'方各庄镇','115',69),(984,'东黄坨镇','116',69),(985,'马城镇','117',69),(986,'城区街道办事处','001',70),(987,'乐亭镇','100',70),(988,'汤家河镇','101',70),(989,'胡家坨镇','102',70),(990,'王滩镇','103',70),(991,'闫各庄镇','104',70),(992,'马头营镇','105',70),(993,'新寨镇','106',70),(994,'汀流河镇','107',70),(995,'姜各庄镇','108',70),(996,'毛庄乡','200',70),(997,'庞各庄乡','201',70),(998,'大相各庄乡','202',70),(999,'古河乡','203',70),(1000,'中堡王庄乡','204',70),(1001,'长芦大清河盐场','450',70),(1002,'海港区','451',70),(1003,'迁西县栗乡街道办事处','001',71),(1004,'兴城镇','100',71),(1005,'金厂峪镇','101',71),(1006,'洒河桥镇','102',71),(1007,'太平寨镇','103',71),(1008,'罗家屯镇','104',71),(1009,'东荒峪镇','105',71),(1010,'新集镇','106',71),(1011,'三屯营镇','107',71),(1012,'滦阳镇','108',71),(1013,'白庙子乡','200',71),(1014,'上营乡','201',71),(1015,'汉儿庄乡','202',71),(1016,'渔户寨乡','203',71),(1017,'旧城乡','204',71),(1018,'尹庄乡','205',71),(1019,'东莲花院乡','206',71),(1020,'新庄子乡','207',71),(1021,'玉田镇','100',72),(1022,'亮甲店镇','101',72),(1023,'鸦鸿桥镇','102',72),(1024,'窝洛沽镇','103',72),(1025,'石臼窝镇','104',72),(1026,'虹桥镇','105',72),(1027,'散水头镇','106',72),(1028,'林南仓镇','107',72),(1029,'林西镇','108',72),(1030,'杨家板桥镇','109',72),(1031,'彩亭桥镇','110',72),(1032,'孤树镇','111',72),(1033,'大安镇','112',72),(1034,'唐自头镇','113',72),(1035,'郭家屯乡','200',72),(1036,'林头屯乡','201',72),(1037,'杨家套乡','202',72),(1038,'潮洛窝乡','203',72),(1039,'陈家铺乡','204',72),(1040,'郭家桥乡','205',72),(1041,'唐海镇','100',73),(1042,'一农场','401',73),(1043,'三农场','403',73),(1044,'四农场','404',73),(1045,'五农场','405',73),(1046,'六农场','406',73),(1047,'七农场','407',73),(1048,'八农场','408',73),(1049,'九农场','409',73),(1050,'十农场','410',73),(1051,'十一农场','411',73),(1052,'八里滩养殖场','412',73),(1053,'十里海养殖场','413',73),(1054,'曹妃甸工业区','451',73),(1055,'路南街道办事处','001',74),(1056,'路北街道办事处','002',74),(1057,'遵化镇','100',74),(1058,'堡子店镇','101',74),(1059,'马兰峪镇','102',74),(1060,'平安城镇','103',74),(1061,'东新庄镇','104',74),(1062,'新店子镇','105',74),(1063,'党峪镇','106',74),(1064,'地北头镇','107',74),(1065,'东旧寨镇','108',74),(1066,'铁厂镇','109',74),(1067,'苏家洼镇','110',74),(1068,'建明镇','111',74),(1069,'石门镇','112',74),(1070,'西留村乡','200',74),(1071,'崔家庄乡','201',74),(1072,'兴旺寨乡','202',74),(1073,'西下营满族乡','203',74),(1074,'汤泉满族乡','204',74),(1075,'东陵满族乡','205',74),(1076,'刘备寨乡','206',74),(1077,'团瓢庄乡','207',74),(1078,'娘娘庄乡','208',74),(1079,'西三里乡','209',74),(1080,'候家寨乡','210',74),(1081,'小厂乡','211',74),(1082,'迁安镇','100',75),(1083,'夏官营镇','101',75),(1084,'杨各庄镇','102',75),(1085,'建昌营镇','103',75),(1086,'赵店子镇','104',75),(1087,'野鸡坨镇','105',75),(1088,'大崔庄镇','106',75),(1089,'杨店子镇','107',75),(1090,'蔡园镇','108',75),(1091,'马兰庄镇','109',75),(1092,'沙河驿镇','110',75),(1093,'木厂口镇','111',75),(1094,'扣庄乡','200',75),(1095,'彭店子乡','201',75),(1096,'上射雁庄乡','202',75),(1097,'闫家店乡','203',75),(1098,'五重安乡','204',75),(1099,'大五里乡','205',75),(1100,'太平庄乡','206',75),(1101,'文化路街道办事处','001',77),(1102,'海滨路街道办事处','002',77),(1103,'北环路街道办事处','003',77),(1104,'建设大街街道办事处','004',77),(1105,'河东街道办事处','005',77),(1106,'西港路街道办事处','006',77),(1107,'燕山大街街道办事处','007',77),(1108,'港城大街街道办事处','008',77),(1109,'东环路街道办事处','009',77),(1110,'白塔岭街道办事处','010',77),(1111,'秦皇岛经济技术开发区珠江道街道办事处','011',77),(1112,'东港镇','100',77),(1113,'海港镇','101',77),(1114,'西港镇','102',77),(1115,'海阳镇','103',77),(1116,'北港镇','104',77),(1117,'秦皇岛经济技术开发区','450',77),(1118,'南关街道办事处','001',78),(1119,'东街街道办事处','002',78),(1120,'西街街道办事处','003',78),(1121,'路南街道办事处','004',78),(1122,'船厂路街道办事处','005',78),(1123,'第一关镇','100',78),(1124,'石河镇','101',78),(1125,'孟姜镇','102',78),(1126,'渤海乡','200',78),(1127,'西山街道办事处','001',79),(1128,'东山街道办事处','002',79),(1129,'海滨镇','100',79),(1130,'戴河镇','101',79),(1131,'青龙镇','100',80),(1132,'祖山镇','101',80),(1133,'木头凳镇','102',80),(1134,'双山子镇','103',80),(1135,'马圈子镇','104',80),(1136,'肖营子镇','105',80),(1137,'凤凰山乡','200',80),(1138,'龙王庙乡','201',80),(1139,'三星口乡','202',80),(1140,'干沟乡','203',80),(1141,'大巫岚乡','204',80),(1142,'土门子乡','205',80),(1143,'大石岭乡','206',80),(1144,'隔河头乡','207',80),(1145,'官场乡','208',80),(1146,'茨榆山乡','209',80),(1147,'平方子乡','210',80),(1148,'安子岭乡','211',80),(1149,'朱杖子乡','212',80),(1150,'草碾乡','213',80),(1151,'七道河乡','214',80),(1152,'八道河乡','215',80),(1153,'娄杖子乡','216',80),(1154,'三拨子乡','217',80),(1155,'凉水河乡','218',80),(1156,'昌黎镇','100',81),(1157,'靖安镇','101',81),(1158,'安山镇','102',81),(1159,'龙家店镇','103',81),(1160,'泥井镇','104',81),(1161,'大蒲河镇','105',81),(1162,'新集镇','106',81),(1163,'刘台庄镇','107',81),(1164,'茹荷镇','108',81),(1165,'朱各庄镇','109',81),(1166,'团林乡','201',81),(1167,'葛条港乡','202',81),(1168,'马坨店乡','203',81),(1169,'荒佃庄乡','204',81),(1170,'两山乡','206',81),(1171,'十里铺乡','207',81),(1172,'抚宁镇','100',82),(1173,'留守营镇','101',82),(1174,'榆关镇','102',82),(1175,'牛头崖镇','103',82),(1176,'石门寨镇','104',82),(1177,'台营镇','105',82),(1178,'大新寨镇','106',82),(1179,'驻操营镇','107',82),(1180,'茶棚乡','200',82),(1181,'杜庄乡','201',82),(1182,'深河乡','202',82),(1183,'卢龙镇','100',83),(1184,'潘庄镇','101',83),(1185,'燕河营镇','102',83),(1186,'双望镇','103',83),(1187,'刘田各庄镇','104',83),(1188,'石门镇','105',83),(1189,'下寨乡','200',83),(1190,'刘家营乡','201',83),(1191,'陈官屯乡','202',83),(1192,'印庄乡','203',83),(1193,'蛤泊乡','204',83),(1194,'木井乡','205',83),(1195,'火磨街道办事处','001',85),(1196,'陵园路街道办事处','002',85),(1197,'光明路街道办事处','003',85),(1198,'滏东街道办事处','004',85),(1199,'罗城头街道办事处','005',85),(1200,'渚河路街道办事处','006',85),(1201,'浴新南街道办事处','007',85),(1202,'农林路街道办事处','008',85),(1203,'贸东街道办事处','009',85),(1204,'贸西街道办事处','010',85),(1205,'马头镇','100',85),(1206,'北张庄镇','101',85),(1207,'马庄乡','200',85),(1208,'丛台西街道办事处','001',86),(1209,'联纺西街道办事处','002',86),(1210,'联纺东街道办事处','003',86),(1211,'光明桥街道办事处','004',86),(1212,'丛台东街道办事处','005',86),(1213,'四季青街道办事处','006',86),(1214,'和平街道办事处','007',86),(1215,'中华街道办事处','008',86),(1216,'人民路街道办事处','009',86),(1217,'柳林桥街道办事处','010',86),(1218,'苏曹乡','200',86),(1219,'胜利桥街道办事处','001',87),(1220,'百家村街道办事处','002',87),(1221,'铁路大院街道办事处','003',87),(1222,'化林路街道办事处','004',87),(1223,'庞村街道办事处','005',87),(1224,'二六七二街道办事处','006',87),(1225,'石化街道办事处','007',87),(1226,'彭家寨乡','200',87),(1227,'华北冶金建设公司','400',87),(1228,'临水镇','100',88),(1229,'峰峰镇','101',88),(1230,'新坡镇','102',88),(1231,'大社镇','103',88),(1232,'和村镇','104',88),(1233,'义井镇','105',88),(1234,'彭城镇','106',88),(1235,'界城镇','107',88),(1236,'大峪镇','108',88),(1237,'尚璧镇','100',89),(1238,'黄粱梦镇','101',89),(1239,'河沙镇镇','102',89),(1240,'户村镇','104',89),(1241,'南堡乡','200',89),(1242,'南吕固乡','201',89),(1243,'兼庄乡','202',89),(1244,'代召乡','203',89),(1245,'康庄乡','204',89),(1246,'三陵乡','205',89),(1247,'临漳镇','100',90),(1248,'南东坊镇','101',90),(1249,'孙陶集镇','102',90),(1250,'柳园镇','103',90),(1251,'称勾集镇','104',90),(1252,'狄邱乡','200',90),(1253,'张村集乡','201',90),(1254,'西羊羔乡','202',90),(1255,'香菜营乡','203',90),(1256,'杜村集乡','204',90),(1257,'章里集乡','205',90),(1258,'习文乡','206',90),(1259,'砖寨营乡','207',90),(1260,'柏鹤集乡','208',90),(1261,'成安镇','100',91),(1262,'商城镇','101',91),(1263,'漳河店镇','102',91),(1264,'李家疃镇','103',91),(1265,'辛义乡','200',91),(1266,'柏寺营乡','201',91),(1267,'道东堡乡','202',91),(1268,'北乡义乡','203',91),(1269,'长巷乡','204',91),(1270,'大名镇','100',92),(1271,'杨桥镇','101',92),(1272,'万堤镇','102',92),(1273,'龙王庙镇','103',92),(1274,'束馆镇','104',92),(1275,'金滩镇','105',92),(1276,'沙圪塔乡','200',92),(1277,'王村乡','201',92),(1278,'铺上乡','202',92),(1279,'黄金堤乡','203',92),(1280,'大街乡','204',92),(1281,'旧治乡','205',92),(1282,'西未庄乡','206',92),(1283,'孙甘店乡','207',92),(1284,'西付集乡','208',92),(1285,'埝头乡','209',92),(1286,'北峰乡','210',92),(1287,'张集乡','211',92),(1288,'红庙乡','212',92),(1289,'营镇回族乡','213',92),(1290,'涉城镇','100',93),(1291,'河南店镇','101',93),(1292,'索堡镇','102',93),(1293,'西戌镇','103',93),(1294,'井店镇','104',93),(1295,'更乐镇','105',93),(1296,'固新镇','106',93),(1297,'西达镇','107',93),(1298,'偏城镇','108',93),(1299,'神头乡','200',93),(1300,'辽城乡','201',93),(1301,'偏店乡','202',93),(1302,'龙虎乡','203',93),(1303,'木井乡','204',93),(1304,'关防乡','205',93),(1305,'合漳乡','206',93),(1306,'鹿头乡','207',93),(1307,'磁州镇','100',94),(1308,'高臾镇','101',94),(1309,'西光禄镇','102',94),(1310,'讲武城镇','103',94),(1311,'岳城镇','104',94),(1312,'观台镇','105',94),(1313,'林坦镇','106',94),(1314,'白土镇','107',94),(1315,'黄沙镇','108',94),(1316,'路村营乡','200',94),(1317,'西固义乡','201',94),(1318,'辛庄营乡','202',94),(1319,'花官营乡','203',94),(1320,'时村营乡','204',94),(1321,'南城乡','205',94),(1322,'台城乡','206',94),(1323,'陶泉乡','207',94),(1324,'都党乡','208',94),(1325,'北贾壁乡','209',94),(1326,'肥乡镇','100',95),(1327,'天台山镇','101',95),(1328,'大西韩乡','200',95),(1329,'辛安镇乡','201',95),(1330,'毛演堡乡','202',95),(1331,'元固乡','203',95),(1332,'屯庄营乡','204',95),(1333,'东漳堡乡','205',95),(1334,'旧店乡','206',95),(1335,'临','100',96),(1336,'大北汪镇','101',96),(1337,'张西堡镇','102',96),(1338,'广府镇','103',96),(1339,'南沿村镇','104',96),(1340,'永合会镇','105',96),(1341,'西苏乡','200',96),(1342,'界河店乡','201',96),(1343,'刘营乡','202',96),(1344,'刘汉乡','203',96),(1345,'正西乡','204',96),(1346,'讲武乡','205',96),(1347,'曲陌乡','206',96),(1348,'辛庄堡乡','207',96),(1349,'小龙马乡','208',96),(1350,'东杨庄乡','209',96),(1351,'小西堡乡','210',96),(1352,'西河庄乡','211',96),(1353,'姚寨乡','212',96),(1354,'西阳城乡','213',96),(1355,'新马头镇','100',97),(1356,'邱城镇','101',97),(1357,'梁二庄乡','200',97),(1358,'南辛店乡','201',97),(1359,'香城固乡','202',97),(1360,'古城营乡','203',97),(1361,'陈村回族乡','204',97),(1362,'鸡泽镇','100',98),(1363,'小寨镇','101',98),(1364,'双塔镇','102',98),(1365,'浮图店乡','200',98),(1366,'吴官营乡','201',98),(1367,'风正乡','202',98),(1368,'曹庄乡','203',98),(1369,'广平镇','100',99),(1370,'平固店镇','101',99),(1371,'双庙乡','200',99),(1372,'十里铺乡','201',99),(1373,'南韩村乡','202',99),(1374,'南阳堡乡','203',99),(1375,'东张孟乡','204',99),(1376,'馆陶镇','100',100),(1377,'房寨镇','101',100),(1378,'柴堡镇','102',100),(1379,'魏僧寨镇','103',100),(1380,'寿山寺乡','200',100),(1381,'王桥乡','201',100),(1382,'南徐村乡','202',100),(1383,'路桥乡','203',100),(1384,'魏城镇','100',101),(1385,'德政镇','101',101),(1386,'北皋镇','102',101),(1387,'双井镇','103',101),(1388,'牙里镇','104',101),(1389,'车往镇','105',101),(1390,'回隆镇','106',101),(1391,'东代固乡','200',101),(1392,'棘针寨乡','201',101),(1393,'沙口集乡','202',101),(1394,'野胡拐乡','203',101),(1395,'仕望集乡','204',101),(1396,'前大磨乡','205',101),(1397,'院堡乡','206',101),(1398,'南双庙乡','207',101),(1399,'大辛庄乡','208',101),(1400,'大马村乡','209',101),(1401,'边马乡','210',101),(1402,'张二庄乡','211',101),(1403,'北台头乡','212',101),(1404,'泊口乡','213',101),(1405,'曲周镇','100',102),(1406,'安寨镇','101',102),(1407,'侯村镇','102',102),(1408,'河南疃镇','103',102),(1409,'槐桥乡','200',102),(1410,'南里岳乡','201',102),(1411,'白寨乡','202',102),(1412,'大河道乡','203',102),(1413,'依庄乡','204',102),(1414,'第四疃乡','205',102),(1415,'武安镇','100',103),(1416,'康二城镇','101',103),(1417,'午汲镇','102',103),(1418,'磁山镇','103',103),(1419,'伯延镇','104',103),(1420,'淑村镇','105',103),(1421,'大同镇','106',103),(1422,'邑城镇','107',103),(1423,'矿山镇','108',103),(1424,'贺进镇','109',103),(1425,'阳邑镇','110',103),(1426,'徘徊镇','111',103),(1427,'冶陶镇','112',103),(1428,'上团城乡','200',103),(1429,'北安庄乡','201',103),(1430,'北安乐乡','202',103),(1431,'西土山乡','203',103),(1432,'西寺庄乡','204',103),(1433,'活水乡','205',103),(1434,'石洞乡','206',103),(1435,'管陶乡','207',103),(1436,'马家庄乡','208',103),(1437,'南长街街道办事处','001',105),(1438,'北大街街道办事处','002',105),(1439,'西大街街道办事处','003',105),(1440,'西门里街道办事处','004',105),(1441,'大梁庄乡','200',105),(1442,'东郭村乡','201',105),(1443,'市高新技术开发区','400',105),(1444,'钢铁路街道办事处','001',106),(1445,'中兴路街道办事处','002',106),(1446,'达活泉街道办事处','003',106),(1447,'张宽街道办事处','004',106),(1448,'章村街道办事处','005',106),(1449,'南大郭乡','200',106),(1450,'李村乡','201',106),(1451,'豫让桥街道','001',107),(1452,'东汪镇','100',107),(1453,'王快镇','101',107),(1454,'祝村镇','102',107),(1455,'晏家屯镇','103',107),(1456,'南石门镇','104',107),(1457,'羊范镇','105',107),(1458,'皇寺镇','106',107),(1459,'会宁镇','107',107),(1460,'西黄村镇','108',107),(1461,'路罗镇','109',107),(1462,'将军墓镇','110',107),(1463,'浆水镇','111',107),(1464,'宋家庄镇','112',107),(1465,'太子井乡','200',107),(1466,'龙泉寺乡','201',107),(1467,'北小庄乡','202',107),(1468,'城计头乡','203',107),(1469,'白岸乡','204',107),(1470,'冀家村乡','206',107),(1471,'临城镇','100',108),(1472,'东镇镇','101',108),(1473,'西竖镇','102',108),(1474,'郝庄镇','103',108),(1475,'黑城乡','200',108),(1476,'鸭鸽营乡','201',108),(1477,'石城乡','203',108),(1478,'赵庄乡','205',108),(1479,'内邱镇','100',109),(1480,'大孟村镇','101',109),(1481,'金店镇','102',109),(1482,'官庄镇','103',109),(1483,'柳林镇','104',109),(1484,'五郭店乡','200',109),(1485,'南赛乡','203',109),(1486,'獐么乡','204',109),(1487,'侯家庄乡','205',109),(1488,'柏乡镇','100',110),(1489,'固城店镇','101',110),(1490,'王家庄乡','200',110),(1491,'西汪乡','201',110),(1492,'龙华乡','202',110),(1493,'内步乡','203',110),(1494,'隆尧镇','100',111),(1495,'魏家庄镇','101',111),(1496,'尹村镇','102',111),(1497,'山口镇','103',111),(1498,'莲子镇','104',111),(1499,'固城镇','105',111),(1500,'北楼乡','200',111),(1501,'东良乡','201',111),(1502,'双碑乡','202',111),(1503,'牛家桥乡','203',111),(1504,'千户营乡','204',111),(1505,'大张庄乡','205',111),(1506,'柳行农场','400',111),(1507,'任城镇','100',112),(1508,'邢家湾镇','101',112),(1509,'辛店镇','102',112),(1510,'西固城乡','200',112),(1511,'永福庄乡','201',112),(1512,'大屯乡','202',112),(1513,'天口乡','203',112),(1514,'骆庄乡','204',112),(1515,'和阳镇','100',113),(1516,'贾宋镇','101',113),(1517,'郝桥镇','102',113),(1518,'东三召乡','200',113),(1519,'阎里乡','201',113),(1520,'河郭乡','202',113),(1521,'史召乡','203',113),(1522,'三思乡','204',113),(1523,'凤凰镇','100',114),(1524,'河渠镇','101',114),(1525,'北河庄镇','102',114),(1526,'耿庄桥镇','103',114),(1527,'东汪镇','104',114),(1528,'贾家口镇','105',114),(1529,'四芝兰镇','106',114),(1530,'大陆村镇','107',114),(1531,'苏家庄镇','108',114),(1532,'换马店镇','109',114),(1533,'侯口乡','200',114),(1534,'纪昌庄乡','202',114),(1535,'唐邱乡','203',114),(1536,'北鱼乡','205',114),(1537,'徐家河乡','206',114),(1538,'大曹庄乡','207',114),(1539,'大曹庄管理区','400',114),(1540,'巨鹿镇','100',115),(1541,'王虎寨镇','101',115),(1542,'西郭城镇','102',115),(1543,'官亭镇','103',115),(1544,'阎疃镇','104',115),(1545,'小吕寨镇','105',115),(1546,'堤村乡','200',115),(1547,'张王疃乡','201',115),(1548,'观寨乡','202',115),(1549,'苏家营乡','203',115),(1550,'新河镇','100',116),(1551,'寻寨镇','101',116),(1552,'白神首乡','200',116),(1553,'荆家庄乡','201',116),(1554,'西流乡','202',116),(1555,'仁让里乡','203',116),(1556,'广宗镇','100',117),(1557,'葫芦乡','200',117),(1558,'大平台乡','201',117),(1559,'件只乡','202',117),(1560,'核桃园乡','203',117),(1561,'东召乡','204',117),(1562,'北塘疃乡','205',117),(1563,'冯家寨乡','206',117),(1564,'丰州镇','100',118),(1565,'平乡镇','101',118),(1566,'河古庙镇','102',118),(1567,'节固乡','200',118),(1568,'油召乡','201',118),(1569,'田付村乡','202',118),(1570,'寻召乡','203',118),(1571,'名州镇','100',119),(1572,'梨元屯镇','101',119),(1573,'章台镇','102',119),(1574,'侯贯镇','103',119),(1575,'七级镇','104',119),(1576,'方家营乡','200',119),(1577,'第什营乡','201',119),(1578,'枣园乡','202',119),(1579,'固献乡','203',119),(1580,'贺钊乡','204',119),(1581,'贺营乡','205',119),(1582,'张营乡','206',119),(1583,'常屯乡','207',119),(1584,'常庄乡','208',119),(1585,'高公庄乡','209',119),(1586,'赵村乡','210',119),(1587,'葛仙庄镇','100',120),(1588,'连庄镇','101',120),(1589,'油坊镇','102',120),(1590,'谢炉镇','103',120),(1591,'王官庄镇','104',120),(1592,'坝营镇','105',120),(1593,'临西镇','100',121),(1594,'河西镇','101',121),(1595,'下堡寺镇','102',121),(1596,'尖冢镇','103',121),(1597,'东枣园乡','200',121),(1598,'老官寨乡','201',121),(1599,'吕寨乡','202',121),(1600,'摇鞍镇乡','203',121),(1601,'大刘庄乡','204',121),(1602,'凤岗街道办事处','001',122),(1603,'南杜街道办事处','002',122),(1604,'北胡街道办事处','003',122),(1605,'西丁街道办事处','004',122),(1606,'苏村镇','100',122),(1607,'大高村镇','101',122),(1608,'垂杨镇','102',122),(1609,'明化镇','103',122),(1610,'段芦头镇','104',122),(1611,'紫冢镇','105',122),(1612,'大村乡','200',122),(1613,'南便村乡','201',122),(1614,'大屯乡','202',122),(1615,'王道寨乡','203',122),(1616,'薛吴村乡','204',122),(1617,'褡裢街道办事处','001',123),(1618,'桥东街道办事处','002',123),(1619,'桥西街道办事处','003',123),(1620,'赞善街道办事处','004',123),(1621,'周庄街道办事处','005',123),(1622,'沙河城镇','100',123),(1623,'新城镇','101',123),(1624,'白塔镇','102',123),(1625,'十里亭镇','103',123),(1626,'綦村镇','104',123),(1627,'留村乡','200',123),(1628,'册井乡','201',123),(1629,'刘石岗乡','202',123),(1630,'柴关乡','203',123),(1631,'蝉房乡','204',123),(1632,'华北冶金矿山建设公司办事处','401',123),(1633,'华北冶金设备制造厂','402',123),(1634,'先锋街道办事处','001',125),(1635,'新市场街道办事处','002',125),(1636,'东风街道办事处','003',125),(1637,'建南街道办事处','004',125),(1638,'韩村北路街道办事处','005',125),(1639,'颉庄乡','200',125),(1640,'富昌乡','201',125),(1641,'韩村乡','202',125),(1642,'南奇乡','203',125),(1643,'江城乡','204',125),(1644,'大马坊乡','205',125),(1645,'保定国家高新区','400',125),(1646,'和平里街道办事处','001',126),(1647,'五四路街道办事处','002',126),(1648,'西关街道办事处','003',126),(1649,'中华路街道办事处','004',126),(1650,'东关街道办事处','005',126),(1651,'韩庄乡','200',126),(1652,'东金庄乡','201',126),(1653,'百楼乡','202',126),(1654,'联盟街道办事处','001',127),(1655,'红星街道办事处','002',127),(1656,'裕华街道办事处','003',127),(1657,'永华街道办事处','004',127),(1658,'南关街道办事处','005',127),(1659,'杨庄乡','200',127),(1660,'南大园乡','201',127),(1661,'焦庄乡','202',127),(1662,'五尧乡','203',127),(1663,'惠阳街道办事处','001',128),(1664,'满城镇','100',128),(1665,'大册营镇','101',128),(1666,'神星镇','102',128),(1667,'南韩村镇','103',128),(1668,'方顺桥乡','200',128),(1669,'于家庄乡','201',128),(1670,'贤台乡','202',128),(1671,'要庄乡','203',128),(1672,'白龙乡','204',128),(1673,'石井乡','205',128),(1674,'坨南乡','206',128),(1675,'刘家台乡','207',128),(1676,'清苑镇','100',129),(1677,'冉庄镇','101',129),(1678,'阳城镇','102',129),(1679,'魏村镇','103',129),(1680,'温仁镇','104',129),(1681,'张登镇','105',129),(1682,'大庄镇','106',129),(1683,'臧村镇','107',129),(1684,'白团乡','200',129),(1685,'北店乡','201',129),(1686,'石桥乡','202',129),(1687,'李庄乡','203',129),(1688,'北王力乡','204',129),(1689,'东吕乡','205',129),(1690,'何桥乡','206',129),(1691,'孙村乡','207',129),(1692,'阎庄乡','208',129),(1693,'望亭乡','209',129),(1694,'城区社区管理办公室街道办事处','001',130),(1695,'涞水镇','100',130),(1696,'永阳镇','101',130),(1697,'义安镇','102',130),(1698,'石亭镇','103',130),(1699,'赵各庄镇','104',130),(1700,'九龙镇','105',130),(1701,'三坡镇','106',130),(1702,'明义乡','200',130),(1703,'王村乡','201',130),(1704,'东文山乡','202',130),(1705,'娄村满族乡','203',130),(1706,'宋各庄乡','204',130),(1707,'其中口乡','205',130),(1708,'龙门乡','206',130),(1709,'胡家庄乡','207',130),(1710,'阜平镇','100',131),(1711,'龙泉关镇','101',131),(1712,'平阳镇','102',131),(1713,'城南庄镇','103',131),(1714,'东下关乡','200',131),(1715,'王林口乡','201',131),(1716,'台峪乡','202',131),(1717,'大台乡','203',131),(1718,'史家寨乡','204',131),(1719,'砂窝乡','205',131),(1720,'吴王口乡','206',131),(1721,'下庄乡','207',131),(1722,'北果元乡','208',131),(1723,'安肃镇','100',132),(1724,'崔庄镇','101',132),(1725,'大因镇','102',132),(1726,'遂城镇','103',132),(1727,'高林村镇','104',132),(1728,'大王店镇','105',132),(1729,'漕河镇','106',132),(1730,'东史端乡','200',132),(1731,'留村乡','201',132),(1732,'正村乡','202',132),(1733,'户木乡','203',132),(1734,'瀑河乡','204',132),(1735,'东釜山乡','205',132),(1736,'义联庄乡','206',132),(1737,'定兴镇','100',133),(1738,'固城镇','101',133),(1739,'贤寓镇','102',133),(1740,'北河镇','103',133),(1741,'东落堡乡','200',133),(1742,'高里乡','201',133),(1743,'张家庄乡','202',133),(1744,'姚村乡','203',133),(1745,'肖村乡','204',133),(1746,'柳卓乡','205',133),(1747,'杨村乡','206',133),(1748,'北田乡','207',133),(1749,'北南蔡乡','208',133),(1750,'李郁庄乡','209',133),(1751,'天宫寺乡','210',133),(1752,'小朱庄乡','211',133),(1753,'仁厚镇','100',134),(1754,'王京镇','101',134),(1755,'高昌镇','102',134),(1756,'北罗镇','103',134),(1757,'白合镇','104',134),(1758,'军城镇','105',134),(1759,'川里镇','106',134),(1760,'长古城乡','200',134),(1761,'都亭乡','201',134),(1762,'南店头乡','202',134),(1763,'北店头乡','203',134),(1764,'罗庄乡','204',134),(1765,'雹水乡','205',134),(1766,'大洋乡','206',134),(1767,'迷城乡','207',134),(1768,'齐家佐乡','208',134),(1769,'羊角乡','209',134),(1770,'石门乡','210',134),(1771,'黄石口乡','211',134),(1772,'倒马关乡','212',134),(1773,'高阳镇','100',135),(1774,'庞口镇','101',135),(1775,'西演镇','102',135),(1776,'邢家南乡','200',135),(1777,'晋庄乡','201',135),(1778,'蒲口乡','202',135),(1779,'小王果庄乡','203',135),(1780,'龙化乡','204',135),(1781,'庞家佐乡','205',135),(1782,'容城镇','100',136),(1783,'小里镇','101',136),(1784,'南张镇','102',136),(1785,'大河镇','103',136),(1786,'八于乡','200',136),(1787,'贾光乡','201',136),(1788,'晾马台乡','202',136),(1789,'平王乡','203',136),(1790,'涞源镇','100',137),(1791,'银坊镇','101',137),(1792,'走马驿镇','102',137),(1793,'水堡镇','103',137),(1794,'王安镇','104',137),(1795,'杨家庄镇','105',137),(1796,'下北头乡','200',137),(1797,'南屯乡','201',137),(1798,'马庄乡','202',137),(1799,'北石佛乡','203',137),(1800,'金家井乡','204',137),(1801,'留家庄乡','205',137),(1802,'上庄乡','206',137),(1803,'东团堡乡','207',137),(1804,'塔崖驿乡','208',137),(1805,'乌龙沟乡','209',137),(1806,'烟煤洞乡','210',137),(1807,'望都镇','100',138),(1808,'固店镇','101',138),(1809,'寺庄乡','200',138),(1810,'赵庄乡','201',138),(1811,'黑堡乡','202',138),(1812,'高岭乡','204',138),(1813,'中韩庄乡','205',138),(1814,'贾村乡','206',138),(1815,'安新镇','100',139),(1816,'大王镇','101',139),(1817,'三台镇','102',139),(1818,'端村镇','103',139),(1819,'赵北口镇','104',139),(1820,'同口镇','105',139),(1821,'刘李庄镇','106',139),(1822,'安州镇','107',139),(1823,'老河头镇','108',139),(1824,'圈头乡','200',139),(1825,'寨里乡','201',139),(1826,'芦庄乡','202',139),(1827,'易州镇','100',140),(1828,'梁格庄镇','101',140),(1829,'西陵镇','102',140),(1830,'裴山镇','103',140),(1831,'塘湖镇','104',140),(1832,'狼牙山镇','105',140),(1833,'良岗镇','106',140),(1834,'紫荆关镇','107',140),(1835,'桥头乡','200',140),(1836,'白马乡','201',140),(1837,'流井乡','202',140),(1838,'高村乡','203',140),(1839,'高陌乡','204',140),(1840,'大龙华乡','205',140),(1841,'安格庄乡','206',140),(1842,'凌云册乡','207',140),(1843,'西山北乡','208',140),(1844,'尉都乡','209',140),(1845,'独乐乡','210',140),(1846,'七峪乡','211',140),(1847,'富岗乡','212',140),(1848,'坡仓乡','213',140),(1849,'牛岗乡','214',140),(1850,'桥家河乡','215',140),(1851,'甘河净乡','216',140),(1852,'蔡家峪乡','217',140),(1853,'南城司乡','218',140),(1854,'恒州镇','100',141),(1855,'灵山镇','101',141),(1856,'燕赵镇','102',141),(1857,'羊平镇','103',141),(1858,'路庄子乡','200',141),(1859,'下河乡','201',141),(1860,'庄窠乡','202',141),(1861,'孝墓乡','203',141),(1862,'文德乡','204',141),(1863,'东旺乡','205',141),(1864,'晓林乡','206',141),(1865,'邸村乡','207',141),(1866,'产德乡','208',141),(1867,'齐村乡','209',141),(1868,'党城乡','210',141),(1869,'郎家庄乡','211',141),(1870,'范家庄乡','212',141),(1871,'北台乡','213',141),(1872,'蠡吾镇','100',142),(1873,'留史镇','101',142),(1874,'大百尺镇','102',142),(1875,'辛兴镇','103',142),(1876,'北郭丹镇','104',142),(1877,'万安镇','105',142),(1878,'桑园镇','106',142),(1879,'南庄镇','107',142),(1880,'小陈乡','200',142),(1881,'林堡乡','201',142),(1882,'北埝头乡','202',142),(1883,'鲍墟乡','203',142),(1884,'大曲堤乡','204',142),(1885,'蒲阳镇','100',143),(1886,'高于铺镇','101',143),(1887,'腰山镇','102',143),(1888,'蒲上乡','200',143),(1889,'白云乡','201',143),(1890,'河口乡','202',143),(1891,'安阳乡','203',143),(1892,'台鱼乡','204',143),(1893,'大悲乡','205',143),(1894,'神南乡','206',143),(1895,'博野镇','100',144),(1896,'小店镇','101',144),(1897,'程委镇','102',144),(1898,'东墟乡','200',144),(1899,'北杨村乡','201',144),(1900,'城东乡','202',144),(1901,'南小王乡','203',144),(1902,'雄州镇','100',145),(1903,'昝岗镇','101',145),(1904,'大营镇','102',145),(1905,'龙湾镇','103',145),(1906,'北沙口乡','200',145),(1907,'朱各庄乡','201',145),(1908,'米家务乡','202',145),(1909,'双堂乡','203',145),(1910,'张岗乡','204',145),(1911,'双塔街道办事处','001',146),(1912,'桃园街道办事处','002',146),(1913,'清凉寺街道办事处','003',146),(1914,'松林店镇','100',146),(1915,'码头镇','101',146),(1916,'东城坊镇','102',146),(1917,'高官庄镇','103',146),(1918,'东仙坡镇','104',146),(1919,'百尺竿乡','200',146),(1920,'义和庄乡','202',146),(1921,'林家屯乡','203',146),(1922,'孙庄乡','204',146),(1923,'豆庄乡','205',146),(1924,'刁窝乡','206',146),(1925,'开发区管理委员会','400',146),(1926,'南城区街道办事处','001',147),(1927,'北城区街道办事处','002',147),(1928,'西城区街道办事处','003',147),(1929,'留早镇','100',147),(1930,'清风店镇','101',147),(1931,'庞村镇','102',147),(1932,'砖路镇','103',147),(1933,'明月店镇','104',147),(1934,'叮咛店镇','105',147),(1935,'东亭镇','106',147),(1936,'大辛庄镇','107',147),(1937,'东旺镇','108',147),(1938,'高蓬镇','109',147),(1939,'邢邑镇','110',147),(1940,'李亲顾镇','111',147),(1941,'子位镇','112',147),(1942,'开元镇','113',147),(1943,'赵村乡','200',147),(1944,'周村乡','202',147),(1945,'东留春乡','203',147),(1946,'号头庄回族乡','204',147),(1947,'杨家庄乡','205',147),(1948,'大鹿庄乡','206',147),(1949,'息冢乡','207',147),(1950,'西城乡','208',147),(1951,'祁州药市街道办事处','001',148),(1952,'祁州镇','100',148),(1953,'伍仁桥镇','101',148),(1954,'石佛镇','102',148),(1955,'郑章镇','103',148),(1956,'大五女镇','104',148),(1957,'明官店乡','200',148),(1958,'南娄底乡','201',148),(1959,'西安国城乡','202',148),(1960,'西佛落乡','203',148),(1961,'北段村乡','204',148),(1962,'和平街道办事处','001',149),(1963,'军城街道办事处','002',149),(1964,'东盛街道办事处','003',149),(1965,'北城街道办事处','004',149),(1966,'兴华路街道办事处','005',149),(1967,'方官镇','100',149),(1968,'新城镇','101',149),(1969,'泗庄镇','102',149),(1970,'白沟镇','103',149),(1971,'辛立庄镇','104',149),(1972,'肖官营乡','200',149),(1973,'梁家营乡','201',149),(1974,'张六庄乡','202',149),(1975,'东马营乡','203',149),(1976,'辛桥乡','204',149),(1977,'红旗楼街道办事处','001',151),(1978,'胜利北路街道办事处','002',151),(1979,'五一路街道办事处','003',151),(1980,'花园街街道办事处','004',151),(1981,'工业路街道办事处','005',151),(1982,'南站街道办事处','006',151),(1983,'马路东街道办事处','007',151),(1984,'老鸦庄镇','100',151),(1985,'姚家庄镇','101',151),(1986,'新华街街道办事处','001',152),(1987,'大境门街道办事处','002',152),(1988,'明德北街街道办事处','003',152),(1989,'明德南街街道办事处','004',152),(1990,'堡子里街道办事处','005',152),(1991,'南营坊街道办事处','006',152),(1992,'工人新村街道办事处','007',152),(1993,'东窑子镇','100',152),(1994,'沈家屯镇','101',152),(1995,'天泰寺街道办事处','001',153),(1996,'皇城街道办事处','002',153),(1997,'南关街道办事处','003',153),(1998,'南大街街道办事处','004',153),(1999,'大北街街道办事处','005',153),(2000,'工业街街道办事处','006',153),(2001,'建国街街道办事处','007',153),(2002,'庞家堡镇','100',153),(2003,'河子西乡','200',153),(2004,'春光乡','201',153),(2005,'侯家庙乡','202',153),(2006,'城镇街道办事处','001',154),(2007,'煤矿街道办事处','002',154),(2008,'花园乡','200',154),(2009,'辛庄子乡','201',154),(2010,'定方水乡','202',154),(2011,'段家堡乡','203',154),(2012,'洋河南镇','100',155),(2013,'深井镇','101',155),(2014,'崞村镇','102',155),(2015,'沙岭子镇','103',155),(2016,'姚家房镇','104',155),(2017,'大仓盖镇','105',155),(2018,'贾家营镇','106',155),(2019,'顾家营镇','107',155),(2020,'赵川镇','108',155),(2021,'王家湾乡','200',155),(2022,'塔儿村乡','201',155),(2023,'江家屯乡','202',155),(2024,'东望山乡','203',155),(2025,'李家堡乡','204',155),(2026,'张北镇','100',156),(2027,'公会镇','101',156),(2028,'二台镇','102',156),(2029,'大囫囵镇','103',156),(2030,'台路沟乡','200',156),(2031,'油篓沟乡','201',156),(2032,'馒头营乡','202',156),(2033,'二泉井乡','203',156),(2034,'单晶河乡','204',156),(2035,'大河乡','205',156),(2036,'海流图乡','206',156),(2037,'两面井乡','207',156),(2038,'大西湾乡','208',156),(2039,'郝家营乡','209',156),(2040,'白庙滩乡','210',156),(2041,'小二台乡','211',156),(2042,'战海乡','212',156),(2043,'三号乡','213',156),(2044,'沙沟乡','214',156),(2045,'宇宙营乡','215',156),(2046,'察北虚拟乡','500',156),(2047,'康保镇','100',157),(2048,'张纪镇','101',157),(2049,'土城子镇','102',157),(2050,'邓油坊镇','103',157),(2051,'李家地镇','104',157),(2052,'照阳河镇','105',157),(2053,'屯垦镇','106',157),(2054,'阎油房乡','200',157),(2055,'丹清河乡','201',157),(2056,'哈必嘎乡','202',157),(2057,'二号卜乡','203',157),(2058,'芦家营乡','204',157),(2059,'忠义乡','205',157),(2060,'处长地乡','206',157),(2061,'满德堂乡','207',157),(2062,'康保牧场虚拟乡','500',157),(2063,'平定堡镇','100',158),(2064,'小厂镇','101',158),(2065,'黄盖淖镇','102',158),(2066,'九连城镇','103',158),(2067,'高山堡乡','200',158),(2068,'小河子乡','201',158),(2069,'二道渠乡','202',158),(2070,'大二号回族乡','203',158),(2071,'闪电河乡','204',158),(2072,'长梁乡','205',158),(2073,'丰源店乡','206',158),(2074,'西辛营乡','207',158),(2075,'莲花滩乡','208',158),(2076,'白土窑乡','209',158),(2077,'榆树沟虚拟乡','501',158),(2078,'沙','502',158),(2079,'小城子虚拟乡','503',158),(2080,'东大门虚拟乡','504',158),(2081,'南壕堑镇','100',159),(2082,'大青沟镇','101',159),(2083,'八道沟镇','102',159),(2084,'红土梁镇','103',159),(2085,'小蒜沟镇','104',159),(2086,'三工地镇','105',159),(2087,'大营盘乡','200',159),(2088,'大苏计乡','201',159),(2089,'石井乡','202',159),(2090,'炕塄乡','204',159),(2091,'七甲乡','205',159),(2092,'套里庄乡','206',159),(2093,'甲石河乡','207',159),(2094,'下马圈乡','208',159),(2095,'蔚州镇','100',160),(2096,'代王城镇','101',160),(2097,'西合营镇','102',160),(2098,'吉家庄镇','103',160),(2099,'白乐镇','104',160),(2100,'暖泉镇','105',160),(2101,'南留庄镇','106',160),(2102,'北水泉镇','107',160),(2103,'桃花镇','108',160),(2104,'阳眷镇','109',160),(2105,'宋家庄镇','110',160),(2106,'下宫村乡','200',160),(2107,'南杨庄乡','202',160),(2108,'柏树乡','203',160),(2109,'常宁乡','204',160),(2110,'涌泉庄乡','205',160),(2111,'杨庄窠乡','206',160),(2112,'南岭庄乡','207',160),(2113,'陈家洼乡','208',160),(2114,'黄梅乡','209',160),(2115,'白草村乡','210',160),(2116,'草沟堡乡','211',160),(2117,'西城镇','100',161),(2118,'东城镇','101',161),(2119,'化稍营镇','102',161),(2120,'揣骨疃镇','103',161),(2121,'东井集镇','104',161),(2122,'要家庄乡','200',161),(2123,'东坊城堡乡','201',161),(2124,'井儿沟乡','202',161),(2125,'三马坊乡','203',161),(2126,'高墙乡','204',161),(2127,'大田洼乡','205',161),(2128,'辛堡乡','206',161),(2129,'马圈堡乡','207',161),(2130,'浮图讲乡','208',161),(2131,'柴沟堡镇','100',162),(2132,'左卫镇','101',162),(2133,'头百户镇','102',162),(2134,'怀安城镇','103',162),(2135,'渡口堡乡','200',162),(2136,'第六屯乡','201',162),(2137,'西湾堡乡','202',162),(2138,'西沙城乡','203',162),(2139,'太平庄乡','204',162),(2140,'王虎屯乡','205',162),(2141,'第三堡乡','206',162),(2142,'孔家庄镇','100',163),(2143,'万全镇','101',163),(2144,'洗马林镇','102',163),(2145,'郭磊庄镇','103',163),(2146,'膳房堡乡','200',163),(2147,'北新屯乡','201',163),(2148,'宣平堡乡','202',163),(2149,'高庙堡乡','203',163),(2150,'旧堡乡','204',163),(2151,'安家堡乡','205',163),(2152,'北沙城乡','206',163),(2153,'沙城镇','100',164),(2154,'北辛堡镇','101',164),(2155,'新保安镇','102',164),(2156,'东花园镇','103',164),(2157,'官厅镇','104',164),(2158,'桑园镇','105',164),(2159,'存瑞镇','106',164),(2160,'土木镇','107',164),(2161,'大黄庄镇','108',164),(2162,'西八里镇','109',164),(2163,'小南辛堡镇','110',164),(2164,'狼山乡','200',164),(2165,'鸡鸣驿乡','203',164),(2166,'东八里乡','205',164),(2167,'瑞云观乡','207',164),(2168,'孙庄子乡','208',164),(2169,'王家楼回族乡','210',164),(2170,'涿鹿镇','100',165),(2171,'张家堡镇','101',165),(2172,'武家沟镇','102',165),(2173,'五堡镇','103',165),(2174,'保岱镇','104',165),(2175,'矾山镇','105',165),(2176,'大堡镇','106',165),(2177,'河东镇','107',165),(2178,'东小庄乡','200',165),(2179,'栾庄乡','201',165),(2180,'温泉屯乡','202',165),(2181,'辉耀乡','203',165),(2182,'黑山寺乡','204',165),(2183,'卧佛寺乡','205',165),(2184,'谢家堡乡','206',165),(2185,'大河南乡','207',165),(2186,'蟒石口乡','208',165),(2187,'赤城镇','100',166),(2188,'田家窑镇','101',166),(2189,'龙关镇','102',166),(2190,'雕鄂镇','103',166),(2191,'独石口镇','104',166),(2192,'白草镇','105',166),(2193,'龙门所镇','106',166),(2194,'后城镇','107',166),(2195,'东卯镇','108',166),(2196,'炮梁乡','200',166),(2197,'大海陀乡','201',166),(2198,'镇宁堡乡','202',166),(2199,'马营乡','203',166),(2200,'云州乡','204',166),(2201,'三道川乡','205',166),(2202,'东万口乡','206',166),(2203,'茨营子乡','207',166),(2204,'样田乡','208',166),(2205,'西湾子街道办','001',167),(2206,'西湾子镇','100',167),(2207,'高家营镇','101',167),(2208,'四台嘴乡','200',167),(2209,'红旗营乡','201',167),(2210,'石窑子乡','202',167),(2211,'驿马图乡','203',167),(2212,'石嘴子乡','204',167),(2213,'狮子沟乡','205',167),(2214,'清三营乡','206',167),(2215,'白旗乡','207',167),(2216,'西大街街道','001',169),(2217,'头道牌楼街道','002',169),(2218,'潘家沟街道','003',169),(2219,'中华路街道','004',169),(2220,'新华路街道','005',169),(2221,'石洞子沟街道','006',169),(2222,'桥东街道','007',169),(2223,'水泉沟镇','100',169),(2224,'狮子沟镇','101',169),(2225,'牛圈子沟镇','102',169),(2226,'大石庙镇','103',169),(2227,'冯营子镇','104',169),(2228,'双塔山街道','001',170),(2229,'滦河街道','002',170),(2230,'双塔山镇','100',170),(2231,'滦河镇','101',170),(2232,'大庙镇','102',170),(2233,'偏桥子镇','103',170),(2234,'鹰手营子镇','100',171),(2235,'北马圈子镇','101',171),(2236,'寿王坟镇','102',171),(2237,'汪家庄镇','103',171),(2238,'下板城镇','100',172),(2239,'上板城镇','101',172),(2240,'甲山镇','102',172),(2241,'六沟镇','103',172),(2242,'三沟镇','104',172),(2243,'头沟镇','105',172),(2244,'高寺台镇','106',172),(2245,'双峰寺镇','107',172),(2246,'东小白旗乡','200',172),(2247,'鞍匠乡','201',172),(2248,'刘杖子乡','202',172),(2249,'新杖子乡','203',172),(2250,'孟家院乡','204',172),(2251,'大营子乡','205',172),(2252,'八家乡','206',172),(2253,'上谷乡','207',172),(2254,'满杖子乡','208',172),(2255,'石灰窑乡','209',172),(2256,'五道河乡','210',172),(2257,'岔沟乡','211',172),(2258,'岗子满族乡','212',172),(2259,'磴上乡','213',172),(2260,'两家满族乡','214',172),(2261,'三家乡','215',172),(2262,'仓子乡','216',172),(2263,'兴隆镇','100',173),(2264,'半壁山镇','101',173),(2265,'挂兰峪镇','102',173),(2266,'青松岭镇','103',173),(2267,'六道河镇','104',173),(2268,'平安堡镇','105',173),(2269,'北营房镇','106',173),(2270,'南天门满族乡','200',173),(2271,'孤山子乡','201',173),(2272,'八卦岭满族乡','202',173),(2273,'陡子峪乡','203',173),(2274,'上石洞乡','204',173),(2275,'北水泉乡','205',173),(2276,'李家营乡','206',173),(2277,'大杖子乡','207',173),(2278,'蘑菇峪乡','208',173),(2279,'三道河乡','209',173),(2280,'蓝旗营乡','210',173),(2281,'安子岭乡','211',173),(2282,'大水泉乡','212',173),(2283,'平泉镇','100',174),(2284,'黄土梁子镇','101',174),(2285,'榆树林子镇','102',174),(2286,'杨树岭镇','103',174),(2287,'七沟镇','104',174),(2288,'小寺沟镇','105',174),(2289,'党坝镇','106',174),(2290,'卧龙镇','107',174),(2291,'南五十家子镇','108',174),(2292,'王土房乡','200',174),(2293,'柳溪满族乡','202',174),(2294,'七家岱满族乡','203',174),(2295,'平房满族蒙古族乡','204',174),(2296,'蒙和乌苏蒙古族乡','205',174),(2297,'茅兰沟满族蒙古族乡','206',174),(2298,'台头山乡','207',174),(2299,'松树台乡','209',174),(2300,'道虎沟乡','210',174),(2301,'郭杖子满族乡','212',174),(2302,'滦平镇','100',175),(2303,'长山峪镇','101',175),(2304,'红旗镇','102',175),(2305,'金沟屯镇','103',175),(2306,'虎什哈镇','104',175),(2307,'巴克什营镇','105',175),(2308,'张百湾镇','106',175),(2309,'平坊满族乡','200',175),(2310,'安纯沟门满族乡','201',175),(2311,'西地满族乡','202',175),(2312,'陈栅子乡','203',175),(2313,'付营子乡','204',175),(2314,'小营满族乡','205',175),(2315,'西沟满族乡','206',175),(2316,'邓厂满族乡','207',175),(2317,'五道营子满族乡','208',175),(2318,'马营子满族乡','209',175),(2319,'付家店满族乡','210',175),(2320,'火斗山乡','211',175),(2321,'两间房乡','212',175),(2322,'涝洼乡','213',175),(2323,'大屯满族乡','214',175),(2324,'隆化镇','100',176),(2325,'韩麻营镇','101',176),(2326,'中关镇','102',176),(2327,'七家镇','103',176),(2328,'汤头沟镇','104',176),(2329,'张三营镇','105',176),(2330,'唐三营镇','106',176),(2331,'蓝旗镇','107',176),(2332,'步古沟镇','108',176),(2333,'郭家屯镇','109',176),(2334,'荒地乡','200',176),(2335,'章吉营乡','201',176),(2336,'茅荆坝乡','202',176),(2337,'尹家营满族乡','203',176),(2338,'庙子沟蒙古族满族乡','204',176),(2339,'偏坡营满族乡','205',176),(2340,'山湾乡','206',176),(2341,'八达营蒙古族乡','207',176),(2342,'太平庄满族乡','208',176),(2343,'旧屯满族乡','209',176),(2344,'西阿超满族蒙古族乡','210',176),(2345,'白虎沟满族蒙古族乡','211',176),(2346,'碱房乡','212',176),(2347,'韩家店乡','213',176),(2348,'湾沟门乡','214',176),(2349,'大阁镇','100',177),(2350,'大滩镇','101',177),(2351,'鱼儿山镇','102',177),(2352,'土城镇','103',177),(2353,'黄旗镇','104',177),(2354,'凤山镇','105',177),(2355,'波罗诺镇','106',177),(2356,'黑山咀镇','107',177),(2357,'天桥镇','108',177),(2358,'万胜永乡','200',177),(2359,'四岔口乡','201',177),(2360,'苏家店乡','202',177),(2361,'外沟门乡','203',177),(2362,'草原乡','204',177),(2363,'窟窿山乡','205',177),(2364,'小坝子乡','206',177),(2365,'五道营乡','207',177),(2366,'南关蒙古族乡','208',177),(2367,'选将营乡','209',177),(2368,'西官营乡','210',177),(2369,'王营乡','211',177),(2370,'北头营乡','212',177),(2371,'胡麻营乡','213',177),(2372,'石人沟乡','214',177),(2373,'汤河乡','215',177),(2374,'杨木栅子乡','216',177),(2375,'宽城镇','100',178),(2376,'龙须门镇','101',178),(2377,'峪耳崖镇','102',178),(2378,'板城镇','103',178),(2379,'汤道河镇','104',178),(2380,'化皮溜子乡','200',178),(2381,'塌山乡','201',178),(2382,'饽罗台乡','202',178),(2383,'孟子岭乡','203',178),(2384,'独石沟乡','204',178),(2385,'碾子峪乡','205',178),(2386,'东大地乡','206',178),(2387,'铧尖乡','207',178),(2388,'东黄花川乡','208',178),(2389,'亮甲台乡','209',178),(2390,'苇子沟乡','210',178),(2391,'大字沟门乡','211',178),(2392,'大石柱子乡','212',178),(2393,'围场镇','100',179),(2394,'四合永镇','101',179),(2395,'克勒沟镇','102',179),(2396,'棋盘山镇','103',179),(2397,'半截塔镇','104',179),(2398,'朝阳地镇','105',179),(2399,'朝阳湾镇','106',179),(2400,'道坝子乡','200',179),(2401,'龙头山乡','201',179),(2402,'腰站乡','202',179),(2403,'黄土坎乡','203',179),(2404,'四道沟乡','204',179),(2405,'兰旗卡伦乡','205',179),(2406,'银窝沟乡','206',179),(2407,'新地乡','207',179),(2408,'广发永乡','208',179),(2409,'育太和乡','209',179),(2410,'郭家湾乡','210',179),(2411,'杨家湾乡','211',179),(2412,'大唤起乡','212',179),(2413,'哈里哈乡','213',179),(2414,'新拨乡','214',179),(2415,'张家湾乡','215',179),(2416,'宝元栈乡','216',179),(2417,'山湾子乡','217',179),(2418,'三义永乡','218',179),(2419,'姜家店乡','219',179),(2420,'下伙房乡','220',179),(2421,'燕格柏乡','221',179),(2422,'牌楼乡','222',179),(2423,'城子乡','223',179),(2424,'老窝铺乡','224',179),(2425,'御道口乡','225',179),(2426,'石桌子乡','226',179),(2427,'大头山乡','227',179),(2428,'南山嘴乡','228',179),(2429,'西龙头乡','229',179),(2430,'塞罕坝机械林场虚拟镇','450',179),(2431,'国营御道口牧场虚拟乡','500',179),(2432,'建设北街街道办事处','001',181),(2433,'车站街道办事处','002',181),(2434,'南大街街道办事处','003',181),(2435,'东环街道办事处','004',181),(2436,'道东街道办事处','005',181),(2437,'小赵庄乡','200',181),(2438,'沧州开发区','400',181),(2439,'水月寺街道办事处','001',182),(2440,'南环中路街道办事处','002',182),(2441,'南湖街道办事处','003',182),(2442,'市场街道办事处','004',182),(2443,'西环中街街道办事处','005',182),(2444,'公园街道办事处','006',182),(2445,'小王庄镇','100',182),(2446,'南陈屯乡','200',182),(2447,'旧州镇','100',183),(2448,'兴济镇','101',183),(2449,'杜生镇','102',183),(2450,'崔尔庄镇','103',183),(2451,'薛官屯乡','200',183),(2452,'捷地回族乡','201',183),(2453,'张官屯乡','202',183),(2454,'李天木回族乡','203',183),(2455,'风化店乡','204',183),(2456,'姚官屯乡','205',183),(2457,'杜林回族乡','206',183),(2458,'汪家铺乡','207',183),(2459,'刘家庙乡','208',183),(2460,'仵龙堂乡','209',183),(2461,'大官厅乡','210',183),(2462,'高川乡','211',183),(2463,'黄递铺乡','212',183),(2464,'大褚村回族乡','213',183),(2465,'纸房头乡','214',183),(2466,'清州镇','100',184),(2467,'金牛镇','101',184),(2468,'新兴镇','102',184),(2469,'流河镇','103',184),(2470,'木门店镇','104',184),(2471,'马厂镇','105',184),(2472,'上伍乡','200',184),(2473,'曹寺乡','201',184),(2474,'盘古乡','202',184),(2475,'陈嘴乡','203',184),(2476,'农场虚拟乡','400',184),(2477,'东光镇','100',185),(2478,'连镇镇','101',185),(2479,'找王镇','102',185),(2480,'秦村镇','103',185),(2481,'灯明寺镇','104',185),(2482,'南霞口镇','105',185),(2483,'大单镇','106',185),(2484,'龙王李乡','200',185),(2485,'于桥乡','201',185),(2486,'苏基镇','100',186),(2487,'辛集镇','101',186),(2488,'高湾镇','102',186),(2489,'赵毛陶乡','200',186),(2490,'香坊乡','201',186),(2491,'小山乡','202',186),(2492,'张会亭乡','203',186),(2493,'海兴县农场','400',186),(2494,'青先农场','401',186),(2495,'青锋农场','402',186),(2496,'盐山镇','100',187),(2497,'望树镇','101',187),(2498,'庆云镇','102',187),(2499,'韩集镇','103',187),(2500,'千童镇','104',187),(2501,'圣佛镇','105',187),(2502,'边务乡','200',187),(2503,'小营乡','201',187),(2504,'杨集乡','202',187),(2505,'孟店乡','203',187),(2506,'常庄乡','204',187),(2507,'小庄乡','205',187),(2508,'肃宁镇','100',188),(2509,'梁家村镇','101',188),(2510,'窝北镇','102',188),(2511,'尚村镇','103',188),(2512,'万里镇','104',188),(2513,'师素乡','201',188),(2514,'河北留善寺乡','203',188),(2515,'付家佐乡','204',188),(2516,'邵庄乡','205',188),(2517,'南皮镇','100',189),(2518,'冯家口镇','101',189),(2519,'寨子镇','102',189),(2520,'鲍官屯镇','103',189),(2521,'王寺镇','104',189),(2522,'乌马营镇','105',189),(2523,'大浪淀乡','200',189),(2524,'刘八里乡','201',189),(2525,'潞灌乡','202',189),(2526,'桑园镇','100',190),(2527,'铁城镇','101',190),(2528,'于集镇','102',190),(2529,'梁集镇','103',190),(2530,'安陵镇','104',190),(2531,'曹家洼乡','200',190),(2532,'宋门乡','201',190),(2533,'杨家寺乡','202',190),(2534,'沟店铺乡','203',190),(2535,'何庄乡','204',190),(2536,'乐寿镇','100',191),(2537,'淮镇镇','101',191),(2538,'郭庄镇','102',191),(2539,'河城街镇','103',191),(2540,'韩村乡','200',191),(2541,'陌南乡','201',191),(2542,'陈庄乡','204',191),(2543,'徐留高乡','205',191),(2544,'商林乡','206',191),(2545,'段村乡','207',191),(2546,'张村乡','209',191),(2547,'临河乡','210',191),(2548,'小平王乡','211',191),(2549,'十五级乡','212',191),(2550,'垒头乡','213',191),(2551,'南河头乡','214',191),(2552,'西城乡','215',191),(2553,'本斋回族乡','216',191),(2554,'农场','400',191),(2555,'孟村镇','100',192),(2556,'新县镇','101',192),(2557,'辛店镇','102',192),(2558,'高寨镇','103',192),(2559,'宋庄子乡','200',192),(2560,'牛进庄乡','201',192),(2561,'解放街道办事处','001',193),(2562,'河东街道办事处','002',193),(2563,'古楼街道办事处','003',193),(2564,'泊镇','100',193),(2565,'交河镇','101',193),(2566,'齐桥镇','102',193),(2567,'寺门村镇','103',193),(2568,'郝村镇','104',193),(2569,'富镇镇','105',193),(2570,'文庙镇','106',193),(2571,'洼里王镇','107',193),(2572,'王武庄乡','201',193),(2573,'营子乡','202',193),(2574,'四营乡','203',193),(2575,'西辛店乡','204',193),(2576,'新华路街道','001',194),(2577,'西环路街道','002',194),(2578,'永丰路街道','003',194),(2579,'出岸镇','100',194),(2580,'石门桥镇','101',194),(2581,'吕公堡镇','102',194),(2582,'长丰镇','103',194),(2583,'莫州镇','104',194),(2584,'苟各庄镇','105',194),(2585,'梁召镇','106',194),(2586,'辛中驿镇','107',194),(2587,'麻家坞乡','202',194),(2588,'议论堡乡','203',194),(2589,'青塔乡','204',194),(2590,'北辛庄乡','205',194),(2591,'七间房乡','206',194),(2592,'北汉乡','207',194),(2593,'于村乡','208',194),(2594,'华北石油管理局虚拟街道','400',194),(2595,'开发区管理委员会','500',194),(2596,'骅东街道','001',195),(2597,'骅中街道','002',195),(2598,'骅西街道','003',195),(2599,'黄骅镇','100',195),(2600,'南排河镇','101',195),(2601,'吕桥镇','102',195),(2602,'旧城镇','103',195),(2603,'羊二庄回族乡','200',195),(2604,'常郭乡','202',195),(2605,'滕庄子乡','203',195),(2606,'官庄乡','204',195),(2607,'齐家务乡','205',195),(2608,'港城开发区新村乡','206',195),(2609,'羊三木乡','207',195),(2610,'南大港管理区虚拟乡','400',195),(2611,'国营中捷农场虚拟乡','401',195),(2612,'黄骅港开发区虚拟乡','402',195),(2613,'临港化工园区','403',195),(2614,'瀛州镇','100',196),(2615,'米各庄镇','101',196),(2616,'景和镇','102',196),(2617,'卧佛堂镇','103',196),(2618,'束城镇','104',196),(2619,'留古寺镇','105',196),(2620,'沙河桥镇','106',196),(2621,'故仙乡','200',196),(2622,'黎民居乡','201',196),(2623,'兴村乡','202',196),(2624,'沙洼乡','203',196),(2625,'西九吉乡','204',196),(2626,'北石槽乡','205',196),(2627,'诗经村乡','207',196),(2628,'郭家村乡','208',196),(2629,'时村乡','209',196),(2630,'行别营乡','210',196),(2631,'尊祖庄乡','211',196),(2632,'龙华店乡','212',196),(2633,'果子洼乡','213',196),(2634,'银河南路街道','001',198),(2635,'光明西道街道','002',198),(2636,'落垡镇','100',198),(2637,'码头镇','101',198),(2638,'葛渔城镇','102',198),(2639,'东沽港镇','103',198),(2640,'杨税务乡','200',198),(2641,'仇庄乡','201',198),(2642,'调河头乡','202',198),(2643,'北史家务乡','203',198),(2644,'银河北路街道','001',199),(2645,'爱民东道街道','002',199),(2646,'解放道街道','003',199),(2647,'新开路街道','004',199),(2648,'南尖塔镇','100',199),(2649,'万庄镇','101',199),(2650,'九州镇','102',199),(2651,'北旺乡','200',199),(2652,'廊坊经济技术开发区','450',199),(2653,'新世纪步行街管理委员会','500',199),(2654,'固安镇','100',200),(2655,'宫村镇','101',200),(2656,'柳泉镇','102',200),(2657,'牛驼镇','103',200),(2658,'马庄镇','104',200),(2659,'东湾乡','200',200),(2660,'彭村乡','201',200),(2661,'渠沟乡','202',200),(2662,'礼让店乡','203',200),(2663,'街道办事处','001',201),(2664,'永清镇','100',201),(2665,'韩村镇','101',201),(2666,'后奕镇','102',201),(2667,'别古庄镇','103',201),(2668,'里澜城镇','104',201),(2669,'管家务回族乡','200',201),(2670,'曹家务乡','201',201),(2671,'龙虎庄乡','202',201),(2672,'刘街乡','203',201),(2673,'三圣口乡','204',201),(2674,'淑阳镇','100',202),(2675,'蒋辛屯镇','101',202),(2676,'渠口镇','102',202),(2677,'安头屯镇','103',202),(2678,'安平镇','104',202),(2679,'刘宋镇','105',202),(2680,'五百户镇','106',202),(2681,'钱旺乡','200',202),(2682,'钳屯乡','201',202),(2683,'香河开发区','500',202),(2684,'平舒镇','100',203),(2685,'旺村镇','101',203),(2686,'大尚屯镇','102',203),(2687,'南赵扶镇','103',203),(2688,'留各庄镇','104',203),(2689,'权村镇','105',203),(2690,'里坦镇','106',203),(2691,'北位乡','200',203),(2692,'大广安乡','201',203),(2693,'臧屯乡','202',203),(2694,'摩配园区管委会','400',203),(2695,'文安镇','100',204),(2696,'新镇镇','101',204),(2697,'苏桥镇','102',204),(2698,'大柳河镇','103',204),(2699,'左各庄镇','104',204),(2700,'滩里镇','105',204),(2701,'史各庄镇','106',204),(2702,'赵各庄镇','107',204),(2703,'兴隆宫镇','108',204),(2704,'大留镇镇','109',204),(2705,'孙氏镇','110',204),(2706,'德归镇','111',204),(2707,'大围河回族满族乡','200',204),(2708,'大厂镇','100',205),(2709,'夏垫镇','101',205),(2710,'祁各庄镇','102',205),(2711,'邵府乡','201',205),(2712,'陈府乡','202',205),(2713,'工业园区','400',205),(2714,'霸州镇','100',206),(2715,'南孟镇','101',206),(2716,'信安镇','102',206),(2717,'堂二里镇','103',206),(2718,'煎茶铺镇','104',206),(2719,'胜芳镇','105',206),(2720,'杨芬港镇','106',206),(2721,'岔河集乡','200',206),(2722,'康仙庄乡','201',206),(2723,'东杨庄乡','202',206),(2724,'王庄子乡','203',206),(2725,'东段乡','204',206),(2726,'霸州经济技术开发区','450',206),(2727,'南城街道办事处','001',207),(2728,'北城街道办事处','002',207),(2729,'李旗庄镇','101',207),(2730,'杨庄镇','102',207),(2731,'皇庄镇','103',207),(2732,'新集镇','104',207),(2733,'段甲岭镇','105',207),(2734,'黄土庄镇','106',207),(2735,'高楼镇','107',207),(2736,'齐心庄镇','108',207),(2737,'燕郊镇','109',207),(2738,'燕郊经济技术开发区','450',207),(2739,'三河市农业高新技术园区','451',207),(2740,'河西街道办事处','001',209),(2741,'河东街道办事处','002',209),(2742,'路北街道办事处','003',209),(2743,'中华街道办事处','004',209),(2744,'郑家河沿镇','100',209),(2745,'赵家圈镇','101',209),(2746,'何家庄乡','200',209),(2747,'大麻森乡','201',209),(2748,'邓家庄乡','202',209),(2749,'彭杜村乡','203',209),(2750,'衡水高新技术产业开发区','400',209),(2751,'衡水湖自然保护区管理处','401',209),(2752,'枣强镇','100',210),(2753,'恩察镇','101',210),(2754,'大营镇','102',210),(2755,'嘉会镇','103',210),(2756,'马屯镇','104',210),(2757,'肖张镇','105',210),(2758,'张秀屯乡','200',210),(2759,'新屯乡','201',210),(2760,'王均乡','202',210),(2761,'唐林乡','203',210),(2762,'王常乡','204',210),(2763,'武邑镇','100',211),(2764,'清凉店镇','101',211),(2765,'审坡镇','102',211),(2766,'赵桥镇','103',211),(2767,'韩庄镇','104',211),(2768,'肖桥头镇','105',211),(2769,'龙店乡','200',211),(2770,'圈头乡','201',211),(2771,'大紫塔乡','203',211),(2772,'武强镇','100',212),(2773,'街关镇','101',212),(2774,'豆村乡','200',212),(2775,'北代乡','201',212),(2776,'孙庄乡','202',212),(2777,'周家窝乡','203',212),(2778,'饶阳镇','100',213),(2779,'大尹村镇','101',213),(2780,'五公镇','102',213),(2781,'王同岳乡','200',213),(2782,'大官亭乡','201',213),(2783,'留楚乡','202',213),(2784,'东里满乡','203',213),(2785,'安平镇','100',214),(2786,'马店镇','101',214),(2787,'南王庄镇','102',214),(2788,'大何庄乡','200',214),(2789,'程油子乡','201',214),(2790,'西两洼乡','202',214),(2791,'大子文乡','203',214),(2792,'东黄城乡','204',214),(2793,'郑口镇','100',215),(2794,'夏庄镇','101',215),(2795,'青罕镇','102',215),(2796,'故城镇','103',215),(2797,'武官寨镇','104',215),(2798,'饶阳店镇','105',215),(2799,'军屯镇','106',215),(2800,'建国镇','107',215),(2801,'西半屯镇','108',215),(2802,'辛庄乡','200',215),(2803,'里老乡','201',215),(2804,'房庄乡','202',215),(2805,'三朗乡','203',215),(2806,'景州镇','100',216),(2807,'龙华镇','101',216),(2808,'广川镇','102',216),(2809,'王瞳镇','103',216),(2810,'洚河流镇','104',216),(2811,'安陵镇','105',216),(2812,'杜桥镇','106',216),(2813,'王谦寺镇','107',216),(2814,'北留智镇','108',216),(2815,'留智庙镇','109',216),(2816,'刘集乡','200',216),(2817,'连镇乡','201',216),(2818,'梁集乡','202',216),(2819,'温城乡','203',216),(2820,'后留名府乡','204',216),(2821,'青兰乡','205',216),(2822,'阜城镇','100',217),(2823,'古城镇','101',217),(2824,'码头镇','102',217),(2825,'霞口镇','103',217),(2826,'崔家庙镇','104',217),(2827,'漫河乡','200',217),(2828,'建桥乡','201',217),(2829,'蒋坊乡','202',217),(2830,'大白乡','203',217),(2831,'王集乡','204',217),(2832,'冀州镇','100',218),(2833,'魏屯镇','101',218),(2834,'官道李镇','102',218),(2835,'南午村镇','103',218),(2836,'周村镇','104',218),(2837,'码头李镇','105',218),(2838,'西王镇','106',218),(2839,'门庄乡','200',218),(2840,'徐家庄乡','201',218),(2841,'北漳淮乡','202',218),(2842,'小寨乡','203',218),(2843,'唐奉镇','100',219),(2844,'深州镇','101',219),(2845,'辰时镇','102',219),(2846,'榆科镇','103',219),(2847,'魏桥镇','104',219),(2848,'大堤镇','105',219),(2849,'前磨头镇','106',219),(2850,'王家井镇','107',219),(2851,'护驾迟镇','108',219),(2852,'兵曹乡','200',219),(2853,'穆村乡','201',219),(2854,'东安庄乡','202',219),(2855,'北溪村乡','203',219),(2856,'大冯营乡','204',219),(2857,'乔屯乡','206',219),(2858,'太古庄乡','207',219),(2859,'大屯乡','208',219),(2860,'河北省深州监狱','400',219),(2861,'坞城街道办事处','001',221),(2862,'营盘街道办事处','002',221),(2863,'北营街道办事处','003',221),(2864,'平阳路街道办事处','004',221),(2865,'黄陵街道办事处','005',221),(2866,'小店街道办事处','006',221),(2867,'北格镇','100',221),(2868,'西温庄乡','200',221),(2869,'刘家堡乡','201',221),(2870,'太原高新技术产业开发区','401',221),(2871,'太原经济技术开发区','501',221),(2872,'柳巷街道办事处','001',222),(2873,'文庙街道办事处','002',222),(2874,'庙前街道办事处','003',222),(2875,'迎泽街道办事处','004',222),(2876,'桥东街道办事处','005',222),(2877,'老军营街道办事处','006',222),(2878,'郝庄镇','100',222),(2879,'民营区','401',222),(2880,'巨轮街道办事处','001',223),(2881,'三桥街道办事处','002',223),(2882,'鼓楼街道办事处','003',223),(2883,'杏花岭街道办事处','004',223),(2884,'坝陵桥街道办事处','005',223),(2885,'大东关街道办事处','006',223),(2886,'职工新街街道办事处','007',223),(2887,'敦化坊街道办事处','008',223),(2888,'涧河街道办事处','009',223),(2889,'杨家峪街道办事处','010',223),(2890,'中涧河乡','200',223),(2891,'小返乡','201',223),(2892,'民营区','401',223),(2893,'尖草坪街道办事处','001',224),(2894,'光社街道办事处','002',224),(2895,'上兰街道办事处','003',224),(2896,'南寨街道办事处','004',224),(2897,'迎新街道办事处','005',224),(2898,'古城街道办事处','006',224),(2899,'汇丰街道办事处','007',224),(2900,'柴村街道办事处','008',224),(2901,'新城街道办事处','009',224),(2902,'向阳镇','100',224),(2903,'阳曲镇','101',224),(2904,'马头水乡','200',224),(2905,'柏板乡','201',224),(2906,'西焉乡','202',224),(2907,'千峰街道办事处','001',225),(2908,'下元街道办事处','002',225),(2909,'和平街道办事处','003',225),(2910,'兴华街道办事处','004',225),(2911,'万柏林街道办事处','005',225),(2912,'杜儿坪街道办事处','006',225),(2913,'白家庄街道办事处','007',225),(2914,'南寒街道办事处','008',225),(2915,'东社街道办事处','009',225),(2916,'化客头街道办事处','010',225),(2917,'小井峪街道办事处','011',225),(2918,'西铭街道办事处','012',225),(2919,'长风街道办事处','013',225),(2920,'神堂沟街道办事处','014',225),(2921,'王封乡','200',225),(2922,'义井街道办事处','001',226),(2923,'罗城街道办事处','002',226),(2924,'晋源街道办事处','003',226),(2925,'金胜镇','100',226),(2926,'晋祠镇','101',226),(2927,'姚村镇','102',226),(2928,'清源镇','100',227),(2929,'徐沟镇','101',227),(2930,'东于镇','102',227),(2931,'孟封镇','103',227),(2932,'马峪乡','200',227),(2933,'柳杜乡','201',227),(2934,'西谷乡','202',227),(2935,'王答乡','203',227),(2936,'集义乡','204',227),(2937,'黄寨镇','100',228),(2938,'大盂镇','101',228),(2939,'东黄水镇','102',228),(2940,'泥屯镇','103',228),(2941,'阳曲县社区建设管理办公室','104',228),(2942,'高村乡','200',228),(2943,'侯村乡','201',228),(2944,'凌井店乡','202',228),(2945,'西凌井乡','203',228),(2946,'北小店乡','204',228),(2947,'杨兴乡','205',228),(2948,'娄烦镇','100',229),(2949,'静游镇','101',229),(2950,'杜交曲镇','102',229),(2951,'庙湾乡','200',229),(2952,'马家庄乡','201',229),(2953,'盖家庄乡','202',229),(2954,'米峪镇乡','203',229),(2955,'天池店乡','204',229),(2956,'东曲街道办事处','001',230),(2957,'西曲街道办事处','002',230),(2958,'桃园街道办事处','003',230),(2959,'屯兰街道办事处','004',230),(2960,'河口镇','100',230),(2961,'镇城底镇','101',230),(2962,'马兰镇','102',230),(2963,'阁上乡','200',230),(2964,'加乐泉乡','201',230),(2965,'梭峪乡','202',230),(2966,'岔口乡','203',230),(2967,'常安乡','204',230),(2968,'原相乡','205',230),(2969,'邢家社乡','206',230),(2970,'南关街道办事处','001',232),(2971,'北关街道办事处','002',232),(2972,'东街街道办事处','003',232),(2973,'西街街道办事处','004',232),(2974,'南街街道办事处','005',232),(2975,'北街街道办事处','006',232),(2976,'新建南路街道办事处','007',232),(2977,'新建北路街道办事处','008',232),(2978,'大庆路街道办事处','009',232),(2979,'新华街街道办事处','010',232),(2980,'西花园街道办事处','011',232),(2981,'老平旺街道办事处','012',232),(2982,'向阳里街道办事处','013',232),(2983,'振华街街道办事处','014',232),(2984,'新胜街道办事处','001',233),(2985,'新平旺街道办事处','002',233),(2986,'煤峪口街道办事处','003',233),(2987,'永定庄街道办事处','004',233),(2988,'同家梁街道办事处','005',233),(2989,'四老沟街道办事处','006',233),(2990,'忻州窑街道办事处','007',233),(2991,'白洞街道办事处','008',233),(2992,'雁崖街道办事处','009',233),(2993,'挖金湾街道办事处','010',233),(2994,'晋华宫街道办事处','011',233),(2995,'马脊梁街道办事处','012',233),(2996,'大斗沟街道办事处','013',233),(2997,'王村街道办事处','014',233),(2998,'姜家湾街道办事处','015',233),(2999,'新泉路街道办事处','016',233),(3000,'民胜街道办事处','017',233),(3001,'口泉街道办事处','018',233),(3002,'马口街道办事处','019',233),(3003,'燕子山街道办事处','020',233),(3004,'杏儿沟街道办事处','021',233),(3005,'青磁窑街道办事处','022',233),(3006,'平泉路街道办事处','023',233),(3007,'四台沟街道办事处','024',233),(3008,'古店镇','100',234),(3009,'高山镇','101',234),(3010,'云冈镇','102',234),(3011,'口泉乡','200',234),(3012,'新旺乡','201',234),(3013,'水泊寺乡','202',234),(3014,'马军营乡','205',234),(3015,'西韩岭乡','206',234),(3016,'平旺乡','207',234),(3017,'鸦儿崖乡','210',234),(3018,'新荣区社区服务管理中心','001',235),(3019,'新荣镇','100',235),(3020,'破鲁堡乡','200',235),(3021,'郭家窑乡','202',235),(3022,'花元屯乡','203',235),(3023,'西村乡','206',235),(3024,'上深涧乡','207',235),(3025,'堡子湾乡','209',235),(3026,'龙泉镇','100',236),(3027,'罗文皂镇','101',236),(3028,'大白登镇','102',236),(3029,'王官屯镇','103',236),(3030,'古城镇','104',236),(3031,'东小村镇','105',236),(3032,'友宰镇','106',236),(3033,'长城乡','201',236),(3034,'北徐屯乡','202',236),(3035,'狮子屯乡','204',236),(3036,'下深井乡','209',236),(3037,'马家皂乡','211',236),(3038,'鳌石乡','212',236),(3039,'玉泉镇','100',237),(3040,'谷前堡镇','101',237),(3041,'米薪关镇','102',237),(3042,'逯家湾镇','103',237),(3043,'新平镇','104',237),(3044,'卅里铺乡','200',237),(3045,'南河堡乡','202',237),(3046,'贾家屯乡','204',237),(3047,'赵家沟乡','206',237),(3048,'南高崖乡','208',237),(3049,'张西河乡','209',237),(3050,'壶泉镇','100',238),(3051,'南村镇','101',238),(3052,'斗泉乡','200',238),(3053,'蕉山乡','202',238),(3054,'加斗乡','203',238),(3055,'宜兴乡','206',238),(3056,'作疃乡','207',238),(3057,'梁庄乡','209',238),(3058,'望狐乡','211',238),(3059,'武灵镇','100',239),(3060,'东河南镇','101',239),(3061,'上寨镇','102',239),(3062,'落水河乡','200',239),(3063,'史庄乡','203',239),(3064,'赵北乡','205',239),(3065,'石家田乡','206',239),(3066,'柳科乡','207',239),(3067,'白崖台乡','208',239),(3068,'红石塄乡','210',239),(3069,'下关乡','212',239),(3070,'独峪乡','213',239),(3071,'永安镇','100',240),(3072,'西坊城镇','101',240),(3073,'蔡村镇','102',240),(3074,'沙圪坨镇','103',240),(3075,'王庄堡镇','104',240),(3076,'大磁窑镇','105',240),(3077,'东坊城乡','201',240),(3078,'裴村乡','203',240),(3079,'驼峰乡','204',240),(3080,'西留村乡','205',240),(3081,'下韩村乡','206',240),(3082,'南榆林乡','208',240),(3083,'吴城乡','210',240),(3084,'黄花滩乡','212',240),(3085,'大仁庄乡','213',240),(3086,'千佛岭乡','215',240),(3087,'官儿乡','218',240),(3088,'青磁窑乡','220',240),(3089,'云兴镇','100',241),(3090,'鹊儿山镇','101',241),(3091,'店湾镇','102',241),(3092,'管家堡乡','200',241),(3093,'张家场乡','201',241),(3094,'三屯乡','205',241),(3095,'马道头乡','206',241),(3096,'小京庄乡','207',241),(3097,'水窑乡','209',241),(3098,'湖东街道办事处','001',242),(3099,'东街街道办事处','002',242),(3100,'西街街道办事处','003',242),(3101,'西坪镇','100',242),(3102,'倍加造镇','101',242),(3103,'周士庄镇','102',242),(3104,'吉家庄乡','201',242),(3105,'峰峪乡','202',242),(3106,'杜庄乡','204',242),(3107,'党留庄乡','205',242),(3108,'瓜园乡','207',242),(3109,'巨乐乡','209',242),(3110,'许堡乡','211',242),(3111,'经济技术开发区','400',242),(3112,'上站街道办事处','001',244),(3113,'下站街道办事处','002',244),(3114,'北大街街道办事处','003',244),(3115,'南山路街道办事处','004',244),(3116,'义井街道办事处','005',244),(3117,'坡底街道办事处','006',244),(3118,'平潭街街道办事处','001',245),(3119,'桥头街道办事处','002',245),(3120,'蔡洼街道办事处','003',245),(3121,'赛鱼街道办事处','004',245),(3122,'沙坪街道办事处','005',245),(3123,'贵石沟街道办事处','006',245),(3124,'荫营镇','100',246),(3125,'河底镇','101',246),(3126,'义井镇','102',246),(3127,'平坦镇','103',246),(3128,'西南舁乡','200',246),(3129,'杨家庄乡','201',246),(3130,'李家庄乡','202',246),(3131,'旧街乡','203',246),(3132,'开发区','450',246),(3133,'冠山镇','100',247),(3134,'冶西镇','101',247),(3135,'锁簧镇','102',247),(3136,'张庄镇','103',247),(3137,'东回镇','104',247),(3138,'柏井镇','105',247),(3139,'娘子关镇','106',247),(3140,'巨城镇','107',247),(3141,'石门口乡','200',247),(3142,'岔口乡','201',247),(3143,'秀水镇','100',248),(3144,'孙家庄镇','101',248),(3145,'路家村镇','102',248),(3146,'南娄镇','103',248),(3147,'牛村镇','104',248),(3148,'长池镇','105',248),(3149,'上社镇','106',248),(3150,'西烟镇','107',248),(3151,'仙人乡','200',248),(3152,'北下庄乡','201',248),(3153,'下社乡','202',248),(3154,'梁家寨乡','203',248),(3155,'西潘乡','204',248),(3156,'东梁乡','205',248),(3157,'东街街道办事处','001',250),(3158,'西街街道办事处','002',250),(3159,'英雄南路街道办事处','003',250),(3160,'英雄中路街道办事处','004',250),(3161,'紫金路街道办事处','005',250),(3162,'太东街道办事处','006',250),(3163,'太西街道办事处','007',250),(3164,'延安南路街道办事处','008',250),(3165,'常青街道办事处','009',250),(3166,'五马街道办事处','010',250),(3167,'长治市高新技术开发区','400',250),(3168,'长北街道办事处','001',251),(3169,'故县街道办事处','002',251),(3170,'老顶山镇','100',251),(3171,'堠北庄镇','101',251),(3172,'大辛庄镇','102',251),(3173,'马厂镇','103',251),(3174,'黄碾镇','104',251),(3175,'西白兔乡','200',251),(3176,'韩店镇','100',252),(3177,'苏店镇','101',252),(3178,'荫城镇','102',252),(3179,'西火镇','103',252),(3180,'八义镇','104',252),(3181,'贾掌镇','105',252),(3182,'郝家庄乡','200',252),(3183,'西池乡','201',252),(3184,'北呈乡','202',252),(3185,'东和乡','203',252),(3186,'南宋乡','204',252),(3187,'古韩镇','100',253),(3188,'王桥镇','101',253),(3189,'侯堡镇','102',253),(3190,'夏店镇','103',253),(3191,'虎（音si）亭镇','104',253),(3192,'西营镇','105',253),(3193,'王村镇','106',253),(3194,'下良镇','107',253),(3195,'善福乡','200',253),(3196,'北底乡','201',253),(3197,'上马乡','202',253),(3198,'麟绛镇','100',254),(3199,'上村镇','101',254),(3200,'渔泽镇','102',254),(3201,'余吾镇','103',254),(3202,'吾元镇','104',254),(3203,'张店镇','105',254),(3204,'丰宜镇','106',254),(3205,'李高乡','200',254),(3206,'路村乡','201',254),(3207,'河神庙乡','202',254),(3208,'西贾乡','203',254),(3209,'西流寨开发区','400',254),(3210,'康庄工业园区','401',254),(3211,'上莲开发区','402',254),(3212,'青羊镇','100',255),(3213,'龙溪镇','101',255),(3214,'石城镇','102',255),(3215,'苗庄镇','103',255),(3216,'杏城镇','104',255),(3217,'西沟乡','200',255),(3218,'东寺头乡','201',255),(3219,'虹梯关乡','202',255),(3220,'阳高乡','203',255),(3221,'北耽车乡','204',255),(3222,'中五井乡','205',255),(3223,'北社乡','206',255),(3224,'黎侯镇','100',256),(3225,'东阳关镇','101',256),(3226,'上遥镇','102',256),(3227,'西井镇','103',256),(3228,'黄崖洞镇','104',256),(3229,'西仵乡','200',256),(3230,'停河铺乡','201',256),(3231,'程家山乡','202',256),(3232,'洪井乡','203',256),(3233,'龙泉镇','100',257),(3234,'百尺镇','101',257),(3235,'店上镇','102',257),(3236,'晋庄镇','103',257),(3237,'树掌镇','104',257),(3238,'集店乡','200',257),(3239,'黄山乡','201',257),(3240,'东井岭乡','202',257),(3241,'石坡乡','203',257),(3242,'五龙山乡','204',257),(3243,'鹅屋乡','205',257),(3244,'桥上乡','206',257),(3245,'常平经济开发区','400',257),(3246,'丹朱镇','100',258),(3247,'鲍店镇','101',258),(3248,'石哲镇','102',258),(3249,'大堡头镇','103',258),(3250,'慈林镇','104',258),(3251,'色头镇','105',258),(3252,'南漳镇','106',258),(3253,'岚水乡','200',258),(3254,'碾张乡','201',258),(3255,'常张乡','202',258),(3256,'南陈乡','203',258),(3257,'宋村乡','204',258),(3258,'丰州镇','100',259),(3259,'洪水镇','101',259),(3260,'蟠龙镇','102',259),(3261,'监漳镇','103',259),(3262,'故城镇','104',259),(3263,'墨镫乡','200',259),(3264,'韩北乡','201',259),(3265,'大有乡','202',259),(3266,'贾豁乡','203',259),(3267,'故县乡','204',259),(3268,'上司乡','205',259),(3269,'石北乡','206',259),(3270,'涌泉乡','207',259),(3271,'分水岭乡','208',259),(3272,'定昌镇','100',260),(3273,'郭村镇','101',260),(3274,'故县镇','102',260),(3275,'新店镇','103',260),(3276,'漳源镇','104',260),(3277,'册村镇','105',260),(3278,'段柳乡','200',260),(3279,'松村乡','201',260),(3280,'次村乡','202',260),(3281,'牛寺乡','203',260),(3282,'南里乡','204',260),(3283,'南泉乡','205',260),(3284,'杨安乡','206',260),(3285,'沁河镇','100',261),(3286,'郭道镇','101',261),(3287,'灵空山镇','102',261),(3288,'王和镇','103',261),(3289,'李元镇','104',261),(3290,'中峪乡','200',261),(3291,'法中乡','201',261),(3292,'交口乡','202',261),(3293,'聪子峪乡','203',261),(3294,'韩洪乡','204',261),(3295,'官滩乡','205',261),(3296,'景凤乡','206',261),(3297,'赤石桥乡','207',261),(3298,'王陶乡','208',261),(3299,'潞华办事处','001',262),(3300,'成家川办事处','002',262),(3301,'店上镇','100',262),(3302,'微子镇','101',262),(3303,'辛安泉镇','102',262),(3304,'翟店镇','103',262),(3305,'合室乡','200',262),(3306,'黄牛蹄乡','201',262),(3307,'史回乡','202',262),(3308,'东街街道办事处','001',264),(3309,'西街街道办事处','002',264),(3310,'南街街道办事处','003',264),(3311,'北街街道办事处','004',264),(3312,'矿区街道办事处','005',264),(3313,'钟家庄街道办事处','006',264),(3314,'西上庄街道办事处','007',264),(3315,'北石店镇','100',264),(3316,'龙港镇','100',265),(3317,'中村镇','101',265),(3318,'郑庄镇','102',265),(3319,'端氏镇','103',265),(3320,'嘉峰镇','104',265),(3321,'郑村镇','105',265),(3322,'柿庄镇','106',265),(3323,'樊村河乡','200',265),(3324,'土沃乡','201',265),(3325,'张村乡','202',265),(3326,'苏庄乡','203',265),(3327,'胡底乡','204',265),(3328,'固县乡','205',265),(3329,'十里乡','206',265),(3330,'东城街道办事处','001',266),(3331,'凤城镇','100',266),(3332,'北留镇','101',266),(3333,'润城镇','102',266),(3334,'町店镇','103',266),(3335,'芹池镇','104',266),(3336,'次营镇','105',266),(3337,'横河镇','106',266),(3338,'河北镇','107',266),(3339,'蟒河镇','108',266),(3340,'东冶镇','109',266),(3341,'白桑乡','200',266),(3342,'寺头乡','201',266),(3343,'西河乡','202',266),(3344,'演礼乡','203',266),(3345,'固隆乡','204',266),(3346,'董封乡','205',266),(3347,'驾岭乡','206',266),(3348,'崇文镇','100',267),(3349,'礼义镇','101',267),(3350,'附城镇','102',267),(3351,'西河底镇','103',267),(3352,'平城镇','104',267),(3353,'杨村镇','105',267),(3354,'潞城镇','106',267),(3355,'夺火乡','204',267),(3356,'马圪当乡','206',267),(3357,'古郊乡','207',267),(3358,'六泉乡','209',267),(3359,'秦家庄乡','212',267),(3360,'南村镇','100',268),(3361,'下村镇','101',268),(3362,'大东沟镇','102',268),(3363,'周村镇','103',268),(3364,'犁川镇','104',268),(3365,'晋庙铺镇','105',268),(3366,'金村镇','106',268),(3367,'高都镇','107',268),(3368,'巴公镇','108',268),(3369,'大阳镇','109',268),(3370,'山河镇','110',268),(3371,'大箕镇','111',268),(3372,'柳树口镇','112',268),(3373,'北义城镇','113',268),(3374,'川底乡','200',268),(3375,'李寨乡','201',268),(3376,'南岭乡','202',268),(3377,'北城街道办事处','001',269),(3378,'东城街道办事处','002',269),(3379,'南城街道办事处','003',269),(3380,'米山镇','101',269),(3381,'三甲镇','102',269),(3382,'神农镇','103',269),(3383,'陈区镇','104',269),(3384,'北诗镇','105',269),(3385,'河西镇','106',269),(3386,'马村镇','107',269),(3387,'野川镇','108',269),(3388,'寺庄镇','109',269),(3389,'建宁乡','201',269),(3390,'石末乡','202',269),(3391,'原村乡','203',269),(3392,'永录乡','204',269),(3393,'朔城区北城街道办事处','001',271),(3394,'朔城区南城街道办事处','002',271),(3395,'朔城区神头街道办事处','003',271),(3396,'朔城区北旺庄街道办事处','004',271),(3397,'朔城区神头镇','100',271),(3398,'朔城区利民镇','101',271),(3399,'朔城区下团堡乡','200',271),(3400,'朔城区小平易乡','201',271),(3401,'朔城区滋润乡','202',271),(3402,'朔城区福善庄乡','203',271),(3403,'朔城区南榆林乡','204',271),(3404,'朔城区贾庄乡','205',271),(3405,'朔城区沙塄河乡','206',271),(3406,'朔城区窑子头乡','207',271),(3407,'朔城区张蔡庄乡','208',271),(3408,'朔州市开发区管委会','400',271),(3409,'平鲁区井坪镇','100',272),(3410,'平鲁区凤凰城镇','101',272),(3411,'平鲁区白堂乡','200',272),(3412,'平鲁区陶村乡','201',272),(3413,'平鲁区下水头乡','202',272),(3414,'平鲁区双碾乡','203',272),(3415,'平鲁区阻虎乡','204',272),(3416,'平鲁区高石庄乡','205',272),(3417,'平鲁区西水界乡','206',272),(3418,'平鲁区下面高乡','207',272),(3419,'平鲁区下木角乡','208',272),(3420,'平鲁区向阳堡乡','209',272),(3421,'平鲁区榆岭乡','210',272),(3422,'山阴县东城管委会','001',273),(3423,'山阴县西城管委会','002',273),(3424,'山阴县玉井镇','100',273),(3425,'山阴县北周庄镇','101',273),(3426,'山阴县古城镇','102',273),(3427,'山阴县吴马营乡','200',273),(3428,'山阴县马营乡','201',273),(3429,'山阴县下喇叭乡','202',273),(3430,'山阴县合盛堡乡','203',273),(3431,'山阴县岱岳乡','204',273),(3432,'山阴县安荣乡','205',273),(3433,'山阴县薛OO乡','206',273),(3434,'山阴县后所乡','207',273),(3435,'山阴县张家庄乡','208',273),(3436,'山阴县马营庄乡','209',273),(3437,'应县金城镇','100',274),(3438,'应县南河种镇','101',274),(3439,'应县下社镇','102',274),(3440,'应县镇子梁乡','200',274),(3441,'应县义井乡','201',274),(3442,'应县藏寨乡','202',274),(3443,'应县大黄巍乡','203',274),(3444,'应县杏寨乡','204',274),(3445,'应县下马峪乡','205',274),(3446,'应县南泉乡','206',274),(3447,'应县大临河乡','207',274),(3448,'应县白马石乡','208',274),(3449,'右玉县新城镇','100',275),(3450,'右玉县右卫镇','101',275),(3451,'右玉县威远镇','102',275),(3452,'右玉县元堡子镇','103',275),(3453,'右玉县牛心堡乡','200',275),(3454,'右玉县白头里乡','201',275),(3455,'右玉县高家堡乡','202',275),(3456,'右玉县丁家窑乡','203',275),(3457,'右玉县杨千河乡','204',275),(3458,'右玉县李达窑乡','205',275),(3459,'怀仁县云中镇','100',276),(3460,'怀仁县吴家窑镇','101',276),(3461,'怀仁县金沙滩镇','102',276),(3462,'怀仁县毛家皂镇','103',276),(3463,'怀仁县何家堡乡','200',276),(3464,'怀仁县新家园乡','201',276),(3465,'怀仁县亲和乡','202',276),(3466,'怀仁县海北头乡','203',276),(3467,'怀仁县马辛庄乡','204',276),(3468,'怀仁县河头乡','205',276),(3469,'怀仁县金沙滩农牧场','500',276),(3470,'怀仁县金沙滩林场','501',276),(3471,'北关街道办事处','001',278),(3472,'锦纶街道办事处','002',278),(3473,'新华街道办事处','003',278),(3474,'西南街道办事处','004',278),(3475,'路西街道办事处','005',278),(3476,'经纬街道办事处','006',278),(3477,'安宁街道办事处','007',278),(3478,'新建街道办事处','008',278),(3479,'晋华街道办事处','009',278),(3480,'乌金山镇','100',278),(3481,'东阳镇','101',278),(3482,'什贴镇','102',278),(3483,'长凝镇','103',278),(3484,'北田镇','104',278),(3485,'修文镇','105',278),(3486,'郭家堡乡','200',278),(3487,'张庆乡','201',278),(3488,'庄子乡','202',278),(3489,'东赵乡','203',278),(3490,'晋中经济开发区','400',278),(3491,'城区街道管理委员会','001',279),(3492,'箕城镇','100',279),(3493,'云竹镇','101',279),(3494,'郝北镇','102',279),(3495,'社城镇','103',279),(3496,'河峪乡','200',279),(3497,'北寨乡','201',279),(3498,'西马乡','202',279),(3499,'岚峪乡','203',279),(3500,'讲堂乡','204',279),(3501,'县城街道社区管理委员会','001',280),(3502,'辽阳镇','100',280),(3503,'桐峪镇','101',280),(3504,'麻田镇','102',280),(3505,'芹泉镇','103',280),(3506,'拐儿镇','104',280),(3507,'寒王乡','200',280),(3508,'石匣乡','201',280),(3509,'龙泉乡','202',280),(3510,'粟城乡','203',280),(3511,'羊角乡','204',280),(3512,'义兴镇','100',281),(3513,'李阳镇','101',281),(3514,'松烟镇','102',281),(3515,'青城镇','103',281),(3516,'横岭镇','104',281),(3517,'喂马乡','200',281),(3518,'平松乡','201',281),(3519,'牛川乡','202',281),(3520,'马坊乡','203',281),(3521,'阳光占乡','204',281),(3522,'乐平镇','100',282),(3523,'皋落镇','101',282),(3524,'冶头镇','102',282),(3525,'沾尚镇','103',282),(3526,'大寨镇','104',282),(3527,'李家庄乡','200',282),(3528,'界都乡','201',282),(3529,'三都乡','202',282),(3530,'赵壁乡','203',282),(3531,'孔氏乡','204',282),(3532,'阎庄乡','205',282),(3533,'西寨乡','206',282),(3534,'朝阳镇','100',283),(3535,'南燕竹镇','101',283),(3536,'宗艾镇','102',283),(3537,'平头镇','103',283),(3538,'松塔镇','104',283),(3539,'西洛镇','105',283),(3540,'尹灵芝镇','106',283),(3541,'平舒乡','200',283),(3542,'解愁乡','201',283),(3543,'温家庄乡','202',283),(3544,'景尚乡','203',283),(3545,'上湖乡','204',283),(3546,'羊头崖乡','205',283),(3547,'马首乡','206',283),(3548,'明星镇','100',284),(3549,'胡村镇','101',284),(3550,'范村镇','102',284),(3551,'侯城乡','200',284),(3552,'北汪乡','201',284),(3553,'水秀乡','202',284),(3554,'阳邑乡','203',284),(3555,'小白乡','204',284),(3556,'任村乡','205',284),(3557,'昭馀镇','100',285),(3558,'东观镇','101',285),(3559,'古县镇','102',285),(3560,'贾令镇','103',285),(3561,'城赵镇','104',285),(3562,'来远镇','105',285),(3563,'西六支乡','200',285),(3564,'峪口乡','201',285),(3565,'古陶镇','100',286),(3566,'段村镇','101',286),(3567,'东泉镇','102',286),(3568,'洪善镇','103',286),(3569,'宁固镇','104',286),(3570,'南政乡','200',286),(3571,'中都乡','201',286),(3572,'岳壁乡','202',286),(3573,'卜宜乡','203',286),(3574,'孟山乡','204',286),(3575,'朱坑乡','205',286),(3576,'襄垣乡','206',286),(3577,'杜家庄乡','207',286),(3578,'香乐乡','208',286),(3579,'翠峰镇','100',287),(3580,'静升镇','101',287),(3581,'两渡镇','102',287),(3582,'夏门镇','103',287),(3583,'南关镇','104',287),(3584,'段纯镇','105',287),(3585,'马和乡','200',287),(3586,'英武乡','201',287),(3587,'王禹乡','202',287),(3588,'坛镇乡','203',287),(3589,'梁家焉乡','204',287),(3590,'交口乡','205',287),(3591,'北关街道办事处','001',288),(3592,'西关街道办事处','002',288),(3593,'东南街道办事处','003',288),(3594,'西南街道办事处','004',288),(3595,'北坛街道办事处','005',288),(3596,'义安镇','100',288),(3597,'张兰镇','101',288),(3598,'连福镇','102',288),(3599,'洪山镇','103',288),(3600,'龙凤镇','104',288),(3601,'绵山镇','105',288),(3602,'义棠镇','106',288),(3603,'城关乡','200',288),(3604,'宋古乡','201',288),(3605,'三佳乡','202',288),(3606,'山西省种羊场','400',288),(3607,'中城街道办事处','001',290),(3608,'东城街道办事处','002',290),(3609,'西城街道办事处','003',290),(3610,'南城街道办事处','004',290),(3611,'北城街道办事处','005',290),(3612,'安邑街道办事处','006',290),(3613,'大渠街道办事处','007',290),(3614,'姚孟街道办事处','008',290),(3615,'解州镇政府','100',290),(3616,'龙居镇政府','101',290),(3617,'北相镇政府','102',290),(3618,'泓芝驿镇政府','103',290),(3619,'三路里镇政府','104',290),(3620,'陶村镇政府','105',290),(3621,'东郭镇政府','106',290),(3622,'席张乡政府','200',290),(3623,'金井乡政府','201',290),(3624,'王范乡政府','202',290),(3625,'冯村乡政府','203',290),(3626,'上郭乡政府','204',290),(3627,'上王乡政府','205',290),(3628,'禹都经济技术开发区','400',290),(3629,'猗氏镇','100',291),(3630,'嵋阳镇','101',291),(3631,'临晋镇','102',291),(3632,'七级镇','103',291),(3633,'东张镇','104',291),(3634,'孙吉镇','105',291),(3635,'三管镇','106',291),(3636,'耽子镇','107',291),(3637,'楚候乡','200',291),(3638,'庙上乡','201',291),(3639,'角杯乡','202',291),(3640,'北辛乡','203',291),(3641,'北景乡','204',291),(3642,'牛杜工贸区','400',291),(3643,'卓里工贸区','401',291),(3644,'闫家庄工贸区','402',291),(3645,'解店镇','100',292),(3646,'通化镇','101',292),(3647,'汉薛镇','102',292),(3648,'荣河镇','103',292),(3649,'万泉乡','200',292),(3650,'里望乡','201',292),(3651,'西村乡','202',292),(3652,'南张乡','203',292),(3653,'高村乡','204',292),(3654,'皇甫乡','205',292),(3655,'贾村乡','206',292),(3656,'王显乡','207',292),(3657,'光华乡','208',292),(3658,'裴庄乡','209',292),(3659,'桐城镇','100',293),(3660,'郭家庄镇','101',293),(3661,'凹底镇','102',293),(3662,'薛店镇','103',293),(3663,'东镇镇','104',293),(3664,'礼元镇','105',293),(3665,'河底镇','106',293),(3666,'神柏乡','200',293),(3667,'阳隅乡','201',293),(3668,'侯村乡','202',293),(3669,'裴社乡','203',293),(3670,'后宫乡','204',293),(3671,'石门乡','205',293),(3672,'稷峰镇','100',294),(3673,'西社镇','101',294),(3674,'化峪镇','102',294),(3675,'翟店镇','103',294),(3676,'清河镇','104',294),(3677,'蔡村乡','200',294),(3678,'太阳乡','201',294),(3679,'龙兴镇','100',295),(3680,'三泉镇','101',295),(3681,'泽掌镇','102',295),(3682,'北张镇','103',295),(3683,'横桥镇','104',295),(3684,'万安镇','105',295),(3685,'阳王镇','106',295),(3686,'古交乡','200',295),(3687,'古绛镇','100',296),(3688,'横水镇','101',296),(3689,'陈村镇','102',296),(3690,'卫庄镇','103',296),(3691,'么里镇','104',296),(3692,'南樊镇','105',296),(3693,'安峪镇','106',296),(3694,'大交镇','107',296),(3695,'郝庄乡','200',296),(3696,'冷口乡','201',296),(3697,'新城镇','100',297),(3698,'历山镇','101',297),(3699,'古城镇','102',297),(3700,'王茅镇','103',297),(3701,'毛家镇','104',297),(3702,'蒲掌乡','200',297),(3703,'英言乡','201',297),(3704,'解峪乡','202',297),(3705,'华峰乡','203',297),(3706,'长直乡','204',297),(3707,'皋落乡','205',297),(3708,'瑶峰镇','100',298),(3709,'庙前镇','101',298),(3710,'裴介镇','102',298),(3711,'水头镇','103',298),(3712,'埝掌镇','104',298),(3713,'泗交镇','105',298),(3714,'尉郭乡','200',298),(3715,'禹王乡','201',298),(3716,'胡张乡','202',298),(3717,'南大里乡','203',298),(3718,'祁家河乡','204',298),(3719,'圣人涧镇','100',299),(3720,'常乐镇','101',299),(3721,'张店镇','102',299),(3722,'张村镇','103',299),(3723,'曹川镇','104',299),(3724,'三门镇','105',299),(3725,'洪池乡','200',299),(3726,'杜马乡','201',299),(3727,'部官乡','202',299),(3728,'坡底乡','203',299),(3729,'古巍镇','100',300),(3730,'风陵渡镇','101',300),(3731,'陌南镇','102',300),(3732,'西陌镇','103',300),(3733,'永乐镇','104',300),(3734,'大王镇','105',300),(3735,'阳城镇','106',300),(3736,'东垆乡','200',300),(3737,'南卫乡','201',300),(3738,'学张乡','202',300),(3739,'城西街道办事处','001',301),(3740,'城北街道办事处','002',301),(3741,'城东街道办事处','003',301),(3742,'于乡镇','100',301),(3743,'卿头镇','101',301),(3744,'开张镇','102',301),(3745,'栲栳镇','103',301),(3746,'蒲州镇','104',301),(3747,'韩阳镇','105',301),(3748,'张营镇','106',301),(3749,'农场虚拟区','400',301),(3750,'城区街道办事处','001',302),(3751,'清涧街道办事处','002',302),(3752,'樊村镇','100',302),(3753,'僧楼镇','101',302),(3754,'小梁乡','200',302),(3755,'柴家乡','201',302),(3756,'赵家庄乡','202',302),(3757,'下化乡','203',302),(3758,'阳村乡','204',302),(3759,'山西铝厂虚拟镇','400',302),(3760,'南城街道办事处','001',304),(3761,'长征街街道办事处','002',304),(3762,'新建路街道办事处','003',304),(3763,'播明镇','100',304),(3764,'奇村镇','101',304),(3765,'三交镇','102',304),(3766,'庄磨镇','103',304),(3767,'豆罗镇','104',304),(3768,'董村镇','105',304),(3769,'曹张乡','200',304),(3770,'高城乡','201',304),(3771,'秦城乡','202',304),(3772,'解原乡','203',304),(3773,'合索乡','204',304),(3774,'阳坡乡','205',304),(3775,'兰村乡','206',304),(3776,'紫岩乡','207',304),(3777,'西张乡','208',304),(3778,'东楼乡','209',304),(3779,'北义井乡','210',304),(3780,'晋昌镇','100',305),(3781,'河边镇','101',305),(3782,'宏道镇','102',305),(3783,'杨芳乡','200',305),(3784,'南王乡','201',305),(3785,'蒋村乡','202',305),(3786,'神山乡','203',305),(3787,'季庄乡','204',305),(3788,'受录乡','205',305),(3789,'台城镇','100',306),(3790,'台怀镇','101',306),(3791,'耿镇镇','102',306),(3792,'豆村镇','103',306),(3793,'白家庄镇','104',306),(3794,'东冶镇','105',306),(3795,'沟南乡','200',306),(3796,'东雷乡','201',306),(3797,'高洪口乡','202',306),(3798,'门限石乡','203',306),(3799,'陈家庄乡','204',306),(3800,'建安乡','205',306),(3801,'神西乡','206',306),(3802,'蒋坊乡','207',306),(3803,'灵境乡','208',306),(3804,'阳白乡','209',306),(3805,'茹村乡','210',306),(3806,'石咀乡','211',306),(3807,'金岗库乡','212',306),(3808,'上馆镇','100',307),(3809,'阳明堡镇','101',307),(3810,'峨口镇','102',307),(3811,'聂营镇','103',307),(3812,'枣林镇','104',307),(3813,'滩上镇','105',307),(3814,'新高乡','200',307),(3815,'峪口乡','201',307),(3816,'磨坊乡','202',307),(3817,'胡峪乡','203',307),(3818,'雁门关乡','204',307),(3819,'繁峙县繁城镇','100',308),(3820,'繁峙县砂河镇','101',308),(3821,'繁峙县大营镇','102',308),(3822,'繁峙县下茹越乡','200',308),(3823,'繁峙县杏园乡','201',308),(3824,'繁峙县光裕堡乡','202',308),(3825,'繁峙县集义庄乡','203',308),(3826,'繁峙县东山乡','204',308),(3827,'繁峙县金山铺乡','205',308),(3828,'繁峙县柏家庄乡','206',308),(3829,'繁峙县横涧乡','207',308),(3830,'繁峙县神堂堡乡','208',308),(3831,'繁峙县岩头乡','209',308),(3832,'街道办事处','001',309),(3833,'凤凰镇','100',309),(3834,'阳方口镇','101',309),(3835,'东寨镇','102',309),(3836,'石家庄镇','103',309),(3837,'薛家洼乡','200',309),(3838,'余庄乡','201',309),(3839,'涔山乡','202',309),(3840,'化北屯乡','203',309),(3841,'西马坊乡','204',309),(3842,'新堡乡','205',309),(3843,'迭台寺乡','206',309),(3844,'圪廖乡','207',309),(3845,'怀道乡','208',309),(3846,'东马坊乡','209',309),(3847,'阳方口煤矿生活区','400',309),(3848,'鹅城镇','100',310),(3849,'杜家村镇','101',310),(3850,'康家会镇','102',310),(3851,'丰润镇','103',310),(3852,'堂尔上乡','201',310),(3853,'中庄乡','202',310),(3854,'双路乡','203',310),(3855,'段家寨乡','204',310),(3856,'辛村乡','205',310),(3857,'王村乡','206',310),(3858,'神峪沟乡','207',310),(3859,'娘子神乡','208',310),(3860,'娑婆乡','209',310),(3861,'赤泥洼乡','210',310),(3862,'龙泉镇','100',311),(3863,'义井镇','101',311),(3864,'八角镇','102',311),(3865,'东湖乡','200',311),(3866,'太平庄乡','201',311),(3867,'虎北乡','202',311),(3868,'贺职乡','203',311),(3869,'长畛乡','204',311),(3870,'烈堡乡','205',311),(3871,'大严备乡','206',311),(3872,'五寨县砚城镇','100',312),(3873,'五寨县小河头镇','101',312),(3874,'五寨县三岔镇','102',312),(3875,'五寨县前所乡','200',312),(3876,'五寨县李家坪乡','201',312),(3877,'五寨县孙家坪乡','202',312),(3878,'五寨县梁家坪乡','203',312),(3879,'五寨县胡会乡','204',312),(3880,'五寨县新寨乡','205',312),(3881,'五寨县韩家楼乡','206',312),(3882,'五寨县东秀庄乡','207',312),(3883,'五寨县杏岭子乡','208',312),(3884,'岚漪镇','100',313),(3885,'三井镇','101',313),(3886,'神堂坪乡','200',313),(3887,'高家会乡','201',313),(3888,'李家沟乡','202',313),(3889,'水峪贯乡','203',313),(3890,'西豹峪乡','204',313),(3891,'温泉乡','205',313),(3892,'阳坪乡','206',313),(3893,'大涧乡','207',313),(3894,'宋家沟乡','208',313),(3895,'王家岔乡','209',313),(3896,'文笔镇','100',314),(3897,'楼子营镇','101',314),(3898,'刘家塔镇','102',314),(3899,'巡镇镇','103',314),(3900,'鹿固乡','200',314),(3901,'前川乡','201',314),(3902,'单寨乡','202',314),(3903,'土沟乡','203',314),(3904,'旧县乡','204',314),(3905,'沙坪乡','205',314),(3906,'社梁乡','206',314),(3907,'沙泉乡','207',314),(3908,'赵家沟乡','208',314),(3909,'东关镇','100',315),(3910,'义门镇','101',315),(3911,'桥头镇','102',315),(3912,'杨家湾镇','103',315),(3913,'腰庄乡','200',315),(3914,'韩家川乡','201',315),(3915,'林遮峪乡','202',315),(3916,'冯家川乡','203',315),(3917,'土崖塔乡','204',315),(3918,'孙家沟乡','205',315),(3919,'窑洼乡','206',315),(3920,'尧圪台乡','207',315),(3921,'南河沟乡','208',315),(3922,'新关镇','100',316),(3923,'天峰坪镇','101',316),(3924,'老营镇','102',316),(3925,'万家寨镇','103',316),(3926,'窑头乡','200',316),(3927,'楼沟乡','201',316),(3928,'尚峪乡','202',316),(3929,'南堡子乡','203',316),(3930,'水泉乡','204',316),(3931,'陈家营乡','205',316),(3932,'北城街道办事处','001',317),(3933,'南城街道办事处','002',317),(3934,'东社镇','100',317),(3935,'苏龙口镇','101',317),(3936,'崞阳镇','102',317),(3937,'大牛店镇','103',317),(3938,'闫庄镇','104',317),(3939,'长梁沟镇','105',317),(3940,'轩岗镇','106',317),(3941,'新原乡','200',317),(3942,'南白乡','201',317),(3943,'子干乡','202',317),(3944,'中阳乡','203',317),(3945,'沿沟乡','204',317),(3946,'大林乡','205',317),(3947,'西镇乡','206',317),(3948,'解村乡','207',317),(3949,'王家庄乡','208',317),(3950,'楼板寨乡','209',317),(3951,'段家堡乡','210',317),(3952,'山西鲁能晋北铝业工矿区','400',317),(3953,'原平市石豹沟煤矿工矿区','401',317),(3954,'同煤集团轩岗煤电有限公司工矿区','402',317),(3955,'解放路街道办事处','001',319),(3956,'鼓楼西街街道办事处','002',319),(3957,'水塔街街道办事处','003',319),(3958,'南街街道办事处','004',319),(3959,'乡贤街街道办事处','005',319),(3960,'辛寺街街道办事处','006',319),(3961,'铁路东街道办事处','007',319),(3962,'车站街街道办事处','008',319),(3963,'汾河街道办事处','009',319),(3964,'屯里镇','100',319),(3965,'乔李镇','101',319),(3966,'大阳镇','102',319),(3967,'县底镇','103',319),(3968,'刘村镇','104',319),(3969,'金殿镇','105',319),(3970,'吴村镇','106',319),(3971,'土门镇','107',319),(3972,'魏村镇','108',319),(3973,'尧庙镇','109',319),(3974,'段店乡','200',319),(3975,'贾得乡','201',319),(3976,'贺家庄乡','202',319),(3977,'一平垣乡','203',319),(3978,'枕头乡','204',319),(3979,'河底乡','205',319),(3980,'滨河办事处(临汾经济开发区)','400',319),(3981,'乐昌镇','100',320),(3982,'史村镇','101',320),(3983,'曲村镇','102',320),(3984,'高显镇','103',320),(3985,'里村镇','104',320),(3986,'北董乡','200',320),(3987,'杨谈乡','201',320),(3988,'唐兴镇','100',321),(3989,'南梁镇','101',321),(3990,'里寨镇','102',321),(3991,'隆化镇','103',321),(3992,'桥上镇','104',321),(3993,'西闫镇','105',321),(3994,'中卫乡','200',321),(3995,'南唐乡','201',321),(3996,'王庄乡','202',321),(3997,'浇底乡','203',321),(3998,'新城镇','100',322),(3999,'赵康镇','101',322),(4000,'汾城镇','102',322),(4001,'南贾镇','103',322),(4002,'古城镇','104',322),(4003,'襄陵镇','105',322),(4004,'邓庄镇','106',322),(4005,'陶寺乡','200',322),(4006,'永固乡','201',322),(4007,'景毛乡','202',322),(4008,'西贾乡','203',322),(4009,'南辛店乡','204',322),(4010,'大邓乡','205',322),(4011,'大槐树镇','100',323),(4012,'甘亭镇','101',323),(4013,'曲亭镇','102',323),(4014,'苏堡镇','103',323),(4015,'广胜寺镇','104',323),(4016,'明姜镇','105',323),(4017,'赵城镇','106',323),(4018,'万安镇','107',323),(4019,'刘家垣镇','108',323),(4020,'淹底乡','200',323),(4021,'兴唐寺乡','201',323),(4022,'堤村乡','202',323),(4023,'辛村乡','203',323),(4024,'龙马乡','204',323),(4025,'山头乡','205',323),(4026,'左木乡','206',323),(4027,'岳阳镇','100',324),(4028,'北平镇','101',324),(4029,'古阳镇','102',324),(4030,'旧县镇','103',324),(4031,'石壁乡','200',324),(4032,'永乐乡','201',324),(4033,'南垣乡','202',324),(4034,'府城镇','100',325),(4035,'和川镇','101',325),(4036,'唐城镇','102',325),(4037,'冀氏镇','103',325),(4038,'马必乡','200',325),(4039,'杜村乡','201',325),(4040,'良马乡','202',325),(4041,'天坛镇','100',326),(4042,'响水河镇','101',326),(4043,'张庄乡','200',326),(4044,'东张乡','201',326),(4045,'槐埝乡','202',326),(4046,'北王乡','203',326),(4047,'北韩乡','204',326),(4048,'米家垣乡','205',326),(4049,'寨圪塔乡','206',326),(4050,'吉昌镇','100',327),(4051,'屯里镇','101',327),(4052,'壶口镇','102',327),(4053,'车城乡','200',327),(4054,'文城乡','201',327),(4055,'东城乡','202',327),(4056,'柏山寺乡','203',327),(4057,'中垛乡','204',327),(4058,'昌宁镇','100',328),(4059,'光华镇','101',328),(4060,'台头镇','102',328),(4061,'管头镇','103',328),(4062,'西坡镇','104',328),(4063,'双鹤乡','200',328),(4064,'关王庙乡','201',328),(4065,'尉庄乡','202',328),(4066,'西交口乡','203',328),(4067,'枣岭乡','204',328),(4068,'昕水镇','100',329),(4069,'曲峨镇','101',329),(4070,'三多乡','200',329),(4071,'太德乡','201',329),(4072,'徐家垛乡','202',329),(4073,'太古乡','203',329),(4074,'龙泉镇','100',330),(4075,'午城镇','101',330),(4076,'黄土镇','102',330),(4077,'阳头升乡','200',330),(4078,'寨子乡','201',330),(4079,'陡坡乡','202',330),(4080,'下李乡','203',330),(4081,'城南乡','204',330),(4082,'芝河镇','100',331),(4083,'桑壁镇','101',331),(4084,'阁底乡','200',331),(4085,'南庄乡','201',331),(4086,'打石腰乡','202',331),(4087,'坡头乡','203',331),(4088,'交口乡','204',331),(4089,'蒲城镇','100',332),(4090,'薛关镇','101',332),(4091,'黑龙关镇','102',332),(4092,'克城镇','103',332),(4093,'山中乡','200',332),(4094,'古县乡','201',332),(4095,'红道乡','202',332),(4096,'乔家湾乡','203',332),(4097,'太林乡','204',332),(4098,'永安镇','100',333),(4099,'对竹镇','101',333),(4100,'和平镇','103',333),(4101,'僧念镇','104',333),(4102,'佃坪乡','200',333),(4103,'团柏乡','201',333),(4104,'邢家要乡','202',333),(4105,'路东街道办事处','001',334),(4106,'路西街道办事处','002',334),(4107,'浍滨街道办事处','003',334),(4108,'上马街道办事处','004',334),(4109,'张村街道办事处','005',334),(4110,'新田乡','200',334),(4111,'高村乡','201',334),(4112,'凤城乡','202',334),(4113,'鼓楼街道办事处','001',335),(4114,'北环路街道办事处','002',335),(4115,'南环路街道办事处','003',335),(4116,'开元街道办事','004',335),(4117,'退沙街道办事处','005',335),(4118,'白龙镇','100',335),(4119,'辛置镇','101',335),(4120,'大张镇','102',335),(4121,'李曹镇','103',335),(4122,'陶唐峪乡','200',335),(4123,'三教乡','201',335),(4124,'师庄乡','202',335),(4125,'滨河街道办事处','001',337),(4126,'凤山街道办事处','002',337),(4127,'莲花池街道办事处','003',337),(4128,'城北街道办事处','004',337),(4129,'田家会街道办事处','005',337),(4130,'交口街道办事处','006',337),(4131,'西属巴街道办事处','007',337),(4132,'吴城镇','100',337),(4133,'信义镇','101',337),(4134,'红眼川乡','200',337),(4135,'枣林乡','201',337),(4136,'坪头乡','202',337),(4137,'凤城镇','100',338),(4138,'开栅镇','101',338),(4139,'南庄镇','102',338),(4140,'南安镇','103',338),(4141,'刘胡兰镇','104',338),(4142,'下曲镇','105',338),(4143,'孝义镇','106',338),(4144,'南武乡','200',338),(4145,'西城乡','201',338),(4146,'北张乡','202',338),(4147,'马西乡','203',338),(4148,'西槽头乡','204',338),(4149,'天宁镇','100',339),(4150,'夏家营镇','101',339),(4151,'西营镇','102',339),(4152,'水峪贯镇','103',339),(4153,'西社镇','104',339),(4154,'庞泉沟镇','105',339),(4155,'洪相乡','200',339),(4156,'岭底乡','201',339),(4157,'东坡底乡','202',339),(4158,'会立乡','203',339),(4159,'蔚汾镇','100',340),(4160,'魏家滩镇','101',340),(4161,'瓦塘镇','102',340),(4162,'康宁镇','103',340),(4163,'高家村镇','104',340),(4164,'罗峪口镇','105',340),(4165,'蔡家会镇','106',340),(4166,'交楼申乡','200',340),(4167,'恶虎滩乡','201',340),(4168,'东会乡','202',340),(4169,'固贤乡','203',340),(4170,'奥家湾乡','204',340),(4171,'蔡家崖乡','205',340),(4172,'贺家会乡','206',340),(4173,'孟家坪乡','207',340),(4174,'赵家坪乡','208',340),(4175,'圪','209',340),(4176,'临泉镇','100',341),(4177,'白文镇','101',341),(4178,'城庄镇','102',341),(4179,'兔坂镇','103',341),(4180,'克虎镇','104',341),(4181,'三交镇','105',341),(4182,'湍水头镇','106',341),(4183,'林家坪镇','107',341),(4184,'招贤镇','108',341),(4185,'碛口镇','109',341),(4186,'刘家会镇','110',341),(4187,'丛罗峪镇','111',341),(4188,'曲峪镇','112',341),(4189,'木瓜坪乡','200',341),(4190,'安业乡','201',341),(4191,'玉坪乡','202',341),(4192,'青凉寺乡','203',341),(4193,'石白头乡','204',341),(4194,'雷家碛乡','205',341),(4195,'第八堡乡','206',341),(4196,'大禹乡','207',341),(4197,'车赶乡','208',341),(4198,'安家庄乡','209',341),(4199,'柳林镇','100',342),(4200,'穆村镇','101',342),(4201,'薛村镇','102',342),(4202,'庄上镇','103',342),(4203,'留誉镇','104',342),(4204,'三交镇','105',342),(4205,'成家庄镇','106',342),(4206,'孟门镇','107',342),(4207,'李家湾乡','200',342),(4208,'贾家垣乡','201',342),(4209,'陈家湾乡','202',342),(4210,'金家庄乡','203',342),(4211,'高家沟乡','204',342),(4212,'石西乡','205',342),(4213,'王家沟乡','206',342),(4214,'灵泉镇','100',343),(4215,'罗村镇','101',343),(4216,'义牒镇','102',343),(4217,'小蒜镇','103',343),(4218,'龙交乡','200',343),(4219,'和合乡','201',343),(4220,'前山乡','202',343),(4221,'曹家垣乡','203',343),(4222,'裴沟乡','204',343),(4223,'东村镇','100',344),(4224,'岚城镇','101',344),(4225,'普明镇','102',344),(4226,'界河口镇','103',344),(4227,'土峪乡','200',344),(4228,'上明乡','201',344),(4229,'王狮乡','202',344),(4230,'梁家庄乡','203',344),(4231,'顺会乡','204',344),(4232,'河口乡','205',344),(4233,'社科乡','206',344),(4234,'大蛇头乡','207',344),(4235,'圪洞镇','100',345),(4236,'马坊镇','101',345),(4237,'峪口镇','102',345),(4238,'大武镇','103',345),(4239,'北武当镇','104',345),(4240,'积翠乡','200',345),(4241,'麻地会乡','201',345),(4242,'宁乡镇','100',346),(4243,'金罗镇','101',346),(4244,'枝柯镇','102',346),(4245,'武家庄镇','103',346),(4246,'暖泉镇','104',346),(4247,'张子山乡','200',346),(4248,'下枣林乡','201',346),(4249,'水头镇','100',347),(4250,'康城镇','101',347),(4251,'双池镇','102',347),(4252,'桃红坡镇','103',347),(4253,'石口乡','200',347),(4254,'回龙乡','201',347),(4255,'温泉乡','202',347),(4256,'新义街道办事处','001',348),(4257,'中阳楼街道办事处','002',348),(4258,'振兴街道办事处','003',348),(4259,'东许街道办事处','004',348),(4260,'兑镇镇','100',348),(4261,'阳泉曲镇','101',348),(4262,'下堡镇','102',348),(4263,'西辛庄镇','103',348),(4264,'高阳镇','104',348),(4265,'梧桐镇','105',348),(4266,'柱濮镇','106',348),(4267,'大孝堡乡','200',348),(4268,'下栅乡','201',348),(4269,'驿马乡','202',348),(4270,'南阳乡','203',348),(4271,'杜村乡','204',348),(4272,'文峰街道办事处','001',349),(4273,'太和桥街道办事处','002',349),(4274,'贾家庄镇','100',349),(4275,'杏花村镇','101',349),(4276,'冀村镇','102',349),(4277,'肖家庄镇','103',349),(4278,'演武镇','104',349),(4279,'三泉镇','105',349),(4280,'石庄镇','106',349),(4281,'杨家庄镇','107',349),(4282,'峪道河镇','108',349),(4283,'西河乡','200',349),(4284,'阳城乡','201',349),(4285,'栗家庄乡','202',349),(4286,'海拉尔东路街道办事处','001',351),(4287,'锡林路办事处','002',351),(4288,'中山东路街道办事处','003',351),(4289,'东街街道办事处','004',351),(4290,'西街街道办事处','005',351),(4291,'东风路街道办事处','006',351),(4292,'迎新路街道办事处','007',351),(4293,'毫沁营镇','100',351),(4294,'保合少镇','101',351),(4295,'新城区鸿盛高科技园区','400',351),(4296,'新华西路办事处','001',352),(4297,'中山西路办事处','002',352),(4298,'光明路办事处','003',352),(4299,'海拉尔西路办事处','004',352),(4300,'环河街办事处','005',352),(4301,'通道街办事处','006',352),(4302,'钢铁路办事处','007',352),(4303,'攸攸板镇','100',352),(4304,'小召前街办事处','001',353),(4305,'兴隆巷办事处','002',353),(4306,'长和廊办事处','003',353),(4307,'石东路办事处','004',353),(4308,'大南街办事处','005',353),(4309,'鄂尔多斯路办事处','006',353),(4310,'西菜园办事处','007',353),(4311,'小黑河镇','100',353),(4312,'人民路街道办事处','001',354),(4313,'大学西路街道办事处','002',354),(4314,'乌兰察布路街道办事处','003',354),(4315,'大学东路街道办事处','004',354),(4316,'中专路街道办事处','005',354),(4317,'巧报镇','100',354),(4318,'榆林镇','101',354),(4319,'巴彦镇','102',354),(4320,'黄合少镇','103',354),(4321,'金河镇','104',354),(4322,'西把栅乡','201',354),(4323,'金桥经济技术开发区','400',354),(4324,'察素齐镇','100',355),(4325,'毕克齐镇','101',355),(4326,'善岱镇','102',355),(4327,'台阁牧镇','103',355),(4328,'白庙子镇','104',355),(4329,'沙尔沁乡','203',355),(4330,'北什轴乡','207',355),(4331,'塔布赛乡','208',355),(4332,'只几梁乡','212',355),(4333,'呼和浩特经济技术开发区金川区','400',355),(4334,'呼和浩特金山经济技术开发区','401',355),(4335,'双河镇','100',356),(4336,'新营子镇','101',356),(4337,'五申镇','102',356),(4338,'伍什家镇','103',356),(4339,'古城镇','104',356),(4340,'城关镇','100',357),(4341,'盛乐镇','101',357),(4342,'新店子镇','102',357),(4343,'舍必崖乡','203',357),(4344,'大红城乡','205',357),(4345,'羊群沟乡','206',357),(4346,'黑老夭乡','207',357),(4347,'盛乐经济工业园区','400',357),(4348,'城关镇','100',358),(4349,'宏河镇','101',358),(4350,'喇嘛湾镇','102',358),(4351,'窑沟乡','200',358),(4352,'北堡乡','201',358),(4353,'可镇','100',359),(4354,'哈乐镇','101',359),(4355,'西乌兰不浪镇','102',359),(4356,'大青山乡','200',359),(4357,'上秃亥乡','205',359),(4358,'德胜沟乡','207',359),(4359,'二份子乡','211',359),(4360,'哈拉合少乡','213',359),(4361,'工业园区','400',359),(4362,'和平街道办事处','001',361),(4363,'财神庙街道办事处','002',361),(4364,'西脑包街道办事处','003',361),(4365,'南门外街道办事处','004',361),(4366,'南圪洞街道办事处','005',361),(4367,'东站街道办事处','006',361),(4368,'回民街道办事处','007',361),(4369,'二里半街道办事处','008',361),(4370,'河东街道办事处','009',361),(4371,'铁西街道办事处','010',361),(4372,'东兴街道办事处','011',361),(4373,'杨圪楞街道办事处','012',361),(4374,'河东镇','100',361),(4375,'少先路街道办事处','001',362),(4376,'张家营子街道办事处','002',362),(4377,'沼潭街道办事处','003',362),(4378,'林荫路街道办事处','004',362),(4379,'友谊大街街道办事处','005',362),(4380,'阿尔丁大街街道办事处','006',362),(4381,'团结大街街道办事处','007',362),(4382,'鞍山道街道办事处','008',362),(4383,'前进道街道办事处','009',362),(4384,'市府东路街道办事处','010',362),(4385,'白云路街道办事处','011',362),(4386,'黄河西路街道办事处','012',362),(4387,'昆工路街道办事处','013',362),(4388,'昆河镇','100',362),(4389,'包钢厂区虚拟办事处','400',362),(4390,'先锋道街道办事处','001',363),(4391,'幸福路街道办事处','002',363),(4392,'万青路街道办事处','003',363),(4393,'富强路街道办事处','004',363),(4394,'科学路街道办事处','005',363),(4395,'青山路街道办事处','006',363),(4396,'自由路街道办事处','007',363),(4397,'乌素图街道办事处','008',363),(4398,'青福镇','100',363),(4399,'万水泉镇','103',363),(4400,'包头稀土高新区新建区虚拟办事处','400',363),(4401,'石拐街道办事处','001',364),(4402,'大发街道办事处','002',364),(4403,'大磁街道办事处','003',364),(4404,'五当沟街道办事处','004',364),(4405,'白狐沟街道办事处','005',364),(4406,'五当召镇','101',364),(4407,'矿山路街道办事处','001',365),(4408,'通阳道街道办事处','002',365),(4409,'沙河街道办事处','001',366),(4410,'麻池镇','103',366),(4411,'哈林格尔镇','105',366),(4412,'沙尔沁镇','108',366),(4413,'兴胜镇','109',366),(4414,'哈业胡同镇','110',366),(4415,'阿嘎如泰苏木乡','202',366),(4416,'包头市国营青年农场','500',366),(4417,'包头市奶业公司','501',366),(4418,'萨拉齐镇','104',367),(4419,'双龙镇','105',367),(4420,'美岱召镇','106',367),(4421,'沟门镇','107',367),(4422,'将军尧镇','108',367),(4423,'海子乡','213',367),(4424,'明沙淖乡','214',367),(4425,'苏波盖乡','215',367),(4426,'九峰山生态管理委员会','500',367),(4427,'金山镇','102',368),(4428,'西斗铺镇','103',368),(4429,'下湿壕镇','104',368),(4430,'银号镇','105',368),(4431,'怀朔镇','106',368),(4432,'兴顺西镇','107',368),(4433,'满都拉镇','102',369),(4434,'希拉穆仁镇','103',369),(4435,'百灵庙镇','104',369),(4436,'石宝镇','105',369),(4437,'乌克忽洞镇','106',369),(4438,'明安镇','107',369),(4439,'巴音花镇','108',369),(4440,'达尔罕苏木乡','213',369),(4441,'凤凰岭街道办事处','001',371),(4442,'海北街道办事处','002',371),(4443,'新华街道办事处','003',371),(4444,'新华西街道办事处','004',371),(4445,'卡布其街道办事处','005',371),(4446,'滨河街道办事处','007',371),(4447,'千里山镇','101',371),(4448,'拉僧仲街道办事处','001',372),(4449,'西卓子山街道办事处','002',372),(4450,'公乌素镇','102',372),(4451,'拉僧庙镇','103',372),(4452,'巴音陶亥镇','104',372),(4453,'三道坎街道办事处','002',373),(4454,'五虎山街道办事处','003',373),(4455,'新达街道办事处','008',373),(4456,'巴音赛街道办事处','009',373),(4457,'梁家沟街道办事处','010',373),(4458,'苏海图街道办事处','011',373),(4459,'滨海街道办事处','012',373),(4460,'乌兰淖尔镇','101',373),(4461,'西屯街道办事处','001',375),(4462,'三中街街道办事处','002',375),(4463,'永巨街道办事处','003',375),(4464,'东城街道办事处','004',375),(4465,'南新街街道办事处','005',375),(4466,'站前街道办事处','006',375),(4467,'铁南街道办事处','007',375),(4468,'长青街道办事处','008',375),(4469,'哈达街道办事处','009',375),(4470,'红庙子镇','100',375),(4471,'文钟镇','102',375),(4472,'西露天街道办事处','001',376),(4473,'平庄城区街道办事处','002',376),(4474,'风水沟镇','100',376),(4475,'元宝山镇','101',376),(4476,'美丽河镇','102',376),(4477,'平庄镇','103',376),(4478,'五家镇','104',376),(4479,'振兴街道办事处','001',377),(4480,'向阳街道办事处','002',377),(4481,'松州街道办事处','003',377),(4482,'铁东街道办事处','004',377),(4483,'玉龙街道办事处','005',377),(4484,'富河街道办事处','006',377),(4485,'兴安街道办事处','007',377),(4486,'全宁街道办事处','008',377),(4487,'穆家营子镇','100',377),(4488,'初头朗镇','101',377),(4489,'大庙镇','102',377),(4490,'王府镇','103',377),(4491,'老府镇','104',377),(4492,'哈拉道口镇','105',377),(4493,'上官地镇','106',377),(4494,'安庆镇','107',377),(4495,'太平地镇','108',377),(4496,'当铺地满族乡','200',377),(4497,'夏家店乡','201',377),(4498,'城子乡','202',377),(4499,'大夫营子乡','203',377),(4500,'岗子乡','204',377),(4501,'天山办事处','001',378),(4502,'天山镇','100',378),(4503,'天山口镇','101',378),(4504,'双胜镇','102',378),(4505,'坤都镇','103',378),(4506,'巴彦花镇','104',378),(4507,'绍根镇','105',378),(4508,'新民乡','200',378),(4509,'先锋乡','201',378),(4510,'罕苏木苏木乡','202',378),(4511,'赛汉塔拉苏木乡','203',378),(4512,'巴拉奇如德苏木乡','204',378),(4513,'林东西城街道办事处','001',379),(4514,'林东东城街道办事处','002',379),(4515,'林东镇','100',379),(4516,'隆昌镇','101',379),(4517,'十三敖包镇','102',379),(4518,'碧流台镇','103',379),(4519,'富河镇','104',379),(4520,'白音诺尔镇','105',379),(4521,'哈拉哈达镇','106',379),(4522,'查干哈达苏木乡','200',379),(4523,'乌兰达坝苏木乡','201',379),(4524,'大板镇','100',380),(4525,'索博日嘎镇','101',380),(4526,'宝日勿苏镇','102',380),(4527,'查干诺尔镇','103',380),(4528,'查干沐沦镇','104',380),(4529,'西拉沐沦苏木乡','200',380),(4530,'巴彦塔拉苏木乡','201',380),(4531,'幸福之路苏木乡','202',380),(4532,'林西街道办事处','001',381),(4533,'林西镇','100',381),(4534,'新城子镇','101',381),(4535,'新林镇','102',381),(4536,'五十家子镇','103',381),(4537,'官地镇','104',381),(4538,'大井镇','105',381),(4539,'统部镇','106',381),(4540,'大营子乡','200',381),(4541,'经棚镇','100',382),(4542,'宇宙地镇','101',382),(4543,'土城子镇','102',382),(4544,'同兴镇','103',382),(4545,'万合永镇','104',382),(4546,'芝瑞镇','105',382),(4547,'达来诺日镇','106',382),(4548,'新开地乡','200',382),(4549,'红山子乡','201',382),(4550,'达日罕乌拉苏木乡','202',382),(4551,'巴彦查干苏木乡','203',382),(4552,'乌丹镇','100',383),(4553,'乌敦套海镇','101',383),(4554,'五分地镇','102',383),(4555,'桥头镇','103',383),(4556,'广德公镇','104',383),(4557,'梧桐花镇','105',383),(4558,'海日苏镇','106',383),(4559,'亿合公镇','107',383),(4560,'解放营子乡','200',383),(4561,'阿什罕苏木乡','201',383),(4562,'白音他拉苏木乡','202',383),(4563,'白音套海苏木乡','203',383),(4564,'锦山镇','100',384),(4565,'美林镇','101',384),(4566,'王爷府镇','102',384),(4567,'小牛群镇','103',384),(4568,'牛家营子镇','104',384),(4569,'乃林镇','105',384),(4570,'西桥镇','106',384),(4571,'十家满族乡','200',384),(4572,'乃林果树农场','400',384),(4573,'马鞍山羊场','401',384),(4574,'天义镇政府','100',385),(4575,'小城子镇政府','101',385),(4576,'大城子镇政府','102',385),(4577,'八里罕镇政府','103',385),(4578,'黑里河镇政府','104',385),(4579,'甸子镇政府','105',385),(4580,'大双庙镇政府','106',385),(4581,'汐子镇政府','107',385),(4582,'大明镇政府','108',385),(4583,'忙农镇政府','109',385),(4584,'三座店乡政府','200',385),(4585,'必斯营子乡政府','201',385),(4586,'五化乡政府','202',385),(4587,'新惠镇','100',386),(4588,'四家子镇','101',386),(4589,'长胜镇','102',386),(4590,'贝子府镇','103',386),(4591,'四道湾子镇','104',386),(4592,'下洼镇','105',386),(4593,'金厂沟梁镇','106',386),(4594,'宝国吐乡','200',386),(4595,'牛古吐乡','201',386),(4596,'木头营子乡','202',386),(4597,'古鲁板蒿乡','203',386),(4598,'丰收乡','204',386),(4599,'玛尼罕乡','205',386),(4600,'萨力巴乡','206',386),(4601,'敖润苏莫苏木乡','207',386),(4602,'科尔沁街道办事处','001',388),(4603,'西门街道办事处','002',388),(4604,'永清街道办事处','003',388),(4605,'明仁街道办事处','004',388),(4606,'施介街道办事处','005',388),(4607,'清真街道办事处','006',388),(4608,'东郊街道办事处','007',388),(4609,'铁路街道办事处','008',388),(4610,'红星街道办事处','009',388),(4611,'霍林街道办事处','010',388),(4612,'建国街道办事处','011',388),(4613,'河西街道办事处','020',388),(4614,'电厂街道办事处','021',388),(4615,'大林镇','100',388),(4616,'钱家店镇','101',388),(4617,'余粮堡镇','102',388),(4618,'木里图镇','103',388),(4619,'丰田镇','104',388),(4620,'清河镇','105',388),(4621,'育新镇','106',388),(4622,'庆和镇','107',388),(4623,'敖力布皋镇','108',388),(4624,'辽河镇','130',388),(4625,'莫力庙苏木乡','200',388),(4626,'哲南农场','400',388),(4627,'三义堂农场','401',388),(4628,'高林屯种畜场','402',388),(4629,'胡力海原种繁殖场','403',388),(4630,'莫力庙羊场','404',388),(4631,'半截店牧场','405',388),(4632,'保康镇','100',389),(4633,'宝龙山镇','101',389),(4634,'舍伯吐镇','102',389),(4635,'巴彦塔拉镇','103',389),(4636,'门达镇','104',389),(4637,'架玛吐镇','105',389),(4638,'腰林毛都镇','106',389),(4639,'希伯花镇','107',389),(4640,'花吐古拉镇','108',389),(4641,'代力吉镇','109',389),(4642,'努日木镇','110',389),(4643,'花胡硕苏木乡','200',389),(4644,'协代苏木乡','201',389),(4645,'白兴吐苏木乡','202',389),(4646,'图布信苏木乡','203',389),(4647,'东苏林场','400',389),(4648,'甘旗卡镇','100',390),(4649,'吉尔嘎朗镇','101',390),(4650,'金宝屯镇','102',390),(4651,'常胜镇','103',390),(4652,'查日苏镇','104',390),(4653,'双胜镇','105',390),(4654,'阿古拉镇','106',390),(4655,'朝鲁吐镇','107',390),(4656,'努古斯台镇','108',390),(4657,'海鲁吐镇','109',390),(4658,'阿都沁苏木乡','200',390),(4659,'茂道吐苏木乡','201',390),(4660,'胜利农场','400',390),(4661,'孟根达坝牧场','401',390),(4662,'查金台牧场','402',390),(4663,'原种场','403',390),(4664,'大青沟管理局','404',390),(4665,'哈日乌苏种畜场','405',390),(4666,'乌兰敖道渔场','406',390),(4667,'金宝屯林场','407',390),(4668,'朝鲁吐林场','408',390),(4669,'茂道吐林场','409',390),(4670,'伊胡塔林场','410',390),(4671,'乌旦塔拉林场','411',390),(4672,'开鲁镇','100',391),(4673,'大榆树镇','101',391),(4674,'黑龙坝镇','102',391),(4675,'麦新镇','103',391),(4676,'义和塔拉镇','104',391),(4677,'建华镇','105',391),(4678,'小街基镇','106',391),(4679,'东风镇','107',391),(4680,'吉日嘎郎吐镇','108',391),(4681,'东来镇','109',391),(4682,'清河牧场','400',391),(4683,'辽河农场','401',391),(4684,'保安农场','402',391),(4685,'库伦镇','100',392),(4686,'扣河子镇','101',392),(4687,'白音花镇','102',392),(4688,'六家子镇','103',392),(4689,'额勒顺镇','104',392),(4690,'茫汗苏木乡','200',392),(4691,'大沁他拉镇','100',393),(4692,'八仙筒镇','101',393),(4693,'青龙山镇','102',393),(4694,'新镇','103',393),(4695,'治安镇','104',393),(4696,'东明镇','105',393),(4697,'土城子镇','106',393),(4698,'义隆永镇','107',393),(4699,'固日班花苏木乡','200',393),(4700,'苇莲苏苏木乡','201',393),(4701,'明仁苏木乡','202',393),(4702,'黄花塔拉苏木乡','203',393),(4703,'国有六号农场','400',393),(4704,'鲁北镇','100',394),(4705,'黄花山镇','101',394),(4706,'嘎亥图镇','102',394),(4707,'巨日合镇','103',394),(4708,'巴雅尔图胡硕镇','104',394),(4709,'香山镇','105',394),(4710,'阿日昆都冷镇','106',394),(4711,'巴彦塔拉苏木乡','200',394),(4712,'乌力吉木仁苏木乡','201',394),(4713,'道老杜苏木乡','202',394),(4714,'格日朝鲁苏木乡','203',394),(4715,'乌额格其牧场','400',394),(4716,'香山农场','401',394),(4717,'乌日根塔拉农场','402',394),(4718,'嘎达苏种畜场','403',394),(4719,'珠斯花街道办事处','001',395),(4720,'莫斯台街道办事处','002',395),(4721,'宝日呼吉尔街道办事处','003',395),(4722,'沙尔呼热街道办事处','004',395),(4723,'达来胡硕街道办事处','005',395),(4724,'东蒙农牧业有限责任公司','400',395),(4725,'交通街道办事处','001',396),(4726,'公园街道办事处','002',396),(4727,'林荫街道办事处','003',396),(4728,'建设街道办事处','004',396),(4729,'富兴街道办事处','005',396),(4730,'天骄街道办事处','006',396),(4731,'哈巴格希街道办事处','007',396),(4732,'诃额伦街道办事处','008',396),(4733,'巴音孟克街道办事处','009',396),(4734,'泊尔江海子镇','100',396),(4735,'罕台镇','101',396),(4736,'塔拉壕镇','102',396),(4737,'树林召镇','100',397),(4738,'吉格斯太镇','101',397),(4739,'白泥井镇','102',397),(4740,'王爱召镇','103',397),(4741,'昭君镇','104',397),(4742,'恩格贝镇','105',397),(4743,'中和西镇','106',397),(4744,'展旦召苏木乡','200',397),(4745,'薛家湾镇','100',398),(4746,'沙圪堵镇','101',398),(4747,'大路镇','102',398),(4748,'纳日松镇','103',398),(4749,'龙口镇','104',398),(4750,'准格尔召镇','105',398),(4751,'暖水乡','200',398),(4752,'十二连城乡','201',398),(4753,'布尔陶亥苏木乡','202',398),(4754,'敖勒召其镇','100',399),(4755,'上海庙镇','101',399),(4756,'城川镇','102',399),(4757,'昂素镇','103',399),(4758,'上海庙经济开发区','400',399),(4759,'乌兰镇','100',400),(4760,'棋盘井镇','101',400),(4761,'蒙西镇','102',400),(4762,'木凯淖尔镇','103',400),(4763,'苏米图苏木乡','200',400),(4764,'阿尔巴斯苏木乡','201',400),(4765,'鄂托克旗赛乌素草籽场','400',400),(4766,'内蒙古白绒山羊种羊场','401',400),(4767,'锡尼镇','100',401),(4768,'巴拉贡镇','101',401),(4769,'吉日嘎朗图镇','102',401),(4770,'独贵塔拉镇','103',401),(4771,'呼和木都镇','104',401),(4772,'杭锦淖尔乡','200',401),(4773,'伊和乌素苏木乡','201',401),(4774,'哈拉淖农场','400',401),(4775,'嘎鲁图镇','100',402),(4776,'乌审召镇','101',402),(4777,'图克镇','102',402),(4778,'乌兰陶勒盖镇','103',402),(4779,'无定河镇','104',402),(4780,'苏力德苏木乡','200',402),(4781,'种羊场','400',402),(4782,'五个林场','401',402),(4783,'阿勒腾席热镇','100',403),(4784,'札萨克镇','101',403),(4785,'乌兰木伦镇','102',403),(4786,'纳林陶亥镇','103',403),(4787,'苏布尔嘎镇','104',403),(4788,'红庆河镇','105',403),(4789,'伊金霍洛镇','106',403),(4790,'正阳办事处','001',405),(4791,'健康街道办事处','002',405),(4792,'靠山街道办事处','003',405),(4793,'胜利街道办事处','004',405),(4794,'呼伦街道办事处','005',405),(4795,'奋斗街道办事处','006',405),(4796,'建设街道办事处','007',405),(4797,'哈克镇','100',405),(4798,'谢尔塔拉种牛场','400',405),(4799,'哈克牧业有限公司','401',405),(4800,'那吉镇','100',406),(4801,'六合镇','101',406),(4802,'亚东镇','102',406),(4803,'霍尔奇镇','103',406),(4804,'向阳峪镇','104',406),(4805,'得力其鄂温克民族乡','200',406),(4806,'查巴奇鄂温克民族乡','201',406),(4807,'音河达斡尔鄂温克民族乡','202',406),(4808,'新发朝鲜民族乡','203',406),(4809,'那吉屯农场','400',406),(4810,'格尼河农场','401',406),(4811,'阿荣旗林业局','402',406),(4812,'尼尔基镇','100',407),(4813,'红彦镇','101',407),(4814,'宝山镇','102',407),(4815,'哈达阳镇','103',407),(4816,'阿尔拉镇','104',407),(4817,'西瓦尔图镇','106',407),(4818,'腾克镇','108',407),(4819,'塔温敖宝镇','110',407),(4820,'巴彦鄂温克民族乡','200',407),(4821,'杜拉尔鄂温克民族乡','203',407),(4822,'国营甘河农场','400',407),(4823,'国营巴彦农场','401',407),(4824,'国营欧肯河农场','402',407),(4825,'国营东方红农场','403',407),(4826,'阿里河镇','100',408),(4827,'大杨树镇','101',408),(4828,'甘河镇','102',408),(4829,'托扎敏镇','103',408),(4830,'诺敏镇','104',408),(4831,'乌鲁布铁镇','105',408),(4832,'古里乡','200',408),(4833,'大兴安岭管理局诺敏河农场','400',408),(4834,'大兴安岭农场宜里农场','401',408),(4835,'大兴安岭农场管理局扎赉河农场','402',408),(4836,'大兴安岭农场管理局古里农场','403',408),(4837,'加格达奇区','404',408),(4838,'松岭地区','405',408),(4839,'大杨树林业局','406',408),(4840,'甘河林业局','407',408),(4841,'克一河林业局','408',408),(4842,'吉文林业局','409',408),(4843,'阿里河林业局','410',408),(4844,'大兴安岭农工商联合公司','411',408),(4845,'大兴安岭农场管理局东方红农场','412',408),(4846,'大兴安岭农场管理局欧肯河农场','413',408),(4847,'大兴安岭林管局毕拉河林业局','414',408),(4848,'大兴安岭林管局伊图里河林业局','415',408),(4849,'大兴安岭林管局库都尔林业局','416',408),(4850,'大兴安岭林管局乌尔其汗林业局','417',408),(4851,'巴彦托海镇','100',409),(4852,'巴雁镇','101',409),(4853,'伊敏河镇','102',409),(4854,'锡尼河镇','103',409),(4855,'巴彦塔拉达斡尔民族乡','200',409),(4856,'伊敏苏木乡','201',409),(4857,'辉苏木乡','202',409),(4858,'巴彦托海经济开发区','400',409),(4859,'伊敏河高载能工业园区','401',409),(4860,'大雁马铃薯高新技术示范园区','402',409),(4861,'陈旗巴彦库仁镇','100',410),(4862,'陈旗宝日希勒镇','101',410),(4863,'陈旗呼和诺尔镇','102',410),(4864,'陈旗乌珠尔苏木乡','200',410),(4865,'陈旗鄂温克民族苏木乡','201',410),(4866,'陈旗国营哈达图农牧场','400',410),(4867,'陈旗国营浩特陶海农牧场','401',410),(4868,'陈旗国营特泥河农牧场','402',410),(4869,'阿木古郎镇','100',411),(4870,'嵯岗镇','101',411),(4871,'乌布尔宝力格苏木乡','200',411),(4872,'吉布胡郎图苏木乡','201',411),(4873,'新宝力格苏木乡','202',411),(4874,'嵯岗镇双娃牧场','400',411),(4875,'阿拉坦额莫勒镇','100',412),(4876,'阿日哈沙特镇','101',412),(4877,'新巴尔虎右旗呼伦镇','102',412),(4878,'贝尔苏木乡','200',412),(4879,'克尔伦苏木乡','201',412),(4880,'敖尔金牧场','400',412),(4881,'东山街道办事处','001',413),(4882,'道南街道办事处','002',413),(4883,'道北街道办事处','003',413),(4884,'兴华街道办事处','004',413),(4885,'满洲里市第一办事处','005',413),(4886,'满洲里市第二办事处','006',413),(4887,'满洲里市第三办事处','007',413),(4888,'满洲里市第四办事处','008',413),(4889,'满洲里市第五办事处','009',413),(4890,'满洲里市灵泉街道办事处','010',413),(4891,'新开河街道办事处','011',413),(4892,'满洲里市互市贸易区','400',413),(4893,'满洲里市经济合作区','401',413),(4894,'满洲里市东湖区','402',413),(4895,'满洲里市扎煤公司','403',413),(4896,'扎赉诺尔矿区','404',413),(4897,'胜利街道办事处','001',414),(4898,'红旗街道办事处','002',414),(4899,'新工街道办事处','003',414),(4900,'永兴街道办事处','004',414),(4901,'建设街道办事处','005',414),(4902,'暖泉街道办事处','006',414),(4903,'牧原街道办事处','007',414),(4904,'免渡河镇','100',414),(4905,'博克图镇','101',414),(4906,'绰源镇','102',414),(4907,'乌尔其汉镇','103',414),(4908,'库都尔镇','104',414),(4909,'图里河镇','105',414),(4910,'莫拐农场','400',414),(4911,'牙克石农场','401',414),(4912,'免渡河农场','402',414),(4913,'兴华街道办事处','001',415),(4914,'正阳街道办事处','002',415),(4915,'繁荣街道办事处','003',415),(4916,'向阳街道办事处','004',415),(4917,'高台子街道办事处','005',415),(4918,'铁东街道办事处','006',415),(4919,'河西街道办事处','007',415),(4920,'磨菇气镇','100',415),(4921,'洼堤镇','101',415),(4922,'卧牛河镇','102',415),(4923,'成吉思汗镇','103',415),(4924,'大河湾镇','104',415),(4925,'浩饶山镇','105',415),(4926,'达斡尔民族乡','200',415),(4927,'南木鄂伦春民族乡','201',415),(4928,'萨马街鄂温克民族乡','202',415),(4929,'大河湾农场','400',415),(4930,'绰尔河农场','401',415),(4931,'扎兰屯马场','402',415),(4932,'成吉思汗监狱农场','403',415),(4933,'公安部后勤供应处农场','404',415),(4934,'南木林业局','405',415),(4935,'柴河林业局','406',415),(4936,'扎兰屯市林业局','407',415),(4937,'市原种场','408',415),(4938,'拉布达林街道办事处','001',416),(4939,'上库力街道办事处','002',416),(4940,'莫尔道嘎镇','100',416),(4941,'黑山头镇','101',416),(4942,'三河回族乡','200',416),(4943,'室韦俄罗斯族民族乡','201',416),(4944,'海拉尔农垦集团有限公司拉布大林农场分公司','400',416),(4945,'三河金','401',416),(4946,'海拉尔农垦集团有限责任公司上库力农场分公司','402',416),(4947,'海拉尔农垦集团有限责任公司苏沁牧场分公司','403',416),(4948,'海拉尔农垦集团有限责任公司恩和牧场分公司','404',416),(4949,'室韦牧场','405',416),(4950,'河东街道办事处','001',417),(4951,'河西街道办事处','002',417),(4952,'森工路街道办事处','003',417),(4953,'金河镇','101',417),(4954,'阿龙山镇','102',417),(4955,'满归镇','103',417),(4956,'敖鲁古雅乡','200',417),(4957,'团结办事处','001',419),(4958,'车站办事处','002',419),(4959,'先锋办事处','003',419),(4960,'解放办事处','004',419),(4961,'新华办事处','005',419),(4962,'东环办事处','006',419),(4963,'铁南办事处','007',419),(4964,'西环路办事处','008',419),(4965,'北环办事处','009',419),(4966,'曙光办事处','010',419),(4967,'狼山镇','100',419),(4968,'新华镇','101',419),(4969,'干召庙镇','102',419),(4970,'乌兰图克镇','103',419),(4971,'双河镇','104',419),(4972,'城关镇','105',419),(4973,'白脑包镇','106',419),(4974,'狼山农场','400',419),(4975,'临河农场','401',419),(4976,'隆兴昌镇','100',420),(4977,'塔尔湖镇','101',420),(4978,'套海镇','102',420),(4979,'新公中镇','103',420),(4980,'天吉太镇','104',420),(4981,'胜丰镇','105',420),(4982,'银定图镇','106',420),(4983,'巴盟国营建丰农场','400',420),(4984,'内蒙古东土城劳动教养管理所','401',420),(4985,'巴彦高勒镇','100',421),(4986,'隆盛合镇','101',421),(4987,'渡口镇','102',421),(4988,'沙金套海苏木乡','200',421),(4989,'乌兰布和农场','400',421),(4990,'巴彦套海农场','401',421),(4991,'哈腾套海农场','402',421),(4992,'包尔盖农场','403',421),(4993,'纳林套海农场','404',421),(4994,'沙漠林业实验中心','405',421),(4995,'乌拉山镇','100',422),(4996,'白彦花镇','101',422),(4997,'先锋镇','102',422),(4998,'新安镇','103',422),(4999,'西小召镇','104',422),(5000,'大佘太镇','105',422),(5001,'明安镇','106',422),(5002,'小佘太镇','107',422),(5003,'额尔登布拉格苏木乡','200',422),(5004,'巴彦淖尔市中滩农场','400',422),(5005,'巴彦淖尔市西山咀农场','401',422),(5006,'巴彦淖尔市新安农场','402',422),(5007,'巴彦淖尔市苏独仑农场','403',422),(5008,'巴彦淖尔市大佘太牧场','404',422),(5009,'巴彦淖尔市乌梁素海渔场','405',422),(5010,'海流图镇','100',423),(5011,'乌加河镇','101',423),(5012,'德岭山镇','102',423),(5013,'石哈河镇','103',423),(5014,'呼鲁斯太苏木乡','200',423),(5015,'川井苏木乡','201',423),(5016,'巴音乌兰苏木乡','202',423),(5017,'新忽热苏木乡','203',423),(5018,'牧羊海牧场','400',423),(5019,'同和太种畜场','401',423),(5020,'巴盟乌北林场','402',423),(5021,'巴音宝力格镇','100',424),(5022,'呼和温都尔镇','101',424),(5023,'潮格温都尔镇','102',424),(5024,'获各琦苏木乡','200',424),(5025,'巴音前达门苏木乡','201',424),(5026,'陕坝镇','100',425),(5027,'头道桥镇','101',425),(5028,'二道桥镇','102',425),(5029,'三道桥镇','103',425),(5030,'蛮会镇','104',425),(5031,'团结镇','105',425),(5032,'双庙镇','106',425),(5033,'沙海镇','107',425),(5034,'巴市太阳庙农场','400',425),(5035,'新体路街道办事处','001',427),(5036,'桥东街道办事处','002',427),(5037,'前进路街道办事处','003',427),(5038,'常青街道办事处','004',427),(5039,'虎山街道办事处','005',427),(5040,'桥西街道办事处','006',427),(5041,'新华街街道办事处','007',427),(5042,'泉山街道办事处','008',427),(5043,'白海子镇','105',427),(5044,'马莲渠乡','205',427),(5045,'卓资山镇','106',428),(5046,'旗下营镇','107',428),(5047,'卓资县十八台镇','108',428),(5048,'卓资县巴音锡勒镇','109',428),(5049,'卓资县梨花镇','110',428),(5050,'卓资县大榆树乡','210',428),(5051,'卓资县红召乡','211',428),(5052,'化德县长顺镇','103',429),(5053,'化德县朝阳镇','104',429),(5054,'化德县七号镇','105',429),(5055,'化德县德包图乡','300',429),(5056,'化德县公腊胡洞乡','301',429),(5057,'七台镇','101',430),(5058,'十八顷镇','102',430),(5059,'大黑沙土镇','103',430),(5060,'西井子镇','104',430),(5061,'屯垦队镇','105',430),(5062,'小海子镇','106',430),(5063,'大库伦乡','300',430),(5064,'卯都乡','301',430),(5065,'玻璃忽镜乡','302',430),(5066,'城关镇','106',431),(5067,'张皋镇','107',431),(5068,'赛乌素镇','108',431),(5069,'鄂尔栋镇','109',431),(5070,'店子镇','110',431),(5071,'大库联乡','209',431),(5072,'民族团结乡','210',431),(5073,'南部矿区管委会','400',431),(5074,'岱海镇','103',432),(5075,'六苏木镇','104',432),(5076,'麦胡图镇','105',432),(5077,'永兴镇','106',432),(5078,'蛮汉镇','107',432),(5079,'天成乡','218',432),(5080,'曹碾满族乡','219',432),(5081,'岱海循环工业发展区','400',432),(5082,'蛮汉山林场','401',432),(5083,'岱海林场','402',432),(5084,'土贵乌拉镇','105',433),(5085,'平地泉镇','106',433),(5086,'玫瑰营镇','107',433),(5087,'巴音塔拉镇','108',433),(5088,'乌拉哈乌拉乡','209',433),(5089,'黄茂营乡','210',433),(5090,'三岔口乡','211',433),(5091,'移民区管委会','500',433),(5092,'科布尔镇','103',434),(5093,'铁沙盖镇','104',434),(5094,'黄羊城镇','105',434),(5095,'广益隆镇','106',434),(5096,'乌素图镇','107',434),(5097,'大滩乡','216',434),(5098,'宏盘乡','217',434),(5099,'巴音乡','218',434),(5100,'库联苏木乡','219',434),(5101,'乌兰哈页苏木乡','220',434),(5102,'白音察干镇','105',435),(5103,'察哈尔右翼后旗土牧尔台镇','106',435),(5104,'察哈尔右翼后旗红格尔图镇','107',435),(5105,'察哈尔右翼后旗贲红镇','108',435),(5106,'察哈尔右翼后旗当郎忽洞苏木乡','209',435),(5107,'察哈尔右翼后旗乌兰哈达苏木乡','210',435),(5108,'察哈尔右翼后旗锡勒乡','211',435),(5109,'四子王旗乌兰花镇','101',436),(5110,'四子王旗吉生太镇','102',436),(5111,'四子王旗库伦图镇','103',436),(5112,'四子王旗供济堂镇','104',436),(5113,'四子王旗白音朝克图镇','105',436),(5114,'四子王旗红格尔苏木乡','225',436),(5115,'四子王旗江岸苏木乡','226',436),(5116,'四子王旗查干补力格苏木乡','227',436),(5117,'四子王旗脑木更苏木乡','228',436),(5118,'四子王旗东八号乡','229',436),(5119,'四子王旗忽鸡图乡','230',436),(5120,'四子王旗乌兰牧场','400',436),(5121,'新城区街道办事处','005',437),(5122,'旧城区街道办事处','006',437),(5123,'北城区街道办事处','007',437),(5124,'工业区街道办事处','008',437),(5125,'南城区街道办事处','009',437),(5126,'隆盛庄镇','107',437),(5127,'黑土台镇','108',437),(5128,'红砂坝镇','109',437),(5129,'巨宝庄镇','110',437),(5130,'三义泉镇','111',437),(5131,'浑源窑乡','207',437),(5132,'官屯堡乡','208',437),(5133,'爱国街道','001',438),(5134,'和平街道','002',438),(5135,'兴安街道','003',438),(5136,'胜利街道','004',438),(5137,'铁西街道','005',438),(5138,'都林街道','006',438),(5139,'五一街道','007',438),(5140,'永联街道','008',438),(5141,'乌兰哈达镇','100',438),(5142,'居力很镇','101',438),(5143,'乌兰哈达原种场','400',438),(5144,'阿尔山市林海街道','001',439),(5145,'阿尔山市新城街道','002',439),(5146,'阿尔山市温泉街道','003',439),(5147,'阿尔山市天池镇','100',439),(5148,'阿尔山市白狼镇','101',439),(5149,'阿尔山市五岔沟镇','102',439),(5150,'科尔沁镇','100',440),(5151,'索伦镇','101',440),(5152,'德佰斯镇','102',440),(5153,'大石寨镇','103',440),(5154,'归流河镇','104',440),(5155,'葛根庙镇','105',440),(5156,'察尔森镇','106',440),(5157,'额尔格图镇','107',440),(5158,'满族屯满族乡','200',440),(5159,'乌兰毛都苏木乡','201',440),(5160,'阿力得尔苏木乡','202',440),(5161,'跃进马场','400',440),(5162,'索伦牧场','401',440),(5163,'呼和马场','402',440),(5164,'阿力得尔牧场','403',440),(5165,'公主陵牧场','404',440),(5166,'绿水种畜场','405',440),(5167,'前旗驻乌兰浩特市虚拟区域','500',440),(5168,'巴彦呼舒镇','100',441),(5169,'巴仁哲里木镇','101',441),(5170,'吐列毛都镇','102',441),(5171,'杜尔基镇','103',441),(5172,'高力板镇','104',441),(5173,'好腰苏木镇','105',441),(5174,'代钦塔拉苏木乡','200',441),(5175,'新佳木苏木乡','201',441),(5176,'布敦化牧场','400',441),(5177,'吐列毛杜农场','401',441),(5178,'铅矿管理区','402',441),(5179,'铜矿管理区','403',441),(5180,'红星林场','404',441),(5181,'杜尔基林场','405',441),(5182,'义和塔拉林场','406',441),(5183,'代钦塔拉林场','407',441),(5184,'好腰苏木林场','408',441),(5185,'哈日努拉防火站','409',441),(5186,'种畜场','410',441),(5187,'良种繁殖场','411',441),(5188,'草籽繁殖场','412',441),(5189,'音德尔镇','100',442),(5190,'新林镇','101',442),(5191,'巴彦高勒镇','102',442),(5192,'胡尔勒镇','103',442),(5193,'阿尔本格勒镇','104',442),(5194,'巴达尔胡镇','105',442),(5195,'图牧吉镇','106',442),(5196,'好力保乡','200',442),(5197,'巴彦乌兰苏木乡','201',442),(5198,'图牧吉劳管所','400',442),(5199,'内蒙劳改局东部分局','401',442),(5200,'种畜场','402',442),(5201,'八一牧场','403',442),(5202,'巴达尔胡农场','404',442),(5203,'突泉镇','100',443),(5204,'六户镇','101',443),(5205,'东杜尔基镇','102',443),(5206,'永安镇','103',443),(5207,'水泉镇','104',443),(5208,'宝石镇','105',443),(5209,'东杜尔基国营农场','400',443),(5210,'东杜尔基良种场','401',443),(5211,'莲花山铜矿','402',443),(5212,'乌兰街道办事处','001',444),(5213,'锡林街道办事处','002',444),(5214,'东城街道办事处','003',444),(5215,'格日勒敖都苏木乡','200',444),(5216,'赛乌苏科技园区','400',444),(5217,'希日塔拉街道办事处','001',445),(5218,'宝力根街道办事处','002',445),(5219,'杭盖街道办事处','003',445),(5220,'楚古兰街道办事处','004',445),(5221,'额尔敦街道办事处','005',445),(5222,'南郊街道办事处','006',445),(5223,'阿尔善宝拉格镇','100',445),(5224,'宝力根苏木乡乡','200',445),(5225,'朝克乌拉苏木乡乡','201',445),(5226,'巴彦锡勒办事处','400',445),(5227,'白音库伦牧场','401',445),(5228,'贝力克牧场','402',445),(5229,'毛登牧场','403',445),(5230,'别力古台镇','100',446),(5231,'洪格尔高勒镇','101',446),(5232,'查干淖尔镇','102',446),(5233,'那仁宝拉格苏木乡','200',446),(5234,'伊和高勒苏木乡乡','201',446),(5235,'吉尔嘎郎图苏木乡','202',446),(5236,'玛尼图煤矿','400',446),(5237,'满都拉图镇','100',447),(5238,'查干敖包中心镇','101',447),(5239,'巴彦淖尔镇','102',447),(5240,'巴彦乌拉苏木乡','200',447),(5241,'赛罕高毕苏木乡','201',447),(5242,'恩格尔河灌区','400',447),(5243,'赛汉塔拉镇','100',448),(5244,'朱日和镇','101',448),(5245,'乌日根塔拉镇','102',448),(5246,'桑宝力格苏木乡','200',448),(5247,'额仁淖尔苏木乡','201',448),(5248,'赛罕乌力吉苏木乡','202',448),(5249,'乌里雅斯太镇','100',449),(5250,'道特淖尔镇','101',449),(5251,'嘎达布其镇','102',449),(5252,'满都胡宝拉格镇','103',449),(5253,'额吉淖尔镇','104',449),(5254,'巴音胡硕镇','105',449),(5255,'呼热图淖尔苏木乡','200',449),(5256,'萨麦苏木乡','201',449),(5257,'哈拉盖图农牧场','400',449),(5258,'贺斯格乌拉农牧场','401',449),(5259,'乌拉盖牧场','402',449),(5260,'水库农牧业经营公司场','403',449),(5261,'巴拉嘎尔高勒镇','100',450),(5262,'巴彦花镇','101',450),(5263,'吉仁高勒镇','102',450),(5264,'浩勒图高勒镇','103',450),(5265,'高日罕镇','104',450),(5266,'巴彦胡舒苏木乡','200',450),(5267,'林业总场','400',450),(5268,'宝昌镇','100',451),(5269,'千斤沟镇','101',451),(5270,'红旗镇','102',451),(5271,'骆驼山镇','103',451),(5272,'幸福乡','200',451),(5273,'贡宝拉格苏木乡','201',451),(5274,'万寿滩良种场','400',451),(5275,'新宝拉格镇','100',452),(5276,'巴彦塔拉镇','101',452),(5277,'翁贡乌拉苏木乡','200',452),(5278,'明安图镇','100',453),(5279,'星耀镇','101',453),(5280,'伊和淖尔苏木乡','200',453),(5281,'乌兰查布苏木乡','201',453),(5282,'额里图种畜场','400',453),(5283,'哲日根图林场','401',453),(5284,'上都镇','100',454),(5285,'桑根达来镇','101',454),(5286,'哈毕日嘎镇','102',454),(5287,'宝绍岱苏木乡','200',454),(5288,'那日图苏木乡','201',454),(5289,'赛音胡都嘎苏木乡','202',454),(5290,'五一种畜场总场','400',454),(5291,'黑城子示范区','401',454),(5292,'大北沟镇','100',455),(5293,'多伦淖尔镇','101',455),(5294,'大河口乡','200',455),(5295,'蔡木山乡','201',455),(5296,'温都尔勒图镇','102',456),(5297,'乌斯太镇','104',456),(5298,'巴润别立镇','105',456),(5299,'巴彦浩特镇','110',456),(5300,'嘉尔嘎勒赛汉镇','111',456),(5301,'吉兰泰镇','112',456),(5302,'宗别立镇','113',456),(5303,'敖伦布拉格镇','114',456),(5304,'巴彦木仁苏木乡','203',456),(5305,'腾格里苏木乡','211',456),(5306,'乌力吉苏木乡','213',456),(5307,'巴彦诺尔公苏木乡','214',456),(5308,'额尔克哈什哈苏木乡','215',456),(5309,'额肯呼都格镇','103',457),(5310,'雅布赖镇','104',457),(5311,'阿拉腾敖包镇','105',457),(5312,'孟根布拉格苏木乡','211',457),(5313,'阿拉腾朝克苏木乡','212',457),(5314,'达来呼布镇','100',458),(5315,'额济纳旗东风镇','101',458),(5316,'额济纳旗赛汉陶来苏木乡','200',458),(5317,'额济纳旗马鬃山苏木乡','201',458),(5318,'额济纳旗苏泊淖尔苏木乡','202',458),(5319,'额济纳旗巴彦陶来农场','400',458),(5320,'砂山街道','001',460),(5321,'新华街道','002',460),(5322,'吴淞街道','006',460),(5323,'西塔街道','007',460),(5324,'北道口街道','009',460),(5325,'遂川街道','011',460),(5326,'八经街道','013',460),(5327,'马路湾街道','016',460),(5328,'集贤街道','017',460),(5329,'新兴街道','018',460),(5330,'南湖街道','019',460),(5331,'长白街道','021',460),(5332,'太原街街道','022',460),(5333,'北市场街道','023',460),(5334,'南市场街道','025',460),(5335,'中山街道','026',460),(5336,'沈水湾街道','027',460),(5337,'大西街道','004',461),(5338,'滨河街道','005',461),(5339,'万莲街道','006',461),(5340,'大南街道','010',461),(5341,'山东庙街道','011',461),(5342,'朱剪炉街道','013',461),(5343,'新北站街道','014',461),(5344,'风雨坛街道','015',461),(5345,'皇城街道','017',461),(5346,'五里河街道','018',461),(5347,'小北街道','001',462),(5348,'大北街道','002',462),(5349,'万泉街道','003',462),(5350,'洮昌街道','004',462),(5351,'文官街道','006',462),(5352,'二台子街道','007',462),(5353,'津桥街道','008',462),(5354,'东站街道','009',462),(5355,'辽沈街道','010',462),(5356,'珠林街道','011',462),(5357,'长安街道','012',462),(5358,'新东街道','014',462),(5359,'东塔街道','015',462),(5360,'三台子街道','001',463),(5361,'陵北街道','002',463),(5362,'辽河街道','003',463),(5363,'黑龙江街道','004',463),(5364,'泰山街道','005',463),(5365,'祟山街道','006',463),(5366,'长江街道','007',463),(5367,'黄河街道','008',463),(5368,'昆山街道','009',463),(5369,'亚明街道','010',463),(5370,'克俭街道','011',463),(5371,'三洞桥街道','012',463),(5372,'华山街道','013',463),(5373,'寿泉街道','014',463),(5374,'塔湾街道','015',463),(5375,'怒江街道','016',463),(5376,'明廉街道','017',463),(5377,'向工街道','018',463),(5378,'新乐街道','019',463),(5379,'太平街道','020',463),(5380,'卫工街道','001',464),(5381,'工人村街道','003',464),(5382,'七路街道','005',464),(5383,'启工街道','007',464),(5384,'笃工街道','013',464),(5385,'兴华街道','015',464),(5386,'兴工街道','018',464),(5387,'霁虹街道','019',464),(5388,'凌空街道','020',464),(5389,'轻重工街道','021',464),(5390,'艳粉路官街道','022',464),(5391,'兴齐保工街道','023',464),(5392,'齐贤兴顺街道','024',464),(5393,'云峰贵和街道','025',464),(5394,'解放街道','001',465),(5395,'铁友街道','002',465),(5396,'民主街道','003',465),(5397,'临湖街道','004',465),(5398,'中兴街道','005',465),(5399,'湖西街道','006',465),(5400,'城郊街道','007',465),(5401,'八一镇','101',465),(5402,'红菱堡镇','102',465),(5403,'林盛堡镇','103',465),(5404,'沙河铺镇','104',465),(5405,'十里河镇','105',465),(5406,'陈相屯镇','106',465),(5407,'姚千户屯镇','107',465),(5408,'王纲堡乡','203',465),(5409,'永乐乡','204',465),(5410,'大沟乡','205',465),(5411,'白清寨乡','206',465),(5412,'佟沟乡','207',465),(5413,'市浑河农场','401',465),(5414,'沈阳塔山农业科技发展有限公司','402',465),(5415,'区示范农场','404',465),(5416,'省稻作研究所','405',465),(5417,'区塔山林场','406',465),(5418,'南塔街道','001',466),(5419,'泉园街道','002',466),(5420,'丰乐街道','003',466),(5421,'马官桥街道','004',466),(5422,'东陵街道','006',466),(5423,'英达街道','007',466),(5424,'前进街道','008',466),(5425,'东湖街道（浑南新区）','009',466),(5426,'五三街道（浑南新区）','010',466),(5427,'浑河站东街道','012',466),(5428,'浑河站西街道','013',466),(5429,'高坎街道（棋盘山开发区）','014',466),(5430,'满堂街道（棋盘山）','015',466),(5431,'深井子镇','102',466),(5432,'祝家屯镇','103',466),(5433,'白塔堡镇','104',466),(5434,'桃仙镇','106',466),(5435,'李相镇','109',466),(5436,'王滨沟乡','206',466),(5437,'新城子街道','001',467),(5438,'清水台街道','002',467),(5439,'辉山街道（农业高新区）','003',467),(5440,'道义镇','101',467),(5441,'兴隆台锡伯族镇','102',467),(5442,'清水台镇','103',467),(5443,'蒲河镇','104',467),(5444,'虎石台镇','105',467),(5445,'财落镇','106',467),(5446,'新城子乡','201',467),(5447,'黄家锡伯族乡','202',467),(5448,'石佛寺朝鲜族锡伯族乡','203',467),(5449,'尹家乡','204',467),(5450,'马刚乡','206',467),(5451,'青年农场','401',467),(5452,'前进农场','402',467),(5453,'育新农场','403',467),(5454,'新城子区马刚林场','404',467),(5455,'新城子区示范农场','405',467),(5456,'新城子区种畜场','406',467),(5457,'迎宾路街道','001',468),(5458,'北塔街道','002',468),(5459,'陵西街道','003',468),(5460,'于洪街道','005',468),(5461,'杨士街道','006',468),(5462,'北陵街道','007',468),(5463,'陵东街道','008',468),(5464,'沙岭街道','009',468),(5465,'平罗镇','101',468),(5466,'马三家子镇','102',468),(5467,'大潘镇','104',468),(5468,'造化镇','105',468),(5469,'翟家镇','106',468),(5470,'彰驿站镇','107',468),(5471,'高花镇','108',468),(5472,'大兴朝鲜族乡','207',468),(5473,'大青中朝友谊乡','209',468),(5474,'光辉乡','213',468),(5475,'马三家劳动教养院','401',468),(5476,'光辉农场','402',468),(5477,'北陵农场','403',468),(5478,'监狱城','404',468),(5479,'辽中镇','100',469),(5480,'于家房镇','101',469),(5481,'朱家房镇','102',469),(5482,'冷子堡镇','103',469),(5483,'刘二堡镇','104',469),(5484,'茨榆坨镇','105',469),(5485,'新民屯镇','106',469),(5486,'满都户镇','107',469),(5487,'杨士岗镇','108',469),(5488,'肖寨门镇','109',469),(5489,'长滩镇','110',469),(5490,'四方台镇','111',469),(5491,'城郊乡','201',469),(5492,'六间房乡','202',469),(5493,'养士堡乡','204',469),(5494,'潘家堡乡','205',469),(5495,'老观坨乡','206',469),(5496,'老大房乡','208',469),(5497,'大黑岗子乡','209',469),(5498,'牛心坨乡','210',469),(5499,'四方台子农场','401',469),(5500,'康平镇','100',470),(5501,'小城子镇','101',470),(5502,'张强镇','102',470),(5503,'方家屯镇','103',470),(5504,'东关屯镇','104',470),(5505,'郝官屯镇','105',470),(5506,'二牛所口镇','106',470),(5507,'北四家子乡','203',470),(5508,'两家子乡','204',470),(5509,'山东屯乡','205',470),(5510,'海洲窝堡乡','206',470),(5511,'沙金台蒙古族满族乡','208',470),(5512,'柳树屯蒙古族满族乡','209',470),(5513,'西关屯蒙古族满族乡','210',470),(5514,'东升满族蒙古族乡','211',470),(5515,'辽宁省康平监狱','403',470),(5516,'三台子畜牧场','404',470),(5517,'法库镇','100',471),(5518,'大孤家子镇','101',471),(5519,'三面船镇','102',471),(5520,'秀水河子镇','103',471),(5521,'叶茂台镇','104',471),(5522,'登仕堡子镇','105',471),(5523,'柏家沟镇','106',471),(5524,'丁家房镇','107',471),(5525,'慈恩寺乡','201',471),(5526,'孟家乡','202',471),(5527,'和平乡','203',471),(5528,'十间房乡','204',471),(5529,'冯贝堡乡','205',471),(5530,'依牛堡子乡','206',471),(5531,'五台子乡','207',471),(5532,'四家子蒙古族乡','208',471),(5533,'双台子乡','209',471),(5534,'卧牛石乡','210',471),(5535,'包家屯乡','211',471),(5536,'东城街道','001',472),(5537,'辽滨街道','002',472),(5538,'西城街道','003',472),(5539,'新柳街道','004',472),(5540,'新城街道','005',472),(5541,'大红旗镇','101',472),(5542,'梁山镇','102',472),(5543,'公主屯镇','103',472),(5544,'兴隆镇','104',472),(5545,'前当堡镇','105',472),(5546,'大民屯镇','106',472),(5547,'大柳屯镇','107',472),(5548,'兴隆堡镇','108',472),(5549,'胡台镇','109',472),(5550,'法哈牛镇','110',472),(5551,'柳河沟镇','111',472),(5552,'高台子乡','202',472),(5553,'金五台子乡','204',472),(5554,'红旗乡','205',472),(5555,'卢家屯乡','206',472),(5556,'姚堡乡','207',472),(5557,'周坨子乡','208',472),(5558,'于家窝堡乡','209',472),(5559,'新农乡','210',472),(5560,'东蛇山子乡','211',472),(5561,'陶家屯乡','212',472),(5562,'罗家房乡','213',472),(5563,'三道岗子乡','214',472),(5564,'张家屯乡','216',472),(5565,'海军广场街道','001',474),(5566,'桂林街道','003',474),(5567,'人民路街道','005',474),(5568,'青泥洼桥街道','008',474),(5569,'昆明街道','009',474),(5570,'葵英街道','010',474),(5571,'桃源街道','011',474),(5572,'老虎滩街道','012',474),(5573,'香炉礁街道','001',475),(5574,'站北街道','002',475),(5575,'日新街道','004',475),(5576,'北京街道','005',475),(5577,'八一路街道','010',475),(5578,'人民广场街道','011',475),(5579,'白云街道','013',475),(5580,'中山公园街道','002',476),(5581,'白山路街道','004',476),(5582,'兴工街道','005',476),(5583,'春柳街道','006',476),(5584,'马栏街道','008',476),(5585,'南沙河口街道','009',476),(5586,'黑石礁街道','010',476),(5587,'李家街道','011',476),(5588,'星海湾街道','017',476),(5589,'周水子街道','001',477),(5590,'椒金山街道','002',477),(5591,'甘井子街道','004',477),(5592,'南关岭街道','006',477),(5593,'泡崖街道','007',477),(5594,'中华路街道','008',477),(5595,'兴华街道','009',477),(5596,'机场街道','010',477),(5597,'辛寨子街道','014',477),(5598,'红旗街道','015',477),(5599,'凌水街道','016',477),(5600,'大连湾街道','017',477),(5601,'泉水街道','018',477),(5602,'革镇堡镇','101',477),(5603,'营城子镇','102',477),(5604,'大连华侨果树农场','400',477),(5605,'大连华侨兴达实业公司','401',477),(5606,'大连华侨鑫山企业公司','402',477),(5607,'大连南关岭农场','403',477),(5608,'登峰街道','001',478),(5609,'市场街道','002',478),(5610,'得胜街道','003',478),(5611,'光荣街道','004',478),(5612,'水师营街道','005',478),(5613,'龙王塘街道','006',478),(5614,'铁山街道','007',478),(5615,'江西街道','008',478),(5616,'双岛湾街道','009',478),(5617,'三涧堡街道','010',478),(5618,'长城街道','011',478),(5619,'龙头街道','012',478),(5620,'北海街道','013',478),(5621,'旅顺开发区','400',478),(5622,'大连奶牛场','401',478),(5623,'拥政街道','001',479),(5624,'友谊街道','002',479),(5625,'光明街道','003',479),(5626,'马桥子街道','004',479),(5627,'海青岛街道','005',479),(5628,'大孤山街道','006',479),(5629,'中长街道','007',479),(5630,'站前街道','008',479),(5631,'先进街道','009',479),(5632,'董家沟街道','011',479),(5633,'金满街道','012',479),(5634,'湾里街道','013',479),(5635,'大李家镇','101',479),(5636,'得胜镇','102',479),(5637,'华家屯镇','103',479),(5638,'二十里堡镇','105',479),(5639,'三十里堡镇','106',479),(5640,'亮甲店镇','107',479),(5641,'登沙河镇','108',479),(5642,'杏树屯镇','109',479),(5643,'石河满族镇','110',479),(5644,'大魏家镇','111',479),(5645,'向应镇','112',479),(5646,'七顶山满族乡','202',479),(5647,'大长山岛镇','100',480),(5648,'獐子岛镇','101',480),(5649,'小长山乡','201',480),(5650,'广鹿乡','202',480),(5651,'海洋乡','203',480),(5652,'新华办事处','001',481),(5653,'文兰办事处','002',481),(5654,'岭东办事处','003',481),(5655,'共济办事处','004',481),(5656,'铁东办事处','005',481),(5657,'祝华办事处','006',481),(5658,'岗店办事处','007',481),(5659,'太阳街道办事处','008',481),(5660,'长兴岛办事处','009',481),(5661,'复州城镇','101',481),(5662,'复州湾镇','102',481),(5663,'松树镇','103',481),(5664,'得利寺镇','105',481),(5665,'万家岭镇','106',481),(5666,'许屯镇','107',481),(5667,'永宁镇','108',481),(5668,'谢屯镇','109',481),(5669,'炮台镇','110',481),(5670,'李店镇','111',481),(5671,'老虎屯镇','112',481),(5672,'东岗镇','113',481),(5673,'李官镇','115',481),(5674,'仙浴湾镇','116',481),(5675,'赵屯乡','201',481),(5676,'土城乡','203',481),(5677,'阎店乡','204',481),(5678,'西杨乡','205',481),(5679,'驼山乡','206',481),(5680,'三台满族乡','208',481),(5681,'交流岛乡','209',481),(5682,'泡崖乡','210',481),(5683,'杨家满族乡','212',481),(5684,'丰荣街道','001',482),(5685,'铁西街道','002',482),(5686,'太平街道','003',482),(5687,'南山街道','004',482),(5688,'皮口镇','101',482),(5689,'城子坦镇','102',482),(5690,'大刘家镇','104',482),(5691,'杨树房镇','105',482),(5692,'双塔镇','106',482),(5693,'安波镇','107',482),(5694,'四平镇','108',482),(5695,'沙包镇','109',482),(5696,'瓦窝镇','110',482),(5697,'元台镇','111',482),(5698,'大谭镇','113',482),(5699,'夹河庙镇','114',482),(5700,'莲山镇','116',482),(5701,'星台镇','117',482),(5702,'墨盘乡','206',482),(5703,'同益乡','208',482),(5704,'乐甲满族乡','209',482),(5705,'城关街道','001',483),(5706,'新华街道','002',483),(5707,'兴达街道','003',483),(5708,'昌盛街道','004',483),(5709,'青堆镇','101',483),(5710,'徐岭镇','102',483),(5711,'黑岛镇','104',483),(5712,'栗子房镇','105',483),(5713,'大营镇','107',483),(5714,'塔岭满族镇','108',483),(5715,'仙人洞镇','109',483),(5716,'蓉花山镇','110',483),(5717,'长岭镇','111',483),(5718,'荷花山镇','112',483),(5719,'城山镇','113',483),(5720,'光明山镇','114',483),(5721,'大郑镇','115',483),(5722,'明阳镇','117',483),(5723,'吴炉镇','118',483),(5724,'王家镇','120',483),(5725,'鞍子山乡','204',483),(5726,'太平岭满族乡','208',483),(5727,'步云山乡','209',483),(5728,'桂云花满族乡','211',483),(5729,'兰店乡','214',483),(5730,'石城乡','216',483),(5731,'长甸办事处','001',485),(5732,'解放办事处','002',485),(5733,'山南办事处','003',485),(5734,'园林办事处','004',485),(5735,'胜利办事处','005',485),(5736,'站前办事处','006',485),(5737,'钢城办事处','007',485),(5738,'和平办事处','008',485),(5739,'对炉办事处','009',485),(5740,'东长甸办事处','010',485),(5741,'湖南办事处','011',485),(5742,'常青办事处','012',485),(5743,'新兴办事处','013',485),(5744,'启明街道办事处','001',486),(5745,'繁荣街道办事处','002',486),(5746,'八家子街道办事处','003',486),(5747,'兴盛街道办事处','004',486),(5748,'共和街道办事处','005',486),(5749,'永乐街道办事处','006',486),(5750,'北陶官街道办事处','007',486),(5751,'南华街道办事处','008',486),(5752,'大陆街道办事处','009',486),(5753,'新陶官街道办事处','010',486),(5754,'友好办事处','001',487),(5755,'双山办事处','004',487),(5756,'立山办事处','006',487),(5757,'曙光办事处','008',487),(5758,'灵山办事处','009',487),(5759,'深南办事处','013',487),(5760,'深北办事处','014',487),(5761,'沙河办事处','015',487),(5762,'沙河镇','100',487),(5763,'旧堡街道','001',488),(5764,'大孤山街道','002',488),(5765,'东鞍山镇','101',488),(5766,'唐家房镇','102',488),(5767,'大孤山镇','103',488),(5768,'千山镇','104',488),(5769,'齐大山镇','105',488),(5770,'达道湾镇','106',488),(5771,'宁远镇','107',488),(5772,'汤岗子镇','108',488),(5773,'鞍山高新区','401',488),(5774,'千山风景区管理委员会','402',488),(5775,'台安镇','100',489),(5776,'西佛镇','101',489),(5777,'新开河镇','102',489),(5778,'黄沙坨镇','103',489),(5779,'高力房镇','104',489),(5780,'桑林镇','105',489),(5781,'富家镇','106',489),(5782,'达牛镇','107',489),(5783,'韭菜台镇','109',489),(5784,'新台镇','110',489),(5785,'桓洞镇','111',489),(5786,'新华农场','400',489),(5787,'洪家农牧场','401',489),(5788,'西平林场','402',489),(5789,'岫岩镇','100',490),(5790,'三家子镇','101',490),(5791,'石庙子镇','102',490),(5792,'黄花甸镇','103',490),(5793,'大营子镇','104',490),(5794,'苏子沟镇','105',490),(5795,'偏岭镇','106',490),(5796,'哈达碑镇','107',490),(5797,'新甸镇','108',490),(5798,'洋河镇','109',490),(5799,'杨家堡镇','111',490),(5800,'汤沟镇','112',490),(5801,'石灰窑镇','113',490),(5802,'前营子镇','114',490),(5803,'龙潭镇','115',490),(5804,'牧牛乡','201',490),(5805,'韭菜沟乡','202',490),(5806,'大房身乡','204',490),(5807,'朝阳乡','205',490),(5808,'红旗营子乡','206',490),(5809,'岭沟乡','211',490),(5810,'哨子河乡','212',490),(5811,'海州街道办事处','001',491),(5812,'兴海街道办事处','002',491),(5813,'响堂街道办事处','003',491),(5814,'东四街道办事处','004',491),(5815,'孤山镇','101',491),(5816,'岔沟镇','102',491),(5817,'接文镇','103',491),(5818,'析木镇','104',491),(5819,'马风镇','105',491),(5820,'牌楼镇','107',491),(5821,'八里镇','108',491),(5822,'毛祁镇','109',491),(5823,'英落镇','110',491),(5824,'感王镇','111',491),(5825,'西柳镇','112',491),(5826,'中小镇','113',491),(5827,'王石镇','114',491),(5828,'南台镇','115',491),(5829,'甘泉镇','116',491),(5830,'大屯镇','117',491),(5831,'腾鳌镇','118',491),(5832,'东四方台温泉管理区','120',491),(5833,'耿庄镇','121',491),(5834,'牛庄镇','123',491),(5835,'西四镇','124',491),(5836,'望台镇','125',491),(5837,'温香镇','126',491),(5838,'高坨镇','127',491),(5839,'海城经济开发区','400',491),(5840,'站前街道','001',493),(5841,'东公园街道','003',493),(5842,'福民街道','005',493),(5843,'新抚街道','007',493),(5844,'榆林街道','009',493),(5845,'永安台街道','011',493),(5846,'千金街道','013',493),(5847,'南阳街道','015',493),(5848,'东洲街道','002',494),(5849,'张甸街道','003',494),(5850,'搭连街道','004',494),(5851,'龙凤街道','005',494),(5852,'新屯街道','006',494),(5853,'万新街道','007',494),(5854,'老虎台街道','008',494),(5855,'平山街道','009',494),(5856,'南花园街道','010',494),(5857,'刘山街道','011',494),(5858,'章党街道','012',494),(5859,'千金乡','201',494),(5860,'碾盘乡','202',494),(5861,'田屯街道','001',495),(5862,'工农街道','002',495),(5863,'建设街道','003',495),(5864,'和平街道','004',495),(5865,'光明街道','005',495),(5866,'朴屯街道','006',495),(5867,'演武街道','007',495),(5868,'五老屯街道','008',495),(5869,'古城子街道','009',495),(5870,'新民街道','010',495),(5871,'李石街道','011',495),(5872,'塔峪镇','101',495),(5873,'河东街道','001',496),(5874,'长春街道','002',496),(5875,'葛布街道','003',496),(5876,'将军堡街道','004',496),(5877,'新华街道','005',496),(5878,'抚顺城街道','007',496),(5879,'前甸镇','102',496),(5880,'河北乡','201',496),(5881,'会元乡','205',496),(5882,'石文镇','101',497),(5883,'后安镇','102',497),(5884,'章党镇','103',497),(5885,'哈达镇','104',497),(5886,'马圈子乡','204',497),(5887,'上马乡','205',497),(5888,'救兵乡','207',497),(5889,'峡河乡','209',497),(5890,'海浪乡','211',497),(5891,'拉古满族乡','212',497),(5892,'兰山乡','215',497),(5893,'汤图满族乡','216',497),(5894,'新宾镇','100',498),(5895,'旺清门镇','101',498),(5896,'永陵镇','102',498),(5897,'平顶山镇','103',498),(5898,'大四平镇','104',498),(5899,'苇子峪镇','105',498),(5900,'木奇镇','106',498),(5901,'上夹河镇','108',498),(5902,'南杂木镇','109',498),(5903,'红升乡','202',498),(5904,'响水河子乡','203',498),(5905,'红庙子乡','204',498),(5906,'北四平乡','205',498),(5907,'榆树乡','207',498),(5908,'下夹河乡','208',498),(5909,'清原镇','100',499),(5910,'红透山镇','101',499),(5911,'草市镇','103',499),(5912,'英额门镇','104',499),(5913,'南口前镇','105',499),(5914,'南山城镇','106',499),(5915,'湾甸子镇','107',499),(5916,'大孤家镇','108',499),(5917,'夏家堡镇','109',499),(5918,'土口子乡','203',499),(5919,'北三家乡','204',499),(5920,'敖家堡乡','206',499),(5921,'大苏河乡','207',499),(5922,'枸乃甸乡','208',499),(5923,'南地街道','001',501),(5924,'工人街道','002',501),(5925,'平山街道','003',501),(5926,'东明街道','004',501),(5927,'崔东街道','005',501),(5928,'站前街道','007',501),(5929,'千金街道','008',501),(5930,'北台街道办事处','010',501),(5931,'桥头镇','101',501),(5932,'河东街道','001',502),(5933,'河西街道','003',502),(5934,'彩屯街道','005',502),(5935,'竖井街道','006',502),(5936,'彩北街道','007',502),(5937,'东风街道办事处','009',502),(5938,'火连寨镇','101',502),(5939,'歪头山镇','102',502),(5940,'石桥子镇','104',502),(5941,'张其寨乡','201',502),(5942,'金山街道','001',503),(5943,'北地街道','002',503),(5944,'高峪街道','004',503),(5945,'明山街道','005',503),(5946,'东兴街道','007',503),(5947,'新明街道','008',503),(5948,'牛心台街道','009',503),(5949,'卧龙街道','010',503),(5950,'高台子镇','101',503),(5951,'南芬街道','001',504),(5952,'铁山街道','002',504),(5953,'郭家街道','003',504),(5954,'下马塘镇','101',504),(5955,'思山岭满族乡','202',504),(5956,'观音阁街道','001',505),(5957,'小市镇','100',505),(5958,'草河掌镇','101',505),(5959,'草河城镇','102',505),(5960,'草河口镇','103',505),(5961,'连山关镇','104',505),(5962,'清河城镇','106',505),(5963,'田师傅镇','109',505),(5964,'南甸镇','110',505),(5965,'碱厂镇','111',505),(5966,'高官镇','112',505),(5967,'东营房乡','202',505),(5968,'江城街道办事处','001',506),(5969,'桓仁镇','100',506),(5970,'普乐堡镇','101',506),(5971,'二棚甸子镇','102',506),(5972,'沙尖子镇','103',506),(5973,'五里甸子镇','104',506),(5974,'八里甸子镇','108',506),(5975,'华来镇','110',506),(5976,'古城镇','111',506),(5977,'雅河朝鲜族乡','201',506),(5978,'向阳乡','202',506),(5979,'黑沟乡','206',506),(5980,'北甸子乡','208',506),(5981,'六道口街道','001',508),(5982,'七道街道','002',508),(5983,'八道街道','003',508),(5984,'九道街道','004',508),(5985,'广济街道','005',508),(5986,'兴东街道','006',508),(5987,'金山镇','101',508),(5988,'头道桥街道','001',509),(5989,'站前街道','002',509),(5990,'临江街道','003',509),(5991,'六道街道','004',509),(5992,'帽盔山街道','005',509),(5993,'纤维街道','006',509),(5994,'永昌街道','007',509),(5995,'花园街道','008',509),(5996,'浪头镇','101',509),(5997,'安民镇','102',509),(5998,'鸭绿江街道','001',510),(5999,'金矿街道','003',510),(6000,'珍珠街道','004',510),(6001,'太平湾街道','005',510),(6002,'同兴镇','102',510),(6003,'五龙背镇','104',510),(6004,'楼房镇','105',510),(6005,'九连城镇','106',510),(6006,'汤山城镇','107',510),(6007,'宽甸镇','100',511),(6008,'灌水镇','101',511),(6009,'硼海镇','102',511),(6010,'红石镇','103',511),(6011,'毛甸子镇','104',511),(6012,'长甸镇','105',511),(6013,'永甸镇','106',511),(6014,'太平哨镇','108',511),(6015,'青山沟镇','109',511),(6016,'牛毛坞镇','110',511),(6017,'大川头镇','111',511),(6018,'青椅山镇','112',511),(6019,'杨木川镇','113',511),(6020,'虎山镇','114',511),(6021,'振江镇','115',511),(6022,'步达远镇','116',511),(6023,'大西岔镇','117',511),(6024,'八河川镇','118',511),(6025,'双山子镇','119',511),(6026,'石湖沟乡','201',511),(6027,'古楼子乡','206',511),(6028,'下露河朝鲜族乡','212',511),(6029,'大东街道','001',512),(6030,'新兴街道','002',512),(6031,'新城街道','003',512),(6032,'孤山镇','101',512),(6033,'汤池镇','103',512),(6034,'前阳镇','104',512),(6035,'长安镇','105',512),(6036,'十字街镇','106',512),(6037,'长山镇','107',512),(6038,'北井子镇','108',512),(6039,'椅圈镇','109',512),(6040,'黄土坎镇','110',512),(6041,'马家店镇','113',512),(6042,'龙王庙满族锡伯族镇','114',512),(6043,'小甸子镇','115',512),(6044,'菩萨庙镇','117',512),(6045,'黑沟镇','118',512),(6046,'新农镇','119',512),(6047,'合隆乡','206',512),(6048,'示范农场','401',512),(6049,'黄土坎农场','402',512),(6050,'海洋红农场','403',512),(6051,'兴隆农场','404',512),(6052,'五四农场','405',512),(6053,'凤凰城街道','001',513),(6054,'凤山街道','002',513),(6055,'草河街道','003',513),(6056,'宝山镇','101',513),(6057,'白旗镇','102',513),(6058,'沙里寨镇','103',513),(6059,'红旗镇','104',513),(6060,'蓝旗镇','105',513),(6061,'边门镇','107',513),(6062,'大堡蒙古族镇','109',513),(6063,'东汤镇','110',513),(6064,'石城镇','111',513),(6065,'大兴镇','112',513),(6066,'爱阳镇','113',513),(6067,'赛马镇','114',513),(6068,'弟兄山镇','115',513),(6069,'鸡冠山镇','116',513),(6070,'刘家河镇','117',513),(6071,'通远堡镇','118',513),(6072,'四门子镇','119',513),(6073,'青城子镇','120',513),(6074,'天安街道','001',515),(6075,'石油街道','002',515),(6076,'北街街道','003',515),(6077,'敬业街道','004',515),(6078,'保安街道','005',515),(6079,'南街街道','006',515),(6080,'饶阳街道','007',515),(6081,'站前街道','008',515),(6082,'士英街道','009',515),(6083,'正大街道','001',516),(6084,'石桥子街道','002',516),(6085,'龙江街道','003',516),(6086,'榴花街道','004',516),(6087,'铁新街道','005',516),(6088,'凌安街道','006',516),(6089,'菊园街道','007',516),(6090,'康宁街道','008',516),(6091,'锦铁街道','009',516),(6092,'马家街道','010',516),(6093,'百股街道','011',516),(6094,'锦州北山农工商总公司','402',516),(6095,'太和街道','001',517),(6096,'兴隆街道','002',517),(6097,'汤河子街道','003',517),(6098,'凌西街道','004',517),(6099,'凌南街道','006',517),(6100,'大薛街道','007',517),(6101,'王家街道','070',517),(6102,'天桥街道','071',517),(6103,'杏山街道','072',517),(6104,'女儿河乡','202',517),(6105,'钟屯乡','203',517),(6106,'营盘乡','204',517),(6107,'新民乡','205',517),(6108,'锦州市果树农场','401',517),(6109,'黑山镇','100',518),(6110,'芳山镇','101',518),(6111,'白厂门镇','102',518),(6112,'常兴镇','103',518),(6113,'姜屯镇','104',518),(6114,'励家镇','105',518),(6115,'绕阳河镇','106',518),(6116,'半拉门镇','107',518),(6117,'无梁殿镇','108',518),(6118,'胡家镇','109',518),(6119,'新立屯镇','110',518),(6120,'八道壕镇','111',518),(6121,'大虎山镇','112',518),(6122,'四家子镇','113',518),(6123,'新兴镇','114',518),(6124,'太和镇','116',518),(6125,'英城子乡','201',518),(6126,'镇安乡','208',518),(6127,'段家乡','209',518),(6128,'大兴乡','210',518),(6129,'薛屯乡','212',518),(6130,'辽宁省锦州市小东种畜场','400',518),(6131,'义州镇','100',519),(6132,'刘龙台镇','101',519),(6133,'七里河镇','102',519),(6134,'大榆树堡镇','103',519),(6135,'稍户营子镇','104',519),(6136,'九道岭镇','105',519),(6137,'高台子镇','106',519),(6138,'瓦子峪镇','108',519),(6139,'城关满族乡','201',519),(6140,'头道河满族乡','202',519),(6141,'地藏寺满族乡','203',519),(6142,'留龙沟满族乡','204',519),(6143,'大定堡满族乡','205',519),(6144,'前杨乡','206',519),(6145,'白庙子乡','207',519),(6146,'聚粮屯乡','208',519),(6147,'张家堡乡','209',519),(6148,'头台满族乡','215',519),(6149,'大凌河街道','001',520),(6150,'金城街道','002',520),(6151,'石山镇','101',520),(6152,'余积镇','102',520),(6153,'双羊镇','103',520),(6154,'班吉塔镇','104',520),(6155,'沈家台镇','105',520),(6156,'三台子镇','106',520),(6157,'右卫满族镇','107',520),(6158,'阎家镇','108',520),(6159,'新庄子镇','109',520),(6160,'娘娘宫镇','110',520),(6161,'翠岩镇','112',520),(6162,'松山镇','170',520),(6163,'大业乡','202',520),(6164,'西八千乡','204',520),(6165,'建业乡','205',520),(6166,'温滴楼满族乡','210',520),(6167,'板石沟乡','212',520),(6168,'白台子乡','214',520),(6169,'谢屯乡','217',520),(6170,'安屯乡','219',520),(6171,'辽宁省金城原种场','401',520),(6172,'大有农场','405',520),(6173,'北镇街道办事处','004',521),(6174,'观音阁街道办事处','005',521),(6175,'大市镇','101',521),(6176,'罗罗堡镇','102',521),(6177,'常兴店镇','103',521),(6178,'正安镇','104',521),(6179,'闾阳镇','105',521),(6180,'中安镇','106',521),(6181,'廖屯镇','107',521),(6182,'赵屯镇','109',521),(6183,'青堆子镇','110',521),(6184,'高山子镇','111',521),(6185,'沟帮子镇','112',521),(6186,'富屯乡','201',521),(6187,'鲍家乡','203',521),(6188,'大屯乡','206',521),(6189,'吴家乡','208',521),(6190,'柳家乡','209',521),(6191,'广宁乡','211',521),(6192,'新立农场','403',521),(6193,'八田地街道','001',523),(6194,'建丰街道','002',523),(6195,'建设街道','003',523),(6196,'跃进街道','004',523),(6197,'东风街道','005',523),(6198,'新兴街道','006',523),(6199,'新建街道','007',523),(6200,'胜利街道','001',524),(6201,'清华街道','002',524),(6202,'滨海街道','003',524),(6203,'得胜街道','004',524),(6204,'五台子街道','005',524),(6205,'渔市街道','006',524),(6206,'河北街道','007',524),(6207,'红海街道','001',525),(6208,'海星街道','002',525),(6209,'望海街道','003',525),(6210,'海东街道','004',525),(6211,'熊岳镇','100',525),(6212,'芦屯镇','101',525),(6213,'红旗满族镇','102',525),(6214,'老边街道','001',526),(6215,'城东街道','002',526),(6216,'路南镇','101',526),(6217,'柳树镇','102',526),(6218,'边城镇','103',526),(6219,'二道镇','104',526),(6220,'鼓楼街道','001',527),(6221,'西城街道','002',527),(6222,'东城街道','003',527),(6223,'太阳升街道','004',527),(6224,'团山街道','005',527),(6225,'西海街道','006',527),(6226,'高屯镇','102',527),(6227,'沙岗镇','105',527),(6228,'九垅地镇','108',527),(6229,'九寨镇','109',527),(6230,'万福镇','110',527),(6231,'卧龙泉镇','111',527),(6232,'青石岭镇','112',527),(6233,'暖泉镇','113',527),(6234,'归州满族镇','115',527),(6235,'榜式堡镇','116',527),(6236,'团甸镇','117',527),(6237,'双台镇','118',527),(6238,'杨运镇','119',527),(6239,'徐屯镇','120',527),(6240,'什字街镇','121',527),(6241,'矿洞沟镇','122',527),(6242,'陈屯镇','123',527),(6243,'梁屯镇','124',527),(6244,'小石棚乡','216',527),(6245,'果园乡','217',527),(6246,'二台乡','218',527),(6247,'石桥街道','001',528),(6248,'青花街道','002',528),(6249,'金桥街道','003',528),(6250,'钢都街道','004',528),(6251,'南楼街道','005',528),(6252,'水源镇','101',528),(6253,'沟沿镇','102',528),(6254,'石佛镇','103',528),(6255,'高坎镇','104',528),(6256,'旗口镇','105',528),(6257,'虎庄镇','106',528),(6258,'官屯镇','107',528),(6259,'博洛铺镇','112',528),(6260,'永安镇','113',528),(6261,'汤池镇','114',528),(6262,'建一镇','115',528),(6263,'黄土岭镇','116',528),(6264,'周家镇','117',528),(6265,'新兴街道','002',530),(6266,'和平街道','003',530),(6267,'西山街道','004',530),(6268,'河北街道','005',530),(6269,'站前街道','006',530),(6270,'西阜新街道','007',530),(6271,'五龙街道','008',530),(6272,'平安西部街道','009',530),(6273,'工人村街道','010',530),(6274,'东梁街道','011',530),(6275,'韩家店镇','101',530),(6276,'街基街道','001',531),(6277,'中部街道','002',531),(6278,'北部街道','003',531),(6279,'南部街道','004',531),(6280,'长营子蒙古族镇','101',531),(6281,'红树街道','001',532),(6282,'煤海街道','002',532),(6283,'高德街道','003',532),(6284,'孙家湾街道','004',532),(6285,'城南街道','005',532),(6286,'水泉镇','101',532),(6287,'清河街道','001',533),(6288,'六台街道','002',533),(6289,'艾友街道','003',533),(6290,'新北街道','004',533),(6291,'河西镇','101',533),(6292,'乌龙坝镇','102',533),(6293,'西苑街道','001',534),(6294,'北苑街道','002',534),(6295,'东苑街道','003',534),(6296,'学院街道','004',534),(6297,'中苑街道','005',534),(6298,'华东街道','006',534),(6299,'四合镇','102',534),(6300,'阜新镇','100',535),(6301,'东梁镇','102',535),(6302,'佛寺镇','103',535),(6303,'伊吗图镇','104',535),(6304,'旧庙镇','105',535),(6305,'务欢池镇','106',535),(6306,'建设镇','107',535),(6307,'大巴镇','108',535),(6308,'泡子镇','109',535),(6309,'十家子镇','110',535),(6310,'王府镇','111',535),(6311,'于寺镇','112',535),(6312,'富荣镇','113',535),(6313,'新民镇','114',535),(6314,'福兴地镇','115',535),(6315,'平安地镇','116',535),(6316,'沙拉镇','117',535),(6317,'大固本镇','118',535),(6318,'大五家子镇','119',535),(6319,'大板镇','120',535),(6320,'蜘蛛山乡','201',535),(6321,'卧凤沟乡','203',535),(6322,'八家子乡','204',535),(6323,'哈达户稍乡','205',535),(6324,'塔营子乡','207',535),(6325,'扎兰营子乡','208',535),(6326,'招束沟乡','210',535),(6327,'苍土乡','211',535),(6328,'老河土乡','214',535),(6329,'七家子乡','215',535),(6330,'红帽子乡','217',535),(6331,'紫都台乡','218',535),(6332,'化石戈乡','219',535),(6333,'太平乡','220',535),(6334,'国华乡','222',535),(6335,'泡子办事处','401',535),(6336,'彰武镇','100',536),(6337,'哈尔套镇','101',536),(6338,'章古台镇','102',536),(6339,'五峰镇','103',536),(6340,'冯家镇','104',536),(6341,'后新秋镇','105',536),(6342,'东六家子镇','106',536),(6343,'阿尔乡镇','107',536),(6344,'苇子沟蒙古族乡','201',536),(6345,'二道河子蒙古族乡','202',536),(6346,'西六家子蒙古族满族乡','203',536),(6347,'两家子乡','204',536),(6348,'双庙乡','205',536),(6349,'平安乡','206',536),(6350,'满堂红乡','207',536),(6351,'四堡子乡','208',536),(6352,'丰田乡','209',536),(6353,'大德乡','210',536),(6354,'大冷蒙古族乡','211',536),(6355,'前福兴地乡','212',536),(6356,'兴隆堡乡','213',536),(6357,'兴隆山乡','214',536),(6358,'大四家子乡','215',536),(6359,'四合城乡','216',536),(6360,'星火街道办事处','001',538),(6361,'胜利街道办事处','002',538),(6362,'跃进街道办事处','003',538),(6363,'卫国路街道办事处','005',538),(6364,'站前街道办事处','006',538),(6365,'铁西街道办事处','009',538),(6366,'武圣街道办事处','001',539),(6367,'文圣街道办事处','002',539),(6368,'襄平街道办事处','003',539),(6369,'庆阳街道办事处','004',539),(6370,'南门街道办事处','005',539),(6371,'东兴街道办事处','007',539),(6372,'工农街道办事处','001',540),(6373,'光华街道办事处','002',540),(6374,'新村街道办事处','003',540),(6375,'长征街道办事处','004',540),(6376,'曙光镇','101',540),(6377,'苏家街道办事处','001',541),(6378,'团山街道办事处','002',541),(6379,'安平街道办事处','003',541),(6380,'汤河镇','101',541),(6381,'安平乡','201',541),(6382,'新华街道办事处','001',542),(6383,'望水台街道办事处','002',542),(6384,'祁家镇','101',542),(6385,'东京陵乡','202',542),(6386,'东宁卫乡','204',542),(6387,'首山镇','100',543),(6388,'刘二堡镇','101',543),(6389,'小屯镇','102',543),(6390,'小北河镇','103',543),(6391,'黄泥洼镇','104',543),(6392,'沙岭镇','105',543),(6393,'唐马寨镇','106',543),(6394,'穆家镇','107',543),(6395,'柳壕镇','108',543),(6396,'兰家镇','109',543),(6397,'河栏镇','110',543),(6398,'隆昌镇','111',543),(6399,'八会镇','112',543),(6400,'寒岭镇','113',543),(6401,'下达河乡','201',543),(6402,'吉洞峪满族乡','202',543),(6403,'甜水满族乡','206',543),(6404,'烟台街道办事处','001',544),(6405,'万宝桥街道办事处','002',544),(6406,'古城子街道办事处','003',544),(6407,'佟二堡镇','101',544),(6408,'铧子镇','102',544),(6409,'张台子镇','103',544),(6410,'西大窑镇','104',544),(6411,'沈旦堡镇','105',544),(6412,'西马峰镇','106',544),(6413,'柳条寨镇','107',544),(6414,'柳河子镇','108',544),(6415,'罗大台镇','109',544),(6416,'王家镇','110',544),(6417,'大河南镇','111',544),(6418,'五星镇','114',544),(6419,'鸡冠山乡','205',544),(6420,'东风街道','001',546),(6421,'胜利街道','002',546),(6422,'建设街道','003',546),(6423,'红旗街道','004',546),(6424,'辽河街道','005',546),(6425,'石油街道','006',546),(6426,'化工街道','007',546),(6427,'铁东街道','008',546),(6428,'双盛街道','009',546),(6429,'振兴街道','001',547),(6430,'兴隆街道','002',547),(6431,'渤海街道','003',547),(6432,'新工街道','004',547),(6433,'于楼街道','005',547),(6434,'友谊街道','006',547),(6435,'曙光街道','007',547),(6436,'欢喜街道','008',547),(6437,'平安街道','009',547),(6438,'新生街道','010',547),(6439,'红村街道','011',547),(6440,'高升街道','012',547),(6441,'沈采街道','013',547),(6442,'锦采街道','014',547),(6443,'茨采街道','015',547),(6444,'创新街道','016',547),(6445,'兴盛街道','017',547),(6446,'兴海街道','018',547),(6447,'大洼镇','100',548),(6448,'田庄台镇','101',548),(6449,'二界沟镇','102',548),(6450,'东风镇','103',548),(6451,'新开镇','104',548),(6452,'田家镇','105',548),(6453,'清水镇','106',548),(6454,'新兴镇','107',548),(6455,'西安镇','108',548),(6456,'新立镇','109',548),(6457,'王家乡','201',548),(6458,'唐家乡','202',548),(6459,'荣兴乡','205',548),(6460,'平安乡','207',548),(6461,'赵圈河乡','210',548),(6462,'辽滨开发区','400',548),(6463,'沙岭镇','101',549),(6464,'高升镇','102',549),(6465,'胡家镇','103',549),(6466,'石新镇','104',549),(6467,'东郭镇','105',549),(6468,'羊圈子镇','106',549),(6469,'古城子镇','107',549),(6470,'坝墙子镇','108',549),(6471,'太平镇','109',549),(6472,'陈家乡','203',549),(6473,'吴家乡','205',549),(6474,'陆家乡','206',549),(6475,'甜水乡','207',549),(6476,'大荒乡','208',549),(6477,'盘山县林场','400',549),(6478,'红旗街道办事处','001',551),(6479,'工人街道','002',551),(6480,'铁西街道','003',551),(6481,'铜钟街道','004',551),(6482,'柴河街道','005',551),(6483,'岭东街道','006',551),(6484,'龙山乡','201',551),(6485,'铁岭经济开发区','401',551),(6486,'红旗街道','001',552),(6487,'向阳街道','002',552),(6488,'张相镇','101',552),(6489,'杨木林子乡','202',552),(6490,'聂家满族乡','203',552),(6491,'新台子镇','101',553),(6492,'铁岭县阿吉镇','102',553),(6493,'铁岭县平顶堡镇','103',553),(6494,'铁岭县大甸子镇','104',553),(6495,'铁岭县凡河镇','105',553),(6496,'铁岭县腰堡镇','106',553),(6497,'铁岭县镇西堡镇','107',553),(6498,'铁岭县蔡牛乡','201',553),(6499,'铁岭县双井子乡','203',553),(6500,'铁岭县熊官屯乡','204',553),(6501,'铁岭县李千户乡','205',553),(6502,'铁岭县横道河子乡','206',553),(6503,'铁岭县鸡冠山乡','208',553),(6504,'铁岭县白旗寨满族乡','209',553),(6505,'铁岭县种畜场','401',553),(6506,'西丰镇','100',554),(6507,'平岗镇','101',554),(6508,'郜家店镇','102',554),(6509,'凉泉镇','103',554),(6510,'振兴镇','104',554),(6511,'安民镇','105',554),(6512,'天德镇','106',554),(6513,'房木镇','107',554),(6514,'陶然乡','201',554),(6515,'柏榆乡','203',554),(6516,'德兴乡','204',554),(6517,'钓鱼乡','205',554),(6518,'明德乡','206',554),(6519,'成平满族乡','209',554),(6520,'和隆满族乡','211',554),(6521,'营厂乡','212',554),(6522,'金星乡','213',554),(6523,'更刻乡','214',554),(6524,'昌图镇','100',555),(6525,'老城镇','101',555),(6526,'八面城镇','102',555),(6527,'三江口镇','103',555),(6528,'金家镇','104',555),(6529,'宝力镇','105',555),(6530,'泉头满族镇','106',555),(6531,'双庙子镇','107',555),(6532,'亮中桥镇','108',555),(6533,'马仲河镇','109',555),(6534,'毛家店镇','110',555),(6535,'老四平镇','111',555),(6536,'大洼镇','112',555),(6537,'头道镇','113',555),(6538,'此路树镇','114',555),(6539,'付家镇','115',555),(6540,'四合镇','117',555),(6541,'朝阳镇','118',555),(6542,'古榆树镇','119',555),(6543,'七家子镇','120',555),(6544,'东嘎镇','121',555),(6545,'四面城镇','122',555),(6546,'前双井子镇','123',555),(6547,'大兴乡','204',555),(6548,'十八家子乡','205',555),(6549,'通江口乡','207',555),(6550,'大四家子乡','208',555),(6551,'后窑乡','209',555),(6552,'长发乡','211',555),(6553,'太平乡','212',555),(6554,'下二台乡','213',555),(6555,'平安堡乡','216',555),(6556,'曲家店乡','217',555),(6557,'三江口农场','401',555),(6558,'宝力农场','402',555),(6559,'新乡农场','403',555),(6560,'付家林场','404',555),(6561,'忙牛马场','405',555),(6562,'两家子农场','406',555),(6563,'兀术街道','001',556),(6564,'调兵山街道','002',556),(6565,'晓明镇','102',556),(6566,'大明镇','103',556),(6567,'晓南镇','105',556),(6568,'新城街道','001',557),(6569,'老城街道','002',557),(6570,'兴开街道','003',557),(6571,'威远堡镇','102',557),(6572,'庆云堡镇','103',557),(6573,'中固镇','104',557),(6574,'八棵树镇','105',557),(6575,'金沟子镇','106',557),(6576,'八宝镇','107',557),(6577,'业民镇','108',557),(6578,'莲花镇','109',557),(6579,'靠山镇','110',557),(6580,'城东乡','201',557),(6581,'三家子乡','206',557),(6582,'马家寨乡','207',557),(6583,'上肥地乡','210',557),(6584,'下肥地乡','211',557),(6585,'黄旗寨乡','212',557),(6586,'松山堡乡','213',557),(6587,'李家台乡','216',557),(6588,'林丰乡','217',557),(6589,'南塔街道','001',559),(6590,'北塔街道','002',559),(6591,'前进街道','003',559),(6592,'凌河街道','004',559),(6593,'光明街道','005',559),(6594,'凌凤街道','006',559),(6595,'龙山街道','007',559),(6596,'站南街道','008',559),(6597,'红旗街道','009',559),(6598,'燕北街道','010',559),(6599,'桃花吐镇','100',559),(6600,'他拉皋镇','101',559),(6601,'长宝营子乡','205',559),(6602,'孙家湾乡','206',559),(6603,'向阳街道','001',560),(6604,'半拉山街道','002',560),(6605,'马山街道','003',560),(6606,'新华街道','004',560),(6607,'海龙街道','005',560),(6608,'开发区龙泉街道','070',560),(6609,'七道泉子镇','101',560),(6610,'西大营子镇','102',560),(6611,'召都巴镇','103',560),(6612,'大平房镇','105',560),(6613,'边杖子乡','201',560),(6614,'联合乡','203',560),(6615,'波罗赤镇','102',561),(6616,'木头城子镇','103',561),(6617,'二十家子镇','104',561),(6618,'羊山镇','105',561),(6619,'六家子镇','106',561),(6620,'瓦房子镇','107',561),(6621,'大庙镇','108',561),(6622,'柳城镇','109',561),(6623,'南双庙乡','204',561),(6624,'古山子乡','206',561),(6625,'西五家子乡','211',561),(6626,'北沟门子乡','212',561),(6627,'杨树湾乡','213',561),(6628,'东大道乡','214',561),(6629,'乌兰河硕蒙古族乡','215',561),(6630,'台子乡','216',561),(6631,'胜利乡','218',561),(6632,'东大屯乡','220',561),(6633,'松岭门乡','221',561),(6634,'根德营子乡','222',561),(6635,'西营子乡','224',561),(6636,'七道岭乡','225',561),(6637,'北四家子乡','228',561),(6638,'王营子乡','230',561),(6639,'黑牛营子乡','231',561),(6640,'尚志乡','232',561),(6641,'长在营子乡','233',561),(6642,'国营贾家店农场','400',561),(6643,'叶柏寿街道','001',562),(6644,'红山街道','002',562),(6645,'铁南街道','003',562),(6646,'万寿街道','004',562),(6647,'富山街道','005',562),(6648,'朱碌科镇','101',562),(6649,'建平镇','102',562),(6650,'黑水镇','103',562),(6651,'喀喇沁镇','104',562),(6652,'北二十家子镇','105',562),(6653,'沙海镇','106',562),(6654,'哈拉道口镇','108',562),(6655,'榆树林子镇','109',562),(6656,'老官地镇','110',562),(6657,'深井镇','111',562),(6658,'奎德素镇','112',562),(6659,'小塘镇','113',562),(6660,'马场镇','114',562),(6661,'昌隆镇','115',562),(6662,'张家营子镇','117',562),(6663,'青松岭乡','205',562),(6664,'杨树岭乡','206',562),(6665,'罗福沟乡','209',562),(6666,'烧锅营子乡','211',562),(6667,'太平庄乡','213',562),(6668,'白山乡','214',562),(6669,'三家蒙古族乡','218',562),(6670,'义成功乡','220',562),(6671,'青峰山乡','221',562),(6672,'八家国营农场','400',562),(6673,'热水国营畜牧农场','401',562),(6674,'大城子镇','100',563),(6675,'南公营子镇','101',563),(6676,'山嘴子镇','102',563),(6677,'南哨镇','103',563),(6678,'公营子镇','104',563),(6679,'白塔子镇','105',563),(6680,'中三家镇','106',563),(6681,'老爷庙镇','107',563),(6682,'六官营子镇','108',563),(6683,'平房子镇','109',563),(6684,'十二德堡乡','203',563),(6685,'尤杖子乡','204',563),(6686,'东哨乡','205',563),(6687,'羊角沟乡','206',563),(6688,'草场乡','207',563),(6689,'坤都营子乡','210',563),(6690,'大营子乡','211',563),(6691,'兴隆庄乡','212',563),(6692,'甘招乡','213',563),(6693,'卧虎沟乡','214',563),(6694,'水泉乡','215',563),(6695,'国营官大海农场','400',563),(6696,'城关街道','001',564),(6697,'南山街道','002',564),(6698,'冠山街道','003',564),(6699,'桥北街道','004',564),(6700,'三宝街道','005',564),(6701,'台吉街道','006',564),(6702,'双河街道','008',564),(6703,'西官营镇','101',564),(6704,'大板镇','102',564),(6705,'上园镇','103',564),(6706,'宝国老镇','104',564),(6707,'黑城子镇','105',564),(6708,'五间房镇','107',564),(6709,'台吉镇','108',564),(6710,'长皋乡','201',564),(6711,'常河营乡','202',564),(6712,'小塔子乡','203',564),(6713,'马友营蒙古族乡','204',564),(6714,'蒙古营乡','205',564),(6715,'泉巨永乡','206',564),(6716,'大三家乡','207',564),(6717,'东官营乡','208',564),(6718,'龙潭乡','210',564),(6719,'哈尔脑乡','212',564),(6720,'南八家子乡','213',564),(6721,'章吉营乡','214',564),(6722,'三宝营乡','215',564),(6723,'巴图营乡','216',564),(6724,'台吉营乡','218',564),(6725,'北塔子乡','219',564),(6726,'娄家店乡','220',564),(6727,'北四家乡','221',564),(6728,'凉水河蒙古族乡','223',564),(6729,'三宝乡','228',564),(6730,'下府经济开发区','270',564),(6731,'大黑山特别行政管理区','271',564),(6732,'兴顺德国营农场','400',564),(6733,'东城街道','001',565),(6734,'北街街道','002',565),(6735,'南街街道','003',565),(6736,'红山街道','004',565),(6737,'热水汤街道','006',565),(6738,'工业园区街道','007',565),(6739,'万元店镇','101',565),(6740,'宋杖子镇','102',565),(6741,'三十家子镇','103',565),(6742,'杨杖子镇','104',565),(6743,'刀尔登镇','105',565),(6744,'松岭子镇','106',565),(6745,'四官营子镇','107',565),(6746,'沟门子镇','108',565),(6747,'凌北镇','109',565),(6748,'小城子镇','110',565),(6749,'四合当镇','111',565),(6750,'城关镇','112',565),(6751,'乌兰白镇','113',565),(6752,'大王杖子乡','204',565),(6753,'刘杖子乡','205',565),(6754,'前进乡','206',565),(6755,'大河北乡','207',565),(6756,'三道河子乡','208',565),(6757,'牛营子乡','209',565),(6758,'北炉乡','210',565),(6759,'瓦房店乡','211',565),(6760,'三家子乡','217',565),(6761,'佛爷洞乡','219',565),(6762,'河坎子乡','220',565),(6763,'连山街道','001',567),(6764,'站前街道','002',567),(6765,'渤海街道','003',567),(6766,'兴工街道','004',567),(6767,'石油街道','005',567),(6768,'化工街道','006',567),(6769,'化机街道','007',567),(6770,'水泥街道','008',567),(6771,'杨家杖子街道','010',567),(6772,'锦郊街道','011',567),(6773,'虹螺岘镇','102',567),(6774,'高桥镇','103',567),(6775,'钢屯镇','104',567),(6776,'寺儿堡镇','105',567),(6777,'新台门蒙古族镇','106',567),(6778,'金星镇','107',567),(6779,'台集屯镇','108',567),(6780,'沙河营乡','201',567),(6781,'孤竹营子乡','202',567),(6782,'白马石乡','203',567),(6783,'山神庙子乡','205',567),(6784,'塔山乡','206',567),(6785,'张相公屯乡','209',567),(6786,'杨郊乡','210',567),(6787,'大兴乡','212',567),(6788,'葫芦岛街道','001',568),(6789,'东街道','002',568),(6790,'西街道','003',568),(6791,'望海寺街道','004',568),(6792,'龙湾街道','005',568),(6793,'滨海街道','006',568),(6794,'双龙街道','007',568),(6795,'玉皇街道','008',568),(6796,'连湾街道','009',568),(6797,'北港街道','010',568),(6798,'双树镇','103',568),(6799,'葫芦岛经济开发区','400',568),(6800,'葫芦岛市专利技术园区','401',568),(6801,'赵家屯街道','001',569),(6802,'沙锅屯街道','002',569),(6803,'邱皮沟街道','003',569),(6804,'苇子沟街道','005',569),(6805,'三家子街道','006',569),(6806,'小凌河街道','007',569),(6807,'九龙街道','008',569),(6808,'缸窑岭镇','101',569),(6809,'暖池塘镇','102',569),(6810,'沙锅屯乡','201',569),(6811,'黄土坎乡','203',569),(6812,'乌金塘水库','400',569),(6813,'绥中镇','100',570),(6814,'西甸子镇','101',570),(6815,'宽帮满族镇','102',570),(6816,'大王庙满族镇','103',570),(6817,'万家镇','104',570),(6818,'前所镇','105',570),(6819,'高岭镇','106',570),(6820,'前卫镇','107',570),(6821,'荒地满族镇','108',570),(6822,'塔山屯镇','109',570),(6823,'高台镇','113',570),(6824,'王宝镇','114',570),(6825,'沙河镇','115',570),(6826,'小庄子镇','116',570),(6827,'西平坡满族乡','201',570),(6828,'葛家满族乡','202',570),(6829,'高甸子满族乡','204',570),(6830,'范家满族乡','206',570),(6831,'明水满族乡','207',570),(6832,'秋子沟乡','208',570),(6833,'加碑岩乡','210',570),(6834,'永安堡乡','211',570),(6835,'李家堡乡','212',570),(6836,'网户满族乡','214',570),(6837,'城郊乡','217',570),(6838,'大台山果树农场','400',570),(6839,'前所果树农场','401',570),(6840,'建昌镇','100',571),(6841,'八家子镇','101',571),(6842,'喇嘛洞镇','102',571),(6843,'药王庙镇','103',571),(6844,'汤神庙镇','104',571),(6845,'玲珑塔镇','105',571),(6846,'大屯镇','106',571),(6847,'牛亡牛营子乡','201',571),(6848,'素珠营子乡','203',571),(6849,'石佛乡','204',571),(6850,'王宝营子乡','206',571),(6851,'老达杖子乡','207',571),(6852,'要路沟乡','208',571),(6853,'魏家岭乡','209',571),(6854,'西碱厂乡','210',571),(6855,'头道营子乡','211',571),(6856,'新开岭乡','212',571),(6857,'贺杖子乡','213',571),(6858,'养马甸子乡','214',571),(6859,'和尚房子乡','215',571),(6860,'杨树湾子乡','218',571),(6861,'黑山科乡','219',571),(6862,'雷家店乡','220',571),(6863,'小德营子乡','222',571),(6864,'二道湾子蒙古族乡','223',571),(6865,'巴什罕乡','224',571),(6866,'娘娘庙乡','225',571),(6867,'谷杖子乡','226',571),(6868,'古城街道','001',572),(6869,'宁远街道','002',572),(6870,'城东街道','003',572),(6871,'温泉街道','004',572),(6872,'钓鱼台街道','005',572),(6873,'华山街道','006',572),(6874,'四家屯街道','007',572),(6875,'曹庄镇','101',572),(6876,'沙后所满族镇','103',572),(6877,'东辛庄满族镇','104',572),(6878,'郭家满族镇','105',572),(6879,'羊安满族乡','201',572),(6880,'元台子满族乡','203',572),(6881,'白塔满族乡','204',572),(6882,'望海满族乡','206',572),(6883,'刘台子满族乡','207',572),(6884,'大寨满族乡','208',572),(6885,'南大山满族乡','209',572),(6886,'围屏满族乡','210',572),(6887,'高家岭满族乡','211',572),(6888,'碱厂满族乡','212',572),(6889,'三道沟满族乡','213',572),(6890,'红崖子满族乡','214',572),(6891,'旧门满族乡','215',572),(6892,'药王满族乡','216',572),(6893,'海滨满族乡','218',572),(6894,'菊花岛乡','219',572),(6895,'南岭街道办事处','001',574),(6896,'自强街道办事处','002',574),(6897,'民康街道办事处','003',574),(6898,'新春街道办事处','004',574),(6899,'长通街道办事处','005',574),(6900,'全安街道办事处','006',574),(6901,'曙光街道办事处','007',574),(6902,'永吉街道办事处','008',574),(6903,'桃源街道办事处','009',574),(6904,'鸿城街道办事处','010',574),(6905,'临河街道办事处（长春经济技术开发区)','070',574),(6906,'永兴街道办事处（净月潭旅游经济开发区）?','071',574),(6907,'净月街道办事处（净月潭旅游经济开发区）?','072',574),(6908,'新立城镇（净月潭旅游经济开发区）（省级?','170',574),(6909,'新湖镇（净月潭旅游经济开发区）（省级）','171',574),(6910,'玉潭镇（净月潭旅游经济开发区）（省级）','172',574),(6911,'幸福乡','200',574),(6912,'新发街道办事处','001',575),(6913,'站前街道办事处','002',575),(6914,'南广街道办事处','003',575),(6915,'东广街道办事处','004',575),(6916,'群英街道办事处','005',575),(6917,'兴业街道办事处','006',575),(6918,'凯旋街道办事处','007',575),(6919,'团山街道办事处','008',575),(6920,'柳影街道办事处','009',575),(6921,'兰家镇','100',575),(6922,'米沙子镇','101',575),(6923,'万宝镇','102',575),(6924,'兴隆山镇（长春经济技术开发区）（国家级?','170',575),(6925,'合隆镇（合隆经济开发区）（省级）','171',575),(6926,'奋进乡','200',575),(6927,'兴业农场','400',575),(6928,'南站街道办事处','001',576),(6929,'桂林街道办事处','002',576),(6930,'南湖街道办事处','003',576),(6931,'永昌街道办事处','004',576),(6932,'重庆街道办事处','005',576),(6933,'清和街道办事处','006',576),(6934,'红旗街道办事处','007',576),(6935,'湖西街道办事处','008',576),(6936,'富锋街道办事处','009',576),(6937,'乐山镇','100',576),(6938,'永春镇','101',576),(6939,'双德乡（长春高新技术产业开发区）（国家?','270',576),(6940,'东盛街道办事处','001',577),(6941,'吉林街道办事处','002',577),(6942,'荣光街道办事处','003',577),(6943,'东站街道办事处','004',577),(6944,'远达街道办事处','005',577),(6945,'八里堡街道办事处','006',577),(6946,'东方广场街道办事处（长春经济技术开发区?','070',577),(6947,'英俊镇','100',577),(6948,'劝农山镇','101',577),(6949,'泉眼镇','102',577),(6950,'龙嘉镇（东湖生态经济开发区）（省级）','170',577),(6951,'卡伦湖镇（东湖生态经济开发区）（省级）','171',577),(6952,'东湖镇（东湖生态经济开发区）（省级）','172',577),(6953,'四家乡','200',577),(6954,'正阳街道办事处','001',578),(6955,'普阳街道办事处','002',578),(6956,'春城街道办事处','003',578),(6957,'铁西街道办事处','004',578),(6958,'青年街道办事处','005',578),(6959,'锦程街道办事处（长春汽车产业开发区）（?','070',578),(6960,'东风街道办事处（长春汽车产业开发区）（?','071',578),(6961,'合心镇','100',578),(6962,'西新镇','101',578),(6963,'城西镇','102',578),(6964,'长春汽车产业开发区（省级）','170',578),(6965,'绿园经济开发区（省级）','171',578),(6966,'云山街道办事处','001',579),(6967,'平湖街道办事处','002',579),(6968,'奢岭街道办事处','003',579),(6969,'山河街道办事处','004',579),(6970,'齐家镇','100',579),(6971,'太平镇','101',579),(6972,'鹿乡镇','102',579),(6973,'双营乡（梅花鹿产业经济开发区）（省级）','270',579),(6974,'农安镇','100',580),(6975,'伏龙泉镇','101',580),(6976,'哈拉海镇','102',580),(6977,'靠山镇','103',580),(6978,'开安镇','104',580),(6979,'烧锅镇','105',580),(6980,'高家店镇','106',580),(6981,'华家镇','107',580),(6982,'三盛玉镇','108',580),(6983,'巴吉垒镇','109',580),(6984,'前岗乡','200',580),(6985,'龙王乡','201',580),(6986,'三岗乡','202',580),(6987,'万顺乡','203',580),(6988,'杨树林乡','204',580),(6989,'永安乡','205',580),(6990,'青山口乡','206',580),(6991,'黄鱼圈乡','207',580),(6992,'新农乡','208',580),(6993,'万金塔乡','209',580),(6994,'小城子乡','210',580),(6995,'洼中高农场','400',580),(6996,'九台街道办事处','001',581),(6997,'营城街道办事处','002',581),(6998,'九郊街道办事处','003',581),(6999,'沐石河镇','100',581),(7000,'城子街镇','101',581),(7001,'其塔木镇','102',581),(7002,'上河湾镇','103',581),(7003,'西营城镇','104',581),(7004,'土们岭镇','105',581),(7005,'苇子沟镇','106',581),(7006,'兴隆镇','107',581),(7007,'纪家镇','108',581),(7008,'波泥河镇','109',581),(7009,'胡家回族乡','200',581),(7010,'莽卡满族乡','201',581),(7011,'华昌街道办事处','001',582),(7012,'正阳街道办事处','002',582),(7013,'培英街道办事处','003',582),(7014,'城郊街道办事处','004',582),(7015,'五棵树镇','100',582),(7016,'弓棚镇','101',582),(7017,'闵家镇','102',582),(7018,'大坡镇','103',582),(7019,'黑林镇','104',582),(7020,'土桥镇','105',582),(7021,'新立镇','106',582),(7022,'大岭镇','107',582),(7023,'向阳镇','108',582),(7024,'泗河镇','109',582),(7025,'八号镇','110',582),(7026,'刘家镇','111',582),(7027,'秀水镇','112',582),(7028,'保寿镇','113',582),(7029,'新庄镇','114',582),(7030,'育民乡','200',582),(7031,'红星乡','201',582),(7032,'太安乡','202',582),(7033,'先峰乡','203',582),(7034,'青山乡','204',582),(7035,'延和朝鲜族乡','205',582),(7036,'恩育乡','206',582),(7037,'城发乡','207',582),(7038,'环城乡','208',582),(7039,'胜利街道办事处','001',583),(7040,'建设街道办事处','002',583),(7041,'惠发街道办事处','003',583),(7042,'夏家店街道办事处','004',583),(7043,'大青嘴镇','100',583),(7044,'郭家镇','101',583),(7045,'松花江镇','102',583),(7046,'达家沟镇','103',583),(7047,'大房身镇','104',583),(7048,'岔路口镇','105',583),(7049,'朱城子镇','106',583),(7050,'布海镇','107',583),(7051,'天台镇','108',583),(7052,'菜园子镇','109',583),(7053,'同太乡','200',583),(7054,'边岗乡','201',583),(7055,'五台乡','202',583),(7056,'朝阳乡','203',583),(7057,'兴华街道办事处','001',585),(7058,'文庙街道办事处','002',585),(7059,'东局子街道办事处','003',585),(7060,'新地号街道办事处','004',585),(7061,'延安街道办事处','005',585),(7062,'站前街道办事处','006',585),(7063,'民主街道办事处','007',585),(7064,'莲花街道办事处','008',585),(7065,'通江街道办事处','009',585),(7066,'哈达湾街道办事处','010',585),(7067,'新建街道办事处','011',585),(7068,'延江街道办事处','012',585),(7069,'双吉街道办事处','013',585),(7070,'九站街道办事处(吉林经济技术开发区)（省?','070',585),(7071,'吉林东市商贸示范区（省级）','071',585),(7072,'孤店子镇','100',585),(7073,'桦皮厂镇','101',585),(7074,'左家镇','102',585),(7075,'两家子满族乡','200',585),(7076,'土城子满族朝鲜族乡','201',585),(7077,'吉林哈达湾工业开发区','400',585),(7078,'吉林市昌邑区幸福经济管理区','401',585),(7079,'龙华街道办事处','001',586),(7080,'湘潭街道办事处','002',586),(7081,'铁东街道办事处','003',586),(7082,'泡子沿街道办事处','004',586),(7083,'龙潭街道办事处','005',586),(7084,'新吉林街道办事处','006',586),(7085,'山前街道办事处','007',586),(7086,'新安街道办事处','008',586),(7087,'遵义街道办事处','009',586),(7088,'榆树街道办事处','010',586),(7089,'靠山街道办事处','011',586),(7090,'东城街道办事处','012',586),(7091,'承德街道办事处','013',586),(7092,'吉林龙潭经济开发区（省级）','070',586),(7093,'乌拉街镇','100',586),(7094,'缸窑镇','101',586),(7095,'江密峰镇','102',586),(7096,'大口钦镇','103',586),(7097,'江北乡','200',586),(7098,'金珠乡','201',586),(7099,'德胜街道办事处','001',587),(7100,'南京街道办事处','002',587),(7101,'大东街道办事处','003',587),(7102,'青岛街道办事处','004',587),(7103,'向阳街道办事处','005',587),(7104,'北极街道办事处','006',587),(7105,'致和街道办事处','007',587),(7106,'长春路街道办事处','008',587),(7107,'临江街道办事处','009',587),(7108,'北山街道办事处','010',587),(7109,'黄旗屯街道办事处','011',587),(7110,'大绥河镇','100',587),(7111,'搜登站镇','101',587),(7112,'越北镇','102',587),(7113,'欢喜乡','200',587),(7114,'泰山街道办事处','001',588),(7115,'江南街道办事处','002',588),(7116,'石井街道办事处','003',588),(7117,'沿丰街道办事处','004',588),(7118,'丰满街道办事处','005',588),(7119,'高新开发区街道办事处（吉林高新技术产业?','070',588),(7120,'红旗街道办事处（丰满经济开发区）（省级?','071',588),(7121,'旺起镇','100',588),(7122,'江南乡','200',588),(7123,'前二道乡','201',588),(7124,'小白山乡（丰满经济开发区）（省级）','270',588),(7125,'朱雀山风景区','400',588),(7126,'口前镇','100',589),(7127,'双河镇','101',589),(7128,'西阳镇','102',589),(7129,'北大湖镇','103',589),(7130,'一拉溪镇','104',589),(7131,'岔路河镇（岔路河特色农业经济开发区）（?','170',589),(7132,'万昌镇（岔路河特色农业经济开发区）（省?','171',589),(7133,'永吉经济开发区（省级）','172',589),(7134,'金家乡','200',589),(7135,'黄榆乡','201',589),(7136,'民主街道办事处','001',590),(7137,'长安街道办事处','002',590),(7138,'河南街道办事处','003',590),(7139,'奶子山街道办事处','004',590),(7140,'拉法街道办事处','005',590),(7141,'河北街道办事处','006',590),(7142,'新农街道办事处','007',590),(7143,'新站镇','100',590),(7144,'天岗镇','101',590),(7145,'白石山镇','102',590),(7146,'漂河镇','103',590),(7147,'黄松甸镇','104',590),(7148,'天北镇','105',590),(7149,'松江镇','106',590),(7150,'庆岭镇','107',590),(7151,'乌林朝鲜族乡','200',590),(7152,'前进乡','201',590),(7153,'明桦街道办事处','001',591),(7154,'永吉街道办事处','002',591),(7155,'胜利街道办事处','003',591),(7156,'新华街道办事处','004',591),(7157,'启新街道办事处','005',591),(7158,'桦甸经济开发区（省级）','070',591),(7159,'夹皮沟镇','100',591),(7160,'二道甸子镇','101',591),(7161,'红石砬子镇','102',591),(7162,'八道河子镇','103',591),(7163,'常山镇','104',591),(7164,'桦郊乡','200',591),(7165,'横道河子乡','201',591),(7166,'金沙乡','202',591),(7167,'桦树林子乡','203',591),(7168,'公吉乡','204',591),(7169,'苏密沟乡','205',591),(7170,'北城街道办事处','001',592),(7171,'南城街道办事处','002',592),(7172,'环城街道办事处','003',592),(7173,'吉舒街道办事处','004',592),(7174,'铁东街道办事处','005',592),(7175,'法特镇','100',592),(7176,'白旗镇','101',592),(7177,'溪河镇','102',592),(7178,'朝阳镇','103',592),(7179,'小城镇','104',592),(7180,'上营镇','105',592),(7181,'水曲柳镇','106',592),(7182,'平安镇','107',592),(7183,'金马镇','108',592),(7184,'开原镇','109',592),(7185,'莲花乡','200',592),(7186,'亮甲山乡','201',592),(7187,'新安乡','202',592),(7188,'七里乡','203',592),(7189,'天德乡','204',592),(7190,'福安街道办事处','001',593),(7191,'东宁街道办事处','002',593),(7192,'河南街道办事处','003',593),(7193,'磐石经济开发区（省级）','070',593),(7194,'烟筒山镇','100',593),(7195,'红旗岭镇','101',593),(7196,'明城镇','102',593),(7197,'石嘴镇','103',593),(7198,'驿马镇','104',593),(7199,'牛心镇','105',593),(7200,'呼兰镇','106',593),(7201,'吉昌镇','107',593),(7202,'松山镇','108',593),(7203,'黑石镇','109',593),(7204,'朝阳山镇','110',593),(7205,'富太镇','111',593),(7206,'取柴河镇','112',593),(7207,'宝山乡','200',593),(7208,'仁兴街道办事处','001',595),(7209,'英雄街道办事处','002',595),(7210,'站前街道办事处','003',595),(7211,'北沟街道办事处','004',595),(7212,'地直街道办事处','005',595),(7213,'红嘴高新技术开发区（省级）','070',595),(7214,'平西乡','200',595),(7215,'平东街道办事处','001',596),(7216,'北市场街道办事处','002',596),(7217,'七马路街道办事处','003',596),(7218,'四马路街道办事处','004',596),(7219,'解放街道办事处','005',596),(7220,'北门街道办事处','006',596),(7221,'黄土坑街道办事处','007',596),(7222,'平南街道办事处','008',596),(7223,'山门镇','100',596),(7224,'石岭镇','101',596),(7225,'叶赫满族镇','102',596),(7226,'四平经济开发区（省级）','170',596),(7227,'城东乡','200',596),(7228,'梨树镇','100',597),(7229,'郭家店镇','101',597),(7230,'榆树台镇','102',597),(7231,'孤家子镇（四平辽河农垦管理区）','103',597),(7232,'小城子镇','104',597),(7233,'喇嘛甸镇','105',597),(7234,'蔡家镇','106',597),(7235,'刘家馆子镇','107',597),(7236,'十家堡镇','108',597),(7237,'孟家岭镇','109',597),(7238,'万发镇','110',597),(7239,'东河镇','111',597),(7240,'沈洋镇','112',597),(7241,'林海镇','113',597),(7242,'小宽镇','114',597),(7243,'白山乡','200',597),(7244,'泉眼岭乡','201',597),(7245,'胜利乡','202',597),(7246,'四棵树乡','203',597),(7247,'双河乡','204',597),(7248,'金山乡','205',597),(7249,'国营梨树农场（四平辽河农垦管理区）','400',597),(7250,'梨树经济开发区','401',597),(7251,'伊通镇','100',598),(7252,'二道镇','101',598),(7253,'伊丹镇','102',598),(7254,'马鞍镇','103',598),(7255,'景台镇','104',598),(7256,'靠山镇','105',598),(7257,'大孤山镇','106',598),(7258,'小孤山镇','107',598),(7259,'营城子镇','108',598),(7260,'西苇镇','109',598),(7261,'河源镇','110',598),(7262,'黄岭子镇','111',598),(7263,'新兴乡','200',598),(7264,'莫里乡','201',598),(7265,'三道乡','202',598),(7266,'伊通经济开发区','400',598),(7267,'河南街道办事处','001',599),(7268,'河北街道办事处','002',599),(7269,'东三街道办事处','003',599),(7270,'岭东街道办事处','004',599),(7271,'铁北街道办事处','005',599),(7272,'岭西街道办事处','006',599),(7273,'刘房子街道办事处','007',599),(7274,'南崴子街道办事处','008',599),(7275,'环岭街道办事处','009',599),(7276,'苇子沟街道办事处','010',599),(7277,'二十家子镇','100',599),(7278,'黑林子镇','101',599),(7279,'陶家屯镇','102',599),(7280,'范家屯镇','103',599),(7281,'响水镇','104',599),(7282,'大岭镇','105',599),(7283,'怀德镇','106',599),(7284,'双城堡镇','107',599),(7285,'双龙镇','108',599),(7286,'杨大城子镇','109',599),(7287,'毛城子镇','110',599),(7288,'玻璃城子镇','111',599),(7289,'朝阳坡镇','112',599),(7290,'大榆树镇','113',599),(7291,'秦家屯镇','114',599),(7292,'八屋镇','115',599),(7293,'十屋镇','116',599),(7294,'桑树台镇','117',599),(7295,'龙山乡','200',599),(7296,'永发乡','201',599),(7297,'郑家屯街道办事处','001',600),(7298,'辽西街道办事处','002',600),(7299,'辽南街道办事处','003',600),(7300,'辽北街道办事处','004',600),(7301,'辽东街道办事处','005',600),(7302,'红旗街道办事处','006',600),(7303,'茂林镇','100',600),(7304,'双山镇','101',600),(7305,'卧虎镇','102',600),(7306,'服先镇','103',600),(7307,'王奔镇','104',600),(7308,'玻璃山镇','105',600),(7309,'兴隆镇','106',600),(7310,'东明镇','107',600),(7311,'那木乡','200',600),(7312,'柳条乡','201',600),(7313,'新立乡','202',600),(7314,'永加乡','203',600),(7315,'双辽农场（四平辽河农垦管理区）','400',600),(7316,'双辽种羊场（四平辽河农垦管理区）','401',600),(7317,'双辽经济开发区','402',600),(7318,'南康街道办事处','001',602),(7319,'北寿街道办事处','002',602),(7320,'东吉街道办事处','003',602),(7321,'西宁街道办事处','004',602),(7322,'站前街道办事处','005',602),(7323,'新兴街道办事处','006',602),(7324,'福镇街道办事处','007',602),(7325,'向阳街道办事处','008',602),(7326,'辽源民营经济开发区（省级）','070',602),(7327,'寿山镇','100',602),(7328,'工农乡','200',602),(7329,'仙城街道办事处','001',603),(7330,'太安街道办事处','002',603),(7331,'东山街道办事处','003',603),(7332,'安家街道办事处','004',603),(7333,'先锋街道办事处','005',603),(7334,'富国街道办事处','006',603),(7335,'灯塔乡','200',603),(7336,'东丰镇','100',604),(7337,'大阳镇','101',604),(7338,'横道河镇','102',604),(7339,'那丹伯镇','103',604),(7340,'猴石镇','104',604),(7341,'杨木林镇','105',604),(7342,'小四平镇','106',604),(7343,'黄河镇','107',604),(7344,'拉拉河镇','108',604),(7345,'沙河镇','109',604),(7346,'南屯基镇','110',604),(7347,'大兴镇','111',604),(7348,'三合满族朝鲜族乡','200',604),(7349,'二龙山乡','201',604),(7350,'白泉镇','100',605),(7351,'渭津镇','101',605),(7352,'安石镇','102',605),(7353,'辽河源镇','103',605),(7354,'泉太镇','104',605),(7355,'建安镇','105',605),(7356,'安恕镇','106',605),(7357,'平岗镇','107',605),(7358,'云顶镇','108',605),(7359,'凌云乡','200',605),(7360,'甲山乡','201',605),(7361,'足民乡','202',605),(7362,'金洲乡','203',605),(7363,'东昌街道办事处','001',607),(7364,'民主街道办事处','002',607),(7365,'老站街道办事处','003',607),(7366,'团结街道办事处','004',607),(7367,'新站街道办事处','005',607),(7368,'光明街道办事处','006',607),(7369,'龙泉街道办事处','007',607),(7370,'金厂镇','100',607),(7371,'环通乡','200',607),(7372,'江东乡','201',607),(7373,'通化市经济开发区管委会','400',607),(7374,'桃园街道办事处','001',608),(7375,'东通化街道办事处','002',608),(7376,'鸭园镇','100',608),(7377,'铁厂镇','101',608),(7378,'五道江镇','102',608),(7379,'二道江乡','200',608),(7380,'快大茂镇','100',609),(7381,'二密镇','101',609),(7382,'果松镇','102',609),(7383,'石湖镇','103',609),(7384,'大安镇','104',609),(7385,'光华镇','105',609),(7386,'兴林镇','106',609),(7387,'英额布镇','107',609),(7388,'三棵榆树镇','108',609),(7389,'江甸镇','109',609),(7390,'富江乡','200',609),(7391,'四棚乡','201',609),(7392,'东来乡','202',609),(7393,'大泉源满族朝鲜族乡','203',609),(7394,'金斗朝鲜族满族乡','204',609),(7395,'通化县工业集中区','400',609),(7396,'东宝新村','401',609),(7397,'朝阳镇','100',610),(7398,'辉南镇','101',610),(7399,'样子哨镇','102',610),(7400,'杉松岗镇','103',610),(7401,'石道河镇','104',610),(7402,'辉发城镇','105',610),(7403,'抚民镇','106',610),(7404,'金川镇','107',610),(7405,'团林镇','108',610),(7406,'庆阳镇','109',610),(7407,'楼街朝鲜族乡','200',610),(7408,'柳河镇','100',611),(7409,'三源浦朝鲜族镇','101',611),(7410,'五道沟镇','102',611),(7411,'驼腰岭镇','103',611),(7412,'孤山子镇','104',611),(7413,'圣水河子镇','105',611),(7414,'罗通山镇','106',611),(7415,'安口镇','107',611),(7416,'向阳镇','108',611),(7417,'红石镇','109',611),(7418,'凉水河子镇','110',611),(7419,'亨通镇','111',611),(7420,'柳南乡','200',611),(7421,'时家店乡','201',611),(7422,'姜家店朝鲜族乡','202',611),(7423,'新华街道办事处','001',612),(7424,'光明街道办事处','002',612),(7425,'和平街道办事处（梅河口市经济贸易开发区?','070',612),(7426,'解放街道办事处（梅河口市经济贸易开发区?','071',612),(7427,'福民街道办事处（梅河口市经济贸易开发区?','072',612),(7428,'山城镇','100',612),(7429,'红梅镇','101',612),(7430,'海龙镇','102',612),(7431,'新合镇','103',612),(7432,'曙光镇','104',612),(7433,'中和镇','105',612),(7434,'黑山头镇','106',612),(7435,'水道镇','107',612),(7436,'进化镇','108',612),(7437,'一座营镇','109',612),(7438,'康大营镇','110',612),(7439,'牛心顶镇','111',612),(7440,'杏岭乡','200',612),(7441,'李炉乡','201',612),(7442,'湾龙乡','202',612),(7443,'双兴乡','203',612),(7444,'兴华乡','204',612),(7445,'小杨满族朝鲜族乡','205',612),(7446,'吉乐乡','206',612),(7447,'团结街道办事处','001',613),(7448,'黎明街道办事处','002',613),(7449,'通胜街道办事处','003',613),(7450,'青石镇','100',613),(7451,'榆林镇','101',613),(7452,'花甸镇','102',613),(7453,'头道镇','103',613),(7454,'清河镇','104',613),(7455,'台上镇','105',613),(7456,'财源镇','106',613),(7457,'大路镇','107',613),(7458,'太王镇','108',613),(7459,'麻线乡','200',613),(7460,'凉水朝鲜族乡','201',613),(7461,'新建街道办事处','001',615),(7462,'通沟街道办事处','002',615),(7463,'东兴街道办事处','003',615),(7464,'红旗街道办事处','004',615),(7465,'城南街道办事处','005',615),(7466,'江北街道办事处','006',615),(7467,'河口街道办事处','007',615),(7468,'板石街道办事处','008',615),(7469,'七道江镇','100',615),(7470,'六道江镇','101',615),(7471,'红土崖镇','102',615),(7472,'三道沟镇','103',615),(7473,'孙家堡子镇','100',616),(7474,'三岔子镇','101',616),(7475,'湾沟镇','102',616),(7476,'松树镇','103',616),(7477,'砟子镇','104',616),(7478,'石人镇','105',616),(7479,'大阳岔镇','106',616),(7480,'大石人镇','107',616),(7481,'抚松镇','100',617),(7482,'松江河镇','101',617),(7483,'泉阳镇','102',617),(7484,'露水河镇','103',617),(7485,'仙人桥镇','104',617),(7486,'万良镇','105',617),(7487,'新屯子镇','106',617),(7488,'东岗镇','107',617),(7489,'漫江镇','108',617),(7490,'北岗镇','109',617),(7491,'兴参镇','110',617),(7492,'兴隆乡','200',617),(7493,'抽水乡','201',617),(7494,'沿江乡','202',617),(7495,'靖宇镇','100',618),(7496,'三道湖镇','101',618),(7497,'龙泉镇','102',618),(7498,'那尔轰镇','103',618),(7499,'花园口镇','104',618),(7500,'景山镇','105',618),(7501,'赤松乡','200',618),(7502,'蒙江乡','201',618),(7503,'长白镇','100',619),(7504,'八道沟镇','101',619),(7505,'十四道沟镇','102',619),(7506,'马鹿沟镇','103',619),(7507,'宝泉山镇','104',619),(7508,'新房子镇','105',619),(7509,'金华乡','200',619),(7510,'十二道沟乡','201',619),(7511,'长白县南坡旅游开发区（长白山保护开发区?','270',619),(7512,'建国街道办事处','001',620),(7513,'新市街道办事处','002',620),(7514,'兴隆街道办事处','003',620),(7515,'大湖街道办事处','004',620),(7516,'森工街道办事处','005',620),(7517,'大栗子街道办事处','006',620),(7518,'桦树镇','100',620),(7519,'六道沟镇','101',620),(7520,'苇沙河镇','102',620),(7521,'花山镇','103',620),(7522,'闹枝镇','104',620),(7523,'四道沟镇','105',620),(7524,'蚂蚁河乡','200',620),(7525,'团结街道办事处','001',622),(7526,'文化街道办事处','002',622),(7527,'民主街道办事处','003',622),(7528,'临江街道办事处','004',622),(7529,'新区街道办事处','005',622),(7530,'前进街道办事处','006',622),(7531,'和平街道办事处','007',622),(7532,'工农街道办事处','008',622),(7533,'沿江街道办事处','009',622),(7534,'铁西街道办事处','010',622),(7535,'繁荣街道办事处','011',622),(7536,'建设街道办事处','012',622),(7537,'石化街道办事处','013',622),(7538,'大洼镇','100',622),(7539,'善友镇','101',622),(7540,'毛都站镇','102',622),(7541,'伯都纳镇','103',622),(7542,'新城乡','200',622),(7543,'兴原乡','201',622),(7544,'华侨农场','400',622),(7545,'前郭尔罗斯镇','100',623),(7546,'长山镇','101',623),(7547,'海渤日戈镇','102',623),(7548,'乌兰图嘎镇','103',623),(7549,'查干花镇','104',623),(7550,'王府站镇','105',623),(7551,'八郎镇','106',623),(7552,'哈拉毛都镇','107',623),(7553,'宝甸乡','200',623),(7554,'平凤乡','201',623),(7555,'蒙古艾里乡','202',623),(7556,'达里巴乡','203',623),(7557,'吉拉吐乡','204',623),(7558,'白依拉嘎乡','205',623),(7559,'洪泉乡','206',623),(7560,'额如乡','207',623),(7561,'套浩太乡','208',623),(7562,'长龙乡','209',623),(7563,'乌兰塔拉乡','210',623),(7564,'东三家子乡','211',623),(7565,'浩特芒哈乡','212',623),(7566,'乌兰敖都乡','213',623),(7567,'红旗农场','400',623),(7568,'红光农场','401',623),(7569,'红星牧场','402',623),(7570,'查干花种畜场','403',623),(7571,'长岭镇','100',624),(7572,'太平川镇','101',624),(7573,'巨宝镇','102',624),(7574,'太平山镇','103',624),(7575,'前七号镇','104',624),(7576,'新安镇','105',624),(7577,'三青山镇','106',624),(7578,'大兴镇','107',624),(7579,'北正镇','108',624),(7580,'流水镇','109',624),(7581,'永久镇','110',624),(7582,'利发盛镇','111',624),(7583,'集体乡','200',624),(7584,'光明乡','201',624),(7585,'三县堡乡','202',624),(7586,'海青乡','203',624),(7587,'前进乡','204',624),(7588,'东岭乡','205',624),(7589,'腰坨子乡','206',624),(7590,'八十八乡','207',624),(7591,'三团乡','208',624),(7592,'三十号乡','209',624),(7593,'长岭种马场','400',624),(7594,'太平川（镇）农业园区','401',624),(7595,'北正（镇）牧业园区','402',624),(7596,'双龙工业园区','403',624),(7597,'长岭经济开发区','404',624),(7598,'太平川机械林场','405',624),(7599,'三团机械林场','406',624),(7600,'东岭机械林场','407',624),(7601,'十四号种畜场','408',624),(7602,'良种繁育场','409',624),(7603,'前七号机械林场','410',624),(7604,'乾安镇','100',625),(7605,'大布苏镇','101',625),(7606,'水字镇','102',625),(7607,'让字镇','103',625),(7608,'所字镇','104',625),(7609,'安字镇','105',625),(7610,'余字乡','200',625),(7611,'道字乡','201',625),(7612,'严字乡','202',625),(7613,'赞字乡','203',625),(7614,'三岔河镇','100',626),(7615,'长春岭镇','101',626),(7616,'五家站镇','102',626),(7617,'陶赖昭镇','103',626),(7618,'蔡家沟镇','104',626),(7619,'弓棚子镇','105',626),(7620,'三井子镇','106',626),(7621,'增盛镇','107',626),(7622,'新万发镇','108',626),(7623,'大林子镇','109',626),(7624,'新源镇','110',626),(7625,'三骏满族蒙古族锡伯族乡','200',626),(7626,'永平乡','201',626),(7627,'社里乡','202',626),(7628,'新站乡','203',626),(7629,'更新乡','204',626),(7630,'伊家店乡','205',626),(7631,'肖家乡','206',626),(7632,'伊家店农场','400',626),(7633,'拉林灌区管理局','401',626),(7634,'下岱吉灌区管理局','402',626),(7635,'海明街道办事处','001',628),(7636,'长庆街道办事处','002',628),(7637,'瑞光街道办事处','003',628),(7638,'明仁街道办事处','004',628),(7639,'铁东街道办事处','005',628),(7640,'城南街道办事处','006',628),(7641,'新立街道办事处','007',628),(7642,'幸福街道办事处','008',628),(7643,'新华街道办事处','009',628),(7644,'保平街道办事处','010',628),(7645,'白城经济开发区（省级）','070',628),(7646,'平安镇','100',628),(7647,'青山镇','101',628),(7648,'林海镇','102',628),(7649,'洮河镇','103',628),(7650,'平台镇','104',628),(7651,'到保镇','105',628),(7652,'岭下镇（查干浩特旅游经济开发区）（省级?','170',628),(7653,'东风乡','200',628),(7654,'三合乡','201',628),(7655,'东胜乡','202',628),(7656,'金祥乡','203',628),(7657,'德顺蒙古族乡','204',628),(7658,'民营经济发展区','400',628),(7659,'白城市工业园区','401',628),(7660,'镇南种羊场','402',628),(7661,'镇赉镇','100',629),(7662,'坦途镇','101',629),(7663,'东屏镇','102',629),(7664,'大屯镇','103',629),(7665,'沿江镇','104',629),(7666,'五棵树镇','105',629),(7667,'黑鱼泡镇','106',629),(7668,'哈吐气蒙古族乡','200',629),(7669,'莫莫格蒙古族乡','201',629),(7670,'建平乡','202',629),(7671,'嘎什根乡','203',629),(7672,'镇赉监狱分局','400',629),(7673,'开通镇','100',630),(7674,'瞻榆镇','101',630),(7675,'双岗镇','102',630),(7676,'兴隆山镇','103',630),(7677,'边昭镇','104',630),(7678,'鸿兴镇','105',630),(7679,'新华镇','106',630),(7680,'乌兰花镇','107',630),(7681,'新发乡','200',630),(7682,'新兴乡','201',630),(7683,'向海蒙古族乡','202',630),(7684,'包拉温都蒙古族乡','203',630),(7685,'团结乡','204',630),(7686,'十花道乡','205',630),(7687,'八面乡','206',630),(7688,'苏公坨乡','207',630),(7689,'通榆经济开发区','400',630),(7690,'团结街道办事处','001',631),(7691,'富文街道办事处','002',631),(7692,'光明街道办事处','003',631),(7693,'兴隆街道办事处','004',631),(7694,'永康街道办事处','005',631),(7695,'通达街道办事处','006',631),(7696,'洮府街道办事处','007',631),(7697,'向阳街道办事处','008',631),(7698,'瓦房镇','100',631),(7699,'万宝镇','101',631),(7700,'黑水镇','102',631),(7701,'那金镇','103',631),(7702,'安定镇','104',631),(7703,'胡力吐蒙古族乡','200',631),(7704,'万宝乡','201',631),(7705,'聚宝乡','202',631),(7706,'东升乡','203',631),(7707,'野马乡','204',631),(7708,'永茂乡','205',631),(7709,'蛟流河乡','206',631),(7710,'大通乡','207',631),(7711,'福顺乡','208',631),(7712,'二龙乡','209',631),(7713,'呼和车力蒙古族乡','210',631),(7714,'洮南市种雏场','400',631),(7715,'洮南市甜菜育种研究所','401',631),(7716,'慧阳街道办事处','001',632),(7717,'临江街道办事处','002',632),(7718,'长虹街道办事处','003',632),(7719,'锦华街道办事处','004',632),(7720,'安北街道办事处','005',632),(7721,'大安经济开发区（省级）','070',632),(7722,'月亮泡镇','100',632),(7723,'安广镇','101',632),(7724,'丰收镇','102',632),(7725,'新平安镇','103',632),(7726,'两家子镇','104',632),(7727,'舍力镇','105',632),(7728,'大岗子镇','106',632),(7729,'叉干镇','107',632),(7730,'龙沼镇','108',632),(7731,'太山镇','109',632),(7732,'烧锅镇','110',632),(7733,'乐胜镇','111',632),(7734,'四棵树乡','200',632),(7735,'联合乡','201',632),(7736,'大赉乡','202',632),(7737,'红岗子乡','203',632),(7738,'海坨乡','204',632),(7739,'新艾里蒙古族乡','205',632),(7740,'朝阳街道办事处','001',633),(7741,'北山街道办事处','002',633),(7742,'新兴街道办事处','003',633),(7743,'公园街道办事处','004',633),(7744,'河南街道办事处','005',633),(7745,'建工街道办事处','006',633),(7746,'小营镇','100',633),(7747,'依兰镇','101',633),(7748,'三道湾镇','102',633),(7749,'向上街道办事处','001',634),(7750,'新华街道办事处','002',634),(7751,'月宫街道办事处','003',634),(7752,'月晴镇','100',634),(7753,'石岘镇','101',634),(7754,'长安镇','102',634),(7755,'凉水镇','103',634),(7756,'渤海街道办事处','001',635),(7757,'胜利街道办事处','002',635),(7758,'民主街道办事处','003',635),(7759,'丹江街道办事处','004',635),(7760,'大石头镇','100',635),(7761,'黄泥河镇','101',635),(7762,'官地镇','102',635),(7763,'沙河沿镇','103',635),(7764,'秋梨沟镇','104',635),(7765,'额穆镇','105',635),(7766,'贤儒镇','106',635),(7767,'大蒲柴河镇','107',635),(7768,'雁鸣湖镇','108',635),(7769,'江源镇','109',635),(7770,'江南镇','110',635),(7771,'大桥乡','200',635),(7772,'黑石乡','201',635),(7773,'青沟子乡','202',635),(7774,'翰章乡','203',635),(7775,'红石乡','204',635),(7776,'丹峰林业有限公司','400',635),(7777,'黄泥河林业局','401',635),(7778,'延边林业集团亚光有限公司','402',635),(7779,'敦化市林业局','403',635),(7780,'靖和街道办事处','001',636),(7781,'新安街道办事处','002',636),(7782,'河南街道办事处','003',636),(7783,'近海街道办事处（珲春边境经济合作区）（?','070',636),(7784,'春化镇','100',636),(7785,'敬信镇','101',636),(7786,'板石镇','102',636),(7787,'英安镇','103',636),(7788,'马川子乡','200',636),(7789,'杨泡满族乡','201',636),(7790,'三家子满族乡','202',636),(7791,'密江乡','203',636),(7792,'哈达门乡','204',636),(7793,'珲春林业局','400',636),(7794,'安民街道办事处','001',637),(7795,'龙门街道办事处','002',637),(7796,'开山屯镇','100',637),(7797,'朝阳川镇','101',637),(7798,'老头沟镇','102',637),(7799,'三合镇','103',637),(7800,'东盛涌镇','104',637),(7801,'智新镇','105',637),(7802,'德新乡','200',637),(7803,'白金乡','201',637),(7804,'民慧街道办事处','001',638),(7805,'光明街道办事处','002',638),(7806,'文化街道办事处','003',638),(7807,'八家子镇','100',638),(7808,'福洞镇','101',638),(7809,'头道镇','102',638),(7810,'西城镇','103',638),(7811,'南坪镇','104',638),(7812,'东城镇','105',638),(7813,'崇善镇','106',638),(7814,'龙城镇','107',638),(7815,'和龙林业局','400',638),(7816,'八家子林业局','401',638),(7817,'和龙市林业局','402',638),(7818,'东城街道办事处','001',639),(7819,'西城街道办事处','002',639),(7820,'汪清镇','100',639),(7821,'大兴沟镇','101',639),(7822,'天桥岭镇','102',639),(7823,'罗子沟镇','103',639),(7824,'百草沟镇','104',639),(7825,'春阳镇','105',639),(7826,'复兴镇','106',639),(7827,'东光镇','107',639),(7828,'鸡冠乡','200',639),(7829,'汪清林业局','400',639),(7830,'天桥岭林业局','401',639),(7831,'大兴沟林业局','402',639),(7832,'明月镇','100',640),(7833,'松江镇','101',640),(7834,'二道白河镇','102',640),(7835,'两江镇','103',640),(7836,'石门镇','104',640),(7837,'万宝镇','105',640),(7838,'亮兵镇','106',640),(7839,'新合乡','200',640),(7840,'永庆乡','201',640),(7841,'白河林业局','400',640),(7842,'安图林业有限公司','401',640),(7843,'安图县林业局','402',640),(7844,'兆麟街道办事处','001',642),(7845,'新阳路街道办事处','002',642),(7846,'抚顺街道办事处','003',642),(7847,'共乐街道办事处','004',642),(7848,'新华街道办事处','005',642),(7849,'城乡路街道办事处','006',642),(7850,'工农街道办事处','007',642),(7851,'尚志街道办事处','008',642),(7852,'斯大林街道办事处','009',642),(7853,'通江街道办事处','010',642),(7854,'经纬街道办事处','011',642),(7855,'工程街道办事处','012',642),(7856,'安静街道办事处','013',642),(7857,'安和街道办事处','014',642),(7858,'正阳河街道办事处','015',642),(7859,'建国街道办事处','016',642),(7860,'康安街道办事处','017',642),(7861,'太平镇','101',642),(7862,'新发镇','102',642),(7863,'新农镇','103',642),(7864,'榆树镇','104',642),(7865,'群力乡','200',642),(7866,'阎家岗农场','500',642),(7867,'花园街道办事处','001',643),(7868,'奋斗路街道办事处','002',643),(7869,'革新街道办事处','003',643),(7870,'文化街道办事处','004',643),(7871,'大成街道办事处','005',643),(7872,'芦家街道办事处','006',643),(7873,'荣市街道办事处','007',643),(7874,'燎原街道办事处','009',643),(7875,'松花江街道办事处','010',643),(7876,'曲线街道办事处','011',643),(7877,'通达街道办事处','012',643),(7878,'七政街道办事处','013',643),(7879,'和兴路街道办事处','015',643),(7880,'哈西街道办事处','016',643),(7881,'保健路街道办事处','017',643),(7882,'先锋路街道办事处','018',643),(7883,'新春街道办事处','019',643),(7884,'王岗镇','101',643),(7885,'红旗满族乡','201',643),(7886,'跃进乡','202',643),(7887,'靖宇街道办事处','001',644),(7888,'太古街道办事处','002',644),(7889,'东莱街道办事处','003',644),(7890,'滨江街道办事处','004',644),(7891,'仁里街道办事处','005',644),(7892,'崇俭街道办事处','007',644),(7893,'振江街道办事处','008',644),(7894,'东原街道办事处','009',644),(7895,'大兴街道办事处','010',644),(7896,'胜利街道办事处','011',644),(7897,'南马街道办事处','012',644),(7898,'民强街道办事处','021',644),(7899,'大有坊街道办事处','022',644),(7900,'南直路街道办事处','023',644),(7901,'化工街道办事处','024',644),(7902,'火车头街道办事处','025',644),(7903,'新一街道办事处','026',644),(7904,'三棵树大街街道办事处','027',644),(7905,'水泥路街道办事处','028',644),(7906,'太平大街街道办事处','029',644),(7907,'黎华街道办事处','030',644),(7908,'新乐街道办事处','031',644),(7909,'永源镇','102',644),(7910,'巨源镇','109',644),(7911,'团结镇','111',644),(7912,'民主乡','200',644),(7913,'兴建街道办事处','001',645),(7914,'保国街道办事处','002',645),(7915,'联盟街道办事处','003',645),(7916,'友协街道办事处','004',645),(7917,'新疆街道办事处','005',645),(7918,'新伟街道办事处','006',645),(7919,'平房镇','101',645),(7920,'平新镇','102',645),(7921,'三电街道办事处','001',646),(7922,'太阳岛街道办事处','002',646),(7923,'松浦街道办事处','003',646),(7924,'万宝街道办事处','004',646),(7925,'松北街道办事处','005',646),(7926,'对青山镇','101',646),(7927,'乐业镇','102',646),(7928,'香坊大街街道办事处','001',647),(7929,'安埠街道办事处','002',647),(7930,'通天街道办事处','003',647),(7931,'新香坊街道办事处','004',647),(7932,'铁东街道办事处','005',647),(7933,'新成街道办事处','006',647),(7934,'红旗街道办事处','007',647),(7935,'六顺街道办事处','008',647),(7936,'建筑街道办事处','009',647),(7937,'哈平路街道办事处','010',647),(7938,'安乐街道办事处','011',647),(7939,'健康路街道办事处','012',647),(7940,'大庆路街道办事处','013',647),(7941,'进乡街道办事处','014',647),(7942,'通乡街道办事处','015',647),(7943,'和平路街道办事处','016',647),(7944,'民生路街道办事处','017',647),(7945,'文政街道办事处','018',647),(7946,'王兆街道办事处','019',647),(7947,'黎明街道办事处','020',647),(7948,'成高子镇','101',647),(7949,'幸福镇','102',647),(7950,'朝阳镇','103',647),(7951,'向阳乡','201',647),(7952,'香坊实验农场','500',647),(7953,'呼兰街道办事处','001',648),(7954,'兰河街道办事处','002',648),(7955,'利民街道办事处','003',648),(7956,'腰卜街道办事处','004',648),(7957,'康金镇','101',648),(7958,'沈家镇','104',648),(7959,'二八镇','105',648),(7960,'石人镇','106',648),(7961,'白奎镇','107',648),(7962,'方台镇','109',648),(7963,'莲花镇','110',648),(7964,'大用镇','111',648),(7965,'双井镇','112',648),(7966,'长岭镇','113',648),(7967,'杨林乡','201',648),(7968,'许卜乡','203',648),(7969,'孟家乡','205',648),(7970,'和平街道办事处','001',649),(7971,'胜利街道办事处','002',649),(7972,'通城街道办事处','003',649),(7973,'河东街道办事处','004',649),(7974,'阿什河街道办事处','005',649),(7975,'玉泉镇','101',649),(7976,'蜚克图镇','103',649),(7977,'亚沟镇','104',649),(7978,'交界镇','105',649),(7979,'小岭镇','106',649),(7980,'平山镇','107',649),(7981,'松峰山镇','108',649),(7982,'新华镇','110',649),(7983,'双丰镇','111',649),(7984,'杨树乡','202',649),(7985,'舍利乡','204',649),(7986,'料甸满族乡','205',649),(7987,'红星乡','206',649),(7988,'大岭乡','207',649),(7989,'依兰镇','100',650),(7990,'达连河镇','101',650),(7991,'江湾镇','102',650),(7992,'三道岗镇','103',650),(7993,'道台桥镇','104',650),(7994,'宏克利镇','105',650),(7995,'团山子乡','200',650),(7996,'愚公乡','201',650),(7997,'迎兰朝鲜族乡','202',650),(7998,'依兰县林业局','400',650),(7999,'依兰农场','500',650),(8000,'松花江农场','501',650),(8001,'红旗良种厂','580',650),(8002,'依兰县农委','581',650),(8003,'方正镇','100',651),(8004,'会发镇','101',651),(8005,'大罗密镇','102',651),(8006,'天门乡','200',651),(8007,'松南乡','201',651),(8008,'德善乡','202',651),(8009,'宝兴乡','204',651),(8010,'伊汉通乡','205',651),(8011,'方正林业局','400',651),(8012,'沙河农场','500',651),(8013,'宾州镇','100',652),(8014,'居仁镇','101',652),(8015,'宾西镇','102',652),(8016,'糖坊镇','103',652),(8017,'宾安镇','104',652),(8018,'新甸镇','105',652),(8019,'胜利镇','106',652),(8020,'宁远镇','107',652),(8021,'摆渡镇','109',652),(8022,'平坊镇','110',652),(8023,'满井镇','111',652),(8024,'常安镇','112',652),(8025,'永和乡','201',652),(8026,'鸟河乡','203',652),(8027,'民和乡','204',652),(8028,'经建乡','205',652),(8029,'三宝乡','210',652),(8030,'巴彦镇','100',653),(8031,'兴隆镇','101',653),(8032,'西集镇','102',653),(8033,'洼兴镇','103',653),(8034,'龙泉镇','104',653),(8035,'巴彦港镇','105',653),(8036,'龙庙镇','106',653),(8037,'万发镇','107',653),(8038,'天增镇','108',653),(8039,'黑山镇','110',653),(8040,'松花江乡','200',653),(8041,'富江乡','202',653),(8042,'华山乡','204',653),(8043,'丰乐乡','205',653),(8044,'德祥乡','209',653),(8045,'红光乡','210',653),(8046,'山后乡','212',653),(8047,'镇东乡','214',653),(8048,'兴隆林业局','400',653),(8049,'木兰镇','100',654),(8050,'东兴镇','101',654),(8051,'大贵镇','102',654),(8052,'利东镇','103',654),(8053,'柳河镇','104',654),(8054,'新民镇','105',654),(8055,'建国乡','200',654),(8056,'吉兴乡','203',654),(8057,'兴隆林业局办事处','400',654),(8058,'通河镇','100',655),(8059,'乌鸦泡镇','101',655),(8060,'清河镇','102',655),(8061,'浓河镇','103',655),(8062,'凤山镇','104',655),(8063,'祥顺镇','105',655),(8064,'三站乡','201',655),(8065,'富林乡','202',655),(8066,'清河林业局','400',655),(8067,'兴隆林业局办事处','401',655),(8068,'岔林河农场','500',655),(8069,'延寿镇','100',656),(8070,'六团镇','101',656),(8071,'中和镇','102',656),(8072,'加信镇','103',656),(8073,'延河镇','104',656),(8074,'安山乡','204',656),(8075,'寿山乡','205',656),(8076,'玉河乡','206',656),(8077,'青川乡','209',656),(8078,'太平川','400',656),(8079,'庆阳农场','500',656),(8080,'双城市街道社区管委会','001',657),(8081,'双城镇','100',657),(8082,'兰棱镇','101',657),(8083,'周家镇','102',657),(8084,'五家镇','103',657),(8085,'韩甸镇','104',657),(8086,'单城镇','105',657),(8087,'东官镇','106',657),(8088,'农丰满族锡伯族镇','107',657),(8089,'杏山镇','108',657),(8090,'朝阳乡','200',657),(8091,'金城乡','201',657),(8092,'青岭满族乡','203',657),(8093,'联兴满族乡','204',657),(8094,'幸福满族乡','205',657),(8095,'新兴满族乡','206',657),(8096,'公正满族乡','207',657),(8097,'永胜乡','208',657),(8098,'临江乡','209',657),(8099,'水泉乡','210',657),(8100,'乐群满族乡','211',657),(8101,'团结满族乡','213',657),(8102,'万隆乡','214',657),(8103,'希勤满族乡','216',657),(8104,'同心满族乡','217',657),(8105,'尚志镇','100',658),(8106,'一面坡镇','101',658),(8107,'苇河镇','102',658),(8108,'亚布力镇','103',658),(8109,'帽儿山镇','104',658),(8110,'亮河镇','105',658),(8111,'庆阳镇','106',658),(8112,'石头河子镇','107',658),(8113,'元宝镇','108',658),(8114,'黑龙宫镇','109',658),(8115,'长寿乡','202',658),(8116,'乌吉密乡','204',658),(8117,'鱼池乡','206',658),(8118,'珍珠山乡','207',658),(8119,'老街基乡','208',658),(8120,'马延乡','209',658),(8121,'河东乡','211',658),(8122,'苇河林业局','400',658),(8123,'亚布力林业局','401',658),(8124,'五常镇','100',659),(8125,'拉林满族镇','101',659),(8126,'山河镇','102',659),(8127,'小山子镇','103',659),(8128,'安家镇','104',659),(8129,'牛家满族镇','105',659),(8130,'杜家镇','106',659),(8131,'背荫河镇','107',659),(8132,'冲河镇','108',659),(8133,'沙河子镇','109',659),(8134,'向阳镇','110',659),(8135,'兴盛乡','200',659),(8136,'志广乡','201',659),(8137,'卫国乡','202',659),(8138,'常堡乡','203',659),(8139,'民意乡','206',659),(8140,'龙凤山乡','207',659),(8141,'红旗满族乡','209',659),(8142,'八家子乡','210',659),(8143,'民乐朝鲜族乡','211',659),(8144,'营城子满族乡','212',659),(8145,'长山乡','214',659),(8146,'兴隆乡','215',659),(8147,'二河乡','216',659),(8148,'山河屯林业局','400',659),(8149,'五龙街道办事处','001',661),(8150,'湖滨街道办事处','002',661),(8151,'江安街道办事处','003',661),(8152,'正阳街道办事处','004',661),(8153,'彩虹街道办事处','005',661),(8154,'南航街道办事处','006',661),(8155,'龙沙区直辖地域','198',661),(8156,'中华街道办事处','003',662),(8157,'西大桥街道办事处','004',662),(8158,'卜奎街道办事处','005',662),(8159,'建设街道办事处','006',662),(8160,'文化街道办事处','007',662),(8161,'建华区直辖地域','198',662),(8162,'站前街道办事处','001',663),(8163,'南浦街道办事处','002',663),(8164,'通东街道办事处','003',663),(8165,'光荣街道办事处','004',663),(8166,'龙华街道办事处','005',663),(8167,'北局宅街道办事处','006',663),(8168,'东湖街道办事处','008',663),(8169,'扎龙乡','200',663),(8170,'齐齐哈尔种畜场','580',663),(8171,'新兴街道办事处','001',664),(8172,'新建街道办事处','002',664),(8173,'林机街道办事处','005',664),(8174,'道北街道办事处','006',664),(8175,'水师营满族镇','100',664),(8176,'三间房镇','102',664),(8177,'红岸街道办事处','001',665),(8178,'沿江街道办事处','003',665),(8179,'电力街道办事处','004',665),(8180,'幸福街道办事处','005',665),(8181,'红宝石街道办事处','006',665),(8182,'北兴街道办事处','007',665),(8183,'铁北街道办事处','008',665),(8184,'长青乡','200',665),(8185,'杜尔门沁达翰尔族乡','202',665),(8186,'东安街道办事处','001',666),(8187,'富强街道办事处','002',666),(8188,'跃进街道办事处','003',666),(8189,'繁荣街道办事处','004',666),(8190,'碾子山区直辖地域','198',666),(8191,'梅里斯街道办事处','001',667),(8192,'雅尔塞镇','101',667),(8193,'卧牛吐镇','102',667),(8194,'达呼店镇','103',667),(8195,'共和镇','104',667),(8196,'莽格吐乡','200',667),(8197,'梅里斯乡','201',667),(8198,'哈拉海农场','501',667),(8199,'龙江镇','100',668),(8200,'景星镇','101',668),(8201,'龙兴镇','102',668),(8202,'山泉镇','103',668),(8203,'七棵树镇','104',668),(8204,'白山乡','200',668),(8205,'黑岗乡','201',668),(8206,'广厚乡','202',668),(8207,'华民乡','203',668),(8208,'哈拉海乡','204',668),(8209,'杏山乡','211',668),(8210,'头站乡','214',668),(8211,'鲁河乡','215',668),(8212,'济沁河乡','217',668),(8213,'依安镇','100',669),(8214,'依龙镇','101',669),(8215,'双阳镇','102',669),(8216,'三兴镇','103',669),(8217,'中心镇','104',669),(8218,'富饶乡','200',669),(8219,'解放乡','201',669),(8220,'阳春乡','202',669),(8221,'新发乡','203',669),(8222,'太东乡','204',669),(8223,'上游乡','205',669),(8224,'红星乡','206',669),(8225,'先锋乡','207',669),(8226,'新屯乡','208',669),(8227,'新兴乡','210',669),(8228,'依安农场','500',669),(8229,'黑龙江红旗马场','580',669),(8230,'泰来镇','100',670),(8231,'平洋镇','101',670),(8232,'汤池镇','102',670),(8233,'江桥蒙古族镇','103',670),(8234,'塔子城镇','104',670),(8235,'大兴镇','105',670),(8236,'和平镇','106',670),(8237,'克利镇','107',670),(8238,'胜利蒙古族乡','200',670),(8239,'宁姜蒙古族乡','209',670),(8240,'葡萄场','400',670),(8241,'果树场','401',670),(8242,'泰来县一苗圃','402',670),(8243,'泰来县二苗圃','403',670),(8244,'东方红机械林场','404',670),(8245,'泰来农场','500',670),(8246,'第一良种场','580',670),(8247,'第二良种场','581',670),(8248,'宏胜种畜场','582',670),(8249,'二龙涛农场','583',670),(8250,'六三监狱','584',670),(8251,'甘南镇','100',671),(8252,'音河镇','101',671),(8253,'平阳镇','102',671),(8254,'东阳镇','103',671),(8255,'巨宝镇','104',671),(8256,'长山乡','201',671),(8257,'中兴乡','202',671),(8258,'兴隆乡','203',671),(8259,'宝山乡','204',671),(8260,'查哈阳乡','206',671),(8261,'查哈阳农场','500',671),(8262,'北京市双河农场','580',671),(8263,'富裕镇','100',672),(8264,'富路镇','101',672),(8265,'富海镇','102',672),(8266,'二道湾镇','103',672),(8267,'龙安桥镇','104',672),(8268,'繁荣乡','200',672),(8269,'绍文乡','201',672),(8270,'忠厚乡','202',672),(8271,'友谊乡','203',672),(8272,'塔哈乡','204',672),(8273,'富裕牧场','500',672),(8274,'繁荣种畜场','580',672),(8275,'克山镇','100',673),(8276,'北兴镇','101',673),(8277,'西城镇','102',673),(8278,'古城镇','103',673),(8279,'北联镇','104',673),(8280,'西河镇','105',673),(8281,'河南乡','200',673),(8282,'双河乡','201',673),(8283,'河北乡','203',673),(8284,'古北乡','204',673),(8285,'西联乡','205',673),(8286,'发展乡','206',673),(8287,'西建乡','207',673),(8288,'向华乡','208',673),(8289,'曙光乡','210',673),(8290,'克山县河北林场','400',673),(8291,'克山县涌泉林场','401',673),(8292,'克山县北联林场','402',673),(8293,'克山农场','500',673),(8294,'克山县第一良种场','580',673),(8295,'克山县第二良种场','581',673),(8296,'克山县种畜场','582',673),(8297,'克山县种猪场','583',673),(8298,'克东镇','100',674),(8299,'宝泉镇','101',674),(8300,'乾丰镇','102',674),(8301,'玉岗镇','103',674),(8302,'金城乡','200',674),(8303,'润津乡','202',674),(8304,'昌盛乡','204',674),(8305,'第一苗圃','400',674),(8306,'第二苗圃','401',674),(8307,'爱华林场','402',674),(8308,'发展林场','403',674),(8309,'东兴林场','404',674),(8310,'红旗奶山羊场','580',674),(8311,'第一良种场','581',674),(8312,'第二良种繁殖场','582',674),(8313,'果树繁殖场','583',674),(8314,'种猪场','584',674),(8315,'建业农场','585',674),(8316,'拜泉镇','100',675),(8317,'三道镇','101',675),(8318,'兴农镇','102',675),(8319,'长春镇','103',675),(8320,'龙泉镇','104',675),(8321,'国富镇','105',675),(8322,'富强镇','106',675),(8323,'新生乡','200',675),(8324,'兴国乡','201',675),(8325,'上升乡','203',675),(8326,'兴华乡','204',675),(8327,'大众乡','206',675),(8328,'丰产乡','209',675),(8329,'永勤乡','210',675),(8330,'爱农乡','212',675),(8331,'时中乡','214',675),(8332,'讷河镇','100',676),(8333,'拉哈镇','101',676),(8334,'二克浅镇','102',676),(8335,'学田镇','103',676),(8336,'龙河镇','104',676),(8337,'讷南镇','105',676),(8338,'六合镇','106',676),(8339,'长发镇','107',676),(8340,'通南镇','108',676),(8341,'同义镇','109',676),(8342,'九井镇','110',676),(8343,'老莱镇','111',676),(8344,'孔国乡','201',676),(8345,'和盛乡','207',676),(8346,'同心乡','208',676),(8347,'兴旺鄂温克族乡','210',676),(8348,'龙河镇保安林场','400',676),(8349,'龙河镇茂山林场','401',676),(8350,'龙河镇国庆林场','402',676),(8351,'学田镇富源林场','403',676),(8352,'老莱镇宽余林场','404',676),(8353,'新江林场','405',676),(8354,'讷河镇一良苗圃','406',676),(8355,'黑龙江省老莱监狱','580',676),(8356,'六合镇黎明奶牛场','581',676),(8357,'孔国乡进化种猪场','582',676),(8358,'二克浅镇二里种畜场','583',676),(8359,'龙河镇青色草原种畜场','584',676),(8360,'第一良种场','585',676),(8361,'第二良种场','586',676),(8362,'第三良种场','587',676),(8363,'第四良种场','588',676),(8364,'向阳街道办事处','001',678),(8365,'南山街道办事处','002',678),(8366,'立新街道办事处','003',678),(8367,'东风街道办事处','004',678),(8368,'红军路街道办事处','005',678),(8369,'西鸡西街道办事处','006',678),(8370,'西山街道办事处','007',678),(8371,'红星乡','200',678),(8372,'西郊乡','201',678),(8373,'桦木林街道办事处','001',679),(8374,'大恒山街道办事处','002',679),(8375,'小恒山街道办事处','003',679),(8376,'二道河子街道办事处','004',679),(8377,'张新街道办事处','005',679),(8378,'奋斗街道办事处','006',679),(8379,'柳毛街道办事处','007',679),(8380,'红旗乡','200',679),(8381,'柳毛乡','201',679),(8382,'东兴街道办事处','001',680),(8383,'矿里街道办事处','002',680),(8384,'洗煤街道办事处','003',680),(8385,'大通沟街道办事处','004',680),(8386,'滴道河乡','200',680),(8387,'兰岭乡','201',680),(8388,'街里街道办事处','001',681),(8389,'穆棱街道办事处','002',681),(8390,'平岗街道办事处','003',681),(8391,'碱场街道办事处','004',681),(8392,'石磷街道办事处','005',681),(8393,'梨树区直辖地域','198',681),(8394,'城子河街道办事处','001',682),(8395,'正阳街道办事处','002',682),(8396,'东海街道办事处','003',682),(8397,'城西街道办事处','004',682),(8398,'杏花街道办事处','005',682),(8399,'长青乡','200',682),(8400,'永丰乡','201',682),(8401,'麻山街道办事处','001',683),(8402,'麻山区直辖地域','198',683),(8403,'鸡东镇','100',684),(8404,'平阳镇','101',684),(8405,'向阳镇','102',684),(8406,'哈达镇','103',684),(8407,'永安镇','104',684),(8408,'永和镇','105',684),(8409,'东海镇','106',684),(8410,'兴农镇','107',684),(8411,'鸡林乡','200',684),(8412,'明德乡','205',684),(8413,'下亮子乡','206',684),(8414,'林业局','400',684),(8415,'八五一零农场','500',684),(8416,'虎林镇','100',685),(8417,'东方红镇','101',685),(8418,'迎春镇','102',685),(8419,'虎头镇','103',685),(8420,'杨岗镇','104',685),(8421,'东风镇','105',685),(8422,'宝东镇','106',685),(8423,'新乐乡','203',685),(8424,'伟光乡','204',685),(8425,'忠诚乡','205',685),(8426,'珍宝岛乡','206',685),(8427,'阿北乡','207',685),(8428,'东方红林业局','400',685),(8429,'迎春林业局','401',685),(8430,'八五零农场','500',685),(8431,'八五四农场','501',685),(8432,'八五六农场','502',685),(8433,'八五八农场','503',685),(8434,'庆丰农场','504',685),(8435,'云山农场','505',685),(8436,'中心街道办事处','001',686),(8437,'密山镇','100',686),(8438,'连珠山镇','101',686),(8439,'当壁镇','102',686),(8440,'知一镇','103',686),(8441,'黑台镇','104',686),(8442,'兴凯镇','105',686),(8443,'裴德镇','106',686),(8444,'柳毛乡','200',686),(8445,'杨木乡','201',686),(8446,'兴凯湖乡','202',686),(8447,'承紫河乡','203',686),(8448,'白泡子乡','204',686),(8449,'二人班乡','206',686),(8450,'太平乡','208',686),(8451,'和平乡','210',686),(8452,'富源乡','212',686),(8453,'牡丹江分局局直','501',686),(8454,'八五五农场','502',686),(8455,'八五七农场','503',686),(8456,'八五一一农场','504',686),(8457,'兴凯湖农场','505',686),(8458,'北山街道办事处','001',688),(8459,'红军街道办事处','002',688),(8460,'光明街道办事处','003',688),(8461,'胜利街道办事处','004',688),(8462,'南翼街道办事处','005',688),(8463,'育才街道办事处','001',689),(8464,'红旗街道办事处','002',689),(8465,'新南街道办事处','003',689),(8466,'湖滨街道办事处','004',689),(8467,'解放街道办事处','005',689),(8468,'团结街道办事处','006',689),(8469,'铁西街道办事处','001',690),(8470,'铁东街道办事处','002',690),(8471,'六号街道办事处','003',690),(8472,'大陆街道办事处','004',690),(8473,'富力街道办事处','005',690),(8474,'麓林山街道办事处','006',690),(8475,'兴安路街道办事处','001',691),(8476,'兴建路街道办事处','002',691),(8477,'兴长路街道办事处','003',691),(8478,'峻德路街道办事处','004',691),(8479,'河东路街道办事处','005',691),(8480,'工人村街道办事处','001',692),(8481,'新一街道办事处','002',692),(8482,'三街街道办事处','003',692),(8483,'东山街道办事处','004',692),(8484,'新华镇','100',692),(8485,'红旗乡','200',692),(8486,'蔬园乡','201',692),(8487,'东方红乡','202',692),(8488,'鹤岗市林业局','400',692),(8489,'新华农场','500',692),(8490,'岭北街道办事处','001',693),(8491,'岭南街道办事处','002',693),(8492,'沟北街道办事处','003',693),(8493,'沟南街道办事处','004',693),(8494,'凤翔镇','100',694),(8495,'鹤北镇','101',694),(8496,'名山镇','102',694),(8497,'团结镇','103',694),(8498,'肇兴镇','104',694),(8499,'东明朝鲜族乡','200',694),(8500,'太平沟乡','203',694),(8501,'环山乡','204',694),(8502,'鹤北林业局','401',694),(8503,'宝泉岭分局局直','500',694),(8504,'江滨农场','501',694),(8505,'军川农场','502',694),(8506,'名山农场','503',694),(8507,'延军农场','504',694),(8508,'共青农场','505',694),(8509,'宝泉岭农场','506',694),(8510,'绥滨镇','100',695),(8511,'绥东镇','101',695),(8512,'忠仁镇','102',695),(8513,'连生乡','200',695),(8514,'北岗乡','201',695),(8515,'富强乡','202',695),(8516,'北山乡','203',695),(8517,'福兴乡','204',695),(8518,'新富乡','205',695),(8519,'二九０农场','500',695),(8520,'绥滨农场','501',695),(8521,'普阳农场','503',695),(8522,'二马路街道办事处','001',697),(8523,'八马路街道办事处','002',697),(8524,'中心站街道办事处','003',697),(8525,'富安街道办事处','004',697),(8526,'窑地街道办事处','005',697),(8527,'长安街道办事处','006',697),(8528,'铁西街道办事处','007',697),(8529,'安邦乡','200',697),(8530,'中山街道办事处','001',698),(8531,'北山街道办事处','002',698),(8532,'南山街道办事处','003',698),(8533,'东山街道办事处','004',698),(8534,'中心街道办事处','005',698),(8535,'西山街道办事处','006',698),(8536,'长胜乡','200',698),(8537,'岭东区青山旅游公司','400',698),(8538,'岭东区岭东经营所','401',698),(8539,'振兴中路街道办事处','001',699),(8540,'振兴东路街道办事处','002',699),(8541,'集贤街道办事处','004',699),(8542,'东荣街道办事处','005',699),(8543,'太保镇','101',699),(8544,'红旗街道办事处','001',700),(8545,'跃进街道办事处','002',700),(8546,'东保卫街道办事处','003',700),(8547,'七星街道办事处','004',700),(8548,'双阳街道办事处','005',700),(8549,'新安街道办事处','006',700),(8550,'电厂街道办事处','007',700),(8551,'七星镇','101',700),(8552,'双鸭山林业局宝山经营所','401',700),(8553,'双鸭山林业局大叶沟林场','402',700),(8554,'双鸭山农场','500',700),(8555,'福利镇','100',701),(8556,'集贤镇','101',701),(8557,'升昌镇','102',701),(8558,'丰乐镇','103',701),(8559,'太平镇','104',701),(8560,'腰屯乡','201',701),(8561,'兴安乡','202',701),(8562,'永安乡','204',701),(8563,'太平林场','401',701),(8564,'丰乐林场','402',701),(8565,'七星林场','403',701),(8566,'峻山林场','404',701),(8567,'爱林林场','405',701),(8568,'腰屯林场','406',701),(8569,'升平煤矿','407',701),(8570,'二九一农场','500',701),(8571,'良种场','501',701),(8572,'种畜场','502',701),(8573,'果树示范场','503',701),(8574,'黑龙江省笔架山监狱','580',701),(8575,'友谊镇','100',702),(8576,'兴隆镇','101',702),(8577,'龙山镇','102',702),(8578,'凤岗镇','103',702),(8579,'兴盛乡','200',702),(8580,'东建乡','201',702),(8581,'庆丰乡','202',702),(8582,'建设乡','203',702),(8583,'友邻乡','204',702),(8584,'新镇乡','205',702),(8585,'成富朝鲜族满族乡','206',702),(8586,'红兴隆分局局直','501',702),(8587,'友谊农场','502',702),(8588,'宝清镇','100',703),(8589,'七星泡镇','101',703),(8590,'青原镇','102',703),(8591,'夹信子镇','103',703),(8592,'龙头镇','104',703),(8593,'小城子镇','105',703),(8594,'朝阳乡','202',703),(8595,'万金山乡','203',703),(8596,'尖山子乡','204',703),(8597,'七星河乡','209',703),(8598,'双鸭山林业局上游经营所','400',703),(8599,'双鸭山林业局南瓮泉经营所','401',703),(8600,'双鸭山林业局七一林场','402',703),(8601,'双鸭山林业局七星河林场','403',703),(8602,'双鸭山林业局红旗林场','404',703),(8603,'双鸭山林业局三岔河林场','405',703),(8604,'双鸭山林业局青龙林场','406',703),(8605,'双鸭山林业局宝石经营所','407',703),(8606,'双鸭山林业局七星河金矿','408',703),(8607,'五九七农场','500',703),(8608,'八五二农场','501',703),(8609,'八五三农场','502',703),(8610,'饶河镇','100',704),(8611,'小佳河镇','101',704),(8612,'西丰镇','102',704),(8613,'五林洞镇','103',704),(8614,'西林子乡','200',704),(8615,'四排乡','201',704),(8616,'大佳河乡','203',704),(8617,'山里乡','204',704),(8618,'大通河乡','207',704),(8619,'小佳河林场','400',704),(8620,'威山林场','401',704),(8621,'西丰林场','402',704),(8622,'大牙克林场','403',704),(8623,'石场林场','404',704),(8624,'宝马山林场','405',704),(8625,'大岱林场','406',704),(8626,'永幸林场','407',704),(8627,'奇源林场','408',704),(8628,'芦源林场','409',704),(8629,'五林洞林场','410',704),(8630,'饶河农场','500',704),(8631,'红旗岭农场','501',704),(8632,'八五九农场','502',704),(8633,'胜利农场','503',704),(8634,'红卫农场','504',704),(8635,'萨尔图街道办事处','001',706),(8636,'铁人街道办事处','005',706),(8637,'友谊街道办事处','006',706),(8638,'富强街道办事处','007',706),(8639,'拥军街道办事处','008',706),(8640,'会战街道办事处','009',706),(8641,'火炬街道办事处','010',706),(8642,'东风街道办事处','011',706),(8643,'东安街道办事处','012',706),(8644,'龙凤街道办事处','001',707),(8645,'兴化街道办事处','002',707),(8646,'卧里屯街道办事处','007',707),(8647,'东光街道办事处','008',707),(8648,'三永街道办事处','009',707),(8649,'开发区黎明街道办事处','010',707),(8650,'龙凤镇','100',707),(8651,'高新区农场','580',707),(8652,'龙岗街道办事处','001',708),(8653,'银浪街道办事处','002',708),(8654,'奋斗街道办事处','004',708),(8655,'庆新街道办事处','005',708),(8656,'西宾街道办事处','007',708),(8657,'乘风街道办事处','009',708),(8658,'喇嘛甸镇','101',708),(8659,'红骥牧场','580',708),(8660,'星火牧场','581',708),(8661,'银浪牧场','582',708),(8662,'红岗街道办事处','001',709),(8663,'八百垧街道办事处','004',709),(8664,'杏南街道办事处','005',709),(8665,'解放街道办事处','006',709),(8666,'创业街道办事处','007',709),(8667,'杏树岗镇','100',709),(8668,'庆葡街道办事处','001',710),(8669,'高台子镇街道办事处','002',710),(8670,'林源镇街道办事处','004',710),(8671,'立志街道办事处','005',710),(8672,'新华街道办事处','006',710),(8673,'大同镇街道办事处','007',710),(8674,'大同镇','100',710),(8675,'高台子镇','101',710),(8676,'太阳升镇','102',710),(8677,'林源镇','103',710),(8678,'祝三乡','200',710),(8679,'老山头乡','203',710),(8680,'八井子乡','205',710),(8681,'双榆树乡','206',710),(8682,'和平牧场','500',710),(8683,'肇州镇','100',711),(8684,'永乐镇','101',711),(8685,'丰乐镇','102',711),(8686,'朝阳沟镇','103',711),(8687,'兴城镇','104',711),(8688,'二井镇','105',711),(8689,'双发乡','202',711),(8690,'托古乡','203',711),(8691,'朝阳乡','205',711),(8692,'永胜乡','206',711),(8693,'榆树乡','208',711),(8694,'新福乡','211',711),(8695,'乐园良种场','580',711),(8696,'卫星种畜场','581',711),(8697,'肇源镇','100',712),(8698,'三站镇','101',712),(8699,'二站镇','102',712),(8700,'茂兴镇','103',712),(8701,'古龙镇','104',712),(8702,'新站镇','105',712),(8703,'头台镇','106',712),(8704,'福兴乡','200',712),(8705,'薄荷台乡','201',712),(8706,'和平乡','203',712),(8707,'古恰乡','206',712),(8708,'超等乡','207',712),(8709,'民意乡','208',712),(8710,'义顺乡','210',712),(8711,'浩德乡','211',712),(8712,'大兴乡','212',712),(8713,'肇源农场','500',712),(8714,'种畜场','581',712),(8715,'茂兴湖渔场','582',712),(8716,'新立良种繁育场','583',712),(8717,'立陡山良种场','584',712),(8718,'八家河渔场','585',712),(8719,'果树示范场','586',712),(8720,'经济作物示范场','587',712),(8721,'林甸镇','100',713),(8722,'红旗镇','101',713),(8723,'东兴乡','200',713),(8724,'宏伟乡','201',713),(8725,'三合乡','202',713),(8726,'花园乡','203',713),(8727,'四合乡','204',713),(8728,'黎明乡','205',713),(8729,'林甸县长青林场','400',713),(8730,'巨浪牧场','500',713),(8731,'黑龙江省林甸县国营苇场','581',713),(8732,'林甸县新兴马场','582',713),(8733,'泰康镇','100',714),(8734,'胡吉吐莫镇','101',714),(8735,'烟筒屯镇','102',714),(8736,'他拉哈镇','103',714),(8737,'一心乡','200',714),(8738,'克尔台乡','201',714),(8739,'白音诺勒乡','202',714),(8740,'敖林西伯乡','203',714),(8741,'巴彦查干乡','204',714),(8742,'腰新乡','205',714),(8743,'江湾乡','206',714),(8744,'绿色草原牧场','500',714),(8745,'黑龙江省大山种羊场','581',714),(8746,'靠山种畜场','582',714),(8747,'对山奶牛场','583',714),(8748,'红旗种畜场','584',714),(8749,'连环湖渔业有限公司','585',714),(8750,'石人沟渔业有限公司','586',714),(8751,'齐家泡渔业有限公司','587',714),(8752,'四家子林场','588',714),(8753,'新店林场','589',714),(8754,'野生饲养场','590',714),(8755,'第一良种场','591',714),(8756,'一心苗圃','592',714),(8757,'一心果树场','593',714),(8758,'旭日街道办事处','001',716),(8759,'红升街道办事处','004',716),(8760,'前进街道办事处','006',716),(8761,'朝阳街道办事处','007',716),(8762,'东升街道办事处','008',716),(8763,'西水街道办事处','002',717),(8764,'联合街道办事处','004',717),(8765,'东升街道办事处','005',717),(8766,'晨明镇','101',717),(8767,'浩良河镇','102',717),(8768,'迎春乡','200',717),(8769,'三岔河林场','400',717),(8770,'四合营林场','401',717),(8771,'亮子河林场','402',717),(8772,'石头河林场','403',717),(8773,'岩石经营所','405',717),(8774,'奋斗经营所','406',717),(8775,'桦阳经营所','407',717),(8776,'浩良河经营所','408',717),(8777,'太平经营所','409',717),(8778,'南岔经营所','410',717),(8779,'威岭经营所','411',717),(8780,'松青经营所','413',717),(8781,'柳树经营所','414',717),(8782,'友好街道办事处','001',718),(8783,'双子河街道办事处','003',718),(8784,'铁林街道办事处','004',718),(8785,'三合经营所','400',718),(8786,'松园林场','401',718),(8787,'中心经营所','402',718),(8788,'永青经营所','403',718),(8789,'碧云经营所','404',718),(8790,'友谊经营所','405',718),(8791,'青杨经营所','406',718),(8792,'岭峰林场','407',718),(8793,'奋斗林场','408',718),(8794,'东卡林场','409',718),(8795,'鸡爪河林场','410',718),(8796,'绿源林场','411',718),(8797,'广川经营所','412',718),(8798,'朝阳经营所','413',718),(8799,'西林街道办事处','001',719),(8800,'新兴街道办事处','003',719),(8801,'苔青街道办事处','005',719),(8802,'向阳街道办事处','001',720),(8803,'曙光街道办事处','002',720),(8804,'解放经营所','400',720),(8805,'昆仑气林场','401',720),(8806,'开源河林场','402',720),(8807,'么河经营所','403',720),(8808,'冲锋经营所','404',720),(8809,'翠峦河经营所','405',720),(8810,'抚育河经营所','406',720),(8811,'尖山河经营所','407',720),(8812,'新青街道办事处','001',721),(8813,'兴安街道办事处','003',721),(8814,'红林经营所','400',721),(8815,'松林林场','401',721),(8816,'泉林林场','402',721),(8817,'水源林场','404',721),(8818,'笑山林场','405',721),(8819,'汤林林场','406',721),(8820,'桦林经营所','407',721),(8821,'青林林场','408',721),(8822,'结源林场','409',721),(8823,'北沟林场','410',721),(8824,'南沟林场','411',721),(8825,'乌拉嘎经营所','412',721),(8826,'柳树河林场','413',721),(8827,'北影林场','414',721),(8828,'美溪街道办事处','001',722),(8829,'大西林林场','400',722),(8830,'五道库经营所','401',722),(8831,'缓岭经营所','402',722),(8832,'对青山经营所','403',722),(8833,'群峦经营所','404',722),(8834,'兰新经营所','405',722),(8835,'顺利河林场','406',722),(8836,'松岭经营所','407',722),(8837,'青山口林场','408',722),(8838,'金沙河林场','409',722),(8839,'桦皮羌子林场','410',722),(8840,'碧仓库林场','411',722),(8841,'三股流经营所','412',722),(8842,'卧龙河林场','413',722),(8843,'奋斗街道办事处','002',723),(8844,'金山街道办事处','003',723),(8845,'白山林场','401',723),(8846,'丰岭林场','402',723),(8847,'丰林林场','403',723),(8848,'丰沟经营所','404',723),(8849,'丰茂林场','405',723),(8850,'横山经营所','406',723),(8851,'丰丽林场','407',723),(8852,'大昆仑经营所','408',723),(8853,'小昆仑林场','409',723),(8854,'育林经营所','410',723),(8855,'五营街道办事处','001',724),(8856,'五星街道办事处','011',724),(8857,'翠北林场','400',724),(8858,'前丰林场','401',724),(8859,'永丰经营所','402',724),(8860,'平原经营所','403',724),(8861,'丽丰经营所','404',724),(8862,'杨树河经营所','405',724),(8863,'平山经营所','406',724),(8864,'丽林经营所','407',724),(8865,'乌马河街道办事处','001',725),(8866,'伊敏林场','400',725),(8867,'伊东经营所','401',725),(8868,'东方红经营所','402',725),(8869,'翠岭经营所','403',725),(8870,'河北经营所','404',725),(8871,'青山林场','405',725),(8872,'育苗经营所','406',725),(8873,'安全经营所','407',725),(8874,'伊青经营所','408',725),(8875,'前进经营所','409',725),(8876,'西岭林场','410',725),(8877,'伊林经营所','411',725),(8878,'河南街道办事处','001',726),(8879,'河北街道办事处','002',726),(8880,'日新林场','400',726),(8881,'石林林场','401',726),(8882,'东升林场','402',726),(8883,'二龙山林场','403',726),(8884,'高峰林场','404',726),(8885,'二清河林场','405',726),(8886,'守虎山林场','406',726),(8887,'泉石林场','407',726),(8888,'峻岭林场','408',726),(8889,'育林经营所','409',726),(8890,'团结经营所','410',726),(8891,'磨石山经营所','411',726),(8892,'中心苗卜','412',726),(8893,'克林经营所','413',726),(8894,'带岭街道','001',727),(8895,'大青川林场','400',727),(8896,'东方红林场','401',727),(8897,'秀水林场','402',727),(8898,'永翠林场','403',727),(8899,'明月林场','404',727),(8900,'红光林场','405',727),(8901,'碧水林场','406',727),(8902,'北列林场','407',727),(8903,'南列林场','408',727),(8904,'寒月林场','409',727),(8905,'环山林场','410',727),(8906,'乌伊岭街道办事处','001',728),(8907,'上游林场','400',728),(8908,'美峰林场','401',728),(8909,'翠峰林场','402',728),(8910,'建新林场','403',728),(8911,'移山林场','404',728),(8912,'林海林场','405',728),(8913,'桔源林场','406',728),(8914,'东克林林场','407',728),(8915,'福民林场','408',728),(8916,'阿廷河林场','409',728),(8917,'永胜经营所','410',728),(8918,'前卫林场','411',728),(8919,'红星街道办事处','001',729),(8920,'清水河经营所','400',729),(8921,'五星河经营所','401',729),(8922,'汤洪岭林场','402',729),(8923,'汤北林场','403',729),(8924,'霍吉河林场','404',729),(8925,'二杨经营所','405',729),(8926,'三杨林场','406',729),(8927,'汤南林场','407',729),(8928,'共青经营所','408',729),(8929,'库斯特林场','409',729),(8930,'二皮河经营所','410',729),(8931,'红山街道办事处','001',730),(8932,'山峰林场','400',730),(8933,'阳光林场','401',730),(8934,'新风林场','402',730),(8935,'卫国林场','403',730),(8936,'查山经营所','404',730),(8937,'长青经营所','405',730),(8938,'青山农场','406',730),(8939,'溪水经营所','407',730),(8940,'蔚兰经营所','408',730),(8941,'永绪经营所','409',730),(8942,'美林经营所','410',730),(8943,'红山经营所','411',730),(8944,'朝阳镇','100',731),(8945,'乌云镇','101',731),(8946,'乌拉嘎镇','102',731),(8947,'常胜乡','200',731),(8948,'向阳乡','201',731),(8949,'沪嘉乡','202',731),(8950,'红光乡','203',731),(8951,'保兴乡','204',731),(8952,'青山乡','205',731),(8953,'太平林场','400',731),(8954,'红旗林场','401',731),(8955,'清河林场','402',731),(8956,'连江林场','403',731),(8957,'马连林场','404',731),(8958,'嘉荫农场','500',731),(8959,'铁力镇','100',732),(8960,'双丰镇','101',732),(8961,'桃山镇','102',732),(8962,'朗乡镇','104',732),(8963,'年丰乡','200',732),(8964,'工农乡','201',732),(8965,'王杨乡','202',732),(8966,'铁力林业局','400',732),(8967,'双丰林业局','401',732),(8968,'桃山林业局','402',732),(8969,'朗乡林业局','403',732),(8970,'铁力农场','500',732),(8971,'西林街道办事处','001',734),(8972,'保卫街道办事处','002',734),(8973,'桥南街道办事处','003',734),(8974,'西南岗街道办事处','004',734),(8975,'建设街道办事处','005',734),(8976,'长安街道办事处','006',734),(8977,'向阳区直辖地域','198',734),(8978,'站前街道办事处','001',735),(8979,'永安街道办事处','002',735),(8980,'奋斗街道办事处','003',735),(8981,'南岗街道办事处','004',735),(8982,'亮子河街道办事处','005',735),(8983,'田园街道办事处','006',735),(8984,'晓云街道办事处','001',736),(8985,'佳东街道办事处','002',736),(8986,'造纸街道办事处','003',736),(8987,'佳南街道办事处','004',736),(8988,'建国街道办事处','005',736),(8989,'松江乡','200',736),(8990,'建国乡','201',736),(8991,'佳西街道办事处','001',737),(8992,'友谊街道办事处','002',737),(8993,'大来镇','101',737),(8994,'敖其镇','102',737),(8995,'望江镇','103',737),(8996,'长发镇','104',737),(8997,'莲江口镇','105',737),(8998,'长青乡','200',737),(8999,'沿江乡','201',737),(9000,'西格木乡','202',737),(9001,'平安乡','208',737),(9002,'四丰乡','210',737),(9003,'群胜乡','211',737),(9004,'莲江口监狱','580',737),(9005,'驼腰子镇','103',738),(9006,'石头河子镇','104',738),(9007,'桦南镇','106',738),(9008,'土龙山镇','107',738),(9009,'孟家岗镇','108',738),(9010,'闫家镇','109',738),(9011,'金沙乡','205',738),(9012,'梨树乡','213',738),(9013,'明义乡','214',738),(9014,'大八浪乡','215',738),(9015,'桦南林业局','400',738),(9016,'曙光农场','500',738),(9017,'桦南种畜场','580',738),(9018,'横头山镇','101',739),(9019,'苏家店镇','103',739),(9020,'悦来镇','104',739),(9021,'新城镇','105',739),(9022,'东河乡','201',739),(9023,'梨丰乡','202',739),(9024,'创业乡','205',739),(9025,'星火乡','207',739),(9026,'四马架乡','208',739),(9027,'江川农场','500',739),(9028,'宝山农场','501',739),(9029,'香兰镇','101',740),(9030,'鹤立镇','102',740),(9031,'竹帘镇','103',740),(9032,'汤原镇','104',740),(9033,'汤旺乡','201',740),(9034,'胜利乡','203',740),(9035,'吉祥乡','208',740),(9036,'振兴乡','209',740),(9037,'太平川乡','210',740),(9038,'永发乡','211',740),(9039,'鹤立林业局','400',740),(9040,'香兰监狱','401',740),(9041,'汤原农场','500',740),(9042,'梧桐河农场','501',740),(9043,'抚远镇','100',741),(9044,'寒葱沟镇','101',741),(9045,'浓桥镇','102',741),(9046,'抓吉镇','103',741),(9047,'通江乡','200',741),(9048,'浓江乡','201',741),(9049,'海青乡','202',741),(9050,'别拉洪乡','203',741),(9051,'鸭南乡','204',741),(9052,'前哨农场','500',741),(9053,'前锋农场','501',741),(9054,'二道河农场','502',741),(9055,'杏林街道办事处','003',742),(9056,'和兴街道办事处','004',742),(9057,'安康街道办事处','005',742),(9058,'幸福街道办事处','006',742),(9059,'同江镇','100',742),(9060,'乐业镇','101',742),(9061,'三村镇','102',742),(9062,'临江镇','103',742),(9063,'向阳乡','201',742),(9064,'青河乡','203',742),(9065,'街津口乡','204',742),(9066,'八岔乡','205',742),(9067,'金川乡','206',742),(9068,'银川乡','207',742),(9069,'街津口林场','400',742),(9070,'鸭北林场','401',742),(9071,'勤得利农场','500',742),(9072,'青龙山农场','501',742),(9073,'前进农场','502',742),(9074,'洪河农场','503',742),(9075,'鸭绿河农场','504',742),(9076,'浓江农场','505',742),(9077,'良种场','580',742),(9078,'果树场','581',742),(9079,'马场','582',742),(9080,'干校','583',742),(9081,'知青农场','584',742),(9082,'城市街道社区委员会','001',743),(9083,'城关街道社区建设委员会','002',743),(9084,'长安镇','103',743),(9085,'砚山镇','106',743),(9086,'头林镇','107',743),(9087,'兴隆岗镇','108',743),(9088,'宏胜镇','109',743),(9089,'向阳川镇','110',743),(9090,'二龙山镇','111',743),(9091,'上街基镇','112',743),(9092,'锦山镇','113',743),(9093,'大榆树镇','114',743),(9094,'石砬山林场','400',743),(9095,'东风岗林场','401',743),(9096,'太东林场','402',743),(9097,'工农林场','403',743),(9098,'建三江分局局直','500',743),(9099,'七星农场','501',743),(9100,'大兴农场','502',743),(9101,'创业农场','503',743),(9102,'种猪场','580',743),(9103,'种蓄场','581',743),(9104,'兴华街道办事处','001',745),(9105,'新城街道办事处','002',745),(9106,'新立街道办事处','003',745),(9107,'新建街道办事处','004',745),(9108,'北山街道办事处','005',745),(9109,'河南街道办事处','006',745),(9110,'新合街道办事处','007',745),(9111,'缸窑沟街道办事处','008',745),(9112,'新安街道办事处','009',745),(9113,'越秀街道办事处','010',745),(9114,'红旗镇','100',745),(9115,'桃南街道办事处','001',746),(9116,'桃北街道办事处','002',746),(9117,'桃西街道办事处','003',746),(9118,'兴岗街道办事处','004',746),(9119,'桃东街道办事处','005',746),(9120,'桃山街道办事处','006',746),(9121,'万宝河镇','100',746),(9122,'东风街道办事处','001',747),(9123,'向阳街道办事处','002',747),(9124,'富强街道办事处','003',747),(9125,'新富街道办事处','004',747),(9126,'龙湖街道办事处','005',747),(9127,'茄子河镇','100',747),(9128,'宏伟镇','101',747),(9129,'铁山乡','200',747),(9130,'中心河乡','201',747),(9131,'新起街道办事处','001',748),(9132,'新华街道办事处','002',748),(9133,'元明街道办事处','003',748),(9134,'铁西街道办事处','004',748),(9135,'城西街道办事处','005',748),(9136,'勃利镇','100',748),(9137,'小五站镇','101',748),(9138,'大四站镇','102',748),(9139,'双河镇','103',748),(9140,'倭肯镇','104',748),(9141,'青山乡','200',748),(9142,'长兴乡','201',748),(9143,'永恒乡','202',748),(9144,'抢垦乡','203',748),(9145,'杏树朝鲜族乡','204',748),(9146,'吉兴朝鲜族满族乡','205',748),(9147,'北兴农场','500',748),(9148,'种畜场','580',748),(9149,'新安街道办事处','001',750),(9150,'长安街道办事处','002',750),(9151,'七星街道办事处','003',750),(9152,'五星街道办事处','004',750),(9153,'兴隆镇','100',750),(9154,'阳明街道办事处','001',751),(9155,'前进街道办事处','002',751),(9156,'新兴街道办事处','003',751),(9157,'桦林橡胶厂街道办事处','004',751),(9158,'铁岭镇','100',751),(9159,'桦林镇','101',751),(9160,'向阳街道办事处','001',752),(9161,'黄花街道办事处','002',752),(9162,'铁北街道办事处','003',752),(9163,'新华街道办事处','004',752),(9164,'大庆街道办事处','005',752),(9165,'兴平街道办事处','006',752),(9166,'北山街道办事处','007',752),(9167,'北安乡','201',752),(9168,'先锋街道办事处','001',753),(9169,'火炬街道办事处','002',753),(9170,'立新街道办事处','003',753),(9171,'牡丹街道办事处','004',753),(9172,'江滨街道办事处','005',753),(9173,'沿江街道办事处','006',753),(9174,'温春镇','100',753),(9175,'沿江乡','200',753),(9176,'东宁镇','100',754),(9177,'三岔口镇','101',754),(9178,'大肚川镇','102',754),(9179,'老黑山镇','103',754),(9180,'道河镇','104',754),(9181,'绥阳镇','105',754),(9182,'绥阳林业局','400',754),(9183,'林口镇','100',755),(9184,'古城镇','101',755),(9185,'刁翎镇','102',755),(9186,'五林镇','103',755),(9187,'朱家镇','104',755),(9188,'柳树镇','105',755),(9189,'三道通镇','106',755),(9190,'龙爪镇','107',755),(9191,'莲花镇','108',755),(9192,'奎山乡','200',755),(9193,'青山乡','201',755),(9194,'建堂乡','202',755),(9195,'林口林业局','400',755),(9196,'绥芬河镇','100',756),(9197,'阜宁镇','101',756),(9198,'海林镇','100',757),(9199,'长汀镇','101',757),(9200,'横道镇','102',757),(9201,'山市镇','103',757),(9202,'柴河镇','104',757),(9203,'二道镇','105',757),(9204,'新安朝鲜族镇','106',757),(9205,'三道镇','107',757),(9206,'海南朝鲜族乡','201',757),(9207,'牡林工程公司街道办事处','400',757),(9208,'柴河林机厂街道办事处','401',757),(9209,'大海林林业局','402',757),(9210,'海林林业局','403',757),(9211,'柴河林业局','404',757),(9212,'海林农场','500',757),(9213,'山市种奶牛场','580',757),(9214,'城区街道办事处','001',758),(9215,'宁安镇','100',758),(9216,'东京城镇','101',758),(9217,'渤海镇','102',758),(9218,'石岩镇','103',758),(9219,'沙兰镇','104',758),(9220,'海浪镇','105',758),(9221,'兰岗镇','106',758),(9222,'江南朝鲜族满族乡','202',758),(9223,'卧龙朝鲜族乡','206',758),(9224,'马河乡','208',758),(9225,'镜泊乡','210',758),(9226,'三陵乡','211',758),(9227,'东京城林业局','400',758),(9228,'宁安农场','500',758),(9229,'八面通镇','100',759),(9230,'穆棱镇','101',759),(9231,'下城子镇','102',759),(9232,'马桥河镇','103',759),(9233,'兴源镇','104',759),(9234,'磨刀石镇','105',759),(9235,'福录乡','200',759),(9236,'河西乡','201',759),(9237,'共和乡','202',759),(9238,'八面通林业局','400',759),(9239,'穆棱林业局','401',759),(9240,'花园街道办事处','001',761),(9241,'兴安街道办事处','002',761),(9242,'海兰街道办事处','003',761),(9243,'西兴街道办事处','004',761),(9244,'西岗子镇','101',761),(9245,'爱辉镇','102',761),(9246,'罕达汽镇','103',761),(9247,'幸福乡','200',761),(9248,'四嘉子乡','201',761),(9249,'坤河乡','202',761),(9250,'上马厂乡','203',761),(9251,'张地营子乡','204',761),(9252,'西峰山乡','205',761),(9253,'新生乡','206',761),(9254,'二站乡','207',761),(9255,'宋集屯煤矿','400',761),(9256,'西岗子煤矿','401',761),(9257,'东方红煤矿','402',761),(9258,'大平林场','407',761),(9259,'七二七林场','408',761),(9260,'望峰林场','409',761),(9261,'卡伦山林场','410',761),(9262,'胜山林场','411',761),(9263,'二站林场','412',761),(9264,'三站林场','413',761),(9265,'大岭林场','414',761),(9266,'桦皮窑林场','415',761),(9267,'滨南林场','416',761),(9268,'江防林场','417',761),(9269,'西岗子试验林场','421',761),(9270,'种畜场','422',761),(9271,'第二良种场','423',761),(9272,'第一良种场','424',761),(9273,'大新屯储木场','425',761),(9274,'锦河农场','500',761),(9275,'嫩江镇','100',762),(9276,'伊拉哈镇','101',762),(9277,'双山镇','102',762),(9278,'多宝山镇','103',762),(9279,'海江镇','104',762),(9280,'前进镇','105',762),(9281,'长福镇','106',762),(9282,'科洛镇','107',762),(9283,'临江乡','202',762),(9284,'联兴乡','206',762),(9285,'白云乡','207',762),(9286,'塔溪乡','208',762),(9287,'霍龙门乡','210',762),(9288,'多宝山铜矿','400',762),(9289,'九三分局局直','500',762),(9290,'鹤山农场','501',762),(9291,'大西江农场','502',762),(9292,'尖山农场','503',762),(9293,'荣军农场','504',762),(9294,'红五月农场','505',762),(9295,'七星泡农场','506',762),(9296,'嫩江农场','507',762),(9297,'山河农场','508',762),(9298,'嫩北农场','509',762),(9299,'建边农场','510',762),(9300,'种畜场','580',762),(9301,'马铃薯原种繁殖场','581',762),(9302,'奇克街道办事处','001',763),(9303,'边疆镇','100',763),(9304,'逊河镇','101',763),(9305,'干岔子乡','201',763),(9306,'松树沟乡','202',763),(9307,'车陆乡','203',763),(9308,'新鄂乡','204',763),(9309,'新兴乡','205',763),(9310,'克林乡','206',763),(9311,'宝山乡','207',763),(9312,'道干林场','402',763),(9313,'干岔子林场','403',763),(9314,'新立林场','404',763),(9315,'三间房林场','405',763),(9316,'良种场','406',763),(9317,'种畜场','407',763),(9318,'逊克农场','500',763),(9319,'孙吴城区街道办事处','001',764),(9320,'孙吴镇','100',764),(9321,'辰清镇','101',764),(9322,'西兴乡','201',764),(9323,'沿江满族乡','202',764),(9324,'腰屯乡','203',764),(9325,'卧牛河乡','204',764),(9326,'群山乡','205',764),(9327,'奋斗乡','206',764),(9328,'红旗乡','207',764),(9329,'正阳山乡','208',764),(9330,'清溪乡','210',764),(9331,'前进林场','402',764),(9332,'大河口林场','403',764),(9333,'正阳林场','404',764),(9334,'平山林场','405',764),(9335,'沿江林场','406',764),(9336,'辰清林场','407',764),(9337,'红旗林场','408',764),(9338,'向阳林场','409',764),(9339,'良种场','410',764),(9340,'种畜场','411',764),(9341,'红色边疆农场','500',764),(9342,'兆麟街道办事处','001',765),(9343,'和平街道办事处','002',765),(9344,'北岗街道办事处','003',765),(9345,'庆华街道办事处','004',765),(9346,'铁西街道办事处','005',765),(9347,'铁南街道办事处','006',765),(9348,'通北镇','101',765),(9349,'赵光镇','102',765),(9350,'海星镇','103',765),(9351,'石泉镇','104',765),(9352,'二井镇','105',765),(9353,'城郊乡','200',765),(9354,'东胜乡','201',765),(9355,'杨家乡','203',765),(9356,'主星乡','207',765),(9357,'通北林业局','400',765),(9358,'北安分局局直','500',765),(9359,'长水河农场','501',765),(9360,'赵光农场','502',765),(9361,'红星农场','503',765),(9362,'建设农场','504',765),(9363,'青山街道办事处','001',766),(9364,'龙镇','101',766),(9365,'和平镇','102',766),(9366,'五大连池镇','103',766),(9367,'新发乡','201',766),(9368,'兴隆乡','202',766),(9369,'建设乡','203',766),(9370,'太平乡','205',766),(9371,'双泉乡','206',766),(9372,'团结乡','207',766),(9373,'兴安乡','208',766),(9374,'朝阳乡','210',766),(9375,'花园劳教所','400',766),(9376,'永丰监狱','401',766),(9377,'华山监狱','402',766),(9378,'凤凰山监狱','403',766),(9379,'元青山林场','406',766),(9380,'三九六林场','407',766),(9381,'小兴安林场','408',766),(9382,'二龙山林场','409',766),(9383,'朝阳林场','410',766),(9384,'引龙河林场','411',766),(9385,'焦得布林场','412',766),(9386,'沾河林业局','417',766),(9387,'莲花管理委员会','418',766),(9388,'二龙山蚕种场','427',766),(9389,'五大连池原种场','428',766),(9390,'畜牧场','429',766),(9391,'第二良种场','430',766),(9392,'龙门农场','501',766),(9393,'襄河农场','502',766),(9394,'龙镇农场','503',766),(9395,'二龙山农场','504',766),(9396,'引龙河农场','505',766),(9397,'尾山农场','506',766),(9398,'格球山农场','507',766),(9399,'大庆农场','580',766),(9400,'紫来办事处','001',768),(9401,'爱路办事处','002',768),(9402,'大有办事处','003',768),(9403,'吉泰办事处','004',768),(9404,'东兴办事处','005',768),(9405,'北林办事处居','006',768),(9406,'宝山镇','101',768),(9407,'绥胜镇','102',768),(9408,'西长发镇','103',768),(9409,'永安镇','104',768),(9410,'太平川镇','105',768),(9411,'秦家镇','106',768),(9412,'双河镇','107',768),(9413,'三河镇','108',768),(9414,'四方台镇','109',768),(9415,'津河镇','110',768),(9416,'张维镇','111',768),(9417,'东津镇','113',768),(9418,'红旗乡','201',768),(9419,'连岗乡','202',768),(9420,'新华乡','203',768),(9421,'兴福乡','204',768),(9422,'东富乡','205',768),(9423,'三井乡','209',768),(9424,'五营乡','212',768),(9425,'兴和乡','213',768),(9426,'望奎镇','100',769),(9427,'通江镇','101',769),(9428,'卫星镇','102',769),(9429,'海丰镇','103',769),(9430,'莲花镇','104',769),(9431,'惠七满族镇','105',769),(9432,'先锋镇','106',769),(9433,'东郊乡','201',769),(9434,'灵山满族乡','202',769),(9435,'后三乡','203',769),(9436,'火箭乡','206',769),(9437,'灯塔乡','207',769),(9438,'东升乡','209',769),(9439,'恭六乡','210',769),(9440,'厢白满族乡','211',769),(9441,'白四林场','400',769),(9442,'种畜场','580',769),(9443,'第一良种场','581',769),(9444,'第二良种场','582',769),(9445,'兰西镇','101',770),(9446,'榆林镇','102',770),(9447,'临江镇','103',770),(9448,'平山镇','104',770),(9449,'康荣乡','200',770),(9450,'燎原乡','201',770),(9451,'北安乡','202',770),(9452,'长江乡','203',770),(9453,'兰河乡','204',770),(9454,'红星乡','205',770),(9455,'红光乡','206',770),(9456,'长岗乡','207',770),(9457,'远大乡','209',770),(9458,'星火乡','210',770),(9459,'奋斗乡','211',770),(9460,'第一原种场','580',770),(9461,'第二原种场','581',770),(9462,'肉用种羊场','582',770),(9463,'青冈镇','100',771),(9464,'中和镇','101',771),(9465,'祯祥镇','102',771),(9466,'兴华镇','103',771),(9467,'永丰镇','104',771),(9468,'芦河镇','105',771),(9469,'劳动乡','201',771),(9470,'建设乡','202',771),(9471,'新村乡','203',771),(9472,'昌盛乡','206',771),(9473,'柞岗乡','207',771),(9474,'民政乡','208',771),(9475,'德胜乡','209',771),(9476,'迎春乡','211',771),(9477,'连丰乡','212',771),(9478,'青冈县林场','400',771),(9479,'青冈县互利营林站','401',771),(9480,'青冈县果树场','402',771),(9481,'青冈县种马场','580',771),(9482,'青冈县种羊场','581',771),(9483,'青冈县原种场','582',771),(9484,'庆安镇','101',772),(9485,'民乐镇','102',772),(9486,'大罗镇','103',772),(9487,'平安镇','104',772),(9488,'勤劳镇','105',772),(9489,'久胜镇','106',772),(9490,'建民乡','201',772),(9491,'巨宝山乡','202',772),(9492,'新胜乡','204',772),(9493,'丰收乡','206',772),(9494,'发展乡','208',772),(9495,'同乐乡','209',772),(9496,'致富乡','210',772),(9497,'欢胜乡','211',772),(9498,'国有林场管理局','400',772),(9499,'柳河林校','401',772),(9500,'柳河农场','500',772),(9501,'明水镇','100',773),(9502,'兴仁镇','101',773),(9503,'永兴镇','102',773),(9504,'崇德镇','103',773),(9505,'通达镇','104',773),(9506,'双兴乡','201',773),(9507,'永久乡','203',773),(9508,'树人乡','204',773),(9509,'光荣乡','205',773),(9510,'繁荣乡','206',773),(9511,'通泉乡','207',773),(9512,'育林乡','208',773),(9513,'国营林场','400',773),(9514,'县联社马场','580',773),(9515,'明水种畜场','581',773),(9516,'育林畜牧场','582',773),(9517,'国营第一良种','583',773),(9518,'国营第二良种','584',773),(9519,'国营第三良种','585',773),(9520,'绥棱镇','100',774),(9521,'上集镇','101',774),(9522,'四海店镇','102',774),(9523,'双岔河镇','103',774),(9524,'靠山乡','200',774),(9525,'后头乡','201',774),(9526,'长山乡','203',774),(9527,'克音河乡','205',774),(9528,'绥中乡','206',774),(9529,'泥尔河乡','207',774),(9530,'阁山乡','210',774),(9531,'阁山林场','400',774),(9532,'四海店林场','401',774),(9533,'三吉台林场','402',774),(9534,'半截河林场','403',774),(9535,'绥棱林业局','404',774),(9536,'绥棱农场','500',774),(9537,'种马场','580',774),(9538,'良种场','581',774),(9539,'奶山羊场','582',774),(9540,'铁西街道办事处','001',775),(9541,'新兴街道办事处','002',775),(9542,'安虹街道办事处','003',775),(9543,'安达镇','100',775),(9544,'任民镇','101',775),(9545,'万宝山镇','103',775),(9546,'昌德镇','104',775),(9547,'升平镇','105',775),(9548,'羊草镇','106',775),(9549,'老虎岗镇','107',775),(9550,'中本镇','108',775),(9551,'太平庄镇','109',775),(9552,'吉兴岗镇','110',775),(9553,'火石山乡','202',775),(9554,'卧里屯乡','204',775),(9555,'青肯泡乡','205',775),(9556,'先源乡','209',775),(9557,'安达畜牧场','500',775),(9558,'种畜场','580',775),(9559,'原种场','581',775),(9560,'种牛场','582',775),(9561,'红旗泡水库管理所','583',775),(9562,'东湖水库管理站','584',775),(9563,'朝阳区办事处','001',776),(9564,'东升区办事处','002',776),(9565,'西园区办事处','003',776),(9566,'正阳区办事处','004',776),(9567,'肇东镇','100',776),(9568,'昌五镇','101',776),(9569,'宋站镇','102',776),(9570,'五站镇','103',776),(9571,'尚家镇','104',776),(9572,'姜家镇','105',776),(9573,'里木店镇','106',776),(9574,'四站镇','107',776),(9575,'涝洲镇','108',776),(9576,'五里明镇','109',776),(9577,'黎明镇','110',776),(9578,'太平乡','201',776),(9579,'海城乡','203',776),(9580,'向阳乡','204',776),(9581,'洪河乡','205',776),(9582,'跃进乡','206',776),(9583,'西八里乡','211',776),(9584,'德昌乡','212',776),(9585,'宣化乡','213',776),(9586,'安民乡','214',776),(9587,'明久乡','215',776),(9588,'四方山农场','500',776),(9589,'海伦镇','100',777),(9590,'海北镇','101',777),(9591,'伦河镇','102',777),(9592,'共合镇','103',777),(9593,'海兴镇','104',777),(9594,'祥富镇','105',777),(9595,'东风镇','106',777),(9596,'前进乡','202',777),(9597,'向荣乡','203',777),(9598,'长发乡','204',777),(9599,'东林乡','205',777),(9600,'海南乡','208',777),(9601,'共荣乡','209',777),(9602,'乐业乡','210',777),(9603,'福民乡','211',777),(9604,'丰山乡','212',777),(9605,'永富乡','213',777),(9606,'百祥乡','215',777),(9607,'联发乡','216',777),(9608,'永和乡','217',777),(9609,'爱民乡','218',777),(9610,'扎音河乡','220',777),(9611,'双录乡','221',777),(9612,'林场公司','400',777),(9613,'东方红水库地区','401',777),(9614,'海伦农场','500',777),(9615,'红光农场','501',777),(9616,'海伦绥化种畜场','580',777),(9617,'海伦二粮种场','581',777),(9618,'海伦市种畜场','582',777),(9619,'街道东山社区','001',778),(9620,'街道卫东社区','002',778),(9621,'街道红旗社区','003',778),(9622,'街道长虹社区','004',778),(9623,'街道曙光社区','005',778),(9624,'街道光明社区','006',778),(9625,'加北乡','200',778),(9626,'白桦乡','201',778),(9627,'加格达奇林业局','400',778),(9628,'林田农业开发区','401',778),(9629,'小扬气镇','100',779),(9630,'劲松镇','101',779),(9631,'古源镇','102',779),(9632,'松岭林业局','400',779),(9633,'新林镇','100',780),(9634,'翠岗镇','101',780),(9635,'塔源镇','102',780),(9636,'大乌苏镇','103',780),(9637,'塔尔根镇','104',780),(9638,'碧洲镇','105',780),(9639,'宏图镇','106',780),(9640,'新林林业局','400',780),(9641,'呼中镇','100',781),(9642,'碧水镇','101',781),(9643,'呼源镇','102',781),(9644,'宏伟镇','103',781),(9645,'呼中林业局','400',781),(9646,'呼玛镇','100',782),(9647,'韩家园镇','101',782),(9648,'三卡乡','200',782),(9649,'金山乡','201',782),(9650,'兴华乡','202',782),(9651,'鸥浦乡','203',782),(9652,'白银纳鄂伦春族民族乡','204',782),(9653,'北疆乡','205',782),(9654,'韩家园林业局','400',782),(9655,'塔河镇','100',783),(9656,'瓦拉干镇','101',783),(9657,'盘古镇','102',783),(9658,'十八站鄂伦春族民族乡','200',783),(9659,'依西肯乡','201',783),(9660,'开库康乡','202',783),(9661,'十八站林业局','400',783),(9662,'塔河林业局','401',783),(9663,'西林吉镇','100',784),(9664,'图强镇','101',784),(9665,'劲涛镇','102',784),(9666,'兴安镇','103',784),(9667,'北极乡','200',784),(9668,'西林吉林业局','400',784),(9669,'图强林业局','401',784),(9670,'阿木尔林业局','402',784),(9671,'南京东路街道','002',785),(9672,'金陵东路街道','006',785),(9673,'外滩街道','013',785),(9674,'人民广场街道','014',785),(9675,'半淞园路街道','015',785),(9676,'董家渡街道','016',785),(9677,'小东门街道','017',785),(9678,'豫园街道','018',785),(9679,'老西门街道','019',785),(9680,'五里桥街道','001',786),(9681,'打浦桥街道','002',786),(9682,'淮海中路街道','008',786),(9683,'瑞金二路街道','009',786),(9684,'天平路街道','003',787),(9685,'湖南路街道','004',787),(9686,'斜土路街道','007',787),(9687,'枫林路街道','008',787),(9688,'长桥街道','010',787),(9689,'田林街道','011',787),(9690,'虹梅路街道','012',787),(9691,'康健新村街道','013',787),(9692,'徐家汇街道','014',787),(9693,'凌云路街道','015',787),(9694,'龙华街道','016',787),(9695,'漕河泾街道','017',787),(9696,'华泾镇','103',787),(9697,'漕河泾新兴技术开发区','501',787),(9698,'华阳路街道','001',788),(9699,'江苏路街道','002',788),(9700,'新华路街道','004',788),(9701,'周家桥街道','005',788),(9702,'天山路街道','006',788),(9703,'仙霞新村街道','008',788),(9704,'虹桥街道','009',788),(9705,'程家桥街道','010',788),(9706,'北新泾街道','011',788),(9707,'新泾镇','102',788),(9708,'江宁路街道','006',789),(9709,'石门二路街道','011',789),(9710,'南京西路街道','012',789),(9711,'静安寺街道','013',789),(9712,'曹家渡街道','014',789),(9713,'曹杨新村街道','005',790),(9714,'长风新村街道','014',790),(9715,'长寿路街道','015',790),(9716,'甘泉路街道','016',790),(9717,'石泉路街道','017',790),(9718,'宜川路街道','020',790),(9719,'真如镇','101',790),(9720,'长征镇','102',790),(9721,'桃浦镇','103',790),(9722,'天目西路街道','001',791),(9723,'北站街道','006',791),(9724,'宝山路街道','007',791),(9725,'共和新路街道','012',791),(9726,'大宁路街道','013',791),(9727,'彭浦新村街道','014',791),(9728,'临汾路街道','015',791),(9729,'芷江西路街道','016',791),(9730,'彭浦镇','101',791),(9731,'乍浦路街道','002',792),(9732,'新港路街道','008',792),(9733,'欧阳路街道','009',792),(9734,'曲阳路街道','010',792),(9735,'广中路街道','011',792),(9736,'嘉兴路街道','014',792),(9737,'凉城新村街道','016',792),(9738,'四川北路街道','017',792),(9739,'提篮桥街道','018',792),(9740,'江湾镇','101',792),(9741,'定海路街道','001',793),(9742,'平凉路街道','006',793),(9743,'江浦路街道','008',793),(9744,'四平路街道','009',793),(9745,'控江路街道','012',793),(9746,'长白新村街道','013',793),(9747,'延吉新村街道','015',793),(9748,'殷行街道','016',793),(9749,'大桥街道','018',793),(9750,'五角场街道','019',793),(9751,'新江湾城街道','020',793),(9752,'五角场镇','101',793),(9753,'江川路街道','001',794),(9754,'龙柏街道','005',794),(9755,'古美街道','006',794),(9756,'莘庄镇','101',794),(9757,'七宝镇','102',794),(9758,'颛桥镇','103',794),(9759,'华漕镇','106',794),(9760,'虹桥镇','107',794),(9761,'梅陇镇','108',794),(9762,'吴泾镇','110',794),(9763,'马桥镇','112',794),(9764,'浦江镇','114',794),(9765,'莘庄工业区','501',794),(9766,'友谊路街道','003',795),(9767,'吴淞街道','007',795),(9768,'张庙街道','008',795),(9769,'罗店镇','101',795),(9770,'大场镇','102',795),(9771,'杨行镇','103',795),(9772,'月浦镇','104',795),(9773,'罗泾镇','106',795),(9774,'顾村镇','109',795),(9775,'高境镇','111',795),(9776,'庙行镇','112',795),(9777,'淞南镇','113',795),(9778,'宝山城市工业园区','501',795),(9779,'新成路街道','001',796),(9780,'真新新村街道','002',796),(9781,'菊园新区','003',796),(9782,'嘉定镇街道','004',796),(9783,'南翔镇','102',796),(9784,'安亭镇','103',796),(9785,'马陆镇','106',796),(9786,'徐行镇','109',796),(9787,'华亭镇','111',796),(9788,'外冈镇','114',796),(9789,'黄渡镇','117',796),(9790,'江桥镇','118',796),(9791,'嘉定工业区','501',796),(9792,'潍坊新村街道','004',797),(9793,'陆家嘴街道','005',797),(9794,'周家渡街道','007',797),(9795,'塘桥街道','008',797),(9796,'上钢新村街道','009',797),(9797,'南码头路街道','010',797),(9798,'沪东新村街道','011',797),(9799,'金杨新村街道','012',797),(9800,'洋泾街道','013',797),(9801,'浦兴路街道','014',797),(9802,'东明路街道','015',797),(9803,'花木街道','016',797),(9804,'川沙新镇','103',797),(9805,'高桥镇','104',797),(9806,'北蔡镇','105',797),(9807,'合庆镇','110',797),(9808,'唐镇','114',797),(9809,'曹路镇','117',797),(9810,'金桥镇','120',797),(9811,'高行镇','121',797),(9812,'高东镇','123',797),(9813,'张江镇','125',797),(9814,'三林镇','130',797),(9815,'外高桥保税区','501',797),(9816,'金桥出口加工区','502',797),(9817,'石化街道','001',798),(9818,'朱泾镇','101',798),(9819,'枫泾镇','102',798),(9820,'张堰镇','103',798),(9821,'亭林镇','104',798),(9822,'吕巷镇','105',798),(9823,'廊下镇','107',798),(9824,'金山卫镇','109',798),(9825,'漕泾镇','112',798),(9826,'山阳镇','113',798),(9827,'岳阳街道','001',799),(9828,'永丰街道','002',799),(9829,'方松街道','003',799),(9830,'中山街道','004',799),(9831,'泗泾镇','102',799),(9832,'佘山镇','103',799),(9833,'车墩镇','104',799),(9834,'新桥镇','105',799),(9835,'洞泾镇','106',799),(9836,'九亭镇','107',799),(9837,'泖港镇','109',799),(9838,'石湖荡镇','116',799),(9839,'新浜镇','117',799),(9840,'叶榭镇','120',799),(9841,'松江工业区','501',799),(9842,'佘山度假区','504',799),(9843,'五厍农业园区','505',799),(9844,'上海松江科技园区','506',799),(9845,'上海松江出口加工区','507',799),(9846,'夏阳街道','001',800),(9847,'盈浦街道','002',800),(9848,'香花桥街道','003',800),(9849,'朱家角镇','102',800),(9850,'练塘镇','103',800),(9851,'金泽镇','104',800),(9852,'赵巷镇','105',800),(9853,'徐泾镇','106',800),(9854,'华新镇','107',800),(9855,'重固镇','109',800),(9856,'白鹤镇','110',800),(9857,'惠南镇','101',801),(9858,'周浦镇','102',801),(9859,'新场镇','103',801),(9860,'大团镇','104',801),(9861,'芦潮港镇','106',801),(9862,'康桥镇','109',801),(9863,'航头镇','110',801),(9864,'六灶镇','111',801),(9865,'祝桥镇','112',801),(9866,'泥城镇','114',801),(9867,'宣桥镇','115',801),(9868,'书院镇','121',801),(9869,'万祥镇','122',801),(9870,'老港镇','124',801),(9871,'芦潮港农场','401',801),(9872,'东海农场','402',801),(9873,'朝阳农场','403',801),(9874,'南桥镇','101',802),(9875,'奉城镇','102',802),(9876,'庄行镇','104',802),(9877,'金汇镇','106',802),(9878,'四团镇','109',802),(9879,'青村镇','111',802),(9880,'柘林镇','118',802),(9881,'海湾镇','123',802),(9882,'上海工业综合开发区','501',802),(9883,'上海化学工业区奉贤分区','502',802),(9884,'上海市奉贤区海湾旅游区','503',802),(9885,'奉贤区现代农业园区','504',802),(9886,'上海海港综合经济开发区','505',802),(9887,'城桥镇','101',803),(9888,'堡镇','102',803),(9889,'新河镇','103',803),(9890,'庙镇','104',803),(9891,'竖新镇','106',803),(9892,'向化镇','107',803),(9893,'三星镇','109',803),(9894,'港沿镇','113',803),(9895,'中兴镇','114',803),(9896,'陈家镇','115',803),(9897,'绿华镇','116',803),(9898,'港西镇','118',803),(9899,'建设镇','119',803),(9900,'新村乡','201',803),(9901,'长兴乡','202',803),(9902,'横沙乡','203',803),(9903,'跃进农场','401',803),(9904,'新海农场','402',803),(9905,'红星农场','403',803),(9906,'长征农场','404',803),(9907,'东风农场','405',803),(9908,'长江农场','406',803),(9909,'前进农场','407',803),(9910,'前哨农场','408',803),(9911,'前卫农场','409',803),(9912,'东平林场','410',803),(9913,'上实现代农业园区','501',803),(9914,'梅园新村街道','002',805),(9915,'新街口街道','003',805),(9916,'玄武门街道','005',805),(9917,'后宰门街道','006',805),(9918,'锁金村街道','007',805),(9919,'红山街道','008',805),(9920,'孝陵卫街道','009',805),(9921,'玄武湖街道','010',805),(9922,'五老村街道','001',806),(9923,'淮海路街道','002',806),(9924,'建康路街道','003',806),(9925,'洪武路街道','004',806),(9926,'大光路街道','005',806),(9927,'瑞金路街道','006',806),(9928,'苜蓿园街道','007',806),(9929,'光华路街道','008',806),(9930,'朝天宫街道','009',806),(9931,'止马营街道','010',806),(9932,'秦虹街道','001',807),(9933,'夫子庙街道','002',807),(9934,'红花街道','003',807),(9935,'双塘街道','004',807),(9936,'中华门街道','005',807),(9937,'滨湖街道','001',808),(9938,'沙洲街道','002',808),(9939,'双闸街道','003',808),(9940,'江心洲街道','004',808),(9941,'南湖街道','005',808),(9942,'兴隆街道','006',808),(9943,'南苑街道','007',808),(9944,'宁海路街道','001',809),(9945,'华侨路街道','002',809),(9946,'湖南路街道','003',809),(9947,'中央门街道','004',809),(9948,'挹江门街道','005',809),(9949,'江东街道','006',809),(9950,'莫愁街道','007',809),(9951,'阅江楼街道','001',810),(9952,'热河南路街道','002',810),(9953,'幕府山街道','003',810),(9954,'建宁路街道','004',810),(9955,'宝塔桥街道','005',810),(9956,'小市街道','006',810),(9957,'泰山街道','001',811),(9958,'顶山街道','002',811),(9959,'沿江街道','003',811),(9960,'江浦街道','004',811),(9961,'高新花苑虚拟街道','050',811),(9962,'桥林镇','101',811),(9963,'永宁镇','102',811),(9964,'汤泉镇','103',811),(9965,'星甸镇','104',811),(9966,'石桥镇','105',811),(9967,'乌江镇','106',811),(9968,'盘城镇','107',811),(9969,'老山林场','400',811),(9970,'汤泉农场','401',811),(9971,'珍珠泉管委会','402',811),(9972,'尧化街道','001',812),(9973,'马群街道','002',812),(9974,'迈皋桥街道','003',812),(9975,'燕子矶街道','004',812),(9976,'栖霞街道','005',812),(9977,'龙潭街道','006',812),(9978,'仙林街道','007',812),(9979,'靖安街道','008',812),(9980,'八卦洲街道','009',812),(9981,'龙潭监狱','400',812),(9982,'栖霞区技术经济开发区','401',812),(9983,'南京龙潭物流园','402',812),(9984,'南京市靖安三江口工业园','403',812),(9985,'南京迈皋桥创业园','404',812),(9986,'南京市马群科技园','405',812),(9987,'南京仙林大学城','406',812),(9988,'南京经济技术开发区','450',812),(9989,'宁南街道','001',813),(9990,'赛虹桥街道','002',813),(9991,'雨花新村街道','003',813),(9992,'西善桥街道','004',813),(9993,'板桥街道','005',813),(9994,'铁心桥街道','006',813),(9995,'梅山街道','007',813),(9996,'雨花经济技术开发区','400',813),(9997,'东山街道','001',814),(9998,'秣陵街道','002',814),(9999,'汤山街道','003',814),(10000,'淳化街道','004',814),(10001,'禄口街道','005',814),(10002,'江宁街道','006',814),(10003,'谷里街道','007',814),(10004,'湖熟镇','100',814),(10005,'横溪镇','101',814),(10006,'江宁科学园','400',814),(10007,'青龙山林场','401',814),(10008,'江宁开发区','450',814),(10009,'卸甲甸街道','001',815),(10010,'西厂门街道','002',815),(10011,'山潘街道','003',815),(10012,'葛塘街道','004',815),(10013,'长芦街道','005',815),(10014,'雄州镇','100',815),(10015,'冶山镇','101',815),(10016,'八百桥镇','102',815),(10017,'横梁镇','103',815),(10018,'东沟镇','104',815),(10019,'龙袍镇','105',815),(10020,'玉带镇','106',815),(10021,'瓜埠镇','107',815),(10022,'新集镇','108',815),(10023,'程桥镇','109',815),(10024,'竹镇镇','110',815),(10025,'马集镇','111',815),(10026,'马鞍镇','112',815),(10027,'新篁镇','113',815),(10028,'六合开发区','400',815),(10029,'永阳镇','100',816),(10030,'白马镇','101',816),(10031,'东屏镇','102',816),(10032,'柘塘镇','103',816),(10033,'石湫镇','104',816),(10034,'洪蓝镇','105',816),(10035,'晶桥镇','106',816),(10036,'和凤镇','107',816),(10037,'溧水县开发区','400',816),(10038,'淳溪镇','100',817),(10039,'阳江镇','101',817),(10040,'砖墙镇','102',817),(10041,'古柏镇','103',817),(10042,'漆桥镇','104',817),(10043,'固城镇','105',817),(10044,'东坝镇','106',817),(10045,'桠溪镇','108',817),(10046,'高淳县团结圩良种繁育场','400',817),(10047,'高淳县茶叶实验场','401',817),(10048,'高淳监狱','402',817),(10049,'高淳县傅家坛林场','403',817),(10050,'崇安寺街道','001',819),(10051,'通江街道','002',819),(10052,'广瑞路街道','003',819),(10053,'上马墩街道','004',819),(10054,'江海街道','005',819),(10055,'广益街道','006',819),(10056,'迎龙桥街道','001',820),(10057,'南禅寺街道','002',820),(10058,'清名桥街道','003',820),(10059,'金星街道','004',820),(10060,'金匮街道','005',820),(10061,'扬名街道','006',820),(10062,'黄巷街道','001',821),(10063,'山北街道','002',821),(10064,'北大街街道','003',821),(10065,'惠山街道','004',821),(10066,'东亭街道','001',822),(10067,'安镇镇','101',822),(10068,'羊尖镇','102',822),(10069,'鹅湖镇','103',822),(10070,'东北塘镇','104',822),(10071,'锡北镇','105',822),(10072,'东港镇','106',822),(10073,'无锡锡山开发区','400',822),(10074,'堰桥街道','001',823),(10075,'长安街道','002',823),(10076,'前洲镇','101',823),(10077,'玉祁镇','102',823),(10078,'洛社镇','103',823),(10079,'钱桥镇','104',823),(10080,'阳山镇','105',823),(10081,'无锡惠山经济开发区','400',823),(10082,'河埒街道','001',824),(10083,'荣巷街道','002',824),(10084,'蠡园街道','003',824),(10085,'蠡湖街道','004',824),(10086,'滨湖街道','005',824),(10087,'华庄街道','006',824),(10088,'太湖街道','007',824),(10089,'雪浪街道','008',824),(10090,'旺庄街道','050',824),(10091,'硕放街道','051',824),(10092,'南站街道','052',824),(10093,'坊前街道','053',824),(10094,'马山镇','103',824),(10095,'胡埭镇','104',824),(10096,'梅村镇','152',824),(10097,'鸿山镇','153',824),(10098,'无锡新加坡工业园','450',824),(10099,'无锡高新技术产业开发区','451',824),(10100,'澄江镇','100',825),(10101,'璜土镇','101',825),(10102,'利港镇','102',825),(10103,'申港镇','103',825),(10104,'夏港镇','104',825),(10105,'月城镇','105',825),(10106,'青阳镇','106',825),(10107,'霞客镇','107',825),(10108,'南闸镇','108',825),(10109,'云亭镇','109',825),(10110,'华士镇','110',825),(10111,'周庄镇','111',825),(10112,'新桥镇','112',825),(10113,'长泾镇','113',825),(10114,'顾山镇','114',825),(10115,'祝塘镇','115',825),(10116,'江阴经济开发区新城东办事处','400',825),(10117,'江阴经济开发区港口办事处','401',825),(10118,'江阴经济开发区石庄办事处','402',825),(10119,'江阴经济开发区靖江园区','403',825),(10120,'宜城街道','001',826),(10121,'屺亭街道','002',826),(10122,'张渚镇','101',826),(10123,'西渚镇','102',826),(10124,'太华镇','103',826),(10125,'徐舍镇','104',826),(10126,'鲸塘镇','105',826),(10127,'芳庄镇','106',826),(10128,'官林镇','107',826),(10129,'杨巷镇','108',826),(10130,'新建镇','109',826),(10131,'和桥镇','110',826),(10132,'高塍镇','111',826),(10133,'万石镇','113',826),(10134,'周铁镇','114',826),(10135,'芳桥镇','115',826),(10136,'新庄镇','116',826),(10137,'丁蜀镇','117',826),(10138,'大浦镇','118',826),(10139,'湖父镇','119',826),(10140,'新街镇','120',826),(10141,'环科园','400',826),(10142,'宜兴经济开发区','401',826),(10143,'芙蓉茶场','402',826),(10144,'宜兴市林场','403',826),(10145,'宜兴市大贤岭林场','404',826),(10146,'无锡市茶叶研究所','405',826),(10147,'黄楼街道','001',828),(10148,'丰财街道','002',828),(10149,'琵琶街道','003',828),(10150,'牌楼街道','004',828),(10151,'铜沛街道','005',828),(10152,'环城街道','006',828),(10153,'金山桥街道','051',828),(10154,'东环街道','052',828),(10155,'大黄山街道','053',828),(10156,'大庙镇','151',828),(10157,'大黄山镇','152',828),(10158,'彭城街道','001',829),(10159,'子房街道','005',829),(10160,'黄山街道','007',829),(10161,'骆驼山街道','008',829),(10162,'大郭庄街道','010',829),(10163,'翠屏山街道','011',829),(10164,'潘塘街道','012',829),(10165,'庞庄街道','001',830),(10166,'利国街道','003',830),(10167,'桃园街道','004',830),(10168,'三河尖街道','005',830),(10169,'义安街道','007',830),(10170,'张集街道','008',830),(10171,'电厂街道','009',830),(10172,'张双楼街道','010',830),(10173,'九里街道','011',830),(10174,'拾屯街道','012',830),(10175,'苏山街道','013',830),(10176,'火花街道','014',830),(10177,'老矿街道','001',831),(10178,'夏桥街道','002',831),(10179,'贾汪镇','101',831),(10180,'青山泉镇','102',831),(10181,'大吴镇','103',831),(10182,'紫庄镇','104',831),(10183,'塔山镇','105',831),(10184,'汴塘镇','106',831),(10185,'江庄镇','107',831),(10186,'工业园区管委会','401',831),(10187,'鹿庄粮棉原种场','402',831),(10188,'王陵街道','001',832),(10189,'永安街道','003',832),(10190,'湖滨街道','004',832),(10191,'段庄街道','005',832),(10192,'翟山街道','006',832),(10193,'奎山街道','007',832),(10194,'和平街道','008',832),(10195,'泰山街道','011',832),(10196,'金山街道','012',832),(10197,'七里沟街道','014',832),(10198,'凤城镇','101',833),(10199,'首羡镇','102',833),(10200,'顺河镇','103',833),(10201,'常店镇','104',833),(10202,'欢口镇','105',833),(10203,'师寨镇','106',833),(10204,'华山镇','107',833),(10205,'梁寨镇','108',833),(10206,'范楼镇','109',833),(10207,'孙楼镇','110',833),(10208,'宋楼镇','111',833),(10209,'大沙河镇','112',833),(10210,'王沟镇','113',833),(10211,'赵庄镇','114',833),(10212,'大沙河林场','401',833),(10213,'龙固镇','101',834),(10214,'杨屯镇','102',834),(10215,'大屯镇','103',834),(10216,'沛城镇','104',834),(10217,'胡寨镇','105',834),(10218,'魏庙镇','106',834),(10219,'五段镇','107',834),(10220,'张庄镇','108',834),(10221,'张寨镇','109',834),(10222,'敬安镇','110',834),(10223,'河口镇','111',834),(10224,'栖山镇','112',834),(10225,'鹿楼镇','113',834),(10226,'朱寨镇','114',834),(10227,'安国镇','115',834),(10228,'中煤集团大屯煤电(集团)公司','403',834),(10229,'经济开发区','451',834),(10230,'铜山镇','101',835),(10231,'何桥镇','102',835),(10232,'黄集镇','103',835),(10233,'马坡镇','104',835),(10234,'郑集镇','105',835),(10235,'柳新镇','106',835),(10236,'刘集镇','107',835),(10237,'大彭镇','108',835),(10238,'汉王镇','109',835),(10239,'三堡镇','110',835),(10240,'棠张镇','111',835),(10241,'张集镇','112',835),(10242,'房村镇','113',835),(10243,'伊庄镇','114',835),(10244,'单集镇','115',835),(10245,'徐庄镇','117',835),(10246,'大许镇','118',835),(10247,'茅村镇','119',835),(10248,'柳泉镇','120',835),(10249,'利国镇','121',835),(10250,'国营沿湖农','401',835),(10251,'睢城镇','101',836),(10252,'王集镇','102',836),(10253,'双沟镇','103',836),(10254,'岚山镇','104',836),(10255,'李集镇','105',836),(10256,'桃园镇','106',836),(10257,'官山镇','107',836),(10258,'高作镇','108',836),(10259,'沙集镇','109',836),(10260,'凌城镇','110',836),(10261,'邱集镇','111',836),(10262,'古邳镇','112',836),(10263,'姚集镇','113',836),(10264,'魏集镇','114',836),(10265,'梁集镇','115',836),(10266,'庆安镇','116',836),(10267,'经济开发区','451',836),(10268,'新安镇','101',837),(10269,'瓦窑镇','102',837),(10270,'港头镇','103',837),(10271,'唐店镇','104',837),(10272,'合沟镇','105',837),(10273,'草桥镇','106',837),(10274,'窑湾镇','107',837),(10275,'棋盘镇','108',837),(10276,'新店镇','110',837),(10277,'邵店镇','111',837),(10278,'北沟镇','112',837),(10279,'时集镇','113',837),(10280,'高流镇','114',837),(10281,'阿湖镇','115',837),(10282,'双塘镇','116',837),(10283,'马岭山镇','117',837),(10284,'经济开发区','451',837),(10285,'运河镇','101',838),(10286,'邳城镇','102',838),(10287,'官湖镇','103',838),(10288,'四户镇','104',838),(10289,'宿羊山镇','105',838),(10290,'八义集镇','106',838),(10291,'土山镇','107',838),(10292,'碾庄镇','108',838),(10293,'港上镇','109',838),(10294,'邹庄镇','110',838),(10295,'占城镇','111',838),(10296,'新河镇','112',838),(10297,'八路镇','113',838),(10298,'炮车镇','114',838),(10299,'铁富镇','115',838),(10300,'岔河镇','116',838),(10301,'戴圩镇','117',838),(10302,'陈楼镇','118',838),(10303,'邢楼镇','119',838),(10304,'戴庄镇','120',838),(10305,'车辐山镇','121',838),(10306,'燕子埠镇','122',838),(10307,'赵墩镇','123',838),(10308,'议堂镇','124',838),(10309,'邳城农场','401',838),(10310,'张楼农场','402',838),(10311,'雕庄街道','001',840),(10312,'青龙街道','002',840),(10313,'茶山街道','003',840),(10314,'红梅街道','004',840),(10315,'天宁街道','005',840),(10316,'兰陵街道','006',840),(10317,'五星街道','001',841),(10318,'永红街道','002',841),(10319,'北港街道','003',841),(10320,'西林街道','004',841),(10321,'南大街街道','005',841),(10322,'荷花池街道','006',841),(10323,'新闸镇','100',841),(10324,'戚墅堰街道','001',842),(10325,'丁堰镇','100',842),(10326,'潞城镇','101',842),(10327,'河海街道','001',843),(10328,'三井街道','002',843),(10329,'龙虎塘街道','003',843),(10330,'春江镇','100',843),(10331,'孟河镇','101',843),(10332,'新桥镇','102',843),(10333,'薛家镇','103',843),(10334,'罗溪镇','104',843),(10335,'西夏墅镇','105',843),(10336,'湖塘镇','100',844),(10337,'牛塘镇','102',844),(10338,'洛阳镇','103',844),(10339,'遥观镇','104',844),(10340,'横林镇','105',844),(10341,'横山桥镇','106',844),(10342,'芙蓉镇','107',844),(10343,'焦溪镇','108',844),(10344,'郑陆镇','109',844),(10345,'雪堰镇','110',844),(10346,'潘家镇','111',844),(10347,'漕桥镇','112',844),(10348,'前黄镇','113',844),(10349,'礼嘉镇','114',844),(10350,'寨桥镇','115',844),(10351,'邹区镇','116',844),(10352,'卜弋镇','117',844),(10353,'夏溪镇','118',844),(10354,'嘉泽镇','119',844),(10355,'湟里镇','120',844),(10356,'东安镇','121',844),(10357,'奔牛镇','122',844),(10358,'武进经济开发区','400',844),(10359,'运村农科良种场','401',844),(10360,'奔牛稻麦原种场','402',844),(10361,'郑陆良种繁育场','403',844),(10362,'夏溪良种繁育场','404',844),(10363,'蚕种场','405',844),(10364,'前黄苗圃','406',844),(10365,'水产养殖场','407',844),(10366,'种兔场','408',844),(10367,'横山苗圃','409',844),(10368,'公路苗圃','410',844),(10369,'高新区','411',844),(10370,'溧城镇','100',845),(10371,'埭头镇','101',845),(10372,'上黄镇','102',845),(10373,'戴埠镇','103',845),(10374,'横涧镇','104',845),(10375,'天目湖镇','106',845),(10376,'别桥镇','107',845),(10377,'绸缪镇','108',845),(10378,'上兴镇','109',845),(10379,'上沛镇','110',845),(10380,'竹箦镇','111',845),(10381,'后周镇','112',845),(10382,'前马镇','113',845),(10383,'南渡镇','114',845),(10384,'新昌镇','115',845),(10385,'社渚镇','116',845),(10386,'周城镇','117',845),(10387,'常州监狱','400',845),(10388,'溧阳监狱','401',845),(10389,'金城镇','100',846),(10390,'白塔镇','101',846),(10391,'河头镇','102',846),(10392,'水北镇','103',846),(10393,'儒林镇','104',846),(10394,'尧塘镇','105',846),(10395,'直溪镇','106',846),(10396,'建昌镇','107',846),(10397,'朱林镇','108',846),(10398,'薛埠镇','109',846),(10399,'茅麓镇','110',846),(10400,'社头镇','111',846),(10401,'指前镇','112',846),(10402,'洮西镇','113',846),(10403,'西岗镇','114',846),(10404,'开发区','400',846),(10405,'双塔街道','001',848),(10406,'南门街道','002',848),(10407,'胥江街道','003',848),(10408,'吴门桥街道','004',848),(10409,'葑门街道','005',848),(10410,'友新街道','006',848),(10411,'观前街道','001',849),(10412,'平江路街道','002',849),(10413,'苏锦街道','003',849),(10414,'娄门街道','004',849),(10415,'城北街道','005',849),(10416,'桃花坞街道','006',849),(10417,'娄葑镇','150',849),(10418,'唯亭镇','152',849),(10419,'胜浦镇','153',849),(10420,'虚拟镇','199',849),(10421,'石路街道','001',850),(10422,'彩香街道','002',850),(10423,'留园街道','003',850),(10424,'虎丘街道','004',850),(10425,'白洋湾街道','005',850),(10426,'横塘街道','001',851),(10427,'狮山街道','002',851),(10428,'枫桥街道','003',851),(10429,'镇湖街道','004',851),(10430,'浒墅关镇','100',851),(10431,'通安镇','101',851),(10432,'东渚镇','102',851),(10433,'高新区浒墅关开发分区','400',851),(10434,'苏州高新区出口加工区','403',851),(10435,'苏州高新技术创业服务中心','405',851),(10436,'苏州高新物流中心','406',851),(10437,'苏州科技城','407',851),(10438,'长桥街道','001',852),(10439,'越溪街道','003',852),(10440,'郭巷街道','004',852),(10441,'横泾街道','005',852),(10442,'香山街道','006',852),(10443,'苏苑街道','007',852),(10444,'龙西街道','008',852),(10445,'城南街道','009',852),(10446,'车坊镇','101',852),(10447,'藏书镇','102',852),(10448,'木渎镇','103',852),(10449,'胥口镇','104',852),(10450,'浦庄镇','105',852),(10451,'渡村镇','106',852),(10452,'东山镇','107',852),(10453,'光福镇','108',852),(10454,'西山镇','109',852),(10455,'江苏省太湖采石公司','400',852),(10456,'吴中区林场','401',852),(10457,'西山农业园区','402',852),(10458,'元和街道','001',853),(10459,'太平街道','002',853),(10460,'黄桥街道','003',853),(10461,'望亭镇','100',853),(10462,'黄埭镇','102',853),(10463,'渭塘镇','105',853),(10464,'北桥镇','106',853),(10465,'阳澄湖镇','109',853),(10466,'开发区','400',853),(10467,'虞山镇','100',854),(10468,'梅李镇','101',854),(10469,'海虞镇','102',854),(10470,'新港镇','103',854),(10471,'古里镇','104',854),(10472,'沙家浜镇','105',854),(10473,'支塘镇','106',854),(10474,'董浜镇','107',854),(10475,'辛庄镇','110',854),(10476,'尚湖镇','111',854),(10477,'虞山林场','400',854),(10478,'常熟经济开发区','401',854),(10479,'常熟东南开发区','402',854),(10480,'杨舍镇','100',855),(10481,'塘桥镇','101',855),(10482,'金港镇','102',855),(10483,'锦丰镇','103',855),(10484,'乐余镇','104',855),(10485,'凤凰镇','105',855),(10486,'南丰镇','106',855),(10487,'大新镇','107',855),(10488,'常阴沙管理区','400',855),(10489,'江苏省张家港经济技术开发区','401',855),(10490,'张家港市沿江开发办','402',855),(10491,'张家港保税区','403',855),(10492,'张家港市稻麦良种场','404',855),(10493,'张家港市畜禽良种场','405',855),(10494,'玉山镇','100',856),(10495,'巴城镇','101',856),(10496,'周市镇','102',856),(10497,'陆家镇','103',856),(10498,'花桥镇','104',856),(10499,'淀山湖镇','105',856),(10500,'张浦镇','106',856),(10501,'周庄镇','107',856),(10502,'千灯镇','108',856),(10503,'锦溪镇','109',856),(10504,'开发区','400',856),(10505,'松陵镇','100',857),(10506,'同里镇','101',857),(10507,'平望镇','104',857),(10508,'盛泽镇','105',857),(10509,'横扇镇','106',857),(10510,'七都镇','107',857),(10511,'震泽镇','108',857),(10512,'桃源镇','109',857),(10513,'汾湖镇','110',857),(10514,'经济开发区','400',857),(10515,'东方丝绸市场','401',857),(10516,'城厢镇','100',858),(10517,'沙溪镇','101',858),(10518,'浏河镇','102',858),(10519,'浮桥镇','103',858),(10520,'璜泾镇','104',858),(10521,'双凤镇','105',858),(10522,'陆渡镇','106',858),(10523,'经济开发区','400',858),(10524,'港区','401',858),(10525,'城东街道','001',860),(10526,'和平桥街道','002',860),(10527,'任港街道','003',860),(10528,'新城桥街道','004',860),(10529,'虹桥街道','005',860),(10530,'学田街道','006',860),(10531,'钟秀街道','007',860),(10532,'文峰街道','008',860),(10533,'中兴街道','050',860),(10534,'观音山镇','100',860),(10535,'狼山镇','101',860),(10536,'新开镇','150',860),(10537,'竹行镇','151',860),(10538,'小海镇','152',860),(10539,'江苏省国营南通农场','450',860),(10540,'南通市富民港良种场','451',860),(10541,'南通市富民港种畜场','452',860),(10542,'永兴街道','001',861),(10543,'唐闸镇街道','002',861),(10544,'天生港镇街道','003',861),(10545,'秦灶街道','004',861),(10546,'陈桥乡','202',861),(10547,'幸福乡','203',861),(10548,'港闸开发区','400',861),(10549,'海安镇','100',862),(10550,'城东镇','101',862),(10551,'曲塘镇','102',862),(10552,'李堡镇','103',862),(10553,'老坝港镇','104',862),(10554,'角斜镇','105',862),(10555,'西场镇','106',862),(10556,'大公镇','107',862),(10557,'孙庄镇','108',862),(10558,'雅周镇','109',862),(10559,'胡集镇','110',862),(10560,'白甸镇','111',862),(10561,'南莫镇','112',862),(10562,'墩头镇','113',862),(10563,'海安县农场','400',862),(10564,'洋口镇','101',863),(10565,'苴镇','102',863),(10566,'长沙镇','103',863),(10567,'大豫镇','104',863),(10568,'掘港镇','105',863),(10569,'兵房镇','106',863),(10570,'马塘镇','107',863),(10571,'丰利镇','108',863),(10572,'曹埠镇','109',863),(10573,'岔河镇','110',863),(10574,'双甸镇','111',863),(10575,'新店镇','112',863),(10576,'河口镇','113',863),(10577,'袁庄镇','114',863),(10578,'汇龙镇','100',864),(10579,'大兴镇','101',864),(10580,'南阳镇','102',864),(10581,'惠丰镇','103',864),(10582,'民主镇','104',864),(10583,'北新镇','105',864),(10584,'久隆镇','106',864),(10585,'王鲍镇','107',864),(10586,'合作镇','108',864),(10587,'志良镇','109',864),(10588,'吕四港镇','110',864),(10589,'天汾镇','111',864),(10590,'兆民镇','112',864),(10591,'海复镇','113',864),(10592,'少直镇','114',864),(10593,'向阳镇','115',864),(10594,'东元镇','116',864),(10595,'近海镇','117',864),(10596,'寅阳镇','118',864),(10597,'和合镇','119',864),(10598,'惠萍镇','120',864),(10599,'新安镇','121',864),(10600,'东海镇','122',864),(10601,'启隆乡','200',864),(10602,'启东经济开发区','400',864),(10603,'如城镇','100',865),(10604,'柴湾镇','101',865),(10605,'雪岸镇','102',865),(10606,'东陈镇','103',865),(10607,'丁堰镇','104',865),(10608,'白蒲镇','105',865),(10609,'林梓镇','106',865),(10610,'下原镇','107',865),(10611,'九华镇','108',865),(10612,'郭园镇','109',865),(10613,'石庄镇','110',865),(10614,'长江镇','111',865),(10615,'吴窑镇','112',865),(10616,'江安镇','113',865),(10617,'高明镇','114',865),(10618,'常青镇','115',865),(10619,'搬经镇','116',865),(10620,'磨头镇','117',865),(10621,'桃园镇','118',865),(10622,'袁桥镇','119',865),(10623,'如皋市经济开发区','400',865),(10624,'如皋港开发区','401',865),(10625,'南通市粮棉原种场','402',865),(10626,'如皋市蚕种场','403',865),(10627,'如皋市良种场','404',865),(10628,'如皋市棉花原种场','405',865),(10629,'如皋市种猪场','406',865),(10630,'如皋市农科所','407',865),(10631,'如皋市江滨医院','408',865),(10632,'如皋市中心沙水产养殖场','409',865),(10633,'如皋市九华水产养殖场','410',865),(10634,'金沙镇','100',866),(10635,'西亭镇','101',866),(10636,'二甲镇','102',866),(10637,'东社镇','103',866),(10638,'三余镇','104',866),(10639,'北兴桥镇','105',866),(10640,'海晏镇','106',866),(10641,'十总镇','107',866),(10642,'骑岸镇','108',866),(10643,'五甲镇','109',866),(10644,'石港镇','110',866),(10645,'四安镇','111',866),(10646,'刘桥镇','112',866),(10647,'新联镇','113',866),(10648,'平潮镇','114',866),(10649,'平东镇','115',866),(10650,'五接镇','116',866),(10651,'兴仁镇','117',866),(10652,'兴东镇','118',866),(10653,'张芝山镇','119',866),(10654,'川港镇','120',866),(10655,'先锋镇','121',866),(10656,'姜灶镇','122',866),(10657,'通州市开发区','400',866),(10658,'环本农场','401',866),(10659,'通州港区管委会','403',866),(10660,'海门镇','100',867),(10661,'三星镇','101',867),(10662,'天补镇','102',867),(10663,'三和镇','103',867),(10664,'德胜镇','104',867),(10665,'三厂镇','105',867),(10666,'常乐镇','106',867),(10667,'麒麟镇','107',867),(10668,'悦来镇','108',867),(10669,'万年镇','109',867),(10670,'三阳镇','110',867),(10671,'四甲镇','111',867),(10672,'货隆镇','112',867),(10673,'余东镇','113',867),(10674,'正余镇','114',867),(10675,'包场镇','115',867),(10676,'刘浩镇','116',867),(10677,'东灶港镇','117',867),(10678,'临江镇','118',867),(10679,'王浩镇','119',867),(10680,'树勋镇','120',867),(10681,'海永乡','200',867),(10682,'海门市经济技术开发区','400',867),(10683,'海门市永隆沙农场','401',867),(10684,'海门市大东农场','403',867),(10685,'海门市畜禽良种场','404',867),(10686,'海门市种羊场','405',867),(10687,'海门市包场渔场','406',867),(10688,'海门市长江芦荡养殖场','407',867),(10689,'海门市沿江渔场','408',867),(10690,'海门市三厂苗圃','409',867),(10691,'海门市农科所','410',867),(10692,'海门市海门盐场','411',867),(10693,'海门市财政局芦荡管理所','412',867),(10694,'江苏省国营江心沙农场','413',867),(10695,'墟沟街道办事处','001',869),(10696,'连云街道办事处','003',869),(10697,'云山街道办事处','004',869),(10698,'板桥街道办事处','005',869),(10699,'连岛街道办事处','006',869),(10700,'中云街道','050',869),(10701,'猴嘴街道','051',869),(10702,'朝阳镇','150',869),(10703,'宿城乡','201',869),(10704,'高公岛乡','202',869),(10705,'前三岛乡','203',869),(10706,'连云港碱厂','400',869),(10707,'浦东街道','001',870),(10708,'浦西街道','002',870),(10709,'新东街道','003',870),(10710,'新南街道','004',870),(10711,'路南街道','005',870),(10712,'新海街道','006',870),(10713,'南城镇','100',870),(10714,'云台乡','200',870),(10715,'花果山乡','201',870),(10716,'宁海乡','202',870),(10717,'云台农场','400',870),(10718,'南云台林场','401',870),(10719,'花果山风景区','402',870),(10720,'海州街道','001',871),(10721,'幸福路街道','002',871),(10722,'朐阳街道','003',871),(10723,'洪门街道','004',871),(10724,'新坝镇','100',871),(10725,'锦屏镇','101',871),(10726,'青口镇','100',872),(10727,'柘汪镇','101',872),(10728,'石桥镇','102',872),(10729,'金山镇','103',872),(10730,'黑林镇','104',872),(10731,'厉庄镇','105',872),(10732,'海头镇','106',872),(10733,'塔山镇','107',872),(10734,'赣马镇','108',872),(10735,'班庄镇','109',872),(10736,'城头镇','110',872),(10737,'门河镇','111',872),(10738,'城西镇','112',872),(10739,'欢墩镇','113',872),(10740,'宋庄镇','114',872),(10741,'沙河镇','115',872),(10742,'墩尚镇','116',872),(10743,'罗阳镇','117',872),(10744,'沙河子园艺场','400',872),(10745,'青口盐场','401',872),(10746,'江苏省赣榆海洋经济开发区','402',872),(10747,'江苏省赣榆经济开发区','403',872),(10748,'牛山镇','100',873),(10749,'白塔埠镇','101',873),(10750,'浦南镇','102',873),(10751,'黄川镇','103',873),(10752,'石梁河镇','104',873),(10753,'青湖镇','105',873),(10754,'石榴镇','106',873),(10755,'温泉镇','107',873),(10756,'双店镇','108',873),(10757,'桃林镇','109',873),(10758,'洪庄镇','110',873),(10759,'安峰镇','111',873),(10760,'房山镇','112',873),(10761,'平明镇','113',873),(10762,'驼峰乡','200',873),(10763,'南辰乡','201',873),(10764,'横沟乡','202',873),(10765,'李埝乡','203',873),(10766,'山左口乡','204',873),(10767,'石湖乡','205',873),(10768,'曲阳乡','206',873),(10769,'张湾乡','207',873),(10770,'岗埠农场','400',873),(10771,'江苏东海经济开发区','401',873),(10772,'伊山镇','100',874),(10773,'板浦镇','101',874),(10774,'杨集镇','102',874),(10775,'燕尾港镇','103',874),(10776,'同兴镇','104',874),(10777,'四队镇','105',874),(10778,'圩丰镇','106',874),(10779,'龙苴镇','107',874),(10780,'伊芦乡','201',874),(10781,'鲁河乡','202',874),(10782,'图河乡','203',874),(10783,'沂北乡','204',874),(10784,'下车乡','205',874),(10785,'白蚬乡','206',874),(10786,'东王集乡','207',874),(10787,'侍庄乡','208',874),(10788,'小伊乡','209',874),(10789,'穆圩乡','210',874),(10790,'陡沟乡','211',874),(10791,'南岗乡','212',874),(10792,'东辛农场','400',874),(10793,'五图河农场','401',874),(10794,'灌西盐场','402',874),(10795,'新安镇','100',875),(10796,'堆沟港镇','101',875),(10797,'长茂镇','102',875),(10798,'北陈集镇','103',875),(10799,'张店镇','104',875),(10800,'三口镇','105',875),(10801,'孟兴庄镇','106',875),(10802,'汤沟镇','107',875),(10803,'百禄镇','108',875),(10804,'五队乡','200',875),(10805,'田楼乡','201',875),(10806,'李集乡','204',875),(10807,'新集乡','206',875),(10808,'花园乡','207',875),(10809,'北京路街道办事处','001',877),(10810,'长西街道办事处','002',877),(10811,'淮海街道办事处','003',877),(10812,'长东街道办事处','004',877),(10813,'西安路街道办事处','005',877),(10814,'水渡口街道办事处','006',877),(10815,'东湖街道办事处','050',877),(10816,'新港街道办事处','051',877),(10817,'广州路街道办事处','052',877),(10818,'钵池乡','350',877),(10819,'徐杨乡','351',877),(10820,'京沪路办事处','400',877),(10821,'淮城镇','100',878),(10822,'平桥镇','101',878),(10823,'上河镇','102',878),(10824,'马甸镇','103',878),(10825,'朱桥镇','104',878),(10826,'溪河镇','105',878),(10827,'施河镇','106',878),(10828,'车桥镇','107',878),(10829,'泾口镇','108',878),(10830,'流均镇','109',878),(10831,'博里镇','110',878),(10832,'仇桥镇','111',878),(10833,'复兴镇','112',878),(10834,'苏嘴镇','113',878),(10835,'钦工镇','114',878),(10836,'顺河镇','115',878),(10837,'季桥镇','116',878),(10838,'席桥镇','117',878),(10839,'林集镇','118',878),(10840,'南闸镇','119',878),(10841,'范集镇','120',878),(10842,'建淮乡','200',878),(10843,'茭陵乡','201',878),(10844,'宋集乡','202',878),(10845,'城东乡','203',878),(10846,'南马厂乡','204',878),(10847,'三堡乡','205',878),(10848,'白马湖农场','400',878),(10849,'王营镇','100',879),(10850,'赵集镇','101',879),(10851,'吴城镇','102',879),(10852,'南陈集镇','103',879),(10853,'码头镇','104',879),(10854,'王兴镇','105',879),(10855,'棉花庄镇','106',879),(10856,'丁集镇','107',879),(10857,'五里镇','108',879),(10858,'徐溜镇','109',879),(10859,'渔沟镇','110',879),(10860,'吴集镇','111',879),(10861,'西宋集镇','112',879),(10862,'三树镇','113',879),(10863,'韩桥乡','200',879),(10864,'新渡乡','201',879),(10865,'老张集乡','202',879),(10866,'凌桥乡','203',879),(10867,'袁集乡','204',879),(10868,'刘老庄乡','205',879),(10869,'古寨乡','206',879),(10870,'工业园管理委员会','400',879),(10871,'清江街道办事处','001',880),(10872,'浦楼街道办事处','002',880),(10873,'闸口街道办事处','003',880),(10874,'清安街道办事处','004',880),(10875,'和平镇','100',880),(10876,'武墩镇','101',880),(10877,'盐河镇','102',880),(10878,'城南乡','200',880),(10879,'黄码乡','201',880),(10880,'涟城镇','100',881),(10881,'高沟镇','101',881),(10882,'唐集镇','102',881),(10883,'保滩镇','103',881),(10884,'大东镇','104',881),(10885,'五港镇','105',881),(10886,'梁岔镇','106',881),(10887,'石湖镇','107',881),(10888,'朱码镇','108',881),(10889,'岔庙镇','109',881),(10890,'东胡集镇','110',881),(10891,'南集镇','111',881),(10892,'义兴镇','112',881),(10893,'成集镇','113',881),(10894,'红窑镇','114',881),(10895,'陈师镇','115',881),(10896,'前进镇','116',881),(10897,'徐集乡','200',881),(10898,'黄营乡','201',881),(10899,'杨口办事处','400',881),(10900,'方渡办事处','401',881),(10901,'南禄办事处','402',881),(10902,'小李集办事处','403',881),(10903,'河网办事处','404',881),(10904,'时码办事处','405',881),(10905,'北集办事处','406',881),(10906,'灰墩办事处','407',881),(10907,'余圩办事处','408',881),(10908,'浅集办事处','409',881),(10909,'蒋庵办事处','410',881),(10910,'经济开发新区','411',881),(10911,'经济开发区','412',881),(10912,'高良涧镇','100',882),(10913,'蒋坝镇','101',882),(10914,'仁和镇','102',882),(10915,'岔河镇','103',882),(10916,'西顺河镇','104',882),(10917,'老子山镇','105',882),(10918,'三河镇','106',882),(10919,'朱坝镇','107',882),(10920,'黄集镇','108',882),(10921,'万集镇','109',882),(10922,'东双沟镇','110',882),(10923,'共和镇','111',882),(10924,'盱城镇','100',883),(10925,'马坝镇','101',883),(10926,'官滩镇','102',883),(10927,'旧铺镇','103',883),(10928,'桂五镇','104',883),(10929,'管镇镇','105',883),(10930,'河桥镇','106',883),(10931,'鲍集镇','107',883),(10932,'黄花塘镇','108',883),(10933,'明祖陵镇','109',883),(10934,'铁佛镇','110',883),(10935,'淮河镇','111',883),(10936,'仇集镇','112',883),(10937,'观音寺镇','113',883),(10938,'维桥乡','200',883),(10939,'穆店乡','201',883),(10940,'王店乡','202',883),(10941,'古桑乡','203',883),(10942,'兴隆乡','204',883),(10943,'三河农场','400',883),(10944,'淮化集团','401',883),(10945,'黎城镇','100',884),(10946,'金南镇','101',884),(10947,'闵桥镇','102',884),(10948,'塔集镇','103',884),(10949,'银集镇','104',884),(10950,'涂沟镇','105',884),(10951,'前锋镇','106',884),(10952,'吕良镇','107',884),(10953,'陈桥镇','108',884),(10954,'金北镇','109',884),(10955,'戴楼镇','110',884),(10956,'宝应湖农场','400',884),(10957,'复兴圩农场','401',884),(10958,'粮棉原种场','402',884),(10959,'江苏金湖经济开发区','403',884),(10960,'五星街道','001',886),(10961,'文峰街道','002',886),(10962,'先锋街道','003',886),(10963,'毓龙街道','004',886),(10964,'张庄街道','005',886),(10965,'黄海街道','006',886),(10966,'新洋街道','007',886),(10967,'大洋街道','008',886),(10968,'南洋镇','100',886),(10969,'亭湖区青墩镇','101',886),(10970,'新兴镇','102',886),(10971,'永丰镇','103',886),(10972,'便仓镇','104',886),(10973,'伍佑镇','105',886),(10974,'步凤镇','106',886),(10975,'开发区','400',886),(10976,'市开发区','401',886),(10977,'大纵湖镇','100',887),(10978,'北龙港镇','101',887),(10979,'楼王镇','102',887),(10980,'学富镇','103',887),(10981,'义丰镇','104',887),(10982,'尚庄镇','105',887),(10983,'葛武镇','106',887),(10984,'北蒋镇','107',887),(10985,'秦南镇','108',887),(10986,'龙冈镇','109',887),(10987,'潘黄镇','110',887),(10988,'郭猛镇','111',887),(10989,'大冈镇','112',887),(10990,'新区街道','550',887),(10991,'响水镇','100',888),(10992,'陈家港镇','101',888),(10993,'小尖镇','102',888),(10994,'黄圩镇','103',888),(10995,'大有镇','104',888),(10996,'双港镇','105',888),(10997,'南河镇','106',888),(10998,'运河镇','107',888),(10999,'张集乡','200',888),(11000,'六套乡','201',888),(11001,'七套乡','202',888),(11002,'老舍乡','203',888),(11003,'县开发区','400',888),(11004,'省属黄海农场','401',888),(11005,'省属灌东盐场','402',888),(11006,'东坎镇','100',889),(11007,'五汛镇','101',889),(11008,'蔡桥镇','102',889),(11009,'正红镇','103',889),(11010,'通榆镇','104',889),(11011,'界牌镇','105',889),(11012,'八巨镇','106',889),(11013,'八滩镇','107',889),(11014,'滨海港镇','108',889),(11015,'滨淮镇','109',889),(11016,'天场乡','200',889),(11017,'大套乡','201',889),(11018,'陈涛乡','202',889),(11019,'振东乡','203',889),(11020,'樊集乡','204',889),(11021,'滨淮农场','400',889),(11022,'新滩盐场','401',889),(11023,'开发区工业园','402',889),(11024,'阜城镇','100',890),(11025,'沟墩镇','101',890),(11026,'吴滩镇','102',890),(11027,'合利镇','103',890),(11028,'陈良镇','104',890),(11029,'施庄镇','105',890),(11030,'三灶镇','106',890),(11031,'郭墅镇','107',890),(11032,'新沟镇','108',890),(11033,'陈集镇','109',890),(11034,'羊寨镇','110',890),(11035,'芦蒲镇','111',890),(11036,'硕集镇','112',890),(11037,'板湖镇','113',890),(11038,'东沟镇','114',890),(11039,'益林镇','115',890),(11040,'公兴镇','116',890),(11041,'杨集镇','117',890),(11042,'古河镇','118',890),(11043,'罗桥镇','119',890),(11044,'开发区','400',890),(11045,'化工园区','401',890),(11046,'合德镇','100',891),(11047,'临海镇','101',891),(11048,'千秋镇','102',891),(11049,'通洋镇','103',891),(11050,'四明镇','104',891),(11051,'阜余镇','105',891),(11052,'海河镇','106',891),(11053,'陈洋镇','107',891),(11054,'海通镇','108',891),(11055,'兴桥镇','109',891),(11056,'新坍镇','110',891),(11057,'长荡镇','111',891),(11058,'盘湾镇','112',891),(11059,'特庸镇','113',891),(11060,'洋马镇','114',891),(11061,'黄尖镇','115',891),(11062,'盐东镇','116',891),(11063,'黄沙港镇','117',891),(11064,'耦耕镇','118',891),(11065,'开发区','400',891),(11066,'淮海农场','401',891),(11067,'临海农场','402',891),(11068,'新洋农场','403',891),(11069,'射阳盐场','404',891),(11070,'农业经济开发区','405',891),(11071,'近湖镇','100',892),(11072,'建阳镇','101',892),(11073,'蒋营镇','102',892),(11074,'恒济镇','103',892),(11075,'颜单镇','104',892),(11076,'沿河镇','105',892),(11077,'芦沟镇','106',892),(11078,'庆丰镇','107',892),(11079,'上冈镇','108',892),(11080,'冈东镇','109',892),(11081,'草堰口镇','110',892),(11082,'冈西镇','111',892),(11083,'钟庄镇','112',892),(11084,'宝塔镇','113',892),(11085,'高作镇','114',892),(11086,'经济开发区','400',892),(11087,'溱东镇','100',893),(11088,'时堰镇','101',893),(11089,'后港镇','102',893),(11090,'台南镇','103',893),(11091,'广山镇','104',893),(11092,'廉贻镇','105',893),(11093,'五烈镇','106',893),(11094,'梁垛镇','107',893),(11095,'安丰镇','108',893),(11096,'南沈灶镇','109',893),(11097,'富安镇','110',893),(11098,'富东镇','111',893),(11099,'唐洋镇','112',893),(11100,'新街镇','113',893),(11101,'许河镇','114',893),(11102,'三仓镇','115',893),(11103,'新曹镇','116',893),(11104,'曹丿镇','117',893),(11105,'头灶镇','118',893),(11106,'四灶镇','119',893),(11107,'海丰镇','120',893),(11108,'东台镇','122',893),(11109,'国营新曹农场','400',893),(11110,'国营','401',893),(11111,'蚕种场','402',893),(11112,'林场','403',893),(11113,'黄海原种场','404',893),(11114,'渔舍农场','405',893),(11115,'种畜场','406',893),(11116,'金东台农场','407',893),(11117,'原种场','408',893),(11118,'开发区','409',893),(11119,'大中镇','100',894),(11120,'草堰镇','101',894),(11121,'白驹镇','102',894),(11122,'刘庄镇','103',894),(11123,'西团镇','104',894),(11124,'小海镇','105',894),(11125,'大桥镇','106',894),(11126,'草庙镇','107',894),(11127,'万盈镇','108',894),(11128,'南阳镇','109',894),(11129,'裕华镇','110',894),(11130,'新丰镇','111',894),(11131,'三龙镇','112',894),(11132,'方强镇','113',894),(11133,'大中农场','400',894),(11134,'方强农场','401',894),(11135,'东坝头农场','402',894),(11136,'东关街道','001',896),(11137,'汶河街道','002',896),(11138,'文峰街道','003',896),(11139,'曲江街道','004',896),(11140,'湾头镇','100',896),(11141,'汤汪乡','200',896),(11142,'邗上街道','001',897),(11143,'蒋王街道','002',897),(11144,'汊河街道','003',897),(11145,'公道镇','100',897),(11146,'方巷镇','101',897),(11147,'槐泗镇','102',897),(11148,'瓜洲镇','103',897),(11149,'杭集镇','104',897),(11150,'李典镇','105',897),(11151,'沙头镇','106',897),(11152,'头桥镇','107',897),(11153,'甘泉镇','108',897),(11154,'泰安镇','109',897),(11155,'杨庙镇','110',897),(11156,'邗江工业园','450',897),(11157,'双桥街道','001',898),(11158,'梅岭街道','002',898),(11159,'瘦西湖街道','003',898),(11160,'扬子津街道','050',898),(11161,'文汇街道','051',898),(11162,'新盛街道办事处','060',898),(11163,'西湖镇','100',898),(11164,'施桥镇','150',898),(11165,'八里镇','151',898),(11166,'平山乡','200',898),(11167,'双桥乡','201',898),(11168,'城北乡','202',898),(11169,'平山茶场','400',898),(11170,'维扬经济开发区','401',898),(11171,'安宜镇','100',899),(11172,'范水镇','101',899),(11173,'夏集镇','102',899),(11174,'柳堡镇','103',899),(11175,'射阳湖镇','104',899),(11176,'广洋湖镇','105',899),(11177,'鲁垛镇','106',899),(11178,'小官庄镇','107',899),(11179,'望直港镇','108',899),(11180,'曹甸镇','109',899),(11181,'西安丰镇','110',899),(11182,'山阳镇','111',899),(11183,'黄塍镇','112',899),(11184,'泾河镇','113',899),(11185,'开发区管委会','400',899),(11186,'真州镇','100',900),(11187,'青山镇','101',900),(11188,'朴席镇','102',900),(11189,'新集镇','103',900),(11190,'新城镇','104',900),(11191,'马集镇','105',900),(11192,'刘集镇','106',900),(11193,'陈集镇','107',900),(11194,'大仪镇','108',900),(11195,'谢集乡','200',900),(11196,'月塘乡','201',900),(11197,'开发区','400',900),(11198,'原种场','401',900),(11199,'蚕种场','402',900),(11200,'园艺试验场','403',900),(11201,'水产试验场','404',900),(11202,'捺山茶场','405',900),(11203,'蚕桑场','406',900),(11204,'滨江办事处','450',900),(11205,'十二圩办事处','451',900),(11206,'高邮镇','100',901),(11207,'龙虬镇','101',901),(11208,'马棚镇','102',901),(11209,'车逻镇','103',901),(11210,'八桥镇','104',901),(11211,'汉留镇','105',901),(11212,'汤庄镇','106',901),(11213,'卸甲镇','107',901),(11214,'三垛镇','108',901),(11215,'甘垛镇','109',901),(11216,'司徒镇','110',901),(11217,'横泾镇','111',901),(11218,'界首镇','112',901),(11219,'周山镇','113',901),(11220,'周巷镇','114',901),(11221,'临泽镇','115',901),(11222,'送桥镇','116',901),(11223,'郭集镇','117',901),(11224,'天山镇','118',901),(11225,'菱塘回族乡','200',901),(11226,'鸭业园区','401',901),(11227,'经济开发区','406',901),(11228,'仙女镇','100',902),(11229,'小纪镇','101',902),(11230,'武坚镇','103',902),(11231,'樊川镇','106',902),(11232,'真武镇','108',902),(11233,'宜陵镇','109',902),(11234,'丁沟镇','110',902),(11235,'郭村镇','112',902),(11236,'邵伯镇','114',902),(11237,'丁伙镇','116',902),(11238,'大桥镇','118',902),(11239,'吴桥镇','119',902),(11240,'浦头镇','120',902),(11241,'正东路街道','001',904),(11242,'健康路街道','002',904),(11243,'大市口街道','003',904),(11244,'四牌楼街道','004',904),(11245,'丁卯街道','050',904),(11246,'大港街道','051',904),(11247,'象山镇','100',904),(11248,'谏壁镇','101',904),(11249,'姚桥镇','150',904),(11250,'大路镇','151',904),(11251,'丁岗镇','152',904),(11252,'京口科技工业园','400',904),(11253,'江苏省共青团农场','401',904),(11254,'宝塔路街道','001',905),(11255,'和平路街道','002',905),(11256,'金山街道','003',905),(11257,'七里甸街道','004',905),(11258,'蒋乔镇','100',905),(11259,'民营经济管理委员会','400',905),(11260,'润州工业园区','401',905),(11261,'高桥镇','100',906),(11262,'辛丰镇','101',906),(11263,'谷阳镇','102',906),(11264,'上党镇','103',906),(11265,'宝堰镇','104',906),(11266,'高资镇','105',906),(11267,'世业镇','106',906),(11268,'丹徒区长山林场','400',906),(11269,'司徒镇','100',907),(11270,'延陵镇','101',907),(11271,'珥陵镇','102',907),(11272,'导墅镇','103',907),(11273,'皇塘镇','104',907),(11274,'吕城镇','105',907),(11275,'陵口镇','106',907),(11276,'访仙镇','107',907),(11277,'界牌镇','108',907),(11278,'新桥镇','109',907),(11279,'后巷镇','110',907),(11280,'埤城镇','111',907),(11281,'云阳镇','112',907),(11282,'丹阳经济技术开发区','400',907),(11283,'丹阳林场','401',907),(11284,'茶叶实验场','402',907),(11285,'江苏省练湖农场','403',907),(11286,'三茅镇','100',908),(11287,'新坝镇','101',908),(11288,'油坊镇','103',908),(11289,'八桥镇','104',908),(11290,'西来桥镇','105',908),(11291,'经济开发区','400',908),(11292,'扬中市良种繁育场','401',908),(11293,'扬中市种猪场','402',908),(11294,'扬中市渔业社','403',908),(11295,'雷公岛水产养殖场','404',908),(11296,'扬中市西沙芦柳管理所','405',908),(11297,'华阳镇','100',909),(11298,'黄梅镇','101',909),(11299,'下蜀镇','102',909),(11300,'白兔镇','103',909),(11301,'边城镇','104',909),(11302,'茅山镇','105',909),(11303,'后白镇','106',909),(11304,'郭庄镇','107',909),(11305,'天王镇','108',909),(11306,'宝华镇','109',909),(11307,'开发区','400',909),(11308,'句容市东山良种场','401',909),(11309,'句容市棉花原种场','402',909),(11310,'句容市下蜀茶场','403',909),(11311,'句容市林场','404',909),(11312,'句容市赵庄林苗场','405',909),(11313,'句容市九华茶场','406',909),(11314,'句容市东进林场','407',909),(11315,'句容市茅山茶场','408',909),(11316,'句容市张庙茶场','409',909),(11317,'句容市高庙茶场','410',909),(11318,'句容市浮山果园','411',909),(11319,'句容市方山茶场','412',909),(11320,'句容市磨盘山林场','413',909),(11321,'句容市后白良种场','414',909),(11322,'句容市二圣种猪场','415',909),(11323,'句容监狱','416',909),(11324,'江苏省第一少年管教所','417',909),(11325,'江苏省第二少年管教所','418',909),(11326,'句东农场','428',909),(11327,'城东街道','001',911),(11328,'城西街道','002',911),(11329,'城南街道','003',911),(11330,'城中街道','004',911),(11331,'城北街道','005',911),(11332,'泰山街道','006',911),(11333,'京泰路街道','007',911),(11334,'凤凰路街道','008',911),(11335,'农业开发区街道','050',911),(11336,'九龙镇','100',911),(11337,'寺巷镇','150',911),(11338,'林场','402',911),(11339,'水产养殖场','403',911),(11340,'畜牧养殖试验场','404',911),(11341,'迎春果场','405',911),(11342,'海陵工业园区','406',911),(11343,'口岸街道','001',912),(11344,'刁铺街道','002',912),(11345,'许庄街道','003',912),(11346,'永安洲镇','100',912),(11347,'白马镇','101',912),(11348,'野徐镇','102',912),(11349,'滨江工业园','450',912),(11350,'戴窑镇','100',913),(11351,'合陈镇','101',913),(11352,'永丰镇','102',913),(11353,'新垛镇','103',913),(11354,'安丰镇','104',913),(11355,'海南镇','105',913),(11356,'钓鱼镇','106',913),(11357,'大邹镇','107',913),(11358,'沙沟镇','108',913),(11359,'中堡镇','109',913),(11360,'李中镇','110',913),(11361,'西郊镇','111',913),(11362,'临城镇','112',913),(11363,'垛田镇','113',913),(11364,'竹泓镇','114',913),(11365,'沈沦镇','115',913),(11366,'大垛镇','116',913),(11367,'荻垛镇','117',913),(11368,'陶庄镇','118',913),(11369,'昌荣镇','119',913),(11370,'茅山镇','120',913),(11371,'周庄镇','121',913),(11372,'陈堡镇','122',913),(11373,'戴南镇','123',913),(11374,'张郭镇','124',913),(11375,'昭阳镇','125',913),(11376,'大营镇','126',913),(11377,'下圩镇','127',913),(11378,'城东镇','128',913),(11379,'老圩乡','200',913),(11380,'周奋乡','201',913),(11381,'缸顾乡','202',913),(11382,'西鲍乡','203',913),(11383,'林湖乡','204',913),(11384,'开发区','450',913),(11385,'良种场','451',913),(11386,'靖城镇','100',914),(11387,'新桥镇','101',914),(11388,'东兴镇','102',914),(11389,'斜桥镇','103',914),(11390,'西来镇','104',914),(11391,'季市镇','105',914),(11392,'孤山镇','106',914),(11393,'红光镇','107',914),(11394,'生祠镇','108',914),(11395,'马桥镇','109',914),(11396,'城南办事处','401',914),(11397,'新港园区','402',914),(11398,'城北园区','403',914),(11399,'江阴园区','404',914),(11400,'渔业公司','405',914),(11401,'黄桥镇','100',915),(11402,'分界镇','101',915),(11403,'古溪镇','102',915),(11404,'横垛镇','103',915),(11405,'元竹镇','104',915),(11406,'珊瑚镇','105',915),(11407,'广陵镇','106',915),(11408,'南沙镇','107',915),(11409,'曲霞镇','108',915),(11410,'张桥镇','109',915),(11411,'溪桥镇','110',915),(11412,'刘陈镇','111',915),(11413,'河失镇','112',915),(11414,'新街镇','113',915),(11415,'姚王镇','114',915),(11416,'宣堡镇','115',915),(11417,'胡庄镇','116',915),(11418,'马甸镇','117',915),(11419,'泰兴镇','118',915),(11420,'七圩镇','119',915),(11421,'蒋华镇','120',915),(11422,'大生镇','121',915),(11423,'过船镇','122',915),(11424,'根思乡','200',915),(11425,'开发区虚拟镇','400',915),(11426,'泰兴市农科所','401',915),(11427,'姜堰镇','100',916),(11428,'溱潼镇','101',916),(11429,'蒋垛镇','102',916),(11430,'顾高镇','103',916),(11431,'大伦镇','104',916),(11432,'张甸镇','105',916),(11433,'大泗镇','106',916),(11434,'梁徐镇','107',916),(11435,'苏陈镇','108',916),(11436,'桥头镇','109',916),(11437,'淤溪镇','110',916),(11438,'白米镇','111',916),(11439,'娄庄镇','112',916),(11440,'沈高镇','113',916),(11441,'兴泰镇','114',916),(11442,'俞垛镇','115',916),(11443,'华港镇','116',916),(11444,'罡杨镇','117',916),(11445,'开发区','400',916),(11446,'溱湖风景区','401',916),(11447,'林场','403',916),(11448,'种猪场','404',916),(11449,'林业站','405',916),(11450,'渔业社','406',916),(11451,'幸福街道','001',918),(11452,'项里街道','002',918),(11453,'河滨街道','003',918),(11454,'古城街道','004',918),(11455,'双庄镇','100',918),(11456,'耿车镇','101',918),(11457,'埠子镇','102',918),(11458,'龙河镇','103',918),(11459,'洋北镇','104',918),(11460,'仓集镇','105',918),(11461,'洋河镇','106',918),(11462,'中扬镇','107',918),(11463,'郑楼镇','108',918),(11464,'陈集镇','109',918),(11465,'罗圩乡','201',918),(11466,'南蔡乡','202',918),(11467,'屠园乡','203',918),(11468,'三棵树乡','350',918),(11469,'顺河镇','100',919),(11470,'晓店镇','101',919),(11471,'蔡集镇','102',919),(11472,'王官集镇','103',919),(11473,'皂河镇','104',919),(11474,'仰化镇','105',919),(11475,'大兴镇','106',919),(11476,'丁嘴镇','107',919),(11477,'来龙镇','108',919),(11478,'黄墩镇','109',919),(11479,'陆集镇','110',919),(11480,'关庙镇','111',919),(11481,'侍岭镇','112',919),(11482,'新庄镇','113',919),(11483,'井头乡','200',919),(11484,'曹集乡','201',919),(11485,'保安乡','202',919),(11486,'嶂山林场','500',919),(11487,'沭城镇','100',920),(11488,'陇集镇','101',920),(11489,'胡集镇','102',920),(11490,'钱集镇','103',920),(11491,'塘沟镇','104',920),(11492,'马厂镇','105',920),(11493,'沂涛镇','106',920),(11494,'庙头镇','107',920),(11495,'韩山镇','108',920),(11496,'华冲镇','109',920),(11497,'桑墟镇','110',920),(11498,'悦来镇','111',920),(11499,'刘集镇','112',920),(11500,'李恒镇','114',920),(11501,'扎下镇','115',920),(11502,'颜集镇','116',920),(11503,'潼阳镇','117',920),(11504,'龙庙镇','118',920),(11505,'高墟镇','119',920),(11506,'耿圩镇','120',920),(11507,'汤涧镇','122',920),(11508,'新河镇','124',920),(11509,'贤官镇','125',920),(11510,'吴集镇','126',920),(11511,'湖东镇','127',920),(11512,'青伊湖镇','128',920),(11513,'北丁集乡','200',920),(11514,'周集乡','201',920),(11515,'东小店乡','202',920),(11516,'张圩乡','203',920),(11517,'茆圩乡','204',920),(11518,'西圩乡','205',920),(11519,'万匹乡','206',920),(11520,'官墩乡','207',920),(11521,'青伊湖农场','400',920),(11522,'众兴镇','100',921),(11523,'爱园镇','101',921),(11524,'王集镇','102',921),(11525,'裴圩镇','103',921),(11526,'新袁镇','104',921),(11527,'李口镇','105',921),(11528,'临河镇','106',921),(11529,'穿城镇','107',921),(11530,'张家圩镇','108',921),(11531,'高渡镇','109',921),(11532,'卢集镇','110',921),(11533,'庄圩乡','200',921),(11534,'里仁乡','201',921),(11535,'三庄乡','202',921),(11536,'南刘集乡','203',921),(11537,'八集乡','204',921),(11538,'泗阳农场','400',921),(11539,'棉花原种场','401',921),(11540,'青阳镇','100',922),(11541,'双沟镇','101',922),(11542,'上塘镇','102',922),(11543,'魏营镇','103',922),(11544,'临淮镇','104',922),(11545,'半城镇','105',922),(11546,'孙园镇','106',922),(11547,'梅花镇','107',922),(11548,'归仁镇','108',922),(11549,'金锁镇','109',922),(11550,'朱湖镇','110',922),(11551,'界集镇','111',922),(11552,'太平镇','112',922),(11553,'龙集镇','113',922),(11554,'四河乡','200',922),(11555,'峰山乡','201',922),(11556,'天岗湖乡','202',922),(11557,'车门乡','203',922),(11558,'瑶沟乡','204',922),(11559,'石集乡','205',922),(11560,'城头乡','206',922),(11561,'陈圩乡','207',922),(11562,'曹庙乡','208',922),(11563,'五里江农场','400',922),(11564,'洪泽湖农场','401',922),(11565,'清波街道','001',924),(11566,'湖滨街道','003',924),(11567,'小营街道','004',924),(11568,'南星街道','008',924),(11569,'紫阳街道','009',924),(11570,'望江街道','010',924),(11571,'长庆街道','001',925),(11572,'武林街道','002',925),(11573,'天水街道','003',925),(11574,'潮鸣街道','005',925),(11575,'朝晖街道','006',925),(11576,'文晖街道','007',925),(11577,'东新街道','008',925),(11578,'石桥街道','009',925),(11579,'凯旋街道','005',926),(11580,'采荷街道','006',926),(11581,'闸弄口街道','007',926),(11582,'四季青街道','008',926),(11583,'白杨街道','009',926),(11584,'下沙街道','010',926),(11585,'彭埠镇','102',926),(11586,'笕桥镇','103',926),(11587,'丁桥镇','104',926),(11588,'九堡镇','105',926),(11589,'米市巷街道','001',927),(11590,'湖墅街道','002',927),(11591,'小河街道','003',927),(11592,'和睦街道','004',927),(11593,'拱宸桥街道','005',927),(11594,'大关街道','007',927),(11595,'上塘街道','008',927),(11596,'康桥镇','102',927),(11597,'半山镇','103',927),(11598,'祥符镇','104',927),(11599,'北山街道','002',928),(11600,'灵隐街道','003',928),(11601,'西溪街道','004',928),(11602,'翠苑街道','005',928),(11603,'文新街道','006',928),(11604,'古荡街道','007',928),(11605,'西湖街道','008',928),(11606,'留下镇','103',928),(11607,'转塘镇','104',928),(11608,'袁浦镇','105',928),(11609,'龙坞镇','106',928),(11610,'三墩镇','109',928),(11611,'周浦乡','202',928),(11612,'蒋村乡','203',928),(11613,'西兴街道','001',929),(11614,'长河街道','002',929),(11615,'浦沿街道','003',929),(11616,'城厢街道','001',930),(11617,'北干街道','002',930),(11618,'蜀山街道','003',930),(11619,'新塘街道','004',930),(11620,'楼塔镇','100',930),(11621,'河上镇','101',930),(11622,'戴村镇','102',930),(11623,'浦阳镇','103',930),(11624,'进化镇','104',930),(11625,'临浦镇','105',930),(11626,'义桥镇','106',930),(11627,'所前镇','107',930),(11628,'衙前镇','108',930),(11629,'闻堰镇','109',930),(11630,'宁围镇','110',930),(11631,'新街镇','111',930),(11632,'坎山镇','112',930),(11633,'瓜沥镇','113',930),(11634,'党山镇','114',930),(11635,'益农镇','115',930),(11636,'靖江镇','116',930),(11637,'南阳镇','117',930),(11638,'义蓬镇','118',930),(11639,'河庄镇','119',930),(11640,'党湾镇','120',930),(11641,'新湾镇','121',930),(11642,'萧山经济开发区','401',930),(11643,'围垦区','501',930),(11644,'临平街道','001',931),(11645,'南苑街道','002',931),(11646,'东湖街道','003',931),(11647,'星桥街道','004',931),(11648,'乔司镇','100',931),(11649,'运河镇','101',931),(11650,'塘栖镇','102',931),(11651,'崇贤镇','103',931),(11652,'仁和镇','104',931),(11653,'良渚镇','105',931),(11654,'闲林镇','106',931),(11655,'仓前镇','107',931),(11656,'余杭镇','108',931),(11657,'径山镇','109',931),(11658,'瓶窑镇','110',931),(11659,'鸬鸟镇','111',931),(11660,'百丈镇','112',931),(11661,'黄湖镇','113',931),(11662,'中泰乡','200',931),(11663,'桐君街道','001',932),(11664,'旧县街道','002',932),(11665,'富春江镇','101',932),(11666,'横村镇','102',932),(11667,'凤川镇','107',932),(11668,'分水镇','109',932),(11669,'瑶琳镇','110',932),(11670,'百江镇','112',932),(11671,'江南镇','113',932),(11672,'莪山畲族自治乡','201',932),(11673,'钟山乡','202',932),(11674,'新合乡','204',932),(11675,'合村乡','210',932),(11676,'千岛湖镇','100',933),(11677,'文昌镇','101',933),(11678,'石林镇','102',933),(11679,'临岐镇','103',933),(11680,'威坪镇','104',933),(11681,'姜家镇','106',933),(11682,'梓桐镇','107',933),(11683,'汾口镇','108',933),(11684,'中洲镇','109',933),(11685,'大墅镇','110',933),(11686,'枫树岭镇','111',933),(11687,'里商乡','200',933),(11688,'金峰乡','201',933),(11689,'富文乡','202',933),(11690,'左口乡','203',933),(11691,'屏门乡','205',933),(11692,'瑶山乡','206',933),(11693,'王阜乡','208',933),(11694,'宋村乡','210',933),(11695,'鸠坑乡','211',933),(11696,'浪川乡','212',933),(11697,'界首乡','214',933),(11698,'安阳乡','216',933),(11699,'新安江街道','001',934),(11700,'洋溪街道','002',934),(11701,'更楼街道','003',934),(11702,'莲花镇','101',934),(11703,'乾潭镇','102',934),(11704,'梅城镇','104',934),(11705,'杨村桥镇','105',934),(11706,'下涯镇','106',934),(11707,'大洋镇','107',934),(11708,'三都镇','108',934),(11709,'寿昌镇','109',934),(11710,'航头镇','110',934),(11711,'大慈岩镇','111',934),(11712,'大同镇','112',934),(11713,'李家镇','113',934),(11714,'钦堂乡','202',934),(11715,'富春街道','001',935),(11716,'春江街道','002',935),(11717,'东洲街道','003',935),(11718,'鹿山街道','004',935),(11719,'万市镇','100',935),(11720,'洞桥镇','101',935),(11721,'新登镇','102',935),(11722,'渌渚镇','103',935),(11723,'胥口镇','104',935),(11724,'永昌镇','105',935),(11725,'大源镇','106',935),(11726,'灵桥镇','107',935),(11727,'里山镇','108',935),(11728,'常绿镇','109',935),(11729,'场口镇','110',935),(11730,'常安镇','111',935),(11731,'龙门镇','112',935),(11732,'高桥镇','113',935),(11733,'受降镇','114',935),(11734,'新桐乡','200',935),(11735,'上官乡','201',935),(11736,'渔山乡','202',935),(11737,'环山乡','204',935),(11738,'湖源乡','205',935),(11739,'春建乡','206',935),(11740,'锦城街道','001',936),(11741,'玲珑街道','002',936),(11742,'青山湖街道','003',936),(11743,'上甘街道','004',936),(11744,'三口镇','100',936),(11745,'横畈镇','101',936),(11746,'高虹镇','102',936),(11747,'太湖源镇','103',936),(11748,'於潜镇','104',936),(11749,'藻溪镇','105',936),(11750,'太阳镇','106',936),(11751,'潜川镇','107',936),(11752,'昌化镇','108',936),(11753,'河桥镇','109',936),(11754,'龙岗镇','110',936),(11755,'湍口镇','111',936),(11756,'清凉峰镇','112',936),(11757,'岛石镇','113',936),(11758,'大峡谷镇','114',936),(11759,'板桥乡','200',936),(11760,'西天目乡','201',936),(11761,'千洪乡','202',936),(11762,'横路乡','203',936),(11763,'乐平乡','204',936),(11764,'马啸乡','205',936),(11765,'新桥乡','206',936),(11766,'南门街道','001',938),(11767,'江厦街道','002',938),(11768,'西门街道','003',938),(11769,'月湖街道','004',938),(11770,'鼓楼街道','005',938),(11771,'白云街道','006',938),(11772,'段塘街道','007',938),(11773,'望春街道','008',938),(11774,'百丈街道','001',939),(11775,'东胜街道','002',939),(11776,'明楼街道','003',939),(11777,'白鹤街道','004',939),(11778,'东柳街道','005',939),(11779,'东郊街道','006',939),(11780,'福明街道','007',939),(11781,'中马街道','001',940),(11782,'白沙街道','002',940),(11783,'孔浦街道','003',940),(11784,'文教街道','004',940),(11785,'甬江街道','005',940),(11786,'庄桥街道','006',940),(11787,'洪塘街道','007',940),(11788,'慈城镇','103',940),(11789,'大榭街道','001',941),(11790,'新','002',941),(11791,'小港街道','003',941),(11792,'大','004',941),(11793,'霞浦街道','005',941),(11794,'柴桥街道','006',941),(11795,'白峰镇','105',941),(11796,'春晓镇','107',941),(11797,'梅山乡','201',941),(11798,'招宝山街道','001',942),(11799,'蛟川街道','002',942),(11800,'骆驼街道','003',942),(11801,'庄市街道','004',942),(11802,'九龙湖镇','101',942),(11803,'下应街道','001',943),(11804,'钟公庙街道','002',943),(11805,'石','003',943),(11806,'梅墟街道','004',943),(11807,'瞻岐镇','100',943),(11808,'咸祥镇','101',943),(11809,'塘溪镇','102',943),(11810,'东钱湖镇','103',943),(11811,'东吴镇','104',943),(11812,'五乡镇','105',943),(11813,'邱隘镇','106',943),(11814,'云龙镇','108',943),(11815,'横溪镇','109',943),(11816,'姜山镇','110',943),(11817,'高桥镇','113',943),(11818,'横街镇','114',943),(11819,'集仕港镇','115',943),(11820,'古林镇','116',943),(11821,'洞桥镇','118',943),(11822,'鄞江镇','119',943),(11823,'章水镇','120',943),(11824,'龙观乡','200',943),(11825,'丹东街道','001',944),(11826,'丹西街道','002',944),(11827,'爵溪街道','003',944),(11828,'石浦镇','101',944),(11829,'西周镇','102',944),(11830,'鹤浦镇','103',944),(11831,'贤庠镇','104',944),(11832,'墙头镇','105',944),(11833,'泗洲头镇','106',944),(11834,'定塘镇','107',944),(11835,'涂茨镇','108',944),(11836,'大徐镇','109',944),(11837,'新桥镇','110',944),(11838,'东陈乡','200',944),(11839,'晓塘乡','201',944),(11840,'黄避岙乡','202',944),(11841,'茅洋乡','203',944),(11842,'高塘岛乡','204',944),(11843,'跃龙街道','001',945),(11844,'桃源街道','002',945),(11845,'梅林街道','003',945),(11846,'桥头胡街道','004',945),(11847,'长街镇','101',945),(11848,'力洋镇','102',945),(11849,'一市镇','104',945),(11850,'岔路镇','105',945),(11851,'前童镇','106',945),(11852,'桑洲镇','107',945),(11853,'黄坛镇','108',945),(11854,'大佳何镇','109',945),(11855,'强蛟镇','110',945),(11856,'西店镇','111',945),(11857,'深圳镇','112',945),(11858,'胡陈乡','200',945),(11859,'茶院乡','201',945),(11860,'越溪乡','202',945),(11861,'梨洲街道','001',946),(11862,'凤山街道','002',946),(11863,'兰江街道','003',946),(11864,'阳明街道','004',946),(11865,'低塘街道','005',946),(11866,'朗霞街道','006',946),(11867,'临山镇','100',946),(11868,'黄家埠镇','101',946),(11869,'小曹娥镇','102',946),(11870,'泗门镇','103',946),(11871,'马渚镇','106',946),(11872,'牟山镇','108',946),(11873,'丈亭镇','109',946),(11874,'三七市镇','110',946),(11875,'河姆渡镇','111',946),(11876,'大隐镇','112',946),(11877,'陆埠镇','113',946),(11878,'梁弄镇','114',946),(11879,'大岚镇','115',946),(11880,'四明山镇','116',946),(11881,'鹿亭乡','201',946),(11882,'浒山街道','001',947),(11883,'宗汉街道','002',947),(11884,'坎墩街道','003',947),(11885,'龙山镇','101',947),(11886,'三北镇','102',947),(11887,'范市镇','103',947),(11888,'掌起镇','104',947),(11889,'观海卫镇','107',947),(11890,'附海镇','108',947),(11891,'桥头镇','109',947),(11892,'匡堰镇','110',947),(11893,'逍林镇','111',947),(11894,'新浦镇','112',947),(11895,'胜山镇','113',947),(11896,'横河镇','114',947),(11897,'崇寿镇','116',947),(11898,'庵东镇','118',947),(11899,'天元镇','119',947),(11900,'长河镇','120',947),(11901,'周巷镇','121',947),(11902,'锦屏街道','001',948),(11903,'岳林街道','002',948),(11904,'江口街道','003',948),(11905,'西坞街道','004',948),(11906,'萧王庙街道','005',948),(11907,'溪口镇','100',948),(11908,'尚田镇','103',948),(11909,'莼湖镇','104',948),(11910,'裘村镇','106',948),(11911,'大堰镇','107',948),(11912,'松岙镇','108',948),(11913,'洪殿街道','002',950),(11914,'五马街道','006',950),(11915,'蒲鞋市街道','007',950),(11916,'莲池街道','013',950),(11917,'广化街道','014',950),(11918,'水心街道','015',950),(11919,'南浦街道','016',950),(11920,'南门街道','018',950),(11921,'江滨街道','019',950),(11922,'黎明街道','020',950),(11923,'绣山街道','021',950),(11924,'黄龙街道','022',950),(11925,'双屿镇','101',950),(11926,'藤桥镇','102',950),(11927,'临江镇','103',950),(11928,'七都镇','104',950),(11929,'南郊乡','202',950),(11930,'仰义乡','203',950),(11931,'双潮乡','204',950),(11932,'上戍乡','205',950),(11933,'岙底乡','206',950),(11934,'永中街道','001',951),(11935,'蒲州街道','002',951),(11936,'海滨街道','003',951),(11937,'永兴街道','004',951),(11938,'海城街道','005',951),(11939,'状元镇','101',951),(11940,'瑶溪镇','102',951),(11941,'沙城镇','103',951),(11942,'天河镇','104',951),(11943,'灵昆镇','105',951),(11944,'景山街道','001',952),(11945,'梧田街道','002',952),(11946,'南白象街道','003',952),(11947,'茶山街道','004',952),(11948,'娄桥街道','005',952),(11949,'新桥街道','006',952),(11950,'三','007',952),(11951,'瞿溪镇','103',952),(11952,'郭溪镇','105',952),(11953,'潘桥镇','106',952),(11954,'泽雅镇','108',952),(11955,'丽岙镇','109',952),(11956,'仙岩镇','110',952),(11957,'北岙镇','100',953),(11958,'大门镇','101',953),(11959,'东屏镇','102',953),(11960,'元觉乡','200',953),(11961,'霓屿乡','201',953),(11962,'鹿西乡','202',953),(11963,'上塘镇','100',954),(11964,'瓯北镇','101',954),(11965,'桥头镇','102',954),(11966,'乌牛镇','103',954),(11967,'桥下镇','104',954),(11968,'大若岩镇','105',954),(11969,'碧莲镇','106',954),(11970,'巽宅镇','107',954),(11971,'岩头镇','108',954),(11972,'枫林镇','109',954),(11973,'岩坦镇','110',954),(11974,'沙头镇','111',954),(11975,'西溪乡','200',954),(11976,'徐岙乡','201',954),(11977,'昆阳乡','202',954),(11978,'茗岙乡','203',954),(11979,'山坑乡','204',954),(11980,'应坑乡','205',954),(11981,'大岙乡','206',954),(11982,'溪下乡','207',954),(11983,'界坑乡','208',954),(11984,'西岙乡','209',954),(11985,'石染乡','210',954),(11986,'五(氵束鸟）乡','211',954),(11987,'表山乡','212',954),(11988,'东皋乡','213',954),(11989,'鹤盛乡','214',954),(11990,'西源乡','215',954),(11991,'岭头乡','216',954),(11992,'溪口乡','217',954),(11993,'鲤溪乡','218',954),(11994,'张溪乡','219',954),(11995,'黄南乡','220',954),(11996,'潘坑乡','221',954),(11997,'陡门乡','222',954),(11998,'花坦乡','223',954),(11999,'渠口乡','224',954),(12000,'下寮乡','225',954),(12001,'昆阳镇','100',955),(12002,'鳌江镇','101',955),(12003,'水头镇','102',955),(12004,'萧江镇','103',955),(12005,'麻步镇','104',955),(12006,'腾蛟镇','105',955),(12007,'钱仓镇','106',955),(12008,'山门镇','107',955),(12009,'顺溪镇','108',955),(12010,'南雁镇','109',955),(12011,'凤卧镇','110',955),(12012,'鹤溪镇','111',955),(12013,'宋桥镇','112',955),(12014,'宋埠镇','113',955),(12015,'榆','114',955),(12016,'郑楼镇','115',955),(12017,'南麂镇','116',955),(12018,'西湾乡','202',955),(12019,'梅溪乡','204',955),(12020,'梅源乡','205',955),(12021,'桃源乡','206',955),(12022,'凤巢乡','207',955),(12023,'龙尾乡','208',955),(12024,'南湖乡','209',955),(12025,'朝阳乡','210',955),(12026,'闹村乡','211',955),(12027,'晓坑乡','212',955),(12028,'怀溪乡','213',955),(12029,'青街畲族乡','214',955),(12030,'维新乡','215',955),(12031,'吴','216',955),(12032,'灵溪镇','100',956),(12033,'龙港镇','101',956),(12034,'宜山镇','103',956),(12035,'钱库镇','104',956),(12036,'芦浦镇','105',956),(12037,'望里镇','106',956),(12038,'金乡镇','107',956),(12039,'炎亭镇','109',956),(12040,'大渔镇','110',956),(12041,'藻溪镇','112',956),(12042,'桥墩镇','113',956),(12043,'莒溪镇','114',956),(12044,'观美镇','115',956),(12045,'矾山镇','116',956),(12046,'赤溪镇','117',956),(12047,'马站镇','118',956),(12048,'霞关镇','119',956),(12049,'沿浦镇','120',956),(12050,'南宋镇','121',956),(12051,'云岩乡','202',956),(12052,'仙居乡','203',956),(12053,'新安乡','204',956),(12054,'括山乡','205',956),(12055,'石砰乡','206',956),(12056,'凤池乡','207',956),(12057,'浦亭乡','209',956),(12058,'五凤乡','210',956),(12059,'腾','211',956),(12060,'昌禅乡','213',956),(12061,'中墩乡','214',956),(12062,'龙沙乡','215',956),(12063,'凤阳畲族乡','216',956),(12064,'蒲城乡','217',956),(12065,'岱岭畲族乡','218',956),(12066,'渔寮乡','219',956),(12067,'大','100',957),(12068,'百丈','101',957),(12069,'南田镇','102',957),(12070,'西坑畲族镇','103',957),(12071,'黄坦镇','104',957),(12072,'珊溪镇','105',957),(12073,'巨屿镇','106',957),(12074,'玉壶镇','107',957),(12075,'樟台乡','200',957),(12076,'金炉乡','201',957),(12077,'龙川乡','202',957),(12078,'里阳乡','203',957),(12079,'二源乡','204',957),(12080,'黄寮乡','205',957),(12081,'十源乡','206',957),(12082,'石','207',957),(12083,'下','208',957),(12084,'岭后乡','209',957),(12085,'富岙乡','210',957),(12086,'云湖乡','211',957),(12087,'仰山乡','212',957),(12088,'桂山乡','213',957),(12089,'金','215',957),(12090,'双桂乡','216',957),(12091,'周山畲族乡','217',957),(12092,'公阳乡','218',957),(12093,'平和乡','219',957),(12094,'周壤乡','220',957),(12095,'上林乡','221',957),(12096,'东溪乡','222',957),(12097,'金星乡','223',957),(12098,'朱雅乡','224',957),(12099,'罗阳镇','100',958),(12100,'司前畲族镇','101',958),(12101,'百丈镇','102',958),(12102,'筱村镇','103',958),(12103,'泗溪镇','104',958),(12104,'彭溪镇','105',958),(12105,'雅阳镇','106',958),(12106,'仕阳镇','107',958),(12107,'龟湖镇','108',958),(12108,'三魁镇','109',958),(12109,'西','110',958),(12110,'岭北乡','200',958),(12111,'仙稔乡','201',958),(12112,'南院乡','202',958),(12113,'碑排乡','203',958),(12114,'竹里畲族乡','204',958),(12115,'黄桥乡','205',958),(12116,'峰门乡','206',958),(12117,'包','207',958),(12118,'新浦乡','208',958),(12119,'联云乡','209',958),(12120,'翁山乡','210',958),(12121,'凤','211',958),(12122,'横坑乡','212',958),(12123,'九峰乡','213',958),(12124,'峰文乡','214',958),(12125,'月湖乡','215',958),(12126,'松','216',958),(12127,'柳峰乡','217',958),(12128,'雪溪乡','218',958),(12129,'万排乡','219',958),(12130,'东溪乡','220',958),(12131,'大安乡','221',958),(12132,'洲岭乡','223',958),(12133,'下洪乡','224',958),(12134,'安阳街道','001',959),(12135,'玉海街道','002',959),(12136,'锦湖街道','003',959),(12137,'东山街道','004',959),(12138,'上望街道','005',959),(12139,'潘岱街道','006',959),(12140,'塘下镇','101',959),(12141,'莘塍镇','109',959),(12142,'汀田镇','111',959),(12143,'飞云镇','114',959),(12144,'仙降镇','115',959),(12145,'马屿镇','116',959),(12146,'曹村镇','118',959),(12147,'陶山镇','120',959),(12148,'碧山镇','121',959),(12149,'湖岭镇','122',959),(12150,'龙湖镇','123',959),(12151,'平阳坑镇','124',959),(12152,'荆谷乡','201',959),(12153,'梅屿乡','202',959),(12154,'顺泰乡','203',959),(12155,'大南乡','204',959),(12156,'桐浦乡','205',959),(12157,'永安乡','207',959),(12158,'桂峰乡','208',959),(12159,'芳庄乡','209',959),(12160,'林溪乡','210',959),(12161,'金川乡','211',959),(12162,'潮基乡','212',959),(12163,'鹿木乡','213',959),(12164,'高楼乡','214',959),(12165,'营前乡','215',959),(12166,'东岩乡','216',959),(12167,'宁益乡','217',959),(12168,'枫岭乡','218',959),(12169,'北麂乡','219',959),(12170,'北龙乡','220',959),(12171,'飞云江农场','400',959),(12172,'乐成镇','100',960),(12173,'大荆镇','101',960),(12174,'仙溪镇','102',960),(12175,'湖雾镇','103',960),(12176,'雁荡镇','104',960),(12177,'芙蓉镇','105',960),(12178,'清江镇','106',960),(12179,'南塘镇','107',960),(12180,'虹桥镇','108',960),(12181,'南岳镇','109',960),(12182,'蒲岐镇','110',960),(12183,'淡溪镇','111',960),(12184,'石帆镇','112',960),(12185,'白石镇','113',960),(12186,'柳市镇','114',960),(12187,'北白象镇','115',960),(12188,'象阳镇','116',960),(12189,'翁','117',960),(12190,'磐石镇','118',960),(12191,'七里港镇','119',960),(12192,'黄华镇','120',960),(12193,'智仁乡','200',960),(12194,'镇安乡','201',960),(12195,'福溪乡','202',960),(12196,'双峰乡','203',960),(12197,'龙西乡','204',960),(12198,'雁湖乡','205',960),(12199,'岭底乡','206',960),(12200,'四都乡','207',960),(12201,'天成乡','208',960),(12202,'城北乡','209',960),(12203,'建设街道','007',962),(12204,'解放街道','008',962),(12205,'新嘉街道','009',962),(12206,'南湖街道','010',962),(12207,'新兴街道','011',962),(12208,'城南街道','012',962),(12209,'东栅街道','013',962),(12210,'凤桥镇','100',962),(12211,'余新镇','101',962),(12212,'新丰镇','103',962),(12213,'七星镇','104',962),(12214,'大桥镇','105',962),(12215,'新城街道','002',963),(12216,'嘉北街道','003',963),(12217,'塘汇街道','004',963),(12218,'王江泾镇','101',963),(12219,'油车港镇','103',963),(12220,'新塍镇','104',963),(12221,'王店镇','105',963),(12222,'洪合镇','106',963),(12223,'魏塘镇','100',964),(12224,'惠民镇','101',964),(12225,'大云镇','102',964),(12226,'西塘镇','103',964),(12227,'丁栅镇','104',964),(12228,'干窑镇','105',964),(12229,'姚庄镇','106',964),(12230,'陶庄镇','107',964),(12231,'天凝镇','108',964),(12232,'洪溪镇','109',964),(12233,'杨庙镇','110',964),(12234,'武原镇','100',965),(12235,'沈荡镇','101',965),(12236,'百步镇','102',965),(12237,'于城镇','103',965),(12238,'秦山镇','104',965),(12239,'澉浦镇','105',965),(12240,'通元镇','106',965),(12241,'西塘桥镇','107',965),(12242,'硖石街道','001',966),(12243,'海洲街道','002',966),(12244,'海昌街道','003',966),(12245,'马桥街道','004',966),(12246,'许村镇','101',966),(12247,'长安镇','103',966),(12248,'周王庙镇','105',966),(12249,'丁桥镇','106',966),(12250,'斜桥镇','107',966),(12251,'黄湾镇','108',966),(12252,'盐官镇','110',966),(12253,'袁花镇','112',966),(12254,'尖山新区','400',966),(12255,'当湖街道','001',967),(12256,'钟埭街道','002',967),(12257,'曹桥街道','003',967),(12258,'乍浦镇','101',967),(12259,'新埭镇','102',967),(12260,'新仓镇','103',967),(12261,'黄姑镇','104',967),(12262,'全塘镇','105',967),(12263,'广陈镇','106',967),(12264,'林埭镇','107',967),(12265,'梧桐街道','001',968),(12266,'龙翔街道','002',968),(12267,'凤鸣街道','003',968),(12268,'乌镇镇','100',968),(12269,'濮院镇','101',968),(12270,'屠甸镇','102',968),(12271,'石门镇','103',968),(12272,'河山镇','104',968),(12273,'洲泉镇','105',968),(12274,'大麻镇','106',968),(12275,'崇福镇','107',968),(12276,'高桥镇','108',968),(12277,'同福乡','200',968),(12278,'月河街道','001',970),(12279,'朝阳街道','002',970),(12280,'爱山街道','003',970),(12281,'飞英街道','004',970),(12282,'龙泉街道','005',970),(12283,'凤凰街道','006',970),(12284,'织里镇','100',970),(12285,'八里店镇','101',970),(12286,'妙西镇','102',970),(12287,'杨家埠镇','103',970),(12288,'埭溪镇','104',970),(12289,'东林镇','105',970),(12290,'道场乡','200',970),(12291,'环渚乡','201',970),(12292,'白雀乡','202',970),(12293,'南浔镇','100',971),(12294,'双林镇','101',971),(12295,'练市镇','102',971),(12296,'善琏镇','103',971),(12297,'旧馆镇','104',971),(12298,'菱湖镇','105',971),(12299,'和孚镇','106',971),(12300,'千金镇','107',971),(12301,'石淙镇','108',971),(12302,'武康镇','100',972),(12303,'乾元镇','101',972),(12304,'新市镇','102',972),(12305,'洛舍镇','103',972),(12306,'钟管镇','104',972),(12307,'莫干山镇','105',972),(12308,'雷甸镇','110',972),(12309,'禹越镇','113',972),(12310,'新安镇','114',972),(12311,'筏头乡','201',972),(12312,'三合乡','202',972),(12313,'雉城镇','100',973),(12314,'洪桥镇','101',973),(12315,'李家巷镇','102',973),(12316,'夹浦镇','103',973),(12317,'林城镇','104',973),(12318,'泗安镇','105',973),(12319,'虹星桥镇','106',973),(12320,'和平镇','107',973),(12321,'小浦镇','108',973),(12322,'煤山镇','109',973),(12323,'水口乡','200',973),(12324,'二界岭乡','201',973),(12325,'吕山乡','202',973),(12326,'吴山乡','203',973),(12327,'白岘乡','204',973),(12328,'槐坎乡','205',973),(12329,'递铺镇','100',974),(12330,'梅溪镇','101',974),(12331,'良朋镇','102',974),(12332,'鄣吴镇','103',974),(12333,'杭垓镇','104',974),(12334,'孝丰镇','105',974),(12335,'报福镇','106',974),(12336,'章村镇','107',974),(12337,'天荒坪镇','108',974),(12338,'高禹镇','109',974),(12339,'昆铜乡','200',974),(12340,'溪龙乡','201',974),(12341,'皈山乡','204',974),(12342,'上墅乡','205',974),(12343,'山川乡','206',974),(12344,'塔山街道','001',976),(12345,'府山街道','002',976),(12346,'蕺山街道','003',976),(12347,'北海街道','004',976),(12348,'城南街道','005',976),(12349,'稽山街道','006',976),(12350,'东湖镇','100',976),(12351,'灵芝镇','101',976),(12352,'东浦镇','102',976),(12353,'鉴湖镇','103',976),(12354,'皋埠镇','104',976),(12355,'马山镇','105',976),(12356,'斗门镇','106',976),(12357,'柯桥街道','001',977),(12358,'柯岩街道','002',977),(12359,'华舍街道','003',977),(12360,'湖塘街道','004',977),(12361,'齐贤镇','100',977),(12362,'钱清镇','101',977),(12363,'孙端镇','102',977),(12364,'福全镇','103',977),(12365,'马鞍镇','104',977),(12366,'平水镇','105',977),(12367,'安昌镇','106',977),(12368,'王坛镇','107',977),(12369,'兰亭镇','108',977),(12370,'稽东镇','109',977),(12371,'杨汛桥镇','110',977),(12372,'漓渚镇','111',977),(12373,'富盛镇','112',977),(12374,'陶堰镇','113',977),(12375,'夏履镇','114',977),(12376,'羽林街道','001',978),(12377,'南明街道','002',978),(12378,'七星街道','003',978),(12379,'澄潭镇','101',978),(12380,'梅渚镇','102',978),(12381,'回山镇','104',978),(12382,'大市聚镇','106',978),(12383,'小将镇','107',978),(12384,'沙溪镇','108',978),(12385,'镜岭镇','109',978),(12386,'儒岙镇','110',978),(12387,'城南乡','200',978),(12388,'东茗乡','201',978),(12389,'双彩乡','203',978),(12390,'新林乡','205',978),(12391,'巧英乡','206',978),(12392,'暨阳街道','001',979),(12393,'浣东街道','002',979),(12394,'陶朱街道','003',979),(12395,'大唐镇','101',979),(12396,'应店街镇','102',979),(12397,'次坞镇','103',979),(12398,'店口镇','104',979),(12399,'阮市镇','105',979),(12400,'直埠镇','106',979),(12401,'江藻镇','107',979),(12402,'山下湖镇','108',979),(12403,'枫桥镇','109',979),(12404,'赵家镇','110',979),(12405,'马剑镇','111',979),(12406,'五泄镇','112',979),(12407,'草塔镇','113',979),(12408,'王家井镇','114',979),(12409,'牌头镇','115',979),(12410,'同山镇','116',979),(12411,'安华镇','117',979),(12412,'街亭镇','118',979),(12413,'璜山镇','119',979),(12414,'陈宅镇','120',979),(12415,'岭北镇','121',979),(12416,'东白湖镇','124',979),(12417,'东和乡','201',979),(12418,'百官街道','001',980),(12419,'曹娥街道','002',980),(12420,'东关街道','003',980),(12421,'道墟镇','100',980),(12422,'长塘镇','101',980),(12423,'上浦镇','102',980),(12424,'汤浦镇','103',980),(12425,'章镇镇','104',980),(12426,'下管镇','105',980),(12427,'丰惠镇','106',980),(12428,'永和镇','107',980),(12429,'梁湖镇','108',980),(12430,'驿亭镇','109',980),(12431,'小越镇','110',980),(12432,'谢塘镇','111',980),(12433,'盖北镇','112',980),(12434,'崧厦镇','113',980),(12435,'沥海镇','114',980),(12436,'岭南乡','200',980),(12437,'陈溪乡','201',980),(12438,'丁宅乡','202',980),(12439,'围垦场','500',980),(12440,'农发场','501',980),(12441,'剡湖街道','001',981),(12442,'三江街道','002',981),(12443,'鹿山街道','003',981),(12444,'浦口街道','004',981),(12445,'甘霖镇','100',981),(12446,'长乐镇','101',981),(12447,'崇仁镇','102',981),(12448,'黄泽镇','103',981),(12449,'三界镇','104',981),(12450,'石璜镇','105',981),(12451,'谷来镇','106',981),(12452,'仙岩镇','107',981),(12453,'金庭镇','108',981),(12454,'北漳镇','109',981),(12455,'下王镇','110',981),(12456,'贵门乡','200',981),(12457,'里南乡','201',981),(12458,'竹溪乡','202',981),(12459,'雅璜乡','203',981),(12460,'王院乡','204',981),(12461,'通源乡','205',981),(12462,'城东街道','001',983),(12463,'城中街道','002',983),(12464,'城西街道','003',983),(12465,'城北街道','004',983),(12466,'江南街道','005',983),(12467,'三江街道','006',983),(12468,'西关街道','007',983),(12469,'秋滨街道','008',983),(12470,'新狮街道','009',983),(12471,'罗店镇','100',983),(12472,'雅畈镇','101',983),(12473,'安地镇','102',983),(12474,'白龙桥镇','103',983),(12475,'琅琊镇','104',983),(12476,'蒋堂镇','105',983),(12477,'汤溪镇','106',983),(12478,'罗埠镇','107',983),(12479,'洋埠镇','108',983),(12480,'乾西乡','201',983),(12481,'竹马乡','202',983),(12482,'长山乡','203',983),(12483,'箬阳乡','204',983),(12484,'沙畈乡','205',983),(12485,'塔石乡','206',983),(12486,'岭上乡','207',983),(12487,'莘畈乡','208',983),(12488,'苏孟乡','209',983),(12489,'多湖街道','001',984),(12490,'东孝街道','002',984),(12491,'孝顺镇','101',984),(12492,'傅村镇','102',984),(12493,'曹宅镇','103',984),(12494,'澧浦镇','104',984),(12495,'岭下镇','105',984),(12496,'江东镇','106',984),(12497,'塘雅镇','107',984),(12498,'赤松镇','108',984),(12499,'源东乡','200',984),(12500,'白洋街道','001',985),(12501,'壶山街道','002',985),(12502,'熟溪街道','003',985),(12503,'柳城畲族镇','100',985),(12504,'履坦镇','101',985),(12505,'桐琴镇','102',985),(12506,'泉溪镇','103',985),(12507,'新宅镇','104',985),(12508,'王宅镇','105',985),(12509,'桃溪镇','106',985),(12510,'茭道镇','107',985),(12511,'大田乡','200',985),(12512,'白姆乡','201',985),(12513,'俞源乡','202',985),(12514,'坦洪乡','203',985),(12515,'西联乡','204',985),(12516,'三港乡','205',985),(12517,'大溪口乡','206',985),(12518,'浦南街道','001',986),(12519,'仙华街道','002',986),(12520,'浦阳街道','003',986),(12521,'黄宅镇','101',986),(12522,'白马镇','102',986),(12523,'郑家坞镇','103',986),(12524,'郑宅镇','104',986),(12525,'岩头镇','105',986),(12526,'檀溪镇','106',986),(12527,'杭坪镇','107',986),(12528,'大畈乡','200',986),(12529,'中余乡','201',986),(12530,'前吴乡','202',986),(12531,'花桥乡','203',986),(12532,'虞宅乡','204',986),(12533,'安文镇','100',987),(12534,'新渥镇','101',987),(12535,'尖山镇','102',987),(12536,'仁川镇','103',987),(12537,'大盘镇','104',987),(12538,'方前镇','105',987),(12539,'玉山镇','106',987),(12540,'尚湖镇','107',987),(12541,'冷水镇','108',987),(12542,'深泽乡','200',987),(12543,'双峰乡','201',987),(12544,'双溪乡','203',987),(12545,'墨林乡','204',987),(12546,'窈川乡','205',987),(12547,'盘峰乡','206',987),(12548,'高二乡','207',987),(12549,'维新乡','208',987),(12550,'胡宅乡','209',987),(12551,'万苍乡','210',987),(12552,'九和乡','211',987),(12553,'兰江街道','001',988),(12554,'云山街道','002',988),(12555,'永昌街道','004',988),(12556,'赤溪街道','005',988),(12557,'女埠街道','006',988),(12558,'上华街道','007',988),(12559,'游埠镇','102',988),(12560,'诸葛镇','104',988),(12561,'黄店镇','106',988),(12562,'香溪镇','108',988),(12563,'马涧镇','109',988),(12564,'梅江镇','111',988),(12565,'灵洞乡','200',988),(12566,'水亭畲族乡','203',988),(12567,'柏社乡','209',988),(12568,'稠城街道','001',989),(12569,'江东街道','002',989),(12570,'稠江街道','003',989),(12571,'北苑街道','004',989),(12572,'后宅街道','005',989),(12573,'城西街道','006',989),(12574,'廿三里街道','007',989),(12575,'佛堂镇','100',989),(12576,'赤岸镇','101',989),(12577,'义亭镇','102',989),(12578,'上溪镇','104',989),(12579,'苏溪镇','105',989),(12580,'大陈镇','106',989),(12581,'吴宁街道','001',990),(12582,'南市街道','003',990),(12583,'白云街道','004',990),(12584,'江北街道','005',990),(12585,'城东街道','006',990),(12586,'六石街道','007',990),(12587,'巍山镇','106',990),(12588,'虎鹿镇','107',990),(12589,'歌山镇','108',990),(12590,'佐村镇','109',990),(12591,'东阳江镇','110',990),(12592,'湖溪镇','112',990),(12593,'马宅镇','114',990),(12594,'千祥镇','116',990),(12595,'南马镇','118',990),(12596,'画水镇','122',990),(12597,'横店镇','123',990),(12598,'三单乡','201',990),(12599,'东城街道','001',991),(12600,'西城街道','002',991),(12601,'江南街道','003',991),(12602,'芝英街道','004',991),(12603,'石柱镇','105',991),(12604,'前仓镇','106',991),(12605,'舟山镇','107',991),(12606,'古山镇','108',991),(12607,'方岩镇','109',991),(12608,'龙山镇','110',991),(12609,'西溪镇','111',991),(12610,'象珠镇','112',991),(12611,'唐先镇','113',991),(12612,'花街镇','114',991),(12613,'新新街道','005',993),(12614,'府山街道','006',993),(12615,'荷花街道','007',993),(12616,'信安街道','008',993),(12617,'白云街道','009',993),(12618,'双港街道','010',993),(12619,'花园街道','011',993),(12620,'石梁镇','100',993),(12621,'航埠镇','101',993),(12622,'黄家乡','205',993),(12623,'七里乡','209',993),(12624,'九华乡','210',993),(12625,'沟溪乡','211',993),(12626,'华墅乡','212',993),(12627,'姜家山乡','213',993),(12628,'万田乡','214',993),(12629,'石室乡','215',993),(12630,'樟潭街道','001',994),(12631,'浮石街道','002',994),(12632,'上方镇','100',994),(12633,'峡川镇','101',994),(12634,'莲花镇','103',994),(12635,'全旺镇','109',994),(12636,'大洲镇','110',994),(12637,'后溪镇','111',994),(12638,'廿里镇','112',994),(12639,'湖南镇','113',994),(12640,'高家镇','114',994),(12641,'杜泽镇','115',994),(12642,'灰坪乡','200',994),(12643,'太真乡','202',994),(12644,'双桥乡','203',994),(12645,'周家乡','206',994),(12646,'云溪乡','207',994),(12647,'横路乡','209',994),(12648,'举村乡','213',994),(12649,'岭洋乡','218',994),(12650,'黄坛口乡','219',994),(12651,'辉埠镇','101',995),(12652,'白石镇','104',995),(12653,'天马镇','107',995),(12654,'招贤镇','108',995),(12655,'青石镇','109',995),(12656,'芳村镇','110',995),(12657,'球川镇','111',995),(12658,'何家乡','200',995),(12659,'同弓乡','211',995),(12660,'大桥头乡','213',995),(12661,'宋畈乡','217',995),(12662,'东案乡','218',995),(12663,'新昌乡','219',995),(12664,'新桥乡','220',995),(12665,'桐村镇','106',996),(12666,'杨林镇','107',996),(12667,'苏庄镇','108',996),(12668,'齐溪镇','109',996),(12669,'城关镇','110',996),(12670,'华埠镇','111',996),(12671,'马金镇','112',996),(12672,'村头镇','113',996),(12673,'池淮镇','114',996),(12674,'中村乡','202',996),(12675,'长虹乡','205',996),(12676,'张湾乡','206',996),(12677,'何田乡','208',996),(12678,'塘坞乡','209',996),(12679,'林山乡','216',996),(12680,'音坑乡','217',996),(12681,'大溪边乡','218',996),(12682,'金村乡','219',996),(12683,'龙洲街道','001',997),(12684,'东华街道','002',997),(12685,'湖镇镇','101',997),(12686,'小南海镇','102',997),(12687,'詹家镇','106',997),(12688,'溪口镇','109',997),(12689,'横山镇','110',997),(12690,'塔石镇','111',997),(12691,'罗家乡','201',997),(12692,'庙下乡','203',997),(12693,'石佛乡','207',997),(12694,'社阳乡','209',997),(12695,'大街乡','211',997),(12696,'沐尘畲族乡','212',997),(12697,'模环乡','213',997),(12698,'双塔街道','001',998),(12699,'虎山街道','002',998),(12700,'四都镇','102',998),(12701,'清湖镇','104',998),(12702,'坛石镇','105',998),(12703,'大桥镇','106',998),(12704,'淤头镇','108',998),(12705,'新塘边镇','109',998),(12706,'廿八都镇','112',998),(12707,'长台镇','113',998),(12708,'上余镇','116',998),(12709,'贺村镇','117',998),(12710,'凤林镇','118',998),(12711,'峡口镇','119',998),(12712,'石门镇','120',998),(12713,'大陈乡','201',998),(12714,'碗窑乡','203',998),(12715,'保安乡','207',998),(12716,'双溪口乡','211',998),(12717,'张村乡','212',998),(12718,'塘源口乡','213',998),(12719,'解放街道','001',1000),(12720,'昌国街道','002',1000),(12721,'环南街道','003',1000),(12722,'城东街道','004',1000),(12723,'盐仓街道','005',1000),(12724,'临城街道','006',1000),(12725,'金塘镇','100',1000),(12726,'小沙镇','101',1000),(12727,'岑港镇','102',1000),(12728,'双桥镇','103',1000),(12729,'白泉镇','104',1000),(12730,'干览镇','105',1000),(12731,'马岙镇','106',1000),(12732,'长白乡','200',1000),(12733,'册子乡','201',1000),(12734,'北蝉乡','202',1000),(12735,'沈家门街道','001',1001),(12736,'勾山街道','002',1001),(12737,'东港街道','003',1001),(12738,'六横镇','100',1001),(12739,'朱家尖镇','101',1001),(12740,'虾峙镇','102',1001),(12741,'展茅镇','103',1001),(12742,'桃花镇','104',1001),(12743,'东极镇','105',1001),(12744,'普陀山镇','106',1001),(12745,'蚂蚁岛乡','200',1001),(12746,'登步乡','201',1001),(12747,'白沙乡','202',1001),(12748,'佛渡乡','203',1001),(12749,'高亭镇','100',1002),(12750,'东沙镇','101',1002),(12751,'岱东镇','102',1002),(12752,'岱西镇','103',1002),(12753,'长涂镇','105',1002),(12754,'衢山镇','106',1002),(12755,'秀山乡','200',1002),(12756,'菜园镇','100',1003),(12757,'嵊山镇','101',1003),(12758,'洋山镇','102',1003),(12759,'五龙乡','200',1003),(12760,'黄龙乡','201',1003),(12761,'枸杞乡','202',1003),(12762,'花鸟乡','203',1003),(12763,'海门街道','001',1005),(12764,'白云街道','002',1005),(12765,'葭','003',1005),(12766,'洪家街道','004',1005),(12767,'三甲街道','005',1005),(12768,'下陈街道','006',1005),(12769,'前所街道','007',1005),(12770,'章安街道','008',1005),(12771,'大陈镇','101',1005),(12772,'椒江农场','400',1005),(12773,'东城街道','001',1006),(12774,'南城街道','002',1006),(12775,'西城街道','003',1006),(12776,'北城街道','004',1006),(12777,'新前街道','005',1006),(12778,'澄江街道','006',1006),(12779,'江口街道','007',1006),(12780,'高桥街道','008',1006),(12781,'宁溪镇','101',1006),(12782,'北洋镇','102',1006),(12783,'头陀镇','103',1006),(12784,'院桥镇','107',1006),(12785,'沙埠镇','108',1006),(12786,'屿头乡','200',1006),(12787,'上郑乡','201',1006),(12788,'富山乡','202',1006),(12789,'茅畲乡','203',1006),(12790,'上','204',1006),(12791,'平田乡','205',1006),(12792,'路南街道','001',1007),(12793,'路桥街道','002',1007),(12794,'路北街道','003',1007),(12795,'螺洋街道','004',1007),(12796,'桐屿街道','005',1007),(12797,'峰江街道','006',1007),(12798,'新桥镇','103',1007),(12799,'横街镇','104',1007),(12800,'金清镇','106',1007),(12801,'蓬街镇','107',1007),(12802,'珠港镇','100',1008),(12803,'清港镇','101',1008),(12804,'楚门镇','102',1008),(12805,'干江镇','103',1008),(12806,'沙门镇','105',1008),(12807,'芦浦镇','106',1008),(12808,'龙溪乡','200',1008),(12809,'鸡山乡','201',1008),(12810,'海山乡','202',1008),(12811,'海游镇','100',1009),(12812,'沙柳镇','101',1009),(12813,'珠岙镇','102',1009),(12814,'亭旁镇','103',1009),(12815,'六敖镇','104',1009),(12816,'健跳镇','105',1009),(12817,'横渡镇','106',1009),(12818,'花桥镇','108',1009),(12819,'小雄镇','109',1009),(12820,'高枧乡','200',1009),(12821,'沿赤乡','203',1009),(12822,'泗淋乡','204',1009),(12823,'蛇蟠乡','205',1009),(12824,'赤城街道','001',1010),(12825,'始丰街道','002',1010),(12826,'福溪街道','003',1010),(12827,'白鹤镇','101',1010),(12828,'石梁镇','102',1010),(12829,'街头镇','104',1010),(12830,'平桥镇','105',1010),(12831,'坦头镇','106',1010),(12832,'三合镇','107',1010),(12833,'洪畴镇','108',1010),(12834,'三州乡','200',1010),(12835,'龙溪乡','203',1010),(12836,'雷峰乡','204',1010),(12837,'南屏乡','207',1010),(12838,'泳溪乡','209',1010),(12839,'安洲街道','001',1011),(12840,'南峰街道','002',1011),(12841,'福应街道','003',1011),(12842,'横溪镇','101',1011),(12843,'埠头镇','102',1011),(12844,'白塔镇','103',1011),(12845,'田市镇','104',1011),(12846,'官路镇','105',1011),(12847,'下各镇','106',1011),(12848,'朱溪镇','107',1011),(12849,'安岭乡','200',1011),(12850,'溪港乡','201',1011),(12851,'湫山乡','202',1011),(12852,'淡竹乡','203',1011),(12853,'皤滩乡','204',1011),(12854,'上张乡','205',1011),(12855,'步路乡','206',1011),(12856,'广度乡','207',1011),(12857,'大战乡','209',1011),(12858,'双庙乡','210',1011),(12859,'太平街道','001',1012),(12860,'城东街道','002',1012),(12861,'城西街道','003',1012),(12862,'城北街道','004',1012),(12863,'横峰街道','005',1012),(12864,'泽国镇','100',1012),(12865,'大溪镇','101',1012),(12866,'松门镇','102',1012),(12867,'箬横镇','103',1012),(12868,'新河镇','104',1012),(12869,'石塘镇','105',1012),(12870,'滨海镇','106',1012),(12871,'温峤镇','107',1012),(12872,'城南镇','108',1012),(12873,'石桥头镇','109',1012),(12874,'坞根镇','110',1012),(12875,'古城街道','001',1013),(12876,'大洋街道','002',1013),(12877,'江南街道','003',1013),(12878,'大田街道','004',1013),(12879,'邵家渡街道','005',1013),(12880,'汛桥镇','100',1013),(12881,'东塍镇','101',1013),(12882,'汇溪镇','103',1013),(12883,'小芝镇','104',1013),(12884,'河头镇','105',1013),(12885,'白水洋镇','106',1013),(12886,'括苍镇','107',1013),(12887,'永丰镇','108',1013),(12888,'尤溪镇','109',1013),(12889,'涌泉镇','110',1013),(12890,'沿江镇','111',1013),(12891,'杜桥镇','112',1013),(12892,'上盘镇','113',1013),(12893,'桃渚镇','114',1013),(12894,'紫金街道','001',1015),(12895,'岩泉街道','002',1015),(12896,'万象街道','003',1015),(12897,'白云街道','004',1015),(12898,'水阁街道','005',1015),(12899,'富岭街道','006',1015),(12900,'碧湖镇','100',1015),(12901,'联城镇','101',1015),(12902,'大港头镇','102',1015),(12903,'老竹畲族镇','103',1015),(12904,'雅溪镇','104',1015),(12905,'太平乡','200',1015),(12906,'仙渡乡','201',1015),(12907,'峰源乡','202',1015),(12908,'高溪乡','203',1015),(12909,'丽新畲族乡','204',1015),(12910,'双黄乡','205',1015),(12911,'黄村乡','206',1015),(12912,'鹤城镇','100',1016),(12913,'温溪镇','101',1016),(12914,'东源镇','102',1016),(12915,'高湖镇','103',1016),(12916,'船寮镇','104',1016),(12917,'海口镇','105',1016),(12918,'腊口镇','106',1016),(12919,'北山镇','107',1016),(12920,'山口镇','108',1016),(12921,'仁庄镇','109',1016),(12922,'万山乡','200',1016),(12923,'黄','201',1016),(12924,'季宅乡','202',1016),(12925,'高市乡','203',1016),(12926,'海溪乡','204',1016),(12927,'章村乡','205',1016),(12928,'祯旺乡','206',1016),(12929,'祯埠乡','207',1016),(12930,'舒桥乡','208',1016),(12931,'巨浦乡','209',1016),(12932,'岭根乡','210',1016),(12933,'万阜乡','211',1016),(12934,'方山乡','212',1016),(12935,'汤','213',1016),(12936,'贵岙乡','214',1016),(12937,'小舟山乡','215',1016),(12938,'吴坑乡','216',1016),(12939,'仁宫乡','217',1016),(12940,'章旦乡','218',1016),(12941,'阜山乡','219',1016),(12942,'石溪乡','220',1016),(12943,'五云镇','100',1017),(12944,'壶镇镇','101',1017),(12945,'新建镇','102',1017),(12946,'舒洪镇','103',1017),(12947,'新碧镇','104',1017),(12948,'大洋镇','105',1017),(12949,'东渡镇','106',1017),(12950,'东方镇','107',1017),(12951,'大源镇','108',1017),(12952,'新川乡','200',1017),(12953,'双川乡','201',1017),(12954,'城北乡','202',1017),(12955,'七里乡','203',1017),(12956,'白竹乡','204',1017),(12957,'雁岭乡','205',1017),(12958,'前路乡','206',1017),(12959,'三溪乡','207',1017),(12960,'溶江乡','208',1017),(12961,'双溪口乡','209',1017),(12962,'胡源乡','210',1017),(12963,'方溪乡','211',1017),(12964,'石笕乡','212',1017),(12965,'南溪乡','213',1017),(12966,'木栗乡','214',1017),(12967,'妙高镇','100',1018),(12968,'云峰镇','101',1018),(12969,'新路湾镇','102',1018),(12970,'北界镇','103',1018),(12971,'金竹镇','104',1018),(12972,'大柘镇','105',1018),(12973,'石练镇','106',1018),(12974,'王村口镇','107',1018),(12975,'黄沙腰镇','108',1018),(12976,'三仁畲族乡','200',1018),(12977,'濂竹乡','201',1018),(12978,'应村乡','202',1018),(12979,'高坪乡','203',1018),(12980,'湖山乡','204',1018),(12981,'蔡源乡','205',1018),(12982,'焦滩乡','206',1018),(12983,'龙洋乡','207',1018),(12984,'柘岱口乡','208',1018),(12985,'西畈乡','209',1018),(12986,'西屏镇','100',1019),(12987,'古市镇','101',1019),(12988,'玉岩镇','102',1019),(12989,'象溪镇','103',1019),(12990,'大东坝镇','104',1019),(12991,'望松乡','200',1019),(12992,'叶村乡','201',1019),(12993,'斋坛乡','202',1019),(12994,'三都乡','203',1019),(12995,'竹源乡','204',1019),(12996,'四都乡','205',1019),(12997,'赤寿乡','206',1019),(12998,'新兴乡','207',1019),(12999,'樟溪乡','208',1019),(13000,'谢村乡','209',1019),(13001,'新处乡','210',1019),(13002,'枫坪乡','211',1019),(13003,'板桥畲族乡','212',1019),(13004,'裕溪乡','213',1019),(13005,'安民乡','214',1019),(13006,'云和镇','100',1020),(13007,'石塘镇','101',1020),(13008,'紧水滩镇','102',1020),(13009,'崇头镇','103',1020),(13010,'雾溪畲族乡','201',1020),(13011,'安溪畲族乡','202',1020),(13012,'云坛乡','203',1020),(13013,'朱村乡','204',1020),(13014,'大源乡','205',1020),(13015,'赤石乡','206',1020),(13016,'黄源乡','207',1020),(13017,'大湾乡','208',1020),(13018,'沙铺乡','209',1020),(13019,'云丰乡','210',1020),(13020,'松源镇','100',1021),(13021,'黄田镇','101',1021),(13022,'竹口镇','102',1021),(13023,'屏都镇','103',1021),(13024,'荷地镇','104',1021),(13025,'左溪镇','105',1021),(13026,'贤良镇','106',1021),(13027,'岭头乡','200',1021),(13028,'五大堡乡','201',1021),(13029,'淤上乡','202',1021),(13030,'安南乡','203',1021),(13031,'张村乡','204',1021),(13032,'隆宫乡','205',1021),(13033,'举水乡','206',1021),(13034,'江根乡','207',1021),(13035,'合湖乡','208',1021),(13036,'龙溪乡','209',1021),(13037,'百山祖乡','210',1021),(13038,'官塘乡','211',1021),(13039,'四山乡','212',1021),(13040,'鹤溪镇','100',1022),(13041,'渤海镇','101',1022),(13042,'东坑镇','102',1022),(13043,'英川镇','103',1022),(13044,'沙湾镇','104',1022),(13045,'外舍乡','200',1022),(13046,'大均乡','201',1022),(13047,'澄照乡','202',1022),(13048,'梅岐乡','203',1022),(13049,'金钟乡','204',1022),(13050,'郑坑乡','205',1022),(13051,'大顺乡','206',1022),(13052,'陈村乡','207',1022),(13053,'大际乡','208',1022),(13054,'景南乡','209',1022),(13055,'雁溪乡','210',1022),(13056,'葛山乡','211',1022),(13057,'鸬鹚乡','212',1022),(13058,'梧桐乡','213',1022),(13059,'标溪乡','214',1022),(13060,'毛洋乡','215',1022),(13061,'秋炉乡','216',1022),(13062,'大地乡','217',1022),(13063,'家地乡','218',1022),(13064,'龙渊街道','001',1023),(13065,'西街街道','002',1023),(13066,'剑池街道','003',1023),(13067,'八都镇','100',1023),(13068,'上','101',1023),(13069,'小梅镇','102',1023),(13070,'查田镇','103',1023),(13071,'安仁镇','104',1023),(13072,'锦溪镇','105',1023),(13073,'住龙镇','106',1023),(13074,'屏南镇','107',1023),(13075,'兰巨乡','200',1023),(13076,'宝溪乡','202',1023),(13077,'竹','203',1023),(13078,'道太乡','204',1023),(13079,'岩樟乡','205',1023),(13080,'城北乡','206',1023),(13081,'龙南乡','207',1023),(13082,'明光路街道','001',1025),(13083,'车站街道','002',1025),(13084,'胜利路街道','003',1025),(13085,'三里街街道','004',1025),(13086,'铜陵路街道','005',1025),(13087,'七里站街道','006',1025),(13088,'红光街道','007',1025),(13089,'和平路街道','008',1025),(13090,'大通路街道','009',1025),(13091,'城东街道','010',1025),(13092,'长淮街道','011',1025),(13093,'方庙街道','012',1025),(13094,'七里塘街道','013',1025),(13095,'大兴镇','100',1025),(13096,'磨店乡','200',1025),(13097,'瑶海区工业园','400',1025),(13098,'杏林街道','001',1026),(13099,'海棠街道','002',1026),(13100,'逍遥津街道','003',1026),(13101,'三牌楼街道','004',1026),(13102,'县桥街道','005',1026),(13103,'益民街道','006',1026),(13104,'安庆路街道','007',1026),(13105,'光明街道','008',1026),(13106,'亳州路街道','009',1026),(13107,'双岗街道','010',1026),(13108,'杏花村街道','011',1026),(13109,'大杨镇','100',1026),(13110,'三十岗乡','200',1026),(13111,'庐阳工业园区','400',1026),(13112,'稻香村街道','001',1027),(13113,'南七里站街道','002',1027),(13114,'三里庵街道','003',1027),(13115,'琥珀山庄街道','004',1027),(13116,'西园新村街道','005',1027),(13117,'五里墩街道','006',1027),(13118,'荷叶地街道','007',1027),(13119,'笔架山街道','008',1027),(13120,'井岗镇','100',1027),(13121,'南岗镇','101',1027),(13122,'蜀山新产业园区','400',1027),(13123,'高新技术产业开发区','401',1027),(13124,'莲花社区管理委员会','402',1027),(13125,'芙蓉社区管理委员会','403',1027),(13126,'锦绣社区管理委员会','404',1027),(13127,'海恒社区管理委员会','405',1027),(13128,'常青街道','001',1028),(13129,'宁国路街道','002',1028),(13130,'芜湖路街道','003',1028),(13131,'巢湖路街道','004',1028),(13132,'骆岗街道','005',1028),(13133,'义兴镇','100',1028),(13134,'义城镇','101',1028),(13135,'大圩乡','200',1028),(13136,'烟墩乡','201',1028),(13137,'包河工业区管委会','400',1028),(13138,'水湖镇','100',1029),(13139,'庄墓镇','101',1029),(13140,'杨庙镇','102',1029),(13141,'吴山镇','103',1029),(13142,'岗集镇','104',1029),(13143,'双墩镇','105',1029),(13144,'下塘镇','106',1029),(13145,'朱巷镇','107',1029),(13146,'罗塘乡','200',1029),(13147,'义井乡','201',1029),(13148,'三十头乡','202',1029),(13149,'陶楼乡','203',1029),(13150,'造甲乡','204',1029),(13151,'左店乡','205',1029),(13152,'杜集乡','206',1029),(13153,'双凤工业区','400',1029),(13154,'店埠镇','100',1030),(13155,'撮镇镇','101',1030),(13156,'梁园镇','102',1030),(13157,'桥头集镇','103',1030),(13158,'长临河镇','104',1030),(13159,'石塘镇','105',1030),(13160,'古城镇','106',1030),(13161,'八斗镇','107',1030),(13162,'元疃镇','108',1030),(13163,'白龙镇','109',1030),(13164,'包公镇','110',1030),(13165,'众兴乡','200',1030),(13166,'张集乡','201',1030),(13167,'马湖乡','202',1030),(13168,'陈集乡','203',1030),(13169,'响导乡','204',1030),(13170,'杨店乡','205',1030),(13171,'牌坊回族满族乡','206',1030),(13172,'合肥龙岗综合经济开发区','400',1030),(13173,'上派镇','100',1031),(13174,'三河镇','101',1031),(13175,'高刘镇','102',1031),(13176,'官亭镇','103',1031),(13177,'小庙镇','104',1031),(13178,'山南镇','105',1031),(13179,'花岗镇','106',1031),(13180,'紫蓬镇','107',1031),(13181,'桃花镇','108',1031),(13182,'丰乐镇','109',1031),(13183,'高店乡','200',1031),(13184,'铭传乡','201',1031),(13185,'柿树岗乡','202',1031),(13186,'严店乡','203',1031),(13187,'桃花工业园管委会','400',1031),(13188,'紫蓬山管委会','401',1031),(13189,'北京路街道','001',1033),(13190,'赭麓街道','002',1033),(13191,'镜湖街道','003',1033),(13192,'吉和街街道','004',1033),(13193,'赭山街道','005',1033),(13194,'弋矶山街道','006',1033),(13195,'汀棠街道','007',1033),(13196,'天门山街道','008',1033),(13197,'北门街道','009',1033),(13198,'东门街道','010',1033),(13199,'荆山街道','011',1033),(13200,'长江大桥综合经济开发区（虚拟）','400',1033),(13201,'弋江桥街道','001',1034),(13202,'中山南路街道','002',1034),(13203,'利民路街道','003',1034),(13204,'马塘街道','100',1034),(13205,'鲁港街道','101',1034),(13206,'火龙岗镇','102',1034),(13207,'虚拟街道','198',1034),(13208,'四褐山街道','001',1035),(13209,'裕溪口街道','002',1035),(13210,'官陡街道','003',1035),(13211,'湾里街道','004',1035),(13212,'清水街道','005',1035),(13213,'经济技术开发区','400',1035),(13214,'鸠江开发区','401',1035),(13215,'三山街道','001',1036),(13216,'保定街道','002',1036),(13217,'龙湖街道','003',1036),(13218,'峨桥镇','100',1036),(13219,'湾','100',1037),(13220,'六郎镇','101',1037),(13221,'陶辛镇','102',1037),(13222,'方村镇','103',1037),(13223,'红杨镇','104',1037),(13224,'花桥镇','105',1037),(13225,'繁阳镇','100',1038),(13226,'荻港镇','101',1038),(13227,'孙村镇','102',1038),(13228,'平铺镇','103',1038),(13229,'新港办事处','104',1038),(13230,'峨山乡','200',1038),(13231,'籍山镇','100',1039),(13232,'许镇镇','101',1039),(13233,'弋江镇','102',1039),(13234,'三里镇','103',1039),(13235,'何湾镇','104',1039),(13236,'工山镇','105',1039),(13237,'烟墩镇','106',1039),(13238,'家发镇','107',1039),(13239,'东风街道','001',1041),(13240,'延安街道','002',1041),(13241,'治淮街道','003',1041),(13242,'东升街道','004',1041),(13243,'解放街道','005',1041),(13244,'曹山街道','006',1041),(13245,'长淮卫镇','100',1041),(13246,'李楼乡','200',1041),(13247,'新城综合开发区(龙子湖区)','400',1041),(13248,'天桥街道','001',1042),(13249,'青年街道','002',1042),(13250,'纬二路街道','003',1042),(13251,'黄庄街道','004',1042),(13252,'宏业村街道','005',1042),(13253,'燕山乡','200',1042),(13254,'雪华乡','201',1042),(13255,'胜利街道','400',1042),(13256,'龙湖街道','401',1042),(13257,'湖滨社区行政事务管理中心','402',1042),(13258,'淮河社区行政事务管理中心','403',1042),(13259,'朝阳街道','001',1043),(13260,'纬四街道','002',1043),(13261,'大庆街道','003',1043),(13262,'张公山街道','004',1043),(13263,'钓鱼台街道','005',1043),(13264,'秦集镇','100',1043),(13265,'长青乡','200',1043),(13266,'高新技术开发区','400',1043),(13267,'淮滨街道','001',1044),(13268,'小蚌埠镇','100',1044),(13269,'吴小街镇','101',1044),(13270,'曹老集镇','102',1044),(13271,'梅桥乡','200',1044),(13272,'城关镇','100',1045),(13273,'鲍集镇','101',1045),(13274,'龙亢镇','102',1045),(13275,'河溜镇','103',1045),(13276,'常坟镇','104',1045),(13277,'马城镇','105',1045),(13278,'双桥集镇','106',1045),(13279,'魏庄镇','107',1045),(13280,'万福镇','108',1045),(13281,'唐集镇','109',1045),(13282,'淝南乡','200',1045),(13283,'淝河乡','201',1045),(13284,'褚集乡','202',1045),(13285,'陈集乡','203',1045),(13286,'古城乡','204',1045),(13287,'徐圩乡','205',1045),(13288,'兰桥乡','206',1045),(13289,'荆芡乡','207',1045),(13290,'找郢乡','208',1045),(13291,'龙亢农场','400',1045),(13292,'经济开发区','401',1045),(13293,'城关镇','100',1046),(13294,'新集镇','101',1046),(13295,'沫河口镇','102',1046),(13296,'小溪镇','103',1046),(13297,'双忠庙镇','104',1046),(13298,'小圩镇','105',1046),(13299,'东刘集镇','106',1046),(13300,'头铺镇','107',1046),(13301,'大新镇','108',1046),(13302,'武桥镇','109',1046),(13303,'朱顶镇','110',1046),(13304,'浍南镇','111',1046),(13305,'申集镇','112',1046),(13306,'沱湖乡','200',1046),(13307,'临北回族乡','201',1046),(13308,'城关镇','100',1047),(13309,'王庄镇','101',1047),(13310,'新马桥镇','102',1047),(13311,'连城镇','103',1047),(13312,'刘集镇','104',1047),(13313,'任桥镇','105',1047),(13314,'湖沟镇','106',1047),(13315,'濠城镇','107',1047),(13316,'石湖乡','200',1047),(13317,'杨庙乡','201',1047),(13318,'仲兴乡','202',1047),(13319,'固镇开发区','400',1047),(13320,'大通街道','001',1049),(13321,'上窑镇','100',1049),(13322,'洛河镇','101',1049),(13323,'九龙岗镇','102',1049),(13324,'孔店乡','200',1049),(13325,'田东街道','001',1050),(13326,'新淮街道','002',1050),(13327,'国庆街道','003',1050),(13328,'淮滨街道','004',1050),(13329,'朝阳街道','005',1050),(13330,'公园街道','006',1050),(13331,'洞山街道','007',1050),(13332,'龙泉街道','008',1050),(13333,'泉山街道','009',1050),(13334,'舜耕镇','100',1050),(13335,'安成镇','101',1050),(13336,'曹庵镇','102',1050),(13337,'三和乡','200',1050),(13338,'史院乡','201',1050),(13339,'谢家集街道','001',1051),(13340,'蔡家岗街道','002',1051),(13341,'立新街道','003',1051),(13342,'谢三村街道','004',1051),(13343,'平山街道','005',1051),(13344,'望峰岗镇','100',1051),(13345,'李郢孜镇','101',1051),(13346,'唐山镇','102',1051),(13347,'杨公镇','103',1051),(13348,'孙庙乡','200',1051),(13349,'孤堆乡','201',1051),(13350,'新庄孜街道','001',1052),(13351,'土坝孜街道','002',1052),(13352,'毕家岗街道','003',1052),(13353,'八公山镇','100',1052),(13354,'山王镇','101',1052),(13355,'妙山林场','400',1052),(13356,'田集街道','001',1053),(13357,'高皇镇','100',1053),(13358,'平圩镇','101',1053),(13359,'泥河镇','102',1053),(13360,'潘集镇','103',1053),(13361,'芦集镇','104',1053),(13362,'夹沟乡','200',1053),(13363,'祁集乡','201',1053),(13364,'古沟回族乡','202',1053),(13365,'架河乡','203',1053),(13366,'贺疃乡','204',1053),(13367,'城关镇','100',1054),(13368,'大山镇','101',1054),(13369,'新集镇','102',1054),(13370,'朱马店镇','103',1054),(13371,'岳张集镇','104',1054),(13372,'顾桥镇','105',1054),(13373,'毛集区毛集镇','106',1054),(13374,'毛集区夏集镇','107',1054),(13375,'城北乡','200',1054),(13376,'李冲回族乡','201',1054),(13377,'刘集乡','202',1054),(13378,'桂集乡','203',1054),(13379,'古店乡','204',1054),(13380,'钱庙乡','205',1054),(13381,'杨村乡','206',1054),(13382,'尚塘乡','207',1054),(13383,'丁集乡','208',1054),(13384,'关店乡','209',1054),(13385,'大兴集乡','210',1054),(13386,'毛集区焦岗乡','211',1054),(13387,'金家庄街道','001',1056),(13388,'江边街道','002',1056),(13389,'塘西街道','003',1056),(13390,'慈湖街道','004',1056),(13391,'慈湖乡','200',1056),(13392,'沙塘路街道','001',1057),(13393,'解放路街道','002',1057),(13394,'湖东路街道','003',1057),(13395,'桃源路街道','004',1057),(13396,'霍里镇','100',1057),(13397,'平湖街道','001',1058),(13398,'雨山街道','002',1058),(13399,'安民街道','003',1058),(13400,'采石街道','004',1058),(13401,'向山镇','100',1058),(13402,'银塘镇','101',1058),(13403,'佳山乡','200',1058),(13404,'姑孰镇','100',1059),(13405,'黄池镇','101',1059),(13406,'乌溪镇','102',1059),(13407,'石桥镇','103',1059),(13408,'塘南镇','104',1059),(13409,'护河镇','105',1059),(13410,'太白镇','106',1059),(13411,'丹阳镇','107',1059),(13412,'博望镇','108',1059),(13413,'新市镇','109',1059),(13414,'大陇乡','200',1059),(13415,'年陡乡','201',1059),(13416,'江心乡','202',1059),(13417,'湖阳乡','203',1059),(13418,'高岳街道办事处','001',1061),(13419,'矿山集街道办事处','002',1061),(13420,'朔里镇','100',1061),(13421,'石台镇','101',1061),(13422,'段圆镇','102',1061),(13423,'相南街道','001',1062),(13424,'东街道','002',1062),(13425,'西街道','003',1062),(13426,'三堤口街道','004',1062),(13427,'东山街道','005',1062),(13428,'人民路街道','006',1062),(13429,'刘桥街道','007',1062),(13430,'任圩街道办事处','008',1062),(13431,'南黎街道办事处筹备组','009',1062),(13432,'曲阳街道办事处筹备组','010',1062),(13433,'渠沟镇','100',1062),(13434,'临海童街道','001',1063),(13435,'前岭街道','002',1063),(13436,'百善街道','003',1063),(13437,'任楼街道','004',1063),(13438,'杨庄街道','005',1063),(13439,'烈山镇','100',1063),(13440,'宋疃镇','101',1063),(13441,'古饶镇','102',1063),(13442,'濉溪镇','100',1064),(13443,'韩村镇','101',1064),(13444,'刘桥镇','102',1064),(13445,'五沟镇','103',1064),(13446,'临涣镇','104',1064),(13447,'双堆集镇','105',1064),(13448,'铁佛镇','106',1064),(13449,'南坪镇','107',1064),(13450,'百善镇','108',1064),(13451,'孙町镇','109',1064),(13452,'四铺乡','200',1064),(13453,'长江路街道','001',1066),(13454,'铜官山街道','002',1066),(13455,'杨家山街道','003',1066),(13456,'石城路街道','004',1066),(13457,'扫把沟街道','005',1066),(13458,'横港街道','006',1066),(13459,'普济圩农场','400',1066),(13460,'狮子山街道','001',1067),(13461,'新庙街道','002',1067),(13462,'矶山街道','003',1067),(13463,'凤凰山街道','004',1067),(13464,'东郊街道办事处','005',1067),(13465,'西湖镇','100',1067),(13466,'铜陵经济技术开发区','400',1067),(13467,'桥南办事处','001',1068),(13468,'铜山镇','100',1068),(13469,'安矿办事处','101',1068),(13470,'大通镇','102',1068),(13471,'灰河乡','200',1068),(13472,'\"两矿一公司\"专管办','400',1068),(13473,'五松镇','100',1069),(13474,'顺安镇','101',1069),(13475,'钟鸣镇','102',1069),(13476,'天门镇','103',1069),(13477,'老洲乡','200',1069),(13478,'东联乡','201',1069),(13479,'西联乡','202',1069),(13480,'胥坝乡','203',1069),(13481,'宜城路街道','001',1071),(13482,'新河路街道','002',1071),(13483,'华中路街道','003',1071),(13484,'人民路街道','004',1071),(13485,'孝肃路街道','005',1071),(13486,'建设路街道','006',1071),(13487,'老峰镇','100',1071),(13488,'龙狮桥乡','200',1071),(13489,'长风乡','201',1071),(13490,'新洲乡','202',1071),(13491,'德宽路街道办事处','001',1072),(13492,'玉琳路街道办事处','002',1072),(13493,'龙山路街道办事处','003',1072),(13494,'菱湖街道办事处','004',1072),(13495,'集贤路街道办事处','005',1072),(13496,'石化路街道办事处','006',1072),(13497,'花亭路街道办事处','007',1072),(13498,'海口镇','100',1072),(13499,'十里乡','200',1072),(13500,'山口乡','201',1072),(13501,'皖河农场','400',1072),(13502,'大桥街道办事处','001',1073),(13503,'菱北街道办事处','002',1073),(13504,'大龙山镇','100',1073),(13505,'杨桥镇','101',1073),(13506,'罗岭镇','102',1073),(13507,'白泽湖乡','200',1073),(13508,'五横乡','201',1073),(13509,'高河镇','100',1074),(13510,'石牌镇','101',1074),(13511,'月山镇','102',1074),(13512,'马庙镇','103',1074),(13513,'金拱镇','104',1074),(13514,'茶岭镇','105',1074),(13515,'公岭镇','106',1074),(13516,'黄墩镇','107',1074),(13517,'三桥镇','108',1074),(13518,'小市镇','109',1074),(13519,'黄龙镇','110',1074),(13520,'平山镇','111',1074),(13521,'腊树镇','112',1074),(13522,'洪铺镇','113',1074),(13523,'江镇镇','114',1074),(13524,'凉亭乡','200',1074),(13525,'石镜乡','201',1074),(13526,'秀山乡','202',1074),(13527,'清河乡','203',1074),(13528,'雷埠乡','204',1074),(13529,'枞阳镇','100',1075),(13530,'Ou山镇','101',1075),(13531,'汤沟镇','102',1075),(13532,'老洲镇','103',1075),(13533,'陈瑶湖镇','104',1075),(13534,'周潭镇','105',1075),(13535,'横埠镇','106',1075),(13536,'项铺镇','107',1075),(13537,'钱桥镇','108',1075),(13538,'麒麟镇','109',1075),(13539,'义津镇','110',1075),(13540,'浮山镇','111',1075),(13541,'官埠桥镇','112',1075),(13542,'铁铜乡','200',1075),(13543,'凤仪乡','201',1075),(13544,'长沙乡','202',1075),(13545,'钱铺乡','203',1075),(13546,'金社乡','204',1075),(13547,'白梅乡','205',1075),(13548,'白湖乡','206',1075),(13549,'会宫乡','207',1075),(13550,'雨坛乡','208',1075),(13551,'梅城镇','100',1076),(13552,'源潭镇','101',1076),(13553,'余井镇','102',1076),(13554,'王河镇','103',1076),(13555,'黄铺镇','104',1076),(13556,'槎水镇','105',1076),(13557,'水吼镇','106',1076),(13558,'官庄镇','107',1076),(13559,'黄泥镇','108',1076),(13560,'黄柏镇','109',1076),(13561,'天柱山镇','110',1076),(13562,'塔畈乡','200',1076),(13563,'油坝乡','201',1076),(13564,'龙潭乡','202',1076),(13565,'痘姆乡','203',1076),(13566,'五庙乡','204',1076),(13567,'开发区','400',1076),(13568,'晋熙镇','100',1077),(13569,'徐桥镇','101',1077),(13570,'新仓镇','102',1077),(13571,'小池镇','103',1077),(13572,'寺前镇','104',1077),(13573,'天华镇','105',1077),(13574,'牛镇镇','106',1077),(13575,'弥陀镇','107',1077),(13576,'北中镇','108',1077),(13577,'百里镇','109',1077),(13578,'大石乡','200',1077),(13579,'城西乡','201',1077),(13580,'江塘乡','202',1077),(13581,'汤泉乡','203',1077),(13582,'刘畈乡','204',1077),(13583,'孚玉镇','100',1078),(13584,'复兴镇','101',1078),(13585,'汇口镇','102',1078),(13586,'许岭镇','103',1078),(13587,'下仓镇','104',1078),(13588,'二郎镇','105',1078),(13589,'破凉镇','106',1078),(13590,'凉亭镇','107',1078),(13591,'长铺镇','108',1078),(13592,'高岭乡','200',1078),(13593,'程岭乡','201',1078),(13594,'九姑乡','202',1078),(13595,'千岭乡','203',1078),(13596,'洲头乡','204',1078),(13597,'佐坝乡','205',1078),(13598,'北浴乡','206',1078),(13599,'陈汉乡','207',1078),(13600,'隘口乡','208',1078),(13601,'柳坪乡','209',1078),(13602,'趾凤乡','210',1078),(13603,'河塌乡','211',1078),(13604,'五里乡','212',1078),(13605,'九成监狱管理分局','400',1078),(13606,'华阳河农场总场','401',1078),(13607,'华阳镇','100',1079),(13608,'杨湾镇','101',1079),(13609,'漳湖镇','102',1079),(13610,'赛口镇','103',1079),(13611,'高士镇','104',1079),(13612,'鸦滩镇','105',1079),(13613,'长岭镇','106',1079),(13614,'太慈镇','107',1079),(13615,'凉泉乡','200',1079),(13616,'雷池乡','201',1079),(13617,'天堂镇','100',1080),(13618,'店前镇','101',1080),(13619,'来榜镇','102',1080),(13620,'菖蒲镇','103',1080),(13621,'头陀镇','104',1080),(13622,'白帽镇','105',1080),(13623,'温泉镇','106',1080),(13624,'响肠镇','107',1080),(13625,'河图镇','108',1080),(13626,'五河镇','109',1080),(13627,'主簿镇','110',1080),(13628,'冶溪镇','111',1080),(13629,'黄尾镇','112',1080),(13630,'毛尖山乡','200',1080),(13631,'莲云乡','201',1080),(13632,'青天乡','202',1080),(13633,'包家乡','203',1080),(13634,'古坊乡','204',1080),(13635,'田头乡','205',1080),(13636,'中关乡','206',1080),(13637,'石关乡','207',1080),(13638,'姚河乡','208',1080),(13639,'和平乡','209',1080),(13640,'巍岭乡','210',1080),(13641,'碧峰街道','001',1081),(13642,'南演街道','002',1081),(13643,'文昌街道','003',1081),(13644,'太平街道','004',1081),(13645,'高桥镇','100',1081),(13646,'吕亭镇','101',1081),(13647,'范岗镇','102',1081),(13648,'孔城镇','103',1081),(13649,'新渡镇','104',1081),(13650,'双港镇','105',1081),(13651,'卅铺镇','106',1081),(13652,'大关镇','107',1081),(13653,'陶冲镇','108',1081),(13654,'金神镇','109',1081),(13655,'兴店镇','110',1081),(13656,'香铺镇','111',1081),(13657,'青草镇','112',1081),(13658,'挂车河镇','113',1081),(13659,'嬉子湖镇','114',1081),(13660,'老梅镇','115',1081),(13661,'唐湾镇','116',1081),(13662,'鲟鱼镇','117',1081),(13663,'黄铺乡','200',1081),(13664,'大塘乡','201',1081),(13665,'龙眠乡','202',1081),(13666,'中义乡','203',1081),(13667,'民营经济开发区','400',1081),(13668,'昱东街道办事处','001',1083),(13669,'昱中街道办事处','002',1083),(13670,'昱西街道办事处','003',1083),(13671,'老街街道办事处','004',1083),(13672,'屯光镇','100',1083),(13673,'阳湖镇','101',1083),(13674,'黎阳镇','102',1083),(13675,'新潭镇','103',1083),(13676,'奕棋镇','104',1083),(13677,'茶林场','500',1083),(13678,'新城街道','001',1084),(13679,'甘棠镇','100',1084),(13680,'仙源镇','101',1084),(13681,'汤口镇','102',1084),(13682,'谭家桥镇','103',1084),(13683,'太平湖镇','104',1084),(13684,'焦村镇','105',1084),(13685,'耿城镇','106',1084),(13686,'三口镇','107',1084),(13687,'新明乡','200',1084),(13688,'龙门乡','201',1084),(13689,'乌石乡','202',1084),(13690,'新华乡','203',1084),(13691,'新丰乡','204',1084),(13692,'永丰乡','205',1084),(13693,'黄山风景区','450',1084),(13694,'徽州区街道工委会','001',1085),(13695,'岩寺镇','100',1085),(13696,'西溪南镇','101',1085),(13697,'潜口镇','102',1085),(13698,'呈坎镇','103',1085),(13699,'洽舍乡','200',1085),(13700,'杨村乡','201',1085),(13701,'富溪乡','202',1085),(13702,'徽城镇','100',1086),(13703,'深渡镇','101',1086),(13704,'北岸镇','102',1086),(13705,'富','103',1086),(13706,'郑村镇','104',1086),(13707,'桂林镇','105',1086),(13708,'许村镇','106',1086),(13709,'溪头镇','107',1086),(13710,'杞梓里镇','108',1086),(13711,'霞坑镇','109',1086),(13712,'岔口镇','110',1086),(13713,'街口镇','111',1086),(13714,'王村镇','112',1086),(13715,'坑口乡','200',1086),(13716,'雄村乡','201',1086),(13717,'上丰乡','202',1086),(13718,'昌溪乡','203',1086),(13719,'武阳乡','204',1086),(13720,'三阳乡','205',1086),(13721,'金川乡','206',1086),(13722,'小川乡','207',1086),(13723,'新溪口乡','208',1086),(13724,'璜田乡','209',1086),(13725,'长陔乡','210',1086),(13726,'森村乡','211',1086),(13727,'绍濂乡','212',1086),(13728,'石门乡','213',1086),(13729,'狮石乡','214',1086),(13730,'海阳镇','100',1087),(13731,'齐云山镇','101',1087),(13732,'万安镇','102',1087),(13733,'五城镇','103',1087),(13734,'东临溪镇','104',1087),(13735,'兰田镇','105',1087),(13736,'溪口镇','106',1087),(13737,'流口镇','107',1087),(13738,'汪村镇','108',1087),(13739,'商山乡','200',1087),(13740,'山斗乡','201',1087),(13741,'岭南乡','202',1087),(13742,'渭桥乡','203',1087),(13743,'板桥乡','204',1087),(13744,'陈霞乡','205',1087),(13745,'鹤城乡','206',1087),(13746,'源芳乡','207',1087),(13747,'榆村乡','208',1087),(13748,'龙田乡','209',1087),(13749,'璜尖乡','210',1087),(13750,'白际乡','211',1087),(13751,'碧阳镇','100',1088),(13752,'宏村镇','101',1088),(13753,'渔亭镇','102',1088),(13754,'西递镇','103',1088),(13755,'柯村乡','200',1088),(13756,'美溪乡','201',1088),(13757,'宏潭乡','202',1088),(13758,'洪星乡','203',1088),(13759,'祁山镇','100',1089),(13760,'小路口镇','101',1089),(13761,'金字牌镇','102',1089),(13762,'平里镇','103',1089),(13763,'历口镇','104',1089),(13764,'闪里镇','105',1089),(13765,'安凌镇','106',1089),(13766,'大坦乡','200',1089),(13767,'凫峰乡','201',1089),(13768,'柏溪乡','202',1089),(13769,'塔坊乡','203',1089),(13770,'祁红乡','204',1089),(13771,'溶口乡','205',1089),(13772,'芦溪乡','206',1089),(13773,'渚口乡','207',1089),(13774,'古溪乡','208',1089),(13775,'新安乡','209',1089),(13776,'箬坑乡','210',1089),(13777,'琅琊街道','001',1091),(13778,'东门街道','002',1091),(13779,'西门街道','003',1091),(13780,'南门街道','004',1091),(13781,'北门街道','005',1091),(13782,'清流街道','006',1091),(13783,'扬子街道','007',1091),(13784,'凤凰街道办事处（滁州市开发区）','008',1091),(13785,'南谯街道办事处','001',1092),(13786,'乌衣镇','100',1092),(13787,'沙河镇','101',1092),(13788,'章广镇','102',1092),(13789,'黄泥岗镇','103',1092),(13790,'珠龙镇','104',1092),(13791,'大柳镇','105',1092),(13792,'腰铺镇','106',1092),(13793,'大王镇','107',1092),(13794,'黄圩乡','200',1092),(13795,'汪郢乡','201',1092),(13796,'花山乡','202',1092),(13797,'城郊乡','203',1092),(13798,'施集乡','204',1092),(13799,'三官集乡','205',1092),(13800,'常山乡','206',1092),(13801,'皇甫乡','207',1092),(13802,'新安镇','100',1093),(13803,'半塔镇','101',1093),(13804,'水口镇','102',1093),(13805,'相官镇','103',1093),(13806,'汊河镇','104',1093),(13807,'大英镇','105',1093),(13808,'雷官镇','106',1093),(13809,'施官镇','107',1093),(13810,'三城乡','200',1093),(13811,'武集乡','201',1093),(13812,'独山乡','202',1093),(13813,'双塘乡','203',1093),(13814,'龙山乡','204',1093),(13815,'邵集乡','205',1093),(13816,'兴隆乡','206',1093),(13817,'杨郢乡','207',1093),(13818,'张山乡','208',1093),(13819,'舜山乡','209',1093),(13820,'襄河镇','100',1094),(13821,'古河镇','101',1094),(13822,'大墅镇','102',1094),(13823,'二郎口镇','103',1094),(13824,'武岗镇','104',1094),(13825,'马厂镇','105',1094),(13826,'石沛镇','106',1094),(13827,'章辉镇','107',1094),(13828,'西王镇','108',1094),(13829,'六镇镇','109',1094),(13830,'程家市乡','200',1094),(13831,'草庵乡','201',1094),(13832,'管坝乡','202',1094),(13833,'周岗乡','203',1094),(13834,'复兴乡','204',1094),(13835,'十字乡','205',1094),(13836,'陈浅乡','206',1094),(13837,'定城镇','100',1095),(13838,'炉桥镇','101',1095),(13839,'永康镇','102',1095),(13840,'吴圩镇','103',1095),(13841,'朱湾镇','104',1095),(13842,'张桥镇','105',1095),(13843,'藕塘镇','106',1095),(13844,'池河镇','107',1095),(13845,'连江镇','108',1095),(13846,'界牌集镇','109',1095),(13847,'仓镇','110',1095),(13848,'三和集镇','111',1095),(13849,'西卅店镇','112',1095),(13850,'岱山镇','113',1095),(13851,'桑涧镇','114',1095),(13852,'年家岗镇','115',1095),(13853,'程桥乡','200',1095),(13854,'东兴乡','201',1095),(13855,'斋朗乡','202',1095),(13856,'严桥乡','203',1095),(13857,'拂晓乡','204',1095),(13858,'天河乡','205',1095),(13859,'练铺乡','206',1095),(13860,'站岗乡','207',1095),(13861,'蒋集乡','208',1095),(13862,'九梓乡','209',1095),(13863,'能仁乡','210',1095),(13864,'靠山乡','211',1095),(13865,'青山乡','212',1095),(13866,'青洛乡','213',1095),(13867,'七里塘乡','214',1095),(13868,'二龙回族乡','215',1095),(13869,'仁和乡','216',1095),(13870,'朱马乡','217',1095),(13871,'大桥乡','218',1095),(13872,'范岗乡','219',1095),(13873,'高塘乡','220',1095),(13874,'府城镇','100',1096),(13875,'临淮镇','101',1096),(13876,'门台子镇','102',1096),(13877,'武店镇','103',1096),(13878,'西泉镇','104',1096),(13879,'刘府镇','105',1096),(13880,'大庙镇','106',1096),(13881,'殷涧镇','107',1096),(13882,'黄泥铺镇','108',1096),(13883,'总铺镇','109',1096),(13884,'红心镇','110',1096),(13885,'板桥镇','111',1096),(13886,'大溪河镇','112',1096),(13887,'石门山镇','113',1096),(13888,'小溪河镇','114',1096),(13889,'曹店乡','200',1096),(13890,'亮岗乡','201',1096),(13891,'周圩乡','202',1096),(13892,'城西乡','203',1096),(13893,'官塘乡','204',1096),(13894,'官沟乡','205',1096),(13895,'二铺乡','206',1096),(13896,'黄湾乡','207',1096),(13897,'枣巷渔业乡','208',1096),(13898,'燃灯乡','209',1096),(13899,'梅市乡','210',1096),(13900,'天长街道','001',1097),(13901,'城南街道','002',1097),(13902,'永丰街道','003',1097),(13903,'桥湾街道','004',1097),(13904,'铜城镇','100',1097),(13905,'汊涧镇','101',1097),(13906,'秦栏镇','102',1097),(13907,'大通镇','103',1097),(13908,'杨村镇','104',1097),(13909,'石梁镇','105',1097),(13910,'金集镇','106',1097),(13911,'安乐镇','107',1097),(13912,'仁和集镇','108',1097),(13913,'冶山镇','109',1097),(13914,'郑集镇','110',1097),(13915,'张铺镇','111',1097),(13916,'界牌镇','112',1097),(13917,'平安镇','113',1097),(13918,'釜山镇','114',1097),(13919,'高庙集镇','115',1097),(13920,'新街乡','200',1097),(13921,'龙集乡','201',1097),(13922,'谕兴乡','202',1097),(13923,'十八集乡','203',1097),(13924,'芦龙乡','204',1097),(13925,'万寿乡','205',1097),(13926,'便益乡','206',1097),(13927,'关塘集乡','207',1097),(13928,'城东新区','400',1097),(13929,'城西街道办事处','001',1098),(13930,'招信镇','100',1098),(13931,'张八岭镇','101',1098),(13932,'三界镇','102',1098),(13933,'管店镇','103',1098),(13934,'自来桥镇','104',1098),(13935,'涧溪镇','105',1098),(13936,'石坝镇','106',1098),(13937,'津里镇','107',1098),(13938,'苏巷镇','108',1098),(13939,'桥头镇','109',1098),(13940,'女山湖镇','110',1098),(13941,'古沛镇','111',1098),(13942,'潘村镇','112',1098),(13943,'嘉山集乡','200',1098),(13944,'涝口乡','201',1098),(13945,'鲁山乡','202',1098),(13946,'横山乡','203',1098),(13947,'三关乡','204',1098),(13948,'马岗乡','205',1098),(13949,'明东乡','206',1098),(13950,'司巷乡','207',1098),(13951,'邵岗乡','208',1098),(13952,'紫阳乡','209',1098),(13953,'太平乡','210',1098),(13954,'柳巷乡','211',1098),(13955,'泊岗乡','212',1098),(13956,'鼓楼街道办事处','001',1100),(13957,'文峰街道办事处','002',1100),(13958,'清河街道办事处','003',1100),(13959,'颍西街道办事处','004',1100),(13960,'西湖景区街道办事处','005',1100),(13961,'阜阳开发区京九办事处','006',1100),(13962,'王店镇','100',1100),(13963,'程集镇','101',1100),(13964,'三合镇','102',1100),(13965,'西湖镇','103',1100),(13966,'九龙镇','104',1100),(13967,'三十里铺镇','105',1100),(13968,'袁集镇','106',1100),(13969,'马寨乡','200',1100),(13970,'河东街道办事处','001',1101),(13971,'新华街道办事处','002',1101),(13972,'向阳街道办事处','003',1101),(13973,'口孜镇','100',1101),(13974,'插花镇','101',1101),(13975,'袁寨镇','102',1101),(13976,'枣庄镇','103',1101),(13977,'老庙镇','104',1101),(13978,'正午镇','105',1101),(13979,'杨楼孜镇','106',1101),(13980,'新乌江镇','107',1101),(13981,'冉庙乡','200',1101),(13982,'中市街道办事处','001',1102),(13983,'周棚街道办事处','002',1102),(13984,'伍明镇','100',1102),(13985,'宁老庄镇','101',1102),(13986,'闻集镇','102',1102),(13987,'行流镇','103',1102),(13988,'城关镇','100',1103),(13989,'杨桥镇','101',1103),(13990,'同城镇','102',1103),(13991,'谭棚镇','103',1103),(13992,'老集镇','104',1103),(13993,'滑集镇','105',1103),(13994,'吕寨镇','106',1103),(13995,'单桥镇','107',1103),(13996,'长官镇','108',1103),(13997,'宋集镇','109',1103),(13998,'张新镇','110',1103),(13999,'艾亭镇','111',1103),(14000,'陈集镇','112',1103),(14001,'韦寨镇','113',1103),(14002,'迎仙镇','114',1103),(14003,'瓦店镇','115',1103),(14004,'姜寨镇','116',1103),(14005,'庙岔镇','117',1103),(14006,'黄岭镇','118',1103),(14007,'白庙镇','119',1103),(14008,'关庙镇','120',1103),(14009,'临泉工业园区','121',1103),(14010,'牛庄乡','200',1103),(14011,'高塘乡','201',1103),(14012,'范兴集乡','202',1103),(14013,'土陂乡','203',1103),(14014,'谢集乡','204',1103),(14015,'杨小街乡','205',1103),(14016,'陶老乡','206',1103),(14017,'田桥乡','207',1103),(14018,'张营乡','208',1103),(14019,'庞营乡','209',1103),(14020,'城关镇','100',1104),(14021,'旧县镇','101',1104),(14022,'税镇镇','102',1104),(14023,'皮条孙镇','103',1104),(14024,'原墙镇','104',1104),(14025,'倪邱镇','105',1104),(14026,'李兴镇','106',1104),(14027,'大新镇','107',1104),(14028,'肖口镇','108',1104),(14029,'关集镇','109',1104),(14030,'三塔镇','110',1104),(14031,'双浮镇','111',1104),(14032,'蔡庙镇','112',1104),(14033,'三堂镇','113',1104),(14034,'苗老集镇','114',1104),(14035,'赵庙镇','115',1104),(14036,'宫集镇','116',1104),(14037,'坟台镇','117',1104),(14038,'洪山镇','118',1104),(14039,'清浅镇','119',1104),(14040,'五星镇','120',1104),(14041,'高庙镇','121',1104),(14042,'桑郢镇','122',1104),(14043,'大庙集镇','123',1104),(14044,'阮桥镇','124',1104),(14045,'双庙镇','125',1104),(14046,'胡总乡','200',1104),(14047,'赵集乡','201',1104),(14048,'郭庙乡','202',1104),(14049,'马集乡','203',1104),(14050,'二郎乡','204',1104),(14051,'城关镇','100',1105),(14052,'方集镇','101',1105),(14053,'中岗镇','102',1105),(14054,'柴集镇','103',1105),(14055,'新村镇','104',1105),(14056,'三塔镇','105',1105),(14057,'朱寨镇','106',1105),(14058,'柳沟镇','107',1105),(14059,'赵集镇','108',1105),(14060,'田集镇','109',1105),(14061,'苗集镇','110',1105),(14062,'黄岗镇','111',1105),(14063,'焦陂镇','112',1105),(14064,'张寨镇','113',1105),(14065,'王堰镇','114',1105),(14066,'地城镇','115',1105),(14067,'洪河桥镇','116',1105),(14068,'王家坝镇','117',1105),(14069,'王化镇','118',1105),(14070,'曹集镇','119',1105),(14071,'王店孜乡','200',1105),(14072,'许堂乡','201',1105),(14073,'会龙乡','202',1105),(14074,'城郊乡','203',1105),(14075,'段郢乡','204',1105),(14076,'公桥乡','205',1105),(14077,'龙王乡','206',1105),(14078,'于集乡','207',1105),(14079,'老观乡','208',1105),(14080,'郜台乡','209',1105),(14081,'阜蒙农场','450',1105),(14082,'慎城镇','100',1106),(14083,'谢桥镇','101',1106),(14084,'南照镇','102',1106),(14085,'杨湖镇','103',1106),(14086,'江口镇','104',1106),(14087,'润河镇','105',1106),(14088,'新集镇','106',1106),(14089,'六十铺镇','107',1106),(14090,'耿棚镇','108',1106),(14091,'半岗镇','109',1106),(14092,'王岗镇','110',1106),(14093,'夏桥镇','111',1106),(14094,'江店孜镇','112',1106),(14095,'陈桥镇','113',1106),(14096,'黄桥镇','114',1106),(14097,'八里河镇','115',1106),(14098,'汤店镇','116',1106),(14099,'西三十铺镇','117',1106),(14100,'红星镇','118',1106),(14101,'十八里铺镇','119',1106),(14102,'鲁口镇','120',1106),(14103,'建颍乡','200',1106),(14104,'五十铺乡','201',1106),(14105,'盛堂乡','202',1106),(14106,'关屯乡','203',1106),(14107,'垂岗乡','204',1106),(14108,'赛涧回族乡','205',1106),(14109,'刘集乡','206',1106),(14110,'黄坝乡','207',1106),(14111,'古城乡','208',1106),(14112,'东城办事处','001',1107),(14113,'西城办事处','002',1107),(14114,'颖南办事处','003',1107),(14115,'光武镇','100',1107),(14116,'泉阳镇','101',1107),(14117,'芦村镇','102',1107),(14118,'新马集镇','103',1107),(14119,'大黄镇','104',1107),(14120,'田营镇','105',1107),(14121,'陶庙镇','106',1107),(14122,'王集镇','107',1107),(14123,'砖集镇','108',1107),(14124,'顾集镇','109',1107),(14125,'代桥镇','110',1107),(14126,'舒庄镇','111',1107),(14127,'邴集乡','200',1107),(14128,'靳寨乡','201',1107),(14129,'任寨乡','202',1107),(14130,'沱河街道','002',1109),(14131,'道东街道','003',1109),(14132,'东关街道','004',1109),(14133,'三里湾街道','005',1109),(14134,'南关街道','006',1109),(14135,'西关街道','007',1109),(14136,'北关街道','008',1109),(14137,'汴河街道','009',1109),(14138,'三八街道','010',1109),(14139,'城东街道','011',1109),(14140,'符离镇','100',1109),(14141,'芦岭镇','101',1109),(14142,'朱仙庄镇','102',1109),(14143,'褚兰镇','103',1109),(14144,'曹村镇','104',1109),(14145,'夹沟镇','105',1109),(14146,'栏杆镇','106',1109),(14147,'时村镇','107',1109),(14148,'永安镇','108',1109),(14149,'灰古镇','109',1109),(14150,'大店镇','110',1109),(14151,'西寺坡镇','111',1109),(14152,'桃园镇','112',1109),(14153,'蕲县镇','113',1109),(14154,'大营镇','114',1109),(14155,'杨庄乡','200',1109),(14156,'支河乡','201',1109),(14157,'解集乡','202',1109),(14158,'桃沟乡','203',1109),(14159,'顺河乡','204',1109),(14160,'蒿沟乡','205',1109),(14161,'苗安乡','206',1109),(14162,'永镇乡','207',1109),(14163,'西二铺乡','208',1109),(14164,'宿州经济技术开发区','450',1109),(14165,'砀城镇','100',1110),(14166,'西南门镇','101',1110),(14167,'李庄镇','102',1110),(14168,'唐寨镇','103',1110),(14169,'葛集镇','104',1110),(14170,'周寨镇','105',1110),(14171,'玄庙镇','106',1110),(14172,'官庄坝镇','107',1110),(14173,'曹庄镇','108',1110),(14174,'关帝庙镇','109',1110),(14175,'朱楼镇','110',1110),(14176,'文庄镇','111',1110),(14177,'程庄镇','112',1110),(14178,'良梨镇','113',1110),(14179,'黄楼乡','200',1110),(14180,'权集乡','201',1110),(14181,'刘暗楼乡','202',1110),(14182,'赵屯乡','203',1110),(14183,'经济开发区','400',1110),(14184,'龙城镇','100',1111),(14185,'黄口镇','101',1111),(14186,'杨楼镇','102',1111),(14187,'闫集镇','103',1111),(14188,'新庄镇','104',1111),(14189,'刘套镇','105',1111),(14190,'马井镇','106',1111),(14191,'大屯镇','107',1111),(14192,'赵庄镇','108',1111),(14193,'杜楼镇','109',1111),(14194,'丁里镇','110',1111),(14195,'王寨镇','111',1111),(14196,'祖楼镇','112',1111),(14197,'青龙镇','113',1111),(14198,'张庄寨镇','114',1111),(14199,'永','115',1111),(14200,'白土镇','116',1111),(14201,'官桥镇','117',1111),(14202,'圣泉乡','200',1111),(14203,'酒店乡','201',1111),(14204,'孙圩孜乡','202',1111),(14205,'庄里乡','203',1111),(14206,'石林乡','204',1111),(14207,'灵城镇','100',1112),(14208,'韦集镇','101',1112),(14209,'黄湾镇','102',1112),(14210,'娄庄镇','103',1112),(14211,'杨疃镇','104',1112),(14212,'尹集镇','105',1112),(14213,'浍沟镇','106',1112),(14214,'尤集镇','107',1112),(14215,'夏楼镇','108',1112),(14216,'朝阳镇','109',1112),(14217,'渔沟镇','110',1112),(14218,'高楼镇','111',1112),(14219,'冯庙镇','112',1112),(14220,'向阳乡','200',1112),(14221,'朱集乡','201',1112),(14222,'大路乡','202',1112),(14223,'大庙乡','203',1112),(14224,'禅堂乡','204',1112),(14225,'虞姬乡','205',1112),(14226,'工业园区','400',1112),(14227,'泗城镇','100',1113),(14228,'墩集镇','101',1113),(14229,'丁湖镇','102',1113),(14230,'草沟镇','103',1113),(14231,'长沟镇','104',1113),(14232,'黄圩镇','105',1113),(14233,'大庄镇','106',1113),(14234,'山头镇','107',1113),(14235,'刘圩镇','108',1113),(14236,'黑塔镇','109',1113),(14237,'草庙镇','110',1113),(14238,'屏山镇','111',1113),(14239,'大路口乡','200',1113),(14240,'大杨乡','201',1113),(14241,'瓦坊乡','202',1113),(14242,'泗县开发区管委会','400',1113),(14243,'中庙街道办事处','001',1115),(14244,'亚父街道办事处','002',1115),(14245,'卧牛山街道办事处','003',1115),(14246,'凤凰山街道办事处','004',1115),(14247,'天河街道办事处','005',1115),(14248,'半汤街道办事处市开发区','006',1115),(14249,'栏杆集镇','100',1115),(14250,'苏湾镇','101',1115),(14251,'柘皋镇','102',1115),(14252,'银屏镇','103',1115),(14253,'夏阁镇','104',1115),(14254,'中','105',1115),(14255,'散兵镇','106',1115),(14256,'黄麓镇','108',1115),(14257,'槐林镇','109',1115),(14258,'坝镇镇','110',1115),(14259,'庙岗乡','200',1115),(14260,'庐城镇','100',1116),(14261,'冶父山镇','101',1116),(14262,'万山镇','102',1116),(14263,'汤池镇','103',1116),(14264,'郭河镇','104',1116),(14265,'金牛镇','105',1116),(14266,'石头镇','106',1116),(14267,'同大镇','107',1116),(14268,'白山镇','108',1116),(14269,'盛桥镇','109',1116),(14270,'白湖镇','110',1116),(14271,'龙桥镇','111',1116),(14272,'矾山镇','112',1116),(14273,'罗河镇','113',1116),(14274,'泥河镇','114',1116),(14275,'乐桥镇','115',1116),(14276,'柯坦镇','116',1116),(14277,'安徽庐江经济开发区','400',1116),(14278,'安徽省白湖监狱管理分局','401',1116),(14279,'安徽省白湖阀门厂有限公司','402',1116),(14280,'安徽省罪犯技术培训中心','403',1116),(14281,'无城镇','100',1117),(14282,'襄安镇','101',1117),(14283,'二坝镇','102',1117),(14284,'汤沟镇','103',1117),(14285,'陡沟镇','104',1117),(14286,'石涧镇','105',1117),(14287,'严桥镇','106',1117),(14288,'开城镇','107',1117),(14289,'蜀山镇','108',1117),(14290,'牛埠镇','109',1117),(14291,'刘渡镇','110',1117),(14292,'姚沟镇','111',1117),(14293,'泥汊镇','112',1117),(14294,'白茆镇','113',1117),(14295,'福渡镇','114',1117),(14296,'泉塘镇','115',1117),(14297,'赫店镇','116',1117),(14298,'红庙镇','117',1117),(14299,'高沟镇','118',1117),(14300,'鹤毛乡','200',1117),(14301,'十里墩乡','201',1117),(14302,'昆山乡','202',1117),(14303,'洪巷乡','203',1117),(14304,'环峰镇','100',1118),(14305,'运漕镇','101',1118),(14306,'铜闸镇','102',1118),(14307,'陶厂镇','103',1118),(14308,'林头镇','104',1118),(14309,'清溪镇','105',1118),(14310,'仙踪镇','106',1118),(14311,'昭关镇','107',1118),(14312,'历阳镇','100',1119),(14313,'沈巷镇','101',1119),(14314,'白桥镇','102',1119),(14315,'姥桥镇','103',1119),(14316,'功桥镇','104',1119),(14317,'西埠镇','105',1119),(14318,'香泉镇','106',1119),(14319,'乌江镇','107',1119),(14320,'善厚镇','108',1119),(14321,'石杨镇','109',1119),(14322,'中市街道','001',1121),(14323,'东市街道','002',1121),(14324,'三里桥街道','003',1121),(14325,'望城街道','004',1121),(14326,'清水河街道','005',1121),(14327,'木厂镇','100',1121),(14328,'马头镇','101',1121),(14329,'东桥镇','102',1121),(14330,'张店镇','103',1121),(14331,'毛坦厂镇','104',1121),(14332,'东河口镇','105',1121),(14333,'双河镇','106',1121),(14334,'施桥镇','107',1121),(14335,'孙岗镇','108',1121),(14336,'三十铺镇','109',1121),(14337,'椿树镇','110',1121),(14338,'城北乡','200',1121),(14339,'翁墩乡','201',1121),(14340,'淠东乡','202',1121),(14341,'中店乡','203',1121),(14342,'横塘岗乡','204',1121),(14343,'先生店乡','205',1121),(14344,'六安经济开发区','400',1121),(14345,'鼓楼街道','001',1122),(14346,'西市街道','002',1122),(14347,'小华山街道','003',1122),(14348,'苏埠镇','100',1122),(14349,'韩摆渡镇','101',1122),(14350,'新安镇','102',1122),(14351,'顺河镇','103',1122),(14352,'独山镇','104',1122),(14353,'石婆店镇','105',1122),(14354,'城南镇','106',1122),(14355,'丁集镇','107',1122),(14356,'固镇镇','108',1122),(14357,'徐集镇','109',1122),(14358,'分路口镇','110',1122),(14359,'江家店镇','111',1122),(14360,'单王乡','200',1122),(14361,'青山乡','201',1122),(14362,'石板冲乡','202',1122),(14363,'西河口乡','203',1122),(14364,'平桥乡','204',1122),(14365,'罗集乡','205',1122),(14366,'狮子岗乡','206',1122),(14367,'寿春镇','100',1123),(14368,'双桥镇','101',1123),(14369,'涧沟镇','102',1123),(14370,'丰庄镇','103',1123),(14371,'正阳关镇','104',1123),(14372,'迎河镇','105',1123),(14373,'板桥镇','106',1123),(14374,'安丰塘镇','107',1123),(14375,'堰口镇','108',1123),(14376,'保义镇','109',1123),(14377,'隐贤镇','110',1123),(14378,'安丰镇','111',1123),(14379,'众兴镇','112',1123),(14380,'茶庵镇','113',1123),(14381,'三觉镇','114',1123),(14382,'炎刘镇','115',1123),(14383,'刘岗镇','116',1123),(14384,'双庙集镇','117',1123),(14385,'小甸镇','118',1123),(14386,'瓦埠镇','119',1123),(14387,'大顺镇','120',1123),(14388,'八公山乡','200',1123),(14389,'张李乡','201',1123),(14390,'窑口乡','202',1123),(14391,'陶店回族乡','203',1123),(14392,'寿西湖农场','400',1123),(14393,'城关镇','100',1124),(14394,'河口镇','101',1124),(14395,'周集镇','102',1124),(14396,'临水镇','103',1124),(14397,'新店镇','104',1124),(14398,'石店镇','105',1124),(14399,'马店镇','106',1124),(14400,'孟集镇','107',1124),(14401,'花园镇','108',1124),(14402,'扈胡镇','109',1124),(14403,'长集镇','110',1124),(14404,'洪集镇','111',1124),(14405,'姚李镇','112',1124),(14406,'乌龙镇','113',1124),(14407,'高塘镇','114',1124),(14408,'龙潭镇','115',1124),(14409,'岔路镇','116',1124),(14410,'冯井镇','117',1124),(14411,'众兴集镇','118',1124),(14412,'夏店镇','119',1124),(14413,'曹庙镇','120',1124),(14414,'叶集区叶集镇','121',1124),(14415,'彭塔乡','200',1124),(14416,'王截流乡','201',1124),(14417,'范桥乡','202',1124),(14418,'临淮岗乡','203',1124),(14419,'城西湖乡','204',1124),(14420,'宋店乡','205',1124),(14421,'三流乡','206',1124),(14422,'邵岗乡','207',1124),(14423,'白莲乡','208',1124),(14424,'潘集乡','209',1124),(14425,'冯瓴乡','210',1124),(14426,'叶集区孙岗乡','211',1124),(14427,'叶集区三元乡','212',1124),(14428,'城关镇','100',1125),(14429,'晓天镇','101',1125),(14430,'桃溪镇','102',1125),(14431,'万佛湖镇','103',1125),(14432,'千人桥镇','104',1125),(14433,'百神庙镇','105',1125),(14434,'杭埠镇','106',1125),(14435,'舒茶镇','107',1125),(14436,'南港镇','108',1125),(14437,'干汊河镇','109',1125),(14438,'张母桥镇','110',1125),(14439,'五显镇','111',1125),(14440,'山七镇','112',1125),(14441,'河棚镇','113',1125),(14442,'汤池镇','114',1125),(14443,'春秋乡','200',1125),(14444,'柏林乡','201',1125),(14445,'棠树乡','202',1125),(14446,'阙店乡','203',1125),(14447,'高峰乡','204',1125),(14448,'庐镇乡','205',1125),(14449,'梅山镇','100',1126),(14450,'响洪甸镇(含响齐办事处)','101',1126),(14451,'青山镇','102',1126),(14452,'燕子河镇','103',1126),(14453,'天堂寨镇','104',1126),(14454,'古碑镇','105',1126),(14455,'吴家店镇','106',1126),(14456,'斑竹园镇','107',1126),(14457,'汤家汇镇','108',1126),(14458,'南溪镇','109',1126),(14459,'双河镇','110',1126),(14460,'白塔畈乡','200',1126),(14461,'张冲乡','201',1126),(14462,'油坊店乡','202',1126),(14463,'长岭乡','203',1126),(14464,'槐树湾乡','204',1126),(14465,'花石乡','205',1126),(14466,'沙河乡','206',1126),(14467,'桃岭乡','207',1126),(14468,'果子园乡','208',1126),(14469,'关庙乡','209',1126),(14470,'银山畈乡','210',1126),(14471,'全军乡','211',1126),(14472,'张畈乡','212',1126),(14473,'水竹坪乡','213',1126),(14474,'铁冲乡','214',1126),(14475,'衡山镇','100',1127),(14476,'佛子岭镇','101',1127),(14477,'下符桥镇','102',1127),(14478,'但家庙镇','103',1127),(14479,'与儿街镇','104',1127),(14480,'黑石渡镇','105',1127),(14481,'诸佛庵镇','106',1127),(14482,'落儿岭镇','107',1127),(14483,'磨子潭镇','108',1127),(14484,'大化坪镇','109',1127),(14485,'漫水河镇','110',1127),(14486,'上士市镇','111',1127),(14487,'单龙寺乡','200',1127),(14488,'东西溪乡','201',1127),(14489,'太平畈乡','202',1127),(14490,'太阳乡','203',1127),(14491,'花戏楼办事处','001',1129),(14492,'薛阁办事处','002',1129),(14493,'汤陵办事处','003',1129),(14494,'古井镇','100',1129),(14495,'芦庙镇','101',1129),(14496,'华佗镇','102',1129),(14497,'魏岗镇','103',1129),(14498,'牛集镇','104',1129),(14499,'颜集镇','105',1129),(14500,'五马镇','106',1129),(14501,'十八里镇','107',1129),(14502,'谯东镇','108',1129),(14503,'十九里镇','109',1129),(14504,'沙土镇','110',1129),(14505,'观堂镇','111',1129),(14506,'大杨镇','112',1129),(14507,'城父镇','113',1129),(14508,'十河镇','114',1129),(14509,'双沟镇','115',1129),(14510,'淝河镇','116',1129),(14511,'古城镇','117',1129),(14512,'龙扬镇','118',1129),(14513,'立德镇','119',1129),(14514,'张店乡','200',1129),(14515,'赵桥乡','201',1129),(14516,'亳州市经济技术开发区','400',1129),(14517,'王大庄良种试验示范场','500',1129),(14518,'羊种改良站','501',1129),(14519,'城关镇','100',1130),(14520,'城西镇','101',1130),(14521,'城东镇','102',1130),(14522,'西阳镇','103',1130),(14523,'双庙镇','104',1130),(14524,'楚店镇','105',1130),(14525,'高公镇','106',1130),(14526,'闸北镇','107',1130),(14527,'高炉镇','108',1130),(14528,'曹市镇','109',1130),(14529,'青町镇','110',1130),(14530,'石弓镇','111',1130),(14531,'龙山镇','112',1130),(14532,'义门镇','113',1130),(14533,'新兴镇','114',1130),(14534,'临湖镇','115',1130),(14535,'丹城镇','116',1130),(14536,'马店集镇','117',1130),(14537,'花沟镇','118',1130),(14538,'店集镇','119',1130),(14539,'陈大镇','120',1130),(14540,'牌坊镇','121',1130),(14541,'公吉寺镇','122',1130),(14542,'标里镇','123',1130),(14543,'张老家乡','200',1130),(14544,'耿皇乡','201',1130),(14545,'单集林场','500',1130),(14546,'城关镇','100',1131),(14547,'双涧镇','101',1131),(14548,'小涧镇','102',1131),(14549,'漆园办事处','103',1131),(14550,'坛城镇','104',1131),(14551,'范集工业园区','105',1131),(14552,'许町镇','106',1131),(14553,'板桥集镇','107',1131),(14554,'马集镇','108',1131),(14555,'岳坊镇','109',1131),(14556,'立仓镇','110',1131),(14557,'楚村镇','111',1131),(14558,'乐土镇','112',1131),(14559,'三义镇','113',1131),(14560,'篱笆镇','114',1131),(14561,'庄周办事处','200',1131),(14562,'王集乡','201',1131),(14563,'小辛集乡','202',1131),(14564,'白杨林场','500',1131),(14565,'城关镇','100',1132),(14566,'阚疃镇','101',1132),(14567,'张村镇','102',1132),(14568,'江集镇','103',1132),(14569,'旧城镇','104',1132),(14570,'西潘楼镇','105',1132),(14571,'孙集镇','106',1132),(14572,'汝集镇','107',1132),(14573,'巩店镇','108',1132),(14574,'王人镇','109',1132),(14575,'王市镇','110',1132),(14576,'永兴镇','111',1132),(14577,'马店镇','112',1132),(14578,'大李集镇','113',1132),(14579,'胡集镇','114',1132),(14580,'展沟镇','115',1132),(14581,'程家集镇','116',1132),(14582,'中疃镇','117',1132),(14583,'望疃镇','118',1132),(14584,'双桥乡','200',1132),(14585,'春店乡','201',1132),(14586,'刘家集乡','202',1132),(14587,'纪王场乡','203',1132),(14588,'孙庙乡','204',1132),(14589,'新张集乡','205',1132),(14590,'丹凤乡','206',1132),(14591,'安徽省阜阳市柴湖良种繁殖场','500',1132),(14592,'池阳街道办事处','001',1134),(14593,'秋浦街道办事处','002',1134),(14594,'里山街道办事处','003',1134),(14595,'江口街道办事处','004',1134),(14596,'殷汇镇','100',1134),(14597,'牛头山镇','101',1134),(14598,'涓桥镇','102',1134),(14599,'马衙镇','103',1134),(14600,'墩上镇','104',1134),(14601,'梅龙镇','105',1134),(14602,'梅街镇','106',1134),(14603,'观前镇','107',1134),(14604,'梅村镇','108',1134),(14605,'唐田镇','109',1134),(14606,'牌楼镇','110',1134),(14607,'乌沙镇','111',1134),(14608,'晏塘镇','112',1134),(14609,'阮桥乡','200',1134),(14610,'高脊岭乡','201',1134),(14611,'木闸乡','202',1134),(14612,'高坦乡','203',1134),(14613,'棠溪乡','204',1134),(14614,'刘街乡','205',1134),(14615,'解放乡','206',1134),(14616,'茅坦乡','207',1134),(14617,'池州市开发区','400',1134),(14618,'尧渡镇','100',1135),(14619,'东流镇','101',1135),(14620,'大渡口镇','102',1135),(14621,'胜利镇','103',1135),(14622,'张溪镇','104',1135),(14623,'洋湖镇','105',1135),(14624,'葛公镇','106',1135),(14625,'香隅镇','107',1135),(14626,'官港镇','108',1135),(14627,'昭潭镇','109',1135),(14628,'龙泉镇','110',1135),(14629,'瓦垄乡','200',1135),(14630,'白笏乡','201',1135),(14631,'坦埠乡','202',1135),(14632,'汪坡乡','203',1135),(14633,'高山乡','204',1135),(14634,'洪方乡','205',1135),(14635,'查桥乡','206',1135),(14636,'七里湖乡','207',1135),(14637,'建新乡','208',1135),(14638,'花园里乡','209',1135),(14639,'马坑乡','210',1135),(14640,'利安乡','211',1135),(14641,'木塔乡','212',1135),(14642,'石城乡','213',1135),(14643,'泥溪乡','214',1135),(14644,'西湾乡','215',1135),(14645,'青山乡','216',1135),(14646,'铁炉乡','217',1135),(14647,'七里镇','100',1136),(14648,'七都镇','101',1136),(14649,'占大镇','102',1136),(14650,'丁香镇','103',1136),(14651,'小河镇','104',1136),(14652,'横渡镇','105',1136),(14653,'六都乡','200',1136),(14654,'七井乡','201',1136),(14655,'珂田乡','202',1136),(14656,'大演乡','203',1136),(14657,'贡溪乡','204',1136),(14658,'矶滩乡','205',1136),(14659,'莘田乡','206',1136),(14660,'蓉城镇','100',1137),(14661,'木镇镇','101',1137),(14662,'庙前镇　','102',1137),(14663,'陵阳镇','103',1137),(14664,'新河镇','104',1137),(14665,'丁桥镇','105',1137),(14666,'朱备镇','106',1137),(14667,'杨田镇　','107',1137),(14668,'九华镇','108',1137),(14669,'乔木乡','200',1137),(14670,'酉华乡','201',1137),(14671,'杜村乡','202',1137),(14672,'九华乡','203',1137),(14673,'西林街道办事处','001',1139),(14674,'澄江街道办事处','002',1139),(14675,'鳌峰街道办事处','003',1139),(14676,'济川街道办事处','004',1139),(14677,'敬亭山街道办事处','005',1139),(14678,'飞彩街道办事处','006',1139),(14679,'双桥街道办事处','007',1139),(14680,'水阳镇','100',1139),(14681,'狸桥镇','101',1139),(14682,'沈村镇','102',1139),(14683,'古泉镇','103',1139),(14684,'洪林镇','104',1139),(14685,'寒亭镇','105',1139),(14686,'文昌镇','106',1139),(14687,'孙埠镇','107',1139),(14688,'向阳镇','108',1139),(14689,'杨柳镇','109',1139),(14690,'水东镇','110',1139),(14691,'新田镇','111',1139),(14692,'周王镇','112',1139),(14693,'溪口镇','113',1139),(14694,'朱桥乡','200',1139),(14695,'养贤乡','201',1139),(14696,'五星乡','202',1139),(14697,'金坝乡','203',1139),(14698,'黄渡乡','204',1139),(14699,'建平镇','100',1140),(14700,'十字镇','101',1140),(14701,'新发镇','102',1140),(14702,'涛城镇','103',1140),(14703,'南丰镇','104',1140),(14704,'梅渚镇','105',1140),(14705,'东夏镇','106',1140),(14706,'毕桥镇','107',1140),(14707,'凌笪乡','200',1140),(14708,'飞里乡','201',1140),(14709,'姚村乡','202',1140),(14710,'幸福乡','203',1140),(14711,'十字茶业总公司','500',1140),(14712,'桃州镇','100',1141),(14713,'柏垫镇','101',1141),(14714,'誓节镇','102',1141),(14715,'邱村镇','103',1141),(14716,'新杭镇','104',1141),(14717,'卢村乡','200',1141),(14718,'东亭乡','201',1141),(14719,'杨滩乡','202',1141),(14720,'四合乡','203',1141),(14721,'经济开发区','400',1141),(14722,'祠山岗茶场','500',1141),(14723,'泾川镇','100',1142),(14724,'茂林镇','101',1142),(14725,'榔桥镇','102',1142),(14726,'桃花潭镇','103',1142),(14727,'琴溪镇','104',1142),(14728,'蔡村镇','105',1142),(14729,'云岭镇','106',1142),(14730,'黄村镇','107',1142),(14731,'丁家桥镇','108',1142),(14732,'汀溪乡','200',1142),(14733,'昌桥乡','201',1142),(14734,'华阳镇','100',1143),(14735,'临溪镇','101',1143),(14736,'长安镇','102',1143),(14737,'上庄镇','103',1143),(14738,'扬溪镇','104',1143),(14739,'伏岭镇','105',1143),(14740,'金沙镇','106',1143),(14741,'瀛洲乡','200',1143),(14742,'板桥头乡','201',1143),(14743,'家朋乡','202',1143),(14744,'荆州乡','203',1143),(14745,'旌阳镇','100',1144),(14746,'蔡家桥镇','101',1144),(14747,'三溪镇','102',1144),(14748,'庙首镇','103',1144),(14749,'白地镇','104',1144),(14750,'版书乡','200',1144),(14751,'俞村乡','201',1144),(14752,'云乐乡','202',1144),(14753,'兴隆乡','203',1144),(14754,'孙村乡','204',1144),(14755,'西津街道','001',1145),(14756,'南山街道','002',1145),(14757,'河沥街道','003',1145),(14758,'汪溪街道','004',1145),(14759,'竹峰街道','005',1145),(14760,'天湖街道','006',1145),(14761,'港口镇','100',1145),(14762,'梅林镇','101',1145),(14763,'中溪镇','102',1145),(14764,'宁墩镇','103',1145),(14765,'仙霞镇','104',1145),(14766,'甲路镇','105',1145),(14767,'胡乐镇','106',1145),(14768,'霞西镇','107',1145),(14769,'云梯畲族乡','200',1145),(14770,'南极乡','201',1145),(14771,'万家乡','202',1145),(14772,'青龙乡','203',1145),(14773,'方塘乡','204',1145),(14774,'鼓东街道','001',1147),(14775,'鼓西街道','002',1147),(14776,'温泉街道','003',1147),(14777,'东街街道','004',1147),(14778,'南街街道','005',1147),(14779,'安泰街道','006',1147),(14780,'华大街道','007',1147),(14781,'水部街道','008',1147),(14782,'五凤街道','009',1147),(14783,'洪山镇','100',1147),(14784,'瀛洲街道','001',1148),(14785,'后洲街道','002',1148),(14786,'义洲街道','003',1148),(14787,'新港街道','004',1148),(14788,'上海街道','005',1148),(14789,'苍霞街道','007',1148),(14790,'茶亭街道','009',1148),(14791,'洋中街道','010',1148),(14792,'鳌峰街道','011',1148),(14793,'宁化街道','012',1148),(14794,'仓前街道','001',1149),(14795,'东升街道','002',1149),(14796,'对湖街道','003',1149),(14797,'临江街道','004',1149),(14798,'三叉街街道','005',1149),(14799,'上渡街道','006',1149),(14800,'下渡街道','007',1149),(14801,'金山街道','008',1149),(14802,'仓山镇','100',1149),(14803,'城门镇','101',1149),(14804,'盖山镇','102',1149),(14805,'建新镇','103',1149),(14806,'螺洲镇','104',1149),(14807,'红星农场','400',1149),(14808,'罗星街道','001',1150),(14809,'马尾镇','100',1150),(14810,'亭江镇','101',1150),(14811,'琅岐镇','102',1150),(14812,'茶园街道','001',1151),(14813,'王庄街道','002',1151),(14814,'象园街道','003',1151),(14815,'鼓山镇','100',1151),(14816,'新店镇','101',1151),(14817,'岳峰镇','102',1151),(14818,'宦溪镇','103',1151),(14819,'寿山乡','201',1151),(14820,'日溪乡','202',1151),(14821,'甘蔗街道','001',1152),(14822,'白沙镇','101',1152),(14823,'南屿镇','102',1152),(14824,'尚干镇','103',1152),(14825,'祥谦镇','104',1152),(14826,'青口镇','105',1152),(14827,'南通镇','106',1152),(14828,'上街镇','107',1152),(14829,'荆溪镇','108',1152),(14830,'竹岐乡','200',1152),(14831,'鸿尾乡','201',1152),(14832,'洋里乡','202',1152),(14833,'大湖乡','203',1152),(14834,'廷坪乡','204',1152),(14835,'小箬乡','206',1152),(14836,'江洋农场','400',1152),(14837,'凤城镇','100',1153),(14838,'敖江镇','101',1153),(14839,'东岱镇','102',1153),(14840,'晓澳镇','104',1153),(14841,'东湖镇','105',1153),(14842,'丹阳镇','106',1153),(14843,'长龙镇','107',1153),(14844,'透堡镇','108',1153),(14845,'马鼻镇','109',1153),(14846,'官坂镇','110',1153),(14847,'筱埕镇','111',1153),(14848,'黄岐镇','112',1153),(14849,'苔','113',1153),(14850,'浦口镇','114',1153),(14851,'坑园镇','115',1153),(14852,'潘渡乡','200',1153),(14853,'江南乡','201',1153),(14854,'蓼沿乡','202',1153),(14855,'安凯乡','203',1153),(14856,'下宫乡','204',1153),(14857,'小沧畲族乡','205',1153),(14858,'马祖乡','206',1153),(14859,'凤山镇','100',1154),(14860,'松山镇','101',1154),(14861,'起步镇','102',1154),(14862,'中房镇','103',1154),(14863,'飞竹镇','104',1154),(14864,'鉴江镇','105',1154),(14865,'白塔乡','200',1154),(14866,'洪洋乡','201',1154),(14867,'西兰乡','202',1154),(14868,'霍口畲族乡','203',1154),(14869,'碧里乡','204',1154),(14870,'罗源湾','500',1154),(14871,'梅城镇','100',1155),(14872,'梅溪镇','101',1155),(14873,'白樟镇','102',1155),(14874,'金沙镇','103',1155),(14875,'白中镇','104',1155),(14876,'池园镇','105',1155),(14877,'坂东镇','106',1155),(14878,'塔庄镇','107',1155),(14879,'省璜镇','108',1155),(14880,'雄江镇','109',1155),(14881,'东桥镇','110',1155),(14882,'云龙乡','200',1155),(14883,'上莲乡','201',1155),(14884,'三溪乡','204',1155),(14885,'桔林乡','205',1155),(14886,'下祝乡','206',1155),(14887,'樟城镇','100',1156),(14888,'嵩口镇','101',1156),(14889,'梧桐镇','102',1156),(14890,'葛岭镇','103',1156),(14891,'城峰镇','104',1156),(14892,'清凉镇','105',1156),(14893,'长庆镇','106',1156),(14894,'同安镇','107',1156),(14895,'大洋镇','108',1156),(14896,'塘前乡','200',1156),(14897,'富泉乡','201',1156),(14898,'岭路乡','202',1156),(14899,'赤锡乡','203',1156),(14900,'盖洋乡','205',1156),(14901,'东洋乡','206',1156),(14902,'霞拔乡','207',1156),(14903,'盘谷乡','208',1156),(14904,'红星乡','209',1156),(14905,'白云乡','210',1156),(14906,'丹云乡','211',1156),(14907,'潭城镇','100',1157),(14908,'苏澳镇','101',1157),(14909,'流水镇','102',1157),(14910,'澳前镇','103',1157),(14911,'北厝镇','104',1157),(14912,'平原镇','105',1157),(14913,'敖东镇','106',1157),(14914,'白青乡','200',1157),(14915,'屿头乡','201',1157),(14916,'大练乡','202',1157),(14917,'芦洋乡','203',1157),(14918,'中楼乡','204',1157),(14919,'东庠乡','205',1157),(14920,'岚城乡','206',1157),(14921,'南海乡','207',1157),(14922,'玉屏街道','002',1158),(14923,'龙山街道','003',1158),(14924,'龙江街道','004',1158),(14925,'宏路街道','005',1158),(14926,'石竹街道','006',1158),(14927,'音西街道','007',1158),(14928,'阳下街道','008',1158),(14929,'海口镇','103',1158),(14930,'城头镇','104',1158),(14931,'南岭镇','105',1158),(14932,'龙田镇','106',1158),(14933,'江镜镇','107',1158),(14934,'港头镇','108',1158),(14935,'高山镇','109',1158),(14936,'沙埔镇','110',1158),(14937,'三山镇','111',1158),(14938,'东瀚镇','112',1158),(14939,'渔溪镇','113',1158),(14940,'上迳镇','114',1158),(14941,'新厝镇','115',1158),(14942,'江阴镇','116',1158),(14943,'东张镇','117',1158),(14944,'镜洋镇','118',1158),(14945,'一都镇','119',1158),(14946,'*江镜华侨','400',1158),(14947,'*东阁华侨','401',1158),(14948,'吴航街道','001',1159),(14949,'航城街道','002',1159),(14950,'营前街道','003',1159),(14951,'漳港街道','004',1159),(14952,'首占镇','102',1159),(14953,'玉田镇','103',1159),(14954,'松下镇','104',1159),(14955,'江田镇','105',1159),(14956,'古槐镇','106',1159),(14957,'文武砂镇','107',1159),(14958,'鹤上镇','108',1159),(14959,'湖南镇','110',1159),(14960,'金峰镇','111',1159),(14961,'文岭镇','112',1159),(14962,'梅花镇','113',1159),(14963,'潭头镇','114',1159),(14964,'罗联乡','200',1159),(14965,'猴屿乡','201',1159),(14966,'厦港街道','001',1161),(14967,'中华街道','003',1161),(14968,'滨海街道','005',1161),(14969,'鹭江街道','006',1161),(14970,'开元街道','007',1161),(14971,'梧村街道','008',1161),(14972,'莲前街道','010',1161),(14973,'嘉莲街道','011',1161),(14974,'鼓浪屿街道','012',1161),(14975,'*云顶岩','401',1161),(14976,'*农科所','402',1161),(14977,'*万石植物园','403',1161),(14978,'海沧街道','001',1162),(14979,'新阳街道','002',1162),(14980,'东孚镇','103',1162),(14981,'第一农场','401',1162),(14982,'海沧农场','402',1162),(14983,'天竺山林场','403',1162),(14984,'*新阳工业区','405',1162),(14985,'出口加工区','406',1162),(14986,'湖里街道','001',1163),(14987,'殿前街道','002',1163),(14988,'禾山街道','003',1163),(14989,'江头街道','004',1163),(14990,'金山街道','005',1163),(14991,'忠仑苗圃','401',1163),(14992,'湖边水库','402',1163),(14993,'高崎国际机场','403',1163),(14994,'前哨盐场','404',1163),(14995,'火炬高技术开发区','405',1163),(14996,'象屿保税区','406',1163),(14997,'集美街道','001',1164),(14998,'侨英街道','002',1164),(14999,'杏林街道','003',1164),(15000,'杏滨街道','004',1164),(15001,'灌口镇','102',1164),(15002,'后溪镇','103',1164),(15003,'第二农场','401',1164),(15004,'省天马种猪场','402',1164),(15005,'天马华侨农场','403',1164),(15006,'坂头防护林场','404',1164),(15007,'大同街道','001',1165),(15008,'祥平街道','002',1165),(15009,'莲花镇','105',1165),(15010,'新民镇','106',1165),(15011,'洪塘镇','107',1165),(15012,'西柯镇','108',1165),(15013,'汀溪镇','109',1165),(15014,'五显镇','110',1165),(15015,'*凤南农场','401',1165),(15016,'*白沙仑农场','402',1165),(15017,'*竹坝华侨农场','403',1165),(15018,'*汀溪水库','404',1165),(15019,'*祥溪林场','405',1165),(15020,'*汀溪防护林场','406',1165),(15021,'大嶝街道','001',1166),(15022,'马巷镇','102',1166),(15023,'新圩镇','103',1166),(15024,'新店镇','104',1166),(15025,'内厝镇','111',1166),(15026,'*大帽山农场','404',1166),(15027,'龙桥街道','001',1168),(15028,'凤凰山街道','002',1168),(15029,'霞林街道','003',1168),(15030,'常太镇','100',1168),(15031,'华亭镇','101',1168),(15032,'灵川镇','102',1168),(15033,'东海镇','103',1168),(15034,'涵东街道','001',1169),(15035,'涵西街道','002',1169),(15036,'三江口镇','100',1169),(15037,'白塘镇','101',1169),(15038,'国欢镇','102',1169),(15039,'梧塘镇','103',1169),(15040,'江口镇','104',1169),(15041,'白沙镇','106',1169),(15042,'庄边镇','107',1169),(15043,'新县镇','108',1169),(15044,'大洋乡','200',1169),(15045,'赤港开发区','500',1169),(15046,'镇海街道','001',1170),(15047,'拱辰街道','002',1170),(15048,'西天尾镇','100',1170),(15049,'黄石镇','101',1170),(15050,'新度镇','102',1170),(15051,'北高镇','103',1170),(15052,'笏石镇','100',1171),(15053,'东庄镇','101',1171),(15054,'忠门镇','102',1171),(15055,'东埔镇','103',1171),(15056,'东峤镇','104',1171),(15057,'埭头镇','105',1171),(15058,'平海镇','106',1171),(15059,'南日镇','107',1171),(15060,'湄洲镇','108',1171),(15061,'月塘乡','200',1171),(15062,'山亭乡','201',1171),(15063,'前沁农场','400',1171),(15064,'莆田市后海管理局','401',1171),(15065,'鲤城街道','001',1172),(15066,'枫亭镇','100',1172),(15067,'榜头镇','101',1172),(15068,'郊尾镇','102',1172),(15069,'度尾镇','103',1172),(15070,'鲤南镇','104',1172),(15071,'赖店镇','105',1172),(15072,'盖尾镇','106',1172),(15073,'园庄镇','107',1172),(15074,'大济镇','108',1172),(15075,'龙华镇','109',1172),(15076,'钟山镇','110',1172),(15077,'游洋镇','111',1172),(15078,'西苑乡','200',1172),(15079,'石苍乡','201',1172),(15080,'社硎乡','202',1172),(15081,'书峰乡','203',1172),(15082,'象溪乡','204',1172),(15083,'列东街道','001',1174),(15084,'列西街道','002',1174),(15085,'徐碧街道','003',1174),(15086,'陈大镇','100',1174),(15087,'洋溪乡','200',1174),(15088,'福建梅列经济开发区','500',1174),(15089,'城关街道','001',1175),(15090,'白沙街道','002',1175),(15091,'富兴堡街道','003',1175),(15092,'荆西街道','004',1175),(15093,'莘口镇','100',1175),(15094,'岩前镇','101',1175),(15095,'城东乡','200',1175),(15096,'中村乡','201',1175),(15097,'雪峰镇','100',1176),(15098,'盖洋镇','101',1176),(15099,'胡坊镇','102',1176),(15100,'瀚仙镇','103',1176),(15101,'城关乡','200',1176),(15102,'沙溪乡','201',1176),(15103,'夏阳乡','202',1176),(15104,'枫溪乡','203',1176),(15105,'夏坊乡','204',1176),(15106,'龙津镇','100',1177),(15107,'嵩溪镇','101',1177),(15108,'嵩口镇','102',1177),(15109,'灵地镇','103',1177),(15110,'长校镇','104',1177),(15111,'温郊乡','201',1177),(15112,'林畲乡','202',1177),(15113,'田源乡','203',1177),(15114,'沙芜乡','204',1177),(15115,'赖坊乡','205',1177),(15116,'余朋乡','206',1177),(15117,'邓家乡','207',1177),(15118,'李家乡','208',1177),(15119,'里田乡','209',1177),(15120,'翠江镇','100',1178),(15121,'泉上镇','101',1178),(15122,'湖村镇','102',1178),(15123,'石壁镇','103',1178),(15124,'城郊乡','200',1178),(15125,'城南乡','201',1178),(15126,'济村乡','202',1178),(15127,'淮土乡','203',1178),(15128,'方田乡','204',1178),(15129,'安乐乡','205',1178),(15130,'曹坊乡','206',1178),(15131,'治平乡','207',1178),(15132,'中沙乡','208',1178),(15133,'河龙乡','209',1178),(15134,'水茜乡','210',1178),(15135,'安远乡','211',1178),(15136,'均溪镇','100',1179),(15137,'石牌镇','101',1179),(15138,'上京镇','102',1179),(15139,'广平镇','103',1179),(15140,'桃源镇','104',1179),(15141,'太华镇','105',1179),(15142,'建设镇','106',1179),(15143,'奇韬镇','107',1179),(15144,'华兴乡','200',1179),(15145,'屏山乡','201',1179),(15146,'吴山乡','202',1179),(15147,'济阳乡','203',1179),(15148,'武陵乡','204',1179),(15149,'谢洋乡','205',1179),(15150,'文江乡','206',1179),(15151,'梅山乡','207',1179),(15152,'湖美乡','208',1179),(15153,'前坪乡','209',1179),(15154,'东风农场','400',1179),(15155,'城关镇','100',1180),(15156,'梅仙镇','101',1180),(15157,'西滨镇','102',1180),(15158,'洋中镇','103',1180),(15159,'新阳镇','104',1180),(15160,'管前镇','105',1180),(15161,'西城镇','106',1180),(15162,'尤溪口镇','107',1180),(15163,'联合乡','200',1180),(15164,'汤川乡','201',1180),(15165,'溪尾乡','202',1180),(15166,'中仙乡','203',1180),(15167,'台溪乡','204',1180),(15168,'坂面乡','205',1180),(15169,'八字桥乡','206',1180),(15170,'凤岗街道','001',1181),(15171,'虬江街道　','002',1181),(15172,'青州镇','101',1181),(15173,'夏茂镇','102',1181),(15174,'高砂镇','104',1181),(15175,'高桥镇','105',1181),(15176,'富口镇','106',1181),(15177,'大洛镇','107',1181),(15178,'南霞乡','201',1181),(15179,'南阳乡','203',1181),(15180,'郑湖乡','204',1181),(15181,'湖源乡','205',1181),(15182,'古镛镇','100',1182),(15183,'万安镇','101',1182),(15184,'高唐镇','102',1182),(15185,'白莲镇','103',1182),(15186,'黄潭镇','104',1182),(15187,'水南镇','105',1182),(15188,'光明乡','200',1182),(15189,'漠源乡','201',1182),(15190,'南口乡','202',1182),(15191,'万全乡','203',1182),(15192,'安仁乡','204',1182),(15193,'大源乡','205',1182),(15194,'余坊乡','206',1182),(15195,'杉城镇','100',1183),(15196,'朱口镇','101',1183),(15197,'新桥乡','200',1183),(15198,'上青乡','201',1183),(15199,'大田乡','202',1183),(15200,'梅口乡','203',1183),(15201,'下渠乡','204',1183),(15202,'开善乡','205',1183),(15203,'大龙乡','208',1183),(15204,'濉城镇','100',1184),(15205,'里心镇','101',1184),(15206,'溪口镇','102',1184),(15207,'均口镇','103',1184),(15208,'金溪乡','200',1184),(15209,'伊家乡','201',1184),(15210,'黄坊乡','202',1184),(15211,'溪源乡','203',1184),(15212,'客坊乡','204',1184),(15213,'黄埠乡','205',1184),(15214,'燕东街道','001',1185),(15215,'燕西街道','002',1185),(15216,'燕南街道','003',1185),(15217,'燕北街道','004',1185),(15218,'西洋镇','100',1185),(15219,'贡川镇','101',1185),(15220,'安砂镇','102',1185),(15221,'小陶镇','103',1185),(15222,'大湖镇','104',1185),(15223,'曹远镇','105',1185),(15224,'洪田镇','106',1185),(15225,'槐南乡','201',1185),(15226,'上坪乡','202',1185),(15227,'罗坊乡','203',1185),(15228,'青水乡','204',1185),(15229,'海滨街道','001',1187),(15230,'临江街道','002',1187),(15231,'鲤中街道','003',1187),(15232,'开元街道','004',1187),(15233,'浮桥街道','005',1187),(15234,'江南街道','006',1187),(15235,'金龙街道','007',1187),(15236,'常泰街道','008',1187),(15237,'清','500',1187),(15238,'东湖街道','001',1188),(15239,'丰泽街道','002',1188),(15240,'泉秀街道','003',1188),(15241,'清源街道','004',1188),(15242,'华大街道','005',1188),(15243,'城东街道','006',1188),(15244,'东海街道','007',1188),(15245,'北峰街道','008',1188),(15246,'万安街道','001',1189),(15247,'双阳街道','002',1189),(15248,'罗溪镇','100',1189),(15249,'马甲镇','101',1189),(15250,'河市镇','102',1189),(15251,'虹山乡','200',1189),(15252,'山腰街道办事处','001',1190),(15253,'南埔镇','100',1190),(15254,'界山镇','101',1190),(15255,'后龙镇','102',1190),(15256,'峰尾镇','103',1190),(15257,'前黄镇','105',1190),(15258,'涂岭镇','106',1190),(15259,'螺城镇','100',1191),(15260,'螺阳镇','101',1191),(15261,'黄塘镇','102',1191),(15262,'紫山镇','103',1191),(15263,'洛阳镇','104',1191),(15264,'东园镇','105',1191),(15265,'张坂镇','106',1191),(15266,'崇武镇','107',1191),(15267,'山霞镇','108',1191),(15268,'涂寨镇','109',1191),(15269,'东岭镇','110',1191),(15270,'东桥镇','111',1191),(15271,'净峰镇','112',1191),(15272,'小','113',1191),(15273,'辋川镇','114',1191),(15274,'百崎回族乡','200',1191),(15275,'凤城镇','100',1192),(15276,'蓬莱镇','101',1192),(15277,'湖头镇','102',1192),(15278,'官桥镇','103',1192),(15279,'剑斗镇','104',1192),(15280,'城厢镇','105',1192),(15281,'金谷镇','106',1192),(15282,'龙门镇','107',1192),(15283,'虎邱镇','108',1192),(15284,'芦田镇','109',1192),(15285,'感德镇','110',1192),(15286,'魁斗镇','111',1192),(15287,'西坪镇','112',1192),(15288,'参内乡','200',1192),(15289,'白濑乡','201',1192),(15290,'湖上乡','202',1192),(15291,'尚卿乡','203',1192),(15292,'大坪乡','204',1192),(15293,'龙涓乡','205',1192),(15294,'长坑乡','206',1192),(15295,'蓝田乡','207',1192),(15296,'祥华乡','208',1192),(15297,'桃舟乡','209',1192),(15298,'福田乡','210',1192),(15299,'桃城镇','100',1193),(15300,'五里街镇','101',1193),(15301,'一都镇','102',1193),(15302,'下洋镇','103',1193),(15303,'蓬壶镇','104',1193),(15304,'达埔镇','105',1193),(15305,'吾峰镇','106',1193),(15306,'石鼓镇','107',1193),(15307,'岵山镇','108',1193),(15308,'东平镇','109',1193),(15309,'湖洋镇','110',1193),(15310,'坑仔口镇','111',1193),(15311,'玉斗镇','112',1193),(15312,'锦斗镇','113',1193),(15313,'东关镇','114',1193),(15314,'桂洋镇','115',1193),(15315,'苏坑镇','116',1193),(15316,'仙夹镇','117',1193),(15317,'横口乡','200',1193),(15318,'呈祥乡','201',1193),(15319,'介福乡','202',1193),(15320,'外山乡','204',1193),(15321,'浔中镇','100',1194),(15322,'龙浔镇','101',1194),(15323,'三班镇','102',1194),(15324,'龙门滩镇','103',1194),(15325,'雷峰镇','104',1194),(15326,'南埕镇','105',1194),(15327,'水口镇','106',1194),(15328,'赤水镇','107',1194),(15329,'上涌镇','108',1194),(15330,'葛坑镇','109',1194),(15331,'杨梅乡','200',1194),(15332,'汤头乡','202',1194),(15333,'桂阳乡','204',1194),(15334,'盖德乡','205',1194),(15335,'国宝乡','206',1194),(15336,'美湖乡','207',1194),(15337,'大铭乡','208',1194),(15338,'春美乡','209',1194),(15339,'湖滨街道','001',1196),(15340,'凤里街道','002',1196),(15341,'灵秀镇','100',1196),(15342,'宝盖镇','101',1196),(15343,'蚶江镇','102',1196),(15344,'祥芝镇','103',1196),(15345,'鸿山镇','104',1196),(15346,'锦尚镇','105',1196),(15347,'永宁镇','106',1196),(15348,'青阳街道办事处','001',1197),(15349,'梅岭街道办事处','002',1197),(15350,'西园街道办事处','003',1197),(15351,'罗山街道办事处','004',1197),(15352,'新塘街道办事处','005',1197),(15353,'灵源街道办事处','006',1197),(15354,'安海镇','101',1197),(15355,'磁灶镇','102',1197),(15356,'陈埭镇','103',1197),(15357,'东石镇','104',1197),(15358,'深沪镇','105',1197),(15359,'金井镇','106',1197),(15360,'池店镇','107',1197),(15361,'内坑镇','109',1197),(15362,'龙湖镇','110',1197),(15363,'永和镇','111',1197),(15364,'英林镇','112',1197),(15365,'紫帽镇','113',1197),(15366,'西滨镇','114',1197),(15367,'*晋江市国营良种繁殖场','498',1197),(15368,'*安平开发区','500',1197),(15369,'*五里工业区','501',1197),(15370,'溪美街道','001',1198),(15371,'柳城街道','002',1198),(15372,'美林街道','003',1198),(15373,'省新镇','100',1198),(15374,'仑苍镇','101',1198),(15375,'东田镇','102',1198),(15376,'英都镇','103',1198),(15377,'翔云镇','104',1198),(15378,'金淘镇','105',1198),(15379,'诗山镇','106',1198),(15380,'蓬华镇','107',1198),(15381,'码头镇','108',1198),(15382,'九都镇','109',1198),(15383,'乐峰镇','110',1198),(15384,'罗东镇','111',1198),(15385,'梅山镇','112',1198),(15386,'洪濑镇','113',1198),(15387,'洪梅镇','114',1198),(15388,'康美镇','115',1198),(15389,'丰州镇','116',1198),(15390,'霞美镇','117',1198),(15391,'官桥镇','118',1198),(15392,'水头镇','119',1198),(15393,'石井镇','120',1198),(15394,'眉山乡','200',1198),(15395,'向阳乡','201',1198),(15396,'雪峰管委会','500',1198),(15397,'东铺头街道','001',1200),(15398,'西桥街道','002',1200),(15399,'新桥街道','003',1200),(15400,'巷口街道','004',1200),(15401,'南坑街道','005',1200),(15402,'通北街道','006',1200),(15403,'浦南镇','100',1200),(15404,'天宝镇','101',1200),(15405,'芝山镇','102',1200),(15406,'石亭镇','103',1200),(15407,'*芗城区奶牛场','400',1200),(15408,'*后房农场','401',1200),(15409,'*天宝林场','402',1200),(15410,'*大房农场','403',1200),(15411,'*五峰农场','404',1200),(15412,'蓝田镇','100',1201),(15413,'步文镇','101',1201),(15414,'朝阳镇','102',1201),(15415,'郭坑镇','103',1201),(15416,'蓝田开发区管委会','500',1201),(15417,'云陵镇','100',1202),(15418,'陈岱镇','101',1202),(15419,'东厦镇','102',1202),(15420,'莆美镇','103',1202),(15421,'列屿镇','104',1202),(15422,'火田镇','105',1202),(15423,'下河乡','200',1202),(15424,'马铺乡','201',1202),(15425,'和平乡','202',1202),(15426,'*和平农场','400',1202),(15427,'*常山华侨经济开发区','500',1202),(15428,'绥安镇','100',1203),(15429,'旧镇镇','101',1203),(15430,'佛昙镇','102',1203),(15431,'赤湖镇','103',1203),(15432,'杜浔镇','104',1203),(15433,'霞美镇','105',1203),(15434,'官浔镇','106',1203),(15435,'石榴镇','107',1203),(15436,'盘陀镇','108',1203),(15437,'长桥镇','109',1203),(15438,'前亭镇','110',1203),(15439,'马坪镇','111',1203),(15440,'深土镇','112',1203),(15441,'六鳌镇','113',1203),(15442,'沙西镇','114',1203),(15443,'古雷镇','115',1203),(15444,'大南坂镇','116',1203),(15445,'南浦乡','200',1203),(15446,'赤岭畲族乡','201',1203),(15447,'湖西畲族乡','202',1203),(15448,'赤土乡','203',1203),(15449,'*漳浦盐场','400',1203),(15450,'*万安农场','401',1203),(15451,'石古农场','402',1203),(15452,'长桥农场','403',1203),(15453,'白竹湖农场','404',1203),(15454,'南山华侨茶果场','405',1203),(15455,'中西林场','406',1203),(15456,'玳瑁山茶场','407',1203),(15457,'下蔡林场','408',1203),(15458,'南诏镇','100',1204),(15459,'四都镇','101',1204),(15460,'梅岭镇','102',1204),(15461,'桥东镇','103',1204),(15462,'深桥镇','104',1204),(15463,'太平镇','105',1204),(15464,'霞葛镇','106',1204),(15465,'官陂镇','107',1204),(15466,'秀篆镇','108',1204),(15467,'金星乡','200',1204),(15468,'西潭乡','201',1204),(15469,'白洋乡','202',1204),(15470,'建设乡','203',1204),(15471,'红星乡','204',1204),(15472,'梅洲乡','205',1204),(15473,'国营西山农场','401',1204),(15474,'国营湖内林场','402',1204),(15475,'岭下溪国有防护林场','403',1204),(15476,'*边贸旅游区管委会','500',1204),(15477,'*闽粤边界开发区管委会','501',1204),(15478,'武安镇','100',1205),(15479,'岩溪镇','101',1205),(15480,'陈巷镇','102',1205),(15481,'枋洋镇','103',1205),(15482,'坂里乡','200',1205),(15483,'*古农农场','400',1205),(15484,'*长泰经济开发区','500',1205),(15485,'*马洋溪旅游区','501',1205),(15486,'*林墩民营经济区','502',1205),(15487,'西埔镇','100',1206),(15488,'樟塘镇','101',1206),(15489,'康美镇','102',1206),(15490,'杏陈镇','103',1206),(15491,'陈城镇','104',1206),(15492,'前楼镇','105',1206),(15493,'铜陵镇','450',1206),(15494,'山城镇','100',1207),(15495,'丰田镇','101',1207),(15496,'靖城镇','102',1207),(15497,'龙山镇','103',1207),(15498,'金山镇','104',1207),(15499,'和溪镇','105',1207),(15500,'奎洋镇','106',1207),(15501,'梅林镇','107',1207),(15502,'书洋镇','108',1207),(15503,'船场镇','109',1207),(15504,'南坑镇','110',1207),(15505,'小溪镇','100',1208),(15506,'山格镇','101',1208),(15507,'文峰镇','102',1208),(15508,'南胜镇','103',1208),(15509,'坂仔镇','104',1208),(15510,'安厚镇','105',1208),(15511,'大溪镇','106',1208),(15512,'霞寨镇','107',1208),(15513,'九峰镇','108',1208),(15514,'芦溪镇','109',1208),(15515,'五寨乡','200',1208),(15516,'国强乡','201',1208),(15517,'崎岭乡','202',1208),(15518,'长乐乡','203',1208),(15519,'秀峰乡','204',1208),(15520,'安厚农场','400',1208),(15521,'华丰镇','100',1209),(15522,'丰山镇','101',1209),(15523,'沙建镇','102',1209),(15524,'新圩镇','103',1209),(15525,'高安镇','104',1209),(15526,'仙都镇','105',1209),(15527,'高车乡','200',1209),(15528,'马坑乡','201',1209),(15529,'湖林乡','203',1209),(15530,'石码镇','100',1210),(15531,'海澄镇','101',1210),(15532,'角美镇','102',1210),(15533,'白水镇','103',1210),(15534,'浮宫镇','104',1210),(15535,'程溪镇','105',1210),(15536,'港尾镇','106',1210),(15537,'九湖镇','107',1210),(15538,'颜厝镇','108',1210),(15539,'榜山镇','109',1210),(15540,'紫泥镇','110',1210),(15541,'东园镇','111',1210),(15542,'东泗乡','200',1210),(15543,'隆教畲族乡','201',1210),(15544,'*双第华侨农场','400',1210),(15545,'*九龙岭林场','401',1210),(15546,'*程溪农场','402',1210),(15547,'*良种场','403',1210),(15548,'*苍坂农场','404',1210),(15549,'*林下林场','405',1210),(15550,'*角美工业开发区','500',1210),(15551,'*招商局漳州开发区','501',1210),(15552,'*东园开发区','502',1210),(15553,'*龙池开发区','503',1210),(15554,'梅山街道','001',1212),(15555,'黄墩街道','002',1212),(15556,'紫云街道','003',1212),(15557,'四鹤街道','004',1212),(15558,'水南街道','005',1212),(15559,'水东街道','006',1212),(15560,'来舟镇','100',1212),(15561,'樟湖镇','101',1212),(15562,'夏道镇','102',1212),(15563,'西芹镇','103',1212),(15564,'峡阳镇','104',1212),(15565,'南山镇','105',1212),(15566,'大横镇','106',1212),(15567,'王台镇','107',1212),(15568,'太平镇','108',1212),(15569,'塔前镇','109',1212),(15570,'茫荡镇','110',1212),(15571,'洋后镇','111',1212),(15572,'炉下镇','112',1212),(15573,'巨口乡','200',1212),(15574,'赤门乡','202',1212),(15575,'双溪街道办事处','001',1213),(15576,'建西镇','100',1213),(15577,'洋口镇','101',1213),(15578,'元坑镇','102',1213),(15579,'埔上镇','103',1213),(15580,'大历镇','104',1213),(15581,'大干镇','105',1213),(15582,'仁寿镇','106',1213),(15583,'洋墩乡','200',1213),(15584,'郑坊乡','201',1213),(15585,'岚下乡','202',1213),(15586,'高阳乡','203',1213),(15587,'南浦街道','001',1214),(15588,'河滨街道','002',1214),(15589,'富岭镇','101',1214),(15590,'石陂镇','102',1214),(15591,'临江镇','103',1214),(15592,'仙阳镇','104',1214),(15593,'水北街镇','105',1214),(15594,'永兴镇','106',1214),(15595,'忠信镇','107',1214),(15596,'莲塘镇','108',1214),(15597,'九牧镇','109',1214),(15598,'万安乡','200',1214),(15599,'古楼乡','201',1214),(15600,'山下乡','202',1214),(15601,'枫溪乡','203',1214),(15602,'濠村乡','204',1214),(15603,'管厝乡','205',1214),(15604,'盘亭乡','206',1214),(15605,'官路乡','207',1214),(15606,'水南农场','400',1214),(15607,'杭川镇','100',1215),(15608,'寨里镇','101',1215),(15609,'止马镇','102',1215),(15610,'鸾风乡','200',1215),(15611,'崇仁乡','201',1215),(15612,'李坊乡','202',1215),(15613,'华桥乡','203',1215),(15614,'司前乡','204',1215),(15615,'松源镇','100',1216),(15616,'郑墩镇','101',1216),(15617,'渭田镇','102',1216),(15618,'河东乡','200',1216),(15619,'茶平乡','201',1216),(15620,'旧县乡','202',1216),(15621,'溪东乡','203',1216),(15622,'花桥乡','204',1216),(15623,'祖墩乡','205',1216),(15624,'熊山镇','100',1217),(15625,'东平镇','101',1217),(15626,'石屯镇','102',1217),(15627,'铁山镇','103',1217),(15628,'镇前镇','104',1217),(15629,'星溪乡','200',1217),(15630,'外屯乡','201',1217),(15631,'杨源乡','202',1217),(15632,'澄源乡','203',1217),(15633,'岭腰乡','204',1217),(15634,'昭阳街道','001',1218),(15635,'通泰街道','002',1218),(15636,'水北街道','003',1218),(15637,'晒口街道','004',1218),(15638,'城郊镇','100',1218),(15639,'水北镇','101',1218),(15640,'下沙镇','102',1218),(15641,'卫闽镇','103',1218),(15642,'沿山镇','104',1218),(15643,'拿口镇','105',1218),(15644,'洪墩镇','106',1218),(15645,'大埠岗镇','107',1218),(15646,'和平镇','108',1218),(15647,'肖家坊镇','109',1218),(15648,'大竹镇','110',1218),(15649,'吴家塘镇','111',1218),(15650,'桂林乡','200',1218),(15651,'张厝乡','201',1218),(15652,'金坑乡','202',1218),(15653,'综合农场','400',1218),(15654,'崇安街道','001',1219),(15655,'新丰街道','002',1219),(15656,'武夷街道','003',1219),(15657,'星村镇','100',1219),(15658,'兴田镇','101',1219),(15659,'五夫镇','102',1219),(15660,'上梅乡','200',1219),(15661,'吴屯乡','201',1219),(15662,'岚谷乡','202',1219),(15663,'洋庄乡','203',1219),(15664,'建安街道','001',1220),(15665,'通济街道','002',1220),(15666,'瓯宁街道','003',1220),(15667,'芝山街道','004',1220),(15668,'徐墩镇','100',1220),(15669,'吉阳镇','101',1220),(15670,'房道镇','102',1220),(15671,'南雅镇','103',1220),(15672,'迪口镇','104',1220),(15673,'小桥镇','105',1220),(15674,'玉山镇','106',1220),(15675,'东游镇','107',1220),(15676,'东峰镇','108',1220),(15677,'小松镇','109',1220),(15678,'顺阳乡','200',1220),(15679,'水源乡','201',1220),(15680,'川石乡','202',1220),(15681,'龙村乡','203',1220),(15682,'潭城街道','001',1221),(15683,'童游街道','002',1221),(15684,'将口镇','102',1221),(15685,'徐市镇','103',1221),(15686,'莒口镇','104',1221),(15687,'麻沙镇','105',1221),(15688,'黄坑镇','106',1221),(15689,'水吉镇','107',1221),(15690,'漳墩镇','108',1221),(15691,'小湖镇','109',1221),(15692,'崇雒乡','200',1221),(15693,'书坊乡','201',1221),(15694,'回龙乡','202',1221),(15695,'东城街道','001',1223),(15696,'南城街道','002',1223),(15697,'西城街道','003',1223),(15698,'中城街道','004',1223),(15699,'西陂街道','005',1223),(15700,'曹溪街道','006',1223),(15701,'东肖街道','007',1223),(15702,'龙门街道','008',1223),(15703,'铁山街道','009',1223),(15704,'红坊镇','100',1223),(15705,'适中镇','101',1223),(15706,'雁石镇','102',1223),(15707,'白沙镇','103',1223),(15708,'万安镇','104',1223),(15709,'大池镇','105',1223),(15710,'小池镇','106',1223),(15711,'江山乡','200',1223),(15712,'岩山乡','201',1223),(15713,'苏坂乡','202',1223),(15714,'汀州镇','100',1224),(15715,'大同镇','101',1224),(15716,'古城镇','102',1224),(15717,'新桥镇','103',1224),(15718,'馆前镇','104',1224),(15719,'童坊镇','105',1224),(15720,'河田镇','106',1224),(15721,'南山镇','107',1224),(15722,'濯田镇','108',1224),(15723,'四都镇','109',1224),(15724,'涂坊镇','110',1224),(15725,'策武乡','200',1224),(15726,'铁长乡','201',1224),(15727,'庵杰乡','202',1224),(15728,'三洲乡','203',1224),(15729,'宣成乡','204',1224),(15730,'红山乡','205',1224),(15731,'羊牯乡','206',1224),(15732,'凤城镇','100',1225),(15733,'坎市镇','101',1225),(15734,'下洋镇','102',1225),(15735,'湖雷镇','103',1225),(15736,'高陂镇','104',1225),(15737,'抚市镇','105',1225),(15738,'湖坑镇','106',1225),(15739,'培丰镇','107',1225),(15740,'龙潭镇','108',1225),(15741,'峰市镇','109',1225),(15742,'城郊乡','200',1225),(15743,'西溪乡','201',1225),(15744,'金砂乡','202',1225),(15745,'仙师乡','203',1225),(15746,'洪山乡','204',1225),(15747,'湖山乡','205',1225),(15748,'岐岭乡','206',1225),(15749,'古竹乡','207',1225),(15750,'堂堡乡','208',1225),(15751,'合溪乡','209',1225),(15752,'虎岗乡','210',1225),(15753,'大溪乡','211',1225),(15754,'陈东乡','212',1225),(15755,'高头乡','213',1225),(15756,'临江镇','100',1226),(15757,'临城镇','101',1226),(15758,'中都镇','102',1226),(15759,'蓝溪镇','103',1226),(15760,'稔田镇','104',1226),(15761,'白砂镇','105',1226),(15762,'古田镇','106',1226),(15763,'才溪镇','107',1226),(15764,'南阳镇','108',1226),(15765,'湖洋乡','200',1226),(15766,'下都乡','201',1226),(15767,'庐丰畲族乡','202',1226),(15768,'太拔乡','203',1226),(15769,'溪口乡','204',1226),(15770,'茶地乡','205',1226),(15771,'泮境乡','206',1226),(15772,'蛟洋乡','207',1226),(15773,'步云乡','208',1226),(15774,'旧县乡','209',1226),(15775,'通贤乡','210',1226),(15776,'官庄畲族乡','211',1226),(15777,'珊瑚乡','212',1226),(15778,'平川镇','100',1227),(15779,'中山镇','101',1227),(15780,'岩前镇','102',1227),(15781,'十方镇','103',1227),(15782,'中堡镇','104',1227),(15783,'桃溪镇','105',1227),(15784,'城厢乡','200',1227),(15785,'万安乡','201',1227),(15786,'东留乡','202',1227),(15787,'民主乡','203',1227),(15788,'下坝乡','204',1227),(15789,'中赤乡','205',1227),(15790,'象洞乡','206',1227),(15791,'武东乡','207',1227),(15792,'永平乡','208',1227),(15793,'湘店乡','209',1227),(15794,'大禾乡','210',1227),(15795,'莲峰镇','100',1228),(15796,'北团镇','101',1228),(15797,'姑田镇','102',1228),(15798,'朋口镇','103',1228),(15799,'莒溪镇','104',1228),(15800,'新泉镇','105',1228),(15801,'庙前镇','106',1228),(15802,'揭乐乡','200',1228),(15803,'塘前乡','201',1228),(15804,'隔川乡','202',1228),(15805,'四堡乡','203',1228),(15806,'罗坊乡','204',1228),(15807,'林坊乡','205',1228),(15808,'文亨乡','206',1228),(15809,'曲溪乡','208',1228),(15810,'赖源乡','209',1228),(15811,'宣和乡','210',1228),(15812,'菁城街道','001',1229),(15813,'桂林街道','002',1229),(15814,'新桥镇','100',1229),(15815,'双洋镇','101',1229),(15816,'永福镇','102',1229),(15817,'溪南镇','103',1229),(15818,'和平镇','104',1229),(15819,'拱桥镇','105',1229),(15820,'象湖镇','106',1229),(15821,'赤水镇','107',1229),(15822,'芦芝乡','200',1229),(15823,'西园乡','201',1229),(15824,'南洋乡','202',1229),(15825,'官田乡','203',1229),(15826,'吾祠乡','204',1229),(15827,'灵地乡','205',1229),(15828,'蕉南街道','001',1231),(15829,'蕉北街道','002',1231),(15830,'城南镇','100',1231),(15831,'漳湾镇','101',1231),(15832,'七都镇','102',1231),(15833,'八都镇','103',1231),(15834,'九都镇','104',1231),(15835,'霍童镇','105',1231),(15836,'赤溪镇','106',1231),(15837,'洋中镇','107',1231),(15838,'飞鸾镇','108',1231),(15839,'三都镇','109',1231),(15840,'金涵畲族乡','200',1231),(15841,'洪口乡','201',1231),(15842,'石后乡','202',1231),(15843,'虎贝乡','203',1231),(15844,'*东侨开发区','500',1231),(15845,'松城街道','001',1232),(15846,'松港街道','002',1232),(15847,'长春镇','101',1232),(15848,'牙城镇','102',1232),(15849,'溪南镇','103',1232),(15850,'沙江镇','104',1232),(15851,'下浒镇','105',1232),(15852,'三沙镇','106',1232),(15853,'盐田畲族乡','200',1232),(15854,'水门畲族乡','201',1232),(15855,'崇儒畲族乡','202',1232),(15856,'柏洋乡','203',1232),(15857,'北壁乡','204',1232),(15858,'海岛乡','205',1232),(15859,'城东街道办事处','001',1233),(15860,'城西街道办事处','002',1233),(15861,'平湖镇','101',1233),(15862,'大桥镇','102',1233),(15863,'黄田镇','103',1233),(15864,'鹤塘镇','104',1233),(15865,'杉洋镇','105',1233),(15866,'凤都镇','106',1233),(15867,'水口镇','107',1233),(15868,'吉巷乡','201',1233),(15869,'泮洋乡','203',1233),(15870,'凤埔乡','204',1233),(15871,'卓洋乡','205',1233),(15872,'大甲乡','206',1233),(15873,'古峰镇','100',1234),(15874,'双溪镇','101',1234),(15875,'黛溪镇','102',1234),(15876,'长桥镇','103',1234),(15877,'屏城乡','200',1234),(15878,'棠口乡','201',1234),(15879,'甘棠乡','202',1234),(15880,'熙岭乡','203',1234),(15881,'路下乡','204',1234),(15882,'寿山乡','205',1234),(15883,'岭下乡','206',1234),(15884,'鳌阳镇','100',1235),(15885,'斜滩镇','101',1235),(15886,'南阳镇','102',1235),(15887,'武曲镇','103',1235),(15888,'大安乡','200',1235),(15889,'坑底乡','201',1235),(15890,'清源乡','202',1235),(15891,'竹管垅乡','203',1235),(15892,'犀溪乡','204',1235),(15893,'芹洋乡','205',1235),(15894,'托溪乡','206',1235),(15895,'平溪乡','207',1235),(15896,'凤阳乡','208',1235),(15897,'下党乡','209',1235),(15898,'狮城镇','100',1236),(15899,'咸村镇','101',1236),(15900,'浦源镇','102',1236),(15901,'七步镇','103',1236),(15902,'李墩镇','104',1236),(15903,'纯池镇','105',1236),(15904,'泗桥乡','200',1236),(15905,'礼门乡','201',1236),(15906,'玛坑乡','202',1236),(15907,'双城镇','100',1237),(15908,'富溪镇','101',1237),(15909,'城郊乡','200',1237),(15910,'乍洋乡','201',1237),(15911,'东源乡','202',1237),(15912,'黄柏乡','203',1237),(15913,'宅中乡','204',1237),(15914,'楮坪乡','205',1237),(15915,'英山乡','206',1237),(15916,'城南街道','001',1238),(15917,'城北街道','002',1238),(15918,'阳头街道','003',1238),(15919,'赛岐镇','100',1238),(15920,'穆阳镇','101',1238),(15921,'上白石镇','102',1238),(15922,'潭头镇','103',1238),(15923,'社口镇','104',1238),(15924,'晓阳镇','105',1238),(15925,'溪潭镇','106',1238),(15926,'甘棠镇','107',1238),(15927,'下白石镇','108',1238),(15928,'溪尾镇','109',1238),(15929,'溪柄镇','110',1238),(15930,'城阳乡','200',1238),(15931,'坂中畲族乡','201',1238),(15932,'范坑乡','202',1238),(15933,'穆云畲族乡','203',1238),(15934,'康厝畲族乡','204',1238),(15935,'湾坞乡','205',1238),(15936,'松罗乡','206',1238),(15937,'*赛岐开发区','500',1238),(15938,'*福安畲族开发区','501',1238),(15939,'*湾坞工业集中区','502',1238),(15940,'桐山街道','001',1239),(15941,'桐城街道','002',1239),(15942,'山前街道','003',1239),(15943,'贯岭镇','100',1239),(15944,'前岐镇','101',1239),(15945,'沙埕镇','102',1239),(15946,'店下镇','103',1239),(15947,'秦屿镇','104',1239),(15948,'白琳镇','106',1239),(15949,'点头镇','107',1239),(15950,'管阳镇','108',1239),(15951,'嵛山镇','109',1239),(15952,'硖门畲族乡','200',1239),(15953,'叠石乡','201',1239),(15954,'佳阳乡','202',1239),(15955,'*龙安开发区','500',1239),(15956,'公园街道办事处','001',1241),(15957,'滕王阁街道办事处','002',1241),(15958,'八一桥街道办事处','003',1241),(15959,'百花洲街道办事处','004',1241),(15960,'墩子塘街道办事处','005',1241),(15961,'大院街道办事处','006',1241),(15962,'豫章街道办事处','007',1241),(15963,'董家窑街道办事处','008',1241),(15964,'彭家桥街道办事处','009',1241),(15965,'沙井街道(红谷滩新区)','050',1241),(15966,'贤士湖管委会','400',1241),(15967,'南浦街道办事处','001',1242),(15968,'朝阳洲街道办事处','002',1242),(15969,'广润门街道办事处','004',1242),(15970,'西湖街道办事处','005',1242),(15971,'系马桩街道办事处','006',1242),(15972,'绳金塔街道办事处','007',1242),(15973,'丁公路街道办事处','009',1242),(15974,'南站街道办事处','010',1242),(15975,'桃源街道办事处','011',1242),(15976,'十字街街道办事处','012',1242),(15977,'桃花镇','101',1242),(15978,'南昌市朝阳农场','400',1242),(15979,'洪都街道办事处','002',1243),(15980,'京山街道办事处','006',1243),(15981,'三家店街道办事处','007',1243),(15982,'岱山街道办事处','008',1243),(15983,'徐家坊街道办事处','009',1243),(15984,'青云谱镇','100',1243),(15985,'南昌昌南工业园','500',1243),(15986,'站前街道办事处','001',1244),(15987,'幸福街道办事处','002',1244),(15988,'招贤镇','100',1244),(15989,'梅岭镇','101',1244),(15990,'罗亭镇','102',1244),(15991,'太平乡','200',1244),(15992,'青山路街道办事处','001',1245),(15993,'上海路街道办事处','003',1245),(15994,'京东镇','100',1245),(15995,'罗家镇','103',1245),(15996,'湖坊镇','104',1245),(15997,'塘山镇','105',1245),(15998,'蛟桥镇(南昌经济技术开发区)','180',1245),(15999,'扬子洲乡','200',1245),(16000,'扬子洲农场','400',1245),(16001,'罗家地区省市单位','401',1245),(16002,'白水湖管理处(南昌经济技术开发区)','481',1245),(16003,'艾溪湖管理处(南昌高新开发区)','490',1245),(16004,'南昌京东旅游经济开发区','500',1245),(16005,'南昌昌东工业区','501',1245),(16006,'南昌民营科技园','502',1245),(16007,'江西金牛集团(英雄开发区)','570',1245),(16008,'湖西新建区(南昌高新开发区)','593',1245),(16009,'莲塘镇','100',1246),(16010,'向塘镇','101',1246),(16011,'三江镇','102',1246),(16012,'塘南镇','103',1246),(16013,'幽兰镇','104',1246),(16014,'蒋巷镇','105',1246),(16015,'武阳镇','106',1246),(16016,'冈上镇','107',1246),(16017,'广福镇','108',1246),(16018,'昌东镇(南昌高新开发区)','191',1246),(16019,'麻丘镇(南昌高新开发区)','192',1246),(16020,'泾口乡','200',1246),(16021,'南新乡','201',1246),(16022,'塔城乡','202',1246),(16023,'黄马乡','203',1246),(16024,'富山乡','204',1246),(16025,'东新乡','205',1246),(16026,'八一乡','206',1246),(16027,'南昌市五星垦殖场','402',1246),(16028,'南昌英雄开发区社会事务管理处(英雄开发','471',1246),(16029,'江西省良种繁殖场(英雄开发区)','472',1246),(16030,'小蓝经济开发区','500',1246),(16031,'长','100',1247),(16032,'望城镇','101',1247),(16033,'生米镇','102',1247),(16034,'西山镇','103',1247),(16035,'石岗镇','104',1247),(16036,'松湖镇','105',1247),(16037,'樵舍镇','106',1247),(16038,'乐化镇','107',1247),(16039,'溪霞镇','108',1247),(16040,'象山镇','109',1247),(16041,'石埠乡','200',1247),(16042,'流湖乡','201',1247),(16043,'厚田乡','202',1247),(16044,'联圩乡','203',1247),(16045,'金桥乡','204',1247),(16046,'铁河乡','205',1247),(16047,'大塘坪乡','206',1247),(16048,'昌邑乡','207',1247),(16049,'南矶乡','208',1247),(16050,'恒湖垦殖场','400',1247),(16051,'新丰垦殖场','401',1247),(16052,'成新实业有限公司','402',1247),(16053,'朱港实业有限公司','403',1247),(16054,'红角洲管理处(红谷滩新区)','450',1247),(16055,'江西长','500',1247),(16056,'江西桑海集团有限公司（江西桑海经济开?','560',1247),(16057,'新祺周管理处(江西桑海经济技术开发区)','561',1247),(16058,'龙津镇','100',1248),(16059,'万埠镇','101',1248),(16060,'石鼻镇','102',1248),(16061,'鼎湖镇','103',1248),(16062,'长埠镇','104',1248),(16063,'东阳镇','105',1248),(16064,'黄洲镇','106',1248),(16065,'乔乐乡','200',1248),(16066,'长均乡','201',1248),(16067,'新民乡','202',1248),(16068,'国营万埠垦殖场','400',1248),(16069,'国营峤岭垦殖场','401',1248),(16070,'江西安义工业园区','500',1248),(16071,'民和镇','100',1249),(16072,'李渡镇','101',1249),(16073,'温圳镇','102',1249),(16074,'文港镇','103',1249),(16075,'梅庄镇','104',1249),(16076,'张公镇','105',1249),(16077,'罗溪镇','106',1249),(16078,'架桥镇','107',1249),(16079,'前坊镇','108',1249),(16080,'三里乡','200',1249),(16081,'二塘乡','201',1249),(16082,'钟陵乡','202',1249),(16083,'池溪乡','203',1249),(16084,'南台乡','204',1249),(16085,'三阳集乡','205',1249),(16086,'七里乡','206',1249),(16087,'下埠集乡','207',1249),(16088,'衙前乡','208',1249),(16089,'白圩乡','209',1249),(16090,'长山晏乡','210',1249),(16091,'泉岭乡','211',1249),(16092,'五里垦殖场','400',1249),(16093,'西郊街道','001',1251),(16094,'竟成镇','100',1251),(16095,'鲇鱼山镇','101',1251),(16096,'丽阳乡','201',1251),(16097,'荷塘乡','202',1251),(16098,'吕蒙乡(景德镇高新区管委会)','290',1251),(16099,'西郊垦殖场','400',1251),(16100,'枫树山总场','450',1251),(16101,'浮东分场','451',1251),(16102,'柏树下分场','452',1251),(16103,'浮南分场','453',1251),(16104,'浮西分场','454',1251),(16105,'南山分场','455',1251),(16106,'三宝分场','456',1251),(16107,'黄岭分场','457',1251),(16108,'塘坞分场','458',1251),(16109,'樟树坑分场','459',1251),(16110,'磨刀港分场','460',1251),(16111,'双桥分场','461',1251),(16112,'昌江化工园区','462',1251),(16113,'六0二所高科技园','463',1251),(16114,'森林公园','464',1251),(16115,'昌江开发区','500',1251),(16116,'石狮埠街道办事处','001',1252),(16117,'新厂街道办事处','002',1252),(16118,'里村街道办事处','003',1252),(16119,'周路口街道办事处','004',1252),(16120,'昌江街道办事处','005',1252),(16121,'新村街道办事处','006',1252),(16122,'珠山街道办事处','007',1252),(16123,'太白园街道办事处','008',1252),(16124,'昌河街道办事处','009',1252),(16125,'高新技术开发区','500',1252),(16126,'浮梁镇','100',1253),(16127,'鹅湖镇','101',1253),(16128,'经公桥镇','102',1253),(16129,'蛟潭镇','103',1253),(16130,'湘湖镇','104',1253),(16131,'瑶里镇','105',1253),(16132,'洪源镇','106',1253),(16133,'寿安镇','107',1253),(16134,'王港乡','200',1253),(16135,'庄湾乡','201',1253),(16136,'三龙乡','202',1253),(16137,'黄坛乡','203',1253),(16138,'兴田乡','204',1253),(16139,'江村乡','205',1253),(16140,'峙滩乡','206',1253),(16141,'勒功乡','207',1253),(16142,'西湖乡','208',1253),(16143,'罗家垦殖场','400',1253),(16144,'庄湾垦殖场','401',1253),(16145,'九龙山垦殖场','402',1253),(16146,'万寿山垦殖场','403',1253),(16147,'浮梁工业园区','500',1253),(16148,'洎阳街道办事处','001',1254),(16149,'塔山街道办事处','002',1254),(16150,'镇桥镇','100',1254),(16151,'乐港镇','101',1254),(16152,'涌山镇','102',1254),(16153,'众埠镇','103',1254),(16154,'接渡镇','104',1254),(16155,'洪岩镇','105',1254),(16156,'礼林镇','106',1254),(16157,'后港镇','107',1254),(16158,'塔前镇','108',1254),(16159,'双田镇','109',1254),(16160,'临港镇','110',1254),(16161,'高家镇','111',1254),(16162,'浯口镇','113',1254),(16163,'鸬鹚乡','200',1254),(16164,'十里岗乡','201',1254),(16165,'农业高新园','400',1254),(16166,'江西乐平工业园区','500',1254),(16167,'东大街街道办事处','001',1256),(16168,'凤凰街街道办事处','002',1256),(16169,'八一街街道办事处','003',1256),(16170,'后埠街街道办事处','004',1256),(16171,'丹江街街道办事处','005',1256),(16172,'白源街街道办事处','006',1256),(16173,'安源镇','100',1256),(16174,'高坑镇','101',1256),(16175,'五陂镇','102',1256),(16176,'青山镇','103',1256),(16177,'城郊管委会','104',1256),(16178,'五陂下垦殖场','400',1256),(16179,'峡山口街道办事处','001',1257),(16180,'湘东镇','101',1257),(16181,'荷尧镇','102',1257),(16182,'老关镇','103',1257),(16183,'腊市镇','104',1257),(16184,'下埠镇','105',1257),(16185,'排上镇','106',1257),(16186,'东桥镇','107',1257),(16187,'麻山镇','108',1257),(16188,'广寒寨乡','200',1257),(16189,'白竺乡','201',1257),(16190,'琴亭镇','101',1258),(16191,'路口镇','102',1258),(16192,'良坊镇','103',1258),(16193,'升坊镇','104',1258),(16194,'坊楼镇','105',1258),(16195,'闪石乡','200',1258),(16196,'湖上乡','201',1258),(16197,'三板桥乡','202',1258),(16198,'神泉乡','203',1258),(16199,'六市乡','204',1258),(16200,'高洲乡','205',1258),(16201,'荷塘乡','206',1258),(16202,'南岭乡','207',1258),(16203,'上栗镇','101',1259),(16204,'桐木镇','102',1259),(16205,'金山镇','103',1259),(16206,'福田镇','104',1259),(16207,'彭高镇','105',1259),(16208,'赤山镇','106',1259),(16209,'鸡冠山乡','200',1259),(16210,'长平乡','201',1259),(16211,'东源乡','202',1259),(16212,'芦溪镇','101',1260),(16213,'宣风镇','102',1260),(16214,'上埠镇','103',1260),(16215,'南坑镇','104',1260),(16216,'银河镇','105',1260),(16217,'源南乡','200',1260),(16218,'长丰乡','201',1260),(16219,'张佳坊乡','202',1260),(16220,'新泉乡','203',1260),(16221,'万龙山乡','204',1260),(16222,'十里街道办事处','001',1262),(16223,'五里街道办事处','002',1262),(16224,'七里湖街道办事处(九江经济开发区)','090',1262),(16225,'姑塘镇','100',1262),(16226,'威家镇','101',1262),(16227,'新港镇','102',1262),(16228,'莲花镇','103',1262),(16229,'海会镇','104',1262),(16230,'赛阳镇','105',1262),(16231,'牯岭镇','176',1262),(16232,'虞家河乡','200',1262),(16233,'庐山茶科所','470',1262),(16234,'庐山林科所','471',1262),(16235,'甘棠街道','001',1263),(16236,'湓浦街道','002',1263),(16237,'人民路街道','003',1263),(16238,'白水湖街道','004',1263),(16239,'金鸡坡街道','005',1263),(16240,'向阳街道办事处(九江经济开发区)','091',1263),(16241,'滨兴街道办事处(九江经济开发区)','092',1263),(16242,'茅山头企业集团','400',1263),(16243,'沙河街镇','100',1264),(16244,'马回岭镇','101',1264),(16245,'江洲镇','102',1264),(16246,'城子镇','103',1264),(16247,'港口街镇','104',1264),(16248,'新合镇','105',1264),(16249,'狮子镇','106',1264),(16250,'永安乡','200',1264),(16251,'涌泉乡','201',1264),(16252,'新塘乡','202',1264),(16253,'城门乡','203',1264),(16254,'岷山乡','204',1264),(16255,'新洲垦殖场','400',1264),(16256,'赛城湖水产场','401',1264),(16257,'岷山林场','402',1264),(16258,'沙河经济技术开发区','500',1264),(16259,'新宁镇','100',1265),(16260,'泉口镇','101',1265),(16261,'鲁溪镇','102',1265),(16262,'船滩镇','103',1265),(16263,'澧溪镇','104',1265),(16264,'罗坪镇','105',1265),(16265,'石门楼镇','106',1265),(16266,'宋溪镇','107',1265),(16267,'大洞乡','200',1265),(16268,'横路乡','201',1265),(16269,'官莲乡','202',1265),(16270,'巾口乡','203',1265),(16271,'东林乡','204',1265),(16272,'上汤乡','205',1265),(16273,'甫田乡','206',1265),(16274,'清江乡','207',1265),(16275,'石渡乡','208',1265),(16276,'杨洲乡','209',1265),(16277,'罗溪乡','210',1265),(16278,'万福经济技术开发区管委会','500',1265),(16279,'义宁镇','100',1266),(16280,'白岭镇','101',1266),(16281,'全丰镇','102',1266),(16282,'古市镇','103',1266),(16283,'大桥镇','104',1266),(16284,'渣津镇','105',1266),(16285,'马坳镇','106',1266),(16286,'杭口镇','107',1266),(16287,'港口镇','108',1266),(16288,'溪口镇','109',1266),(16289,'西港镇','110',1266),(16290,'山口镇','111',1266),(16291,'黄沙镇','112',1266),(16292,'黄港镇','113',1266),(16293,'何市镇','114',1266),(16294,'上奉镇','115',1266),(16295,'四都镇','116',1266),(16296,'三都镇','117',1266),(16297,'路口乡','200',1266),(16298,'黄龙乡','201',1266),(16299,'上衫乡','202',1266),(16300,'余段乡','203',1266),(16301,'水源乡','204',1266),(16302,'石坳乡','205',1266),(16303,'东港乡','206',1266),(16304,'上杭乡','207',1266),(16305,'程坊乡','208',1266),(16306,'新湾乡','209',1266),(16307,'布甲乡','210',1266),(16308,'漫江乡','211',1266),(16309,'复源乡','212',1266),(16310,'竹坪乡','213',1266),(16311,'征村乡','214',1266),(16312,'庙岭乡','215',1266),(16313,'黄坳乡','216',1266),(16314,'大椿乡','217',1266),(16315,'涂埠镇','100',1267),(16316,'吴城镇','101',1267),(16317,'柘林镇','102',1267),(16318,'虬津镇','103',1267),(16319,'艾城镇','104',1267),(16320,'滩溪镇','105',1267),(16321,'白槎镇','106',1267),(16322,'梅棠镇','107',1267),(16323,'燕坊镇','108',1267),(16324,'马口镇','109',1267),(16325,'江益镇(共青开放开发区)','180',1267),(16326,'三角乡','200',1267),(16327,'九合乡','201',1267),(16328,'立新乡','202',1267),(16329,'江上乡','203',1267),(16330,'云山企业集团','400',1267),(16331,'恒丰企业集团','401',1267),(16332,'八角岭垦殖场','402',1267),(16333,'永丰垦殖场','403',1267),(16334,'柘林管理局','404',1267),(16335,'县农科所','405',1267),(16336,'茶山街道办事处(共青开放开发区)','084',1268),(16337,'蒲亭镇','100',1268),(16338,'聂桥镇','101',1268),(16339,'车桥镇','102',1268),(16340,'丰林镇','103',1268),(16341,'甘露镇(共青开放开发区)','182',1268),(16342,'金湖镇(共青开放开发区)','183',1268),(16343,'宝塔乡','200',1268),(16344,'河东乡','201',1268),(16345,'高塘乡','202',1268),(16346,'林泉乡','203',1268),(16347,'吴山乡','204',1268),(16348,'磨溪乡','205',1268),(16349,'爱民乡','206',1268),(16350,'邹桥乡','207',1268),(16351,'塘山乡','208',1268),(16352,'彭山林场','400',1268),(16353,'园艺场','401',1268),(16354,'南康镇','100',1269),(16355,'白鹿镇','101',1269),(16356,'温泉镇','102',1269),(16357,'蓼花镇','103',1269),(16358,'华林镇','104',1269),(16359,'蛟塘镇','105',1269),(16360,'横塘镇','106',1269),(16361,'蓼南乡','200',1269),(16362,'苏家当乡','201',1269),(16363,'泽泉乡','202',1269),(16364,'沙湖山管理处','400',1269),(16365,'东牯山林场','401',1269),(16366,'农科所','402',1269),(16367,'水稻良种场','403',1269),(16368,'都昌镇','100',1270),(16369,'周溪镇','101',1270),(16370,'三汊港镇','102',1270),(16371,'中馆镇','103',1270),(16372,'大沙镇','104',1270),(16373,'万户镇','105',1270),(16374,'南峰镇','106',1270),(16375,'土塘镇','107',1270),(16376,'大港镇','108',1270),(16377,'蔡岭镇','109',1270),(16378,'徐埠镇','110',1270),(16379,'左里镇','111',1270),(16380,'和合乡','200',1270),(16381,'阳峰乡','201',1270),(16382,'西源乡','202',1270),(16383,'芗溪乡','203',1270),(16384,'狮山乡','204',1270),(16385,'鸣山乡','205',1270),(16386,'春桥乡','206',1270),(16387,'苏山乡','207',1270),(16388,'多宝乡','208',1270),(16389,'汪墩乡','209',1270),(16390,'北山乡','210',1270),(16391,'大树乡','211',1270),(16392,'江西省对外经济技术合作蔡岭示范区','400',1270),(16393,'都昌县良种场','401',1270),(16394,'双钟镇','100',1271),(16395,'流泗镇','101',1271),(16396,'马影镇','102',1271),(16397,'武山镇','103',1271),(16398,'城山镇','104',1271),(16399,'大垅乡','200',1271),(16400,'凰村乡','201',1271),(16401,'张青乡','202',1271),(16402,'文桥乡','203',1271),(16403,'付垅乡','204',1271),(16404,'舜德乡','205',1271),(16405,'流芳乡','206',1271),(16406,'南北港水产场','400',1271),(16407,'武山垦殖场','401',1271),(16408,'龙城镇','100',1272),(16409,'棉船镇','101',1272),(16410,'马','102',1272),(16411,'芙蓉墩镇','103',1272),(16412,'定山镇','104',1272),(16413,'天红镇','105',1272),(16414,'杨梓镇','106',1272),(16415,'东升镇','107',1272),(16416,'浪溪镇','108',1272),(16417,'黄花镇','109',1272),(16418,'太平关乡','200',1272),(16419,'黄岭乡','201',1272),(16420,'浩山乡','202',1272),(16421,'太泊湖农业综合开发区','400',1272),(16422,'上十岭综合垦殖场','401',1272),(16423,'芙蓉农场','402',1272),(16424,'建筑材料厂','403',1272),(16425,'水产养殖场','404',1272),(16426,'棉科所','405',1272),(16427,'棉花原种场国营分场','406',1272),(16428,'太泊湖水产养殖场','407',1272),(16429,'黄乐林场','408',1272),(16430,'湓城街道办事处','001',1273),(16431,'桂林街道办事处','002',1273),(16432,'码头镇','100',1273),(16433,'白杨镇','101',1273),(16434,'南义镇','102',1273),(16435,'横港镇','103',1273),(16436,'范镇','104',1273),(16437,'肇陈镇','105',1273),(16438,'高丰镇','106',1273),(16439,'夏畈镇','107',1273),(16440,'乐园乡','200',1273),(16441,'洪一乡','201',1273),(16442,'花园乡','202',1273),(16443,'洪下乡','203',1273),(16444,'武蛟乡','204',1273),(16445,'横立山乡','205',1273),(16446,'黄金乡','206',1273),(16447,'南阳乡','207',1273),(16448,'赛湖农场','400',1273),(16449,'青山林场','401',1273),(16450,'瑞昌市大德山林场','402',1273),(16451,'城南街道办事处','001',1275),(16452,'城北街道办事处','002',1275),(16453,'袁河街道办事处','003',1275),(16454,'水北镇','100',1275),(16455,'下村镇','101',1275),(16456,'良山镇','102',1275),(16457,'罗坊镇','103',1275),(16458,'姚圩镇','104',1275),(16459,'珠珊镇','105',1275),(16460,'观巢镇','106',1275),(16461,'欧里镇','107',1275),(16462,'河下镇(仙女湖管理区）','170',1275),(16463,'水西镇（经济技术开发区)','190',1275),(16464,'鹄山乡','200',1275),(16465,'人和乡','201',1275),(16466,'界水乡','202',1275),(16467,'南安乡','203',1275),(16468,'新溪乡','204',1275),(16469,'九龙山乡（仙女湖管理区）','271',1275),(16470,'新钢街道办事处','400',1275),(16471,'分宜镇','100',1276),(16472,'杨桥镇','101',1276),(16473,'湖泽镇','102',1276),(16474,'双林镇','103',1276),(16475,'钤山镇','104',1276),(16476,'凤阳乡','200',1276),(16477,'洞村乡','201',1276),(16478,'高岚乡','202',1276),(16479,'操场乡','203',1276),(16480,'洋江乡','204',1276),(16481,'分宜县芳山林场','400',1276),(16482,'山下林场','402',1276),(16483,'上村林场','403',1276),(16484,'长埠林场','404',1276),(16485,'东坑林场（仙女湖管理区）','473',1276),(16486,'城西工业园管理委员会（乡级开发区）','500',1276),(16487,'江边街道办事处','001',1278),(16488,'交通街道办事处','002',1278),(16489,'东湖街道办事处','003',1278),(16490,'梅园街道办事处','004',1278),(16491,'四青街道办事处','005',1278),(16492,'白露街道办事处','006',1278),(16493,'童家镇','100',1278),(16494,'夏埠乡','200',1278),(16495,'邓埠镇','100',1279),(16496,'锦江镇','101',1279),(16497,'潢溪镇','102',1279),(16498,'中童镇','103',1279),(16499,'马荃镇','104',1279),(16500,'画桥镇','105',1279),(16501,'平定乡','200',1279),(16502,'春涛乡','201',1279),(16503,'杨溪乡','202',1279),(16504,'洪湖乡','203',1279),(16505,'黄庄乡','204',1279),(16506,'高公寨营林场','400',1279),(16507,'刘家站垦殖场','401',1279),(16508,'邓家埠水稻原种场','402',1279),(16509,'余江县水产场','403',1279),(16510,'塘潮源林场','404',1279),(16511,'张公桥农场','405',1279),(16512,'青年综合垦殖场','406',1279),(16513,'大桥农场','407',1279),(16514,'余江县工业园区','500',1279),(16515,'花园街道','001',1280),(16516,'雄石街道','002',1280),(16517,'东门街道','003',1280),(16518,'泗沥镇','100',1280),(16519,'河潭镇','101',1280),(16520,'周坊镇','102',1280),(16521,'鸿塘镇','103',1280),(16522,'志光镇','104',1280),(16523,'流口镇','105',1280),(16524,'罗河镇','106',1280),(16525,'金屯镇','107',1280),(16526,'塘湾镇','108',1280),(16527,'文坊镇','109',1280),(16528,'冷水镇','110',1280),(16529,'龙虎山镇（龙虎山风景旅游区管委会）','190',1280),(16530,'上清镇(龙虎山风景旅游区管委会)','191',1280),(16531,'滨江乡','200',1280),(16532,'白田乡','201',1280),(16533,'雷溪乡','202',1280),(16534,'彭湾乡','203',1280),(16535,'樟坪畲族乡','204',1280),(16536,'耳口乡','205',1280),(16537,'余家乡','206',1280),(16538,'塔桥园艺场','400',1280),(16539,'河潭埠垦殖场','401',1280),(16540,'西窑林场','402',1280),(16541,'双圳林场','403',1280),(16542,'耳口林场','404',1280),(16543,'冷水林场','405',1280),(16544,'三县岭林场','406',1280),(16545,'上清林场(龙虎山风景旅游区管委会)','492',1280),(16546,'贵溪市工业园区','500',1280),(16547,'解放街道办事处','001',1282),(16548,'赣江街道办事处','002',1282),(16549,'南外街道办事处','003',1282),(16550,'东外街道办事处','004',1282),(16551,'黄金岭街道办事处(黄金开发区）','091',1282),(16552,'沙石镇','100',1282),(16553,'水东镇','101',1282),(16554,'水南镇','102',1282),(16555,'湖边镇','103',1282),(16556,'沙河镇','104',1282),(16557,'水西镇','105',1282),(16558,'蟠龙镇(黄金开发区）','190',1282),(16559,'赣南工业园','500',1282),(16560,'沙河工业园','501',1282),(16561,'梅林镇','100',1283),(16562,'王母渡镇','101',1283),(16563,'沙地镇','102',1283),(16564,'江口镇','103',1283),(16565,'田村镇','104',1283),(16566,'南塘镇','105',1283),(16567,'茅店镇','106',1283),(16568,'吉埠镇','107',1283),(16569,'五云镇','108',1283),(16570,'韩坊乡','200',1283),(16571,'阳埠乡','201',1283),(16572,'大埠乡','202',1283),(16573,'长洛乡','203',1283),(16574,'大田乡','204',1283),(16575,'湖江乡','205',1283),(16576,'储潭乡','206',1283),(16577,'石芫乡','207',1283),(16578,'三溪乡','208',1283),(16579,'白鹭乡','209',1283),(16580,'赣县工业园','500',1283),(16581,'嘉定镇','100',1284),(16582,'大塘埠镇','101',1284),(16583,'古陂镇','102',1284),(16584,'大桥镇','103',1284),(16585,'新田镇','104',1284),(16586,'安西镇','105',1284),(16587,'小江镇','106',1284),(16588,'铁石口镇','107',1284),(16589,'大阿镇','108',1284),(16590,'油山镇','109',1284),(16591,'小河镇','110',1284),(16592,'西牛镇','111',1284),(16593,'正平镇','112',1284),(16594,'虎山乡','200',1284),(16595,'崇仙乡','201',1284),(16596,'万隆乡','202',1284),(16597,'信丰县工业园','500',1284),(16598,'南安镇','100',1285),(16599,'新城镇','101',1285),(16600,'樟斗镇','102',1285),(16601,'池江镇','103',1285),(16602,'青龙镇','104',1285),(16603,'左拔镇','105',1285),(16604,'黄龙镇','106',1285),(16605,'吉村镇','107',1285),(16606,'浮江乡','200',1285),(16607,'河洞乡','201',1285),(16608,'内良乡','202',1285),(16609,'新世纪工业园','500',1285),(16610,'东山镇','100',1286),(16611,'陡水镇','101',1286),(16612,'社溪镇','102',1286),(16613,'营前镇','103',1286),(16614,'黄埠镇','104',1286),(16615,'梅水乡','200',1286),(16616,'油石乡','201',1286),(16617,'安和乡','202',1286),(16618,'寺下乡','203',1286),(16619,'双溪乡','204',1286),(16620,'水岩乡','205',1286),(16621,'平富乡','206',1286),(16622,'五指峰乡','207',1286),(16623,'紫阳乡','208',1286),(16624,'上犹县黄埠工业区','500',1286),(16625,'横水镇','100',1287),(16626,'扬眉镇','101',1287),(16627,'过埠镇','102',1287),(16628,'铅厂镇','103',1287),(16629,'长龙镇','104',1287),(16630,'关田镇','105',1287),(16631,'龙勾乡','200',1287),(16632,'杰坝乡','201',1287),(16633,'金坑乡','202',1287),(16634,'思顺乡','203',1287),(16635,'麟潭乡','204',1287),(16636,'上堡乡','205',1287),(16637,'聂都乡','206',1287),(16638,'文英乡','207',1287),(16639,'乐洞乡','208',1287),(16640,'丰州乡','209',1287),(16641,'天台山林场','400',1287),(16642,'欣山镇','100',1288),(16643,'孔田镇','101',1288),(16644,'版石镇','102',1288),(16645,'天心镇','103',1288),(16646,'龙布镇','104',1288),(16647,'鹤子镇','105',1288),(16648,'三百山镇','106',1288),(16649,'车头镇','107',1288),(16650,'镇岗乡','200',1288),(16651,'凤山乡','201',1288),(16652,'新龙乡','202',1288),(16653,'蔡坊乡','203',1288),(16654,'重石乡','204',1288),(16655,'长沙乡','205',1288),(16656,'浮槎乡','206',1288),(16657,'双芫乡','207',1288),(16658,'塘村乡','208',1288),(16659,'高云山乡','209',1288),(16660,'九龙工业园','500',1288),(16661,'龙南镇','100',1289),(16662,'武当镇','101',1289),(16663,'杨村镇','102',1289),(16664,'汶龙镇','103',1289),(16665,'程龙镇','104',1289),(16666,'关西镇','105',1289),(16667,'里仁镇','106',1289),(16668,'渡江镇','107',1289),(16669,'桃江乡','200',1289),(16670,'东江乡','201',1289),(16671,'临塘乡','202',1289),(16672,'南亨乡','203',1289),(16673,'夹湖乡','204',1289),(16674,'安基山林场','400',1289),(16675,'九连山林场','401',1289),(16676,'金塘开发区','500',1289),(16677,'历市镇','100',1290),(16678,'岿美山镇','101',1290),(16679,'老城镇','102',1290),(16680,'天九镇','103',1290),(16681,'龙塘镇','104',1290),(16682,'岭北镇','105',1290),(16683,'鹅公镇','106',1290),(16684,'定南县工业园','500',1290),(16685,'城厢镇','100',1291),(16686,'大吉山镇','101',1291),(16687,'陂头镇','102',1291),(16688,'金龙镇','103',1291),(16689,'南迳镇','104',1291),(16690,'龙源坝镇','105',1291),(16691,'中寨乡','200',1291),(16692,'社迳乡','201',1291),(16693,'龙下乡','202',1291),(16694,'大吉山矿社区管理委员会','400',1291),(16695,'茅山林场','401',1291),(16696,'全南县工业园','500',1291),(16697,'梅江镇','100',1292),(16698,'青塘镇','101',1292),(16699,'长胜镇　','102',1292),(16700,'黄陂镇　　','103',1292),(16701,'固村镇　　','104',1292),(16702,'赖村镇　','105',1292),(16703,'石上镇','106',1292),(16704,'东山坝镇','107',1292),(16705,'洛口镇','108',1292),(16706,'小布镇','109',1292),(16707,'黄石镇','110',1292),(16708,'田头镇','111',1292),(16709,'竹笮乡　　','200',1292),(16710,'对坊乡','201',1292),(16711,'固厚乡','202',1292),(16712,'田埠乡','203',1292),(16713,'会同乡　','204',1292),(16714,'湛田乡','205',1292),(16715,'安福乡　','206',1292),(16716,'东韶乡','207',1292),(16717,'肖田乡　','208',1292),(16718,'钓峰乡　','209',1292),(16719,'大沽乡','210',1292),(16720,'蔡江乡　　','211',1292),(16721,'宁都县水东工业园','500',1292),(16722,'贡江镇','100',1293),(16723,'铁山垅镇','101',1293),(16724,'盘古山镇','102',1293),(16725,'禾丰镇','103',1293),(16726,'祁禄山镇','104',1293),(16727,'梓山镇','105',1293),(16728,'银坑镇','106',1293),(16729,'岭背镇','107',1293),(16730,'罗坳镇','108',1293),(16731,'罗江乡','200',1293),(16732,'小溪乡','201',1293),(16733,'利村乡','202',1293),(16734,'新陂乡','203',1293),(16735,'靖石乡','204',1293),(16736,'黄麟乡','205',1293),(16737,'沙心乡','206',1293),(16738,'宽田乡','207',1293),(16739,'葛坳乡','208',1293),(16740,'桥头乡','209',1293),(16741,'马安乡','210',1293),(16742,'仙下乡','211',1293),(16743,'车溪乡','212',1293),(16744,'段屋乡','213',1293),(16745,'于都工业园','500',1293),(16746,'潋江镇','100',1294),(16747,'江背镇','101',1294),(16748,'古龙冈镇','102',1294),(16749,'梅窖镇','103',1294),(16750,'高兴镇','104',1294),(16751,'良村镇','105',1294),(16752,'龙口镇','106',1294),(16753,'兴江乡','200',1294),(16754,'樟木乡','201',1294),(16755,'东村乡','202',1294),(16756,'兴莲乡','203',1294),(16757,'杰村乡','204',1294),(16758,'社富乡','205',1294),(16759,'埠头乡','206',1294),(16760,'永丰乡','207',1294),(16761,'隆坪乡','208',1294),(16762,'均村乡','209',1294),(16763,'茶园乡','210',1294),(16764,'崇贤乡','211',1294),(16765,'枫边乡','212',1294),(16766,'南坑乡','213',1294),(16767,'城岗乡','214',1294),(16768,'方太乡','215',1294),(16769,'鼎龙乡','216',1294),(16770,'长冈乡','217',1294),(16771,'兴国县工业园','500',1294),(16772,'文武坝镇','100',1295),(16773,'筠门岭镇','101',1295),(16774,'西江镇','102',1295),(16775,'周田镇','103',1295),(16776,'麻州镇','104',1295),(16777,'庄口镇','105',1295),(16778,'清溪乡','200',1295),(16779,'右水乡','201',1295),(16780,'高排乡','202',1295),(16781,'晓龙乡','203',1295),(16782,'珠兰乡','204',1295),(16783,'洞头乡','205',1295),(16784,'中村乡','206',1295),(16785,'站塘乡','207',1295),(16786,'永隆乡','208',1295),(16787,'富城乡','209',1295),(16788,'小密乡','210',1295),(16789,'庄埠乡','211',1295),(16790,'白鹅乡','212',1295),(16791,'会昌县燕子窝工业园','500',1295),(16792,'长宁镇','100',1296),(16793,'晨光镇','101',1296),(16794,'留车镇','102',1296),(16795,'南桥镇','103',1296),(16796,'吉潭镇','104',1296),(16797,'澄江镇','105',1296),(16798,'桂竹帽镇','106',1296),(16799,'文峰乡','200',1296),(16800,'三标乡','201',1296),(16801,'菖蒲乡','202',1296),(16802,'龙廷乡','203',1296),(16803,'丹溪乡','204',1296),(16804,'项山乡','205',1296),(16805,'水源乡','206',1296),(16806,'罗珊乡','207',1296),(16807,'琴江镇','100',1297),(16808,'小松镇','101',1297),(16809,'屏山镇','102',1297),(16810,'横江镇','103',1297),(16811,'高田镇','104',1297),(16812,'木兰乡','200',1297),(16813,'丰山乡','201',1297),(16814,'大由乡','202',1297),(16815,'龙岗乡','203',1297),(16816,'珠坑乡','204',1297),(16817,'象湖镇','100',1298),(16818,'瑞林镇','101',1298),(16819,'壬田镇','102',1298),(16820,'九堡镇','103',1298),(16821,'沙洲坝镇','104',1298),(16822,'谢坊镇','105',1298),(16823,'武阳镇','106',1298),(16824,'叶坪乡','200',1298),(16825,'丁陂乡','201',1298),(16826,'大柏地乡','202',1298),(16827,'岗面乡','203',1298),(16828,'日东乡','204',1298),(16829,'万田乡','205',1298),(16830,'黄柏乡','206',1298),(16831,'云石山乡','207',1298),(16832,'泽覃乡','208',1298),(16833,'拔英乡','209',1298),(16834,'瑞金市工业园','500',1298),(16835,'蓉江街道办事处','001',1299),(16836,'东山街道办事处','002',1299),(16837,'唐江镇','100',1299),(16838,'凤岗镇','101',1299),(16839,'潭口镇','102',1299),(16840,'龙岭镇','103',1299),(16841,'龙回镇','104',1299),(16842,'镜坝镇','105',1299),(16843,'横市镇','106',1299),(16844,'潭东镇(黄金开发区）','192',1299),(16845,'浮石乡','200',1299),(16846,'赤土畲族乡','201',1299),(16847,'横寨乡','202',1299),(16848,'朱坊乡','203',1299),(16849,'太窝乡','204',1299),(16850,'三江乡','205',1299),(16851,'龙华乡','206',1299),(16852,'十八塘乡','207',1299),(16853,'麻双乡','208',1299),(16854,'大坪乡','209',1299),(16855,'坪市乡','210',1299),(16856,'隆木乡','211',1299),(16857,'南康市工业园','500',1299),(16858,'古南街道办事处','001',1301),(16859,'永叔街道办事处','002',1301),(16860,'文山街道办事处','003',1301),(16861,'习溪桥街道办事处','004',1301),(16862,'北门街道办事处','005',1301),(16863,'白塘街道办事处','006',1301),(16864,'兴桥镇','100',1301),(16865,'樟山镇','101',1301),(16866,'长塘镇','102',1301),(16867,'禾埠乡','200',1301),(16868,'曲濑乡','202',1301),(16869,'吉州区工业园小区','500',1301),(16870,'河东街道办事处','001',1302),(16871,'天玉镇','100',1302),(16872,'值夏镇','101',1302),(16873,'新圩镇','102',1302),(16874,'富滩镇','103',1302),(16875,'富田镇','104',1302),(16876,'文陂乡','200',1302),(16877,'东固畲族少数民族乡','201',1302),(16878,'东固垦殖场','400',1302),(16879,'青原区河东经济开发区','500',1302),(16880,'敦厚镇','100',1303),(16881,'永阳镇','101',1303),(16882,'天河镇','102',1303),(16883,'横江镇','103',1303),(16884,'固江镇','104',1303),(16885,'万福镇','105',1303),(16886,'永和镇','106',1303),(16887,'桐坪镇','107',1303),(16888,'凤凰镇','108',1303),(16889,'油田镇','109',1303),(16890,'敖城镇','110',1303),(16891,'北源乡','200',1303),(16892,'大冲乡','201',1303),(16893,'里田乡','202',1303),(16894,'梅塘乡','203',1303),(16895,'登龙乡','204',1303),(16896,'安塘乡','205',1303),(16897,'官田乡','206',1303),(16898,'指阳乡','207',1303),(16899,'吉安市高新技术开发区','500',1303),(16900,'吉安县工业园区','501',1303),(16901,'文峰镇','100',1304),(16902,'阜田镇','101',1304),(16903,'盘谷镇','102',1304),(16904,'枫江镇','103',1304),(16905,'黄桥镇','104',1304),(16906,'金滩镇','105',1304),(16907,'八都镇','106',1304),(16908,'双村镇','107',1304),(16909,'醪桥镇','108',1304),(16910,'螺田镇','109',1304),(16911,'白沙镇','110',1304),(16912,'白水镇','111',1304),(16913,'丁江镇','112',1304),(16914,'乌江镇','113',1304),(16915,'水南镇','114',1304),(16916,'尚贤乡','200',1304),(16917,'水田乡','201',1304),(16918,'冠山乡','202',1304),(16919,'吉水县工业园区','500',1304),(16920,'水边镇','100',1305),(16921,'马埠镇','101',1305),(16922,'巴邱镇','102',1305),(16923,'仁和镇','103',1305),(16924,'砚溪镇','104',1305),(16925,'罗田镇','105',1305),(16926,'桐林乡','200',1305),(16927,'福民乡','201',1305),(16928,'戈坪乡','202',1305),(16929,'金江乡','203',1305),(16930,'金坪华侨农场','400',1305),(16931,'峡江县工业园区','500',1305),(16932,'金川镇','100',1306),(16933,'三湖镇','101',1306),(16934,'大洋洲镇','102',1306),(16935,'七琴镇','103',1306),(16936,'麦斜镇','104',1306),(16937,'溧江乡','200',1306),(16938,'桃溪乡','201',1306),(16939,'城上乡','202',1306),(16940,'潭丘乡','203',1306),(16941,'神政桥乡','204',1306),(16942,'沂江乡','205',1306),(16943,'界埠乡','206',1306),(16944,'荷浦乡','207',1306),(16945,'洋峰农场','400',1306),(16946,'黎山林场','401',1306),(16947,'263地质大队','403',1306),(16948,'新干工业园区','500',1306),(16949,'恩江镇','100',1307),(16950,'坑田镇','101',1307),(16951,'沿陂镇','102',1307),(16952,'古县镇','103',1307),(16953,'瑶田镇','104',1307),(16954,'藤田镇','105',1307),(16955,'石马镇','106',1307),(16956,'沙溪镇','107',1307),(16957,'佐龙乡','200',1307),(16958,'八江乡','201',1307),(16959,'潭城乡','202',1307),(16960,'鹿冈乡','203',1307),(16961,'七都乡','204',1307),(16962,'陶塘乡','205',1307),(16963,'中村乡','206',1307),(16964,'上溪乡','207',1307),(16965,'潭头乡','208',1307),(16966,'三坊乡','209',1307),(16967,'上固乡','210',1307),(16968,'君埠乡','211',1307),(16969,'龙冈畲族乡','212',1307),(16970,'罗铺垦殖场','400',1307),(16971,'官山林场','402',1307),(16972,'永丰县工业园区','500',1307),(16973,'澄江镇','100',1308),(16974,'碧溪镇','101',1308),(16975,'桥头镇','102',1308),(16976,'禾市镇','103',1308),(16977,'螺溪镇','104',1308),(16978,'苏溪镇','105',1308),(16979,'马市镇','106',1308),(16980,'塘洲镇','107',1308),(16981,'冠朝镇','108',1308),(16982,'沙村镇','109',1308),(16983,'老营盘镇','110',1308),(16984,'小龙镇','111',1308),(16985,'灌溪镇','112',1308),(16986,'苑前镇','113',1308),(16987,'万合镇','114',1308),(16988,'沿溪镇','115',1308),(16989,'石山乡','200',1308),(16990,'南溪乡','201',1308),(16991,'上模乡','202',1308),(16992,'水槎乡','203',1308),(16993,'上圯乡','204',1308),(16994,'中龙乡','205',1308),(16995,'武山垦殖场','400',1308),(16996,'综合垦殖场','401',1308),(16997,'小龙矿区管委会','402',1308),(16998,'八一八矿区','403',1308),(16999,'井冈山机场','404',1308),(17000,'泰和县工业园区','500',1308),(17001,'泉江镇','100',1309),(17002,'雩田镇','101',1309),(17003,'碧洲镇','102',1309),(17004,'草林镇','103',1309),(17005,'堆子前镇','104',1309),(17006,'左安镇','105',1309),(17007,'高坪镇','106',1309),(17008,'大汾镇','107',1309),(17009,'衙前镇','108',1309),(17010,'禾源镇','109',1309),(17011,'汤湖镇','110',1309),(17012,'珠田乡','200',1309),(17013,'巾石乡','201',1309),(17014,'大坑乡','202',1309),(17015,'枚江乡','203',1309),(17016,'双桥乡','204',1309),(17017,'新江乡','205',1309),(17018,'五斗江乡','206',1309),(17019,'西溪乡','207',1309),(17020,'南江乡','208',1309),(17021,'黄坑乡','209',1309),(17022,'戴家埔乡','210',1309),(17023,'营盘圩乡','211',1309),(17024,'五指峰林场','400',1309),(17025,'云岭林场','401',1309),(17026,'遂川县工业园区','500',1309),(17027,'芙蓉镇','100',1310),(17028,'五丰镇','101',1310),(17029,'枧头镇','102',1310),(17030,'窑头镇','103',1310),(17031,'百加镇','104',1310),(17032,'高陂镇','105',1310),(17033,'潞田镇','106',1310),(17034,'沙坪镇','107',1310),(17035,'夏造镇','108',1310),(17036,'罗塘乡','200',1310),(17037,'弹前乡','201',1310),(17038,'武术乡','202',1310),(17039,'宝山乡','203',1310),(17040,'涧田乡','204',1310),(17041,'顺峰乡','205',1310),(17042,'韶口乡','206',1310),(17043,'万安县麻源垦殖场','400',1310),(17044,'万安县工业园','500',1310),(17045,'平都镇','100',1311),(17046,'浒坑镇','101',1311),(17047,'洲湖镇','102',1311),(17048,'横龙镇','103',1311),(17049,'洋溪镇','104',1311),(17050,'严田镇','105',1311),(17051,'枫田镇','106',1311),(17052,'竹江乡','200',1311),(17053,'瓜畲乡','201',1311),(17054,'钱山乡','202',1311),(17055,'赤谷乡','203',1311),(17056,'山庄乡','204',1311),(17057,'洋门乡','205',1311),(17058,'金田乡','206',1311),(17059,'彭坊乡','207',1311),(17060,'泰山乡','208',1311),(17061,'寮塘乡','209',1311),(17062,'甘洛乡','210',1311),(17063,'章庄乡','211',1311),(17064,'安福县工业园','500',1311),(17065,'禾川镇','100',1312),(17066,'石桥镇','101',1312),(17067,'龙源口镇','102',1312),(17068,'里田镇','103',1312),(17069,'龙门镇','104',1312),(17070,'沙市镇','105',1312),(17071,'文竹镇','106',1312),(17072,'埠前镇','107',1312),(17073,'怀忠镇','108',1312),(17074,'高桥楼镇','109',1312),(17075,'坳南乡','200',1312),(17076,'曲白乡','201',1312),(17077,'才丰乡','202',1312),(17078,'烟阁乡','203',1312),(17079,'在中乡','204',1312),(17080,'三湾乡','205',1312),(17081,'台岭乡','206',1312),(17082,'龙田乡','207',1312),(17083,'高溪乡','208',1312),(17084,'莲洲乡','209',1312),(17085,'高市乡','210',1312),(17086,'象形乡','211',1312),(17087,'芦溪乡','212',1312),(17088,'永新县工业园区','500',1312),(17089,'茨坪街道办事处','001',1313),(17090,'厦坪镇','100',1313),(17091,'龙市镇','101',1313),(17092,'古城镇','102',1313),(17093,'新城镇','103',1313),(17094,'大陇镇','104',1313),(17095,'拿山乡','200',1313),(17096,'黄坳乡','201',1313),(17097,'下七乡','202',1313),(17098,'长坪乡','203',1313),(17099,'坳里乡','204',1313),(17100,'鹅岭乡','205',1313),(17101,'柏露乡','206',1313),(17102,'茅坪乡','207',1313),(17103,'葛田乡','208',1313),(17104,'荷花乡','209',1313),(17105,'睦村乡','210',1313),(17106,'东上乡','211',1313),(17107,'井企集团','400',1313),(17108,'井冈山自然保护区','401',1313),(17109,'白石垦殖场','402',1313),(17110,'井冈山市工业园区','500',1313),(17111,'灵泉街道','001',1315),(17112,'秀江街道','002',1315),(17113,'湛郎街道','004',1315),(17114,'珠泉街道','005',1315),(17115,'化成街道','006',1315),(17116,'官园街道','007',1315),(17117,'下浦街道','008',1315),(17118,'凤凰街道','009',1315),(17119,'金园街道','010',1315),(17120,'彬江镇','100',1315),(17121,'西村镇','101',1315),(17122,'金瑞镇','102',1315),(17123,'温汤镇','103',1315),(17124,'三阳镇','104',1315),(17125,'慈化镇','105',1315),(17126,'天台镇','106',1315),(17127,'洪塘镇','107',1315),(17128,'渥江乡','200',1315),(17129,'新坊乡','201',1315),(17130,'洪江乡','202',1315),(17131,'南庙乡','203',1315),(17132,'竹亭乡','204',1315),(17133,'水江乡','205',1315),(17134,'楠木乡','206',1315),(17135,'辽市乡','207',1315),(17136,'寨下乡','208',1315),(17137,'芦村乡','209',1315),(17138,'柏木乡','210',1315),(17139,'湖田乡','211',1315),(17140,'新田乡','212',1315),(17141,'飞剑潭乡','213',1315),(17142,'农牧实验场','400',1315),(17143,'西岭布果园场','401',1315),(17144,'明月山采育林场','402',1315),(17145,'新坊采育林场','403',1315),(17146,'油茶林场','404',1315),(17147,'宜春经济枝术开发区','500',1315),(17148,'袁州区医药工业园','501',1315),(17149,'冯川镇','100',1316),(17150,'赤岸镇','101',1316),(17151,'赤田镇','102',1316),(17152,'宋埠镇','103',1316),(17153,'干洲镇','104',1316),(17154,'澡下镇','105',1316),(17155,'会埠镇','106',1316),(17156,'罗市镇','107',1316),(17157,'上富镇','108',1316),(17158,'甘坊镇','109',1316),(17159,'仰山乡','200',1316),(17160,'澡溪乡','201',1316),(17161,'柳溪乡','202',1316),(17162,'石溪办事处','400',1316),(17163,'百丈山名胜风景区','401',1316),(17164,'干洲垦殖场','402',1316),(17165,'东风垦殖场','403',1316),(17166,'农牧渔良种场','404',1316),(17167,'奉新工业园区','500',1316),(17168,'康乐街道','001',1317),(17169,'株潭镇','100',1317),(17170,'黄茅镇','101',1317),(17171,'潭埠镇','102',1317),(17172,'双桥镇','103',1317),(17173,'高村镇','104',1317),(17174,'罗城镇','105',1317),(17175,'三兴镇','106',1317),(17176,'鹅峰乡','200',1317),(17177,'马步乡','201',1317),(17178,'高城乡','202',1317),(17179,'赤兴乡','203',1317),(17180,'岭东乡','204',1317),(17181,'白水乡','205',1317),(17182,'仙源乡','206',1317),(17183,'白良乡','207',1317),(17184,'茭湖乡','208',1317),(17185,'万载县工业园','500',1317),(17186,'敖阳街道','001',1318),(17187,'田心镇','100',1318),(17188,'徐家渡镇','101',1318),(17189,'锦江镇','102',1318),(17190,'泗溪镇','103',1318),(17191,'翰堂镇','104',1318),(17192,'南港镇','105',1318),(17193,'芦洲乡','200',1318),(17194,'塔下乡','201',1318),(17195,'蒙山乡','202',1318),(17196,'镇渡乡','203',1318),(17197,'野市乡','204',1318),(17198,'新界埠乡','205',1318),(17199,'墨山垦殖场','400',1318),(17200,'上甘山林场','401',1318),(17201,'敖山华侨农场','402',1318),(17202,'上高县工业园区','500',1318),(17203,'新昌镇','100',1319),(17204,'澄塘镇','101',1319),(17205,'棠浦镇','102',1319),(17206,'新庄镇','103',1319),(17207,'潭山镇','104',1319),(17208,'芳溪镇','105',1319),(17209,'石市镇','106',1319),(17210,'花桥乡','200',1319),(17211,'同安乡','201',1319),(17212,'天宝乡','202',1319),(17213,'黄岗乡','203',1319),(17214,'桥西乡','204',1319),(17215,'车上林场','400',1319),(17216,'双峰林场','401',1319),(17217,'石花尖垦殖场','402',1319),(17218,'黄岗山垦殖场','403',1319),(17219,'宜丰县工业园区','500',1319),(17220,'双溪镇','100',1320),(17221,'仁首镇','101',1320),(17222,'宝峰镇','102',1320),(17223,'高湖镇','103',1320),(17224,'躁都镇','104',1320),(17225,'香田乡','200',1320),(17226,'水口乡','201',1320),(17227,'中源乡','202',1320),(17228,'罗湾乡','203',1320),(17229,'三爪仑乡','205',1320),(17230,'雷公尖垦殖场','400',1320),(17231,'靖安县工业园区','500',1320),(17232,'永宁镇','100',1321),(17233,'温泉镇','101',1321),(17234,'棋坪镇','102',1321),(17235,'排埠镇','103',1321),(17236,'三都镇','104',1321),(17237,'大段镇','105',1321),(17238,'高桥乡','200',1321),(17239,'港口乡','201',1321),(17240,'带溪乡','202',1321),(17241,'花山林场','400',1321),(17242,'大沩山林场','401',1321),(17243,'茶山林场','402',1321),(17244,'龙门林场','403',1321),(17245,'剑光街道','002',1322),(17246,'河洲街道','006',1322),(17247,'剑南街道','007',1322),(17248,'孙渡街道','008',1322),(17249,'尚庄街道','009',1322),(17250,'白土镇','101',1322),(17251,'袁渡镇','102',1322),(17252,'张巷镇','104',1322),(17253,'杜市镇','105',1322),(17254,'淘沙镇','106',1322),(17255,'秀市镇','107',1322),(17256,'洛市镇','109',1322),(17257,'铁路镇','110',1322),(17258,'丽村镇','111',1322),(17259,'董家镇','115',1322),(17260,'隍城镇','116',1322),(17261,'小港镇','119',1322),(17262,'石滩镇','120',1322),(17263,'桥东镇','121',1322),(17264,'荣塘镇','122',1322),(17265,'拖船镇','123',1322),(17266,'泉港镇','124',1322),(17267,'梅林镇','125',1322),(17268,'曲江镇','126',1322),(17269,'上塘镇','127',1322),(17270,'筱塘乡','201',1322),(17271,'段潭乡','202',1322),(17272,'蕉坑乡','203',1322),(17273,'石江乡','204',1322),(17274,'荷湖乡','205',1322),(17275,'湖塘乡','206',1322),(17276,'同田乡','207',1322),(17277,'丰城矿务局','400',1322),(17278,'江西省新洛煤电有限责任公司','401',1322),(17279,'丰城市工业园','402',1322),(17280,'淦阳街道','001',1323),(17281,'鹿江街道','002',1323),(17282,'福城街道','003',1323),(17283,'大桥街道','004',1323),(17284,'城北街道','005',1323),(17285,'临江镇','100',1323),(17286,'永泰镇','101',1323),(17287,'黄土岗镇','102',1323),(17288,'经楼镇','103',1323),(17289,'昌付镇','104',1323),(17290,'店下镇','105',1323),(17291,'阁山镇','106',1323),(17292,'刘公庙镇','107',1323),(17293,'观上镇','108',1323),(17294,'义成镇','109',1323),(17295,'中洲乡','200',1323),(17296,'洲上乡','201',1323),(17297,'洋湖乡','202',1323),(17298,'吴城乡','203',1323),(17299,'省双金园艺场','400',1323),(17300,'樟树市工业园','500',1323),(17301,'瑞州街道','001',1324),(17302,'筠阳街道','002',1324),(17303,'蓝坊镇','100',1324),(17304,'荷岭镇','101',1324),(17305,'黄沙岗镇','102',1324),(17306,'新街镇','103',1324),(17307,'八景镇','104',1324),(17308,'独城镇','105',1324),(17309,'太阳镇','106',1324),(17310,'建山镇','107',1324),(17311,'田南镇','108',1324),(17312,'相城镇','109',1324),(17313,'灰埠镇','110',1324),(17314,'石脑镇','111',1324),(17315,'龙潭镇','112',1324),(17316,'杨圩镇','113',1324),(17317,'村前镇','114',1324),(17318,'伍桥镇','115',1324),(17319,'祥符镇','116',1324),(17320,'大城镇','117',1324),(17321,'上湖乡','200',1324),(17322,'汪家圩乡','201',1324),(17323,'相城垦殖场','401',1324),(17324,'上游水库工程管理局','402',1324),(17325,'英岗岭矿务局','403',1324),(17326,'八景煤矿','404',1324),(17327,'江西新茂实业公司','405',1324),(17328,'江西省瑞州监狱','406',1324),(17329,'高安市新世纪工业城管委会','500',1324),(17330,'青云街道办事处','001',1326),(17331,'西大街街道办事处','002',1326),(17332,'荆公路街道办事处','003',1326),(17333,'六水桥街道办事处','004',1326),(17334,'文昌街道办事处','005',1326),(17335,'城西街道办事处(金巢开发区)','091',1326),(17336,'钟岭街道办事处(金巢开发区)','092',1326),(17337,'上顿渡镇','100',1326),(17338,'温泉镇','101',1326),(17339,'高坪镇','102',1326),(17340,'秋溪镇','103',1326),(17341,'荣山镇','104',1326),(17342,'龙溪镇','105',1326),(17343,'大岗镇','107',1326),(17344,'云山镇','108',1326),(17345,'唱凯镇','109',1326),(17346,'罗针镇','110',1326),(17347,'罗湖镇','111',1326),(17348,'太阳镇','112',1326),(17349,'东馆镇','113',1326),(17350,'腾桥镇','114',1326),(17351,'青泥镇','115',1326),(17352,'孝桥镇','116',1326),(17353,'抚北镇','117',1326),(17354,'崇岗镇(金巢开发区)','190',1326),(17355,'展坪乡','200',1326),(17356,'连城乡','201',1326),(17357,'桐源乡','202',1326),(17358,'湖南乡','203',1326),(17359,'七里岗乡','204',1326),(17360,'嵩湖乡','205',1326),(17361,'鹏田乡','206',1326),(17362,'茅排乡','207',1326),(17363,'河埠乡','208',1326),(17364,'荣山垦殖场','400',1326),(17365,'七里岗垦殖场','401',1326),(17366,'开发区管理委员会','500',1326),(17367,'建昌镇','100',1327),(17368,'株良镇','101',1327),(17369,'上唐镇','102',1327),(17370,'里塔镇','103',1327),(17371,'洪门镇','104',1327),(17372,'沙洲镇','105',1327),(17373,'龙湖镇','106',1327),(17374,'新丰街镇','107',1327),(17375,'万坊镇','108',1327),(17376,'徐家乡','200',1327),(17377,'天井源乡','201',1327),(17378,'浔溪乡','203',1327),(17379,'日峰镇','100',1328),(17380,'宏村镇','101',1328),(17381,'洵口镇','102',1328),(17382,'熊村镇','103',1328),(17383,'龙安镇','104',1328),(17384,'德胜镇','105',1328),(17385,'潭溪乡','200',1328),(17386,'湖坊乡','201',1328),(17387,'荷源乡','202',1328),(17388,'厚村乡','203',1328),(17389,'社苹乡','204',1328),(17390,'樟溪乡','205',1328),(17391,'西城乡','206',1328),(17392,'中田乡','207',1328),(17393,'华山垦殖场','400',1328),(17394,'德胜企业集团','500',1328),(17395,'工业园区管委会','501',1328),(17396,'琴城镇','100',1329),(17397,'太和镇','101',1329),(17398,'白舍镇','102',1329),(17399,'市山镇','103',1329),(17400,'洽湾镇','104',1329),(17401,'桑田镇','105',1329),(17402,'紫霄镇','106',1329),(17403,'三溪乡','200',1329),(17404,'东坪乡','201',1329),(17405,'莱溪乡','202',1329),(17406,'太源乡','203',1329),(17407,'付坊乡','204',1329),(17408,'南丰县长红垦殖场','400',1329),(17409,'南丰工业园区','500',1329),(17410,'巴山镇','100',1330),(17411,'相山镇','101',1330),(17412,'航埠镇','102',1330),(17413,'孙坊镇','103',1330),(17414,'河上镇','104',1330),(17415,'礼陂镇','105',1330),(17416,'马鞍镇','106',1330),(17417,'石庄乡','200',1330),(17418,'六家桥乡','201',1330),(17419,'白鹭乡','202',1330),(17420,'三山乡','203',1330),(17421,'白陂乡','204',1330),(17422,'桃源乡','205',1330),(17423,'许坊乡','206',1330),(17424,'郭圩乡','207',1330),(17425,'鳌溪镇','100',1331),(17426,'公溪镇','101',1331),(17427,'山砀镇','102',1331),(17428,'龚坊镇','103',1331),(17429,'戴坊镇','104',1331),(17430,'牛田镇','105',1331),(17431,'万崇镇','106',1331),(17432,'增田镇','107',1331),(17433,'招携镇','108',1331),(17434,'湖溪乡','200',1331),(17435,'罗陂乡','201',1331),(17436,'湖坪乡','202',1331),(17437,'南村乡','203',1331),(17438,'谷岗乡','204',1331),(17439,'金竹畲族乡','205',1331),(17440,'大马头垦殖场','400',1331),(17441,'流坑管理局','401',1331),(17442,'凤冈镇','100',1332),(17443,'棠阴镇','101',1332),(17444,'黄陂镇','102',1332),(17445,'东陂镇','103',1332),(17446,'梨溪镇','104',1332),(17447,'二都镇','105',1332),(17448,'中港乡','200',1332),(17449,'新丰乡','201',1332),(17450,'神冈乡','202',1332),(17451,'圳口乡','203',1332),(17452,'南源乡','204',1332),(17453,'桃陂乡','205',1332),(17454,'黄柏岭垦殖场','400',1332),(17455,'青年垦殖场','401',1332),(17456,'宜黄县工业园区','500',1332),(17457,'秀谷镇','100',1333),(17458,'浒湾镇','101',1333),(17459,'双塘镇','102',1333),(17460,'何源镇','103',1333),(17461,'合市镇','104',1333),(17462,'琅琚镇','105',1333),(17463,'左坊镇','106',1333),(17464,'黄通乡','200',1333),(17465,'对桥乡','201',1333),(17466,'陆坊乡','202',1333),(17467,'陈坊积乡','203',1333),(17468,'琉璃乡','204',1333),(17469,'石门乡','205',1333),(17470,'华侨农场','400',1333),(17471,'鹤城镇','100',1334),(17472,'马头山镇','101',1334),(17473,'高埠镇','102',1334),(17474,'嵩市镇','103',1334),(17475,'乌石镇','104',1334),(17476,'高田乡','200',1334),(17477,'石峡乡','201',1334),(17478,'孝岗镇','100',1335),(17479,'小璜镇','101',1335),(17480,'圩上桥镇','102',1335),(17481,'马圩镇','103',1335),(17482,'詹圩镇','104',1335),(17483,'岗上积镇','105',1335),(17484,'杨桥殿镇','106',1335),(17485,'黎圩镇','107',1335),(17486,'王桥镇','108',1335),(17487,'珀','200',1335),(17488,'邓家乡','201',1335),(17489,'虎圩乡','202',1335),(17490,'瑶圩乡','203',1335),(17491,'红星企业集团','400',1335),(17492,'红光垦殖场','401',1335),(17493,'红亮垦殖场','402',1335),(17494,'甘坑林场','403',1335),(17495,'江西铜业集团公司东同矿业有限责任公司','404',1335),(17496,'江西磷肥厂','405',1335),(17497,'江西红星工业园区','500',1335),(17498,'大富工业园区','501',1335),(17499,'盱江镇','100',1336),(17500,'头陂镇','101',1336),(17501,'赤水镇','103',1336),(17502,'驿前镇','104',1336),(17503,'甘竹镇','105',1336),(17504,'千善乡','200',1336),(17505,'水南圩乡','201',1336),(17506,'长桥乡','202',1336),(17507,'杨溪乡','203',1336),(17508,'尖峰乡','204',1336),(17509,'塘坊乡','205',1336),(17510,'翠雷山垦殖场','400',1336),(17511,'广昌县工业园区','500',1336),(17512,'水南街道办事处','001',1338),(17513,'东市街道办事处','002',1338),(17514,'西市街道办事处','003',1338),(17515,'北门街道办事处','004',1338),(17516,'茅家岭街道','005',1338),(17517,'沙溪镇','100',1338),(17518,'灵溪镇','101',1338),(17519,'秦峰乡','201',1338),(17520,'朝阳乡','202',1338),(17521,'凤凰工业园区(上饶经济开发区)','570',1338),(17522,'三江工业基地(上饶经济开发区)','571',1338),(17523,'旭日街道办事处','001',1339),(17524,'罗桥街道办事处','002',1339),(17525,'田墩镇','101',1339),(17526,'上泸镇','102',1339),(17527,'华坛山镇','103',1339),(17528,'茶亭镇','104',1339),(17529,'皂头镇','105',1339),(17530,'四十八镇','106',1339),(17531,'枫岭头镇','107',1339),(17532,'煌固镇','108',1339),(17533,'花厅镇','109',1339),(17534,'五府山镇','110',1339),(17535,'郑坊镇','111',1339),(17536,'望仙乡','200',1339),(17537,'石人乡','201',1339),(17538,'清水乡','202',1339),(17539,'石狮乡','203',1339),(17540,'湖村乡','204',1339),(17541,'尊桥乡','207',1339),(17542,'应家乡','209',1339),(17543,'黄沙岭乡','210',1339),(17544,'铁山乡','211',1339),(17545,'董团乡(上饶经济开发区）','270',1339),(17546,'永丰街道办事处','001',1340),(17547,'芦林街道办事处','002',1340),(17548,'丰溪街道办事处','003',1340),(17549,'五都镇','101',1340),(17550,'洋口镇','102',1340),(17551,'横山镇','103',1340),(17552,'桐畈镇','104',1340),(17553,'湖丰镇','105',1340),(17554,'大南镇','106',1340),(17555,'排山镇','107',1340),(17556,'毛村镇','108',1340),(17557,'枧底镇','109',1340),(17558,'泉波镇','110',1340),(17559,'壶峤镇','111',1340),(17560,'霞峰镇','112',1340),(17561,'下溪镇','113',1340),(17562,'吴村镇','114',1340),(17563,'沙田镇','115',1340),(17564,'铜拔山镇','116',1340),(17565,'大石乡','200',1340),(17566,'东阳乡','202',1340),(17567,'嵩峰乡','204',1340),(17568,'少阳乡','206',1340),(17569,'铜钹山垦殖场','400',1340),(17570,'芦林工业园区管理委员会','500',1340),(17571,'冰溪镇','100',1341),(17572,'临湖镇','101',1341),(17573,'必姆镇','102',1341),(17574,'横街镇','103',1341),(17575,'文成镇','104',1341),(17576,'下镇镇','105',1341),(17577,'岩瑞镇','107',1341),(17578,'双明镇','108',1341),(17579,'紫湖镇','109',1341),(17580,'仙岩镇','110',1341),(17581,'樟村镇','111',1341),(17582,'枫林镇','198',1341),(17583,'南山乡','200',1341),(17584,'怀玉乡','201',1341),(17585,'下塘乡','202',1341),(17586,'四股桥乡','203',1341),(17587,'六都乡','204',1341),(17588,'三清乡','290',1341),(17589,'金山工业园','500',1341),(17590,'河口镇','100',1342),(17591,'永平镇','101',1342),(17592,'石塘镇','102',1342),(17593,'鹅湖镇','103',1342),(17594,'湖坊镇','105',1342),(17595,'武夷山镇','106',1342),(17596,'汪二镇','108',1342),(17597,'陈坊乡','200',1342),(17598,'虹桥乡','201',1342),(17599,'新滩乡','202',1342),(17600,'葛仙山乡','203',1342),(17601,'稼轩乡','205',1342),(17602,'英将乡','206',1342),(17603,'紫溪乡','207',1342),(17604,'太源畲族乡','208',1342),(17605,'天柱山乡','209',1342),(17606,'篁碧畲族乡','210',1342),(17607,'国营铅山县河口茶叶实验场','400',1342),(17608,'国营铅山县畜牧良种繁殖场','401',1342),(17609,'国营铅山县鱼种场','402',1342),(17610,'铅山县水稻良种场','403',1342),(17611,'铅山县农业科学研究所','404',1342),(17612,'铅山县国营森林苗圃','405',1342),(17613,'江西铜业集团公司永铜分公司','500',1342),(17614,'江西武夷山国家级自然保护区管理局','501',1342),(17615,'鹅湖书院文物管理保护所','502',1342),(17616,'铅山县工业园区开发管理委员会','503',1342),(17617,'岑阳镇','100',1343),(17618,'葛源镇','101',1343),(17619,'姚家乡','200',1343),(17620,'莲荷乡','201',1343),(17621,'司铺乡','202',1343),(17622,'港边乡','203',1343),(17623,'龙门畈乡','204',1343),(17624,'青板乡','205',1343),(17625,'新篁乡（办事处）','206',1343),(17626,'红桥垦殖场','400',1343),(17627,'兴安工业园区','500',1343),(17628,'铺前煤矿','501',1343),(17629,'上坑源林场','502',1343),(17630,'山黄林场','503',1343),(17631,'曹溪镇','101',1344),(17632,'漆工镇','102',1344),(17633,'樟树墩镇','103',1344),(17634,'南岩镇','104',1344),(17635,'朱坑镇','105',1344),(17636,'圭峰镇','106',1344),(17637,'叠山镇','107',1344),(17638,'港口镇','108',1344),(17639,'弋江镇','109',1344),(17640,'三县岭乡','200',1344),(17641,'中畈乡','202',1344),(17642,'葛溪乡','203',1344),(17643,'湾里乡','204',1344),(17644,'花亭乡','205',1344),(17645,'清湖乡','206',1344),(17646,'旭光乡','208',1344),(17647,'圭峰风景管理区','500',1344),(17648,'连胜工业园','501',1344),(17649,'城南工业园','502',1344),(17650,'玉亭镇','100',1345),(17651,'瑞洪镇','101',1345),(17652,'黄金埠镇','102',1345),(17653,'古埠镇','104',1345),(17654,'乌泥镇','105',1345),(17655,'石口镇','106',1345),(17656,'杨埠镇','107',1345),(17657,'九龙镇','108',1345),(17658,'康山乡','200',1345),(17659,'东塘乡','202',1345),(17660,'大塘乡','204',1345),(17661,'鹭鸶港乡','206',1345),(17662,'三塘乡','207',1345),(17663,'洪家嘴乡','209',1345),(17664,'白马桥乡','210',1345),(17665,'江埠乡','211',1345),(17666,'枫港乡','213',1345),(17667,'大溪乡','214',1345),(17668,'梅港乡','217',1345),(17669,'社赓乡','218',1345),(17670,'渔池湖水产场','402',1345),(17671,'县良种场','403',1345),(17672,'李梅林场','404',1345),(17673,'康山垦总场','405',1345),(17674,'禾斛岭垦殖场','406',1345),(17675,'峡山林场','407',1345),(17676,'信丰垦殖场','408',1345),(17677,'马背嘴工业园区','500',1345),(17678,'城西工业园区','501',1345),(17679,'城北开发区','502',1345),(17680,'鄱阳镇','100',1346),(17681,'谢家滩镇','101',1346),(17682,'石门街镇','102',1346),(17683,'四十里街镇','103',1346),(17684,'油墩街镇','104',1346),(17685,'田畈街镇','105',1346),(17686,'金盘岭镇','106',1346),(17687,'高家岭镇','107',1346),(17688,'凰岗镇','108',1346),(17689,'双港镇','109',1346),(17690,'古县渡镇','110',1346),(17691,'饶丰镇','111',1346),(17692,'乐丰镇','112',1346),(17693,'饶埠镇','113',1346),(17694,'侯家岗乡','201',1346),(17695,'莲花山乡','202',1346),(17696,'响水滩乡','203',1346),(17697,'枧田街乡','206',1346),(17698,'柘港乡','207',1346),(17699,'鸦鹊湖乡','208',1346),(17700,'银宝湖乡','209',1346),(17701,'游城乡','210',1346),(17702,'珠湖乡','211',1346),(17703,'白沙洲乡','212',1346),(17704,'团林乡','213',1346),(17705,'昌洲乡','215',1346),(17706,'庙前乡','216',1346),(17707,'莲湖乡','217',1346),(17708,'芦田乡','218',1346),(17709,'农科所','401',1346),(17710,'饶洲监狱','402',1346),(17711,'陈营镇','100',1347),(17712,'石镇镇','101',1347),(17713,'青云镇','102',1347),(17714,'梓埠镇','103',1347),(17715,'大源镇','104',1347),(17716,'裴梅镇','105',1347),(17717,'湖云乡','200',1347),(17718,'齐埠乡','201',1347),(17719,'汪家乡','203',1347),(17720,'上坊乡','205',1347),(17721,'苏桥乡','206',1347),(17722,'珠田乡','208',1347),(17723,'林科所','400',1347),(17724,'紫阳镇','100',1348),(17725,'清华镇','101',1348),(17726,'秋口镇','102',1348),(17727,'江湾镇','103',1348),(17728,'思口镇','104',1348),(17729,'赋春镇','106',1348),(17730,'镇头镇','107',1348),(17731,'太白镇','109',1348),(17732,'中云镇','110',1348),(17733,'许村镇','111',1348),(17734,'溪头乡','200',1348),(17735,'段莘乡','201',1348),(17736,'浙源乡','204',1348),(17737,'沱川乡','205',1348),(17738,'大鄣山乡','206',1348),(17739,'珍珠山乡','208',1348),(17740,'银城街道办事处','001',1349),(17741,'绕二镇','103',1349),(17742,'海口镇','105',1349),(17743,'新岗山镇','106',1349),(17744,'泗洲镇','107',1349),(17745,'花桥镇(大茅山经济开发区)','190',1349),(17746,'黄柏乡','200',1349),(17747,'万村乡','201',1349),(17748,'张村乡','202',1349),(17749,'皈大乡','203',1349),(17750,'李宅乡','204',1349),(17751,'龙头山乡','205',1349),(17752,'江西省德兴铜矿','401',1349),(17753,'大茅山集团公司(大茅山经济开发区)','490',1349),(17754,'解放路街道办事处','001',1351),(17755,'千佛山街道办事处','002',1351),(17756,'趵突泉街道办事处','003',1351),(17757,'泉城路街道办事处','004',1351),(17758,'大明湖街道办事处','005',1351),(17759,'东关街道办事处','006',1351),(17760,'文东街道办事处','007',1351),(17761,'建新街道办事处','008',1351),(17762,'甸柳街道办事处','009',1351),(17763,'燕山街道办事处','010',1351),(17764,'姚家镇','100',1351),(17765,'大观园街道办事处','002',1352),(17766,'杆石桥街道办事处','003',1352),(17767,'四里村街道办事处','004',1352),(17768,'魏家庄街道办事处','006',1352),(17769,'二七街道办事处','008',1352),(17770,'七里山街道办事处','009',1352),(17771,'六里山街道办事处','010',1352),(17772,'舜玉路街道办事处','012',1352),(17773,'泺源街道办事处','014',1352),(17774,'王官庄街道办事处','015',1352),(17775,'舜耕街道办事处','016',1352),(17776,'白马山街道办事处','017',1352),(17777,'七贤街道办事处','018',1352),(17778,'党家庄镇','101',1352),(17779,'十六里河镇','102',1352),(17780,'振兴街街道办事处','001',1353),(17781,'中大槐树街道办事处','002',1353),(17782,'道德街街道办事处','003',1353),(17783,'西市场街道办事处','004',1353),(17784,'五里沟街道办事处','005',1353),(17785,'营市街街道办事处','006',1353),(17786,'青年公园街道办事处','007',1353),(17787,'南辛庄街道办事处','008',1353),(17788,'段店北路街道办事处','009',1353),(17789,'张庄路街道办事处','010',1353),(17790,'匡山街道办事处','011',1353),(17791,'美里湖街道办事处','012',1353),(17792,'吴家堡镇','100',1353),(17793,'段店镇','101',1353),(17794,'无影山街道办事处','001',1354),(17795,'天桥东街街道办事处','003',1354),(17796,'北村街道办事处','004',1354),(17797,'南村街道办事处','005',1354),(17798,'堤口路街道办事处','006',1354),(17799,'北坦街道办事处','007',1354),(17800,'制锦市街道办事处','009',1354),(17801,'宝华街道办事处','010',1354),(17802,'官扎营街道办事处','011',1354),(17803,'纬北路街道办事处','012',1354),(17804,'药山街道办事处','013',1354),(17805,'北园街道办事处','014',1354),(17806,'泺口街道办事处','015',1354),(17807,'桑梓店镇','101',1354),(17808,'大桥镇','102',1354),(17809,'山大路街道办事处','001',1355),(17810,'洪家楼街道办事处','002',1355),(17811,'东风街道办事处','003',1355),(17812,'全福街道办事处','004',1355),(17813,'仲宫镇','101',1355),(17814,'港沟镇','102',1355),(17815,'柳埠镇','103',1355),(17816,'孙村镇','104',1355),(17817,'郭店镇','105',1355),(17818,'董家镇','106',1355),(17819,'唐王镇','107',1355),(17820,'遥墙镇','108',1355),(17821,'王舍人镇','109',1355),(17822,'华山镇','110',1355),(17823,'西营镇','111',1355),(17824,'彩石镇','112',1355),(17825,'文昌街街道办事处','001',1356),(17826,'崮云湖街道办事处','002',1356),(17827,'平安街道办事处','003',1356),(17828,'五峰山街道办事处','004',1356),(17829,'归德镇','101',1356),(17830,'孝里镇','102',1356),(17831,'万德镇','103',1356),(17832,'张夏镇','106',1356),(17833,'马山镇','107',1356),(17834,'双泉乡','200',1356),(17835,'平阴镇','100',1357),(17836,'东阿镇','102',1357),(17837,'孝直镇','103',1357),(17838,'孔村镇','104',1357),(17839,'洪范池镇','105',1357),(17840,'玫瑰镇','106',1357),(17841,'安城乡','201',1357),(17842,'济阳镇','100',1358),(17843,'垛石镇','101',1358),(17844,'孙耿镇','102',1358),(17845,'曲堤镇','103',1358),(17846,'仁风镇','104',1358),(17847,'崔寨镇','107',1358),(17848,'太平镇','108',1358),(17849,'新市乡','206',1358),(17850,'1、许商街道办事处','001',1359),(17851,'2、玉皇庙街道办事处','002',1359),(17852,'3、殷巷镇','101',1359),(17853,'4、怀仁镇','102',1359),(17854,'5、龙桑寺镇','104',1359),(17855,'6、郑路镇','105',1359),(17856,'7、贾庄镇','106',1359),(17857,'8、孙集乡','201',1359),(17858,'9、沙河乡','204',1359),(17859,'10、韩庙乡','205',1359),(17860,'11、张坊乡','207',1359),(17861,'12、白桥乡','212',1359),(17862,'明水街道办事处','001',1360),(17863,'双山街道办事处','002',1360),(17864,'枣园街道办事处','003',1360),(17865,'龙山街道办事处','004',1360),(17866,'埠村街道办事处','005',1360),(17867,'圣井街道办事处','006',1360),(17868,'普集镇','101',1360),(17869,'绣惠镇','103',1360),(17870,'相公庄镇','104',1360),(17871,'垛庄镇','105',1360),(17872,'水寨镇','106',1360),(17873,'文祖镇','109',1360),(17874,'刁镇','110',1360),(17875,'曹范镇','111',1360),(17876,'白云湖镇','113',1360),(17877,'高官寨镇','114',1360),(17878,'宁家埠镇','115',1360),(17879,'官庄乡','201',1360),(17880,'辛寨乡','203',1360),(17881,'黄河乡','204',1360),(17882,'香港中路街道办事处','001',1362),(17883,'八大峡街道办事处','002',1362),(17884,'台西街道办事处','003',1362),(17885,'云南路街道办事处','004',1362),(17886,'中山街道办事处','005',1362),(17887,'观海路街道办事处','006',1362),(17888,'江苏路街道办事处','007',1362),(17889,'金口路街道办事处','008',1362),(17890,'八大关街道办事处','009',1362),(17891,'湛山街道办事处','010',1362),(17892,'金湖路街道办事处','011',1362),(17893,'八大湖街道办事处','012',1362),(17894,'金门路街道办事处','013',1362),(17895,'珠海路街道办事处','014',1362),(17896,'冠县路街道办事处','001',1363),(17897,'胶州路街道办事处','002',1363),(17898,'黄台路街道办事处','003',1363),(17899,'热河路街道办事处','004',1363),(17900,'辽宁路街道办事处','005',1363),(17901,'北仲路街道办事处','006',1363),(17902,'威海路街道办事处','007',1363),(17903,'延安路街道办事处','008',1363),(17904,'泰山路街道办事处','009',1363),(17905,'华阳路街道办事处','010',1363),(17906,'登州路街道办事处','011',1363),(17907,'利津路街道办事处','012',1363),(17908,'宁夏路街道办事处','013',1363),(17909,'敦化路街道办事处','014',1363),(17910,'辽源路街道办事处','015',1363),(17911,'合肥路街道办事处','016',1363),(17912,'浮山后社区事务受理中心街道','017',1363),(17913,'阜新路街道办事处','001',1364),(17914,'海伦路街道办事处','002',1364),(17915,'嘉兴路街道办事处','003',1364),(17916,'兴隆路街道办事处','004',1364),(17917,'水清沟街道办事处','005',1364),(17918,'洛阳路街道办事处','006',1364),(17919,'河西街道办事处','007',1364),(17920,'黄岛街道办事处','001',1365),(17921,'辛安街道办事处','002',1365),(17922,'薛家岛街道办事处','003',1365),(17923,'柳花泊街道办事处','004',1365),(17924,'长江路街道办事处','005',1365),(17925,'红石崖街道办事处','006',1365),(17926,'中韩街道','001',1366),(17927,'沙子口街道','002',1366),(17928,'王哥庄街道','003',1366),(17929,'北宅街道','004',1366),(17930,'振华路街道办事处','001',1367),(17931,'永清路街道办事处','002',1367),(17932,'永安路街道办事处','003',1367),(17933,'兴华路街道办事处','004',1367),(17934,'兴城路街道办事处','005',1367),(17935,'李村街道办事处','006',1367),(17936,'虎山路街道办事处','007',1367),(17937,'浮山路街道办事处','008',1367),(17938,'九水路街道办事处','009',1367),(17939,'湘潭路街道办事处','010',1367),(17940,'楼山街道办事处','011',1367),(17941,'城阳街道办事处','001',1368),(17942,'夏庄街道办事处','002',1368),(17943,'流亭街道办事处','003',1368),(17944,'棘洪滩街道办事处','004',1368),(17945,'上马街道办事处','005',1368),(17946,'红岛街道办事处','006',1368),(17947,'河套街道办事处','007',1368),(17948,'惜福镇街道办事处','008',1368),(17949,'阜安街道办事处','001',1369),(17950,'中云街道办事处','002',1369),(17951,'北关街道办事处','003',1369),(17952,'南关街道办事处','004',1369),(17953,'云溪街道办事处','005',1369),(17954,'胶莱镇','100',1369),(17955,'马店镇','101',1369),(17956,'李哥庄镇','102',1369),(17957,'营海镇','104',1369),(17958,'铺集镇','105',1369),(17959,'张应镇','106',1369),(17960,'里岔镇','108',1369),(17961,'胶东镇','109',1369),(17962,'胶西镇','110',1369),(17963,'洋河镇','111',1369),(17964,'九龙镇','112',1369),(17965,'杜村镇','113',1369),(17966,'胶北镇','114',1369),(17967,'环秀街道','001',1370),(17968,'潮海街道','002',1370),(17969,'通济街道办事处','003',1370),(17970,'北安街道','004',1370),(17971,'龙山街道办事处','005',1370),(17972,'鳌山卫镇','101',1370),(17973,'温泉镇','102',1370),(17974,'龙泉镇','103',1370),(17975,'刘家庄镇','104',1370),(17976,'蓝村镇','105',1370),(17977,'店集镇','106',1370),(17978,'灵山镇','107',1370),(17979,'七级镇','108',1370),(17980,'王村镇','110',1370),(17981,'丰城镇','112',1370),(17982,'段泊岚镇','115',1370),(17983,'移风店镇','117',1370),(17984,'普东镇','118',1370),(17985,'大信镇','119',1370),(17986,'田横镇','121',1370),(17987,'金口镇','122',1370),(17988,'华山镇','123',1370),(17989,'南泉镇','124',1370),(17990,'城关街道办事处','001',1371),(17991,'李园街道办事处','002',1371),(17992,'同和街道办事处','003',1371),(17993,'香店街道办事处','004',1371),(17994,'麻兰镇','100',1371),(17995,'古岘镇','101',1371),(17996,'仁兆镇','102',1371),(17997,'张戈庄镇','103',1371),(17998,'郭庄镇','104',1371),(17999,'南村镇','105',1371),(18000,'兰底镇','106',1371),(18001,'万家镇','107',1371),(18002,'蓼兰镇','108',1371),(18003,'崔家集镇','109',1371),(18004,'明村镇','110',1371),(18005,'白埠镇','111',1371),(18006,'门村镇','112',1371),(18007,'田庄镇','113',1371),(18008,'马戈庄镇','114',1371),(18009,'张舍镇','115',1371),(18010,'新河镇','116',1371),(18011,'灰埠镇','117',1371),(18012,'长乐镇','118',1371),(18013,'店子镇','119',1371),(18014,'大泽山镇','120',1371),(18015,'大田镇','121',1371),(18016,'旧店镇','122',1371),(18017,'祝沟镇','123',1371),(18018,'云山镇','124',1371),(18019,'崔召镇','125',1371),(18020,'平度外向型工业加工','400',1371),(18021,'珠山街道办事处','001',1372),(18022,'珠海街道办事处','002',1372),(18023,'隐珠街道办事处','003',1372),(18024,'灵山卫街道办事处','004',1372),(18025,'铁山街道办事处','005',1372),(18026,'滨海街道办事处','006',1372),(18027,'琅琊镇','102',1372),(18028,'泊里镇','103',1372),(18029,'大场镇','104',1372),(18030,'大村镇','105',1372),(18031,'六汪镇','106',1372),(18032,'王台镇','107',1372),(18033,'张家楼镇','110',1372),(18034,'海青镇','112',1372),(18035,'宝山镇','113',1372),(18036,'藏南镇','115',1372),(18037,'理务关镇（乡改镇）','116',1372),(18038,'水集街道办事处','001',1373),(18039,'望城街道办事处','002',1373),(18040,'龙水街道办事处','004',1373),(18041,'梅花山街道办事处','005',1373),(18042,'滨河路街道办事处','006',1373),(18043,'沽河街道办事处','007',1373),(18044,'孙受镇','100',1373),(18045,'姜山镇','101',1373),(18046,'夏格庄镇','102',1373),(18047,'院上镇','104',1373),(18048,'日庄镇','105',1373),(18049,'南墅镇','106',1373),(18050,'河头店镇','107',1373),(18051,'店埠镇','108',1373),(18052,'李权庄镇','109',1373),(18053,'武备镇','112',1373),(18054,'马连庄镇','116',1373),(18055,'般阳路街道','001',1375),(18056,'松龄路街道','002',1375),(18057,'商城路街道','003',1375),(18058,'钟楼街道','004',1375),(18059,'城南镇','101',1375),(18060,'昆仑镇','102',1375),(18061,'磁村镇','103',1375),(18062,'岭子镇','104',1375),(18063,'商家镇','105',1375),(18064,'黑旺镇','108',1375),(18065,'淄河镇','109',1375),(18066,'东坪镇','110',1375),(18067,'西河镇','111',1375),(18068,'龙泉镇','112',1375),(18069,'寨里镇','113',1375),(18070,'罗村镇','114',1375),(18071,'洪山镇','115',1375),(18072,'双杨镇','116',1375),(18073,'太河乡','200',1375),(18074,'峨庄乡','201',1375),(18075,'张庄乡','202',1375),(18076,'车站街道办事处','001',1376),(18077,'公园街道办事处','002',1376),(18078,'杏园街道办事处','003',1376),(18079,'和平街道','004',1376),(18080,'科苑街道办事处','005',1376),(18081,'体育场街道办事处','006',1376),(18082,'石桥街道办事处','007',1376),(18083,'四宝山街道办事处','008',1376),(18084,'马尚镇','100',1376),(18085,'南定镇','101',1376),(18086,'沣水镇','102',1376),(18087,'湖田镇','103',1376),(18088,'傅家镇','104',1376),(18089,'中埠镇','105',1376),(18090,'卫固镇','106',1376),(18091,'房镇镇','107',1376),(18092,'城东街道办事处','001',1377),(18093,'城西街道办事处','002',1377),(18094,'域城镇','102',1377),(18095,'白塔镇','103',1377),(18096,'夏家庄镇','104',1377),(18097,'山头镇','105',1377),(18098,'八陡镇','106',1377),(18099,'崮山镇','107',1377),(18100,'石马镇','108',1377),(18101,'北博山镇','109',1377),(18102,'南博山镇','110',1377),(18103,'源泉镇','111',1377),(18104,'池上镇','112',1377),(18105,'闻韶街道','001',1378),(18106,'雪宫街道','002',1378),(18107,'辛店街道','003',1378),(18108,'稷下街道','004',1378),(18109,'齐陵街道','005',1378),(18110,'齐都镇','100',1378),(18111,'皇城镇','102',1378),(18112,'敬仲镇','103',1378),(18113,'朱台镇','104',1378),(18114,'梧台镇','106',1378),(18115,'金岭镇','107',1378),(18116,'南王镇','108',1378),(18117,'凤凰镇','109',1378),(18118,'边河乡','201',1378),(18119,'丝绸路街道','001',1379),(18120,'大街街道','002',1379),(18121,'青年路街道','003',1379),(18122,'永安街道','004',1379),(18123,'城北路街道','005',1379),(18124,'北郊镇','100',1379),(18125,'南郊镇','101',1379),(18126,'王村镇','102',1379),(18127,'萌水镇','103',1379),(18128,'索镇镇','100',1380),(18129,'起凤镇','101',1380),(18130,'邢家镇','102',1380),(18131,'田庄镇','103',1380),(18132,'荆家镇','104',1380),(18133,'马桥镇','105',1380),(18134,'陈庄镇','106',1380),(18135,'新城镇','107',1380),(18136,'周家镇','108',1380),(18137,'唐山镇','109',1380),(18138,'果里镇','110',1380),(18139,'田镇','100',1381),(18140,'青城镇','101',1381),(18141,'高城镇','102',1381),(18142,'黑里寨镇','103',1381),(18143,'唐坊镇','104',1381),(18144,'常家镇','105',1381),(18145,'花沟镇','106',1381),(18146,'赵店镇','107',1381),(18147,'木李镇','108',1381),(18148,'南麻镇','100',1382),(18149,'土门镇','101',1382),(18150,'鲁村镇','102',1382),(18151,'东里镇','103',1382),(18152,'悦庄镇','104',1382),(18153,'西里镇','105',1382),(18154,'大张庄镇','106',1382),(18155,'中庄镇','107',1382),(18156,'张家坡镇','108',1382),(18157,'徐家庄乡','200',1382),(18158,'燕崖乡','202',1382),(18159,'石桥乡','205',1382),(18160,'三岔乡','206',1382),(18161,'中心街街道办事处','001',1384),(18162,'各塔埠街道办事处','002',1384),(18163,'矿区街道办事处','003',1384),(18164,'文化路街道办事','004',1384),(18165,'龙山路街道办事处','005',1384),(18166,'光明路街道办事','006',1384),(18167,'税郭镇','101',1384),(18168,'孟庄镇','102',1384),(18169,'齐村镇','103',1384),(18170,'永安乡','201',1384),(18171,'西王庄乡','202',1384),(18172,'临城街道办事处','001',1385),(18173,'兴仁街道办事处','002',1385),(18174,'兴城街道办事处','003',1385),(18175,'沙沟镇','101',1385),(18176,'周营镇','102',1385),(18177,'邹坞镇','103',1385),(18178,'陶庄镇','104',1385),(18179,'常庄镇','106',1385),(18180,'张范镇','107',1385),(18181,'坛山街道办事处','001',1386),(18182,'吴林街道办事处','002',1386),(18183,'古邵镇','100',1386),(18184,'阴平镇','101',1386),(18185,'底阁镇','102',1386),(18186,'榴园镇','103',1386),(18187,'峨山镇','104',1386),(18188,'运河街道办事处','001',1387),(18189,'邳庄镇','100',1387),(18190,'张山子镇','101',1387),(18191,'泥沟镇','102',1387),(18192,'涧头集镇','103',1387),(18193,'马兰屯镇','104',1387),(18194,'山城街道办事处','001',1388),(18195,'店子镇','101',1388),(18196,'西集镇','102',1388),(18197,'桑村镇','103',1388),(18198,'北庄镇','104',1388),(18199,'城头镇','105',1388),(18200,'徐庄镇','106',1388),(18201,'水泉镇','107',1388),(18202,'冯卯镇','108',1388),(18203,'凫城乡','200',1388),(18204,'荆河街道','001',1389);
insert  into `te_township`(`townshipId`,`townshipName`,`townshipCode`,`countyId`) values (18205,'龙泉街道','002',1389),(18206,'北辛街道','003',1389),(18207,'善南街道','004',1389),(18208,'东沙河镇','100',1389),(18209,'洪绪镇','101',1389),(18210,'南沙河镇','102',1389),(18211,'大坞镇','103',1389),(18212,'滨湖镇','104',1389),(18213,'级索镇','105',1389),(18214,'西岗镇','106',1389),(18215,'姜屯镇','107',1389),(18216,'鲍沟镇','108',1389),(18217,'张汪镇','109',1389),(18218,'官桥镇','110',1389),(18219,'柴胡店镇','111',1389),(18220,'羊庄镇','112',1389),(18221,'木石镇','113',1389),(18222,'界河镇','114',1389),(18223,'龙阳镇','115',1389),(18224,'东郭镇','116',1389),(18225,'文汇街道办事处','001',1391),(18226,'黄河路街道办事处','002',1391),(18227,'东城街道办事处','003',1391),(18228,'辛店街道办事处','004',1391),(18229,'胜利街道办事处','005',1391),(18230,'胜园街道办事处','006',1391),(18231,'牛庄镇','102',1391),(18232,'六户镇','103',1391),(18233,'史口镇','104',1391),(18234,'龙居镇','105',1391),(18235,'河口街道办事处','001',1392),(18236,'义和镇','100',1392),(18237,'仙河镇','101',1392),(18238,'孤岛镇','102',1392),(18239,'新户乡','200',1392),(18240,'　太平乡','201',1392),(18241,'　六合乡','203',1392),(18242,'垦利镇','100',1393),(18243,'胜坨镇','101',1393),(18244,'郝家镇','102',1393),(18245,'永安镇','104',1393),(18246,'黄河口镇','105',1393),(18247,'西宋乡','204',1393),(18248,'董集乡','207',1393),(18249,'利津镇','100',1394),(18250,'北宋镇','101',1394),(18251,'盐窝镇','102',1394),(18252,'陈庄镇','103',1394),(18253,'汀罗镇','104',1394),(18254,'明集乡','201',1394),(18255,'北岭乡','202',1394),(18256,'虎滩乡','203',1394),(18257,'刁口乡','206',1394),(18258,'广饶镇','100',1395),(18259,'大王镇','101',1395),(18260,'稻庄镇','102',1395),(18261,'石村镇','103',1395),(18262,'丁庄镇','104',1395),(18263,'李鹊镇','106',1395),(18264,'大码头乡','204',1395),(18265,'西刘桥乡','205',1395),(18266,'花官乡','207',1395),(18267,'陈官乡','208',1395),(18268,'向阳街道','001',1397),(18269,'东山街道','002',1397),(18270,'毓璜顶街道','003',1397),(18271,'通伸街道','004',1397),(18272,'凤凰台街道','005',1397),(18273,'奇山街道','006',1397),(18274,'白石街道','007',1397),(18275,'芝罘岛街道','008',1397),(18276,'黄务街道','009',1397),(18277,'只楚街道','010',1397),(18278,'世回尧街道','011',1397),(18279,'幸福街道','012',1397),(18280,'清洋街道','001',1398),(18281,'福新街道','002',1398),(18282,'古现街道(烟台开发区)','003',1398),(18283,'大季家街道(烟台开发区)','004',1398),(18284,'高疃镇','102',1398),(18285,'张格庄镇','103',1398),(18286,'回里镇','104',1398),(18287,'门楼镇','105',1398),(18288,'海河社区管理处(烟台开发区)','400',1398),(18289,'长江社区管理处(烟台开发区)','401',1398),(18290,'八角街道(烟台开发区)','402',1398),(18291,'宁海街道','001',1399),(18292,'文化街道','002',1399),(18293,'养马岛街道','003',1399),(18294,'观水镇','101',1399),(18295,'武宁镇','102',1399),(18296,'大窑镇','103',1399),(18297,'姜格庄镇','104',1399),(18298,'龙泉镇','105',1399),(18299,'玉林店镇','106',1399),(18300,'水道镇','107',1399),(18301,'莒格庄镇','108',1399),(18302,'高陵镇','109',1399),(18303,'王格庄镇','110',1399),(18304,'黄海路街道','001',1400),(18305,'初家街道','002',1400),(18306,'滨海路街道','003',1400),(18307,'解甲庄镇','101',1400),(18308,'莱山镇','102',1400),(18309,'南长山镇','100',1401),(18310,'砣矶镇','101',1401),(18311,'北长山乡','201',1401),(18312,'黑山乡','202',1401),(18313,'大钦岛乡','203',1401),(18314,'小钦岛乡','204',1401),(18315,'南隍城乡','205',1401),(18316,'北隍城乡','206',1401),(18317,'东莱街道','001',1402),(18318,'龙港街道','002',1402),(18319,'新嘉街道','003',1402),(18320,'徐福镇','101',1402),(18321,'黄山馆镇','102',1402),(18322,'北马镇','103',1402),(18323,'芦头镇','104',1402),(18324,'东江镇','105',1402),(18325,'下丁家镇','106',1402),(18326,'七甲镇','107',1402),(18327,'石良镇','108',1402),(18328,'兰高镇','109',1402),(18329,'诸由观镇','110',1402),(18330,'城厢街道','001',1403),(18331,'古柳街道','002',1403),(18332,'龙旺庄街道','003',1403),(18333,'冯格庄街道','004',1403),(18334,'沐浴店镇','101',1403),(18335,'团旺镇','102',1403),(18336,'穴坊镇','103',1403),(18337,'羊郡镇','104',1403),(18338,'姜疃镇','105',1403),(18339,'万第镇','106',1403),(18340,'照旺庄镇','107',1403),(18341,'谭格庄镇','108',1403),(18342,'柏林庄镇','109',1403),(18343,'河洛镇','110',1403),(18344,'吕格庄镇','111',1403),(18345,'高格庄镇','112',1403),(18346,'大夼镇','113',1403),(18347,'山前店镇','114',1403),(18348,'文昌路街道','001',1404),(18349,'永安路街道','002',1404),(18350,'三山岛街道','003',1404),(18351,'城港路街道','004',1404),(18352,'文峰路街道','005',1404),(18353,'沙河镇','101',1404),(18354,'朱桥镇','102',1404),(18355,'郭家店镇','103',1404),(18356,'金城镇','104',1404),(18357,'平里店镇','105',1404),(18358,'驿道镇','106',1404),(18359,'程郭镇','107',1404),(18360,'虎头崖镇','108',1404),(18361,'柞村镇','109',1404),(18362,'夏邱镇','110',1404),(18363,'土山镇','111',1404),(18364,'登州街道','001',1405),(18365,'紫荆山街道','002',1405),(18366,'新港街道','003',1405),(18367,'蓬莱阁街道','004',1405),(18368,'南王街道','005',1405),(18369,'刘家沟镇','102',1405),(18370,'潮水镇','103',1405),(18371,'大柳行镇','105',1405),(18372,'小门家镇','106',1405),(18373,'大辛店镇','107',1405),(18374,'村里集镇','108',1405),(18375,'北沟镇','109',1405),(18376,'罗峰街道','001',1406),(18377,'泉山街道','002',1406),(18378,'梦芝街道','003',1406),(18379,'温泉街道','004',1406),(18380,'辛庄镇','101',1406),(18381,'蚕庄镇','102',1406),(18382,'金岭镇','103',1406),(18383,'毕郭镇','104',1406),(18384,'玲珑镇','105',1406),(18385,'张星镇','106',1406),(18386,'大秦家镇','107',1406),(18387,'夏甸镇','108',1406),(18388,'阜山镇','109',1406),(18389,'齐山镇','110',1406),(18390,'翠屏街道','001',1407),(18391,'庄园街道','002',1407),(18392,'松山街道','003',1407),(18393,'观里镇','101',1407),(18394,'蛇窝泊镇','102',1407),(18395,'唐家泊镇','103',1407),(18396,'桃村镇','104',1407),(18397,'亭口镇','105',1407),(18398,'臧家庄镇','106',1407),(18399,'寺口镇','107',1407),(18400,'苏家店镇','108',1407),(18401,'杨础镇','109',1407),(18402,'西城镇','110',1407),(18403,'官道镇','111',1407),(18404,'庙后镇','113',1407),(18405,'方圆街道','001',1408),(18406,'东村街道','002',1408),(18407,'凤城街道','003',1408),(18408,'留格庄镇','102',1408),(18409,'盘石店镇','103',1408),(18410,'郭城镇','104',1408),(18411,'徐家店镇','105',1408),(18412,'发城镇','106',1408),(18413,'小纪镇','107',1408),(18414,'行村镇','108',1408),(18415,'辛安镇','109',1408),(18416,'二十里店镇','110',1408),(18417,'大阎家镇','111',1408),(18418,'朱吴镇','112',1408),(18419,'外向型工业加工区','401',1408),(18420,'城关街道办事处','001',1410),(18421,'南关街道办事处','002',1410),(18422,'西关街道办事处','003',1410),(18423,'北关街道办事处','004',1410),(18424,'军埠口镇','101',1410),(18425,'符山镇','102',1410),(18426,'于河镇','103',1410),(18427,'望留镇','104',1410),(18428,'寒亭街道办事处','001',1411),(18429,'开元街道办事处','002',1411),(18430,'固堤镇','100',1411),(18431,'央子镇','101',1411),(18432,'高里镇','102',1411),(18433,'双杨店镇','103',1411),(18434,'朱里镇','104',1411),(18435,'河滩镇','105',1411),(18436,'泊子乡','200',1411),(18437,'南孙乡','201',1411),(18438,'长宁街道办事处','001',1412),(18439,'恒安街道办事处','002',1412),(18440,'凤凰街道办事处','003',1412),(18441,'坊安街道办事处','004',1412),(18442,'穆村镇','103',1412),(18443,'眉村镇','104',1412),(18444,'荆山洼镇','105',1412),(18445,'南流镇','106',1412),(18446,'东关街道办事处','001',1413),(18447,'大虞街道办事处','002',1413),(18448,'梨园街道办事处','003',1413),(18449,'廿里堡街道办事处','004',1413),(18450,'潍州路街道办事处','005',1413),(18451,'北苑街道办事处','006',1413),(18452,'广文街道办事处','007',1413),(18453,'南苑街道办事处','008',1413),(18454,'新城街道办事处','009',1413),(18455,'清池街道办事处','010',1413),(18456,'钢城街道办事处','011',1413),(18457,'城关街道办事处','001',1414),(18458,'东城街道办事处','002',1414),(18459,'五井镇','101',1414),(18460,'杨善镇','102',1414),(18461,'冶源镇','103',1414),(18462,'寺头镇','104',1414),(18463,'九山镇','105',1414),(18464,'七贤镇','106',1414),(18465,'辛寨镇','107',1414),(18466,'卧龙镇','108',1414),(18467,'蒋峪镇','109',1414),(18468,'大关镇','110',1414),(18469,'营子镇','111',1414),(18470,'龙岗镇','112',1414),(18471,'柳山镇','113',1414),(18472,'上林镇','114',1414),(18473,'纸坊镇','115',1414),(18474,'石家河乡','200',1414),(18475,'城关街道办事处','001',1415),(18476,'宝城街道办事处','002',1415),(18477,'朱刘街道办事处','003',1415),(18478,'城南街道办事处','004',1415),(18479,'尧沟镇','102',1415),(18480,'五图镇','104',1415),(18481,'北岩镇','106',1415),(18482,'乔官镇','107',1415),(18483,'唐吾镇','108',1415),(18484,'高崖镇','109',1415),(18485,'红河镇','110',1415),(18486,'马宋镇','111',1415),(18487,'阿陀镇','112',1415),(18488,'崔家庄镇','113',1415),(18489,'白塔镇','114',1415),(18490,'朱汉镇','115',1415),(18491,'王府街道办事处','001',1416),(18492,'益都街道办事处','002',1416),(18493,'昭德街道办事处','003',1416),(18494,'东坝街道办事处','004',1416),(18495,'王母宫街道办事处','005',1416),(18496,'云门山街道办事处','006',1416),(18497,'弥河镇','100',1416),(18498,'王坟镇','101',1416),(18499,'五里镇','102',1416),(18500,'庙子镇','103',1416),(18501,'邵庄镇','105',1416),(18502,'普通镇','106',1416),(18503,'东高镇','107',1416),(18504,'高柳镇','109',1416),(18505,'朱良镇','110',1416),(18506,'何官镇','111',1416),(18507,'口埠镇','112',1416),(18508,'东夏镇','113',1416),(18509,'谭坊镇','115',1416),(18510,'郑母镇','116',1416),(18511,'黄楼镇','117',1416),(18512,'密州街道办事处','001',1417),(18513,'龙都街道办事处','002',1417),(18514,'舜王街道办事处','003',1417),(18515,'吕标镇','100',1417),(18516,'枳沟镇','101',1417),(18517,'贾悦镇','102',1417),(18518,'孟疃镇','103',1417),(18519,'马庄镇','104',1417),(18520,'石桥子镇','105',1417),(18521,'程戈庄镇','106',1417),(18522,'九台镇','107',1417),(18523,'相州镇','108',1417),(18524,'郭家屯镇','109',1417),(18525,'昌城镇','110',1417),(18526,'百尺河镇','111',1417),(18527,'辛兴镇','112',1417),(18528,'朱解镇','113',1417),(18529,'林家村镇','114',1417),(18530,'瓦店镇','115',1417),(18531,'郝戈庄镇','116',1417),(18532,'皇华镇','117',1417),(18533,'桃园乡','200',1417),(18534,'桃林乡','201',1417),(18535,'圣城街道办事处','001',1418),(18536,'文家街道','003',1418),(18537,'古城街道','004',1418),(18538,'洛城街道','005',1418),(18539,'孙家集街道','006',1418),(18540,'大家洼街道办事处','007',1418),(18541,'化龙镇','100',1418),(18542,'营里镇','103',1418),(18543,'台头镇','104',1418),(18544,'田柳镇','106',1418),(18545,'上口镇','108',1418),(18546,'侯镇镇','109',1418),(18547,'纪台镇','111',1418),(18548,'稻田镇','112',1418),(18549,'田马镇','113',1418),(18550,'留吕镇','114',1418),(18551,'羊口镇','115',1418),(18552,'兴安街道办事处','001',1419),(18553,'贾戈街道办事处','002',1419),(18554,'景芝镇','100',1419),(18555,'黄旗堡镇','101',1419),(18556,'凌河镇','103',1419),(18557,'官庄镇','104',1419),(18558,'雹泉镇','105',1419),(18559,'红沙沟镇','106',1419),(18560,'大盛镇','107',1419),(18561,'庵上镇','108',1419),(18562,'赵戈镇','109',1419),(18563,'刘家尧镇','110',1419),(18564,'石埠子镇','111',1419),(18565,'石堆镇','112',1419),(18566,'关王镇','113',1419),(18567,'王家庄镇','114',1419),(18568,'临浯镇','115',1419),(18569,'白芬子镇','116',1419),(18570,'管公镇','117',1419),(18571,'柘山镇','118',1419),(18572,'辉渠镇','119',1419),(18573,'吾山镇','120',1419),(18574,'金冢子镇','121',1419),(18575,'高密市朝阳街道','001',1420),(18576,'高密市醴泉街道','002',1420),(18577,'高密市密水街道','003',1420),(18578,'柏城镇','100',1420),(18579,'高密市姚哥庄镇','101',1420),(18580,'高密市河崖镇','102',1420),(18581,'夏庄镇','103',1420),(18582,'姜庄镇','104',1420),(18583,'仁和镇','105',1420),(18584,'大牟家镇','106',1420),(18585,'周戈庄镇','107',1420),(18586,'康庄镇','108',1420),(18587,'阚家镇','109',1420),(18588,'双羊镇','110',1420),(18589,'井沟镇','111',1420),(18590,'呼家庄镇','112',1420),(18591,'注沟镇','113',1420),(18592,'柴沟镇','114',1420),(18593,'高密市拒城河镇','115',1420),(18594,'高密市李家营镇','116',1420),(18595,'奎聚街道办事处','001',1421),(18596,'都昌街道办事处','002',1421),(18597,'柳疃镇','101',1421),(18598,'龙池镇','102',1421),(18599,'夏店镇','103',1421),(18600,'卜庄镇','104',1421),(18601,'围子镇','105',1421),(18602,'宋庄镇','106',1421),(18603,'石埠镇','107',1421),(18604,'饮马镇','108',1421),(18605,'北孟镇','109',1421),(18606,'丈岭镇','111',1421),(18607,'双台乡','201',1421),(18608,'太保庄乡','202',1421),(18609,'古槐街道办事处','001',1423),(18610,'济阳街道办事处','002',1423),(18611,'阜桥街道办事处','003',1423),(18612,'越河街道办事处','004',1423),(18613,'仙营街道办事处','005',1423),(18614,'观音阁街道办事处','006',1423),(18615,'金城街道办事处','007',1423),(18616,'南苑街道办事处','008',1423),(18617,'三贾街道办事处','001',1424),(18618,'许庄街道办事处','002',1424),(18619,'柳行街道办事处','003',1424),(18620,'李营镇','100',1424),(18621,'廿里铺镇','101',1424),(18622,'长沟镇','102',1424),(18623,'安居镇','103',1424),(18624,'唐口镇','104',1424),(18625,'接庄镇','105',1424),(18626,'南张镇','108',1424),(18627,'石桥镇','109',1424),(18628,'喻屯镇','110',1424),(18629,'兖矿集团济东新村','400',1424),(18630,'夏镇街道办事处','001',1425),(18631,'昭阳街道办事处','002',1425),(18632,'韩庄镇','101',1425),(18633,'欢城镇','102',1425),(18634,'南阳镇','103',1425),(18635,'鲁桥镇','104',1425),(18636,'傅村镇','105',1425),(18637,'留庄镇','106',1425),(18638,'微山岛乡','200',1425),(18639,'两城乡','204',1425),(18640,'马坡乡','205',1425),(18641,'高楼乡','206',1425),(18642,'张楼乡','207',1425),(18643,'赵庙乡','209',1425),(18644,'西平乡','210',1425),(18645,'谷亭镇','100',1426),(18646,'清河镇','101',1426),(18647,'鱼城镇','102',1426),(18648,'王鲁镇','103',1426),(18649,'张黄镇','104',1426),(18650,'王庙镇','105',1426),(18651,'李阁镇','106',1426),(18652,'唐马乡','200',1426),(18653,'老砦乡','201',1426),(18654,'罗屯乡','204',1426),(18655,'金乡镇','100',1427),(18656,'羊山镇','101',1427),(18657,'胡集镇','102',1427),(18658,'肖云镇','103',1427),(18659,'鸡黍镇','104',1427),(18660,'王丕镇','106',1427),(18661,'司马镇','107',1427),(18662,'鱼山镇','108',1427),(18663,'马庙镇','109',1427),(18664,'化雨乡','200',1427),(18665,'卜集乡','201',1427),(18666,'高河乡','202',1427),(18667,'兴隆乡','203',1427),(18668,'嘉祥镇','100',1428),(18669,'纸坊镇','101',1428),(18670,'梁宝寺镇','102',1428),(18671,'卧龙山镇','103',1428),(18672,'疃里镇','104',1428),(18673,'马村镇','105',1428),(18674,'金屯镇','106',1428),(18675,'大张楼镇','107',1428),(18676,'老僧堂乡','200',1428),(18677,'黄垓乡','201',1428),(18678,'万张乡','204',1428),(18679,'马集乡','207',1428),(18680,'满硐乡','208',1428),(18681,'仲山乡','209',1428),(18682,'孟姑集乡','210',1428),(18683,'汶上镇','100',1429),(18684,'南站镇','101',1429),(18685,'南旺镇','102',1429),(18686,'次丘镇','103',1429),(18687,'寅寺镇','104',1429),(18688,'郭楼镇','105',1429),(18689,'康驿镇','106',1429),(18690,'苑庄镇','107',1429),(18691,'义桥乡','201',1429),(18692,'刘楼乡','202',1429),(18693,'郭仓乡','203',1429),(18694,'杨店乡','204',1429),(18695,'军屯乡','205',1429),(18696,'白石乡','206',1429),(18697,'泗河街道办事处','001',1430),(18698,'济河街道办事处','002',1430),(18699,'泉林镇','101',1430),(18700,'星村镇','102',1430),(18701,'柘沟镇','103',1430),(18702,'金庄镇','104',1430),(18703,'苗馆镇','105',1430),(18704,'中册镇','106',1430),(18705,'杨柳镇','107',1430),(18706,'泗张镇','108',1430),(18707,'圣水峪乡','200',1430),(18708,'大黄沟乡','205',1430),(18709,'高峪乡','206',1430),(18710,'梁山镇','100',1431),(18711,'小路口镇','101',1431),(18712,'韩岗镇','102',1431),(18713,'徐集镇','103',1431),(18714,'拳铺镇','104',1431),(18715,'杨营镇','105',1431),(18716,'韩垓镇','106',1431),(18717,'馆驿镇','107',1431),(18718,'小安山镇','108',1431),(18719,'马营乡','211',1431),(18720,'寿张集乡','213',1431),(18721,'黑虎庙乡','214',1431),(18722,'赵','215',1431),(18723,'大路口乡','217',1431),(18724,'鲁城街道办事处','001',1432),(18725,'书院街道办事处','002',1432),(18726,'吴村镇','101',1432),(18727,'姚村镇','102',1432),(18728,'陵城镇','103',1432),(18729,'小雪镇','104',1432),(18730,'南辛镇','105',1432),(18731,'时庄镇','107',1432),(18732,'王庄乡','200',1432),(18733,'董庄乡','201',1432),(18734,'息陬乡','202',1432),(18735,'防山乡','204',1432),(18736,'鼓楼街道办事处','001',1433),(18737,'永安街道办事处','002',1433),(18738,'大安镇','101',1433),(18739,'新驿镇','102',1433),(18740,'颜店镇','103',1433),(18741,'王因镇','104',1433),(18742,'新兖镇','105',1433),(18743,'谷村镇','106',1433),(18744,'漕河镇','107',1433),(18745,'黄屯镇','109',1433),(18746,'兴隆庄镇','110',1433),(18747,'小孟镇','111',1433),(18748,'钢山街道办事处','001',1434),(18749,'千泉街道办事处','002',1434),(18750,'凫山街道办事处','003',1434),(18751,'香城镇','101',1434),(18752,'城前镇','102',1434),(18753,'大束镇','103',1434),(18754,'北宿镇','104',1434),(18755,'中心店镇','105',1434),(18756,'唐村镇','106',1434),(18757,'太平镇','107',1434),(18758,'平阳寺镇','108',1434),(18759,'石墙镇','109',1434),(18760,'峄山镇','110',1434),(18761,'看庄镇','111',1434),(18762,'张庄镇','112',1434),(18763,'田黄镇','113',1434),(18764,'郭里镇','114',1434),(18765,'岱庙街道办事处','001',1436),(18766,'财源街道办事处','002',1436),(18767,'泰前街道办事处','003',1436),(18768,'上高街道办事处','004',1436),(18769,'徐家楼街道办事处','005',1436),(18770,'省庄镇','100',1436),(18771,'邱家店镇','101',1436),(18772,'大津口乡','202',1436),(18773,'粥店街道','001',1437),(18774,'天平街道','002',1437),(18775,'山口镇','100',1437),(18776,'祝阳镇','101',1437),(18777,'范镇','102',1437),(18778,'角峪镇','103',1437),(18779,'徂徕镇','104',1437),(18780,'北集坡镇','105',1437),(18781,'满庄镇','106',1437),(18782,'夏张镇','107',1437),(18783,'道朗镇','108',1437),(18784,'黄前镇','109',1437),(18785,'大汶口镇','110',1437),(18786,'马庄镇','111',1437),(18787,'房村镇','112',1437),(18788,'良庄镇','113',1437),(18789,'下港乡','200',1437),(18790,'化马湾乡','201',1437),(18791,'宁阳镇','100',1438),(18792,'泗店镇','101',1438),(18793,'东疏镇','102',1438),(18794,'伏山镇','103',1438),(18795,'蒋集镇','107',1438),(18796,'磁窑镇','109',1438),(18797,'华丰镇','110',1438),(18798,'葛石镇','111',1438),(18799,'鹤山乡','201',1438),(18800,'东庄乡','204',1438),(18801,'乡饮乡','206',1438),(18802,'州城镇','100',1439),(18803,'沙河站镇','101',1439),(18804,'彭集镇','102',1439),(18805,'东平镇','104',1439),(18806,'老湖镇','106',1439),(18807,'银山镇','107',1439),(18808,'斑鸠店镇','108',1439),(18809,'接山乡','200',1439),(18810,'大羊乡','202',1439),(18811,'梯门乡','203',1439),(18812,'新湖乡','204',1439),(18813,'商老庄乡','206',1439),(18814,'戴庙乡','207',1439),(18815,'旧县乡','208',1439),(18816,'青云街道办事处','001',1440),(18817,'新汶街道办事处','002',1440),(18818,'东都镇','101',1440),(18819,'小协镇','102',1440),(18820,'翟镇','103',1440),(18821,'泉沟镇','104',1440),(18822,'羊流镇','105',1440),(18823,'果都镇','106',1440),(18824,'西张庄镇','107',1440),(18825,'天宝镇','108',1440),(18826,'楼德镇','110',1440),(18827,'禹村镇','111',1440),(18828,'宫里镇','112',1440),(18829,'谷里镇','113',1440),(18830,'石莱镇','114',1440),(18831,'放城镇','115',1440),(18832,'刘杜镇','116',1440),(18833,'汶南镇','117',1440),(18834,'龙廷镇','119',1440),(18835,'岳家庄乡','203',1440),(18836,'新城街道','001',1441),(18837,'老城镇','100',1441),(18838,'潮泉镇','101',1441),(18839,'王瓜店镇','102',1441),(18840,'桃园镇','103',1441),(18841,'王庄镇','104',1441),(18842,'湖屯镇','105',1441),(18843,'石横镇','106',1441),(18844,'安临站镇','107',1441),(18845,'孙伯镇','108',1441),(18846,'安驾庄镇','109',1441),(18847,'汶阳镇','110',1441),(18848,'边院镇','111',1441),(18849,'仪阳乡','200',1441),(18850,'环翠楼街道办事处','001',1443),(18851,'鲸园街道办事处','002',1443),(18852,'竹岛街道办事处','003',1443),(18853,'怡园街道办事处','004',1443),(18854,'田和街道办事处','007',1443),(18855,'皇冠街道办事处','008',1443),(18856,'凤林街道办事处','009',1443),(18857,'西苑街道办事处','010',1443),(18858,'张村镇','100',1443),(18859,'羊亭镇','101',1443),(18860,'温泉镇','102',1443),(18861,'崮山镇','103',1443),(18862,'孙家疃镇','104',1443),(18863,'泊于镇','105',1443),(18864,'桥头镇','106',1443),(18865,'草庙子镇','107',1443),(18866,'初村镇','108',1443),(18867,'龙山路街道办事处','001',1444),(18868,'天福路街道办事处','002',1444),(18869,'环山路街道办事处','003',1444),(18870,'文登营镇','100',1444),(18871,'大水泊镇','101',1444),(18872,'张家产镇','102',1444),(18873,'高村镇','103',1444),(18874,'泽库镇','104',1444),(18875,'侯家镇','105',1444),(18876,'宋村镇','106',1444),(18877,'泽头镇','107',1444),(18878,'小观镇','108',1444),(18879,'葛家镇','109',1444),(18880,'米山镇','110',1444),(18881,'界石镇','111',1444),(18882,'汪疃镇','112',1444),(18883,'苘山镇','113',1444),(18884,'开发区办事处','400',1444),(18885,'宁津街道办事处','001',1445),(18886,'港湾街道办事处','002',1445),(18887,'桃园街道办事处','003',1445),(18888,'王连街道办事处','004',1445),(18889,'东山街道办事处','005',1445),(18890,'斥山街道办事处','006',1445),(18891,'崖头街道办事处','007',1445),(18892,'城西街道办事处','008',1445),(18893,'寻山街道办事处','009',1445),(18894,'崂山街道办事处','010',1445),(18895,'俚岛镇','101',1445),(18896,'成山镇','102',1445),(18897,'埠柳镇','103',1445),(18898,'港西镇','104',1445),(18899,'夏庄镇','105',1445),(18900,'崖西镇','106',1445),(18901,'荫子镇','107',1445),(18902,'滕家镇','108',1445),(18903,'大疃镇','109',1445),(18904,'上庄镇','110',1445),(18905,'虎山镇','111',1445),(18906,'人和镇','112',1445),(18907,'城区街道办事处','001',1446),(18908,'夏村镇','100',1446),(18909,'乳山口镇','101',1446),(18910,'海阳所镇','102',1446),(18911,'白沙滩镇','103',1446),(18912,'大孤山镇','104',1446),(18913,'南黄镇','105',1446),(18914,'冯家镇','106',1446),(18915,'下初镇','107',1446),(18916,'午极镇','108',1446),(18917,'育黎镇','109',1446),(18918,'崖子镇','110',1446),(18919,'诸往镇','111',1446),(18920,'乳山寨镇','112',1446),(18921,'徐家镇','114',1446),(18922,'日照街道','001',1448),(18923,'石臼街道','002',1448),(18924,'奎山街道办事处','003',1448),(18925,'秦楼街道','004',1448),(18926,'北京路街道办事处','007',1448),(18927,'河山镇','100',1448),(18928,'两城镇','101',1448),(18929,'涛雒镇','102',1448),(18930,'西湖镇','106',1448),(18931,'陈疃镇','107',1448),(18932,'南湖镇','108',1448),(18933,'三庄镇','109',1448),(18934,'岚山头街道办事处','001',1449),(18935,'安东卫街道办事处','002',1449),(18936,'碑廓镇','100',1449),(18937,'虎山镇','101',1449),(18938,'巨峰镇','102',1449),(18939,'高兴镇','103',1449),(18940,'后村镇','104',1449),(18941,'黄墩镇','105',1449),(18942,'前三岛乡','200',1449),(18943,'洪凝镇','101',1450),(18944,'街头镇','102',1450),(18945,'潮河镇','103',1450),(18946,'许孟镇','104',1450),(18947,'于里镇','105',1450),(18948,'汪湖镇','106',1450),(18949,'叩官镇','107',1450),(18950,'中至镇','108',1450),(18951,'高泽镇','109',1450),(18952,'石场乡','201',1450),(18953,'户部乡','202',1450),(18954,'松柏乡','203',1450),(18955,'城阳镇','101',1451),(18956,'招贤镇','102',1451),(18957,'阎庄镇','103',1451),(18958,'夏庄镇','104',1451),(18959,'刘官庄镇','105',1451),(18960,'峤山镇','106',1451),(18961,'小店镇','107',1451),(18962,'中楼镇','108',1451),(18963,'龙山镇','109',1451),(18964,'东莞镇','110',1451),(18965,'浮来山镇','111',1451),(18966,'陵阳镇','112',1451),(18967,'店子集镇','113',1451),(18968,'长岭镇','114',1451),(18969,'安庄镇','115',1451),(18970,'棋山镇','116',1451),(18971,'洛河镇','117',1451),(18972,'寨里河乡','201',1451),(18973,'果庄乡','204',1451),(18974,'桑园乡','205',1451),(18975,'库山乡','206',1451),(18976,'凤城街道办事处','001',1453),(18977,'张家洼街道办事处','002',1453),(18978,'高庄街道办事处','003',1453),(18979,'鹏泉街道办事处','004',1453),(18980,'口镇','100',1453),(18981,'羊里镇','101',1453),(18982,'方下镇','102',1453),(18983,'牛泉镇','103',1453),(18984,'苗山镇','105',1453),(18985,'雪野镇','106',1453),(18986,'大王庄镇','107',1453),(18987,'寨里镇','108',1453),(18988,'杨庄镇','109',1453),(18989,'茶业口镇','110',1453),(18990,'和庄乡','200',1453),(18991,'艾山街道办事处','001',1454),(18992,'颜庄镇','100',1454),(18993,'黄庄镇','101',1454),(18994,'里辛镇','102',1454),(18995,'辛庄镇','103',1454),(18996,'兰山街道','001',1456),(18997,'银雀山街道','002',1456),(18998,'金雀山街道','003',1456),(18999,'南坊街道','004',1456),(19000,'白沙埠镇','101',1456),(19001,'枣沟头镇','102',1456),(19002,'半程镇','103',1456),(19003,'义堂镇','105',1456),(19004,'马厂湖镇','106',1456),(19005,'李官镇','107',1456),(19006,'朱保镇','108',1456),(19007,'罗庄街道办事处','001',1457),(19008,'付庄街道办事处','002',1457),(19009,'盛庄街道办事处','003',1457),(19010,'汤庄街道办事处','004',1457),(19011,'双月街道湖办事处','005',1457),(19012,'册山街道办事处','006',1457),(19013,'高都街道办事处','007',1457),(19014,'罗西街道办事处','008',1457),(19015,'九曲街道办事处','001',1458),(19016,'芝麻墩街道办事处','002',1458),(19017,'梅埠街道办事处','003',1458),(19018,'相公街道办事处','004',1458),(19019,'太平街道办事处','005',1458),(19020,'汤头街道办事处','006',1458),(19021,'凤凰岭街道办事处','007',1458),(19022,'重沟镇','103',1458),(19023,'汤河镇','104',1458),(19024,'八湖镇','107',1458),(19025,'郑旺镇','108',1458),(19026,'刘店子乡','201',1458),(19027,'界湖镇','100',1459),(19028,'岸堤镇','101',1459),(19029,'孙祖镇','102',1459),(19030,'双堠镇','103',1459),(19031,'青驼镇','104',1459),(19032,'张庄镇','105',1459),(19033,'砖埠镇','106',1459),(19034,'葛沟镇','107',1459),(19035,'杨家坡镇','108',1459),(19036,'大庄镇','109',1459),(19037,'辛集镇','110',1459),(19038,'蒲汪镇','111',1459),(19039,'湖头镇','112',1459),(19040,'苏村镇','113',1459),(19041,'铜井镇','114',1459),(19042,'依汶镇','115',1459),(19043,'马牧池乡','201',1459),(19044,'郯城镇','100',1460),(19045,'马头镇','101',1460),(19046,'重坊镇','102',1460),(19047,'李庄镇','103',1460),(19048,'褚墩镇','104',1460),(19049,'杨集镇','105',1460),(19050,'黄山镇','106',1460),(19051,'港上镇','107',1460),(19052,'高峰头镇','108',1460),(19053,'庙山镇','109',1460),(19054,'沙墩镇','110',1460),(19055,'胜利乡','200',1460),(19056,'新村乡','201',1460),(19057,'花园乡','202',1460),(19058,'归昌乡','203',1460),(19059,'红花乡','204',1460),(19060,'泉源乡','205',1460),(19061,'沂水镇','100',1461),(19062,'马站镇','101',1461),(19063,'高桥镇','102',1461),(19064,'许家湖镇','103',1461),(19065,'黄山铺镇','104',1461),(19066,'姚店子镇','105',1461),(19067,'诸葛镇','106',1461),(19068,'崔家峪镇','107',1461),(19069,'四十里堡镇','108',1461),(19070,'杨庄镇','109',1461),(19071,'夏蔚镇','110',1461),(19072,'沙沟镇','111',1461),(19073,'高庄镇','112',1461),(19074,'道托乡','200',1461),(19075,'圈里乡','201',1461),(19076,'龙家圈乡','202',1461),(19077,'泉庄乡','203',1461),(19078,'富官庄乡','204',1461),(19079,'院东头乡','205',1461),(19080,'卞庄镇','100',1462),(19081,'大仲村镇','101',1462),(19082,'兰陵镇','102',1462),(19083,'长城镇','103',1462),(19084,'磨山镇','104',1462),(19085,'神山镇','105',1462),(19086,'车辋镇','106',1462),(19087,'尚岩镇','107',1462),(19088,'向城镇','108',1462),(19089,'新兴镇','109',1462),(19090,'南桥镇','110',1462),(19091,'层山镇','111',1462),(19092,'庄坞镇','112',1462),(19093,'沂堂镇','113',1462),(19094,'贾庄乡','200',1462),(19095,'矿坑乡','201',1462),(19096,'下村乡','202',1462),(19097,'鲁城乡','203',1462),(19098,'三合乡','204',1462),(19099,'兴明乡','205',1462),(19100,'二庙乡','206',1462),(19101,'费城镇','100',1463),(19102,'上冶镇','101',1463),(19103,'薛庄镇','102',1463),(19104,'方城镇','103',1463),(19105,'汪沟镇','104',1463),(19106,'探沂镇','105',1463),(19107,'朱田镇','106',1463),(19108,'梁邱镇','107',1463),(19109,'新庄镇','108',1463),(19110,'马庄镇','109',1463),(19111,'新桥镇','110',1463),(19112,'刘庄镇','111',1463),(19113,'胡阳镇','112',1463),(19114,'石井镇','113',1463),(19115,'大田庄乡','200',1463),(19116,'南张庄乡','201',1463),(19117,'城北乡','202',1463),(19118,'芍药山乡','204',1463),(19119,'平邑镇','100',1464),(19120,'仲村镇','101',1464),(19121,'武台镇','102',1464),(19122,'保太镇','103',1464),(19123,'柏林镇','104',1464),(19124,'卞桥镇','105',1464),(19125,'地方镇','106',1464),(19126,'铜石镇','107',1464),(19127,'温水镇','108',1464),(19128,'流峪镇','109',1464),(19129,'郑城镇','110',1464),(19130,'白彦镇','111',1464),(19131,'临涧镇','112',1464),(19132,'丰阳镇','113',1464),(19133,'资邱乡','200',1464),(19134,'魏庄乡','201',1464),(19135,'十字路镇','100',1465),(19136,'团林镇','101',1465),(19137,'大店镇','102',1465),(19138,'坊前镇','103',1465),(19139,'坪上镇','104',1465),(19140,'相邸镇','105',1465),(19141,'板泉镇','106',1465),(19142,'洙边镇','107',1465),(19143,'文疃镇','108',1465),(19144,'壮岗镇','109',1465),(19145,'汀水镇','110',1465),(19146,'石莲子镇','111',1465),(19147,'岭泉镇','112',1465),(19148,'筵宾镇','113',1465),(19149,'涝坡镇','114',1465),(19150,'朱芦镇','115',1465),(19151,'道口乡','200',1465),(19152,'相沟乡','201',1465),(19153,'蒙阴镇','100',1466),(19154,'常路镇','101',1466),(19155,'岱崮镇','102',1466),(19156,'坦埠镇','103',1466),(19157,'垛庄镇','104',1466),(19158,'高都镇','105',1466),(19159,'野店镇','106',1466),(19160,'桃墟镇','107',1466),(19161,'界牌镇','108',1466),(19162,'联城乡','200',1466),(19163,'旧寨乡','201',1466),(19164,'临沭镇','100',1467),(19165,'蛟龙镇','101',1467),(19166,'大兴镇','102',1467),(19167,'石门镇','103',1467),(19168,'曹庄镇','104',1467),(19169,'南古镇','105',1467),(19170,'郑山镇','106',1467),(19171,'白旄镇','107',1467),(19172,'青云镇','108',1467),(19173,'玉山镇','109',1467),(19174,'店头镇','110',1467),(19175,'朱仓乡','200',1467),(19176,'新湖街道办事处','001',1469),(19177,'新华街道办事处','002',1469),(19178,'天衢街道办事处','003',1469),(19179,'东地街道办事处','004',1469),(19180,'运河街道办事处','005',1469),(19181,'二屯镇','100',1469),(19182,'黄河涯镇','101',1469),(19183,'宋官屯镇','103',1469),(19184,'赵虎镇','106',1469),(19185,'抬头寺乡','200',1469),(19186,'袁桥乡','201',1469),(19187,'安德街道办事处','001',1470),(19188,'陵城镇','100',1470),(19189,'郑家寨镇','101',1470),(19190,'糜镇','102',1470),(19191,'宋家镇','103',1470),(19192,'徽王庄镇','104',1470),(19193,'神头镇','105',1470),(19194,'滋镇','106',1470),(19195,'前孙镇','107',1470),(19196,'边临镇','108',1470),(19197,'义渡口乡','200',1470),(19198,'丁庄乡','201',1470),(19199,'于集乡','202',1470),(19200,'宁津镇','100',1471),(19201,'柴胡店镇','101',1471),(19202,'长官镇','102',1471),(19203,'杜集镇','103',1471),(19204,'保店镇','104',1471),(19205,'大柳镇','105',1471),(19206,'大曹镇','106',1471),(19207,'相衙镇','107',1471),(19208,'时集镇','108',1471),(19209,'张大庄乡','200',1471),(19210,'刘营伍乡','201',1471),(19211,'渤海路街道办事处','001',1472),(19212,'庆云镇','100',1472),(19213,'常家镇','101',1472),(19214,'尚堂镇','102',1472),(19215,'崔口镇','103',1472),(19216,'严务乡','200',1472),(19217,'东辛店乡','201',1472),(19218,'中丁乡','202',1472),(19219,'徐园子乡','203',1472),(19220,'邢侗街道办事处','001',1473),(19221,'恒源街道办事处','002',1473),(19222,'临盘街道办事处','003',1473),(19223,'临邑镇','100',1473),(19224,'临南镇','102',1473),(19225,'德平镇','103',1473),(19226,'林子镇','104',1473),(19227,'兴隆镇','105',1473),(19228,'孟寺镇','106',1473),(19229,'翟家乡','200',1473),(19230,'理合务乡','201',1473),(19231,'宿安乡','202',1473),(19232,'晏城镇','100',1474),(19233,'表白寺镇','101',1474),(19234,'焦庙镇','102',1474),(19235,'赵官镇','103',1474),(19236,'祝阿镇','104',1474),(19237,'仁里集镇','105',1474),(19238,'潘店镇','106',1474),(19239,'胡官屯镇','107',1474),(19240,'宣章屯镇','108',1474),(19241,'华店乡','200',1474),(19242,'安头乡','201',1474),(19243,'马集乡','202',1474),(19244,'刘桥乡','203',1474),(19245,'大黄乡','204',1474),(19246,'龙门街道办事处','001',1475),(19247,'桃园街道办事处','002',1475),(19248,'王凤楼镇','101',1475),(19249,'前曹镇','102',1475),(19250,'恩城镇','103',1475),(19251,'王庙镇','104',1475),(19252,'王杲铺镇','105',1475),(19253,'张华镇','106',1475),(19254,'腰站镇','107',1475),(19255,'坊子乡','200',1475),(19256,'王打卦乡','201',1475),(19257,'三唐乡','202',1475),(19258,'银城街道办事处','001',1476),(19259,'北城街道办事处','002',1476),(19260,'南城镇','100',1476),(19261,'苏留庄镇','101',1476),(19262,'新盛店镇','102',1476),(19263,'雷集镇','103',1476),(19264,'郑保屯镇','104',1476),(19265,'白马湖镇','105',1476),(19266,'东李官屯镇','106',1476),(19267,'宋楼镇','107',1476),(19268,'香赵庄镇','108',1476),(19269,'双庙镇','109',1476),(19270,'渡口驿乡','200',1476),(19271,'田庄乡','204',1476),(19272,'广运街道办事处','001',1477),(19273,'武城镇','100',1477),(19274,'老城镇','101',1477),(19275,'滕庄镇','102',1477),(19276,'鲁权屯镇','103',1477),(19277,'郝王庄镇','104',1477),(19278,'杨庄乡','200',1477),(19279,'李家户乡','201',1477),(19280,'甲马营乡','202',1477),(19281,'市中街道','001',1478),(19282,'胡家街道','002',1478),(19283,'云红街道','003',1478),(19284,'郭家街道','004',1478),(19285,'杨安镇','100',1478),(19286,'朱集镇','101',1478),(19287,'黄夹镇','102',1478),(19288,'丁坞镇','103',1478),(19289,'花园镇','104',1478),(19290,'郑店镇','105',1478),(19291,'化楼镇','106',1478),(19292,'孔镇','107',1478),(19293,'西段乡','200',1478),(19294,'大孙乡','201',1478),(19295,'铁营乡','202',1478),(19296,'寨头堡乡','203',1478),(19297,'市中街道','001',1479),(19298,'伦镇','100',1479),(19299,'房寺镇','101',1479),(19300,'张庄镇','102',1479),(19301,'辛店镇','103',1479),(19302,'安仁镇','104',1479),(19303,'辛寨镇','105',1479),(19304,'梁家镇','106',1479),(19305,'李屯乡','200',1479),(19306,'十里望乡','201',1479),(19307,'莒镇乡','202',1479),(19308,'古楼街道办事处','001',1481),(19309,'柳园街道办事处','002',1481),(19310,'新区街道办事处','003',1481),(19311,'湖西街道办事处','004',1481),(19312,'道口铺街道办事','005',1481),(19313,'阎寺街道办事处','006',1481),(19314,'凤凰街道办事处','007',1481),(19315,'北城街道办事处','008',1481),(19316,'东城街道办事处','009',1481),(19317,'蒋官屯街道办事','010',1481),(19318,'侯营镇','100',1481),(19319,'沙镇镇','101',1481),(19320,'堂邑镇','102',1481),(19321,'梁水镇','103',1481),(19322,'斗虎屯镇','104',1481),(19323,'郑家镇','105',1481),(19324,'张炉集镇','106',1481),(19325,'于集镇','107',1481),(19326,'许营乡','200',1481),(19327,'朱老庄乡','201',1481),(19328,'博济桥街道办事','001',1482),(19329,'侨润街道办事处','002',1482),(19330,'狮子楼街道办事','003',1482),(19331,'阎楼镇','101',1482),(19332,'阿城镇','103',1482),(19333,'七级镇','104',1482),(19334,'安乐镇','105',1482),(19335,'定水镇','106',1482),(19336,'石佛镇','107',1482),(19337,'李台镇','108',1482),(19338,'寿张镇','109',1482),(19339,'十五里园镇','111',1482),(19340,'张秋镇','112',1482),(19341,'郭店屯乡','201',1482),(19342,'大布乡','203',1482),(19343,'西湖乡','205',1482),(19344,'高庙王乡','206',1482),(19345,'金斗营乡','207',1482),(19346,'莘城镇','100',1483),(19347,'张鲁镇','101',1483),(19348,'朝城镇','102',1483),(19349,'观城镇','103',1483),(19350,'古城镇','104',1483),(19351,'大张家镇','105',1483),(19352,'古云镇','106',1483),(19353,'十八里铺镇','107',1483),(19354,'莘亭镇','108',1483),(19355,'燕店镇','109',1483),(19356,'董杜庄镇','110',1483),(19357,'王奉镇','111',1483),(19358,'樱桃园镇','112',1483),(19359,'河店镇','113',1483),(19360,'妹冢镇','114',1483),(19361,'魏庄乡','202',1483),(19362,'大王寨乡','203',1483),(19363,'俎店乡','207',1483),(19364,'张寨乡','209',1483),(19365,'徐庄乡','210',1483),(19366,'王庄集乡','212',1483),(19367,'柿子园乡','214',1483),(19368,'振兴街道办事处','001',1484),(19369,'信发街道办事处','002',1484),(19370,'乐平铺镇','101',1484),(19371,'冯官屯镇','102',1484),(19372,'菜屯镇','103',1484),(19373,'博平镇','104',1484),(19374,'杜郎口镇','105',1484),(19375,'韩屯镇','106',1484),(19376,'韩集乡','201',1484),(19377,'广平乡','202',1484),(19378,'胡屯乡','205',1484),(19379,'温陈乡','206',1484),(19380,'贾寨乡','207',1484),(19381,'杨官屯乡','208',1484),(19382,'洪官屯乡','209',1484),(19383,'肖庄乡','210',1484),(19384,'铜城街道办事处','001',1485),(19385,'新城街道办事处','002',1485),(19386,'刘集镇','101',1485),(19387,'牛角店镇','102',1485),(19388,'大桥镇','103',1485),(19389,'高集镇','104',1485),(19390,'姜楼镇','105',1485),(19391,'顾官屯镇','106',1485),(19392,'姚寨镇','107',1485),(19393,'鱼山乡','201',1485),(19394,'陈集乡','205',1485),(19395,'冠城镇','100',1486),(19396,'贾镇','101',1486),(19397,'桑阿镇','102',1486),(19398,'柳林镇','103',1486),(19399,'清水镇','104',1486),(19400,'东古城镇','105',1486),(19401,'北馆陶镇','106',1486),(19402,'斜店乡','200',1486),(19403,'梁堂乡','201',1486),(19404,'定远寨乡','202',1486),(19405,'辛集乡','203',1486),(19406,'范寨乡','204',1486),(19407,'甘官屯乡','205',1486),(19408,'兰沃乡','206',1486),(19409,'店子乡','207',1486),(19410,'烟庄乡','208',1486),(19411,'万善乡','209',1486),(19412,'鱼邱湖街道办','001',1487),(19413,'汇鑫街道办事','002',1487),(19414,'人和街道办事','003',1487),(19415,'梁村镇','101',1487),(19416,'尹集镇','102',1487),(19417,'清平镇','103',1487),(19418,'固河镇','104',1487),(19419,'三十里铺镇','105',1487),(19420,'琉璃寺镇','106',1487),(19421,'杨屯乡','203',1487),(19422,'赵寨子乡','204',1487),(19423,'姜店乡','205',1487),(19424,'青年路街道办事处','001',1488),(19425,'新华路街道办事处','002',1488),(19426,'先锋路街道办事处','003',1488),(19427,'大辛庄街道办事处','004',1488),(19428,'松林镇','101',1488),(19429,'老赵庄镇','102',1488),(19430,'康庄镇','103',1488),(19431,'魏湾镇','104',1488),(19432,'刘垓子镇','105',1488),(19433,'八岔路镇','107',1488),(19434,'潘庄镇','108',1488),(19435,'烟店镇','109',1488),(19436,'唐园镇','110',1488),(19437,'金郝庄乡','201',1488),(19438,'戴湾乡','202',1488),(19439,'尚店乡','203',1488),(19440,'市中街道办事处','001',1490),(19441,'市西街道办事处','002',1490),(19442,'北镇街道办事处','003',1490),(19443,'市东街道办事处','004',1490),(19444,'彭李街道办事处','005',1490),(19445,'小营街道办事处','007',1490),(19446,'滨北街道办事处','008',1490),(19447,'梁才街道办事处','009',1490),(19448,'杜店街道办事处','010',1490),(19449,'沙河街道办事处','011',1490),(19450,'里则街道办事处','012',1490),(19451,'旧镇镇','104',1490),(19452,'堡集镇','105',1490),(19453,'尚集乡','201',1490),(19454,'秦皇台乡','203',1490),(19455,'孙武镇','100',1491),(19456,'石庙镇','101',1491),(19457,'桑落墅镇','102',1491),(19458,'淄角镇','103',1491),(19459,'胡集镇','104',1491),(19460,'李庄镇','105',1491),(19461,'麻店镇','107',1491),(19462,'魏集镇','108',1491),(19463,'清河镇','109',1491),(19464,'姜楼镇','111',1491),(19465,'何坊乡','200',1491),(19466,'皂户李乡','204',1491),(19467,'辛店乡','205',1491),(19468,'大年陈乡','208',1491),(19469,'阳信镇','100',1492),(19470,'商店镇','101',1492),(19471,'温店镇','102',1492),(19472,'河流镇','103',1492),(19473,'翟王镇','104',1492),(19474,'流坡坞镇','105',1492),(19475,'劳店乡','200',1492),(19476,'水落坡乡','201',1492),(19477,'洋湖乡','204',1492),(19478,'无棣镇','100',1493),(19479,'水湾镇','101',1493),(19480,'碣石山镇','102',1493),(19481,'小泊头镇','103',1493),(19482,'埕口镇','104',1493),(19483,'马山子镇','105',1493),(19484,'信阳乡','200',1493),(19485,'车镇乡','201',1493),(19486,'柳堡乡','202',1493),(19487,'西小王乡','203',1493),(19488,'佘家巷乡','204',1493),(19489,'富国镇','100',1494),(19490,'下洼镇','101',1494),(19491,'古城镇','102',1494),(19492,'冯家镇','103',1494),(19493,'泊头镇','104',1494),(19494,'大高镇','105',1494),(19495,'黄升乡','201',1494),(19496,'滨海乡','202',1494),(19497,'下河乡','203',1494),(19498,'利国乡','204',1494),(19499,'海防办事处乡','205',1494),(19500,'博兴镇','100',1495),(19501,'曹王镇','101',1495),(19502,'兴福镇','102',1495),(19503,'陈户镇','103',1495),(19504,'湖滨镇','104',1495),(19505,'店子镇','106',1495),(19506,'吕艺镇','107',1495),(19507,'纯化镇','108',1495),(19508,'庞家镇','109',1495),(19509,'乔庄镇','110',1495),(19510,'黛溪街道办事处','001',1496),(19511,'黄山街道办事处','002',1496),(19512,'高新街道办事处','003',1496),(19513,'长山镇','101',1496),(19514,'魏桥镇','102',1496),(19515,'西董镇','103',1496),(19516,'好生镇','104',1496),(19517,'临池镇','105',1496),(19518,'焦桥镇','108',1496),(19519,'韩店镇','109',1496),(19520,'孙镇镇','110',1496),(19521,'九户镇','111',1496),(19522,'青阳镇','112',1496),(19523,'明集镇','113',1496),(19524,'台子镇','114',1496),(19525,'码头镇','115',1496),(19526,'东城街道','001',1498),(19527,'西城街道','002',1498),(19528,'南城街道','003',1498),(19529,'北城街道','004',1498),(19530,'牡丹街道','005',1498),(19531,'丹阳街道(属开','006',1498),(19532,'岳程街道(属开','007',1498),(19533,'佃户屯街道办','008',1498),(19534,'何楼街道','009',1498),(19535,'万福街道','010',1498),(19536,'沙土镇','100',1498),(19537,'吴店镇','101',1498),(19538,'王浩屯镇','102',1498),(19539,'黄','103',1498),(19540,'都司镇','104',1498),(19541,'高庄镇','105',1498),(19542,'小留镇','106',1498),(19543,'李村镇','107',1498),(19544,'马岭岗镇','108',1498),(19545,'安兴镇','109',1498),(19546,'大黄集镇','110',1498),(19547,'吕陵镇','111',1498),(19548,'胡集乡','201',1498),(19549,'皇镇乡','202',1498),(19550,'曹县曹城镇','100',1499),(19551,'庄寨镇','101',1499),(19552,'普连集镇','102',1499),(19553,'青固集镇','103',1499),(19554,'桃源集镇','104',1499),(19555,'韩集镇','105',1499),(19556,'砖庙镇','106',1499),(19557,'古营集镇','107',1499),(19558,'魏湾镇','108',1499),(19559,'侯集回族镇','109',1499),(19560,'苏集镇','110',1499),(19561,'孙老家镇','111',1499),(19562,'阎店楼镇','112',1499),(19563,'梁堤头镇','113',1499),(19564,'安才楼镇','114',1499),(19565,'曹县邵庄镇','115',1499),(19566,'曹县王集镇','116',1499),(19567,'曹县青岗集乡','200',1499),(19568,'曹县常乐集乡','201',1499),(19569,'曹县倪集乡','202',1499),(19570,'曹县楼庄乡','203',1499),(19571,'曹县郑庄乡','205',1499),(19572,'曹县大集乡','206',1499),(19573,'曹县朱洪庙乡','207',1499),(19574,'曹县仵楼乡','208',1499),(19575,'单城镇','100',1500),(19576,'郭村镇','101',1500),(19577,'单县黄岗镇','102',1500),(19578,'单县终兴镇','103',1500),(19579,'单县孙溜镇','104',1500),(19580,'高韦庄镇','105',1500),(19581,'单县徐寨镇','106',1500),(19582,'蔡堂镇','107',1500),(19583,'单县朱集镇','108',1500),(19584,'单县李新庄镇','109',1500),(19585,'浮岗镇','110',1500),(19586,'莱河镇','111',1500),(19587,'单县时楼镇','112',1500),(19588,'杨楼镇','113',1500),(19589,'单县张集镇','114',1500),(19590,'龙王庙镇','115',1500),(19591,'单县谢集乡','200',1500),(19592,'单县高老家乡','201',1500),(19593,'单县曹庄乡','202',1500),(19594,'单县李田楼乡','204',1500),(19595,'成武县成武镇','100',1501),(19596,'成武县大田集镇','101',1501),(19597,'成武县天宫庙镇','102',1501),(19598,'成武县汶上集镇','103',1501),(19599,'成武县南鲁集镇','104',1501),(19600,'成武县伯乐集镇','105',1501),(19601,'成武县苟村集镇','106',1501),(19602,'成武县白浮图镇','107',1501),(19603,'成武县孙寺镇','108',1501),(19604,'成武县九女镇','109',1501),(19605,'成武县党集乡','200',1501),(19606,'成武县张楼乡','201',1501),(19607,'巨野镇','100',1502),(19608,'龙固镇','101',1502),(19609,'大义镇','102',1502),(19610,'柳林镇','103',1502),(19611,'章缝镇','104',1502),(19612,'大谢集镇','105',1502),(19613,'独山镇','106',1502),(19614,'麒麟镇','107',1502),(19615,'核桃园镇','108',1502),(19616,'田庄镇','109',1502),(19617,'太平镇','110',1502),(19618,'万丰镇','111',1502),(19619,'陶庙镇','112',1502),(19620,'董官屯镇','113',1502),(19621,'田桥镇','114',1502),(19622,'营里镇','115',1502),(19623,'郓城镇','100',1503),(19624,'黄安镇','101',1503),(19625,'杨庄集镇','102',1503),(19626,'侯咽集镇','103',1503),(19627,'武安镇','104',1503),(19628,'郭屯镇','105',1503),(19629,'丁里长镇','106',1503),(19630,'玉皇庙镇','107',1503),(19631,'程屯镇','108',1503),(19632,'随官屯镇','109',1503),(19633,'张营镇','110',1503),(19634,'潘渡镇','111',1503),(19635,'双桥乡','200',1503),(19636,'唐庙乡','201',1503),(19637,'南赵楼乡','202',1503),(19638,'黄堆集乡','203',1503),(19639,'黄集乡','205',1503),(19640,'李集乡','206',1503),(19641,'张鲁集乡','207',1503),(19642,'水堡乡','208',1503),(19643,'陈坡乡','209',1503),(19644,'鄄城镇','100',1504),(19645,'什集镇','101',1504),(19646,'红船镇','102',1504),(19647,'旧城镇','103',1504),(19648,'闫什镇','104',1504),(19649,'箕山镇','105',1504),(19650,'李进士堂镇','106',1504),(19651,'董口镇','107',1504),(19652,'临濮镇','108',1504),(19653,'彭楼镇','109',1504),(19654,'左营乡','200',1504),(19655,'大埝乡','201',1504),(19656,'引马乡','202',1504),(19657,'凤凰乡','205',1504),(19658,'富春乡','207',1504),(19659,'郑营乡','208',1504),(19660,'定陶镇','100',1505),(19661,'陈集镇','101',1505),(19662,'冉固镇','102',1505),(19663,'张湾镇','103',1505),(19664,'黄店镇','104',1505),(19665,'孟海镇','105',1505),(19666,'马集镇','106',1505),(19667,'仿山乡','200',1505),(19668,'南王店乡','202',1505),(19669,'定陶县半堤乡','203',1505),(19670,'定陶县杜堂乡','204',1505),(19671,'城关镇','100',1506),(19672,'东明集镇','101',1506),(19673,'东明县刘楼镇','102',1506),(19674,'东明县陆圈镇','103',1506),(19675,'东明县马头镇','104',1506),(19676,'三春集镇','105',1506),(19677,'东明县大屯镇','106',1506),(19678,'东明县武胜桥乡','200',1506),(19679,'东明县菜园集乡','201',1506),(19680,'东明县小井乡','202',1506),(19681,'沙窝乡','203',1506),(19682,'东明县长兴集乡','204',1506),(19683,'东明县焦园乡','205',1506),(19684,'林山寨街道办事处','001',1508),(19685,'建设路街道办事处','002',1508),(19686,'棉纺路街道办事处','003',1508),(19687,'秦岭路街道办事处','004',1508),(19688,'桐柏路街道办事处','005',1508),(19689,'三官庙街道办事处','006',1508),(19690,'绿东村街道办事处','007',1508),(19691,'汝河路街道办事处','008',1508),(19692,'航海西路街道办事处','009',1508),(19693,'中原西路街道办事处','010',1508),(19694,'须水镇','100',1508),(19695,'石佛镇','160',1508),(19696,'沟赵乡','360',1508),(19697,'淮河路街道办事处','001',1509),(19698,'解放路街道办事处','002',1509),(19699,'铭功路街道办事处','003',1509),(19700,'一马路街道办事处','004',1509),(19701,'蜜蜂张街道办事处','005',1509),(19702,'五里堡街道办事处','006',1509),(19703,'大学路街道办事处','007',1509),(19704,'建中街街道办事处','008',1509),(19705,'福华街街道办事处','009',1509),(19706,'德华街街道办事处','010',1509),(19707,'嵩山路街道办事处','011',1509),(19708,'京广路街道办事处','012',1509),(19709,'长江路街道办事处','013',1509),(19710,'马寨镇','100',1509),(19711,'侯寨乡','201',1509),(19712,'北下街街道办事处','001',1510),(19713,'西大街街道办事处','002',1510),(19714,'南关街道办事处','003',1510),(19715,'城东路街道办事处','004',1510),(19716,'东大街街道办事处','005',1510),(19717,'二里岗街道办事处','006',1510),(19718,'陇海路街道办事处','007',1510),(19719,'紫荆山南路街道办事处','008',1510),(19720,'航海东路街道办事处','009',1510),(19721,'十八里河镇','100',1510),(19722,'南曹乡','201',1510),(19723,'圃田乡','202',1510),(19724,'经济开发区明湖街道办事处','560',1510),(19725,'经济开发区潮河街道办事处','561',1510),(19726,'经八路街道办事处','001',1511),(19727,'花园路街道办事处','002',1511),(19728,'人民路街道办事处','003',1511),(19729,'杜岭街街道办事处','004',1511),(19730,'大石桥街道办事处','005',1511),(19731,'南阳路街道办事处','006',1511),(19732,'南阳新村街道办事处','007',1511),(19733,'文化路街道办事处','008',1511),(19734,'丰产路街道办事处','009',1511),(19735,'东风路街道办事处','010',1511),(19736,'北林路街道办事处','011',1511),(19737,'未来路街道办事处','012',1511),(19738,'凤凰台街道办事处','013',1511),(19739,'龙子湖街道办事处','014',1511),(19740,'祭城路街道办事处','015',1511),(19741,'柳林镇','101',1511),(19742,'庙李镇','102',1511),(19743,'济源路街道办事处','001',1512),(19744,'中心路街道办事处','002',1512),(19745,'新安路街道办事处','003',1512),(19746,'工业路街道办事处','004',1512),(19747,'矿山街道办事处','005',1512),(19748,'峡窝镇','100',1512),(19749,'新城街道办事处','001',1513),(19750,'刘寨街道办事处','002',1513),(19751,'老鸦陈街道办事处','003',1513),(19752,'长兴路街道办事处','004',1513),(19753,'迎宾路街道办事处','005',1513),(19754,'大河路街道办事处','006',1513),(19755,'花园口镇','100',1513),(19756,'古荥镇','101',1513),(19757,'城关镇','100',1514),(19758,'韩寺镇','101',1514),(19759,'官渡镇','102',1514),(19760,'狼城岗镇','103',1514),(19761,'万滩镇','104',1514),(19762,'白沙镇','105',1514),(19763,'郑庵镇','106',1514),(19764,'张庄镇','108',1514),(19765,'黄店镇','109',1514),(19766,'大孟镇','110',1514),(19767,'九龙镇','111',1514),(19768,'雁鸣湖乡','202',1514),(19769,'刘集乡','203',1514),(19770,'八岗乡','205',1514),(19771,'三官庙乡','206',1514),(19772,'刁家乡','208',1514),(19773,'姚家乡','209',1514),(19774,'新华路街道办事处','001',1515),(19775,'杜甫路街道办事处','002',1515),(19776,'永安路街道办事处','003',1515),(19777,'孝义街道办事处','004',1515),(19778,'紫荆路街道办事处','005',1515),(19779,'米河镇','100',1515),(19780,'新中镇','101',1515),(19781,'小关镇','102',1515),(19782,'竹林镇','103',1515),(19783,'大峪沟镇','104',1515),(19784,'河洛镇','105',1515),(19785,'站街镇','106',1515),(19786,'康店镇','108',1515),(19787,'北山口镇','110',1515),(19788,'西村镇','111',1515),(19789,'芝田镇','112',1515),(19790,'回郭镇','113',1515),(19791,'鲁庄镇','114',1515),(19792,'夹津口镇','115',1515),(19793,'涉村镇','116',1515),(19794,'索河街道办事处','001',1516),(19795,'京城街道办事处','002',1516),(19796,'乔楼镇','101',1516),(19797,'豫龙镇','102',1516),(19798,'广武镇','103',1516),(19799,'王村镇','104',1516),(19800,'汜水镇','105',1516),(19801,'高山镇','106',1516),(19802,'刘河镇','108',1516),(19803,'崔庙镇','109',1516),(19804,'贾峪镇','110',1516),(19805,'城关乡','200',1516),(19806,'高村乡','201',1516),(19807,'金寨回族乡','204',1516),(19808,'青屏街街道办事处','001',1517),(19809,'新华路街道办事处','002',1517),(19810,'西大街街道办事处','003',1517),(19811,'城关镇','100',1517),(19812,'米村镇','101',1517),(19813,'牛店镇','102',1517),(19814,'平陌镇','103',1517),(19815,'超化镇','104',1517),(19816,'苟堂镇','105',1517),(19817,'大隗镇','106',1517),(19818,'刘寨镇','107',1517),(19819,'白寨镇','108',1517),(19820,'岳村镇','109',1517),(19821,'来集镇','110',1517),(19822,'袁庄乡','200',1517),(19823,'曲梁乡','202',1517),(19824,'矿区街道办事处','400',1517),(19825,'尖山风景区管理委员会','401',1517),(19826,'新建路街道办事处','001',1518),(19827,'新华路街道办事处','002',1518),(19828,'新烟街道办事处','003',1518),(19829,'新村镇','101',1518),(19830,'辛店镇','102',1518),(19831,'观音寺镇','103',1518),(19832,'梨河镇','104',1518),(19833,'和庄镇','105',1518),(19834,'薛店镇','106',1518),(19835,'孟庄镇','107',1518),(19836,'郭店镇','108',1518),(19837,'龙湖镇','109',1518),(19838,'城关乡','200',1518),(19839,'八千乡','202',1518),(19840,'龙王乡','203',1518),(19841,'嵩阳街道办事处','001',1519),(19842,'少林街道办事处','002',1519),(19843,'中岳街道办事处','003',1519),(19844,'大金店镇','100',1519),(19845,'颖阳镇','101',1519),(19846,'卢店镇','102',1519),(19847,'告成镇','103',1519),(19848,'阳城区镇','104',1519),(19849,'大冶镇','105',1519),(19850,'宣化镇','106',1519),(19851,'东金店乡','201',1519),(19852,'白坪乡','202',1519),(19853,'君召乡','203',1519),(19854,'石道乡','204',1519),(19855,'唐庄乡','205',1519),(19856,'徐庄乡','206',1519),(19857,'北书店街道办事处','001',1521),(19858,'午朝门街道办事处','002',1521),(19859,'大兴街道办事处','003',1521),(19860,'北道门街道办事处','005',1521),(19861,'北郊乡','201',1521),(19862,'柳园口乡','202',1521),(19863,'清平街道','001',1522),(19864,'铁塔街道','002',1522),(19865,'曹门街道','003',1522),(19866,'宋门街道','004',1522),(19867,'工业街道','005',1522),(19868,'苹果园街道','006',1522),(19869,'东郊乡','200',1522),(19870,'土柏岗乡','201',1522),(19871,'相国寺街道','001',1523),(19872,'新华街道','002',1523),(19873,'卧龙街道','003',1523),(19874,'州桥街道','004',1523),(19875,'西司门街道','005',1523),(19876,'九村街道','006',1523),(19877,'五一街道','007',1523),(19878,'仙人庄街道','008',1523),(19879,'三里堡街道','001',1524),(19880,'新门关街道','002',1524),(19881,'繁塔街道','003',1524),(19882,'官坊街道','004',1524),(19883,'菜市街道','005',1524),(19884,'南郊乡','200',1524),(19885,'汪屯乡','201',1524),(19886,'城西街道','001',1525),(19887,'梁苑街道','002',1525),(19888,'杏花营镇','100',1525),(19889,'西郊乡','201',1525),(19890,'水稻乡','207',1525),(19891,'杏花营农场','400',1525),(19892,'开发区','560',1525),(19893,'城关镇','100',1526),(19894,'五里河镇','101',1526),(19895,'付集镇','102',1526),(19896,'于镇镇','103',1526),(19897,'高阳镇','104',1526),(19898,'葛岗镇','105',1526),(19899,'阳固镇','106',1526),(19900,'邢口镇','107',1526),(19901,'裴村店乡','200',1526),(19902,'宗店乡','202',1526),(19903,'板木乡','203',1526),(19904,'竹林乡','204',1526),(19905,'官庄乡','205',1526),(19906,'湖岗乡','206',1526),(19907,'苏木乡','207',1526),(19908,'沙沃乡','208',1526),(19909,'平城乡','209',1526),(19910,'泥沟乡','210',1526),(19911,'柿元乡','211',1526),(19912,'西寨乡','212',1526),(19913,'城郊乡','213',1526),(19914,'城关镇','100',1527),(19915,'竖岗镇','101',1527),(19916,'玉皇庙镇','102',1527),(19917,'四所楼镇','103',1527),(19918,'朱砂镇','104',1527),(19919,'长智镇','105',1527),(19920,'冯庄乡','200',1527),(19921,'孙营乡','201',1527),(19922,'大岗李乡','202',1527),(19923,'邸阁乡','203',1527),(19924,'练城乡','204',1527),(19925,'厉庄乡','205',1527),(19926,'城关镇','100',1528),(19927,'洧川镇','101',1528),(19928,'朱曲镇','102',1528),(19929,'蔡庄镇','103',1528),(19930,'永兴镇','104',1528),(19931,'张市镇','105',1528),(19932,'十八里镇','106',1528),(19933,'水坡镇','107',1528),(19934,'邢庄乡','200',1528),(19935,'庄头乡','201',1528),(19936,'大营乡','202',1528),(19937,'大马乡','203',1528),(19938,'岗李乡','204',1528),(19939,'门楼任乡','205',1528),(19940,'大桥乡','206',1528),(19941,'南曹乡','207',1528),(19942,'小陈乡','208',1528),(19943,'城关镇','100',1529),(19944,'陈留镇','101',1529),(19945,'仇楼镇','102',1529),(19946,'八里湾镇','103',1529),(19947,'曲兴镇','104',1529),(19948,'朱仙镇','106',1529),(19949,'半坡店乡','200',1529),(19950,'罗王乡','202',1529),(19951,'刘店乡','203',1529),(19952,'袁坊乡','204',1529),(19953,'杜良乡','205',1529),(19954,'兴隆乡','206',1529),(19955,'西姜寨乡','208',1529),(19956,'万隆乡','210',1529),(19957,'范村乡','211',1529),(19958,'城关镇','100',1530),(19959,'固阳镇','101',1530),(19960,'南彰镇','102',1530),(19961,'张君墓镇','103',1530),(19962,'红庙镇','104',1530),(19963,'城关乡','200',1530),(19964,'三义寨乡','201',1530),(19965,'坝头乡','202',1530),(19966,'爪营乡','203',1530),(19967,'谷营乡','204',1530),(19968,'小宋乡','205',1530),(19969,'孟寨乡','206',1530),(19970,'许河乡','207',1530),(19971,'葡萄架乡','208',1530),(19972,'闫楼乡','209',1530),(19973,'仪封乡','210',1530),(19974,'中原油田','400',1530),(19975,'仪封园艺场','401',1530),(19976,'造纸林场','402',1530),(19977,'柳林林场','403',1530),(19978,'西关农场','404',1530),(19979,'畜牧良种场','405',1530),(19980,'固阳农科所','406',1530),(19981,'西关街道办事处','001',1532),(19982,'西南隅街道办事处','002',1532),(19983,'西北隅街道办事处','003',1532),(19984,'东南隅街道办事处','004',1532),(19985,'东北隅街道办事处','005',1532),(19986,'南关街道办事处','006',1532),(19987,'洛浦街道办事处','007',1532),(19988,'邙山镇','100',1532),(19989,'王城路街道办事处','001',1533),(19990,'金谷园街道办事处','002',1533),(19991,'西工街道办事处','003',1533),(19992,'邙岭路街道办事处','004',1533),(19993,'道北路街道办事处','005',1533),(19994,'唐宫路街道办事处','006',1533),(19995,'汉屯路街道办事处','007',1533),(19996,'凯旋东路街道办事处','008',1533),(19997,'洛北乡','200',1533),(19998,'红山乡','201',1533),(19999,'东关街道办事处','001',1534),(20000,'廛西街道办事处','002',1534),(20001,'五股路街道办事处','003',1534),(20002,'北窑街道办事处','004',1534),(20003,'塔湾街道办事处','005',1534),(20004,'杨文街道办事处','006',1534),(20005,'华林新村街道办事处','007',1534),(20006,'廛河回族乡','200',1534),(20007,'湖北路街道办事处','001',1535),(20008,'天津路街道办事处','002',1535),(20009,'长春路街道办事处','003',1535),(20010,'南昌路街道办事处','004',1535),(20011,'长安路街道办事处','005',1535),(20012,'重庆路街道办事处','006',1535),(20013,'郑州路街道办事处','007',1535),(20014,'武汉路街道办事处','008',1535),(20015,'徐家营街道办事处','009',1535),(20016,'珠江路街道办事处','010',1535),(20017,'周山路街道办事处','011',1535),(20018,'辛店镇','160',1535),(20019,'工农乡','200',1535),(20020,'孙旗屯乡','360',1535),(20021,'创业路街道办事处','560',1535),(20022,'大庆路街道办事处','001',1536),(20023,'吉利乡','200',1536),(20024,'安乐街道办事处','001',1537),(20025,'关林镇','100',1537),(20026,'龙门镇','101',1537),(20027,'安乐镇','102',1537),(20028,'白马寺镇','103',1537),(20029,'李楼乡','200',1537),(20030,'古城乡','201',1537),(20031,'镇北路街道办事处','560',1537),(20032,'城关镇','100',1538),(20033,'会盟镇','101',1538),(20034,'平乐镇','102',1538),(20035,'送庄镇','103',1538),(20036,'白鹤镇','104',1538),(20037,'朝阳镇','105',1538),(20038,'小浪底镇','106',1538),(20039,'麻屯镇','107',1538),(20040,'横水镇','108',1538),(20041,'常代乡','201',1538),(20042,'城关镇','100',1539),(20043,'石寺镇','101',1539),(20044,'五头镇','102',1539),(20045,'磁涧镇','103',1539),(20046,'铁门镇','104',1539),(20047,'石井乡','201',1539),(20048,'仓头乡','203',1539),(20049,'北冶乡','204',1539),(20050,'曹村乡','205',1539),(20051,'正村乡','206',1539),(20052,'南李村乡','207',1539),(20053,'洛新工业园','400',1539),(20054,'城关镇','100',1540),(20055,'赤土店镇','101',1540),(20056,'合峪镇','102',1540),(20057,'潭头镇','103',1540),(20058,'三川镇','104',1540),(20059,'冷水镇','105',1540),(20060,'陶湾镇','106',1540),(20061,'栾川乡','200',1540),(20062,'庙子乡','201',1540),(20063,'秋扒乡','203',1540),(20064,'狮子庙乡','204',1540),(20065,'白土乡','205',1540),(20066,'叫河乡','206',1540),(20067,'石庙乡','207',1540),(20068,'城关镇','100',1541),(20069,'田湖镇','101',1541),(20070,'旧县镇','102',1541),(20071,'车村镇','103',1541),(20072,'闫庄乡','200',1541),(20073,'大坪乡','201',1541),(20074,'库区乡','202',1541),(20075,'何村乡','203',1541),(20076,'德亭乡','204',1541),(20077,'大章乡','205',1541),(20078,'纸房乡','206',1541),(20079,'饭坡乡','207',1541),(20080,'九店乡','208',1541),(20081,'黄庄乡','209',1541),(20082,'木植街乡','210',1541),(20083,'白河乡','211',1541),(20084,'陶村林场','400',1541),(20085,'五马寺林场','401',1541),(20086,'王莽寨林场','402',1541),(20087,'城关镇','100',1542),(20088,'上店镇','101',1542),(20089,'付店镇','102',1542),(20090,'小店镇','103',1542),(20091,'柏树乡','200',1542),(20092,'十八盘乡','202',1542),(20093,'勒村乡','203',1542),(20094,'王坪乡','204',1542),(20095,'三屯乡','205',1542),(20096,'刘店乡','206',1542),(20097,'陶营乡','207',1542),(20098,'内埠乡','208',1542),(20099,'蔡店乡','209',1542),(20100,'大安工业园区','400',1542),(20101,'城关镇','100',1543),(20102,'丰李镇','101',1543),(20103,'柳泉镇','102',1543),(20104,'韩城镇','103',1543),(20105,'白杨镇','104',1543),(20106,'寻村镇','105',1543),(20107,'城关乡','200',1543),(20108,'盐镇乡','203',1543),(20109,'高村乡','204',1543),(20110,'三乡乡','206',1543),(20111,'张坞乡','207',1543),(20112,'穆册乡','208',1543),(20113,'上观乡','209',1543),(20114,'莲庄乡','210',1543),(20115,'赵保乡','211',1543),(20116,'董王庄乡','212',1543),(20117,'樊村乡','213',1543),(20118,'城关镇','100',1544),(20119,'王范回族镇','101',1544),(20120,'上戈镇','102',1544),(20121,'城郊乡','200',1544),(20122,'河底乡','201',1544),(20123,'东宋乡','203',1544),(20124,'小界乡','205',1544),(20125,'马店乡','207',1544),(20126,'长水乡','208',1544),(20127,'罗岭乡','209',1544),(20128,'故县乡','210',1544),(20129,'下峪乡','211',1544),(20130,'兴华乡','212',1544),(20131,'底张乡','213',1544),(20132,'山底乡','214',1544),(20133,'赵村乡','215',1544),(20134,'陈吴乡','216',1544),(20135,'涧口乡','217',1544),(20136,'城关镇','100',1545),(20137,'鸣皋镇','101',1545),(20138,'水寨镇','102',1545),(20139,'彭婆镇','103',1545),(20140,'鸦岭乡','200',1545),(20141,'高山乡','202',1545),(20142,'平等乡','203',1545),(20143,'酒后乡','204',1545),(20144,'葛寨乡','205',1545),(20145,'白元乡','206',1545),(20146,'白沙乡','207',1545),(20147,'半坡乡','208',1545),(20148,'江左乡','209',1545),(20149,'吕店乡','210',1545),(20150,'城关镇','100',1546),(20151,'首阳山镇','101',1546),(20152,'佃庄镇','102',1546),(20153,'翟镇','103',1546),(20154,'岳滩镇','104',1546),(20155,'顾县镇','105',1546),(20156,'缑氏镇','106',1546),(20157,'府店镇','107',1546),(20158,'高龙镇','108',1546),(20159,'寇店镇','109',1546),(20160,'庞村镇','110',1546),(20161,'李村镇','111',1546),(20162,'诸葛镇','112',1546),(20163,'山化乡','200',1546),(20164,'邙岭乡','201',1546),(20165,'大口乡','203',1546),(20166,'曙光街街道办事处','001',1548),(20167,'光明路街道办事处','002',1548),(20168,'中兴路街道办事处','003',1548),(20169,'矿工路街道办事处','004',1548),(20170,'西市场街道办事处','005',1548),(20171,'新新街街道办事处','006',1548),(20172,'青石山街道办事处','007',1548),(20173,'湛河北路街道办事处','008',1548),(20174,'湖滨路街道办事处','009',1548),(20175,'西高皇街道办事处','010',1548),(20176,'焦店镇','100',1548),(20177,'东安路街道办事处','001',1549),(20178,'优越路街道办事处','002',1549),(20179,'五一路街道办事处','003',1549),(20180,'建设路街道办事处','004',1549),(20181,'东环路街道办事处','005',1549),(20182,'东工人镇街道办事处','006',1549),(20183,'光华路街道办事处','007',1549),(20184,'鸿鹰街道办事处','008',1549),(20185,'皇台街道办事处','009',1549),(20186,'北环路街道办事处','010',1549),(20187,'东高皇乡','200',1549),(20188,'石龙区高庄街道办事处','001',1550),(20189,'石龙区龙兴街道办事处','002',1550),(20190,'石龙区人民路街道办事处','003',1550),(20191,'石龙区龙河街道办事处','004',1550),(20192,'马庄街道','001',1551),(20193,'南环路街道','002',1551),(20194,'姚孟街道','003',1551),(20195,'九里山街道','004',1551),(20196,'轻工路街道','005',1551),(20197,'高阳路街道','006',1551),(20198,'北渡镇','100',1551),(20199,'曹镇乡','200',1551),(20200,'铁路街道办事处','001',1552),(20201,'城关镇','100',1552),(20202,'周庄镇','101',1552),(20203,'闹店镇','102',1552),(20204,'石桥镇','103',1552),(20205,'商酒务镇','104',1552),(20206,'大营镇','105',1552),(20207,'张八桥镇','106',1552),(20208,'杨庄镇','107',1552),(20209,'肖旗乡','200',1552),(20210,'赵庄乡','201',1552),(20211,'前营乡','202',1552),(20212,'李庄乡','203',1552),(20213,'昆阳镇','100',1553),(20214,'任店镇','101',1553),(20215,'保安镇','102',1553),(20216,'仙台镇','103',1553),(20217,'遵化店镇','104',1553),(20218,'城关乡','200',1553),(20219,'夏李乡','201',1553),(20220,'常村乡','202',1553),(20221,'马庄回族乡','203',1553),(20222,'田庄乡','204',1553),(20223,'旧县乡','205',1553),(20224,'辛店乡','206',1553),(20225,'龙泉乡','207',1553),(20226,'水寨乡','208',1553),(20227,'廉村乡','209',1553),(20228,'邓李乡','210',1553),(20229,'龚店乡','211',1553),(20230,'洪庄杨乡','212',1553),(20231,'鲁阳镇','100',1554),(20232,'下汤镇','101',1554),(20233,'梁洼镇','102',1554),(20234,'张官营镇','103',1554),(20235,'张良镇','104',1554),(20236,'尧山镇','105',1554),(20237,'赵村乡','200',1554),(20238,'四棵树乡','201',1554),(20239,'团城乡','202',1554),(20240,'熊背乡','203',1554),(20241,'让河乡','204',1554),(20242,'瓦屋乡','205',1554),(20243,'观音寺乡','206',1554),(20244,'昭平台库区乡','207',1554),(20245,'背孜乡','208',1554),(20246,'仓头乡','209',1554),(20247,'董周乡','210',1554),(20248,'张店乡','211',1554),(20249,'辛集乡','212',1554),(20250,'滚子营乡','213',1554),(20251,'马楼乡','214',1554),(20252,'城关镇','100',1555),(20253,'冢头镇','101',1555),(20254,'安良镇','102',1555),(20255,'堂街镇','103',1555),(20256,'薛店镇','104',1555),(20257,'长桥镇','105',1555),(20258,'王集乡','200',1555),(20259,'李口乡','201',1555),(20260,'姚庄回族乡','202',1555),(20261,'白庙乡','203',1555),(20262,'广阔天地乡','204',1555),(20263,'渣元乡','205',1555),(20264,'茨芭乡','206',1555),(20265,'黄道乡','207',1555),(20266,'垭口街道办事处','001',1556),(20267,'寺坡街道办事处','002',1556),(20268,'朱兰街道办事处普查区','003',1556),(20269,'院岭街道办事处','004',1556),(20270,'尚店镇','100',1556),(20271,'八台镇','101',1556),(20272,'尹集镇','102',1556),(20273,'枣林乡','201',1556),(20274,'庙街乡','202',1556),(20275,'铁山乡','203',1556),(20276,'武功乡','204',1556),(20277,'杨庄乡','205',1556),(20278,'煤山街道办事处','001',1557),(20279,'风穴路街道办事处','002',1557),(20280,'钟楼街道办事处','003',1557),(20281,'洗耳河街道办事处','004',1557),(20282,'汝南街道办事处','005',1557),(20283,'寄料镇','101',1557),(20284,'温泉镇','102',1557),(20285,'临汝镇','103',1557),(20286,'小屯镇','104',1557),(20287,'杨楼乡','200',1557),(20288,'蟒川乡','201',1557),(20289,'王寨乡','202',1557),(20290,'陵头乡','203',1557),(20291,'庙下乡','204',1557),(20292,'纸坊乡','205',1557),(20293,'尚庄乡','206',1557),(20294,'骑岭乡','207',1557),(20295,'大峪乡','208',1557),(20296,'夏店乡','209',1557),(20297,'焦村乡','210',1557),(20298,'东大街街道办事处','001',1559),(20299,'头二三街道办事处','002',1559),(20300,'甜水井街道办事处','003',1559),(20301,'东关街道办事处','004',1559),(20302,'南关街道办事处','005',1559),(20303,'西大街街道办事处','006',1559),(20304,'北大街街道办事处','008',1559),(20305,'西关街道办事处','011',1559),(20306,'紫薇大道街道办事处','012',1559),(20307,'光华路街道办事处','013',1559),(20308,'永明路街道办事处','014',1559),(20309,'中华路街道办事处','015',1559),(20310,'宝莲寺镇','101',1559),(20311,'高庄乡','200',1559),(20312,'步行街综合治理办公室','561',1559),(20313,'北大街综合治理办公室','562',1559),(20314,'安阳市开发区峨嵋大街街道办事处','563',1559),(20315,'安阳市开发区银杏大街街道办事处','564',1559),(20316,'安阳市开发区商颂大街街道办事处','565',1559),(20317,'红旗路街道办事处','001',1560),(20318,'解放路街道办事处','003',1560),(20319,'灯塔路街道办事处','004',1560),(20320,'豆腐营街道办事处','005',1560),(20321,'洹北街道办事处','006',1560),(20322,'彰东街道办事处　','008',1560),(20323,'彰北街道办事处','009',1560),(20324,'民航路街道办事处','010',1560),(20325,'曙光路街道办事处','011',1560),(20326,'殷都区梅园庄街道办事处','001',1561),(20327,'殷都区李珍街道办事处','002',1561),(20328,'殷都区电厂路街道办事处','003',1561),(20329,'殷都区纱厂街道办事处','004',1561),(20330,'殷都区铁西路街道办事处','005',1561),(20331,'殷都区水冶街道办事处','006',1561),(20332,'殷都区清风街街道办事处','007',1561),(20333,'殷都区北蒙街道办事处','008',1561),(20334,'殷都区相台街道办事处','009',1561),(20335,'殷都区西郊乡','200',1561),(20336,'田村街道办事处','001',1562),(20337,'彰武街道办事处','002',1562),(20338,'文昌大道街道办事处','003',1562),(20339,'文明大道街道办事处','004',1562),(20340,'太行小区街道办事处','005',1562),(20341,'中州路街道办事处','006',1562),(20342,'龙泉镇','100',1562),(20343,'东风乡','201',1562),(20344,'马投涧乡','202',1562),(20345,'水冶镇','101',1563),(20346,'铜冶镇','102',1563),(20347,'善应镇','103',1563),(20348,'柏庄镇','105',1563),(20349,'白壁镇','106',1563),(20350,'曲沟镇','107',1563),(20351,'吕村镇','108',1563),(20352,'蒋村乡','200',1563),(20353,'伦掌乡','201',1563),(20354,'都里乡','202',1563),(20355,'磊口乡','203',1563),(20356,'许家沟乡','204',1563),(20357,'马家乡','205',1563),(20358,'崔家桥乡','209',1563),(20359,'安丰乡','210',1563),(20360,'洪河屯乡','211',1563),(20361,'韩陵乡','212',1563),(20362,'永和乡','213',1563),(20363,'瓦店乡','214',1563),(20364,'北郭乡','216',1563),(20365,'辛村乡','217',1563),(20366,'城关镇','100',1564),(20367,'菜园镇','101',1564),(20368,'任固镇','102',1564),(20369,'五陵镇','103',1564),(20370,'宜沟镇','104',1564),(20371,'韩庄乡','200',1564),(20372,'白营乡','201',1564),(20373,'古贤乡','202',1564),(20374,'瓦岗乡','203',1564),(20375,'伏道乡','204',1564),(20376,'道口镇','100',1565),(20377,'城关镇','101',1565),(20378,'白道口镇','102',1565),(20379,'留固镇','103',1565),(20380,'上官镇','104',1565),(20381,'牛屯镇','105',1565),(20382,'万古镇','106',1565),(20383,'高平镇','107',1565),(20384,'王庄镇','108',1565),(20385,'枣村乡','200',1565),(20386,'四间房乡','201',1565),(20387,'八里营乡','202',1565),(20388,'赵营乡','203',1565),(20389,'大寨乡','204',1565),(20390,'桑村乡','205',1565),(20391,'老爷庙乡','206',1565),(20392,'老店乡','207',1565),(20393,'慈周寨乡','208',1565),(20394,'瓦岗寨乡','209',1565),(20395,'焦虎乡','210',1565),(20396,'半坡店乡','211',1565),(20397,'小铺乡','212',1565),(20398,'城关镇','100',1566),(20399,'东庄镇','101',1566),(20400,'井店镇','102',1566),(20401,'梁庄镇','103',1566),(20402,'后河镇','104',1566),(20403,'楚旺镇','105',1566),(20404,'张龙乡','200',1566),(20405,'马上乡','201',1566),(20406,'高堤乡','202',1566),(20407,'亳城乡','203',1566),(20408,'二安乡','204',1566),(20409,'六村乡','205',1566),(20410,'中召乡','206',1566),(20411,'宋村乡','207',1566),(20412,'田氏乡','208',1566),(20413,'石盘屯乡','209',1566),(20414,'豆公乡','210',1566),(20415,'开元街道办事处','001',1567),(20416,'振林街道办事处','002',1567),(20417,'龙山街道办事处','003',1567),(20418,'桂园街道办事处','004',1567),(20419,'合涧镇','101',1567),(20420,'临淇镇','102',1567),(20421,'东姚镇','103',1567),(20422,'横水镇','104',1567),(20423,'河顺镇','105',1567),(20424,'任村镇','106',1567),(20425,'姚村镇','107',1567),(20426,'陵阳镇','108',1567),(20427,'原康镇','109',1567),(20428,'五龙镇','110',1567),(20429,'采桑镇','111',1567),(20430,'东岗镇','112',1567),(20431,'桂林镇','113',1567),(20432,'城郊乡','200',1567),(20433,'茶店乡','202',1567),(20434,'石板岩乡','203',1567),(20435,'中北街道','001',1569),(20436,'中山路街道','002',1569),(20437,'新华街街道','003',1569),(20438,'鹤山街街道','004',1569),(20439,'九矿广场街道','005',1569),(20440,'鹤壁集乡','200',1569),(20441,'姬家山乡','201',1569),(20442,'红旗街道','001',1570),(20443,'长风中路街道','002',1570),(20444,'山城路街道','003',1570),(20445,'汤河街街道','004',1570),(20446,'鹿楼街道','005',1570),(20447,'石林乡','200',1570),(20448,'鹿楼乡','201',1570),(20449,'金山街道','001',1571),(20450,'大赉店镇','100',1571),(20451,'上峪乡','200',1571),(20452,'大河涧乡','201',1571),(20453,'九州路街道','560',1571),(20454,'黎阳路街道','561',1571),(20455,'长江路街道','562',1571),(20456,'城关镇','100',1572),(20457,'善堂镇','101',1572),(20458,'屯子镇','102',1572),(20459,'钜桥镇','103',1572),(20460,'新镇镇','104',1572),(20461,'小河镇','105',1572),(20462,'黎阳镇','106',1572),(20463,'卫贤镇','107',1572),(20464,'王庄乡','200',1572),(20465,'白寺乡','201',1572),(20466,'朝歌镇','100',1573),(20467,'高村镇','101',1573),(20468,'北阳镇','102',1573),(20469,'桥盟乡','200',1573),(20470,'庙口乡','201',1573),(20471,'黄洞乡','202',1573),(20472,'西岗乡','203',1573),(20473,'西街办事处','001',1575),(20474,'东街办事处','002',1575),(20475,'渠东办事处','003',1575),(20476,'南干道办事处','007',1575),(20477,'向阳小区办事处','009',1575),(20478,'洪门镇','100',1575),(20479,'红旗区小店镇','101',1575),(20480,'开发区关堤乡','360',1575),(20481,'新乡市小店工业园区','400',1575),(20482,'开发区办事处','560',1575),(20483,'胜利路街道办事处','001',1576),(20484,'解放路街道办事处','002',1576),(20485,'中同街街道办事处','003',1576),(20486,'健康路街道办事处','004',1576),(20487,'自由路街道办事处','007',1576),(20488,'南桥街道办事处','008',1576),(20489,'铁西街道办事处','009',1576),(20490,'平原乡','200',1576),(20491,'宝西街道办事处','001',1577),(20492,'宝东街道办事处','002',1577),(20493,'大块镇','100',1577),(20494,'潞王坟乡','200',1577),(20495,'耿黄乡','201',1577),(20496,'东干道办事处','001',1578),(20497,'荣校路办事处','002',1578),(20498,'北干道办事处','003',1578),(20499,'花园办事处','004',1578),(20500,'卫北办事处','005',1578),(20501,'新辉路办事处','006',1578),(20502,'和平路办事处','007',1578),(20503,'王村镇','100',1578),(20504,'牧野乡','201',1578),(20505,'国家化学与物理电源产业园','400',1578),(20506,'翟坡镇','101',1579),(20507,'小冀镇','102',1579),(20508,'七里营镇','103',1579),(20509,'朗公庙镇','104',1579),(20510,'古固寨镇','105',1579),(20511,'大召营镇','107',1579),(20512,'合河乡','200',1579),(20513,'新乡经济开发区','560',1579),(20514,'城关镇','100',1580),(20515,'照境镇','101',1580),(20516,'黄堤镇','102',1580),(20517,'中和镇','103',1580),(20518,'徐营镇','104',1580),(20519,'冯庄镇','105',1580),(20520,'亢村镇','106',1580),(20521,'史庄镇','107',1580),(20522,'位庄乡','200',1580),(20523,'大新庄乡','203',1580),(20524,'太山乡','204',1580),(20525,'西工区管理委员会','560',1580),(20526,'城关镇','100',1581),(20527,'原武镇','101',1581),(20528,'师寨镇','102',1581),(20529,'葛埠口乡','200',1581),(20530,'福宁集乡','201',1581),(20531,'祝楼乡','203',1581),(20532,'桥北乡','204',1581),(20533,'韩董庄乡','205',1581),(20534,'蒋庄乡','206',1581),(20535,'官厂乡','207',1581),(20536,'大宾乡','209',1581),(20537,'陡门乡','211',1581),(20538,'齐街乡','213',1581),(20539,'太平镇乡','214',1581),(20540,'路寨乡','215',1581),(20541,'阳阿乡','216',1581),(20542,'靳堂乡','218',1581),(20543,'延津县城关镇','100',1582),(20544,'延津县东屯镇','101',1582),(20545,'延津县丰庄镇','102',1582),(20546,'延津县僧固乡','200',1582),(20547,'延津县石婆固乡','201',1582),(20548,'延津县位邱乡','202',1582),(20549,'延津县司寨乡','203',1582),(20550,'延津县王楼乡','204',1582),(20551,'延津县马庄乡','205',1582),(20552,'延津县胙城乡','206',1582),(20553,'延津县榆林乡','207',1582),(20554,'延津县小潭乡','208',1582),(20555,'延津县国营林场','400',1582),(20556,'延津县新兴农场','401',1582),(20557,'新乡市食品工业聚集区','402',1582),(20558,'新乡市纺织工业聚集区','403',1582),(20559,'封丘县城关镇','100',1583),(20560,'封丘县黄陵镇','101',1583),(20561,'封丘县黄德镇','102',1583),(20562,'封丘县应举镇','103',1583),(20563,'封丘县陈桥镇','104',1583),(20564,'封丘县赵岗镇','105',1583),(20565,'封丘县城关乡','200',1583),(20566,'封丘县回族乡','201',1583),(20567,'封丘县王村乡','202',1583),(20568,'封丘县陈固乡','203',1583),(20569,'封丘县居厢乡','204',1583),(20570,'封丘县鲁岗乡','205',1583),(20571,'封丘县荆宫乡','206',1583),(20572,'封丘县留光乡','207',1583),(20573,'封丘县曹岗乡','208',1583),(20574,'封丘县潘店乡','209',1583),(20575,'封丘县李庄乡','210',1583),(20576,'封丘县尹岗乡','211',1583),(20577,'封丘县冯村乡','212',1583),(20578,'蒲西办事处','001',1584),(20579,'蒲东办事处','002',1584),(20580,'南蒲办事处','003',1584),(20581,'蒲北办事处','004',1584),(20582,'丁栾镇','101',1584),(20583,'樊相镇','102',1584),(20584,'魏庄镇','103',1584),(20585,'恼里镇','104',1584),(20586,'常村镇','105',1584),(20587,'赵堤镇','106',1584),(20588,'芦岗乡','202',1584),(20589,'孟岗乡','203',1584),(20590,'苗寨乡','204',1584),(20591,'方里乡','205',1584),(20592,'武邱乡','206',1584),(20593,'佘家乡','208',1584),(20594,'张三寨乡','209',1584),(20595,'满村乡','210',1584),(20596,'汲水镇','100',1585),(20597,'太公泉镇','101',1585),(20598,'孙杏村镇','102',1585),(20599,'后河镇','103',1585),(20600,'李源屯镇','104',1585),(20601,'唐庄镇','105',1585),(20602,'上乐村镇','106',1585),(20603,'狮豹头乡','201',1585),(20604,'安都乡','203',1585),(20605,'顿坊店乡','204',1585),(20606,'柳庄乡','205',1585),(20607,'庞寨乡','206',1585),(20608,'城郊乡','208',1585),(20609,'城关街道办事处','001',1586),(20610,'胡桥街道办事处','002',1586),(20611,'薄壁镇','101',1586),(20612,'峪河镇','102',1586),(20613,'百泉镇','103',1586),(20614,'孟庄镇','104',1586),(20615,'常村镇','105',1586),(20616,'吴村镇','106',1586),(20617,'南村镇','107',1586),(20618,'南寨镇','108',1586),(20619,'上八里镇','109',1586),(20620,'北云门镇','110',1586),(20621,'占城镇','111',1586),(20622,'黄水乡','200',1586),(20623,'拍石头乡','201',1586),(20624,'高庄乡','202',1586),(20625,'张村乡','203',1586),(20626,'冀屯乡','204',1586),(20627,'赵固乡','205',1586),(20628,'西平罗乡','206',1586),(20629,'洪洲乡','207',1586),(20630,'沙窑乡','208',1586),(20631,'民生街道办事处','001',1588),(20632,'民主街道办事处','002',1588),(20633,'新华街道办事处','003',1588),(20634,'焦西街道办事处','004',1588),(20635,'焦南街道办事处','005',1588),(20636,'焦北街道办事处','006',1588),(20637,'七百间街道办事处','007',1588),(20638,'上白作街道办事处','008',1588),(20639,'王褚街道办事处','009',1588),(20640,'李封街道办事处','001',1589),(20641,'王封街道办事处','002',1589),(20642,'朱村街道办事处','003',1589),(20643,'冯封街道办事处','004',1589),(20644,'龙洞街道办事处','005',1589),(20645,'月山街道','006',1589),(20646,'丹河街道办事处','007',1589),(20647,'许衡街道办事处','008',1589),(20648,'府城街道办事处','009',1589),(20649,'龙翔街道办事处','010',1589),(20650,'马村街道办事处','001',1590),(20651,'北山街道办事处','002',1590),(20652,'冯营街道办事处','003',1590),(20653,'九里山街道办事处','004',1590),(20654,'待王街道办事处','005',1590),(20655,'安阳城街道办事处','006',1590),(20656,'演马街道办事处','007',1590),(20657,'东方红街道办事处','001',1591),(20658,'焦东街道办事处','002',1591),(20659,'百间房街道办事处','003',1591),(20660,'太行街道办事处','004',1591),(20661,'艺新街道办事处','005',1591),(20662,'光亚街道办事处','006',1591),(20663,'定和街道办事处','007',1591),(20664,'中星街道办事处','008',1591),(20665,'新城街道办事处','009',1591),(20666,'李万街道办事处','060',1591),(20667,'城关镇','100',1592),(20668,'方庄镇','101',1592),(20669,'郇封镇','102',1592),(20670,'高村乡','202',1592),(20671,'周庄乡','203',1592),(20672,'五里源乡','204',1592),(20673,'岸上乡','205',1592),(20674,'西村乡','206',1592),(20675,'小营工贸区','400',1592),(20676,'博爱县清化镇','100',1593),(20677,'博爱县柏山镇','101',1593),(20678,'博爱县月山镇','102',1593),(20679,'博爱县许良镇','103',1593),(20680,'博爱县阳庙镇','104',1593),(20681,'博爱县磨头镇','105',1593),(20682,'博爱县孝敬镇','106',1593),(20683,'博爱县寨豁乡','200',1593),(20684,'博爱县金城乡','203',1593),(20685,'博爱县苏家作乡','204',1593),(20686,'国营博爱农场','400',1593),(20687,'木城镇','100',1594),(20688,'詹店镇','101',1594),(20689,'西陶镇','102',1594),(20690,'谢旗营镇','103',1594),(20691,'大封镇','104',1594),(20692,'宁郭镇','105',1594),(20693,'龙源镇','106',1594),(20694,'嘉应观乡','200',1594),(20695,'乔庙乡','201',1594),(20696,'圪当店乡','202',1594),(20697,'三阳乡','203',1594),(20698,'小董乡','204',1594),(20699,'大虹桥乡','205',1594),(20700,'北郭乡','206',1594),(20701,'武陟宁郭农场','400',1594),(20702,'温泉镇','100',1595),(20703,'祥云镇','101',1595),(20704,'番田镇','102',1595),(20705,'黄庄镇','104',1595),(20706,'武德镇','105',1595),(20707,'赵堡镇','106',1595),(20708,'南张羌镇','107',1595),(20709,'岳村乡','200',1595),(20710,'招贤乡','201',1595),(20711,'北冷乡','203',1595),(20712,'国营温县农场','400',1595),(20713,'济源市双桥街道办事处','001',1596),(20714,'济源市济水街道办事处','002',1596),(20715,'济源市北海街道办事处','003',1596),(20716,'济源市天坛街道办事处','004',1596),(20717,'济源市克井镇','100',1596),(20718,'济源市五龙口镇','101',1596),(20719,'济源市轵城镇','102',1596),(20720,'济源市承留镇','103',1596),(20721,'济源市邵原镇','104',1596),(20722,'济源市坡头镇','105',1596),(20723,'济源市梨林镇','106',1596),(20724,'济源市大峪镇','107',1596),(20725,'济源市亚桥乡','200',1596),(20726,'济源市思礼乡','201',1596),(20727,'济源市王屋乡','202',1596),(20728,'济源市下冶乡','203',1596),(20729,'覃怀街道','001',1597),(20730,'怀庆街道','002',1597),(20731,'太行街道','003',1597),(20732,'沁园街道','004',1597),(20733,'崇义镇','100',1597),(20734,'西向镇','101',1597),(20735,'西万镇','102',1597),(20736,'柏香镇','103',1597),(20737,'山王庄镇','104',1597),(20738,'紫陵镇','105',1597),(20739,'常平乡','200',1597),(20740,'王召乡','201',1597),(20741,'王曲乡','202',1597),(20742,'大定街道','001',1598),(20743,'会昌街道','002',1598),(20744,'河雍街道','003',1598),(20745,'河阳街道','004',1598),(20746,'化工镇','100',1598),(20747,'南庄镇','101',1598),(20748,'城伯镇','102',1598),(20749,'谷旦镇','103',1598),(20750,'赵和镇','104',1598),(20751,'西虢镇','105',1598),(20752,'槐树乡','201',1598),(20753,'中原路街道办事处','001',1600),(20754,'胜利路街道办事处','002',1600),(20755,'建设路街道办事处','003',1600),(20756,'人民路街道办事处','004',1600),(20757,'大庆路街道办事处','005',1600),(20758,'黄河路街道办事处','006',1600),(20759,'任丘路街道办事处','007',1600),(20760,'昆吾路街道办事处','060',1600),(20761,'皇甫路街道办事处','061',1600),(20762,'白条河农场虚拟办事处','065',1600),(20763,'岳村乡','202',1600),(20764,'孟轲乡','203',1600),(20765,'胡村乡','360',1600),(20766,'王助乡','361',1600),(20767,'新习乡','362',1600),(20768,'中原油田街道办事处','400',1600),(20769,'开发区虚拟街道办事处','560',1600),(20770,'城关镇','100',1601),(20771,'马庄桥镇','101',1601),(20772,'瓦屋头镇','102',1601),(20773,'六塔乡','200',1601),(20774,'仙庄乡','201',1601),(20775,'巩营乡','202',1601),(20776,'马村乡','203',1601),(20777,'高堡乡','204',1601),(20778,'古城乡','205',1601),(20779,'大流乡','206',1601),(20780,'韩村乡','207',1601),(20781,'大屯乡','208',1601),(20782,'固城乡','209',1601),(20783,'柳格乡','211',1601),(20784,'双庙乡','212',1601),(20785,'纸房乡','213',1601),(20786,'阳邵乡','214',1601),(20787,'城关镇','100',1602),(20788,'韩张镇','101',1602),(20789,'元村镇','102',1602),(20790,'杨村乡','200',1602),(20791,'张果屯乡','201',1602),(20792,'千口乡','202',1602),(20793,'福坎乡','203',1602),(20794,'谷金楼乡','204',1602),(20795,'西邵乡','205',1602),(20796,'寺庄乡','206',1602),(20797,'梁村乡','207',1602),(20798,'近德固乡','208',1602),(20799,'城关镇','100',1603),(20800,'濮城镇','101',1603),(20801,'辛庄乡','200',1603),(20802,'杨集乡','201',1603),(20803,'陈庄乡','202',1603),(20804,'白衣阁乡','203',1603),(20805,'王楼乡','204',1603),(20806,'颜村铺乡','205',1603),(20807,'龙王庄乡','207',1603),(20808,'陆集乡','208',1603),(20809,'张庄乡','209',1603),(20810,'高码头乡','210',1603),(20811,'城关镇','100',1604),(20812,'侯庙镇','101',1604),(20813,'后方乡','200',1604),(20814,'清水河乡','201',1604),(20815,'马楼乡','202',1604),(20816,'孙口乡','203',1604),(20817,'打渔陈乡','204',1604),(20818,'夹河乡','205',1604),(20819,'吴坝乡','206',1604),(20820,'城关镇','100',1605),(20821,'濮阳县柳屯镇','101',1605),(20822,'濮阳县文留镇','102',1605),(20823,'濮阳县庆祖镇','103',1605),(20824,'濮阳县八公桥镇','104',1605),(20825,'濮阳县徐镇镇','106',1605),(20826,'濮阳县户部寨乡','201',1605),(20827,'濮阳县清河头乡','202',1605),(20828,'濮阳县鲁河乡','203',1605),(20829,'濮阳县梁庄乡','204',1605),(20830,'濮阳县王称固乡','205',1605),(20831,'濮阳县白罡乡','206',1605),(20832,'濮阳县梨园乡','207',1605),(20833,'濮阳县五星乡','208',1605),(20834,'濮阳县子岸乡','209',1605),(20835,'濮阳县胡状乡','210',1605),(20836,'濮阳县郎中乡','211',1605),(20837,'濮阳县海通乡','212',1605),(20838,'濮阳县渠村乡','213',1605),(20839,'濮阳县习城乡','214',1605),(20840,'濮阳县县直虚拟办事处','400',1605),(20841,'中原油田矿区虚拟办事处','401',1605),(20842,'西大街道办事处','001',1607),(20843,'东大街道办事处','002',1607),(20844,'西关街道办事处','003',1607),(20845,'南关街道办事处','004',1607),(20846,'北大街道办事处','005',1607),(20847,'五一路街道办事处','006',1607),(20848,'高桥营街道办事处','007',1607),(20849,'丁庄街道办事处','008',1607),(20850,'七里店街道办事处','009',1607),(20851,'文峰街道办事处','010',1607),(20852,'新兴街道办事处','011',1607),(20853,'半截河街道办事处','012',1607),(20854,'许昌经济开发区','560',1607),(20855,'将官池镇','100',1608),(20856,'五女店镇','101',1608),(20857,'尚集镇','102',1608),(20858,'苏桥镇','103',1608),(20859,'蒋李集镇','104',1608),(20860,'张潘镇','105',1608),(20861,'灵井镇','106',1608),(20862,'陈曹乡','200',1608),(20863,'邓庄乡','201',1608),(20864,'小召乡','202',1608),(20865,'河街乡','203',1608),(20866,'桂村乡','204',1608),(20867,'椹涧乡','205',1608),(20868,'榆林乡','206',1608),(20869,'长村张乡','207',1608),(20870,'艾庄回族乡','208',1608),(20871,'安陵镇','100',1609),(20872,'马栏镇','101',1609),(20873,'柏梁镇','102',1609),(20874,'陈化店镇','103',1609),(20875,'望田镇','104',1609),(20876,'张桥乡','200',1609),(20877,'南坞乡','201',1609),(20878,'陶城乡','202',1609),(20879,'只乐乡','203',1609),(20880,'大马乡','204',1609),(20881,'彭店乡','205',1609),(20882,'马坊乡','206',1609),(20883,'城关镇','100',1610),(20884,'颍桥回族镇','101',1610),(20885,'麦岭镇','102',1610),(20886,'颍阳镇','103',1610),(20887,'王洛镇','104',1610),(20888,'紫云镇','105',1610),(20889,'湛北乡','200',1610),(20890,'山头店乡','201',1610),(20891,'茨沟乡','202',1610),(20892,'丁营乡','203',1610),(20893,'姜庄乡','204',1610),(20894,'范湖乡','205',1610),(20895,'双庙乡','206',1610),(20896,'汾陈乡','207',1610),(20897,'十里铺乡','208',1610),(20898,'库庄乡','209',1610),(20899,'颍川街道办事处','001',1611),(20900,'夏都街道办事处','002',1611),(20901,'韩城街道办事处','003',1611),(20902,'钧台街道办事处','004',1611),(20903,'火龙镇','100',1611),(20904,'顺店镇','101',1611),(20905,'方山镇','102',1611),(20906,'神','103',1611),(20907,'鸿畅镇','104',1611),(20908,'梁北镇','105',1611),(20909,'古城镇','106',1611),(20910,'无梁镇','107',1611),(20911,'文殊镇','108',1611),(20912,'朱阁乡','200',1611),(20913,'苌庄乡','201',1611),(20914,'花石乡','202',1611),(20915,'鸠山乡','203',1611),(20916,'磨街乡','204',1611),(20917,'张得乡','205',1611),(20918,'小吕乡','206',1611),(20919,'范坡乡','207',1611),(20920,'褚河乡','208',1611),(20921,'郭连乡','209',1611),(20922,'山货回族乡','210',1611),(20923,'浅井乡','211',1611),(20924,'方岗乡','212',1611),(20925,'建设路街道办事处','001',1612),(20926,'长兴路街道办事处','002',1612),(20927,'长社路街道办事处','003',1612),(20928,'金桥路街道办事处','004',1612),(20929,'和尚桥镇','100',1612),(20930,'坡胡镇','101',1612),(20931,'后河镇','102',1612),(20932,'石固镇','103',1612),(20933,'老城镇','104',1612),(20934,'南席镇','105',1612),(20935,'大周镇','106',1612),(20936,'董村镇','107',1612),(20937,'增福庙乡','200',1612),(20938,'官亭乡','201',1612),(20939,'石象乡','202',1612),(20940,'古桥乡','203',1612),(20941,'老街街道','001',1614),(20942,'马路街街道','002',1614),(20943,'顺河街街道','003',1614),(20944,'干河陈街道','004',1614),(20945,'大刘镇','100',1614),(20946,'阴阳赵乡','201',1614),(20947,'问十乡','202',1614),(20948,'空冢郭乡','203',1614),(20949,'沙北街道办事处','001',1615),(20950,'城关镇','100',1615),(20951,'孟庙镇','101',1615),(20952,'商桥镇','102',1615),(20953,'裴城镇','103',1615),(20954,'新店镇','104',1615),(20955,'龙城镇','105',1615),(20956,'黑龙潭乡','201',1615),(20957,'李集乡','202',1615),(20958,'天桥街街道','001',1616),(20959,'翟庄办事处','002',1616),(20960,'召陵镇','100',1616),(20961,'邓襄镇','101',1616),(20962,'万金镇','102',1616),(20963,'老窝镇','103',1616),(20964,'后谢乡','201',1616),(20965,'姬石乡','202',1616),(20966,'青年村乡','203',1616),(20967,'舞泉镇','100',1617),(20968,'吴城镇','101',1617),(20969,'北舞渡镇','102',1617),(20970,'莲花镇','103',1617),(20971,'辛安镇','104',1617),(20972,'孟寨镇','105',1617),(20973,'太尉镇','106',1617),(20974,'文峰乡','200',1617),(20975,'保和乡','201',1617),(20976,'马村乡','202',1617),(20977,'侯集乡','203',1617),(20978,'姜店乡','204',1617),(20979,'九街乡','205',1617),(20980,'章化乡','206',1617),(20981,'城关镇','100',1618),(20982,'繁城镇','101',1618),(20983,'杜曲镇','102',1618),(20984,'王岗镇','103',1618),(20985,'台陈镇','104',1618),(20986,'巨陵镇','105',1618),(20987,'瓦店镇','106',1618),(20988,'三家店镇','107',1618),(20989,'窝城镇','108',1618),(20990,'大郭乡','200',1618),(20991,'皇帝庙乡','201',1618),(20992,'固厢乡','202',1618),(20993,'石桥乡','203',1618),(20994,'陈庄乡','204',1618),(20995,'王孟乡','205',1618),(20996,'湖滨街道','001',1620),(20997,'前进街道','002',1620),(20998,'车站街道','003',1620),(20999,'涧河街道','004',1620),(21000,'大安街道','005',1620),(21001,'会兴街道','006',1620),(21002,'崖底街道','007',1620),(21003,'交口乡','201',1620),(21004,'磁钟乡','202',1620),(21005,'高庙乡','203',1620),(21006,'向阳街道','560',1620),(21007,'城关镇','100',1621),(21008,'英豪镇','101',1621),(21009,'张村镇','102',1621),(21010,'洪阳镇','103',1621),(21011,'天池镇','104',1621),(21012,'仰韶乡','201',1621),(21013,'仁村乡','203',1621),(21014,'果园乡','206',1621),(21015,'陈村乡','207',1621),(21016,'坡头乡','208',1621),(21017,'段村乡','209',1621),(21018,'南村乡','210',1621),(21019,'大营镇','100',1622),(21020,'原店镇','101',1622),(21021,'西张村镇','102',1622),(21022,'观音堂镇','103',1622),(21023,'张汴乡','200',1622),(21024,'张湾乡','201',1622),(21025,'菜园乡','203',1622),(21026,'张茅乡','205',1622),(21027,'王家后乡','206',1622),(21028,'硖石乡','207',1622),(21029,'西李村乡','210',1622),(21030,'宫前乡','211',1622),(21031,'店子乡','212',1622),(21032,'城关镇','100',1623),(21033,'杜关镇','101',1623),(21034,'五里川镇','102',1623),(21035,'官道口镇','103',1623),(21036,'朱阳关镇','104',1623),(21037,'官坡镇','105',1623),(21038,'范里镇','106',1623),(21039,'东明镇','107',1623),(21040,'文峪乡','200',1623),(21041,'横涧乡','201',1623),(21042,'磨沟口乡','202',1623),(21043,'双槐树乡','203',1623),(21044,'汤河乡','204',1623),(21045,'瓦窑沟乡','205',1623),(21046,'狮子坪乡','206',1623),(21047,'沙河乡','207',1623),(21048,'徐家湾乡','208',1623),(21049,'潘河乡','209',1623),(21050,'木桐乡','210',1623),(21051,'千秋路街道','001',1624),(21052,'朝阳路街道','002',1624),(21053,'新义街街道','003',1624),(21054,'常村路街道','004',1624),(21055,'泰山路街道','005',1624),(21056,'新区街道','006',1624),(21057,'东区街道','007',1624),(21058,'城关镇','100',1625),(21059,'尹庄镇','101',1625),(21060,'朱阳镇','102',1625),(21061,'阳平镇','103',1625),(21062,'故县镇','104',1625),(21063,'豫灵镇','105',1625),(21064,'大王镇','106',1625),(21065,'阳店镇','107',1625),(21066,'函谷关镇','108',1625),(21067,'焦村镇','109',1625),(21068,'川口乡','200',1625),(21069,'寺河乡','201',1625),(21070,'苏村乡','202',1625),(21071,'五亩乡','203',1625),(21072,'西阎乡','204',1625),(21073,'灵宝市园艺场','400',1625),(21074,'东关街道办事处','001',1627),(21075,'新华街道办事处','002',1627),(21076,'汉冶街道办事处','003',1627),(21077,'仲景街道办事处','004',1627),(21078,'白河街道办事处','005',1627),(21079,'枣林街道办事处','006',1627),(21080,'官庄镇','102',1627),(21081,'瓦店镇','103',1627),(21082,'红泥湾镇','104',1627),(21083,'黄台岗镇','105',1627),(21084,'溧河乡','301',1627),(21085,'汉冢乡','302',1627),(21086,'金华乡','303',1627),(21087,'茶庵乡','304',1627),(21088,'高庙乡','305',1627),(21089,'新店乡','306',1627),(21090,'南阳油田','400',1627),(21091,'七一街道办事处','002',1628),(21092,'卧龙岗街道办事处','003',1628),(21093,'武侯街道办事处','004',1628),(21094,'梅溪街道办事处','005',1628),(21095,'车站街道办事处','006',1628),(21096,'光武街道办事处','007',1628),(21097,'靳岗街道办事处','008',1628),(21098,'张衡街道办事处','060',1628),(21099,'百里奚街道办事处','061',1628),(21100,'石桥镇','101',1628),(21101,'潦河镇','102',1628),(21102,'安皋镇','103',1628),(21103,'蒲山镇','104',1628),(21104,'陆营镇','105',1628),(21105,'青华镇','106',1628),(21106,'英庄镇','107',1628),(21107,'七里园乡','300',1628),(21108,'谢庄乡','305',1628),(21109,'王村乡','306',1628),(21110,'龙兴乡','307',1628),(21111,'城关镇','100',1629),(21112,'留山镇','101',1629),(21113,'云阳镇','102',1629),(21114,'皇路店镇','103',1629),(21115,'南河店镇','104',1629),(21116,'板山坪镇','105',1629),(21117,'乔端镇','106',1629),(21118,'白土岗镇','107',1629),(21119,'城郊乡','300',1629),(21120,'小店乡','301',1629),(21121,'皇后乡','302',1629),(21122,'太山庙乡','303',1629),(21123,'石门乡','304',1629),(21124,'四棵树乡','305',1629),(21125,'马市坪乡','308',1629),(21126,'崔庄乡','310',1629),(21127,'河南红阳机械厂','400',1629),(21128,'河南向东机械厂','401',1629),(21129,'河南红宇机械厂','402',1629),(21130,'国营东风机械厂','403',1629),(21131,'国营长江机械厂','404',1629),(21132,'城关镇','100',1630),(21133,'独树镇','101',1630),(21134,'博望镇','102',1630),(21135,'拐河镇','103',1630),(21136,'小史店镇','104',1630),(21137,'赵河镇','105',1630),(21138,'广阳镇','106',1630),(21139,'券桥乡','300',1630),(21140,'杨集乡','301',1630),(21141,'二郎庙乡','302',1630),(21142,'古庄店乡','303',1630),(21143,'杨楼乡','304',1630),(21144,'清河乡','306',1630),(21145,'柳河乡','309',1630),(21146,'四里店乡','310',1630),(21147,'袁店回族乡','311',1630),(21148,'河南中南机械厂','400',1630),(21149,'方城县大寺林场','401',1630),(21150,'白羽街道办事处','001',1631),(21151,'紫金街道办事处','002',1631),(21152,'莲花街道办事处','003',1631),(21153,'丹水镇','101',1631),(21154,'西坪镇','102',1631),(21155,'双龙镇','103',1631),(21156,'回车镇','104',1631),(21157,'丁河镇','105',1631),(21158,'桑坪镇','106',1631),(21159,'米坪镇','107',1631),(21160,'田关乡','300',1631),(21161,'阳城乡','301',1631),(21162,'五里桥乡','303',1631),(21163,'重阳乡','306',1631),(21164,'寨根乡','307',1631),(21165,'石界河乡','309',1631),(21166,'军马河乡','311',1631),(21167,'二郎坪乡','313',1631),(21168,'太平镇乡','314',1631),(21169,'南阳市黄石庵林场','400',1631),(21170,'涅阳办事处','001',1632),(21171,'雪枫办事处','002',1632),(21172,'玉都办事处','003',1632),(21173,'石佛寺镇','101',1632),(21174,'晁陂镇','102',1632),(21175,'贾宋镇','103',1632),(21176,'侯集镇','104',1632),(21177,'老庄镇','105',1632),(21178,'卢医镇','106',1632),(21179,'遮山镇','107',1632),(21180,'高丘镇','108',1632),(21181,'曲屯镇','109',1632),(21182,'枣园镇','110',1632),(21183,'杨营镇','111',1632),(21184,'柳泉铺乡','301',1632),(21185,'二龙乡','303',1632),(21186,'王岗乡','306',1632),(21187,'马庄乡','309',1632),(21188,'张林乡','310',1632),(21189,'安字营乡','313',1632),(21190,'彭营乡','314',1632),(21191,'郭庄回族乡','315',1632),(21192,'城关镇','100',1633),(21193,'夏馆镇','101',1633),(21194,'师岗镇','102',1633),(21195,'马山口镇','103',1633),(21196,'湍东镇','104',1633),(21197,'赤眉镇','105',1633),(21198,'瓦亭镇','106',1633),(21199,'王店镇','107',1633),(21200,'灌涨镇','108',1633),(21201,'板场乡','300',1633),(21202,'大桥乡','301',1633),(21203,'赵店乡','302',1633),(21204,'七里坪乡','306',1633),(21205,'余关乡','307',1633),(21206,'砟岖乡','308',1633),(21207,'西庙岗乡','309',1633),(21208,'龙城街道办事处','001',1634),(21209,'商圣街道办事处','002',1634),(21210,'荆紫关镇','101',1634),(21211,'老城镇','102',1634),(21212,'香花镇','103',1634),(21213,'厚坡镇','104',1634),(21214,'九重镇','105',1634),(21215,'盛湾镇','106',1634),(21216,'金河镇','107',1634),(21217,'寺湾镇','108',1634),(21218,'仓房镇','109',1634),(21219,'上集镇','110',1634),(21220,'马蹬镇','111',1634),(21221,'西簧乡','301',1634),(21222,'毛堂乡','302',1634),(21223,'大石桥乡','303',1634),(21224,'滔河乡','304',1634),(21225,'社旗镇','100',1635),(21226,'桥头镇','101',1635),(21227,'饶良镇','103',1635),(21228,'兴隆镇','104',1635),(21229,'晋庄镇','105',1635),(21230,'李店镇','106',1635),(21231,'苗店镇','107',1635),(21232,'郝寨镇','108',1635),(21233,'城郊乡','300',1635),(21234,'大冯营乡','301',1635),(21235,'太和乡','304',1635),(21236,'朱集乡','308',1635),(21237,'下洼乡','311',1635),(21238,'陌陂乡','312',1635),(21239,'唐庄乡','313',1635),(21240,'城关镇','100',1636),(21241,'源潭镇','101',1636),(21242,'张店镇','102',1636),(21243,'郭滩镇','103',1636),(21244,'湖阳镇','104',1636),(21245,'黑龙镇','105',1636),(21246,'大河屯镇','106',1636),(21247,'龙潭镇','107',1636),(21248,'桐寨铺镇','108',1636),(21249,'苍台镇','109',1636),(21250,'上屯镇','110',1636),(21251,'毕店镇','111',1636),(21252,'少拜寺镇','112',1636),(21253,'城郊乡','300',1636),(21254,'桐河乡','301',1636),(21255,'昝岗乡','306',1636),(21256,'祁仪乡','307',1636),(21257,'马振抚乡','308',1636),(21258,'古城乡','309',1636),(21259,'东王集乡','311',1636),(21260,'城关镇','100',1637),(21261,'王庄镇','101',1637),(21262,'沙堰镇','102',1637),(21263,'新甸铺镇','103',1637),(21264,'施庵镇','104',1637),(21265,'歪子镇','105',1637),(21266,'五星镇','106',1637),(21267,'溧河铺镇','107',1637),(21268,'王集镇','108',1637),(21269,'城郊乡','300',1637),(21270,'前高庙乡','303',1637),(21271,'樊集乡','305',1637),(21272,'上庄乡','307',1637),(21273,'上港乡','309',1637),(21274,'城关镇','100',1638),(21275,'月河镇','101',1638),(21276,'吴城镇','102',1638),(21277,'固县镇','103',1638),(21278,'毛集镇','104',1638),(21279,'大河镇','105',1638),(21280,'埠江镇','106',1638),(21281,'平氏镇','107',1638),(21282,'淮源镇','108',1638),(21283,'城郊乡','300',1638),(21284,'回龙乡','301',1638),(21285,'黄岗乡','302',1638),(21286,'朱庄乡','303',1638),(21287,'安棚乡','304',1638),(21288,'程湾乡','305',1638),(21289,'新集乡','306',1638),(21290,'古城街道办事处','001',1639),(21291,'花洲街道办事处','002',1639),(21292,'湍河街道办事处','003',1639),(21293,'罗庄镇','102',1639),(21294,'汲滩镇','103',1639),(21295,'穰东镇','104',1639),(21296,'孟楼镇','105',1639),(21297,'林扒镇','106',1639),(21298,'构林镇','107',1639),(21299,'十林镇','108',1639),(21300,'张村镇','109',1639),(21301,'都司镇','110',1639),(21302,'赵集镇','111',1639),(21303,'刘集镇','112',1639),(21304,'桑庄镇','113',1639),(21305,'彭桥镇','114',1639),(21306,'张楼乡','301',1639),(21307,'白牛乡','302',1639),(21308,'夏集乡','304',1639),(21309,'裴营乡','305',1639),(21310,'文渠乡','310',1639),(21311,'高集乡','311',1639),(21312,'陶营乡','313',1639),(21313,'小杨营乡','316',1639),(21314,'腰店乡','318',1639),(21315,'龙堰乡','319',1639),(21316,'九龙乡','320',1639),(21317,'南阳市黄牛良种繁育场','400',1639),(21318,'杏山旅游管理区杏山街道办事','560',1639),(21319,'前进街道','001',1641),(21320,'长征街道','002',1641),(21321,'八八街道','003',1641),(21322,'东风街道','004',1641),(21323,'中州街道','005',1641),(21324,'白云街道','006',1641),(21325,'平原街道','007',1641),(21326,'建设街道','008',1641),(21327,'谢集镇','100',1641),(21328,'双八镇','101',1641),(21329,'张阁镇','102',1641),(21330,'平台镇','160',1641),(21331,'周集乡','200',1641),(21332,'水池铺乡','201',1641),(21333,'观堂乡','202',1641),(21334,'王楼乡','203',1641),(21335,'李庄乡','204',1641),(21336,'孙福集乡','205',1641),(21337,'刘口乡','206',1641),(21338,'古城街道办事处','001',1642),(21339,'文化街道办事处','002',1642),(21340,'东方街道办事处','003',1642),(21341,'新城街道办事处','004',1642),(21342,'宋集镇','100',1642),(21343,'郭村镇','101',1642),(21344,'李口镇','102',1642),(21345,'高辛镇','103',1642),(21346,'古宋乡','200',1642),(21347,'闫集乡','201',1642),(21348,'冯桥乡','202',1642),(21349,'坞墙乡','203',1642),(21350,'包公庙乡','204',1642),(21351,'娄店乡','205',1642),(21352,'毛固堆乡','206',1642),(21353,'路河乡','207',1642),(21354,'勒马乡','208',1642),(21355,'临河店乡','209',1642),(21356,'民权县城关镇','100',1643),(21357,'民权县人和镇','101',1643),(21358,'民权县龙塘镇','102',1643),(21359,'民权县北关镇','103',1643),(21360,'民权县程庄镇','104',1643),(21361,'民权县王庄寨镇','105',1643),(21362,'民权县伯党乡','200',1643),(21363,'民权县花元乡','201',1643),(21364,'民权县尹店乡','202',1643),(21365,'民权县孙六乡','203',1643),(21366,'野岗乡','204',1643),(21367,'民权县双塔乡','205',1643),(21368,'民权县林七乡','206',1643),(21369,'民权县胡集乡','207',1643),(21370,'民权县褚庙乡','208',1643),(21371,'民权县老颜集乡','210',1643),(21372,'民权县顺河乡','211',1643),(21373,'民权县王桥乡','212',1643),(21374,'商丘市农场','400',1643),(21375,'商丘市林场','401',1643),(21376,'长岗镇','100',1644),(21377,'平岗镇','101',1644),(21378,'周堂镇','102',1644),(21379,'蓼堤镇','103',1644),(21380,'西陵寺镇','104',1644),(21381,'城关镇','105',1644),(21382,'潮庄镇','106',1644),(21383,'尚屯镇','107',1644),(21384,'后台乡','200',1644),(21385,'河集乡','202',1644),(21386,'孙聚寨乡','203',1644),(21387,'白楼乡','204',1644),(21388,'河堤乡','205',1644),(21389,'白庙乡','206',1644),(21390,'胡堂乡','207',1644),(21391,'尤吉屯乡','208',1644),(21392,'董店乡','210',1644),(21393,'涧岗乡','211',1644),(21394,'匡城乡','213',1644),(21395,'城郊乡','214',1644),(21396,'宁陵县城关镇','100',1645),(21397,'宁陵县张弓镇','101',1645),(21398,'宁陵县柳河镇','102',1645),(21399,'宁陵县逻岗镇','103',1645),(21400,'宁陵县黄岗乡','200',1645),(21401,'宁陵县华堡乡','201',1645),(21402,'宁陵县刘楼乡','203',1645),(21403,'宁陵县程楼乡','204',1645),(21404,'宁陵县乔楼乡','205',1645),(21405,'宁陵县城郊乡','206',1645),(21406,'宁陵县阳驿乡','207',1645),(21407,'宁陵县石桥乡','208',1645),(21408,'宁陵县孔集乡','209',1645),(21409,'宁陵县赵村乡','210',1645),(21410,'城关镇','100',1646),(21411,'陈青集镇','101',1646),(21412,'起台镇','102',1646),(21413,'胡襄镇','103',1646),(21414,'慈圣镇','104',1646),(21415,'安平镇','105',1646),(21416,'远襄镇','106',1646),(21417,'邵元乡','200',1646),(21418,'张桥乡','201',1646),(21419,'梁庄乡','202',1646),(21420,'洪恩乡','203',1646),(21421,'老王集乡','204',1646),(21422,'大仵乡','205',1646),(21423,'马集乡','206',1646),(21424,'牛城乡','207',1646),(21425,'惠济乡','208',1646),(21426,'伯岗乡','210',1646),(21427,'岗王乡','211',1646),(21428,'申桥乡','212',1646),(21429,'李原乡','213',1646),(21430,'皇集乡','214',1646),(21431,'城关镇','100',1647),(21432,'界沟镇','101',1647),(21433,'营廓镇','102',1647),(21434,'杜集镇','103',1647),(21435,'谷熟镇','104',1647),(21436,'大杨集镇','105',1647),(21437,'贾寨镇','106',1647),(21438,'利民镇','107',1647),(21439,'张集镇','108',1647),(21440,'黄冢乡','200',1647),(21441,'沙集乡','201',1647),(21442,'店集乡','202',1647),(21443,'站集乡','203',1647),(21444,'闻集乡','204',1647),(21445,'芒种桥乡','205',1647),(21446,'刘店乡','207',1647),(21447,'大候乡','208',1647),(21448,'城郊乡','210',1647),(21449,'郑集乡','211',1647),(21450,'李老家乡','212',1647),(21451,'稍岗乡','213',1647),(21452,'镇里','214',1647),(21453,'古王集乡','215',1647),(21454,'刘集乡','219',1647),(21455,'乔集乡','220',1647),(21456,'田庙乡','221',1647),(21457,'城关镇','100',1648),(21458,'会亭镇','101',1648),(21459,'马头镇','102',1648),(21460,'济阳镇','103',1648),(21461,'李集镇','104',1648),(21462,'车站镇','105',1648),(21463,'杨集镇','106',1648),(21464,'韩道口镇','107',1648),(21465,'曹集乡','200',1648),(21466,'胡桥乡','201',1648),(21467,'歧河乡','202',1648),(21468,'郭店乡','203',1648),(21469,'业庙乡','204',1648),(21470,'中峰乡','205',1648),(21471,'罗庄乡','206',1648),(21472,'桑固乡','207',1648),(21473,'何营乡','208',1648),(21474,'王集乡','210',1648),(21475,'刘店集乡','211',1648),(21476,'骆集乡','212',1648),(21477,'太平乡','213',1648),(21478,'孔庄乡','214',1648),(21479,'火店乡','215',1648),(21480,'北镇乡','216',1648),(21481,'演集镇','100',1649),(21482,'城关镇','101',1649),(21483,'芒山镇','102',1649),(21484,'高庄镇','103',1649),(21485,'搓城镇','104',1649),(21486,'裴桥镇','105',1649),(21487,'马桥镇','106',1649),(21488,'薛湖镇','107',1649),(21489,'蒋口镇','108',1649),(21490,'陈集镇','109',1649),(21491,'十八里镇','110',1649),(21492,'城厢乡','200',1649),(21493,'候岭乡','201',1649),(21494,'黄口乡','202',1649),(21495,'新桥乡','203',1649),(21496,'双桥乡','204',1649),(21497,'王集乡','205',1649),(21498,'李寨乡','206',1649),(21499,'卧龙乡','207',1649),(21500,'龙岗乡','208',1649),(21501,'马牧乡','209',1649),(21502,'搓阳乡','210',1649),(21503,'太邱乡','213',1649),(21504,'顺和乡','214',1649),(21505,'条河乡','217',1649),(21506,'刘河乡','218',1649),(21507,'陈官庄乡','219',1649),(21508,'苗桥乡','220',1649),(21509,'茴村乡','221',1649),(21510,'老城街道办事处','001',1650),(21511,'民权街道办事处','002',1650),(21512,'车站街道办事处','003',1650),(21513,'五里墩街道办事处','004',1650),(21514,'五星街道办事处','005',1650),(21515,'湖东街道办事处','006',1650),(21516,'南湾街道办事处','007',1650),(21517,'金牛山街道办事处','008',1650),(21518,'双井街道办事处','009',1650),(21519,'李家寨镇','100',1650),(21520,'吴家店镇','101',1650),(21521,'东双河镇','102',1650),(21522,'游河乡','203',1650),(21523,'董家河乡','204',1650),(21524,'师河港乡','205',1650),(21525,'谭家河乡','206',1650),(21526,'柳林乡','207',1650),(21527,'十三里桥乡','208',1650),(21528,'羊山街道办事处','001',1651),(21529,'前进街道办事处','002',1651),(21530,'南京路街道办事处','003',1651),(21531,'平桥街道办事处','004',1651),(21532,'甘岸街道办事处','005',1651),(21533,'明港镇','101',1651),(21534,'五里店镇','102',1651),(21535,'邢集镇','103',1651),(21536,'平昌镇','105',1651),(21537,'肖王乡','201',1651),(21538,'龙井乡','202',1651),(21539,'胡店乡','203',1651),(21540,'洋河乡','204',1651),(21541,'彭家湾乡','205',1651),(21542,'长台乡','206',1651),(21543,'肖店乡','207',1651),(21544,'王岗乡','209',1651),(21545,'高粱店乡','210',1651),(21546,'查山乡','211',1651),(21547,'上天梯管理区','400',1651),(21548,'城关镇','100',1652),(21549,'周党镇','101',1652),(21550,'竹竿镇','102',1652),(21551,'灵山镇','103',1652),(21552,'子路镇','104',1652),(21553,'楠杆镇','105',1652),(21554,'青山镇','106',1652),(21555,'潘新镇','107',1652),(21556,'彭新镇','108',1652),(21557,'龙山乡','200',1652),(21558,'东卜乡','201',1652),(21559,'庙仙乡','202',1652),(21560,'莽张乡','203',1652),(21561,'定远乡','204',1652),(21562,'山店乡','205',1652),(21563,'铁铺乡','206',1652),(21564,'朱堂乡','207',1652),(21565,'尤店乡','208',1652),(21566,'高店乡','209',1652),(21567,'河南省五一农场','400',1652),(21568,'弦山街道办事处','001',1653),(21569,'紫水街道办事处','002',1653),(21570,'十里镇','101',1653),(21571,'寨河镇','102',1653),(21572,'孙铁铺镇','103',1653),(21573,'马畈镇','104',1653),(21574,'泼陂河镇','105',1653),(21575,'白雀园镇','106',1653),(21576,'砖桥镇','107',1653),(21577,'仙居乡','201',1653),(21578,'北向店乡','203',1653),(21579,'罗陈乡','204',1653),(21580,'殷棚乡','206',1653),(21581,'南向店乡','207',1653),(21582,'晏河乡','208',1653),(21583,'凉亭乡','210',1653),(21584,'斛山乡','212',1653),(21585,'槐店乡','213',1653),(21586,'文殊乡','215',1653),(21587,'新集镇','100',1654),(21588,'沙窝镇','101',1654),(21589,'吴陈河镇','103',1654),(21590,'苏河镇','104',1654),(21591,'八里畈镇','105',1654),(21592,'周河乡','201',1654),(21593,'陡山河乡','202',1654),(21594,'浒湾乡','203',1654),(21595,'千斤乡','204',1654),(21596,'卡房乡','205',1654),(21597,'郭家河乡','206',1654),(21598,'陈店乡','207',1654),(21599,'箭厂河乡','208',1654),(21600,'泗店乡','209',1654),(21601,'田铺乡','210',1654),(21602,'城关镇','100',1655),(21603,'上石桥镇','101',1655),(21604,'鄢岗镇','102',1655),(21605,'双椿铺镇','103',1655),(21606,'汪桥镇','104',1655),(21607,'余集镇','105',1655),(21608,'河风桥乡','203',1655),(21609,'李集乡','204',1655),(21610,'丰集乡','205',1655),(21611,'四顾墩乡','206',1655),(21612,'苏仙石乡','207',1655),(21613,'汪岗乡','208',1655),(21614,'伏山乡','209',1655),(21615,'鲇鱼山乡','210',1655),(21616,'观庙乡','211',1655),(21617,'吴河乡','212',1655),(21618,'冯店乡','213',1655),(21619,'达权店乡','214',1655),(21620,'长竹园乡','215',1655),(21621,'汤泉池管理处','400',1655),(21622,'城关镇','100',1656),(21623,'陈淋子镇','101',1656),(21624,'黎集镇','102',1656),(21625,'蒋集镇','103',1656),(21626,'往流镇','104',1656),(21627,'郭陆滩镇','105',1656),(21628,'胡族铺镇','106',1656),(21629,'方集镇','107',1656),(21630,'城效乡','200',1656),(21631,'洪埠乡','201',1656),(21632,'杨集乡','202',1656),(21633,'马岗集乡','203',1656),(21634,'草庙集乡','204',1656),(21635,'汪棚乡','205',1656),(21636,'南大桥乡','206',1656),(21637,'段集乡','207',1656),(21638,'赵岗乡','208',1656),(21639,'武庙乡','209',1656),(21640,'祖师庙乡','210',1656),(21641,'张老埠乡','211',1656),(21642,'石佛店乡','212',1656),(21643,'张广庙乡','213',1656),(21644,'泉河铺乡','214',1656),(21645,'分水亭乡','215',1656),(21646,'沙河铺乡','216',1656),(21647,'陈集乡','217',1656),(21648,'徐集乡','218',1656),(21649,'三河尖乡','220',1656),(21650,'李店乡','221',1656),(21651,'丰港乡','222',1656),(21652,'柳树店乡','223',1656),(21653,'观堂乡','224',1656),(21654,'春申街道办事处','001',1657),(21655,'定城街道办事处','002',1657),(21656,'弋阳街道办事处','003',1657),(21657,'老城街道办事处','004',1657),(21658,'双柳树镇','101',1657),(21659,'伞陂镇','102',1657),(21660,'卜塔集镇','103',1657),(21661,'仁和镇','105',1657),(21662,'付店镇','106',1657),(21663,'踅孜镇','107',1657),(21664,'桃林铺镇','108',1657),(21665,'黄寺岗镇','109',1657),(21666,'江家集镇','110',1657),(21667,'传流店乡','201',1657),(21668,'魏岗乡','202',1657),(21669,'张集乡','203',1657),(21670,'来龙乡','204',1657),(21671,'隆古乡','205',1657),(21672,'谈店乡','206',1657),(21673,'上油岗乡','207',1657),(21674,'白店乡','209',1657),(21675,'黄湖农场','400',1657),(21676,'河南省潢川经济技术开发区','560',1657),(21677,'城关镇','100',1658),(21678,'马集镇','101',1658),(21679,'栏杆镇','102',1658),(21680,'防胡镇','103',1658),(21681,'新里镇','104',1658),(21682,'期思镇','105',1658),(21683,'赵集镇','106',1658),(21684,'台头乡','200',1658),(21685,'王家岗乡','201',1658),(21686,'固城乡','202',1658),(21687,'三空桥乡','203',1658),(21688,'张里乡','204',1658),(21689,'邓湾乡','206',1658),(21690,'张庄乡','207',1658),(21691,'王店乡','208',1658),(21692,'谷堆乡','209',1658),(21693,'芦集乡','212',1658),(21694,'城关镇','100',1659),(21695,'包信镇','101',1659),(21696,'夏庄镇','102',1659),(21697,'东岳镇','103',1659),(21698,'项店镇','104',1659),(21699,'小茴店镇','105',1659),(21700,'城郊乡','200',1659),(21701,'孙庙乡','201',1659),(21702,'路口乡','202',1659),(21703,'彭店乡','203',1659),(21704,'杨店乡','204',1659),(21705,'张陶乡','205',1659),(21706,'白土店乡','206',1659),(21707,'岗李店乡','207',1659),(21708,'长陵乡','208',1659),(21709,'陈棚乡','209',1659),(21710,'临河乡','210',1659),(21711,'关店乡','211',1659),(21712,'曹黄林乡','213',1659),(21713,'八里岔乡','214',1659),(21714,'地矿局','400',1659),(21715,'陈州回族街道办事处','001',1661),(21716,'七一路街道办事处','002',1661),(21717,'纺织路街道办事处','003',1661),(21718,'人和街道办事处','004',1661),(21719,'小桥街道办事处','005',1661),(21720,'城南办事处','006',1661),(21721,'城北办事处','007',1661),(21722,'城东办事处','008',1661),(21723,'搬口办事处','009',1661),(21724,'李埠口乡','200',1661),(21725,'开发区','560',1661),(21726,'开发区(北区)','561',1661),(21727,'城关镇','100',1662),(21728,'崔桥镇','101',1662),(21729,'江村镇','102',1662),(21730,'白潭镇','103',1662),(21731,'韭园镇','104',1662),(21732,'练寺镇','105',1662),(21733,'大新镇','106',1662),(21734,'包屯镇','107',1662),(21735,'汴岗镇','108',1662),(21736,'曹里乡','200',1662),(21737,'柴岗乡','201',1662),(21738,'固城乡','202',1662),(21739,'吕潭乡','203',1662),(21740,'大李庄乡','204',1662),(21741,'城郊乡','205',1662),(21742,'国营农牧场','500',1662),(21743,'城关镇','100',1663),(21744,'西夏亭镇','101',1663),(21745,'逍遥镇','102',1663),(21746,'奉母镇','103',1663),(21747,'红花集镇','104',1663),(21748,'聂堆镇','105',1663),(21749,'东夏亭镇','106',1663),(21750,'西华营镇','107',1663),(21751,'址坊镇','108',1663),(21752,'田口乡','200',1663),(21753,'清河驿乡','201',1663),(21754,'皮营乡','202',1663),(21755,'东王营乡','203',1663),(21756,'大王庄乡','204',1663),(21757,'李大庄乡','205',1663),(21758,'叶埠口乡','206',1663),(21759,'迟营乡','207',1663),(21760,'黄土桥乡','208',1663),(21761,'艾岗乡','209',1663),(21762,'西华县农场','400',1663),(21763,'西华县园艺场','401',1663),(21764,'西华县林场','402',1663),(21765,'西华县农科站','403',1663),(21766,'黄泛区农场','405',1663),(21767,'五二农场','406',1663),(21768,'新城区办事处','001',1664),(21769,'东城区办事处','002',1664),(21770,'老城办事处','003',1664),(21771,'黄寨镇','101',1664),(21772,'练集镇','102',1664),(21773,'魏集镇','103',1664),(21774,'固墙镇','104',1664),(21775,'白寺镇','105',1664),(21776,'巴村镇','106',1664),(21777,'谭庄镇','107',1664),(21778,'邓城镇','108',1664),(21779,'胡吉镇','109',1664),(21780,'城关乡','200',1664),(21781,'平店乡','202',1664),(21782,'袁老乡','203',1664),(21783,'化河乡','204',1664),(21784,'姚集乡','205',1664),(21785,'舒庄乡','206',1664),(21786,'大武乡','207',1664),(21787,'张明乡','208',1664),(21788,'郝岗乡','209',1664),(21789,'张庄乡','210',1664),(21790,'汤庄乡','211',1664),(21791,'商水县农场','500',1664),(21792,'东城办事处','001',1665),(21793,'北城办事处','002',1665),(21794,'槐店回族镇','100',1665),(21795,'刘庄店镇','101',1665),(21796,'留福集镇','102',1665),(21797,'老城镇','103',1665),(21798,'赵德营镇','104',1665),(21799,'付井镇','105',1665),(21800,'纸店镇','106',1665),(21801,'新安集镇','107',1665),(21802,'白集镇','108',1665),(21803,'刘湾镇','109',1665),(21804,'连池乡','200',1665),(21805,'石槽集乡','201',1665),(21806,'范营乡','202',1665),(21807,'李老庄乡','203',1665),(21808,'大邢庄乡','204',1665),(21809,'冯营乡','205',1665),(21810,'周营乡','206',1665),(21811,'洪山乡','207',1665),(21812,'北杨集乡','208',1665),(21813,'卞路口乡','209',1665),(21814,'城关镇','100',1666),(21815,'吴台镇','101',1666),(21816,'南丰镇','102',1666),(21817,'白马镇','103',1666),(21818,'宁平镇','104',1666),(21819,'宜路镇','105',1666),(21820,'钱店镇','106',1666),(21821,'汲冢镇','107',1666),(21822,'石槽镇','108',1666),(21823,'城郊乡','200',1666),(21824,'虎头岗乡','201',1666),(21825,'汲水乡','202',1666),(21826,'张完集乡','203',1666),(21827,'丁村乡','204',1666),(21828,'双楼乡','205',1666),(21829,'秋渠乡','206',1666),(21830,'东风乡','207',1666),(21831,'巴集乡','208',1666),(21832,'李楼乡','209',1666),(21833,'胡集乡','210',1666),(21834,'城关回族镇','100',1667),(21835,'新站镇','101',1667),(21836,'鲁台镇','102',1667),(21837,'四通镇','103',1667),(21838,'临蔡镇','104',1667),(21839,'安岭镇','105',1667),(21840,'朱集乡','200',1667),(21841,'豆门乡','201',1667),(21842,'冯塘乡','202',1667),(21843,'刘振屯乡','203',1667),(21844,'王店乡','204',1667),(21845,'大连乡','205',1667),(21846,'葛店乡','206',1667),(21847,'黄集乡','207',1667),(21848,'白楼乡','208',1667),(21849,'齐老乡','209',1667),(21850,'郑集乡','210',1667),(21851,'曹河乡','211',1667),(21852,'许湾乡','213',1667),(21853,'城关回族镇','100',1668),(21854,'常营镇','101',1668),(21855,'逊母口镇','102',1668),(21856,'老冢镇','103',1668),(21857,'朱口镇','104',1668),(21858,'马头镇','105',1668),(21859,'龙曲镇','106',1668),(21860,'板桥镇','107',1668),(21861,'符草楼镇','108',1668),(21862,'马厂镇','109',1668),(21863,'毛庄镇','110',1668),(21864,'城郊乡','200',1668),(21865,'杨庙乡','201',1668),(21866,'王集乡','202',1668),(21867,'高贤乡','203',1668),(21868,'芝麻洼乡','204',1668),(21869,'清集乡','205',1668),(21870,'独塘乡','206',1668),(21871,'大许寨乡','207',1668),(21872,'五里口乡','208',1668),(21873,'张集乡','209',1668),(21874,'高朗乡','210',1668),(21875,'转楼乡','211',1668),(21876,'太康农场','400',1668),(21877,'石油堪探局太康农场','401',1668),(21878,'太康培训中心','402',1668),(21879,'园艺厂','404',1668),(21880,'农科所','405',1668),(21881,'畜牧良种场','406',1668),(21882,'城关镇','100',1669),(21883,'玄武镇','101',1669),(21884,'枣集镇','102',1669),(21885,'太清宫镇','103',1669),(21886,'王皮溜镇','104',1669),(21887,'试量镇','105',1669),(21888,'辛集镇','106',1669),(21889,'马铺镇','107',1669),(21890,'涡北镇','108',1669),(21891,'城郊乡','200',1669),(21892,'郑家集乡','201',1669),(21893,'观堂乡','202',1669),(21894,'生铁冢乡','203',1669),(21895,'张店乡','204',1669),(21896,'赵村乡','205',1669),(21897,'任集乡','206',1669),(21898,'唐集乡','207',1669),(21899,'高集乡','208',1669),(21900,'邱集乡','209',1669),(21901,'穆店乡','210',1669),(21902,'杨湖口乡','211',1669),(21903,'贾滩乡','212',1669),(21904,'鹿邑县农科所','400',1669),(21905,'鹿邑县太清农场','401',1669),(21906,'鹿邑县火王农场','402',1669),(21907,'鹿邑县前李农场','403',1669),(21908,'鹿邑县枣集农场','404',1669),(21909,'鹿邑县后狄楼农场','405',1669),(21910,'鹿邑县蚕种场','406',1669),(21911,'花园办事处','001',1670),(21912,'水寨办事处','002',1670),(21913,'东方办事处','003',1670),(21914,'莲花办事处','004',1670),(21915,'千佛阁办事处','005',1670),(21916,'光武办事处','006',1670),(21917,'南顿镇','100',1670),(21918,'孙店镇','101',1670),(21919,'李寨镇','102',1670),(21920,'贾岭镇','103',1670),(21921,'高寺镇','104',1670),(21922,'新桥镇','105',1670),(21923,'付集镇','106',1670),(21924,'官会镇','107',1670),(21925,'丁集镇','108',1670),(21926,'郑郭镇','109',1670),(21927,'秣陵镇','110',1670),(21928,'王明口镇','111',1670),(21929,'永丰乡','200',1670),(21930,'范集乡','201',1670),(21931,'三店乡','202',1670),(21932,'人民街道办事处','001',1672),(21933,'东风街道办事处','002',1672),(21934,'西园街道办事处','003',1672),(21935,'新华街道办事处','004',1672),(21936,'南海路办事处','005',1672),(21937,'老街办事处','006',1672),(21938,'橡林办事处','007',1672),(21939,'雪松办事处','008',1672),(21940,'顺河办事处','009',1672),(21941,'刘阁办事处','010',1672),(21942,'水屯镇','100',1672),(21943,'诸市乡','203',1672),(21944,'朱古洞乡','204',1672),(21945,'胡庙乡','205',1672),(21946,'古城乡','206',1672),(21947,'关王庙乡','360',1672),(21948,'金河办事处','560',1672),(21949,'金桥办事处','561',1672),(21950,'金山办事处','562',1672),(21951,'柏城办事处','001',1673),(21952,'柏亭办事处','002',1673),(21953,'五沟营镇','101',1673),(21954,'权寨镇','102',1673),(21955,'师灵镇','103',1673),(21956,'出山镇','104',1673),(21957,'环城乡','200',1673),(21958,'重渠乡','201',1673),(21959,'盆尧乡','202',1673),(21960,'人和乡','203',1673),(21961,'宋集乡','204',1673),(21962,'谭店乡','205',1673),(21963,'吕店乡','206',1673),(21964,'芦庙乡','208',1673),(21965,'杨庄乡','209',1673),(21966,'专探乡','210',1673),(21967,'二郎乡','211',1673),(21968,'蔡寨回族乡','212',1673),(21969,'焦庄乡','213',1673),(21970,'老王坡农场','500',1673),(21971,'蔡都镇','100',1674),(21972,'黄埠镇','101',1674),(21973,'杨集镇','102',1674),(21974,'洙湖镇','103',1674),(21975,'党店镇','104',1674),(21976,'朱里镇','105',1674),(21977,'华陂镇','106',1674),(21978,'芦岗乡','200',1674),(21979,'大路李乡','201',1674),(21980,'无量寺乡','202',1674),(21981,'邵店乡','203',1674),(21982,'五龙乡','204',1674),(21983,'杨屯乡','205',1674),(21984,'和店乡','206',1674),(21985,'蔡沟乡','207',1674),(21986,'塔桥乡','208',1674),(21987,'齐海乡','209',1674),(21988,'崇礼乡','210',1674),(21989,'韩寨乡','211',1674),(21990,'东岸乡','212',1674),(21991,'东洪乡','213',1674),(21992,'小岳寺乡','215',1674),(21993,'西洪乡','216',1674),(21994,'百尺乡','217',1674),(21995,'古槐镇','100',1675),(21996,'杨埠镇','101',1675),(21997,'东和店镇','102',1675),(21998,'庙湾镇','103',1675),(21999,'射桥镇','104',1675),(22000,'西洋店镇','105',1675),(22001,'东皇庙乡','200',1675),(22002,'高杨店乡','201',1675),(22003,'十字路乡','202',1675),(22004,'后刘乡','203',1675),(22005,'万冢乡','204',1675),(22006,'玉皇庙乡','205',1675),(22007,'郭楼乡','206',1675),(22008,'李屯乡','207',1675),(22009,'老王岗乡','208',1675),(22010,'辛店乡','209',1675),(22011,'万金店乡','210',1675),(22012,'双庙乡','211',1675),(22013,'真阳镇','100',1676),(22014,'寒冻镇','101',1676),(22015,'汝南埠镇','102',1676),(22016,'铜钟镇','103',1676),(22017,'陡沟镇','104',1676),(22018,'熊寨镇','105',1676),(22019,'慎水乡','200',1676),(22020,'傅寨乡','201',1676),(22021,'袁寨乡','202',1676),(22022,'新阮店乡','203',1676),(22023,'油坊店乡','204',1676),(22024,'雷寨乡','207',1676),(22025,'王勿桥乡','208',1676),(22026,'永兴乡','209',1676),(22027,'吕河乡','210',1676),(22028,'大林乡','211',1676),(22029,'皮店乡','212',1676),(22030,'彭桥乡','213',1676),(22031,'兰青乡','214',1676),(22032,'五三农场','500',1676),(22033,'盘龙镇','100',1677),(22034,'竹沟镇','101',1677),(22035,'任店镇','102',1677),(22036,'新安店镇','103',1677),(22037,'留庄镇','104',1677),(22038,'刘店镇','105',1677),(22039,'蚁蜂镇','106',1677),(22040,'三里河乡','200',1677),(22041,'石滚河乡','203',1677),(22042,'瓦岗乡','204',1677),(22043,'李新店乡','205',1677),(22044,'双河乡','206',1677),(22045,'普会寺乡','209',1677),(22046,'泌水镇','100',1678),(22047,'沙河店镇','101',1678),(22048,'羊册镇','102',1678),(22049,'马谷田镇','103',1678),(22050,'板桥镇','104',1678),(22051,'春水镇','105',1678),(22052,'高店乡','200',1678),(22053,'盘古乡','201',1678),(22054,'高邑乡','202',1678),(22055,'王店乡','203',1678),(22056,'铜山乡','204',1678),(22057,'老河乡','205',1678),(22058,'下碑寺乡','206',1678),(22059,'象河乡','207',1678),(22060,'付庄乡','208',1678),(22061,'贾楼乡','209',1678),(22062,'黄山口乡','210',1678),(22063,'郭集乡','211',1678),(22064,'泰山庙乡','212',1678),(22065,'官庄乡','213',1678),(22066,'杨家集乡','214',1678),(22067,'双庙街乡','215',1678),(22068,'赊湾乡','216',1678),(22069,'花园乡','217',1678),(22070,'汝宁镇','100',1679),(22071,'王岗镇','101',1679),(22072,'马乡镇','102',1679),(22073,'和孝镇','103',1679),(22074,'老君庙镇','104',1679),(22075,'留盆镇','105',1679),(22076,'金铺镇','106',1679),(22077,'三门闸乡','200',1679),(22078,'三里店乡','201',1679),(22079,'三桥乡','202',1679),(22080,'南余店乡','204',1679),(22081,'常兴乡','206',1679),(22082,'官庄乡','207',1679),(22083,'韩庄乡','209',1679),(22084,'罗店乡','210',1679),(22085,'张楼乡','211',1679),(22086,'板店乡','212',1679),(22087,'瞿阳镇','100',1680),(22088,'车站镇','101',1680),(22089,'玉山镇','102',1680),(22090,'常庄乡','200',1680),(22091,'和兴乡','202',1680),(22092,'沈寨乡','203',1680),(22093,'槐树乡','204',1680),(22094,'查岈山乡','205',1680),(22095,'阳丰乡','206',1680),(22096,'花庄乡','207',1680),(22097,'文城乡','209',1680),(22098,'褚堂乡','211',1680),(22099,'石寨铺乡','213',1680),(22100,'查岈山风景区','500',1680),(22101,'凤鸣谷风景区','501',1680),(22102,'古吕镇','100',1681),(22103,'砖店镇','101',1681),(22104,'陈店镇','102',1681),(22105,'佛阁寺镇','103',1681),(22106,'练村镇','104',1681),(22107,'棠村镇','105',1681),(22108,'韩集镇','106',1681),(22109,'龙口镇','107',1681),(22110,'李桥回族镇','108',1681),(22111,'十里铺乡','200',1681),(22112,'黄楼乡','201',1681),(22113,'余店乡','202',1681),(22114,'河坞乡','204',1681),(22115,'关津乡','205',1681),(22116,'宋岗乡','206',1681),(22117,'顿岗乡','207',1681),(22118,'涧头乡','208',1681),(22119,'杨庄户乡','209',1681),(22120,'化庄乡','210',1681),(22121,'栎城乡','211',1681),(22122,'孙召乡','212',1681),(22123,'弥陀寺乡','213',1681),(22124,'上海街道办事处','001',1683),(22125,'大智街道办事处','002',1683),(22126,'一元街道办事处','003',1683),(22127,'车站街道办事处','004',1683),(22128,'四唯街道办事处','005',1683),(22129,'永清街道办事处','006',1683),(22130,'西马街道办事处','007',1683),(22131,'球场街道办事处','008',1683),(22132,'劳动街道办事处','009',1683),(22133,'二七街道办事处','010',1683),(22134,'新村街道办事处','011',1683),(22135,'丹水池街道办事处','012',1683),(22136,'台北街道办事处','014',1683),(22137,'花桥街道办事处','015',1683),(22138,'谌家矶街道','016',1683),(22139,'后湖街道','017',1683),(22140,'区直管乡百步亭花园','208',1683),(22141,'民族街道办事处','001',1684),(22142,'花楼街道办事处','002',1684),(22143,'水塔街道办事处','003',1684),(22144,'民权街道办事处','004',1684),(22145,'满春街道办事处','005',1684),(22146,'民意街道办事处','006',1684),(22147,'新华街道办事处','007',1684),(22148,'万松街道办事处','008',1684),(22149,'唐家墩街道办事处','009',1684),(22150,'北湖街道办事处','010',1684),(22151,'前进街道办事处','011',1684),(22152,'常青街道办事处','012',1684),(22153,'汉兴街道办事处','013',1684),(22154,'易家墩街道办事处','001',1684),(22155,'韩家墩街道办事处','002',1684),(22156,'宗关街道办事处','003',1684),(22157,'汉水桥街道办事处','004',1684),(22158,'宝丰街道办事处','005',1684),(22159,'荣华街道办事处','006',1684),(22160,'崇仁街道办事处','007',1684),(22161,'汉中街道办事处','008',1684),(22162,'汉正街道办事处','009',1684),(22163,'六角亭街道办事处','010',1684),(22164,'长丰街道','011',1684),(22165,'翠微街道办事处','001',1685),(22166,'建桥街道办事处','002',1685),(22167,'月湖街道办事处','003',1685),(22168,'晴川街道办事处','004',1685),(22169,'鹦鹉街道办事处','005',1685),(22170,'洲头街道办事处','006',1685),(22171,'五里墩街道办事处','007',1685),(22172,'琴断口街道办事处','008',1685),(22173,'江汉二桥街道办事处','009',1685),(22174,'永丰街道办事处','010',1685),(22175,'江堤街道办事处','011',1685),(22176,'四新街道管委会','082',1685),(22177,'积玉桥街道办事处','001',1686),(22178,'杨园街道办事处','002',1686),(22179,'徐家棚街道办事处','003',1686),(22180,'粮道街道办事处','005',1686),(22181,'中华路街道办事处','006',1686),(22182,'黄鹤楼街道办事处','007',1686),(22183,'紫阳街道办事处','008',1686),(22184,'白沙洲街道办事处','009',1686),(22185,'首义路街道办事处','010',1686),(22186,'中南路街道办事处','011',1686),(22187,'水果湖街道办事处','012',1686),(22188,'珞珈山街道办事处','013',1686),(22189,'石洞街道办事处','014',1686),(22190,'南湖街道办事处','015',1686),(22191,'东湖风景区虚拟街道（武','092',1686),(22192,'红卫路街道办事处','001',1687),(22193,'冶金街道办事处','002',1687),(22194,'新沟桥街道办事处','003',1687),(22195,'红钢城街道办事处','004',1687),(22196,'工人村街道办事处','005',1687),(22197,'青山镇街道办事处','006',1687),(22198,'厂前街道办事处','007',1687),(22199,'武东街道办事处','008',1687),(22200,'白玉山街道办事处','009',1687),(22201,'钢花村街道办事处','010',1687),(22202,'钢都花园街道管委会','011',1687),(22203,'武钢厂区','400',1687),(22204,'珞南街道办事处','001',1688),(22205,'关山街道办事处','002',1688),(22206,'狮子山街道办事处','003',1688),(22207,'张家湾街道','004',1688),(22208,'红旗街道办事处','005',1688),(22209,'葛化街道办事处','006',1688),(22210,'洪山街道办事处','007',1688),(22211,'和平街道办事处','008',1688),(22212,'东湖风景区虚拟街道（洪山）','092',1688),(22213,'花山镇','100',1688),(22214,'左岭镇','101',1688),(22215,'湖北省农科院虚拟镇','198',1688),(22216,'青菱乡','201',1688),(22217,'九峰乡','202',1688),(22218,'建设乡','204',1688),(22219,'天兴乡','205',1688),(22220,'东湖开发区','480',1688),(22221,'吴家山街道办事处','001',1689),(22222,'柏泉办事处虚拟街道','002',1689),(22223,'将军路街道办事处','004',1689),(22224,'慈惠街道办事处','005',1689),(22225,'走马岭街道办事处','006',1689),(22226,'径河街道办事处','007',1689),(22227,'长青街道办事处','008',1689),(22228,'辛安渡办事处虚拟街道','011',1689),(22229,'东山办事处虚拟街道','012',1689),(22230,'常青花园新区街道管理委员会','013',1689),(22231,'新沟镇街道办事处','014',1689),(22232,'金银湖街道办事处','015',1689),(22233,'纱帽街道办事处','001',1690),(22234,'邓南镇','100',1690),(22235,'汉南虚拟镇','198',1690),(22236,'东城垸农场','450',1690),(22237,'乌金农场','500',1690),(22238,'汉南农场','501',1690),(22239,'银莲湖农场','502',1690),(22240,'蔡甸街道办事处','001',1691),(22241,'永安街道办事处','003',1691),(22242,'侏儒街道办事处','004',1691),(22243,'大集街道办事处','005',1691),(22244,'张湾街道办事处','006',1691),(22245,'沌口街办事处','070',1691),(22246,'军山街道','071',1691),(22247,'索河镇','100',1691),(22248,'玉贤镇','101',1691),(22249,'蔡甸虚拟镇','198',1691),(22250,'消泗乡','200',1691),(22251,'桐湖办事处','400',1691),(22252,'洪北管委会','401',1691),(22253,'纸坊街道','001',1692),(22254,'金口街道','002',1692),(22255,'乌龙泉街道','003',1692),(22256,'郑店街道','005',1692),(22257,'流芳街道','006',1692),(22258,'东湖开发区虚拟街道','086',1692),(22259,'法泗镇','100',1692),(22260,'安山镇','101',1692),(22261,'湖泗镇','103',1692),(22262,'五里界镇','104',1692),(22263,'豹','105',1692),(22264,'江夏区虚拟镇','198',1692),(22265,'山坡乡','204',1692),(22266,'舒安乡','206',1692),(22267,'金水农场','400',1692),(22268,'江夏区经济开发区庙山办事处','401',1692),(22269,'江夏区经济开发区藏龙岛办事处','402',1692),(22270,'江夏区经济开发区大桥新区办事处','403',1692),(22271,'江夏区经济开发区梁子湖风景区办事','404',1692),(22272,'前川街道','001',1693),(22273,'祁家湾街道','002',1693),(22274,'横店街道','003',1693),(22275,'罗汉寺街道','004',1693),(22276,'滠口街道','005',1693),(22277,'六指店街道','006',1693),(22278,'天河街道','007',1693),(22279,'姚集镇','100',1693),(22280,'蔡榨镇','101',1693),(22281,'王家河镇','102',1693),(22282,'李集镇','103',1693),(22283,'长轩岭镇','104',1693),(22284,'三里镇','105',1693),(22285,'蔡店乡','200',1693),(22286,'木兰乡','201',1693),(22287,'武湖农场','400',1693),(22288,'木兰山风景区','401',1693),(22289,'大潭原种场','402',1693),(22290,'盘龙城经济开发区','403',1693),(22291,'邾城街道办事处','001',1694),(22292,'阳逻街道办事处','002',1694),(22293,'仓埠街道办事处','003',1694),(22294,'汪集街道办事处','004',1694),(22295,'李集街道办事处','005',1694),(22296,'三店街道办事处','006',1694),(22297,'潘塘街道办事处','007',1694),(22298,'旧街街道办事处','008',1694),(22299,'双柳街道办事处','009',1694),(22300,'辛冲镇','100',1694),(22301,'徐古镇','101',1694),(22302,'凤凰镇','102',1694),(22303,'新洲虚拟镇','198',1694),(22304,'道观河风景旅游管理处','400',1694),(22305,'涨渡湖农场','401',1694),(22306,'龙王咀农场','403',1694),(22307,'新洲区火车站','404',1694),(22308,'阳逻开发区','405',1694),(22309,'沈家营街道办事处','001',1696),(22310,'黄石港街道办事处','002',1696),(22311,'红旗桥街道办事处','003',1696),(22312,'胜阳港街道办事处','004',1696),(22313,'花湖街道办事处','070',1696),(22314,'江北农场','400',1696),(22315,'临江街道办事处','001',1697),(22316,'八泉街道办事处','002',1697),(22317,'陈家湾街道办事处','003',1697),(22318,'澄月街道办事处','004',1697),(22319,'黄思湾街道办事处','005',1697),(22320,'西塞山街道办事处','006',1697),(22321,'河口镇','100',1697),(22322,'冶钢农场','400',1697),(22323,'新下陆街道办事处','001',1698),(22324,'老下陆街道办事处','002',1698),(22325,'东方山街道办事处','003',1698),(22326,'团城山街道办事处','070',1698),(22327,'铁山街道办事处','001',1699),(22328,'鹿獐山街道办事处','002',1699),(22329,'兴国镇','100',1700),(22330,'富池镇','101',1700),(22331,'黄颡口镇','102',1700),(22332,'韦源口镇','103',1700),(22333,'太子镇','104',1700),(22334,'大王镇','105',1700),(22335,'陶港镇','106',1700),(22336,'白沙镇','107',1700),(22337,'浮屠镇','108',1700),(22338,'三溪镇','109',1700),(22339,'龙港镇','110',1700),(22340,'洋港镇','111',1700),(22341,'排市镇','112',1700),(22342,'木港镇','113',1700),(22343,'枫林镇','114',1700),(22344,'王英镇','115',1700),(22345,'综合农场','450',1700),(22346,'率洲农场','451',1700),(22347,'半壁山农场','452',1700),(22348,'荆头山农场','453',1700),(22349,'原种场','454',1700),(22350,'金海开发区','455',1700),(22351,'东岳路街道','001',1701),(22352,'经济开发区虚拟街道','002',1701),(22353,'金湖街道','003',1701),(22354,'罗家桥街道','004',1701),(22355,'金牛镇','100',1701),(22356,'保安镇','101',1701),(22357,'灵乡镇','102',1701),(22358,'金山店镇','103',1701),(22359,'还地桥镇','104',1701),(22360,'殷祖镇','105',1701),(22361,'刘仁八镇','107',1701),(22362,'陈贵镇','108',1701),(22363,'大箕铺镇','109',1701),(22364,'汪仁镇','170',1701),(22365,'茗山乡','200',1701),(22366,'东风农场管理区','450',1701),(22367,'金山街道办事处','570',1701),(22368,'武当路街道办事处','001',1703),(22369,'二堰街道办事处','002',1703),(22370,'五堰街道办事处','003',1703),(22371,'白浪开发区白浪街道办事处','004',1703),(22372,'大川镇人民政府','100',1703),(22373,'小川乡（赛武当管理局）','200',1703),(22374,'茅塔乡人民政府','201',1703),(22375,'鸳鸯乡人民政府','202',1703),(22376,'花果街道','001',1704),(22377,'红卫街道','002',1704),(22378,'车城道街道','003',1704),(22379,'汉江路街道','004',1704),(22380,'黄龙镇','100',1704),(22381,'柏林镇','101',1704),(22382,'方滩乡','200',1704),(22383,'西沟乡','201',1704),(22384,'西城开发区','400',1704),(22385,'秦家坪林场','500',1704),(22386,'凤凰山茶场','501',1704),(22387,'城关镇','100',1705),(22388,'安阳镇','101',1705),(22389,'杨溪铺镇','102',1705),(22390,'青曲镇','103',1705),(22391,'白桑关镇','104',1705),(22392,'南化塘镇','105',1705),(22393,'白浪镇','106',1705),(22394,'刘洞镇','107',1705),(22395,'谭山镇','108',1705),(22396,'梅铺镇','109',1705),(22397,'青山镇','110',1705),(22398,'茶店镇','111',1705),(22399,'柳陂镇','112',1705),(22400,'鲍峡镇','113',1705),(22401,'胡家营镇','114',1705),(22402,'大柳乡','200',1705),(22403,'五峰乡','201',1705),(22404,'叶大乡','202',1705),(22405,'原种场','500',1705),(22406,'红岩背林场','501',1705),(22407,'城关镇','100',1706),(22408,'土门镇','101',1706),(22409,'上津镇','102',1706),(22410,'店子镇','103',1706),(22411,'夹河镇','104',1706),(22412,'羊尾镇','105',1706),(22413,'观音镇','106',1706),(22414,'马鞍镇','107',1706),(22415,'河夹镇','108',1706),(22416,'香口乡','200',1706),(22417,'关防乡','201',1706),(22418,'湖北口回族乡','202',1706),(22419,'景阳乡','203',1706),(22420,'六郎乡','204',1706),(22421,'涧池乡','205',1706),(22422,'安家乡','206',1706),(22423,'槐树林特场（乡）','207',1706),(22424,'三官洞林区（乡）','208',1706),(22425,'城关镇','100',1707),(22426,'溢水镇','101',1707),(22427,'麻家渡镇','102',1707),(22428,'宝丰镇','103',1707),(22429,'擂鼓镇','104',1707),(22430,'秦古镇','105',1707),(22431,'得胜镇','106',1707),(22432,'田家镇','107',1707),(22433,'官渡镇','108',1707),(22434,'潘口乡','200',1707),(22435,'竹坪乡','201',1707),(22436,'大庙乡','202',1707),(22437,'双台乡','203',1707),(22438,'楼台乡','204',1707),(22439,'文峰乡','205',1707),(22440,'深河乡','206',1707),(22441,'柳林乡','207',1707),(22442,'堵河源(乡)自然保护区管理局','208',1707),(22443,'双堰园艺场','504',1707),(22444,'城关镇','100',1708),(22445,'蒋家堰镇','101',1708),(22446,'中峰镇','102',1708),(22447,'水坪镇','103',1708),(22448,'县河镇','104',1708),(22449,'泉溪镇','105',1708),(22450,'丰溪镇','106',1708),(22451,'龙坝乡','200',1708),(22452,'新洲乡','201',1708),(22453,'兵营乡','202',1708),(22454,'鄂坪乡','203',1708),(22455,'汇湾乡','204',1708),(22456,'天宝乡','205',1708),(22457,'桃源乡','206',1708),(22458,'向坝乡','207',1708),(22459,'龙王垭茶场','500',1708),(22460,'国营竹溪综合农场','501',1708),(22461,'原种场','502',1708),(22462,'渔种场','503',1708),(22463,'种畜场','504',1708),(22464,'王家山茶场','505',1708),(22465,'标湖林场','506',1708),(22466,'双竹林场','507',1708),(22467,'八卦山林场','508',1708),(22468,'源茂林场','509',1708),(22469,'岱王沟林场','510',1708),(22470,'望府座林场','511',1708),(22471,'天池垭林场','512',1708),(22472,'九里岗林场','513',1708),(22473,'竹溪县十八里长峡管理局','514',1708),(22474,'城关镇','100',1709),(22475,'军店镇','101',1709),(22476,'化龙堰镇','102',1709),(22477,'土城镇','103',1709),(22478,'大木厂镇','104',1709),(22479,'青峰镇','105',1709),(22480,'门古寺镇','106',1709),(22481,'红塔乡','200',1709),(22482,'白鹤乡','201',1709),(22483,'窑淮乡','202',1709),(22484,'姚坪乡','203',1709),(22485,'榔口乡','204',1709),(22486,'沙河乡','205',1709),(22487,'万峪河乡','206',1709),(22488,'桥上乡','207',1709),(22489,'上龛乡','208',1709),(22490,'中坝乡','209',1709),(22491,'九道乡','210',1709),(22492,'回龙乡','211',1709),(22493,'国营五台山林业总场','500',1709),(22494,'国营杨岔山林场','501',1709),(22495,'国营九口山林场','502',1709),(22496,'国营毛家山林场','503',1709),(22497,'国营代东河林场','504',1709),(22498,'房县西蒿漆场','505',1709),(22499,'房县园艺场','506',1709),(22500,'谭家湾水库管养所','507',1709),(22501,'温泉风景区','508',1709),(22502,'房县旱粮粮种场','509',1709),(22503,'均州路街道办事处','001',1710),(22504,'大坝路街道办事处','002',1710),(22505,'丹赵路街道办事处','003',1710),(22506,'三官殿街道办事处','005',1710),(22507,'土关垭镇','100',1710),(22508,'浪河镇','101',1710),(22509,'丁家营镇','102',1710),(22510,'六里坪镇','103',1710),(22511,'盐池河镇','104',1710),(22512,'均县镇','105',1710),(22513,'习家店镇','106',1710),(22514,'蒿坪镇','107',1710),(22515,'石鼓镇','108',1710),(22516,'凉水河镇','109',1710),(22517,'官山镇','110',1710),(22518,'土台乡','201',1710),(22519,'武当山特区','450',1710),(22520,'西陵街道','001',1712),(22521,'学院街道','002',1712),(22522,'云集街道','003',1712),(22523,'西坝街道','004',1712),(22524,'葛洲坝街道','005',1712),(22525,'夜明珠街道','006',1712),(22526,'开发区虚拟街道办事处','071',1712),(22527,'窑湾乡','201',1712),(22528,'峡口风景区虚拟乡','401',1712),(22529,'大公桥街道办事处','001',1713),(22530,'万寿桥街道办事处','002',1713),(22531,'宝塔河街道办事处','003',1713),(22532,'伍家岗街道办事处','004',1713),(22533,'伍家乡','201',1713),(22534,'点军街道办事处','001',1714),(22535,'点军区艾家镇','101',1714),(22536,'桥边镇','102',1714),(22537,'联棚乡','201',1714),(22538,'土城乡','202',1714),(22539,'古老背街道办事处','001',1714),(22540,'虎牙街道办事处','002',1714),(22541,'云池街道办事处','003',1714),(22542,'小溪塔街道办事处','001',1715),(22543,'樟村坪镇','101',1715),(22544,'雾渡河镇','102',1715),(22545,'分乡镇','103',1715),(22546,'太平溪镇','104',1715),(22547,'三斗坪镇','105',1715),(22548,'乐天溪镇','106',1715),(22549,'龙泉镇','107',1715),(22550,'鸦鹊岭镇','108',1715),(22551,'下堡坪乡','201',1715),(22552,'邓村乡','202',1715),(22553,'黄花乡','203',1715),(22554,'三峡坝区虚拟街道','401',1715),(22555,'鸣凤镇','101',1716),(22556,'花林寺镇','102',1716),(22557,'旧县镇','103',1716),(22558,'洋坪镇','104',1716),(22559,'茅坪场镇','105',1716),(22560,'荷花镇','106',1716),(22561,'河口乡','201',1716),(22562,'古夫镇','101',1717),(22563,'高阳镇','102',1717),(22564,'峡口镇','103',1717),(22565,'南阳镇','104',1717),(22566,'黄粮镇','105',1717),(22567,'水月寺镇','106',1717),(22568,'高桥乡','201',1717),(22569,'榛子乡','202',1717),(22570,'茅坪镇','101',1718),(22571,'归州镇','102',1718),(22572,'屈原镇','103',1718),(22573,'沙镇溪镇','104',1718),(22574,'两河口镇','105',1718),(22575,'郭家坝镇','106',1718),(22576,'杨林桥镇','107',1718),(22577,'水田坝乡','201',1718),(22578,'泄滩乡','202',1718),(22579,'梅家河乡','203',1718),(22580,'磨坪乡','204',1718),(22581,'周坪乡','205',1718),(22582,'龙舟坪镇','101',1719),(22583,'高家堰镇','102',1719),(22584,'磨市镇','103',1719),(22585,'都镇湾镇','104',1719),(22586,'资丘镇','105',1719),(22587,'渔峡口镇','106',1719),(22588,'榔坪镇','107',1719),(22589,'贺家坪镇','108',1719),(22590,'大堰乡','201',1719),(22591,'鸭子口乡','202',1719),(22592,'火烧坪乡','203',1719),(22593,'五峰镇','101',1720),(22594,'长乐坪镇','102',1720),(22595,'渔洋关镇','103',1720),(22596,'仁和坪镇','104',1720),(22597,'湾潭镇','105',1720),(22598,'付家堰乡','201',1720),(22599,'牛庄乡','202',1720),(22600,'采花乡','203',1720),(22601,'陆城街道办事处','001',1721),(22602,'宜都工业园区虚拟街道','070',1721),(22603,'红花套镇','100',1721),(22604,'高坝洲镇','101',1721),(22605,'聂家河镇','102',1721),(22606,'松木坪镇','103',1721),(22607,'枝城镇','104',1721),(22608,'姚家店乡','200',1721),(22609,'五眼泉乡','201',1721),(22610,'潘家湾土家族乡','202',1721),(22611,'王家畈乡','203',1721),(22612,'松宜矿区管理委员会','450',1721),(22613,'玉阳街道办事处','001',1722),(22614,'坝陵街道办事处','002',1722),(22615,'玉泉街道办事处','003',1722),(22616,'两河镇','101',1722),(22617,'河溶镇','102',1722),(22618,'育溪镇','103',1722),(22619,'庙前镇','104',1722),(22620,'王店镇','105',1722),(22621,'半月镇','106',1722),(22622,'草埠湖镇','107',1722),(22623,'马家店街道','001',1723),(22624,'安福寺镇','101',1723),(22625,'白洋镇','102',1723),(22626,'顾家店镇','103',1723),(22627,'董市镇','104',1723),(22628,'仙女镇','105',1723),(22629,'问安镇','106',1723),(22630,'七星台镇','107',1723),(22631,'百里洲镇','108',1723),(22632,'王府街道办事处','001',1725),(22633,'昭明街道办事处','002',1725),(22634,'庞公街道办事处','003',1725),(22635,'檀溪街道办事处','004',1725),(22636,'隆中街道办事处','005',1725),(22637,'欧庙镇','100',1725),(22638,'卧龙镇','101',1725),(22639,'尹集乡','200',1725),(22640,'汉江街道办事处','001',1726),(22641,'王寨街道办事处','002',1726),(22642,'中原街道办事处','003',1726),(22643,'定中门街道办事处','004',1726),(22644,'清河口街道办事处','005',1726),(22645,'屏襄门街道办事处','006',1726),(22646,'米公街道办事处','007',1726),(22647,'柿铺街道办事处','008',1726),(22648,'高新区紫贞街道办事处','070',1726),(22649,'高新区七里河街道办事处','071',1726),(22650,'鱼梁洲街道','090',1726),(22651,'牛首镇','100',1726),(22652,'太平店镇','101',1726),(22653,'高新区团山镇','170',1726),(22654,'高新区米庄镇','180',1726),(22655,'开发区','400',1726),(22656,'张湾镇','100',1727),(22657,'龙王镇','101',1727),(22658,'石桥镇','102',1727),(22659,'黄集镇','103',1727),(22660,'伙牌镇','104',1727),(22661,'古驿镇','105',1727),(22662,'朱集镇','106',1727),(22663,'程河镇','107',1727),(22664,'双沟镇','108',1727),(22665,'张家集镇','109',1727),(22666,'黄龙镇','110',1727),(22667,'峪山镇','111',1727),(22668,'东津镇','112',1727),(22669,'襄北农场','400',1727),(22670,'城关镇','100',1728),(22671,'武安镇','101',1728),(22672,'九集镇','102',1728),(22673,'李庙镇','103',1728),(22674,'长坪镇','104',1728),(22675,'薛坪镇','105',1728),(22676,'板桥镇','106',1728),(22677,'巡检镇','107',1728),(22678,'东巩镇','108',1728),(22679,'肖堰镇','109',1728),(22680,'清河管理区','450',1728),(22681,'城关镇','100',1729),(22682,'石花镇','101',1729),(22683,'盛康镇','102',1729),(22684,'庙滩镇','103',1729),(22685,'五山镇','104',1729),(22686,'茨河镇','105',1729),(22687,'南河镇','106',1729),(22688,'紫金镇','107',1729),(22689,'冷集镇','108',1729),(22690,'赵湾乡','200',1729),(22691,'薤山林场','400',1729),(22692,'城关镇','100',1730),(22693,'黄堡镇','101',1730),(22694,'后坪镇','102',1730),(22695,'龙坪镇','103',1730),(22696,'店垭镇','104',1730),(22697,'马良镇','105',1730),(22698,'歇马镇','106',1730),(22699,'马桥镇','107',1730),(22700,'寺坪镇','108',1730),(22701,'过渡湾镇','109',1730),(22702,'两峪乡','200',1730),(22703,'光化街道办事处','001',1731),(22704,'洪山嘴街道办事处','003',1731),(22705,'李楼街道办事处','004',1731),(22706,'孟楼镇','100',1731),(22707,'竹林桥镇','101',1731),(22708,'薛集镇','102',1731),(22709,'张集镇','103',1731),(22710,'仙人渡镇','104',1731),(22711,'袁冲乡','200',1731),(22712,'蔬菜原种场','400',1731),(22713,'百花山林场','401',1731),(22714,'林茂山林场','402',1731),(22715,'二房营原种场','403',1731),(22716,'北城街道办事处','001',1732),(22717,'南城街道办事处','002',1732),(22718,'环城街道办事处','003',1732),(22719,'琚湾镇','100',1732),(22720,'七方镇','101',1732),(22721,'杨当镇','102',1732),(22722,'太平镇','103',1732),(22723,'新市镇','104',1732),(22724,'鹿头镇','105',1732),(22725,'刘升镇','106',1732),(22726,'兴隆镇','107',1732),(22727,'王城镇','108',1732),(22728,'吴店镇','109',1732),(22729,'熊集镇','110',1732),(22730,'平林镇','111',1732),(22731,'随阳农场','400',1732),(22732,'车河农场','401',1732),(22733,'鄢城街道办事处','001',1733),(22734,'南营街道办事处','002',1733),(22735,'郑集镇','102',1733),(22736,'小河镇','103',1733),(22737,'刘猴镇','104',1733),(22738,'孔湾镇','105',1733),(22739,'流水镇','106',1733),(22740,'板桥镇','107',1733),(22741,'王集镇','108',1733),(22742,'襄南监狱','400',1733),(22743,'劳教所','401',1733),(22744,'大雁工业园区','450',1733),(22745,'雷河发展园区','451',1733),(22746,'太和镇','100',1735),(22747,'东沟镇','101',1735),(22748,'梁子生态管理区（镇）','102',1735),(22749,'涂家垴镇','103',1735),(22750,'沼山镇','104',1735),(22751,'华容镇','100',1736),(22752,'葛店镇','101',1736),(22753,'庙岭镇','102',1736),(22754,'段店镇','103',1736),(22755,'临江乡','200',1736),(22756,'蒲团乡','201',1736),(22757,'葛店开发区','400',1736),(22758,'凤凰街道','001',1737),(22759,'古楼街道','002',1737),(22760,'西山街道','003',1737),(22761,'凡口街道','004',1737),(22762,'泽林镇','100',1737),(22763,'杜山镇','101',1737),(22764,'新庙镇','102',1737),(22765,'碧石镇','103',1737),(22766,'汀祖镇','104',1737),(22767,'燕矶镇','105',1737),(22768,'杨叶镇','106',1737),(22769,'花湖镇','107',1737),(22770,'长港镇','108',1737),(22771,'沙窝乡','200',1737),(22772,'龙泉街道办','001',1739),(22773,'泉口街道办','002',1739),(22774,'栗溪镇','100',1739),(22775,'子陵镇','101',1739),(22776,'漳河镇','102',1739),(22777,'马河镇','103',1739),(22778,'石桥驿镇','104',1739),(22779,'牌楼镇','105',1739),(22780,'仙居乡','200',1739),(22781,'掇刀街道办事处','001',1740),(22782,'白庙街道办事处','002',1740),(22783,'荆门高新区虚拟街道','007',1740),(22784,'团林铺镇','100',1740),(22785,'麻城镇','101',1740),(22786,'新市镇','100',1741),(22787,'永兴镇','101',1741),(22788,'曹武镇','102',1741),(22789,'罗店镇','103',1741),(22790,'宋河镇','104',1741),(22791,'坪坝镇','105',1741),(22792,'三阳镇','106',1741),(22793,'绿林镇','107',1741),(22794,'杨集镇','108',1741),(22795,'孙桥镇','109',1741),(22796,'石龙镇','110',1741),(22797,'永隆镇','111',1741),(22798,'雁门口镇','112',1741),(22799,'钱场镇','113',1741),(22800,'开发区(镇)','170',1741),(22801,'罗汉寺办事处','451',1741),(22802,'长滩办事处','452',1741),(22803,'何集办事处','453',1741),(22804,'屈家岭办事处','454',1741),(22805,'易家岭办事处','455',1741),(22806,'太子山林场(虚拟镇)','456',1741),(22807,'原种场（虚拟镇）','457',1741),(22808,'沙洋镇','100',1742),(22809,'五里铺镇','101',1742),(22810,'十里铺镇','102',1742),(22811,'纪山镇','103',1742),(22812,'拾回桥镇','104',1742),(22813,'后港镇','105',1742),(22814,'毛李镇','106',1742),(22815,'官当镇','107',1742),(22816,'李市镇','108',1742),(22817,'马良镇','109',1742),(22818,'高阳镇','110',1742),(22819,'沈集镇','111',1742),(22820,'曾集镇','112',1742),(22821,'沙洋监狱管理局','450',1742),(22822,'沙洋劳动教养管理所','451',1742),(22823,'郢中街道办事处','001',1743),(22824,'洋梓镇','100',1743),(22825,'长寿镇','101',1743),(22826,'丰乐镇','102',1743),(22827,'胡集镇','103',1743),(22828,'双河镇','104',1743),(22829,'磷矿镇','105',1743),(22830,'文集镇','106',1743),(22831,'冷水镇','107',1743),(22832,'石牌镇','108',1743),(22833,'旧口镇','109',1743),(22834,'柴湖镇','110',1743),(22835,'长滩镇','111',1743),(22836,'东桥镇','112',1743),(22837,'客店镇','113',1743),(22838,'张集镇','114',1743),(22839,'九里乡','200',1743),(22840,'国营官庄湖农场','450',1743),(22841,'南湖原种场','451',1743),(22842,'罗汉寺种畜场','452',1743),(22843,'温峡水库','458',1743),(22844,'孝南区书院街道办事处','001',1745),(22845,'孝南区新华街道办事处','002',1745),(22846,'孝南区广场街道办事处','003',1745),(22847,'孝南区车站街道办事处','004',1745),(22848,'孝南区新铺镇','100',1745),(22849,'孝南区西河镇','101',1745),(22850,'孝南区杨店镇','102',1745),(22851,'孝南区陡岗镇','103',1745),(22852,'孝南区肖港镇','104',1745),(22853,'孝南区毛陈镇','105',1745),(22854,'孝南区三汊镇','106',1745),(22855,'孝南区祝站镇','107',1745),(22856,'孝南区朋兴乡','200',1745),(22857,'孝南区卧龙乡','201',1745),(22858,'孝南区闵集乡','202',1745),(22859,'孝南区南大开发区','400',1745),(22860,'孝南区朱胡农场','450',1745),(22861,'孝南区东山头原种场','500',1745),(22862,'孝感开发区','570',1745),(22863,'花园镇','100',1746),(22864,'丰山镇','101',1746),(22865,'周巷镇','102',1746),(22866,'小河镇','103',1746),(22867,'王店镇','104',1746),(22868,'卫店镇','105',1746),(22869,'白沙镇','106',1746),(22870,'邹岗镇','107',1746),(22871,'小悟乡','200',1746),(22872,'季店乡','201',1746),(22873,'花西乡','202',1746),(22874,'陡山乡','203',1746),(22875,'开发区','400',1746),(22876,'双峰山旅游渡假区','500',1746),(22877,'城关镇','100',1747),(22878,'阳平镇','101',1747),(22879,'芳畈镇','102',1747),(22880,'新城镇','103',1747),(22881,'夏店镇','104',1747),(22882,'刘集镇','105',1747),(22883,'河口镇','106',1747),(22884,'四姑镇','107',1747),(22885,'吕王镇','108',1747),(22886,'黄站镇','109',1747),(22887,'宣化店镇','110',1747),(22888,'丰店镇','111',1747),(22889,'大新镇','112',1747),(22890,'三里镇','113',1747),(22891,'高店乡','200',1747),(22892,'彭店乡','201',1747),(22893,'东新乡','202',1747),(22894,'城关镇','100',1748),(22895,'义堂镇','101',1748),(22896,'曾店镇','102',1748),(22897,'吴铺镇','103',1748),(22898,'伍洛镇','104',1748),(22899,'下辛店镇','105',1748),(22900,'道桥镇','106',1748),(22901,'隔蒲潭镇','107',1748),(22902,'胡金店镇','108',1748),(22903,'倒店乡','200',1748),(22904,'沙河乡','201',1748),(22905,'清明河乡','202',1748),(22906,'县经济技术开发区','450',1748),(22907,'城中街道办事处','001',1749),(22908,'城北街道办事处','002',1749),(22909,'四里棚街道办事处','003',1749),(22910,'东马坊街道办事处','004',1749),(22911,'长江埠街道办事处','005',1749),(22912,'田店镇','100',1749),(22913,'杨河镇','101',1749),(22914,'三合镇','102',1749),(22915,'郎君镇','103',1749),(22916,'黄滩镇','104',1749),(22917,'天鹅镇','105',1749),(22918,'义和镇','106',1749),(22919,'陈河镇','107',1749),(22920,'杨岭镇','108',1749),(22921,'汤池镇','109',1749),(22922,'经济技术开发区','400',1749),(22923,'南垸良种场','500',1749),(22924,'府城街道办事处','001',1750),(22925,'南城街道办事处','002',1750),(22926,'赵棚镇','100',1750),(22927,'李店镇','101',1750),(22928,'巡店镇','102',1750),(22929,'棠棣镇','103',1750),(22930,'雷公镇','104',1750),(22931,'王义贞镇','105',1750),(22932,'烟店镇','106',1750),(22933,'孛畈镇','107',1750),(22934,'伏水镇','108',1750),(22935,'陈店乡','200',1750),(22936,'辛榨乡','201',1750),(22937,'木梓乡','202',1750),(22938,'接官乡','203',1750),(22939,'开发区','400',1750),(22940,'仙女山街道办事处','001',1751),(22941,'马口镇','100',1751),(22942,'脉旺镇','101',1751),(22943,'城隍镇','102',1751),(22944,'分水镇','103',1751),(22945,'沉湖镇','104',1751),(22946,'二河镇','105',1751),(22947,'回龙镇','106',1751),(22948,'新堰镇','107',1751),(22949,'垌冢镇','108',1751),(22950,'麻河镇','109',1751),(22951,'刘家隔镇','110',1751),(22952,'新河镇','111',1751),(22953,'庙头镇','112',1751),(22954,'杨林沟镇','113',1751),(22955,'西江乡','200',1751),(22956,'湾潭乡','201',1751),(22957,'南河乡','202',1751),(22958,'马鞍乡','203',1751),(22959,'里潭乡','204',1751),(22960,'韩集乡','205',1751),(22961,'中洲农场','450',1751),(22962,'华严农场','500',1751),(22963,'三星垸原种场','502',1751),(22964,'经济开发区','504',1751),(22965,'沉湖基地开发总公司','505',1751),(22966,'中山街道办事处','001',1753),(22967,'崇文街道办事处','002',1753),(22968,'解放街道办事处','003',1753),(22969,'胜利街道办事处','004',1753),(22970,'朝阳街道办事处','005',1753),(22971,'锣场镇','100',1753),(22972,'岑河镇','101',1753),(22973,'观音当镇','102',1753),(22974,'立新乡','200',1753),(22975,'关沮乡','201',1753),(22976,'联合乡','202',1753),(22977,'岑河原种场','500',1753),(22978,'沙市农场','501',1753),(22979,'西城街道办事处','001',1754),(22980,'东城街道办事处','002',1754),(22981,'城南经济开发区虚拟街道','003',1754),(22982,'纪南镇','100',1754),(22983,'川店镇','101',1754),(22984,'马山镇','102',1754),(22985,'八岭山镇','103',1754),(22986,'李埠镇','104',1754),(22987,'弥市镇','105',1754),(22988,'郢城镇','106',1754),(22989,'太湖港管理区','450',1754),(22990,'菱角湖管理区','451',1754),(22991,'埠河镇','100',1755),(22992,'斗湖堤镇','101',1755),(22993,'夹竹园镇','102',1755),(22994,'闸口镇','103',1755),(22995,'杨家厂镇','104',1755),(22996,'麻豪口镇','105',1755),(22997,'藕池镇','106',1755),(22998,'黄山头镇','107',1755),(22999,'孟家溪镇','108',1755),(23000,'南平镇','109',1755),(23001,'章庄铺镇','110',1755),(23002,'狮子口镇','111',1755),(23003,'斑竹','112',1755),(23004,'毛家港镇','113',1755),(23005,'甘家厂乡','200',1755),(23006,'章田寺乡','201',1755),(23007,'容城镇','100',1756),(23008,'朱河镇','101',1756),(23009,'新沟镇','102',1756),(23010,'龚场镇','103',1756),(23011,'周老嘴镇','104',1756),(23012,'黄歇口镇','105',1756),(23013,'汪桥镇','106',1756),(23014,'程集镇','107',1756),(23015,'分盐镇','108',1756),(23016,'毛市镇','109',1756),(23017,'福田寺镇','110',1756),(23018,'上车湾镇','111',1756),(23019,'汴河镇','112',1756),(23020,'尺八镇','113',1756),(23021,'白螺镇','114',1756),(23022,'网市镇','115',1756),(23023,'三洲镇','116',1756),(23024,'桥市镇','117',1756),(23025,'红城乡','200',1756),(23026,'棋盘乡','201',1756),(23027,'柘木乡','202',1756),(23028,'人民大垸农场管理区','450',1756),(23029,'荒湖农场管理区','451',1756),(23030,'资市镇','100',1757),(23031,'滩桥镇','101',1757),(23032,'熊河镇','102',1757),(23033,'白马寺镇','103',1757),(23034,'沙岗镇','104',1757),(23035,'普济镇','105',1757),(23036,'郝穴镇','106',1757),(23037,'马家寨乡','200',1757),(23038,'秦市乡','201',1757),(23039,'江北监狱','450',1757),(23040,'三湖管理区','500',1757),(23041,'六合垸管理区','501',1757),(23042,'绣林街道办事处','001',1758),(23043,'笔架山街道办事处','002',1758),(23044,'新厂镇','100',1758),(23045,'横沟市镇','101',1758),(23046,'大垸镇','102',1758),(23047,'小河口镇','103',1758),(23048,'桃花山镇','104',1758),(23049,'调关镇','105',1758),(23050,'东升镇','106',1758),(23051,'高基庙镇','107',1758),(23052,'南口镇','108',1758),(23053,'高陵镇','109',1758),(23054,'团山寺镇','110',1758),(23055,'久合垸乡','200',1758),(23056,'天鹅洲开发区','500',1758),(23057,'新堤街道办事处','001',1759),(23058,'滨湖街道办事处','002',1759),(23059,'螺山镇','100',1759),(23060,'乌林镇','101',1759),(23061,'龙口镇','102',1759),(23062,'燕窝镇','103',1759),(23063,'新滩镇','104',1759),(23064,'峰口镇','105',1759),(23065,'曹市镇','106',1759),(23066,'府场镇','107',1759),(23067,'戴家场镇','108',1759),(23068,'瞿家湾镇','109',1759),(23069,'沙口镇','110',1759),(23070,'万全镇','111',1759),(23071,'汊河镇','112',1759),(23072,'黄家口镇','113',1759),(23073,'老湾乡','200',1759),(23074,'小港管理区','450',1759),(23075,'大同湖管理区','451',1759),(23076,'大沙湖管理区','452',1759),(23077,'新江口镇','100',1760),(23078,'南海镇','101',1760),(23079,'八宝镇','102',1760),(23080,'宛市镇','103',1760),(23081,'老城镇','104',1760),(23082,'陈店镇','105',1760),(23083,'王家桥镇','106',1760),(23084,'斯家场镇','107',1760),(23085,'杨林市镇','108',1760),(23086,'纸厂河镇','109',1760),(23087,'街河市镇','110',1760),(23088,'危水镇','111',1760),(23089,'刘家场镇','112',1760),(23090,'沙道观镇','113',1760),(23091,'万家乡','200',1760),(23092,'卸甲坪土家族乡','201',1760),(23093,'赤壁街道办事处','001',1762),(23094,'东湖街道办事处','002',1762),(23095,'禹王街道办事处','003',1762),(23096,'南湖街道办事处','004',1762),(23097,'路口镇','100',1762),(23098,'堵城镇','101',1762),(23099,'陈策楼镇','102',1762),(23100,'陶店乡','200',1762),(23101,'火车站开发区','450',1762),(23102,'黄州科技经济开发区管理委员会','470',1762),(23103,'团风镇','100',1763),(23104,'淋山河镇','101',1763),(23105,'方高坪镇','102',1763),(23106,'回龙山镇','103',1763),(23107,'马曹庙镇','104',1763),(23108,'上巴河镇','105',1763),(23109,'总路咀镇','106',1763),(23110,'但店镇','107',1763),(23111,'贾庙乡','200',1763),(23112,'杜皮乡','201',1763),(23113,'黄湖农场','400',1763),(23114,'金锣港农场','401',1763),(23115,'城关镇','100',1764),(23116,'七里坪镇','101',1764),(23117,'华河镇','102',1764),(23118,'二程镇','103',1764),(23119,'上新集镇','104',1764),(23120,'高桥镇','105',1764),(23121,'觅儿镇','106',1764),(23122,'八里镇','107',1764),(23123,'太平桥镇','108',1764),(23124,'永河镇','109',1764),(23125,'杏花乡','200',1764),(23126,'火连畈茶场','500',1764),(23127,'天台山旅游开发管理处','501',1764),(23128,'凤山镇','100',1765),(23129,'骆驼坳镇','101',1765),(23130,'大河岸镇','102',1765),(23131,'九资河镇','103',1765),(23132,'胜利镇','104',1765),(23133,'河铺镇','105',1765),(23134,'三里畈镇','106',1765),(23135,'白莲河乡','200',1765),(23136,'匡河乡','201',1765),(23137,'白庙河乡','202',1765),(23138,'平湖乡','203',1765),(23139,'大崎乡','204',1765),(23140,'青苔关林场','500',1765),(23141,'天堂寨林场','501',1765),(23142,'薄刀峰林场','502',1765),(23143,'黄狮寨林场','503',1765),(23144,'温泉镇','100',1766),(23145,'南河镇','101',1766),(23146,'红山镇','102',1766),(23147,'金家铺镇','103',1766),(23148,'石头咀镇','104',1766),(23149,'草盘地镇','105',1766),(23150,'雷家店镇','106',1766),(23151,'杨柳湾镇','107',1766),(23152,'方家咀乡','200',1766),(23153,'孔家坊乡','201',1766),(23154,'陶家河乡','202',1766),(23155,'桃花冲林场','400',1766),(23156,'吴家山林场','401',1766),(23157,'五峰山林场','402',1766),(23158,'清泉镇','100',1767),(23159,'巴河镇','101',1767),(23160,'竹瓦镇','102',1767),(23161,'汪岗镇','103',1767),(23162,'团陂镇','104',1767),(23163,'关口镇','105',1767),(23164,'白莲镇','106',1767),(23165,'蔡河镇','107',1767),(23166,'洗马镇','108',1767),(23167,'丁司','109',1767),(23168,'散花镇','110',1767),(23169,'兰溪镇','111',1767),(23170,'经济开发区镇','170',1767),(23171,'绿杨乡','200',1767),(23172,'策湖养殖场','400',1767),(23173,'三角山林场','401',1767),(23174,'漕河镇','100',1768),(23175,'赤东镇','101',1768),(23176,'蕲州镇','102',1768),(23177,'管窑镇','103',1768),(23178,'彭思镇','104',1768),(23179,'横车镇','105',1768),(23180,'株林镇','106',1768),(23181,'刘河镇','107',1768),(23182,'狮子镇','108',1768),(23183,'青石镇','109',1768),(23184,'张榜镇','110',1768),(23185,'大同镇','111',1768),(23186,'檀林镇','112',1768),(23187,'向桥乡','200',1768),(23188,'八里湖农场','450',1768),(23189,'铁路经济开发区','451',1768),(23190,'黄梅镇','100',1769),(23191,'孔垄镇','101',1769),(23192,'小池镇','102',1769),(23193,'下新镇','103',1769),(23194,'大河镇','104',1769),(23195,'停前镇','105',1769),(23196,'五祖镇','106',1769),(23197,'濯港镇','107',1769),(23198,'蔡山镇','108',1769),(23199,'新开镇','109',1769),(23200,'独山镇','110',1769),(23201,'分路镇','111',1769),(23202,'柳林乡','200',1769),(23203,'杉木乡','201',1769),(23204,'苦竹乡','202',1769),(23205,'刘佐乡','203',1769),(23206,'挪步园风景管理处','400',1769),(23207,'龙感湖','401',1769),(23208,'龙池办事处','001',1770),(23209,'鼓楼办事处','002',1770),(23210,'南湖办事处','003',1770),(23211,'中馆驿镇','100',1770),(23212,'宋埠镇','101',1770),(23213,'歧亭镇','102',1770),(23214,'白果镇','103',1770),(23215,'夫子河镇','104',1770),(23216,'阎家河镇','105',1770),(23217,'张家畈镇','106',1770),(23218,'木子店镇','107',1770),(23219,'盐田河镇','108',1770),(23220,'三河口镇','109',1770),(23221,'黄土岗镇','110',1770),(23222,'福田河镇','111',1770),(23223,'乘马岗镇','112',1770),(23224,'顺河镇','113',1770),(23225,'铁门岗乡','200',1770),(23226,'龟山乡','201',1770),(23227,'狮子峰林场','403',1770),(23228,'铁路生活区虚拟街道','470',1770),(23229,'开发区','471',1770),(23230,'五脑山林场','500',1770),(23231,'武穴办事处','001',1771),(23232,'刊江办事处','002',1771),(23233,'田镇办事处','003',1771),(23234,'万丈湖办事处','004',1771),(23235,'梅川镇','100',1771),(23236,'余川镇','101',1771),(23237,'花桥镇','102',1771),(23238,'大金镇','103',1771),(23239,'石佛寺镇','104',1771),(23240,'四望镇','105',1771),(23241,'法寺镇','106',1771),(23242,'龙坪镇','107',1771),(23243,'万丈湖办事处','400',1771),(23244,'温泉办事处','001',1773),(23245,'浮山办事处','002',1773),(23246,'永安办事处','003',1773),(23247,'汀泗桥镇','100',1773),(23248,'向阳湖镇','101',1773),(23249,'官埠桥镇','102',1773),(23250,'横沟桥镇','103',1773),(23251,'贺胜桥镇','104',1773),(23252,'双溪桥镇','105',1773),(23253,'马桥镇','106',1773),(23254,'桂花镇','107',1773),(23255,'高桥镇','108',1773),(23256,'大幕乡','200',1773),(23257,'向阳湖奶牛良种场','450',1773),(23258,'陆溪镇','100',1774),(23259,'高铁岭镇','101',1774),(23260,'官桥镇','102',1774),(23261,'鱼岳镇','103',1774),(23262,'新街镇','104',1774),(23263,'渡普镇','105',1774),(23264,'潘家湾镇','106',1774),(23265,'牌洲湾镇','107',1774),(23266,'头墩农场','450',1774),(23267,'隽水镇','100',1775),(23268,'麦市镇','101',1775),(23269,'塘湖镇','102',1775),(23270,'关刀镇','103',1775),(23271,'沙堆镇','104',1775),(23272,'五里镇','105',1775),(23273,'石南镇','106',1775),(23274,'北港镇','107',1775),(23275,'马港镇','108',1775),(23276,'四庄乡','200',1775),(23277,'大坪乡','201',1775),(23278,'鹿角山林场','500',1775),(23279,'林业大队','501',1775),(23280,'天城镇','100',1776),(23281,'沙坪镇','101',1776),(23282,'石城镇','102',1776),(23283,'桂花泉镇','103',1776),(23284,'白霓镇','104',1776),(23285,'路口镇','105',1776),(23286,'金塘镇','106',1776),(23287,'青山镇','107',1776),(23288,'肖岭乡','200',1776),(23289,'铜钟乡','201',1776),(23290,'港口乡','202',1776),(23291,'高枧乡','203',1776),(23292,'通羊镇','100',1777),(23293,'南林桥镇','101',1777),(23294,'黄沙铺镇','102',1777),(23295,'厦铺镇','103',1777),(23296,'九宫山镇','104',1777),(23297,'闯王镇','105',1777),(23298,'洪港镇','106',1777),(23299,'大畈镇','107',1777),(23300,'大路乡','200',1777),(23301,'杨芳林乡','201',1777),(23302,'燕厦乡','202',1777),(23303,'慈口乡','203',1777),(23304,'九宫山风景区','450',1777),(23305,'蒲圻办事处','001',1778),(23306,'赤马港办事处','002',1778),(23307,'陆水湖办事处','003',1778),(23308,'新店镇','100',1778),(23309,'赵李桥镇','101',1778),(23310,'茶庵岭镇','102',1778),(23311,'车埠镇','103',1778),(23312,'赤壁镇','104',1778),(23313,'柳山湖镇','105',1778),(23314,'神山镇','106',1778),(23315,'中伙铺镇','107',1778),(23316,'官塘驿镇','108',1778),(23317,'余家桥乡','200',1778),(23318,'黄盖湖农场','450',1778),(23319,'官塘驿林场','451',1778),(23320,'羊楼洞茶场','452',1778),(23321,'沧湖开发区','453',1778),(23322,'西城街道（办事处）','001',1780),(23323,'东城街道（办事处）','002',1780),(23324,'南郊街道（办事处）','003',1780),(23325,'北郊街道（办事处）','004',1780),(23326,'淅河镇','100',1780),(23327,'万店镇','101',1780),(23328,'高城镇','102',1780),(23329,'殷店镇','103',1780),(23330,'草店镇','104',1780),(23331,'小林镇','105',1780),(23332,'淮河镇','106',1780),(23333,'万和镇','108',1780),(23334,'尚市镇','109',1780),(23335,'厉山镇','110',1780),(23336,'唐县镇','111',1780),(23337,'吴山镇','112',1780),(23338,'安居镇','113',1780),(23339,'新街镇','114',1780),(23340,'环潭镇','115',1780),(23341,'洪山镇','116',1780),(23342,'长岗镇','118',1780),(23343,'三里岗镇','119',1780),(23344,'柳林镇','120',1780),(23345,'均川镇','121',1780),(23346,'何店镇','122',1780),(23347,'洛阳镇','123',1780),(23348,'府河镇','124',1780),(23349,'万福店办事处','498',1780),(23350,'曾都区新型工业基地','499',1780),(23351,'应山街道办事处','001',1781),(23352,'十里（街道）办事处','002',1781),(23353,'广水街道办事处','003',1781),(23354,'武胜关镇','100',1781),(23355,'杨寨镇','101',1781),(23356,'陈巷镇','102',1781),(23357,'长岭镇','103',1781),(23358,'马坪镇','104',1781),(23359,'关庙镇','105',1781),(23360,'余店镇','106',1781),(23361,'吴店镇','107',1781),(23362,'郝店镇','108',1781),(23363,'蔡河镇','109',1781),(23364,'城郊乡','200',1781),(23365,'李店乡','201',1781),(23366,'太平乡','202',1781),(23367,'骆店乡','203',1781),(23368,'中华山林场','400',1781),(23369,'花山林场','401',1781),(23370,'三潭风景区','402',1781),(23371,'舞阳坝街道办事处','001',1782),(23372,'六角亭街道办事处','002',1782),(23373,'小渡船街道办事处','003',1782),(23374,'龙凤镇','100',1782),(23375,'崔坝镇','101',1782),(23376,'板桥镇','102',1782),(23377,'三岔乡','200',1782),(23378,'新塘乡','201',1782),(23379,'红土乡','202',1782),(23380,'沙地乡','203',1782),(23381,'白杨乡','204',1782),(23382,'太阳乡','205',1782),(23383,'屯堡乡','206',1782),(23384,'白果乡','207',1782),(23385,'芭蕉乡','208',1782),(23386,'盛家坝乡','209',1782),(23387,'都亭街道办事处','001',1783),(23388,'东城街道办事处','002',1783),(23389,'谋道镇','100',1783),(23390,'柏杨坝镇','101',1783),(23391,'汪营镇','102',1783),(23392,'建南镇','103',1783),(23393,'忠路镇','104',1783),(23394,'团堡镇','105',1783),(23395,'凉雾乡','200',1783),(23396,'元堡乡','201',1783),(23397,'南坪乡','202',1783),(23398,'文斗乡','203',1783),(23399,'毛坝乡','204',1783),(23400,'沙溪乡','205',1783),(23401,'福宝山开发区','400',1783),(23402,'业州镇','100',1784),(23403,'高坪镇','101',1784),(23404,'红岩镇','102',1784),(23405,'景阳镇','103',1784),(23406,'官店镇','104',1784),(23407,'长梁乡','200',1784),(23408,'茅田乡','201',1784),(23409,'龙坪乡','202',1784),(23410,'三里乡','203',1784),(23411,'花坪乡','204',1784),(23412,'信陵镇','100',1785),(23413,'东壤口镇','101',1785),(23414,'沿渡河镇','102',1785),(23415,'官渡口镇','103',1785),(23416,'茶店子镇','104',1785),(23417,'绿葱坡镇','105',1785),(23418,'大支坪镇','106',1785),(23419,'野三关镇','107',1785),(23420,'水布垭镇','108',1785),(23421,'清太坪镇','109',1785),(23422,'溪丘湾乡','200',1785),(23423,'金果坪乡','201',1785),(23424,'珠山镇','100',1786),(23425,'椒园镇','101',1786),(23426,'沙道沟镇','102',1786),(23427,'万寨乡','200',1786),(23428,'长潭河乡','201',1786),(23429,'李家河乡','202',1786),(23430,'晓关乡','203',1786),(23431,'高罗乡','204',1786),(23432,'椿木营乡','205',1786),(23433,'高乐山镇','100',1787),(23434,'忠堡镇','101',1787),(23435,'甲马池镇','102',1787),(23436,'朝阳寺镇','103',1787),(23437,'清坪镇','104',1787),(23438,'丁寨乡','200',1787),(23439,'尖山乡','201',1787),(23440,'活龙坪乡','202',1787),(23441,'小村乡','203',1787),(23442,'黄金洞乡','204',1787),(23443,'翔凤镇','100',1788),(23444,'百福司镇','101',1788),(23445,'大河镇','102',1788),(23446,'绿水乡','200',1788),(23447,'漫水乡','201',1788),(23448,'旧司乡','202',1788),(23449,'革勒车乡','203',1788),(23450,'三胡乡','204',1788),(23451,'走马镇','100',1789),(23452,'容美镇','101',1789),(23453,'铁炉乡','200',1789),(23454,'五里乡','201',1789),(23455,'燕子乡','202',1789),(23456,'下坪乡','203',1789),(23457,'邬阳乡','204',1789),(23458,'中营乡','205',1789),(23459,'太平乡','206',1789),(23460,'八峰开发区','400',1789),(23461,'沙嘴街道办事处','001',1790),(23462,'干河街道办事处','002',1790),(23463,'龙华山办事处','003',1790),(23464,'郑场镇','100',1790),(23465,'毛嘴镇','101',1790),(23466,'豆河镇','102',1790),(23467,'三伏潭镇','103',1790),(23468,'胡场镇','104',1790),(23469,'长倘口镇','105',1790),(23470,'西流河镇','106',1790),(23471,'沙湖镇','107',1790),(23472,'杨林尾镇','108',1790),(23473,'彭场镇','109',1790),(23474,'张沟镇','110',1790),(23475,'郭河镇','111',1790),(23476,'沔城回族镇','112',1790),(23477,'通海口镇','113',1790),(23478,'陈场镇','114',1790),(23479,'工业园区','400',1790),(23480,'九合垸原种场','401',1790),(23481,'沙湖原种场','402',1790),(23482,'排湖渔场','403',1790),(23483,'五湖渔场','404',1790),(23484,'赵西垸林场','405',1790),(23485,'刘家垸林场','406',1790),(23486,'畜禽良种场','407',1790),(23487,'刘口工业园','408',1790),(23488,'园林街道办事处','001',1791),(23489,'潜江经济开发区虚拟街道','002',1791),(23490,'杨市街道办事处','003',1791),(23491,'周矶街道办事处','004',1791),(23492,'竹根滩镇','100',1791),(23493,'渔洋镇','101',1791),(23494,'王场镇','102',1791),(23495,'高石碑镇','103',1791),(23496,'熊口镇','104',1791),(23497,'老新镇','105',1791),(23498,'浩口镇','106',1791),(23499,'积玉口镇','107',1791),(23500,'张金镇','108',1791),(23501,'龙湾镇','109',1791),(23502,'江汉石油管理局','400',1791),(23503,'周矶管理区','450',1791),(23504,'后湖管理区','451',1791),(23505,'熊口管理区','452',1791),(23506,'总口管理区','453',1791),(23507,'西大垸管理区','454',1791),(23508,'运粮湖管理区','455',1791),(23509,'高场原种场','456',1791),(23510,'浩口原种场','457',1791),(23511,'棉花原种场','458',1791),(23512,'竟陵街道办事处','001',1792),(23513,'侨乡街道开发区','002',1792),(23514,'杨林街道办事处','003',1792),(23515,'多宝镇','100',1792),(23516,'拖市镇','101',1792),(23517,'张港镇','102',1792),(23518,'蒋场镇','103',1792),(23519,'汪场镇','104',1792),(23520,'渔薪镇','105',1792),(23521,'黄潭镇','106',1792),(23522,'岳口镇','107',1792),(23523,'横林镇','108',1792),(23524,'彭市镇','109',1792),(23525,'麻洋镇','110',1792),(23526,'多祥镇','111',1792),(23527,'干驿镇','112',1792),(23528,'马湾镇','113',1792),(23529,'卢市镇','114',1792),(23530,'小板镇','115',1792),(23531,'九真镇','116',1792),(23532,'皂市镇','118',1792),(23533,'胡市镇','119',1792),(23534,'石河镇','120',1792),(23535,'佛子山镇','121',1792),(23536,'净潭乡','201',1792),(23537,'蒋湖虚拟镇','450',1792),(23538,'白茅湖虚拟镇','451',1792),(23539,'沉湖管委会','452',1792),(23540,'松柏镇','100',1793),(23541,'阳日镇','101',1793),(23542,'木鱼镇','102',1793),(23543,'红坪镇','103',1793),(23544,'新华乡','200',1793),(23545,'宋洛乡','201',1793),(23546,'九湖乡','202',1793),(23547,'下谷坪土家族乡','203',1793),(23548,'文艺路街道','001',1795),(23549,'朝阳街街道','002',1795),(23550,'韭菜园街道','003',1795),(23551,'浏正街街道','004',1795),(23552,'解放路街道','005',1795),(23553,'府后街街道','006',1795),(23554,'都正街街道','007',1795),(23555,'五里牌街道','008',1795),(23556,'火星街道','009',1795),(23557,'马王堆街道','010',1795),(23558,'东屯渡街道','011',1795),(23559,'湘湖街道','012',1795),(23560,'东岸乡','200',1795),(23561,'书院路街道办事处','001',1796),(23562,'坡子街街道办事处','002',1796),(23563,'学院街街道办事处','003',1796),(23564,'城南路街道办事处','004',1796),(23565,'裕南街街道办事处','005',1796),(23566,'金盆岭街道办事处','006',1796),(23567,'新开铺街道办事处','007',1796),(23568,'青园街道办事处','008',1796),(23569,'桂花坪街道办事处','009',1796),(23570,'大托镇','100',1796),(23571,'望月湖街道','001',1797),(23572,'岳麓街道','002',1797),(23573,'桔子洲街道','003',1797),(23574,'银盆岭街道','004',1797),(23575,'观沙岭街道','005',1797),(23576,'望城坡街道','006',1797),(23577,'西湖街道','007',1797),(23578,'咸嘉湖街道','008',1797),(23579,'望岳街道','009',1797),(23580,'东方红镇','100',1797),(23581,'天顶乡','201',1797),(23582,'梅溪湖综合开发管委会','400',1797),(23583,'芙蓉北路街道','001',1798),(23584,'清水塘街道','003',1798),(23585,'望麓园街道','004',1798),(23586,'湘雅路街道','005',1798),(23587,'伍家岭街道','006',1798),(23588,'新河街道','009',1798),(23589,'通泰街街道','010',1798),(23590,'四方坪街道','012',1798),(23591,'洪山街道','013',1798),(23592,'东风路街道','014',1798),(23593,'捞刀河镇','100',1798),(23594,'新港镇','101',1798),(23595,'青竹湖镇','102',1798),(23596,'侯家塘街道','001',1799),(23597,'左家塘街道','002',1799),(23598,'圭塘街道','003',1799),(23599,'砂子塘街道','004',1799),(23600,'东塘街道','005',1799),(23601,'雨花亭街道','006',1799),(23602,'高桥街道','007',1799),(23603,'洞井镇','100',1799),(23604,'黎托乡','200',1799),(23605,'湖南环保科技产业园管理委员会','400',1799),(23606,'星沙镇','100',1800),(23607,'暮云镇','101',1800),(23608,'黄兴镇','102',1800),(23609,'榔梨镇','103',1800),(23610,'江背镇','104',1800),(23611,'黄花镇','105',1800),(23612,'春华镇','106',1800),(23613,'果园镇','107',1800),(23614,'路口镇','108',1800),(23615,'高桥镇','109',1800),(23616,'金井镇','110',1800),(23617,'福临镇','111',1800),(23618,'青山铺镇','112',1800),(23619,'安沙镇','113',1800),(23620,'北山镇','114',1800),(23621,'双江镇','115',1800),(23622,'跳马乡','200',1800),(23623,'干杉乡','201',1800),(23624,'白沙乡','203',1800),(23625,'开慧乡','204',1800),(23626,'高塘岭镇','100',1801),(23627,'桥驿镇','101',1801),(23628,'丁字镇','102',1801),(23629,'茶亭镇','103',1801),(23630,'东城镇','104',1801),(23631,'铜官镇','105',1801),(23632,'靖港镇','106',1801),(23633,'乔口镇','107',1801),(23634,'乌山镇','108',1801),(23635,'星城镇','109',1801),(23636,'雷锋镇','110',1801),(23637,'雨敞坪镇','111',1801),(23638,'莲花镇','112',1801),(23639,'坪塘镇','113',1801),(23640,'含浦镇','114',1801),(23641,'白箬铺镇','115',1801),(23642,'格塘乡','200',1801),(23643,'新康乡','201',1801),(23644,'黄金乡','202',1801),(23645,'玉潭镇','100',1802),(23646,'道林镇','101',1802),(23647,'花明楼镇','102',1802),(23648,'东湖塘镇','103',1802),(23649,'夏铎铺镇','104',1802),(23650,'双江口镇','105',1802),(23651,'煤炭坝镇','106',1802),(23652,'坝塘镇','107',1802),(23653,'偕乐桥镇','108',1802),(23654,'灰汤镇','109',1802),(23655,'双凫铺镇','110',1802),(23656,'老粮仓镇','111',1802),(23657,'流沙河镇','112',1802),(23658,'巷子口镇','113',1802),(23659,'龙田镇','114',1802),(23660,'横市镇','116',1802),(23661,'回龙铺镇','117',1802),(23662,'黄材镇','118',1802),(23663,'大屯营乡','200',1802),(23664,'全民乡','201',1802),(23665,'朱良桥乡','202',1802),(23666,'菁华铺乡','203',1802),(23667,'南田坪乡','205',1802),(23668,'资福乡','206',1802),(23669,'枫木桥乡','207',1802),(23670,'大成桥乡','208',1802),(23671,'喻家坳乡','209',1802),(23672,'青山桥乡','210',1802),(23673,'沙田乡','213',1802),(23674,'白马桥乡','215',1802),(23675,'历经铺乡','216',1802),(23676,'城郊乡','217',1802),(23677,'沩山乡','218',1802),(23678,'淮川街道','001',1803),(23679,'集里街道','002',1803),(23680,'荷花街道','003',1803),(23681,'关口街道','004',1803),(23682,'社港镇','102',1803),(23683,'官渡镇','104',1803),(23684,'张坊镇','105',1803),(23685,'达浒镇','106',1803),(23686,'沿溪镇','107',1803),(23687,'古港镇','108',1803),(23688,'永和镇','109',1803),(23689,'大瑶镇','110',1803),(23690,'金刚镇','111',1803),(23691,'文家市镇','112',1803),(23692,'太平桥镇','113',1803),(23693,'枨冲镇','114',1803),(23694,'镇头镇','115',1803),(23695,'普迹镇','116',1803),(23696,'永安镇','117',1803),(23697,'北盛镇','118',1803),(23698,'龙伏镇','120',1803),(23699,'澄潭江镇','121',1803),(23700,'中和镇','122',1803),(23701,'柏加镇','123',1803),(23702,'洞阳镇','124',1803),(23703,'大围山镇','125',1803),(23704,'沙市镇','126',1803),(23705,'淳口镇','127',1803),(23706,'小河乡','201',1803),(23707,'七宝山乡','202',1803),(23708,'三口乡','203',1803),(23709,'高坪乡','204',1803),(23710,'溪江乡','205',1803),(23711,'杨花乡','206',1803),(23712,'葛家乡','207',1803),(23713,'官桥乡','208',1803),(23714,'蕉溪乡','211',1803),(23715,'月塘街道','001',1805),(23716,'茨菇塘街道','002',1805),(23717,'宋家桥街道','003',1805),(23718,'桂花街道','004',1805),(23719,'金山街道','005',1805),(23720,'仙庾镇','100',1805),(23721,'明照乡','201',1805),(23722,'贺家土街道','001',1806),(23723,'建设街道','002',1806),(23724,'建宁街道','003',1806),(23725,'董家段街道','004',1806),(23726,'庆云街道','005',1806),(23727,'枫溪街道','006',1806),(23728,'龙泉街道','007',1806),(23729,'五里墩乡','201',1806),(23730,'田心街道','001',1807),(23731,'响石岭街道','002',1807),(23732,'清水塘街道','003',1807),(23733,'铜塘湾街道','004',1807),(23734,'井龙街道','005',1807),(23735,'龙头铺镇','100',1807),(23736,'云田乡','202',1807),(23737,'嵩山路街道','001',1808),(23738,'泰山路街道','002',1808),(23739,'栗雨街道','003',1808),(23740,'马家河镇','100',1808),(23741,'群丰镇','101',1808),(23742,'渌口镇','100',1809),(23743,'朱亭镇','101',1809),(23744,'雷打石镇','104',1809),(23745,'三门镇','105',1809),(23746,'古岳峰镇','106',1809),(23747,'淦田镇','107',1809),(23748,'白关镇','108',1809),(23749,'龙凤乡','200',1809),(23750,'龙潭乡','201',1809),(23751,'砖桥乡','202',1809),(23752,'平山乡','203',1809),(23753,'洲坪乡','207',1809),(23754,'南阳桥乡','208',1809),(23755,'仙井乡','209',1809),(23756,'姚家坝乡','210',1809),(23757,'堂市乡','212',1809),(23758,'王十万乡','213',1809),(23759,'太湖乡','214',1809),(23760,'城关镇','100',1810),(23761,'酒埠江镇','102',1810),(23762,'桃水镇','103',1810),(23763,'皇图岭镇','105',1810),(23764,'网岭镇','106',1810),(23765,'新市镇','107',1810),(23766,'渌田镇','109',1810),(23767,'柏市镇','110',1810),(23768,'大同桥镇','111',1810),(23769,'菜花坪镇','113',1810),(23770,'市上坪镇','114',1810),(23771,'石羊塘镇','115',1810),(23772,'高枧镇','116',1810),(23773,'钟佳桥镇','117',1810),(23774,'黄丰桥镇','118',1810),(23775,'峦山镇','119',1810),(23776,'丫江桥镇','120',1810),(23777,'上云桥镇','121',1810),(23778,'银坑乡','202',1810),(23779,'湖南坳乡','204',1810),(23780,'坪阳庙乡','205',1810),(23781,'贾山乡','207',1810),(23782,'高和乡','211',1810),(23783,'鸭塘铺乡','212',1810),(23784,'莲塘坳乡','213',1810),(23785,'城关镇','100',1811),(23786,'界首镇','101',1811),(23787,'严塘镇','102',1811),(23788,'湖口镇','103',1811),(23789,'浣溪镇','104',1811),(23790,'马江镇','105',1811),(23791,'高陇镇','106',1811),(23792,'腰陂镇','107',1811),(23793,'潞水镇','108',1811),(23794,'虎踞镇','109',1811),(23795,'平水镇','110',1811),(23796,'枣市镇','111',1811),(23797,'火田镇','112',1811),(23798,'下东乡','202',1811),(23799,'思聪乡','204',1811),(23800,'尧水乡','206',1811),(23801,'八团乡','207',1811),(23802,'七地乡','211',1811),(23803,'秩堂乡','212',1811),(23804,'桃坑乡','213',1811),(23805,'茶陵县红色农场','400',1811),(23806,'茶陵监狱','403',1811),(23807,'汉背办事处','404',1811),(23808,'利民办事处','405',1811),(23809,'霞阳镇','100',1812),(23810,'沔渡镇','101',1812),(23811,'十都镇','102',1812),(23812,'水口镇','103',1812),(23813,'三河镇','104',1812),(23814,'鹿原镇','105',1812),(23815,'垄溪乡','200',1812),(23816,'石洲乡','201',1812),(23817,'策源乡','202',1812),(23818,'下村乡','203',1812),(23819,'中村乡','204',1812),(23820,'龙渣瑶族乡','205',1812),(23821,'平乐乡','206',1812),(23822,'船形乡','207',1812),(23823,'东风乡','208',1812),(23824,'炎陵县大院农场','400',1812),(23825,'炎陵县桃源洞管理局','401',1812),(23826,'阳三街道','002',1813),(23827,'西山街道','003',1813),(23828,'黄泥坳街道','004',1813),(23829,'来龙门街道','006',1813),(23830,'南桥镇','100',1813),(23831,'富里镇','101',1813),(23832,'白兔潭镇','102',1813),(23833,'浦口镇','103',1813),(23834,'王坊镇','104',1813),(23835,'王仙镇','105',1813),(23836,'泗汾镇','107',1813),(23837,'沈潭镇','108',1813),(23838,'船湾镇','109',1813),(23839,'大障镇','110',1813),(23840,'贺家桥镇','111',1813),(23841,'仙霞镇','118',1813),(23842,'黄獭嘴镇','119',1813),(23843,'均楚镇','120',1813),(23844,'东富镇','121',1813),(23845,'石亭镇','122',1813),(23846,'栗山坝镇','123',1813),(23847,'神福港镇','124',1813),(23848,'孙家湾乡','204',1813),(23849,'清水江乡','205',1813),(23850,'嘉树乡','206',1813),(23851,'新阳乡','213',1813),(23852,'官庄乡','214',1813),(23853,'枫林市乡','215',1813),(23854,'东堡乡','216',1813),(23855,'板杉乡','217',1813),(23856,'雨湖路街道','001',1815),(23857,'城正街街道','002',1815),(23858,'平政路街道','003',1815),(23859,'云塘街道','004',1815),(23860,'广场街道','005',1815),(23861,'中山路街道','006',1815),(23862,'窑湾街道','007',1815),(23863,'羊牯塘街道','008',1815),(23864,'鹤岭镇','100',1815),(23865,'楠竹山镇','101',1815),(23866,'昭潭乡','200',1815),(23867,'护潭乡','201',1815),(23868,'长城乡','202',1815),(23869,'先锋乡','203',1815),(23870,'岳塘街道','001',1816),(23871,'东坪街道','002',1816),(23872,'中洲路街道','003',1816),(23873,'书院路街道','004',1816),(23874,'下摄司街道','005',1816),(23875,'建设路街道','006',1816),(23876,'滴水埠街道','007',1816),(23877,'五里堆街道','008',1816),(23878,'社建村街道','009',1816),(23879,'宝塔街道','010',1816),(23880,'易家湾镇','100',1816),(23881,'双马镇','101',1816),(23882,'霞城乡','200',1816),(23883,'板塘乡','201',1816),(23884,'荷塘乡','202',1816),(23885,'昭山乡','203',1816),(23886,'红旗农场','400',1816),(23887,'易俗河镇','100',1817),(23888,'梅林桥镇','101',1817),(23889,'谭家山镇','102',1817),(23890,'中路铺镇','103',1817),(23891,'茶恩寺镇','104',1817),(23892,'河口镇','105',1817),(23893,'射埠镇','106',1817),(23894,'花石镇','107',1817),(23895,'青山桥镇','108',1817),(23896,'石鼓镇','109',1817),(23897,'姜畲镇','110',1817),(23898,'云湖桥镇','111',1817),(23899,'石潭镇','112',1817),(23900,'杨嘉桥镇','113',1817),(23901,'乌石镇','114',1817),(23902,'响塘乡','200',1817),(23903,'响水乡','201',1817),(23904,'分水乡','202',1817),(23905,'排头乡','203',1817),(23906,'龙口乡','204',1817),(23907,'锦石乡','205',1817),(23908,'白石乡','206',1817),(23909,'望春门街道','001',1818),(23910,'新湘路街道','002',1818),(23911,'昆仑桥街道','003',1818),(23912,'东山街道','004',1818),(23913,'山枣镇','100',1818),(23914,'栗山镇','101',1818),(23915,'中沙镇','102',1818),(23916,'虞塘镇','103',1818),(23917,'潭市镇','104',1818),(23918,'棋梓镇','105',1818),(23919,'壶天镇','106',1818),(23920,'翻江镇','107',1818),(23921,'金石镇','108',1818),(23922,'白田镇','109',1818),(23923,'月山镇','110',1818),(23924,'泉塘镇','111',1818),(23925,'梅桥镇','112',1818),(23926,'东郊乡','200',1818),(23927,'毛田乡','201',1818),(23928,'金薮乡','202',1818),(23929,'育','203',1818),(23930,'龙洞乡','204',1818),(23931,'清溪镇','100',1819),(23932,'银田镇','101',1819),(23933,'如意镇','102',1819),(23934,'韶山乡','200',1819),(23935,'永义乡','201',1819),(23936,'杨林乡','203',1819),(23937,'大坪乡','204',1819),(23938,'广东路街道','001',1821),(23939,'东风路街道','002',1821),(23940,'冶金街道','003',1821),(23941,'苗圃街道','004',1821),(23942,'粤汉街道','005',1821),(23943,'新湘街道','006',1821),(23944,'茶山坳镇','100',1821),(23945,'东阳渡镇','101',1821),(23946,'和平乡','200',1821),(23947,'酃湖乡','201',1821),(23948,'金甲岭农场','400',1821),(23949,'白渔潭园艺场','401',1821),(23950,'酃湖渔场','402',1821),(23951,'松林茶场','403',1821),(23952,'衡阳市苗圃农场','404',1821),(23953,'先锋街道','001',1822),(23954,'雁峰街道','002',1822),(23955,'天马山街道','003',1822),(23956,'黄茶岭街道','004',1822),(23957,'白沙洲街道','005',1822),(23958,'岳屏镇','100',1822),(23959,'湘江乡','200',1822),(23960,'湘江农场','400',1822),(23961,'人民路街道','001',1823),(23962,'青山街道','002',1823),(23963,'潇湘街道','003',1823),(23964,'五一街道','004',1823),(23965,'合江街道','005',1823),(23966,'黄沙湾街道','006',1823),(23967,'松木乡','200',1823),(23968,'角山乡','201',1823),(23969,'蒸湘街道','001',1824),(23970,'红湘街道（政府虚拟所在地）','002',1824),(23971,'华兴街道','003',1824),(23972,'联合街道','004',1824),(23973,'呆鹰岭镇','100',1824),(23974,'长湖乡','200',1824),(23975,'雨母山乡','201',1824),(23976,'祝融街道','001',1825),(23977,'南岳镇','100',1825),(23978,'岳林乡','200',1825),(23979,'龙凤乡','201',1825),(23980,'拜殿乡','202',1825),(23981,'西渡镇','100',1826),(23982,'集兵镇','101',1826),(23983,'杉桥镇','103',1826),(23984,'井头镇','104',1826),(23985,'演陂镇','105',1826),(23986,'金兰镇','106',1826),(23987,'洪市镇','107',1826),(23988,'曲兰镇','108',1826),(23989,'金溪镇','109',1826),(23990,'界牌镇','110',1826),(23991,'渣江镇','111',1826),(23992,'三湖镇','112',1826),(23993,'台源镇','113',1826),(23994,'樟木乡','200',1826),(23995,'岣嵝乡','201',1826),(23996,'岘山乡','203',1826),(23997,'关市乡','204',1826),(23998,'栏栊乡','205',1826),(23999,'库宗乡','206',1826),(24000,'大安乡','207',1826),(24001,'溪江乡','208',1826),(24002,'石市乡','209',1826),(24003,'长安乡','210',1826),(24004,'板市乡','211',1826),(24005,'樟树乡','212',1826),(24006,'潮江乡','213',1826),(24007,'衡阳县岣嵝峰林场','400',1826),(24008,'衡阳市岳峰瓷厂','401',1826),(24009,'衡南县云集镇','100',1827),(24010,'向阳镇','101',1827),(24011,'廖田镇','102',1827),(24012,'茶市镇','103',1827),(24013,'冠市镇','104',1827),(24014,'江口镇','105',1827),(24015,'宝盖镇','106',1827),(24016,'花桥镇','107',1827),(24017,'铁丝塘镇','108',1827),(24018,'泉溪镇','109',1827),(24019,'洪山镇','110',1827),(24020,'三塘镇','111',1827),(24021,'谭子山镇','112',1827),(24022,'鸡笼镇','113',1827),(24023,'泉湖镇','114',1827),(24024,'柞市镇','115',1827),(24025,'茅市镇','116',1827),(24026,'硫市镇','117',1827),(24027,'栗江镇','118',1827),(24028,'近尾洲镇','119',1827),(24029,'车江镇','120',1827),(24030,'咸塘镇','121',1827),(24031,'相市乡','200',1827),(24032,'洲市乡','201',1827),(24033,'松江乡','202',1827),(24034,'川口办事处','400',1827),(24035,'衡阳市农校农场','401',1827),(24036,'衡南县原种场','402',1827),(24037,'衡阳市农科所','403',1827),(24038,'衡州监狱','404',1827),(24039,'衡南县岐山办事处','406',1827),(24040,'开云镇','100',1828),(24041,'白果镇','101',1828),(24042,'东湖镇','102',1828),(24043,'萱洲镇','103',1828),(24044,'长江镇','104',1828),(24045,'新桥镇','105',1828),(24046,'马迹镇','106',1828),(24047,'店门镇','107',1828),(24048,'贺家乡','200',1828),(24049,'永和乡','201',1828),(24050,'沙泉乡','202',1828),(24051,'福田乡','203',1828),(24052,'岭坡乡','204',1828),(24053,'望峰乡','205',1828),(24054,'长青乡','206',1828),(24055,'贯塘乡','207',1828),(24056,'江东乡','208',1828),(24057,'城关镇','100',1829),(24058,'石湾镇','101',1829),(24059,'新塘镇','102',1829),(24060,'大浦镇','103',1829),(24061,'吴集镇','104',1829),(24062,'甘溪镇','105',1829),(24063,'杨林镇','106',1829),(24064,'草市镇','107',1829),(24065,'杨桥镇','108',1829),(24066,'霞流镇','109',1829),(24067,'荣恒镇','110',1829),(24068,'高湖镇','111',1829),(24069,'白莲镇','112',1829),(24070,'大桥镇','113',1829),(24071,'蓬源镇','114',1829),(24072,'莫井乡','200',1829),(24073,'踏庄乡','201',1829),(24074,'高塘乡','202',1829),(24075,'南湾乡','204',1829),(24076,'三樟乡','208',1829),(24077,'栗木乡','209',1829),(24078,'珍珠乡','210',1829),(24079,'石滩乡','211',1829),(24080,'德圳乡','212',1829),(24081,'洪桥镇','100',1830),(24082,'白鹤铺镇','101',1830),(24083,'金桥镇','102',1830),(24084,'鸟江镇','103',1830),(24085,'粮市镇','104',1830),(24086,'河洲镇','105',1830),(24087,'归阳镇','106',1830),(24088,'过水坪镇','107',1830),(24089,'双桥镇','108',1830),(24090,'灵官镇','109',1830),(24091,'风石堰镇','110',1830),(24092,'白地市镇','111',1830),(24093,'黄土铺镇','112',1830),(24094,'石亭子镇','113',1830),(24095,'官家嘴镇','114',1830),(24096,'步云桥镇','115',1830),(24097,'砖塘镇','116',1830),(24098,'蒋家桥镇','117',1830),(24099,'太和堂镇','118',1830),(24100,'马杜桥乡','200',1830),(24101,'凤歧坪乡','201',1830),(24102,'城连圩乡','202',1830),(24103,'四明山乡','203',1830),(24104,'蔡子池街道','001',1831),(24105,'灶市街街道','002',1831),(24106,'水东江街道','003',1831),(24107,'五里牌街道办事处','004',1831),(24108,'黄市镇','100',1831),(24109,'小水镇','101',1831),(24110,'公平圩镇','102',1831),(24111,'泗门洲镇','103',1831),(24112,'三都镇','104',1831),(24113,'南阳镇','105',1831),(24114,'竹市镇','106',1831),(24115,'夏塘镇','107',1831),(24116,'龙塘镇','108',1831),(24117,'哲桥镇','109',1831),(24118,'永济镇','110',1831),(24119,'遥田镇','111',1831),(24120,'新市镇','112',1831),(24121,'洲陂乡','200',1831),(24122,'亮源乡','201',1831),(24123,'马水乡','202',1831),(24124,'太平圩乡','203',1831),(24125,'导子乡','204',1831),(24126,'东湖圩乡','205',1831),(24127,'上架乡','206',1831),(24128,'沙明乡','207',1831),(24129,'大义乡','208',1831),(24130,'磨形乡','209',1831),(24131,'南京乡','210',1831),(24132,'仁义乡','211',1831),(24133,'余庆乡','212',1831),(24134,'长坪乡','213',1831),(24135,'太和圩乡','214',1831),(24136,'坛下乡','215',1831),(24137,'大市乡','216',1831),(24138,'肥田乡','217',1831),(24139,'宜阳镇','100',1832),(24140,'柏坊镇','101',1832),(24141,'松柏镇','102',1832),(24142,'烟洲镇','103',1832),(24143,'荫田镇','104',1832),(24144,'白沙镇','105',1832),(24145,'西岭镇','106',1832),(24146,'盐湖镇','107',1832),(24147,'三角塘镇','108',1832),(24148,'洋泉镇','109',1832),(24149,'庙前镇','110',1832),(24150,'罗桥镇','111',1832),(24151,'板桥镇','112',1832),(24152,'胜桥镇','113',1832),(24153,'官岭镇','114',1832),(24154,'新河镇','115',1832),(24155,'宜潭乡','200',1832),(24156,'蓬塘乡','201',1832),(24157,'兰江乡','202',1832),(24158,'大堡乡','203',1832),(24159,'江河乡','204',1832),(24160,'弥泉乡','205',1832),(24161,'塔山瑶族乡','206',1832),(24162,'常宁市硫铁矿','400',1832),(24163,'常宁市龙王山金矿','401',1832),(24164,'常宁市水泥厂','402',1832),(24165,'兴隆街道','001',1834),(24166,'龙须塘街道','002',1834),(24167,'汽车站街道','003',1834),(24168,'小江湖街道','004',1834),(24169,'东风路街道','005',1834),(24170,'桥头街道','006',1834),(24171,'高崇山镇','100',1834),(24172,'渡头桥镇','101',1834),(24173,'城东乡','200',1834),(24174,'石桥乡','201',1834),(24175,'火车站乡','202',1834),(24176,'云水乡','203',1834),(24177,'中心路街道','001',1835),(24178,'红旗路街道','002',1835),(24179,'城北路街道','003',1835),(24180,'城西路街道','004',1835),(24181,'翠园街道','005',1835),(24182,'百春园街道','006',1835),(24183,'雨溪镇','100',1835),(24184,'罗市镇','101',1835),(24185,'城南乡','200',1835),(24186,'檀江乡','202',1835),(24187,'蔡锷乡','203',1835),(24188,'板桥乡','204',1835),(24189,'城南园艺场','500',1835),(24190,'邵阳市第一园艺场','501',1835),(24191,'新滩镇街道','001',1836),(24192,'状元洲街道','002',1836),(24193,'田江乡','200',1836),(24194,'茶元头乡','202',1836),(24195,'陈家桥乡','203',1836),(24196,'邵阳市园艺场','500',1836),(24197,'两市镇','100',1837),(24198,'牛马司镇','101',1837),(24199,'范家山镇','102',1837),(24200,'九龙岭镇','103',1837),(24201,'仙槎桥镇','104',1837),(24202,'火厂坪镇','105',1837),(24203,'佘田桥镇','106',1837),(24204,'灵官殿镇','107',1837),(24205,'团山镇','108',1837),(24206,'砂石镇','109',1837),(24207,'廉桥镇','110',1837),(24208,'流光岭镇','111',1837),(24209,'流泽镇','112',1837),(24210,'魏家桥镇','113',1837),(24211,'野鸡坪镇','114',1837),(24212,'杨桥镇','115',1837),(24213,'水东江镇','116',1837),(24214,'黄陂桥乡','201',1837),(24215,'黑田铺乡','202',1837),(24216,'双凤乡','203',1837),(24217,'周官桥乡','204',1837),(24218,'简家陇乡','205',1837),(24219,'堡面前乡','209',1837),(24220,'石株桥乡','210',1837),(24221,'界岭乡','211',1837),(24222,'斫曹乡','212',1837),(24223,'酿溪镇','100',1838),(24224,'严塘镇','101',1838),(24225,'雀塘镇','102',1838),(24226,'陈家坊镇','103',1838),(24227,'潭溪镇','104',1838),(24228,'寸石镇','105',1838),(24229,'坪上镇','106',1838),(24230,'龙溪铺镇','107',1838),(24231,'巨口铺镇','108',1838),(24232,'新田铺镇','109',1838),(24233,'小塘镇','110',1838),(24234,'潭府乡','200',1838),(24235,'太芝庙乡','201',1838),(24236,'大新乡','202',1838),(24237,'迎光乡','203',1838),(24238,'塘渡口镇','100',1839),(24239,'白仓镇','101',1839),(24240,'金称市镇','102',1839),(24241,'塘田市镇','103',1839),(24242,'黄亭市镇','104',1839),(24243,'长阳铺镇','105',1839),(24244,'岩口铺镇','106',1839),(24245,'九公桥镇','107',1839),(24246,'下花桥镇','108',1839),(24247,'谷洲镇','109',1839),(24248,'郦家坪镇','110',1839),(24249,'五峰铺镇','111',1839),(24250,'黄塘乡','200',1839),(24251,'小溪市乡','201',1839),(24252,'霞塘云乡','202',1839),(24253,'长乐乡','203',1839),(24254,'蔡桥乡','204',1839),(24255,'河伯乡','205',1839),(24256,'黄荆乡','206',1839),(24257,'诸甲亭乡','207',1839),(24258,'罗城乡','208',1839),(24259,'金江乡','209',1839),(24260,'七里山园艺场','401',1839),(24261,'五丰铺林场','402',1839),(24262,'河伯岭林场','403',1839),(24263,'桃洪镇','100',1840),(24264,'小沙江镇','101',1840),(24265,'金石桥镇','102',1840),(24266,'司门前镇','103',1840),(24267,'高平镇','104',1840),(24268,'六都寨镇','105',1840),(24269,'荷香桥镇','106',1840),(24270,'横板桥镇','107',1840),(24271,'周旺镇','108',1840),(24272,'滩头镇','109',1840),(24273,'鸭田镇','110',1840),(24274,'西洋江镇','111',1840),(24275,'雨山铺镇','112',1840),(24276,'麻塘山乡','200',1840),(24277,'虎形山瑶族乡','201',1840),(24278,'大水田乡','203',1840),(24279,'羊古坳乡','204',1840),(24280,'罗洪乡','205',1840),(24281,'七江乡','206',1840),(24282,'荷田乡','207',1840),(24283,'石门乡','208',1840),(24284,'南岳庙乡','211',1840),(24285,'山界回族乡','212',1840),(24286,'三阁司乡','213',1840),(24287,'北山乡','214',1840),(24288,'岩口乡','215',1840),(24289,'洞口镇','100',1841),(24290,'江口镇','101',1841),(24291,'毓兰镇','102',1841),(24292,'高沙镇','103',1841),(24293,'竹市镇','104',1841),(24294,'石江镇','105',1841),(24295,'黄桥镇','106',1841),(24296,'山门镇','107',1841),(24297,'醪田镇','108',1841),(24298,'花园镇','109',1841),(24299,'花古乡','200',1841),(24300,'古楼乡','201',1841),(24301,'长塘瑶族乡','202',1841),(24302,'罗溪瑶族乡','203',1841),(24303,'月溪乡','204',1841),(24304,'渣坪乡','205',1841),(24305,'岩山乡','207',1841),(24306,'杨林乡','208',1841),(24307,'水东乡','209',1841),(24308,'石柱乡','210',1841),(24309,'桐山乡','211',1841),(24310,'大屋瑶族乡','212',1841),(24311,'邵阳市茶铺茶场','500',1841),(24312,'长铺镇','100',1842),(24313,'武阳镇','101',1842),(24314,'李熙桥镇','102',1842),(24315,'红岩镇','103',1842),(24316,'唐家坊镇','104',1842),(24317,'金屋塘镇','105',1842),(24318,'东山侗族乡','200',1842),(24319,'鹅公岭侗族苗族乡','201',1842),(24320,'朝仪侗族乡','202',1842),(24321,'在市苗族乡','203',1842),(24322,'乐安铺苗族侗族乡','204',1842),(24323,'黄桑坪苗族乡','205',1842),(24324,'关峡苗族乡','206',1842),(24325,'长铺子苗族乡','207',1842),(24326,'党坪苗族乡','208',1842),(24327,'联民苗族瑶族乡','209',1842),(24328,'麻塘苗族乡','210',1842),(24329,'枫木团苗族侗族乡','211',1842),(24330,'河口苗族乡','212',1842),(24331,'竹舟江苗族乡','213',1842),(24332,'白玉乡','214',1842),(24333,'黄土矿乡','215',1842),(24334,'瓦屋塘乡','216',1842),(24335,'水口乡','217',1842),(24336,'梅坪乡','218',1842),(24337,'金石镇','100',1843),(24338,'水庙镇','101',1843),(24339,'白沙镇','103',1843),(24340,'黄龙镇','104',1843),(24341,'高桥镇','105',1843),(24342,'回龙寺镇','106',1843),(24343,'一渡水镇','107',1843),(24344,'黄金瑶族乡','200',1843),(24345,'麻林瑶族乡','201',1843),(24346,'飞仙桥乡','202',1843),(24347,'万塘乡','203',1843),(24348,'清江桥乡','204',1843),(24349,'安山乡','205',1843),(24350,'丰田乡','206',1843),(24351,'马头桥乡','207',1843),(24352,'巡田乡','208',1843),(24353,'靖位乡','209',1843),(24354,'儒林镇','100',1844),(24355,'茅坪镇','101',1844),(24356,'西岩镇','102',1844),(24357,'丹口镇','103',1844),(24358,'五团镇','104',1844),(24359,'南山镇','105',1844),(24360,'威溪乡','200',1844),(24361,'长安营乡','201',1844),(24362,'白毛坪乡','202',1844),(24363,'兰蓉乡','203',1844),(24364,'汀坪乡','204',1844),(24365,'南山牧场','400',1844),(24366,'土桥农场','401',1844),(24367,'原种场','402',1844),(24368,'农科所','403',1844),(24369,'云马林场','404',1844),(24370,'燕子山林场','405',1844),(24371,'青界山林场','406',1844),(24372,'南洞林场','407',1844),(24373,'金紫山林场','408',1844),(24374,'辕门口街道','001',1845),(24375,'迎春亭街道','002',1845),(24376,'邓元泰镇','100',1845),(24377,'湾头桥镇','101',1845),(24378,'文坪镇','102',1845),(24379,'荆竹铺镇','103',1845),(24380,'稠树塘镇','104',1845),(24381,'邓家铺镇','105',1845),(24382,'龙溪镇','106',1845),(24383,'司马冲镇','107',1845),(24384,'龙田乡','200',1845),(24385,'头堂乡','201',1845),(24386,'安乐乡','202',1845),(24387,'大甸乡','203',1845),(24388,'马坪乡','204',1845),(24389,'晏田乡','205',1845),(24390,'秦桥乡','206',1845),(24391,'水浸坪乡','207',1845),(24392,'双牌乡','208',1845),(24393,'岳阳楼街道','001',1847),(24394,'三眼桥街道','002',1847),(24395,'吕仙亭街道','003',1847),(24396,'金鹗山街道','004',1847),(24397,'东茅岭街道','005',1847),(24398,'五里牌街道','006',1847),(24399,'冷水铺街道','007',1847),(24400,'城陵矶街道','008',1847),(24401,'新路口街道','009',1847),(24402,'北港街道','010',1847),(24403,'洞庭街道','011',1847),(24404,'洛王街道','012',1847),(24405,'南湖街道','013',1847),(24406,'站前街道','014',1847),(24407,'西塘镇','100',1847),(24408,'梅溪乡','200',1847),(24409,'郭镇乡','201',1847),(24410,'三荷乡','202',1847),(24411,'康王乡','203',1847),(24412,'经济技术开发区通海路管理处','402',1847),(24413,'南湖渔场','404',1847),(24414,'湖滨农垦集团公司','405',1847),(24415,'金凤桥管理处','406',1847),(24416,'云溪镇','100',1848),(24417,'陆城镇','101',1848),(24418,'路口镇','102',1848),(24419,'道仁矶镇','103',1848),(24420,'文桥镇','104',1848),(24421,'云溪乡','200',1848),(24422,'永济乡','201',1848),(24423,'长炼街道','450',1848),(24424,'岳化社区','451',1848),(24425,'西城街道','001',1849),(24426,'柳林洲镇','100',1849),(24427,'广兴洲镇','101',1849),(24428,'许市镇','102',1849),(24429,'钱粮湖镇','103',1849),(24430,'良心堡镇','104',1849),(24431,'采桑湖镇','105',1849),(24432,'荣家湾镇','100',1850),(24433,'麻塘镇','102',1850),(24434,'鹿角镇','103',1850),(24435,'黄沙街镇','104',1850),(24436,'新墙镇','105',1850),(24437,'柏祥镇','106',1850),(24438,'筻口镇','107',1850),(24439,'公田镇','108',1850),(24440,'毛田镇','109',1850),(24441,'月田镇','110',1850),(24442,'张谷英镇','111',1850),(24443,'新开镇','112',1850),(24444,'中洲乡','202',1850),(24445,'长湖乡','203',1850),(24446,'步仙乡','204',1850),(24447,'甘田乡','205',1850),(24448,'杨林乡','206',1850),(24449,'云山乡','207',1850),(24450,'相思乡','208',1850),(24451,'饶村乡','209',1850),(24452,'东洞庭湖管委会','500',1850),(24453,'城关镇','100',1851),(24454,'三封寺镇','101',1851),(24455,'治河渡镇','102',1851),(24456,'北景港镇','103',1851),(24457,'鲇鱼须镇','104',1851),(24458,'宋家嘴镇','105',1851),(24459,'万庾镇','106',1851),(24460,'插旗镇','110',1851),(24461,'注滋口镇','111',1851),(24462,'操军镇','112',1851),(24463,'东山镇','114',1851),(24464,'梅田湖镇','119',1851),(24465,'胜峰乡','200',1851),(24466,'新河乡','201',1851),(24467,'护城乡','202',1851),(24468,'新建乡','203',1851),(24469,'南山乡','204',1851),(24470,'终南乡','205',1851),(24471,'幸福乡','206',1851),(24472,'团洲乡','207',1851),(24473,'文星镇','100',1852),(24474,'东塘镇','101',1852),(24475,'袁家铺镇','102',1852),(24476,'界头铺镇','103',1852),(24477,'樟树镇','104',1852),(24478,'三塘镇','110',1852),(24479,'长康镇','111',1852),(24480,'城西镇','115',1852),(24481,'岭北镇','116',1852),(24482,'新泉镇','117',1852),(24483,'湘滨镇','118',1852),(24484,'南湖洲镇','119',1852),(24485,'石塘乡','200',1852),(24486,'六塘乡','201',1852),(24487,'白泥湖乡','202',1852),(24488,'静河乡','203',1852),(24489,'玉华乡','204',1852),(24490,'杨林寨乡','206',1852),(24491,'青潭乡','209',1852),(24492,'汉昌镇','100',1853),(24493,'安定镇','101',1853),(24494,'三市镇','102',1853),(24495,'加义镇','103',1853),(24496,'长寿镇','104',1853),(24497,'龙门镇','105',1853),(24498,'虹桥镇','106',1853),(24499,'南江镇','107',1853),(24500,'梅仙镇','108',1853),(24501,'浯口镇','109',1853),(24502,'瓮江镇','110',1853),(24503,'伍市镇','111',1853),(24504,'向家镇','112',1853),(24505,'童市镇','113',1853),(24506,'岑川镇','114',1853),(24507,'三阳乡','200',1853),(24508,'思村乡','201',1853),(24509,'咏生乡','202',1853),(24510,'黄金洞乡','203',1853),(24511,'南桥乡','204',1853),(24512,'木金乡','205',1853),(24513,'大坪乡','206',1853),(24514,'冬塔乡','207',1853),(24515,'板江乡','208',1853),(24516,'大洲乡','209',1853),(24517,'三墩乡','210',1853),(24518,'余坪乡','211',1853),(24519,'城关镇','100',1854),(24520,'汨罗镇','101',1854),(24521,'新市镇','102',1854),(24522,'古培镇','103',1854),(24523,'白水镇','104',1854),(24524,'川山坪镇','105',1854),(24525,'高家坊镇','106',1854),(24526,'弼时镇','107',1854),(24527,'李家段镇','108',1854),(24528,'黄柏镇','109',1854),(24529,'长乐镇','110',1854),(24530,'大荆镇','111',1854),(24531,'桃林寺镇','112',1854),(24532,'三江镇','113',1854),(24533,'范家园镇','114',1854),(24534,'沙溪镇','115',1854),(24535,'营田镇','116',1854),(24536,'河市镇','117',1854),(24537,'屈子祠镇','118',1854),(24538,'城郊乡','200',1854),(24539,'红花乡','201',1854),(24540,'黄市乡','202',1854),(24541,'玉池乡','203',1854),(24542,'天井乡','205',1854),(24543,'智峰乡','206',1854),(24544,'古仑乡','208',1854),(24545,'火天乡','209',1854),(24546,'新塘乡','210',1854),(24547,'白塘乡','211',1854),(24548,'磊石乡','214',1854),(24549,'八景乡','215',1854),(24550,'黄金乡','216',1854),(24551,'琴棋乡','217',1854),(24552,'凤凰乡','218',1854),(24553,'原种场','401',1854),(24554,'范家园茶叶示范场','402',1854),(24555,'长安街道办事处','001',1855),(24556,'桥东街道办事处','002',1855),(24557,'桃矿街道办事处','003',1855),(24558,'忠防镇','101',1855),(24559,'白云镇','102',1855),(24560,'聂市镇','103',1855),(24561,'源潭镇','104',1855),(24562,'江南镇','105',1855),(24563,'羊楼司镇','106',1855),(24564,'桃林镇','107',1855),(24565,'长塘镇','108',1855),(24566,'白羊田镇','109',1855),(24567,'詹桥镇','110',1855),(24568,'儒溪镇','111',1855),(24569,'定湖镇','112',1855),(24570,'黄盖镇','113',1855),(24571,'五里牌乡','200',1855),(24572,'乘风乡','201',1855),(24573,'文白乡','202',1855),(24574,'龙源乡','203',1855),(24575,'坦渡乡','204',1855),(24576,'城南乡','205',1855),(24577,'横铺乡','206',1855),(24578,'贺畈乡','207',1855),(24579,'壁山乡','208',1855),(24580,'城东街道','001',1857),(24581,'城南街道','002',1857),(24582,'城西街道','003',1857),(24583,'城北街道','004',1857),(24584,'三岔路街道','005',1857),(24585,'德山街道','006',1857),(24586,'河','100',1857),(24587,'德山镇','101',1857),(24588,'芦荻山乡','200',1857),(24589,'东郊乡','201',1857),(24590,'东江乡','202',1857),(24591,'护城乡','203',1857),(24592,'丹洲乡','204',1857),(24593,'南坪岗乡','205',1857),(24594,'武陵区经济技术开发区','400',1857),(24595,'柳叶湖旅游渡假区','401',1857),(24596,'武陵镇','100',1858),(24597,'蒿子港镇','101',1858),(24598,'中河口镇','102',1858),(24599,'十美堂镇','103',1858),(24600,'牛鼻滩镇','104',1858),(24601,'韩公渡镇','105',1858),(24602,'石公桥镇','106',1858),(24603,'镇德桥镇','107',1858),(24604,'周家店镇','108',1858),(24605,'大龙站镇','109',1858),(24606,'双桥坪镇','110',1858),(24607,'灌溪镇','111',1858),(24608,'蔡家岗镇','112',1858),(24609,'斗姆湖镇','113',1858),(24610,'草坪镇','114',1858),(24611,'石门桥镇','115',1858),(24612,'谢家铺镇','116',1858),(24613,'黄土店镇','117',1858),(24614,'尧天坪镇','118',1858),(24615,'港二口镇','119',1858),(24616,'雷公庙镇','120',1858),(24617,'石板滩镇','121',1858),(24618,'黄珠洲乡','200',1858),(24619,'黑山嘴乡','201',1858),(24620,'白鹤山乡','202',1858),(24621,'长岭岗乡','203',1858),(24622,'许家桥回族维吾尔族乡','204',1858),(24623,'丁家港乡','205',1858),(24624,'钱家坪乡','206',1858),(24625,'唐家铺乡','207',1858),(24626,'沧山乡','208',1858),(24627,'长茅岭乡','209',1858),(24628,'逆江坪乡','210',1858),(24629,'鼎城区园艺场','500',1858),(24630,'特种养殖场','501',1858),(24631,'花岩溪林场','502',1858),(24632,'贺家山原种场','503',1858),(24633,'西洞庭农场','504',1858),(24634,'城关镇','100',1859),(24635,'大鲸港镇','101',1859),(24636,'黄山头镇','102',1859),(24637,'三岔河镇','103',1859),(24638,'官','104',1859),(24639,'下渔口镇','105',1859),(24640,'陈家嘴镇','106',1859),(24641,'焦圻镇','107',1859),(24642,'安猷乡','200',1859),(24643,'安障乡','201',1859),(24644,'安昌乡','202',1859),(24645,'安宏乡','203',1859),(24646,'安生乡','204',1859),(24647,'安全乡','205',1859),(24648,'安福乡','206',1859),(24649,'安凝乡','207',1859),(24650,'安丰乡','208',1859),(24651,'安裕乡','209',1859),(24652,'安康乡','210',1859),(24653,'安德乡','211',1859),(24654,'蒋家嘴镇','101',1860),(24655,'岩汪湖镇','102',1860),(24656,'坡头镇','103',1860),(24657,'酉港镇','104',1860),(24658,'洲口镇','105',1860),(24659,'罐头嘴镇','106',1860),(24660,'沧港镇','107',1860),(24661,'朱家铺镇','108',1860),(24662,'太子庙镇','109',1860),(24663,'毓德铺镇','110',1860),(24664,'崔家桥镇','111',1860),(24665,'军山铺镇','112',1860),(24666,'百禄桥镇','113',1860),(24667,'西湖镇','114',1860),(24668,'洋淘湖镇','115',1860),(24669,'龙阳镇','116',1860),(24670,'周文庙乡','201',1860),(24671,'鸭子港乡','202',1860),(24672,'文蔚乡','203',1860),(24673,'新兴乡','204',1860),(24674,'聂家桥乡','205',1860),(24675,'毛家滩回族维吾尔族乡','206',1860),(24676,'丰家铺乡','207',1860),(24677,'东岳庙乡','208',1860),(24678,'岩嘴乡','209',1860),(24679,'株木山乡','210',1860),(24680,'三和乡','211',1860),(24681,'龙潭桥乡','212',1860),(24682,'月明潭乡','213',1860),(24683,'大南湖乡','216',1860),(24684,'澧阳镇','100',1861),(24685,'张公庙镇','101',1861),(24686,'小渡口镇','102',1861),(24687,'梦溪镇','103',1861),(24688,'复兴厂镇','104',1861),(24689,'盐井镇','105',1861),(24690,'雷公塔镇','106',1861),(24691,'大堰','107',1861),(24692,'王家厂镇','108',1861),(24693,'金罗镇','109',1861),(24694,'码头铺镇','110',1861),(24695,'方石坪镇','111',1861),(24696,'甘溪滩镇','112',1861),(24697,'火连坡镇','113',1861),(24698,'九垸乡','200',1861),(24699,'官垸乡','201',1861),(24700,'永丰乡','202',1861),(24701,'如东乡','203',1861),(24702,'澧澹乡','204',1861),(24703,'澧南乡','205',1861),(24704,'澧东乡','206',1861),(24705,'涔南乡','207',1861),(24706,'大坪乡','208',1861),(24707,'道河乡','209',1861),(24708,'双龙乡','210',1861),(24709,'宜万乡','211',1861),(24710,'车溪乡','212',1861),(24711,'中武乡','213',1861),(24712,'闸口乡','214',1861),(24713,'洞市乡','215',1861),(24714,'杨家坊乡','216',1861),(24715,'太青乡','217',1861),(24716,'安福镇','100',1862),(24717,'合口镇','101',1862),(24718,'新安镇','102',1862),(24719,'佘市桥镇','103',1862),(24720,'太浮镇','104',1862),(24721,'四新岗镇','105',1862),(24722,'停弦渡镇','106',1862),(24723,'修梅镇','107',1862),(24724,'杉板乡','200',1862),(24725,'文家乡','201',1862),(24726,'陈二乡','202',1862),(24727,'柏枝乡','203',1862),(24728,'烽火乡','204',1862),(24729,'望城乡','205',1862),(24730,'杨板乡','206',1862),(24731,'官亭乡','207',1862),(24732,'九里乡','208',1862),(24733,'漳江镇','100',1863),(24734,'陬市镇','101',1863),(24735,'盘塘镇','102',1863),(24736,'热市镇','103',1863),(24737,'黄石镇','104',1863),(24738,'漆河镇','105',1863),(24739,'理公港镇','106',1863),(24740,'观音寺镇','107',1863),(24741,'龙潭镇','108',1863),(24742,'三阳港镇','109',1863),(24743,'剪市镇','110',1863),(24744,'茶庵铺镇','111',1863),(24745,'西安镇','112',1863),(24746,'沙坪镇','113',1863),(24747,'桃花源镇','114',1863),(24748,'架桥镇','115',1863),(24749,'马鬃岭镇','116',1863),(24750,'凌津滩镇','117',1863),(24751,'青林乡','200',1863),(24752,'车湖垸乡','201',1863),(24753,'枫树维吾尔族回族乡','202',1863),(24754,'木塘垸乡','203',1863),(24755,'双溪口乡','206',1863),(24756,'郝坪乡','207',1863),(24757,'九溪乡','208',1863),(24758,'黄甲铺乡','209',1863),(24759,'钟家铺乡','210',1863),(24760,'牛车河乡','211',1863),(24761,'佘家坪乡','212',1863),(24762,'太平桥乡','213',1863),(24763,'浯溪河乡','214',1863),(24764,'深水港乡','215',1863),(24765,'泥窝潭乡','216',1863),(24766,'兴隆街乡','218',1863),(24767,'太平铺乡','219',1863),(24768,'牯牛山乡','220',1863),(24769,'杨溪桥乡','221',1863),(24770,'寺坪乡','222',1863),(24771,'郑家驿乡','223',1863),(24772,'芦花潭乡','224',1863),(24773,'楚江镇','100',1864),(24774,'蒙泉镇','101',1864),(24775,'夹山镇','102',1864),(24776,'易家渡镇','103',1864),(24777,'新关镇','104',1864),(24778,'皂市镇','105',1864),(24779,'维新镇','106',1864),(24780,'太平镇','107',1864),(24781,'磨市镇','108',1864),(24782,'壶瓶山镇','109',1864),(24783,'南北镇','110',1864),(24784,'二都乡','200',1864),(24785,'新铺乡','201',1864),(24786,'白云乡','202',1864),(24787,'三圣乡','203',1864),(24788,'子良乡','204',1864),(24789,'所街乡','205',1864),(24790,'雁池乡','206',1864),(24791,'罗坪乡','207',1864),(24792,'秀坪园艺场','500',1864),(24793,'经济开发区','501',1864),(24794,'东山峰农场','502',1864),(24795,'大同山林场','503',1864),(24796,'白云山林场','504',1864),(24797,'洛浦寺林场','505',1864),(24798,'夹山管理处','506',1864),(24799,'三洲驿街道','001',1865),(24800,'汪家桥街道','002',1865),(24801,'襄阳街街道','003',1865),(24802,'金鱼岭街道','004',1865),(24803,'新洲镇','100',1865),(24804,'渡口镇','101',1865),(24805,'保和堤镇','102',1865),(24806,'白衣镇','103',1865),(24807,'灵泉乡','202',1865),(24808,'棠华乡','203',1865),(24809,'李家铺乡','204',1865),(24810,'涔澹农场','500',1865),(24811,'永定街道','001',1867),(24812,'大庸桥街道','002',1867),(24813,'西溪坪街道','003',1867),(24814,'官黎坪街道','004',1867),(24815,'崇文街道','005',1867),(24816,'南庄坪街道','006',1867),(24817,'新桥镇','100',1867),(24818,'温塘镇','101',1867),(24819,'教字垭镇','102',1867),(24820,'大坪镇','103',1867),(24821,'沅古坪镇','104',1867),(24822,'尹家溪镇','105',1867),(24823,'后坪镇','106',1867),(24824,'阳湖坪镇','107',1867),(24825,'王家坪镇','108',1867),(24826,'三家馆乡','201',1867),(24827,'沙堤乡','202',1867),(24828,'枫香岗乡','203',1867),(24829,'合作桥乡','204',1867),(24830,'双溪桥乡','205',1867),(24831,'谢家垭乡','206',1867),(24832,'青安坪乡','207',1867),(24833,'罗塔坪乡','208',1867),(24834,'罗水乡','209',1867),(24835,'桥头乡','210',1867),(24836,'三岔乡','211',1867),(24837,'四都坪乡','212',1867),(24838,'茅溪水库管理所','400',1867),(24839,'猪石头林场','401',1867),(24840,'原种场','404',1867),(24841,'旱科所','405',1867),(24842,'军地坪街道办事处','001',1868),(24843,'天子山镇','100',1868),(24844,'索溪峪土家族乡','200',1868),(24845,'协合乡','201',1868),(24846,'中湖乡','202',1868),(24847,'张家界国家森林公园管理处','450',1868),(24848,'零阳镇','100',1869),(24849,'岩泊渡镇','101',1869),(24850,'溪口镇','102',1869),(24851,'东岳观镇','103',1869),(24852,'通津铺镇','104',1869),(24853,'杉木桥镇','105',1869),(24854,'象市镇','106',1869),(24855,'江垭镇','107',1869),(24856,'苗市镇','108',1869),(24857,'零溪镇','109',1869),(24858,'高桥镇','110',1869),(24859,'龙潭河镇','111',1869),(24860,'广福桥镇','112',1869),(24861,'南山坪乡','200',1869),(24862,'宜冲桥乡','201',1869),(24863,'洞溪乡','202',1869),(24864,'金坪乡','203',1869),(24865,'景龙桥乡','204',1869),(24866,'二坊坪乡','205',1869),(24867,'三合口乡','206',1869),(24868,'国太桥乡','207',1869),(24869,'庄塌乡','208',1869),(24870,'杨柳铺乡','209',1869),(24871,'朝阳乡','210',1869),(24872,'三官寺土家族乡','211',1869),(24873,'高峰土家族乡','212',1869),(24874,'许家坊土家族乡','213',1869),(24875,'金岩土家族乡','214',1869),(24876,'赵家岗土家族乡','215',1869),(24877,'甘堰土家族乡','216',1869),(24878,'阳和土家族乡','217',1869),(24879,'澧源镇','100',1870),(24880,'瑞塔铺镇','101',1870),(24881,'官地坪镇','102',1870),(24882,'凉水口镇','103',1870),(24883,'龙潭坪镇','104',1870),(24884,'五道水镇','105',1870),(24885,'陈家河镇','106',1870),(24886,'廖家村镇','107',1870),(24887,'利福塔镇','108',1870),(24888,'空壳树乡','200',1870),(24889,'汨湖乡','201',1870),(24890,'竹叶坪乡','202',1870),(24891,'走马坪白族乡','203',1870),(24892,'人潮溪乡','204',1870),(24893,'西莲乡','205',1870),(24894,'白石乡','206',1870),(24895,'刘家坪白族乡','207',1870),(24896,'芙蓉桥白族乡','208',1870),(24897,'麦地坪白族乡','209',1870),(24898,'马合口白族乡','210',1870),(24899,'长潭坪乡','211',1870),(24900,'淋溪河乡','212',1870),(24901,'洪家关乡','213',1870),(24902,'桥自湾乡','214',1870),(24903,'谷罗山乡','215',1870),(24904,'沙塔坪乡','216',1870),(24905,'苦竹坪乡','217',1870),(24906,'四方溪乡','218',1870),(24907,'芭茅溪乡','219',1870),(24908,'细沙坪乡','220',1870),(24909,'八大公山乡','221',1870),(24910,'蹇家坡乡','222',1870),(24911,'岩屋口乡','223',1870),(24912,'河口乡','224',1870),(24913,'上河溪乡','225',1870),(24914,'两河口乡','226',1870),(24915,'打鼓泉乡','227',1870),(24916,'上洞街乡','228',1870),(24917,'天星山林场','500',1870),(24918,'大码头街道','005',1872),(24919,'汽车路街道','006',1872),(24920,'迎风桥镇','102',1872),(24921,'沙头镇','104',1872),(24922,'茈湖口镇','105',1872),(24923,'长春镇','106',1872),(24924,'新桥河镇','107',1872),(24925,'张家塞乡','203',1872),(24926,'赫山街道','001',1873),(24927,'桃花仑街道','002',1873),(24928,'金银山街道','003',1873),(24929,'朝阳街道','005',1873),(24930,'会龙山街道','006',1873),(24931,'八字哨镇','101',1873),(24932,'泉交河镇','103',1873),(24933,'欧江岔镇','104',1873),(24934,'沧水铺镇','105',1873),(24935,'岳家桥镇','107',1873),(24936,'谢林港镇','109',1873),(24937,'新市渡镇','110',1873),(24938,'兰溪镇','111',1873),(24939,'龙光桥镇','112',1873),(24940,'衡龙桥镇','113',1873),(24941,'泥江口镇','114',1873),(24942,'牌口乡','202',1873),(24943,'笔架山乡','209',1873),(24944,'龙岭工业园','402',1873),(24945,'明山头镇','102',1874),(24946,'青树嘴镇','103',1874),(24947,'厂窖镇','106',1874),(24948,'武圣宫镇','107',1874),(24949,'河坝镇','121',1874),(24950,'金盆镇','123',1874),(24951,'北洲子镇','124',1874),(24952,'南洲镇','125',1874),(24953,'华阁镇','126',1874),(24954,'茅草街镇','127',1874),(24955,'三仙湖镇','128',1874),(24956,'麻河口镇','129',1874),(24957,'千山红镇','130',1874),(24958,'乌嘴乡','201',1874),(24959,'中鱼口乡','212',1874),(24960,'浪拔湖乡','213',1874),(24961,'大通湖渔场','403',1874),(24962,'修山镇','101',1875),(24963,'鸬鹚渡镇','103',1875),(24964,'石牛江镇','107',1875),(24965,'牛田镇','108',1875),(24966,'松木塘镇','109',1875),(24967,'桃花江镇','112',1875),(24968,'灰山港镇','113',1875),(24969,'武潭镇','114',1875),(24970,'马迹塘镇','115',1875),(24971,'三堂街镇','116',1875),(24972,'大栗港镇','117',1875),(24973,'高桥乡','203',1875),(24974,'沾溪乡','205',1875),(24975,'浮丘山乡','212',1875),(24976,'板溪林场','400',1875),(24977,'石井头林场','401',1875),(24978,'浮邱山林场','402',1875),(24979,'清塘铺镇','101',1876),(24980,'仙溪镇','103',1876),(24981,'长塘镇','105',1876),(24982,'小淹镇','106',1876),(24983,'羊角塘镇','108',1876),(24984,'冷市镇','109',1876),(24985,'奎溪镇','111',1876),(24986,'烟溪镇','112',1876),(24987,'渠江镇','113',1876),(24988,'平口镇','114',1876),(24989,'柘溪镇','115',1876),(24990,'乐安镇','116',1876),(24991,'滔溪镇','117',1876),(24992,'梅城镇','118',1876),(24993,'大福镇','119',1876),(24994,'马路镇','120',1876),(24995,'东坪镇','121',1876),(24996,'江南镇','122',1876),(24997,'高明乡','200',1876),(24998,'龙塘乡','206',1876),(24999,'田庄乡','209',1876),(25000,'南金乡','211',1876),(25001,'古楼乡','212',1876),(25002,'琼湖街道办事处','006',1877),(25003,'庆云山街道办事处','007',1877),(25004,'四季红镇','102',1877),(25005,'泗湖山镇','105',1877),(25006,'南嘴镇','107',1877),(25007,'新湾镇','108',1877),(25008,'茶盘洲镇','110',1877),(25009,'南大膳镇','112',1877),(25010,'黄茅洲镇','113',1877),(25011,'草尾镇','114',1877),(25012,'阳罗洲镇','115',1877),(25013,'共华镇','116',1877),(25014,'三眼塘镇','117',1877),(25015,'万子湖乡','209',1877),(25016,'南洞庭芦苇场','401',1877),(25017,'漉湖芦苇场','402',1877),(25018,'人民路街道办事处','001',1879),(25019,'北湖街道办事处','002',1879),(25020,'燕泉街道办事处','003',1879),(25021,'下湄桥街道办事处','004',1879),(25022,'石盖塘镇','100',1879),(25023,'华塘镇','101',1879),(25024,'鲁塘镇','102',1879),(25025,'郴江镇','103',1879),(25026,'万华岩镇','104',1879),(25027,'江口乡','200',1879),(25028,'市郊乡','201',1879),(25029,'大塘瑶族乡','202',1879),(25030,'同和乡','203',1879),(25031,'保和乡','204',1879),(25032,'月峰瑶族乡','205',1879),(25033,'芙蓉乡','206',1879),(25034,'永春乡','207',1879),(25035,'南溪乡','208',1879),(25036,'苏仙岭街道','001',1880),(25037,'南塔街道','002',1880),(25038,'桥口镇','100',1880),(25039,'白露塘镇','101',1880),(25040,'良田镇','102',1880),(25041,'栖凤渡镇','103',1880),(25042,'坳上镇','104',1880),(25043,'许家洞镇','105',1880),(25044,'白鹿洞镇','106',1880),(25045,'五里牌镇','107',1880),(25046,'岗脚乡','200',1880),(25047,'廖王坪乡','201',1880),(25048,'马头岭乡','202',1880),(25049,'荷叶坪乡','203',1880),(25050,'塘溪乡','204',1880),(25051,'太平乡','205',1880),(25052,'邓家塘乡','206',1880),(25053,'廖家湾乡','207',1880),(25054,'大奎上乡','208',1880),(25055,'城关镇','100',1881),(25056,'黄沙坪镇','101',1881),(25057,'仁义镇','102',1881),(25058,'太和镇','103',1881),(25059,'洋市镇','104',1881),(25060,'和平镇','105',1881),(25061,'流峰镇','106',1881),(25062,'塘市镇','107',1881),(25063,'莲塘镇','108',1881),(25064,'飞仙镇','109',1881),(25065,'荷叶镇','110',1881),(25066,'方元镇','111',1881),(25067,'樟市镇','112',1881),(25068,'敖泉镇','113',1881),(25069,'城郊乡','200',1881),(25070,'清和乡','201',1881),(25071,'正和乡','202',1881),(25072,'燕塘乡','203',1881),(25073,'浩塘乡','204',1881),(25074,'团结乡','205',1881),(25075,'东城乡','206',1881),(25076,'雷坪乡','207',1881),(25077,'青兰乡','208',1881),(25078,'桥市乡','209',1881),(25079,'银河乡','211',1881),(25080,'樟木乡','212',1881),(25081,'板桥乡','213',1881),(25082,'华山瑶族乡','214',1881),(25083,'四里乡','215',1881),(25084,'六合乡','216',1881),(25085,'泗洲乡','217',1881),(25086,'欧阳海乡','218',1881),(25087,'光明乡','219',1881),(25088,'白水乡','220',1881),(25089,'杨柳瑶族乡','221',1881),(25090,'华泉乡','222',1881),(25091,'古楼乡','223',1881),(25092,'十字乡','224',1881),(25093,'余田乡','225',1881),(25094,'城关镇','100',1882),(25095,'白石渡镇','101',1882),(25096,'杨梅山镇','102',1882),(25097,'瑶岗仙镇','103',1882),(25098,'梅田镇','104',1882),(25099,'麻田镇','105',1882),(25100,'黄沙镇','106',1882),(25101,'迎春镇','107',1882),(25102,'一六镇','108',1882),(25103,'栗源镇','109',1882),(25104,'岩泉镇','110',1882),(25105,'城南乡','200',1882),(25106,'浆水乡','201',1882),(25107,'长村村乡','202',1882),(25108,'东风乡','203',1882),(25109,'天塘乡','204',1882),(25110,'莽山瑶族乡','205',1882),(25111,'笆篱乡','206',1882),(25112,'白沙圩乡','207',1882),(25113,'关溪乡','208',1882),(25114,'长策乡','209',1882),(25115,'里田乡','210',1882),(25116,'新华乡','211',1882),(25117,'赤石乡','212',1882),(25118,'平和乡','213',1882),(25119,'太平里乡','214',1882),(25120,'沙坪乡','215',1882),(25121,'城关镇','100',1883),(25122,'马田镇','101',1883),(25123,'湘阴渡镇','102',1883),(25124,'塘门口镇','103',1883),(25125,'金龟镇','104',1883),(25126,'柏林镇','105',1883),(25127,'鲤鱼塘镇','106',1883),(25128,'油市镇','107',1883),(25129,'城郊乡','200',1883),(25130,'碧塘乡','201',1883),(25131,'高亭乡','202',1883),(25132,'洋塘乡','203',1883),(25133,'复和乡','204',1883),(25134,'油麻乡','205',1883),(25135,'三塘乡','206',1883),(25136,'悦来乡','207',1883),(25137,'黄泥乡','208',1883),(25138,'香梅乡','209',1883),(25139,'樟树乡','210',1883),(25140,'太和乡','211',1883),(25141,'洞口乡','212',1883),(25142,'千冲乡','213',1883),(25143,'大布江乡','214',1883),(25144,'龙形市乡','215',1883),(25145,'七甲乡','216',1883),(25146,'城关镇','100',1884),(25147,'车头镇','101',1884),(25148,'塘村村镇','102',1884),(25149,'袁家镇','103',1884),(25150,'行廊镇','104',1884),(25151,'肖家镇','105',1884),(25152,'龙潭镇','106',1884),(25153,'石桥镇','107',1884),(25154,'泮头乡','200',1884),(25155,'普满乡','201',1884),(25156,'田心乡','202',1884),(25157,'坦坪乡','203',1884),(25158,'广发乡','204',1884),(25159,'莲荷乡','205',1884),(25160,'盘江乡','206',1884),(25161,'钟水乡','207',1884),(25162,'石羔乡','208',1884),(25163,'城关镇','100',1885),(25164,'金江镇','101',1885),(25165,'香花岭镇','102',1885),(25166,'岚桥镇','103',1885),(25167,'武水镇','104',1885),(25168,'双溪乡','200',1885),(25169,'南强乡','201',1885),(25170,'广宜乡','202',1885),(25171,'同益乡','203',1885),(25172,'汾市乡','204',1885),(25173,'土地乡','205',1885),(25174,'水东乡','206',1885),(25175,'接龙乡','207',1885),(25176,'花塘乡','208',1885),(25177,'楚江乡','209',1885),(25178,'武源乡','210',1885),(25179,'万水乡','211',1885),(25180,'麦市乡','212',1885),(25181,'三合乡','213',1885),(25182,'镇南乡','214',1885),(25183,'大冲乡','215',1885),(25184,'西山瑶族乡','216',1885),(25185,'城关镇','100',1886),(25186,'小垣瑶族镇','101',1886),(25187,'热水镇','102',1886),(25188,'土桥镇','103',1886),(25189,'三星镇','104',1886),(25190,'暖水镇','105',1886),(25191,'大坪镇','106',1886),(25192,'三江口瑶族镇','107',1886),(25193,'城郊乡','200',1886),(25194,'附城乡','201',1886),(25195,'井坡乡','202',1886),(25196,'文明乡','203',1886),(25197,'盈洞瑶族乡','204',1886),(25198,'岭秀瑶族乡','205',1886),(25199,'田庄乡','206',1886),(25200,'南洞乡','207',1886),(25201,'永丰乡','208',1886),(25202,'濠头乡','209',1886),(25203,'益将乡','210',1886),(25204,'集龙乡','211',1886),(25205,'马桥乡','212',1886),(25206,'外沙乡','213',1886),(25207,'延寿瑶族乡','214',1886),(25208,'城关镇','100',1887),(25209,'沙田镇','101',1887),(25210,'清泉镇','102',1887),(25211,'桥头乡','200',1887),(25212,'寒口乡','201',1887),(25213,'黄洞乡','202',1887),(25214,'三洞乡','203',1887),(25215,'增口乡','204',1887),(25216,'寨前乡','205',1887),(25217,'流源乡','206',1887),(25218,'大塘乡','207',1887),(25219,'新坊乡','208',1887),(25220,'普乐乡','209',1887),(25221,'东洛乡','210',1887),(25222,'贝溪乡','211',1887),(25223,'大水乡','212',1887),(25224,'青山乡','213',1887),(25225,'四都乡','214',1887),(25226,'宋坪林场','400',1887),(25227,'城关镇','100',1888),(25228,'安平镇','101',1888),(25229,'龙海镇','102',1888),(25230,'清溪镇','103',1888),(25231,'关王镇','104',1888),(25232,'灵官镇','105',1888),(25233,'排山乡','200',1888),(25234,'龙市乡','201',1888),(25235,'军山乡','202',1888),(25236,'禾市乡','203',1888),(25237,'渡口乡','204',1888),(25238,'华王乡','205',1888),(25239,'牌楼乡','206',1888),(25240,'平背乡','207',1888),(25241,'坪上乡','208',1888),(25242,'承坪乡','209',1888),(25243,'竹山乡','210',1888),(25244,'豪山乡','211',1888),(25245,'羊脑乡','212',1888),(25246,'新洲乡','213',1888),(25247,'洋际乡','214',1888),(25248,'唐洞街道','001',1889),(25249,'滁口镇','100',1889),(25250,'鲤鱼江镇','101',1889),(25251,'三都镇','102',1889),(25252,'蓼江镇','103',1889),(25253,'七里镇','104',1889),(25254,'兴宁镇','105',1889),(25255,'州门司镇','106',1889),(25256,'青腰镇','107',1889),(25257,'黄草镇','108',1889),(25258,'东江镇','109',1889),(25259,'香花乡','200',1889),(25260,'高码乡','201',1889),(25261,'东坪乡','202',1889),(25262,'团结瑶族乡','203',1889),(25263,'碑记乡','206',1889),(25264,'连坪瑶族乡','207',1889),(25265,'何家山乡','208',1889),(25266,'坪石乡','209',1889),(25267,'彭市乡','210',1889),(25268,'汤市乡','211',1889),(25269,'烟坪乡','212',1889),(25270,'兰市乡','213',1889),(25271,'波水乡','214',1889),(25272,'皮石乡','215',1889),(25273,'清江乡','216',1889),(25274,'龙溪乡','217',1889),(25275,'白廊乡','218',1889),(25276,'朝阳街道','001',1891),(25277,'南津渡街道','002',1891),(25278,'七里店街道','003',1891),(25279,'徐家井街道','004',1891),(25280,'水口山镇','101',1891),(25281,'珠山镇','102',1891),(25282,'黄田铺镇','103',1891),(25283,'富家桥镇','104',1891),(25284,'菱角塘镇','105',1891),(25285,'邮亭圩镇','106',1891),(25286,'接履桥镇','107',1891),(25287,'石岩头镇','108',1891),(25288,'大庆坪乡','200',1891),(25289,'梳子铺乡','201',1891),(25290,'石山脚乡','202',1891),(25291,'凼底乡','203',1891),(25292,'梅湾街道','001',1892),(25293,'菱角山街道','002',1892),(25294,'肖家园街道','003',1892),(25295,'杨家桥街道','004',1892),(25296,'梧桐街道','005',1892),(25297,'凤凰街道','006',1892),(25298,'花桥街镇','101',1892),(25299,'普利桥镇','102',1892),(25300,'牛角坝镇','103',1892),(25301,'高溪市镇','104',1892),(25302,'黄阳司镇','105',1892),(25303,'上岭桥镇','106',1892),(25304,'竹山桥镇','107',1892),(25305,'伊塘镇','108',1892),(25306,'岚角山镇','109',1892),(25307,'蔡市镇','110',1892),(25308,'仁湾镇','111',1892),(25309,'珊瑚乡','200',1892),(25310,'杨村甸乡','201',1892),(25311,'马坪农业开发区','401',1892),(25312,'工业园区','402',1892),(25313,'浯溪镇','100',1893),(25314,'观音滩镇','101',1893),(25315,'茅竹镇','102',1893),(25316,'大忠桥镇','103',1893),(25317,'三口塘镇','104',1893),(25318,'肖家村镇','105',1893),(25319,'八宝镇','106',1893),(25320,'白水镇','107',1893),(25321,'黄泥塘镇','108',1893),(25322,'进宝塘镇','109',1893),(25323,'潘市镇','110',1893),(25324,'梅溪镇','111',1893),(25325,'羊角塘镇','112',1893),(25326,'下马渡镇','113',1893),(25327,'七里桥镇','114',1893),(25328,'大村甸镇','115',1893),(25329,'黎家坪镇','116',1893),(25330,'文富市镇','117',1893),(25331,'文明镇','118',1893),(25332,'龚家坪镇','119',1893),(25333,'金洞镇','120',1893),(25334,'小金洞乡','200',1893),(25335,'晒北滩瑶族乡','201',1893),(25336,'凤凰乡','202',1893),(25337,'白果市乡','203',1893),(25338,'石鼓源乡','204',1893),(25339,'上司源乡','205',1893),(25340,'原种场','401',1893),(25341,'畜牧场','402',1893),(25342,'挂榜山林场','403',1893),(25343,'大江林场','404',1893),(25344,'内下林场','405',1893),(25345,'白牙市镇','100',1894),(25346,'大庙口镇','101',1894),(25347,'紫溪市镇','102',1894),(25348,'横塘镇','103',1894),(25349,'石期市镇','104',1894),(25350,'井头圩镇','105',1894),(25351,'端桥铺镇','106',1894),(25352,'鹿马桥镇','107',1894),(25353,'芦洪市镇','108',1894),(25354,'新圩江镇','109',1894),(25355,'花桥镇','110',1894),(25356,'大盛镇','111',1894),(25357,'南桥镇','112',1894),(25358,'大江口乡','200',1894),(25359,'川岩乡','201',1894),(25360,'水岭乡','202',1894),(25361,'舜皇山国家森林公园','400',1894),(25362,'黄泥洞林场','401',1894),(25363,'泷泊镇','100',1895),(25364,'江村镇','101',1895),(25365,'五里牌镇','102',1895),(25366,'平福头乡','200',1895),(25367,'尚仁里乡','201',1895),(25368,'永江乡','202',1895),(25369,'何家洞乡','203',1895),(25370,'麻江乡','204',1895),(25371,'茶林乡','205',1895),(25372,'塘底乡','206',1895),(25373,'上梧江瑶族乡','207',1895),(25374,'理家坪乡','208',1895),(25375,'双牌打鼓坪林场','400',1895),(25376,'双牌五星岭林场','401',1895),(25377,'双牌阳明山林场','402',1895),(25378,'道江镇','100',1896),(25379,'梅花镇','101',1896),(25380,'寿雁镇','102',1896),(25381,'仙子脚镇','103',1896),(25382,'清塘镇','104',1896),(25383,'祥霖铺镇','105',1896),(25384,'蚣坝镇','106',1896),(25385,'四马桥镇','107',1896),(25386,'白马渡镇','108',1896),(25387,'富塘乡','200',1896),(25388,'乐福堂乡','201',1896),(25389,'桥头乡','202',1896),(25390,'营江乡','203',1896),(25391,'万家庄乡','204',1896),(25392,'新车乡','205',1896),(25393,'上关乡','206',1896),(25394,'白芒铺乡','207',1896),(25395,'柑子园乡','208',1896),(25396,'东门乡','209',1896),(25397,'审章塘瑶族乡','210',1896),(25398,'井塘瑶族乡','211',1896),(25399,'横岭瑶族乡','212',1896),(25400,'洪塘营瑶族乡','213',1896),(25401,'道县月岩林场','400',1896),(25402,'道县桥头林场','401',1896),(25403,'道县大坪铺农场','402',1896),(25404,'消浦镇','100',1897),(25405,'上江圩镇','101',1897),(25406,'允山镇','102',1897),(25407,'夏层铺镇','103',1897),(25408,'桃川镇','104',1897),(25409,'粗石江镇','105',1897),(25410,'松柏瑶族乡','200',1897),(25411,'黄甲岭乡','201',1897),(25412,'千家峒瑶族乡','202',1897),(25413,'兰溪瑶族乡','203',1897),(25414,'源口瑶族乡','204',1897),(25415,'舜陵镇','100',1898),(25416,'天堂镇','101',1898),(25417,'水市镇','102',1898),(25418,'湾井镇','103',1898),(25419,'冷水镇','104',1898),(25420,'太平镇','105',1898),(25421,'禾亭镇','106',1898),(25422,'仁和镇','107',1898),(25423,'中和镇','108',1898),(25424,'柏家坪镇','109',1898),(25425,'清水桥镇','110',1898),(25426,'鲤溪镇','111',1898),(25427,'九疑瑶族乡','200',1898),(25428,'保安乡','201',1898),(25429,'荒塘瑶族乡','202',1898),(25430,'棉花坪瑶族乡','203',1898),(25431,'桐木漯瑶族乡','204',1898),(25432,'塔峰镇','100',1899),(25433,'竹管寺镇','101',1899),(25434,'毛俊镇','102',1899),(25435,'楠市镇','103',1899),(25436,'所城镇','104',1899),(25437,'新圩镇','105',1899),(25438,'汇源瑶族乡','200',1899),(25439,'犁头瑶族乡','201',1899),(25440,'浆洞瑶族乡','202',1899),(25441,'紫良瑶族乡','203',1899),(25442,'大桥瑶族乡','204',1899),(25443,'荆竹瑶族乡','205',1899),(25444,'祠堂圩乡','206',1899),(25445,'土市乡','207',1899),(25446,'太平圩乡','208',1899),(25447,'蓝山荆竹林场','400',1899),(25448,'蓝山浆洞林场','401',1899),(25449,'蓝山南岭林场','402',1899),(25450,'蓝山原种场','403',1899),(25451,'蓝山黄毛岭茶场','404',1899),(25452,'龙泉镇','100',1900),(25453,'金陵镇','101',1900),(25454,'骥村镇','102',1900),(25455,'枧头镇','103',1900),(25456,'新圩镇','104',1900),(25457,'石羊镇','105',1900),(25458,'新隆镇','106',1900),(25459,'莲花乡','200',1900),(25460,'冷水井乡','201',1900),(25461,'门楼下瑶族乡','202',1900),(25462,'茂家乡','203',1900),(25463,'毛里乡','204',1900),(25464,'十字乡','205',1900),(25465,'金盆圩乡','206',1900),(25466,'三井乡','207',1900),(25467,'陶岭乡','208',1900),(25468,'高山乡','209',1900),(25469,'知市坪乡','210',1900),(25470,'大坪塘乡','211',1900),(25471,'沱江镇','100',1901),(25472,'桥头铺镇','101',1901),(25473,'东田镇','102',1901),(25474,'大路铺镇','103',1901),(25475,'白芒营镇','104',1901),(25476,'涛圩镇','105',1901),(25477,'河路口镇','106',1901),(25478,'小圩镇','107',1901),(25479,'大圩镇','108',1901),(25480,'水口镇','109',1901),(25481,'码市镇','110',1901),(25482,'界牌乡','200',1901),(25483,'桥市乡','201',1901),(25484,'大石桥乡','202',1901),(25485,'清塘壮族乡','203',1901),(25486,'两岔河乡','204',1901),(25487,'务江乡','205',1901),(25488,'花江乡','206',1901),(25489,'湘江乡','207',1901),(25490,'贝江乡','208',1901),(25491,'未竹口乡','209',1901),(25492,'大锡乡','210',1901),(25493,'江华林业采育场','400',1901),(25494,'城中街道','001',1903),(25495,'城北街道','002',1903),(25496,'红星街道','003',1903),(25497,'迎丰街道','004',1903),(25498,'坨院街道','005',1903),(25499,'黄金坳镇','101',1903),(25500,'鸭嘴岩镇','102',1903),(25501,'盈口乡','201',1903),(25502,'杨村乡','202',1903),(25503,'石门乡','203',1903),(25504,'贺家田乡','204',1903),(25505,'凉亭坳乡','205',1903),(25506,'芦坪乡','206',1903),(25507,'黄岩旅游度假区','400',1903),(25508,'中方镇','100',1904),(25509,'牌楼坳镇','101',1904),(25510,'泸阳镇','102',1904),(25511,'花桥镇','103',1904),(25512,'铜湾镇','104',1904),(25513,'桐木镇','105',1904),(25514,'铁坡镇','106',1904),(25515,'炉亭坳乡','200',1904),(25516,'下坪乡','201',1904),(25517,'聂家村乡','202',1904),(25518,'龙场乡','203',1904),(25519,'铜鼎乡','204',1904),(25520,'新建乡','205',1904),(25521,'袁家乡','206',1904),(25522,'蒋家乡','207',1904),(25523,'新路河乡','208',1904),(25524,'丁家乡','209',1904),(25525,'锦溪乡','211',1904),(25526,'活水乡','212',1904),(25527,'石宝乡','213',1904),(25528,'蒿吉坪瑶族乡','214',1904),(25529,'接龙乡','215',1904),(25530,'麻溪铺镇','102',1905),(25531,'五强溪镇','105',1905),(25532,'沅陵镇','109',1905),(25533,'明溪口镇','110',1905),(25534,'凉水井镇','111',1905),(25535,'七甲坪镇','112',1905),(25536,'筲箕湾镇','113',1905),(25537,'官庄镇','114',1905),(25538,'杜家坪乡','223',1905),(25539,'楠木铺乡','224',1905),(25540,'深溪口乡','229',1905),(25541,'肖家桥乡','230',1905),(25542,'火场土家族乡','234',1905),(25543,'陈家滩乡','238',1905),(25544,'清浪乡','239',1905),(25545,'借母溪乡','245',1905),(25546,'荔溪乡','247',1905),(25547,'大合坪乡','248',1905),(25548,'太常乡','249',1905),(25549,'马底驿乡','250',1905),(25550,'北溶乡','251',1905),(25551,'二酉乡','252',1905),(25552,'盘古乡','253',1905),(25553,'辰阳镇','100',1906),(25554,'孝坪镇','101',1906),(25555,'田湾镇','102',1906),(25556,'火马冲镇','103',1906),(25557,'黄溪口镇','104',1906),(25558,'潭湾镇','105',1906),(25559,'安坪镇','106',1906),(25560,'寺前镇','107',1906),(25561,'船溪乡','200',1906),(25562,'城郊乡','201',1906),(25563,'板桥乡','202',1906),(25564,'长田湾乡','204',1906),(25565,'小龙门乡','205',1906),(25566,'后塘瑶族乡','206',1906),(25567,'苏木溪瑶族乡','207',1906),(25568,'罗子山瑶族乡','208',1906),(25569,'上蒲溪瑶族乡','209',1906),(25570,'仙人湾瑶族乡','210',1906),(25571,'龙头庵乡','211',1906),(25572,'锦滨乡','212',1906),(25573,'石碧乡','213',1906),(25574,'桥头乡','214',1906),(25575,'大水田乡','215',1906),(25576,'桥头溪乡','216',1906),(25577,'石马湾乡','217',1906),(25578,'龙泉岩乡','218',1906),(25579,'修溪乡','219',1906),(25580,'伍家湾乡','220',1906),(25581,'柿溪乡','221',1906),(25582,'谭家场乡','222',1906),(25583,'卢峰镇','100',1907),(25584,'江口镇','101',1907),(25585,'低庄镇','102',1907),(25586,'桥江镇','103',1907),(25587,'龙潭镇','104',1907),(25588,'均坪镇','105',1907),(25589,'观音阁镇','106',1907),(25590,'双井镇','107',1907),(25591,'水东镇','108',1907),(25592,'两丫坪镇','109',1907),(25593,'黄茅园镇','110',1907),(25594,'祖市殿镇','111',1907),(25595,'葛竹坪镇','112',1907),(25596,'谭家湾镇','113',1907),(25597,'小江口乡','201',1907),(25598,'思蒙乡','202',1907),(25599,'木溪乡','203',1907),(25600,'舒溶溪乡','204',1907),(25601,'仲夏乡','205',1907),(25602,'水隘乡','207',1907),(25603,'让家溪乡','208',1907),(25604,'大渭溪乡','209',1907),(25605,'岩家垅乡','210',1907),(25606,'水田庄乡','212',1907),(25607,'油洋乡','213',1907),(25608,'新田乡','214',1907),(25609,'岗东乡','215',1907),(25610,'两江乡','216',1907),(25611,'善溪乡','217',1907),(25612,'桐木溪乡','218',1907),(25613,'小横垅乡','219',1907),(25614,'统溪河乡','220',1907),(25615,'龙王江乡','221',1907),(25616,'陶金坪乡','222',1907),(25617,'中都乡','223',1907),(25618,'沿溪乡','224',1907),(25619,'九溪江乡','225',1907),(25620,'北斗溪乡','226',1907),(25621,'横板桥乡','227',1907),(25622,'温水乡','228',1907),(25623,'大华乡','229',1907),(25624,'龙庄湾乡','230',1907),(25625,'林城镇','100',1908),(25626,'坪村镇','101',1908),(25627,'堡子镇','102',1908),(25628,'团河镇','103',1908),(25629,'若水镇','104',1908),(25630,'朗江镇','105',1908),(25631,'广坪镇','106',1908),(25632,'马鞍镇','107',1908),(25633,'沙溪乡','200',1908),(25634,'金子岩侗族苗族乡','201',1908),(25635,'王家坪乡','202',1908),(25636,'长寨乡','203',1908),(25637,'高椅乡','204',1908),(25638,'黄茅乡','205',1908),(25639,'萧家乡','206',1908),(25640,'金龙乡','207',1908),(25641,'宝田侗族苗族乡','209',1908),(25642,'漠滨侗族苗族乡','210',1908),(25643,'蒲稳侗族苗族乡','211',1908),(25644,'青朗侗族苗族乡','212',1908),(25645,'炮团侗族苗族乡','213',1908),(25646,'地灵乡','214',1908),(25647,'连山乡','215',1908),(25648,'岩头乡','216',1908),(25649,'洒溪乡','217',1908),(25650,'锦和镇','101',1909),(25651,'江口墟镇','102',1909),(25652,'岩门镇','103',1909),(25653,'兰里镇','104',1909),(25654,'吕家坪镇','105',1909),(25655,'高村镇','106',1909),(25656,'郭公坪乡','200',1909),(25657,'长潭乡','201',1909),(25658,'拖冲乡','202',1909),(25659,'尧市乡','203',1909),(25660,'文昌阁乡','204',1909),(25661,'大桥江乡','205',1909),(25662,'舒家村乡','206',1909),(25663,'隆家堡乡','207',1909),(25664,'谭家寨乡','208',1909),(25665,'石羊哨乡','209',1909),(25666,'板栗树乡','210',1909),(25667,'谷达坡乡','211',1909),(25668,'兰村乡','212',1909),(25669,'栗坪乡','213',1909),(25670,'绿溪口乡','214',1909),(25671,'和坪溪乡','215',1909),(25672,'黄桑乡','216',1909),(25673,'新晃镇','100',1910),(25674,'波洲镇','101',1910),(25675,'兴隆镇','102',1910),(25676,'鱼市镇','103',1910),(25677,'凉伞镇','104',1910),(25678,'扶罗镇','105',1910),(25679,'中寨镇','106',1910),(25680,'步头降苗族乡','200',1910),(25681,'洞坪乡','201',1910),(25682,'大湾罗乡','202',1910),(25683,'方家屯乡','203',1910),(25684,'晏家乡','204',1910),(25685,'林冲乡','205',1910),(25686,'天堂乡','206',1910),(25687,'黄雷乡','207',1910),(25688,'凳寨乡','208',1910),(25689,'茶坪乡','209',1910),(25690,'新寨乡','210',1910),(25691,'贡溪乡','211',1910),(25692,'李树乡','212',1910),(25693,'禾滩乡','213',1910),(25694,'碧朗乡','214',1910),(25695,'米贝苗族乡','215',1910),(25696,'芷江镇','100',1911),(25697,'罗旧镇','101',1911),(25698,'新店坪镇','102',1911),(25699,'碧涌镇','103',1911),(25700,'公坪镇','104',1911),(25701,'牛牯坪乡','201',1911),(25702,'艾头坪乡','202',1911),(25703,'岩桥乡','203',1911),(25704,'水宽乡','204',1911),(25705,'木叶溪乡','206',1911),(25706,'五郎溪乡','207',1911),(25707,'麻缨塘乡','208',1911),(25708,'竹坪铺乡','209',1911),(25709,'土桥乡','210',1911),(25710,'上坪乡','211',1911),(25711,'大树坳乡','212',1911),(25712,'大洪山乡','213',1911),(25713,'杨公庙乡','214',1911),(25714,'梨溪口乡','215',1911),(25715,'洞下场乡','216',1911),(25716,'罗岩乡','217',1911),(25717,'板山乡','218',1911),(25718,'大垅乡','219',1911),(25719,'梨坳乡','220',1911),(25720,'冷水溪乡','221',1911),(25721,'楠木坪乡','222',1911),(25722,'晓坪乡','223',1911),(25723,'罗卜田乡','224',1911),(25724,'渠阳镇','100',1912),(25725,'甘棠镇','101',1912),(25726,'大堡子镇','102',1912),(25727,'坳上镇','103',1912),(25728,'新厂镇','104',1912),(25729,'平茶镇','105',1912),(25730,'太阳坪乡','200',1912),(25731,'三锹乡','201',1912),(25732,'文溪乡','202',1912),(25733,'寨牙乡','203',1912),(25734,'横江桥乡','204',1912),(25735,'铺口乡','205',1912),(25736,'藕团乡','206',1912),(25737,'双江镇','100',1913),(25738,'县溪镇','101',1913),(25739,'播阳镇','102',1913),(25740,'临口镇','103',1913),(25741,'牙屯堡镇','104',1913),(25742,'菁芜洲镇','105',1913),(25743,'溪口镇','106',1913),(25744,'陇城镇','107',1913),(25745,'江口乡','200',1913),(25746,'戈冲苗族乡','201',1913),(25747,'大高坪苗族乡','203',1913),(25748,'独坡乡','204',1913),(25749,'杉木桥乡','209',1913),(25750,'木脚乡','210',1913),(25751,'下乡乡','211',1913),(25752,'马龙乡','212',1913),(25753,'传素瑶族乡','214',1913),(25754,'黄土乡','215',1913),(25755,'坪坦乡','216',1913),(25756,'坪阳乡','218',1913),(25757,'甘溪乡','219',1913),(25758,'通道县地连林场','400',1913),(25759,'通道县播阳农场','401',1913),(25760,'河滨路街道','001',1914),(25761,'沅江路街道','002',1914),(25762,'新街街道','003',1914),(25763,'高坡街街道','004',1914),(25764,'黔城镇','101',1914),(25765,'安江镇','102',1914),(25766,'托口镇','103',1914),(25767,'雪峰镇','104',1914),(25768,'双溪镇','105',1914),(25769,'江市镇','106',1914),(25770,'沅河镇','107',1914),(25771,'塘湾镇','108',1914),(25772,'硖州乡','200',1914),(25773,'龙田乡','201',1914),(25774,'岔头乡','202',1914),(25775,'茅渡乡','203',1914),(25776,'大崇乡','204',1914),(25777,'熟坪乡','205',1914),(25778,'铁山乡','206',1914),(25779,'群峰乡','207',1914),(25780,'湾溪乡','208',1914),(25781,'洗马乡','209',1914),(25782,'沙湾乡','211',1914),(25783,'深渡苗族乡','212',1914),(25784,'龙船塘瑶族乡','213',1914),(25785,'太平乡','214',1914),(25786,'土溪乡','215',1914),(25787,'红岩乡','216',1914),(25788,'岩垅乡','217',1914),(25789,'横岩乡','218',1914),(25790,'常青乡','219',1914),(25791,'桂花园乡','220',1914),(25792,'乐坪街道','001',1916),(25793,'花山街道','002',1916),(25794,'黄泥塘街道','003',1916),(25795,'长青街道','004',1916),(25796,'大科街道','005',1916),(25797,'涟滨街道办事处','006',1916),(25798,'大埠桥街道办事处','007',1916),(25799,'杉山镇','100',1916),(25800,'万宝镇','101',1916),(25801,'茶园镇','103',1916),(25802,'百亩乡','202',1916),(25803,'小碧乡','203',1916),(25804,'双江乡','204',1916),(25805,'石井乡','205',1916),(25806,'永丰镇','100',1917),(25807,'荷叶镇','101',1917),(25808,'井字镇','102',1917),(25809,'梓门桥镇','103',1917),(25810,'杏子铺镇','104',1917),(25811,'走马街镇','105',1917),(25812,'蛇形山镇','106',1917),(25813,'洪山殿镇','107',1917),(25814,'甘棠镇','108',1917),(25815,'三塘铺镇','109',1917),(25816,'青树坪镇','110',1917),(25817,'花门镇','111',1917),(25818,'锁石镇','112',1917),(25819,'石牛乡','200',1917),(25820,'沙塘乡','201',1917),(25821,'印塘乡','202',1917),(25822,'上梅镇','100',1918),(25823,'石冲口镇','101',1918),(25824,'洋溪镇','102',1918),(25825,'槎溪镇','103',1918),(25826,'水车镇','104',1918),(25827,'文田镇','105',1918),(25828,'奉家镇','106',1918),(25829,'炉观镇','107',1918),(25830,'游家镇','108',1918),(25831,'西河镇','109',1918),(25832,'孟公镇','110',1918),(25833,'琅塘镇','111',1918),(25834,'白溪镇','112',1918),(25835,'圳上镇','113',1918),(25836,'吉庆镇','114',1918),(25837,'温塘镇','115',1918),(25838,'田坪镇','116',1918),(25839,'桑梓镇','117',1918),(25840,'曹家镇','118',1918),(25841,'科头乡','200',1918),(25842,'维山乡','201',1918),(25843,'天门乡','202',1918),(25844,'荣华乡','203',1918),(25845,'金凤乡','204',1918),(25846,'油溪乡','205',1918),(25847,'坐石乡','206',1918),(25848,'上渡办事处','450',1918),(25849,'大熊山国有林场','500',1918),(25850,'古台山国有林场','501',1918),(25851,'冷水江街道','001',1919),(25852,'锡矿山街道','002',1919),(25853,'沙塘湾街道','003',1919),(25854,'布溪街道','004',1919),(25855,'禾青镇','100',1919),(25856,'岩口镇','101',1919),(25857,'渣渡镇','102',1919),(25858,'铎山镇','103',1919),(25859,'毛易镇','104',1919),(25860,'三尖镇','105',1919),(25861,'潘桥乡','200',1919),(25862,'金竹山乡','202',1919),(25863,'梓龙乡','203',1919),(25864,'矿山乡','204',1919),(25865,'中连乡','205',1919),(25866,'同兴乡','206',1919),(25867,'蓝田街道','001',1920),(25868,'六亩塘镇','100',1920),(25869,'石马山镇','101',1920),(25870,'安平镇','102',1920),(25871,'湄江镇','103',1920),(25872,'伏口镇','104',1920),(25873,'桥头河镇','105',1920),(25874,'七星街镇','106',1920),(25875,'杨市镇','107',1920),(25876,'枫坪镇','108',1920),(25877,'斗笠山镇','109',1920),(25878,'水洞底镇','110',1920),(25879,'白马镇','111',1920),(25880,'茅塘镇','112',1920),(25881,'荷塘镇','113',1920),(25882,'金石镇','114',1920),(25883,'三甲乡','200',1920),(25884,'龙塘乡','201',1920),(25885,'古塘乡','202',1920),(25886,'渡头塘乡','203',1920),(25887,'峒河街道办事处','002',1921),(25888,'乾州街道办事处','004',1921),(25889,'镇溪街道办事处','005',1921),(25890,'矮寨镇','100',1921),(25891,'马颈坳镇','101',1921),(25892,'河溪镇','102',1921),(25893,'双塘镇','103',1921),(25894,'丹青镇','104',1921),(25895,'寨阳乡','200',1921),(25896,'已略乡','201',1921),(25897,'社塘坡乡','202',1921),(25898,'太平乡','203',1921),(25899,'白岩乡','204',1921),(25900,'排绸乡','205',1921),(25901,'排吼乡','206',1921),(25902,'白沙镇','100',1922),(25903,'达岚镇','102',1922),(25904,'兴隆场镇','104',1922),(25905,'潭溪镇','105',1922),(25906,'洗溪镇','106',1922),(25907,'武溪镇','107',1922),(25908,'浦市镇','108',1922),(25909,'合水镇','109',1922),(25910,'石榴坪乡','203',1922),(25911,'永兴场乡','205',1922),(25912,'解放岩乡','206',1922),(25913,'小章乡','207',1922),(25914,'白羊溪乡','208',1922),(25915,'梁家潭乡','209',1922),(25916,'八什坪乡','210',1922),(25917,'军亭界林场','400',1922),(25918,'廖家桥镇','101',1923),(25919,'茶田镇','104',1923),(25920,'吉信镇','105',1923),(25921,'腊尔山镇','107',1923),(25922,'禾库镇','108',1923),(25923,'沱江镇','109',1923),(25924,'阿拉营镇','110',1923),(25925,'木江坪镇','111',1923),(25926,'山江镇','112',1923),(25927,'官庄乡','202',1923),(25928,'水打田乡','204',1923),(25929,'林峰乡','205',1923),(25930,'都里乡','206',1923),(25931,'落潮井乡','207',1923),(25932,'新场乡','208',1923),(25933,'茨岩乡','209',1923),(25934,'三拱桥乡','212',1923),(25935,'竿子坪乡','213',1923),(25936,'麻冲乡','216',1923),(25937,'千工坪乡','218',1923),(25938,'木里乡','219',1923),(25939,'两林乡','220',1923),(25940,'柳薄乡','221',1923),(25941,'米良乡','222',1923),(25942,'龙潭镇','102',1924),(25943,'民乐镇','103',1924),(25944,'团结镇','104',1924),(25945,'吉卫镇','105',1924),(25946,'麻栗场镇','106',1924),(25947,'雅酉镇','107',1924),(25948,'边城镇','108',1924),(25949,'花垣镇','109',1924),(25950,'长乐乡','200',1924),(25951,'两河乡','202',1924),(25952,'排碧乡','204',1924),(25953,'董马库乡','205',1924),(25954,'猫儿乡','206',1924),(25955,'道二乡','209',1924),(25956,'排吾乡','210',1924),(25957,'排料乡','211',1924),(25958,'雅桥乡','212',1924),(25959,'补抽乡','213',1924),(25960,'普戎镇','104',1925),(25961,'野竹坪镇','107',1925),(25962,'复兴镇','108',1925),(25963,'迁陵镇','109',1925),(25964,'清水坪镇','110',1925),(25965,'比耳镇','111',1925),(25966,'毛沟镇','112',1925),(25967,'水田河镇','113',1925),(25968,'葫芦镇','114',1925),(25969,'碗米坡镇','115',1925),(25970,'水银乡','202',1925),(25971,'涂乍乡','203',1925),(25972,'大妥乡','205',1925),(25973,'夯沙乡','210',1925),(25974,'清水乡','215',1925),(25975,'阳朝乡','217',1925),(25976,'保靖白云农垦场','403',1925),(25977,'默戎镇','101',1926),(25978,'罗依溪镇','102',1926),(25979,'古阳镇','104',1926),(25980,'红石林镇','105',1926),(25981,'断龙山乡','200',1926),(25982,'高峰乡','202',1926),(25983,'岩头寨乡','203',1926),(25984,'河蓬乡','205',1926),(25985,'坪坝乡','206',1926),(25986,'山枣乡','207',1926),(25987,'双溪乡','208',1926),(25988,'高望界乡','212',1926),(25989,'首车镇','101',1927),(25990,'王村镇','103',1927),(25991,'永茂镇','104',1927),(25992,'长官镇','108',1927),(25993,'青坪镇','109',1927),(25994,'泽家镇','111',1927),(25995,'石堤镇','112',1927),(25996,'万坪镇','113',1927),(25997,'塔卧镇','114',1927),(25998,'砂坝镇','115',1927),(25999,'灵溪镇','116',1927),(26000,'两岔乡','200',1927),(26001,'勺哈乡','201',1927),(26002,'西歧乡','202',1927),(26003,'对山乡','203',1927),(26004,'列夕乡','206',1927),(26005,'松柏乡','208',1927),(26006,'高坪乡','210',1927),(26007,'回龙乡','212',1927),(26008,'小溪乡','214',1927),(26009,'朗溪乡','216',1927),(26010,'润雅乡','220',1927),(26011,'车坪乡','222',1927),(26012,'毛坝乡','228',1927),(26013,'万民乡','229',1927),(26014,'盐井乡','230',1927),(26015,'抚志乡','233',1927),(26016,'吊井乡','235',1927),(26017,'大坝乡','237',1927),(26018,'颗砂乡','238',1927),(26019,'民安街道办事处','001',1928),(26020,'华塘街道办事处','002',1928),(26021,'新城街道办事处','003',1928),(26022,'石羔镇','101',1928),(26023,'洗车河镇','104',1928),(26024,'隆头镇','106',1928),(26025,'石牌镇','110',1928),(26026,'茨岩塘镇','112',1928),(26027,'红岩溪镇','113',1928),(26028,'靛房镇','114',1928),(26029,'苗儿滩镇','115',1928),(26030,'里耶镇','116',1928),(26031,'桂塘镇','117',1928),(26032,'召市镇','118',1928),(26033,'洛塔乡','200',1928),(26034,'洗洛乡','203',1928),(26035,'湾塘乡','204',1928),(26036,'白羊乡','205',1928),(26037,'兴隆街乡','206',1928),(26038,'三元乡','207',1928),(26039,'桶车乡','208',1928),(26040,'大安乡','210',1928),(26041,'水田坝乡','211',1928),(26042,'乌鸦乡','212',1928),(26043,'猛必乡','213',1928),(26044,'他砂乡','218',1928),(26045,'内溪乡','220',1928),(26046,'贾市乡','223',1928),(26047,'塔泥乡','231',1928),(26048,'农车乡','232',1928),(26049,'老兴乡','234',1928),(26050,'贾坝乡','235',1928),(26051,'咱果乡','236',1928),(26052,'茅坪乡','237',1928),(26053,'沙面街道','001',1929),(26054,'岭南街道','002',1929),(26055,'华林街道','003',1929),(26056,'多宝街道','004',1929),(26057,'昌华街道','005',1929),(26058,'逢源街道','006',1929),(26059,'龙津街道','007',1929),(26060,'金花街道','008',1929),(26061,'彩虹街道','009',1929),(26062,'南源街道','010',1929),(26063,'西村街道','011',1929),(26064,'站前街道','012',1929),(26065,'桥中街道','013',1929),(26066,'白鹤洞街道','014',1929),(26067,'冲口街道','015',1929),(26068,'花地街道','016',1929),(26069,'石围塘街道','017',1929),(26070,'茶','018',1929),(26071,'东','019',1929),(26072,'海龙街道','020',1929),(26073,'东沙街道','021',1929),(26074,'中南街道','022',1929),(26075,'洪桥街道','001',1930),(26076,'广卫街道','002',1930),(26077,'北京街道','003',1930),(26078,'六榕街道','004',1930),(26079,'流花街道','005',1930),(26080,'东风街道','006',1930),(26081,'光塔街道','007',1930),(26082,'诗书街道','008',1930),(26083,'大新街道','009',1930),(26084,'人民街道','010',1930),(26085,'东湖街道','011',1930),(26086,'农林街道','012',1930),(26087,'梅花村街道','013',1930),(26088,'黄花岗街道','014',1930),(26089,'华乐街道','015',1930),(26090,'建设街道','016',1930),(26091,'大塘街道','017',1930),(26092,'珠光街道','018',1930),(26093,'大东街道','019',1930),(26094,'白云街道','020',1930),(26095,'登峰街道','021',1930),(26096,'矿泉街道','022',1930),(26097,'赤岗街道','001',1931),(26098,'新港街道','002',1931),(26099,'昌岗街道','003',1931),(26100,'江南中街道','004',1931),(26101,'滨江街道','005',1931),(26102,'素社街道','006',1931),(26103,'海幢街道','007',1931),(26104,'南华西街道','008',1931),(26105,'龙凤街道','009',1931),(26106,'沙园街道','010',1931),(26107,'南石头街道','011',1931),(26108,'凤阳街道','012',1931),(26109,'瑞宝街道','013',1931),(26110,'江海街道','014',1931),(26111,'琶洲街道','015',1931),(26112,'南洲街道','016',1931),(26113,'华洲街道','017',1931),(26114,'官洲街道','018',1931),(26115,'五山街道','001',1932),(26116,'员村街道','002',1932),(26117,'车陂街道','003',1932),(26118,'沙河街道','004',1932),(26119,'石牌街道','006',1932),(26120,'沙东街道','007',1932),(26121,'天河南街道','008',1932),(26122,'林和街道','009',1932),(26123,'兴华街道','010',1932),(26124,'棠下街道','011',1932),(26125,'天园街道','012',1932),(26126,'猎德街道','013',1932),(26127,'冼村街道','014',1932),(26128,'元岗街道','015',1932),(26129,'黄村街道','016',1932),(26130,'长兴街道','017',1932),(26131,'龙洞街道','018',1932),(26132,'凤凰街道','019',1932),(26133,'前进街道','020',1932),(26134,'珠吉街道','021',1932),(26135,'新塘街道','022',1932),(26136,'三元里街道','002',1933),(26137,'松洲街道','003',1933),(26138,'景泰街道','004',1933),(26139,'同德街道','005',1933),(26140,'黄石街道','006',1933),(26141,'棠景街道','007',1933),(26142,'新市街道','008',1933),(26143,'同和街道','009',1933),(26144,'京溪街道','010',1933),(26145,'永平街道','011',1933),(26146,'嘉禾街道','012',1933),(26147,'均禾街道','013',1933),(26148,'石井街道','014',1933),(26149,'金沙街道','015',1933),(26150,'人和镇','103',1933),(26151,'太和镇','107',1933),(26152,'钟落潭镇','108',1933),(26153,'江高镇','113',1933),(26154,'黄埔街道','001',1934),(26155,'红山街道','002',1934),(26156,'鱼珠街道','003',1934),(26157,'大沙街道','005',1934),(26158,'文冲街道','006',1934),(26159,'穗东街道','007',1934),(26160,'南岗街道','008',1934),(26161,'荔联街道','009',1934),(26162,'长洲街道','010',1934),(26163,'市桥街道','007',1935),(26164,'沙头街道','008',1935),(26165,'东环街道','009',1935),(26166,'桥南街道','010',1935),(26167,'小谷围街道','011',1935),(26168,'大石街道','012',1935),(26169,'洛浦街道','013',1935),(26170,'南村镇','102',1935),(26171,'新造镇','103',1935),(26172,'化龙镇','104',1935),(26173,'石楼镇','105',1935),(26174,'东涌镇','107',1935),(26175,'大岗镇','114',1935),(26176,'榄核镇','116',1935),(26177,'沙湾镇','118',1935),(26178,'钟村镇','119',1935),(26179,'石基镇','120',1935),(26180,'新华街道','001',1936),(26181,'梯面镇','103',1936),(26182,'花山镇','104',1936),(26183,'花东镇','105',1936),(26184,'炭步镇','107',1936),(26185,'赤坭镇','108',1936),(26186,'狮岭镇','109',1936),(26187,'雅瑶镇','111',1936),(26188,'南沙街道','001',1937),(26189,'万顷沙镇','100',1937),(26190,'横沥镇','101',1937),(26191,'黄阁镇','102',1937),(26192,'珠江管理区','400',1937),(26193,'夏港街道','001',1938),(26194,'萝岗街道','002',1938),(26195,'东区街道','003',1938),(26196,'联和街道','004',1938),(26197,'永和街道','005',1938),(26198,'九龙镇','101',1938),(26199,'荔城街道','001',1939),(26200,'增江街道','002',1939),(26201,'朱村街道','003',1939),(26202,'新塘镇','101',1939),(26203,'石滩镇','102',1939),(26204,'中新镇','103',1939),(26205,'正果镇','104',1939),(26206,'派潭镇','105',1939),(26207,'小楼镇','106',1939),(26208,'街口街道','001',1940),(26209,'江埔街道','002',1940),(26210,'城郊街道','003',1940),(26211,'温泉镇','103',1940),(26212,'良口镇','104',1940),(26213,'吕田镇','107',1940),(26214,'太平镇','111',1940),(26215,'鳌头镇','113',1940),(26216,'流溪河林场','402',1940),(26217,'黄龙带水库管理处','404',1940),(26218,'大岭山林场','405',1940),(26219,'新华街道办事处','001',1941),(26220,'惠民街道办事处','002',1941),(26221,'西联镇','100',1941),(26222,'西河镇','101',1941),(26223,'龙归镇','102',1941),(26224,'江湾镇','103',1941),(26225,'重阳镇','104',1941),(26226,'东河街道办事处','001',1942),(26227,'车站街道办事处','002',1942),(26228,'田螺冲街道办事处','003',1942),(26229,'太平街道办事处','004',1942),(26230,'南门街道办事处','005',1942),(26231,'和平街道办事处','006',1942),(26232,'曲仁街道办事处','007',1942),(26233,'新韶镇','100',1942),(26234,'乐园镇','101',1942),(26235,'十里亭镇','102',1942),(26236,'犁市镇','103',1942),(26237,'花坪镇','104',1942),(26238,'韶关监狱','450',1942),(26239,'北江监狱','451',1942),(26240,'武江监狱','452',1942),(26241,'韶关市冶炼厂','453',1942),(26242,'马坝镇','100',1943),(26243,'大塘镇','101',1943),(26244,'枫湾镇','102',1943),(26245,'小坑镇','103',1943),(26246,'沙溪镇','104',1943),(26247,'乌石镇','106',1943),(26248,'樟市镇','107',1943),(26249,'白土镇','108',1943),(26250,'罗坑镇','109',1943),(26251,'韶关钢铁集团有限公司','450',1943),(26252,'韶关发电厂','451',1943),(26253,'曲江区大宝山矿','452',1943),(26254,'韶关十六冶金建设公司','453',1943),(26255,'消雪岭华侨农场','454',1943),(26256,'太平镇','100',1944),(26257,'马市镇','101',1944),(26258,'澄江镇','102',1944),(26259,'顿岗镇','103',1944),(26260,'罗坝镇','104',1944),(26261,'司前镇','105',1944),(26262,'隘子镇','106',1944),(26263,'城南镇','107',1944),(26264,'沈所镇','108',1944),(26265,'深渡水乡','204',1944),(26266,'刘张家山林场','500',1944),(26267,'丹霞街道办事处','001',1945),(26268,'闻韶镇','102',1945),(26269,'扶溪镇','103',1945),(26270,'长江镇','104',1945),(26271,'城口镇','105',1945),(26272,'红山镇','106',1945),(26273,'石塘镇','107',1945),(26274,'董塘镇','108',1945),(26275,'大桥镇','109',1945),(26276,'周田镇','110',1945),(26277,'黄坑镇','111',1945),(26278,'仁化林场','450',1945),(26279,'龙仙镇','100',1946),(26280,'坝仔镇','104',1946),(26281,'江尾镇','106',1946),(26282,'官渡镇','109',1946),(26283,'周陂镇','111',1946),(26284,'翁城镇','113',1946),(26285,'新江镇','114',1946),(26286,'铁龙林场','450',1946),(26287,'乳城镇','100',1947),(26288,'一六镇','103',1947),(26289,'桂头镇','104',1947),(26290,'洛阳镇','106',1947),(26291,'大布镇','108',1947),(26292,'大桥镇','109',1947),(26293,'东坪镇','111',1947),(26294,'游溪镇','112',1947),(26295,'必背镇','113',1947),(26296,'天井山林场','450',1947),(26297,'乳阳林业局','451',1947),(26298,'丰城街道办事处','001',1948),(26299,'黄礤镇','101',1948),(26300,'马头镇','102',1948),(26301,'梅坑镇','103',1948),(26302,'沙田镇','104',1948),(26303,'遥田镇','105',1948),(26304,'回龙镇','106',1948),(26305,'乐城街道办事处','001',1949),(26306,'北乡镇','102',1949),(26307,'九峰镇','103',1949),(26308,'廊田镇','104',1949),(26309,'长来镇','105',1949),(26310,'梅花镇','106',1949),(26311,'三溪镇','107',1949),(26312,'坪石镇','108',1949),(26313,'黄圃镇','110',1949),(26314,'五山镇','111',1949),(26315,'两江镇','112',1949),(26316,'沙坪镇','113',1949),(26317,'云岩镇','114',1949),(26318,'秀水镇','115',1949),(26319,'大源镇','117',1949),(26320,'庆云镇','118',1949),(26321,'白石镇','119',1949),(26322,'坪石办事处','451',1949),(26323,'梅田办事处','452',1949),(26324,'乐昌监狱','453',1949),(26325,'坪石监狱','454',1949),(26326,'雄州街道办事处','001',1950),(26327,'乌迳镇','100',1950),(26328,'界址镇','103',1950),(26329,'坪田镇','104',1950),(26330,'黄坑镇','105',1950),(26331,'邓坊镇','106',1950),(26332,'油山镇','107',1950),(26333,'南亩镇','109',1950),(26334,'水口镇','110',1950),(26335,'江头镇','111',1950),(26336,'湖口镇','112',1950),(26337,'珠玑镇','113',1950),(26338,'主田镇','115',1950),(26339,'古市镇','116',1950),(26340,'全安镇','118',1950),(26341,'百顺镇','120',1950),(26342,'澜河镇','121',1950),(26343,'帽子峰镇','122',1950),(26344,'桂园街道办事处','001',1951),(26345,'黄贝街道办事处','002',1951),(26346,'东门街道办事处','003',1951),(26347,'翠竹街道办事处','004',1951),(26348,'南湖街道办事处','005',1951),(26349,'笋岗街道办事处','006',1951),(26350,'东湖街道办事处','007',1951),(26351,'莲塘街道办事处','008',1951),(26352,'东晓街道办事处','009',1951),(26353,'清水河街道办事处','010',1951),(26354,'南园街道办事处','001',1952),(26355,'园岭街道办事处','002',1952),(26356,'福田街道办事处','004',1952),(26357,'沙头街道办事处','005',1952),(26358,'香蜜湖街道办事处','006',1952),(26359,'梅林街道办事处','007',1952),(26360,'莲花街道办事处','008',1952),(26361,'华富街道办事处','009',1952),(26362,'福田保税区','400',1952),(26363,'南头街道办事处','001',1953),(26364,'南山街道办事处','002',1953),(26365,'沙河街道办事处','003',1953),(26366,'蛇口街道办事处','005',1953),(26367,'招商街道办事处','006',1953),(26368,'粤海街道办事处','007',1953),(26369,'桃源街道办事处','008',1953),(26370,'西丽街道办事处','009',1953),(26371,'新安街道办事处','001',1954),(26372,'光明街道办事处','002',1954),(26373,'西乡街道办事处','003',1954),(26374,'福永街道办事处','004',1954),(26375,'沙井街道办事处','005',1954),(26376,'松岗街道办事处','006',1954),(26377,'公明街道办事处','007',1954),(26378,'石岩街道办事处','008',1954),(26379,'观澜街道办事处','010',1954),(26380,'大浪街道办事处','011',1954),(26381,'龙华街道办事处','012',1954),(26382,'民治街道办事处','013',1954),(26383,'深圳宝安国际机场','400',1954),(26384,'平湖街道办事处','003',1955),(26385,'坪地街道办事处','006',1955),(26386,'坪山街道办事处','007',1955),(26387,'坑梓街道办事处','008',1955),(26388,'葵涌街道办事处','009',1955),(26389,'大鹏街道办事处','010',1955),(26390,'南澳街道办事处','011',1955),(26391,'南湾街道办事处','012',1955),(26392,'坂田街道办事处','013',1955),(26393,'布吉街道办事处','014',1955),(26394,'龙城街道办事处','015',1955),(26395,'龙岗街道办事处','016',1955),(26396,'横岗街道办事处','017',1955),(26397,'深圳市大工业区','400',1955),(26398,'梅沙街道办事处','001',1956),(26399,'盐田街道办事处','002',1956),(26400,'沙头角街道办事处','003',1956),(26401,'海山街道办事处','004',1956),(26402,'市保税区（沙头角）','400',1956),(26403,'市保税区（盐田港）','401',1956),(26404,'翠香街道','001',1957),(26405,'梅华街道','002',1957),(26406,'前山街道办','003',1957),(26407,'吉大街道','004',1957),(26408,'拱北街道','005',1957),(26409,'香湾街道','006',1957),(26410,'狮山街道','007',1957),(26411,'湾仔街道','008',1957),(26412,'唐家湾镇','100',1957),(26413,'南屏镇','102',1957),(26414,'横琴镇','104',1957),(26415,'桂山镇','105',1957),(26416,'万山镇','106',1957),(26417,'担杆镇','107',1957),(26418,'大学园区','400',1957),(26419,'南屏科技园','401',1957),(26420,'保税区','402',1957),(26421,'莲洲镇','100',1958),(26422,'斗门镇','103',1958),(26423,'乾务镇','105',1958),(26424,'白蕉镇','106',1958),(26425,'井岸镇','107',1958),(26426,'白蕉科技工业园','400',1958),(26427,'龙山工业区','401',1958),(26428,'三灶镇','100',1959),(26429,'南水镇','101',1959),(26430,'红旗镇','103',1959),(26431,'平沙镇','104',1959),(26432,'金霞街道','001',1960),(26433,'珠池街道','003',1960),(26434,'新津街道','004',1960),(26435,'鸥汀街道','005',1960),(26436,'龙祥街道','008',1960),(26437,'外砂镇','100',1960),(26438,'新溪镇','101',1960),(26439,'石炮台街道','001',1961),(26440,'金砂街道','002',1961),(26441,'金厦街道','003',1961),(26442,'东方街道','004',1961),(26443,'大华街道','005',1961),(26444,'同益街道','006',1961),(26445,'光华街道','007',1961),(26446,'东墩街道','008',1961),(26447,'广厦街道','009',1961),(26448,'海安街道','010',1961),(26449,'新福街道','011',1961),(26450,'乌桥街道','012',1961),(26451,'岐山街道','013',1961),(26452,'永祥街道','014',1961),(26453,'月浦街道','017',1961),(26454,'达濠街道','001',1962),(26455,'马窖街道','002',1962),(26456,'广澳街道','004',1962),(26457,'滨海街道','005',1962),(26458,'河浦街道','006',1962),(26459,'玉新街道','007',1962),(26460,'文光街道','001',1963),(26461,'棉北街道','002',1963),(26462,'城南街道','003',1963),(26463,'金浦街道','004',1963),(26464,'海门镇','100',1963),(26465,'河溪镇','101',1963),(26466,'和平镇','102',1963),(26467,'西胪镇','103',1963),(26468,'关埠镇','104',1963),(26469,'谷饶镇','106',1963),(26470,'贵屿镇','107',1963),(26471,'铜盂镇','108',1963),(26472,'金灶镇','110',1963),(26473,'峡山街道','001',1964),(26474,'井都镇','101',1964),(26475,'成田镇','103',1964),(26476,'司马浦镇','104',1964),(26477,'陈店镇','105',1964),(26478,'两英镇','106',1964),(26479,'仙城镇','107',1964),(26480,'胪岗镇','108',1964),(26481,'红场镇','109',1964),(26482,'雷岭镇','110',1964),(26483,'陇田镇','112',1964),(26484,'凤翔街道','001',1965),(26485,'广益街道','002',1965),(26486,'澄华街道','003',1965),(26487,'上华镇','100',1965),(26488,'隆都镇','101',1965),(26489,'莲下镇','102',1965),(26490,'莲上镇','103',1965),(26491,'溪南镇','104',1965),(26492,'东里镇','105',1965),(26493,'盐鸿镇','106',1965),(26494,'莲华镇','107',1965),(26495,'后宅镇','100',1966),(26496,'云澳镇','101',1966),(26497,'深澳镇','102',1966),(26498,'石湾镇街道办事处','010',1967),(26499,'张槎街道办事处','011',1967),(26500,'祖庙街道办事处','012',1967),(26501,'南庄镇','100',1967),(26502,'桂城街道办事处','011',1968),(26503,'罗村街道办事处','012',1968),(26504,'九江镇办事处','121',1968),(26505,'西樵镇办事处','122',1968),(26506,'丹灶镇办事处','123',1968),(26507,'狮山镇办事处','124',1968),(26508,'大沥镇办事处','125',1968),(26509,'里水镇办事处','126',1968),(26510,'伦教街道办事处','003',1969),(26511,'勒流街道','004',1969),(26512,'大良街道办事处','005',1969),(26513,'容桂街道办事处','006',1969),(26514,'陈村镇','101',1969),(26515,'北','102',1969),(26516,'乐从镇','103',1969),(26517,'龙江镇','104',1969),(26518,'杏坛镇','105',1969),(26519,'均安镇','106',1969),(26520,'西南街道办事处','001',1970),(26521,'大塘镇','101',1970),(26522,'乐平镇','103',1970),(26523,'白坭镇','104',1970),(26524,'芦苞镇','105',1970),(26525,'省三水劳教所','400',1970),(26526,'省南丰劳教所','401',1970),(26527,'省女子劳教所','402',1970),(26528,'省第二戒毒劳教所','403',1970),(26529,'广州军区三水农场','404',1970),(26530,'迳口华侨经济区','405',1970),(26531,'荷城街道办事处','004',1971),(26532,'杨和镇','106',1971),(26533,'明城镇','107',1971),(26534,'更合镇','108',1971),(26535,'高明监狱','400',1971),(26536,'云勇林场','401',1971),(26537,'对川茶场','402',1971),(26538,'佛山监狱','403',1971),(26539,'仓后街道办事处','001',1972),(26540,'沙仔尾街道办事处','002',1972),(26541,'堤东街道办事处','003',1972),(26542,'北街街道办事处','004',1972),(26543,'潮连街道办事处','005',1972),(26544,'环市街道办事处','006',1972),(26545,'棠下镇','101',1972),(26546,'荷塘镇','102',1972),(26547,'杜阮镇','103',1972),(26548,'江南街道办事处','001',1973),(26549,'外海街道办事处','004',1973),(26550,'礼乐街道办事处','005',1973),(26551,'会城街道','001',1974),(26552,'大泽镇','101',1974),(26553,'司前镇','102',1974),(26554,'罗坑镇','103',1974),(26555,'双水镇','104',1974),(26556,'崖门镇','105',1974),(26557,'沙堆镇','106',1974),(26558,'古井镇','107',1974),(26559,'三江镇','108',1974),(26560,'睦州镇','109',1974),(26561,'大','110',1974),(26562,'圭峰山风景区','450',1974),(26563,'银湖湾湿地公园','451',1974),(26564,'今古洲经济开发试验区','470',1974),(26565,'台城街道办事处','001',1975),(26566,'大江镇','100',1975),(26567,'水步镇','101',1975),(26568,'四九镇','102',1975),(26569,'白沙镇','103',1975),(26570,'三合镇','104',1975),(26571,'冲蒌镇','105',1975),(26572,'斗山镇','106',1975),(26573,'都斛镇','107',1975),(26574,'赤溪镇','108',1975),(26575,'端芬镇','109',1975),(26576,'广海镇','110',1975),(26577,'海宴镇','111',1975),(26578,'汶村镇','112',1975),(26579,'深井镇','113',1975),(26580,'北陡镇','114',1975),(26581,'川岛镇','115',1975),(26582,'华侨农场','401',1975),(26583,'三埠街道办事处','001',1976),(26584,'长沙街道办事处','002',1976),(26585,'沙塘镇','103',1976),(26586,'苍城镇','104',1976),(26587,'龙胜镇','105',1976),(26588,'大沙镇','106',1976),(26589,'马冈镇','107',1976),(26590,'塘口镇','108',1976),(26591,'赤坎镇','109',1976),(26592,'百合镇','110',1976),(26593,'蚬冈镇','111',1976),(26594,'金鸡镇','112',1976),(26595,'月山镇','115',1976),(26596,'赤水镇','116',1976),(26597,'水口镇','117',1976),(26598,'沙坪镇','100',1977),(26599,'龙口镇','101',1977),(26600,'雅瑶镇','102',1977),(26601,'古劳镇','103',1977),(26602,'桃源镇','104',1977),(26603,'鹤城镇','105',1977),(26604,'共和镇','106',1977),(26605,'址山镇','107',1977),(26606,'宅梧镇','108',1977),(26607,'云乡镇','109',1977),(26608,'双合镇','112',1977),(26609,'江门监狱','401',1977),(26610,'四堡林场','402',1977),(26611,'恩城街道办事处','001',1978),(26612,'平石街道办事处','003',1978),(26613,'横陂镇','100',1978),(26614,'圣堂镇','101',1978),(26615,'良西镇','102',1978),(26616,'沙湖镇','103',1978),(26617,'牛江镇','104',1978),(26618,'君堂镇','105',1978),(26619,'大田镇','106',1978),(26620,'那吉镇','107',1978),(26621,'大槐镇','108',1978),(26622,'东成镇','109',1978),(26623,'中华街道','001',1979),(26624,'寸金街道','002',1979),(26625,'民主街道','003',1979),(26626,'中山街道','004',1979),(26627,'沙湾街道','005',1979),(26628,'调顺街道','006',1979),(26629,'南桥街道','007',1979),(26630,'北桥街道','008',1979),(26631,'解放街道办事处','001',1980),(26632,'爱国街道办事处','002',1980),(26633,'工农街道办事处','003',1980),(26634,'友谊街道办事处','004',1980),(26635,'新兴街道办事处','005',1980),(26636,'海滨街道办事处','006',1980),(26637,'建设街道办事处','009',1980),(26638,'东新街道办事处','010',1980),(26639,'新园街道办事处','011',1980),(26640,'海头街道办事处','012',1980),(26641,'泉庄街道办事处(湛江开发区)','070',1980),(26642,'乐华街道办事处(湛江开发区)','071',1980),(26643,'南调街道办事处','001',1981),(26644,'麻斜街道办事处','002',1981),(26645,'南三镇','100',1981),(26646,'坡头镇','101',1981),(26647,'乾塘镇','102',1981),(26648,'龙头镇','103',1981),(26649,'官渡镇','104',1981),(26650,'中国石油南海西部公司','400',1981),(26651,'湛江市坡头区官渡工业园','401',1981),(26652,'麻章镇','100',1982),(26653,'太平镇','101',1982),(26654,'湖光镇','102',1982),(26655,'东山镇','170',1982),(26656,'东简镇','171',1982),(26657,'民安镇','172',1982),(26658,'硇洲镇','173',1982),(26659,'湖光农场虚拟镇','450',1982),(26660,'遂城镇','100',1983),(26661,'黄略镇','101',1983),(26662,'洋青镇','102',1983),(26663,'界炮镇','103',1983),(26664,'乐民镇','104',1983),(26665,'江洪镇','105',1983),(26666,'杨柑镇','106',1983),(26667,'城月镇','107',1983),(26668,'乌塘镇','108',1983),(26669,'建新镇','109',1983),(26670,'岭北镇','110',1983),(26671,'北坡镇','111',1983),(26672,'港门镇','112',1983),(26673,'草潭镇','113',1983),(26674,'河头镇','114',1983),(26675,'广前公司虚拟镇','450',1983),(26676,'雷州林业局虚拟镇','451',1983),(26677,'徐城街道办','001',1984),(26678,'迈陈镇','102',1984),(26679,'海安镇','103',1984),(26680,'曲界镇','104',1984),(26681,'前山镇','105',1984),(26682,'西连镇','106',1984),(26683,'下桥镇','107',1984),(26684,'龙塘镇','108',1984),(26685,'下洋镇','109',1984),(26686,'锦和镇','110',1984),(26687,'和安镇','111',1984),(26688,'新寮镇','112',1984),(26689,'南山镇','113',1984),(26690,'城北乡','201',1984),(26691,'角尾乡','204',1984),(26692,'南华农场虚拟镇','451',1984),(26693,'五一农场虚拟镇','452',1984),(26694,'华海公司虚拟镇','453',1984),(26695,'友好农场虚拟镇','454',1984),(26696,'红星农场虚拟镇','455',1984),(26697,'罗州街道办','001',1985),(26698,'城南街道办','002',1985),(26699,'城北街道办','003',1985),(26700,'石城镇','101',1985),(26701,'新民镇','102',1985),(26702,'吉水镇','103',1985),(26703,'河唇镇','104',1985),(26704,'石角镇','105',1985),(26705,'良垌镇','106',1985),(26706,'横山镇','107',1985),(26707,'安铺镇','108',1985),(26708,'营仔镇','109',1985),(26709,'青平镇','110',1985),(26710,'车板镇','111',1985),(26711,'高桥镇','112',1985),(26712,'石岭镇','113',1985),(26713,'雅塘镇','114',1985),(26714,'石颈镇','115',1985),(26715,'长山镇','116',1985),(26716,'塘蓬镇','117',1985),(26717,'和寮镇','118',1985),(26718,'雷城街道办','001',1986),(26719,'白沙镇','100',1986),(26720,'沈塘镇','101',1986),(26721,'客路镇','102',1986),(26722,'杨家镇','103',1986),(26723,'唐家镇','104',1986),(26724,'企水镇','105',1986),(26725,'纪家镇','106',1986),(26726,'松竹镇','107',1986),(26727,'南兴镇','108',1986),(26728,'雷高镇','109',1986),(26729,'东里镇','110',1986),(26730,'调风镇','111',1986),(26731,'龙门镇','112',1986),(26732,'英利镇','113',1986),(26733,'北和镇','114',1986),(26734,'乌石镇','115',1986),(26735,'覃斗镇','116',1986),(26736,'附城镇','117',1986),(26737,'华侨管理区虚拟镇','450',1986),(26738,'丰收糖业集团有限公司虚拟镇','451',1986),(26739,'火炬农场虚拟镇','452',1986),(26740,'幸福农场虚拟镇','453',1986),(26741,'东方红农场虚拟镇','454',1986),(26742,'金星农场虚拟镇','455',1986),(26743,'梅录街道','001',1987),(26744,'塘尾街道','002',1987),(26745,'大山江街道','003',1987),(26746,'博铺街道','004',1987),(26747,'海滨街道','005',1987),(26748,'浅水镇','100',1987),(26749,'长岐镇','101',1987),(26750,'覃巴镇','102',1987),(26751,'王村港镇','103',1987),(26752,'振文镇','104',1987),(26753,'樟铺镇','105',1987),(26754,'吴阳镇','106',1987),(26755,'塘缀镇','107',1987),(26756,'黄坡镇','109',1987),(26757,'兰石镇','111',1987),(26758,'红旗街道办','001',1988),(26759,'河西街道办','002',1988),(26760,'河东街道办','003',1988),(26761,'露天矿街道办','004',1988),(26762,'新华街道办','005',1988),(26763,'官渡街道办','006',1988),(26764,'站前街道办','007',1988),(26765,'金塘镇','100',1988),(26766,'公馆镇','101',1988),(26767,'新坡镇','102',1988),(26768,'镇盛镇','103',1988),(26769,'鳌头镇','104',1988),(26770,'袂花镇','105',1988),(26771,'高山镇','106',1988),(26772,'山阁镇','107',1988),(26773,'茂南开发区','400',1988),(26774,'南海街道','001',1989),(26775,'高地街道','002',1989),(26776,'羊角镇','101',1989),(26777,'坡心镇','102',1989),(26778,'七迳镇','103',1989),(26779,'小良镇','104',1989),(26780,'沙院镇','105',1989),(26781,'马踏镇','100',1990),(26782,'岭门镇','101',1990),(26783,'树仔镇','104',1990),(26784,'麻岗镇','106',1990),(26785,'旦场镇','107',1990),(26786,'霞洞镇','115',1990),(26787,'观珠镇','116',1990),(26788,'沙琅镇','117',1990),(26789,'黄岭镇','118',1990),(26790,'望夫镇','119',1990),(26791,'罗坑镇','120',1990),(26792,'那霍镇','121',1990),(26793,'水东镇','123',1990),(26794,'博贺镇','125',1990),(26795,'林头镇','126',1990),(26796,'电城镇','127',1990),(26797,'陈村镇','450',1990),(26798,'曙光农场','451',1990),(26799,'水丰农场','452',1990),(26800,'新华农场','453',1990),(26801,'电白盐场','454',1990),(26802,'石仔岭街道','002',1991),(26803,'山美街道','003',1991),(26804,'金山街道','006',1991),(26805,'潘州街道','007',1991),(26806,'宝光街道','008',1991),(26807,'谢鸡镇','100',1991),(26808,'新垌镇','101',1991),(26809,'云潭镇','102',1991),(26810,'分界镇','103',1991),(26811,'根子镇','104',1991),(26812,'泗水镇','105',1991),(26813,'镇江镇','107',1991),(26814,'沙田镇','109',1991),(26815,'南塘镇','110',1991),(26816,'荷花镇','111',1991),(26817,'石板镇','112',1991),(26818,'大井镇','115',1991),(26819,'潭头镇','116',1991),(26820,'大坡镇','119',1991),(26821,'平山镇','120',1991),(26822,'深镇镇','121',1991),(26823,'马贵镇','122',1991),(26824,'古丁镇','123',1991),(26825,'曹江镇','124',1991),(26826,'荷塘镇','126',1991),(26827,'石鼓镇','127',1991),(26828,'东岸镇','128',1991),(26829,'长坡镇','129',1991),(26830,'团结农场','450',1991),(26831,'胜利农场','451',1991),(26832,'火星农场','452',1991),(26833,'河西街道','001',1992),(26834,'东山街道','002',1992),(26835,'下郭街道','003',1992),(26836,'南盛街道','004',1992),(26837,'石湾街道','005',1992),(26838,'长岐镇','100',1992),(26839,'同庆镇','101',1992),(26840,'杨梅镇','102',1992),(26841,'良光镇','103',1992),(26842,'笪桥镇','104',1992),(26843,'丽岗镇','106',1992),(26844,'新安镇','107',1992),(26845,'官桥镇','108',1992),(26846,'林尘镇','110',1992),(26847,'合江镇','112',1992),(26848,'那务镇','113',1992),(26849,'播扬镇','114',1992),(26850,'宝圩镇','115',1992),(26851,'平定镇','116',1992),(26852,'文楼镇','117',1992),(26853,'江湖镇','118',1992),(26854,'中垌镇','120',1992),(26855,'鉴江开发区','400',1992),(26856,'新时代农场','401',1992),(26857,'新华农场','402',1992),(26858,'和平农场','403',1992),(26859,'红阳农场','404',1992),(26860,'红峰农场','405',1992),(26861,'建设农场','406',1992),(26862,'茂名监狱（石滩农场）','407',1992),(26863,'东镇街道办','001',1993),(26864,'镇隆镇','101',1993),(26865,'水口镇','102',1993),(26866,'丁堡镇','105',1993),(26867,'池洞镇','106',1993),(26868,'贵子镇','112',1993),(26869,'怀乡镇','113',1993),(26870,'茶山镇','114',1993),(26871,'洪冠镇','115',1993),(26872,'白石镇','116',1993),(26873,'大成镇','117',1993),(26874,'钱排镇','118',1993),(26875,'合水镇','119',1993),(26876,'新宝镇','120',1993),(26877,'平塘镇','121',1993),(26878,'思贺镇','122',1993),(26879,'金垌镇','123',1993),(26880,'朱砂镇','124',1993),(26881,'北界镇','125',1993),(26882,'信宜市国营红旗农场','400',1993),(26883,'端州区城东街道','001',1994),(26884,'端州区城北街道','002',1994),(26885,'端州区城西街道','003',1994),(26886,'端州区城南街道','004',1994),(26887,'端州区黄岗镇','100',1994),(26888,'端州区睦岗镇','101',1994),(26889,'星湖风景区','400',1994),(26890,'坑口街道办事处','001',1995),(26891,'桂城街道办事处','002',1995),(26892,'广利街道办事处','003',1995),(26893,'永安镇','101',1995),(26894,'沙浦镇','102',1995),(26895,'凤凰镇','103',1995),(26896,'莲花镇','104',1995),(26897,'肇庆市劳教所','400',1995),(26898,'广宁县排沙镇','100',1996),(26899,'广宁县石涧镇','101',1996),(26900,'广宁县潭布镇','102',1996),(26901,'广宁县江屯镇','103',1996),(26902,'广宁县联和镇','104',1996),(26903,'广宁县螺岗镇','105',1996),(26904,'广宁县北市镇','106',1996),(26905,'广宁县坑口镇','107',1996),(26906,'广宁县赤坑镇','108',1996),(26907,'广宁县南街镇','109',1996),(26908,'广宁县宾亨镇','110',1996),(26909,'广宁县五和镇','111',1996),(26910,'广宁县横山镇','112',1996),(26911,'广宁县木格镇','113',1996),(26912,'广宁县石咀镇','114',1996),(26913,'广宁县古水镇','115',1996),(26914,'广宁县洲仔镇','116',1996),(26915,'怀城镇','100',1997),(26916,'闸岗镇','101',1997),(26917,'坳仔镇','102',1997),(26918,'汶朗镇','103',1997),(26919,'甘洒镇','104',1997),(26920,'凤岗镇','105',1997),(26921,'洽水镇','106',1997),(26922,'梁村镇','107',1997),(26923,'大岗镇','108',1997),(26924,'岗坪镇','109',1997),(26925,'冷坑镇','110',1997),(26926,'马宁镇','111',1997),(26927,'蓝钟镇','112',1997),(26928,'永固镇','113',1997),(26929,'诗洞镇','114',1997),(26930,'桥头镇','115',1997),(26931,'中洲镇','116',1997),(26932,'连麦镇','118',1997),(26933,'下帅壮族瑶族乡','200',1997),(26934,'广东省第一监狱','400',1997),(26935,'江口镇','100',1998),(26936,'江川镇','101',1998),(26937,'白垢镇','102',1998),(26938,'大洲镇','103',1998),(26939,'渔涝镇','104',1998),(26940,'河儿口镇','105',1998),(26941,'连都镇','106',1998),(26942,'杏花镇','107',1998),(26943,'罗董镇','108',1998),(26944,'长岗镇','109',1998),(26945,'平凤镇','110',1998),(26946,'南丰镇','111',1998),(26947,'大玉口镇','112',1998),(26948,'都平镇','113',1998),(26949,'金装镇','114',1998),(26950,'长安镇','115',1998),(26951,'德城街道办事处','001',1999),(26952,'新圩镇','101',1999),(26953,'回龙镇','102',1999),(26954,'官圩镇','103',1999),(26955,'马圩镇','105',1999),(26956,'高良镇','106',1999),(26957,'莫村镇','107',1999),(26958,'永丰镇','109',1999),(26959,'武垄镇','110',1999),(26960,'播植镇','111',1999),(26961,'凤村镇','112',1999),(26962,'悦城镇','113',1999),(26963,'九市镇','114',1999),(26964,'南岸街道办事处','001',2000),(26965,'河台镇','100',2000),(26966,'乐城镇','101',2000),(26967,'水南镇','102',2000),(26968,'禄步镇','103',2000),(26969,'小湘镇','105',2000),(26970,'大湾镇','106',2000),(26971,'新桥镇','107',2000),(26972,'白诸镇','108',2000),(26973,'莲塘镇','109',2000),(26974,'活道镇','110',2000),(26975,'蛟塘镇','111',2000),(26976,'回龙镇','112',2000),(26977,'白土镇','113',2000),(26978,'金渡镇','114',2000),(26979,'金利镇','115',2000),(26980,'蚬岗镇','116',2000),(26981,'四会市城中街道','001',2001),(26982,'四会市东城街道','002',2001),(26983,'四会市贞山街道','003',2001),(26984,'四会市龙甫镇','100',2001),(26985,'四会市地豆镇地豆镇','101',2001),(26986,'四会市威整镇','102',2001),(26987,'四会市罗源镇','103',2001),(26988,'四会市迳口镇','104',2001),(26989,'四会市大沙镇','105',2001),(26990,'四会市石狗镇','107',2001),(26991,'四会市黄田镇','108',2001),(26992,'四会市江谷镇','110',2001),(26993,'四会市下茆镇','113',2001),(26994,'广东省济广监狱','400',2001),(26995,'肇庆高新技术产业开发区','450',2001),(26996,'桥东街道办事处','001',2002),(26997,'桥西街道办事处','002',2002),(26998,'江南街道办事处','003',2002),(26999,'江北街道办事处','004',2002),(27000,'龙丰街道办事处','005',2002),(27001,'河南岸街道办事处','006',2002),(27002,'惠环街道办事处','007',2002),(27003,'陈江街道办事处','008',2002),(27004,'水口街道办事处','009',2002),(27005,'小金口街道办事处','010',2002),(27006,'汝湖镇','100',2002),(27007,'三栋镇','103',2002),(27008,'潼湖镇','106',2002),(27009,'沥林镇','107',2002),(27010,'马安镇','109',2002),(27011,'横沥镇','110',2002),(27012,'芦洲镇','112',2002),(27013,'潼桥镇','114',2002),(27014,'惠州市林场','450',2002),(27015,'淡水街道办事处','001',2003),(27016,'秋长街道办事处','002',2003),(27017,'澳头街道办事处','006',2003),(27018,'霞涌街道办事处','007',2003),(27019,'沙田镇','101',2003),(27020,'新圩镇','103',2003),(27021,'镇隆镇','104',2003),(27022,'永湖镇','108',2003),(27023,'良井镇','109',2003),(27024,'平潭镇','110',2003),(27025,'三和开发区','570',2003),(27026,'西区街道办事处','580',2003),(27027,'石坝镇','100',2004),(27028,'麻陂镇','102',2004),(27029,'观音阁镇','103',2004),(27030,'公庄镇','104',2004),(27031,'杨村镇','105',2004),(27032,'柏塘镇','106',2004),(27033,'泰美镇','108',2004),(27034,'罗阳镇','110',2004),(27035,'湖镇镇','113',2004),(27036,'长宁镇','115',2004),(27037,'福田镇','116',2004),(27038,'龙华镇','117',2004),(27039,'龙溪镇','118',2004),(27040,'园洲镇','119',2004),(27041,'石湾镇','121',2004),(27042,'杨侨镇','122',2004),(27043,'罗浮山管委会','450',2004),(27044,'平山街道办事处','001',2005),(27045,'大岭镇','101',2005),(27046,'白花镇','102',2005),(27047,'梁化镇','103',2005),(27048,'稔山镇','104',2005),(27049,'铁涌镇','105',2005),(27050,'平海镇','106',2005),(27051,'吉隆镇','109',2005),(27052,'多祝镇','113',2005),(27053,'安墩镇','115',2005),(27054,'高潭镇','118',2005),(27055,'宝口镇','120',2005),(27056,'白盆珠镇','121',2005),(27057,'广东省惠州市国营惠东梁化林场','401',2005),(27058,'广东省惠州市国营惠东九龙峰林场','402',2005),(27059,'惠东县港口海龟湾自然保护区','403',2005),(27060,'莲花山白盆珠省级自然保护区','404',2005),(27061,'广东惠东古田省级自然保护区','405',2005),(27062,'龙城街道办事处','001',2006),(27063,'麻榨镇','100',2006),(27064,'永汉镇','101',2006),(27065,'平陵镇','106',2006),(27066,'龙田镇','115',2006),(27067,'龙潭镇','116',2006),(27068,'地派镇','117',2006),(27069,'龙华镇','118',2006),(27070,'龙江镇','119',2006),(27071,'蓝田瑶族乡','200',2006),(27072,'惠州市国营油田林场','450',2006),(27073,'龙门县青年林场','451',2006),(27074,'龙门县柑桔场','452',2006),(27075,'龙门县密溪林场','453',2006),(27076,'南昆山生态旅游区管理委员会','570',2006),(27077,'江南街道','004',2007),(27078,'金山街道','006',2007),(27079,'西郊街道','007',2007),(27080,'三角镇','102',2007),(27081,'长沙镇','103',2007),(27082,'城北镇','105',2007),(27083,'城东镇','101',2008),(27084,'石扇镇','102',2008),(27085,'梅西镇','103',2008),(27086,'大坪镇','104',2008),(27087,'石坑镇','105',2008),(27088,'水车镇','109',2008),(27089,'梅南镇','110',2008),(27090,'丙村镇','113',2008),(27091,'白渡镇','115',2008),(27092,'松源镇','116',2008),(27093,'隆文镇','117',2008),(27094,'桃尧镇','118',2008),(27095,'畲江镇','126',2008),(27096,'程江镇','127',2008),(27097,'西阳镇','128',2008),(27098,'雁洋镇','129',2008),(27099,'松口镇','130',2008),(27100,'南口镇','131',2008),(27101,'梅西水库','500',2008),(27102,'湖寮镇','100',2009),(27103,'青溪镇','103',2009),(27104,'三河镇','105',2009),(27105,'银江镇','108',2009),(27106,'洲瑞镇','109',2009),(27107,'光德镇','112',2009),(27108,'桃源镇','113',2009),(27109,'百侯镇','116',2009),(27110,'大东镇','117',2009),(27111,'大麻镇','121',2009),(27112,'枫朗镇','122',2009),(27113,'茶阳镇','123',2009),(27114,'高陂镇','124',2009),(27115,'西河镇','125',2009),(27116,'丰溪林场','400',2009),(27117,'洲瑞林场','401',2009),(27118,'大埔林场','402',2009),(27119,'北斗镇','103',2010),(27120,'汤西镇','104',2010),(27121,'汤南镇','105',2010),(27122,'埔寨镇','106',2010),(27123,'建桥镇','110',2010),(27124,'龙岗镇','111',2010),(27125,'潘田镇','112',2010),(27126,'黄金镇','114',2010),(27127,'小胜镇','122',2010),(27128,'砂田镇','123',2010),(27129,'八乡山镇','124',2010),(27130,'丰良镇','125',2010),(27131,'潭江镇','126',2010),(27132,'汤坑镇','127',2010),(27133,'留隍镇','128',2010),(27134,'大龙华镇','129',2010),(27135,'埔寨农场','450',2010),(27136,'转水镇','103',2011),(27137,'潭下镇','108',2011),(27138,'郭田镇','117',2011),(27139,'双华镇','118',2011),(27140,'梅林镇','125',2011),(27141,'华阳镇','126',2011),(27142,'华城镇','130',2011),(27143,'周江镇','131',2011),(27144,'水寨镇','134',2011),(27145,'河东镇','135',2011),(27146,'岐岭镇','136',2011),(27147,'长布镇','137',2011),(27148,'横陂镇','138',2011),(27149,'安流镇','139',2011),(27150,'棉洋镇','140',2011),(27151,'龙村镇','141',2011),(27152,'石正镇','101',2012),(27153,'八尺镇','104',2012),(27154,'差干镇','105',2012),(27155,'河头镇','107',2012),(27156,'中行镇','108',2012),(27157,'上举镇','109',2012),(27158,'泗水镇','110',2012),(27159,'长田镇','114',2012),(27160,'热柘镇','115',2012),(27161,'东石镇','117',2012),(27162,'仁居镇','118',2012),(27163,'大柘镇','119',2012),(27164,'三圳镇','103',2013),(27165,'文福镇','106',2013),(27166,'广福镇','107',2013),(27167,'新铺镇','112',2013),(27168,'蓝坊镇','113',2013),(27169,'南礤镇','114',2013),(27170,'蕉城镇','115',2013),(27171,'长潭镇','116',2013),(27172,'华侨农场','450',2013),(27173,'广东省蕉岭监狱','498',2013),(27174,'兴田街道办事处','001',2014),(27175,'福兴街道办事处','002',2014),(27176,'宁新街道办事处','003',2014),(27177,'永和镇','107',2014),(27178,'新圩镇','111',2014),(27179,'罗浮镇','115',2014),(27180,'罗岗镇','116',2014),(27181,'黄槐镇','117',2014),(27182,'龙田镇','123',2014),(27183,'石马镇','124',2014),(27184,'宁中镇','128',2014),(27185,'径南镇','129',2014),(27186,'坭陂镇','130',2014),(27187,'水口镇','131',2014),(27188,'黄陂镇','132',2014),(27189,'合水镇','133',2014),(27190,'大坪镇','134',2014),(27191,'叶塘镇','135',2014),(27192,'新陂镇','136',2014),(27193,'刁坊镇','137',2014),(27194,'新港街道','001',2016),(27195,'香洲街道','002',2016),(27196,'凤山街道','003',2016),(27197,'田','004',2016),(27198,'东洲街道','005',2016),(27199,'遮浪街道','006',2016),(27200,'马宫街道','007',2016),(27201,'红草镇','100',2016),(27202,'东冲镇','102',2016),(27203,'捷胜镇','103',2016),(27204,'梅陇镇','101',2017),(27205,'小漠镇','102',2017),(27206,'后门镇','105',2017),(27207,'联安镇','106',2017),(27208,'陶河镇','107',2017),(27209,'赤坑镇','108',2017),(27210,'大湖镇','109',2017),(27211,'可塘镇','110',2017),(27212,'黄羌镇','112',2017),(27213,'平东镇','113',2017),(27214,'海城镇','115',2017),(27215,'鹅埠镇','116',2017),(27216,'赤石镇','117',2017),(27217,'公平镇','118',2017),(27218,'附城虚拟乡','202',2017),(27219,'城东虚拟乡','203',2017),(27220,'梅陇农场','450',2017),(27221,'河田镇','100',2018),(27222,'水唇镇','101',2018),(27223,'河口镇','102',2018),(27224,'新田镇','103',2018),(27225,'上护镇','104',2018),(27226,'螺溪镇','105',2018),(27227,'东坑镇','106',2018),(27228,'南万镇','107',2018),(27229,'东海镇','100',2019),(27230,'甲子镇','101',2019),(27231,'碣石镇','102',2019),(27232,'湖东镇','103',2019),(27233,'大安镇','104',2019),(27234,'博美镇','105',2019),(27235,'内湖镇','106',2019),(27236,'南塘镇','107',2019),(27237,'陂洋镇','108',2019),(27238,'八万镇','109',2019),(27239,'金厢镇','110',2019),(27240,'潭西镇','111',2019),(27241,'甲东镇','112',2019),(27242,'河西镇','113',2019),(27243,'城东镇','114',2019),(27244,'河东镇','115',2019),(27245,'上英镇','116',2019),(27246,'桥冲镇','117',2019),(27247,'甲西镇','118',2019),(27248,'西南镇','119',2019),(27249,'华侨管理区虚拟乡','202',2019),(27250,'铜锣湖农场','450',2019),(27251,'星都经济开发试验区','451',2019),(27252,'大安场','452',2019),(27253,'罗经嶂林场','453',2019),(27254,'湖东林场','454',2019),(27255,'东海岸林场','455',2019),(27256,'红岭林场','456',2019),(27257,'畜牧果林场','457',2019),(27258,'上城街道办事处','001',2020),(27259,'新江街道办事处','002',2020),(27260,'东埔街道办事处','003',2020),(27261,'源西街道办事处','004',2020),(27262,'源南镇','100',2020),(27263,'埔前镇','101',2020),(27264,'高埔岗农场','400',2020),(27265,'紫城镇','100',2021),(27266,'附城镇','101',2021),(27267,'龙窝镇','102',2021),(27268,'九和镇','103',2021),(27269,'上义镇','104',2021),(27270,'蓝塘镇','105',2021),(27271,'凤安镇','106',2021),(27272,'义容镇','107',2021),(27273,'古竹镇','108',2021),(27274,'临江镇','109',2021),(27275,'柏埔镇','110',2021),(27276,'黄塘镇','111',2021),(27277,'敬梓镇','112',2021),(27278,'乌石镇','113',2021),(27279,'水墩镇','114',2021),(27280,'南岭镇','115',2021),(27281,'苏区镇','116',2021),(27282,'瓦溪镇','117',2021),(27283,'好义镇','118',2021),(27284,'中坝镇','119',2021),(27285,'老隆镇','100',2022),(27286,'附城镇','101',2022),(27287,'义都镇','102',2022),(27288,'佗城镇','103',2022),(27289,'鹤市镇','104',2022),(27290,'黄布镇','105',2022),(27291,'紫市镇','106',2022),(27292,'通衢镇','107',2022),(27293,'登云镇','109',2022),(27294,'丰稔镇','110',2022),(27295,'四都镇','111',2022),(27296,'铁场镇','112',2022),(27297,'龙母镇','114',2022),(27298,'田心镇','115',2022),(27299,'黎咀镇','116',2022),(27300,'黄石镇','117',2022),(27301,'赤光镇','118',2022),(27302,'回龙镇','119',2022),(27303,'新田镇','120',2022),(27304,'车田镇','121',2022),(27305,'岩镇镇','123',2022),(27306,'麻布岗镇','124',2022),(27307,'贝岭镇','125',2022),(27308,'细坳镇','126',2022),(27309,'上坪镇','127',2022),(27310,'元善镇','100',2023),(27311,'上坪镇','101',2023),(27312,'内莞镇','102',2023),(27313,'陂头镇','104',2023),(27314,'溪山镇','105',2023),(27315,'隆街镇','107',2023),(27316,'田源镇','108',2023),(27317,'油溪镇','109',2023),(27318,'忠信镇','110',2023),(27319,'高莞镇','111',2023),(27320,'大湖镇','113',2023),(27321,'三角镇','114',2023),(27322,'绣缎镇','115',2023),(27323,'阳明镇','100',2024),(27324,'大坝镇','101',2024),(27325,'长塘镇','102',2024),(27326,'下车镇','103',2024),(27327,'上陵镇','104',2024),(27328,'优胜镇','105',2024),(27329,'贝墩镇','106',2024),(27330,'古寨镇','107',2024),(27331,'彭寨镇','108',2024),(27332,'合水镇','109',2024),(27333,'公白镇','110',2024),(27334,'青州镇','111',2024),(27335,'俐源镇','112',2024),(27336,'热水镇','113',2024),(27337,'东水镇','114',2024),(27338,'礼士镇','115',2024),(27339,'林寨镇','116',2024),(27340,'仙塘镇','100',2025),(27341,'灯塔镇','101',2025),(27342,'骆湖镇','102',2025),(27343,'船塘镇','103',2025),(27344,'顺天镇','104',2025),(27345,'上莞镇','105',2025),(27346,'曾田镇','106',2025),(27347,'柳城镇','107',2025),(27348,'义合镇','108',2025),(27349,'蓝口镇','109',2025),(27350,'黄田镇','110',2025),(27351,'叶潭镇','111',2025),(27352,'黄村镇','112',2025),(27353,'康禾镇','113',2025),(27354,'锡场镇','114',2025),(27355,'新港镇','115',2025),(27356,'双江镇','116',2025),(27357,'涧头镇','117',2025),(27358,'新回龙镇','121',2025),(27359,'半江镇','122',2025),(27360,'漳溪乡','200',2025),(27361,'南恩街道办事处','001',2026),(27362,'城南街道办事处','002',2026),(27363,'城北街道办事处','003',2026),(27364,'中洲街道办事处','004',2026),(27365,'城东街道办事处','006',2026),(27366,'岗列街道办事处','008',2026),(27367,'城西街道办事处','009',2026),(27368,'白沙街道办事处','011',2026),(27369,'埠场镇','102',2026),(27370,'平冈镇','103',2026),(27371,'海陵镇','104',2026),(27372,'闸坡镇','105',2026),(27373,'双捷镇','106',2026),(27374,'阳江林场罗琴分场','401',2026),(27375,'平冈农场','450',2026),(27376,'红十月农场','453',2026),(27377,'织贡镇','100',2027),(27378,'程村镇','101',2027),(27379,'塘口镇','102',2027),(27380,'上洋镇','103',2027),(27381,'溪头镇','104',2027),(27382,'沙扒镇','105',2027),(27383,'儒洞镇','106',2027),(27384,'新圩镇','107',2027),(27385,'织贡农场','501',2027),(27386,'阳江林场儒洞分场','502',2027),(27387,'东城镇','100',2028),(27388,'北惯镇','101',2028),(27389,'那龙镇','102',2028),(27390,'东平镇','103',2028),(27391,'雅韶镇','104',2028),(27392,'大沟镇','105',2028),(27393,'新洲镇','106',2028),(27394,'合山镇','107',2028),(27395,'塘坪镇','108',2028),(27396,'大八镇','109',2028),(27397,'红丰镇','110',2028),(27398,'阳江监狱','400',2028),(27399,'红五月农场','401',2028),(27400,'鸡山农场','402',2028),(27401,'阳江林场宝山分场','501',2028),(27402,'阳江林场田畔分场','502',2028),(27403,'阳东原种场','503',2028),(27404,'阳东林场','504',2028),(27405,'阳江林场东岸分场','505',2028),(27406,'春城街道办事处','001',2029),(27407,'河朗镇','101',2029),(27408,'松柏镇','102',2029),(27409,'石望镇','103',2029),(27410,'春湾镇','105',2029),(27411,'合水镇','106',2029),(27412,'陂面镇','107',2029),(27413,'圭岗镇','108',2029),(27414,'永宁镇','109',2029),(27415,'马水镇','110',2029),(27416,'岗美镇','111',2029),(27417,'河口镇','112',2029),(27418,'潭水镇','113',2029),(27419,'三甲镇','114',2029),(27420,'双窖镇','116',2029),(27421,'八甲镇','117',2029),(27422,'岗桥管理区','401',2029),(27423,'三叶农场','402',2029),(27424,'石录矿区','403',2029),(27425,'花滩林场','404',2029),(27426,'东湖林场','405',2029),(27427,'河尾山林场','406',2029),(27428,'南山矿','407',2029),(27429,'阳春监狱','408',2029),(27430,'硫铁矿','410',2029),(27431,'清城区凤城街道办事处','006',2030),(27432,'清城区东城街道办事处','007',2030),(27433,'清城区洲心街道办事处','008',2030),(27434,'清城区横荷街道办事处','009',2030),(27435,'清城区源潭镇','103',2030),(27436,'清城区龙塘镇','105',2030),(27437,'清城区石角镇','106',2030),(27438,'清远市国营银盏林场','450',2030),(27439,'石角镇','100',2031),(27440,'水头镇','101',2031),(27441,'汤塘镇','102',2031),(27442,'龙山镇','103',2031),(27443,'高岗镇','104',2031),(27444,'迳头镇','107',2031),(27445,'青莲镇','100',2032),(27446,'江英镇','101',2032),(27447,'杜步镇','104',2032),(27448,'七拱镇','105',2032),(27449,'太平镇','107',2032),(27450,'杨梅镇','108',2032),(27451,'大莨镇','110',2032),(27452,'小江镇','111',2032),(27453,'岭背镇','113',2032),(27454,'黄坌镇','115',2032),(27455,'黎埠镇','116',2032),(27456,'阳城镇','119',2032),(27457,'秤架乡','201',2032),(27458,'连山县永和镇','100',2033),(27459,'连山县吉田镇','104',2033),(27460,'连山县太保镇','105',2033),(27461,'连山县禾洞镇','106',2033),(27462,'连山县福堂镇','108',2033),(27463,'连山县小三江镇','109',2033),(27464,'连山县上帅镇','111',2033),(27465,'连山县连山林场','450',2033),(27466,'连山县禾洞农林场','451',2033),(27467,'三江镇','100',2034),(27468,'大麦山镇','101',2034),(27469,'寨岗镇','102',2034),(27470,'三排镇','105',2034),(27471,'涡水镇','106',2034),(27472,'大坪镇','108',2034),(27473,'香坪镇','109',2034),(27474,'太和镇','102',2035),(27475,'太平镇','104',2035),(27476,'山塘镇','105',2035),(27477,'三坑镇','106',2035),(27478,'龙颈镇','112',2035),(27479,'禾云镇','113',2035),(27480,'浸潭镇','117',2035),(27481,'石潭镇','118',2035),(27482,'飞来峡镇','123',2035),(27483,'笔架林场','450',2035),(27484,'英城街道办事处','001',2036),(27485,'沙口镇','101',2036),(27486,'望埠镇','102',2036),(27487,'横石水镇','103',2036),(27488,'桥头镇','105',2036),(27489,'青塘镇','106',2036),(27490,'白沙镇','108',2036),(27491,'大站镇','109',2036),(27492,'西牛镇','110',2036),(27493,'九龙镇','111',2036),(27494,'含光镇','112',2036),(27495,'大湾镇','114',2036),(27496,'石灰铺镇','115',2036),(27497,'石牯塘镇','116',2036),(27498,'下太镇','120',2036),(27499,'波罗镇','124',2036),(27500,'横石塘镇','125',2036),(27501,'大洞镇','126',2036),(27502,'连江口镇','129',2036),(27503,'黎溪镇','130',2036),(27504,'水边镇','131',2036),(27505,'英红镇','136',2036),(27506,'东华镇','137',2036),(27507,'黄花镇','138',2036),(27508,'英德监狱','400',2036),(27509,'连州镇','100',2037),(27510,'星子镇','101',2037),(27511,'大路边镇','102',2037),(27512,'龙坪镇','103',2037),(27513,'西岸镇','104',2037),(27514,'保安镇','105',2037),(27515,'丰阳镇','106',2037),(27516,'东陂镇','107',2037),(27517,'九陂镇','109',2037),(27518,'西江镇','118',2037),(27519,'瑶安瑶族乡','200',2037),(27520,'三水瑶族乡','201',2037),(27521,'东城街道办事处','003',2037),(27522,'南城街道办事处','004',2037),(27523,'万江街道办事处','005',2037),(27524,'莞城街道办事处','006',2037),(27525,'石碣镇','101',2037),(27526,'石龙镇','102',2037),(27527,'茶山镇','103',2037),(27528,'石排镇','104',2037),(27529,'企石镇','105',2037),(27530,'横沥镇','106',2037),(27531,'桥头镇','107',2037),(27532,'谢岗镇','108',2037),(27533,'东坑镇','109',2037),(27534,'常平镇','110',2037),(27535,'寮步镇','111',2037),(27536,'樟木头镇','112',2037),(27537,'大朗镇','113',2037),(27538,'黄江镇','114',2037),(27539,'清溪镇','115',2037),(27540,'塘厦镇','116',2037),(27541,'凤岗镇','117',2037),(27542,'大岭山镇','118',2037),(27543,'长安镇','119',2037),(27544,'虎门镇','121',2037),(27545,'厚街镇','122',2037),(27546,'沙田镇','123',2037),(27547,'道','124',2037),(27548,'洪梅镇','125',2037),(27549,'麻涌镇','126',2037),(27550,'望牛墩镇','127',2037),(27551,'中堂镇','128',2037),(27552,'高','129',2037),(27553,'松山湖管委会','401',2037),(27554,'虎门港管委会','402',2037),(27555,'石岐区','001',2037),(27556,'东区','002',2037),(27557,'火炬高技术产业开发区','003',2037),(27558,'西区','004',2037),(27559,'南区办事处','005',2037),(27560,'五桂山办事处','006',2037),(27561,'小榄镇','100',2037),(27562,'黄圃镇','101',2037),(27563,'民众镇','102',2037),(27564,'东凤镇','103',2037),(27565,'东升镇','104',2037),(27566,'古镇镇','105',2037),(27567,'沙溪镇','106',2037),(27568,'坦洲镇','107',2037),(27569,'港口镇','108',2037),(27570,'三角镇','109',2037),(27571,'横栏镇','110',2037),(27572,'南头镇','111',2037),(27573,'阜沙镇','112',2037),(27574,'南朗镇','113',2037),(27575,'三乡镇','114',2037),(27576,'板芙镇','115',2037),(27577,'大涌镇','116',2037),(27578,'神湾镇','117',2037),(27579,'潮州市湘桥区湘桥街道','001',2038),(27580,'潮州市湘桥区西湖街道','002',2038),(27581,'潮州市湘桥区金山街道','003',2038),(27582,'潮州市湘桥区太平街道','004',2038),(27583,'潮州市湘桥区南春街道','005',2038),(27584,'潮州市湘桥区西新街道','006',2038),(27585,'潮州市湘桥区桥东街道','007',2038),(27586,'潮州市湘桥区城西街道','008',2038),(27587,'潮州市湘桥区凤新街道','009',2038),(27588,'潮州市湘桥区意溪镇','100',2038),(27589,'潮州市湘桥区红山林场','400',2038),(27590,'潮州市开发区','401',2038),(27591,'潮州市潮安县古巷镇','100',2039),(27592,'潮州市潮安县登塘镇','101',2039),(27593,'潮州市潮安县凤塘镇','103',2039),(27594,'潮州市潮安县浮洋镇','104',2039),(27595,'潮州市潮安县龙湖镇','105',2039),(27596,'潮州市潮安县金石镇','106',2039),(27597,'潮州市潮安县沙溪镇','107',2039),(27598,'潮州市潮安县彩塘镇','108',2039),(27599,'潮州市潮安县东凤镇','109',2039),(27600,'潮州市潮安县庵埠镇','110',2039),(27601,'潮州市潮安县磷溪镇','111',2039),(27602,'潮州市潮安县铁铺镇','112',2039),(27603,'潮州市潮安县官塘镇','113',2039),(27604,'潮州市潮安县江东镇','114',2039),(27605,'潮州市潮安县归湖镇','115',2039),(27606,'潮州市潮安县文祠镇','116',2039),(27607,'潮州市潮安县凤凰镇','117',2039),(27608,'潮州市潮安县赤凤镇','120',2039),(27609,'潮州市枫溪区','121',2039),(27610,'潮州市潮安县万峰林场','400',2039),(27611,'潮州市潮安县大坑苗圃场','404',2039),(27612,'潮州市潮安县东山湖农场','405',2039),(27613,'潮州市潮安县庵埠经济开发试验区','450',2039),(27614,'潮州市饶平县黄冈镇','100',2040),(27615,'潮州市饶平县上饶镇','102',2040),(27616,'潮州市饶平县饶洋镇','103',2040),(27617,'潮州市饶平县新丰镇','104',2040),(27618,'潮州市饶平县建饶镇','106',2040),(27619,'潮州市饶平县三饶镇','107',2040),(27620,'潮州市饶平县新塘镇','108',2040),(27621,'潮州市饶平县汤溪镇','109',2040),(27622,'潮州市饶平县浮滨镇','110',2040),(27623,'潮州市饶平县浮山镇','112',2040),(27624,'潮州市饶平县东山镇','113',2040),(27625,'潮州市饶平县新圩镇','114',2040),(27626,'潮州市饶平县樟溪镇','116',2040),(27627,'潮州市饶平县钱东镇','117',2040),(27628,'潮州市饶平县高堂镇','118',2040),(27629,'潮州市饶平县联饶镇','119',2040),(27630,'潮州市饶平县所城镇','120',2040),(27631,'潮州市饶平县大埕镇','121',2040),(27632,'潮州市饶平县柘林镇','122',2040),(27633,'潮州市饶平县井洲镇','123',2040),(27634,'潮州市饶平县海山镇','124',2040),(27635,'潮州市饶平县韩江林场','400',2040),(27636,'榕华街道办事处','001',2041),(27637,'新兴街道办事处','002',2041),(27638,'中山街道办事处','003',2041),(27639,'西马街道办事处','004',2041),(27640,'东山街道办事处','005',2041),(27641,'榕东街道办事处','006',2041),(27642,'仙桥街道办事处','007',2041),(27643,'梅云街道办事处','008',2041),(27644,'渔湖镇','101',2041),(27645,'磐东镇','104',2041),(27646,'曲溪街道办事处','001',2042),(27647,'云路镇','102',2042),(27648,'玉窖镇','103',2042),(27649,'登岗镇','104',2042),(27650,'炮台镇','105',2042),(27651,'地都镇','106',2042),(27652,'霖磐镇','107',2042),(27653,'月城镇','108',2042),(27654,'白塔镇','109',2042),(27655,'龙尾镇','110',2042),(27656,'桂岭镇','111',2042),(27657,'锡场镇','112',2042),(27658,'新亨镇','113',2042),(27659,'玉湖镇','114',2042),(27660,'埔田镇','115',2042),(27661,'东径茶场','401',2042),(27662,'卅岭农场','403',2042),(27663,'河婆街道办事处','001',2043),(27664,'龙潭镇','102',2043),(27665,'南山镇','103',2043),(27666,'五经富镇','104',2043),(27667,'京溪园镇','105',2043),(27668,'灰寨镇','106',2043),(27669,'塔头镇','107',2043),(27670,'东园镇','108',2043),(27671,'凤江镇','109',2043),(27672,'棉湖镇','110',2043),(27673,'金和镇','111',2043),(27674,'大溪镇','112',2043),(27675,'钱坑镇','113',2043),(27676,'坪上镇','114',2043),(27677,'五云镇','115',2043),(27678,'上砂镇','116',2043),(27679,'良田乡','201',2043),(27680,'北山农林场','401',2043),(27681,'果林场','402',2043),(27682,'油桐林场','403',2043),(27683,'高田农场','404',2043),(27684,'河','405',2043),(27685,'县苗圃场','406',2043),(27686,'惠城镇','100',2044),(27687,'华湖镇','102',2044),(27688,'仙庵镇','103',2044),(27689,'靖海镇','104',2044),(27690,'周田镇','105',2044),(27691,'前詹镇','106',2044),(27692,'神泉镇','107',2044),(27693,'东陇镇','108',2044),(27694,'岐石镇','109',2044),(27695,'隆江镇','110',2044),(27696,'溪西镇','111',2044),(27697,'鳌江镇','112',2044),(27698,'东港镇','113',2044),(27699,'葵潭镇','114',2044),(27700,'东埔农场','401',2044),(27701,'揭阳市大南山华侨管理区','402',2044),(27702,'葵潭农场','403',2044),(27703,'青坑林场','404',2044),(27704,'南海农林场','405',2044),(27705,'四香果林场','406',2044),(27706,'揭阳（惠来）沿海经济开发试验区','450',2044),(27707,'流沙东街道','001',2045),(27708,'流沙南街道','002',2045),(27709,'流沙西街道','003',2045),(27710,'流沙北街道','004',2045),(27711,'池尾街道','005',2045),(27712,'赤岗镇','102',2045),(27713,'大坝镇','103',2045),(27714,'洪阳镇','104',2045),(27715,'南溪镇','105',2045),(27716,'广太镇','106',2045),(27717,'麒麟镇','107',2045),(27718,'南径镇','108',2045),(27719,'占陇镇','109',2045),(27720,'军埠镇','110',2045),(27721,'下架山镇','111',2045),(27722,'大南山镇','112',2045),(27723,'高埔镇','113',2045),(27724,'云落镇','114',2045),(27725,'大坪镇','115',2045),(27726,'船埔镇','116',2045),(27727,'梅林镇','117',2045),(27728,'里湖镇','119',2045),(27729,'梅塘镇','121',2045),(27730,'燎原镇','122',2045),(27731,'后溪乡','201',2045),(27732,'大池农场','401',2045),(27733,'马鞍山农场','402',2045),(27734,'大坪农场','403',2045),(27735,'普侨区','404',2045),(27736,'三坑农场','405',2045),(27737,'乌石农场','406',2045),(27738,'云城街道','001',2046),(27739,'高峰街道','002',2046),(27740,'河口街道','003',2046),(27741,'安塘街道','004',2046),(27742,'腰古镇','102',2046),(27743,'思劳镇','103',2046),(27744,'都杨镇','104',2046),(27745,'新城镇','100',2047),(27746,'车岗镇','101',2047),(27747,'水台镇','103',2047),(27748,'稔村镇','104',2047),(27749,'东成镇','105',2047),(27750,'太平镇','107',2047),(27751,'里洞镇','108',2047),(27752,'六祖镇','109',2047),(27753,'大江镇','110',2047),(27754,'天堂镇','112',2047),(27755,'河头镇','113',2047),(27756,'勒竹镇','114',2047),(27757,'国营良洞迳林场','401',2047),(27758,'国营水台林场','402',2047),(27759,'国营岩头林场','403',2047),(27760,'都城镇','100',2048),(27761,'平台镇','101',2048),(27762,'桂圩镇','102',2048),(27763,'通门镇','104',2048),(27764,'建城镇','105',2048),(27765,'宝珠镇','106',2048),(27766,'大方镇','108',2048),(27767,'千官镇','110',2048),(27768,'大湾镇','111',2048),(27769,'河口镇','112',2048),(27770,'宋桂镇','113',2048),(27771,'东坝镇','114',2048),(27772,'连滩镇','115',2048),(27773,'历洞镇','116',2048),(27774,'南江口镇','117',2048),(27775,'西江林场','401',2048),(27776,'通门林场','402',2048),(27777,'大历林场','403',2048),(27778,'同乐林场','404',2048),(27779,'六都镇','100',2049),(27780,'高村镇','101',2049),(27781,'白石镇','102',2049),(27782,'镇安镇','103',2049),(27783,'富林镇','104',2049),(27784,'南盛镇','107',2049),(27785,'前锋镇','108',2049),(27786,'石城镇','109',2049),(27787,'罗城街道','001',2050),(27788,'素龙街道','002',2050),(27789,'附城街道','003',2050),(27790,'双东镇街道','004',2050),(27791,'罗镜镇','100',2050),(27792,'太平镇','101',2050),(27793,'分界镇','102',2050),(27794,'罗平镇','104',2050),(27795,'船步镇','105',2050),(27796,'满塘镇','106',2050),(27797,'苹塘镇','107',2050),(27798,'金鸡镇','108',2050),(27799,'围底镇','109',2050),(27800,'华石镇','110',2050),(27801,'林滨镇','111',2050),(27802,'黎少镇','113',2050),(27803,'生江镇','114',2050),(27804,'连州镇','115',2050),(27805,'泗纶镇','116',2050),(27806,'加益镇','118',2050),(27807,'龙湾镇','119',2050),(27808,'罗平农场','120',2050),(27809,'民生街道办事处','001',2052),(27810,'朝阳街道办事处','002',2052),(27811,'三塘镇','101',2052),(27812,'五塘镇','102',2052),(27813,'昆仑镇','104',2052),(27814,'九曲湾农场','450',2052),(27815,'新竹街道办事处','001',2053),(27816,'中山街道办事处','002',2053),(27817,'建政街道办事处','003',2053),(27818,'南湖街道办事处','004',2053),(27819,'津头街道办事处','005',2053),(27820,'刘圩镇','100',2053),(27821,'南阳镇','101',2053),(27822,'伶俐镇','102',2053),(27823,'长塘镇','103',2053),(27824,'南宁市仙葫经济开发区','450',2053),(27825,'南宁市青秀山管理委员会','451',2053),(27826,'福建园街道办事处','001',2054),(27827,'江南街道办事处','002',2054),(27828,'沙井街道办事处','003',2054),(27829,'那洪街道办事处','004',2054),(27830,'吴圩镇','102',2054),(27831,'苏圩镇','103',2054),(27832,'延安镇','104',2054),(27833,'江西镇','105',2054),(27834,'经济技术开发区','450',2054),(27835,'衡阳街道办事处','001',2055),(27836,'北湖街道办事处','002',2055),(27837,'西乡塘街道办事处','003',2055),(27838,'安吉街道办事处','004',2055),(27839,'华强街道办事处','005',2055),(27840,'新阳街道办事处','006',2055),(27841,'上尧街道办事处','007',2055),(27842,'安宁街道办事处','008',2055),(27843,'石埠街道办事处','009',2055),(27844,'心圩街道办事处','010',2055),(27845,'金陵镇','100',2055),(27846,'双定镇','101',2055),(27847,'坛洛镇','105',2055),(27848,'那龙矿务局','450',2055),(27849,'罗文农场','451',2055),(27850,'石埠奶场','452',2055),(27851,'金光农场','453',2055),(27852,'良庆镇','100',2056),(27853,'那马镇','101',2056),(27854,'那陈镇','102',2056),(27855,'大塘镇','103',2056),(27856,'南晓镇','104',2056),(27857,'南宁市大沙田经济开发区','450',2056),(27858,'南宁市沿海经济开发区','451',2056),(27859,'蒲庙镇','100',2057),(27860,'那楼镇','101',2057),(27861,'新江镇','102',2057),(27862,'百济乡','200',2057),(27863,'中和乡','202',2057),(27864,'城厢镇','100',2058),(27865,'太平镇','102',2058),(27866,'双桥镇','103',2058),(27867,'宁武镇','104',2058),(27868,'锣圩镇','105',2058),(27869,'仙湖镇','106',2058),(27870,'府城镇','107',2058),(27871,'陆斡镇','108',2058),(27872,'两江镇','109',2058),(27873,'罗波镇','110',2058),(27874,'灵马镇','111',2058),(27875,'甘圩镇','112',2058),(27876,'马头镇','113',2058),(27877,'百合农场','450',2058),(27878,'华侨投资区','451',2058),(27879,'东风农场','452',2058),(27880,'城厢镇','100',2059),(27881,'南圩镇','101',2059),(27882,'雁江镇','102',2059),(27883,'那桐镇','103',2059),(27884,'乔建镇','104',2059),(27885,'丁当镇','105',2059),(27886,'古潭乡','201',2059),(27887,'都结乡','203',2059),(27888,'布泉乡','204',2059),(27889,'屏山乡','205',2059),(27890,'隆安华侨经济区管理委员会','450',2059),(27891,'白山镇','100',2060),(27892,'百龙滩镇','101',2060),(27893,'林圩镇','102',2060),(27894,'古零镇','103',2060),(27895,'金钗镇','104',2060),(27896,'周鹿镇','105',2060),(27897,'永州镇','106',2060),(27898,'乔利乡','200',2060),(27899,'加方乡','201',2060),(27900,'古寨瑶族乡','202',2060),(27901,'里当瑶族乡','203',2060),(27902,'马山县光明山林场','450',2060),(27903,'大丰镇','100',2061),(27904,'明亮镇','101',2061),(27905,'巷贤镇','102',2061),(27906,'白圩镇','103',2061),(27907,'三里镇','104',2061),(27908,'乔贤镇','105',2061),(27909,'西燕镇','106',2061),(27910,'澄泰乡','200',2061),(27911,'木山乡','202',2061),(27912,'塘红乡','203',2061),(27913,'镇圩瑶族乡','205',2061),(27914,'芦圩镇','100',2062),(27915,'黎塘镇','101',2062),(27916,'甘棠镇','102',2062),(27917,'思陇镇','103',2062),(27918,'新桥镇','104',2062),(27919,'新圩镇','105',2062),(27920,'邹圩镇','106',2062),(27921,'大桥镇','107',2062),(27922,'武陵镇','108',2062),(27923,'中华镇','109',2062),(27924,'古辣镇','110',2062),(27925,'露圩镇','111',2062),(27926,'王灵镇','112',2062),(27927,'和吉镇','113',2062),(27928,'洋桥镇','114',2062),(27929,'陈平乡','200',2062),(27930,'廖平农场','451',2062),(27931,'横州镇','100',2063),(27932,'百合镇','101',2063),(27933,'那阳镇','102',2063),(27934,'南乡镇','103',2063),(27935,'新福镇','104',2063),(27936,'莲塘镇','105',2063),(27937,'平马镇','106',2063),(27938,'峦城镇','107',2063),(27939,'六景镇','108',2063),(27940,'石塘镇','110',2063),(27941,'陶圩镇','112',2063),(27942,'校椅镇','113',2063),(27943,'云表镇','114',2063),(27944,'马岭镇','115',2063),(27945,'马山乡','200',2063),(27946,'平朗乡','203',2063),(27947,'镇龙乡','204',2063),(27948,'广西农垦国有良圻农场','450',2063),(27949,'城中街道办事处','001',2065),(27950,'公园街道办事处','002',2065),(27951,'中南街道办事处','003',2065),(27952,'水上街道办事处','004',2065),(27953,'潭中街道办事处','005',2065),(27954,'河东街道办事处','006',2065),(27955,'静兰街道办事处','007',2065),(27956,'天马街道办事处','001',2066),(27957,'驾鹤街道办事处','002',2066),(27958,'箭盘街道办事处','003',2066),(27959,'五里亭街道办事处','004',2066),(27960,'荣军街道办事处','005',2066),(27961,'白莲街道办事处','006',2066),(27962,'麒麟街道办事处','007',2066),(27963,'阳和街道办事处','008',2066),(27964,'河西街道办事处','001',2067),(27965,'南站街道办事处','002',2067),(27966,'鹅山街道办事处','003',2067),(27967,'柳南街道办事处','004',2067),(27968,'柳石街道办事处','005',2067),(27969,'银山街道办事处','006',2067),(27970,'潭西街道办事处','007',2067),(27971,'南环街道办事处','008',2067),(27972,'太阳村镇','100',2067),(27973,'解放街道办事处','001',2068),(27974,'雅儒街道办事处','002',2068),(27975,'胜利街道办事处','003',2068),(27976,'雀儿山街道办事处','004',2068),(27977,'钢城街道办事处','005',2068),(27978,'锦绣街道办事处','006',2068),(27979,'白露街道办事处','007',2068),(27980,'柳长街道办事处','008',2068),(27981,'石碑坪镇','100',2068),(27982,'沙塘镇','101',2068),(27983,'长塘镇','102',2068),(27984,'洛埠镇','103',2068),(27985,'拉堡镇','100',2069),(27986,'里雍镇','101',2069),(27987,'百朋镇','102',2069),(27988,'成团镇','103',2069),(27989,'洛满镇','104',2069),(27990,'流山镇','105',2069),(27991,'三都镇','106',2069),(27992,'里高镇','107',2069),(27993,'进德镇','108',2069),(27994,'穿山镇','109',2069),(27995,'土博镇','110',2069),(27996,'白沙乡','200',2069),(27997,'大埔镇','100',2070),(27998,'龙头镇','101',2070),(27999,'太平镇','102',2070),(28000,'沙埔镇','103',2070),(28001,'东泉镇','104',2070),(28002,'凤山镇','105',2070),(28003,'六塘镇','106',2070),(28004,'冲脉镇','107',2070),(28005,'寨隆镇','108',2070),(28006,'古砦仫佬族乡','200',2070),(28007,'马山乡','201',2070),(28008,'社冲乡','202',2070),(28009,'鹿寨镇','100',2071),(28010,'雒容镇','101',2071),(28011,'中渡镇','102',2071),(28012,'寨沙镇','103',2071),(28013,'平山镇','104',2071),(28014,'黄冕乡','200',2071),(28015,'江口乡','201',2071),(28016,'导江乡','202',2071),(28017,'拉沟乡','203',2071),(28018,'四排乡','204',2071),(28019,'长安镇','100',2072),(28020,'浮石镇','101',2072),(28021,'泗顶镇','102',2072),(28022,'板榄镇','103',2072),(28023,'大将镇','104',2072),(28024,'大良镇','105',2072),(28025,'雅瑶乡','200',2072),(28026,'大坡乡','201',2072),(28027,'东起乡','202',2072),(28028,'沙子乡','203',2072),(28029,'桥板乡','204',2072),(28030,'潭头乡','205',2072),(28031,'融水镇','100',2073),(28032,'和睦镇','101',2073),(28033,'三防镇','102',2073),(28034,'怀宝镇','103',2073),(28035,'永乐乡','200',2073),(28036,'四荣乡','201',2073),(28037,'香粉乡','202',2073),(28038,'安太乡','203',2073),(28039,'洞头乡','204',2073),(28040,'汪洞乡','205',2073),(28041,'同练瑶族乡','206',2073),(28042,'滚贝侗族乡','207',2073),(28043,'杆洞乡','208',2073),(28044,'安陲乡','209',2073),(28045,'大浪乡','210',2073),(28046,'白云乡','211',2073),(28047,'红水乡','212',2073),(28048,'拱洞乡','213',2073),(28049,'良寨乡','214',2073),(28050,'大年乡','215',2073),(28051,'古宜镇','100',2074),(28052,'斗江镇','101',2074),(28053,'丹洲镇','102',2074),(28054,'独峒乡','200',2074),(28055,'八江乡','201',2074),(28056,'林溪乡','202',2074),(28057,'同乐苗族乡','203',2074),(28058,'梅林乡','204',2074),(28059,'富禄苗族乡','205',2074),(28060,'洋溪乡','206',2074),(28061,'良口乡','207',2074),(28062,'老堡乡','208',2074),(28063,'高基瑶族乡','209',2074),(28064,'和平乡','210',2074),(28065,'程村乡','211',2074),(28066,'秀峰街道办事处','001',2076),(28067,'丽君街道办事处','002',2076),(28068,'甲山街道办事处','003',2076),(28069,'叠彩街道办事处','001',2077),(28070,'北门街道办事处','002',2077),(28071,'大河乡','200',2077),(28072,'南门街道办事处','001',2078),(28073,'象山街道办事处','002',2078),(28074,'平山街道办事处','003',2078),(28075,'二塘乡','200',2078),(28076,'七星区街道办事处','001',2079),(28077,'东江街道办事处','002',2079),(28078,'穿山街道办事处','003',2079),(28079,'朝阳乡','200',2079),(28080,'桂林华侨农场','450',2079),(28081,'雁山街道办事处','001',2080),(28082,'雁山镇','100',2080),(28083,'柘木镇','101',2080),(28084,'大埠乡','200',2080),(28085,'草坪回族乡','201',2080),(28086,'阳朔镇','100',2081),(28087,'白沙镇','101',2081),(28088,'福利镇','102',2081),(28089,'兴坪镇','103',2081),(28090,'葡萄镇','104',2081),(28091,'高田镇','105',2081),(28092,'金宝乡','200',2081),(28093,'普益乡','201',2081),(28094,'杨堤乡','202',2081),(28095,'临桂镇','100',2082),(28096,'六塘镇','101',2082),(28097,'会仙镇','102',2082),(28098,'两江镇','103',2082),(28099,'五通镇','104',2082),(28100,'南边山乡','200',2082),(28101,'四塘乡','201',2082),(28102,'茶洞乡','202',2082),(28103,'中庸乡','203',2082),(28104,'宛田瑶族乡','204',2082),(28105,'黄沙瑶族乡','205',2082),(28106,'灵川镇','100',2083),(28107,'大圩镇','101',2083),(28108,'定江镇','102',2083),(28109,'三街镇','103',2083),(28110,'潭下镇','104',2083),(28111,'青狮潭镇','105',2083),(28112,'潮田乡','200',2083),(28113,'大境瑶族乡','201',2083),(28114,'海洋乡','202',2083),(28115,'灵田乡','203',2083),(28116,'兰田瑶族乡','204',2083),(28117,'全州镇','100',2084),(28118,'黄沙河镇','101',2084),(28119,'庙头镇','102',2084),(28120,'文桥镇','103',2084),(28121,'大西江镇','104',2084),(28122,'龙水镇','105',2084),(28123,'才湾镇','106',2084),(28124,'绍水镇','107',2084),(28125,'石塘镇','108',2084),(28126,'永岁乡','200',2084),(28127,'枧塘乡','201',2084),(28128,'咸水乡','202',2084),(28129,'凤凰乡','203',2084),(28130,'蕉江瑶族乡','204',2084),(28131,'安和乡','205',2084),(28132,'两河乡','206',2084),(28133,'白宝乡','207',2084),(28134,'东山瑶族乡','208',2084),(28135,'兴安镇','100',2085),(28136,'湘漓镇','101',2085),(28137,'界首镇','102',2085),(28138,'高尚镇','103',2085),(28139,'严关镇','104',2085),(28140,'溶江镇','105',2085),(28141,'漠川乡','200',2085),(28142,'白石乡','201',2085),(28143,'崔家乡','202',2085),(28144,'华江瑶族乡','203',2085),(28145,'永福镇','100',2086),(28146,'罗锦镇','101',2086),(28147,'百寿镇','102',2086),(28148,'苏桥镇','103',2086),(28149,'堡里乡','201',2086),(28150,'广福乡','202',2086),(28151,'三皇乡','203',2086),(28152,'永安乡','204',2086),(28153,'龙江乡','205',2086),(28154,'灌阳镇','100',2087),(28155,'黄关镇','101',2087),(28156,'文市镇','102',2087),(28157,'洞井瑶族乡','200',2087),(28158,'观音阁乡','201',2087),(28159,'西山瑶族乡','202',2087),(28160,'新街乡','203',2087),(28161,'新圩乡','204',2087),(28162,'水车乡','205',2087),(28163,'龙胜镇','100',2088),(28164,'瓢里镇','101',2088),(28165,'三门镇','102',2088),(28166,'和平乡','200',2088),(28167,'泗水乡','201',2088),(28168,'江底乡','202',2088),(28169,'马堤乡','203',2088),(28170,'伟江乡','204',2088),(28171,'平等乡','205',2088),(28172,'乐江乡','206',2088),(28173,'资源镇','100',2089),(28174,'中峰乡','200',2089),(28175,'梅溪乡','201',2089),(28176,'瓜里乡','202',2089),(28177,'车田苗族乡','203',2089),(28178,'两水苗族乡','204',2089),(28179,'河口瑶族乡','205',2089),(28180,'平乐镇','100',2090),(28181,'二塘镇','101',2090),(28182,'沙子镇','102',2090),(28183,'同安镇','103',2090),(28184,'张家镇','104',2090),(28185,'源头镇','105',2090),(28186,'阳安乡','200',2090),(28187,'青龙乡','201',2090),(28188,'桥亭乡','202',2090),(28189,'大发瑶族乡','203',2090),(28190,'荔城镇','100',2091),(28191,'东昌镇','101',2091),(28192,'新坪镇','102',2091),(28193,'杜莫镇','103',2091),(28194,'青山镇','104',2091),(28195,'修仁镇','105',2091),(28196,'大塘镇','106',2091),(28197,'花箦镇','107',2091),(28198,'双江镇','108',2091),(28199,'马岭镇','109',2091),(28200,'龙怀乡','200',2091),(28201,'茶城乡','201',2091),(28202,'蒲芦瑶族乡','202',2091),(28203,'恭城镇','100',2092),(28204,'栗木镇','101',2092),(28205,'莲花镇','102',2092),(28206,'平安乡','200',2092),(28207,'三江乡','201',2092),(28208,'嘉会乡','202',2092),(28209,'西岭乡','203',2092),(28210,'观音乡','204',2092),(28211,'龙虎乡','205',2092),(28212,'城东办事处','001',2094),(28213,'城南办事处','002',2094),(28214,'城中办事处','003',2094),(28215,'城北办事处','004',2094),(28216,'城东镇','101',2094),(28217,'旺甫镇','102',2094),(28218,'角嘴街道办事处','001',2095),(28219,'东兴街道办事处','002',2095),(28220,'富民街道办事处','003',2095),(28221,'龙湖镇','101',2095),(28222,'夏郢镇','102',2095),(28223,'大塘街道办事处','001',2096),(28224,'兴龙街道办事处','002',2096),(28225,'长洲镇','101',2096),(28226,'倒水镇','102',2096),(28227,'龙圩镇','100',2097),(28228,'大坡镇','101',2097),(28229,'广平镇','102',2097),(28230,'新地镇','103',2097),(28231,'岭脚镇','105',2097),(28232,'京南镇','108',2097),(28233,'狮寨镇','109',2097),(28234,'六堡镇','112',2097),(28235,'梨埠镇','113',2097),(28236,'木双镇','114',2097),(28237,'石桥镇','115',2097),(28238,'沙头镇','116',2097),(28239,'藤州镇','100',2098),(28240,'塘步镇','103',2098),(28241,'垠南镇','104',2098),(28242,'同心镇','105',2098),(28243,'金鸡镇','106',2098),(28244,'新庆镇','107',2098),(28245,'象棋镇','108',2098),(28246,'岭景镇','109',2098),(28247,'天平镇','110',2098),(28248,'蒙江镇','111',2098),(28249,'和平镇','112',2098),(28250,'太平镇','113',2098),(28251,'古龙镇','114',2098),(28252,'东荣镇','115',2098),(28253,'大黎镇','116',2098),(28254,'平福乡','200',2098),(28255,'蒙山镇','100',2099),(28256,'西河镇','101',2099),(28257,'新圩镇','102',2099),(28258,'文圩镇','103',2099),(28259,'黄村镇','104',2099),(28260,'陈塘镇','105',2099),(28261,'汉豪乡','200',2099),(28262,'长坪瑶族乡','201',2099),(28263,'夏宜瑶族乡','202',2099),(28264,'岑城镇','100',2100),(28265,'马路镇','102',2100),(28266,'南渡镇','103',2100),(28267,'水汶镇','105',2100),(28268,'大隆镇','106',2100),(28269,'梨木镇','107',2100),(28270,'大业镇','108',2100),(28271,'筋竹镇','109',2100),(28272,'城谏镇','110',2100),(28273,'归义镇','111',2100),(28274,'糯垌镇','112',2100),(28275,'安平镇','113',2100),(28276,'三堡镇','114',2100),(28277,'波塘镇','115',2100),(28278,'中街街道办事处','001',2102),(28279,'东街街道办事处','002',2102),(28280,'西街街道办事处','003',2102),(28281,'海角街道办事处','004',2102),(28282,'地角街道办事处','005',2102),(28283,'高德街道办事处','006',2102),(28284,'驿马街道办事处','007',2102),(28285,'涠州镇','100',2102),(28286,'福成镇','100',2103),(28287,'银滩镇','101',2103),(28288,'平阳镇','102',2103),(28289,'侨港镇','103',2103),(28290,'南康镇','100',2104),(28291,'营盘镇','101',2104),(28292,'兴港镇','102',2104),(28293,'廉州镇','100',2105),(28294,'党江镇','101',2105),(28295,'西场镇','102',2105),(28296,'沙岗镇','103',2105),(28297,'乌家镇','104',2105),(28298,'闸口镇','105',2105),(28299,'公馆镇','106',2105),(28300,'白沙镇','107',2105),(28301,'山口镇','108',2105),(28302,'沙田镇','109',2105),(28303,'石湾镇','110',2105),(28304,'石康镇','111',2105),(28305,'常乐镇','112',2105),(28306,'曲樟乡','200',2105),(28307,'星岛湖乡','201',2105),(28308,'港口区渔州坪街道办事处','001',2107),(28309,'港口区白沙万街道办事处','002',2107),(28310,'港口区企沙镇','100',2107),(28311,'港口区光坡镇','101',2107),(28312,'港口区公车镇','102',2107),(28313,'防城区防城镇','100',2108),(28314,'防城区大','101',2108),(28315,'防城区华石镇','102',2108),(28316,'防城区那梭镇','103',2108),(28317,'防城区那良镇','104',2108),(28318,'防城区峒中镇','105',2108),(28319,'防城区茅岭乡','201',2108),(28320,'防城区扶隆乡','202',2108),(28321,'防城区滩营乡','203',2108),(28322,'防城区江山乡','204',2108),(28323,'小峰经济作物场','450',2108),(28324,'荣光农场','451',2108),(28325,'十万山华侨林场','452',2108),(28326,'垌美农场','453',2108),(28327,'那梭农场','454',2108),(28328,'上思县思阳镇','100',2109),(28329,'上思县在妙镇','101',2109),(28330,'上思县叫安乡','201',2109),(28331,'上思县华兰乡','202',2109),(28332,'上思县南屏瑶族乡','203',2109),(28333,'上思县平福乡','204',2109),(28334,'上思县那琴乡','205',2109),(28335,'上思县公正乡','206',2109),(28336,'广西农垦国有昌菱农场','450',2109),(28337,'东兴市东兴镇','100',2110),(28338,'东兴市江平镇','101',2110),(28339,'东兴市马路镇','102',2110),(28340,'向阳街道办事处','001',2112),(28341,'水东街道办事处','002',2112),(28342,'文峰街道办事处','003',2112),(28343,'南珠街道办事处','004',2112),(28344,'沙埠镇','100',2112),(28345,'康熙岭镇','101',2112),(28346,'黄屋屯镇','102',2112),(28347,'尖山镇','103',2112),(28348,'大番坡镇','104',2112),(28349,'龙门港镇','105',2112),(28350,'犀牛脚镇','106',2112),(28351,'久隆镇','107',2112),(28352,'东场镇','108',2112),(28353,'那丽镇','109',2112),(28354,'那彭镇','110',2112),(28355,'那思镇','111',2112),(28356,'丽光华侨农场','400',2112),(28357,'钦州港经济开发区','401',2112),(28358,'大垌镇','100',2113),(28359,'平吉镇','101',2113),(28360,'青塘镇','102',2113),(28361,'小董镇','103',2113),(28362,'板城镇','104',2113),(28363,'那蒙镇','105',2113),(28364,'长滩镇','106',2113),(28365,'新棠镇','107',2113),(28366,'大直镇','108',2113),(28367,'大寺镇','109',2113),(28368,'贵台镇','110',2113),(28369,'钦州市矿务局','400',2113),(28370,'灵城镇','100',2114),(28371,'新圩镇','101',2114),(28372,'丰塘镇','102',2114),(28373,'平山镇','103',2114),(28374,'石塘镇','104',2114),(28375,'佛子镇','105',2114),(28376,'平南镇','106',2114),(28377,'烟墩镇','107',2114),(28378,'檀圩镇','108',2114),(28379,'那隆镇','109',2114),(28380,'三隆镇','110',2114),(28381,'陆屋镇','111',2114),(28382,'旧州镇','112',2114),(28383,'太平镇','113',2114),(28384,'沙坪镇','114',2114),(28385,'武利镇','115',2114),(28386,'文利镇','116',2114),(28387,'伯劳镇','117',2114),(28388,'国营新光农场','400',2114),(28389,'国营华山农场','401',2114),(28390,'小江镇','100',2115),(28391,'泉水镇','101',2115),(28392,'石','102',2115),(28393,'安石镇','103',2115),(28394,'张黄镇','104',2115),(28395,'大成镇','105',2115),(28396,'白石水镇','106',2115),(28397,'北通镇','107',2115),(28398,'三合镇','108',2115),(28399,'龙门镇','109',2115),(28400,'福旺镇','110',2115),(28401,'寨圩镇','111',2115),(28402,'乐民镇','112',2115),(28403,'六','113',2115),(28404,'平睦镇','114',2115),(28405,'官垌镇','115',2115),(28406,'贵城街道办事处','001',2117),(28407,'港城镇','100',2117),(28408,'大圩镇','101',2117),(28409,'庆丰镇','102',2117),(28410,'奇石乡','200',2117),(28411,'中里乡','201',2117),(28412,'根竹乡','202',2117),(28413,'武乐乡','203',2117),(28414,'江南办事处','001',2118),(28415,'桥圩镇','100',2118),(28416,'木格镇','101',2118),(28417,'木梓镇','102',2118),(28418,'湛江镇','103',2118),(28419,'东津镇','104',2118),(28420,'八塘镇','105',2118),(28421,'新塘乡','200',2118),(28422,'瓦塘乡','201',2118),(28423,'覃塘镇','100',2119),(28424,'东龙镇','101',2119),(28425,'三里镇','102',2119),(28426,'黄练镇','103',2119),(28427,'石卡镇','104',2119),(28428,'五里镇','105',2119),(28429,'山北乡','200',2119),(28430,'樟木乡','201',2119),(28431,'蒙公乡','203',2119),(28432,'大岭乡','204',2119),(28433,'平南镇','100',2120),(28434,'平山镇','101',2120),(28435,'寺面镇','102',2120),(28436,'六陈镇','103',2120),(28437,'大新镇','104',2120),(28438,'大安镇','105',2120),(28439,'武林镇','106',2120),(28440,'大坡镇','107',2120),(28441,'大洲镇','108',2120),(28442,'镇隆镇','109',2120),(28443,'上渡镇','110',2120),(28444,'安怀镇','112',2120),(28445,'丹竹镇','113',2120),(28446,'官成镇','114',2120),(28447,'思旺镇','115',2120),(28448,'大鹏镇','116',2120),(28449,'同和镇','117',2120),(28450,'东华乡','202',2120),(28451,'思界乡','204',2120),(28452,'国安瑶族乡','205',2120),(28453,'马练瑶族乡','206',2120),(28454,'木乐镇','101',2121),(28455,'木圭镇','102',2121),(28456,'石咀镇','103',2121),(28457,'油麻镇','104',2121),(28458,'社坡镇','105',2121),(28459,'罗秀镇','106',2121),(28460,'麻垌镇','107',2121),(28461,'社步镇','108',2121),(28462,'下湾镇','109',2121),(28463,'木根镇','110',2121),(28464,'中沙镇','111',2121),(28465,'大洋镇','113',2121),(28466,'大湾镇','114',2121),(28467,'白沙镇','115',2121),(28468,'石龙镇','116',2121),(28469,'蒙圩镇','117',2121),(28470,'西山镇','118',2121),(28471,'南木镇','119',2121),(28472,'江口镇','120',2121),(28473,'金田镇','121',2121),(28474,'紫荆镇','122',2121),(28475,'马皮乡','200',2121),(28476,'寻旺乡','202',2121),(28477,'罗播乡','203',2121),(28478,'厚禄乡','204',2121),(28479,'垌心乡','206',2121),(28480,'玉城街道办事处','001',2123),(28481,'南江街道办事处','002',2123),(28482,'城西街道办事处','003',2123),(28483,'城北街道办事处','004',2123),(28484,'名山街道办事处','005',2123),(28485,'大塘镇','100',2123),(28486,'茂林镇','105',2123),(28487,'仁东镇','106',2123),(28488,'福绵镇','107',2123),(28489,'成均镇','108',2123),(28490,'樟木镇','109',2123),(28491,'新桥镇','110',2123),(28492,'沙田镇','111',2123),(28493,'石和镇','112',2123),(28494,'仁厚镇','113',2123),(28495,'容州镇','100',2124),(28496,'杨梅镇','102',2124),(28497,'灵山镇','103',2124),(28498,'六王镇','104',2124),(28499,'黎村镇','105',2124),(28500,'杨村镇','106',2124),(28501,'县底镇','107',2124),(28502,'自良镇','108',2124),(28503,'松山镇','109',2124),(28504,'罗江镇','110',2124),(28505,'石头镇','111',2124),(28506,'石寨镇','112',2124),(28507,'容西乡','200',2124),(28508,'十里乡','201',2124),(28509,'浪水乡','202',2124),(28510,'温泉镇','101',2125),(28511,'米场镇','102',2125),(28512,'马坡镇','103',2125),(28513,'珊罗镇','104',2125),(28514,'平乐镇','105',2125),(28515,'沙坡镇','106',2125),(28516,'大桥镇','107',2125),(28517,'乌石镇','108',2125),(28518,'良田镇','109',2125),(28519,'清湖镇','110',2125),(28520,'古城镇','111',2125),(28521,'沙湖乡','200',2125),(28522,'横山乡','201',2125),(28523,'滩面乡','203',2125),(28524,'博白镇','100',2126),(28525,'双凤镇','102',2126),(28526,'顿谷镇','105',2126),(28527,'水鸣镇','106',2126),(28528,'那林镇','107',2126),(28529,'江宁镇','108',2126),(28530,'三滩镇','109',2126),(28531,'黄凌镇','110',2126),(28532,'亚山镇','111',2126),(28533,'旺茂镇','112',2126),(28534,'东平镇','114',2126),(28535,'沙河镇','115',2126),(28536,'菱角镇','116',2126),(28537,'新田镇','117',2126),(28538,'凤山镇','118',2126),(28539,'宁潭镇','119',2126),(28540,'文地镇','120',2126),(28541,'英桥镇','121',2126),(28542,'那卜镇','122',2126),(28543,'大垌镇','123',2126),(28544,'沙陂镇','124',2126),(28545,'双旺镇','125',2126),(28546,'松旺镇','126',2126),(28547,'龙潭镇','127',2126),(28548,'大坝镇','128',2126),(28549,'永安镇','129',2126),(28550,'径口镇','130',2126),(28551,'浪平乡','201',2126),(28552,'石南镇','100',2127),(28553,'大平山镇','101',2127),(28554,'葵阳镇','102',2127),(28555,'城隍镇','103',2127),(28556,'山心镇','104',2127),(28557,'沙塘镇','105',2127),(28558,'蒲塘镇','106',2127),(28559,'北市镇','107',2127),(28560,'龙安镇','108',2127),(28561,'高峰镇','109',2127),(28562,'小平山镇','110',2127),(28563,'卖酒镇','111',2127),(28564,'洛阳乡','202',2127),(28565,'陵城街道办事处','001',2128),(28566,'城南街道办事处','002',2128),(28567,'城北街道办事处','003',2128),(28568,'北流镇','100',2128),(28569,'新荣镇','101',2128),(28570,'民安镇','102',2128),(28571,'山围镇','103',2128),(28572,'民乐镇','104',2128),(28573,'西垠镇','105',2128),(28574,'新圩镇','106',2128),(28575,'大里镇','107',2128),(28576,'塘岸镇','108',2128),(28577,'清水口镇','109',2128),(28578,'隆盛镇','110',2128),(28579,'大坡外镇','111',2128),(28580,'六麻镇','112',2128),(28581,'新丰镇','113',2128),(28582,'沙垌镇','114',2128),(28583,'平政镇','115',2128),(28584,'白马镇','116',2128),(28585,'大伦镇','117',2128),(28586,'扶新镇','118',2128),(28587,'六靖镇','119',2128),(28588,'石窝镇','120',2128),(28589,'清湾镇','121',2128),(28590,'百城街道办事处','001',2130),(28591,'龙景街道办事处','002',2130),(28592,'阳圩镇','101',2130),(28593,'四塘镇','102',2130),(28594,'龙川镇','103',2130),(28595,'永乐乡','201',2130),(28596,'汪甸瑶族乡','202',2130),(28597,'大楞乡','203',2130),(28598,'泮水乡','204',2130),(28599,'田州镇','100',2131),(28600,'那坡镇','101',2131),(28601,'坡洪镇','102',2131),(28602,'那满镇','103',2131),(28603,'百育镇','104',2131),(28604,'玉凤镇','105',2131),(28605,'头塘镇','106',2131),(28606,'洞靖乡','202',2131),(28607,'巴别乡','204',2131),(28608,'五村乡','205',2131),(28609,'平马镇','100',2132),(28610,'祥周镇','101',2132),(28611,'林逢镇','103',2132),(28612,'思林镇','105',2132),(28613,'印茶镇','106',2132),(28614,'江城镇','107',2132),(28615,'朔良镇','108',2132),(28616,'义圩镇','109',2132),(28617,'那拔镇','110',2132),(28618,'作登瑶族乡','201',2132),(28619,'马头镇','100',2133),(28620,'新安镇','101',2133),(28621,'果化镇','102',2133),(28622,'太平镇','103',2133),(28623,'坡造镇','104',2133),(28624,'四塘镇','105',2133),(28625,'旧城镇','106',2133),(28626,'榜圩镇','107',2133),(28627,'海城乡','200',2133),(28628,'凤梧乡','201',2133),(28629,'黎明乡','202',2133),(28630,'同老乡','203',2133),(28631,'平果铝','450',2133),(28632,'城关镇','100',2134),(28633,'足荣镇','101',2134),(28634,'隆桑镇','102',2134),(28635,'敬德镇','103',2134),(28636,'都安乡','200',2134),(28637,'马隘乡','201',2134),(28638,'那甲乡','202',2134),(28639,'荣华乡','203',2134),(28640,'燕峒乡','204',2134),(28641,'龙光乡','205',2134),(28642,'巴头乡','206',2134),(28643,'东凌乡','207',2134),(28644,'桂西华银氧化铝厂','450',2134),(28645,'新靖镇','100',2135),(28646,'化峒镇','101',2135),(28647,'湖润镇','102',2135),(28648,'安德镇','103',2135),(28649,'龙临镇','104',2135),(28650,'渠洋镇','105',2135),(28651,'岳圩镇','106',2135),(28652,'龙邦镇','107',2135),(28653,'同德乡','200',2135),(28654,'壬庄乡','201',2135),(28655,'安宁乡','202',2135),(28656,'地州乡','203',2135),(28657,'禄峒乡','204',2135),(28658,'南坡乡','206',2135),(28659,'吞盘乡','207',2135),(28660,'果乐乡','209',2135),(28661,'新甲乡','211',2135),(28662,'武平乡','212',2135),(28663,'魁圩乡','215',2135),(28664,'城厢镇','100',2136),(28665,'平孟镇','101',2136),(28666,'坡荷乡','200',2136),(28667,'龙合乡','201',2136),(28668,'德隆乡','203',2136),(28669,'百合乡','204',2136),(28670,'百南乡','205',2136),(28671,'百省乡','207',2136),(28672,'百都乡','208',2136),(28673,'泗城镇','100',2137),(28674,'逻楼镇','101',2137),(28675,'加尤镇','102',2137),(28676,'下甲乡','200',2137),(28677,'伶站瑶族乡','201',2137),(28678,'朝里瑶族乡','202',2137),(28679,'沙里乡','203',2137),(28680,'玉洪瑶族乡','205',2137),(28681,'同乐镇','100',2138),(28682,'甘田镇','101',2138),(28683,'新化镇','102',2138),(28684,'花坪镇','103',2138),(28685,'逻沙乡','201',2138),(28686,'逻西乡','203',2138),(28687,'幼平乡','204',2138),(28688,'雅长乡','205',2138),(28689,'乐里镇','100',2139),(28690,'旧州镇','101',2139),(28691,'定安镇','102',2139),(28692,'六隆镇','103',2139),(28693,'潞城瑶族乡','200',2139),(28694,'利周瑶族乡','201',2139),(28695,'平塘乡','202',2139),(28696,'浪平乡','203',2139),(28697,'八桂瑶族乡','204',2139),(28698,'八渡瑶族乡','205',2139),(28699,'那比乡','206',2139),(28700,'高龙乡','207',2139),(28701,'百乐乡','208',2139),(28702,'者苗乡','209',2139),(28703,'八达镇','100',2140),(28704,'古障镇','101',2140),(28705,'马蚌乡','200',2140),(28706,'普合苗族乡','203',2140),(28707,'西平乡','204',2140),(28708,'那佐苗族乡','206',2140),(28709,'那劳乡','207',2140),(28710,'足别瑶族苗族乡','208',2140),(28711,'新州镇','100',2141),(28712,'桠杈镇','101',2141),(28713,'天生桥镇','102',2141),(28714,'平班镇','103',2141),(28715,'沙梨乡','200',2141),(28716,'隆或乡','201',2141),(28717,'者保乡','203',2141),(28718,'者浪乡','204',2141),(28719,'革步乡','205',2141),(28720,'金钟山乡','206',2141),(28721,'德峨乡','207',2141),(28722,'猪场乡','208',2141),(28723,'蛇场乡','210',2141),(28724,'克长乡','211',2141),(28725,'岩茶乡','213',2141),(28726,'介廷乡','215',2141),(28727,'八步街道办事处','001',2143),(28728,'西湾街道办事处','002',2143),(28729,'贺街镇','101',2143),(28730,'步头镇','102',2143),(28731,'莲塘镇','103',2143),(28732,'大宁镇','104',2143),(28733,'南乡镇','105',2143),(28734,'桂岭镇','106',2143),(28735,'开山镇','107',2143),(28736,'黄田镇','108',2143),(28737,'里松镇','109',2143),(28738,'鹅塘镇','110',2143),(28739,'沙田镇','111',2143),(28740,'公会镇','112',2143),(28741,'水口镇','113',2143),(28742,'信都镇','114',2143),(28743,'灵峰镇','115',2143),(28744,'仁义镇','116',2143),(28745,'铺门镇','117',2143),(28746,'黄洞瑶族乡','200',2143),(28747,'大平瑶族乡','201',2143),(28748,'昭平镇','100',2144),(28749,'文竹镇','101',2144),(28750,'黄姚镇','102',2144),(28751,'富罗镇','103',2144),(28752,'北陀镇','104',2144),(28753,'马江镇','105',2144),(28754,'五将镇','107',2144),(28755,'仙回瑶族乡','201',2144),(28756,'走马乡','202',2144),(28757,'樟木林乡','205',2144),(28758,'凤凰乡','206',2144),(28759,'木格乡','208',2144),(28760,'钟山镇','100',2145),(28761,'望高镇','102',2145),(28762,'羊头镇','103',2145),(28763,'回龙镇','104',2145),(28764,'石龙镇','105',2145),(28765,'凤翔镇','106',2145),(28766,'珊瑚镇','107',2145),(28767,'同古镇','108',2145),(28768,'公安镇','109',2145),(28769,'清塘镇','111',2145),(28770,'燕塘镇','112',2145),(28771,'红花镇','113',2145),(28772,'花山瑶族乡','200',2145),(28773,'两安瑶族乡','201',2145),(28774,'富阳镇','100',2146),(28775,'白沙镇','101',2146),(28776,'莲山镇','102',2146),(28777,'古城镇','103',2146),(28778,'福利镇','104',2146),(28779,'麦岭镇','105',2146),(28780,'葛坡镇','106',2146),(28781,'城北镇','107',2146),(28782,'朝东镇','108',2146),(28783,'新华乡','200',2146),(28784,'石家乡','201',2146),(28785,'柳家乡','203',2146),(28786,'金城江街道办事处','001',2148),(28787,'东江镇','101',2148),(28788,'六圩镇','102',2148),(28789,'六甲镇','103',2148),(28790,'河池镇','104',2148),(28791,'拔贡镇','105',2148),(28792,'九圩镇','106',2148),(28793,'五圩镇','107',2148),(28794,'白土乡','200',2148),(28795,'侧岭乡','203',2148),(28796,'保平乡','204',2148),(28797,'长老乡','205',2148),(28798,'城关镇','100',2149),(28799,'大厂镇','101',2149),(28800,'车河镇','102',2149),(28801,'芒场镇','103',2149),(28802,'六寨镇','104',2149),(28803,'月里镇','105',2149),(28804,'吾隘镇','106',2149),(28805,'罗富乡','200',2149),(28806,'中堡苗族乡','202',2149),(28807,'八圩瑶族乡','203',2149),(28808,'里湖瑶族乡','204',2149),(28809,'六排镇','100',2150),(28810,'向阳镇','101',2150),(28811,'岜暮乡','200',2150),(28812,'八腊瑶族乡','201',2150),(28813,'纳直乡','203',2150),(28814,'更新乡','204',2150),(28815,'下老乡','206',2150),(28816,'坡结乡','207',2150),(28817,'三堡乡','208',2150),(28818,'凤城镇','100',2151),(28819,'袍里乡','200',2151),(28820,'砦牙乡','201',2151),(28821,'长洲乡','202',2151),(28822,'乔音乡','203',2151),(28823,'金牙瑶族乡','205',2151),(28824,'中亭乡','207',2151),(28825,'平乐瑶族乡','208',2151),(28826,'江洲瑶族乡','209',2151),(28827,'东兰镇','100',2152),(28828,'隘洞镇','101',2152),(28829,'长乐镇','102',2152),(28830,'三石镇','103',2152),(28831,'武篆镇','104',2152),(28832,'泗孟乡','200',2152),(28833,'兰木乡','201',2152),(28834,'长江乡','202',2152),(28835,'巴畴乡','203',2152),(28836,'金谷乡','204',2152),(28837,'三弄瑶族乡','205',2152),(28838,'大同乡','206',2152),(28839,'花香乡','207',2152),(28840,'切学乡','208',2152),(28841,'东门镇','100',2153),(28842,'龙岸镇','101',2153),(28843,'黄金镇','102',2153),(28844,'小长安镇','103',2153),(28845,'四把镇','105',2153),(28846,'天河镇','106',2153),(28847,'怀群镇','107',2153),(28848,'宝坛乡','200',2153),(28849,'乔善乡','202',2153),(28850,'纳翁乡','203',2153),(28851,'兼爱乡','204',2153),(28852,'思恩镇','100',2154),(28853,'水源镇','101',2154),(28854,'洛阳镇','102',2154),(28855,'川山镇','103',2154),(28856,'明伦镇','104',2154),(28857,'东兴镇','105',2154),(28858,'大才乡','200',2154),(28859,'下南乡','202',2154),(28860,'大安乡','204',2154),(28861,'长美乡','205',2154),(28862,'龙岩乡','206',2154),(28863,'驯乐苗族乡','207',2154),(28864,'巴马镇','100',2155),(28865,'燕洞乡','200',2155),(28866,'甲篆乡','201',2155),(28867,'那社乡','202',2155),(28868,'所略乡','203',2155),(28869,'西山乡','205',2155),(28870,'东山乡','207',2155),(28871,'凤凰乡','208',2155),(28872,'百林乡','209',2155),(28873,'那桃乡','210',2155),(28874,'安阳镇','100',2156),(28875,'高岭镇','101',2156),(28876,'澄江乡','200',2156),(28877,'地苏乡','202',2156),(28878,'东庙乡','204',2156),(28879,'大兴乡','206',2156),(28880,'下坳乡','207',2156),(28881,'隆福乡','208',2156),(28882,'保安乡','209',2156),(28883,'板岭乡','210',2156),(28884,'永安乡','211',2156),(28885,'三只羊乡','212',2156),(28886,'龙湾乡','213',2156),(28887,'菁盛乡','214',2156),(28888,'拉烈乡','215',2156),(28889,'百旺乡','216',2156),(28890,'加贵乡','217',2156),(28891,'拉仁乡','218',2156),(28892,'九渡乡','219',2156),(28893,'大化镇','100',2157),(28894,'都阳镇','101',2157),(28895,'岩滩镇','102',2157),(28896,'共和乡','200',2157),(28897,'贡川乡','201',2157),(28898,'百马乡','202',2157),(28899,'古河乡','203',2157),(28900,'古文乡','204',2157),(28901,'江南乡','205',2157),(28902,'羌圩乡','206',2157),(28903,'乙圩乡','207',2157),(28904,'北景乡','208',2157),(28905,'板升乡','210',2157),(28906,'七百弄乡','211',2157),(28907,'雅龙乡','213',2157),(28908,'六也乡','214',2157),(28909,'庆远镇','100',2158),(28910,'三岔镇','101',2158),(28911,'洛西镇','102',2158),(28912,'怀远镇','103',2158),(28913,'德胜镇','104',2158),(28914,'石别镇','105',2158),(28915,'北山镇','106',2158),(28916,'祥贝乡','200',2158),(28917,'刘三姐乡','201',2158),(28918,'屏南乡','203',2158),(28919,'洛东乡','204',2158),(28920,'福龙瑶族乡','207',2158),(28921,'北牙瑶族乡','208',2158),(28922,'同德乡','210',2158),(28923,'安马乡','211',2158),(28924,'龙头乡','213',2158),(28925,'城东街道办事处','001',2160),(28926,'城北街道办事处','002',2160),(28927,'河西街道办事处','003',2160),(28928,'凤凰镇','101',2160),(28929,'良江镇','102',2160),(28930,'小平阳镇','103',2160),(28931,'迁江镇','104',2160),(28932,'石陵镇','105',2160),(28933,'平阳镇','106',2160),(28934,'三五乡','201',2160),(28935,'五山乡','202',2160),(28936,'陶邓乡','203',2160),(28937,'桥巩乡','204',2160),(28938,'良塘乡','205',2160),(28939,'七洞乡','206',2160),(28940,'城厢乡','209',2160),(28941,'蒙村乡','210',2160),(28942,'寺山乡','211',2160),(28943,'石牙乡','212',2160),(28944,'南泗乡','213',2160),(28945,'高安乡','214',2160),(28946,'大湾乡','215',2160),(28947,'正龙乡','216',2160),(28948,'城关镇','100',2161),(28949,'大塘镇','101',2161),(28950,'思练镇','102',2161),(28951,'红渡镇','103',2161),(28952,'古蓬镇','104',2161),(28953,'马泗乡','201',2161),(28954,'欧洞乡','202',2161),(28955,'安东乡','203',2161),(28956,'果遂乡','204',2161),(28957,'新圩乡','205',2161),(28958,'遂意乡','206',2161),(28959,'北更乡','207',2161),(28960,'象州镇','100',2162),(28961,'石龙镇','101',2162),(28962,'运江镇','102',2162),(28963,'寺村镇','103',2162),(28964,'中平镇','104',2162),(28965,'罗秀镇','105',2162),(28966,'大乐镇','106',2162),(28967,'马坪乡','200',2162),(28968,'妙皇乡','201',2162),(28969,'百丈乡','202',2162),(28970,'水晶乡','203',2162),(28971,'武宣镇','100',2163),(28972,'桐岭镇','101',2163),(28973,'通挽镇','102',2163),(28974,'东乡镇','103',2163),(28975,'三里镇','104',2163),(28976,'二塘镇','105',2163),(28977,'黄茆镇','106',2163),(28978,'禄新乡','201',2163),(28979,'思灵乡','202',2163),(28980,'金鸡乡','204',2163),(28981,'金秀镇','100',2164),(28982,'桐木镇','101',2164),(28983,'头排镇','102',2164),(28984,'三角乡','200',2164),(28985,'忠良乡','201',2164),(28986,'罗香乡','202',2164),(28987,'长垌乡','203',2164),(28988,'大樟乡','204',2164),(28989,'六巷乡','205',2164),(28990,'三江乡','207',2164),(28991,'岭南镇','100',2165),(28992,'北泗乡','200',2165),(28993,'河里乡','201',2165),(28994,'太平镇','100',2167),(28995,'新和镇','101',2167),(28996,'濑湍镇','102',2167),(28997,'江州镇','103',2167),(28998,'左州镇','104',2167),(28999,'那隆镇','105',2167),(29000,'驮卢镇','106',2167),(29001,'罗白乡','201',2167),(29002,'板利乡','202',2167),(29003,'新宁镇','100',2168),(29004,'渠黎镇','101',2168),(29005,'渠旧镇','102',2168),(29006,'柳桥镇','103',2168),(29007,'东门镇','104',2168),(29008,'山圩镇','105',2168),(29009,'中东镇','106',2168),(29010,'东罗镇','107',2168),(29011,'龙头乡','201',2168),(29012,'岜盆乡','202',2168),(29013,'昌平乡','203',2168),(29014,'城中镇','100',2169),(29015,'爱店镇','101',2169),(29016,'明江镇','102',2169),(29017,'海渊镇','103',2169),(29018,'亭亮乡','201',2169),(29019,'寨安乡','202',2169),(29020,'峙浪乡','203',2169),(29021,'东安乡','204',2169),(29022,'板棍乡','205',2169),(29023,'北江乡','206',2169),(29024,'桐棉乡','207',2169),(29025,'那堪乡','208',2169),(29026,'那楠乡','209',2169),(29027,'龙州镇','100',2170),(29028,'下冻镇','101',2170),(29029,'水口镇','102',2170),(29030,'金龙镇','103',2170),(29031,'响水镇','104',2170),(29032,'八角乡','201',2170),(29033,'上降乡','202',2170),(29034,'彬桥乡','203',2170),(29035,'上龙乡','204',2170),(29036,'武德乡','205',2170),(29037,'逐卜乡','206',2170),(29038,'上金乡','207',2170),(29039,'桃城镇','100',2171),(29040,'全茗镇','101',2171),(29041,'雷平镇','102',2171),(29042,'硕龙镇','103',2171),(29043,'下雷镇','104',2171),(29044,'五山乡','200',2171),(29045,'龙门乡','201',2171),(29046,'昌明乡','202',2171),(29047,'福隆乡','203',2171),(29048,'那岭乡','204',2171),(29049,'恩城乡','205',2171),(29050,'榄圩乡','206',2171),(29051,'宝圩乡','207',2171),(29052,'堪圩乡','208',2171),(29053,'天等镇','100',2172),(29054,'龙茗镇','101',2172),(29055,'进结镇','102',2172),(29056,'向都镇','103',2172),(29057,'都康乡','200',2172),(29058,'宁干乡','201',2172),(29059,'驮堪乡','202',2172),(29060,'福新乡','203',2172),(29061,'东平乡','204',2172),(29062,'进远乡','205',2172),(29063,'上映乡','206',2172),(29064,'把荷乡','207',2172),(29065,'小山乡','208',2172),(29066,'凭祥镇','100',2173),(29067,'友谊镇','101',2173),(29068,'上石镇','102',2173),(29069,'夏石镇','103',2173),(29070,'秀英街道办事处','001',2175),(29071,'海秀街道办','002',2175),(29072,'长流镇','100',2175),(29073,'西秀镇','101',2175),(29074,'海秀镇','102',2175),(29075,'石山镇','103',2175),(29076,'永兴镇','104',2175),(29077,'东山镇','105',2175),(29078,'中山街道办事处','001',2176),(29079,'滨海街道办事处','002',2176),(29080,'金贸街道办事处','003',2176),(29081,'大同街道办事处','004',2176),(29082,'海垦街道办事处','005',2176),(29083,'金宇街道办事处','006',2176),(29084,'城西镇','100',2176),(29085,'龙桥镇','101',2176),(29086,'新坡镇','102',2176),(29087,'遵谭镇','103',2176),(29088,'龙泉镇','104',2176),(29089,'国兴街道办','001',2177),(29090,'府城镇','100',2177),(29091,'龙塘镇','101',2177),(29092,'云龙镇','102',2177),(29093,'红旗镇','103',2177),(29094,'三门坡镇','104',2177),(29095,'大坡镇','105',2177),(29096,'甲子镇','106',2177),(29097,'旧州镇','107',2177),(29098,'国营红明农场','400',2177),(29099,'国营东昌农场','401',2177),(29100,'省岭脚热带作物场','500',2177),(29101,'省长昌煤矿','501',2177),(29102,'海府街道办事处','001',2178),(29103,'蓝天街道办事处','002',2178),(29104,'博爱街道办事处','003',2178),(29105,'海甸街道办事处','004',2178),(29106,'人民路街道办事处','005',2178),(29107,'白龙街道办事处','006',2178),(29108,'和平南街道办事处','007',2178),(29109,'白沙街道办事处','008',2178),(29110,'新埠街道办事处','009',2178),(29111,'灵山镇','101',2178),(29112,'演丰镇','102',2178),(29113,'三江镇','103',2178),(29114,'大致坡镇','104',2178),(29115,'国营桂林洋农场','400',2178),(29116,'国营三江农场','401',2178),(29117,'罗牛山农场','500',2178),(29118,'河西区（虚拟街道办）','001',2179),(29119,'河东区（虚拟街道办）','002',2179),(29120,'海棠湾镇','100',2179),(29121,'田独镇','101',2179),(29122,'凤凰镇','102',2179),(29123,'崖城镇','103',2179),(29124,'天涯镇','104',2179),(29125,'育才镇','105',2179),(29126,'国营南田农场','400',2179),(29127,'国营南新农场','401',2179),(29128,'国营南岛农场','402',2179),(29129,'国营立才农场','403',2179),(29130,'国营南滨农场','404',2179),(29131,'冲山镇','100',2180),(29132,'南圣镇','101',2180),(29133,'毛阳镇','102',2180),(29134,'番阳镇','103',2180),(29135,'畅好乡','200',2180),(29136,'毛道乡','201',2180),(29137,'水满乡','202',2180),(29138,'国营畅好农场','400',2180),(29139,'嘉积镇','100',2181),(29140,'万泉镇','101',2181),(29141,'石壁镇','102',2181),(29142,'中原镇','103',2181),(29143,'博敖镇','104',2181),(29144,'阳江镇','105',2181),(29145,'龙江镇','106',2181),(29146,'潭门镇','107',2181),(29147,'塔洋镇','108',2181),(29148,'长坡镇','109',2181),(29149,'大路镇','110',2181),(29150,'会山镇','111',2181),(29151,'国营东太农场','400',2181),(29152,'国营东平农场','401',2181),(29153,'国营东红农场','402',2181),(29154,'国营东升农场','403',2181),(29155,'国营南俸农场','404',2181),(29156,'彬村山华侨农场','500',2181),(29157,'那大镇','100',2182),(29158,'和庆镇','101',2182),(29159,'南丰镇','102',2182),(29160,'大成镇','103',2182),(29161,'雅星镇','104',2182),(29162,'兰洋镇','105',2182),(29163,'光村镇','106',2182),(29164,'木棠镇','107',2182),(29165,'海头镇','108',2182),(29166,'峨蔓镇','109',2182),(29167,'三都镇','110',2182),(29168,'王五镇','111',2182),(29169,'白马井镇','112',2182),(29170,'中和镇','113',2182),(29171,'排浦镇','114',2182),(29172,'东成镇','115',2182),(29173,'新州镇','116',2182),(29174,'国营西培农场','400',2182),(29175,'国营西华农场','401',2182),(29176,'国营西庆农场','402',2182),(29177,'国营西流农场','403',2182),(29178,'国营西联农场','404',2182),(29179,'国营蓝洋农场','405',2182),(29180,'国营新盈农场','406',2182),(29181,'国营八一农场东山分场','407',2182),(29182,'国营八一农场金川分场','408',2182),(29183,'国营八一农场长岭分场','409',2182),(29184,'国营八一农场英岛分场','410',2182),(29185,'国营八一农场春江分场','411',2182),(29186,'国营八一农场强打管区','412',2182),(29187,'国营龙山农场','413',2182),(29188,'国营红岭农场','414',2182),(29189,'洋浦经济开发区','415',2182),(29190,'华南热作学院','500',2182),(29191,'文城镇','100',2183),(29192,'重兴镇','101',2183),(29193,'蓬莱镇','102',2183),(29194,'会文镇','103',2183),(29195,'东路镇','104',2183),(29196,'潭牛镇','105',2183),(29197,'东阁镇','106',2183),(29198,'文教镇','107',2183),(29199,'东郊镇','108',2183),(29200,'龙楼镇','109',2183),(29201,'昌洒镇','110',2183),(29202,'翁田镇','111',2183),(29203,'抱罗镇','112',2183),(29204,'冯坡镇','113',2183),(29205,'锦山镇','114',2183),(29206,'铺前镇','115',2183),(29207,'国营东路农场','400',2183),(29208,'国营南阳农场','401',2183),(29209,'国营罗豆农场','402',2183),(29210,'国营文昌橡胶研究所','403',2183),(29211,'万城镇','100',2184),(29212,'龙滚镇','101',2184),(29213,'和乐镇','102',2184),(29214,'后安镇','103',2184),(29215,'大茂镇','104',2184),(29216,'东澳镇','105',2184),(29217,'礼纪镇','106',2184),(29218,'长丰镇','107',2184),(29219,'山根镇','108',2184),(29220,'北大镇','109',2184),(29221,'南桥镇','110',2184),(29222,'三更罗镇','111',2184),(29223,'国营东兴农场','400',2184),(29224,'国营东和农场','401',2184),(29225,'国营东岭农场','402',2184),(29226,'国营南林农场','403',2184),(29227,'国营新中农场','404',2184),(29228,'兴隆华侨农场','500',2184),(29229,'地方国营六连林场','501',2184),(29230,'八所镇','100',2185),(29231,'东河镇','101',2185),(29232,'大田镇','102',2185),(29233,'感城镇','103',2185),(29234,'板桥镇','104',2185),(29235,'三家镇','105',2185),(29236,'四更镇','106',2185),(29237,'新龙镇','107',2185),(29238,'天安乡','200',2185),(29239,'江边乡','201',2185),(29240,'国营广坝农场','400',2185),(29241,'国营公爱农场','401',2185),(29242,'国营红泉农场','402',2185),(29243,'省国营东方华侨农场','500',2185),(29244,'定城镇','100',2186),(29245,'新竹镇','101',2186),(29246,'龙湖镇','102',2186),(29247,'黄竹镇','103',2186),(29248,'雷鸣镇','104',2186),(29249,'龙门镇','105',2186),(29250,'龙河镇','106',2186),(29251,'岭口镇','107',2186),(29252,'翰林镇','108',2186),(29253,'富文镇','109',2186),(29254,'国营中瑞农场','400',2186),(29255,'国营南海农场','401',2186),(29256,'国营金鸡岭农场','402',2186),(29257,'定安热作研究所','403',2186),(29258,'屯城镇','100',2187),(29259,'新兴镇','101',2187),(29260,'枫木镇','102',2187),(29261,'乌坡镇','103',2187),(29262,'南吕镇','104',2187),(29263,'南坤镇','105',2187),(29264,'坡心镇','106',2187),(29265,'西昌镇','107',2187),(29266,'国营中建农场','400',2187),(29267,'国营中坤农场','401',2187),(29268,'国营黄岭农场','402',2187),(29269,'国营南吕农场','403',2187),(29270,'国营广青农场','404',2187),(29271,'国营晨星农场','405',2187),(29272,'金江镇','100',2188),(29273,'老城镇','101',2188),(29274,'瑞溪镇','102',2188),(29275,'永发镇','103',2188),(29276,'加乐镇','104',2188),(29277,'文儒镇','105',2188),(29278,'中兴镇','106',2188),(29279,'仁兴镇','107',2188),(29280,'福山镇','108',2188),(29281,'桥头镇','109',2188),(29282,'国营红光农场','400',2188),(29283,'国营红岗农场','401',2188),(29284,'国营西达农场','402',2188),(29285,'国营昆仑农场','403',2188),(29286,'国营和岭农场','404',2188),(29287,'国营金安农场','405',2188),(29288,'澄迈县华侨农场','500',2188),(29289,'临城镇','100',2189),(29290,'波莲镇','101',2189),(29291,'东英镇','102',2189),(29292,'博厚镇','103',2189),(29293,'皇桐镇','104',2189),(29294,'多文镇','105',2189),(29295,'和舍镇','106',2189),(29296,'南宝镇','107',2189),(29297,'新盈镇','108',2189),(29298,'调楼镇','109',2189),(29299,'国营红华农场','400',2189),(29300,'国营加来农场','401',2189),(29301,'牙叉镇','100',2190),(29302,'七坊镇','101',2190),(29303,'邦溪镇','102',2190),(29304,'打安镇','103',2190),(29305,'细水乡','200',2190),(29306,'元门乡','201',2190),(29307,'南开乡','202',2190),(29308,'阜龙乡','203',2190),(29309,'青松乡','204',2190),(29310,'金波乡','205',2190),(29311,'荣邦乡','206',2190),(29312,'国营金波农场','400',2190),(29313,'国营白沙农场','401',2190),(29314,'国营牙叉农场','402',2190),(29315,'国营卫星农场','403',2190),(29316,'国营龙江农场','404',2190),(29317,'国营珠碧江农场','405',2190),(29318,'国营芙蓉田农场','406',2190),(29319,'国营大岭农场','407',2190),(29320,'国营邦溪农场','408',2190),(29321,'石碌镇','100',2191),(29322,'叉河镇','101',2191),(29323,'十月田镇','102',2191),(29324,'乌烈镇','103',2191),(29325,'昌化镇','104',2191),(29326,'海尾镇','105',2191),(29327,'七叉镇','106',2191),(29328,'王下乡','200',2191),(29329,'国营红田农场','400',2191),(29330,'国营红林农场','401',2191),(29331,'国营坝王岭林场','500',2191),(29332,'海南钢铁公司','501',2191),(29333,'抱由镇','100',2192),(29334,'万冲镇','101',2192),(29335,'大安镇','102',2192),(29336,'志仲镇','103',2192),(29337,'千家镇','104',2192),(29338,'九所镇','105',2192),(29339,'利国镇','106',2192),(29340,'黄流镇','107',2192),(29341,'佛罗镇','108',2192),(29342,'尖峰镇','109',2192),(29343,'莺歌海镇','110',2192),(29344,'国营乐中农场','400',2192),(29345,'国营山荣农场','401',2192),(29346,'国营乐光农场','402',2192),(29347,'国营报伦农场','403',2192),(29348,'国营福报农场','404',2192),(29349,'国营保国农场','405',2192),(29350,'国营保显农场','406',2192),(29351,'国营尖峰岭林业公司','500',2192),(29352,'国营莺歌海盐场','501',2192),(29353,'椰林镇','100',2193),(29354,'光坡镇','101',2193),(29355,'三才镇','102',2193),(29356,'英州镇','103',2193),(29357,'隆广镇','104',2193),(29358,'文罗镇','105',2193),(29359,'本号镇','106',2193),(29360,'新村镇','107',2193),(29361,'黎安镇','108',2193),(29362,'提蒙乡','200',2193),(29363,'群英乡','201',2193),(29364,'国营岭门农场','400',2193),(29365,'国营南平农场','401',2193),(29366,'国营吊罗山林业公司','500',2193),(29367,'保城镇','100',2194),(29368,'什玲镇','101',2194),(29369,'加茂镇','102',2194),(29370,'响水镇','103',2194),(29371,'新政镇','104',2194),(29372,'三道镇','105',2194),(29373,'六弓乡','200',2194),(29374,'南林乡','201',2194),(29375,'毛感乡','202',2194),(29376,'国营五指山茶场','400',2194),(29377,'国营新星农场','401',2194),(29378,'国营保亭热作所','402',2194),(29379,'国营金江农场','403',2194),(29380,'国营南茂农场','404',2194),(29381,'国营三道农场','405',2194),(29382,'营根镇','100',2195),(29383,'湾岭镇','101',2195),(29384,'黎母山镇','102',2195),(29385,'和平镇','103',2195),(29386,'长征镇','104',2195),(29387,'红毛镇','105',2195),(29388,'中平镇','106',2195),(29389,'吊罗山乡','200',2195),(29390,'上安乡','201',2195),(29391,'什运乡','202',2195),(29392,'国营新进农场','400',2195),(29393,'国营大丰农场','401',2195),(29394,'国营阳江农场','402',2195),(29395,'国营乌石农场','403',2195),(29396,'国营南方农场','404',2195),(29397,'国营岭头农场','405',2195),(29398,'国营加钗农场','406',2195),(29399,'国营长征农场','407',2195),(29400,'国营乘坡农场','408',2195),(29401,'国营太平农场','409',2195),(29402,'国营新伟农场','410',2195),(29403,'国营黎母山林业公司','500',2195),(29404,'永兴岛（虚拟镇）','100',2196),(29405,'永署礁（虚拟镇）','100',2197),(29406,'中沙岛礁（虚拟镇）','100',2198),(29407,'高笋塘街道办事处','001',2199),(29408,'太白街道办事处','017',2199),(29409,'牌楼街道办事处','018',2199),(29410,'双河口街道办事处','019',2199),(29411,'龙都街道办事处','020',2199),(29412,'周家坝街道','021',2199),(29413,'沙河街道','022',2199),(29414,'钟鼓楼街道','023',2199),(29415,'百安坝街道办事处','024',2199),(29416,'五桥街道办事处','025',2199),(29417,'陈家坝街道办事处','026',2199),(29418,'小周镇','109',2199),(29419,'大周镇','110',2199),(29420,'新乡镇','123',2199),(29421,'孙家镇','132',2199),(29422,'高峰镇','134',2199),(29423,'龙沙镇','135',2199),(29424,'响水镇','136',2199),(29425,'武陵镇','137',2199),(29426,'壤渡镇','138',2199),(29427,'甘宁镇','139',2199),(29428,'天城镇','140',2199),(29429,'熊家镇','141',2199),(29430,'高梁镇','142',2199),(29431,'李河镇','143',2199),(29432,'分水镇','144',2199),(29433,'余家镇','145',2199),(29434,'后山镇','146',2199),(29435,'弹子镇','147',2199),(29436,'长岭镇','148',2199),(29437,'新田镇','149',2199),(29438,'白羊镇','150',2199),(29439,'龙驹镇','151',2199),(29440,'走马镇','152',2199),(29441,'罗田镇','153',2199),(29442,'太龙镇','154',2199),(29443,'长滩镇','155',2199),(29444,'太安镇','156',2199),(29445,'白土镇','157',2199),(29446,'柱山乡','201',2199),(29447,'铁峰乡','212',2199),(29448,'溪口乡','225',2199),(29449,'长坪乡','226',2199),(29450,'燕山乡','227',2199),(29451,'梨树乡','234',2199),(29452,'普子乡','237',2199),(29453,'地宝乡','238',2199),(29454,'恒合土家族乡','239',2199),(29455,'黄柏乡','244',2199),(29456,'九池乡','245',2199),(29457,'郭村乡','246',2199),(29458,'茨竹乡','247',2199),(29459,'敦仁街道办事处','001',2200),(29460,'崇义街道办事处','002',2200),(29461,'荔枝街道办事处','003',2200),(29462,'江北街道办事处','004',2200),(29463,'江东街道办事处','005',2200),(29464,'百胜镇','100',2200),(29465,'珍溪镇','101',2200),(29466,'清溪镇','102',2200),(29467,'南沱镇','103',2200),(29468,'焦石镇','104',2200),(29469,'白涛镇','105',2200),(29470,'马武镇','106',2200),(29471,'青羊镇','107',2200),(29472,'龙潭镇','108',2200),(29473,'堡子镇','109',2200),(29474,'龙桥镇','110',2200),(29475,'蔺市镇','111',2200),(29476,'新妙镇','112',2200),(29477,'石沱镇','113',2200),(29478,'镇安镇','114',2200),(29479,'义和镇','115',2200),(29480,'李渡镇','116',2200),(29481,'致韩镇','117',2200),(29482,'丛林乡','200',2200),(29483,'中峰乡','201',2200),(29484,'仁义乡','202',2200),(29485,'土地坡乡','203',2200),(29486,'罗云乡','204',2200),(29487,'卷洞乡','205',2200),(29488,'大木乡','206',2200),(29489,'山窝乡','207',2200),(29490,'武陵山乡','208',2200),(29491,'天台乡','209',2200),(29492,'梓里乡','210',2200),(29493,'酒店乡','211',2200),(29494,'太和乡','212',2200),(29495,'同乐乡','213',2200),(29496,'聚宝乡','214',2200),(29497,'新村乡','215',2200),(29498,'明家乡','216',2200),(29499,'增福乡','217',2200),(29500,'惠民乡','218',2200),(29501,'两汇乡','219',2200),(29502,'石和乡','220',2200),(29503,'石龙乡','221',2200),(29504,'桥南开发区','400',2200),(29505,'七星岗街道办事处','001',2201),(29506,'解放碑街道办事处','003',2201),(29507,'两路口街道办事处','004',2201),(29508,'上清寺街道办事处','005',2201),(29509,'菜园坝街道办事处','007',2201),(29510,'南纪门街道办事处','008',2201),(29511,'望龙门街道办事处','009',2201),(29512,'朝天门街道办事处','010',2201),(29513,'大溪沟街道办事处','011',2201),(29514,'大坪街道办事处','012',2201),(29515,'化龙桥街道办事处','013',2201),(29516,'石油路街道办事处','014',2201),(29517,'新山村街道','001',2202),(29518,'跃进村街道','002',2202),(29519,'九宫庙街道','003',2202),(29520,'茄子溪街道','004',2202),(29521,'春晖路街道','005',2202),(29522,'八桥镇','101',2202),(29523,'建胜镇','102',2202),(29524,'跳磴镇','103',2202),(29525,'华新街街道办事处','001',2203),(29526,'江北城街道办事处','002',2203),(29527,'石马河街道办事处','003',2203),(29528,'大石坝街道办事处','004',2203),(29529,'寸滩街道办事处','005',2203),(29530,'观音桥街道办事处','006',2203),(29531,'五里店街道办事处','007',2203),(29532,'郭家沱街道办事处','008',2203),(29533,'铁山坪街道办事处','009',2203),(29534,'鱼嘴镇人民政府','100',2203),(29535,'复盛镇人民政府','101',2203),(29536,'五宝镇人民政府','102',2203),(29537,'小龙坎街道','001',2204),(29538,'沙坪坝街道','002',2204),(29539,'渝碚路街道','003',2204),(29540,'磁器口街道','004',2204),(29541,'童家桥街道','005',2204),(29542,'石井坡街道','006',2204),(29543,'詹家溪街道','007',2204),(29544,'井口街道','008',2204),(29545,'歌乐山街道','009',2204),(29546,'山洞街道','010',2204),(29547,'新桥街道','011',2204),(29548,'天星桥街道','012',2204),(29549,'土湾街道','013',2204),(29550,'覃家岗镇','101',2204),(29551,'井口镇','102',2204),(29552,'歌乐山镇','103',2204),(29553,'青木关镇','104',2204),(29554,'凤凰镇','105',2204),(29555,'回龙坝镇','106',2204),(29556,'陈家桥镇','107',2204),(29557,'曾家镇','108',2204),(29558,'虎溪镇','109',2204),(29559,'西永镇','110',2204),(29560,'土主镇','111',2204),(29561,'中梁镇','112',2204),(29562,'联芳园区镇','113',2204),(29563,'杨家坪街道办事处','001',2205),(29564,'黄桷坪街道办事处','002',2205),(29565,'谢家湾街道办事处','003',2205),(29566,'石坪桥街道办事处','004',2205),(29567,'石桥铺街道办事处','005',2205),(29568,'中梁山街道办事处','006',2205),(29569,'渝州路街道办事处','007',2205),(29570,'九龙镇','100',2205),(29571,'华岩镇','102',2205),(29572,'含谷镇','103',2205),(29573,'金凤镇','104',2205),(29574,'白市驿镇','105',2205),(29575,'走马镇','106',2205),(29576,'石板镇','107',2205),(29577,'巴福镇','108',2205),(29578,'陶家镇','109',2205),(29579,'西彭镇','110',2205),(29580,'铜罐驿镇','111',2205),(29581,'铜元局街道办事处','001',2206),(29582,'花园路街道办事处','002',2206),(29583,'南坪街道','003',2206),(29584,'海棠溪街道','004',2206),(29585,'龙门浩街道','005',2206),(29586,'弹子石街道','006',2206),(29587,'南山街道','007',2206),(29588,'南坪镇','101',2206),(29589,'涂山镇','102',2206),(29590,'鸡冠石镇','103',2206),(29591,'峡口镇','105',2206),(29592,'长生桥镇','106',2206),(29593,'迎龙镇','107',2206),(29594,'广阳镇','108',2206),(29595,'天生街道','001',2207),(29596,'朝阳街道','002',2207),(29597,'北温泉街道','003',2207),(29598,'东阳街道','004',2207),(29599,'龙凤桥街道','005',2207),(29600,'歇马镇','101',2207),(29601,'澄江镇','102',2207),(29602,'蔡家岗镇','103',2207),(29603,'童家溪镇','104',2207),(29604,'天府镇','105',2207),(29605,'施家梁镇','108',2207),(29606,'水土镇','109',2207),(29607,'静观镇','110',2207),(29608,'柳荫镇','111',2207),(29609,'复兴镇','112',2207),(29610,'三圣镇','113',2207),(29611,'金刀峡镇','116',2207),(29612,'万盛街道','001',2208),(29613,'东林街道','002',2208),(29614,'万东镇','100',2208),(29615,'南桐镇','101',2208),(29616,'青年镇','102',2208),(29617,'关坝镇','103',2208),(29618,'丛林镇','104',2208),(29619,'石林镇','105',2208),(29620,'金桥镇','106',2208),(29621,'黑山镇','107',2208),(29622,'龙滩子街道办事处','001',2209),(29623,'双路镇','100',2209),(29624,'通桥镇','101',2209),(29625,'双龙湖街道','002',2210),(29626,'龙溪街道','003',2210),(29627,'回兴街道','004',2210),(29628,'双凤桥街道','005',2210),(29629,'鸳鸯街道','007',2210),(29630,'翠云街道','008',2210),(29631,'人和街道','009',2210),(29632,'天宫殿街道','010',2210),(29633,'大竹林镇','102',2210),(29634,'礼嘉镇','103',2210),(29635,'悦来镇','106',2210),(29636,'王家镇','110',2210),(29637,'御临镇','118',2210),(29638,'石船镇','120',2210),(29639,'大盛镇','123',2210),(29640,'麻柳沱镇','124',2210),(29641,'洛碛镇','125',2210),(29642,'古路镇','126',2210),(29643,'高嘴镇','127',2210),(29644,'石坪镇','129',2210),(29645,'玉峰山镇','130',2210),(29646,'龙兴镇','131',2210),(29647,'张关镇','132',2210),(29648,'统景镇','133',2210),(29649,'明月镇','134',2210),(29650,'大湾镇','135',2210),(29651,'华蓥山镇','136',2210),(29652,'茨竹镇','137',2210),(29653,'兴隆镇','138',2210),(29654,'木耳镇','139',2210),(29655,'鱼洞街道','001',2211),(29656,'李家沱街道','002',2211),(29657,'花溪镇','101',2211),(29658,'南泉镇','102',2211),(29659,'界石镇','103',2211),(29660,'一品镇','104',2211),(29661,'南彭镇','105',2211),(29662,'惠民镇','106',2211),(29663,'安澜镇','107',2211),(29664,'跳石镇','108',2211),(29665,'木洞镇','109',2211),(29666,'双河口镇','110',2211),(29667,'麻柳嘴镇','111',2211),(29668,'丰盛镇','112',2211),(29669,'二圣镇','113',2211),(29670,'东泉镇','114',2211),(29671,'姜家镇','115',2211),(29672,'天星寺镇','116',2211),(29673,'接龙镇','117',2211),(29674,'石滩镇','118',2211),(29675,'石龙镇','119',2211),(29676,'城东街道办事处','001',2212),(29677,'城南街道办事处','002',2212),(29678,'城西街道办事处','003',2212),(29679,'两河镇','105',2212),(29680,'石会镇','106',2212),(29681,'黑溪镇','107',2212),(29682,'黄溪镇','108',2212),(29683,'黎水镇','109',2212),(29684,'金溪镇','110',2212),(29685,'马喇镇','111',2212),(29686,'濯水镇','112',2212),(29687,'石家河镇','113',2212),(29688,'鹅池镇','114',2212),(29689,'正阳镇','115',2212),(29690,'舟白镇','116',2212),(29691,'小南海镇','117',2212),(29692,'冯家镇','118',2212),(29693,'邻鄂镇','119',2212),(29694,'中塘乡','245',2212),(29695,'蓬东乡','246',2212),(29696,'沙坝乡','247',2212),(29697,'白石乡','248',2212),(29698,'杉岭乡','249',2212),(29699,'太极乡','250',2212),(29700,'水田乡','251',2212),(29701,'白土乡','252',2212),(29702,'金洞乡','253',2212),(29703,'五里乡','254',2212),(29704,'水市乡','255',2212),(29705,'新华乡','256',2212),(29706,'凤城街道办事处','001',2213),(29707,'晏家街道办事处','002',2213),(29708,'江南镇','122',2213),(29709,'邻封镇','123',2213),(29710,'但渡镇','124',2213),(29711,'云集镇','125',2213),(29712,'长寿湖镇','126',2213),(29713,'双龙镇','127',2213),(29714,'龙河镇','128',2213),(29715,'石堰镇','129',2213),(29716,'云台镇','130',2213),(29717,'海棠镇','131',2213),(29718,'葛兰镇','132',2213),(29719,'新市镇','133',2213),(29720,'渡舟镇','134',2213),(29721,'八颗镇','135',2213),(29722,'洪湖镇','136',2213),(29723,'万顺镇','137',2213),(29724,'几江街道办事处','001',2214),(29725,'德感街道办事处','002',2214),(29726,'支坪街道办事处','003',2214),(29727,'双福镇','100',2214),(29728,'油溪镇','101',2214),(29729,'吴滩镇','102',2214),(29730,'石门镇','103',2214),(29731,'朱杨镇','104',2214),(29732,'石蟆镇','105',2214),(29733,'永兴镇','106',2214),(29734,'塘河镇','107',2214),(29735,'白沙镇','108',2214),(29736,'龙华镇','109',2214),(29737,'李市镇','110',2214),(29738,'慈云镇','111',2214),(29739,'蔡家镇','112',2214),(29740,'中山镇','113',2214),(29741,'嘉平镇','114',2214),(29742,'柏林镇','115',2214),(29743,'先锋镇','116',2214),(29744,'珞璜镇','117',2214),(29745,'贾嗣镇','118',2214),(29746,'夏坝镇','119',2214),(29747,'西湖镇','120',2214),(29748,'杜市镇','121',2214),(29749,'广兴镇','122',2214),(29750,'四面山风景管理委员会','400',2214),(29751,'合阳城街道办事处','001',2215),(29752,'钓鱼城街道办事处','002',2215),(29753,'南津街街道办事处','003',2215),(29754,'沙鱼镇','100',2215),(29755,'官渡镇','101',2215),(29756,'涞滩镇','102',2215),(29757,'肖家镇','103',2215),(29758,'古楼镇','104',2215),(29759,'三庙镇','105',2215),(29760,'二郎镇','106',2215),(29761,'龙凤镇','107',2215),(29762,'隆兴镇','108',2215),(29763,'铜溪镇','109',2215),(29764,'盐井镇','110',2215),(29765,'草街镇','111',2215),(29766,'双凤镇','112',2215),(29767,'狮滩镇','113',2215),(29768,'清平镇','114',2215),(29769,'土场镇','115',2215),(29770,'小沔镇','116',2215),(29771,'三汇镇','117',2215),(29772,'香龙镇','118',2215),(29773,'云门镇','119',2215),(29774,'钱塘镇','120',2215),(29775,'龙市镇','121',2215),(29776,'大石镇','122',2215),(29777,'燕窝镇','123',2215),(29778,'太和镇','124',2215),(29779,'渭沱镇','125',2215),(29780,'双槐镇','126',2215),(29781,'中山路街道','001',2216),(29782,'胜利路街道','002',2216),(29783,'南大街街道','003',2216),(29784,'青峰镇','100',2216),(29785,'大安镇','101',2216),(29786,'金龙镇','102',2216),(29787,'陈食镇','103',2216),(29788,'临江镇','104',2216),(29789,'双竹镇','105',2216),(29790,'何埂镇','106',2216),(29791,'松既镇','107',2216),(29792,'仙龙镇','108',2216),(29793,'吉安镇','109',2216),(29794,'五间镇','110',2216),(29795,'来苏镇','111',2216),(29796,'宝峰镇','112',2216),(29797,'双石镇','113',2216),(29798,'红炉镇','114',2216),(29799,'永荣镇','115',2216),(29800,'三教镇','116',2216),(29801,'板桥镇','117',2216),(29802,'朱沱镇','118',2216),(29803,'东城街道办事处','001',2217),(29804,'南城街道办事处','002',2217),(29805,'西城街道办事处','003',2217),(29806,'三泉镇','100',2217),(29807,'南平镇','101',2217),(29808,'神童镇','102',2217),(29809,'鸣玉镇','103',2217),(29810,'大观镇','104',2217),(29811,'兴隆镇','105',2217),(29812,'太平场镇','106',2217),(29813,'白沙镇','107',2217),(29814,'水江镇','108',2217),(29815,'石墙镇','109',2217),(29816,'金山镇','110',2217),(29817,'头渡镇','111',2217),(29818,'大有镇','112',2217),(29819,'合溪镇','113',2217),(29820,'石莲乡','200',2217),(29821,'木凉乡','201',2217),(29822,'河图乡','202',2217),(29823,'土溪乡','203',2217),(29824,'乾丰乡','204',2217),(29825,'骑龙乡','205',2217),(29826,'鱼泉乡','206',2217),(29827,'中桥乡','207',2217),(29828,'铁村乡','208',2217),(29829,'德隆乡','209',2217),(29830,'庆元乡','210',2217),(29831,'古花乡','211',2217),(29832,'峰岩乡','212',2217),(29833,'民主乡','213',2217),(29834,'冷水关乡','214',2217),(29835,'石溪乡','215',2217),(29836,'福寿乡','216',2217),(29837,'古南镇','100',2218),(29838,'三江镇','101',2218),(29839,'石角镇','102',2218),(29840,'东溪镇','103',2218),(29841,'赶水镇','104',2218),(29842,'打通镇','105',2218),(29843,'石壕镇','106',2218),(29844,'永新镇','107',2218),(29845,'三角镇','108',2218),(29846,'隆盛镇','109',2218),(29847,'郭扶镇','110',2218),(29848,'篆塘镇','111',2218),(29849,'丁山镇','112',2218),(29850,'安稳镇','113',2218),(29851,'扶欢镇','114',2218),(29852,'永城镇','115',2218),(29853,'新盛镇','116',2218),(29854,'中峰镇','117',2218),(29855,'横山镇','118',2218),(29856,'桂林街道办事处','001',2219),(29857,'梓潼街道办事处','002',2219),(29858,'上和镇','101',2219),(29859,'龙形镇','102',2219),(29860,'古溪镇','103',2219),(29861,'宝龙镇','104',2219),(29862,'玉溪镇','107',2219),(29863,'米心镇','108',2219),(29864,'群力镇','109',2219),(29865,'双江镇','110',2219),(29866,'花岩镇','112',2219),(29867,'柏梓镇','113',2219),(29868,'崇龛镇','114',2219),(29869,'塘坝镇','115',2219),(29870,'新胜镇','116',2219),(29871,'太安镇','117',2219),(29872,'小渡镇','119',2219),(29873,'卧佛镇','120',2219),(29874,'五桂镇','121',2219),(29875,'田家乡','200',2219),(29876,'别口乡','203',2219),(29877,'寿桥乡','208',2219),(29878,'巴川街道','001',2220),(29879,'东城街道','002',2220),(29880,'南城街道','003',2220),(29881,'土桥镇','101',2220),(29882,'二坪镇','103',2220),(29883,'水口镇','104',2220),(29884,'安居镇','105',2220),(29885,'白羊镇','106',2220),(29886,'平滩镇','107',2220),(29887,'石鱼镇','110',2220),(29888,'福果镇','111',2220),(29889,'维新镇','113',2220),(29890,'高楼镇','114',2220),(29891,'大庙镇','115',2220),(29892,'围龙镇','116',2220),(29893,'华兴镇','117',2220),(29894,'永嘉镇','120',2220),(29895,'安溪镇','121',2220),(29896,'西河镇','122',2220),(29897,'太平镇','124',2220),(29898,'旧县镇','125',2220),(29899,'虎峰镇','126',2220),(29900,'少云镇','127',2220),(29901,'蒲吕镇','128',2220),(29902,'侣俸镇','129',2220),(29903,'小林乡','201',2220),(29904,'双山乡','202',2220),(29905,'庆隆乡','205',2220),(29906,'龙岗街道办事处','001',2221),(29907,'棠香街道办事处','002',2221),(29908,'龙水镇','100',2221),(29909,'智凤镇','101',2221),(29910,'宝顶镇','102',2221),(29911,'中敖镇','103',2221),(29912,'三驱镇','104',2221),(29913,'宝兴镇','105',2221),(29914,'玉龙镇','106',2221),(29915,'石马镇','107',2221),(29916,'拾万镇','108',2221),(29917,'回龙镇','109',2221),(29918,'金山镇','110',2221),(29919,'万古镇','111',2221),(29920,'国梁镇','112',2221),(29921,'雍溪镇','113',2221),(29922,'珠溪镇','114',2221),(29923,'龙石镇','115',2221),(29924,'邮亭镇','116',2221),(29925,'铁山镇','117',2221),(29926,'高升镇','118',2221),(29927,'季家镇','119',2221),(29928,'古龙乡','200',2221),(29929,'高坪乡','201',2221),(29930,'昌元镇','100',2222),(29931,'广顺镇','101',2222),(29932,'峰高镇','102',2222),(29933,'直升镇','103',2222),(29934,'路孔镇','104',2222),(29935,'安富镇','105',2222),(29936,'清江镇','106',2222),(29937,'仁义镇','107',2222),(29938,'河包镇','108',2222),(29939,'古昌镇','109',2222),(29940,'吴家镇','110',2222),(29941,'观胜镇','111',2222),(29942,'铜鼓镇','112',2222),(29943,'清流镇','113',2222),(29944,'盘龙镇','114',2222),(29945,'远觉镇','115',2222),(29946,'双河镇','116',2222),(29947,'清升镇','117',2222),(29948,'荣隆镇','118',2222),(29949,'龙集镇','119',2222),(29950,'璧城街道办事处','001',2223),(29951,'青杠街道办事处','002',2223),(29952,'八塘镇','100',2223),(29953,'七塘镇','101',2223),(29954,'大路镇','102',2223),(29955,'河边镇','103',2223),(29956,'福禄镇','104',2223),(29957,'大兴镇','105',2223),(29958,'正兴镇','106',2223),(29959,'丁家镇','107',2223),(29960,'广普镇','108',2223),(29961,'三合镇','109',2223),(29962,'健龙乡','200',2223),(29963,'梁山镇','100',2224),(29964,'仁贤镇','101',2224),(29965,'礼让镇','102',2224),(29966,'云龙镇','103',2224),(29967,'屏锦镇','104',2224),(29968,'袁驿镇','106',2224),(29969,'新盛镇','107',2224),(29970,'福禄镇','108',2224),(29971,'金带镇','109',2224),(29972,'聚奎镇','110',2224),(29973,'明达镇','111',2224),(29974,'荫平镇','112',2224),(29975,'和林镇','113',2224),(29976,'回龙镇','114',2224),(29977,'碧山镇','115',2224),(29978,'虎城镇','116',2224),(29979,'七星镇','117',2224),(29980,'龙门镇','118',2224),(29981,'文化镇','119',2224),(29982,'合兴镇','120',2224),(29983,'石安镇','121',2224),(29984,'柏家镇','122',2224),(29985,'大观镇','123',2224),(29986,'竹山镇','124',2224),(29987,'蟠龙镇','125',2224),(29988,'安胜乡','200',2224),(29989,'铁门乡','201',2224),(29990,'龙胜乡','202',2224),(29991,'复平乡','203',2224),(29992,'城东乡','204',2224),(29993,'紫照乡','205',2224),(29994,'城北乡','206',2224),(29995,'曲水乡','207',2224),(29996,'梁平县农场','400',2224),(29997,'梁平县双桂工业园区','401',2224),(29998,'葛城镇','100',2225),(29999,'巴山镇','102',2225),(30000,'坪坝镇','103',2225),(30001,'庙坝镇','104',2225),(30002,'明通镇','105',2225),(30003,'修齐镇','106',2225),(30004,'高观镇','107',2225),(30005,'高燕乡','200',2225),(30006,'龙田乡','201',2225),(30007,'北屏乡','202',2225),(30008,'高楠乡','204',2225),(30009,'左岚乡','205',2225),(30010,'沿河乡','208',2225),(30011,'双河乡','210',2225),(30012,'蓼子乡','211',2225),(30013,'鸡鸣乡','212',2225),(30014,'咸宜乡','213',2225),(30015,'周溪乡','214',2225),(30016,'明中乡','216',2225),(30017,'治平乡','217',2225),(30018,'岚天乡','219',2225),(30019,'厚坪乡','220',2225),(30020,'河鱼乡','221',2225),(30021,'东安乡','223',2225),(30022,'三合镇','100',2226),(30023,'虎威镇','101',2226),(30024,'社坛镇','102',2226),(30025,'三元镇','103',2226),(30026,'许明寺镇','104',2226),(30027,'董家镇','105',2226),(30028,'树人镇','106',2226),(30029,'十直镇','107',2226),(30030,'镇江镇','108',2226),(30031,'高家镇','109',2226),(30032,'兴义镇','110',2226),(30033,'双路镇','111',2226),(30034,'江池镇','112',2226),(30035,'龙河镇','113',2226),(30036,'武平镇','114',2226),(30037,'包鸾镇','115',2226),(30038,'湛普镇','116',2226),(30039,'名山镇','117',2226),(30040,'南天湖镇','118',2226),(30041,'崇兴乡','200',2226),(30042,'仁沙乡','201',2226),(30043,'青龙乡','202',2226),(30044,'双龙场乡','203',2226),(30045,'保合乡','204',2226),(30046,'龙孔乡','205',2226),(30047,'太平坝乡','206',2226),(30048,'都督乡','207',2226),(30049,'暨龙乡','208',2226),(30050,'栗子乡','209',2226),(30051,'三建乡','210',2226),(30052,'三坝乡','211',2226),(30053,'桂溪镇','100',2227),(30054,'新民镇','101',2227),(30055,'沙坪镇','102',2227),(30056,'周嘉镇','103',2227),(30057,'普顺镇','104',2227),(30058,'永安镇','105',2227),(30059,'高安镇','106',2227),(30060,'高峰镇','107',2227),(30061,'五洞镇','108',2227),(30062,'澄溪镇','109',2227),(30063,'太平镇','110',2227),(30064,'鹤游镇','111',2227),(30065,'坪山镇','112',2227),(30066,'砚台镇','113',2227),(30067,'曹回乡','200',2227),(30068,'长龙乡','201',2227),(30069,'沙河乡','202',2227),(30070,'杠家乡','203',2227),(30071,'大石乡','204',2227),(30072,'黄沙乡','205',2227),(30073,'包家乡','206',2227),(30074,'白家乡','207',2227),(30075,'永平乡','208',2227),(30076,'三溪乡','209',2227),(30077,'裴兴乡','210',2227),(30078,'巷口镇','100',2228),(30079,'火炉镇','101',2228),(30080,'白马镇','102',2228),(30081,'鸭江镇','103',2228),(30082,'长坝镇','104',2228),(30083,'江口镇','105',2228),(30084,'平桥镇','106',2228),(30085,'羊角镇','107',2228),(30086,'仙女山镇','108',2228),(30087,'桐梓镇','109',2228),(30088,'土坎镇','110',2228),(30089,'凤来乡','200',2228),(30090,'和顺乡','201',2228),(30091,'庙垭乡','202',2228),(30092,'石桥乡','203',2228),(30093,'双河乡','204',2228),(30094,'黄莺乡','205',2228),(30095,'沧沟乡','206',2228),(30096,'文复乡','207',2228),(30097,'土地乡','208',2228),(30098,'白云乡','209',2228),(30099,'后坪乡','210',2228),(30100,'浩口乡','211',2228),(30101,'接龙乡','212',2228),(30102,'赵家乡','213',2228),(30103,'铁矿乡','214',2228),(30104,'忠州镇','100',2229),(30105,'新生镇','101',2229),(30106,'任家镇','102',2229),(30107,'乌杨镇','103',2229),(30108,'洋渡镇','104',2229),(30109,'东溪镇','105',2229),(30110,'复兴镇','106',2229),(30111,'石宝镇','107',2229),(30112,'汝溪镇','108',2229),(30113,'野鹤镇','109',2229),(30114,'官坝镇','110',2229),(30115,'石黄镇','111',2229),(30116,'马灌镇','112',2229),(30117,'金鸡镇','113',2229),(30118,'新立镇','114',2229),(30119,'双桂镇','115',2229),(30120,'拔山镇','116',2229),(30121,'花桥镇','117',2229),(30122,'永丰镇','118',2229),(30123,'三汇镇','119',2229),(30124,'白石镇','120',2229),(30125,'黄金镇','122',2229),(30126,'善广乡','201',2229),(30127,'石子乡','203',2229),(30128,'磨子土家族自治乡','204',2229),(30129,'涂井乡','206',2229),(30130,'金声乡','208',2229),(30131,'兴峰乡','210',2229),(30132,'汉丰街道办事处','001',2230),(30133,'镇东街道办事处','002',2230),(30134,'丰乐街道办事处','003',2230),(30135,'白鹤街道办事处','004',2230),(30136,'郭家镇','103',2230),(30137,'温泉镇','106',2230),(30138,'铁桥镇','107',2230),(30139,'南雅镇','112',2230),(30140,'和谦镇','114',2230),(30141,'镇安镇','116',2230),(30142,'竹溪镇','118',2230),(30143,'渠口镇','119',2230),(30144,'厚坝镇','120',2230),(30145,'高桥镇','122',2230),(30146,'义和镇','127',2230),(30147,'大进镇','128',2230),(30148,'长沙镇','129',2230),(30149,'临江镇','130',2230),(30150,'赵家镇','131',2230),(30151,'敦好镇','132',2230),(30152,'中和镇','133',2230),(30153,'岳溪镇','134',2230),(30154,'南门镇','135',2230),(30155,'河堰镇','136',2230),(30156,'九龙山镇','137',2230),(30157,'白泉乡','202',2230),(30158,'关面乡','203',2230),(30159,'满月乡','204',2230),(30160,'五通乡','211',2230),(30161,'白桥乡','214',2230),(30162,'麻柳乡','215',2230),(30163,'紫水乡','216',2230),(30164,'天和乡','224',2230),(30165,'三汇口乡','225',2230),(30166,'金峰乡','226',2230),(30167,'谭家乡','227',2230),(30168,'巫山乡','228',2230),(30169,'大德乡','229',2230),(30170,'云阳镇','100',2231),(30171,'云安镇','101',2231),(30172,'双江镇','102',2231),(30173,'龙角镇','105',2231),(30174,'故陵镇','107',2231),(30175,'红狮镇','108',2231),(30176,'路阳镇','115',2231),(30177,'农坝镇','116',2231),(30178,'渠马镇','118',2231),(30179,'黄石镇','121',2231),(30180,'巴阳镇','122',2231),(30181,'沙市镇','123',2231),(30182,'鱼泉镇','124',2231),(30183,'凤鸣镇','125',2231),(30184,'盘龙镇','126',2231),(30185,'宝坪镇','127',2231),(30186,'南溪镇','128',2231),(30187,'双土镇','129',2231),(30188,'桑坪镇','130',2231),(30189,'江口镇','131',2231),(30190,'高阳镇','132',2231),(30191,'平安镇','133',2231),(30192,'人和镇','134',2231),(30193,'栖霞乡','202',2231),(30194,'外郎乡','208',2231),(30195,'泥溪乡','209',2231),(30196,'耀灵乡','210',2231),(30197,'票草乡','213',2231),(30198,'堰坪乡','214',2231),(30199,'新津乡','215',2231),(30200,'普安乡','216',2231),(30201,'龙洞乡','217',2231),(30202,'洞鹿乡','218',2231),(30203,'石门乡','219',2231),(30204,'大阳乡','220',2231),(30205,'后叶乡','229',2231),(30206,'养鹿乡','235',2231),(30207,'水口乡','236',2231),(30208,'上坝乡','239',2231),(30209,'云硐乡','240',2231),(30210,'毛坝乡','241',2231),(30211,'清水土家族自治乡','242',2231),(30212,'双龙乡','243',2231),(30213,'永安镇','116',2232),(30214,'白帝镇','117',2232),(30215,'草堂镇','118',2232),(30216,'汾河镇','119',2232),(30217,'康乐镇','120',2232),(30218,'大树镇','121',2232),(30219,'竹园镇','122',2232),(30220,'公平镇','123',2232),(30221,'朱衣镇','124',2232),(30222,'甲高镇','125',2232),(30223,'羊市镇','126',2232),(30224,'吐祥镇','127',2232),(30225,'兴隆镇','128',2232),(30226,'青龙镇','129',2232),(30227,'新民镇','130',2232),(30228,'永乐镇','131',2232),(30229,'岩湾乡','265',2232),(30230,'平安乡','266',2232),(30231,'红土乡','267',2232),(30232,'新政乡','268',2232),(30233,'石岗乡','269',2232),(30234,'康坪乡','270',2232),(30235,'五马乡','271',2232),(30236,'太和乡','272',2232),(30237,'安坪乡','273',2232),(30238,'鹤峰乡','274',2232),(30239,'冯坪乡','275',2232),(30240,'长安土家族乡','276',2232),(30241,'龙桥土家族乡','277',2232),(30242,'云雾土家族乡','278',2232),(30243,'巫峡镇','100',2233),(30244,'庙宇镇','101',2233),(30245,'大昌镇','102',2233),(30246,'福田镇','103',2233),(30247,'龙溪镇','104',2233),(30248,'双龙镇','105',2233),(30249,'官阳镇','106',2233),(30250,'骡坪镇','107',2233),(30251,'抱龙镇','108',2233),(30252,'官渡镇','109',2233),(30253,'铜鼓镇','110',2233),(30254,'红椿乡','200',2233),(30255,'龙井乡','205',2233),(30256,'两坪乡','207',2233),(30257,'曲尺乡','208',2233),(30258,'建坪乡','210',2233),(30259,'大溪乡','211',2233),(30260,'金坪乡','214',2233),(30261,'平河乡','216',2233),(30262,'庙堂乡','218',2233),(30263,'当阳乡','219',2233),(30264,'竹贤乡','222',2233),(30265,'三溪乡','225',2233),(30266,'培石乡','227',2233),(30267,'笃坪乡','229',2233),(30268,'邓家乡','231',2233),(30269,'城厢镇','100',2234),(30270,'凤凰镇','101',2234),(30271,'宁厂镇','102',2234),(30272,'上磺镇','103',2234),(30273,'古路镇','104',2234),(30274,'文峰镇','105',2234),(30275,'徐家镇','106',2234),(30276,'白鹿镇','107',2234),(30277,'尖山镇','108',2234),(30278,'下堡镇','109',2234),(30279,'胜利乡','204',2234),(30280,'菱角乡','205',2234),(30281,'大河乡','207',2234),(30282,'天星乡','208',2234),(30283,'长桂乡','210',2234),(30284,'蒲莲乡','212',2234),(30285,'峰灵乡','213',2234),(30286,'塘坊乡','216',2234),(30287,'朝阳洞乡','220',2234),(30288,'鱼鳞乡','226',2234),(30289,'乌龙乡','227',2234),(30290,'田坝乡','229',2234),(30291,'中岗乡','234',2234),(30292,'通城乡','236',2234),(30293,'花台乡','237',2234),(30294,'兰英乡','239',2234),(30295,'双阳乡','240',2234),(30296,'中梁乡','242',2234),(30297,'天元乡','243',2234),(30298,'土城乡','245',2234),(30299,'红池坝经济开发区','400',2234),(30300,'南宾镇','100',2235),(30301,'西沱镇','101',2235),(30302,'下路镇','102',2235),(30303,'悦崃镇','103',2235),(30304,'临溪镇','104',2235),(30305,'黄水镇','105',2235),(30306,'马武镇','106',2235),(30307,'沙子镇','107',2235),(30308,'王场镇','108',2235),(30309,'沿溪镇','109',2235),(30310,'龙沙镇','110',2235),(30311,'鱼池镇','111',2235),(30312,'大歇乡','200',2235),(30313,'三河乡','201',2235),(30314,'万朝乡','202',2235),(30315,'黎场乡','203',2235),(30316,'三星乡','204',2235),(30317,'六塘乡','205',2235),(30318,'桥头乡','206',2235),(30319,'三益乡','207',2235),(30320,'王家乡','208',2235),(30321,'河嘴乡','209',2235),(30322,'石家乡','210',2235),(30323,'冷水乡','211',2235),(30324,'枫木乡','212',2235),(30325,'中益乡','213',2235),(30326,'洗新乡','214',2235),(30327,'黄鹤乡','215',2235),(30328,'龙潭乡','216',2235),(30329,'新乐乡','217',2235),(30330,'金铃乡','218',2235),(30331,'金竹乡','219',2235),(30332,'中和镇','100',2236),(30333,'平凯镇','101',2236),(30334,'清溪场镇','102',2236),(30335,'隘口镇','103',2236),(30336,'溶溪镇','104',2236),(30337,'官庄镇','105',2236),(30338,'龙池镇','106',2236),(30339,'石堤镇','107',2236),(30340,'峨溶镇','108',2236),(30341,'洪安镇','109',2236),(30342,'雅江镇','110',2236),(30343,'石耶镇','111',2236),(30344,'梅江镇','112',2236),(30345,'兰桥镇','113',2236),(30346,'官舟乡','200',2236),(30347,'孝溪乡','201',2236),(30348,'塘坳乡','202',2236),(30349,'膏田乡','203',2236),(30350,'溪口乡','204',2236),(30351,'妙泉乡','205',2236),(30352,'宋农乡','206',2236),(30353,'海洋乡','207',2236),(30354,'大溪乡','208',2236),(30355,'保安乡','209',2236),(30356,'里仁乡','210',2236),(30357,'涌洞乡','211',2236),(30358,'干川乡','212',2236),(30359,'平马乡','213',2236),(30360,'中平乡','214',2236),(30361,'岑溪乡','215',2236),(30362,'钟灵乡','216',2236),(30363,'巴家乡','217',2236),(30364,'钟多镇','100',2237),(30365,'龙潭镇','101',2237),(30366,'麻旺镇','102',2237),(30367,'酉酬镇','103',2237),(30368,'大溪镇','104',2237),(30369,'兴隆镇','105',2237),(30370,'黑水镇','106',2237),(30371,'丁市镇','107',2237),(30372,'龚滩镇','108',2237),(30373,'李溪镇','109',2237),(30374,'泔溪镇','110',2237),(30375,'后溪镇','111',2237),(30376,'苍岭镇','112',2237),(30377,'小河镇','113',2237),(30378,'涂市乡','200',2237),(30379,'板溪乡','201',2237),(30380,'铜鼓乡','202',2237),(30381,'江丰乡','203',2237),(30382,'可大乡','204',2237),(30383,'偏柏乡','205',2237),(30384,'五福乡','206',2237),(30385,'木叶乡','207',2237),(30386,'毛坝乡','208',2237),(30387,'花田乡','209',2237),(30388,'后坪乡','210',2237),(30389,'天馆乡','211',2237),(30390,'宜居乡','212',2237),(30391,'万木乡','213',2237),(30392,'两罾乡','214',2237),(30393,'板桥乡','215',2237),(30394,'官清乡','216',2237),(30395,'南腰界乡','217',2237),(30396,'车田乡','218',2237),(30397,'腴地乡','219',2237),(30398,'清泉乡','220',2237),(30399,'庙溪乡','221',2237),(30400,'浪坪乡','222',2237),(30401,'双泉乡','223',2237),(30402,'楠木乡','224',2237),(30403,'汉葭镇','100',2238),(30404,'保家镇','101',2238),(30405,'郁山镇','102',2238),(30406,'高谷镇','103',2238),(30407,'桑柘镇','104',2238),(30408,'鹿角镇','105',2238),(30409,'黄家镇','106',2238),(30410,'普子镇','107',2238),(30411,'龙射镇','108',2238),(30412,'连湖镇','109',2238),(30413,'靛水乡','200',2238),(30414,'岩东乡','201',2238),(30415,'鹿鸣乡','202',2238),(30416,'平安乡','203',2238),(30417,'棣棠乡','204',2238),(30418,'太原乡','205',2238),(30419,'三义乡','206',2238),(30420,'联合乡','207',2238),(30421,'石柳乡','208',2238),(30422,'龙溪乡','209',2238),(30423,'走马乡','210',2238),(30424,'芦塘乡','211',2238),(30425,'长滩乡','212',2238),(30426,'乔梓乡','213',2238),(30427,'迁桥乡','214',2238),(30428,'新田乡','215',2238),(30429,'梅子垭乡','216',2238),(30430,'诸佛乡','217',2238),(30431,'小厂乡','218',2238),(30432,'桐楼乡','219',2238),(30433,'万足乡','220',2238),(30434,'鞍子乡','221',2238),(30435,'善感乡','222',2238),(30436,'双龙乡','223',2238),(30437,'石盘乡','224',2238),(30438,'大垭乡','225',2238),(30439,'润溪乡','226',2238),(30440,'朗溪乡','227',2238),(30441,'龙塘乡','228',2238),(30442,'督院街街道办事处','020',2240),(30443,'盐市口街道办事处','021',2240),(30444,'春熙路街道办事处','022',2240),(30445,'书院街街道办事处','023',2240),(30446,'合江亭街道办事处','024',2240),(30447,'水井坊街道办事处','025',2240),(30448,'牛市口街道办事处','026',2240),(30449,'龙舟路街道办事处','027',2240),(30450,'双桂路街道办事处','028',2240),(30451,'莲新街道办事处','029',2240),(30452,'沙河街道办事处','030',2240),(30453,'东光街道办事处','031',2240),(30454,'狮子山街道办事处','032',2240),(30455,'成龙路街道办事处','035',2240),(30456,'柳江街道办事处','036',2240),(30457,'三圣街道办事处','037',2240),(30458,'太升路街道办事处','001',2241),(30459,'草市街街道办事处','002',2241),(30460,'西御河街道办事处','003',2241),(30461,'汪家拐街道办事处','004',2241),(30462,'少城街街道办事处','005',2241),(30463,'新华西路街道办事处','006',2241),(30464,'草堂路街道办事处','007',2241),(30465,'府南街道办事处','008',2241),(30466,'光华街道办事处','009',2241),(30467,'东坡街道办事处','010',2241),(30468,'金沙街道办事处','011',2241),(30469,'黄田坝街道办事处','012',2241),(30470,'苏坡街道办事处','013',2241),(30471,'文家街道办事处','014',2241),(30472,'西安路街道办事处','024',2242),(30473,'西华街道办事处','025',2242),(30474,'人民北路街道办事处','026',2242),(30475,'荷花池街道办事处','027',2242),(30476,'驷马桥街道办事处','030',2242),(30477,'茶店子街道办事处','031',2242),(30478,'抚琴街道办事处','032',2242),(30479,'九里堤街道办事处','035',2242),(30480,'五块石街道办事处','036',2242),(30481,'黄忠街道办事处','037',2242),(30482,'营门口街道办事处','038',2242),(30483,'金泉街道办事处','040',2242),(30484,'沙河源街道办事处','041',2242),(30485,'天回镇街道办事处','042',2242),(30486,'凤凰山街道办事处','043',2242),(30487,'浆洗街街道办事处','001',2243),(30488,'小天竺街道办事处','002',2243),(30489,'致民路街道办事处','003',2243),(30490,'望江路街道办事处','004',2243),(30491,'玉林街道办事处','005',2243),(30492,'跳伞塔街道办事处','006',2243),(30493,'火车南站街道办事处','007',2243),(30494,'双楠街道办事处','008',2243),(30495,'晋阳街道办事处','009',2243),(30496,'红牌楼街道办事处','010',2243),(30497,'簇桥街道办事处','011',2243),(30498,'机投桥街道办事处','012',2243),(30499,'金花桥街道办事处','013',2243),(30500,'芳草街道办事处','061',2243),(30501,'肖家河街道办事处','062',2243),(30502,'石羊场街道办事处','063',2243),(30503,'桂溪街道办事处','064',2243),(30504,'猛追街道办事处','002',2244),(30505,'双桥街道办事处','004',2244),(30506,'建设街道办事处','005',2244),(30507,'府青街道办事处','006',2244),(30508,'二仙街道办事处','007',2244),(30509,'跳蹬街道办事处','008',2244),(30510,'新鸿街道办事处','009',2244),(30511,'双水碾街道办事处','010',2244),(30512,'万年街道办事处','011',2244),(30513,'桃蹊街道办事处','012',2244),(30514,'圣灯街道办事处','013',2244),(30515,'保和街道办事处','014',2244),(30516,'青龙街道办事处','015',2244),(30517,'龙潭街道办事处','016',2244),(30518,'龙泉街道办事处','001',2245),(30519,'大面街道办事处','002',2245),(30520,'十陵街道办事处','003',2245),(30521,'同安街道办事处','004',2245),(30522,'洛带镇','102',2245),(30523,'西河镇','104',2245),(30524,'洪安镇','108',2245),(30525,'柏合镇','109',2245),(30526,'茶店镇','110',2245),(30527,'黄土镇','111',2245),(30528,'山泉镇','115',2245),(30529,'万兴乡','200',2245),(30530,'红阳街道','001',2246),(30531,'大弯街道','002',2246),(30532,'弥牟镇','102',2246),(30533,'大同镇','103',2246),(30534,'城厢镇','104',2246),(30535,'祥福镇','105',2246),(30536,'姚渡镇','106',2246),(30537,'清泉镇','108',2246),(30538,'龙王镇','110',2246),(30539,'福洪乡','202',2246),(30540,'人和乡','203',2246),(30541,'大丰街道办事处','001',2247),(30542,'三河街道办事处','003',2247),(30543,'新都镇','100',2247),(30544,'石板滩镇','102',2247),(30545,'新繁镇','103',2247),(30546,'新民镇','104',2247),(30547,'泰兴镇','106',2247),(30548,'斑竹园镇','108',2247),(30549,'清流镇','109',2247),(30550,'马家镇','111',2247),(30551,'龙桥镇','112',2247),(30552,'木兰镇','114',2247),(30553,'军屯镇','116',2247),(30554,'柳城街道办事处','001',2248),(30555,'公平街道办事处','002',2248),(30556,'涌泉街道办事处','003',2248),(30557,'天府街道办事处','004',2248),(30558,'金马街道办事处','005',2248),(30559,'永宁街道办事处','006',2248),(30560,'万春街道办事处','007',2248),(30561,'和盛镇','101',2248),(30562,'永盛镇','102',2248),(30563,'寿安镇','106',2248),(30564,'赵镇','100',2249),(30565,'三星镇','101',2249),(30566,'清江镇','102',2249),(30567,'官仓镇','103',2249),(30568,'淮口镇','104',2249),(30569,'白果镇','105',2249),(30570,'五凤镇','106',2249),(30571,'高板镇','108',2249),(30572,'三溪镇','109',2249),(30573,'福兴镇','110',2249),(30574,'金龙镇','111',2249),(30575,'赵家镇','112',2249),(30576,'竹篙镇','113',2249),(30577,'广兴镇','114',2249),(30578,'隆盛镇','115',2249),(30579,'转龙镇','116',2249),(30580,'土桥镇','117',2249),(30581,'云合镇','118',2249),(30582,'又新镇','119',2249),(30583,'栖贤乡','200',2249),(30584,'平桥乡','203',2249),(30585,'东升街道办事处','001',2250),(30586,'西航港街道办事处','002',2250),(30587,'华阳街道办事处','003',2250),(30588,'中和街道办事处','004',2250),(30589,'太平镇','101',2250),(30590,'永兴镇','102',2250),(30591,'籍田镇','106',2250),(30592,'正兴镇','107',2250),(30593,'彭镇','108',2250),(30594,'大林镇','109',2250),(30595,'煎茶镇','110',2250),(30596,'黄龙溪镇','111',2250),(30597,'永安镇','112',2250),(30598,'九江镇','114',2250),(30599,'黄水镇','115',2250),(30600,'金桥镇','116',2250),(30601,'黄甲镇','117',2250),(30602,'公兴镇','118',2250),(30603,'胜利镇','119',2250),(30604,'新兴镇','120',2250),(30605,'兴隆镇','121',2250),(30606,'万安镇','122',2250),(30607,'白沙镇','123',2250),(30608,'三星镇','124',2250),(30609,'合江镇','125',2250),(30610,'郫筒镇','100',2251),(30611,'团结镇','101',2251),(30612,'犀浦镇','102',2251),(30613,'花园镇','103',2251),(30614,'唐昌镇','104',2251),(30615,'安德镇','105',2251),(30616,'三道堰镇','106',2251),(30617,'安靖镇','107',2251),(30618,'红光镇','108',2251),(30619,'新民场镇','110',2251),(30620,'德源镇','112',2251),(30621,'友爱镇','115',2251),(30622,'古城镇','117',2251),(30623,'唐元镇','118',2251),(30624,'合作镇','119',2251),(30625,'晋原镇','100',2252),(30626,'王泗镇','101',2252),(30627,'新场镇','103',2252),(30628,'悦来镇','104',2252),(30629,'安仁镇','105',2252),(30630,'出江镇','106',2252),(30631,'花水湾镇','107',2252),(30632,'西岭镇','108',2252),(30633,'斜源镇','109',2252),(30634,'董场镇','110',2252),(30635,'韩场镇','111',2252),(30636,'三岔镇','112',2252),(30637,'上安镇','113',2252),(30638,'苏家镇','114',2252),(30639,'青霞镇','115',2252),(30640,'沙渠镇','116',2252),(30641,'蔡场镇','118',2252),(30642,'雾山乡','202',2252),(30643,'金星乡','203',2252),(30644,'鹤鸣乡','205',2252),(30645,'鹤山镇','100',2253),(30646,'大塘镇','101',2253),(30647,'寿安镇','102',2253),(30648,'朝阳湖镇','103',2253),(30649,'西来镇','104',2253),(30650,'大兴镇','105',2253),(30651,'甘溪镇','106',2253),(30652,'成佳镇','107',2253),(30653,'复兴乡','200',2253),(30654,'光明乡','201',2253),(30655,'白云乡','202',2253),(30656,'长秋乡','203',2253),(30657,'五津镇','100',2254),(30658,'花桥镇','101',2254),(30659,'花源镇','102',2254),(30660,'金华镇','103',2254),(30661,'普兴镇','104',2254),(30662,'兴义镇','105',2254),(30663,'新平镇','106',2254),(30664,'方兴镇','107',2254),(30665,'安西镇','108',2254),(30666,'永商镇','109',2254),(30667,'邓双镇','110',2254),(30668,'文井乡','202',2254),(30669,'灌口镇','100',2255),(30670,'幸福镇','101',2255),(30671,'蒲阳镇','102',2255),(30672,'聚源镇','103',2255),(30673,'崇义镇','104',2255),(30674,'天马镇','105',2255),(30675,'石羊镇','106',2255),(30676,'柳街镇','107',2255),(30677,'玉堂镇','108',2255),(30678,'中兴镇','109',2255),(30679,'青城山镇','110',2255),(30680,'龙池镇','111',2255),(30681,'胥家镇','112',2255),(30682,'安龙镇','113',2255),(30683,'大观镇','114',2255),(30684,'紫坪铺镇','115',2255),(30685,'翠月湖镇','116',2255),(30686,'向峨乡','202',2255),(30687,'虹口乡','211',2255),(30688,'天彭镇','100',2256),(30689,'龙门山镇','101',2256),(30690,'新兴镇','102',2256),(30691,'丽春镇','103',2256),(30692,'九尺镇','104',2256),(30693,'蒙阳镇','105',2256),(30694,'通济镇','106',2256),(30695,'丹景山镇','107',2256),(30696,'隆丰镇','108',2256),(30697,'敖平镇','109',2256),(30698,'磁峰镇','110',2256),(30699,'桂花镇','111',2256),(30700,'军乐镇','113',2256),(30701,'三界镇','114',2256),(30702,'小渔洞镇','116',2256),(30703,'红岩镇','118',2256),(30704,'升平镇','120',2256),(30705,'白鹿镇','121',2256),(30706,'葛仙山镇','123',2256),(30707,'致和镇','126',2256),(30708,'临邛镇','100',2257),(30709,'羊安镇','101',2257),(30710,'牟礼镇','102',2257),(30711,'桑园镇','103',2257),(30712,'平乐镇','104',2257),(30713,'夹关镇','105',2257),(30714,'火井镇','106',2257),(30715,'水口镇','107',2257),(30716,'固驿镇','108',2257),(30717,'冉义镇','109',2257),(30718,'回龙镇','110',2257),(30719,'高埂镇','111',2257),(30720,'前进镇','112',2257),(30721,'高何镇','113',2257),(30722,'临济镇','115',2257),(30723,'卧龙镇','116',2257),(30724,'天台山镇','118',2257),(30725,'宝林镇','120',2257),(30726,'茶园乡','201',2257),(30727,'道佐乡','206',2257),(30728,'油榨乡','209',2257),(30729,'南宝乡','211',2257),(30730,'大同乡','212',2257),(30731,'孔明乡','214',2257),(30732,'崇阳镇','100',2258),(30733,'三江镇','101',2258),(30734,'江源镇','102',2258),(30735,'羊马镇','103',2258),(30736,'廖家镇','104',2258),(30737,'元通镇','105',2258),(30738,'观胜镇','106',2258),(30739,'怀远镇','107',2258),(30740,'三郎镇','108',2258),(30741,'街子镇','109',2258),(30742,'文井江镇','110',2258),(30743,'王场镇','111',2258),(30744,'白头镇','112',2258),(30745,'道明镇','113',2258),(30746,'隆兴镇','114',2258),(30747,'大划镇','116',2258),(30748,'崇平镇','117',2258),(30749,'梓潼镇','118',2258),(30750,'桤泉镇','119',2258),(30751,'锦江乡','201',2258),(30752,'公议乡','202',2258),(30753,'鸡冠山乡','206',2258),(30754,'济协乡','208',2258),(30755,'燎原乡','209',2258),(30756,'集贤乡','211',2258),(30757,'五星街街道','001',2260),(30758,'东兴寺街道','002',2260),(30759,'新街街道','003',2260),(30760,'郭家坳街街道','004',2260),(30761,'丹桂街道','005',2260),(30762,'学苑街道','006',2260),(30763,'仲权镇','101',2260),(30764,'舒坪镇','102',2260),(30765,'荣边镇','103',2260),(30766,'红旗乡','201',2260),(30767,'高峰乡','202',2260),(30768,'农团乡','203',2260),(30769,'漆树乡','204',2260),(30770,'筱溪街道','001',2261),(30771,'贡井街道','002',2261),(30772,'艾叶镇','100',2261),(30773,'建设镇','101',2261),(30774,'长土镇','102',2261),(30775,'龙潭镇','104',2261),(30776,'桥头镇','105',2261),(30777,'五宝镇','106',2261),(30778,'莲花镇','107',2261),(30779,'成佳镇','108',2261),(30780,'白庙镇','109',2261),(30781,'章佳乡','200',2261),(30782,'牛尾乡','201',2261),(30783,'大安街道','001',2262),(30784,'龙井街道','002',2262),(30785,'马冲口街道','003',2262),(30786,'凉高山街道','004',2262),(30787,'大山铺镇','100',2262),(30788,'团结镇','102',2262),(30789,'三多寨镇','103',2262),(30790,'何市镇','104',2262),(30791,'新店镇','105',2262),(30792,'新民镇','106',2262),(30793,'牛佛镇','107',2262),(30794,'庙坝镇','108',2262),(30795,'回龙镇','109',2262),(30796,'永嘉乡','204',2262),(30797,'和平乡','205',2262),(30798,'凤凰乡','207',2262),(30799,'沿滩镇','100',2263),(30800,'卫坪镇','101',2263),(30801,'兴隆镇','102',2263),(30802,'富全镇','105',2263),(30803,'永安镇','106',2263),(30804,'联络镇','107',2263),(30805,'邓关镇','108',2263),(30806,'王井镇','109',2263),(30807,'黄市镇','110',2263),(30808,'瓦市镇','111',2263),(30809,'仙市镇','112',2263),(30810,'刘山乡','203',2263),(30811,'九洪乡','204',2263),(30812,'旭阳镇','100',2264),(30813,'双石镇','102',2264),(30814,'望佳镇','103',2264),(30815,'鼎新镇','107',2264),(30816,'乐德镇','110',2264),(30817,'过水镇','111',2264),(30818,'古文镇','112',2264),(30819,'河口镇','113',2264),(30820,'新桥镇','114',2264),(30821,'正紫镇','115',2264),(30822,'度佳镇','116',2264),(30823,'东佳镇','117',2264),(30824,'长山镇','118',2264),(30825,'保华镇','119',2264),(30826,'留佳镇','120',2264),(30827,'来牟镇','121',2264),(30828,'双古镇','122',2264),(30829,'观山镇','123',2264),(30830,'高山镇','124',2264),(30831,'东兴镇','125',2264),(30832,'铁厂镇','126',2264),(30833,'金花乡','202',2264),(30834,'雷音乡','203',2264),(30835,'古佳乡','204',2264),(30836,'于佳乡','205',2264),(30837,'复兴乡','206',2264),(30838,'墨林乡','207',2264),(30839,'富世镇','100',2265),(30840,'东湖镇','101',2265),(30841,'琵琶镇','102',2265),(30842,'狮市镇','103',2265),(30843,'骑龙镇','104',2265),(30844,'互助镇','107',2265),(30845,'代寺镇','111',2265),(30846,'中石镇','112',2265),(30847,'童寺镇','113',2265),(30848,'古佛镇','114',2265),(30849,'永年镇','115',2265),(30850,'彭庙镇','116',2265),(30851,'兜山镇','117',2265),(30852,'板桥镇','118',2265),(30853,'福善镇','119',2265),(30854,'李桥镇','120',2265),(30855,'赵化镇','121',2265),(30856,'安溪镇','122',2265),(30857,'万寿镇','123',2265),(30858,'飞龙镇','124',2265),(30859,'怀德镇','125',2265),(30860,'长滩镇','126',2265),(30861,'龙万乡','200',2265),(30862,'宝庆乡','201',2265),(30863,'富和乡','202',2265),(30864,'石道乡','203',2265),(30865,'大渡口街道办事处','001',2267),(30866,'炳草岗街道办事处','002',2267),(30867,'南山街道办事处','003',2267),(30868,'向阳村街道办事处','004',2267),(30869,'弄弄坪街道办事处','005',2267),(30870,'枣子坪街道办事处','006',2267),(30871,'长寿路街道办事处','007',2267),(30872,'密地街道办事处','008',2267),(30873,'瓜子坪街道办事处','009',2267),(30874,'银江镇','100',2267),(30875,'清香坪街道办事处','001',2268),(30876,'玉泉街道办事处','002',2268),(30877,'河门口街道办事处','003',2268),(30878,'陶家渡街道办事处','004',2268),(30879,'摩梭河街道办事处','005',2268),(30880,'大宝鼎街道办事处','006',2268),(30881,'格里坪镇','100',2268),(30882,'大河中路街道办事处','001',2269),(30883,'仁和镇','100',2269),(30884,'平地镇','101',2269),(30885,'大田镇','102',2269),(30886,'福田镇','103',2269),(30887,'同德镇','104',2269),(30888,'金江镇','105',2269),(30889,'布德镇','106',2269),(30890,'前进镇','107',2269),(30891,'大龙潭彝族乡','200',2269),(30892,'啊喇彝族乡','201',2269),(30893,'总发乡','202',2269),(30894,'太平乡','203',2269),(30895,'务本乡','204',2269),(30896,'中坝乡','205',2269),(30897,'攀莲镇','100',2270),(30898,'丙谷镇','101',2270),(30899,'得石镇','102',2270),(30900,'撒莲镇','103',2270),(30901,'垭口镇','104',2270),(30902,'白马镇','105',2270),(30903,'普威镇','106',2270),(30904,'草场乡','200',2270),(30905,'湾丘彝族乡','201',2270),(30906,'白坡彝族乡','202',2270),(30907,'麻陇彝族乡','203',2270),(30908,'新山傈僳族乡','204',2270),(30909,'攀钢集团湾丘基地','400',2270),(30910,'桐子林镇','100',2271),(30911,'红格镇','101',2271),(30912,'渔门镇','102',2271),(30913,'永兴镇','103',2271),(30914,'益民乡','200',2271),(30915,'新九乡','201',2271),(30916,'和爱彝族乡','202',2271),(30917,'红果彝族乡','203',2271),(30918,'共和乡','205',2271),(30919,'国胜乡','206',2271),(30920,'红宝苗族乡','207',2271),(30921,'惠民乡','208',2271),(30922,'箐河彝族乡','209',2271),(30923,'温泉彝族乡','210',2271),(30924,'格萨拉彝族乡','211',2271),(30925,'南城街道','001',2273),(30926,'北城街道','002',2273),(30927,'大山坪街道','003',2273),(30928,'邻玉街道办事处','004',2273),(30929,'蓝田街道办事处','005',2273),(30930,'茜草街道办事处','006',2273),(30931,'华阳街道办事处','007',2273),(30932,'泰安镇','102',2273),(30933,'黄舣镇','103',2273),(30934,'弥陀镇','104',2273),(30935,'况场镇','105',2273),(30936,'通滩镇','106',2273),(30937,'江北镇','107',2273),(30938,'方山镇','108',2273),(30939,'丹林乡','200',2273),(30940,'分水岭乡','202',2273),(30941,'石寨乡','203',2273),(30942,'安富街道','001',2274),(30943,'永宁街道','002',2274),(30944,'大渡口镇','100',2274),(30945,'护国镇','101',2274),(30946,'打古镇','102',2274),(30947,'上马镇','103',2274),(30948,'合面镇','104',2274),(30949,'新乐镇','105',2274),(30950,'丰乐镇','106',2274),(30951,'白节镇','107',2274),(30952,'天仙镇','108',2274),(30953,'渠坝镇','109',2274),(30954,'龙车镇','110',2274),(30955,'棉花坡镇','111',2274),(30956,'小市街道办事处','001',2275),(30957,'高坝街道办事处','002',2275),(30958,'红星街道办事处','003',2275),(30959,'莲花池街道办事处','004',2275),(30960,'罗汉镇','100',2275),(30961,'鱼塘镇','101',2275),(30962,'石洞镇','102',2275),(30963,'胡市镇','103',2275),(30964,'特兴镇','104',2275),(30965,'安宁镇','105',2275),(30966,'双加镇','106',2275),(30967,'金龙乡','200',2275),(30968,'长安乡','201',2275),(30969,'福集镇','100',2276),(30970,'嘉明镇','101',2276),(30971,'喻寺镇','102',2276),(30972,'得胜镇','103',2276),(30973,'牛滩镇','105',2276),(30974,'兆雅镇','106',2276),(30975,'玄滩镇','107',2276),(30976,'太伏镇','108',2276),(30977,'云龙镇','109',2276),(30978,'石桥镇','110',2276),(30979,'毗卢镇','111',2276),(30980,'奇峰镇','112',2276),(30981,'潮河镇','113',2276),(30982,'云锦镇','114',2276),(30983,'立石镇','115',2276),(30984,'百和镇','116',2276),(30985,'天兴镇','117',2276),(30986,'方洞镇','118',2276),(30987,'海潮镇','123',2276),(30988,'合江镇','100',2277),(30989,'望龙镇','101',2277),(30990,'白沙镇','102',2277),(30991,'佛荫镇','103',2277),(30992,'先市镇','104',2277),(30993,'尧坝镇','105',2277),(30994,'九支镇','106',2277),(30995,'五通镇','107',2277),(30996,'凤鸣镇','108',2277),(30997,'榕山镇','109',2277),(30998,'白鹿镇','110',2277),(30999,'甘雨镇','111',2277),(31000,'福宝镇','112',2277),(31001,'先滩镇','113',2277),(31002,'自怀镇','114',2277),(31003,'大桥镇','115',2277),(31004,'车辋镇','116',2277),(31005,'密溪乡','200',2277),(31006,'白米乡','201',2277),(31007,'焦滩乡','202',2277),(31008,'参宝乡','203',2277),(31009,'二里乡','206',2277),(31010,'实录乡','208',2277),(31011,'虎头乡','209',2277),(31012,'榕右乡','210',2277),(31013,'南滩乡','212',2277),(31014,'石龙乡','213',2277),(31015,'叙永镇','100',2278),(31016,'江门镇','101',2278),(31017,'马岭镇','102',2278),(31018,'天池镇','103',2278),(31019,'水尾镇','104',2278),(31020,'两河镇','105',2278),(31021,'落卜镇','106',2278),(31022,'后山镇','107',2278),(31023,'分水镇','108',2278),(31024,'摩尼镇','109',2278),(31025,'赤水镇','110',2278),(31026,'向林乡','200',2278),(31027,'大石乡','201',2278),(31028,'兴隆乡','202',2278),(31029,'龙凤乡','203',2278),(31030,'正东乡','204',2278),(31031,'黄坭乡','206',2278),(31032,'营山乡','207',2278),(31033,'麻城乡','208',2278),(31034,'观兴乡','209',2278),(31035,'合乐乡','210',2278),(31036,'白腊乡','211',2278),(31037,'枧槽乡','212',2278),(31038,'水潦乡','213',2278),(31039,'石坝乡','214',2278),(31040,'三八菜蔬场','400',2278),(31041,'红星菜蔬场','401',2278),(31042,'叙永农场','402',2278),(31043,'古蔺镇','100',2279),(31044,'龙山镇','101',2279),(31045,'永乐镇','102',2279),(31046,'太平镇','103',2279),(31047,'二郎镇','104',2279),(31048,'大村镇','105',2279),(31049,'石宝镇','106',2279),(31050,'丹桂镇','107',2279),(31051,'水口镇','108',2279),(31052,'观文镇','109',2279),(31053,'双沙镇','110',2279),(31054,'德跃镇','111',2279),(31055,'护家乡','201',2279),(31056,'鱼化乡','202',2279),(31057,'石屏乡','203',2279),(31058,'东新乡','204',2279),(31059,'土城乡','205',2279),(31060,'金星乡','206',2279),(31061,'白泥乡','207',2279),(31062,'椒园乡','208',2279),(31063,'马嘶苗族乡','209',2279),(31064,'马蹄乡','211',2279),(31065,'箭竹苗族乡','212',2279),(31066,'大寨苗族乡','214',2279),(31067,'桂花乡','215',2279),(31068,'黄荆乡','216',2279),(31069,'旌阳街道','001',2281),(31070,'城南街道','002',2281),(31071,'城北街道','003',2281),(31072,'旌东街道','004',2281),(31073,'工农街道','005',2281),(31074,'黄许镇','100',2281),(31075,'孝泉镇','101',2281),(31076,'八角井镇','102',2281),(31077,'柏隆镇','103',2281),(31078,'孝感镇','104',2281),(31079,'天元镇','105',2281),(31080,'扬嘉镇','107',2281),(31081,'德新镇','108',2281),(31082,'双东镇','110',2281),(31083,'新中镇','111',2281),(31084,'和新镇','117',2281),(31085,'东湖乡','201',2281),(31086,'凯江镇','100',2282),(31087,'南华镇','101',2282),(31088,'回龙镇','102',2282),(31089,'通济镇','103',2282),(31090,'永太镇','104',2282),(31091,'黄鹿镇','105',2282),(31092,'集凤镇','106',2282),(31093,'富兴镇','107',2282),(31094,'辑庆镇','108',2282),(31095,'兴隆镇','109',2282),(31096,'龙台镇','110',2282),(31097,'永安镇','111',2282),(31098,'双龙镇','112',2282),(31099,'玉兴镇','113',2282),(31100,'永兴镇','114',2282),(31101,'悦来镇','115',2282),(31102,'继光镇','116',2282),(31103,'仓山镇','117',2282),(31104,'广福镇','118',2282),(31105,'会龙镇','119',2282),(31106,'万福镇','120',2282),(31107,'普兴镇','121',2282),(31108,'联合镇','122',2282),(31109,'冯店镇','123',2282),(31110,'积金镇','124',2282),(31111,'太安镇','125',2282),(31112,'杰兴镇','127',2282),(31113,'南山镇','130',2282),(31114,'东北镇','132',2282),(31115,'古店乡','200',2282),(31116,'青市乡','201',2282),(31117,'瓦店乡','203',2282),(31118,'石泉乡','204',2282),(31119,'柏树乡','206',2282),(31120,'白果乡','207',2282),(31121,'清河乡','208',2282),(31122,'高店乡','209',2282),(31123,'石笋乡','210',2282),(31124,'太平乡','211',2282),(31125,'民主乡','212',2282),(31126,'永丰乡','214',2282),(31127,'元兴乡','216',2282),(31128,'通山乡','218',2282),(31129,'石龙乡','219',2282),(31130,'合兴乡','221',2282),(31131,'万安镇','100',2283),(31132,'鄢家镇','101',2283),(31133,'金山镇','102',2283),(31134,'略坪镇','103',2283),(31135,'御营镇','104',2283),(31136,'慧觉镇','105',2283),(31137,'调元镇','106',2283),(31138,'新盛镇','107',2283),(31139,'蟠龙镇','108',2283),(31140,'白马关镇','113',2283),(31141,'雒城镇','100',2284),(31142,'三水镇','101',2284),(31143,'连山镇','102',2284),(31144,'高坪镇','103',2284),(31145,'南兴镇','104',2284),(31146,'向阳镇','105',2284),(31147,'小汉镇','106',2284),(31148,'金轮镇','107',2284),(31149,'新丰镇','108',2284),(31150,'兴隆镇','109',2284),(31151,'新华镇','110',2284),(31152,'和兴镇','112',2284),(31153,'松林镇','113',2284),(31154,'金鱼镇','114',2284),(31155,'新平镇','115',2284),(31156,'南丰镇','116',2284),(31157,'西高镇','119',2284),(31158,'北外乡','200',2284),(31159,'西外乡','202',2284),(31160,'方亭街道办事处','001',2285),(31161,'皂角街道办事处','002',2285),(31162,'元石镇','101',2285),(31163,'洄澜镇','103',2285),(31164,'洛水镇','105',2285),(31165,'禾丰镇','106',2285),(31166,'双盛镇','107',2285),(31167,'马祖镇','108',2285),(31168,'隐丰镇','109',2285),(31169,'马井镇','110',2285),(31170,'蓥华镇','111',2285),(31171,'南泉镇','113',2285),(31172,'湔氐镇','116',2285),(31173,'红白镇','118',2285),(31174,'八角镇','119',2285),(31175,'师古镇','120',2285),(31176,'剑南镇','100',2286),(31177,'东北镇','101',2286),(31178,'西南镇','102',2286),(31179,'兴隆镇','103',2286),(31180,'九龙镇','104',2286),(31181,'遵道镇','105',2286),(31182,'汉旺镇','106',2286),(31183,'拱星镇','108',2286),(31184,'土门镇','109',2286),(31185,'广济镇','110',2286),(31186,'金花镇','111',2286),(31187,'玉泉镇','112',2286),(31188,'板桥镇','113',2286),(31189,'新市镇','115',2286),(31190,'孝德镇','116',2286),(31191,'富新镇','119',2286),(31192,'齐天镇','121',2286),(31193,'什地镇','122',2286),(31194,'绵远镇','123',2286),(31195,'清平乡','200',2286),(31196,'天池乡','201',2286),(31197,'城厢街道','001',2288),(31198,'城北街道','002',2288),(31199,'工区街道','003',2288),(31200,'南山街道','004',2288),(31201,'朝阳街道','005',2288),(31202,'高新街道','006',2288),(31203,'城南街道','007',2288),(31204,'创业园街道','009',2288),(31205,'塘讯街道','010',2288),(31206,'丰谷镇','100',2288),(31207,'关帝镇','101',2288),(31208,'青义镇','103',2288),(31209,'龙门镇','104',2288),(31210,'石塘镇','105',2288),(31211,'吴家镇','106',2288),(31212,'杨家镇','107',2288),(31213,'金峰镇','108',2288),(31214,'玉皇镇','109',2288),(31215,'新皂镇','110',2288),(31216,'河边镇','111',2288),(31217,'磨家镇','112',2288),(31218,'永兴镇','113',2288),(31219,'城郊乡','200',2288),(31220,'石洞乡','201',2288),(31221,'涪江街道','001',2289),(31222,'科学城街道办事处','002',2289),(31223,'富乐街道办事处','003',2289),(31224,'游仙镇','100',2289),(31225,'石马镇','101',2289),(31226,'新桥镇','102',2289),(31227,'小枧沟镇','103',2289),(31228,'魏城镇','104',2289),(31229,'沉抗镇','105',2289),(31230,'忠兴镇','106',2289),(31231,'柏林镇','107',2289),(31232,'徐家镇','108',2289),(31233,'石板镇','109',2289),(31234,'刘家镇','110',2289),(31235,'玉河镇','111',2289),(31236,'松垭镇','112',2289),(31237,'白蝉乡','200',2289),(31238,'观太乡','201',2289),(31239,'建华乡','202',2289),(31240,'云凤乡','203',2289),(31241,'东林乡','204',2289),(31242,'太平乡','205',2289),(31243,'梓棉乡','206',2289),(31244,'朝真乡','207',2289),(31245,'东宣乡','208',2289),(31246,'街子乡','209',2289),(31247,'凤凰乡','210',2289),(31248,'四川省新华劳动教育管理所','400',2289),(31249,'北坝镇','100',2290),(31250,'潼川镇','101',2290),(31251,'东塔镇','102',2290),(31252,'百顷镇','103',2290),(31253,'塔山镇','104',2290),(31254,'柳池镇','105',2290),(31255,'龙树镇','106',2290),(31256,'石安镇','107',2290),(31257,'富顺镇','108',2290),(31258,'三元镇','109',2290),(31259,'秋林镇','110',2290),(31260,'永新镇','111',2290),(31261,'新德镇','112',2290),(31262,'新生镇','113',2290),(31263,'鲁班镇','114',2290),(31264,'景福镇','115',2290),(31265,'紫河镇','116',2290),(31266,'安居镇','117',2290),(31267,'观桥镇','118',2290),(31268,'嘀江镇','119',2290),(31269,'中新镇','120',2290),(31270,'古井镇','121',2290),(31271,'万安镇','122',2290),(31272,'西平镇','123',2290),(31273,'八洞镇','124',2290),(31274,'凯河镇','125',2290),(31275,'乐安镇','126',2290),(31276,'建平镇','127',2290),(31277,'前锋镇','128',2290),(31278,'建设镇','129',2290),(31279,'光辉镇','130',2290),(31280,'中太镇','131',2290),(31281,'金石镇','132',2290),(31282,'新鲁镇','133',2290),(31283,'黎曙镇','134',2290),(31284,'刘营镇','135',2290),(31285,'灵兴镇','136',2290),(31286,'芦溪镇','137',2290),(31287,'立新镇','138',2290),(31288,'花园镇','139',2290),(31289,'永明镇','140',2290),(31290,'高堰乡','200',2290),(31291,'忠孝乡','201',2290),(31292,'双胜乡','202',2290),(31293,'金鼓乡','203',2290),(31294,'断石乡','204',2290),(31295,'玉林乡','205',2290),(31296,'乐加乡','206',2290),(31297,'曙光乡','207',2290),(31298,'建中乡','208',2290),(31299,'宝泉乡','209',2290),(31300,'广利乡','210',2290),(31301,'协和乡','211',2290),(31302,'双乐乡','212',2290),(31303,'菊河乡','213',2290),(31304,'幸福乡','214',2290),(31305,'下新乡','215',2290),(31306,'进都乡','216',2290),(31307,'上新乡','217',2290),(31308,'老马乡','218',2290),(31309,'里程乡','219',2290),(31310,'争胜乡','220',2290),(31311,'云同乡','221',2290),(31312,'云溪镇','100',2291),(31313,'玉龙镇','101',2291),(31314,'富驿镇','102',2291),(31315,'金孔镇','103',2291),(31316,'两河镇','104',2291),(31317,'黄甸镇','105',2291),(31318,'柏梓镇','106',2291),(31319,'八角镇','107',2291),(31320,'黑坪镇','108',2291),(31321,'高灯镇','109',2291),(31322,'金鸡镇','110',2291),(31323,'安家镇','111',2291),(31324,'林农镇','112',2291),(31325,'巨龙镇','113',2291),(31326,'龙泉乡','200',2291),(31327,'折弓乡','201',2291),(31328,'麻秧乡','202',2291),(31329,'三元乡','203',2291),(31330,'五龙乡','204',2291),(31331,'茶亭乡','205',2291),(31332,'金安乡','206',2291),(31333,'洗泽乡','207',2291),(31334,'毛公乡','208',2291),(31335,'冯河乡','209',2291),(31336,'石牛庙乡','210',2291),(31337,'大兴回族乡','211',2291),(31338,'宗海乡','212',2291),(31339,'两岔河乡','213',2291),(31340,'剑河乡','214',2291),(31341,'来龙乡','215',2291),(31342,'永泰乡','216',2291),(31343,'黄溪乡','217',2291),(31344,'榉溪乡','218',2291),(31345,'双碑乡','219',2291),(31346,'林山乡','220',2291),(31347,'新农乡','221',2291),(31348,'安昌镇','100',2292),(31349,'桑枣镇','101',2292),(31350,'花悄镇','102',2292),(31351,'黄土镇','103',2292),(31352,'塔水镇','104',2292),(31353,'秀水镇','105',2292),(31354,'河清镇','106',2292),(31355,'永安镇','107',2292),(31356,'界牌镇','108',2292),(31357,'永河镇','109',2292),(31358,'雎水镇','110',2292),(31359,'清泉镇','111',2292),(31360,'宝林镇','112',2292),(31361,'沸水镇','113',2292),(31362,'晓坝镇','114',2292),(31363,'乐兴镇','115',2292),(31364,'茶坪乡','200',2292),(31365,'兴仁乡','201',2292),(31366,'高川乡','202',2292),(31367,'迎新乡','203',2292),(31368,'文昌镇','100',2293),(31369,'长卿镇','101',2293),(31370,'许州镇','102',2293),(31371,'黎雅镇','103',2293),(31372,'白云镇','104',2293),(31373,'卧龙镇','105',2293),(31374,'观义镇','106',2293),(31375,'玛瑙镇','107',2293),(31376,'石牛镇','108',2293),(31377,'自强镇','109',2293),(31378,'仁和镇','110',2293),(31379,'东石乡','200',2293),(31380,'三泉乡','201',2293),(31381,'宏仁乡','202',2293),(31382,'小垭乡','203',2293),(31383,'演武乡','204',2293),(31384,'仙峰乡','205',2293),(31385,'双板乡','206',2293),(31386,'豢龙乡','207',2293),(31387,'双峰乡','208',2293),(31388,'交泰乡','209',2293),(31389,'金龙场乡','210',2293),(31390,'石台乡','211',2293),(31391,'仙鹅乡','212',2293),(31392,'马鸣乡','213',2293),(31393,'马迎乡','214',2293),(31394,'二洞乡','215',2293),(31395,'建兴乡','216',2293),(31396,'宝石乡','217',2293),(31397,'定远乡','218',2293),(31398,'大新乡','219',2293),(31399,'文兴乡','220',2293),(31400,'曲山镇','100',2294),(31401,'擂鼓镇','101',2294),(31402,'通口镇','102',2294),(31403,'香泉乡','200',2294),(31404,'陈家坝乡','201',2294),(31405,'桂溪乡','202',2294),(31406,'贯岭乡','203',2294),(31407,'禹里乡','204',2294),(31408,'漩坪乡','205',2294),(31409,'白坭乡','206',2294),(31410,'小坝乡','207',2294),(31411,'片口乡','208',2294),(31412,'开坪乡','209',2294),(31413,'坝底乡','210',2294),(31414,'白什乡','211',2294),(31415,'青片乡','212',2294),(31416,'都坝乡','213',2294),(31417,'桃龙藏族乡','214',2294),(31418,'墩上乡','215',2294),(31419,'马槽乡','216',2294),(31420,'龙安镇','100',2295),(31421,'古城镇','101',2295),(31422,'南坝镇','102',2295),(31423,'响岩镇','103',2295),(31424,'平通镇','104',2295),(31425,'豆叩镇','105',2295),(31426,'大印镇','106',2295),(31427,'大桥镇','107',2295),(31428,'水晶镇','108',2295),(31429,'高村乡','200',2295),(31430,'水田乡','201',2295),(31431,'坝子乡','202',2295),(31432,'水观乡','203',2295),(31433,'平南羌族乡','204',2295),(31434,'徐塘羌族乡','205',2295),(31435,'锁江羌族乡','206',2295),(31436,'土城乡','207',2295),(31437,'旧堡乡','208',2295),(31438,'阔达乡','209',2295),(31439,'黄羊关藏族乡','210',2295),(31440,'虎牙藏族乡','211',2295),(31441,'泗耳藏族乡','212',2295),(31442,'白马藏族乡','213',2295),(31443,'木座藏族乡','214',2295),(31444,'木皮藏族乡','215',2295),(31445,'长钢街道','001',2296),(31446,'武都长钢街道','002',2296),(31447,'含增长钢街道办事处','003',2296),(31448,'华坪办事处','004',2296),(31449,'中坝镇','100',2296),(31450,'太平镇','101',2296),(31451,'三合镇','102',2296),(31452,'含增镇','103',2296),(31453,'青莲镇','104',2296),(31454,'彰明镇','105',2296),(31455,'龙凤镇','106',2296),(31456,'武都镇','107',2296),(31457,'大康镇','108',2296),(31458,'新安镇','109',2296),(31459,'战旗镇','110',2296),(31460,'双河镇','111',2296),(31461,'永胜镇','112',2296),(31462,'小溪坝镇','113',2296),(31463,'河口镇','114',2296),(31464,'重华镇','115',2296),(31465,'厚坝镇','116',2296),(31466,'二郎庙镇','117',2296),(31467,'马角镇','118',2296),(31468,'雁门镇','119',2296),(31469,'九岭镇','120',2296),(31470,'八一乡','200',2296),(31471,'方水乡','201',2296),(31472,'西屏乡','202',2296),(31473,'香水乡','203',2296),(31474,'大堰乡','204',2296),(31475,'东兴乡','205',2296),(31476,'义新乡','207',2296),(31477,'贯山乡','208',2296),(31478,'新兴乡','209',2296),(31479,'新春乡','210',2296),(31480,'东安乡','211',2296),(31481,'铜星乡','212',2296),(31482,'文胜乡','213',2296),(31483,'重兴乡','214',2296),(31484,'云集乡','215',2296),(31485,'石元乡','216',2296),(31486,'敬元乡','217',2296),(31487,'六合乡','218',2296),(31488,'枫顺乡','219',2296),(31489,'东坝街道办事处','001',2298),(31490,'嘉陵街道办事处','002',2298),(31491,'河西街道办事处','003',2298),(31492,'荣山镇','100',2298),(31493,'大石镇','101',2298),(31494,'盘龙镇','102',2298),(31495,'宝轮镇','103',2298),(31496,'赤化镇','104',2298),(31497,'三堆镇','105',2298),(31498,'工农镇','106',2298),(31499,'白朝乡','200',2298),(31500,'金洞乡','201',2298),(31501,'龙潭乡','202',2298),(31502,'雪峰办事处','400',2298),(31503,'南河办事处','401',2298),(31504,'回龙河办事处','402',2298),(31505,'上西办事处','404',2298),(31506,'袁家坝办事处','405',2298),(31507,'杨家岩办事处','406',2298),(31508,'下西街道办事处','407',2298),(31509,'元坝镇','100',2299),(31510,'卫子镇','101',2299),(31511,'王家镇','102',2299),(31512,'磨滩镇','103',2299),(31513,'柏林沟镇','104',2299),(31514,'太公镇','105',2299),(31515,'虎跳镇','106',2299),(31516,'红岩镇','107',2299),(31517,'昭化镇','108',2299),(31518,'晋贤乡','200',2299),(31519,'文村乡','201',2299),(31520,'清水乡','202',2299),(31521,'张家乡','203',2299),(31522,'香溪乡','204',2299),(31523,'青牛乡','205',2299),(31524,'陈江乡','206',2299),(31525,'丁家乡','207',2299),(31526,'黄龙乡','208',2299),(31527,'石井铺乡','209',2299),(31528,'白果乡','210',2299),(31529,'梅树乡','211',2299),(31530,'明觉乡','212',2299),(31531,'射箭乡','213',2299),(31532,'朝阳乡','214',2299),(31533,'大朝乡','215',2299),(31534,'沙坝乡','216',2299),(31535,'柳桥乡','217',2299),(31536,'紫云乡','218',2299),(31537,'拣银岩社区街道办事处','400',2299),(31538,'朝天镇','100',2300),(31539,'大滩镇','101',2300),(31540,'羊木镇','102',2300),(31541,'曾家镇','103',2300),(31542,'中子镇','104',2300),(31543,'沙河镇','105',2300),(31544,'陈家乡','200',2300),(31545,'小安乡','201',2300),(31546,'鱼洞乡','202',2300),(31547,'东溪河乡','203',2300),(31548,'花石乡','204',2300),(31549,'蒲家乡','205',2300),(31550,'西北乡','206',2300),(31551,'宣河乡','207',2300),(31552,'转斗乡','208',2300),(31553,'青林乡','209',2300),(31554,'平溪乡','210',2300),(31555,'两河口乡','211',2300),(31556,'李家乡','212',2300),(31557,'汪家乡','213',2300),(31558,'麻柳乡','214',2300),(31559,'临溪乡','215',2300),(31560,'文安乡','216',2300),(31561,'马家坝乡','217',2300),(31562,'柏杨乡','218',2300),(31563,'东河镇','100',2301),(31564,'嘉川镇','101',2301),(31565,'木门镇','102',2301),(31566,'白水镇','103',2301),(31567,'尚武镇','104',2301),(31568,'张华镇','105',2301),(31569,'黄洋镇','106',2301),(31570,'普济镇','107',2301),(31571,'三江镇','108',2301),(31572,'金溪镇','109',2301),(31573,'五权镇','110',2301),(31574,'高阳镇','111',2301),(31575,'双汇镇','112',2301),(31576,'英萃镇','113',2301),(31577,'国华镇','114',2301),(31578,'龙凤乡','200',2301),(31579,'大河乡','201',2301),(31580,'九龙乡','202',2301),(31581,'万家乡','203',2301),(31582,'燕子乡','204',2301),(31583,'水磨乡','205',2301),(31584,'鼓城乡','206',2301),(31585,'檬子乡','207',2301),(31586,'福庆乡','208',2301),(31587,'枣林乡','209',2301),(31588,'麻英乡','210',2301),(31589,'柳溪乡','211',2301),(31590,'农建乡','212',2301),(31591,'化龙乡','213',2301),(31592,'大两乡','214',2301),(31593,'万山乡','215',2301),(31594,'正源乡','216',2301),(31595,'天星乡','217',2301),(31596,'盐河乡','218',2301),(31597,'大德乡','219',2301),(31598,'静乐寺社区街道办事处','400',2301),(31599,'陈家岭社区街道办事处','401',2301),(31600,'磨岩社区街道办事处','402',2301),(31601,'乔庄镇','100',2302),(31602,'青溪镇','101',2302),(31603,'房石镇','102',2302),(31604,'关庄镇','103',2302),(31605,'凉水镇','104',2302),(31606,'竹园镇','105',2302),(31607,'木鱼镇','106',2302),(31608,'沙州镇','107',2302),(31609,'姚渡镇','108',2302),(31610,'黄坪乡','200',2302),(31611,'瓦砾乡','201',2302),(31612,'孔溪乡','202',2302),(31613,'茶坝乡','203',2302),(31614,'大坝乡','204',2302),(31615,'桥楼乡','205',2302),(31616,'三锅乡','206',2302),(31617,'蒿溪回族乡','207',2302),(31618,'乐安寺乡','208',2302),(31619,'前进乡','209',2302),(31620,'曲河乡','210',2302),(31621,'马公乡','211',2302),(31622,'石坝乡','212',2302),(31623,'红光乡','213',2302),(31624,'苏河乡','214',2302),(31625,'茅坝乡','215',2302),(31626,'大院回族乡','216',2302),(31627,'楼子乡','217',2302),(31628,'金子山乡','218',2302),(31629,'马鹿乡','219',2302),(31630,'七佛乡','220',2302),(31631,'建峰乡','221',2302),(31632,'白家乡','222',2302),(31633,'板桥乡','223',2302),(31634,'骑马乡','224',2302),(31635,'观音店乡','225',2302),(31636,'营盘乡','227',2302),(31637,'唐家河国家级自然保护区','400',2302),(31638,'普安镇','100',2303),(31639,'龙源镇','101',2303),(31640,'城北镇','102',2303),(31641,'盐店镇','103',2303),(31642,'柳沟镇','104',2303),(31643,'武连镇','105',2303),(31644,'东宝镇','106',2303),(31645,'开封镇','107',2303),(31646,'元山镇','108',2303),(31647,'演圣镇','109',2303),(31648,'王河镇','110',2303),(31649,'公兴镇','111',2303),(31650,'金仙镇','112',2303),(31651,'香沉镇','113',2303),(31652,'白龙镇','114',2303),(31653,'鹤龄镇','115',2303),(31654,'杨村镇','116',2303),(31655,'羊岭镇','117',2303),(31656,'江口镇','118',2303),(31657,'木马镇','119',2303),(31658,'剑门关镇','120',2303),(31659,'汉阳镇','121',2303),(31660,'下寺镇','122',2303),(31661,'江石乡','200',2303),(31662,'田家乡','201',2303),(31663,'闻溪乡','202',2303),(31664,'姚家乡','203',2303),(31665,'北庙乡','204',2303),(31666,'西庙乡','205',2303),(31667,'义兴乡','206',2303),(31668,'毛坝乡','207',2303),(31669,'凉山乡','208',2303),(31670,'垂泉乡','209',2303),(31671,'秀钟乡','210',2303),(31672,'正兴乡','211',2303),(31673,'马灯乡','212',2303),(31674,'高池乡','213',2303),(31675,'碗泉乡','214',2303),(31676,'迎水乡','215',2303),(31677,'国光乡','216',2303),(31678,'柘坝乡','217',2303),(31679,'公店乡','218',2303),(31680,'吼狮乡','219',2303),(31681,'长岭乡','220',2303),(31682,'涂山乡','221',2303),(31683,'圈龙乡','222',2303),(31684,'碑垭乡','223',2303),(31685,'广坪乡','224',2303),(31686,'禾丰乡','225',2303),(31687,'店子乡','226',2303),(31688,'摇铃乡','227',2303),(31689,'樵店乡','228',2303),(31690,'锦屏乡','229',2303),(31691,'柏垭乡','230',2303),(31692,'高观乡','231',2303),(31693,'张王乡','232',2303),(31694,'上寺乡','233',2303),(31695,'陵江镇','100',2304),(31696,'云峰镇','102',2304),(31697,'东青镇','104',2304),(31698,'白桥镇','105',2304),(31699,'八庙镇','106',2304),(31700,'五龙镇','107',2304),(31701,'永宁镇','108',2304),(31702,'鸳溪镇','109',2304),(31703,'三川镇','110',2304),(31704,'龙王镇','111',2304),(31705,'元坝镇','112',2304),(31706,'唤马镇','113',2304),(31707,'歧坪镇','114',2304),(31708,'白驿镇','115',2304),(31709,'漓江镇','116',2304),(31710,'文昌镇','117',2304),(31711,'岳东镇','118',2304),(31712,'石马镇','119',2304),(31713,'运山镇','120',2304),(31714,'东溪镇','121',2304),(31715,'高坡镇','122',2304),(31716,'龙山镇','123',2304),(31717,'禅林乡','202',2304),(31718,'亭子乡','204',2304),(31719,'白鹤乡','208',2304),(31720,'浙水乡','209',2304),(31721,'雍河乡','210',2304),(31722,'新观乡','212',2304),(31723,'中土乡','214',2304),(31724,'石门乡','216',2304),(31725,'月山乡','223',2304),(31726,'白山乡','226',2304),(31727,'彭店乡','228',2304),(31728,'桥溪乡','229',2304),(31729,'龙洞乡','232',2304),(31730,'黄猫乡','233',2304),(31731,'石灶乡','234',2304),(31732,'河地乡','238',2304),(31733,'双河乡','240',2304),(31734,'九龙山农场','400',2304),(31735,'三溪口林场','401',2304),(31736,'南津路街道','001',2306),(31737,'凯旋路街道','002',2306),(31738,'高升街街道','003',2306),(31739,'镇江寺街道','004',2306),(31740,'育才路街道','005',2306),(31741,'介福路街道','006',2306),(31742,'嘉禾街道','007',2306),(31743,'广德寺街道','008',2306),(31744,'富源路街道','009',2306),(31745,'龙坪街道','010',2306),(31746,'灵泉寺街道','011',2306),(31747,'慈音街道','012',2306),(31748,'九莲街道','013',2306),(31749,'南强镇','100',2306),(31750,'仁里镇','101',2306),(31751,'复桥镇','102',2306),(31752,'永兴镇','103',2306),(31753,'河沙镇','104',2306),(31754,'新桥镇','105',2306),(31755,'桂花镇','106',2306),(31756,'西宁乡','200',2306),(31757,'老池乡','201',2306),(31758,'保升乡','202',2306),(31759,'唐家乡','203',2306),(31760,'北固乡','204',2306),(31761,'安居镇','100',2307),(31762,'东禅镇','101',2307),(31763,'分水镇','102',2307),(31764,'石洞镇','103',2307),(31765,'拦江镇','104',2307),(31766,'保石镇','105',2307),(31767,'白马镇','106',2307),(31768,'中兴镇','107',2307),(31769,'横山镇','108',2307),(31770,'会龙镇','109',2307),(31771,'三家镇','110',2307),(31772,'玉丰镇','111',2307),(31773,'西眉镇','112',2307),(31774,'磨溪镇','113',2307),(31775,'聚贤乡','200',2307),(31776,'莲花乡','201',2307),(31777,'观音乡','202',2307),(31778,'步云乡','203',2307),(31779,'常理乡','204',2307),(31780,'大安乡','205',2307),(31781,'马家乡','206',2307),(31782,'赤城镇','100',2308),(31783,'新会镇','101',2308),(31784,'文井镇','102',2308),(31785,'明月镇','103',2308),(31786,'常乐镇','104',2308),(31787,'天福镇','105',2308),(31788,'红江镇','106',2308),(31789,'宝梵镇','107',2308),(31790,'大石镇','108',2308),(31791,'吉祥镇','109',2308),(31792,'鸣凤镇','110',2308),(31793,'任隆镇','111',2308),(31794,'三凤镇','112',2308),(31795,'高坪镇','113',2308),(31796,'蓬南镇','114',2308),(31797,'群利镇','115',2308),(31798,'下东乡','200',2308),(31799,'新星乡','201',2308),(31800,'罗戈乡','202',2308),(31801,'板桥乡','203',2308),(31802,'槐花乡','204',2308),(31803,'吉星乡','205',2308),(31804,'黄泥乡','206',2308),(31805,'荷叶乡','207',2308),(31806,'金龙乡','208',2308),(31807,'农兴乡','209',2308),(31808,'新胜乡','210',2308),(31809,'回水乡','211',2308),(31810,'群力乡','212',2308),(31811,'高升乡','213',2308),(31812,'金桥乡','214',2308),(31813,'太和镇','100',2309),(31814,'大榆镇','101',2309),(31815,'广兴镇','102',2309),(31816,'金华镇','103',2309),(31817,'柳树镇','104',2309),(31818,'太乙镇','105',2309),(31819,'金家镇','106',2309),(31820,'复兴镇','107',2309),(31821,'天仙镇','108',2309),(31822,'仁和镇','109',2309),(31823,'青岗镇','110',2309),(31824,'洋溪镇','111',2309),(31825,'香山镇','112',2309),(31826,'明星镇','113',2309),(31827,'涪西镇','114',2309),(31828,'陈古镇','115',2309),(31829,'凤来镇','116',2309),(31830,'潼射镇','117',2309),(31831,'曹碑镇','118',2309),(31832,'官升镇','119',2309),(31833,'瞿河乡','200',2309),(31834,'伏河乡','201',2309),(31835,'青堤乡','202',2309),(31836,'双溪乡','203',2309),(31837,'文升乡','204',2309),(31838,'万林乡','205',2309),(31839,'太兴乡','206',2309),(31840,'东岳乡','207',2309),(31841,'金鹤乡','208',2309),(31842,'玉太乡','209',2309),(31843,'蓬莱镇','100',2310),(31844,'隆盛镇','101',2310),(31845,'回马镇','102',2310),(31846,'天保镇','103',2310),(31847,'河边镇','104',2310),(31848,'卓筒井镇','105',2310),(31849,'玉峰镇','106',2310),(31850,'象山镇','107',2310),(31851,'通仙乡','200',2310),(31852,'金元乡','201',2310),(31853,'智水乡','202',2310),(31854,'城东街道','001',2312),(31855,'城南街道','002',2312),(31856,'城西街道','003',2312),(31857,'玉溪街道','004',2312),(31858,'牌楼街道','005',2312),(31859,'壕子口街道','006',2312),(31860,'白马镇','100',2312),(31861,'史家镇','101',2312),(31862,'凌家镇','102',2312),(31863,'朝阳镇','103',2312),(31864,'永安镇','104',2312),(31865,'全安镇','105',2312),(31866,'靖民镇','106',2312),(31867,'乐贤镇','107',2312),(31868,'沱江乡','200',2312),(31869,'交通乡','201',2312),(31870,'四合乡','202',2312),(31871,'凤鸣乡','203',2312),(31872,'伏龙乡','204',2312),(31873,'龚家乡','205',2312),(31874,'东兴街道','001',2313),(31875,'西林街道','002',2313),(31876,'新江街道','003',2313),(31877,'田家镇','100',2313),(31878,'郭北镇','101',2313),(31879,'高梁镇','102',2313),(31880,'白合镇','103',2313),(31881,'顺河镇','104',2313),(31882,'胜利镇','105',2313),(31883,'高桥镇','106',2313),(31884,'双才镇','107',2313),(31885,'小河口镇','108',2313),(31886,'杨家镇','109',2313),(31887,'碑木镇','110',2313),(31888,'石子镇','111',2313),(31889,'太安乡','200',2313),(31890,'苏家乡','201',2313),(31891,'富溪乡','202',2313),(31892,'同福乡','203',2313),(31893,'碑南乡','204',2313),(31894,'永东乡','205',2313),(31895,'永福乡','206',2313),(31896,'新店乡','207',2313),(31897,'双桥乡','208',2313),(31898,'平坦乡','209',2313),(31899,'中山乡','210',2313),(31900,'大治乡','211',2313),(31901,'柳桥乡','212',2313),(31902,'三烈乡','213',2313),(31903,'严陵镇','100',2314),(31904,'铺子湾镇','101',2314),(31905,'新店镇','102',2314),(31906,'向义镇','103',2314),(31907,'界牌镇','104',2314),(31908,'龙会镇','105',2314),(31909,'高石镇','106',2314),(31910,'东联镇','107',2314),(31911,'靖和镇','108',2314),(31912,'镇西镇','109',2314),(31913,'庆卫镇','110',2314),(31914,'山王镇','111',2314),(31915,'黄荆沟镇','112',2314),(31916,'观英滩镇','113',2314),(31917,'新场镇','114',2314),(31918,'连界镇','115',2314),(31919,'越溪镇','116',2314),(31920,'两河镇','117',2314),(31921,'碗厂镇','118',2314),(31922,'小河镇','119',2314),(31923,'重龙镇','100',2315),(31924,'甘露镇','101',2315),(31925,'归德镇','102',2315),(31926,'鱼溪镇','103',2315),(31927,'金李井镇','104',2315),(31928,'铁佛镇','105',2315),(31929,'球溪镇','106',2315),(31930,'顺河场镇','107',2315),(31931,'龙结镇','108',2315),(31932,'罗泉镇','109',2315),(31933,'发轮镇','110',2315),(31934,'兴隆街镇','111',2315),(31935,'银山镇','112',2315),(31936,'宋家镇','113',2315),(31937,'太平镇','114',2315),(31938,'骝马镇','115',2315),(31939,'水南镇','116',2315),(31940,'苏家湾镇','117',2315),(31941,'新桥镇','118',2315),(31942,'明心寺镇','119',2315),(31943,'双河镇','120',2315),(31944,'公民镇','121',2315),(31945,'龙江镇','122',2315),(31946,'双龙镇','123',2315),(31947,'高楼镇','124',2315),(31948,'陈家镇','125',2315),(31949,'配龙镇','126',2315),(31950,'走马镇','127',2315),(31951,'孟塘镇','128',2315),(31952,'马鞍镇','129',2315),(31953,'狮子镇','130',2315),(31954,'板栗桠乡','200',2315),(31955,'龙山乡','201',2315),(31956,'金鹅镇','100',2316),(31957,'山川镇','101',2316),(31958,'响石镇','102',2316),(31959,'圣灯镇','103',2316),(31960,'黄家镇','104',2316),(31961,'双凤镇','105',2316),(31962,'龙市镇','106',2316),(31963,'迎祥镇','107',2316),(31964,'界市镇','108',2316),(31965,'石碾镇','109',2316),(31966,'周兴镇','110',2316),(31967,'渔箭镇','111',2316),(31968,'石燕桥镇','112',2316),(31969,'李市镇','113',2316),(31970,'胡家镇','114',2316),(31971,'云顶镇','115',2316),(31972,'桂花井乡','200',2316),(31973,'普润乡','201',2316),(31974,'张公桥街道','001',2318),(31975,'泊水街道','002',2318),(31976,'上河街道','003',2318),(31977,'篦子街道','004',2318),(31978,'通江镇','100',2318),(31979,'牟子镇','101',2318),(31980,'土主镇','102',2318),(31981,'白马镇','103',2318),(31982,'茅桥镇','104',2318),(31983,'青平镇','105',2318),(31984,'苏稽镇','106',2318),(31985,'水口镇','107',2318),(31986,'安谷镇','108',2318),(31987,'棉竹镇','109',2318),(31988,'全福镇','110',2318),(31989,'童家镇','111',2318),(31990,'九峰镇','112',2318),(31991,'罗汉镇','113',2318),(31992,'临江镇','114',2318),(31993,'车子镇','115',2318),(31994,'悦来乡','200',2318),(31995,'关庙乡','201',2318),(31996,'石龙乡','202',2318),(31997,'剑峰乡','203',2318),(31998,'凌云乡','204',2318),(31999,'迎阳乡','205',2318),(32000,'九龙乡','206',2318),(32001,'普仁乡','207',2318),(32002,'平兴乡','208',2318),(32003,'杨湾乡','209',2318),(32004,'沙湾镇','100',2319),(32005,'嘉农镇','101',2319),(32006,'太平镇','102',2319),(32007,'福禄镇','103',2319),(32008,'牛石镇','104',2319),(32009,'龚嘴镇','105',2319),(32010,'葫芦镇','106',2319),(32011,'踏水镇','107',2319),(32012,'谭坝乡','200',2319),(32013,'轸溪乡','201',2319),(32014,'范店乡','202',2319),(32015,'铜茨乡','203',2319),(32016,'碧山乡','204',2319),(32017,'沫江办事处','400',2319),(32018,'竹根镇','100',2320),(32019,'牛华镇','101',2320),(32020,'杨柳镇','102',2320),(32021,'桥沟镇','103',2320),(32022,'金粟镇','104',2320),(32023,'金山镇','105',2320),(32024,'辉山镇','106',2320),(32025,'西坝镇','107',2320),(32026,'冠英镇','108',2320),(32027,'蔡金镇','109',2320),(32028,'石麟镇','110',2320),(32029,'新云乡','200',2320),(32030,'永和镇','100',2321),(32031,'金河镇','101',2321),(32032,'和平彝族乡','200',2321),(32033,'共安彝族乡','201',2321),(32034,'吉星乡','202',2321),(32035,'永胜乡','203',2321),(32036,'玉津镇','100',2322),(32037,'孝姑镇','101',2322),(32038,'石溪镇','102',2322),(32039,'清溪镇','103',2322),(32040,'新民镇','104',2322),(32041,'罗城镇','105',2322),(32042,'芭沟镇','106',2322),(32043,'龙孔镇','107',2322),(32044,'定文镇','108',2322),(32045,'敖家镇','109',2322),(32046,'金石井镇','110',2322),(32047,'泉水镇','111',2322),(32048,'双溪乡','200',2322),(32049,'九井乡','201',2322),(32050,'同兴乡','202',2322),(32051,'榨鼓乡','203',2322),(32052,'铁炉乡','204',2322),(32053,'大兴乡','205',2322),(32054,'南阳乡','206',2322),(32055,'纪家乡','207',2322),(32056,'新盛乡','208',2322),(32057,'寿保乡','209',2322),(32058,'舞雩乡','210',2322),(32059,'下渡乡','211',2322),(32060,'玉屏乡','212',2322),(32061,'岷东乡','213',2322),(32062,'塘坝乡','214',2322),(32063,'马庙乡','215',2322),(32064,'公平乡','216',2322),(32065,'伏龙乡','217',2322),(32066,'研城镇','100',2323),(32067,'马踏镇','101',2323),(32068,'竹园镇','102',2323),(32069,'研经镇','103',2323),(32070,'周坡镇','104',2323),(32071,'千佛镇','105',2323),(32072,'王村镇','106',2323),(32073,'三江镇','107',2323),(32074,'东林镇','108',2323),(32075,'磨池镇','109',2323),(32076,'集益乡','200',2323),(32077,'纯复乡','201',2323),(32078,'三教乡','202',2323),(32079,'高滩乡','203',2323),(32080,'宝五乡','204',2323),(32081,'四合乡','205',2323),(32082,'黄钵乡','206',2323),(32083,'胜泉乡','207',2323),(32084,'门坎乡','208',2323),(32085,'石牛乡','209',2323),(32086,'高凤乡','210',2323),(32087,'金峰乡','211',2323),(32088,'分全乡','212',2323),(32089,'镇阳乡','213',2323),(32090,'天云乡','214',2323),(32091,'乌抛乡','215',2323),(32092,'大佛乡','216',2323),(32093,'焉城镇','100',2324),(32094,'黄土镇','101',2324),(32095,'甘江镇','102',2324),(32096,'界牌镇','103',2324),(32097,'中兴镇','104',2324),(32098,'三洞镇','105',2324),(32099,'吴场镇','106',2324),(32100,'木城镇','107',2324),(32101,'华头镇','108',2324),(32102,'甘霖镇','109',2324),(32103,'新场镇','110',2324),(32104,'顺河乡','200',2324),(32105,'马村乡','201',2324),(32106,'土门乡','202',2324),(32107,'青州乡','203',2324),(32108,'梧凤乡','204',2324),(32109,'永青乡','205',2324),(32110,'迎江乡','206',2324),(32111,'龙沱乡','207',2324),(32112,'南安乡','208',2324),(32113,'歇马乡','209',2324),(32114,'麻柳乡','210',2324),(32115,'沐溪镇','100',2325),(32116,'永福镇','101',2325),(32117,'大楠镇','102',2325),(32118,'箭板镇','103',2325),(32119,'舟坝镇','104',2325),(32120,'黄丹镇','105',2325),(32121,'利店镇','106',2325),(32122,'建和乡','200',2325),(32123,'幸福乡','201',2325),(32124,'新凡乡','202',2325),(32125,'富和乡','203',2325),(32126,'炭库乡','204',2325),(32127,'底堡乡','205',2325),(32128,'杨村乡','206',2325),(32129,'高笋乡','207',2325),(32130,'茨竹乡','208',2325),(32131,'海云乡','209',2325),(32132,'武圣乡','210',2325),(32133,'凤村乡','211',2325),(32134,'五马坪监狱','400',2325),(32135,'沙坪镇','100',2326),(32136,'大堡镇','101',2326),(32137,'毛坪镇','102',2326),(32138,'五渡镇','103',2326),(32139,'新林镇','104',2326),(32140,'黑竹沟镇','105',2326),(32141,'红花乡','200',2326),(32142,'宜坪乡','201',2326),(32143,'杨村乡','202',2326),(32144,'白杨乡','203',2326),(32145,'觉莫乡','204',2326),(32146,'万坪乡','205',2326),(32147,'杨河乡','206',2326),(32148,'共和乡','207',2326),(32149,'新场乡','208',2326),(32150,'平等乡','209',2326),(32151,'哈曲乡','210',2326),(32152,'金岩乡','211',2326),(32153,'勒乌乡','212',2326),(32154,'民建镇','100',2327),(32155,'荣丁镇','101',2327),(32156,'劳动乡','200',2327),(32157,'建设乡','201',2327),(32158,'石梁乡','203',2327),(32159,'荞坝乡','204',2327),(32160,'民主乡','206',2327),(32161,'老河坝乡','207',2327),(32162,'下溪乡','208',2327),(32163,'雪口山乡','209',2327),(32164,'镇江庙乡','210',2327),(32165,'大竹堡乡','211',2327),(32166,'苏坝乡','213',2327),(32167,'烟峰乡','214',2327),(32168,'袁家溪乡','215',2327),(32169,'沙腔乡','216',2327),(32170,'三河口乡','217',2327),(32171,'梅子坝乡','221',2327),(32172,'高卓营乡','223',2327),(32173,'永红乡','226',2327),(32174,'绥山镇','100',2328),(32175,'高桥镇','101',2328),(32176,'罗目镇','102',2328),(32177,'九里镇','103',2328),(32178,'龙池镇','104',2328),(32179,'乐都镇','105',2328),(32180,'符溪镇','106',2328),(32181,'峨山镇','107',2328),(32182,'双福镇','108',2328),(32183,'桂花桥镇','109',2328),(32184,'大为镇','110',2328),(32185,'胜利镇','111',2328),(32186,'龙门乡','200',2328),(32187,'川主乡','201',2328),(32188,'沙溪乡','202',2328),(32189,'新平乡','203',2328),(32190,'普兴乡','204',2328),(32191,'黄湾乡','205',2328),(32192,'中城街道','001',2330),(32193,'北城街道','002',2330),(32194,'西城街道','003',2330),(32195,'东南街道','004',2330),(32196,'舞凤街道','005',2330),(32197,'新建街道','006',2330),(32198,'华凤街道','007',2330),(32199,'和平路街道','008',2330),(32200,'潆溪镇','103',2330),(32201,'共兴镇','104',2330),(32202,'金台镇','105',2330),(32203,'芦溪镇','106',2330),(32204,'李家镇','107',2330),(32205,'双桥镇','108',2330),(32206,'荆溪镇','109',2330),(32207,'搬罾镇','110',2330),(32208,'新复乡','200',2330),(32209,'同仁乡','201',2330),(32210,'大林乡','204',2330),(32211,'梵殿乡','205',2330),(32212,'顺河乡','206',2330),(32213,'灯台乡','207',2330),(32214,'辉景乡','208',2330),(32215,'龙桂乡','209',2330),(32216,'永丰乡','210',2330),(32217,'桂花乡','211',2330),(32218,'凤山乡','212',2330),(32219,'渔溪乡','213',2330),(32220,'白塔街道办事处','001',2331),(32221,'清溪街道办事处','002',2331),(32222,'小龙镇','101',2331),(32223,'龙门镇','102',2331),(32224,'江陵镇','103',2331),(32225,'擦耳镇','104',2331),(32226,'老君镇','105',2331),(32227,'东观镇','106',2331),(32228,'长乐镇','107',2331),(32229,'胜观镇','108',2331),(32230,'永安镇','109',2331),(32231,'阙家镇','110',2331),(32232,'石圭镇','111',2331),(32233,'青居镇','112',2331),(32234,'青莲镇','113',2331),(32235,'都京镇','114',2331),(32236,'会龙镇','115',2331),(32237,'螺溪镇','116',2331),(32238,'走马乡','201',2331),(32239,'喻家乡','202',2331),(32240,'马家乡','203',2331),(32241,'黄溪乡','204',2331),(32242,'万家乡','205',2331),(32243,'御史乡','207',2331),(32244,'隆兴乡','208',2331),(32245,'斑竹乡','209',2331),(32246,'鄢家乡','210',2331),(32247,'浸水乡','211',2331),(32248,'溪头乡','212',2331),(32249,'青松乡','213',2331),(32250,'凤凰乡','215',2331),(32251,'南江乡','218',2331),(32252,'火花街道','001',2332),(32253,'曲水镇','101',2332),(32254,'李渡镇','102',2332),(32255,'吉安镇','103',2332),(32256,'龙岭镇','104',2332),(32257,'金凤镇','105',2332),(32258,'安福镇','106',2332),(32259,'安平镇','107',2332),(32260,'世阳镇','108',2332),(32261,'大通镇','109',2332),(32262,'一立镇','110',2332),(32263,'龙蟠镇','111',2332),(32264,'里坝镇','112',2332),(32265,'集凤镇','113',2332),(32266,'金宝镇','114',2332),(32267,'三会镇','115',2332),(32268,'西兴镇','116',2332),(32269,'双桂镇','117',2332),(32270,'文峰镇','118',2332),(32271,'七宝寺镇','119',2332),(32272,'龙泉镇','120',2332),(32273,'河西乡','201',2332),(32274,'移山乡','202',2332),(32275,'木老乡','203',2332),(32276,'新场乡','205',2332),(32277,'土门乡','207',2332),(32278,'临江乡','208',2332),(32279,'双店乡','209',2332),(32280,'白家乡','211',2332),(32281,'华兴乡','212',2332),(32282,'大同乡','213',2332),(32283,'盐溪乡','215',2332),(32284,'桥龙乡','216',2332),(32285,'天星乡','218',2332),(32286,'大观乡','219',2332),(32287,'大兴乡','220',2332),(32288,'新庙乡','221',2332),(32289,'桃园乡','222',2332),(32290,'太和乡','223',2332),(32291,'积善乡','226',2332),(32292,'石楼乡','228',2332),(32293,'礼乐乡','229',2332),(32294,'花园乡','230',2332),(32295,'南隆镇','100',2333),(32296,'河东镇','101',2333),(32297,'老鸦镇','102',2333),(32298,'永定镇','103',2333),(32299,'碑院镇','104',2333),(32300,'谢河镇','105',2333),(32301,'盘龙镇','106',2333),(32302,'铁佛塘镇','107',2333),(32303,'石河镇','108',2333),(32304,'王家镇','109',2333),(32305,'富利镇','110',2333),(32306,'楠木镇','111',2333),(32307,'长坪镇','112',2333),(32308,'东坝镇','113',2333),(32309,'河坝镇','114',2333),(32310,'定水镇','115',2333),(32311,'大王镇','116',2333),(32312,'黄金镇','117',2333),(32313,'流马镇','118',2333),(32314,'建兴镇','119',2333),(32315,'三官镇','120',2333),(32316,'伏虎镇','121',2333),(32317,'双佛镇','122',2333),(32318,'花罐镇','123',2333),(32319,'大桥镇','124',2333),(32320,'大河镇','125',2333),(32321,'万年镇','126',2333),(32322,'升钟镇','127',2333),(32323,'升水镇','128',2333),(32324,'大坪镇','129',2333),(32325,'神坝镇','130',2333),(32326,'碾盘乡','200',2333),(32327,'火峰乡','201',2333),(32328,'群龙乡','202',2333),(32329,'大富乡','204',2333),(32330,'光华乡','205',2333),(32331,'碧龙乡','206',2333),(32332,'三清乡','208',2333),(32333,'中心乡','209',2333),(32334,'五灵乡','210',2333),(32335,'平桥乡','211',2333),(32336,'梅家乡','212',2333),(32337,'龙庙乡','213',2333),(32338,'马王乡','214',2333),(32339,'大堰乡','215',2333),(32340,'窑场乡','216',2333),(32341,'太华乡','217',2333),(32342,'兴盛乡','218',2333),(32343,'寒坡乡','220',2333),(32344,'肖家乡','222',2333),(32345,'四龙乡','225',2333),(32346,'碾垭乡','226',2333),(32347,'千秋乡','227',2333),(32348,'玉镇乡','228',2333),(32349,'小元乡','229',2333),(32350,'柳驿乡','230',2333),(32351,'石泉乡','231',2333),(32352,'雄狮乡','232',2333),(32353,'宏观乡','233',2333),(32354,'永庆乡','234',2333),(32355,'永红乡','235',2333),(32356,'柳树乡','236',2333),(32357,'保城乡','237',2333),(32358,'双峰乡','238',2333),(32359,'皂角乡','239',2333),(32360,'丘垭乡','240',2333),(32361,'光中乡','241',2333),(32362,'铁鞭乡','242',2333),(32363,'太霞乡','243',2333),(32364,'店垭乡','244',2333),(32365,'桐坪乡','245',2333),(32366,'西河乡','246',2333),(32367,'朗池镇','100',2334),(32368,'渌井镇','101',2334),(32369,'东升镇','102',2334),(32370,'骆市镇','103',2334),(32371,'黄渡镇','104',2334),(32372,'小桥镇','105',2334),(32373,'灵鹫镇','106',2334),(32374,'老林镇','107',2334),(32375,'木垭镇','108',2334),(32376,'消水镇','109',2334),(32377,'双流镇','110',2334),(32378,'绿水镇','111',2334),(32379,'三兴镇','112',2334),(32380,'蓼叶镇','113',2334),(32381,'新店镇','114',2334),(32382,'回龙镇','115',2334),(32383,'星火镇','116',2334),(32384,'西桥镇','117',2334),(32385,'城南镇','118',2334),(32386,'济川乡','201',2334),(32387,'茶盘乡','202',2334),(32388,'双溪乡','204',2334),(32389,'带河乡','206',2334),(32390,'四喜乡','207',2334),(32391,'玲珑乡','210',2334),(32392,'涌泉乡','211',2334),(32393,'木顶乡','212',2334),(32394,'清源乡','213',2334),(32395,'龙伏乡','214',2334),(32396,'双林乡','215',2334),(32397,'明德乡','216',2334),(32398,'普岭乡','217',2334),(32399,'三元乡','218',2334),(32400,'太蓬乡','219',2334),(32401,'柏林乡','221',2334),(32402,'孔雀乡','222',2334),(32403,'合兴乡','223',2334),(32404,'六合乡','224',2334),(32405,'悦中乡','225',2334),(32406,'高码乡','227',2334),(32407,'安固乡','228',2334),(32408,'大庙乡','230',2334),(32409,'通天乡','231',2334),(32410,'安化乡','232',2334),(32411,'法堂乡','233',2334),(32412,'增产乡','234',2334),(32413,'丰产乡','236',2334),(32414,'清水乡','237',2334),(32415,'青山乡','238',2334),(32416,'福源乡','239',2334),(32417,'柏坪乡','240',2334),(32418,'七涧乡','241',2334),(32419,'凉风乡','243',2334),(32420,'锦屏镇','101',2335),(32421,'巨龙镇','102',2335),(32422,'正源镇','103',2335),(32423,'龙云镇','104',2335),(32424,'金溪镇','105',2335),(32425,'徐家镇','106',2335),(32426,'河舒镇','107',2335),(32427,'利溪镇','108',2335),(32428,'龙蚕镇','109',2335),(32429,'杨家镇','110',2335),(32430,'罗家镇','111',2335),(32431,'福德镇','112',2335),(32432,'银汉镇','113',2335),(32433,'兴旺镇','114',2335),(32434,'相如镇','115',2335),(32435,'高庙乡','201',2335),(32436,'群乐乡','202',2335),(32437,'长梁乡','203',2335),(32438,'两路乡','204',2335),(32439,'睦坝乡','205',2335),(32440,'石梁乡','207',2335),(32441,'平头乡','208',2335),(32442,'鲜店乡','209',2335),(32443,'茶亭乡','211',2335),(32444,'诸家乡','212',2335),(32445,'骑龙乡','214',2335),(32446,'金甲乡','215',2335),(32447,'新园乡','217',2335),(32448,'三坝乡','218',2335),(32449,'碧溪乡','220',2335),(32450,'柳滩乡','221',2335),(32451,'石孔乡','222',2335),(32452,'开元乡','223',2335),(32453,'新河乡','225',2335),(32454,'南燕乡','226',2335),(32455,'天成乡','227',2335),(32456,'海田乡','228',2335),(32457,'济渡乡','229',2335),(32458,'凤石乡','230',2335),(32459,'金城镇','100',2336),(32460,'新政镇','101',2336),(32461,'马鞍镇','102',2336),(32462,'永乐镇','103',2336),(32463,'日兴镇','104',2336),(32464,'土门镇','105',2336),(32465,'复兴镇','106',2336),(32466,'观紫镇','107',2336),(32467,'先锋镇','108',2336),(32468,'三蛟镇','109',2336),(32469,'回春镇','110',2336),(32470,'柳垭镇','111',2336),(32471,'义路镇','112',2336),(32472,'立山镇','113',2336),(32473,'三河镇','114',2336),(32474,'瓦子镇','115',2336),(32475,'大寅镇','116',2336),(32476,'二道镇','117',2336),(32477,'赛金镇','118',2336),(32478,'丁字桥镇','119',2336),(32479,'大仪镇','120',2336),(32480,'张公镇','121',2336),(32481,'五福镇','122',2336),(32482,'周河镇','123',2336),(32483,'杨桥镇','124',2336),(32484,'保平镇','125',2336),(32485,'文星镇','126',2336),(32486,'双胜镇','127',2336),(32487,'度门镇','128',2336),(32488,'老木乡','200',2336),(32489,'檬垭乡','201',2336),(32490,'铜鼓乡','202',2336),(32491,'中坝乡','205',2336),(32492,'双盘乡','206',2336),(32493,'凤仪乡','207',2336),(32494,'双庆乡','208',2336),(32495,'大风乡','209',2336),(32496,'福临乡','210',2336),(32497,'来仪乡','212',2336),(32498,'碧泉乡','213',2336),(32499,'乐兴乡','214',2336),(32500,'石佛乡','216',2336),(32501,'思德乡','217',2336),(32502,'秋垭乡','218',2336),(32503,'大罗乡','219',2336),(32504,'义门乡','220',2336),(32505,'合作乡','221',2336),(32506,'阳通乡','222',2336),(32507,'茶房乡','223',2336),(32508,'龙桥乡','225',2336),(32509,'板桥乡','226',2336),(32510,'永光乡','227',2336),(32511,'炬光乡','228',2336),(32512,'九龙乡','229',2336),(32513,'芭蕉乡','230',2336),(32514,'灯塔乡','231',2336),(32515,'武棚乡','232',2336),(32516,'柴井乡','241',2336),(32517,'晋城镇','100',2337),(32518,'太平镇','101',2337),(32519,'大全镇','102',2337),(32520,'仙林镇','103',2337),(32521,'古楼镇','104',2337),(32522,'义兴镇','105',2337),(32523,'关文镇','106',2337),(32524,'凤鸣镇','107',2337),(32525,'青狮镇','108',2337),(32526,'槐树镇','109',2337),(32527,'鸣龙镇','110',2337),(32528,'双凤镇','111',2337),(32529,'高院镇','112',2337),(32530,'仁和镇','113',2337),(32531,'多扶镇','114',2337),(32532,'常林乡','202',2337),(32533,'占山乡','203',2337),(32534,'莲池乡','204',2337),(32535,'宏桥乡','205',2337),(32536,'金泉乡','207',2337),(32537,'华光乡','208',2337),(32538,'金源乡','209',2337),(32539,'岱林乡','210',2337),(32540,'李桥乡','211',2337),(32541,'中岭乡','212',2337),(32542,'西碾乡','213',2337),(32543,'紫岩乡','214',2337),(32544,'复安乡','215',2337),(32545,'观凤乡','216',2337),(32546,'青龙乡','217',2337),(32547,'双洛乡','218',2337),(32548,'义和乡','219',2337),(32549,'罐垭乡','220',2337),(32550,'中南乡','221',2337),(32551,'双江乡','222',2337),(32552,'凤和乡','223',2337),(32553,'东岱乡','224',2337),(32554,'同德乡','225',2337),(32555,'祥龙乡','226',2337),(32556,'车龙乡','227',2337),(32557,'扶君乡','228',2337),(32558,'东太乡','229',2337),(32559,'永清乡','230',2337),(32560,'金山乡','231',2337),(32561,'保宁街道','001',2338),(32562,'沙溪街道','003',2338),(32563,'七里街道','004',2338),(32564,'江南镇','101',2338),(32565,'彭城镇','103',2338),(32566,'双龙镇','104',2338),(32567,'柏垭镇','105',2338),(32568,'飞凤镇','106',2338),(32569,'思依镇','107',2338),(32570,'文成镇','108',2338),(32571,'二龙镇','109',2338),(32572,'石滩镇','110',2338),(32573,'老观镇','111',2338),(32574,'龙泉镇','112',2338),(32575,'千佛镇','113',2338),(32576,'望垭镇','114',2338),(32577,'河溪镇','115',2338),(32578,'妙高镇','116',2338),(32579,'洪山镇','117',2338),(32580,'石龙镇','118',2338),(32581,'宝马镇','119',2338),(32582,'水观镇','120',2338),(32583,'金垭镇','121',2338),(32584,'玉台镇','122',2338),(32585,'垭口乡','201',2338),(32586,'治平乡','202',2338),(32587,'天宫乡','208',2338),(32588,'天林乡','209',2338),(32589,'枣碧乡','210',2338),(32590,'北门乡','211',2338),(32591,'桥楼乡','212',2338),(32592,'河楼乡','213',2338),(32593,'木兰乡','215',2338),(32594,'东兴乡','216',2338),(32595,'清泉乡','217',2338),(32596,'博树回族乡','219',2338),(32597,'凉水乡','221',2338),(32598,'解元乡','224',2338),(32599,'西山乡','225',2338),(32600,'方山乡','226',2338),(32601,'金子乡','232',2338),(32602,'三庙乡','233',2338),(32603,'峰占乡','234',2338),(32604,'鹤丰乡','235',2338),(32605,'金城乡','239',2338),(32606,'五马乡','241',2338),(32607,'朱镇乡','243',2338),(32608,'宝台乡','245',2338),(32609,'福星乡','247',2338),(32610,'通惠街道办事处','001',2340),(32611,'大石桥街道办事处','002',2340),(32612,'苏祠街道办事处','003',2340),(32613,'白马镇','100',2340),(32614,'象耳镇','101',2340),(32615,'太和镇','102',2340),(32616,'悦兴镇','103',2340),(32617,'尚义镇','104',2340),(32618,'多悦镇','105',2340),(32619,'秦家镇','106',2340),(32620,'万胜镇','107',2340),(32621,'崇仁镇','108',2340),(32622,'思蒙镇','109',2340),(32623,'修文镇','110',2340),(32624,'松江镇','112',2340),(32625,'崇礼镇','113',2340),(32626,'富牛镇','114',2340),(32627,'永寿镇','115',2340),(32628,'三苏乡','204',2340),(32629,'广济乡','205',2340),(32630,'盘鳌乡','206',2340),(32631,'土地乡','210',2340),(32632,'复盛乡','211',2340),(32633,'复兴乡','212',2340),(32634,'金花乡','213',2340),(32635,'柳圣乡','214',2340),(32636,'文宫镇','102',2341),(32637,'禾加镇','112',2341),(32638,'龙马镇','116',2341),(32639,'方加镇','117',2341),(32640,'文林镇','123',2341),(32641,'大化镇','124',2341),(32642,'高家镇','125',2341),(32643,'中农镇','126',2341),(32644,'禄加镇','127',2341),(32645,'宝飞镇','128',2341),(32646,'彰加镇','129',2341),(32647,'慈航镇','130',2341),(32648,'汪洋镇','131',2341),(32649,'钟祥镇','132',2341),(32650,'始建镇','133',2341),(32651,'满井镇','134',2341),(32652,'富加镇','135',2341),(32653,'龙正镇','136',2341),(32654,'黑龙滩镇','137',2341),(32655,'清水镇','138',2341),(32656,'视高镇','139',2341),(32657,'北斗镇','140',2341),(32658,'于丞乡','200',2341),(32659,'青岗乡','203',2341),(32660,'古佛乡','209',2341),(32661,'板燕乡','210',2341),(32662,'石咀乡','218',2341),(32663,'藕塘乡','219',2341),(32664,'玉龙乡','222',2341),(32665,'合兴乡','232',2341),(32666,'促进乡','239',2341),(32667,'鸭池乡','251',2341),(32668,'双堡乡','254',2341),(32669,'河口乡','258',2341),(32670,'板桥乡','259',2341),(32671,'元通乡','268',2341),(32672,'向家乡','269',2341),(32673,'里仁乡','276',2341),(32674,'兴盛乡','277',2341),(32675,'兆嘉乡','281',2341),(32676,'宝马乡','287',2341),(32677,'珠嘉乡','288',2341),(32678,'鳌陵乡','289',2341),(32679,'观寺乡','290',2341),(32680,'中岗乡','291',2341),(32681,'龙桥乡','292',2341),(32682,'曲江乡','293',2341),(32683,'城堰乡','294',2341),(32684,'谢安乡','295',2341),(32685,'新店乡','296',2341),(32686,'天峨乡','297',2341),(32687,'识经乡','298',2341),(32688,'凤陵乡','299',2341),(32689,'涂加乡','300',2341),(32690,'四公乡','301',2341),(32691,'松峰乡','302',2341),(32692,'曹家乡','303',2341),(32693,'景贤乡','304',2341),(32694,'农旺乡','305',2341),(32695,'洪峰乡','306',2341),(32696,'凤鸣镇','100',2342),(32697,'青龙镇','101',2342),(32698,'公义镇','103',2342),(32699,'观音镇','105',2342),(32700,'灵石镇','106',2342),(32701,'彭溪镇','107',2342),(32702,'黄丰镇','108',2342),(32703,'江口镇','109',2342),(32704,'谢家镇','110',2342),(32705,'保胜乡','205',2342),(32706,'皇陵乡','209',2342),(32707,'武阳乡','210',2342),(32708,'义和乡','211',2342),(32709,'止戈镇','101',2343),(32710,'三宝镇','102',2343),(32711,'花溪镇','108',2343),(32712,'洪川镇','112',2343),(32713,'余坪镇','113',2343),(32714,'槽渔滩镇','114',2343),(32715,'中保镇','115',2343),(32716,'东岳镇','116',2343),(32717,'柳江镇','117',2343),(32718,'高庙镇','118',2343),(32719,'瓦屋山镇','119',2343),(32720,'中山乡','200',2343),(32721,'将军乡','201',2343),(32722,'汉王乡','205',2343),(32723,'桃源乡','212',2343),(32724,'仁美镇','102',2344),(32725,'丹棱镇','105',2344),(32726,'杨场镇','106',2344),(32727,'双桥镇','107',2344),(32728,'张场镇','108',2344),(32729,'石桥乡','200',2344),(32730,'顺龙乡','204',2344),(32731,'汉阳镇','102',2345),(32732,'河坝子镇','105',2345),(32733,'南城镇','106',2345),(32734,'青城镇','107',2345),(32735,'瑞峰镇','108',2345),(32736,'黑龙镇','109',2345),(32737,'西龙镇','110',2345),(32738,'高台乡','205',2345),(32739,'白果乡','217',2345),(32740,'罗波乡','218',2345),(32741,'北城街道办事处','001',2347),(32742,'东城街道办事处','002',2347),(32743,'南城街道办事处','003',2347),(32744,'西城街道办事处','004',2347),(32745,'南岸街道办事处','005',2347),(32746,'西郊街道办事处','006',2347),(32747,'安阜街道办事处','007',2347),(32748,'白沙湾街道办事处','008',2347),(32749,'赵场街道办事处','009',2347),(32750,'象鼻街道办事处','010',2347),(32751,'南广镇','100',2347),(32752,'李庄镇','101',2347),(32753,'菜坝镇','102',2347),(32754,'金坪镇','104',2347),(32755,'高店镇','106',2347),(32756,'沙坪镇','107',2347),(32757,'牟坪镇','108',2347),(32758,'李端镇','109',2347),(32759,'宋家乡','200',2347),(32760,'明威乡','201',2347),(32761,'凉姜乡','202',2347),(32762,'邱场乡','203',2347),(32763,'思坡乡','204',2347),(32764,'宗场乡','205',2347),(32765,'柏溪镇','100',2348),(32766,'喜捷镇','101',2348),(32767,'观音镇','102',2348),(32768,'横江镇','103',2348),(32769,'永兴镇','104',2348),(32770,'白花镇','105',2348),(32771,'柳嘉镇','106',2348),(32772,'泥溪镇','107',2348),(32773,'蕨溪镇','108',2348),(32774,'商州镇','109',2348),(32775,'高场镇','110',2348),(32776,'安边镇','111',2348),(32777,'双龙镇','112',2348),(32778,'李场镇','113',2348),(32779,'合什镇','114',2348),(32780,'古罗镇','115',2348),(32781,'孔滩镇','116',2348),(32782,'复龙镇','117',2348),(32783,'古柏乡','200',2348),(32784,'王场乡','201',2348),(32785,'双谊乡','202',2348),(32786,'隆兴乡','203',2348),(32787,'泥南乡','204',2348),(32788,'龙池乡','205',2348),(32789,'普安乡','207',2348),(32790,'凤仪乡','209',2348),(32791,'南溪镇','100',2349),(32792,'罗龙镇','101',2349),(32793,'刘家镇','102',2349),(32794,'江南镇','103',2349),(32795,'大观镇','104',2349),(32796,'汪家镇','105',2349),(32797,'黄沙镇','106',2349),(32798,'仙临镇','107',2349),(32799,'长兴镇','108',2349),(32800,'裴石乡','200',2349),(32801,'马家乡','201',2349),(32802,'大坪乡','203',2349),(32803,'石鼓乡','204',2349),(32804,'林丰乡','205',2349),(32805,'留宾乡','206',2349),(32806,'江安镇','100',2350),(32807,'红桥镇','101',2350),(32808,'桐梓镇','102',2350),(32809,'井口镇','103',2350),(32810,'怡乐镇','104',2350),(32811,'留耕镇','105',2350),(32812,'底蓬镇','106',2350),(32813,'五矿镇','108',2350),(32814,'迎安镇','109',2350),(32815,'夕佳山镇','110',2350),(32816,'水清镇','111',2350),(32817,'铁清镇','112',2350),(32818,'四面山镇','113',2350),(32819,'大井镇','114',2350),(32820,'大妙乡','200',2350),(32821,'蟠龙乡','203',2350),(32822,'滥坝乡','204',2350),(32823,'仁和乡','205',2350),(32824,'长宁镇','100',2351),(32825,'梅硐镇','101',2351),(32826,'双河镇','102',2351),(32827,'硐底镇','103',2351),(32828,'花滩镇','104',2351),(32829,'竹海镇','105',2351),(32830,'老翁镇','106',2351),(32831,'古河镇','107',2351),(32832,'下长镇','108',2351),(32833,'龙头镇','110',2351),(32834,'铜锣乡','200',2351),(32835,'桃坪乡','201',2351),(32836,'铜鼓乡','203',2351),(32837,'井江乡','204',2351),(32838,'三元乡','205',2351),(32839,'开佛乡','206',2351),(32840,'富兴乡','207',2351),(32841,'梅白乡','208',2351),(32842,'文江镇','100',2352),(32843,'庆符镇','101',2352),(32844,'沙河镇','102',2352),(32845,'嘉乐镇','103',2352),(32846,'大窝镇','104',2352),(32847,'罗场镇','105',2352),(32848,'蕉村镇','106',2352),(32849,'可久镇','107',2352),(32850,'来复镇','108',2352),(32851,'月江镇','109',2352),(32852,'胜天镇','110',2352),(32853,'复兴镇','111',2352),(32854,'趱滩乡','203',2352),(32855,'羊田乡','204',2352),(32856,'落润乡','205',2352),(32857,'潆溪乡','206',2352),(32858,'庆岭乡','207',2352),(32859,'双河乡','208',2352),(32860,'四烈乡','210',2352),(32861,'珙泉镇','100',2353),(32862,'巡场镇','101',2353),(32863,'孝儿镇','102',2353),(32864,'底洞镇','103',2353),(32865,'上罗镇','104',2353),(32866,'洛表镇','105',2353),(32867,'洛亥镇','106',2353),(32868,'王家镇','107',2353),(32869,'恒丰乡','200',2353),(32870,'沐滩乡','202',2353),(32871,'仁义乡','203',2353),(32872,'玉和苗族乡','205',2353),(32873,'下罗乡','207',2353),(32874,'罗渡苗族乡','209',2353),(32875,'曹营乡','210',2353),(32876,'石碑乡','211',2353),(32877,'观斗苗族乡','212',2353),(32878,'筠连镇','100',2354),(32879,'腾达镇','101',2354),(32880,'巡司镇','102',2354),(32881,'双腾镇','103',2354),(32882,'沐爱镇','104',2354),(32883,'维新镇','105',2354),(32884,'镇舟镇','107',2354),(32885,'蒿坝镇','108',2354),(32886,'大雪山镇','109',2354),(32887,'武德乡','200',2354),(32888,'塘坝乡','202',2354),(32889,'龙镇乡','203',2354),(32890,'孔雀乡','204',2354),(32891,'乐义乡','205',2354),(32892,'高坎乡','206',2354),(32893,'团林苗族乡','208',2354),(32894,'联合苗族乡','209',2354),(32895,'高坪苗族乡','210',2354),(32896,'古宋镇','100',2355),(32897,'共乐镇','103',2355),(32898,'莲花镇','105',2355),(32899,'九丝城镇','107',2355),(32900,'石海镇','108',2355),(32901,'太平镇','109',2355),(32902,'周家镇','110',2355),(32903,'大坝苗族乡','200',2355),(32904,'毓秀苗族乡','201',2355),(32905,'玉屏乡','202',2355),(32906,'大河苗族乡','205',2355),(32907,'麒麟苗族乡','206',2355),(32908,'仙峰苗族乡','207',2355),(32909,'五星乡','208',2355),(32910,'锦屏镇','100',2356),(32911,'新市镇','101',2356),(32912,'中都镇','102',2356),(32913,'龙华镇','103',2356),(32914,'大乘镇','104',2356),(32915,'福延镇','105',2356),(32916,'富荣镇','106',2356),(32917,'新安镇','107',2356),(32918,'楼东乡','202',2356),(32919,'鸭池乡','203',2356),(32920,'龙溪乡','204',2356),(32921,'太平乡','205',2356),(32922,'夏溪乡','208',2356),(32923,'屏边彝族乡','210',2356),(32924,'清平彝族乡','211',2356),(32925,'新发乡','212',2356),(32926,'浓洄街道办事处','001',2358),(32927,'北辰街道办事处','002',2358),(32928,'奎阁街道办事处','003',2358),(32929,'广福街道办事处','004',2358),(32930,'万盛街道办事处','005',2358),(32931,'中桥街道办事处','006',2358),(32932,'枣山镇','100',2358),(32933,'官盛镇','101',2358),(32934,'协兴镇','102',2358),(32935,'浓溪镇','103',2358),(32936,'悦来镇','104',2358),(32937,'兴平镇','105',2358),(32938,'井河镇','106',2358),(32939,'花桥镇','107',2358),(32940,'龙台镇','108',2358),(32941,'肖溪镇','109',2358),(32942,'恒升镇','110',2358),(32943,'石笋镇','111',2358),(32944,'白市镇','112',2358),(32945,'大安镇','113',2358),(32946,'观阁镇','114',2358),(32947,'广兴镇','115',2358),(32948,'前锋镇','116',2358),(32949,'桂兴镇','117',2358),(32950,'代市镇','118',2358),(32951,'观塘镇','119',2358),(32952,'护安镇','120',2358),(32953,'穿石乡','200',2358),(32954,'广门乡','201',2358),(32955,'广罗乡','202',2358),(32956,'方坪乡','203',2358),(32957,'化龙乡','204',2358),(32958,'大龙乡','205',2358),(32959,'崇望乡','206',2358),(32960,'龙安乡','207',2358),(32961,'彭家乡','208',2358),(32962,'杨坪乡','209',2358),(32963,'郑山乡','210',2358),(32964,'蒲莲乡','211',2358),(32965,'大有乡','212',2358),(32966,'消河乡','213',2358),(32967,'东岳乡','214',2358),(32968,'苏溪乡','215',2358),(32969,'白马乡','216',2358),(32970,'光辉乡','217',2358),(32971,'龙滩乡','218',2358),(32972,'小井乡','219',2358),(32973,'新桥乡','220',2358),(32974,'虎城乡','222',2358),(32975,'九龙镇','100',2359),(32976,'花园镇','101',2359),(32977,'坪滩镇','102',2359),(32978,'龙孔镇','103',2359),(32979,'镇裕镇','104',2359),(32980,'白庙镇','105',2359),(32981,'酉溪镇','106',2359),(32982,'同兴镇','107',2359),(32983,'兴隆镇','108',2359),(32984,'秦溪镇','109',2359),(32985,'顾县镇','110',2359),(32986,'苟角镇','111',2359),(32987,'天平镇','112',2359),(32988,'石垭镇','113',2359),(32989,'乔家镇','114',2359),(32990,'罗渡镇','115',2359),(32991,'裕民镇','116',2359),(32992,'中和镇','117',2359),(32993,'新场镇','118',2359),(32994,'普安镇','119',2359),(32995,'赛龙镇','120',2359),(32996,'临溪镇','121',2359),(32997,'朝阳乡','200',2359),(32998,'北城乡','201',2359),(32999,'镇龙乡','202',2359),(33000,'粽粑乡','203',2359),(33001,'排楼乡','205',2359),(33002,'西板乡','206',2359),(33003,'嘉陵乡','207',2359),(33004,'石鼓乡','208',2359),(33005,'平安乡','209',2359),(33006,'恐龙乡','210',2359),(33007,'团结乡','211',2359),(33008,'黄龙乡','212',2359),(33009,'双鄢乡','213',2359),(33010,'东板乡','214',2359),(33011,'长田乡','215',2359),(33012,'鱼峰乡','216',2359),(33013,'大石乡','218',2359),(33014,'花板乡','219',2359),(33015,'大佛乡','220',2359),(33016,'齐福乡','222',2359),(33017,'伏龙乡','223',2359),(33018,'沿口镇','100',2360),(33019,'中心镇','101',2360),(33020,'烈面镇','102',2360),(33021,'飞龙镇','103',2360),(33022,'乐善镇','104',2360),(33023,'万善镇','105',2360),(33024,'龙女镇','106',2360),(33025,'三溪镇','107',2360),(33026,'赛马镇','108',2360),(33027,'胜利镇','109',2360),(33028,'金牛镇','110',2360),(33029,'清平镇','111',2360),(33030,'街子镇','112',2360),(33031,'万隆镇','113',2360),(33032,'礼安镇','114',2360),(33033,'华封镇','115',2360),(33034,'鸣钟乡','200',2360),(33035,'真静乡','201',2360),(33036,'猛山乡','202',2360),(33037,'双星乡','203',2360),(33038,'龙庭乡','204',2360),(33039,'石盘乡','205',2360),(33040,'旧县乡','207',2360),(33041,'鼓匠乡','208',2360),(33042,'白坪乡','209',2360),(33043,'永胜乡','210',2360),(33044,'新学乡','211',2360),(33045,'宝箴塞乡','212',2360),(33046,'金光乡','213',2360),(33047,'八一乡','214',2360),(33048,'高石乡','215',2360),(33049,'鼎屏镇','100',2361),(33050,'城北镇','101',2361),(33051,'城南镇','102',2361),(33052,'柑子镇','103',2361),(33053,'龙安镇','104',2361),(33054,'观音桥镇','105',2361),(33055,'牟家镇','106',2361),(33056,'合流镇','107',2361),(33057,'坛同镇','108',2361),(33058,'高滩镇','109',2361),(33059,'九龙镇','110',2361),(33060,'幺滩镇','111',2361),(33061,'袁市镇','112',2361),(33062,'丰禾镇','113',2361),(33063,'八耳镇','114',2361),(33064,'石永镇','115',2361),(33065,'兴仁镇','116',2361),(33066,'王家镇','117',2361),(33067,'太和乡','200',2361),(33068,'新镇乡','201',2361),(33069,'冷家乡','202',2361),(33070,'长安乡','203',2361),(33071,'西天乡','204',2361),(33072,'梁板乡','205',2361),(33073,'甘坝乡','206',2361),(33074,'四海乡','207',2361),(33075,'九峰乡','208',2361),(33076,'椿木乡','209',2361),(33077,'华蓥乡','210',2361),(33078,'子中乡','211',2361),(33079,'风垭乡','212',2361),(33080,'黎家乡','213',2361),(33081,'龙桥乡','214',2361),(33082,'关河乡','215',2361),(33083,'两河乡','216',2361),(33084,'长滩乡','217',2361),(33085,'凉山乡','218',2361),(33086,'复盛乡','219',2361),(33087,'古路乡','220',2361),(33088,'荆坪乡','221',2361),(33089,'柳塘乡','222',2361),(33090,'石滓乡','223',2361),(33091,'护邻乡','224',2361),(33092,'同石乡','225',2361),(33093,'三古乡','226',2361),(33094,'双河街道办事处','001',2362),(33095,'古桥街道办事处','002',2362),(33096,'华龙街道办事处','003',2362),(33097,'天池镇','101',2362),(33098,'禄市镇','102',2362),(33099,'永兴镇','103',2362),(33100,'明月镇','104',2362),(33101,'阳和镇','105',2362),(33102,'高兴镇','106',2362),(33103,'观音溪镇','107',2362),(33104,'溪口镇','108',2362),(33105,'庆华镇','109',2362),(33106,'红岩乡','200',2362),(33107,'东城街道办事处','001',2364),(33108,'西城街道办事处','002',2364),(33109,'朝阳街道办事处','003',2364),(33110,'西外镇','100',2364),(33111,'北外镇','101',2364),(33112,'罗江镇','102',2364),(33113,'蒲家镇','103',2364),(33114,'复兴镇','104',2364),(33115,'双龙镇','105',2364),(33116,'魏兴镇','106',2364),(33117,'盘石乡','200',2364),(33118,'东岳乡','201',2364),(33119,'新村乡','202',2364),(33120,'南外镇','100',2365),(33121,'亭子镇','101',2365),(33122,'福善镇','102',2365),(33123,'麻柳镇','103',2365),(33124,'檀木镇','104',2365),(33125,'大树镇','105',2365),(33126,'南岳镇','106',2365),(33127,'万家镇','107',2365),(33128,'景市镇','108',2365),(33129,'百节镇','109',2365),(33130,'赵家镇','110',2365),(33131,'河市镇','111',2365),(33132,'石板镇','112',2365),(33133,'金垭镇','113',2365),(33134,'渡市镇','114',2365),(33135,'管村镇','115',2365),(33136,'石梯镇','116',2365),(33137,'石桥镇','117',2365),(33138,'堡子镇','118',2365),(33139,'江陵镇','119',2365),(33140,'碑庙镇','120',2365),(33141,'大风乡','200',2365),(33142,'江阳乡','201',2365),(33143,'东兴乡','202',2365),(33144,'安仁乡','203',2365),(33145,'葫芦乡','204',2365),(33146,'大滩乡','205',2365),(33147,'花红乡','206',2365),(33148,'黄庭乡','207',2365),(33149,'黄都乡','208',2365),(33150,'平滩乡','209',2365),(33151,'碑高乡','210',2365),(33152,'马家乡','211',2365),(33153,'木子乡','212',2365),(33154,'双庙乡','213',2365),(33155,'斌郎乡','214',2365),(33156,'幺塘乡','215',2365),(33157,'陈家乡','216',2365),(33158,'龙会乡','217',2365),(33159,'罐子乡','218',2365),(33160,'申家乡','219',2365),(33161,'草兴乡','220',2365),(33162,'木头乡','221',2365),(33163,'金檀乡','222',2365),(33164,'大堰乡','223',2365),(33165,'赵固乡','224',2365),(33166,'九岭乡','225',2365),(33167,'桥湾乡','226',2365),(33168,'五四乡','227',2365),(33169,'银铁乡','228',2365),(33170,'沿河乡','229',2365),(33171,'香隆乡','230',2365),(33172,'永进乡','231',2365),(33173,'洛车乡','232',2365),(33174,'道让乡','233',2365),(33175,'虎让乡','234',2365),(33176,'米城乡','235',2365),(33177,'龙滩乡','236',2365),(33178,'梓桐乡','237',2365),(33179,'北山乡','238',2365),(33180,'金石乡','239',2365),(33181,'安云乡','240',2365),(33182,'青宁乡','241',2365),(33183,'檬双乡','242',2365),(33184,'东乡镇','100',2366),(33185,'君塘镇','101',2366),(33186,'清溪镇','102',2366),(33187,'普光镇','103',2366),(33188,'天生镇','104',2366),(33189,'柏树镇','105',2366),(33190,'芭蕉镇','106',2366),(33191,'南坝镇','107',2366),(33192,'五宝镇','108',2366),(33193,'峰城镇','109',2366),(33194,'土黄镇','110',2366),(33195,'华景镇','111',2366),(33196,'樊哙镇','112',2366),(33197,'新华镇','113',2366),(33198,'黄金镇','114',2366),(33199,'胡家镇','115',2366),(33200,'毛坝镇','116',2366),(33201,'双河镇','117',2366),(33202,'大成镇','118',2366),(33203,'明月乡','200',2366),(33204,'红岭乡','201',2366),(33205,'柳池乡','202',2366),(33206,'三河乡','203',2366),(33207,'老君乡','204',2366),(33208,'黄石乡','205',2366),(33209,'七里乡','206',2366),(33210,'庙安乡','207',2366),(33211,'天宝乡','208',2366),(33212,'东林乡','209',2366),(33213,'下八乡','210',2366),(33214,'凉风乡','211',2366),(33215,'上峡乡','212',2366),(33216,'塔河乡','213',2366),(33217,'茶河乡','214',2366),(33218,'天台乡','215',2366),(33219,'观山乡','216',2366),(33220,'南坪乡','217',2366),(33221,'凤林乡','218',2366),(33222,'桃花乡','219',2366),(33223,'白马乡','220',2366),(33224,'漆碑乡','221',2366),(33225,'三墩乡','222',2366),(33226,'漆树乡','223',2366),(33227,'龙泉乡','224',2366),(33228,'渡口乡','225',2366),(33229,'石铁乡','226',2366),(33230,'厂溪乡','227',2366),(33231,'红峰乡','228',2366),(33232,'凤鸣乡','229',2366),(33233,'花池乡','230',2366),(33234,'土主乡','231',2366),(33235,'庆云乡','232',2366),(33236,'马渡乡','233',2366),(33237,'隘口乡','234',2366),(33238,'新宁镇','100',2367),(33239,'普安镇','101',2367),(33240,'回龙镇','102',2367),(33241,'天师镇','103',2367),(33242,'永兴镇','104',2367),(33243,'讲治镇','105',2367),(33244,'甘棠镇','106',2367),(33245,'任市镇','107',2367),(33246,'广福镇','108',2367),(33247,'长岭镇','109',2367),(33248,'长田乡','200',2367),(33249,'骑龙乡','201',2367),(33250,'新太乡','202',2367),(33251,'灵岩乡','203',2367),(33252,'沙坝场乡','204',2367),(33253,'梅家乡','205',2367),(33254,'宝石乡','206',2367),(33255,'靖安乡','207',2367),(33256,'新街乡','208',2367),(33257,'拔妙乡','209',2367),(33258,'竹阳镇','100',2368),(33259,'乌木镇','101',2368),(33260,'团坝镇','102',2368),(33261,'杨家镇','103',2368),(33262,'清河镇','104',2368),(33263,'柏林镇','105',2368),(33264,'石河镇','106',2368),(33265,'双拱镇','107',2368),(33266,'石桥铺镇','108',2368),(33267,'观音镇','109',2368),(33268,'周家镇','110',2368),(33269,'石子镇','111',2368),(33270,'文星镇','112',2368),(33271,'妈妈镇','113',2368),(33272,'高穴镇','114',2368),(33273,'欧家镇','115',2368),(33274,'庙坝镇','116',2368),(33275,'清水镇','117',2368),(33276,'城西乡','200',2368),(33277,'竹北乡','201',2368),(33278,'东柳乡','202',2368),(33279,'朝阳乡','203',2368),(33280,'人和乡','204',2368),(33281,'中华乡','205',2368),(33282,'黄家乡','206',2368),(33283,'柏家乡','207',2368),(33284,'李家乡','208',2368),(33285,'余华乡','209',2368),(33286,'二郎乡','210',2368),(33287,'蒲包乡','211',2368),(33288,'永胜乡','212',2368),(33289,'新生乡','213',2368),(33290,'安吉乡','214',2368),(33291,'白坝乡','215',2368),(33292,'双溪乡','216',2368),(33293,'高明乡','217',2368),(33294,'八渡乡','218',2368),(33295,'中和乡','219',2368),(33296,'杨通乡','220',2368),(33297,'天城乡','221',2368),(33298,'四合乡','222',2368),(33299,'张家乡','223',2368),(33300,'童家乡','224',2368),(33301,'神合乡','225',2368),(33302,'金鸡乡','226',2368),(33303,'黄滩乡','227',2368),(33304,'牌坊乡','228',2368),(33305,'姚市乡','229',2368),(33306,'莲印乡','230',2368),(33307,'川主乡','231',2368),(33308,'渠江镇','100',2369),(33309,'天星镇','101',2369),(33310,'临巴镇','102',2369),(33311,'土溪镇','103',2369),(33312,'三汇镇','104',2369),(33313,'文崇镇','105',2369),(33314,'涌兴镇','106',2369),(33315,'贵福镇','107',2369),(33316,'岩峰镇','108',2369),(33317,'静边镇','109',2369),(33318,'清溪场镇','110',2369),(33319,'宝城镇','111',2369),(33320,'有庆镇','112',2369),(33321,'鲜渡镇','113',2369),(33322,'琅琊镇','114',2369),(33323,'渠南乡','200',2369),(33324,'渠北乡','201',2369),(33325,'青龙乡','202',2369),(33326,'板桥乡','203',2369),(33327,'锡溪乡','204',2369),(33328,'龙潭乡','205',2369),(33329,'河东乡','206',2369),(33330,'李馥乡','207',2369),(33331,'青神乡','208',2369),(33332,'流溪乡','209',2369),(33333,'东安乡','210',2369),(33334,'汇东乡','211',2369),(33335,'汇南乡','212',2369),(33336,'汇北乡','213',2369),(33337,'丰乐乡','214',2369),(33338,'报恩乡','215',2369),(33339,'安北乡','216',2369),(33340,'平安乡','217',2369),(33341,'千佛乡','218',2369),(33342,'柏水乡','219',2369),(33343,'大义乡','220',2369),(33344,'义和乡','221',2369),(33345,'水口乡','222',2369),(33346,'三板乡','223',2369),(33347,'巨光乡','224',2369),(33348,'蔡合乡','225',2369),(33349,'鹤林乡','226',2369),(33350,'白兔乡','227',2369),(33351,'青丝乡','228',2369),(33352,'万寿乡','229',2369),(33353,'射洪乡','230',2369),(33354,'望江乡','231',2369),(33355,'和乐乡','232',2369),(33356,'龙凤乡','233',2369),(33357,'新市乡','234',2369),(33358,'宋家乡','235',2369),(33359,'拱市乡','236',2369),(33360,'中滩乡','237',2369),(33361,'屏西乡','238',2369),(33362,'定远乡','239',2369),(33363,'嘉禾乡','240',2369),(33364,'李渡乡','241',2369),(33365,'望溪乡','242',2369),(33366,'双土乡','243',2369),(33367,'卷硐乡','244',2369),(33368,'太平镇','100',2370),(33369,'青花镇','101',2370),(33370,'旧院镇','102',2370),(33371,'罗文镇','103',2370),(33372,'河口镇','104',2370),(33373,'草坝镇','105',2370),(33374,'竹峪镇','106',2370),(33375,'大竹镇','107',2370),(33376,'黄钟镇','108',2370),(33377,'官渡镇','109',2370),(33378,'沙镇','110',2370),(33379,'沙滩镇','111',2370),(33380,'茶垭乡','200',2370),(33381,'长石乡','201',2370),(33382,'白羊乡','202',2370),(33383,'铁矿乡','203',2370),(33384,'固军乡','204',2370),(33385,'井溪乡','205',2370),(33386,'堰塘乡','206',2370),(33387,'蜂桶乡','207',2370),(33388,'花楼乡','208',2370),(33389,'长坝乡','209',2370),(33390,'曾家乡','210',2370),(33391,'大沙乡','211',2370),(33392,'秦河乡','212',2370),(33393,'庙垭乡','213',2370),(33394,'鹰背乡','214',2370),(33395,'石窝乡','215',2370),(33396,'玉带乡','216',2370),(33397,'新店乡','217',2370),(33398,'魏家乡','218',2370),(33399,'柳黄乡','219',2370),(33400,'溪口乡','220',2370),(33401,'永宁乡','221',2370),(33402,'虹桥乡','222',2370),(33403,'康乐乡','223',2370),(33404,'白果乡','224',2370),(33405,'钟亭乡','225',2370),(33406,'庙子乡','226',2370),(33407,'临河乡','227',2370),(33408,'紫溪乡','228',2370),(33409,'庙坡乡','229',2370),(33410,'梨树乡','230',2370),(33411,'皮窝乡','231',2370),(33412,'丝罗乡','232',2370),(33413,'罐坝乡','233',2370),(33414,'石人乡','234',2370),(33415,'赵塘乡','235',2370),(33416,'中坪乡','236',2370),(33417,'八台乡','237',2370),(33418,'花萼乡','238',2370),(33419,'曹家乡','239',2370),(33420,'石塘乡','240',2370),(33421,'东城街道','001',2372),(33422,'西城街道','002',2372),(33423,'河北街道','003',2372),(33424,'青江街道','004',2372),(33425,'北郊镇','100',2372),(33426,'草坝镇','101',2372),(33427,'合江镇','102',2372),(33428,'大兴镇','103',2372),(33429,'对岩镇','104',2372),(33430,'沙坪镇','105',2372),(33431,'中里镇','106',2372),(33432,'上里镇','107',2372),(33433,'严桥镇','108',2372),(33434,'晏场镇','109',2372),(33435,'多营镇','110',2372),(33436,'碧峰峡镇','111',2372),(33437,'南郊乡','200',2372),(33438,'八步乡','201',2372),(33439,'观化乡','202',2372),(33440,'孔坪乡','203',2372),(33441,'凤鸣乡','204',2372),(33442,'望鱼乡','205',2372),(33443,'蒙阳镇','100',2373),(33444,'百丈镇','101',2373),(33445,'车岭镇','102',2373),(33446,'永兴镇','103',2373),(33447,'马岭镇','104',2373),(33448,'新店镇','105',2373),(33449,'蒙顶山镇','106',2373),(33450,'黑竹镇','107',2373),(33451,'红星镇','108',2373),(33452,'城东乡','200',2373),(33453,'前进乡','201',2373),(33454,'中峰乡','202',2373),(33455,'联江乡','203',2373),(33456,'廖场乡','204',2373),(33457,'万古乡','205',2373),(33458,'红岩乡','206',2373),(33459,'双河乡','207',2373),(33460,'建山乡','208',2373),(33461,'解放乡','209',2373),(33462,'茅河乡','210',2373),(33463,'严道镇','100',2374),(33464,'花滩镇','101',2374),(33465,'六合乡','200',2374),(33466,'烈太乡','201',2374),(33467,'安靖乡','202',2374),(33468,'民建乡','203',2374),(33469,'烈士乡','204',2374),(33470,'荥河乡','205',2374),(33471,'新建乡','206',2374),(33472,'泗坪乡','207',2374),(33473,'新庙乡','208',2374),(33474,'三合乡','209',2374),(33475,'大田坝乡','210',2374),(33476,'天凤乡','211',2374),(33477,'宝峰乡','212',2374),(33478,'新添乡','213',2374),(33479,'附城乡','214',2374),(33480,'五宪乡','215',2374),(33481,'烟竹乡','216',2374),(33482,'青龙乡','217',2374),(33483,'龙苍沟乡','218',2374),(33484,'富林镇','100',2375),(33485,'九襄镇','101',2375),(33486,'乌斯河镇','102',2375),(33487,'宜东镇','103',2375),(33488,'富庄镇','104',2375),(33489,'清溪镇','105',2375),(33490,'大树镇','106',2375),(33491,'皇木镇','107',2375),(33492,'大田乡','200',2375),(33493,'唐家乡','201',2375),(33494,'富春乡','202',2375),(33495,'河西乡','203',2375),(33496,'大岭乡','204',2375),(33497,'前域乡','205',2375),(33498,'后域乡','206',2375),(33499,'大堰乡','207',2375),(33500,'两河乡','208',2375),(33501,'富乡乡','209',2375),(33502,'梨园乡','210',2375),(33503,'三交乡','211',2375),(33504,'双溪乡','212',2375),(33505,'西溪乡','213',2375),(33506,'建黎乡','214',2375),(33507,'市荣乡','215',2375),(33508,'富泉乡','216',2375),(33509,'万工乡','217',2375),(33510,'安乐乡','218',2375),(33511,'万里乡','219',2375),(33512,'马烈乡','220',2375),(33513,'白岩乡','221',2375),(33514,'青富乡','222',2375),(33515,'桂贤乡','223',2375),(33516,'河南乡','224',2375),(33517,'晒经乡','225',2375),(33518,'料林乡','226',2375),(33519,'小堡藏族彝族乡','227',2375),(33520,'片马彝族乡','228',2375),(33521,'坭美彝族乡','229',2375),(33522,'永利彝族乡','230',2375),(33523,'顺河彝族乡','231',2375),(33524,'棉城街道办事处','001',2376),(33525,'新棉镇','100',2376),(33526,'安顺彝族乡','200',2376),(33527,'先锋藏族乡','201',2376),(33528,'蟹螺藏族乡','202',2376),(33529,'永和乡','203',2376),(33530,'回隆彝族乡','204',2376),(33531,'擦罗彝族乡','205',2376),(33532,'栗子坪彝族乡','206',2376),(33533,'美罗乡','207',2376),(33534,'迎政乡','208',2376),(33535,'宰羊乡','209',2376),(33536,'丰乐乡','210',2376),(33537,'新民藏族彝族乡','211',2376),(33538,'挖角彝族藏族乡','212',2376),(33539,'田湾彝族乡','213',2376),(33540,'草科藏族乡','214',2376),(33541,'城厢镇','100',2377),(33542,'始阳镇','101',2377),(33543,'小河乡','200',2377),(33544,'思经乡','201',2377),(33545,'鱼泉乡','202',2377),(33546,'紫石乡','203',2377),(33547,'两路乡','204',2377),(33548,'大坪乡','205',2377),(33549,'乐英乡','206',2377),(33550,'多功乡','207',2377),(33551,'仁义乡','208',2377),(33552,'老场乡','209',2377),(33553,'新华乡','210',2377),(33554,'新场乡','211',2377),(33555,'兴业乡','212',2377),(33556,'芦阳镇','100',2378),(33557,'飞仙关镇','101',2378),(33558,'双石镇','102',2378),(33559,'太平镇','103',2378),(33560,'大川镇','104',2378),(33561,'思延乡','200',2378),(33562,'清仁乡','201',2378),(33563,'龙门乡','202',2378),(33564,'宝盛乡','203',2378),(33565,'穆坪镇','100',2379),(33566,'灵关镇','101',2379),(33567,'陇东镇','102',2379),(33568,'蜂蛹寨乡','201',2379),(33569,'硗碛乡','202',2379),(33570,'永富乡','203',2379),(33571,'明礼乡','204',2379),(33572,'五龙乡','205',2379),(33573,'大溪乡','206',2379),(33574,'东城街道办事处','001',2381),(33575,'西城街道办事处','002',2381),(33576,'回风街道办事处','003',2381),(33577,'江北街道办事处','004',2381),(33578,'巴州镇','100',2381),(33579,'清江镇','101',2381),(33580,'兴文镇','102',2381),(33581,'水宁寺镇','103',2381),(33582,'化成镇','104',2381),(33583,'曾口镇','105',2381),(33584,'梁永镇','106',2381),(33585,'三江镇','107',2381),(33586,'鼎山镇','108',2381),(33587,'大罗镇','109',2381),(33588,'玉山镇','110',2381),(33589,'恩阳镇','111',2381),(33590,'渔溪镇','112',2381),(33591,'三河场镇','113',2381),(33592,'青木镇','114',2381),(33593,'花丛镇','115',2381),(33594,'柳林镇','116',2381),(33595,'下八庙镇','117',2381),(33596,'茶坝镇','118',2381),(33597,'观音井镇','119',2381),(33598,'三汇镇','120',2381),(33599,'上八庙镇','121',2381),(33600,'枣林镇','122',2381),(33601,'平梁乡','200',2381),(33602,'光辉乡','201',2381),(33603,'花溪乡','202',2381),(33604,'大和乡','203',2381),(33605,'白庙乡','204',2381),(33606,'关渡乡','205',2381),(33607,'凌云乡','206',2381),(33608,'寺岭乡','207',2381),(33609,'梓桐庙乡','208',2381),(33610,'金碑乡','209',2381),(33611,'羊凤乡','210',2381),(33612,'凤溪乡','211',2381),(33613,'龙背乡','212',2381),(33614,'三星乡','213',2381),(33615,'关公乡','214',2381),(33616,'舞凤乡','215',2381),(33617,'兴隆场乡','216',2381),(33618,'石城乡','217',2381),(33619,'九镇乡','218',2381),(33620,'尹家乡','219',2381),(33621,'双胜乡','220',2381),(33622,'群乐乡','221',2381),(33623,'万安乡','222',2381),(33624,'玉井乡','223',2381),(33625,'义兴乡','224',2381),(33626,'诺江镇','100',2382),(33627,'民胜镇','101',2382),(33628,'火炬镇','102',2382),(33629,'广纳镇','103',2382),(33630,'铁佛镇','104',2382),(33631,'麻石镇','105',2382),(33632,'至诚镇','106',2382),(33633,'洪口镇','107',2382),(33634,'沙溪镇','108',2382),(33635,'瓦室镇','109',2382),(33636,'永安镇','110',2382),(33637,'铁溪镇','111',2382),(33638,'涪阳镇','112',2382),(33639,'诺水河镇','113',2382),(33640,'杨柏乡','200',2382),(33641,'大兴乡','201',2382),(33642,'东山乡','202',2382),(33643,'三溪乡','203',2382),(33644,'双泉乡','204',2382),(33645,'文峰乡','205',2382),(33646,'春在乡','206',2382),(33647,'三合乡','207',2382),(33648,'云昙乡','208',2382),(33649,'唱歌乡','209',2382),(33650,'芝苞乡','210',2382),(33651,'龙凤场乡','211',2382),(33652,'董溪乡','212',2382),(33653,'澌波乡','213',2382),(33654,'松溪乡','214',2382),(33655,'九层乡','215',2382),(33656,'胜利乡','216',2382),(33657,'板凳乡','217',2382),(33658,'文胜乡','218',2382),(33659,'兴隆乡','219',2382),(33660,'毛裕乡','220',2382),(33661,'泥溪乡','221',2382),(33662,'烟溪乡','222',2382),(33663,'沙坪乡','223',2382),(33664,'朱元乡','224',2382),(33665,'长坪乡','225',2382),(33666,'两河口乡','226',2382),(33667,'空山乡','227',2382),(33668,'青浴乡','228',2382),(33669,'板桥口乡','229',2382),(33670,'铁厂乡','230',2382),(33671,'新场乡','231',2382),(33672,'陈河乡','232',2382),(33673,'草池乡','233',2382),(33674,'回林乡','234',2382),(33675,'南江镇','100',2383),(33676,'沙河镇','101',2383),(33677,'乐坝镇','102',2383),(33678,'长赤镇','103',2383),(33679,'正直镇','104',2383),(33680,'大河镇','105',2383),(33681,'光雾山镇','106',2383),(33682,'东榆镇','107',2383),(33683,'下两镇','108',2383),(33684,'赶场镇','109',2383),(33685,'杨坝镇','110',2383),(33686,'赤溪乡','200',2383),(33687,'燕山乡','201',2383),(33688,'八庙乡','202',2383),(33689,'高塔乡','203',2383),(33690,'团结乡','204',2383),(33691,'红光乡','205',2383),(33692,'傅家乡','206',2383),(33693,'红四乡','207',2383),(33694,'天池乡','208',2383),(33695,'侯家乡','209',2383),(33696,'双桂乡','210',2383),(33697,'凤仪乡','211',2383),(33698,'朱公乡','212',2383),(33699,'黑潭乡','213',2383),(33700,'和平乡','214',2383),(33701,'双流乡','215',2383),(33702,'元潭乡','216',2383),(33703,'高桥乡','217',2383),(33704,'平岗乡','218',2383),(33705,'仁和乡','219',2383),(33706,'石滩乡','220',2383),(33707,'关门乡','221',2383),(33708,'兴马乡','222',2383),(33709,'北极乡','223',2383),(33710,'关路乡','224',2383),(33711,'关田乡','225',2383),(33712,'红岩乡','226',2383),(33713,'桥亭乡','227',2383),(33714,'贵民乡','228',2383),(33715,'沙坝乡','229',2383),(33716,'柳湾乡','230',2383),(33717,'汇滩乡','231',2383),(33718,'上两乡','232',2383),(33719,'关坝乡','233',2383),(33720,'寨坡乡','234',2383),(33721,'坪河乡','235',2383),(33722,'流坝乡','236',2383),(33723,'江口镇','100',2384),(33724,'响滩镇','101',2384),(33725,'西兴镇','102',2384),(33726,'佛楼镇','103',2384),(33727,'白衣镇','104',2384),(33728,'涵水镇','105',2384),(33729,'岳家镇','106',2384),(33730,'兰草镇','107',2384),(33731,'驷马镇','108',2384),(33732,'坦溪镇','109',2384),(33733,'元山镇','110',2384),(33734,'云台镇','111',2384),(33735,'邱家镇','112',2384),(33736,'笔山镇','113',2384),(33737,'镇龙镇','114',2384),(33738,'得胜镇','115',2384),(33739,'鹿鸣镇','116',2384),(33740,'青云乡','200',2384),(33741,'元石乡','201',2384),(33742,'六门乡','202',2384),(33743,'大寨乡','203',2384),(33744,'龙岗乡','204',2384),(33745,'土兴乡','205',2384),(33746,'板庙乡','206',2384),(33747,'泥龙乡','207',2384),(33748,'岩口乡','208',2384),(33749,'望京乡','209',2384),(33750,'喜神乡','210',2384),(33751,'土垭乡','211',2384),(33752,'石垭乡','212',2384),(33753,'青凤乡','213',2384),(33754,'澌岸乡','214',2384),(33755,'马鞍乡','215',2384),(33756,'五木乡','216',2384),(33757,'灵山乡','217',2384),(33758,'界牌乡','218',2384),(33759,'粉壁乡','219',2384),(33760,'澌滩乡','220',2384),(33761,'高峰乡','221',2384),(33762,'南风乡','222',2384),(33763,'福申乡','223',2384),(33764,'双鹿乡','224',2384),(33765,'黑水乡','225',2384),(33766,'莲花办街道事处','001',2386),(33767,'三贤祠街道办事处','002',2386),(33768,'资溪街道办事处','003',2386),(33769,'狮子山街道办事处','004',2386),(33770,'雁江镇','100',2386),(33771,'松涛镇','101',2386),(33772,'宝台镇','102',2386),(33773,'临江镇','103',2386),(33774,'保和镇','104',2386),(33775,'老君镇','105',2386),(33776,'中和镇','106',2386),(33777,'丹山镇','107',2386),(33778,'小院镇','108',2386),(33779,'堪嘉镇','109',2386),(33780,'伍隍镇','110',2386),(33781,'石岭镇','111',2386),(33782,'东峰镇','112',2386),(33783,'南津镇','113',2386),(33784,'忠义镇','114',2386),(33785,'碑记镇','115',2386),(33786,'丰裕镇','116',2386),(33787,'迎接镇','117',2386),(33788,'祥符镇','118',2386),(33789,'新场乡','200',2386),(33790,'回龙乡','201',2386),(33791,'清水乡','202',2386),(33792,'四川大堰劳动教养管理所','400',2386),(33793,'岳阳镇','100',2387),(33794,'鸳大镇','101',2387),(33795,'石桥铺镇','102',2387),(33796,'通贤镇','103',2387),(33797,'龙台镇','104',2387),(33798,'姚市镇','105',2387),(33799,'林凤镇','106',2387),(33800,'毛家镇','107',2387),(33801,'永清镇','108',2387),(33802,'永顺镇','109',2387),(33803,'石羊镇','110',2387),(33804,'两板桥镇','111',2387),(33805,'护龙镇','112',2387),(33806,'李家镇','113',2387),(33807,'元坝镇','114',2387),(33808,'兴隆镇','115',2387),(33809,'天林镇','116',2387),(33810,'镇子镇','117',2387),(33811,'文化镇','118',2387),(33812,'周礼镇','119',2387),(33813,'驯龙镇','120',2387),(33814,'华严镇','121',2387),(33815,'城北乡','200',2387),(33816,'城西乡','201',2387),(33817,'思贤乡','202',2387),(33818,'石鼓乡','203',2387),(33819,'八庙乡','204',2387),(33820,'来凤乡','205',2387),(33821,'天马乡','206',2387),(33822,'人和乡','207',2387),(33823,'长河碥乡','208',2387),(33824,'团结乡','209',2387),(33825,'悦来乡','210',2387),(33826,'白水乡','211',2387),(33827,'云峰乡','212',2387),(33828,'岳新乡','213',2387),(33829,'偏岩乡','214',2387),(33830,'东胜乡','215',2387),(33831,'坪河乡','216',2387),(33832,'乾龙乡','217',2387),(33833,'高升乡','218',2387),(33834,'横庙乡','219',2387),(33835,'瑞云乡','220',2387),(33836,'白塔寺乡','221',2387),(33837,'双龙街乡','222',2387),(33838,'顶新乡','223',2387),(33839,'和平乡','224',2387),(33840,'高屋乡','225',2387),(33841,'忠义乡','226',2387),(33842,'合义乡','227',2387),(33843,'努力乡','228',2387),(33844,'护建乡','229',2387),(33845,'清流乡','230',2387),(33846,'共和乡','231',2387),(33847,'天宝乡','232',2387),(33848,'协和乡','233',2387),(33849,'鱼龙乡','234',2387),(33850,'建华乡','235',2387),(33851,'大平乡','236',2387),(33852,'九龙乡','237',2387),(33853,'岳源乡','238',2387),(33854,'龙桥乡','239',2387),(33855,'千佛乡','240',2387),(33856,'拱桥乡','241',2387),(33857,'宝华乡','242',2387),(33858,'南薰乡','243',2387),(33859,'自治乡','244',2387),(33860,'大埝乡','245',2387),(33861,'朝阳乡','246',2387),(33862,'天池镇','100',2388),(33863,'石佛镇','101',2388),(33864,'回澜镇','102',2388),(33865,'石湍镇','103',2388),(33866,'童家镇','104',2388),(33867,'宝林镇','105',2388),(33868,'大佛镇','106',2388),(33869,'良安镇','107',2388),(33870,'金顺镇','108',2388),(33871,'中和场镇','109',2388),(33872,'劳动镇','110',2388),(33873,'中天镇','111',2388),(33874,'佛星镇','112',2388),(33875,'蟠龙镇','113',2388),(33876,'东山镇','114',2388),(33877,'通旅镇','115',2388),(33878,'高寺镇','116',2388),(33879,'龙溪乡','200',2388),(33880,'全胜乡','201',2388),(33881,'孔雀乡','202',2388),(33882,'龙门乡','203',2388),(33883,'双河场乡','204',2388),(33884,'放生乡','205',2388),(33885,'盛池乡','206',2388),(33886,'凉水乡','207',2388),(33887,'简城镇','100',2389),(33888,'石桥镇','101',2389),(33889,'新市镇','102',2389),(33890,'石盘镇','103',2389),(33891,'东溪镇','104',2389),(33892,'平泉镇','105',2389),(33893,'禾丰镇','106',2389),(33894,'云龙镇','107',2389),(33895,'三星镇','108',2389),(33896,'养马镇','109',2389),(33897,'贾家镇','110',2389),(33898,'石板凳镇','111',2389),(33899,'三岔镇','112',2389),(33900,'镇金镇','113',2389),(33901,'石钟镇','114',2389),(33902,'施家镇','115',2389),(33903,'三合镇','116',2389),(33904,'平武镇','117',2389),(33905,'金马镇','118',2389),(33906,'踏水镇','119',2389),(33907,'江源镇','120',2389),(33908,'涌泉镇','121',2389),(33909,'芦葭镇','122',2389),(33910,'草池镇','123',2389),(33911,'太平桥镇','124',2389),(33912,'青龙镇','125',2389),(33913,'老君井乡','200',2389),(33914,'福田乡','201',2389),(33915,'宏缘乡','202',2389),(33916,'周家乡','203',2389),(33917,'平窝乡','204',2389),(33918,'武庙乡','205',2389),(33919,'高明乡','206',2389),(33920,'玉成乡','207',2389),(33921,'丹景乡','208',2389),(33922,'望水乡','209',2389),(33923,'清风乡','210',2389),(33924,'董家埂乡','211',2389),(33925,'五星乡','212',2389),(33926,'飞龙乡','213',2389),(33927,'灵仙乡','214',2389),(33928,'五指乡','215',2389),(33929,'新民乡','216',2389),(33930,'新星乡','217',2389),(33931,'同合乡','218',2389),(33932,'老龙乡','219',2389),(33933,'壮溪乡','220',2389),(33934,'海螺乡','221',2389),(33935,'坛罐乡','222',2389),(33936,'雷家乡','223',2389),(33937,'安乐乡','224',2389),(33938,'普安乡','225',2389),(33939,'平息乡','226',2389),(33940,'五合乡','227',2389),(33941,'永宁乡','228',2389),(33942,'威州镇','100',2390),(33943,'绵','101',2390),(33944,'映秀镇','102',2390),(33945,'卧龙镇','103',2390),(33946,'水磨镇','105',2390),(33947,'漩口镇','106',2390),(33948,'龙溪乡','200',2390),(33949,'克枯乡','201',2390),(33950,'雁门乡','202',2390),(33951,'草坡乡','203',2390),(33952,'银杏乡','204',2390),(33953,'耿达乡','205',2390),(33954,'三江乡','207',2390),(33955,'杂谷脑镇','100',2391),(33956,'米亚罗镇','101',2391),(33957,'古尔沟镇','102',2391),(33958,'薛城镇','103',2391),(33959,'夹壁乡','200',2391),(33960,'朴头乡','201',2391),(33961,'甘堡乡','202',2391),(33962,'蒲溪乡','203',2391),(33963,'上孟乡','204',2391),(33964,'下孟乡','205',2391),(33965,'木卡乡','206',2391),(33966,'通化乡','207',2391),(33967,'桃坪乡','208',2391),(33968,'凤仪镇','100',2392),(33969,'南新镇','101',2392),(33970,'叠溪镇','102',2392),(33971,'渭门乡','201',2392),(33972,'永和乡','202',2392),(33973,'沟口乡','203',2392),(33974,'光明乡','204',2392),(33975,'富顺乡','205',2392),(33976,'土门乡','206',2392),(33977,'东兴乡','207',2392),(33978,'黑虎乡','208',2392),(33979,'飞虹乡','209',2392),(33980,'回龙乡','210',2392),(33981,'三龙乡','211',2392),(33982,'白溪乡','212',2392),(33983,'洼底乡','213',2392),(33984,'石大关乡','214',2392),(33985,'太平乡','215',2392),(33986,'松坪沟乡','216',2392),(33987,'曲谷乡','217',2392),(33988,'雅都乡','218',2392),(33989,'维城乡','219',2392),(33990,'进安镇','100',2393),(33991,'川主寺镇','101',2393),(33992,'进安回族乡','200',2393),(33993,'十里回族乡','201',2393),(33994,'青云乡','202',2393),(33995,'安宏乡','203',2393),(33996,'大寨乡','204',2393),(33997,'牟尼乡','205',2393),(33998,'镇江关乡','206',2393),(33999,'镇坪乡','207',2393),(34000,'岷江乡','208',2393),(34001,'大姓乡','209',2393),(34002,'白羊乡','210',2393),(34003,'红土乡','211',2393),(34004,'红扎乡','212',2393),(34005,'小姓乡','213',2393),(34006,'燕云乡','214',2393),(34007,'山巴乡','215',2393),(34008,'水晶乡','216',2393),(34009,'小河乡','217',2393),(34010,'施家堡乡','218',2393),(34011,'黄龙乡','219',2393),(34012,'上八寨乡','220',2393),(34013,'下八寨乡','221',2393),(34014,'草原乡','222',2393),(34015,'国营牧场','400',2393),(34016,'松潘林业局','401',2393),(34017,'永乐镇','100',2394),(34018,'漳扎镇','101',2394),(34019,'永丰乡','200',2394),(34020,'永和乡','201',2394),(34021,'安乐乡','202',2394),(34022,'白河乡','203',2394),(34023,'双河乡','204',2394),(34024,'保华乡府','205',2394),(34025,'罗依乡','206',2394),(34026,'勿角乡','207',2394),(34027,'马家乡','208',2394),(34028,'郭元乡','209',2394),(34029,'草地乡','210',2394),(34030,'陵江乡','211',2394),(34031,'黑河乡','212',2394),(34032,'玉瓦乡','213',2394),(34033,'大录乡','214',2394),(34034,'大录九寨沟县国营牧场','400',2394),(34035,'金川镇','100',2395),(34036,'观音桥镇','101',2395),(34037,'沙耳乡','200',2395),(34038,'庆宁乡','201',2395),(34039,'咯尔乡','202',2395),(34040,'勒乌乡','203',2395),(34041,'万林乡','204',2395),(34042,'河东乡','205',2395),(34043,'河西乡','206',2395),(34044,'集沐乡','207',2395),(34045,'撒瓦脚乡','208',2395),(34046,'卡拉足乡','209',2395),(34047,'俄热乡','210',2395),(34048,'太阳河乡','211',2395),(34049,'二嘎里乡','212',2395),(34050,'阿科里乡','213',2395),(34051,'安宁乡','214',2395),(34052,'卡撒乡','215',2395),(34053,'曾达乡','216',2395),(34054,'独松乡','217',2395),(34055,'马尔邦乡','218',2395),(34056,'马奈乡','219',2395),(34057,'毛日乡','220',2395),(34058,'美兴镇','100',2396),(34059,'日隆镇','101',2396),(34060,'老营乡','200',2396),(34061,'崇德乡','201',2396),(34062,'新桥乡','202',2396),(34063,'美沃乡','203',2396),(34064,'沙龙乡','204',2396),(34065,'宅垄乡','205',2396),(34066,'新格乡','206',2396),(34067,'达维乡','207',2396),(34068,'日尔乡','208',2396),(34069,'结斯乡','209',2396),(34070,'沃日乡','210',2396),(34071,'木坡乡','211',2396),(34072,'两河乡','212',2396),(34073,'抚边乡','213',2396),(34074,'八角乡','214',2396),(34075,'双柏乡','215',2396),(34076,'窝底乡','216',2396),(34077,'汗牛乡','217',2396),(34078,'潘安乡','218',2396),(34079,'芦花镇','100',2397),(34080,'卡龙镇','101',2397),(34081,'沙石多乡','200',2397),(34082,'红岩乡','201',2397),(34083,'麻窝乡','202',2397),(34084,'双溜索乡','203',2397),(34085,'瓦钵梁子乡','204',2397),(34086,'色尔古乡','205',2397),(34087,'石碉楼乡','206',2397),(34088,'龙坝乡','207',2397),(34089,'洛多乡','208',2397),(34090,'木苏乡','209',2397),(34091,'维古乡','210',2397),(34092,'知木林乡','211',2397),(34093,'扎窝乡','212',2397),(34094,'晴朗乡','213',2397),(34095,'慈坝乡','214',2397),(34096,'马尔康镇','100',2398),(34097,'卓克基镇','101',2398),(34098,'松岗镇','102',2398),(34099,'梭磨乡','200',2398),(34100,'白湾乡','201',2398),(34101,'党坝乡','202',2398),(34102,'木尔宗乡','203',2398),(34103,'脚木足乡','204',2398),(34104,'沙尔宗乡','205',2398),(34105,'龙尔甲乡','206',2398),(34106,'大藏乡','207',2398),(34107,'康山乡','208',2398),(34108,'草登乡','209',2398),(34109,'日部乡','210',2398),(34110,'马尔康县国营牧场','400',2398),(34111,'壤柯镇','100',2399),(34112,'蒲西乡','200',2399),(34113,'宗科乡','201',2399),(34114,'石里乡','202',2399),(34115,'吾依乡','203',2399),(34116,'岗木达乡','204',2399),(34117,'上杜柯乡','205',2399),(34118,'茸木达乡','206',2399),(34119,'南木达乡','207',2399),(34120,'尕多乡','208',2399),(34121,'中壤塘乡','209',2399),(34122,'上壤塘乡','210',2399),(34123,'阿坝镇','100',2400),(34124,'哇尔玛乡','200',2400),(34125,'麦昆乡','201',2400),(34126,'河支乡','202',2400),(34127,'龙藏乡','203',2400),(34128,'求吉玛乡','204',2400),(34129,'甲尔多乡','205',2400),(34130,'各莫乡','206',2400),(34131,'德格乡','207',2400),(34132,'四洼乡','208',2400),(34133,'安斗乡','209',2400),(34134,'柯河乡','210',2400),(34135,'垮沙乡','211',2400),(34136,'安羌乡','212',2400),(34137,'查理乡','213',2400),(34138,'茸安乡','214',2400),(34139,'洛尔达乡','215',2400),(34140,'麦尔玛乡','216',2400),(34141,'贾洛乡','217',2400),(34142,'若柯河农场','400',2400),(34143,'贾柯河牧场','401',2400),(34144,'达扎寺镇','100',2401),(34145,'班佑乡','200',2401),(34146,'阿西乡','201',2401),(34147,'唐克乡','202',2401),(34148,'辖曼乡','203',2401),(34149,'红星乡','204',2401),(34150,'麦溪乡','205',2401),(34151,'嫩哇乡','206',2401),(34152,'冻列乡','207',2401),(34153,'崇尔乡','208',2401),(34154,'热尔乡','209',2401),(34155,'占哇乡','210',2401),(34156,'降扎乡','211',2401),(34157,'巴西乡','212',2401),(34158,'阿西茸乡','213',2401),(34159,'求吉乡','214',2401),(34160,'包座乡','215',2401),(34161,'白河牧场','400',2401),(34162,'若尔盖县辖曼牧场','401',2401),(34163,'若尔盖县黑河牧场','402',2401),(34164,'邛溪镇','100',2402),(34165,'刷经寺镇','101',2402),(34166,'安曲乡','200',2402),(34167,'龙日乡','201',2402),(34168,'江茸乡','202',2402),(34169,'查尔玛乡','203',2402),(34170,'瓦切乡','204',2402),(34171,'阿木乡','205',2402),(34172,'壤口乡','206',2402),(34173,'麦洼乡','207',2402),(34174,'色地乡','208',2402),(34175,'炉城镇','100',2403),(34176,'姑咱镇','101',2403),(34177,'新都桥镇','102',2403),(34178,'雅拉乡','201',2403),(34179,'时济乡','202',2403),(34180,'前溪乡','203',2403),(34181,'舍联乡','204',2403),(34182,'麦崩乡','205',2403),(34183,'三合乡','206',2403),(34184,'金汤乡','207',2403),(34185,'捧塔乡','208',2403),(34186,'沙德乡','209',2403),(34187,'贡嘎山乡','210',2403),(34188,'普沙绒乡','211',2403),(34189,'吉居乡','212',2403),(34190,'瓦泽乡','213',2403),(34191,'呷巴乡','214',2403),(34192,'甲根坝乡','215',2403),(34193,'朋布西乡','216',2403),(34194,'塔公乡','217',2403),(34195,'孔玉乡','218',2403),(34196,'泸桥镇','100',2404),(34197,'冷碛镇','101',2404),(34198,'兴隆镇','102',2404),(34199,'磨西镇','103',2404),(34200,'岚安乡','200',2404),(34201,'烹坝乡','201',2404),(34202,'田坝乡','202',2404),(34203,'杵坭乡','203',2404),(34204,'加郡乡','204',2404),(34205,'德威乡','205',2404),(34206,'新兴乡','206',2404),(34207,'得妥乡','207',2404),(34208,'章谷镇','100',2405),(34209,'巴底乡','200',2405),(34210,'巴旺乡','201',2405),(34211,'聂呷乡','202',2405),(34212,'革什扎乡','203',2405),(34213,'边耳乡','204',2405),(34214,'丹东乡','205',2405),(34215,'东谷乡','206',2405),(34216,'水子乡','207',2405),(34217,'格宗乡','208',2405),(34218,'梭坡乡','209',2405),(34219,'中路乡','210',2405),(34220,'岳扎乡','211',2405),(34221,'半扇门乡','212',2405),(34222,'太平桥乡','213',2405),(34223,'呷尔镇','100',2406),(34224,'汤古乡','200',2406),(34225,'斜卡乡','201',2406),(34226,'三岩龙乡','202',2406),(34227,'上团乡','203',2406),(34228,'八窝龙乡','204',2406),(34229,'乃渠乡','205',2406),(34230,'乌拉溪乡','206',2406),(34231,'烟袋乡','207',2406),(34232,'魁多乡','208',2406),(34233,'子耳彝族乡','209',2406),(34234,'三垭彝族乡','210',2406),(34235,'俄尔彝族乡','211',2406),(34236,'小金彝族乡','212',2406),(34237,'朵洛彝族乡','213',2406),(34238,'踏卡彝族乡','214',2406),(34239,'湾坝彝族乡','215',2406),(34240,'洪坝乡','216',2406),(34241,'河口镇','100',2407),(34242,'呷拉乡','200',2407),(34243,'八角楼乡','201',2407),(34244,'普巴绒乡','202',2407),(34245,'祝桑乡','203',2407),(34246,'米龙乡','204',2407),(34247,'八衣绒乡','205',2407),(34248,'波斯河乡','206',2407),(34249,'恶古乡','207',2407),(34250,'牙衣河乡','208',2407),(34251,'西俄洛乡','209',2407),(34252,'麻郎错乡','210',2407),(34253,'德差乡','211',2407),(34254,'红龙乡','212',2407),(34255,'柯拉乡','213',2407),(34256,'瓦多乡','214',2407),(34257,'木绒乡','215',2407),(34258,'鲜水镇','100',2408),(34259,'八美镇','101',2408),(34260,'格西乡','200',2408),(34261,'麻孜乡','201',2408),(34262,'孔色乡','202',2408),(34263,'葛卡乡','203',2408),(34264,'亚卓乡','204',2408),(34265,'仲尼乡','205',2408),(34266,'红顶乡','206',2408),(34267,'扎拖乡','207',2408),(34268,'下拖乡','208',2408),(34269,'瓦日乡','209',2408),(34270,'木茹乡','210',2408),(34271,'甲斯孔乡','211',2408),(34272,'甲宗乡','212',2408),(34273,'七美乡','213',2408),(34274,'银恩乡','214',2408),(34275,'维它乡','215',2408),(34276,'龙灯乡','216',2408),(34277,'协德乡','217',2408),(34278,'色卡乡','218',2408),(34279,'沙冲乡','219',2408),(34280,'新都镇','100',2409),(34281,'泥巴乡','200',2409),(34282,'雅德乡','201',2409),(34283,'洛秋乡','202',2409),(34284,'斯木乡','203',2409),(34285,'宜木乡','204',2409),(34286,'仁达乡','205',2409),(34287,'朱倭乡','206',2409),(34288,'旦都乡','207',2409),(34289,'充古乡','208',2409),(34290,'更知乡','209',2409),(34291,'卡娘乡','210',2409),(34292,'宗塔乡','211',2409),(34293,'宗麦乡','212',2409),(34294,'上罗柯马乡','213',2409),(34295,'下罗柯马乡','214',2409),(34296,'甘孜镇','100',2410),(34297,'呷拉乡','200',2410),(34298,'色西底乡','201',2410),(34299,'南多乡','202',2410),(34300,'生康乡','203',2410),(34301,'贡隆乡','204',2410),(34302,'扎科乡','205',2410),(34303,'来马乡','206',2410),(34304,'昔色乡','207',2410),(34305,'卡攻乡','208',2410),(34306,'仁果乡','209',2410),(34307,'拖坝乡','210',2410),(34308,'斯俄乡','211',2410),(34309,'庭卡乡','212',2410),(34310,'下雄乡','213',2410),(34311,'四通达乡','214',2410),(34312,'夺多乡','215',2410),(34313,'泥柯乡','216',2410),(34314,'茶扎乡','217',2410),(34315,'大德乡','218',2410),(34316,'卡龙乡','219',2410),(34317,'查龙乡','220',2410),(34318,'如龙镇','100',2411),(34319,'沙堆乡','200',2411),(34320,'乐安乡','201',2411),(34321,'大盖乡','202',2411),(34322,'绕鲁乡','203',2411),(34323,'色威乡','204',2411),(34324,'甲拉西乡','205',2411),(34325,'拉日马乡','206',2411),(34326,'博美乡','207',2411),(34327,'尤拉西乡','208',2411),(34328,'子拖西乡','209',2411),(34329,'和平乡','210',2411),(34330,'洛古乡','211',2411),(34331,'雄龙西乡','212',2411),(34332,'麻日乡','213',2411),(34333,'通宵乡','214',2411),(34334,'友谊乡','215',2411),(34335,'皮擦乡','216',2411),(34336,'银多乡','217',2411),(34337,'更庆镇','100',2412),(34338,'达马乡','200',2412),(34339,'普马乡','201',2412),(34340,'岳巴乡','202',2412),(34341,'八帮乡','203',2412),(34342,'龚垭乡','204',2412),(34343,'白垭乡','205',2412),(34344,'汪布顶乡','206',2412),(34345,'柯洛洞乡','207',2412),(34346,'卡松渡乡','208',2412),(34347,'俄南乡','209',2412),(34348,'竹庆乡','210',2412),(34349,'俄支乡','211',2412),(34350,'马尼干戈乡','212',2412),(34351,'玉隆乡','213',2412),(34352,'错阿乡','214',2412),(34353,'中扎科乡','215',2412),(34354,'然姑乡','216',2412),(34355,'窝公乡','217',2412),(34356,'温拖乡','218',2412),(34357,'年古乡','219',2412),(34358,'浪多乡','220',2412),(34359,'阿须乡','221',2412),(34360,'打滚乡','222',2412),(34361,'亚丁乡','223',2412),(34362,'所巴乡','224',2412),(34363,'建设镇','100',2413),(34364,'金沙乡','200',2413),(34365,'绒盖乡','201',2413),(34366,'章都乡','202',2413),(34367,'麻绒乡','203',2413),(34368,'河坡乡','204',2413),(34369,'热加乡','205',2413),(34370,'登龙乡','206',2413),(34371,'赠科乡','207',2413),(34372,'阿察乡','208',2413),(34373,'麻邛乡','209',2413),(34374,'辽西乡','210',2413),(34375,'纳塔乡','211',2413),(34376,'安孜乡','212',2413),(34377,'盖玉乡','213',2413),(34378,'沙马乡','214',2413),(34379,'山岩乡','215',2413),(34380,'尼呷镇','100',2414),(34381,'洛须镇','101',2414),(34382,'真达乡','200',2414),(34383,'奔达乡','201',2414),(34384,'正科乡','202',2414),(34385,'麻呷乡','203',2414),(34386,'德荣马乡','204',2414),(34387,'俄多马乡','205',2414),(34388,'长沙贡马乡','206',2414),(34389,'呷衣乡','207',2414),(34390,'格孟乡','208',2414),(34391,'蒙宜乡','209',2414),(34392,'新荣乡','210',2414),(34393,'宜牛乡','211',2414),(34394,'虾扎乡','212',2414),(34395,'起坞乡','213',2414),(34396,'阿日扎乡','214',2414),(34397,'长须贡马乡','215',2414),(34398,'长沙干马乡','216',2414),(34399,'长须干马乡','217',2414),(34400,'温波乡','218',2414),(34401,'瓦须乡','219',2414),(34402,'色柯镇','100',2415),(34403,'翁达镇','101',2415),(34404,'泥朵乡','200',2415),(34405,'克戈乡','201',2415),(34406,'然充乡','202',2415),(34407,'康勒乡','203',2415),(34408,'大章乡','204',2415),(34409,'大则乡','205',2415),(34410,'亚龙乡','206',2415),(34411,'塔子乡','207',2415),(34412,'年龙乡','208',2415),(34413,'洛若乡','209',2415),(34414,'霍西乡','210',2415),(34415,'旭日乡','211',2415),(34416,'杨各乡','212',2415),(34417,'甲学乡','213',2415),(34418,'歌乐沱乡','214',2415),(34419,'高城镇','100',2416),(34420,'君坝乡','200',2416),(34421,'哈依乡','201',2416),(34422,'觉吾乡','202',2416),(34423,'莫坝乡','203',2416),(34424,'亚火乡','204',2416),(34425,'绒坝乡','205',2416),(34426,'呷柯乡','206',2416),(34427,'奔戈乡','207',2416),(34428,'村戈乡','208',2416),(34429,'禾尼乡','209',2416),(34430,'曲登乡','210',2416),(34431,'喇嘛垭乡','211',2416),(34432,'章纳乡','212',2416),(34433,'上木拉乡','213',2416),(34434,'下木拉乡','214',2416),(34435,'中木拉乡','215',2416),(34436,'雄坝乡','216',2416),(34437,'甲洼乡','217',2416),(34438,'藏坝乡','218',2416),(34439,'格木乡','219',2416),(34440,'拉波乡','220',2416),(34441,'麦洼乡','221',2416),(34442,'德巫乡','222',2416),(34443,'夏邛镇','100',2417),(34444,'拉哇乡','200',2417),(34445,'党巴乡','201',2417),(34446,'竹巴龙乡','202',2417),(34447,'中心绒乡','203',2417),(34448,'苏哇龙乡','204',2417),(34449,'昌波乡','205',2417),(34450,'地巫乡','206',2417),(34451,'中咱乡','207',2417),(34452,'亚日贡乡','208',2417),(34453,'波密乡','209',2417),(34454,'莫多乡','210',2417),(34455,'松多乡','211',2417),(34456,'波戈溪乡','212',2417),(34457,'甲英乡','213',2417),(34458,'措拉乡','214',2417),(34459,'茶洛乡','215',2417),(34460,'列衣乡','216',2417),(34461,'德达乡','217',2417),(34462,'香巴拉镇','100',2418),(34463,'尼斯乡','200',2418),(34464,'沙贡乡','201',2418),(34465,'水洼乡','202',2418),(34466,'青德乡','203',2418),(34467,'青麦乡','204',2418),(34468,'然乌乡','205',2418),(34469,'洞松乡','206',2418),(34470,'热打乡','207',2418),(34471,'定波乡','208',2418),(34472,'正斗乡','209',2418),(34473,'白依乡','210',2418),(34474,'金珠镇','100',2419),(34475,'桑堆乡','200',2419),(34476,'省母乡','201',2419),(34477,'傍河乡','202',2419),(34478,'色拉乡','203',2419),(34479,'巨龙乡','204',2419),(34480,'邓波乡','205',2419),(34481,'木拉乡','206',2419),(34482,'赤土乡','207',2419),(34483,'香格里拉乡','208',2419),(34484,'蒙自乡','209',2419),(34485,'各卡乡','210',2419),(34486,'吉呷乡','211',2419),(34487,'俄牙同乡','212',2419),(34488,'松麦镇','100',2420),(34489,'斯闸乡','200',2420),(34490,'徐龙乡','201',2420),(34491,'日龙乡','202',2420),(34492,'曲雅贡乡','203',2420),(34493,'奔都乡','204',2420),(34494,'八日乡','205',2420),(34495,'古学乡','206',2420),(34496,'子庚乡','207',2420),(34497,'?','208',2420),(34498,'白松乡','209',2420),(34499,'茨巫乡','210',2420),(34500,'北城街道办事处','001',2421),(34501,'西城街道办事处','002',2421),(34502,'东城街道办事处','003',2421),(34503,'长安街道办事处','004',2421),(34504,'新村街道办事处','005',2421),(34505,'长宁街道办事处','006',2421),(34506,'马道镇','100',2421),(34507,'礼州镇','101',2421),(34508,'安宁镇','102',2421),(34509,'川兴镇','103',2421),(34510,'黄联关镇','104',2421),(34511,'佑君镇','105',2421),(34512,'太和镇','106',2421),(34513,'安哈镇','107',2421),(34514,'西郊乡','200',2421),(34515,'高枧乡','201',2421),(34516,'小庙乡','202',2421),(34517,'四合乡','203',2421),(34518,'月华乡','204',2421),(34519,'兴胜乡','205',2421),(34520,'琅环乡','206',2421),(34521,'民胜乡','207',2421),(34522,'西乡乡','208',2421),(34523,'樟木箐乡','209',2421),(34524,'响水乡','210',2421),(34525,'开元乡','211',2421),(34526,'大兴乡','212',2421),(34527,'海南乡','213',2421),(34528,'大箐乡','214',2421),(34529,'经久乡','215',2421),(34530,'西溪乡','216',2421),(34531,'黄水乡','217',2421),(34532,'洛古波乡','218',2421),(34533,'裕隆回族乡','219',2421),(34534,'高草回族乡','220',2421),(34535,'中坝乡','221',2421),(34536,'阿七乡','222',2421),(34537,'荞地乡','223',2421),(34538,'磨盘乡','224',2421),(34539,'巴汝乡','225',2421),(34540,'银厂乡','226',2421),(34541,'白马乡','227',2421),(34542,'马鞍山乡','228',2421),(34543,'乔瓦镇','100',2422),(34544,'桃巴乡','200',2422),(34545,'博科乡','201',2422),(34546,'宁朗乡','202',2422),(34547,'依吉乡','203',2422),(34548,'俄亚乡','204',2422),(34549,'水洛乡','205',2422),(34550,'牦牛坪乡','206',2422),(34551,'屋脚乡','207',2422),(34552,'项脚乡','208',2422),(34553,'李子坪乡','209',2422),(34554,'列瓦乡','210',2422),(34555,'芽租乡','211',2422),(34556,'下麦地乡','212',2422),(34557,'西秋乡','213',2422),(34558,'克尔乡','214',2422),(34559,'白碉乡','215',2422),(34560,'三桷桠乡','216',2422),(34561,'倮波乡','217',2422),(34562,'卡拉乡','218',2422),(34563,'后所乡','219',2422),(34564,'沙湾乡','220',2422),(34565,'东子乡','221',2422),(34566,'固增乡','222',2422),(34567,'麦日乡','223',2422),(34568,'东朗乡','224',2422),(34569,'唐央乡','225',2422),(34570,'博窝乡','226',2422),(34571,'麦地龙乡','227',2422),(34572,'盐井镇','100',2423),(34573,'卫城镇','101',2423),(34574,'梅雨镇','102',2423),(34575,'白乌镇','103',2423),(34576,'树河镇','104',2423),(34577,'黄草镇','105',2423),(34578,'平川镇','106',2423),(34579,'泸沽湖镇','107',2423),(34580,'双河乡','200',2423),(34581,'干海乡','201',2423),(34582,'下海乡','202',2423),(34583,'棉桠乡','203',2423),(34584,'甘塘乡','204',2423),(34585,'马鹿乡','205',2423),(34586,'藤桥乡','206',2423),(34587,'田湾乡','207',2423),(34588,'德石乡','208',2423),(34589,'大河乡','209',2423),(34590,'盐塘乡','210',2423),(34591,'巫木乡','211',2423),(34592,'大草乡','212',2423),(34593,'博大乡','213',2423),(34594,'金河乡','214',2423),(34595,'右所乡','215',2423),(34596,'巴折乡','216',2423),(34597,'阿萨乡','217',2423),(34598,'长柏乡','218',2423),(34599,'桃子乡','219',2423),(34600,'盖租乡','220',2423),(34601,'前所乡','221',2423),(34602,'沃底乡','222',2423),(34603,'大坡蒙古族乡','223',2423),(34604,'洼里乡','224',2423),(34605,'梅子坪乡','225',2423),(34606,'德州镇','100',2424),(34607,'永郎镇','101',2424),(34608,'乐跃镇','102',2424),(34609,'麻栗乡','200',2424),(34610,'阿月乡','201',2424),(34611,'王所乡','202',2424),(34612,'六所乡','203',2424),(34613,'巴洞乡','204',2424),(34614,'宽裕乡','205',2424),(34615,'茨达乡','206',2424),(34616,'小高乡','207',2424),(34617,'锦川乡','208',2424),(34618,'老碾乡','209',2424),(34619,'大湾乡','210',2424),(34620,'马安乡','211',2424),(34621,'铁炉乡','212',2424),(34622,'前山乡','213',2424),(34623,'大山乡','214',2424),(34624,'大六槽乡','215',2424),(34625,'热河乡','216',2424),(34626,'南山傈傈族乡','217',2424),(34627,'金沙傈傈族乡','218',2424),(34628,'银鹿乡','219',2424),(34629,'城关镇','100',2425),(34630,'鹿厂镇','101',2425),(34631,'黎溪镇','102',2425),(34632,'通安镇','103',2425),(34633,'太平镇','104',2425),(34634,'益门镇','105',2425),(34635,'果元乡','200',2425),(34636,'南阁乡','201',2425),(34637,'内东乡','202',2425),(34638,'老街乡','203',2425),(34639,'外北乡','204',2425),(34640,'彰冠乡','205',2425),(34641,'爱民乡','206',2425),(34642,'爱国乡','207',2425),(34643,'凤营乡','208',2425),(34644,'白鸡乡','209',2425),(34645,'矮郎乡','210',2425),(34646,'小黑箐乡','211',2425),(34647,'河口乡','212',2425),(34648,'中厂乡','213',2425),(34649,'关河乡','214',2425),(34650,'鱼乍乡','215',2425),(34651,'绿水乡','216',2425),(34652,'黎洪乡','217',2425),(34653,'金雨乡','218',2425),(34654,'树堡乡','219',2425),(34655,'江竹乡','220',2425),(34656,'新安傣族乡','221',2425),(34657,'普隆乡','222',2425),(34658,'竹箐乡','223',2425),(34659,'新发乡','224',2425),(34660,'杨家坝乡','225',2425),(34661,'江普乡','226',2425),(34662,'木古乡','227',2425),(34663,'富乐乡','228',2425),(34664,'海潮乡','229',2425),(34665,'芭蕉乡','230',2425),(34666,'横山乡','231',2425),(34667,'马宗乡','232',2425),(34668,'法坪乡','233',2425),(34669,'槽元乡','234',2425),(34670,'黄柏乡','235',2425),(34671,'云甸乡','236',2425),(34672,'仓田乡','237',2425),(34673,'白果湾乡','238',2425),(34674,'下村乡','239',2425),(34675,'龙泉乡','240',2425),(34676,'六华乡','241',2425),(34677,'三地乡','242',2425),(34678,'六民乡','243',2425),(34679,'会东镇','100',2426),(34680,'铅锌镇','101',2426),(34681,'小岔河乡','200',2426),(34682,'撒者邑乡','201',2426),(34683,'新云乡','202',2426),(34684,'长新乡','203',2426),(34685,'火山乡','204',2426),(34686,'堵格乡','205',2426),(34687,'坪塘乡','206',2426),(34688,'姜州乡','207',2426),(34689,'中心乡','208',2426),(34690,'小坝乡','209',2426),(34691,'火石乡','210',2426),(34692,'铁柳乡','211',2426),(34693,'龙树乡','212',2426),(34694,'可河乡','213',2426),(34695,'嘎吉乡','214',2426),(34696,'柏岩乡','215',2426),(34697,'海坝乡','216',2426),(34698,'洛佐乡','217',2426),(34699,'新马乡','218',2426),(34700,'淌塘乡','219',2426),(34701,'普咩乡','220',2426),(34702,'岩坝乡','221',2426),(34703,'鹿鹤村乡','222',2426),(34704,'新田乡','223',2426),(34705,'江西街乡','224',2426),(34706,'岔河乡','225',2426),(34707,'双堰乡','226',2426),(34708,'发箐乡','227',2426),(34709,'铁厂沟乡','228',2426),(34710,'新街乡','229',2426),(34711,'马龙乡','230',2426),(34712,'新龙乡','231',2426),(34713,'红岩乡','232',2426),(34714,'红果乡','233',2426),(34715,'鲁吉乡','234',2426),(34716,'溜姑乡','235',2426),(34717,'大崇乡','236',2426),(34718,'黑嘎乡','237',2426),(34719,'文箐乡','238',2426),(34720,'野牛坪乡','239',2426),(34721,'松坪乡','240',2426),(34722,'新山乡','241',2426),(34723,'小街乡','242',2426),(34724,'老口乡','243',2426),(34725,'干海子乡','244',2426),(34726,'黄坪乡','245',2426),(34727,'野租乡','246',2426),(34728,'拉马乡','247',2426),(34729,'鲁南乡','248',2426),(34730,'雪山乡','249',2426),(34731,'柏杉乡','250',2426),(34732,'披砂镇','100',2427),(34733,'松新镇','101',2427),(34734,'竹寿镇','102',2427),(34735,'华弹镇','103',2427),(34736,'白鹤滩镇','104',2427),(34737,'葫芦口镇','105',2427),(34738,'景星乡','200',2427),(34739,'俱乐乡','201',2427),(34740,'新村乡','202',2427),(34741,'幸福乡','203',2427),(34742,'海子乡','204',2427),(34743,'六铁乡','205',2427),(34744,'新建乡','206',2427),(34745,'稻谷乡','207',2427),(34746,'新华乡','208',2427),(34747,'石梨乡','209',2427),(34748,'松林乡','210',2427),(34749,'杉树乡','211',2427),(34750,'梁子乡','212',2427),(34751,'大同乡','213',2427),(34752,'西瑶乡','214',2427),(34753,'红星乡','215',2427),(34754,'骑骡沟乡','216',2427),(34755,'倮格乡','217',2427),(34756,'跑马乡','218',2427),(34757,'普基镇','100',2428),(34758,'荞窝镇','101',2428),(34759,'螺髻山镇','102',2428),(34760,'永安乡','200',2428),(34761,'向阳乡','201',2428),(34762,'文坪乡','202',2428),(34763,'黎安乡','203',2428),(34764,'花山乡','204',2428),(34765,'东山乡','205',2428),(34766,'大坪乡','206',2428),(34767,'辉隆乡','207',2428),(34768,'洛乌沟乡','208',2428),(34769,'雨水乡','209',2428),(34770,'甘天地乡','210',2428),(34771,'洛乌乡','211',2428),(34772,'孟甘乡','212',2428),(34773,'特兹乡','213',2428),(34774,'吉乐乡','214',2428),(34775,'特口乡','215',2428),(34776,'耶底乡','216',2428),(34777,'夹铁乡','217',2428),(34778,'瓦洛乡','218',2428),(34779,'哈力洛乡','219',2428),(34780,'菜子乡','220',2428),(34781,'祝联乡','221',2428),(34782,'刘家坪乡','222',2428),(34783,'月吾乡','223',2428),(34784,'特补乡','224',2428),(34785,'五道箐乡','225',2428),(34786,'特尔果乡','226',2428),(34787,'大槽乡','227',2428),(34788,'马洪乡','228',2428),(34789,'洛甘乡','229',2428),(34790,'红莫依达乡','230',2428),(34791,'特木里镇','100',2429),(34792,'龙潭镇','101',2429),(34793,'拖觉镇','102',2429),(34794,'木尔乡','200',2429),(34795,'九都乡','201',2429),(34796,'拉达乡','202',2429),(34797,'乌科乡','203',2429),(34798,'沙洛乡','204',2429),(34799,'洛古乡','205',2429),(34800,'补尔乡','206',2429),(34801,'觉撒乡','207',2429),(34802,'美撒乡','208',2429),(34803,'拉果乡','209',2429),(34804,'乌依乡','210',2429),(34805,'浪珠乡','211',2429),(34806,'包谷坪乡','212',2429),(34807,'合井乡','213',2429),(34808,'罗家坪乡','214',2429),(34809,'牛角湾乡','215',2429),(34810,'补洛乡','216',2429),(34811,'火烈乡','217',2429),(34812,'乐安乡','218',2429),(34813,'四棵乡','219',2429),(34814,'地洛乡','220',2429),(34815,'俄里坪乡','221',2429),(34816,'瓦都乡','222',2429),(34817,'采哈乡','223',2429),(34818,'委只洛乡','224',2429),(34819,'联补乡','225',2429),(34820,'基只乡','226',2429),(34821,'天地坝镇','100',2430),(34822,'派来镇','101',2430),(34823,'芦稿镇','102',2430),(34824,'对坪镇','103',2430),(34825,'桃坪乡','200',2430),(34826,'热水河乡','201',2430),(34827,'马依足乡','202',2430),(34828,'红峰乡','203',2430),(34829,'尔觉西乡','204',2430),(34830,'热柯觉乡','205',2430),(34831,'甲依乡','206',2430),(34832,'木府乡','207',2430),(34833,'寨子乡','208',2430),(34834,'则祖乡','209',2430),(34835,'基觉乡','210',2430),(34836,'小银木乡','211',2430),(34837,'春江乡','212',2430),(34838,'红联乡','213',2430),(34839,'青松乡','214',2430),(34840,'放马坪乡','215',2430),(34841,'梗堡乡','216',2430),(34842,'山江乡','217',2430),(34843,'洛觉乡','218',2430),(34844,'向岭乡','219',2430),(34845,'谷德乡','220',2430),(34846,'高峰乡','221',2430),(34847,'老寨子乡','222',2430),(34848,'德溪乡','223',2430),(34849,'南瓦乡','224',2430),(34850,'依莫合乡','225',2430),(34851,'土沟乡','226',2430),(34852,'丙底乡','227',2430),(34853,'依达乡','228',2430),(34854,'丝窝乡','229',2430),(34855,'新城镇','100',2431),(34856,'城北乡','200',2431),(34857,'树坪乡','201',2431),(34858,'谷曲乡','202',2431),(34859,'达洛乡','203',2431),(34860,'龙恩乡','204',2431),(34861,'美甘乡','205',2431),(34862,'四开乡','206',2431),(34863,'大坝乡','207',2431),(34864,'地莫乡','208',2431),(34865,'柳且乡','209',2431),(34866,'博洛乡','210',2431),(34867,'库莫乡','211',2431),(34868,'解放乡','212',2431),(34869,'三岗乡','213',2431),(34870,'洒拉地坡乡','214',2431),(34871,'三岔河乡','215',2431),(34872,'尼地乡','216',2431),(34873,'碗厂乡','217',2431),(34874,'普诗乡','218',2431),(34875,'玛增依乌乡','219',2431),(34876,'塘且乡','220',2431),(34877,'久特洛古乡','221',2431),(34878,'齿可波西乡','222',2431),(34879,'特口甲谷乡','223',2431),(34880,'竹核乡','224',2431),(34881,'阿并洛古乡','225',2431),(34882,'格吾乡','226',2431),(34883,'特布洛乡','227',2431),(34884,'庆恒乡','228',2431),(34885,'拉一木乡','229',2431),(34886,'色底乡','230',2431),(34887,'补约乡','231',2431),(34888,'比尔乡','232',2431),(34889,'库依乡','233',2431),(34890,'金曲乡','234',2431),(34891,'宜牧地乡','235',2431),(34892,'波洛乡','236',2431),(34893,'央摩租乡','237',2431),(34894,'则普乡','238',2431),(34895,'永乐乡','239',2431),(34896,'且莫乡','240',2431),(34897,'甘多洛古乡','241',2431),(34898,'支尔莫乡','242',2431),(34899,'龙沟乡','243',2431),(34900,'日哈乡','244',2431),(34901,'哈甘乡','245',2431),(34902,'光明镇','100',2432),(34903,'冕山镇','101',2432),(34904,'红莫镇','102',2432),(34905,'两河口镇','103',2432),(34906,'米市镇','104',2432),(34907,'洛哈镇','105',2432),(34908,'尼波镇','106',2432),(34909,'拉克乡','200',2432),(34910,'则约乡','201',2432),(34911,'贺波洛乡','202',2432),(34912,'鲁基乡','203',2432),(34913,'李子乡','204',2432),(34914,'北山乡','205',2432),(34915,'西河乡','206',2432),(34916,'东河乡','207',2432),(34917,'且拖乡','208',2432),(34918,'博洛拉达乡','209',2432),(34919,'沙马拉达乡','210',2432),(34920,'巴久乡','211',2432),(34921,'洛莫乡','212',2432),(34922,'依洛乡','213',2432),(34923,'热柯依达乡','214',2432),(34924,'额尼乡','215',2432),(34925,'乐武乡','216',2432),(34926,'城厢镇','100',2433),(34927,'漫水湾镇','101',2433),(34928,'大桥镇','102',2433),(34929,'复兴镇','103',2433),(34930,'泸沽镇','104',2433),(34931,'沙坝镇','105',2433),(34932,'回坪乡','200',2433),(34933,'回龙乡','201',2433),(34934,'哈哈乡','202',2433),(34935,'森荣乡','203',2433),(34936,'林里乡','204',2433),(34937,'石龙乡','205',2433),(34938,'铁厂乡','206',2433),(34939,'河边乡','207',2433),(34940,'河里乡','208',2433),(34941,'冶勒乡','209',2433),(34942,'拖乌乡','210',2433),(34943,'彝海乡','211',2433),(34944,'曹古乡','212',2433),(34945,'惠安乡','213',2433),(34946,'后山乡','214',2433),(34947,'宏模乡','215',2433),(34948,'先锋乡','216',2433),(34949,'泽远乡','217',2433),(34950,'里庄乡','218',2433),(34951,'金林乡','219',2433),(34952,'腊窝乡','220',2433),(34953,'联合乡','221',2433),(34954,'麦地沟乡','222',2433),(34955,'锦屏乡','223',2433),(34956,'南河乡','224',2433),(34957,'青纳乡','225',2433),(34958,'和爱藏族乡','226',2433),(34959,'棉沙湾乡','227',2433),(34960,'马头乡','228',2433),(34961,'窝堡乡','229',2433),(34962,'新兴乡','230',2433),(34963,'健美乡','231',2433),(34964,'越城镇','100',2434),(34965,'中所镇','101',2434),(34966,'新民镇','102',2434),(34967,'乃托镇','103',2434),(34968,'普雄镇','104',2434),(34969,'新乡乡','200',2434),(34970,'马拖乡','201',2434),(34971,'大瑞乡','202',2434),(34972,'南箐乡','203',2434),(34973,'丁山乡','204',2434),(34974,'大花乡','205',2434),(34975,'河东乡','206',2434),(34976,'西山乡','207',2434),(34977,'板桥乡','208',2434),(34978,'瓦岩乡','209',2434),(34979,'大屯乡','210',2434),(34980,'保安藏族乡','211',2434),(34981,'白果乡','212',2434),(34982,'梅花乡','213',2434),(34983,'拉普乡','214',2434),(34984,'铁西乡','215',2434),(34985,'尔觉乡','216',2434),(34986,'四甘普乡','217',2434),(34987,'贡莫乡','218',2434),(34988,'拉白乡','219',2434),(34989,'乐青地乡','220',2434),(34990,'德吉乡','221',2434),(34991,'依洛地坝乡','222',2434),(34992,'尔赛乡','223',2434),(34993,'古二乡','224',2434),(34994,'竹阿觉乡','225',2434),(34995,'保石乡','226',2434),(34996,'五里箐乡','227',2434),(34997,'书古乡','228',2434),(34998,'瓦普莫乡','229',2434),(34999,'申果乡','230',2434),(35000,'瓦曲觉乡','231',2434),(35001,'申普乡','232',2434),(35002,'瓦曲乃乌乡','233',2434),(35003,'瓦里觉乡','234',2434),(35004,'拉吉乡','235',2434),(35005,'新市坝镇','100',2435),(35006,'田坝镇','101',2435),(35007,'海棠镇','102',2435),(35008,'吉米镇','103',2435),(35009,'斯觉镇','104',2435),(35010,'普昌镇','105',2435),(35011,'玉田镇','106',2435),(35012,'前进乡','200',2435),(35013,'胜利乡','201',2435),(35014,'新茶乡','202',2435),(35015,'两河乡','203',2435),(35016,'里克乡','204',2435),(35017,'尼尔觉乡','205',2435),(35018,'拉莫乡','206',2435),(35019,'波波乡','207',2435),(35020,'阿嘎乡','208',2435),(35021,'阿尔乡','209',2435),(35022,'石海乡','210',2435),(35023,'团结乡','211',2435),(35024,'嘎日乡','212',2435),(35025,'则拉乡','213',2435),(35026,'坪坝乡','214',2435),(35027,'蓼坪乡','215',2435),(35028,'阿兹觉乡','216',2435),(35029,'乌史大桥乡','217',2435),(35030,'黑马乡','218',2435),(35031,'沙岱乡','219',2435),(35032,'苏雄乡','220',2435),(35033,'巴普镇','100',2436),(35034,'觉洛乡','200',2436),(35035,'井叶特西乡','201',2436),(35036,'合姑洛乡','202',2436),(35037,'巴古乡','203',2436),(35038,'农作乡','204',2436),(35039,'佐戈依达乡','205',2436),(35040,'子威乡','206',2436),(35041,'依洛拉达乡','207',2436),(35042,'典补乡','208',2436),(35043,'哈洛乡','209',2436),(35044,'牛牛坝乡','210',2436),(35045,'尔合乡','211',2436),(35046,'竹库乡','212',2436),(35047,'候古莫乡','213',2436),(35048,'候播乃拖乡','214',2436),(35049,'采红乡','215',2436),(35050,'苏洛乡','216',2436),(35051,'九口乡','217',2436),(35052,'洛俄依甘乡','218',2436),(35053,'拉木阿觉乡','219',2436),(35054,'洛莫依达乡','220',2436),(35055,'柳洪乡','221',2436),(35056,'乐约乡','222',2436),(35057,'尔其乡','223',2436),(35058,'瓦古乡','224',2436),(35059,'峨曲古乡','225',2436),(35060,'炳途乡','226',2436),(35061,'拖木乡','227',2436),(35062,'尼哈乡','228',2436),(35063,'龙门乡','229',2436),(35064,'依果觉乡','230',2436),(35065,'洒库乡','231',2436),(35066,'瓦西乡','232',2436),(35067,'树窝乡','233',2436),(35068,'龙窝乡','234',2436),(35069,'锦城镇','100',2437),(35070,'西宁镇','101',2437),(35071,'汶水镇','102',2437),(35072,'黄琅镇','103',2437),(35073,'南田乡','200',2437),(35074,'海湾乡','201',2437),(35075,'杉树堡乡','202',2437),(35076,'箐口乡','203',2437),(35077,'帕哈乡','204',2437),(35078,'永盛乡','205',2437),(35079,'溪洛米乡','206',2437),(35080,'白铁坝乡','207',2437),(35081,'顺河乡','208',2437),(35082,'渡口乡','209',2437),(35083,'回龙场乡','210',2437),(35084,'马湖乡','211',2437),(35085,'中田乡','212',2437),(35086,'谷米乡','213',2437),(35087,'柑子乡','214',2437),(35088,'双河口乡','215',2437),(35089,'罗山溪乡','216',2437),(35090,'桂花乡','217',2437),(35091,'烂坝子乡','218',2437),(35092,'沙沱乡','219',2437),(35093,'山棱岗乡','220',2437),(35094,'长河乡','221',2437),(35095,'谷堆乡','222',2437),(35096,'八寨乡','223',2437),(35097,'拉咪乡','224',2437),(35098,'松树乡','225',2437),(35099,'曲依乡','226',2437),(35100,'千万贯乡','227',2437),(35101,'五官乡','228',2437),(35102,'上田坝乡','229',2437),(35103,'大坪子乡','230',2437),(35104,'簸箕梁子乡','231',2437),(35105,'小沟乡','232',2437),(35106,'莫红乡','233',2437),(35107,'克觉乡','234',2437),(35108,'坪头乡','235',2437),(35109,'雷池乡','236',2437),(35110,'巴姑乡','237',2437),(35111,'咪姑乡','238',2437),(35112,'一车乡','239',2437),(35113,'斯古溪乡','240',2437),(35114,'卡哈洛乡','241',2437),(35115,'元宝山乡','242',2437),(35116,'大岩洞乡','243',2437),(35117,'岩脚乡','244',2437),(35118,'新华路街道办事处','001',2439),(35119,'西湖路街道办事处','002',2439),(35120,'大南门街道办事处','003',2439),(35121,'中华南路街道办事处','004',2439),(35122,'市府路街道办事处','005',2439),(35123,'河滨街道办事处','006',2439),(35124,'遵义路街道办事处','007',2439),(35125,'兴关路街道办事处','008',2439),(35126,'沙冲路街道办事处','009',2439),(35127,'太慈桥街道办事处','010',2439),(35128,'花果园街道办事处','011',2439),(35129,'油榨街街道办事处','012',2439),(35130,'中曹司街道办事处','013',2439),(35131,'二戈寨街道办事处','014',2439),(35132,'龙洞堡街道办事处','015',2439),(35133,'后巢乡','200',2439),(35134,'云关乡','201',2439),(35135,'中华中路街道办事处','001',2440),(35136,'中山东路街道办事处','002',2440),(35137,'中山西路街道办事处','003',2440),(35138,'中华北路街道办事处','004',2440),(35139,'北京路街道办事处','005',2440),(35140,'延安中路街道办事处','006',2440),(35141,'市西路街道办事处','007',2440),(35142