/*
 * Decompiled with CFR 0.152.
 */
package com.p6spy.engine.common;

import com.p6spy.engine.common.Subclasser;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

public class SubclassTask
extends Task {
    protected String outputDir;
    protected String outputPackage;
    protected File baseDir;
    protected Path classpath;
    protected ArrayList fileSets = new ArrayList();
    protected AntClassLoader loader;
    static /* synthetic */ Class class$javax$sql$DataSource;

    public void execute() throws BuildException {
        this.loader = this.createClassLoader();
        Iterator it = this.fileSets.iterator();
        while (it.hasNext()) {
            FileSet fileset = (FileSet)it.next();
            DirectoryScanner ds = fileset.getDirectoryScanner(this.getProject());
            String[] files = ds.getIncludedFiles();
            int size = files.length;
            int i = 0;
            while (i < size) {
                String fileName = files[i];
                if (fileName.endsWith(".class")) {
                    this.fixAndLoad(fileName);
                } else if (fileName.endsWith(".jar")) {
                    this.expandJar(ds.getBasedir(), fileName);
                } else {
                    this.log("File '" + fileName + "' is neither a .class nor a .jar file, skipping.", 1);
                }
                ++i;
            }
        }
    }

    public void fixAndLoad(String fileName) {
        String cleanString = fileName.substring(0, fileName.indexOf(".class"));
        StringBuffer className = new StringBuffer();
        int start = 0;
        int pos = 0;
        while ((pos = cleanString.indexOf(Subclasser.DELIMITER, start)) > 0) {
            className.append(cleanString.substring(start, pos));
            className.append(".");
            start = pos + 1;
        }
        if (start < cleanString.length()) {
            className.append(cleanString.substring(start));
        }
        if ((cleanString = className.toString()).indexOf(".P6") == -1) {
            this.loadClass(cleanString);
        }
    }

    public void loadClass(String className) {
        try {
            Class k = this.loader.loadClass(className);
            int mods = k.getModifiers();
            if ((class$javax$sql$DataSource == null ? (class$javax$sql$DataSource = SubclassTask.class$("javax.sql.DataSource")) : class$javax$sql$DataSource).isAssignableFrom(k) && (mods & 0x400) == 0 && (mods & 0x200) == 0 && (mods & 0x10) == 0) {
                this.log("Found class " + className, 1);
                Subclasser sub = new Subclasser(k);
                if (this.outputPackage != null) {
                    sub.setOutputPackage(this.outputPackage);
                }
                if (this.outputDir != null) {
                    sub.setOutputDir(this.outputDir);
                }
                sub.createSubClass();
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void expandJar(File parentDir, String jarName) {
        try {
            File jarFS = new File(parentDir, jarName);
            JarFile jar = new JarFile(jarFS);
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
                this.fixAndLoad(entry.getName());
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected AntClassLoader createClassLoader() {
        Path localPath = this.classpath == null ? Path.systemClasspath : this.classpath;
        AntClassLoader loader = new AntClassLoader(this.getProject(), localPath);
        return loader;
    }

    public String getOutputpackage() {
        return this.outputPackage;
    }

    public void setOutputpackage(String value) {
        this.outputPackage = value;
    }

    public String getOutputdir() {
        if (this.outputDir == null) {
            this.outputDir = ".";
        }
        return this.outputDir;
    }

    public void setOutputdir(File file) {
        this.outputDir = file.getAbsolutePath();
    }

    public void setDir(File dir) {
        this.baseDir = dir;
    }

    public void setClasspath(Path cp) {
        if (this.classpath == null) {
            this.classpath = cp;
        } else {
            this.classpath.append(cp);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void addFileset(FileSet fs) {
        this.fileSets.add(fs);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

