/*
 * Decompiled with CFR 0.152.
 */
package cn.com.mjsoft.cms.common.service;

import cn.com.mjsoft.cms.behavior.InitSiteGroupInfoBehavior;
import cn.com.mjsoft.cms.common.dao.CommonSystemDao;
import cn.com.mjsoft.cms.common.datasource.MySqlDataSource;
import cn.com.mjsoft.cms.security.service.SecurityService;
import cn.com.mjsoft.cms.site.bean.CmsServerBean;
import cn.com.mjsoft.framework.persistence.core.PersistenceEngine;
import cn.com.mjsoft.framework.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class CommonSystemService {
    private static Logger _$4 = Logger.getLogger(CommonSystemService.class);
    public static final String CS_FILE_NAME = "config" + File.separator + "cs.properties";
    private static CommonSystemService _$3 = null;
    public PersistenceEngine mysqlEngine = new PersistenceEngine(new MySqlDataSource());
    private static SecurityService _$2 = SecurityService.getInstance();
    private CommonSystemDao _$1 = new CommonSystemDao(this.mysqlEngine);

    private CommonSystemService() {
    }

    private static synchronized void _$1() {
        if (null == _$3) {
            _$3 = new CommonSystemService();
        }
    }

    public static CommonSystemService getInstance() {
        if (null == _$3) {
            CommonSystemService._$1();
        }
        return _$3;
    }

    public Map retrieveCmsSystemRuntimeConfigInfo() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.putAll(this._$1.queryCmsSystemRuntimeConfig());
        CmsServerBean cmsServerBean = InitSiteGroupInfoBehavior.currentCmsServerInfoBean;
        hashMap.put("domain", cmsServerBean.getDomain());
        hashMap.put("context", cmsServerBean.getContext());
        hashMap.put("port", cmsServerBean.getPort());
        return hashMap;
    }

    public Object getCmsSystemRuntimeConfigTag() {
        return this.retrieveCmsSystemRuntimeConfigInfo();
    }

    public Object getCmsSystemRuntimeInitCacheTag() {
        return InitSiteGroupInfoBehavior.currentCmsServerInfoBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsServerBean buildNewCmsServerBean() {
        Object object;
        String string = InitSiteGroupInfoBehavior.class.getClassLoader().getResource("/").getPath();
        String string2 = System.getProperty("os.name").toLowerCase();
        if (string2.indexOf("win") != -1 && string.startsWith("/")) {
            string = StringUtil.subString(string, 1, string.length());
        }
        string = StringUtil.replaceString(string, "/", File.separator, false, false);
        String string3 = StringUtil.replaceString(string, "classes", CS_FILE_NAME, false, false);
        Properties properties = new Properties();
        if (null != string3) {
            object = null;
            try {
                object = new FileInputStream(string3);
                properties.load((InputStream)object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                if (null != object) {
                    try {
                        ((InputStream)object).close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
        object = new CmsServerBean();
        ((CmsServerBean)object).setDomain(properties.getProperty("back_domain"));
        ((CmsServerBean)object).setContext(properties.getProperty("back_context"));
        ((CmsServerBean)object).setPort(StringUtil.getIntValue(properties.getProperty("back_port"), 80));
        Map map = this._$1.queryCmsSystemRuntimeConfig();
        ((CmsServerBean)object).setBaiduMapDefCity((String)map.get("baiduMapDefCity"));
        ((CmsServerBean)object).setDangerAccessCount(StringUtil.getIntValue((String)map.get("dangerAccessCount"), 3));
        ((CmsServerBean)object).setManagerIp((String)map.get("managerIp"));
        ((CmsServerBean)object).setLoginTime(StringUtil.getIntValue((String)map.get("loginTime"), 30));
        ((CmsServerBean)object).setOpenOfficePath((String)map.get("openOfficePath"));
        ((CmsServerBean)object).setOtherVCUrl((String)map.get("otherVCUrl"));
        ((CmsServerBean)object).setRootOrgName((String)map.get("rootOrgName"));
        _$2.checkSysRootRoleAndUser(properties);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editCmsRuntimeConfig(Map map, String string) {
        try {
            this.mysqlEngine.beginTransaction();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("managerIp", (String)map.get("managerIp"));
            hashMap.put("loginTime", StringUtil.getIntValue((String)map.get("loginTime"), 30));
            hashMap.put("openOfficePath", (String)map.get("openOfficePath"));
            hashMap.put("rootOrgName", StringUtil.isStringNull((String)map.get("rootOrgName")) ? "\u603b\u516c\u53f8" : (String)map.get("rootOrgName"));
            hashMap.put("baiduMapDefCity", (String)map.get("baiduMapDefCity"));
            hashMap.put("dangerAccessCount", StringUtil.getIntValue((String)map.get("dangerAccessCount"), 3));
            hashMap.put("otherVCUrl", (String)map.get("otherVCUrl"));
            this._$1.updateCmsRuntimeCfg(hashMap);
            hashMap.clear();
            hashMap.put("domain", (String)map.get("domain"));
            hashMap.put("context", (String)map.get("context"));
            hashMap.put("port", (String)map.get("port"));
            hashMap.put("serverId", 1);
            this._$1.updateCmsServerCfg(hashMap);
            StringUtil.setProperty(string, "back_domain", (String)map.get("domain"));
            StringUtil.setProperty(string, "back_context", (String)map.get("context"));
            StringUtil.setProperty(string, "back_port", (String)map.get("port"));
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
            InitSiteGroupInfoBehavior.bulidCmsServer();
        }
    }

    public void updateRootOrgName(String string) {
        if (StringUtil.isStringNull(string)) {
            string = "\u603b\u516c\u53f8";
        }
    }
}

