/*
 * Decompiled with CFR 0.152.
 */
package cn.com.mjsoft.cms.member.service;

import cn.com.mjsoft.cms.behavior.InitSiteGroupInfoBehavior;
import cn.com.mjsoft.cms.channel.bean.ContentClassBean;
import cn.com.mjsoft.cms.channel.dao.ChannelDao;
import cn.com.mjsoft.cms.common.Constant;
import cn.com.mjsoft.cms.common.ServiceUtil;
import cn.com.mjsoft.cms.common.datasource.MySqlDataSource;
import cn.com.mjsoft.cms.common.page.Page;
import cn.com.mjsoft.cms.content.dao.ContentDao;
import cn.com.mjsoft.cms.content.service.ContentService;
import cn.com.mjsoft.cms.member.bean.MemberBean;
import cn.com.mjsoft.cms.member.bean.MemberLoginUser;
import cn.com.mjsoft.cms.member.bean.MemberMessageTemplateBean;
import cn.com.mjsoft.cms.member.bean.MemberRankBean;
import cn.com.mjsoft.cms.member.bean.MemberScoreActBean;
import cn.com.mjsoft.cms.member.dao.MemberDao;
import cn.com.mjsoft.cms.member.dao.vo.Member;
import cn.com.mjsoft.cms.member.dao.vo.MemberMessage;
import cn.com.mjsoft.cms.member.dao.vo.MemberMessageTemplate;
import cn.com.mjsoft.cms.member.dao.vo.MemberRank;
import cn.com.mjsoft.cms.member.dao.vo.MemberScoreAct;
import cn.com.mjsoft.cms.member.html.MemberUtilTag;
import cn.com.mjsoft.cms.metadata.bean.DataModelBean;
import cn.com.mjsoft.cms.metadata.bean.ModelFiledInfoBean;
import cn.com.mjsoft.cms.metadata.bean.ModelPersistenceMySqlCodeBean;
import cn.com.mjsoft.cms.metadata.service.MetaDataService;
import cn.com.mjsoft.cms.resources.service.ResourcesService;
import cn.com.mjsoft.cms.security.bean.MemberRoleBean;
import cn.com.mjsoft.cms.security.dao.SecurityDao;
import cn.com.mjsoft.cms.site.bean.SiteGroupBean;
import cn.com.mjsoft.framework.behavior.Behavior;
import cn.com.mjsoft.framework.cache.Cache;
import cn.com.mjsoft.framework.cache.impl.LRUCache;
import cn.com.mjsoft.framework.persistence.core.PersistenceEngine;
import cn.com.mjsoft.framework.persistence.core.support.UpdateState;
import cn.com.mjsoft.framework.security.Auth;
import cn.com.mjsoft.framework.security.crypto.PasswordUtility;
import cn.com.mjsoft.framework.security.crypto.util.EncodeOne;
import cn.com.mjsoft.framework.security.headstream.IUser;
import cn.com.mjsoft.framework.security.session.SecuritySession;
import cn.com.mjsoft.framework.security.session.SecuritySessionKeeper;
import cn.com.mjsoft.framework.util.DateAndTimeUtil;
import cn.com.mjsoft.framework.util.IPSeeker;
import cn.com.mjsoft.framework.util.ObjectUtility;
import cn.com.mjsoft.framework.util.StringUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MemberService {
    private static Logger _$11 = Logger.getLogger(MemberService.class);
    private static final Cache _$10 = new LRUCache(2000);
    private static final Cache _$9 = new LRUCache(4000);
    private static MemberService _$8 = null;
    public PersistenceEngine mysqlEngine = new PersistenceEngine(new MySqlDataSource());
    private ResourcesService _$7 = ResourcesService.getInstance();
    private MetaDataService _$6 = MetaDataService.getInstance();
    private ContentService _$5 = ContentService.getInstance();
    private MemberDao _$4 = new MemberDao(this.mysqlEngine);
    private SecurityDao _$3 = new SecurityDao(this.mysqlEngine);
    private ContentDao _$2 = new ContentDao(this.mysqlEngine);
    private ChannelDao _$1 = new ChannelDao(this.mysqlEngine);

    private MemberService() {
    }

    private static synchronized void _$1() {
        if (null == _$8) {
            _$8 = new MemberService();
        }
    }

    public static MemberService getInstance() {
        if (null == _$8) {
            MemberService._$1();
        }
        return _$8;
    }

    public void addNewMemberMessageTemplate(MemberMessageTemplate memberMessageTemplate) {
        this._$4.save(memberMessageTemplate);
    }

    public void editMemberMessageTemplate(MemberMessageTemplate memberMessageTemplate) {
        this._$4.updateMemberMessageTemplate(memberMessageTemplate);
    }

    public void addMemberMessageTemplate(MemberMessageTemplate memberMessageTemplate) {
        this._$4.updateMemberMessageTemplate(memberMessageTemplate);
    }

    public Long retrieveMemeberCount(Long l) {
        Long l2 = this._$4.queryMemeberCountBySiteId(l);
        return l2;
    }

    public List retrieveMemeberList(Long l, Long l2, Integer n) {
        return this._$4.queryMemeberBySiteId(l, l2, n);
    }

    public List retrieveMemeberByRoleId(Long l, Long l2, Integer n) {
        return this._$4.queryMemeberByRoleId(l, l2, n);
    }

    public Long retrieveMemeberCountByRoleId(Long l) {
        return this._$4.queryMemeberCountByRoleId(l);
    }

    public void clientAddNewMemberMessage(Long l, Map map, String string) {
        if (map == null) {
            return;
        }
        Long l2 = (Long)map.get("siteId");
        MemberMessageTemplateBean memberMessageTemplateBean = this._$4.querySingleMessageTemplate(string, l2);
        if (memberMessageTemplateBean == null) {
            return;
        }
        String string2 = memberMessageTemplateBean.getTemplateContent();
        Iterator iterator = map.entrySet().iterator();
        Map.Entry entry = null;
        String string3 = null;
        String string4 = null;
        while (iterator.hasNext()) {
            entry = iterator.next();
            string3 = (String)entry.getKey();
            string4 = entry.getValue() != null ? entry.getValue().toString() : "";
            string2 = StringUtil.replaceString(string2, "${" + string3 + "}", string4, false, false);
        }
        MemberMessage memberMessage = new MemberMessage();
        memberMessage.setMsgTypeName("\u7cfb\u7edf\u65e5\u5fd7");
        memberMessage.setMsgTitle(memberMessageTemplateBean.getTemplateTitle());
        memberMessage.setIsRead(Constant.COMMON.OFF);
        memberMessage.setMemberId(l);
        memberMessage.setMsgContent(string2);
        memberMessage.setSendDt(new Date());
        memberMessage.setIsSys(Constant.COMMON.ON);
        this._$4.save(memberMessage);
    }

    public void clientAddNewDefinedMemberMessage(Long l, Map map, String string, String string2) {
        if (map == null) {
            return;
        }
        if (StringUtil.isStringNull(string) || StringUtil.isStringNull(string2)) {
            return;
        }
        String string3 = string2;
        Iterator iterator = map.entrySet().iterator();
        Map.Entry entry = null;
        String string4 = null;
        String string5 = null;
        while (iterator.hasNext()) {
            entry = iterator.next();
            string4 = (String)entry.getKey();
            string5 = entry.getValue() != null ? entry.getValue().toString() : "";
            string3 = StringUtil.replaceString(string3, "${" + string4 + "}", string5, false, false);
        }
        MemberMessage memberMessage = new MemberMessage();
        memberMessage.setMsgTypeName("\u7cfb\u7edf\u65e5\u5fd7");
        memberMessage.setMsgTitle(string);
        memberMessage.setIsRead(Constant.COMMON.OFF);
        memberMessage.setMemberId(l);
        memberMessage.setMsgContent(string3);
        memberMessage.setSendDt(new Date());
        memberMessage.setIsSys(Constant.COMMON.OFF);
        this._$4.save(memberMessage);
    }

    public String disposeDefinedMemberEmailAndMessageContent(Map map, String string) {
        if (map == null) {
            return string;
        }
        if (StringUtil.isStringNull(string)) {
            return string;
        }
        map.put("sysEventDT", DateAndTimeUtil.getFormatDate(new Date().getTime(), "yyyy-MM-dd HH:mm:ss"));
        String string2 = string;
        Iterator iterator = map.entrySet().iterator();
        Map.Entry entry = null;
        String string3 = null;
        String string4 = null;
        while (iterator.hasNext()) {
            entry = iterator.next();
            string3 = (String)entry.getKey();
            string4 = entry.getValue() != null ? entry.getValue().toString() : "";
            string2 = StringUtil.replaceString(string2, "${" + string3 + "}", string4, false, false);
        }
        return string2;
    }

    public void clientDisposeMemberScore(Long l, Map map, String string, Integer n) {
        if (StringUtil.isStringNull(string)) {
            return;
        }
        Long l2 = (Long)map.get("siteId");
        MemberScoreActBean memberScoreActBean = this._$4.querySingleMemberScoreActInfoByCommand(string, l2);
        if (memberScoreActBean == null) {
            return;
        }
        String string2 = memberScoreActBean.getActClass();
        if (StringUtil.isStringNotNull(string2)) {
            Class clazz = ObjectUtility.getClassInstance(string2);
            if (clazz != null) {
                Object var9_9 = null;
                try {
                    var9_9 = clazz.newInstance();
                }
                catch (InstantiationException instantiationException) {
                    instantiationException.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                if (var9_9 instanceof Behavior) {
                    ((Behavior)var9_9).operation(memberScoreActBean, new Object[]{map, string});
                }
            }
        } else if (Constant.COMMON.ON.equals(memberScoreActBean.getActFlag())) {
            this._$4.updateMemberScoreAddVal(l, memberScoreActBean.getActScore() * n);
        } else if (Constant.COMMON.OFF.equals(memberScoreActBean.getActFlag())) {
            this._$4.updateMemberScoreReduceVal(l, memberScoreActBean.getActScore() * n);
        }
        this.disposeMemberRank(l);
        MemberService.removeMemberInfoCache(l);
    }

    public void disposeMemberRank(Long l) {
        MemberBean memberBean = this._$4.querySingleMemberBeanById(l);
        if (memberBean != null) {
            Map map = null;
            long l2 = 0L;
            long l3 = 0L;
            List list = this._$4.queryMemberRankInfo(memberBean.getSiteId());
            if (list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    map = (Map)list.get(i);
                    l2 = (Long)map.get("minScore");
                    l3 = (Long)map.get("maxScore");
                    if (memberBean.getScore() < l2 || memberBean.getScore() > l3) continue;
                    this._$4.updateMemberLevel(memberBean.getMemberId(), (Integer)map.get("rankLevel"));
                    break;
                }
            }
        }
    }

    public void addNewMessageTemplateParam(Map map) {
        this._$4.saveMessageTemplateParam(map);
    }

    public void editMessageTemplateParam(Map map) {
        this._$4.updateMessageTemplateParam(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMemberRank(MemberRank memberRank) {
        SiteGroupBean siteGroupBean = (SiteGroupBean)SecuritySessionKeeper.getSecuritySession().getCurrentLoginSiteInfo();
        try {
            this.mysqlEngine.beginTransaction();
            memberRank.setSiteId(siteGroupBean.getSiteId());
            this._$4.saveMemberRank(memberRank);
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
            MemberService memberService = this;
            memberService._$4.clearRankCache();
        }
    }

    public void editMemberRank(MemberRank memberRank) {
        this._$4.updateMemberRank(memberRank);
        MemberService memberService = this;
        memberService._$4.clearRankCache();
    }

    public MemberRankBean getMemberSingleRankForTag(String string) {
        Long l = StringUtil.getLongValue(string, -1L);
        return this._$4.querySingleMemberRankInfo(l);
    }

    public Map getMemberSingleRankByLevelForTag(String string) {
        Integer n = StringUtil.getIntValue(string, -1);
        List list = this._$4.queryMemberRankInfoByLevel(n);
        if (list.size() > 0) {
            return (Map)list.get(0);
        }
        return null;
    }

    public String getMemberRoleInfoForTag(String string) {
        Long l = StringUtil.getLongValue(string, -1L);
        List list = this._$3.queryMemberRoleBeanByUserId(l);
        StringBuffer stringBuffer = new StringBuffer();
        MemberRoleBean memberRoleBean = null;
        for (int i = 0; i < list.size(); ++i) {
            memberRoleBean = (MemberRoleBean)list.get(i);
            if (i + 1 < list.size()) {
                stringBuffer.append(memberRoleBean.getRoleName() + ",  ");
                continue;
            }
            stringBuffer.append(memberRoleBean.getRoleName());
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMemberRank(List list) {
        if (list == null) {
            return;
        }
        try {
            this.mysqlEngine.beginTransaction();
            Long l = null;
            for (int i = 0; i < list.size(); ++i) {
                l = Long.valueOf(list.get(i).toString());
                if (l < 1L) continue;
                this._$4.deleteMemberRank(l);
            }
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
            MemberService memberService = this;
            memberService._$4.clearRankCache();
        }
    }

    public List getMemberRankInfoForTag() {
        SiteGroupBean siteGroupBean = (SiteGroupBean)SecuritySessionKeeper.getSecuritySession().getCurrentLoginSiteInfo();
        return this._$4.queryMemberRankInfo(siteGroupBean.getSiteId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMemberScoreAct(MemberScoreAct memberScoreAct) {
        SiteGroupBean siteGroupBean = (SiteGroupBean)SecuritySessionKeeper.getSecuritySession().getCurrentLoginSiteInfo();
        try {
            this.mysqlEngine.beginTransaction();
            memberScoreAct.setSiteId(siteGroupBean.getSiteId());
            this._$4.saveMemberScoreAct(memberScoreAct);
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
        }
    }

    public void editMemberScoreAct(MemberScoreAct memberScoreAct) {
        this._$4.updateMemberScoreAct(memberScoreAct);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMemberScoreAct(List list) {
        if (list == null) {
            return;
        }
        try {
            this.mysqlEngine.beginTransaction();
            Long l = null;
            for (int i = 0; i < list.size(); ++i) {
                l = Long.valueOf(list.get(i).toString());
                if (l < 1L) continue;
                this._$4.deleteMemberScoreAct(l);
            }
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
        }
    }

    public List getMemberScoreActForTag() {
        SiteGroupBean siteGroupBean = (SiteGroupBean)SecuritySessionKeeper.getSecuritySession().getCurrentLoginSiteInfo();
        return this._$4.queryMemberScoreActInfo(siteGroupBean.getSiteId());
    }

    public MemberScoreActBean getMemberSingleScoreActForTag(String string) {
        Long l = StringUtil.getLongValue(string, -1L);
        return this._$4.querySingleMemberScoreActInfo(l);
    }

    public Object[] retrieveMemberInfo(String string, String string2, String string3, String string4, String string5, String string6) {
        List list = null;
        Long l = StringUtil.getLongValue(string, -1L);
        if (l < 0L) {
            return null;
        }
        int n = StringUtil.getIntValue(string4, 1);
        int n2 = StringUtil.getIntValue(string3, 15);
        Page page = null;
        if (StringUtil.isStringNotNull(string5)) {
            list = new ArrayList<Map>();
            String string7 = string5;
            String string8 = StringUtil.decodeFromWeb(string6);
            Map map = null;
            if ("name".equals(string7)) {
                if (StringUtil.isStringNotNull(string8) && !(map = this._$4.queryMemeberByName(l, string8)).isEmpty()) {
                    list.add(map);
                }
            } else if ("trueName".equals(string7)) {
                if (StringUtil.isStringNotNull(string8) && !(map = this._$4.queryMemeberByTrueName(l, string8)).isEmpty()) {
                    list.add(map);
                }
            } else if ("email".equals(string7)) {
                if (StringUtil.isStringNotNull(string8) && !(map = this._$4.queryMemeberByEmail(l, string8)).isEmpty()) {
                    list.add(map);
                }
            } else if ("phone".equals(string7)) {
                if (StringUtil.isStringNotNull(string8) && !(map = this._$4.queryMemeberByPhone(l, string8)).isEmpty()) {
                    list.add(map);
                }
            } else if ("applTrueName".equals(string7)) {
                list = this._$4.queryMemeberByIsTrueName(l, "2");
            } else if ("isTrueName".equals(string7)) {
                list = this._$4.queryMemeberByIsTrueName(l, "1");
            }
            page = new Page(n2, list.size(), n);
            return new Object[]{list, page};
        }
        if (!"".equals(string2)) {
            Long l2 = this._$4.queryMemeberCountBySiteId(l, Integer.valueOf(string2));
            page = new Page(n2, l2.intValue(), n);
            list = this._$4.queryMemeberBySiteId(l, Integer.valueOf(string2), page.getFirstResult(), page.getPageSize());
        } else {
            Long l3 = this._$4.queryMemeberCountBySiteId(l);
            page = new Page(n2, l3.intValue(), n);
            list = this._$4.queryMemeberBySiteId(l, page.getFirstResult(), page.getPageSize());
        }
        return new Object[]{list, page};
    }

    public String sendMemberMessage(String string, String string2, List list) {
        List list2 = list;
        Long l = null;
        for (int i = 0; i < list2.size(); ++i) {
            l = Long.valueOf(list2.get(i).toString());
            Map map = this._$4.querySingleMemberInfo(l);
            SiteGroupBean siteGroupBean = (SiteGroupBean)InitSiteGroupInfoBehavior.siteGroupIdInfoCache.getEntry(map.get("siteId"));
            if ((map = this.retrieveSingleMemberAndExtInfo(l, siteGroupBean.getExtMemberModelId())).isEmpty()) continue;
            map.put("sysEventDT", DateAndTimeUtil.getFormatDate(new Date().getTime(), "yyyy-MM-dd HH:mm:ss"));
            this.clientAddNewDefinedMemberMessage(l, map, string, string2);
        }
        return "1";
    }

    public String sendMemberMail(String string, String string2, List list) {
        List list2 = list;
        Long l = null;
        for (int i = 0; i < list2.size(); ++i) {
            l = Long.valueOf(list2.get(i).toString());
            this.clientAddNewMemberEmail(l, string, string2);
        }
        return "1";
    }

    public String clientAddNewMemberEmail(Long l, String string, String string2) {
        Map map = this._$4.querySingleMemberInfo(l);
        if (map.isEmpty()) {
            return "-1";
        }
        String string3 = (String)map.get("email");
        if (StringUtil.isStringNull(string3)) {
            return "-2";
        }
        String string4 = string;
        SiteGroupBean siteGroupBean = (SiteGroupBean)InitSiteGroupInfoBehavior.siteGroupIdInfoCache.getEntry(map.get("siteId"));
        if (siteGroupBean != null && siteGroupBean.getExtMemberModelId() > 0L) {
            map = this.retrieveSingleMemberAndExtInfo(l, siteGroupBean.getExtMemberModelId());
        }
        string2 = this.disposeDefinedMemberEmailAndMessageContent(map, string2);
        int n = ServiceUtil.addSiteEmailSendInfo(siteGroupBean.getSiteId(), string3, string4, string2, new Timestamp(new Date().getTime()));
        if (n == 1) {
            return "1";
        }
        return "0";
    }

    public void checkMemberCoreInfo(Long l, String string, Boolean bl) {
        if ("cert".equals(string)) {
            if (bl.booleanValue()) {
                this._$4.updateMemberCertStatus(l, Constant.COMMON.ON);
            } else {
                this._$4.updateMemberCertStatus(l, Constant.COMMON.OFF);
            }
        } else if ("bank".equals(string)) {
            if (bl.booleanValue()) {
                this._$4.updateMemberBankStatus(l, Constant.COMMON.ON);
            } else {
                this._$4.updateMemberBankStatus(l, Constant.COMMON.OFF);
            }
        }
    }

    public void changeMemberStatus(List list, String string) {
        if (list == null) {
            return;
        }
        Long l = null;
        for (int i = 0; i < list.size(); ++i) {
            l = list.get(i) instanceof Long ? (Long)list.get(i) : Long.valueOf(StringUtil.getLongValue((String)list.get(i), -1L));
            if (l < 0L) continue;
            if ("open".equals(string)) {
                this._$4.updateMemberUseStatus(l, Constant.COMMON.ON);
                continue;
            }
            if (!"close".equals(string)) continue;
            this._$4.updateMemberUseStatus(l, Constant.COMMON.OFF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateState addMemberBasicInfo(SiteGroupBean siteGroupBean, Member member, DataModelBean dataModelBean, List list, ModelPersistenceMySqlCodeBean modelPersistenceMySqlCodeBean, Map map) {
        UpdateState updateState = null;
        try {
            this.mysqlEngine.beginTransaction();
            member.setMemLevel(siteGroupBean.getMemberDefLv());
            member.setScore(siteGroupBean.getMemberDefSc());
            updateState = this._$4.save(member);
            if (updateState.haveKey() && dataModelBean != null && list != null && modelPersistenceMySqlCodeBean != null) {
                ModelFiledInfoBean modelFiledInfoBean = null;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                String string = null;
                Object object = null;
                for (int i = 0; i < list.size(); ++i) {
                    modelFiledInfoBean = (ModelFiledInfoBean)list.get(i);
                    object = ServiceUtil.disposeDataModelFiledFromWeb(modelFiledInfoBean, map, null, true);
                    arrayList.add(object);
                    if (11 != modelFiledInfoBean.getHtmlElementId().intValue() || !Constant.COMMON.ON.equals(modelFiledInfoBean.getNeedMark()) || Constant.COMMON.ON.equals(this._$7.getImageMarkStatus(string = ServiceUtil.getImageReUrl((String)object))) || !ServiceUtil.disposeImageMark((SiteGroupBean)SecuritySessionKeeper.getSecuritySession().getCurrentLoginSiteInfo(), string, Integer.valueOf(ServiceUtil.getImageW((String)object)), Integer.valueOf(ServiceUtil.getImageH((String)object)))) continue;
                    this._$7.setImageMarkStatus(string, Constant.COMMON.ON);
                }
                arrayList.add(updateState.getKey());
                this._$2.saveOrUpdateModelContent(modelPersistenceMySqlCodeBean.getInsertSql(), arrayList.toArray());
                Long l = siteGroupBean.getMemberDefRoleId();
                if (l > 0L) {
                    this._$3.saveMemberRelateRole(updateState.getKey(), l);
                }
            }
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
        }
        return updateState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editMemberBasicInfo(MemberBean memberBean, DataModelBean dataModelBean, List list, ModelPersistenceMySqlCodeBean modelPersistenceMySqlCodeBean, Map map) {
        try {
            this.mysqlEngine.beginTransaction();
            this._$4.updateMemberBasic(map);
            if ("true".equals(map.get("sysMailChange"))) {
                this._$4.updateMailCheckStatus(memberBean.getMemberId(), Constant.COMMON.OFF);
            }
            if (dataModelBean != null && list != null && modelPersistenceMySqlCodeBean != null) {
                Integer n = this._$2.queryUserDefinedContentExist(dataModelBean, memberBean.getMemberId());
                ModelFiledInfoBean modelFiledInfoBean = null;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                String string = null;
                Object object = null;
                for (int i = 0; i < list.size(); ++i) {
                    modelFiledInfoBean = (ModelFiledInfoBean)list.get(i);
                    object = ServiceUtil.disposeDataModelFiledFromWeb(modelFiledInfoBean, map, null, true);
                    arrayList.add(object);
                    if (11 != modelFiledInfoBean.getHtmlElementId().intValue() || !Constant.COMMON.ON.equals(modelFiledInfoBean.getNeedMark()) || Constant.COMMON.ON.equals(this._$7.getImageMarkStatus(string = ServiceUtil.getImageReUrl((String)object))) || !ServiceUtil.disposeImageMark((SiteGroupBean)SecuritySessionKeeper.getSecuritySession().getCurrentLoginSiteInfo(), string, Integer.valueOf(ServiceUtil.getImageW((String)object)), Integer.valueOf(ServiceUtil.getImageH((String)object)))) continue;
                    this._$7.setImageMarkStatus(string, Constant.COMMON.ON);
                }
                arrayList.add(memberBean.getMemberId());
                if (n == 1) {
                    this._$2.saveOrUpdateModelContent(modelPersistenceMySqlCodeBean.getUpdateSql(), arrayList.toArray());
                } else if (n == 0) {
                    this._$2.saveOrUpdateModelContent(modelPersistenceMySqlCodeBean.getInsertSql(), arrayList.toArray());
                }
                MemberService.removeMemberInfoCache(memberBean.getMemberId());
            }
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
        }
    }

    public boolean checkMemberUserName(String string) {
        Map map = this._$4.querySingleMemberInfoByName(string);
        return !map.isEmpty();
    }

    public boolean checkMemberUserMail(String string) {
        Map map = this._$4.querySingleMemberInfoByMail(string);
        return !map.isEmpty();
    }

    public MemberBean retrieveSingleMemberBean(Long l) {
        return this._$4.querySingleMemberBeanById(l);
    }

    public MemberBean retrieveSingleMemberBean(String string) {
        return this._$4.queryMemberBeanByName(string);
    }

    public MemberBean retrieveSingleMemberBeanByEMail(String string) {
        return this._$4.queryMemberBeanByMail(string);
    }

    public Map retrieveSingleMemberAndExtInfo(Long l, Long l2) {
        String string = "retrieveSingleMemberAndExtInfo:" + l;
        Map map = (Map)_$10.getEntry(string);
        if (map == null) {
            ModelPersistenceMySqlCodeBean modelPersistenceMySqlCodeBean = this._$6.retrieveSingleModelPerMysqlCodeBean(l2);
            DataModelBean dataModelBean = this._$6.retrieveSingleDataModelBeanById(l2);
            map = this._$4.queryMemberInfoById(l, dataModelBean, modelPersistenceMySqlCodeBean);
            map.put("PREVLOGINDT", DateAndTimeUtil.formatTimestamp((Timestamp)map.get("PREVLOGINDT"), "yyyy-MM-dd HH:mm:ss"));
            map.put("REGDT", DateAndTimeUtil.formatTimestamp((Timestamp)map.get("REGDT"), "yyyy-MM-dd HH:mm:ss"));
            map.put("CURRLOGINDT", DateAndTimeUtil.formatTimestamp((Timestamp)map.get("CURRLOGINDT"), "yyyy-MM-dd HH:mm:ss"));
            _$10.putEntry(string, map);
        }
        return map;
    }

    public Long retrieveMemberActInfoCount(Map map, int n) {
        if (map == null) {
            return 0L;
        }
        Long l = (Long)map.get("memberId");
        Long l2 = (Long)map.get("siteId");
        String string = (String)map.get("memberName");
        if (n == 1) {
            return this._$4.queryActInfoCommentCount(l, l2);
        }
        if (n == 2) {
            return this._$4.queryActInfoMessageCount(l);
        }
        if (n == 3) {
            return this._$4.queryActInfoGuestbookCount(l, l2);
        }
        if (n == 4) {
            return this._$4.queryActInfoPushContentCount(string, l2);
        }
        return 0L;
    }

    public MemberBean getSingleMemberBeanForTag(String string) {
        return this._$4.querySingleMemberBeanById(StringUtil.getLongValue(string, -1L));
    }

    public Map retrieveSingleMemberBeanByName(String string) {
        SiteGroupBean siteGroupBean = (SiteGroupBean)SecuritySessionKeeper.getSecuritySession().getCurrentLoginSiteInfo();
        return this._$4.queryMemeberByName(siteGroupBean.getSiteId(), string);
    }

    public IUser obtainUser(String string) {
        Map map = this._$4.querySingleMemberInfoByName(string);
        if (map.isEmpty()) {
            return null;
        }
        List list = this._$3.queryMemberHaveSecurityRoleByUserId((Long)map.get("memberId"));
        MemberLoginUser memberLoginUser = new MemberLoginUser();
        memberLoginUser.setName((String)map.get("memberName"));
        memberLoginUser.setPassword((String)map.get("password"));
        memberLoginUser.setUserId((Long)map.get("memberId"));
        memberLoginUser.setRoleIdList(list);
        memberLoginUser.setStatus((Integer)map.get("useStatus"));
        return memberLoginUser;
    }

    public IUser obtainUserByPhone(String string) {
        Map map = this._$4.querySingleMemberInfoByPhone(string);
        if (map.isEmpty()) {
            return null;
        }
        List list = this._$3.queryMemberHaveSecurityRoleByUserId((Long)map.get("memberId"));
        MemberLoginUser memberLoginUser = new MemberLoginUser();
        memberLoginUser.setName((String)map.get("memberName"));
        memberLoginUser.setPassword((String)map.get("password"));
        memberLoginUser.setUserId((Long)map.get("memberId"));
        memberLoginUser.setRoleIdList(list);
        memberLoginUser.setStatus((Integer)map.get("useStatus"));
        return memberLoginUser;
    }

    public IUser obtainUserByEmail(String string) {
        Map map = this._$4.querySingleMemberInfoByMail(string);
        if (map.isEmpty()) {
            return null;
        }
        List list = this._$3.queryMemberHaveSecurityRoleByUserId((Long)map.get("memberId"));
        MemberLoginUser memberLoginUser = new MemberLoginUser();
        memberLoginUser.setName((String)map.get("memberName"));
        memberLoginUser.setPassword((String)map.get("password"));
        memberLoginUser.setUserId((Long)map.get("memberId"));
        memberLoginUser.setRoleIdList(list);
        memberLoginUser.setStatus((Integer)map.get("useStatus"));
        return memberLoginUser;
    }

    public List retrieveMemeberRole(Long l) {
        List list = this._$3.queryMemberHaveSecurityRoleByUserId(l);
        return list;
    }

    public void updateMemberLoginTrace(String string, Timestamp timestamp, Long l) {
        Map map = this._$4.querySingleMemberInfo(l);
        String string2 = (String)map.get("currLoginIp");
        String string3 = StringUtil.isStringNotNull(string2) ? IPSeeker.getInstance().getAddress(string2) : "";
        Timestamp timestamp2 = (Timestamp)map.get("currLoginDT");
        this._$4.updateMemberLoginTrace(string, timestamp, string2, string3, timestamp2, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int changeMemberLoginPassword(String string, String string2, String string3) {
        if (StringUtil.isStringNull(string) || StringUtil.isStringNull(string2) || StringUtil.isStringNull(string3)) {
            return -2;
        }
        Auth auth = SecuritySessionKeeper.getSecuritySession().getAuth();
        Long l = (Long)auth.getIdentity();
        try {
            this.mysqlEngine.beginTransaction();
            Map map = this._$4.querySingleMemberInfo(l);
            if (map.isEmpty()) {
                int n = -2;
                return n;
            }
            if (!PasswordUtility.match(string, (String)map.get("password"))) {
                int n = -3;
                return n;
            }
            if (!string2.equals(string3)) {
                int n = -4;
                return n;
            }
            this._$4.updateMemberPW(l, PasswordUtility.encrypt(string2));
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
        }
        MemberService.removeMemberInfoCache(l);
        return 1;
    }

    public Object[] validateMemberEmail(Map map) {
        String string = (String)map.get("key");
        byte[] byArray = EncodeOne.decryptAES(EncodeOne.parseHexStr2Byte(string), "jtop!Q(O*I&Ubestp1237$R%Tcms56324rojectis!Q@W#E$R%Tjtopcmsisbest");
        String string2 = new String(byArray);
        if (StringUtil.isStringNull(string2)) {
            return new Object[]{-1, null, null};
        }
        String[] stringArray = string2.split("\\|");
        if (stringArray.length < 5) {
            return new Object[]{-1, null, null};
        }
        Long l = StringUtil.getLongValue(stringArray[4], -1L);
        String string3 = stringArray[3];
        String string4 = DateAndTimeUtil.getCunrrentDayAndTime("yyyy-MM-dd");
        int n = DateAndTimeUtil.getDayInterval(string4, string3, "yyyy-MM-dd");
        if (n > 1) {
            return new Object[]{-2, null, l};
        }
        Long l2 = StringUtil.getLongValue(stringArray[0], -1L);
        Map map2 = this._$4.querySingleMemberInfo(l2);
        if (map2.isEmpty()) {
            return new Object[]{-3, null, l};
        }
        Integer n2 = (Integer)map2.get("isTrueEmail");
        if (Constant.COMMON.ON.equals(n2)) {
            return new Object[]{-4, map2, l};
        }
        Long l3 = this._$4.queryMemberLostEmailTraceCount(string);
        if (l3 > 0L) {
            return new Object[]{-2, null, l};
        }
        this._$4.updateMailCheckStatus(l2, Constant.COMMON.ON);
        this._$4.saveMemberLostEmailTrace(string, new Date());
        MemberService.removeMemberInfoCache(l2);
        return new Object[]{1, map2, l};
    }

    public String sendMemberValiEmail(SiteGroupBean siteGroupBean, Map map) {
        if (siteGroupBean == null) {
            return "0";
        }
        MemberBean memberBean = (MemberBean)SecuritySessionKeeper.getSecuritySession().getMember();
        if (memberBean == null) {
            return "0";
        }
        String string = (String)map.get("email");
        if (StringUtil.isStringNull(string = StringUtil.decodeFromWeb(string))) {
            return "-2";
        }
        Long l = memberBean.getMemberId();
        Map map2 = this._$4.querySingleMemberInfo(l);
        String string2 = (String)map2.get("email");
        Timestamp timestamp = (Timestamp)map2.get("regDT");
        if (StringUtil.isStringNotNull(string2) && !string2.equals(string)) {
            string2 = string;
            boolean bl = this.checkMemberUserMail(string2);
            if (bl) {
                return "-3";
            }
            this._$4.updateMemberEMail(l, string2);
            this._$4.updateMailCheckStatus(l, Constant.COMMON.OFF);
        } else {
            if (Constant.COMMON.ON.equals(map2.get("isTrueEmail")) && string2.equals(string)) {
                return "-4";
            }
            string2 = string;
            this._$4.updateMemberEMail(l, string2);
        }
        siteGroupBean = (SiteGroupBean)InitSiteGroupInfoBehavior.siteGroupIdInfoCache.getEntry(siteGroupBean.getSiteId());
        String string3 = "\u6ce8\u518c\u90ae\u4ef6\u786e\u8ba4";
        String string4 = DateAndTimeUtil.getCunrrentDayAndTime("yyyy-MM-dd");
        String string5 = l + "|" + timestamp + "|" + string2 + "|" + string4 + "|" + siteGroupBean.getSiteId() + "|" + System.currentTimeMillis();
        byte[] byArray = EncodeOne.encryptAES(string5, "jtop!Q(O*I&Ubestp1237$R%Tcms56324rojectis!Q@W#E$R%Tjtopcmsisbest");
        String string6 = EncodeOne.encode16(byArray).toLowerCase();
        String string7 = this.disposeDefinedMemberEmailAndMessageContent(map2, siteGroupBean.getRegMailText());
        String string8 = siteGroupBean.getSiteUrl() + "member/memberEmailActive.cmd?key=" + string6;
        string7 = StringUtil.replaceString(string7, "${sysRegMailcallback}", string8, false, false);
        string7 = StringUtil.replaceString(string7, "${siteName}", siteGroupBean.getSiteName(), false, false);
        string7 = StringUtil.replaceString(string7, "${siteUrl}", siteGroupBean.getSiteUrl(), false, false);
        int n = ServiceUtil.addSiteEmailSendInfo(siteGroupBean.getSiteId(), string2, string3, string7, new Timestamp(new Date().getTime()));
        if (n == 1) {
            return "1";
        }
        return "0";
    }

    public Object[] sendResetMemberPasswordMail(String string) {
        if (StringUtil.isStringNull(string)) {
            return new Object[]{"0", null};
        }
        Map map = this._$4.querySingleMemberInfoByMail(string);
        if (map.isEmpty()) {
            return new Object[]{"-2", null};
        }
        SiteGroupBean siteGroupBean = (SiteGroupBean)InitSiteGroupInfoBehavior.siteGroupIdInfoCache.getEntry(map.get("siteId"));
        String string2 = "\u91cd\u7f6e\u767b\u5f55\u5bc6\u7801";
        String string3 = DateAndTimeUtil.getCunrrentDayAndTime("yyyy-MM-dd");
        String string4 = map.get("memberId") + "|" + map.get("regDT") + "|" + string + "|" + string3 + "|" + siteGroupBean.getSiteId() + "|" + System.currentTimeMillis();
        byte[] byArray = EncodeOne.encryptAES(string4, "jtop!Q(O*I&Ubestp1237$R%Tcms56324rojectis!Q@W#E$R%Tjtopcmsisbest");
        String string5 = EncodeOne.encode16(byArray).toLowerCase();
        String string6 = this.disposeDefinedMemberEmailAndMessageContent(map, siteGroupBean.getResetPwText());
        String string7 = siteGroupBean.getSiteUrl() + "member/checkResetReq.cmd?key=" + string5;
        string6 = StringUtil.replaceString(string6, "${sysResetPWcallback}", string7, false, false);
        string6 = StringUtil.replaceString(string6, "${siteName}", siteGroupBean.getSiteName(), false, false);
        string6 = StringUtil.replaceString(string6, "${siteUrl}", siteGroupBean.getSiteUrl(), false, false);
        int n = ServiceUtil.addSiteEmailSendInfo(siteGroupBean.getSiteId(), string, string2, string6, new Timestamp(new Date().getTime()));
        if (n == 1) {
            return new Object[]{"1", map};
        }
        return new Object[]{"0", null};
    }

    public String checkResetMemberKey(String[] stringArray, String string) {
        if (stringArray == null || stringArray.length < 5) {
            return "0";
        }
        Long l = StringUtil.getLongValue(stringArray[0], -1L);
        Map map = this._$4.querySingleMemberInfo(l);
        if (map.isEmpty()) {
            return "-2";
        }
        Timestamp timestamp = DateAndTimeUtil.getTimestamp(stringArray[1], "yyyy-MM-dd HH:mm:ss");
        if (!timestamp.equals(map.get("regDT"))) {
            return "-3";
        }
        String string2 = stringArray[2];
        String string3 = (String)map.get("email");
        if (!string2.equals(string3)) {
            return "-4";
        }
        String string4 = DateAndTimeUtil.getCunrrentDayAndTime("yyyy-MM-dd");
        int n = DateAndTimeUtil.getDayInterval(string4, stringArray[3], "yyyy-MM-dd");
        if (n > 1) {
            return "-5";
        }
        Long l2 = this._$4.queryMemberLostEmailTraceCount(string);
        if (l2 > 0L) {
            return "-5";
        }
        return "1";
    }

    public String resetMemberPassword(Map map) {
        String string;
        String string2 = (String)map.get("newPw");
        String string3 = (String)map.get("checkNewPw");
        String string4 = (String)map.get("key");
        String string5 = (String)map.get("idKey");
        String string6 = (String)map.get("regKey");
        String string7 = (String)map.get("mailKey");
        if (StringUtil.isStringNull(string2) || StringUtil.isStringNull(string3) || StringUtil.isStringNull(string4) || StringUtil.isStringNull(string5) || StringUtil.isStringNull(string6) || StringUtil.isStringNull(string7)) {
            return "0";
        }
        byte[] byArray = EncodeOne.decryptAES(EncodeOne.parseHexStr2Byte(string5), MemberUtilTag.getSalt("E"));
        String string8 = string = new String(byArray);
        byArray = EncodeOne.decryptAES(EncodeOne.parseHexStr2Byte(string6), MemberUtilTag.getSalt("B"));
        String string9 = string = new String(byArray);
        byArray = EncodeOne.decryptAES(EncodeOne.parseHexStr2Byte(string7), MemberUtilTag.getSalt("C"));
        String string10 = string = new String(byArray);
        Long l = StringUtil.getLongValue(string8, -1L);
        Map map2 = this._$4.querySingleMemberInfo(l);
        if (map2.isEmpty()) {
            return "-2";
        }
        Timestamp timestamp = DateAndTimeUtil.getTimestamp(string9, "yyyy-MM-dd HH:mm:ss");
        if (!timestamp.equals(map2.get("regDT"))) {
            return "-3";
        }
        if (!string10.equals(map2.get("email"))) {
            return "-4";
        }
        if (!string2.equals(string3)) {
            return "-5";
        }
        Long l2 = this._$4.queryMemberLostEmailTraceCount(string4);
        if (l2 > 0L) {
            return "-6";
        }
        UpdateState updateState = this._$4.updateMemberPW(l, PasswordUtility.encrypt(string2));
        if (updateState.getRow() > 0) {
            this._$4.saveMemberLostEmailTrace(string4, new Date());
            MemberService.removeMemberInfoCache(l);
            return "1";
        }
        return "0";
    }

    public String[] decryptKey(String string) {
        byte[] byArray = EncodeOne.decryptAES(EncodeOne.parseHexStr2Byte(string), "jtop!Q(O*I&Ubestp1237$R%Tcms56324rojectis!Q@W#E$R%Tjtopcmsisbest");
        String string2 = new String(byArray);
        if (StringUtil.isStringNull(string2)) {
            return null;
        }
        String[] stringArray = string2.split("\\|");
        return stringArray;
    }

    public int changeMemberHeadPhoto(Map map) {
        Auth auth;
        Long l;
        Long l2 = StringUtil.getLongValue((String)map.get("headPhoto"), -1L);
        String string = ServiceUtil.disposeSingleImageInfo(l2);
        UpdateState updateState = this._$4.updateMemberHeadPhoto(string, l = (Long)(auth = SecuritySessionKeeper.getSecuritySession().getAuth()).getIdentity());
        if (updateState.getRow() > 0) {
            MemberService.removeMemberInfoCache(l);
            return 1;
        }
        return 0;
    }

    public Map retrieveThirdLoginInfo(String string, String string2) {
        return this._$4.queryThirdLoginInfo(string, string2);
    }

    public void addThirdLoginInfo(Long l, String string, String string2) {
        this._$4.saveThirdLoginInfo(l, string, string2);
    }

    public void addOneCountForMemberLoginSuccess(Long l) {
        this._$4.updateMemberLoginSuccessCount(l);
    }

    public String getMemberRegTypeForTag(String string) {
        Long l = StringUtil.getLongValue(string, -1L);
        Map map = this._$4.querySingleMemberThirdRegInfo(l);
        if (map.isEmpty()) {
            return "\u666e\u901a\u6ce8\u518c\u5e10\u53f7";
        }
        if ("qq".equals(map.get("loginType"))) {
            return "\u5173\u8054QQ\u5e10\u53f7";
        }
        if ("weibo".equals(map.get("loginType"))) {
            return "\u5173\u8054\u5fae\u535a\u5e10\u53f7";
        }
        return "\u672a\u77e5\u7c7b\u578b";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeMemberScore(String string, Integer n, List list) {
        if (list == null) {
            return;
        }
        Long l = null;
        try {
            this.mysqlEngine.beginTransaction();
            for (int i = 0; i < list.size(); ++i) {
                l = Long.valueOf(list.get(i).toString());
                if (l < 1L) continue;
                if ("a".equals(string)) {
                    this._$4.updateMemberScoreAddVal(l, n);
                } else if ("d".equals(string)) {
                    this._$4.updateMemberScoreReduceVal(l, n);
                }
                this.disposeMemberRank(l);
                MemberService.removeMemberInfoCache(l);
            }
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMember(List list) {
        if (list == null) {
            return;
        }
        try {
            this.mysqlEngine.beginTransaction();
            Long l = null;
            Map map = null;
            for (int i = 0; i < list.size(); ++i) {
                l = StringUtil.getLongValue((String)list.get(i), -1L);
                if (l < 0L || (map = this._$4.querySingleMemberInfo(l)).isEmpty()) continue;
                this._$4.deleteMemberById(l);
                this._$3.deleteMemberRoleRealte(l);
                this._$4.deleteMemberThirdRegInfo(l);
                this._$4.deleteMessage(l);
            }
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
        }
    }

    public void addMemberLoginTrace(Long l, String string, String string2, Integer n) {
        this._$4.saveMemberLoginTrace(l, string2, string, new Timestamp(new Date().getTime()), n);
    }

    public Object getMemberLoginTraceTag(String string, String string2, String string3) {
        SiteGroupBean siteGroupBean = (SiteGroupBean)SecuritySessionKeeper.getSecuritySession().getCurrentLoginSiteInfo();
        int n = StringUtil.getIntValue(string2, 1);
        int n2 = StringUtil.getIntValue(string3, 15);
        Page page = null;
        Long l = null;
        List list = null;
        if (StringUtil.isStringNotNull(string)) {
            l = this._$4.queryMemberLoginTraceCount(string.trim());
            page = new Page(n2, l.intValue(), n);
            list = this._$4.queryMemberLoginTrace(string.trim(), (Long)page.getFirstResult(), (Integer)n2);
        } else {
            l = this._$4.queryMemberLoginTraceCount(siteGroupBean.getSiteId());
            page = new Page(n2, l.intValue(), n);
            list = this._$4.queryMemberLoginTrace(siteGroupBean.getSiteId(), (Long)page.getFirstResult(), (Integer)n2);
        }
        return new Object[]{list, page};
    }

    public Object[] getMemberContentForTag(String string, String string2, String string3) {
        SiteGroupBean siteGroupBean = (SiteGroupBean)SecuritySessionKeeper.getSecuritySession().getCurrentLoginSiteInfo();
        SecuritySession securitySession = SecuritySessionKeeper.getSecuritySession();
        MemberBean memberBean = (MemberBean)securitySession.getMember();
        int n = StringUtil.getIntValue(string2, 1);
        int n2 = StringUtil.getIntValue(string, 15);
        Page page = null;
        List list = null;
        if ("".equals(string3)) {
            Long l = this._$4.queryMemeberContentCountBySiteId(siteGroupBean.getSiteId(), memberBean.getMemberName());
            page = new Page(n2, l.intValue(), n);
            list = this._$4.queryMemeberContentMainInfoBySiteId(siteGroupBean.getSiteId(), memberBean.getMemberName(), page.getFirstResult(), page.getPageSize());
        } else {
            Integer n3 = StringUtil.getIntValue(string3, 1);
            Long l = this._$4.queryMemeberContentCountBySiteIdAndState(siteGroupBean.getSiteId(), memberBean.getMemberName(), n3);
            page = new Page(n2, l.intValue(), n);
            list = this._$4.queryMemeberContentMainInfoBySiteIdAndState(siteGroupBean.getSiteId(), memberBean.getMemberName(), n3, page.getFirstResult(), page.getPageSize());
        }
        return new Object[]{list, page};
    }

    public Map getMemberSingleContentForTag(String string) {
        Long l = StringUtil.getLongValue(string, -1L);
        Map map = this._$4.queryMemeberSIngleContentMainInfoById(l);
        Long l2 = (Long)map.get("classId");
        ContentClassBean contentClassBean = this._$1.querySingleClassBeanInfoByClassId(l2);
        DataModelBean dataModelBean = this._$6.retrieveSingleDataModelBeanById(contentClassBean.getContentType());
        if (dataModelBean == null) {
            return null;
        }
        ModelPersistenceMySqlCodeBean modelPersistenceMySqlCodeBean = this._$6.retrieveSingleModelPerMysqlCodeBean(contentClassBean.getContentType());
        map = this._$2.querySingleUserDefineContent(modelPersistenceMySqlCodeBean, dataModelBean.getRelateTableName(), l);
        return map;
    }

    public void deleteContentForMember(List list) {
        this._$5.deleteSystemAndUserDefineContentForMember(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMessageForMember(List list) {
        if (list == null) {
            return;
        }
        MemberBean memberBean = (MemberBean)SecuritySessionKeeper.getSecuritySession().getMember();
        if (memberBean == null || memberBean.getMemberId() < 0L) {
            return;
        }
        Long l = null;
        try {
            this.mysqlEngine.beginTransaction();
            for (int i = 0; i < list.size(); ++i) {
                l = StringUtil.getLongValue((String)list.get(i), -1L);
                if (l < 0L) continue;
                this._$4.deleteMessageById(l, memberBean.getMemberId());
            }
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCommentForMember(List list) {
        if (list == null) {
            return;
        }
        MemberBean memberBean = (MemberBean)SecuritySessionKeeper.getSecuritySession().getMember();
        if (memberBean == null || memberBean.getMemberId() < 0L) {
            return;
        }
        Long l = null;
        try {
            this.mysqlEngine.beginTransaction();
            for (int i = 0; i < list.size(); ++i) {
                l = StringUtil.getLongValue((String)list.get(i), -1L);
                if (l < 0L) continue;
                this._$4.deleteCommentById(l, memberBean.getMemberId());
            }
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMessageTemplate(List list) {
        if (list == null) {
            return;
        }
        try {
            this.mysqlEngine.beginTransaction();
            Long l = null;
            for (int i = 0; i < list.size(); ++i) {
                l = StringUtil.getLongValue((String)list.get(i), -1L);
                if (l < 0L) continue;
                this._$4.deleteMessageTemplate(l);
            }
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMessageTemplateParam(List list) {
        if (list == null) {
            return;
        }
        try {
            this.mysqlEngine.beginTransaction();
            Long l = null;
            for (int i = 0; i < list.size(); ++i) {
                l = StringUtil.getLongValue((String)list.get(i), -1L);
                if (l < 0L) continue;
                this._$4.deleteMessageTemplateParam(l);
            }
            this.mysqlEngine.commit();
        }
        finally {
            this.mysqlEngine.endTransaction();
        }
    }

    public Object[] getMemberCommentForTag(String string, String string2, String string3) {
        SiteGroupBean siteGroupBean = (SiteGroupBean)SecuritySessionKeeper.getSecuritySession().getCurrentLoginSiteInfo();
        SecuritySession securitySession = SecuritySessionKeeper.getSecuritySession();
        MemberBean memberBean = (MemberBean)securitySession.getMember();
        int n = StringUtil.getIntValue(string2, 1);
        int n2 = StringUtil.getIntValue(string, 15);
        Page page = null;
        List list = null;
        if ("".equals(string3)) {
            Long l = this._$4.queryMemeberCommentCountBySiteId(siteGroupBean.getSiteId(), memberBean.getMemberId());
            page = new Page(n2, l.intValue(), n);
            list = this._$4.queryMemeberCommentBySiteId(siteGroupBean.getSiteId(), memberBean.getMemberId(), page.getFirstResult(), page.getPageSize());
        } else {
            Integer n3 = StringUtil.getIntValue(string3, 1);
            Long l = this._$4.queryMemeberCommentCountBySiteIdAndCensor(siteGroupBean.getSiteId(), memberBean.getMemberId(), n3);
            page = new Page(n2, l.intValue(), n);
            list = this._$4.queryMemeberCommentBySiteIdAndCensor(siteGroupBean.getSiteId(), memberBean.getMemberId(), n3, page.getFirstResult(), page.getPageSize());
        }
        return new Object[]{list, page};
    }

    public Object[] getMemberGbForTag(String string, String string2, String string3) {
        SiteGroupBean siteGroupBean = (SiteGroupBean)SecuritySessionKeeper.getSecuritySession().getCurrentLoginSiteInfo();
        SecuritySession securitySession = SecuritySessionKeeper.getSecuritySession();
        MemberBean memberBean = (MemberBean)securitySession.getMember();
        int n = StringUtil.getIntValue(string2, 1);
        int n2 = StringUtil.getIntValue(string, 15);
        Page page = null;
        List list = null;
        if ("".equals(string3)) {
            Long l = this._$4.queryMemeberGbCountBySiteId(siteGroupBean.getSiteId(), memberBean.getMemberId());
            page = new Page(n2, l.intValue(), n);
            list = this._$4.queryMemeberGbBySiteId(siteGroupBean.getSiteId(), memberBean.getMemberId(), page.getFirstResult(), page.getPageSize());
        } else {
            Integer n3 = StringUtil.getIntValue(string3, 1);
            Long l = this._$4.queryMemeberGbCountBySiteIdAndCensor(siteGroupBean.getSiteId(), memberBean.getMemberId(), n3);
            page = new Page(n2, l.intValue(), n);
            list = this._$4.queryMemeberGbBySiteIdAndCensor(siteGroupBean.getSiteId(), memberBean.getMemberId(), n3, page.getFirstResult(), page.getPageSize());
        }
        return new Object[]{list, page};
    }

    public Object[] getMemberMsgForTag(String string, String string2, String string3) {
        SecuritySession securitySession = SecuritySessionKeeper.getSecuritySession();
        MemberBean memberBean = (MemberBean)securitySession.getMember();
        int n = StringUtil.getIntValue(string2, 1);
        int n2 = StringUtil.getIntValue(string, 15);
        Page page = null;
        List list = null;
        if ("".equals(string3)) {
            Long l = this._$4.queryMemeberMsgCount(memberBean.getMemberId());
            page = new Page(n2, l.intValue(), n);
            list = this._$4.queryMemeberMsg(memberBean.getMemberId(), page.getFirstResult(), page.getPageSize());
        } else {
            Integer n3 = StringUtil.getIntValue(string3, 1);
            Long l = this._$4.queryMemeberMsgCount(memberBean.getMemberId(), n3);
            page = new Page(n2, l.intValue(), n);
            list = this._$4.queryMemeberMsg(memberBean.getMemberId(), n3, page.getFirstResult(), page.getPageSize());
        }
        return new Object[]{list, page};
    }

    public Map getMemberSingleMsgForTag(String string) {
        Long l = StringUtil.getLongValue(string, -1L);
        return this._$4.querySingleMemeberMsg(l);
    }

    public void updateMemberMsgReadFlagForTag(String string) {
        Long l = StringUtil.getLongValue(string, -1L);
        this._$4.updateMemeberMsgReadFlag(l);
    }

    public Object[] getMessageTemplateForTag(String string, String string2) {
        SiteGroupBean siteGroupBean = (SiteGroupBean)SecuritySessionKeeper.getSecuritySession().getCurrentLoginSiteInfo();
        int n = StringUtil.getIntValue(string, 1);
        int n2 = StringUtil.getIntValue(string2, 15);
        Page page = null;
        List list = null;
        Long l = this._$4.queryMessageTemplateCountBySiteId(siteGroupBean.getSiteId());
        page = new Page(n2, l.intValue(), n);
        list = this._$4.queryMessageTemplateBySiteId(siteGroupBean.getSiteId(), page.getFirstResult(), page.getPageSize());
        return new Object[]{list, page};
    }

    public static void clearMemberInfoCache() {
        _$10.clearAllEntry();
    }

    public static void removeMemberInfoCache(Long l) {
        String string = "retrieveSingleMemberAndExtInfo:" + l;
        _$10.removeEntry(string);
    }

    public static void clearMemberActInfoCache() {
        _$9.clearAllEntry();
    }
}

