/*
 * Decompiled with CFR 0.152.
 */
package cn.com.mjsoft.cms.metadata.dao;

import cn.com.mjsoft.cms.common.Constant;
import cn.com.mjsoft.cms.content.dao.ContentValueResultCallBack;
import cn.com.mjsoft.cms.metadata.bean.DataModelBean;
import cn.com.mjsoft.cms.metadata.bean.ModelFiledInfoBean;
import cn.com.mjsoft.cms.metadata.bean.ModelPersistenceMySqlCodeBean;
import cn.com.mjsoft.cms.metadata.bean.ModelValidateConfigBean;
import cn.com.mjsoft.cms.metadata.bean.PathInjectAssistBean;
import cn.com.mjsoft.cms.metadata.dao.DataModelBeanTransform;
import cn.com.mjsoft.cms.metadata.dao.HtmlElementInfoMapValueRowTransform;
import cn.com.mjsoft.cms.metadata.dao.ModelFiledInfoBeanTransform;
import cn.com.mjsoft.cms.metadata.dao.ModelPersistenceMySqlCodeBeanTransform;
import cn.com.mjsoft.cms.metadata.dao.ModelValidateConfigBeanTransform;
import cn.com.mjsoft.cms.metadata.dao.PathInjectAssistBeanTransform;
import cn.com.mjsoft.cms.metadata.dao.vo.DataModel;
import cn.com.mjsoft.cms.metadata.dao.vo.ModelFiledMetadata;
import cn.com.mjsoft.cms.metadata.dao.vo.ModelHtmlConfig;
import cn.com.mjsoft.cms.metadata.dao.vo.PathInjectAssist;
import cn.com.mjsoft.framework.cache.Cache;
import cn.com.mjsoft.framework.cache.impl.LRUCache;
import cn.com.mjsoft.framework.exception.FrameworkException;
import cn.com.mjsoft.framework.persistence.core.PersistenceEngine;
import cn.com.mjsoft.framework.persistence.core.support.EntitySqlBridge;
import cn.com.mjsoft.framework.persistence.core.support.UpdateState;
import cn.com.mjsoft.framework.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MetaDataDao {
    private Logger _$1 = Logger.getLogger(this.getClass());
    public static Map cacheManager = new HashMap();
    public PersistenceEngine pe;

    public void setPe(PersistenceEngine persistenceEngine) {
        this.pe = persistenceEngine;
    }

    public MetaDataDao() {
    }

    public MetaDataDao(PersistenceEngine persistenceEngine) {
        this.pe = persistenceEngine;
    }

    public UpdateState saveDataModel(DataModel dataModel) {
        return this.pe.save(dataModel);
    }

    public UpdateState updateDataModelBaseInfo(DataModel dataModel) {
        String string = "update model set modelName=?, validateBehavior=?, beforeBehavior=?, afterBehavior=?, privateMode=?, ico=?, remark=? where dataModelId=?";
        return this.pe.update(string, dataModel);
    }

    public List queryAllDataModelBeanListWithStateAndSiteId(Integer n, Integer n2, Long l) {
        String string = "select * from (select * from model where useState=? and modelType=? and siteId=? and privateMode=1 union  select * from model where useState=? and modelType=? and privateMode=0) tmp order by dataModelId desc";
        return this.pe.query(string, new Object[]{n, n2, l, n, n2}, new DataModelBeanTransform());
    }

    public List queryAllDataModelBeanListByModelTypeAndSiteId(Integer n, Long l) {
        String string = "queryAllDataModelBeanListByModelTypeAndSiteId:" + n + "|" + l;
        Cache cache = (Cache)cacheManager.get("queryAllDataModelBeanListByModelTypeAndSiteId");
        List list = (List)cache.getEntry(string);
        if (list == null) {
            String string2 = "select * from (select * from model where modelType=? and siteId=? and privateMode=1 union  select * from model where modelType=? and privateMode=0) tmp order by dataModelId desc";
            list = this.pe.query(string2, new Object[]{n, l, n}, new DataModelBeanTransform());
            cache.putEntry(string, list);
        }
        return list;
    }

    public List queryAllDataModelBeanListByModelTypeAndSiteIdPrivateMode(Integer n, Long l, Integer n2) {
        String string = "select * from model where modelType=? and siteId=? and privateMode=? order by dataModelId desc";
        return this.pe.query(string, new Object[]{n, l, n2}, new DataModelBeanTransform());
    }

    public List queryDataModelBeanListByModelTypeAndSiteId(Integer n, Long l) {
        String string = "queryDataModelBeanListByModelTypeAndSiteId:" + n + "|" + l;
        Cache cache = (Cache)cacheManager.get("queryAllDataModelBeanListByModelTypeAndSiteId");
        List list = (List)cache.getEntry(string);
        if (list == null) {
            String string2 = "select * from model where modelType=? and siteId=? order by dataModelId desc";
            list = this.pe.query(string2, new Object[]{n, l}, new DataModelBeanTransform());
            cache.putEntry(string, list);
        }
        return list;
    }

    public List queryAllDataModelIdListBySiteIdPrivateMode(Long l, Integer n) {
        String string = "select dataModelId from model where siteId=? and privateMode=?";
        return this.pe.querySingleCloumn(string, new Object[]{l, n}, Long.class);
    }

    public Double queryMaxDataModelOrderId(Long l) {
        String string = "select max(orderId) from model_filed_metadata where dataModelId=?";
        return (Double)this.pe.querySingleObject(string, new Object[]{l}, Double.class);
    }

    public void updateColumnDefVal(String string, String string2, String string3) {
        String string4 = "update " + string + " set " + string2 + "=?";
        this.pe.update(string4, new Object[]{string3});
    }

    public void updateColumnDefValById(String string, String string2, String string3, Long l) {
        String string4 = "update " + string + " set " + string2 + "=? where contentId=?";
        this.pe.update(string4, new Object[]{string3, l});
    }

    public UpdateState saveModelMetadata(ModelFiledMetadata modelFiledMetadata) {
        return this.pe.save(modelFiledMetadata);
    }

    public UpdateState saveModelFiledHtmlConfig(ModelHtmlConfig modelHtmlConfig) {
        return this.pe.save(modelHtmlConfig);
    }

    public List queryUserDefinedModelFiledInfoBeanList(Long l) {
        String string = "select mc.*, md.* from model_filed_metadata md left join model_html_config mc on md.metaDataId=mc.metaDataId where md.dataModelId=? order by md.orderId asc";
        return this.pe.query(string, new Object[]{l}, new ModelFiledInfoBeanTransform());
    }

    public UpdateState deleteDataModelFiledMetadata(Long l) {
        return this.pe.delete(ModelFiledMetadata.class, l);
    }

    public UpdateState deleteHtmlConfigByItsFiledId(Long l) {
        String string = "delete from model_html_config where metaDataId=?";
        return this.pe.update(string, new Object[]{l});
    }

    public UpdateState createModelRelatingMysqlTable(DataModel dataModel) {
        StringBuffer stringBuffer = new StringBuffer("create table IF NOT EXISTS ");
        stringBuffer.append(dataModel.getRelateTableName() + " (");
        stringBuffer.append("contentId bigint(20) NOT NULL,PRIMARY KEY (");
        stringBuffer.append("contentId");
        stringBuffer.append(")) ENGINE=InnoDB DEFAULT CHARSET=gbk");
        return this.pe.update(stringBuffer.toString());
    }

    public UpdateState createOrModifyModelRelatingMysqlColumn(ModelFiledMetadata modelFiledMetadata, String string, boolean bl) {
        UpdateState updateState;
        block23: {
            String string2 = null;
            if (Constant.METADATA.MYSQL_VARCHAR.equals(modelFiledMetadata.getPerdureType())) {
                string2 = "varchar(" + modelFiledMetadata.getCapacity() + ")";
            } else if (Constant.METADATA.MYSQL_TEXT.equals(modelFiledMetadata.getPerdureType())) {
                string2 = "text";
            } else if (Constant.METADATA.MYSQL_LONGTEXT.equals(modelFiledMetadata.getPerdureType())) {
                string2 = "longtext";
            } else if (Constant.METADATA.MYSQL_INT.equals(modelFiledMetadata.getPerdureType())) {
                string2 = "int";
            } else if (Constant.METADATA.MYSQL_BIGINT.equals(modelFiledMetadata.getPerdureType())) {
                string2 = "bigint";
            } else if (Constant.METADATA.MYSQL_DOUBLE.equals(modelFiledMetadata.getPerdureType())) {
                string2 = "double";
            } else if (Constant.METADATA.MYSQL_DATETIME.equals(modelFiledMetadata.getPerdureType())) {
                string2 = "datetime DEFAULT '0000-00-00 00:00:00'";
            } else if (Constant.METADATA.MYSQL_DATE.equals(modelFiledMetadata.getPerdureType())) {
                string2 = "date DEFAULT '0000-00-00'";
            } else if (Constant.METADATA.MYSQL_TIME.equals(modelFiledMetadata.getPerdureType())) {
                string2 = "time DEFAULT '00:00:00'";
            }
            StringBuffer stringBuffer = new StringBuffer("alter table ");
            stringBuffer.append(string);
            if (bl) {
                stringBuffer.append(" modify ");
            } else {
                stringBuffer.append(" add column ");
            }
            stringBuffer.append(modelFiledMetadata.getRelateFiledName());
            stringBuffer.append(" " + string2);
            updateState = null;
            try {
                updateState = this.pe.update(stringBuffer.toString());
            }
            catch (Exception exception) {
                String string3 = "Row size too large. The maximum row size for the used table type, not counting BLOBs, is 65535. You have to change some columns to TEXT or BLOBs";
                String string4 = exception.getMessage();
                if (string4.indexOf(string3) == -1 || !Constant.METADATA.MYSQL_VARCHAR.equals(modelFiledMetadata.getPerdureType())) break block23;
                stringBuffer = new StringBuffer("alter table ");
                stringBuffer.append(string);
                if (bl) {
                    stringBuffer.append(" modify ");
                } else {
                    stringBuffer.append(" add column ");
                }
                stringBuffer.append(modelFiledMetadata.getRelateFiledName());
                stringBuffer.append(" text");
                updateState = this.pe.update(stringBuffer.toString());
            }
        }
        return updateState;
    }

    public UpdateState createModelRelatingMysqlColumnForDateOrderHelper(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer("alter table ");
        stringBuffer.append(string);
        stringBuffer.append(" add column ");
        stringBuffer.append(string2);
        stringBuffer.append(" bigint");
        return this.pe.update(stringBuffer.toString());
    }

    public String queryTargetModelTableNameByModelId(Long l) {
        String string = "select relateTableName from model where dataModelId=?";
        return (String)this.pe.querySingleObject(string, new Object[]{l}, String.class);
    }

    public boolean queryHaveSameFiledSign(ModelFiledMetadata modelFiledMetadata) {
        String string = "select count(*) from model_filed_metadata where filedSign=? and dataModelId=?";
        Integer n = (Integer)this.pe.querySingleObject(string, new Object[]{modelFiledMetadata.getFiledSign(), modelFiledMetadata.getDataModelId()}, Integer.class);
        return n > 0;
    }

    public void dropMysqlFiledbyId(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer("alter table ");
        stringBuffer.append(string);
        stringBuffer.append(" drop column ");
        stringBuffer.append(string2);
        try {
            this.pe.update(stringBuffer.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String querySingleModelTableName(Long l) {
        String string = "select relateTableName from model mo,model_filed_metadata mf where mo.dataModelId=mf.dataModelId and mf.metaDataId=?";
        return (String)this.pe.querySingleObject(string, new Object[]{l}, String.class);
    }

    public String querySingleFiledName(Long l) {
        String string = "select relateFiledName from model_filed_metadata where metaDataId=?";
        return (String)this.pe.querySingleObject(string, new Object[]{l}, String.class);
    }

    public String querySingleFiledNameForQueryData(Long l) {
        String string = "select relateFiledName from model_filed_metadata where metaDataId=?";
        Cache cache = (Cache)cacheManager.get("querySingleFiledNameForQueryData");
        String string2 = (String)cache.getEntry(l);
        if (string2 == null) {
            string2 = (String)this.pe.querySingleObject(string, new Object[]{l}, String.class);
            cache.putEntry(l, string2);
        }
        return string2;
    }

    public String querySingleFiledSign(Long l) {
        String string = "select filedSign from model_filed_metadata where metaDataId=?";
        return (String)this.pe.querySingleObject(string, new Object[]{l}, String.class);
    }

    public Integer querySingleFiledDataType(Long l) {
        String string = "select perdureType from model_filed_metadata where metaDataId=?";
        return (Integer)this.pe.querySingleObject(string, new Object[]{l}, Integer.class);
    }

    public Integer querySingleFiledOrderFlag(Long l) {
        String string = "select orderFlag from model_filed_metadata where metaDataId=?";
        return (Integer)this.pe.querySingleObject(string, new Object[]{l}, Integer.class);
    }

    public Map querySystemHtmlElementInfo() {
        String string = "select * from model_html_element";
        HtmlElementInfoMapValueRowTransform htmlElementInfoMapValueRowTransform = new HtmlElementInfoMapValueRowTransform();
        this.pe.query(string, htmlElementInfoMapValueRowTransform);
        return htmlElementInfoMapValueRowTransform.getInfoMap();
    }

    public DataModelBean querySingleDataModelBeanById(Long l) {
        String string = "select * from model where dataModelId=?";
        Cache cache = (Cache)cacheManager.get("retrieveSingleDataModelBean");
        DataModelBean dataModelBean = (DataModelBean)cache.getEntry(l);
        if (dataModelBean == null) {
            dataModelBean = (DataModelBean)this.pe.querySingleRow(string, new Object[]{l}, new DataModelBeanTransform());
            cache.putEntry(l, dataModelBean);
        }
        return dataModelBean;
    }

    public DataModelBean querySingleDataModelBeanByName(String string) {
        String string2 = "select * from model where modelName=?";
        if (StringUtil.isStringNull(string)) {
            return null;
        }
        Cache cache = (Cache)cacheManager.get("retrieveSingleDataModelBean");
        DataModelBean dataModelBean = (DataModelBean)cache.getEntry(string);
        if (dataModelBean == null) {
            dataModelBean = (DataModelBean)this.pe.querySingleRow(string2, new Object[]{string}, new DataModelBeanTransform());
            cache.putEntry(string, dataModelBean);
        }
        return dataModelBean;
    }

    public void updateMetedataOrder(Long l, Double d) {
        String string = "update model_filed_metadata set orderId=? where metaDataId=?";
        this.pe.update(string, new Object[]{d, l});
    }

    public void updateMetedataBlankCount(Long l, Integer n) {
        String string = "update model_html_config set blankCount=? where metaDataId=?";
        this.pe.update(string, new Object[]{n, l});
    }

    public List queryModelFieldValue(DataModelBean dataModelBean, String string) {
        String string2 = "select contentId, " + string + " as val from " + dataModelBean.getRelateTableName();
        return this.pe.queryResultMap(string2);
    }

    public Integer queryHaveMetedataEntitySql(Long l) {
        String string = "select count(*) from model_persistence_code where dataModelId=?";
        return (Integer)this.pe.querySingleObject(string, new Object[]{l}, Integer.class);
    }

    public void saveMetedataEntitySql(EntitySqlBridge entitySqlBridge, Long l) {
        String string = "insert into model_persistence_code (dataModelId, insertSql, updateSql, deleteSql, selectSql, selectColumn, listSelectColumn) values (? ,?, ?, ?, ?, ?, ?)";
        this.pe.update(string, new Object[]{l, entitySqlBridge.getInsertSql(), entitySqlBridge.getUpdateSql(), entitySqlBridge.getDeleteSql(), entitySqlBridge.getSelectSql(), entitySqlBridge.getSelectColumn(), entitySqlBridge.getListSelectColumn()});
    }

    public void updateMetedataEntitySql(EntitySqlBridge entitySqlBridge, Long l) {
        String string = "update model_persistence_code set insertSql=?, updateSql=?, deleteSql=?, selectSql=?, selectColumn=? where dataModelId=?";
        this.pe.update(string, new Object[]{entitySqlBridge.getInsertSql(), entitySqlBridge.getUpdateSql(), entitySqlBridge.getDeleteSql(), entitySqlBridge.getSelectSql(), entitySqlBridge.getSelectColumn(), l});
    }

    public List querySystemModelFiledInfoBeanList() {
        String string = "select mc.*, md.* from model_filed_metadata md left join model_html_config mc on md.metaDataId=mc.metaDataId where md.dataModelId=0 order by md.orderId asc";
        return this.pe.query(string, new ModelFiledInfoBeanTransform());
    }

    public ModelPersistenceMySqlCodeBean querySingleModelPerMysqlCodeBean(Long l) {
        String string = "select * from model_persistence_code where dataModelId=?";
        return (ModelPersistenceMySqlCodeBean)this.pe.querySingleRow(string, new Object[]{l}, new ModelPersistenceMySqlCodeBeanTransform());
    }

    public void deleteExtendTable(String string) {
        String string2 = "drop table " + string;
        try {
            this.pe.update(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void deleteAllMetadataFiledByModelId(Long l) {
        String string = "delete from model_filed_metadata where dataModelId=?";
        this.pe.update(string, new Object[]{l});
    }

    public void deleteAllMetadataHtmlConfigByModelId(Long l) {
        String string = "delete from model_html_config where metaDataId in (select metaDataId from model_filed_metadata where metaDataId=?)";
        this.pe.update(string, new Object[]{l});
    }

    public void deleteModelPersistenceCodeByModelId(Long l) {
        String string = "delete from model_persistence_code where dataModelId=?";
        this.pe.update(string, new Object[]{l});
    }

    public void deleteModelByModelId(Long l) {
        String string = "delete from model where dataModelId=?";
        this.pe.update(string, new Object[]{l});
    }

    public void updateModelResType(Long l, Integer n) {
        String string = "update model set modelResType=? where dataModelId=?";
        this.pe.update(string, new Object[]{n, l});
    }

    public void updateModelMainEditorFieldSign(Long l, String string) {
        String string2 = "update model set mainEditorFieldSign=? where dataModelId=?";
        this.pe.update(string2, new Object[]{string, l});
    }

    public ModelFiledInfoBean querySingleDataModelFieldBeanById(Long l) {
        String string = "select mc.*, md.* from model_filed_metadata md left join model_html_config mc on md.metaDataId=mc.metaDataId where md.metadataId=?";
        return (ModelFiledInfoBean)this.pe.querySingleRow(string, new Object[]{l}, new ModelFiledInfoBeanTransform());
    }

    public UpdateState updateModelMetadata(ModelFiledMetadata modelFiledMetadata) {
        return this.pe.update(modelFiledMetadata);
    }

    public void updateModelFiledHtmlConfig(ModelHtmlConfig modelHtmlConfig) {
        String string = "update model_html_config set htmlElementId=?, isMustFill=?, maxLength=?, defaultValue=?, choiceValue=?, errorMessage=?, htmlContent=?, allowableFile=?, dataType=?, style=?, cssClass=?, javascript=?, htmlDesc=?, checkRegex=?, defaultValidate=?, needMark=?, imageH=?, imageW=?, imageDisposeMode=?, linkType=?, linkModelId=?, linkFieldId=?, useSysUrl=?, fullEditor=?, mainEditor=?, editorW=?, editorH=?, blankCount=? where metaDataId=?";
        this.pe.update(string, modelHtmlConfig);
    }

    public List queryAllModelValidateConfigBean() {
        String string = "select * from model_validate_config";
        return this.pe.query(string, new ModelValidateConfigBeanTransform());
    }

    public ModelValidateConfigBean querySingleModelValidateConfigBean(Long l) {
        String string = "select * from model_validate_config where validateConfigId=?";
        return (ModelValidateConfigBean)this.pe.querySingleRow(string, new Object[]{l}, new ModelValidateConfigBeanTransform());
    }

    public List queryContentPathInjectAssistInfo(Long l) {
        String string = "select * from model_res_path_inject_assist where modelId=?";
        return this.pe.query(string, new Object[]{l}, new PathInjectAssistBeanTransform());
    }

    public PathInjectAssistBean querySingleContentPathInjectAssistInfo(Long l) {
        String string = "select * from model_res_path_inject_assist where metaDataId=?";
        return (PathInjectAssistBean)this.pe.querySingleRow(string, new Object[]{l}, new PathInjectAssistBeanTransform());
    }

    public void deletePathInjectAssistByMdId(Long l) {
        String string = "delete from model_res_path_inject_assist where metaDataId=?";
        this.pe.update(string, new Object[]{l});
    }

    public void deletePathInjectAssistByModelId(Long l) {
        String string = "delete from model_res_path_inject_assist where modelId=?";
        this.pe.update(string, new Object[]{l});
    }

    public void deleteClassExtModelIdByModelId(Long l) {
        String string = "update contentclass set extDataModelId=-1 where extDataModelId=?";
        this.pe.update(string, new Object[]{l});
    }

    public void deletePathInjectAssistByFieldName(Long l, String string) {
        String string2 = "delete from model_res_path_inject_assist where modelId=? and fieldName=?";
        this.pe.update(string2, new Object[]{l, string});
    }

    public void saveNewPathInjectAssistInfo(PathInjectAssist pathInjectAssist) {
        this.pe.save(pathInjectAssist);
    }

    public void updatePathInjectAssistInfo(String string, Long l) {
        String string2 = "update model_res_path_inject_assist set fieldName=? where metaDataId=?";
        this.pe.update(string2, new Object[]{string, l});
    }

    public Long querySystemTableCount(String string, Object[] objectArray) {
        return (Long)this.pe.querySingleObject(string, objectArray);
    }

    public List querySystemTableByQueryFlag(String string, Object[] objectArray) {
        return this.pe.queryResultMap(string, objectArray);
    }

    public List queryMutiQueryContentByQueryFlagAndPageInfo(String string, Object[] objectArray) {
        return this.pe.queryResultMap(string, objectArray, new ContentValueResultCallBack());
    }

    public List queryIndexMetadataForTable(String string) {
        if (StringUtil.hasSQLDChars(string)) {
            throw new FrameworkException("\u5305\u542b\u975e\u6cd5\u5b57\u7b26,\u672c\u6b21\u64cd\u4f5c\u5f3a\u5236\u4e2d\u6b62\u6267\u884c");
        }
        String string2 = "show index from " + string;
        return this.pe.queryResultMap(string2);
    }

    public void deleteIndexForTable(String string, String string2) {
        if (StringUtil.hasSQLDChars(string)) {
            throw new FrameworkException("\u5305\u542b\u975e\u6cd5\u5b57\u7b26,\u672c\u6b21\u64cd\u4f5c\u5f3a\u5236\u4e2d\u6b62\u6267\u884c");
        }
        if (StringUtil.hasSQLDChars(string2)) {
            throw new FrameworkException("\u5305\u542b\u975e\u6cd5\u5b57\u7b26,\u672c\u6b21\u64cd\u4f5c\u5f3a\u5236\u4e2d\u6b62\u6267\u884c");
        }
        String string3 = "ALTER TABLE " + string + " DROP INDEX " + string2;
        try {
            this.pe.update(string3);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createNewIndexForTable(String string, String string2, String string3) {
        if (StringUtil.hasSQLDChars(string)) {
            throw new FrameworkException("\u5305\u542b\u975e\u6cd5\u5b57\u7b26,\u672c\u6b21\u64cd\u4f5c\u5f3a\u5236\u4e2d\u6b62\u6267\u884c");
        }
        if (StringUtil.hasSQLDChars(string2)) {
            throw new FrameworkException("\u5305\u542b\u975e\u6cd5\u5b57\u7b26,\u672c\u6b21\u64cd\u4f5c\u5f3a\u5236\u4e2d\u6b62\u6267\u884c");
        }
        String string4 = "create index " + string2 + " on " + string + " (" + string3 + ")";
        try {
            this.pe.update(string4);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List queryAllSearchFieldSign() {
        String string = "select filedSign from model_filed_metadata where searchFlag=1";
        return this.pe.querySingleCloumn(string, String.class);
    }

    public List queryModelLinkFieldInfo(Long l) {
        String string = "select * from model_filed_metadata mfm, model_html_config mhc where mfm.dataModelId=? and mfm.metaDataId=mhc.metaDataId and mhc.htmlElementId in (1,7,8,9)";
        return this.pe.queryResultMap(string, new Object[]{l});
    }

    public static void clearCache() {
        Cache cache = (Cache)cacheManager.get("retrieveSingleDataModelBean");
        cache.clearAllEntry();
        cache = (Cache)cacheManager.get("querySingleFiledNameForQueryData");
        cache.clearAllEntry();
        cache = (Cache)cacheManager.get("queryAllDataModelBeanListByModelTypeAndSiteId");
        cache.clearAllEntry();
    }

    static {
        cacheManager.put("retrieveSingleDataModelBean", new LRUCache(500));
        cacheManager.put("querySingleFiledNameForQueryData", new LRUCache(3000));
        cacheManager.put("queryAllDataModelBeanListByModelTypeAndSiteId", new LRUCache(600));
    }
}

