/*
 * Decompiled with CFR 0.152.
 */
package cn.com.mjsoft.cms.resources.bean;

import cn.com.mjsoft.cms.behavior.InitSiteGroupInfoBehavior;
import cn.com.mjsoft.cms.common.Constant;
import cn.com.mjsoft.cms.site.bean.SiteGroupBean;
import cn.com.mjsoft.framework.config.impl.SystemConfiguration;
import cn.com.mjsoft.framework.util.FileUtil;
import cn.com.mjsoft.framework.util.StringUtil;
import java.io.File;
import java.io.Serializable;
import java.sql.Timestamp;
import org.apache.commons.lang.builder.ToStringBuilder;

public class SiteResourceBean
implements Serializable {
    private static final long serialVersionUID = 1543557418687797204L;
    private Long resId = -1L;
    private Long classId = -1L;
    private Long siteId = -1L;
    private String fileType;
    private Integer resType;
    private String resName;
    private String resSource;
    private Long resSize;
    private Integer width;
    private Integer height;
    private Integer duration;
    private String resolution;
    private String cover;
    private Integer haveMark;
    private Timestamp modifyTime;

    public Long getClassId() {
        return this.classId;
    }

    public void setClassId(Long classId) {
        this.classId = classId;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public Timestamp getModifyTime() {
        return this.modifyTime;
    }

    public void setModifyTime(Timestamp modifyTime) {
        this.modifyTime = modifyTime;
    }

    public Long getResId() {
        return this.resId;
    }

    public void setResId(Long resId) {
        this.resId = resId;
    }

    public String getResName() {
        return this.resName;
    }

    public void setResName(String resName) {
        this.resName = resName;
    }

    public Long getResSize() {
        return this.resSize;
    }

    public void setResSize(Long resSize) {
        this.resSize = resSize;
    }

    public String getResSource() {
        return this.resSource;
    }

    public void setResSource(String resSource) {
        this.resSource = resSource;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getResType() {
        return this.resType;
    }

    public void setResType(Integer resType) {
        this.resType = resType;
    }

    public String getSizeStr() {
        return FileUtil.changeFileSizeToStr(this.resSize);
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public String getResolution() {
        return this.resolution;
    }

    public void setResolution(String resolution) {
        this.resolution = resolution;
    }

    public String getCover() {
        return this.cover;
    }

    public void setCover(String cover) {
        this.cover = cover;
    }

    public Long getSiteId() {
        return this.siteId;
    }

    public void setSiteId(Long siteId) {
        this.siteId = siteId;
    }

    public Integer getHaveMark() {
        return this.haveMark;
    }

    public void setHaveMark(Integer haveMark) {
        this.haveMark = haveMark;
    }

    public String getUrl() {
        SiteGroupBean site = (SiteGroupBean)InitSiteGroupInfoBehavior.siteGroupIdInfoCache.getEntry(this.siteId);
        if (Constant.RESOURCE.IMAGE_RES_TYPE.equals(this.resType)) {
            return String.valueOf(site.getSiteImagePrefixUrl()) + this.resSource;
        }
        if (Constant.RESOURCE.VIDEO_RES_TYPE.equals(this.resType) || Constant.RESOURCE.MUSIC_RES_TYPE.equals(this.resType)) {
            return String.valueOf(site.getSiteMediaPrefixUrl()) + this.resSource;
        }
        if (Constant.RESOURCE.DOC_RES_TYPE.equals(this.resType) || Constant.RESOURCE.ANY_RES_TYPE.equals(this.resType)) {
            return String.valueOf(site.getSiteFilePrefixUrl()) + this.resSource;
        }
        return "";
    }

    public String getFullFilePath() {
        SiteGroupBean site = (SiteGroupBean)InitSiteGroupInfoBehavior.siteGroupIdInfoCache.getEntry(this.siteId);
        String rootPath = SystemConfiguration.getInstance().getSystemConfig().getSystemRealPath();
        String fileResSource = StringUtil.replaceString(this.resSource, "/", File.separator, false, false);
        if (Constant.RESOURCE.IMAGE_RES_TYPE.equals(this.resType)) {
            return String.valueOf(rootPath) + site.getSiteRoot() + File.separator + "upload" + File.separator + fileResSource;
        }
        if (Constant.RESOURCE.VIDEO_RES_TYPE.equals(this.resType) || Constant.RESOURCE.MUSIC_RES_TYPE.equals(this.resType)) {
            return String.valueOf(rootPath) + site.getSiteRoot() + File.separator + "video" + File.separator + fileResSource;
        }
        if (Constant.RESOURCE.DOC_RES_TYPE.equals(this.resType) || Constant.RESOURCE.ANY_RES_TYPE.equals(this.resType)) {
            return String.valueOf(rootPath) + site.getSiteRoot() + File.separator + "file" + File.separator + fileResSource;
        }
        return "";
    }

    public String getResizeImgUrl() {
        SiteGroupBean site = (SiteGroupBean)InitSiteGroupInfoBehavior.siteGroupIdInfoCache.getEntry(this.siteId);
        if (Constant.RESOURCE.IMAGE_RES_TYPE.equals(this.resType)) {
            return String.valueOf(site.getSiteImagePrefixUrl()) + StringUtil.replaceString(this.resSource, "/", "/imgResize", false, false);
        }
        return "";
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("resId", (Object)this.resId).append("haveMark", (Object)this.haveMark).append("resType", (Object)this.resType).append("resolution", (Object)this.resolution).append("cover", (Object)this.cover).append("siteId", (Object)this.siteId).append("resName", (Object)this.resName).append("source", (Object)this.resSource).append("duration", (Object)this.duration).append("fileType", (Object)this.fileType).append("classId", (Object)this.classId).append("height", (Object)this.height).append("url", (Object)this.getUrl()).append("resizeImgUrl", (Object)this.getResizeImgUrl()).append("sizeStr", (Object)this.getSizeStr()).append("width", (Object)this.width).append("modifyTime", (Object)this.modifyTime).append("size", (Object)this.resSize).toString();
    }
}

