/*
 * Decompiled with CFR 0.152.
 */
package cn.com.mjsoft.framework.persistence.core;

import cn.com.mjsoft.cms.channel.bean.ContentClassBean;
import cn.com.mjsoft.framework.exception.FrameworkException;
import cn.com.mjsoft.framework.persistence.core.CustomTypeValue;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public final class JdbcInstrument {
    private static final Logger _$5 = Logger.getLogger(JdbcInstrument.class);
    private static final String _$4 = "Informix";
    private static Pattern _$3 = Pattern.compile("\\s{1}\\S+\\s*=");
    private static Pattern _$2 = Pattern.compile("\\s*(?i)insert\\s{1,}into\\s{1,}.+");
    private static Pattern _$1 = Pattern.compile("\\w+\\s*[,)]");

    private JdbcInstrument() {
    }

    public static void setPreparedStatementParameterValue(PreparedStatement preparedStatement, int n, Object object) throws SQLException {
        if (object != null) {
            JdbcInstrument.setJavaTypeValue(preparedStatement, n, object);
        } else if (object == null) {
            boolean bl = false;
            try {
                bl = preparedStatement.getConnection().getMetaData().getDatabaseProductName().indexOf(_$4) != -1;
            }
            catch (Throwable throwable) {
                _$5.debug((Object)"\u65e0\u6cd5\u5f97\u5230\u5f53\u524d\u6570\u636e\u5e93\u7cfb\u7edf\u4fe1\u606f", throwable);
            }
            if (bl) {
                preparedStatement.setObject(n, null);
            } else {
                preparedStatement.setNull(n, 0);
            }
        }
    }

    public static void setJavaTypeValue(PreparedStatement preparedStatement, int n, Object object) throws SQLException {
        if (object instanceof String) {
            preparedStatement.setString(n, (String)object);
        } else if (object instanceof Integer) {
            preparedStatement.setInt(n, (Integer)object);
        } else if (object instanceof Long) {
            preparedStatement.setLong(n, (Long)object);
        } else if (object instanceof Float) {
            preparedStatement.setFloat(n, ((Float)object).floatValue());
        } else if (object instanceof Short) {
            preparedStatement.setShort(n, (Short)object);
        } else if (object instanceof Double) {
            preparedStatement.setDouble(n, (Double)object);
        } else if (object instanceof Boolean) {
            preparedStatement.setBoolean(n, (Boolean)object);
        } else if (object instanceof java.util.Date && !(object instanceof Date) && !(object instanceof Time) && !(object instanceof Timestamp)) {
            preparedStatement.setTimestamp(n, new Timestamp(((java.util.Date)object).getTime()));
        } else if (object instanceof Calendar) {
            preparedStatement.setTimestamp(n, new Timestamp(((Calendar)object).getTime().getTime()));
        } else if (object instanceof Date) {
            preparedStatement.setDate(n, (Date)object);
        } else if (object instanceof Byte) {
            preparedStatement.setByte(n, (Byte)object);
        } else if (object instanceof byte[]) {
            preparedStatement.setBytes(n, (byte[])object);
        } else if (object instanceof BigDecimal) {
            preparedStatement.setBigDecimal(n, (BigDecimal)object);
        } else if (object instanceof Blob) {
            preparedStatement.setBlob(n, (Blob)object);
        } else if (object instanceof Clob) {
            preparedStatement.setClob(n, (Clob)object);
        } else if (object instanceof InputStream) {
            InputStream inputStream = (InputStream)object;
            try {
                preparedStatement.setBinaryStream(n, inputStream, inputStream.available());
            }
            catch (IOException iOException) {
                _$5.error((Object)iOException);
                iOException.printStackTrace();
            }
        } else if (object instanceof CustomTypeValue) {
            ((CustomTypeValue)object).setTypeValue(preparedStatement, n);
        } else {
            preparedStatement.setObject(n, object);
        }
    }

    public static Object getResultSetColumnValue(ResultSet resultSet, int n, Class clazz) throws SQLException {
        if (clazz != null) {
            Object object = null;
            boolean bl = false;
            if (String.class.equals((Object)clazz)) {
                object = resultSet.getString(n);
            } else if (Boolean.class.equals((Object)clazz)) {
                object = resultSet.getBoolean(n) ? Boolean.TRUE : Boolean.FALSE;
                bl = true;
            } else if (Byte.class.equals((Object)clazz)) {
                object = new Byte(resultSet.getByte(n));
                bl = true;
            } else if (Short.class.equals((Object)clazz)) {
                object = new Short(resultSet.getShort(n));
                bl = true;
            } else if (Integer.class.equals((Object)clazz)) {
                object = new Integer(resultSet.getInt(n));
                bl = true;
            } else if (Long.class.equals((Object)clazz)) {
                object = new Long(resultSet.getLong(n));
                bl = true;
            } else if (Float.class.equals((Object)clazz)) {
                object = new Float(resultSet.getFloat(n));
                bl = true;
            } else if (Double.class.equals((Object)clazz) || Number.class.equals((Object)clazz)) {
                object = new Double(resultSet.getDouble(n));
                bl = true;
            } else {
                object = byte[].class.equals((Object)clazz) ? (Object)resultSet.getBytes(n) : (Date.class.equals((Object)clazz) ? resultSet.getDate(n) : (Time.class.equals((Object)clazz) ? resultSet.getTime(n) : (Timestamp.class.equals((Object)clazz) || java.util.Date.class.equals((Object)clazz) ? resultSet.getTimestamp(n) : (BigDecimal.class.equals((Object)clazz) ? resultSet.getBigDecimal(n) : (Blob.class.equals((Object)clazz) ? resultSet.getBlob(n) : (Clob.class.equals((Object)clazz) ? resultSet.getClob(n) : resultSet.getObject(n)))))));
            }
            if (bl && object != null && resultSet.wasNull()) {
                object = null;
            }
            return object;
        }
        return JdbcInstrument.getResultSetValue(resultSet, n);
    }

    public static Object getResultSetValue(ResultSet resultSet, int n) throws SQLException {
        Object object = resultSet.getObject(n);
        if (object instanceof Blob) {
            object = resultSet.getBytes(n);
        } else if (object instanceof Clob) {
            object = resultSet.getString(n);
        } else if (object != null && object.getClass().getName().startsWith("oracle.sql.TIMESTAMP")) {
            object = resultSet.getTimestamp(n);
        } else if (object != null && object.getClass().getName().startsWith("oracle.sql.DATE")) {
            String string = resultSet.getMetaData().getColumnClassName(n);
            object = "java.sql.Timestamp".equals(string) || "oracle.sql.TIMESTAMP".equals(string) ? resultSet.getTimestamp(n) : resultSet.getDate(n);
        } else if (object != null && object instanceof Date && "java.sql.Timestamp".equals(resultSet.getMetaData().getColumnClassName(n))) {
            object = resultSet.getTimestamp(n);
        }
        return object;
    }

    public static boolean closeConnection(Connection connection) {
        boolean bl = false;
        if (connection != null) {
            try {
                connection.close();
                connection = null;
                _$5.debug((Object)"\u91ca\u653econnection\u6210\u529f");
                bl = true;
            }
            catch (SQLException sQLException) {
                bl = false;
                _$5.warn((Object)"\u65e0\u6cd5\u91ca\u653econnection", (Throwable)sQLException);
            }
            catch (Exception exception) {
                bl = false;
                _$5.warn((Object)"\u672a\u77e5\u5f02\u5e38\u51fa\u73b0\uff0c\u65e0\u6cd5\u91ca\u653econnection", (Throwable)exception);
            }
        }
        return bl;
    }

    public static void closeStatement(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
                statement = null;
                _$5.debug((Object)"\u91ca\u653estatment\u6210\u529f");
            }
            catch (SQLException sQLException) {
                _$5.warn((Object)"\u65e0\u6cd5\u91ca\u653estatment", (Throwable)sQLException);
            }
            catch (Exception exception) {
                _$5.warn((Object)"\u672a\u77e5\u5f02\u5e38\u51fa\u73b0\uff0c\u65e0\u6cd5\u91ca\u653estatment", (Throwable)exception);
            }
        }
    }

    public static void closeResultSet(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
                resultSet = null;
                _$5.debug((Object)"\u91ca\u653eResult\u6210\u529f");
            }
            catch (SQLException sQLException) {
                _$5.warn((Object)"\u65e0\u6cd5\u91ca\u653eResultSet", (Throwable)sQLException);
            }
            catch (Exception exception) {
                _$5.warn((Object)"\u672a\u77e5\u5f02\u5e38\u51fa\u73b0\uff0c\u65e0\u6cd5\u91ca\u653eResultSet", (Throwable)exception);
            }
        }
    }

    public static Object[] disposeSqlParamArgs(String string, Object object) {
        boolean bl = false;
        if (_$2.matcher(string).matches()) {
            bl = true;
        }
        String string2 = null;
        String string3 = null;
        Matcher matcher = null;
        matcher = bl ? _$1.matcher(string) : _$3.matcher(string);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Class<?> clazz = object.getClass();
        Field field = null;
        try {
            while (matcher.find()) {
                string2 = matcher.group();
                string3 = bl ? string2.replace(",", "").replace(")", "") : string2.replace("=", "");
                field = clazz.getDeclaredField(string3.trim());
                field.setAccessible(true);
                arrayList.add(field.get(object));
            }
        }
        catch (Exception exception) {
            if (exception instanceof NoSuchFieldException) {
                throw new FrameworkException("update\u8bed\u53e5\u4e2d\u5bf9\u5e94\u7684\u5b57\u6bb5 [" + string3 + "]\u4e0d\u5b58\u5728bean\u4e2d," + object.getClass());
            }
            exception.printStackTrace();
        }
        return arrayList.toArray();
    }

    public static Object[] disposeSqlParamArgsForMap(String string, Map map) {
        boolean bl = false;
        if (_$2.matcher(string).matches()) {
            bl = true;
        }
        String string2 = null;
        String string3 = null;
        Matcher matcher = null;
        matcher = bl ? _$1.matcher(string) : _$3.matcher(string);
        ArrayList arrayList = new ArrayList();
        while (matcher.find()) {
            string2 = matcher.group();
            string3 = bl ? string2.replace(",", "").replace(")", "") : string2.replace("=", "");
            arrayList.add(map.get(string3.trim()));
        }
        return arrayList.toArray();
    }

    public static void main(String[] stringArray) {
        String string = "update contentclass set   classFlag  =  ?  , className=?, classType=?, classDesc=?, contentType=?, workflowId=?,  classHomeTemplateUrl=?, classTemplateUrl=?, contentTemplateUrl=?, listPageLimit=?, classHomeProduceType=?, classProduceType=?, contentProduceType=?, showStatus=?, useStatus=?, relateRangeType=?, contentPublishRuleId=?, classHomePublishRuleId=?, classPublishRuleId=?, outLink=?, classPageGuideImg=?, openComment=?, mustCommentCensor=?, notMemberComment=?, commentCaptcha=?, filterCommentSensitive=?, commentHtml=?, sensitiveMode=?, seoTitle=?, seoKeyword=?, seoDesc=?, searchStatus=?, memberAddContent=?, extDataModelId=?, editorImageH=?, editorImageW=?, homeImageW=?, homeImageH=?, classHomeImageW=?, classHomeImageH=?, listImageW=?, listImageH=?, contentImageW=?, contentImageH=? where classId=?";
        ContentClassBean contentClassBean = new ContentClassBean();
        contentClassBean.setClassFlag("asdasd");
        contentClassBean.setClassId(1111L);
        contentClassBean.setNotMemberComment(99999);
        contentClassBean.setContentImageH(323);
        String string2 = "insert into content_system_articleinfo (contentId, CMS_SYS_IS_PAGE, isSingleClassType, outLink, content, firstPageContent, pageCount) values (?,?,?,?,?,?,?)";
        Pattern pattern = Pattern.compile("\\s*(?i)insert\\s{1,}into\\s{1,}.+");
        Pattern pattern2 = Pattern.compile("\\w+\\s*[,)]");
        Matcher matcher = pattern2.matcher(string2);
        while (matcher.find()) {
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("classFlag", "1231231");
        hashMap.put("classHomeProduceType", 1);
        JdbcInstrument.disposeSqlParamArgsForMap(string, hashMap);
    }
}

