/*
 * Decompiled with CFR 0.152.
 */
package cn.com.mjsoft.framework.util;

import cn.com.mjsoft.framework.config.impl.SystemConfiguration;
import cn.com.mjsoft.framework.util.FileUtil;
import cn.com.mjsoft.framework.util.StringUtil;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.im4java.core.CompositeCmd;
import org.im4java.core.ConvertCmd;
import org.im4java.core.GMOperation;
import org.im4java.core.IMOperation;
import org.im4java.core.Operation;
import org.im4java.process.StandardStream;

public class ImageUtil {
    private static Logger _$1 = Logger.getLogger(ImageUtil.class);
    public static final String GM_PATH = "core" + File.separator + "extools" + File.separator + "image" + File.separator + "GraphicsMagick";

    public ByteArrayOutputStream ResizeImg(InputStream inputStream, int n, int n2) throws IOException {
        Object object;
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        double d = 0.0;
        Image image = bufferedImage.getScaledInstance(n, n2, 4);
        if (bufferedImage.getHeight() > n2 || bufferedImage.getWidth() > n) {
            d = bufferedImage.getHeight() > bufferedImage.getWidth() ? new Integer(n2).doubleValue() / (double)bufferedImage.getHeight() : new Integer(n).doubleValue() / (double)bufferedImage.getWidth();
            object = new AffineTransformOp(AffineTransform.getScaleInstance(d, d), null);
            image = ((AffineTransformOp)object).filter(bufferedImage, null);
        }
        object = new BufferedImage(n3, n4, 1);
        Graphics2D graphics2D = ((BufferedImage)object).createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, n3, n4);
        if (n == image.getWidth(null)) {
            graphics2D.drawImage(image, 0, (n2 - image.getHeight(null)) / 2, image.getWidth(null), image.getHeight(null), Color.white, null);
        } else {
            graphics2D.drawImage(image, (n - image.getWidth(null)) / 2, 0, image.getWidth(null), image.getHeight(null), Color.white, null);
        }
        graphics2D.dispose();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)byteArrayOutputStream);
        jPEGImageEncoder.encode((BufferedImage)image);
        return byteArrayOutputStream;
    }

    public static void subPicture(File file, String string, int n, int n2, int n3, int n4) throws IOException {
        ImageUtil._$1(ImageIO.read(file), string, n, n2, n3, n4);
    }

    private static void _$1(BufferedImage bufferedImage, String string, int n, int n2, int n3, int n4) throws IOException {
        BufferedImage bufferedImage2 = bufferedImage.getSubimage(n, n2, n3, n4);
        BufferedImage bufferedImage3 = new BufferedImage(n3, n4, 1);
        bufferedImage3.getGraphics().drawImage(bufferedImage2.getScaledInstance(n3, n4, 4), 0, 0, null);
        File file = new File(string);
        ImageIO.write((RenderedImage)bufferedImage3, "JPEG", file);
    }

    public static void zoomPicture(File file, String string, double d) throws IOException {
        ImageIO.setUseCache(true);
        ImageIO.setCacheDirectory(new File(SystemConfiguration.getInstance().getSystemConfig().getSystemRealPath() + "sys_temp"));
        ImageUtil._$1(ImageIO.read(file), string, d);
    }

    public static void zoomPicture(File file, String string, int n, int n2) throws IOException {
        ImageIO.setUseCache(true);
        ImageIO.setCacheDirectory(new File(SystemConfiguration.getInstance().getSystemConfig().getSystemRealPath() + "sys_temp"));
        ImageUtil._$1(ImageIO.read(file), string, n, n2);
    }

    public static void zoomPicture(InputStream inputStream, String string, double d) throws IOException {
        ImageUtil._$1(ImageIO.read(inputStream), string, d);
    }

    private static void _$1(BufferedImage bufferedImage, String string, double d) throws IOException {
        if (bufferedImage == null) {
            return;
        }
        double d2 = d;
        double d3 = 1.0;
        if ((double)bufferedImage.getHeight() > d2 || (double)bufferedImage.getWidth() > d2) {
            d3 = d2 / (double)bufferedImage.getWidth();
        }
        int n = (int)Math.floor((double)bufferedImage.getWidth() * d3);
        int n2 = (int)Math.floor((double)bufferedImage.getHeight() * d3);
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 1);
        Graphics graphics = bufferedImage2.getGraphics();
        Image image = bufferedImage.getScaledInstance(n, n2, 4);
        graphics.drawImage(image, 0, 0, null);
        image.flush();
        File file = new File(string);
        ImageIO.write((RenderedImage)bufferedImage2, "JPEG", file);
        graphics.dispose();
    }

    private static void _$1(BufferedImage bufferedImage, String string, int n, int n2) throws IOException {
        if (bufferedImage == null) {
            return;
        }
        int n3 = n;
        int n4 = n2;
        BufferedImage bufferedImage2 = new BufferedImage(n3, n4, 1);
        Graphics graphics = bufferedImage2.getGraphics();
        Image image = bufferedImage.getScaledInstance(n3, n4, 4);
        graphics.drawImage(image, 0, 0, null);
        image.flush();
        File file = new File(string);
        ImageIO.write((RenderedImage)bufferedImage2, "JPEG", file);
        graphics.dispose();
    }

    public static void reduceImg(String string, String string2, int n, int n2) {
        try {
            File file = new File(string);
            if (!file.exists()) {
                return;
            }
            BufferedImage bufferedImage = ImageIO.read(file);
            BufferedImage bufferedImage2 = new BufferedImage(n, n2, 1);
            bufferedImage2.getGraphics().drawImage(bufferedImage.getScaledInstance(n, n2, 4), 0, 0, null);
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)fileOutputStream);
            jPEGImageEncoder.encode(bufferedImage2);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File downloadImageByUrl(String string, String string2) {
        File file = null;
        try {
            URL uRL = new URL(string);
            String string3 = uRL.getFile();
            String string4 = null;
            if (StringUtil.isStringNotNull(string3)) {
                string4 = StringUtil.subString(string3, string3.lastIndexOf("."), string3.length());
            }
            if (StringUtil.isStringNull(string4)) {
                return null;
            }
            file = new File(string2 + StringUtil.getUUIDString() + string4);
            File file2 = new File(string2);
            if (!file2.exists()) {
                file2.mkdirs();
            }
            InputStream inputStream = null;
            BufferedInputStream bufferedInputStream = null;
            FileOutputStream fileOutputStream = null;
            BufferedOutputStream bufferedOutputStream = null;
            try {
                inputStream = uRL.openStream();
                bufferedInputStream = new BufferedInputStream(inputStream);
                fileOutputStream = new FileOutputStream(file);
                bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                FileUtil.writeFile(bufferedInputStream, bufferedOutputStream);
            }
            finally {
                _$1.info((Object)("\u5c1d\u8bd5\u4e0b\u8f7d\u56fe\u7247:" + string));
                if (inputStream != null) {
                    inputStream.close();
                }
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (bufferedOutputStream != null) {
                    bufferedOutputStream.close();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (file == null) {
            return null;
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] getImageHeightAndWidth(String string) {
        File file = new File(string);
        FileInputStream fileInputStream = null;
        Object[] objectArray = new Object[]{0, 0, 0L};
        try {
            fileInputStream = new FileInputStream(file);
            ImageIO.setUseCache(true);
            File file2 = new File(SystemConfiguration.getInstance().getSystemConfig().getSystemRealPath() + "sys_temp");
            if (!file2.exists()) {
                file2.mkdirs();
            }
            ImageIO.setCacheDirectory(new File(SystemConfiguration.getInstance().getSystemConfig().getSystemRealPath() + "sys_temp"));
            _$1.info((Object)(">>>>>>>>>cache dir>>>>>>>>>:" + SystemConfiguration.getInstance().getSystemConfig().getSystemRealPath() + "sys_temp"));
            BufferedImage bufferedImage = ImageIO.read(fileInputStream);
            objectArray[0] = bufferedImage.getWidth();
            objectArray[1] = bufferedImage.getHeight();
            objectArray[2] = file.lastModified();
            bufferedImage.flush();
        }
        catch (Exception exception) {
            objectArray = new Object[]{0, 0, 0L};
            exception.printStackTrace();
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createCharMark(String string, String string2, String string3, Color color, float f, String string4, int n, int n2, int n3) {
        ImageIcon imageIcon = new ImageIcon(string);
        Image image = imageIcon.getImage();
        int n4 = image.getWidth(null);
        int n5 = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(n4, n5, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(color);
        graphics2D.setBackground(Color.white);
        graphics2D.drawImage(image, 0, 0, null);
        AttributedString attributedString = new AttributedString(string3);
        Font font = new Font(string4, 1, n);
        attributedString.addAttribute(TextAttribute.FONT, font, 0, string3.length());
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        graphics2D.drawString(attributedCharacterIterator, n4 - n2, n5 - n3);
        graphics2D.dispose();
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string2);
            JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)fileOutputStream);
            JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage);
            jPEGEncodeParam.setQuality(f, true);
            jPEGImageEncoder.encode(bufferedImage, jPEGEncodeParam);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            _$1.error((Object)exception);
            exception.printStackTrace();
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public static void cutImage(String string, String string2, int n, int n2, int n3, int n4) throws Exception {
        int n5 = n3 - n;
        int n6 = n4 - n2;
        IMOperation iMOperation = new IMOperation();
        iMOperation.addImage();
        iMOperation.crop(Integer.valueOf(n5), Integer.valueOf(n6), Integer.valueOf(n), Integer.valueOf(n2));
        if (n5 > 1000 || n6 > 1000) {
            iMOperation.quality(Double.valueOf(96.0));
        } else {
            iMOperation.quality(Double.valueOf(100.0));
        }
        iMOperation.addImage();
        ConvertCmd convertCmd = new ConvertCmd(true);
        convertCmd.setErrorConsumer(StandardStream.STDERR);
        String string3 = System.getProperty("os.name").toLowerCase();
        if (string3.indexOf("win") != -1) {
            convertCmd.setSearchPath(SystemConfiguration.getInstance().getSystemConfig().getSystemRealPath() + GM_PATH);
        }
        convertCmd.run((Operation)iMOperation, (Object[])new String[]{string, string2});
    }

    public static void resizeImage(int n, int n2, String string, String string2, int n3) throws Exception {
        IMOperation iMOperation = new IMOperation();
        iMOperation.addImage();
        if (n2 == -1) {
            iMOperation.resize(Integer.valueOf(n), null);
        } else if (n == -1) {
            iMOperation.resize(null, Integer.valueOf(n2));
        } else {
            iMOperation.resize(Integer.valueOf(n), Integer.valueOf(n2), ">");
        }
        iMOperation.quality(Double.valueOf(n3));
        iMOperation.addImage();
        ConvertCmd convertCmd = new ConvertCmd(true);
        convertCmd.setErrorConsumer(StandardStream.STDERR);
        String string3 = System.getProperty("os.name").toLowerCase();
        if (string3.indexOf("win") != -1) {
            convertCmd.setSearchPath(SystemConfiguration.getInstance().getSystemConfig().getSystemRealPath() + GM_PATH);
        }
        convertCmd.run((Operation)iMOperation, (Object[])new String[]{string, string2});
    }

    public static void addImageTextMark(String string, String string2, String string3, String string4, String string5, int n, int n2, int n3) throws Exception {
        GMOperation gMOperation = new GMOperation();
        gMOperation.font(string4).gravity("southeast").pointsize(Integer.valueOf(n)).fill(string5).draw("text " + n2 + "," + n3 + " " + "'" + string3 + "'");
        gMOperation.quality(Double.valueOf(100.0));
        gMOperation.addImage();
        gMOperation.addImage();
        ConvertCmd convertCmd = new ConvertCmd(true);
        convertCmd.setErrorConsumer(StandardStream.STDERR);
        String string6 = System.getProperty("os.name").toLowerCase();
        if (string6.indexOf("win") != -1) {
            convertCmd.setSearchPath(SystemConfiguration.getInstance().getSystemConfig().getSystemRealPath() + GM_PATH);
        }
        convertCmd.run((Operation)gMOperation, (Object[])new String[]{string, string2});
    }

    public static boolean addImageMark(String string, String string2, String string3, String string4, int n, int n2, int n3, int n4, int n5) {
        File file = new File(string3);
        if (!file.exists()) {
            return false;
        }
        IMOperation iMOperation = new IMOperation();
        iMOperation.gravity(string4).geometry(Integer.valueOf(n), Integer.valueOf(n2), Integer.valueOf(n3), Integer.valueOf(n4)).dissolve(Integer.valueOf(n5));
        iMOperation.quality(Double.valueOf(100.0));
        iMOperation.addImage();
        iMOperation.addImage();
        iMOperation.addImage();
        CompositeCmd compositeCmd = new CompositeCmd(true);
        compositeCmd.setErrorConsumer(StandardStream.STDERR);
        String string5 = System.getProperty("os.name").toLowerCase();
        if (string5.indexOf("win") != -1) {
            compositeCmd.setSearchPath(SystemConfiguration.getInstance().getSystemConfig().getSystemRealPath() + GM_PATH);
        }
        boolean bl = false;
        try {
            compositeCmd.run((Operation)iMOperation, (Object[])new String[]{string3, string, string2});
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
            exception.printStackTrace();
        }
        return bl;
    }

    public static void main(String[] stringArray) throws Exception {
        Random random = new Random();
        ImageUtil.addImageMark("D:/t4.jpg", "D:/t42.jpg", "D:/jtop.png", "southeast", 280, 65, 200, 40, 100);
    }
}

