/*
 * Decompiled with CFR 0.152.
 */
package cn.com.mjsoft.framework.util;

import cn.com.mjsoft.framework.exception.FrameworkException;
import cn.com.mjsoft.framework.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import org.wltea.analyzer.IKSegmentation;
import org.wltea.analyzer.Lexeme;
import org.wltea.analyzer.lucene.IKAnalyzer;

public class LuceneUtil {
    private static Logger _$1 = Logger.getLogger(LuceneUtil.class);
    public static Analyzer analyzer = new IKAnalyzer();

    public static IndexSearcher createSearcher(IndexReader indexReader) {
        if (indexReader == null) {
            return null;
        }
        return new IndexSearcher(indexReader);
    }

    public static IndexReader createReader(String string) {
        IndexReader indexReader = null;
        File file = new File(string);
        if (file.exists() && file.isDirectory()) {
            try {
                return IndexReader.open((Directory)FSDirectory.open((File)new File(string)));
            }
            catch (Exception exception) {
                _$1.error((Object)"[createReader] \u5f53\u524d\u7ad9\u70b9\u65e0\u4efb\u4f55\u7d22\u5f15\u5143\u6587\u4ef6.");
            }
        } else {
            _$1.error((Object)"[LuceneUtil] createReader: \u6307\u5b9a\u7684\u7d22\u5f15\u76ee\u5f55\u4e0d\u5b58\u5728!");
        }
        return indexReader;
    }

    public static IndexWriter createWriter(String string, double d, int n, int n2) {
        IndexWriter indexWriter = null;
        File file = new File(string);
        if (file.exists() && file.isDirectory()) {
            file.mkdirs();
        }
        try {
            FSDirectory fSDirectory = FSDirectory.open((File)new File(string));
            indexWriter = LuceneUtil.createWriter((Directory)fSDirectory, d, n, n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            _$1.error((Object)exception);
        }
        return indexWriter;
    }

    public static IndexWriter createWriter(Directory directory, double d, int n, int n2) {
        IndexWriter indexWriter = null;
        try {
            IndexWriterConfig indexWriterConfig = new IndexWriterConfig(Version.LUCENE_36, analyzer);
            indexWriterConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            indexWriterConfig.setRAMBufferSizeMB(d);
            LogByteSizeMergePolicy logByteSizeMergePolicy = new LogByteSizeMergePolicy();
            logByteSizeMergePolicy.setMergeFactor(n);
            logByteSizeMergePolicy.setMaxMergeDocs(n2);
            logByteSizeMergePolicy.setUseCompoundFile(true);
            indexWriterConfig.setMergePolicy((MergePolicy)logByteSizeMergePolicy);
            indexWriter = new IndexWriter(directory, indexWriterConfig);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            _$1.error((Object)exception);
        }
        return indexWriter;
    }

    public static Object[] reopenReaderAndSearcher(IndexSearcher indexSearcher) {
        return LuceneUtil.reopenReaderAndSearcher(indexSearcher, null);
    }

    public static Object[] reopenReaderAndSearcher(IndexSearcher indexSearcher, IndexWriter indexWriter) {
        if (indexSearcher == null) {
            throw new FrameworkException("[LuceneUtil] : oldSearch:" + indexSearcher);
        }
        IndexReader indexReader = indexSearcher.getIndexReader();
        if (indexReader == null) {
            throw new FrameworkException("[LuceneUtil] : oldReader:" + indexSearcher);
        }
        try {
            IndexReader indexReader2 = null;
            indexReader2 = indexWriter != null ? IndexReader.openIfChanged((IndexReader)indexReader, (IndexWriter)indexWriter, (boolean)true) : IndexReader.openIfChanged((IndexReader)indexReader);
            if (indexReader2 != null) {
                return new Object[]{new IndexSearcher(indexReader2), indexSearcher};
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            _$1.error((Object)exception);
        }
        return new Object[]{indexSearcher, null};
    }

    public static void addOrUpdateIndexDocument(IndexWriter indexWriter, Document document, String string) {
        if (document == null || indexWriter == null) {
            _$1.error((Object)"[LuceneUtil] addOrUpdateIndexDocument \u53c2\u6570\u4e3a\u7a7a");
            return;
        }
        try {
            indexWriter.updateDocument(new Term("contentId", string), document);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            _$1.error((Object)exception);
        }
    }

    public static void deleteIndexDocument(IndexWriter indexWriter, Term term) {
        if (indexWriter == null) {
            _$1.error((Object)"[LuceneUtil] deleteIndexDocument \u53c2\u6570\u4e3a\u7a7a");
            return;
        }
        try {
            indexWriter.deleteDocuments(term);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            _$1.error((Object)exception);
        }
    }

    public static void close(IndexWriter indexWriter) {
        if (indexWriter != null) {
            try {
                indexWriter.forceMerge(3);
                indexWriter.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                _$1.error((Object)exception);
            }
        }
    }

    public static void commit(IndexWriter indexWriter) {
        try {
            if (indexWriter != null) {
                indexWriter.forceMerge(3);
                indexWriter.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            _$1.error((Object)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List wordAnalysis(String string, String string2, boolean bl) {
        if (StringUtil.isStringNull(string)) {
            return new ArrayList();
        }
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = new ArrayList<String>();
        ByteArrayInputStream byteArrayInputStream = null;
        Reader reader = null;
        try {
            Lexeme lexeme;
            byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            reader = new InputStreamReader(byteArrayInputStream);
            IKSegmentation iKSegmentation = new IKSegmentation(reader, bl);
            while ((lexeme = iKSegmentation.next()) != null) {
                arrayList.add(lexeme.getLexemeText());
                stringBuffer.append(lexeme.getLexemeText()).append(string2);
            }
            if (stringBuffer.length() > 1) {
                stringBuffer.delete(stringBuffer.length() - string2.length(), stringBuffer.length());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (byteArrayInputStream != null) {
                try {
                    ((InputStream)byteArrayInputStream).close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        _$1.debug((Object)("[wordAnalysis] " + stringBuffer.toString()));
        return arrayList;
    }
}

