/*
 * Decompiled with CFR 0.152.
 */
package cn.com.mjsoft.framework.util;

import cn.com.mjsoft.cms.common.Constant;
import java.util.Date;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

public class ScheduleJobUtil {
    private static Logger _$2 = Logger.getLogger(ScheduleJobUtil.class);
    private static final Properties _$1 = new Properties();

    public static JobDetail buildNewJobDetail(Class clazz, JobKey jobKey, String string) {
        return JobBuilder.newJob((Class)clazz).withDescription(string).withIdentity(jobKey).build();
    }

    public static Trigger buildNewPeriodTrigger(TriggerKey triggerKey, Integer n, int n2, boolean bl) {
        SimpleScheduleBuilder simpleScheduleBuilder = SimpleScheduleBuilder.simpleSchedule();
        if (Constant.JOB.PERROID_SEC.equals(n)) {
            simpleScheduleBuilder = simpleScheduleBuilder.withIntervalInSeconds(n2);
        } else if (Constant.JOB.PERROID_MIN.equals(n)) {
            simpleScheduleBuilder = simpleScheduleBuilder.withIntervalInMinutes(n2);
        } else if (Constant.JOB.PERROID_HOUR.equals(n)) {
            simpleScheduleBuilder = simpleScheduleBuilder.withIntervalInHours(n2);
        } else if (Constant.JOB.PERROID_DAY.equals(n)) {
            simpleScheduleBuilder = simpleScheduleBuilder.withIntervalInHours(24 * n2);
        } else {
            return null;
        }
        if (bl) {
            simpleScheduleBuilder = simpleScheduleBuilder.repeatForever();
        }
        return TriggerBuilder.newTrigger().withIdentity(triggerKey).withSchedule((ScheduleBuilder)simpleScheduleBuilder).build();
    }

    public static Trigger buildNewCronTrigger(TriggerKey triggerKey, String string) {
        return TriggerBuilder.newTrigger().withIdentity(triggerKey).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)string)).build();
    }

    public static Trigger buildNewAtOnceTrigger(TriggerKey triggerKey) {
        return TriggerBuilder.newTrigger().withIdentity(triggerKey).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule()).startNow().build();
    }

    public static void regJob(Scheduler scheduler, JobDetail jobDetail, boolean bl) throws SchedulerException {
        scheduler.addJob(jobDetail, bl);
    }

    public static boolean removeJob(Scheduler scheduler, JobKey jobKey) throws SchedulerException {
        return scheduler.deleteJob(jobKey);
    }

    public static Date regScheduleJob(Scheduler scheduler, JobDetail jobDetail, Trigger trigger) throws SchedulerException {
        _$2.info((Object)("[Schedule] \u6ce8\u518cJob:" + jobDetail + ", \u89e6\u53d1\u5668:" + trigger));
        return scheduler.scheduleJob(jobDetail, trigger);
    }

    public static Date regScheduleJobTrigger(Scheduler scheduler, Trigger trigger) throws SchedulerException {
        return scheduler.scheduleJob(trigger);
    }

    public static boolean stopScheduleJob(Scheduler scheduler, TriggerKey triggerKey) throws SchedulerException {
        return scheduler.unscheduleJob(triggerKey);
    }

    public static Date reScheduleJob(Scheduler scheduler, TriggerKey triggerKey, Trigger trigger) throws SchedulerException {
        return scheduler.rescheduleJob(triggerKey, trigger);
    }

    public static void triggerJob(Scheduler scheduler, JobKey jobKey) throws SchedulerException {
        scheduler.triggerJob(jobKey);
    }

    public static void triggerJob(Scheduler scheduler, JobKey jobKey, JobDataMap jobDataMap) throws SchedulerException {
        scheduler.triggerJob(jobKey, jobDataMap);
    }

    public static void pauseTrigger(Scheduler scheduler, TriggerKey triggerKey) throws SchedulerException {
        scheduler.pauseTrigger(triggerKey);
    }

    public static void resumeTrigger(Scheduler scheduler, TriggerKey triggerKey) throws SchedulerException {
        scheduler.resumeTrigger(triggerKey);
    }

    public static void pauseJob(Scheduler scheduler, JobKey jobKey) throws SchedulerException {
        scheduler.pauseJob(jobKey);
    }

    public static void resumeJob(Scheduler scheduler, JobKey jobKey) throws SchedulerException {
        scheduler.resumeJob(jobKey);
    }

    public static void pauseAll(Scheduler scheduler) throws SchedulerException {
        scheduler.pauseAll();
    }

    public static void resumeAll(Scheduler scheduler) throws SchedulerException {
        scheduler.resumeAll();
    }

    public static void start(Scheduler scheduler) throws SchedulerException {
        _$2.info((Object)"[Schedule] Schedule\u5df2\u542f\u52a8!");
        scheduler.start();
    }

    public static boolean isStarted(Scheduler scheduler) throws SchedulerException {
        return scheduler.isStarted();
    }

    public static void shutdown(Scheduler scheduler) throws SchedulerException {
        scheduler.shutdown();
    }

    public static void init(Properties properties) {
        if (properties != null) {
            // empty if block
        }
    }
}

