/*
 * Decompiled with CFR 0.152.
 */
package cn.com.mjsoft.framework.util.jdk14zip;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;

public class InflaterInputStream
extends FilterInputStream {
    protected Inflater _$8;
    protected byte[] _$7;
    protected int _$6;
    private boolean _$5 = false;
    private boolean _$4 = false;
    boolean _$3 = false;
    private byte[] _$2 = new byte[1];
    private byte[] _$1 = new byte[512];

    private void _$2() throws IOException {
        if (this._$5) {
            throw new IOException("Stream closed");
        }
    }

    public InflaterInputStream(InputStream inputStream, Inflater inflater, int n) {
        super(inputStream);
        if (inputStream == null || inflater == null) {
            throw new NullPointerException();
        }
        if (n <= 0) {
            throw new IllegalArgumentException("buffer size <= 0");
        }
        this._$8 = inflater;
        this._$7 = new byte[n];
    }

    public InflaterInputStream(InputStream inputStream, Inflater inflater) {
        this(inputStream, inflater, 512);
    }

    public InflaterInputStream(InputStream inputStream) {
        this(inputStream, new Inflater());
        this._$3 = true;
    }

    public int read() throws IOException {
        this._$2();
        return this.read(this._$2, 0, 1) == -1 ? -1 : this._$2[0] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this._$2();
        if ((n | n2 | n + n2 | byArray.length - (n + n2)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        try {
            int n3;
            while ((n3 = this._$8.inflate(byArray, n, n2)) == 0) {
                if (this._$8.finished() || this._$8.needsDictionary()) {
                    this._$4 = true;
                    return -1;
                }
                if (!this._$8.needsInput()) continue;
                this._$1();
            }
            return n3;
        }
        catch (DataFormatException dataFormatException) {
            String string = dataFormatException.getMessage();
            throw new ZipException(string != null ? string : "Invalid ZLIB data format");
        }
    }

    public int available() throws IOException {
        this._$2();
        if (this._$4) {
            return 0;
        }
        return 1;
    }

    public long skip(long l) throws IOException {
        int n;
        int n2;
        if (l < 0L) {
            throw new IllegalArgumentException("negative skip length");
        }
        this._$2();
        int n3 = (int)Math.min(l, Integer.MAX_VALUE);
        for (n = 0; n < n3; n += n2) {
            n2 = n3 - n;
            if (n2 > this._$1.length) {
                n2 = this._$1.length;
            }
            if ((n2 = this.read(this._$1, 0, n2)) != -1) continue;
            this._$4 = true;
            break;
        }
        return n;
    }

    public void close() throws IOException {
        if (!this._$5) {
            if (this._$3) {
                this._$8.end();
            }
            this.in.close();
            this._$5 = true;
        }
    }

    protected void _$1() throws IOException {
        this._$2();
        this._$6 = this.in.read(this._$7, 0, this._$7.length);
        if (this._$6 == -1) {
            throw new EOFException("Unexpected end of ZLIB input stream");
        }
        this._$8.setInput(this._$7, 0, this._$6);
    }
}

