/*
 * Decompiled with CFR 0.152.
 */
package org.im4java.core;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import org.im4java.core.IMOperation;
import org.im4java.core.IdentifyCmd;
import org.im4java.core.InfoException;
import org.im4java.process.ArrayListOutputConsumer;
import org.im4java.process.InputProvider;
import org.im4java.process.Pipe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Info {
    private Hashtable<String, String> iAttributes = null;
    private LinkedList<Hashtable<String, String>> iAttribList = new LinkedList();
    private int iOldIndent = 0;
    private String iPrefix = "";

    public Info(String string) throws InfoException {
        this.getCompleteInfo(string, null);
    }

    public Info(String string, InputStream inputStream) throws InfoException {
        if (inputStream != null && !string.equals("-") && !string.endsWith(":-")) {
            throw new IllegalArgumentException("illegal filename for piped input");
        }
        this.getCompleteInfo(string, inputStream);
    }

    public Info(String string, boolean bl) throws InfoException {
        if (!bl) {
            this.getCompleteInfo(string, null);
        } else {
            this.getBaseInfo(string, null);
        }
    }

    public Info(String string, InputStream inputStream, boolean bl) throws InfoException {
        if (inputStream != null && !string.equals("-") && !string.endsWith(":-")) {
            throw new IllegalArgumentException("illegal filename for piped input");
        }
        if (!bl) {
            this.getCompleteInfo(string, inputStream);
        } else {
            this.getBaseInfo(string, inputStream);
        }
    }

    private void getCompleteInfo(String string, InputStream inputStream) throws InfoException {
        IMOperation iMOperation = new IMOperation();
        iMOperation.verbose();
        iMOperation.addImage(string);
        try {
            Object object;
            IdentifyCmd identifyCmd = new IdentifyCmd();
            ArrayListOutputConsumer arrayListOutputConsumer = new ArrayListOutputConsumer();
            identifyCmd.setOutputConsumer(arrayListOutputConsumer);
            if (inputStream != null) {
                object = new Pipe(inputStream, null);
                identifyCmd.setInputProvider((InputProvider)object);
            }
            identifyCmd.run(iMOperation, new Object[0]);
            object = arrayListOutputConsumer.getOutput();
            StringBuilder stringBuilder = new StringBuilder(80);
            Iterator iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (string2.length() == 0) {
                    stringBuilder.append("\n\n");
                    continue;
                }
                if (string2.indexOf(58) == -1) {
                    stringBuilder.append("\n").append(string2);
                    continue;
                }
                if (stringBuilder.length() > 0) {
                    this.parseLine(stringBuilder.toString());
                    stringBuilder = new StringBuilder(80);
                    stringBuilder.append(string2);
                    continue;
                }
                stringBuilder.append(string2);
            }
            if (stringBuilder.length() > 0) {
                this.parseLine(stringBuilder.toString());
            }
            this.addBaseInfo();
            this.iAttribList.add(this.iAttributes);
        }
        catch (Exception exception) {
            throw new InfoException(exception);
        }
    }

    private void addBaseInfo() {
        String[] stringArray;
        String string = this.iAttributes.get("Geometry");
        if (string != null) {
            stringArray = string.split("x|\\+");
            this.iAttributes.put("Width", stringArray[0]);
            this.iAttributes.put("Height", stringArray[1]);
        }
        if ((string = this.iAttributes.get("Page geometry")) != null) {
            stringArray = string.split("x|\\+");
            this.iAttributes.put("PageWidth", stringArray[0]);
            this.iAttributes.put("PageHeight", stringArray[1]);
            this.iAttributes.put("PageGeometry", string);
        }
    }

    private void parseLine(String string) {
        if (string.startsWith("Image:")) {
            if (this.iAttributes != null) {
                this.addBaseInfo();
                this.iAttribList.add(this.iAttributes);
            }
            this.iAttributes = new Hashtable();
        }
        int n = string.indexOf(string.trim()) / 2;
        String[] stringArray = string.trim().split(": ", 2);
        if (n < this.iOldIndent) {
            int n2 = this.iPrefix.length() - 1;
            for (int i = 0; i < this.iOldIndent - n; ++i) {
                n2 = this.iPrefix.lastIndexOf(58, n2 - 1);
            }
            this.iPrefix = n2 == -1 ? "" : this.iPrefix.substring(0, n2 + 1);
        }
        this.iOldIndent = n;
        if (stringArray.length == 1) {
            this.iPrefix = this.iPrefix + stringArray[0];
        } else {
            this.iAttributes.put(this.iPrefix + stringArray[0], stringArray[1]);
        }
    }

    private void getBaseInfo(String string, InputStream inputStream) throws InfoException {
        IMOperation iMOperation = new IMOperation();
        iMOperation.ping();
        iMOperation.format("%m\n%w\n%h\n%g\n%W\n%H\n%G\n%z\n%r");
        iMOperation.addImage(string);
        try {
            Object object;
            IdentifyCmd identifyCmd = new IdentifyCmd();
            ArrayListOutputConsumer arrayListOutputConsumer = new ArrayListOutputConsumer();
            identifyCmd.setOutputConsumer(arrayListOutputConsumer);
            if (inputStream != null) {
                object = new Pipe(inputStream, null);
                identifyCmd.setInputProvider((InputProvider)object);
            }
            identifyCmd.run(iMOperation, new Object[0]);
            object = arrayListOutputConsumer.getOutput();
            Iterator iterator = ((ArrayList)object).iterator();
            this.iAttributes = new Hashtable();
            this.iAttributes.put("Format", (String)iterator.next());
            this.iAttributes.put("Width", (String)iterator.next());
            this.iAttributes.put("Height", (String)iterator.next());
            this.iAttributes.put("Geometry", (String)iterator.next());
            this.iAttributes.put("PageWidth", (String)iterator.next());
            this.iAttributes.put("PageHeight", (String)iterator.next());
            this.iAttributes.put("PageGeometry", (String)iterator.next());
            this.iAttributes.put("Depth", (String)iterator.next());
            this.iAttributes.put("Class", (String)iterator.next());
            this.iAttribList.add(this.iAttributes);
        }
        catch (Exception exception) {
            throw new InfoException(exception);
        }
    }

    public String getImageFormat() {
        return this.iAttributes.get("Format");
    }

    public String getImageFormat(int n) {
        return this.iAttribList.get(n).get("Format");
    }

    public int getImageWidth() throws InfoException {
        return this.getImageWidth(this.iAttribList.size() - 1);
    }

    public int getImageWidth(int n) throws InfoException {
        try {
            return Integer.parseInt(this.iAttribList.get(n).get("Width"));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InfoException(numberFormatException);
        }
    }

    public int getImageHeight() throws InfoException {
        return this.getImageHeight(this.iAttribList.size() - 1);
    }

    public int getImageHeight(int n) throws InfoException {
        try {
            return Integer.parseInt(this.iAttribList.get(n).get("Height"));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InfoException(numberFormatException);
        }
    }

    public String getImageGeometry() {
        return this.iAttributes.get("Geometry");
    }

    public String getImageGeometry(int n) {
        return this.iAttribList.get(n).get("Geometry");
    }

    public int getImageDepth() throws InfoException {
        return this.getImageDepth(this.iAttribList.size() - 1);
    }

    public int getImageDepth(int n) throws InfoException {
        String[] stringArray = this.iAttribList.get(n).get("Depth").split("-|/", 2);
        try {
            return Integer.parseInt(stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InfoException(numberFormatException);
        }
    }

    public String getImageClass() {
        return this.iAttributes.get("Class");
    }

    public String getImageClass(int n) {
        return this.iAttribList.get(n).get("Class");
    }

    public int getPageWidth() throws InfoException {
        return this.getPageWidth(this.iAttribList.size() - 1);
    }

    public int getPageWidth(int n) throws InfoException {
        try {
            return Integer.parseInt(this.iAttribList.get(n).get("PageWidth"));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InfoException(numberFormatException);
        }
    }

    public int getPageHeight() throws InfoException {
        return this.getPageHeight(this.iAttribList.size() - 1);
    }

    public int getPageHeight(int n) throws InfoException {
        try {
            return Integer.parseInt(this.iAttribList.get(n).get("PageHeight"));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InfoException(numberFormatException);
        }
    }

    public String getPageGeometry() {
        return this.iAttributes.get("PageGeometry");
    }

    public String getPageGeometry(int n) {
        return this.iAttribList.get(n).get("PageGeometry");
    }

    public String getProperty(String string) {
        return this.iAttributes.get(string);
    }

    public String getProperty(String string, int n) {
        return this.iAttribList.get(n).get(string);
    }

    public int getSceneCount() {
        return this.iAttribList.size();
    }

    public Enumeration<String> getPropertyNames() {
        return this.iAttributes.keys();
    }
}

