/*
 * Decompiled with CFR 0.152.
 */
package org.im4java.test;

import org.im4java.core.ConvertCmd;
import org.im4java.core.DisplayCmd;
import org.im4java.core.IMOperation;
import org.im4java.process.ProcessEvent;
import org.im4java.process.ProcessEventListener;
import org.im4java.test.AbstractTestCase;

public class TestCase16
extends AbstractTestCase {
    public String getDescription() {
        return "asynchronous execution";
    }

    public static void main(String[] stringArray) {
        TestCase16 testCase16 = new TestCase16();
        testCase16.runTest(stringArray);
    }

    public void run() throws Exception {
        System.err.println("16. Testing asynchronous execution ...");
        IMOperation iMOperation = new IMOperation();
        iMOperation.size(400, 200);
        iMOperation.addImage("gradient:red", iTmpImage);
        ConvertCmd convertCmd = new ConvertCmd();
        convertCmd.run(iMOperation, new Object[0]);
        DisplayCmd displayCmd = new DisplayCmd();
        displayCmd.setAsyncMode(true);
        AsyncTestProcessEventListener asyncTestProcessEventListener = new AsyncTestProcessEventListener();
        displayCmd.addProcessEventListener(asyncTestProcessEventListener);
        IMOperation iMOperation2 = new IMOperation();
        iMOperation2.addImage(iTmpImage);
        displayCmd.run(iMOperation2, new Object[0]);
        for (int i = 0; i < 10; ++i) {
            System.err.println("sleeping for one second...");
            Thread.sleep(1000L);
            if (!asyncTestProcessEventListener.isRunning()) break;
        }
        asyncTestProcessEventListener.destroy();
    }

    class AsyncTestProcessEventListener
    implements ProcessEventListener {
        private Process iProcess = null;
        private boolean isTerminated = false;

        AsyncTestProcessEventListener() {
        }

        public void processInitiated(ProcessEvent processEvent) {
            System.err.println("process initiated");
        }

        public void processStarted(ProcessEvent processEvent) {
            System.err.println("process started");
            this.isTerminated = false;
            this.iProcess = processEvent.getProcess();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processTerminated(ProcessEvent processEvent) {
            System.err.println("process terminated");
            Object object = this.iProcess;
            synchronized (object) {
                this.iProcess = null;
            }
            this.isTerminated = true;
            if (processEvent.getException() != null) {
                object = processEvent.getException();
                System.err.println("Process terminated with: " + ((Throwable)object).getMessage());
            } else {
                System.out.println("async process terminated with rc: " + processEvent.getReturnCode());
            }
        }

        public boolean isRunning() {
            return !this.isTerminated;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            try {
                Process process = this.iProcess;
                synchronized (process) {
                    this.iProcess.destroy();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

