/*
Navicat MySQL Data Transfer

Source Server         : localhost
Source Server Version : 50146
Source Host           : localhost:3306
Source Database       : jtopcmsv1_beta

Target Server Type    : MYSQL
Target Server Version : 50146
File Encoding         : 65001

Date: 2015-05-09 09:56:22
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for `advert_config`
-- ----------------------------
DROP TABLE IF EXISTS `advert_config`;
CREATE TABLE `advert_config` (
  `configId` bigint(20) NOT NULL AUTO_INCREMENT,
  `configName` varchar(70) NOT NULL,
  `configDesc` varchar(500) DEFAULT NULL,
  `advertCode` mediumtext,
  `posModelId` bigint(20) DEFAULT NULL,
  `contentModelId` bigint(20) DEFAULT NULL,
  `userState` int(11) NOT NULL,
  `creator` varchar(40) NOT NULL,
  `siteId` bigint(20) NOT NULL,
  PRIMARY KEY (`configId`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of advert_config
-- ----------------------------

-- ----------------------------
-- Table structure for `advert_config_param`
-- ----------------------------
DROP TABLE IF EXISTS `advert_config_param`;
CREATE TABLE `advert_config_param` (
  `paramId` bigint(20) NOT NULL AUTO_INCREMENT,
  `configId` bigint(20) NOT NULL DEFAULT '0',
  `paramFlag` varchar(50) NOT NULL,
  `paramType` int(11) NOT NULL,
  `paramName` varchar(60) NOT NULL,
  `htmlType` int(11) NOT NULL,
  `choiceValue` varchar(900) DEFAULT NULL,
  `defaultValue` varchar(200) DEFAULT NULL,
  `mustFill` int(11) NOT NULL,
  `allowFileType` varchar(300) DEFAULT NULL,
  `fileSize` int(11) DEFAULT NULL,
  PRIMARY KEY (`paramId`),
  KEY `configId_paramId` (`configId`,`paramId`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of advert_config_param
-- ----------------------------

-- ----------------------------
-- Table structure for `advert_content`
-- ----------------------------
DROP TABLE IF EXISTS `advert_content`;
CREATE TABLE `advert_content` (
  `advertId` bigint(20) NOT NULL AUTO_INCREMENT,
  `adName` varchar(80) NOT NULL,
  `adFlag` varchar(60) NOT NULL,
  `posId` bigint(20) NOT NULL,
  `advertCode` mediumtext,
  `showStartDate` datetime DEFAULT NULL,
  `showEndDate` datetime DEFAULT '0000-00-00 00:00:00',
  `percent` int(11) NOT NULL,
  `importance` int(11) NOT NULL,
  `target` int(11) NOT NULL,
  `keyword` varchar(300) DEFAULT NULL,
  `creator` varchar(120) DEFAULT 'CURRENT_TIMESTAMP',
  `useState` int(11) NOT NULL,
  `siteId` bigint(20) NOT NULL,
  PRIMARY KEY (`advertId`),
  KEY `flag` (`adFlag`),
  KEY `ad_con` (`posId`,`showStartDate`,`useState`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of advert_content
-- ----------------------------

-- ----------------------------
-- Table structure for `advert_param_value`
-- ----------------------------
DROP TABLE IF EXISTS `advert_param_value`;
CREATE TABLE `advert_param_value` (
  `paramId` bigint(20) NOT NULL,
  `configType` int(11) NOT NULL,
  `configId` bigint(20) NOT NULL,
  `targetId` bigint(20) NOT NULL,
  `paramValue` varchar(800) DEFAULT NULL,
  KEY `pctId` (`paramId`,`configType`,`targetId`,`configId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of advert_param_value
-- ----------------------------

-- ----------------------------
-- Table structure for `advert_position`
-- ----------------------------
DROP TABLE IF EXISTS `advert_position`;
CREATE TABLE `advert_position` (
  `posId` bigint(20) NOT NULL AUTO_INCREMENT,
  `posName` varchar(80) NOT NULL,
  `posFlag` varchar(80) NOT NULL,
  `configName` varchar(80) DEFAULT NULL,
  `configId` bigint(20) NOT NULL,
  `width` int(11) DEFAULT NULL,
  `height` int(11) DEFAULT NULL,
  `posDesc` varchar(700) DEFAULT NULL,
  `useState` int(11) NOT NULL,
  `creator` varchar(70) DEFAULT NULL,
  `target` varchar(15) NOT NULL,
  `showMode` int(11) NOT NULL,
  `siteId` bigint(20) NOT NULL,
  PRIMARY KEY (`posId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of advert_position
-- ----------------------------

-- ----------------------------
-- Table structure for `block_content`
-- ----------------------------
DROP TABLE IF EXISTS `block_content`;
CREATE TABLE `block_content` (
  `blockId` bigint(20) NOT NULL,
  `row` int(11) NOT NULL,
  `rowOrder` int(11) NOT NULL,
  `title` varchar(400) NOT NULL,
  `url` varchar(400) NOT NULL,
  `imgUrl` varchar(400) DEFAULT NULL,
  `summary` varchar(600) DEFAULT NULL,
  `addTime` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of block_content
-- ----------------------------

-- ----------------------------
-- Table structure for `block_info`
-- ----------------------------
DROP TABLE IF EXISTS `block_info`;
CREATE TABLE `block_info` (
  `blockId` bigint(20) NOT NULL AUTO_INCREMENT,
  `parentId` bigint(20) DEFAULT NULL,
  `blockName` varchar(80) NOT NULL,
  `flag` varchar(40) NOT NULL,
  `type` int(11) NOT NULL,
  `siteId` bigint(20) NOT NULL,
  `templateUrl` varchar(200) DEFAULT NULL,
  `creator` varchar(255) DEFAULT NULL,
  `blockDesc` varchar(600) DEFAULT NULL,
  `staticUrl` varchar(700) DEFAULT NULL,
  `jobId` bigint(20) DEFAULT NULL,
  `periodType` int(11) DEFAULT NULL,
  `period` int(11) DEFAULT NULL,
  `lastPubTime` datetime DEFAULT NULL,
  PRIMARY KEY (`blockId`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of block_info
-- ----------------------------

-- ----------------------------
-- Table structure for `block_pub_dt_trace`
-- ----------------------------
DROP TABLE IF EXISTS `block_pub_dt_trace`;
CREATE TABLE `block_pub_dt_trace` (
  `selfBlockId` bigint(20) NOT NULL,
  `lastPubDT` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of block_pub_dt_trace
-- ----------------------------

-- ----------------------------
-- Table structure for `block_type`
-- ----------------------------
DROP TABLE IF EXISTS `block_type`;
CREATE TABLE `block_type` (
  `blockTypeId` bigint(20) NOT NULL AUTO_INCREMENT,
  `blockTypeName` varchar(60) NOT NULL,
  `siteFlag` varchar(40) NOT NULL,
  `creator` varchar(60) NOT NULL,
  `templateUrl` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`blockTypeId`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of block_type
-- ----------------------------

-- ----------------------------
-- Table structure for `comment_info`
-- ----------------------------
DROP TABLE IF EXISTS `comment_info`;
CREATE TABLE `comment_info` (
  `commentId` bigint(20) NOT NULL AUTO_INCREMENT,
  `contentId` bigint(20) NOT NULL,
  `classId` bigint(20) NOT NULL,
  `memberId` bigint(20) NOT NULL,
  `modelId` bigint(20) NOT NULL,
  `typeId` bigint(20) NOT NULL,
  `replyId` bigint(20) NOT NULL,
  `replayText` mediumtext,
  `replyTrace` varchar(2500) NOT NULL,
  `userName` varchar(80) DEFAULT NULL,
  `commentText` varchar(3000) DEFAULT NULL,
  `score` int(11) DEFAULT NULL,
  `supportCount` bigint(20) DEFAULT NULL,
  `againstCount` bigint(20) DEFAULT NULL,
  `moodFlag` int(11) DEFAULT NULL,
  `ip` varchar(25) DEFAULT NULL,
  `censorState` int(11) NOT NULL,
  `siteId` bigint(20) NOT NULL,
  `commDT` datetime DEFAULT NULL,
  PRIMARY KEY (`commentId`),
  KEY `cid` (`contentId`,`censorState`) USING BTREE,
  KEY `classId` (`classId`,`censorState`) USING BTREE,
  KEY `memId` (`memberId`,`siteId`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of comment_info
-- ----------------------------

-- ----------------------------
-- Table structure for `comment_replay_text`
-- ----------------------------
DROP TABLE IF EXISTS `comment_replay_text`;
CREATE TABLE `comment_replay_text` (
  `commentId` bigint(20) NOT NULL DEFAULT '0',
  `replayText` longtext,
  PRIMARY KEY (`commentId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of comment_replay_text
-- ----------------------------

-- ----------------------------
-- Table structure for `contentclass`
-- ----------------------------
DROP TABLE IF EXISTS `contentclass`;
CREATE TABLE `contentclass` (
  `classId` bigint(20) NOT NULL AUTO_INCREMENT,
  `siteFlag` varchar(40) NOT NULL,
  `classFlag` varchar(70) NOT NULL,
  `className` varchar(60) NOT NULL,
  `classType` int(11) NOT NULL,
  `parent` bigint(20) NOT NULL,
  `layer` int(11) NOT NULL,
  `isLeaf` int(11) NOT NULL,
  `classDesc` varchar(255) DEFAULT NULL,
  `isSpecial` int(11) NOT NULL,
  `isRecommend` int(11) DEFAULT NULL,
  `linearOrderFlag` varchar(900) NOT NULL,
  `isLastChild` int(11) NOT NULL,
  `contentType` bigint(20) NOT NULL,
  `singleContentId` bigint(20) DEFAULT NULL,
  `classHomeTemplateUrl` varchar(180) DEFAULT NULL,
  `classTemplateUrl` varchar(180) DEFAULT NULL,
  `contentTemplateUrl` varchar(180) DEFAULT NULL,
  `channelPath` varchar(600) DEFAULT NULL,
  `syncPubClass` int(11) NOT NULL,
  `listPageLimit` varchar(5) NOT NULL,
  `endStaticPageUrl` varchar(300) DEFAULT NULL,
  `endPagePos` int(11) DEFAULT NULL,
  `staticHomePageUrl` varchar(300) DEFAULT NULL,
  `staticPageUrl` varchar(300) DEFAULT NULL,
  `classHomeProduceType` int(11) NOT NULL,
  `classProduceType` int(11) NOT NULL,
  `contentProduceType` int(11) NOT NULL,
  `immediatelyStaticAction` int(11) NOT NULL,
  `needCensor` int(11) DEFAULT NULL,
  `showStatus` int(11) NOT NULL,
  `workflowId` bigint(20) DEFAULT NULL,
  `useStatus` int(11) NOT NULL,
  `contentPublishRuleId` bigint(20) DEFAULT NULL,
  `classHomePublishRuleId` bigint(20) DEFAULT NULL,
  `classPublishRuleId` bigint(20) DEFAULT NULL,
  `outLink` varchar(300) DEFAULT NULL,
  `logoImage` varchar(200) DEFAULT NULL,
  `banner` varchar(200) DEFAULT NULL,
  `openComment` int(11) NOT NULL,
  `mustCommentCensor` int(11) NOT NULL,
  `notMemberComment` int(11) NOT NULL,
  `commentCaptcha` int(11) DEFAULT NULL,
  `filterCommentSensitive` int(11) DEFAULT NULL,
  `commentHtml` int(11) DEFAULT NULL,
  `sensitiveMode` int(11) NOT NULL,
  `seoTitle` varchar(300) DEFAULT NULL,
  `seoKeyword` varchar(300) DEFAULT NULL,
  `seoDesc` varchar(500) DEFAULT NULL,
  `searchStatus` int(11) DEFAULT NULL,
  `relateRangeType` int(11) DEFAULT NULL,
  `memberAddContent` int(11) DEFAULT NULL,
  `extDataModelId` bigint(20) DEFAULT NULL,
  `editorImageMark` int(11) DEFAULT NULL,
  `editorImageH` int(11) DEFAULT NULL,
  `editorImageW` int(11) DEFAULT NULL,
  `homeImageW` int(11) DEFAULT NULL,
  `homeImageH` int(11) DEFAULT NULL,
  `classImageW` int(11) DEFAULT NULL,
  `classImageH` int(11) DEFAULT NULL,
  `listImageW` int(11) DEFAULT NULL,
  `listImageH` int(11) DEFAULT NULL,
  `contentImageW` int(11) DEFAULT NULL,
  `contentImageH` int(11) DEFAULT NULL,
  `systemHandleTime` datetime DEFAULT NULL,
  `addYear` int(11) DEFAULT NULL,
  `addMonth` int(11) DEFAULT NULL,
  `contentImageDM` int(11) DEFAULT NULL,
  `listImageDM` int(11) DEFAULT NULL,
  `classImageDM` int(11) DEFAULT NULL,
  `homeImageDM` int(11) DEFAULT NULL,
  `editorImageDM` int(11) DEFAULT NULL,
  PRIMARY KEY (`classId`),
  KEY `site` (`siteFlag`)
) ENGINE=InnoDB AUTO_INCREMENT=10725 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of contentclass
-- ----------------------------

-- ----------------------------
-- Table structure for `content_aiticle_dl_img`
-- ----------------------------
DROP TABLE IF EXISTS `content_aiticle_dl_img`;
CREATE TABLE `content_aiticle_dl_img` (
  `contentId` bigint(20) NOT NULL DEFAULT '0',
  `resId` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of content_aiticle_dl_img
-- ----------------------------

-- ----------------------------
-- Table structure for `content_art_source`
-- ----------------------------
DROP TABLE IF EXISTS `content_art_source`;
CREATE TABLE `content_art_source` (
  `sId` bigint(20) NOT NULL AUTO_INCREMENT,
  `sourceName` varchar(160) NOT NULL,
  `firstChar` varchar(5) NOT NULL,
  PRIMARY KEY (`sId`)
) ENGINE=InnoDB AUTO_INCREMENT=79 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of content_art_source
-- ----------------------------

-- ----------------------------
-- Table structure for `content_assistant_copy_info`
-- ----------------------------
DROP TABLE IF EXISTS `content_assistant_copy_info`;
CREATE TABLE `content_assistant_copy_info` (
  `contentId` bigint(20) NOT NULL,
  `refClassId` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of content_assistant_copy_info
-- ----------------------------

-- ----------------------------
-- Table structure for `content_assistant_page_info`
-- ----------------------------
DROP TABLE IF EXISTS `content_assistant_page_info`;
CREATE TABLE `content_assistant_page_info` (
  `contentId` bigint(20) NOT NULL DEFAULT '0',
  `pos` int(11) NOT NULL,
  `pageTitle` varchar(70) DEFAULT NULL,
  `pageContent` mediumtext,
  `pageStaticUrl` varchar(300) DEFAULT NULL,
  `startPos` int(11) NOT NULL,
  `endPos` int(11) NOT NULL,
  KEY `c-pos` (`contentId`,`pos`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of content_assistant_page_info
-- ----------------------------

-- ----------------------------
-- Table structure for `content_assistant_photo_group`
-- ----------------------------
DROP TABLE IF EXISTS `content_assistant_photo_group`;
CREATE TABLE `content_assistant_photo_group` (
  `contentId` bigint(20) NOT NULL,
  `groupSign` varchar(20) NOT NULL,
  `modelType` bigint(20) DEFAULT NULL,
  `photoName` varchar(300) DEFAULT NULL,
  `isCover` int(11) DEFAULT NULL,
  `url` varchar(400) DEFAULT NULL,
  `photoDesc` varchar(300) DEFAULT NULL,
  `outLinkUrl` varchar(300) DEFAULT NULL,
  `photoAddTime` timestamp NULL DEFAULT '0000-00-00 00:00:00',
  `width` int(11) DEFAULT NULL,
  `height` int(11) DEFAULT NULL,
  `needMark` int(11) DEFAULT NULL,
  `orderFlag` int(11) DEFAULT NULL,
  KEY `co` (`contentId`,`orderFlag`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of content_assistant_photo_group
-- ----------------------------

-- ----------------------------
-- Table structure for `content_assistant_publish_id`
-- ----------------------------
DROP TABLE IF EXISTS `content_assistant_publish_id`;
CREATE TABLE `content_assistant_publish_id` (
  `pubIdTrace` bigint(20) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of content_assistant_publish_id
-- ----------------------------

-- ----------------------------
-- Table structure for `content_commend_push_info`
-- ----------------------------
DROP TABLE IF EXISTS `content_commend_push_info`;
CREATE TABLE `content_commend_push_info` (
  `infoId` bigint(20) NOT NULL AUTO_INCREMENT,
  `rowFlag` bigint(20) NOT NULL,
  `rowOrder` int(11) NOT NULL,
  `contentId` bigint(20) DEFAULT '0',
  `title` varchar(200) DEFAULT NULL,
  `url` varchar(300) DEFAULT NULL,
  `img` varchar(200) DEFAULT NULL,
  `summary` varchar(600) DEFAULT NULL,
  `addTime` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `modelId` bigint(20) DEFAULT NULL,
  `classId` bigint(20) DEFAULT NULL,
  `commendTypeId` bigint(20) DEFAULT NULL,
  `orderFlag` int(11) DEFAULT NULL,
  `typeFlag` varchar(100) DEFAULT NULL,
  `commendFlag` varchar(100) NOT NULL,
  `commendMan` varchar(30) NOT NULL,
  `siteFlag` varchar(60) NOT NULL,
  PRIMARY KEY (`infoId`),
  KEY `rfro` (`commendFlag`,`rowFlag`,`rowOrder`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=795 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of content_commend_push_info
-- ----------------------------

-- ----------------------------
-- Table structure for `content_commend_push_temp`
-- ----------------------------
DROP TABLE IF EXISTS `content_commend_push_temp`;
CREATE TABLE `content_commend_push_temp` (
  `contentId` bigint(20) NOT NULL DEFAULT '0',
  `commTypeId` bigint(20) NOT NULL,
  `commFlag` varchar(80) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of content_commend_push_temp
-- ----------------------------

-- ----------------------------
-- Table structure for `content_commend_type`
-- ----------------------------
DROP TABLE IF EXISTS `content_commend_type`;
CREATE TABLE `content_commend_type` (
  `commendTypeId` bigint(20) NOT NULL AUTO_INCREMENT,
  `siteFlag` varchar(60) NOT NULL,
  `isSpec` int(11) NOT NULL,
  `classLinerFlag` varchar(400) DEFAULT NULL,
  `classId` bigint(20) NOT NULL,
  `commendName` varchar(60) NOT NULL,
  `commFlag` varchar(30) NOT NULL,
  `typeDesc` varchar(400) DEFAULT NULL,
  `listTemplateUrl` varchar(120) DEFAULT NULL,
  `listProduceType` int(11) NOT NULL,
  `listPublishRuleId` bigint(20) DEFAULT NULL,
  `listStaticUrl` varchar(150) DEFAULT NULL,
  `childClassMode` int(11) NOT NULL,
  `mustCensor` int(11) NOT NULL,
  `creator` varchar(80) DEFAULT NULL,
  `imageWidth` int(11) DEFAULT NULL,
  `imageHeight` int(11) DEFAULT NULL,
  PRIMARY KEY (`commendTypeId`)
) ENGINE=InnoDB AUTO_INCREMENT=76 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of content_commend_type
-- ----------------------------

-- ----------------------------
-- Table structure for `content_main_info`
-- ----------------------------
DROP TABLE IF EXISTS `content_main_info`;
CREATE TABLE `content_main_info` (
  `contentId` bigint(20) NOT NULL AUTO_INCREMENT,
  `classId` bigint(20) NOT NULL,
  `refCid` bigint(20) DEFAULT NULL,
  `title` varchar(200) NOT NULL,
  `simpleTitle` varchar(80) DEFAULT NULL,
  `shortTitle` varchar(30) DEFAULT NULL,
  `author` varchar(60) DEFAULT NULL,
  `creator` varchar(50) DEFAULT NULL,
  `summary` varchar(500) DEFAULT NULL,
  `titleStyle` varchar(80) DEFAULT NULL,
  `simpleTitleStyle` varchar(80) DEFAULT NULL,
  `addTime` datetime DEFAULT '0000-00-00 00:00:00',
  `clickMonthCount` bigint(20) DEFAULT NULL,
  `clickWeekCount` bigint(20) DEFAULT NULL,
  `clickDayCount` bigint(20) DEFAULT NULL,
  `clickCount` bigint(20) DEFAULT NULL,
  `commMonthCount` bigint(20) DEFAULT NULL,
  `commWeekCount` bigint(20) DEFAULT NULL,
  `commDayCount` bigint(20) DEFAULT NULL,
  `commCount` bigint(20) DEFAULT NULL,
  `supportCount` bigint(20) DEFAULT NULL,
  `againstCount` bigint(20) DEFAULT NULL,
  `homeImage` varchar(200) DEFAULT NULL,
  `classImage` varchar(200) DEFAULT NULL,
  `channelImage` varchar(200) DEFAULT NULL,
  `contentImage` varchar(200) DEFAULT NULL,
  `systemHandleTime` varchar(25) NOT NULL,
  `especialTemplateUrl` varchar(110) DEFAULT NULL,
  `staticPageUrl` varchar(120) DEFAULT NULL,
  `outLink` varchar(200) DEFAULT NULL,
  `produceType` int(11) DEFAULT NULL,
  `censorState` int(11) DEFAULT NULL,
  `isPageContent` int(11) DEFAULT NULL,
  `isSystemOrder` int(11) NOT NULL,
  `orderIdFlag` double NOT NULL,
  `keywords` varchar(200) DEFAULT NULL,
  `tagKey` varchar(120) DEFAULT NULL,
  `pubDateSysDT` bigint(20) DEFAULT NULL,
  `appearStartDateTime` datetime DEFAULT '0000-00-00 00:00:00',
  `appearEndDateTime` datetime DEFAULT '0000-00-00 00:00:00',
  `homeImgFlag` int(11) DEFAULT NULL,
  `classImgFlag` int(11) DEFAULT NULL,
  `commendFlag` int(11) DEFAULT NULL,
  `channelImgFlag` int(11) DEFAULT NULL,
  `contentImgFlag` int(11) DEFAULT NULL,
  `relateIds` varchar(300) DEFAULT NULL,
  `relateSurvey` varchar(200) DEFAULT NULL,
  `typeFlag` varchar(40) DEFAULT NULL,
  `topFlag` int(11) DEFAULT NULL,
  `otherFlag` int(11) DEFAULT NULL,
  `modelId` bigint(20) NOT NULL,
  `siteId` bigint(20) DEFAULT NULL,
  `allowCommend` int(11) DEFAULT NULL,
  `moodT1Count` bigint(20) DEFAULT NULL,
  `moodT2Count` bigint(20) DEFAULT NULL,
  `moodT3Count` bigint(20) DEFAULT NULL,
  `moodT4Count` bigint(20) DEFAULT NULL,
  `moodT5Count` bigint(20) DEFAULT NULL,
  `moodT6Count` bigint(20) DEFAULT NULL,
  `moodT7Count` bigint(20) DEFAULT NULL,
  `moodT8Count` bigint(20) DEFAULT NULL,
  `moodT9Count` bigint(20) DEFAULT NULL,
  `moodT10Count` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`contentId`),
  KEY `ois` (`orderIdFlag`,`isSystemOrder`),
  KEY `hcmo` (`classImgFlag`,`classId`,`modelId`,`censorState`,`orderIdFlag`),
  KEY `cmc-oid` (`classId`,`modelId`,`censorState`,`orderIdFlag`),
  KEY `cmto-limit` (`classId`,`modelId`,`topFlag`,`orderIdFlag`) USING BTREE,
  KEY `title-cid` (`title`,`classId`) USING BTREE,
  KEY `tcmcoid` (`topFlag`,`classId`,`modelId`,`censorState`,`orderIdFlag`) USING BTREE,
  KEY `tcmccid` (`topFlag`,`classId`,`modelId`,`censorState`,`contentId`) USING BTREE,
  KEY `tcm` (`topFlag`,`classId`,`modelId`,`contentId`) USING BTREE,
  KEY `cmmonclk` (`classId`,`modelId`,`clickMonthCount`) USING BTREE,
  KEY `cmwekclk` (`classId`,`modelId`,`clickWeekCount`) USING BTREE,
  KEY `cmdayclk` (`classId`,`modelId`,`clickDayCount`) USING BTREE,
  KEY `cmclk` (`classId`,`modelId`,`clickCount`) USING BTREE,
  KEY `cmmoncom` (`classId`,`modelId`,`commMonthCount`) USING BTREE,
  KEY `cmwekcom` (`classId`,`modelId`,`commWeekCount`) USING BTREE,
  KEY `cmdaycom` (`classId`,`modelId`,`commDayCount`) USING BTREE,
  KEY `cmcom` (`classId`,`modelId`,`commCount`) USING BTREE,
  KEY `cmsu` (`classId`,`modelId`,`supportCount`) USING BTREE,
  KEY `cmag` (`classId`,`modelId`,`againstCount`) USING BTREE,
  KEY `tcmpt` (`topFlag`,`classId`,`modelId`,`appearStartDateTime`) USING BTREE,
  KEY `tcmcpt` (`topFlag`,`classId`,`modelId`,`censorState`,`appearStartDateTime`) USING BTREE,
  KEY `tcmo` (`topFlag`,`classId`,`modelId`,`orderIdFlag`) USING BTREE,
  KEY `cmat` (`classId`,`modelId`,`addTime`),
  KEY `tcmcpd` (`topFlag`,`classId`,`modelId`,`censorState`,`pubDateSysDT`) USING BTREE,
  KEY `tcmpd` (`topFlag`,`classId`,`modelId`,`pubDateSysDT`),
  KEY `cmlioid` (`classId`,`modelId`,`classImgFlag`,`orderIdFlag`),
  KEY `cmhioid` (`classId`,`modelId`,`homeImgFlag`,`orderIdFlag`) USING BTREE,
  KEY `cmchioid` (`classId`,`modelId`,`channelImgFlag`,`orderIdFlag`) USING BTREE,
  KEY `cmcoioid` (`classId`,`modelId`,`contentImgFlag`,`orderIdFlag`),
  KEY `sidcapt` (`siteId`,`censorState`,`appearStartDateTime`),
  KEY `sidcept` (`siteId`,`censorState`,`appearEndDateTime`),
  KEY `test2` (`classId`,`censorState`,`contentId`),
  KEY `test` (`classId`,`censorState`,`pubDateSysDT`) USING BTREE,
  KEY `test3` (`pubDateSysDT`,`contentId`) USING BTREE,
  KEY `memId` (`creator`,`otherFlag`,`siteId`)
) ENGINE=InnoDB AUTO_INCREMENT=292 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of content_main_info
-- ----------------------------

-- ----------------------------
-- Table structure for `content_mood`
-- ----------------------------
DROP TABLE IF EXISTS `content_mood`;
CREATE TABLE `content_mood` (
  `contentId` bigint(20) NOT NULL,
  `supportCount` bigint(20) DEFAULT NULL,
  `againstCount` bigint(20) DEFAULT NULL,
  `moodT1Count` bigint(20) DEFAULT NULL,
  `moodT2Count` bigint(20) DEFAULT NULL,
  `moodT3Count` bigint(20) DEFAULT NULL,
  `moodT4Count` bigint(20) DEFAULT NULL,
  `moodT5Count` bigint(20) DEFAULT NULL,
  `moodT6Count` bigint(20) DEFAULT NULL,
  `moodT7Count` bigint(20) DEFAULT NULL,
  `moodT8Count` bigint(20) DEFAULT NULL,
  `moodT9Count` bigint(20) DEFAULT NULL,
  `moodT10Count` bigint(20) DEFAULT NULL,
  KEY `cid` (`contentId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of content_mood
-- ----------------------------

-- ----------------------------
-- Table structure for `content_special_subject_info`
-- ----------------------------
DROP TABLE IF EXISTS `content_special_subject_info`;
CREATE TABLE `content_special_subject_info` (
  `specSubId` bigint(20) NOT NULL AUTO_INCREMENT,
  `specFlag` varchar(20) DEFAULT NULL,
  `title` varchar(120) NOT NULL,
  `shortTitle` varchar(70) DEFAULT NULL,
  `summary` varchar(2500) DEFAULT NULL,
  `banner` varchar(100) DEFAULT NULL,
  `homeImage` varchar(100) DEFAULT NULL,
  `classImage` varchar(100) DEFAULT NULL,
  `channelImage` varchar(100) DEFAULT NULL,
  `specProduceType` int(11) DEFAULT NULL,
  `listProduceType` int(11) DEFAULT NULL,
  `specPublishRuleId` int(11) DEFAULT NULL,
  `listPublishRuleId` int(11) DEFAULT NULL,
  `specTemplateUrl` varchar(180) DEFAULT NULL,
  `listTemplateUrl` varchar(180) DEFAULT NULL,
  `syncPubSpec` int(11) NOT NULL,
  `listPageLimit` varchar(5) NOT NULL,
  `staticPageUrl` varchar(300) DEFAULT NULL,
  `useStatus` int(11) NOT NULL,
  PRIMARY KEY (`specSubId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of content_special_subject_info
-- ----------------------------

-- ----------------------------
-- Table structure for `content_status`
-- ----------------------------
DROP TABLE IF EXISTS `content_status`;
CREATE TABLE `content_status` (
  `selfContentId` bigint(20) NOT NULL DEFAULT '0',
  `clickMonthCount` bigint(20) DEFAULT NULL,
  `clickWeekCount` bigint(20) DEFAULT NULL,
  `clickDayCount` bigint(20) DEFAULT NULL,
  `commMonthCount` bigint(20) DEFAULT NULL,
  `commWeekCount` bigint(20) DEFAULT NULL,
  `commDayCount` bigint(20) DEFAULT NULL,
  `commCount` bigint(20) DEFAULT NULL,
  `clickCount` bigint(20) DEFAULT NULL,
  `supportCount` bigint(20) DEFAULT NULL,
  `againstCount` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`selfContentId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of content_status
-- ----------------------------

-- ----------------------------
-- Table structure for `content_system_articleinfo`
-- ----------------------------
DROP TABLE IF EXISTS `content_system_articleinfo`;
CREATE TABLE `content_system_articleinfo` (
  `contentId` bigint(20) NOT NULL,
  `pageCount` int(11) DEFAULT NULL,
  `CMS_SYS_IS_PAGE` tinyint(1) DEFAULT NULL,
  `isSingleClassType` tinyint(1) DEFAULT NULL,
  `outLink` varchar(220) DEFAULT NULL,
  `content` longtext,
  `firstPageContent` text,
  `firstPageStaticUrl` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`contentId`)
) ENGINE=MyISAM AUTO_INCREMENT=290070 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of content_system_articleinfo
-- ----------------------------

-- ----------------------------
-- Table structure for `content_system_downloadinfo`
-- ----------------------------
DROP TABLE IF EXISTS `content_system_downloadinfo`;
CREATE TABLE `content_system_downloadinfo` (
  `contentId` bigint(20) NOT NULL,
  `system` varchar(80) DEFAULT NULL,
  `licence` varchar(30) DEFAULT NULL,
  `homeLink` varchar(300) DEFAULT NULL,
  `docLink` varchar(300) DEFAULT NULL,
  `demoLink` varchar(300) DEFAULT NULL,
  `downloadCount` int(11) DEFAULT NULL,
  `developer` varchar(120) DEFAULT NULL,
  `class` varchar(40) DEFAULT NULL,
  `updateTime` datetime DEFAULT NULL,
  `softUrl` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`contentId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of content_system_downloadinfo
-- ----------------------------

-- ----------------------------
-- Table structure for `content_system_photoinfo`
-- ----------------------------
DROP TABLE IF EXISTS `content_system_photoinfo`;
CREATE TABLE `content_system_photoinfo` (
  `contentId` bigint(20) NOT NULL,
  `photoGroup` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`contentId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of content_system_photoinfo
-- ----------------------------

-- ----------------------------
-- Table structure for `content_system_videoinfo`
-- ----------------------------
DROP TABLE IF EXISTS `content_system_videoinfo`;
CREATE TABLE `content_system_videoinfo` (
  `contentId` bigint(20) NOT NULL,
  `mediaType` varchar(10) DEFAULT NULL,
  `autoStart` varchar(6) DEFAULT NULL,
  `repeatFlag` varchar(20) DEFAULT NULL,
  `quality` varchar(20) DEFAULT NULL,
  `allowFullScreen` varchar(6) DEFAULT NULL,
  `video` varchar(160) NOT NULL,
  `convertToFlv` int(11) DEFAULT NULL,
  PRIMARY KEY (`contentId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of content_system_videoinfo
-- ----------------------------

-- ----------------------------
-- Table structure for `content_trash_main_info`
-- ----------------------------
DROP TABLE IF EXISTS `content_trash_main_info`;
CREATE TABLE `content_trash_main_info` (
  `contentId` bigint(20) NOT NULL DEFAULT '0',
  `classId` bigint(20) NOT NULL,
  `refCid` bigint(20) DEFAULT NULL,
  `title` varchar(200) NOT NULL,
  `simpleTitle` varchar(80) DEFAULT NULL,
  `shortTitle` varchar(30) DEFAULT NULL,
  `author` varchar(60) DEFAULT NULL,
  `creator` varchar(50) DEFAULT NULL,
  `summary` varchar(500) DEFAULT NULL,
  `titleStyle` varchar(80) DEFAULT NULL,
  `simpleTitleStyle` varchar(80) DEFAULT NULL,
  `addTime` datetime DEFAULT '0000-00-00 00:00:00',
  `clickMonthCount` bigint(20) DEFAULT NULL,
  `clickWeekCount` bigint(20) DEFAULT NULL,
  `clickDayCount` bigint(20) DEFAULT NULL,
  `clickCount` bigint(20) DEFAULT NULL,
  `commMonthCount` bigint(20) DEFAULT NULL,
  `commWeekCount` bigint(20) DEFAULT NULL,
  `commDayCount` bigint(20) DEFAULT NULL,
  `commCount` bigint(20) DEFAULT NULL,
  `supportCount` bigint(20) DEFAULT NULL,
  `againstCount` bigint(20) DEFAULT NULL,
  `homeImage` varchar(200) DEFAULT NULL,
  `classImage` varchar(200) DEFAULT NULL,
  `channelImage` varchar(200) DEFAULT NULL,
  `contentImage` varchar(200) DEFAULT NULL,
  `systemHandleTime` varchar(25) NOT NULL,
  `especialTemplateUrl` varchar(110) DEFAULT NULL,
  `staticPageUrl` varchar(120) DEFAULT NULL,
  `produceType` int(11) DEFAULT NULL,
  `censorState` int(11) DEFAULT NULL,
  `isPageContent` int(11) DEFAULT NULL,
  `isSystemOrder` int(11) NOT NULL,
  `orderIdFlag` double NOT NULL,
  `keywords` varchar(200) DEFAULT NULL,
  `tagKey` varchar(300) DEFAULT NULL,
  `pubDateSysDT` bigint(20) DEFAULT NULL,
  `appearStartDateTime` datetime DEFAULT '0000-00-00 00:00:00',
  `appearEndDateTime` datetime DEFAULT '0000-00-00 00:00:00',
  `homeImgFlag` int(11) DEFAULT NULL,
  `classImgFlag` int(11) DEFAULT NULL,
  `commendFlag` int(11) DEFAULT NULL,
  `channelImgFlag` int(11) DEFAULT NULL,
  `contentImgFlag` int(11) DEFAULT NULL,
  `typeFlag` varchar(40) DEFAULT NULL,
  `topFlag` int(11) DEFAULT NULL,
  `modelId` bigint(20) NOT NULL,
  `siteId` bigint(20) DEFAULT NULL,
  `allowCommend` int(11) DEFAULT NULL,
  `deleteTime` datetime DEFAULT NULL,
  PRIMARY KEY (`contentId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of content_trash_main_info
-- ----------------------------

-- ----------------------------
-- Table structure for `content_type`
-- ----------------------------
DROP TABLE IF EXISTS `content_type`;
CREATE TABLE `content_type` (
  `typeId` bigint(20) NOT NULL AUTO_INCREMENT,
  `typeName` varchar(80) NOT NULL,
  `typeFlag` varchar(60) NOT NULL,
  `groupId` int(11) DEFAULT NULL,
  `siteId` bigint(6) NOT NULL,
  PRIMARY KEY (`typeId`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of content_type
-- ----------------------------

-- ----------------------------
-- Table structure for `content_wait_pub_temp`
-- ----------------------------
DROP TABLE IF EXISTS `content_wait_pub_temp`;
CREATE TABLE `content_wait_pub_temp` (
  `contentId` bigint(20) DEFAULT NULL,
  `classId` bigint(20) DEFAULT NULL,
  `orderIdFlag` double(15,6) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of content_wait_pub_temp
-- ----------------------------

-- ----------------------------
-- Table structure for `friend_site_link`
-- ----------------------------
DROP TABLE IF EXISTS `friend_site_link`;
CREATE TABLE `friend_site_link` (
  `flId` bigint(20) NOT NULL AUTO_INCREMENT,
  `siteName` varchar(120) DEFAULT NULL,
  `siteLink` varchar(300) DEFAULT NULL,
  `siteLogo` varchar(120) DEFAULT NULL,
  `orderFlag` int(11) NOT NULL,
  `typeId` bigint(20) NOT NULL,
  `siteId` bigint(20) NOT NULL,
  PRIMARY KEY (`flId`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of friend_site_link
-- ----------------------------

-- ----------------------------
-- Table structure for `friend_site_link_type`
-- ----------------------------
DROP TABLE IF EXISTS `friend_site_link_type`;
CREATE TABLE `friend_site_link_type` (
  `ltId` bigint(20) NOT NULL AUTO_INCREMENT,
  `typeName` varchar(60) NOT NULL,
  `typeFlag` varchar(60) NOT NULL,
  `siteId` bigint(20) NOT NULL,
  PRIMARY KEY (`ltId`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of friend_site_link_type
-- ----------------------------

-- ----------------------------
-- Table structure for `guestbook_config`
-- ----------------------------
DROP TABLE IF EXISTS `guestbook_config`;
CREATE TABLE `guestbook_config` (
  `configId` bigint(20) NOT NULL AUTO_INCREMENT,
  `cfgName` varchar(50) NOT NULL,
  `cfgDesc` varchar(300) DEFAULT NULL,
  `mustHaveTitle` int(11) NOT NULL,
  `mustLogin` int(11) NOT NULL,
  `mustCensor` int(11) NOT NULL,
  `needVerifyCode` int(11) NOT NULL,
  `cfgFlag` varchar(80) NOT NULL,
  `useState` int(11) NOT NULL,
  `infoModelId` bigint(20) NOT NULL,
  `siteId` bigint(20) NOT NULL,
  PRIMARY KEY (`configId`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of guestbook_config
-- ----------------------------

-- ----------------------------
-- Table structure for `guestbook_main_info`
-- ----------------------------
DROP TABLE IF EXISTS `guestbook_main_info`;
CREATE TABLE `guestbook_main_info` (
  `gbId` bigint(20) NOT NULL AUTO_INCREMENT,
  `configId` bigint(20) NOT NULL,
  `isReply` int(11) NOT NULL,
  `isCensor` int(11) NOT NULL,
  `isOpen` int(11) NOT NULL,
  `gbTitle` varchar(400) DEFAULT NULL,
  `gbMan` varchar(80) DEFAULT NULL,
  `gbText` varchar(3500) DEFAULT NULL,
  `gbEmail` varchar(70) NOT NULL,
  `replyMan` varchar(200) DEFAULT NULL,
  `replyText` varchar(3000) DEFAULT NULL,
  `replyDate` timestamp NULL DEFAULT '0000-00-00 00:00:00',
  `ip` varchar(25) DEFAULT NULL,
  `memberId` bigint(20) DEFAULT NULL,
  `addDate` datetime DEFAULT '0000-00-00 00:00:00',
  `siteId` bigint(20) NOT NULL,
  PRIMARY KEY (`gbId`),
  KEY `c-isOp` (`configId`,`isOpen`) USING BTREE,
  KEY `c` (`configId`),
  KEY `c-isCe` (`configId`,`isCensor`),
  KEY `c-isRe` (`configId`,`isReply`),
  KEY `memId` (`memberId`,`siteId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of guestbook_main_info
-- ----------------------------

-- ----------------------------
-- Table structure for `icon_res_info`
-- ----------------------------
DROP TABLE IF EXISTS `icon_res_info`;
CREATE TABLE `icon_res_info` (
  `iconName` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of icon_res_info
-- ----------------------------

-- ----------------------------
-- Table structure for `jtopcms_model_adhdpz`
-- ----------------------------
DROP TABLE IF EXISTS `jtopcms_model_adhdpz`;
CREATE TABLE `jtopcms_model_adhdpz` (
  `contentId` bigint(20) NOT NULL,
  `jtopcms_def_hdgksd` varchar(60) DEFAULT NULL,
  PRIMARY KEY (`contentId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of jtopcms_model_adhdpz
-- ----------------------------

-- ----------------------------
-- Table structure for `jtopcms_model_ad_dl`
-- ----------------------------
DROP TABLE IF EXISTS `jtopcms_model_ad_dl`;
CREATE TABLE `jtopcms_model_ad_dl` (
  `contentId` bigint(20) NOT NULL,
  `jtopcms_def_dl_href` varchar(300) DEFAULT NULL,
  `jtopcms_def_dl_img` varchar(200) DEFAULT NULL,
  `jtopcms_def_dl_name` varchar(60) DEFAULT NULL,
  PRIMARY KEY (`contentId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of jtopcms_model_ad_dl
-- ----------------------------

-- ----------------------------
-- Table structure for `jtopcms_model_ad_mh_flash`
-- ----------------------------
DROP TABLE IF EXISTS `jtopcms_model_ad_mh_flash`;
CREATE TABLE `jtopcms_model_ad_mh_flash` (
  `contentId` bigint(20) NOT NULL,
  `jtopcms_def_ad_mh_home_flash` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`contentId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of jtopcms_model_ad_mh_flash
-- ----------------------------

-- ----------------------------
-- Table structure for `jtopcms_model_ad_mh_tp`
-- ----------------------------
DROP TABLE IF EXISTS `jtopcms_model_ad_mh_tp`;
CREATE TABLE `jtopcms_model_ad_mh_tp` (
  `contentId` bigint(20) NOT NULL,
  `jtopcms_def_ad_mh_tp_url` varchar(300) DEFAULT NULL,
  `jtopcms_def_ad_mh_tp` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`contentId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of jtopcms_model_ad_mh_tp
-- ----------------------------

-- ----------------------------
-- Table structure for `jtopcms_model_caipu`
-- ----------------------------
DROP TABLE IF EXISTS `jtopcms_model_caipu`;
CREATE TABLE `jtopcms_model_caipu` (
  `contentId` bigint(20) NOT NULL,
  `jtopcms_def_gongyi` int(11) DEFAULT NULL,
  `jtopcms_def_sicai` int(11) DEFAULT NULL,
  `jtopcms_def_shijian` int(11) DEFAULT NULL,
  `jtopcms_def_nandu` int(11) DEFAULT NULL,
  `jtopcms_def_cainame` varchar(300) DEFAULT NULL,
  `jtopcms_def_kouwei` varchar(100) DEFAULT NULL,
  `jtopcms_def_jilurq` timestamp NULL DEFAULT '0000-00-00 00:00:00',
  `jtopcms_def_mingxi` varchar(4000) DEFAULT NULL,
  `jtopcms_def_xstp` varchar(200) DEFAULT NULL,
  `jtopcms_def_spcai` varchar(200) DEFAULT NULL,
  `jtopcms_def_jieshaosp2` varchar(200) DEFAULT NULL,
  `jtopcms_def_caixi` varchar(60) DEFAULT NULL,
  `jtopcms_def_wsytpp` varchar(200) DEFAULT NULL,
  `jtopcms_def_ysytp` varchar(200) DEFAULT NULL,
  `jtopcms_def_zjwj` varchar(200) DEFAULT NULL,
  `jtopcms_def_sadasd` varchar(20) DEFAULT NULL,
  `jtopcms_def_asdasd` bigint(20) DEFAULT NULL,
  `jtopcms_def_asdd` varchar(20) DEFAULT NULL,
  `jtopcms_def_cstj` varchar(200) DEFAULT NULL,
  `jtopcms_def_jieshao` text,
  PRIMARY KEY (`contentId`),
  KEY `caipu` (`jtopcms_def_jilurq`,`contentId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of jtopcms_model_caipu
-- ----------------------------

-- ----------------------------
-- Table structure for `jtopcms_model_ceshi`
-- ----------------------------
DROP TABLE IF EXISTS `jtopcms_model_ceshi`;
CREATE TABLE `jtopcms_model_ceshi` (
  `ceshiId` bigint(20) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`ceshiId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of jtopcms_model_ceshi
-- ----------------------------

-- ----------------------------
-- Table structure for `jtopcms_model_cmscp_content`
-- ----------------------------
DROP TABLE IF EXISTS `jtopcms_model_cmscp_content`;
CREATE TABLE `jtopcms_model_cmscp_content` (
  `contentId` bigint(20) NOT NULL,
  `jtopcms_def_cmscp_nr` longtext,
  PRIMARY KEY (`contentId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of jtopcms_model_cmscp_content
-- ----------------------------

-- ----------------------------
-- Table structure for `jtopcms_model_fgkwj`
-- ----------------------------
DROP TABLE IF EXISTS `jtopcms_model_fgkwj`;
CREATE TABLE `jtopcms_model_fgkwj` (
  `contentId` bigint(20) NOT NULL,
  `jtopcms_def_falshfile` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`contentId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of jtopcms_model_fgkwj
-- ----------------------------

-- ----------------------------
-- Table structure for `jtopcms_model_hdnrcs`
-- ----------------------------
DROP TABLE IF EXISTS `jtopcms_model_hdnrcs`;
CREATE TABLE `jtopcms_model_hdnrcs` (
  `contentId` bigint(20) NOT NULL,
  `jtopcms_def_hdgglj` varchar(300) DEFAULT NULL,
  `jtopcms_def_hdgktp` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`contentId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of jtopcms_model_hdnrcs
-- ----------------------------

-- ----------------------------
-- Table structure for `jtopcms_model_mainsite`
-- ----------------------------
DROP TABLE IF EXISTS `jtopcms_model_mainsite`;
CREATE TABLE `jtopcms_model_mainsite` (
  `contentId` bigint(20) NOT NULL,
  `jtopcms_def_extSmsContent` text,
  `jtopcms_def_zdtpcs` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`contentId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of jtopcms_model_mainsite
-- ----------------------------

-- ----------------------------
-- Table structure for `jtopcms_model_main_ext`
-- ----------------------------
DROP TABLE IF EXISTS `jtopcms_model_main_ext`;
CREATE TABLE `jtopcms_model_main_ext` (
  `contentId` bigint(20) NOT NULL,
  `jtopcms_def_sfgb` int(11) DEFAULT NULL,
  `jtopcms_def_jstp` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`contentId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of jtopcms_model_main_ext
-- ----------------------------

-- ----------------------------
-- Table structure for `jtopcms_model_mhxw`
-- ----------------------------
DROP TABLE IF EXISTS `jtopcms_model_mhxw`;
CREATE TABLE `jtopcms_model_mhxw` (
  `contentId` bigint(20) NOT NULL,
  `jtopcms_def_mh_wz` longtext,
  PRIMARY KEY (`contentId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of jtopcms_model_mhxw
-- ----------------------------

-- ----------------------------
-- Table structure for `jtopcms_model_mh_ly`
-- ----------------------------
DROP TABLE IF EXISTS `jtopcms_model_mh_ly`;
CREATE TABLE `jtopcms_model_mh_ly` (
  `contentId` bigint(20) NOT NULL,
  `jtopcms_def_mh_lylx` int(11) DEFAULT NULL,
  `jtopcms_def_mh_ly_lxdh` varchar(60) DEFAULT NULL,
  `jtopcms_def_mh_ly_qqhm` varchar(60) DEFAULT NULL,
  `jtopcms_def_mh_ly_mail` varchar(60) DEFAULT NULL,
  `jtopcms_def_mh_ly_dwdz` varchar(300) DEFAULT NULL,
  `jtopcms_def_mh_ly_slr` varchar(200) DEFAULT NULL,
  `jtopcms_def_mh_ly_zltp` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`contentId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of jtopcms_model_mh_ly
-- ----------------------------

-- ----------------------------
-- Table structure for `jtopcms_model_mh_mem`
-- ----------------------------
DROP TABLE IF EXISTS `jtopcms_model_mh_mem`;
CREATE TABLE `jtopcms_model_mh_mem` (
  `contentId` bigint(20) NOT NULL,
  `jtopcms_def_mh_mem_gzdw` varchar(300) DEFAULT NULL,
  `jtopcms_def_mh_mem_bm` varchar(120) DEFAULT NULL,
  `jtopcms_def_mh_mem_xl` int(11) DEFAULT NULL,
  `jtopcms_def_mh_mem_zwjs` varchar(2000) DEFAULT NULL,
  PRIMARY KEY (`contentId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of jtopcms_model_mh_mem
-- ----------------------------

-- ----------------------------
-- Table structure for `jtopcms_model_mh_sp`
-- ----------------------------
DROP TABLE IF EXISTS `jtopcms_model_mh_sp`;
CREATE TABLE `jtopcms_model_mh_sp` (
  `contentId` bigint(20) NOT NULL,
  `jtopcms_def_mh_sp_file` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`contentId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of jtopcms_model_mh_sp
-- ----------------------------

-- ----------------------------
-- Table structure for `jtopcms_model_xiazai`
-- ----------------------------
DROP TABLE IF EXISTS `jtopcms_model_xiazai`;
CREATE TABLE `jtopcms_model_xiazai` (
  `contentId` bigint(20) NOT NULL,
  `jtopcms_def_mbwj` varchar(200) DEFAULT NULL,
  `jtopcms_def_wjmc` varchar(60) DEFAULT NULL,
  `jtopcms_def_czxt` int(11) DEFAULT NULL,
  `jtopcms_def_rjsp` varchar(200) DEFAULT NULL,
  `jtopcms_def_rjmc` varchar(700) DEFAULT NULL,
  `jtopcms_def_xiala` int(11) DEFAULT NULL,
  PRIMARY KEY (`contentId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of jtopcms_model_xiazai
-- ----------------------------

-- ----------------------------
-- Table structure for `jtopcms_model_xwz`
-- ----------------------------
DROP TABLE IF EXISTS `jtopcms_model_xwz`;
CREATE TABLE `jtopcms_model_xwz` (
  `contentId` bigint(20) NOT NULL,
  `jtopcms_def_content` longtext,
  PRIMARY KEY (`contentId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of jtopcms_model_xwz
-- ----------------------------

-- ----------------------------
-- Table structure for `jtopcms_model_zcmgbext`
-- ----------------------------
DROP TABLE IF EXISTS `jtopcms_model_zcmgbext`;
CREATE TABLE `jtopcms_model_zcmgbext` (
  `contentId` bigint(20) NOT NULL,
  `jtopcms_def_zcmgbxmid` bigint(20) DEFAULT NULL,
  `jtopcms_def_zcmgbxmmc` varchar(60) DEFAULT NULL,
  PRIMARY KEY (`contentId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of jtopcms_model_zcmgbext
-- ----------------------------

-- ----------------------------
-- Table structure for `jtopcms_model_zcmkz`
-- ----------------------------
DROP TABLE IF EXISTS `jtopcms_model_zcmkz`;
CREATE TABLE `jtopcms_model_zcmkz` (
  `contentId` bigint(20) NOT NULL,
  `jtopcms_def_zcmydt` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`contentId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of jtopcms_model_zcmkz
-- ----------------------------

-- ----------------------------
-- Table structure for `jtopcms_model_zcmtzsq`
-- ----------------------------
DROP TABLE IF EXISTS `jtopcms_model_zcmtzsq`;
CREATE TABLE `jtopcms_model_zcmtzsq` (
  `contentId` bigint(20) NOT NULL,
  `jtopcms_def_sq_qymc` varchar(120) DEFAULT NULL,
  `jtopcms_def_sq_fr` varchar(60) DEFAULT NULL,
  `jtopcms_def_sq_phone` varchar(60) DEFAULT NULL,
  `jtopcms_def_sq_jkje` varchar(60) DEFAULT NULL,
  `jtopcms_def_sq_jkqx` varchar(60) DEFAULT NULL,
  `jtopcms_def_sq_hkly` varchar(2000) DEFAULT NULL,
  `jtopcms_def_sq_dy` varchar(4000) DEFAULT NULL,
  PRIMARY KEY (`contentId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of jtopcms_model_zcmtzsq
-- ----------------------------

-- ----------------------------
-- Table structure for `jtopcms_model_zt_cs`
-- ----------------------------
DROP TABLE IF EXISTS `jtopcms_model_zt_cs`;
CREATE TABLE `jtopcms_model_zt_cs` (
  `contentId` bigint(20) NOT NULL,
  `jtopcms_def_zt_zd1` varchar(60) DEFAULT NULL,
  `jtopcms_def_zt_tp1` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`contentId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of jtopcms_model_zt_cs
-- ----------------------------

-- ----------------------------
-- Table structure for `jtopcms_model_zwfw`
-- ----------------------------
DROP TABLE IF EXISTS `jtopcms_model_zwfw`;
CREATE TABLE `jtopcms_model_zwfw` (
  `contentId` bigint(20) NOT NULL,
  `jtopcms_def_serType` int(11) DEFAULT NULL,
  `jtopcms_def_dx` varchar(70) DEFAULT NULL,
  `jtopcms_def_danwei` varchar(60) DEFAULT NULL,
  `jtopcms_def_phone` varchar(60) DEFAULT NULL,
  `jtopcms_def_qq` varchar(60) DEFAULT NULL,
  `jtopcms_def_fkType` int(11) DEFAULT NULL,
  PRIMARY KEY (`contentId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of jtopcms_model_zwfw
-- ----------------------------

-- ----------------------------
-- Table structure for `manager_message`
-- ----------------------------
DROP TABLE IF EXISTS `manager_message`;
CREATE TABLE `manager_message` (
  `msgId` bigint(20) NOT NULL AUTO_INCREMENT,
  `msgTypeName` varchar(300) NOT NULL,
  `msgTitle` varchar(600) NOT NULL,
  `msgContent` text NOT NULL,
  `replyContent` text,
  `sender` bigint(20) NOT NULL,
  `sendDT` datetime DEFAULT NULL,
  `replyDT` datetime DEFAULT NULL,
  `userId` bigint(20) NOT NULL,
  `isRead` int(11) NOT NULL,
  `isReply` int(11) NOT NULL,
  `isReDelete` int(11) NOT NULL,
  `isSeDelete` int(11) NOT NULL,
  PRIMARY KEY (`msgId`)
) ENGINE=InnoDB AUTO_INCREMENT=306 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of manager_message
-- ----------------------------

-- ----------------------------
-- Table structure for `member`
-- ----------------------------
DROP TABLE IF EXISTS `member`;
CREATE TABLE `member` (
  `memberId` bigint(20) NOT NULL AUTO_INCREMENT,
  `memberName` varchar(200) NOT NULL,
  `email` varchar(150) DEFAULT NULL,
  `headPhoto` varchar(200) DEFAULT NULL,
  `isTrueEmail` int(11) NOT NULL,
  `password` varchar(400) DEFAULT NULL,
  `isTruePass` int(11) DEFAULT NULL,
  `phoneNumber` varchar(20) DEFAULT NULL,
  `isTruePhone` int(11) NOT NULL,
  `regDT` datetime DEFAULT NULL,
  `trueName` varchar(50) DEFAULT NULL,
  `certType` int(11) DEFAULT NULL,
  `certCode` varchar(200) DEFAULT NULL,
  `certPhotoP` varchar(200) DEFAULT NULL,
  `certPhotoR` varchar(200) DEFAULT NULL,
  `isTrueMan` int(11) DEFAULT NULL,
  `prevLoginIp` varchar(60) DEFAULT NULL,
  `prevLoginArea` varchar(80) DEFAULT NULL,
  `prevLoginDT` datetime DEFAULT NULL,
  `currLoginIp` varchar(60) DEFAULT NULL,
  `currLoginDT` datetime DEFAULT NULL,
  `memLevel` int(11) NOT NULL,
  `score` bigint(20) NOT NULL,
  `useStatus` int(11) NOT NULL,
  `siteId` bigint(20) NOT NULL,
  `isFirst` int(6) DEFAULT '0',
  `loginSuccessCount` bigint(20) NOT NULL,
  PRIMARY KEY (`memberId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of member
-- ----------------------------

-- ----------------------------
-- Table structure for `member_acc_class_relate_role`
-- ----------------------------
DROP TABLE IF EXISTS `member_acc_class_relate_role`;
CREATE TABLE `member_acc_class_relate_role` (
  `classId` bigint(20) NOT NULL,
  `roleId` bigint(20) NOT NULL,
  `siteId` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of member_acc_class_relate_role
-- ----------------------------

-- ----------------------------
-- Table structure for `member_acc_rule`
-- ----------------------------
DROP TABLE IF EXISTS `member_acc_rule`;
CREATE TABLE `member_acc_rule` (
  `accRuleId` bigint(20) NOT NULL AUTO_INCREMENT,
  `accName` varchar(120) NOT NULL,
  `ruleDesc` varchar(500) DEFAULT NULL,
  `minScore` bigint(20) NOT NULL,
  `minLever` bigint(20) NOT NULL,
  `roleIds` varchar(4000) DEFAULT NULL,
  `eft` int(11) NOT NULL,
  `typeId` int(11) NOT NULL,
  `siteId` bigint(20) NOT NULL,
  PRIMARY KEY (`accRuleId`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of member_acc_rule
-- ----------------------------

-- ----------------------------
-- Table structure for `member_class_acc`
-- ----------------------------
DROP TABLE IF EXISTS `member_class_acc`;
CREATE TABLE `member_class_acc` (
  `classId` bigint(20) NOT NULL,
  `accRuleId` bigint(20) NOT NULL,
  `siteId` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of member_class_acc
-- ----------------------------

-- ----------------------------
-- Table structure for `member_class_submit_acc`
-- ----------------------------
DROP TABLE IF EXISTS `member_class_submit_acc`;
CREATE TABLE `member_class_submit_acc` (
  `classId` bigint(20) NOT NULL,
  `accRuleId` bigint(20) NOT NULL,
  `siteId` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of member_class_submit_acc
-- ----------------------------

-- ----------------------------
-- Table structure for `member_login_trace`
-- ----------------------------
DROP TABLE IF EXISTS `member_login_trace`;
CREATE TABLE `member_login_trace` (
  `ip` varchar(60) NOT NULL,
  `eventDT` varchar(255) NOT NULL,
  `loginSuccess` int(6) NOT NULL,
  `userName` varchar(100) DEFAULT NULL,
  `siteId` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of member_login_trace
-- ----------------------------

-- ----------------------------
-- Table structure for `member_lost_email_trace`
-- ----------------------------
DROP TABLE IF EXISTS `member_lost_email_trace`;
CREATE TABLE `member_lost_email_trace` (
  `keyStr` varchar(3000) NOT NULL,
  `eventDt` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of member_lost_email_trace
-- ----------------------------

-- ----------------------------
-- Table structure for `member_message`
-- ----------------------------
DROP TABLE IF EXISTS `member_message`;
CREATE TABLE `member_message` (
  `msgId` bigint(20) NOT NULL AUTO_INCREMENT,
  `msgTypeName` varchar(300) DEFAULT NULL,
  `msgTitle` varchar(600) NOT NULL,
  `msgContent` text NOT NULL,
  `sendDT` datetime DEFAULT NULL,
  `memberId` bigint(20) NOT NULL,
  `isSys` int(11) NOT NULL,
  `isRead` int(6) NOT NULL,
  PRIMARY KEY (`msgId`),
  KEY `memId` (`memberId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of member_message
-- ----------------------------

-- ----------------------------
-- Table structure for `member_message_template`
-- ----------------------------
DROP TABLE IF EXISTS `member_message_template`;
CREATE TABLE `member_message_template` (
  `mtId` bigint(20) NOT NULL AUTO_INCREMENT,
  `mtFlag` varchar(60) NOT NULL,
  `templateName` varchar(200) DEFAULT NULL,
  `templateTitle` varchar(300) DEFAULT NULL,
  `templateContent` text,
  `creator` varchar(60) NOT NULL,
  `siteId` bigint(20) NOT NULL,
  PRIMARY KEY (`mtId`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of member_message_template
-- ----------------------------

-- ----------------------------
-- Table structure for `member_message_template_param`
-- ----------------------------
DROP TABLE IF EXISTS `member_message_template_param`;
CREATE TABLE `member_message_template_param` (
  `tpId` bigint(20) NOT NULL AUTO_INCREMENT,
  `paramName` varchar(80) NOT NULL,
  `paramFlag` varchar(100) NOT NULL,
  `creator` varchar(60) NOT NULL,
  `siteId` bigint(20) NOT NULL,
  PRIMARY KEY (`tpId`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of member_message_template_param
-- ----------------------------

-- ----------------------------
-- Table structure for `member_rank`
-- ----------------------------
DROP TABLE IF EXISTS `member_rank`;
CREATE TABLE `member_rank` (
  `rankId` bigint(20) NOT NULL AUTO_INCREMENT,
  `rankName` varchar(200) NOT NULL,
  `rankLevel` int(11) NOT NULL,
  `minScore` bigint(20) NOT NULL,
  `maxScore` bigint(20) NOT NULL,
  `rankDesc` varchar(600) DEFAULT NULL,
  `siteId` bigint(20) NOT NULL,
  PRIMARY KEY (`rankId`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of member_rank
-- ----------------------------

-- ----------------------------
-- Table structure for `member_relate_role`
-- ----------------------------
DROP TABLE IF EXISTS `member_relate_role`;
CREATE TABLE `member_relate_role` (
  `userId` bigint(20) DEFAULT NULL,
  `roleId` bigint(20) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of member_relate_role
-- ----------------------------

-- ----------------------------
-- Table structure for `member_role`
-- ----------------------------
DROP TABLE IF EXISTS `member_role`;
CREATE TABLE `member_role` (
  `roleId` bigint(20) NOT NULL AUTO_INCREMENT,
  `siteId` bigint(20) NOT NULL,
  `roleName` varchar(100) NOT NULL,
  `roleDesc` varchar(200) DEFAULT NULL,
  `useState` int(6) NOT NULL,
  PRIMARY KEY (`roleId`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of member_role
-- ----------------------------

-- ----------------------------
-- Table structure for `member_role_relate_resource`
-- ----------------------------
DROP TABLE IF EXISTS `member_role_relate_resource`;
CREATE TABLE `member_role_relate_resource` (
  `roleId` bigint(20) NOT NULL,
  `secResId` bigint(20) NOT NULL,
  KEY `sec` (`secResId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of member_role_relate_resource
-- ----------------------------

-- ----------------------------
-- Table structure for `member_score_act`
-- ----------------------------
DROP TABLE IF EXISTS `member_score_act`;
CREATE TABLE `member_score_act` (
  `saId` bigint(20) NOT NULL AUTO_INCREMENT,
  `actName` varchar(60) NOT NULL,
  `actFlag` int(11) NOT NULL,
  `actScore` int(11) NOT NULL,
  `targetCmd` varchar(120) DEFAULT NULL,
  `actClass` varchar(500) DEFAULT NULL,
  `actDesc` varchar(600) DEFAULT NULL,
  `siteId` bigint(20) NOT NULL,
  PRIMARY KEY (`saId`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of member_score_act
-- ----------------------------

-- ----------------------------
-- Table structure for `member_securityresource`
-- ----------------------------
DROP TABLE IF EXISTS `member_securityresource`;
CREATE TABLE `member_securityresource` (
  `secResId` bigint(20) NOT NULL AUTO_INCREMENT,
  `sysFlag` varchar(80) DEFAULT NULL,
  `resourceName` varchar(50) NOT NULL,
  `icon` varchar(300) DEFAULT NULL,
  `resourceDesc` varchar(300) DEFAULT NULL,
  `resourceType` int(6) NOT NULL COMMENT '1=功能菜单 ， 2=模块入口， 3=功能集合',
  `useState` int(6) NOT NULL,
  `dataProtectType` int(6) NOT NULL,
  `creator` varchar(20) NOT NULL,
  `target` varchar(300) DEFAULT NULL,
  `parentResId` bigint(20) DEFAULT NULL,
  `isLeaf` int(6) NOT NULL,
  `layer` int(6) NOT NULL,
  `isLastChild` int(6) NOT NULL,
  `linearOrderFlag` varchar(400) NOT NULL,
  `dataSecLevel` int(6) DEFAULT NULL,
  `dataSecTypeId` bigint(20) DEFAULT NULL,
  `siteId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`secResId`),
  KEY `target_key` (`target`),
  KEY `sec-resT` (`dataSecTypeId`,`resourceType`),
  KEY `dp-linear` (`dataProtectType`,`linearOrderFlag`(383))
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of member_securityresource
-- ----------------------------

-- ----------------------------
-- Table structure for `member_third_login`
-- ----------------------------
DROP TABLE IF EXISTS `member_third_login`;
CREATE TABLE `member_third_login` (
  `selfMemberId` bigint(20) NOT NULL,
  `loginType` varchar(15) NOT NULL,
  `openUid` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`selfMemberId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of member_third_login
-- ----------------------------

-- ----------------------------
-- Table structure for `model`
-- ----------------------------
DROP TABLE IF EXISTS `model`;
CREATE TABLE `model` (
  `dataModelId` bigint(20) NOT NULL AUTO_INCREMENT,
  `modelName` varchar(100) NOT NULL,
  `modelSign` varchar(50) NOT NULL COMMENT '标记：此标记唯一',
  `relateTableName` varchar(100) NOT NULL COMMENT '关联的表名，要注意建立的表不能有数据库系统使用单词',
  `modelResType` int(6) NOT NULL,
  `modelType` int(6) NOT NULL,
  `remark` varchar(500) DEFAULT NULL,
  `useState` int(6) NOT NULL,
  `mainEditorFieldSign` varchar(20) DEFAULT NULL,
  `validateBehavior` varchar(300) DEFAULT NULL,
  `beforeBehavior` varchar(300) DEFAULT NULL,
  `privateMode` int(6) NOT NULL,
  `afterBehavior` varchar(300) DEFAULT NULL,
  `specialListPage` varchar(300) DEFAULT NULL,
  `specialAddPage` varchar(300) DEFAULT NULL,
  `specialEditPage` varchar(300) DEFAULT NULL,
  `ico` varchar(160) DEFAULT NULL,
  `siteId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`dataModelId`)
) ENGINE=InnoDB AUTO_INCREMENT=99 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of model
-- ----------------------------

-- ----------------------------
-- Table structure for `model_filed_metadata`
-- ----------------------------
DROP TABLE IF EXISTS `model_filed_metadata`;
CREATE TABLE `model_filed_metadata` (
  `metaDataId` bigint(20) NOT NULL AUTO_INCREMENT,
  `dataModelId` bigint(20) NOT NULL COMMENT '所属的模型ID',
  `showName` varchar(60) NOT NULL,
  `relateFiledName` varchar(70) NOT NULL,
  `perdureType` varchar(30) NOT NULL COMMENT '对应的持久层类型',
  `capacity` bigint(20) DEFAULT NULL,
  `filedSign` varchar(60) NOT NULL,
  `queryFlag` int(6) DEFAULT NULL,
  `orderFlag` int(6) DEFAULT NULL,
  `searchFlag` int(6) DEFAULT NULL,
  `orderId` double DEFAULT NULL,
  PRIMARY KEY (`metaDataId`)
) ENGINE=InnoDB AUTO_INCREMENT=495 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of model_filed_metadata
-- ----------------------------

-- ----------------------------
-- Table structure for `model_html_config`
-- ----------------------------
DROP TABLE IF EXISTS `model_html_config`;
CREATE TABLE `model_html_config` (
  `htmlConfigId` bigint(20) NOT NULL AUTO_INCREMENT,
  `metaDataId` bigint(20) NOT NULL,
  `htmlElementId` bigint(20) NOT NULL,
  `htmlDesc` varchar(400) DEFAULT NULL,
  `isMustFill` int(6) DEFAULT NULL,
  `maxLength` int(11) DEFAULT NULL,
  `defaultValue` varchar(60) DEFAULT NULL,
  `choiceValue` text,
  `errorMessage` varchar(500) DEFAULT NULL,
  `htmlContent` longtext,
  `allowableFile` varchar(200) DEFAULT NULL,
  `dataType` int(6) DEFAULT NULL,
  `style` varchar(3000) DEFAULT NULL,
  `cssClass` varchar(40) DEFAULT NULL,
  `javascript` text,
  `checkRegex` varchar(2000) DEFAULT NULL,
  `defaultValidate` varchar(300) DEFAULT NULL,
  `needMark` int(6) DEFAULT NULL COMMENT '是否需要水印',
  `imageH` int(11) DEFAULT NULL,
  `imageW` int(11) DEFAULT NULL,
  `imageDisposeMode` int(6) DEFAULT NULL,
  `linkModelId` bigint(20) DEFAULT NULL,
  `linkType` int(6) DEFAULT NULL COMMENT '是否选择类型数据关联',
  `linkFieldId` bigint(20) DEFAULT NULL COMMENT '各选择类型元素数据关联id',
  `useSysUrl` int(6) DEFAULT NULL COMMENT '文件是否使用系统生成地址，隐藏真实路径',
  `fullEditor` int(6) DEFAULT NULL COMMENT '是否为全功能编辑器',
  `mainEditor` int(6) DEFAULT NULL COMMENT '是否为主编辑器，一个模型只存在一个主编辑器',
  `editorW` int(11) DEFAULT NULL,
  `editorH` int(11) DEFAULT NULL,
  `blankCount` int(11) DEFAULT NULL,
  PRIMARY KEY (`htmlConfigId`)
) ENGINE=InnoDB AUTO_INCREMENT=532 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of model_html_config
-- ----------------------------

-- ----------------------------
-- Table structure for `model_html_element`
-- ----------------------------
DROP TABLE IF EXISTS `model_html_element`;
CREATE TABLE `model_html_element` (
  `htmlElementId` bigint(20) NOT NULL,
  `htmlElementName` varchar(50) NOT NULL,
  `htmlInputTemplet` mediumtext NOT NULL,
  `htmlEditTemplet` mediumtext NOT NULL,
  `layoutParam` varchar(300) DEFAULT NULL,
  `valueParam` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`htmlElementId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of model_html_element
-- ----------------------------

-- ----------------------------
-- Table structure for `model_icon_config`
-- ----------------------------
DROP TABLE IF EXISTS `model_icon_config`;
CREATE TABLE `model_icon_config` (
  `modelId` bigint(20) NOT NULL DEFAULT '0',
  `iconFile` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`modelId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of model_icon_config
-- ----------------------------

-- ----------------------------
-- Table structure for `model_persistence_code`
-- ----------------------------
DROP TABLE IF EXISTS `model_persistence_code`;
CREATE TABLE `model_persistence_code` (
  `dataModelId` bigint(20) NOT NULL DEFAULT '0',
  `insertSql` mediumtext,
  `deleteSql` mediumtext,
  `updateSql` mediumtext,
  `selectSql` mediumtext,
  `selectColumn` mediumtext,
  `listSelectColumn` mediumtext,
  PRIMARY KEY (`dataModelId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of model_persistence_code
-- ----------------------------

-- ----------------------------
-- Table structure for `model_res_path_inject_assist`
-- ----------------------------
DROP TABLE IF EXISTS `model_res_path_inject_assist`;
CREATE TABLE `model_res_path_inject_assist` (
  `modelId` bigint(20) NOT NULL,
  `fieldName` varchar(240) NOT NULL,
  `resType` int(6) NOT NULL,
  `metaDataId` bigint(20) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of model_res_path_inject_assist
-- ----------------------------

-- ----------------------------
-- Table structure for `model_validate_config`
-- ----------------------------
DROP TABLE IF EXISTS `model_validate_config`;
CREATE TABLE `model_validate_config` (
  `validateConfigId` bigint(20) NOT NULL AUTO_INCREMENT,
  `validateName` varchar(60) NOT NULL,
  `regulation` varchar(400) NOT NULL,
  `errorMessage` varchar(600) NOT NULL,
  PRIMARY KEY (`validateConfigId`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of model_validate_config
-- ----------------------------

-- ----------------------------
-- Table structure for `pick_content_rule`
-- ----------------------------
DROP TABLE IF EXISTS `pick_content_rule`;
CREATE TABLE `pick_content_rule` (
  `pickCfgId` bigint(20) NOT NULL AUTO_INCREMENT,
  `configName` varchar(80) NOT NULL,
  `listHeadUrlRule` varchar(500) DEFAULT NULL,
  `listUrlRule` varchar(700) DEFAULT NULL,
  `contentUrlRule` text,
  `contentPageUrlRule` text,
  `prefixSiteUrl` varchar(300) DEFAULT NULL,
  `configDesc` varchar(600) DEFAULT NULL,
  `titleStart` varchar(2000) DEFAULT NULL,
  `titleEnd` varchar(2000) DEFAULT NULL,
  `contentStart` varchar(2000) DEFAULT NULL,
  `contentEnd` varchar(2000) DEFAULT NULL,
  `summaryStart` varchar(2000) DEFAULT NULL,
  `summaryEnd` varchar(2000) DEFAULT NULL,
  `addDateStart` varchar(2000) DEFAULT NULL,
  `addDateEnd` varchar(2000) DEFAULT NULL,
  `authorStart` varchar(2000) DEFAULT NULL,
  `authorEnd` varchar(2000) DEFAULT NULL,
  `sourceStart` varchar(2000) DEFAULT NULL,
  `sourceEnd` varchar(2000) DEFAULT NULL,
  `keywordStart` varchar(2000) DEFAULT NULL,
  `keywordEnd` varchar(2000) DEFAULT NULL,
  `htmlMode` int(6) DEFAULT NULL,
  `siteId` bigint(20) NOT NULL,
  PRIMARY KEY (`pickCfgId`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of pick_content_rule
-- ----------------------------

-- ----------------------------
-- Table structure for `pick_content_task`
-- ----------------------------
DROP TABLE IF EXISTS `pick_content_task`;
CREATE TABLE `pick_content_task` (
  `pickTaskId` bigint(20) NOT NULL AUTO_INCREMENT,
  `taskName` varchar(100) NOT NULL,
  `taskDesc` varchar(400) DEFAULT NULL,
  `ruleId` bigint(20) NOT NULL,
  `classId` bigint(20) NOT NULL,
  `deleteHref` int(6) DEFAULT NULL,
  `downOutImg` int(6) DEFAULT NULL,
  `guideImgPos` int(11) DEFAULT NULL,
  `pickThreadCount` int(11) DEFAULT NULL,
  `pickInterval` int(11) DEFAULT NULL,
  `pickMaxListPage` int(11) DEFAULT NULL,
  `pickMaxContent` int(11) DEFAULT NULL,
  `censorMode` int(6) NOT NULL,
  `siteId` bigint(20) NOT NULL,
  `excuteDT` datetime DEFAULT NULL,
  `selfJobId` bigint(20) DEFAULT NULL,
  `period` int(6) DEFAULT NULL,
  `periodType` int(6) DEFAULT NULL,
  PRIMARY KEY (`pickTaskId`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of pick_content_task
-- ----------------------------

-- ----------------------------
-- Table structure for `pick_web_trace`
-- ----------------------------
DROP TABLE IF EXISTS `pick_web_trace`;
CREATE TABLE `pick_web_trace` (
  `tid` bigint(20) NOT NULL AUTO_INCREMENT,
  `title` varchar(500) DEFAULT NULL,
  `targetUrl` varchar(450) DEFAULT NULL,
  `classId` bigint(20) DEFAULT NULL,
  `selfRuleId` bigint(20) DEFAULT NULL,
  `eventDT` datetime DEFAULT NULL,
  `pickSucc` int(6) DEFAULT NULL,
  `tags` varchar(200) DEFAULT NULL,
  `author` varchar(60) DEFAULT NULL,
  `siteId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`tid`)
) ENGINE=InnoDB AUTO_INCREMENT=5396 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of pick_web_trace
-- ----------------------------

-- ----------------------------
-- Table structure for `publish_file_track`
-- ----------------------------
DROP TABLE IF EXISTS `publish_file_track`;
CREATE TABLE `publish_file_track` (
  `action` int(11) NOT NULL,
  `fileId` bigint(20) NOT NULL DEFAULT '0',
  `systemHandleTime` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `sysDisposeStatus` int(11) NOT NULL,
  PRIMARY KEY (`fileId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of publish_file_track
-- ----------------------------

-- ----------------------------
-- Table structure for `publish_page_assistant`
-- ----------------------------
DROP TABLE IF EXISTS `publish_page_assistant`;
CREATE TABLE `publish_page_assistant` (
  `queryKey` varchar(400) DEFAULT NULL,
  `classTemplateUrl` varchar(200) NOT NULL,
  `classId` bigint(20) NOT NULL,
  `lastPn` int(11) DEFAULT NULL,
  `lastPageStaticUrl` varchar(500) DEFAULT NULL,
  `ruleId` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of publish_page_assistant
-- ----------------------------

-- ----------------------------
-- Table structure for `publish_rule`
-- ----------------------------
DROP TABLE IF EXISTS `publish_rule`;
CREATE TABLE `publish_rule` (
  `ruleId` bigint(20) NOT NULL AUTO_INCREMENT,
  `ruleName` varchar(200) NOT NULL,
  `type` int(11) NOT NULL,
  `pagePathParam` varchar(400) DEFAULT NULL,
  `pagePathRule` varchar(500) DEFAULT NULL,
  `savePathParam` varchar(500) DEFAULT NULL,
  `savePathRule` varchar(600) DEFAULT NULL,
  `pageSize` int(11) DEFAULT NULL,
  `pageFileNameRule` varchar(200) DEFAULT NULL,
  `pageFileNameParam` varchar(200) DEFAULT NULL,
  `fileNameParam` varchar(500) DEFAULT NULL,
  `fileNameRule` varchar(500) DEFAULT NULL,
  `suffixRule` varchar(20) NOT NULL,
  `needPage` int(11) DEFAULT NULL,
  `siteId` bigint(20) NOT NULL,
  PRIMARY KEY (`ruleId`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of publish_rule
-- ----------------------------

-- ----------------------------
-- Table structure for `publish_temporary_content`
-- ----------------------------
DROP TABLE IF EXISTS `publish_temporary_content`;
CREATE TABLE `publish_temporary_content` (
  `contentId` bigint(20) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of publish_temporary_content
-- ----------------------------

-- ----------------------------
-- Table structure for `role_range_fl_org_relate_res`
-- ----------------------------
DROP TABLE IF EXISTS `role_range_fl_org_relate_res`;
CREATE TABLE `role_range_fl_org_relate_res` (
  `resId` bigint(20) NOT NULL,
  `orgId` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of role_range_fl_org_relate_res
-- ----------------------------

-- ----------------------------
-- Table structure for `role_range_fl_org_relate_site`
-- ----------------------------
DROP TABLE IF EXISTS `role_range_fl_org_relate_site`;
CREATE TABLE `role_range_fl_org_relate_site` (
  `orgId` bigint(20) DEFAULT NULL,
  `siteId` bigint(20) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of role_range_fl_org_relate_site
-- ----------------------------

-- ----------------------------
-- Table structure for `role_range_org_relate_resource`
-- ----------------------------
DROP TABLE IF EXISTS `role_range_org_relate_resource`;
CREATE TABLE `role_range_org_relate_resource` (
  `orgId` bigint(20) NOT NULL,
  `resId` bigint(20) NOT NULL,
  KEY `orgId` (`orgId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of role_range_org_relate_resource
-- ----------------------------

-- ----------------------------
-- Table structure for `role_range_org_relate_res_acc`
-- ----------------------------
DROP TABLE IF EXISTS `role_range_org_relate_res_acc`;
CREATE TABLE `role_range_org_relate_res_acc` (
  `orgId` bigint(20) NOT NULL,
  `resId` bigint(20) NOT NULL,
  `accId` bigint(20) NOT NULL,
  `dataSecTypeId` bigint(20) NOT NULL,
  `siteId` bigint(20) NOT NULL,
  KEY `ots` (`orgId`,`accId`,`siteId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of role_range_org_relate_res_acc
-- ----------------------------

-- ----------------------------
-- Table structure for `role_range_org_relate_site`
-- ----------------------------
DROP TABLE IF EXISTS `role_range_org_relate_site`;
CREATE TABLE `role_range_org_relate_site` (
  `orgId` bigint(20) NOT NULL,
  `siteId` bigint(20) NOT NULL,
  `parOrgId` bigint(20) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of role_range_org_relate_site
-- ----------------------------

-- ----------------------------
-- Table structure for `role_range_root_org_relate_site`
-- ----------------------------
DROP TABLE IF EXISTS `role_range_root_org_relate_site`;
CREATE TABLE `role_range_root_org_relate_site` (
  `orgId` bigint(20) DEFAULT NULL,
  `siteId` bigint(20) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of role_range_root_org_relate_site
-- ----------------------------

-- ----------------------------
-- Table structure for `role_relate_resource`
-- ----------------------------
DROP TABLE IF EXISTS `role_relate_resource`;
CREATE TABLE `role_relate_resource` (
  `roleId` bigint(20) NOT NULL,
  `secResId` bigint(20) NOT NULL,
  KEY `sec` (`secResId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of role_relate_resource
-- ----------------------------

-- ----------------------------
-- Table structure for `role_relate_resource_acc`
-- ----------------------------
DROP TABLE IF EXISTS `role_relate_resource_acc`;
CREATE TABLE `role_relate_resource_acc` (
  `roleId` bigint(20) NOT NULL,
  `secResId` bigint(20) NOT NULL,
  `accId` bigint(20) NOT NULL,
  `dataSecTypeId` bigint(20) NOT NULL,
  `siteId` bigint(20) NOT NULL,
  KEY `sec_acc` (`secResId`,`accId`),
  KEY `role_res` (`roleId`,`secResId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of role_relate_resource_acc
-- ----------------------------

-- ----------------------------
-- Table structure for `role_relate_site`
-- ----------------------------
DROP TABLE IF EXISTS `role_relate_site`;
CREATE TABLE `role_relate_site` (
  `roleId` bigint(20) NOT NULL,
  `siteId` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of role_relate_site
-- ----------------------------

-- ----------------------------
-- Table structure for `role_relate_workflow_acc`
-- ----------------------------
DROP TABLE IF EXISTS `role_relate_workflow_acc`;
CREATE TABLE `role_relate_workflow_acc` (
  `roleId` bigint(20) NOT NULL,
  `accId` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of role_relate_workflow_acc
-- ----------------------------

-- ----------------------------
-- Table structure for `schedule_job_detail`
-- ----------------------------
DROP TABLE IF EXISTS `schedule_job_detail`;
CREATE TABLE `schedule_job_detail` (
  `jobId` bigint(20) NOT NULL AUTO_INCREMENT,
  `jobName` varchar(60) NOT NULL,
  `jobDesc` varchar(500) DEFAULT NULL,
  `jobExecuteClass` varchar(450) NOT NULL,
  `triggerType` int(11) NOT NULL,
  `periodSegment` int(11) DEFAULT NULL,
  `periodVar` int(11) DEFAULT NULL,
  `dayExeTime` varchar(50) DEFAULT NULL,
  `cronExpression` varchar(100) DEFAULT NULL,
  `lastExcuteTime` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `jobStartDate` timestamp NULL DEFAULT '0000-00-00 00:00:00',
  `jobEndDate` timestamp NULL DEFAULT NULL,
  `systemJob` int(11) NOT NULL,
  `useState` int(11) NOT NULL,
  `siteId` bigint(20) NOT NULL,
  PRIMARY KEY (`jobId`)
) ENGINE=InnoDB AUTO_INCREMENT=50 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of schedule_job_detail
-- ----------------------------

-- ----------------------------
-- Table structure for `schedule_publish_job_target`
-- ----------------------------
DROP TABLE IF EXISTS `schedule_publish_job_target`;
CREATE TABLE `schedule_publish_job_target` (
  `selfJobId` bigint(20) NOT NULL DEFAULT '0',
  `homePage` varchar(6) DEFAULT NULL,
  `channel` varchar(6) DEFAULT NULL,
  `spec` varchar(6) DEFAULT NULL,
  PRIMARY KEY (`selfJobId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of schedule_publish_job_target
-- ----------------------------

-- ----------------------------
-- Table structure for `search_config`
-- ----------------------------
DROP TABLE IF EXISTS `search_config`;
CREATE TABLE `search_config` (
  `indexConfigId` bigint(20) NOT NULL AUTO_INCREMENT,
  `siteId` bigint(20) NOT NULL,
  `jobId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`indexConfigId`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of search_config
-- ----------------------------

-- ----------------------------
-- Table structure for `search_index_content_state`
-- ----------------------------
DROP TABLE IF EXISTS `search_index_content_state`;
CREATE TABLE `search_index_content_state` (
  `indexStateId` bigint(20) NOT NULL AUTO_INCREMENT,
  `contentId` bigint(20) DEFAULT '0',
  `siteId` bigint(20) NOT NULL,
  `classId` bigint(20) DEFAULT NULL,
  `modelId` bigint(20) DEFAULT NULL,
  `censor` int(6) DEFAULT NULL,
  `indexDate` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `eventFlag` int(11) NOT NULL,
  PRIMARY KEY (`indexStateId`),
  KEY `s_i` (`siteId`,`indexStateId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of search_index_content_state
-- ----------------------------

-- ----------------------------
-- Table structure for `search_key_count`
-- ----------------------------
DROP TABLE IF EXISTS `search_key_count`;
CREATE TABLE `search_key_count` (
  `skId` bigint(20) NOT NULL AUTO_INCREMENT,
  `queryKey` varchar(200) NOT NULL,
  `count` int(11) NOT NULL,
  `siteId` bigint(20) NOT NULL,
  PRIMARY KEY (`skId`)
) ENGINE=InnoDB AUTO_INCREMENT=46 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of search_key_count
-- ----------------------------

-- ----------------------------
-- Table structure for `securityresource`
-- ----------------------------
DROP TABLE IF EXISTS `securityresource`;
CREATE TABLE `securityresource` (
  `secResId` bigint(20) NOT NULL AUTO_INCREMENT,
  `sysFlag` varchar(80) DEFAULT NULL,
  `resourceName` varchar(50) NOT NULL,
  `icon` varchar(300) DEFAULT NULL,
  `resourceDesc` varchar(300) DEFAULT NULL,
  `resourceType` int(6) NOT NULL COMMENT '1=功能菜单 ， 2=模块入口， 3=功能集合',
  `useState` int(6) NOT NULL,
  `dataProtectType` int(6) NOT NULL,
  `creator` varchar(20) NOT NULL,
  `target` varchar(300) DEFAULT NULL,
  `parentResId` bigint(20) DEFAULT NULL,
  `isLeaf` int(6) NOT NULL,
  `layer` int(6) NOT NULL,
  `isLastChild` int(6) NOT NULL,
  `linearOrderFlag` varchar(400) NOT NULL,
  `dataSecLevel` int(6) DEFAULT NULL,
  `dataSecTypeId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`secResId`),
  KEY `target_key` (`target`),
  KEY `sec-resT` (`dataSecTypeId`,`resourceType`),
  KEY `dp-linear` (`dataProtectType`,`linearOrderFlag`(383))
) ENGINE=InnoDB AUTO_INCREMENT=607 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of securityresource
-- ----------------------------

-- ----------------------------
-- Table structure for `security_data_type`
-- ----------------------------
DROP TABLE IF EXISTS `security_data_type`;
CREATE TABLE `security_data_type` (
  `dataTypeId` bigint(20) NOT NULL AUTO_INCREMENT,
  `typeName` varchar(60) NOT NULL,
  `dtDesc` varchar(120) DEFAULT NULL,
  `accSymbol` varchar(80) NOT NULL,
  `isSys` int(11) DEFAULT NULL,
  `accBehaviorClass` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`dataTypeId`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of security_data_type
-- ----------------------------

-- ----------------------------
-- Table structure for `sitetemplet`
-- ----------------------------
DROP TABLE IF EXISTS `sitetemplet`;
CREATE TABLE `sitetemplet` (
  `templetId` bigint(20) NOT NULL AUTO_INCREMENT,
  `templetFileName` varchar(80) NOT NULL DEFAULT '0',
  `templetDisplayName` varchar(60) DEFAULT NULL,
  `type` int(6) NOT NULL COMMENT '1.栏目展示模板 2.内容展示模板',
  `relatedTempletFilePath` varchar(350) DEFAULT NULL,
  `templetFullPath` varchar(350) NOT NULL,
  `siteName` varchar(50) NOT NULL,
  `templetDesc` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`templetId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of sitetemplet
-- ----------------------------

-- ----------------------------
-- Table structure for `site_announce`
-- ----------------------------
DROP TABLE IF EXISTS `site_announce`;
CREATE TABLE `site_announce` (
  `anId` bigint(20) NOT NULL AUTO_INCREMENT,
  `anTitle` varchar(300) NOT NULL,
  `content` text,
  `showStartDate` datetime DEFAULT NULL,
  `showEndDate` datetime DEFAULT NULL,
  `anOrder` bigint(20) DEFAULT NULL,
  `siteId` bigint(20) NOT NULL,
  PRIMARY KEY (`anId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of site_announce
-- ----------------------------

-- ----------------------------
-- Table structure for `site_cms_server`
-- ----------------------------
DROP TABLE IF EXISTS `site_cms_server`;
CREATE TABLE `site_cms_server` (
  `serverId` bigint(20) NOT NULL AUTO_INCREMENT,
  `domain` varchar(300) NOT NULL,
  `context` varchar(100) DEFAULT NULL,
  `port` int(11) DEFAULT NULL,
  `firstInitOver` int(11) NOT NULL,
  PRIMARY KEY (`serverId`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of site_cms_server
-- ----------------------------

-- ----------------------------
-- Table structure for `site_def_template_config`
-- ----------------------------
DROP TABLE IF EXISTS `site_def_template_config`;
CREATE TABLE `site_def_template_config` (
  `siteId` bigint(20) DEFAULT NULL,
  `modelId` bigint(20) DEFAULT NULL,
  `templateType` bigint(20) DEFAULT NULL,
  `listTemplateUrl` varchar(180) DEFAULT NULL,
  `contentTemplateUrl` varchar(180) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of site_def_template_config
-- ----------------------------

-- ----------------------------
-- Table structure for `site_delete_trace`
-- ----------------------------
DROP TABLE IF EXISTS `site_delete_trace`;
CREATE TABLE `site_delete_trace` (
  `siteId` bigint(20) DEFAULT NULL,
  `siteFlag` varchar(100) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of site_delete_trace
-- ----------------------------

-- ----------------------------
-- Table structure for `site_de_access`
-- ----------------------------
DROP TABLE IF EXISTS `site_de_access`;
CREATE TABLE `site_de_access` (
  `infoId` bigint(20) NOT NULL AUTO_INCREMENT,
  `blackIp` varchar(50) NOT NULL,
  `startDT` datetime DEFAULT NULL,
  `endDT` datetime DEFAULT NULL,
  `effectHour` int(11) NOT NULL,
  `isDeForever` int(6) NOT NULL,
  PRIMARY KEY (`infoId`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of site_de_access
-- ----------------------------

-- ----------------------------
-- Table structure for `site_de_access_trace`
-- ----------------------------
DROP TABLE IF EXISTS `site_de_access_trace`;
CREATE TABLE `site_de_access_trace` (
  `trId` bigint(20) NOT NULL AUTO_INCREMENT,
  `ip` varchar(50) NOT NULL,
  `targetUrl` varchar(400) NOT NULL,
  `dangerStr` varchar(3000) NOT NULL,
  `queryStr` text,
  `eventDT` datetime DEFAULT NULL,
  `eventDay` date DEFAULT NULL,
  PRIMARY KEY (`trId`)
) ENGINE=InnoDB AUTO_INCREMENT=104 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of site_de_access_trace
-- ----------------------------

-- ----------------------------
-- Table structure for `site_dispense_server`
-- ----------------------------
DROP TABLE IF EXISTS `site_dispense_server`;
CREATE TABLE `site_dispense_server` (
  `serverId` bigint(20) NOT NULL AUTO_INCREMENT,
  `protocol` int(11) NOT NULL,
  `serverName` varchar(60) NOT NULL,
  `serverIP` varchar(30) NOT NULL,
  `serverPort` varchar(10) NOT NULL,
  `serverUrl` varchar(80) DEFAULT NULL,
  `fileRoot` varchar(500) DEFAULT NULL,
  `connectStatus` int(6) DEFAULT NULL,
  `status` int(11) NOT NULL,
  `loginName` varchar(60) DEFAULT NULL,
  `loginPassword` varchar(80) DEFAULT NULL,
  `filterFlag` varchar(500) DEFAULT NULL,
  `siteId` bigint(20) NOT NULL,
  PRIMARY KEY (`serverId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of site_dispense_server
-- ----------------------------

-- ----------------------------
-- Table structure for `site_file_transfe_state`
-- ----------------------------
DROP TABLE IF EXISTS `site_file_transfe_state`;
CREATE TABLE `site_file_transfe_state` (
  `transferFileId` bigint(20) NOT NULL AUTO_INCREMENT,
  `gatewayId` bigint(20) NOT NULL,
  `filePath` varchar(400) DEFAULT NULL,
  `fullPath` varchar(500) DEFAULT NULL,
  `transferStatus` int(11) NOT NULL,
  `fileEventFlag` int(30) NOT NULL,
  `eventTime` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `siteId` bigint(20) NOT NULL,
  PRIMARY KEY (`transferFileId`),
  KEY `gid` (`gatewayId`,`transferFileId`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of site_file_transfe_state
-- ----------------------------

-- ----------------------------
-- Table structure for `site_group`
-- ----------------------------
DROP TABLE IF EXISTS `site_group`;
CREATE TABLE `site_group` (
  `siteId` bigint(20) NOT NULL AUTO_INCREMENT,
  `siteRoot` varchar(40) NOT NULL,
  `siteFlag` varchar(60) NOT NULL,
  `siteName` varchar(100) NOT NULL,
  `siteUrl` varchar(255) NOT NULL,
  `logoImage` varchar(120) DEFAULT NULL,
  `copyright` varchar(140) DEFAULT NULL,
  `icp` varchar(50) DEFAULT NULL,
  `homePageTemplate` varchar(100) DEFAULT NULL,
  `siteDesc` varchar(450) DEFAULT NULL,
  `staticFileType` int(6) DEFAULT NULL,
  `homePageProduceType` int(6) NOT NULL,
  `homePageStaticUrl` varchar(200) DEFAULT NULL,
  `publishRoot` varchar(40) DEFAULT NULL,
  `imageRoot` varchar(40) DEFAULT NULL,
  `mediaRoot` varchar(40) DEFAULT NULL,
  `fileRoot` varchar(40) DEFAULT NULL,
  `templateCharset` varchar(12) NOT NULL,
  `seoTitle` varchar(300) DEFAULT NULL,
  `seoKeyword` varchar(300) DEFAULT NULL,
  `seoDesc` varchar(500) DEFAULT NULL,
  `shareMode` int(6) NOT NULL,
  `downOutImage` int(6) NOT NULL,
  `deleteOutLink` int(6) NOT NULL,
  `sameTitle` int(6) DEFAULT NULL,
  `genKw` int(6) DEFAULT NULL,
  `summaryLength` int(11) DEFAULT NULL,
  `defClickCount` int(11) DEFAULT NULL,
  `managerIP` varchar(600) DEFAULT NULL,
  `siteCollType` int(6) DEFAULT NULL,
  `outSiteCollUrl` varchar(200) DEFAULT NULL,
  `sendMailHost` varchar(60) DEFAULT NULL,
  `mail` varchar(60) DEFAULT NULL,
  `mailUserName` varchar(30) DEFAULT NULL,
  `mailUserPW` varchar(40) DEFAULT NULL,
  `mailSSL` int(6) DEFAULT NULL,
  `smsApiUrl` varchar(500) DEFAULT NULL,
  `smsAccount` varchar(100) DEFAULT NULL,
  `smsPW` varchar(100) DEFAULT NULL,
  `smsSendOnceSec` int(11) DEFAULT NULL,
  `smsMaxCount` int(11) DEFAULT NULL,
  `smsIpDayCount` int(11) DEFAULT NULL,
  `managerLoginTime` int(11) DEFAULT NULL,
  `searchFun` int(6) DEFAULT NULL,
  `useFW` int(6) DEFAULT NULL,
  `imageAllowType` varchar(220) DEFAULT NULL,
  `mediaAllowType` varchar(220) DEFAULT NULL,
  `fileAllowType` varchar(320) DEFAULT NULL,
  `imageMaxC` int(11) DEFAULT NULL,
  `mediaMaxC` int(11) DEFAULT NULL,
  `fileMaxC` int(11) DEFAULT NULL,
  `useImageMark` int(6) DEFAULT NULL,
  `imageMarkType` int(6) DEFAULT NULL,
  `offSetX` int(11) DEFAULT NULL,
  `offSetY` int(11) DEFAULT NULL,
  `imageMarkPos` varchar(50) DEFAULT NULL,
  `imageMarkChar` varchar(60) DEFAULT NULL,
  `imageMark` varchar(200) DEFAULT NULL,
  `imageMarkDis` int(11) DEFAULT NULL,
  `defEditorImageW` int(11) DEFAULT NULL,
  `defEditorImageH` int(11) DEFAULT NULL,
  `defEditorImageDM` int(6) DEFAULT NULL,
  `defHomeImageW` int(11) DEFAULT NULL,
  `defHomeImageH` int(11) DEFAULT NULL,
  `defHomeImageDM` int(6) DEFAULT NULL,
  `defClassImageW` int(11) DEFAULT NULL,
  `defClassImageH` int(11) DEFAULT NULL,
  `defClassImageDM` int(6) DEFAULT NULL,
  `defListImageW` int(11) DEFAULT NULL,
  `defListImageH` int(11) DEFAULT NULL,
  `defListImageDM` int(6) DEFAULT NULL,
  `defContentImageW` int(11) DEFAULT NULL,
  `defContentImageH` int(11) DEFAULT NULL,
  `defContentImageDM` int(6) DEFAULT NULL,
  `extDataModelId` bigint(20) DEFAULT NULL,
  `extMemberModelId` bigint(20) DEFAULT NULL,
  `allowMemberReg` int(11) DEFAULT NULL,
  `wxAppId` varchar(50) DEFAULT NULL,
  `wxAppKey` varchar(100) DEFAULT NULL,
  `wxPrevUid` varchar(100) DEFAULT NULL,
  `qqAppId` varchar(50) DEFAULT NULL,
  `qqAppKey` varchar(100) DEFAULT NULL,
  `qqBackUri` varchar(500) DEFAULT NULL,
  `wbAppId` varchar(50) DEFAULT NULL,
  `wbAppKey` varchar(100) DEFAULT NULL,
  `wbBackUri` varchar(500) DEFAULT NULL,
  `regMailText` varchar(2000) DEFAULT NULL,
  `mailRegBackUri` varchar(300) DEFAULT NULL,
  `relateMemberUri` varchar(100) DEFAULT NULL,
  `thirdLoginErrorUri` varchar(100) DEFAULT NULL,
  `thirdLoginSuccessUri` varchar(100) DEFAULT NULL,
  `resetPwText` varchar(2000) DEFAULT NULL,
  `resetPwBackUri` varchar(300) DEFAULT NULL,
  `memberDefRoleId` bigint(20) DEFAULT NULL,
  `memberDefLv` int(6) DEFAULT NULL,
  `memberDefSc` bigint(20) DEFAULT NULL,
  `useState` int(6) NOT NULL,
  PRIMARY KEY (`siteId`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of site_group
-- ----------------------------

-- ----------------------------
-- Table structure for `site_mail_queue`
-- ----------------------------
DROP TABLE IF EXISTS `site_mail_queue`;
CREATE TABLE `site_mail_queue` (
  `mailId` varchar(60) NOT NULL,
  `sendTo` varchar(4000) DEFAULT NULL,
  `subject` varchar(800) DEFAULT NULL,
  `mailContent` mediumtext,
  `createDT` datetime DEFAULT NULL,
  `siteId` bigint(20) NOT NULL,
  PRIMARY KEY (`mailId`),
  KEY `dt` (`createDT`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of site_mail_queue
-- ----------------------------

-- ----------------------------
-- Table structure for `site_publish_gateway`
-- ----------------------------
DROP TABLE IF EXISTS `site_publish_gateway`;
CREATE TABLE `site_publish_gateway` (
  `gatewayId` bigint(20) NOT NULL AUTO_INCREMENT,
  `collectJobId` bigint(20) DEFAULT NULL,
  `transferJobId` bigint(20) DEFAULT NULL,
  `name` varchar(60) NOT NULL,
  `transfeType` int(11) NOT NULL,
  `sourcePath` varchar(500) DEFAULT NULL,
  `targetServerId` bigint(20) DEFAULT NULL,
  `siteRoot` varchar(200) DEFAULT NULL,
  `siteId` bigint(20) NOT NULL,
  `targetServerRoot` varchar(200) DEFAULT NULL,
  `useState` int(11) NOT NULL,
  PRIMARY KEY (`gatewayId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of site_publish_gateway
-- ----------------------------

-- ----------------------------
-- Table structure for `site_resource`
-- ----------------------------
DROP TABLE IF EXISTS `site_resource`;
CREATE TABLE `site_resource` (
  `resId` bigint(20) NOT NULL AUTO_INCREMENT,
  `classId` bigint(20) NOT NULL,
  `siteId` bigint(20) NOT NULL,
  `fileType` varchar(12) DEFAULT NULL,
  `resType` int(11) NOT NULL,
  `resName` varchar(100) DEFAULT NULL,
  `resSource` varchar(80) NOT NULL,
  `resSize` bigint(20) DEFAULT NULL,
  `width` int(11) DEFAULT NULL,
  `height` int(11) DEFAULT NULL,
  `duration` int(11) DEFAULT NULL,
  `resolution` varchar(30) DEFAULT NULL,
  `cover` varchar(80) DEFAULT NULL,
  `haveMark` int(6) DEFAULT NULL,
  `downloadCount` bigint(20) DEFAULT NULL,
  `modifyTime` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`resId`),
  KEY `rc` (`classId`,`resType`,`resId`),
  KEY `re_src` (`resSource`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of site_resource
-- ----------------------------

-- ----------------------------
-- Table structure for `site_resource_upload_trace`
-- ----------------------------
DROP TABLE IF EXISTS `site_resource_upload_trace`;
CREATE TABLE `site_resource_upload_trace` (
  `resId` bigint(20) NOT NULL,
  `uploadDate` datetime DEFAULT NULL,
  `isUse` int(6) NOT NULL,
  PRIMARY KEY (`resId`),
  KEY `date` (`uploadDate`,`isUse`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of site_resource_upload_trace
-- ----------------------------

-- ----------------------------
-- Table structure for `site_sensitive_word`
-- ----------------------------
DROP TABLE IF EXISTS `site_sensitive_word`;
CREATE TABLE `site_sensitive_word` (
  `swId` bigint(20) NOT NULL AUTO_INCREMENT,
  `sensitiveStr` varchar(600) NOT NULL,
  `replaceStr` varchar(60) NOT NULL,
  `useStatus` int(11) NOT NULL,
  PRIMARY KEY (`swId`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of site_sensitive_word
-- ----------------------------

-- ----------------------------
-- Table structure for `site_share_content`
-- ----------------------------
DROP TABLE IF EXISTS `site_share_content`;
CREATE TABLE `site_share_content` (
  `sscId` bigint(20) NOT NULL AUTO_INCREMENT,
  `contentId` bigint(20) NOT NULL DEFAULT '0',
  `fromSiteId` bigint(20) NOT NULL,
  `toSiteId` bigint(20) NOT NULL,
  `modelId` bigint(20) NOT NULL,
  `fromClassId` bigint(20) NOT NULL,
  `isPub` int(6) NOT NULL,
  PRIMARY KEY (`sscId`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of site_share_content
-- ----------------------------

-- ----------------------------
-- Table structure for `site_share_content_trace`
-- ----------------------------
DROP TABLE IF EXISTS `site_share_content_trace`;
CREATE TABLE `site_share_content_trace` (
  `contentId` bigint(20) NOT NULL,
  `siteId` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of site_share_content_trace
-- ----------------------------

-- ----------------------------
-- Table structure for `stat_date_helper`
-- ----------------------------
DROP TABLE IF EXISTS `stat_date_helper`;
CREATE TABLE `stat_date_helper` (
  `prevDay` date DEFAULT NULL,
  `currentDay` date DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of stat_date_helper
-- ----------------------------

-- ----------------------------
-- Table structure for `stat_manager_login_trace`
-- ----------------------------
DROP TABLE IF EXISTS `stat_manager_login_trace`;
CREATE TABLE `stat_manager_login_trace` (
  `ip` varchar(60) NOT NULL,
  `eventDT` varchar(255) NOT NULL,
  `loginSuccess` int(6) NOT NULL,
  `userName` varchar(100) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of stat_manager_login_trace
-- ----------------------------

-- ----------------------------
-- Table structure for `stat_uvid_trace`
-- ----------------------------
DROP TABLE IF EXISTS `stat_uvid_trace`;
CREATE TABLE `stat_uvid_trace` (
  `uvid` varchar(60) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of stat_uvid_trace
-- ----------------------------

-- ----------------------------
-- Table structure for `stat_visitor_area_analysis`
-- ----------------------------
DROP TABLE IF EXISTS `stat_visitor_area_analysis`;
CREATE TABLE `stat_visitor_area_analysis` (
  `pvCount` bigint(20) NOT NULL,
  `area` varchar(80) NOT NULL,
  `siteId` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of stat_visitor_area_analysis
-- ----------------------------

-- ----------------------------
-- Table structure for `stat_visitor_br_analysis`
-- ----------------------------
DROP TABLE IF EXISTS `stat_visitor_br_analysis`;
CREATE TABLE `stat_visitor_br_analysis` (
  `pvCount` bigint(20) NOT NULL,
  `brName` varchar(80) NOT NULL,
  `siteId` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of stat_visitor_br_analysis
-- ----------------------------

-- ----------------------------
-- Table structure for `stat_visitor_class_analysis`
-- ----------------------------
DROP TABLE IF EXISTS `stat_visitor_class_analysis`;
CREATE TABLE `stat_visitor_class_analysis` (
  `pvCount` bigint(20) NOT NULL,
  `classId` bigint(20) NOT NULL,
  `siteId` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of stat_visitor_class_analysis
-- ----------------------------

-- ----------------------------
-- Table structure for `stat_visitor_content_analysis`
-- ----------------------------
DROP TABLE IF EXISTS `stat_visitor_content_analysis`;
CREATE TABLE `stat_visitor_content_analysis` (
  `pvCount` bigint(20) NOT NULL,
  `contentId` bigint(20) NOT NULL,
  `siteId` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of stat_visitor_content_analysis
-- ----------------------------

-- ----------------------------
-- Table structure for `stat_visitor_day_analysis`
-- ----------------------------
DROP TABLE IF EXISTS `stat_visitor_day_analysis`;
CREATE TABLE `stat_visitor_day_analysis` (
  `uvCount` int(11) NOT NULL,
  `ipCount` int(11) NOT NULL,
  `pvCount` int(11) NOT NULL,
  `visitYear` int(11) NOT NULL,
  `visitMonth` int(11) NOT NULL,
  `visitDay` int(11) NOT NULL,
  `vdt` datetime DEFAULT NULL,
  `newUv` int(11) NOT NULL,
  `oldUv` int(11) NOT NULL,
  `siteId` bigint(20) NOT NULL,
  KEY `sda_vd` (`visitYear`,`visitMonth`,`visitDay`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of stat_visitor_day_analysis
-- ----------------------------

-- ----------------------------
-- Table structure for `stat_visitor_day_exit_analysis`
-- ----------------------------
DROP TABLE IF EXISTS `stat_visitor_day_exit_analysis`;
CREATE TABLE `stat_visitor_day_exit_analysis` (
  `url` varchar(800) NOT NULL,
  `visitYear` int(11) NOT NULL,
  `visitMonth` int(11) NOT NULL,
  `visitDay` int(11) NOT NULL,
  `count` int(11) NOT NULL,
  `siteId` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of stat_visitor_day_exit_analysis
-- ----------------------------

-- ----------------------------
-- Table structure for `stat_visitor_day_gate_analysis`
-- ----------------------------
DROP TABLE IF EXISTS `stat_visitor_day_gate_analysis`;
CREATE TABLE `stat_visitor_day_gate_analysis` (
  `url` varchar(800) NOT NULL,
  `visitYear` int(11) NOT NULL,
  `visitMonth` int(11) NOT NULL,
  `visitDay` int(11) NOT NULL,
  `count` int(11) NOT NULL,
  `siteId` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of stat_visitor_day_gate_analysis
-- ----------------------------

-- ----------------------------
-- Table structure for `stat_visitor_host_analysis`
-- ----------------------------
DROP TABLE IF EXISTS `stat_visitor_host_analysis`;
CREATE TABLE `stat_visitor_host_analysis` (
  `pvCount` bigint(20) NOT NULL,
  `host` varchar(200) NOT NULL,
  `siteId` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of stat_visitor_host_analysis
-- ----------------------------

-- ----------------------------
-- Table structure for `stat_visitor_hour_analysis`
-- ----------------------------
DROP TABLE IF EXISTS `stat_visitor_hour_analysis`;
CREATE TABLE `stat_visitor_hour_analysis` (
  `uvCount` int(70) NOT NULL,
  `ipCount` int(50) NOT NULL,
  `pvCount` int(11) NOT NULL,
  `visitYear` int(11) NOT NULL,
  `visitMonth` int(11) NOT NULL,
  `visitDay` int(11) NOT NULL,
  `visitHour` int(11) NOT NULL,
  `siteId` bigint(20) NOT NULL,
  `newUv` int(11) NOT NULL,
  `oldUv` int(11) NOT NULL,
  KEY `sha_vd` (`visitYear`,`visitMonth`,`visitDay`,`visitHour`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of stat_visitor_hour_analysis
-- ----------------------------

-- ----------------------------
-- Table structure for `stat_visitor_la_analysis`
-- ----------------------------
DROP TABLE IF EXISTS `stat_visitor_la_analysis`;
CREATE TABLE `stat_visitor_la_analysis` (
  `pvCount` bigint(20) NOT NULL,
  `laName` varchar(40) NOT NULL,
  `siteId` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of stat_visitor_la_analysis
-- ----------------------------

-- ----------------------------
-- Table structure for `stat_visitor_os_analysis`
-- ----------------------------
DROP TABLE IF EXISTS `stat_visitor_os_analysis`;
CREATE TABLE `stat_visitor_os_analysis` (
  `pvCount` bigint(20) NOT NULL,
  `osName` varchar(50) NOT NULL,
  `siteId` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of stat_visitor_os_analysis
-- ----------------------------

-- ----------------------------
-- Table structure for `stat_visitor_resol_analysis`
-- ----------------------------
DROP TABLE IF EXISTS `stat_visitor_resol_analysis`;
CREATE TABLE `stat_visitor_resol_analysis` (
  `pvCount` bigint(20) NOT NULL,
  `resVal` varchar(30) NOT NULL,
  `siteId` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of stat_visitor_resol_analysis
-- ----------------------------

-- ----------------------------
-- Table structure for `stat_visitor_search_analysis`
-- ----------------------------
DROP TABLE IF EXISTS `stat_visitor_search_analysis`;
CREATE TABLE `stat_visitor_search_analysis` (
  `uvCount` bigint(20) NOT NULL,
  `searchName` varchar(60) NOT NULL,
  `siteId` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of stat_visitor_search_analysis
-- ----------------------------

-- ----------------------------
-- Table structure for `stat_visitor_seh_key_analysis`
-- ----------------------------
DROP TABLE IF EXISTS `stat_visitor_seh_key_analysis`;
CREATE TABLE `stat_visitor_seh_key_analysis` (
  `uvCount` bigint(20) NOT NULL,
  `keyVal` varchar(200) NOT NULL,
  `siteId` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of stat_visitor_seh_key_analysis
-- ----------------------------

-- ----------------------------
-- Table structure for `stat_visitor_source_analysis`
-- ----------------------------
DROP TABLE IF EXISTS `stat_visitor_source_analysis`;
CREATE TABLE `stat_visitor_source_analysis` (
  `manUvCount` int(70) NOT NULL,
  `searchUvCount` int(50) NOT NULL,
  `sprUvCount` int(11) NOT NULL,
  `visitYear` int(11) NOT NULL,
  `visitMonth` int(11) NOT NULL,
  `visitDay` int(11) NOT NULL,
  `vdt` datetime DEFAULT NULL,
  `siteId` bigint(20) NOT NULL,
  KEY `visitDate` (`visitYear`,`visitMonth`,`visitDay`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of stat_visitor_source_analysis
-- ----------------------------

-- ----------------------------
-- Table structure for `stat_visitor_src_s_analysis`
-- ----------------------------
DROP TABLE IF EXISTS `stat_visitor_src_s_analysis`;
CREATE TABLE `stat_visitor_src_s_analysis` (
  `uvCount` bigint(20) NOT NULL,
  `siteUrl` varchar(200) NOT NULL,
  `siteId` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of stat_visitor_src_s_analysis
-- ----------------------------

-- ----------------------------
-- Table structure for `stat_visitor_url_analysis`
-- ----------------------------
DROP TABLE IF EXISTS `stat_visitor_url_analysis`;
CREATE TABLE `stat_visitor_url_analysis` (
  `clickCount` bigint(20) NOT NULL,
  `url` varchar(500) NOT NULL,
  `siteId` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of stat_visitor_url_analysis
-- ----------------------------

-- ----------------------------
-- Table structure for `stat_visit_info`
-- ----------------------------
DROP TABLE IF EXISTS `stat_visit_info`;
CREATE TABLE `stat_visit_info` (
  `visitorId` bigint(20) NOT NULL AUTO_INCREMENT,
  `uvId` varchar(60) NOT NULL,
  `host` varchar(300) DEFAULT NULL,
  `reffer` varchar(2000) DEFAULT NULL,
  `refferHost` varchar(200) DEFAULT NULL,
  `refferType` int(4) DEFAULT NULL,
  `refferKey` varchar(200) DEFAULT NULL,
  `visitTimeIn` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `visitTimeOut` timestamp NULL DEFAULT '0000-00-00 00:00:00',
  `ip` varchar(50) NOT NULL,
  `url` varchar(550) NOT NULL,
  `title` varchar(460) DEFAULT NULL,
  `browser` varchar(240) DEFAULT NULL,
  `screen` varchar(50) DEFAULT NULL,
  `system` varchar(45) DEFAULT NULL,
  `lang` varchar(15) DEFAULT NULL,
  `source` varchar(50) DEFAULT NULL,
  `visitYear` int(11) NOT NULL,
  `visitMonth` int(11) NOT NULL,
  `visitDay` int(11) NOT NULL,
  `visitHour` int(11) NOT NULL,
  `contentId` bigint(20) DEFAULT NULL,
  `classId` bigint(20) DEFAULT NULL,
  `siteId` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`visitorId`),
  KEY `visit-date` (`visitDay`,`visitHour`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of stat_visit_info
-- ----------------------------

-- ----------------------------
-- Table structure for `survey_base_info`
-- ----------------------------
DROP TABLE IF EXISTS `survey_base_info`;
CREATE TABLE `survey_base_info` (
  `surveyId` bigint(20) NOT NULL AUTO_INCREMENT,
  `groupFlag` varchar(60) NOT NULL,
  `groupId` bigint(20) NOT NULL,
  `optionType` int(6) NOT NULL,
  `surveyTitle` varchar(500) NOT NULL,
  `haveText` int(6) NOT NULL,
  `addiTitle` varchar(300) DEFAULT NULL,
  `siteFlag` varchar(40) NOT NULL,
  `orderFlag` int(11) NOT NULL,
  PRIMARY KEY (`surveyId`)
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of survey_base_info
-- ----------------------------

-- ----------------------------
-- Table structure for `survey_group`
-- ----------------------------
DROP TABLE IF EXISTS `survey_group`;
CREATE TABLE `survey_group` (
  `groupId` bigint(20) NOT NULL AUTO_INCREMENT,
  `classId` bigint(20) DEFAULT NULL,
  `questName` varchar(200) NOT NULL,
  `flagName` varchar(120) NOT NULL,
  `questDesc` varchar(500) DEFAULT NULL,
  `restriction` int(11) NOT NULL,
  `restInterval` int(11) DEFAULT NULL,
  `startDate` datetime DEFAULT NULL,
  `endDate` datetime DEFAULT NULL,
  `needCaptcha` int(11) NOT NULL,
  `useState` int(11) NOT NULL,
  `handlers` varchar(80) DEFAULT NULL,
  `siteId` bigint(20) NOT NULL,
  PRIMARY KEY (`groupId`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of survey_group
-- ----------------------------

-- ----------------------------
-- Table structure for `survey_option_info`
-- ----------------------------
DROP TABLE IF EXISTS `survey_option_info`;
CREATE TABLE `survey_option_info` (
  `optionId` bigint(20) NOT NULL AUTO_INCREMENT,
  `surveyId` bigint(20) NOT NULL,
  `optionText` varchar(500) DEFAULT NULL,
  `optionImage` varchar(200) DEFAULT NULL,
  `vote` int(11) NOT NULL,
  `votePer` int(11) NOT NULL,
  `target` varchar(300) DEFAULT NULL,
  `inputText` varchar(4000) DEFAULT NULL,
  `inputTextCount` int(11) DEFAULT NULL,
  `siteFlag` varchar(40) NOT NULL,
  PRIMARY KEY (`optionId`)
) ENGINE=InnoDB AUTO_INCREMENT=238 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of survey_option_info
-- ----------------------------

-- ----------------------------
-- Table structure for `survey_vote_info`
-- ----------------------------
DROP TABLE IF EXISTS `survey_vote_info`;
CREATE TABLE `survey_vote_info` (
  `optId` bigint(20) NOT NULL,
  `surveyId` bigint(20) NOT NULL,
  `voteText` varchar(4000) DEFAULT NULL,
  `voteMan` varchar(60) DEFAULT NULL,
  `ip` varchar(50) NOT NULL,
  `voteDate` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of survey_vote_info
-- ----------------------------

-- ----------------------------
-- Table structure for `survey_vote_ip_trace`
-- ----------------------------
DROP TABLE IF EXISTS `survey_vote_ip_trace`;
CREATE TABLE `survey_vote_ip_trace` (
  `ip` varchar(24) NOT NULL,
  `surveyGroupId` bigint(20) NOT NULL,
  `lastVoteDateTime` varchar(20) DEFAULT NULL,
  KEY `ip_gid` (`lastVoteDateTime`,`ip`,`surveyGroupId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of survey_vote_ip_trace
-- ----------------------------

-- ----------------------------
-- Table structure for `syscacheclasslayer`
-- ----------------------------
DROP TABLE IF EXISTS `syscacheclasslayer`;
CREATE TABLE `syscacheclasslayer` (
  `classId` bigint(20) NOT NULL,
  `layerQuerySqlCache` mediumtext NOT NULL,
  PRIMARY KEY (`classId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of syscacheclasslayer
-- ----------------------------

-- ----------------------------
-- Table structure for `systemrole`
-- ----------------------------
DROP TABLE IF EXISTS `systemrole`;
CREATE TABLE `systemrole` (
  `roleId` bigint(20) NOT NULL AUTO_INCREMENT,
  `orgId` bigint(20) NOT NULL,
  `roleName` varchar(100) NOT NULL,
  `roleDesc` varchar(200) DEFAULT NULL,
  `useState` int(6) NOT NULL,
  PRIMARY KEY (`roleId`)
) ENGINE=InnoDB AUTO_INCREMENT=84 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of systemrole
-- ----------------------------

-- ----------------------------
-- Table structure for `systemuser`
-- ----------------------------
DROP TABLE IF EXISTS `systemuser`;
CREATE TABLE `systemuser` (
  `userId` bigint(20) NOT NULL AUTO_INCREMENT,
  `manageOrgId` bigint(20) NOT NULL,
  `userName` varchar(200) NOT NULL,
  `userTrueName` varchar(300) NOT NULL,
  `password` varchar(500) NOT NULL,
  `remark` varchar(300) DEFAULT NULL,
  `phone` varchar(60) DEFAULT NULL,
  `email` varchar(200) DEFAULT NULL,
  `addTime` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `relateOrgCode` varchar(300) DEFAULT NULL,
  `creator` varchar(30) DEFAULT NULL,
  `useState` int(6) NOT NULL,
  PRIMARY KEY (`userId`)
) ENGINE=InnoDB AUTO_INCREMENT=70 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of systemuser
-- ----------------------------

-- ----------------------------
-- Table structure for `system_cfg`
-- ----------------------------
DROP TABLE IF EXISTS `system_cfg`;
CREATE TABLE `system_cfg` (
  `serverId` bigint(20) NOT NULL AUTO_INCREMENT,
  `managerIp` varchar(4000) DEFAULT NULL,
  `loginTime` varchar(50) DEFAULT NULL,
  `openOfficePath` varchar(600) DEFAULT NULL,
  `rootOrgName` varchar(200) DEFAULT NULL,
  `baiduMapDefCity` varchar(100) DEFAULT NULL,
  `dangerAccessCount` varchar(10) DEFAULT NULL,
  `otherVCUrl` varchar(400) DEFAULT NULL,
  PRIMARY KEY (`serverId`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of system_cfg
-- ----------------------------

-- ----------------------------
-- Table structure for `system_organization`
-- ----------------------------
DROP TABLE IF EXISTS `system_organization`;
CREATE TABLE `system_organization` (
  `orgId` bigint(20) NOT NULL AUTO_INCREMENT,
  `parentId` bigint(20) NOT NULL,
  `orgFlag` varchar(60) NOT NULL,
  `orgName` varchar(300) NOT NULL,
  `orgDesc` varchar(400) DEFAULT NULL,
  `isLeaf` int(11) NOT NULL,
  `layer` int(11) NOT NULL,
  `linearOrderFlag` varchar(400) NOT NULL,
  `directorIds` varchar(500) DEFAULT NULL,
  `orgBossId` bigint(20) NOT NULL,
  `creator` varchar(80) DEFAULT NULL,
  PRIMARY KEY (`orgId`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of system_organization
-- ----------------------------

-- ----------------------------
-- Table structure for `tag_relate_content`
-- ----------------------------
DROP TABLE IF EXISTS `tag_relate_content`;
CREATE TABLE `tag_relate_content` (
  `contentId` bigint(20) NOT NULL,
  `tagId` bigint(20) NOT NULL,
  KEY `c-t-id` (`contentId`,`tagId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of tag_relate_content
-- ----------------------------

-- ----------------------------
-- Table structure for `tag_type`
-- ----------------------------
DROP TABLE IF EXISTS `tag_type`;
CREATE TABLE `tag_type` (
  `tagTypeId` bigint(20) NOT NULL AUTO_INCREMENT,
  `tagTypeName` varchar(300) NOT NULL,
  `flag` varchar(80) NOT NULL,
  `siteId` bigint(20) NOT NULL,
  PRIMARY KEY (`tagTypeId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of tag_type
-- ----------------------------

-- ----------------------------
-- Table structure for `tag_word`
-- ----------------------------
DROP TABLE IF EXISTS `tag_word`;
CREATE TABLE `tag_word` (
  `tagId` bigint(20) NOT NULL AUTO_INCREMENT,
  `tagName` varchar(100) NOT NULL,
  `tagFlag` varchar(40) DEFAULT NULL,
  `tagTypeId` bigint(20) NOT NULL,
  `firstChar` varchar(5) DEFAULT NULL,
  `clickCount` bigint(20) NOT NULL,
  `contentCount` bigint(20) NOT NULL,
  `creator` varchar(80) NOT NULL,
  `siteId` bigint(20) NOT NULL,
  PRIMARY KEY (`tagId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of tag_word
-- ----------------------------

-- ----------------------------
-- Table structure for `template_edition`
-- ----------------------------
DROP TABLE IF EXISTS `template_edition`;
CREATE TABLE `template_edition` (
  `editionId` bigint(20) NOT NULL AUTO_INCREMENT,
  `templateName` varchar(200) NOT NULL,
  `filePath` varchar(400) NOT NULL,
  `editDT` datetime DEFAULT NULL,
  `editDesc` varchar(3000) DEFAULT NULL,
  `editor` bigint(20) NOT NULL,
  `siteId` bigint(20) NOT NULL,
  PRIMARY KEY (`editionId`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of template_edition
-- ----------------------------

-- ----------------------------
-- Table structure for `template_helper`
-- ----------------------------
DROP TABLE IF EXISTS `template_helper`;
CREATE TABLE `template_helper` (
  `templetFileName` varchar(700) NOT NULL DEFAULT '0',
  `templetDisplayName` varchar(90) DEFAULT NULL,
  `siteId` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of template_helper
-- ----------------------------

-- ----------------------------
-- Table structure for `tool_editor_module_code`
-- ----------------------------
DROP TABLE IF EXISTS `tool_editor_module_code`;
CREATE TABLE `tool_editor_module_code` (
  `emId` bigint(20) NOT NULL AUTO_INCREMENT,
  `emName` varchar(60) NOT NULL,
  `emType` int(6) NOT NULL,
  `code` text,
  `emDesc` varchar(200) DEFAULT NULL,
  `useState` int(6) NOT NULL,
  `siteId` bigint(20) NOT NULL,
  PRIMARY KEY (`emId`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of tool_editor_module_code
-- ----------------------------

-- ----------------------------
-- Table structure for `tool_image_ratio`
-- ----------------------------
DROP TABLE IF EXISTS `tool_image_ratio`;
CREATE TABLE `tool_image_ratio` (
  `irId` bigint(20) NOT NULL AUTO_INCREMENT,
  `ratioName` varchar(80) NOT NULL,
  `ratioWidth` int(80) NOT NULL,
  `ratioHeight` int(11) NOT NULL,
  `siteId` bigint(20) NOT NULL,
  PRIMARY KEY (`irId`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of tool_image_ratio
-- ----------------------------

-- ----------------------------
-- Table structure for `user_relate_role`
-- ----------------------------
DROP TABLE IF EXISTS `user_relate_role`;
CREATE TABLE `user_relate_role` (
  `userId` bigint(20) NOT NULL,
  `roleId` bigint(20) NOT NULL,
  KEY `ur` (`userId`,`roleId`)
) ENGINE=InnoDB DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of user_relate_role
-- ----------------------------
