﻿using Microsoft.Practices.Prism.UnityExtensions;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using Microsoft.Practices.Unity;
using Microsoft.Practices.Prism.Modularity;

namespace SmokeRegex.Client
{
    public class Bootstrapper : UnityBootstrapper
    {
        protected override DependencyObject CreateShell()
        {
            Window shell = this.Container.Resolve<Shell>();
            shell.Show();
            Application.Current.MainWindow = shell;
            return shell;
        }

        protected override IUnityContainer CreateContainer()
        {
            var container = base.CreateContainer();
            ViewModels.Base.WindowViewModelBase.InitContainer(container);
            return container;
        }

        protected override void ConfigureContainer()
        {
            base.ConfigureContainer();

            //注册类型
            this.Container.RegisterType<Dialog.IDialogService, Dialog.NormalDialogService>();

            this.Container.RegisterType<Window, Views.DownloadHtml>(Consts.WindowNames.DownloadHtml);
            this.Container.RegisterType<Window, Views.Replace>(Consts.WindowNames.Replace);
            this.Container.RegisterType<Window, Views.Help>(Consts.WindowNames.Help);
            this.Container.RegisterType<Window, Views.About>(Consts.WindowNames.About);
            this.Container.RegisterType<Window, Views.AddCustomPattern>(Consts.WindowNames.AddCustomPattern);
        }

        protected override void ConfigureModuleCatalog()
        {
            base.ConfigureModuleCatalog();

            this.ModuleCatalog.AddModule(new ModuleInfo { ModuleName = "MainModule", ModuleType = typeof(MainModule).AssemblyQualifiedName });
        }
    }
}
