﻿using Microsoft.Practices.Unity;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace SmokeRegex.Client
{
    /// <summary>
    /// Shell.xaml 的交互逻辑
    /// </summary>
    [TemplatePart(Name = "btnClose")]
    [TemplatePart(Name = "btnNormal")]
    [TemplatePart(Name = "btnMaximize")]
    [TemplatePart(Name = "btnMinimize")]
    [TemplatePart(Name = "grdTitle")]
    public partial class Shell : Window
    {
        public Shell(IUnityContainer unityContainer)
        {
            Helpers.FullScreenHelper.RepairWpfWindowFullScreenBehavior(this);
            this.UnityContainer = unityContainer;
            InitializeComponent();
            this.SizeChanged += Shell_SizeChanged;
            this.Loaded += Shell_Loaded;
        }

        #region 私有变量

        /// <summary>
        /// 最小化按钮
        /// </summary>
        private Button btnClose;

        /// <summary>
        /// 正常按钮
        /// </summary>
        private Button btnNormal;

        /// <summary>
        /// 最大化按钮
        /// </summary>
        private Button btnMaximize;

        /// <summary>
        /// 最小化按钮
        /// </summary>
        private Button btnMinimize;

        /// <summary>
        /// 显示标题区域的Grid
        /// </summary>
        private Grid grdTitle;

        #endregion

        #region 属性
        public IUnityContainer UnityContainer { get; private set; }        
        #endregion

        void Shell_SizeChanged(object sender, SizeChangedEventArgs e)
        {
            if (this.WindowState == System.Windows.WindowState.Maximized)
            {
                btnNormal.Visibility = System.Windows.Visibility.Visible;
                btnMaximize.Visibility = System.Windows.Visibility.Collapsed;
            }
            else
            {
                btnNormal.Visibility = System.Windows.Visibility.Collapsed;
                btnMaximize.Visibility = System.Windows.Visibility.Visible;
            }

            if (this.WindowState == System.Windows.WindowState.Minimized)
            {
                this.ShowInTaskbar = false;
            }
            else
            {
                this.ShowInTaskbar = true;
            }
        }

        void Shell_Loaded(object sender, RoutedEventArgs e)
        {
            btnNormal.Click += btnNormal_Click;
            btnClose.Click += btnClose_Click;
            btnMaximize.Click += btnMaximize_Click;
            btnMinimize.Click += btnMinimize_Click;
            grdTitle.MouseLeftButtonDown += grdTitle_MouseLeftButtonDown;
        }



        public override void OnApplyTemplate()
        {
            base.OnApplyTemplate();

            btnClose = (Button)GetTemplateChild("btnClose");
            btnNormal = (Button)GetTemplateChild("btnNormal");
            btnMaximize = (Button)GetTemplateChild("btnMaximize");
            btnMinimize = (Button)GetTemplateChild("btnMinimize");
            grdTitle = (Grid)GetTemplateChild("grdTitle");
        }

        protected override void OnClosed(EventArgs e)
        {
            base.OnClosed(e);
        }

        #region 事件处理

        void btnNormal_Click(object sender, RoutedEventArgs e)
        {
            this.WindowState = System.Windows.WindowState.Normal;
        }

        void btnClose_Click(object sender, RoutedEventArgs e)
        {
            this.Close();
        }

        void btnMaximize_Click(object sender, RoutedEventArgs e)
        {
            this.WindowState = System.Windows.WindowState.Maximized;
        }

        void btnMinimize_Click(object sender, RoutedEventArgs e)
        {
            this.WindowState = System.Windows.WindowState.Minimized;
        }

        void grdTitle_MouseLeftButtonDown(object sender, MouseButtonEventArgs e)
        {
            if (e.ClickCount == 1)
            {
                this.DragMove();
            }
            else
            {
                if (this.WindowState == WindowState.Maximized)
                {
                    this.WindowState = WindowState.Normal;
                }
                else
                {
                    this.WindowState = WindowState.Maximized;
                }
            }
        }
        #endregion
    }
}
