﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using Microsoft.Practices.Prism.Events;
using Microsoft.Practices.Prism.Regions;
using Microsoft.Practices.Prism.ViewModel;
using Microsoft.Practices.Unity;

namespace SmokeRegex.Client.ViewModels.Base
{
    /// <summary>
    /// ViewModel基类
    /// </summary>
    public class ViewModelBase : NotificationObject
    {
        #region 字段
        public static IUnityContainer StaticUnityContainer;
        #endregion

        #region 属性

        private bool _isLoading;

        /// <summary>
        /// 是否正在忙碌状态
        /// </summary>
        public bool IsLoading
        {
            get { return _isLoading; }
            set
            {
                if (_isLoading != value)
                {
                    _isLoading = value;
                    this.RaisePropertyChanged("IsLoading");
                }
            }
        }

        /// <summary>
        /// 当前是否处于设计器模式
        /// </summary>
        public bool IsInDesignMode
        {
            get
            {
                return DesignerProperties.GetIsInDesignMode(new System.Windows.DependencyObject());
            }
        }

        /// <summary>
        /// RegionManager实例
        /// </summary>
        public IRegionManager RegionManager
        {
            get
            {
                return this.UnityContainer.Resolve<IRegionManager>();
            }
        }
        /// <summary>
        /// 依赖注入容器
        /// </summary>
        public IUnityContainer UnityContainer
        {
            get
            {
                return StaticUnityContainer;
            }
        }
        /// <summary>
        /// 事件聚合器
        /// </summary>
        public IEventAggregator EventAggregator
        {
            get
            {
                return this.UnityContainer.Resolve<IEventAggregator>();
            }
        }
        /// <summary>
        /// 对话框服务
        /// </summary>
        public Dialog.IDialogService DialogService
        {
            get
            {
                return this.UnityContainer.Resolve<Dialog.IDialogService>();
            }
        }

        #endregion

        #region 方法

        public static void InitContainer(IUnityContainer unityContainer)
        {
            if (StaticUnityContainer == null)
            {
                StaticUnityContainer = unityContainer;
            }
        }

        /// <summary>
        /// 发布一个事件消息
        /// 这是简化版的方法,避免写一堆GetEvent().Publish()
        /// </summary>
        /// <typeparam name="TEvent"></typeparam>
        /// <param name="e"></param>
        protected void PublishEvent<TEvent>(TEvent e)
        {
            this.EventAggregator.GetEvent<CompositePresentationEvent<TEvent>>().Publish(e);
        }

        /// <summary>
        /// 订阅一个事件消息
        /// 这是简化版的方法,避免写一堆GetEvent().Subscribe()
        /// </summary>
        /// <typeparam name="TEvent"></typeparam>
        /// <param name="action"></param>
        protected void SubscribeEvent<TEvent>(Action<TEvent> action)
        {
            this.EventAggregator.GetEvent<CompositePresentationEvent<TEvent>>().Subscribe(action);
        }

        protected void SubscribeEvent<TEvent>(Action<TEvent> action, ThreadOption threadOption, bool keepSubscriberReferenceAlive, Predicate<TEvent> filter)
        {
            this.EventAggregator.GetEvent<CompositePresentationEvent<TEvent>>().Subscribe(action, threadOption, keepSubscriberReferenceAlive, filter);
        }

        #endregion
    }
}
