﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Practices.Prism.Commands;
using Microsoft.Practices.Unity;
using SmokeRegex.Client.Dialog;
using System.Windows;

namespace SmokeRegex.Client.ViewModels.Base
{
    public class WindowViewModelBase : ViewModelBase
    {
        public WindowViewModelBase(string windowName)
            : base()
        {
            this.WindowName = windowName;
        }

        /// <summary>
        /// 窗口注册的名称
        /// </summary>
        public string WindowName { get; private set; }

        /// <summary>
        /// 窗口实体
        /// </summary>
        public Window Window { get; private set; }

        private bool _isShow;
        /// <summary>
        /// 窗口是否在显示窗台
        /// </summary>
        public bool IsShow
        {
            get { return _isShow; }
            set
            {
                if (_isShow != value)
                {
                    _isShow = value;
                    this.RaisePropertyChanged("IsShow");
                }
            }
        }

        private string _title;

        /// <summary>
        /// 窗体的标题
        /// </summary>
        public virtual string Title
        {
            get { return _title; }
            set
            {
                if (_title != value)
                {
                    _title = value;
                    this.RaisePropertyChanged("Title");
                }
            }
        }

        #region 命令

        private DelegateCommand _showCommand;

        /// <summary>
        /// 打开命令
        /// </summary>
        public DelegateCommand ShowCommand
        {
            get
            {
                if (_showCommand == null)
                {
                    _showCommand = new DelegateCommand(this.Show);
                }
                return _showCommand;
            }
        }

        private DelegateCommand _closeCommand;

        /// <summary>
        /// 关闭命令
        /// </summary>
        public DelegateCommand CloseCommand
        {
            get
            {
                if (_closeCommand == null)
                {
                    _closeCommand = new DelegateCommand(this.Close);
                }
                return _closeCommand;
            }
        }

        private DelegateCommand _minimizeCommand;

        /// <summary>
        /// 使窗体最小化命令
        /// </summary>
        public DelegateCommand MinimizeCommand
        {
            get
            {
                if (_minimizeCommand == null)
                {
                    _minimizeCommand = new DelegateCommand(this.Minimize);
                }
                return _minimizeCommand;
            }
        }

        private DelegateCommand _maximizeCommand;

        /// <summary>
        /// 使窗体最大化命令
        /// </summary>
        public DelegateCommand MaximizeCommand
        {
            get
            {
                if (_maximizeCommand == null)
                {
                    _maximizeCommand = new DelegateCommand(this.Maximize);
                }
                return _maximizeCommand;
            }
        }

        private DelegateCommand _normalCommand;

        /// <summary>
        /// 使窗体正常命令
        /// </summary>
        public DelegateCommand NormalCommand
        {
            get
            {
                if (_normalCommand == null)
                {
                    _normalCommand = new DelegateCommand(this.Normal);
                }
                return _normalCommand;
            }
        }

        private DelegateCommand _showDialogCommand;

        /// <summary>
        /// 打开模式窗口命令
        /// </summary>
        public DelegateCommand ShowDialogCommand
        {
            get
            {
                if (_showDialogCommand == null)
                {
                    _showDialogCommand = new DelegateCommand(this.ShowDialog);
                }
                return _showDialogCommand;
            }
        }

        #endregion

        #region 方法

        private Window CreateWindow()
        {
            try
            {
                var window = this.UnityContainer.Resolve<Window>(this.WindowName);
                window.Closed += window_Closed;
                window.DataContext = this;
                window.Owner = System.Windows.Application.Current.MainWindow;
                this.Window = window;
                return window;
            }
            catch
            {
                string message = string.Format("打开窗口 {0} 失败!", this.Title);
                throw new Exception(message);
            }
        }

        void window_Closed(object sender, EventArgs e)
        {
            this.Window = null;
            this.IsShow = false;
        }

        /// <summary>
        /// 显示窗口
        /// </summary>
        public virtual void Show()
        {
            if (this.Window != null)
            {
                this.Window.Show();
            }
            else
            {
                var window = this.CreateWindow();
                window.Show();
            }
            this.IsShow = true;
        }

        /// <summary>
        /// 打开模式窗口
        /// </summary>
        public virtual void ShowDialog()
        {
            if (this.Window != null)
            {
                this.Window.ShowDialog();
            }
            else
            {
                var window = this.CreateWindow();
                window.ShowDialog();
            }
            this.IsShow = true;
        }

        /// <summary>
        /// 关闭窗口
        /// </summary>
        public virtual void Close()
        {
            if (this.Window != null)
            {
                this.Window.Close();                
            }
        }

        /// <summary>
        /// 使窗体最小化
        /// </summary>
        public virtual void Minimize()
        {
            this.Window.WindowState = WindowState.Minimized;
        }

        /// <summary>
        /// 使窗体最大化
        /// </summary>
        public virtual void Maximize()
        {
            this.Window.WindowState = WindowState.Maximized;
        }

        /// <summary>
        /// 使窗体正常
        /// </summary>
        public virtual void Normal()
        {
            this.Window.WindowState = WindowState.Normal;
        }
        #endregion
    }
}
