﻿using Microsoft.Practices.Prism.Commands;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;

namespace SmokeRegex.Client.ViewModels
{
    public class CustomPatternViewModel : Base.WindowViewModelBase
    {
        private static readonly string filePath = System.Environment.CurrentDirectory + @"\Content\CustomPatterns.xml";

        public CustomPatternViewModel()
            : base(Consts.WindowNames.AddCustomPattern)
        {
            this.InitCustomPatterns();
        }

        #region 属性
        private string _name;

        /// <summary>
        /// 要保存的名称
        /// </summary>
        public string Name
        {
            get
            {
                return _name;
            }
            set
            {
                if (_name != value)
                {
                    _name = value;
                    this.RaisePropertyChanged("Name");
                }
            }
        }

        private string _errorMessage;

        /// <summary>
        /// 显示的错误信息
        /// </summary>
        public string ErrorMessage
        {
            get
            {
                return _errorMessage;
            }
            set
            {
                if (_errorMessage != value)
                {
                    _errorMessage = value;
                    this.RaisePropertyChanged("ErrorMessage");
                }
            }
        }

        private string _pattern;

        /// <summary>
        /// 要操作的表达式
        /// </summary>
        public string Pattern
        {
            get
            {
                return _pattern;
            }
            set
            {
                if (_pattern != value)
                {
                    _pattern = value;
                    this.RaisePropertyChanged("Pattern");
                }
            }
        }

        public ObservableCollection<Models.PatternInfo> CustomPatternList { get; private set; }
        #endregion

        #region 命令
        private DelegateCommand<string> _addCommand;

        public DelegateCommand<string> AddCommand
        {
            get
            {
                if (_addCommand == null)
                {
                    _addCommand = new DelegateCommand<string>(this.Add);
                }
                return _addCommand;
            }
        }

        private void Add(string parameter)
        {
            this.Name = null;
            this.ErrorMessage = null;
            this.Pattern = parameter;
            this.ShowDialog();
        }

        private DelegateCommand _submitCommand;

        public DelegateCommand SubmitCommand
        {
            get
            {
                if (_submitCommand == null)
                {
                    _submitCommand = new DelegateCommand(this.Submit);
                }
                return _submitCommand;
            }
        }

        private void Submit()
        {
            if (this.CustomPatternList.Count(t => t.Name == this.Name) > 0)
            {
                ErrorMessage = "名称重复!请重新输入!";
                return;
            }

            Models.PatternInfo item = new Models.PatternInfo
            {
                Name = this.Name,
                Pattern = this.Pattern
            };
            this.CustomPatternList.Add(item);
            this.Close();
            this.Save();
        }

        private DelegateCommand<string> _deleteCommand;

        public DelegateCommand<string> DeleteCommand
        {
            get
            {
                if (_deleteCommand == null)
                {
                    _deleteCommand = new DelegateCommand<string>(this.Delete);
                }
                return _deleteCommand;
            }
        }

        private void Delete(string parameter)
        {
            this.DialogService.Confirm("确定删除此表达式吗?", "确认操作", b =>
            {
                if (b)
                {
                    var itemList = this.CustomPatternList.Where(t => t.Pattern == parameter).ToList();
                    foreach (var item in itemList)
                    {
                        this.CustomPatternList.Remove(item);
                    }
                    this.Save();
                }
            });
        }
        #endregion

        #region 方法

        private void InitCustomPatterns()
        {
            this.CustomPatternList = new ObservableCollection<Models.PatternInfo>();

            try
            {
                var patternList = Helpers.XmlHelper.Deserialize<List<Models.PatternInfo>>(filePath);
                foreach (var item in patternList)
                {
                    this.CustomPatternList.Add(item);
                }
            }
            catch
            {
 
            }
        }

        private void Save()
        {
            Helpers.XmlHelper.Serialize(filePath, this.CustomPatternList);
        }
        #endregion
    }
}
