﻿using Microsoft.Practices.Prism.Commands;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Text;

namespace SmokeRegex.Client.ViewModels
{
    public class DownloadHtmlViewModel : Base.WindowViewModelBase
    {
        WebClient Client;

        public DownloadHtmlViewModel()
            : base(Consts.WindowNames.DownloadHtml)
        {
            this.Client = new WebClient();
            Client.DownloadStringCompleted += Client_DownloadStringCompleted;
        }

        void Client_DownloadStringCompleted(object sender, DownloadStringCompletedEventArgs e)
        {
            this.IsLoading = false;
            if (e.Error != null)
            {
                this.ErrorMessage = e.Error.InnerException.Message;
            }
            else
            {
                Events.DownloadHtmlEvent eve = new Events.DownloadHtmlEvent(e.Result);
                this.PublishEvent(eve);
                this.DownloadUri = null;
                this.Close();
            }
        }

        private string _downloadUri;

        /// <summary>
        /// 下载的路径
        /// </summary>
        public string DownloadUri
        {
            get
            {
                return _downloadUri;
            }
            set
            {
                if (_downloadUri != value)
                {
                    _downloadUri = value;
                    this.RaisePropertyChanged("DownloadUri");
                }
            }
        }


        private string _errorMessage;

        /// <summary>
        /// 可能的错误信息
        /// </summary>
        public string ErrorMessage
        {
            get
            {
                return _errorMessage;
            }
            set
            {
                if (_errorMessage != value)
                {
                    _errorMessage = value;
                    this.RaisePropertyChanged("ErrorMessage");
                }
            }
        }


        private DelegateCommand _submitCommand;

        /// <summary>
        /// 提交命令
        /// </summary>
        public DelegateCommand SubmitCommand
        {
            get
            {
                if (_submitCommand == null)
                {
                    _submitCommand = new DelegateCommand(this.Submit);
                }
                return _submitCommand;
            }
        }

        private void Submit()
        {
            Uri uri;

            if (!Uri.TryCreate(this.DownloadUri, UriKind.Absolute, out uri))
            {
                this.ErrorMessage = "请输入正确的Uri格式!";
                return;
            }
            else
            {
                this.ErrorMessage = null;
            }

            this.IsLoading = true;
            this.Client.DownloadStringAsync(uri);
        }

    }
}
