/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.validator;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.Validateable;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.MethodFilterInterceptor;
import com.opensymphony.xwork2.interceptor.PrefixMethodInvocationUtil;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import com.opensymphony.xwork2.validator.ActionValidatorManager;

public class ValidationInterceptor
extends MethodFilterInterceptor {
    private boolean validateAnnotatedMethodOnly;
    private ActionValidatorManager actionValidatorManager;
    private static final Logger LOG = LoggerFactory.getLogger(ValidationInterceptor.class);
    private static final String VALIDATE_PREFIX = "validate";
    private static final String ALT_VALIDATE_PREFIX = "validateDo";
    private boolean alwaysInvokeValidate = true;
    private boolean programmatic = true;
    private boolean declarative = true;

    @Inject
    public void setActionValidatorManager(ActionValidatorManager mgr) {
        this.actionValidatorManager = mgr;
    }

    public void setProgrammatic(boolean programmatic) {
        this.programmatic = programmatic;
    }

    public void setDeclarative(boolean declarative) {
        this.declarative = declarative;
    }

    public void setAlwaysInvokeValidate(String alwaysInvokeValidate) {
        this.alwaysInvokeValidate = Boolean.parseBoolean(alwaysInvokeValidate);
    }

    public boolean isValidateAnnotatedMethodOnly() {
        return this.validateAnnotatedMethodOnly;
    }

    public void setValidateAnnotatedMethodOnly(boolean validateAnnotatedMethodOnly) {
        this.validateAnnotatedMethodOnly = validateAnnotatedMethodOnly;
    }

    protected void doBeforeInvocation(ActionInvocation invocation) throws Exception {
        Object action = invocation.getAction();
        ActionProxy proxy = invocation.getProxy();
        String context = proxy.getActionName();
        String method = proxy.getMethod();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Validating " + invocation.getProxy().getNamespace() + "/" + invocation.getProxy().getActionName() + " with method " + method + ".", new String[0]);
        }
        if (this.declarative) {
            if (this.validateAnnotatedMethodOnly) {
                this.actionValidatorManager.validate(action, context, method);
            } else {
                this.actionValidatorManager.validate(action, context);
            }
        }
        if (action instanceof Validateable && this.programmatic) {
            Exception exception = null;
            Validateable validateable = (Validateable)action;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Invoking validate() on action " + validateable, new String[0]);
            }
            try {
                PrefixMethodInvocationUtil.invokePrefixMethod(invocation, new String[]{VALIDATE_PREFIX, ALT_VALIDATE_PREFIX});
            }
            catch (Exception e) {
                LOG.warn("an exception occured while executing the prefix method", e, new String[0]);
                exception = e;
            }
            if (this.alwaysInvokeValidate) {
                validateable.validate();
            }
            if (exception != null) {
                throw exception;
            }
        }
    }

    protected String doIntercept(ActionInvocation invocation) throws Exception {
        this.doBeforeInvocation(invocation);
        return invocation.invoke();
    }
}

