﻿/**
 * menubutton - jQuery jwwUI Copyright (c) 2013-2015 www.jeeww.com. All rights reserved. 
 * Licensed under the GPL or commercial licenses 
 */
(function($) {
	function create(target) {
		var defs = $.data(target, "menubutton").defs;
		var menubuttonObj = $(target);
		menubuttonObj.removeClass("m-btn-active m-btn-plain-active").addClass("m-btn");
		menubuttonObj.button($.extend({}, defs, { text : defs.text
		        + "<span class=\"m-btn-downarrow\">&nbsp;</span>" }));
		if (defs.menu) {
			$(defs.menu).menu({ onShow : function() {
				menubuttonObj.addClass((defs.plain == true) ? "m-btn-plain-active" : "m-btn-active");
			}, onHide : function() {
				menubuttonObj.removeClass((defs.plain == true) ? "m-btn-plain-active" : "m-btn-active");
			} });
		}
		menuButtonEvent(target, defs.disabled);
	}
	;
	function menuButtonEvent(target, disableFlag) {
		var defs = $.data(target, "menubutton").defs;
		defs.disabled = disableFlag;
		var menubuttonObj = $(target);
		if (disableFlag) {
			menubuttonObj.button("disable");
			menubuttonObj.unbind(".menubutton");
		} else {
			menubuttonObj.button("enable");
			menubuttonObj.unbind(".menubutton");
			menubuttonObj.bind("click.menubutton", function() {
				menuShowHide();
				return false;
			});
			var fun = null;
			menubuttonObj.bind("mouseenter.menubutton", function() {
				fun = setTimeout(function() {
					menuShowHide();
				}, defs.duration);
				return false;
			}).bind("mouseleave.menubutton", function() {
				if (fun) {
					clearTimeout(fun);
				}
			});
		}
		function menuShowHide() {
			if (!defs.menu) {
				return;
			}
			$("body>div.menu-top").menu("hide");
			$(defs.menu).menu("show", { alignTo : menubuttonObj });
			menubuttonObj.blur();
		}
		;
	}
	;
	$.fn.menubutton = function(defs, param) {
		if (typeof defs == "string") {
			return $.fn.menubutton.methods[defs](this, param);
		}
		defs = defs || {};
		return this.each(function() {
			var menubutton = $.data(this, "menubutton");
			if (menubutton) {
				$.extend(menubutton.defs, defs);
			} else {
				$.data(this, "menubutton", { defs : $.extend({}, $.fn.menubutton.defaults, $.fn.menubutton
				        .getDefs(this), defs) });
				$(this).removeAttr("disabled");
			}
			create(this);
		});
	};
	$.fn.menubutton.methods = { defs : function(jq) {
		return $.data(jq[0], "menubutton").defs;
	}, enable : function(jq) {
		return jq.each(function() {
			menuButtonEvent(this, false);
		});
	}, disable : function(jq) {
		return jq.each(function() {
			menuButtonEvent(this, true);
		});
	}, destroy : function(jq) {
		return jq.each(function() {
			var defs = $(this).menubutton("defs");
			if (defs.menu) {
				$(defs.menu).menu("destroy");
			}
			$(this).remove();
		});
	} };
	$.fn.menubutton.getDefs = function(param) {
		return $.extend({}, $.fn.button.getDefs(param), $.parser.getDefs(param, [ "menu",
		        { plain : "boolean", duration : "number" } ]));
	};
	$.fn.menubutton.defaults = $.extend({}, $.fn.button.defaults, { plain : true, menu : null, duration : 100 });
})(jQuery);
