﻿/**
 * numberbox - jQuery jwwUI Copyright (c) 2013-2015 www.jeeww.com. All rights
 * reserved. Licensed under the GPL or commercial licenses
 */
(function($) {
	function createNumberBox(target) {
		$(target).addClass("numberbox-f");
		var v = $("<input type=\"hidden\">").insertAfter(target);
		var name = $(target).attr("name");
		if (name) {
			v.attr("name", name);
			$(target).removeAttr("name").attr("numberboxName", name);
		}
		return v;
	}
	;
	function setNumberBoxOtherInfo(target) {
		var defs = $.data(target, "numberbox").defs;
		var fn = defs.onChange;
		defs.onChange = function() {
		};
		setValue(target, defs.parser.call(target, defs.value));
		defs.onChange = fn;
		defs.originalValue = getValue(target);
	}
	;
	function getValue(target) {
		return $.data(target, "numberbox").field.val();
	}
	;
	function setValue(target, value) {
		var numberbox = $.data(target, "numberbox");
		var defs = numberbox.defs;
		var oldValue = getValue(target);
		value = defs.parser.call(target, value);
		defs.value = value;
		numberbox.field.val(value);
		$(target).val(defs.formatter.call(target, value));
		if (oldValue != value) {
			defs.onChange.call(target, value, oldValue);
		}
	}
	;
	function bindEvent(target) {
		var defs = $.data(target, "numberbox").defs;
		$(target).unbind(".numberbox").bind(
		        "keypress.numberbox",
		        function(e) {
			        if (e.which == 45) {
				        if ($(this).val().indexOf("-") == -1) {
					        return true;
				        } else {
					        return false;
				        }
			        }
			        if (e.which == 46) {
				        if ($(this).val().indexOf(".") == -1) {
					        return true;
				        } else {
					        return false;
				        }
			        } else {
				        if ((e.which >= 48 && e.which <= 57 && e.ctrlKey == false && e.shiftKey == false)
				                || e.which == 0 || e.which == 8) {
					        return true;
				        } else {
					        if (e.ctrlKey == true && (e.which == 99 || e.which == 118)) {
						        return true;
					        } else {
						        return false;
					        }
				        }
			        }
		        }).bind("blur.numberbox", function() {
			setValue(target, $(this).val());
			$(this).val(defs.formatter.call(target, getValue(target)));
		}).bind("focus.numberbox", function() {
			var vv = getValue(target);
			if ($(this).val() != vv) {
				$(this).val(vv);
			}
		});
	}
	;
	function validateNumberBox(target) {
		if ($.fn.inputbox) {
			var defs = $.data(target, "numberbox").defs;
			$(target).inputbox(defs);
		}
	}
	;
	function enableOrDisable(target, flag) {
		var defs = $.data(target, "numberbox").defs;
		if (flag) {
			defs.disabled = true;
			$(target).attr("disabled", true);
		} else {
			defs.disabled = false;
			$(target).removeAttr("disabled");
		}
	}
	;
	$.fn.numberbox = function(defs, param) {
		if (typeof defs == "string") {
			var fun = $.fn.numberbox.methods[defs];
			if (fun) {
				return fun(this, param);
			} else {
				return this.inputbox(defs, param);
			}
		}
		defs = defs || {};
		return this.each(function() {
			var numberbox = $.data(this, "numberbox");
			if (numberbox) {
				$.extend(numberbox.defs, defs);
			} else {
				var thisDefs = $.fn.numberbox.getDefs(this);
				var xxx = $.extend({}, $.fn.numberbox.defaults, thisDefs, defs);
				if (defs.increment) {
					$(this).removeClass("inputbox-text-border");
				}
				numberbox = $.data(this, "numberbox", {
				    defs : xxx,
				    field : createNumberBox(this)
				});
				$(this).removeAttr("disabled");
				$(this).css({
					imeMode : "disabled"
				});
			}
			enableOrDisable(this, numberbox.defs.disabled);
			bindEvent(this);
			validateNumberBox(this);
			setNumberBoxOtherInfo(this);
		});
	};
	$.fn.numberbox.methods = {
	    defs : function(jq) {
		    return $.data(jq[0], "numberbox").defs;
	    },
	    destroy : function(jq) {
		    return jq.each(function() {
			    $.data(this, "numberbox").field.remove();
			    $(this).inputbox("destroy");
			    $(this).remove();
		    });
	    },
	    disable : function(jq) {
		    return jq.each(function() {
			    enableOrDisable(this, true);
		    });
	    },
	    enable : function(jq) {
		    return jq.each(function() {
			    enableOrDisable(this, false);
		    });
	    },
	    fix : function(jq) {
		    return jq.each(function() {
			    setValue(this, $(this).val());
		    });
	    },
	    setValue : function(jq, _1d) {
		    return jq.each(function() {
			    setValue(this, _1d);
		    });
	    },
	    getValue : function(jq) {
		    return getValue(jq[0]);
	    },
	    clear : function(jq) {
		    return jq.each(function() {
			    var numberbox = $.data(this, "numberbox");
			    numberbox.field.val("");
			    $(this).val("");
		    });
	    },
	    reset : function(jq) {
		    return jq.each(function() {
			    var defs = $(this).numberbox("defs");
			    $(this).numberbox("setValue", defs.originalValue);
		    });
	    }
	};
	$.fn.numberbox.getDefs = function(target) {
		var t = $(target);
		return $.extend({}, $.fn.inputbox.getDefs(target), $.parser.getDefs(target, [
		        "decimalSeparator", "groupSeparator", "suffix", {
		            min : "number",
		            max : "number",
		            precision : "number"
		        } ]), {
		    prefix : (t.attr("prefix") ? t.attr("prefix") : undefined),
		    disabled : (t.attr("disabled") ? true : undefined),
		    value : (t.val() || undefined)
		});
	};
	$.fn.numberbox.defaults = $.extend({}, $.fn.inputbox.defaults, {
	    disabled : false,
	    border : false,
	    value : "",
	    min : null,
	    max : null,
	    precision : 0,
	    decimalSeparator : ".",
	    groupSeparator : "",
	    prefix : "",
	    suffix : "",
	    formatter : function(value) {
		    if (!value) {
			    return value;
		    }
		    value = value + "";
		    var defs = $(this).numberbox("defs");
		    var s1 = value, s2 = "";
		    var index = value.indexOf(".");
		    if (index >= 0) {
			    s1 = value.substring(0, index);
			    s2 = value.substring(index + 1, value.length);
		    }
		    if (defs.groupSeparator) {
			    var p = /(\d+)(\d{3})/;
			    while (p.test(s1)) {
				    s1 = s1.replace(p, "$1" + defs.groupSeparator + "$2");
			    }
		    }
		    if (s2) {
			    return defs.prefix + s1 + defs.decimalSeparator + s2 + defs.suffix;
		    } else {
			    return defs.prefix + s1 + defs.suffix;
		    }
	    },
	    parser : function(value) {
		    value = value + "";
		    var defs = $(this).numberbox("defs");
		    if (defs.groupSeparator) {
			    value = value.replace(new RegExp("\\" + defs.groupSeparator, "g"), "");
		    }
		    if (defs.decimalSeparator) {
			    value = value.replace(new RegExp("\\" + defs.decimalSeparator, "g"), ".");
		    }
		    if (defs.prefix) {
			    value = value.replace(new RegExp("\\" + $.trim(defs.prefix), "g"), "");
		    }
		    if (defs.suffix) {
			    value = value.replace(new RegExp("\\" + $.trim(defs.suffix), "g"), "");
		    }
		    value = value.replace(/\s/g, "");
		    var val = parseFloat(value).toFixed(defs.precision);
		    if (isNaN(val)) {
			    val = "";
		    } else {
			    if (typeof (defs.min) == "number" && val < defs.min) {
				    val = defs.min.toFixed(defs.precision);
			    } else {
				    if (typeof (defs.max) == "number" && val > defs.max) {
					    val = defs.max.toFixed(defs.precision);
				    }
			    }
		    }
		    return val;
	    },
	    onChange : function(newValue, oldValue) {
	    }
	});
})(jQuery);
