﻿/**
 * numberspinner - jQuery jwwUI Copyright (c) 2013-2015 www.jeeww.com. All
 * rights reserved. Licensed under the GPL or commercial licenses
 */
(function($) {
	function create(target) {
		$(target).addClass("numberspinner-f");
		var defs = $.data(target, "numberspinner").defs;
		if (defs.border) {
			$(target).spinner(defs);
			defs.border = false;// delete numberbox text border.
			$(target).numberbox(defs);
		} else {
			$(target).spinner(defs).numberbox(defs);
		}
	}
	;
	function incrementValue(target, opFlag) {
		var defs = $.data(target, "numberspinner").defs;
		var v = parseFloat($(target).numberbox("getValue") || defs.value) || 0;
		if (opFlag == true) {
			v -= defs.increment;
		} else {
			v += defs.increment;
		}
		$(target).numberbox("setValue", v);
	}
	;
	$.fn.numberspinner = function(defs, param) {
		if (typeof defs == "string") {
			var fun = $.fn.numberspinner.methods[defs];
			if (fun) {
				return fun(this, param);
			} else {
				return this.spinner(defs, param);
			}
		}
		defs = defs || {};
		return this.each(function() {
			var numberspinner = $.data(this, "numberspinner");
			if (numberspinner) {
				$.extend(numberspinner.defs, defs);
			} else {
				$.data(this, "numberspinner", {
					defs : $.extend({}, $.fn.numberspinner.defaults, $.fn.numberspinner.getDefs(this),
					        defs)
				});
			}
			create(this);
		});
	};
	$.fn.numberspinner.methods = {
	    defs : function(jq) {
		    var defs = $.data(jq[0], "numberspinner").defs;
		    return $.extend(defs, {
		        value : jq.numberbox("getValue"),
		        originalValue : jq.numberbox("defs").originalValue
		    });
	    },
	    setValue : function(jq, value) {
		    return jq.each(function() {
			    $(this).numberbox("setValue", value);
		    });
	    },
	    getValue : function(jq) {
		    return jq.numberbox("getValue");
	    },
	    clear : function(jq) {
		    return jq.each(function() {
			    $(this).spinner("clear");
			    $(this).numberbox("clear");
		    });
	    },
	    reset : function(jq) {
		    return jq.each(function() {
			    var defs = $(this).numberspinner("defs");
			    $(this).numberspinner("setValue", defs.originalValue);
		    });
	    }
	};
	$.fn.numberspinner.getDefs = function(target) {
		return $.extend({}, $.fn.spinner.getDefs(target), $.fn.numberbox.getDefs(target), {});
	};
	$.fn.numberspinner.defaults = $.extend({}, $.fn.spinner.defaults, $.fn.numberbox.defaults, {
	    border : false,
	    spin : function(opFlag) {
		    incrementValue(this, opFlag);
	    }
	});
})(jQuery);
