﻿/**
 * textareabox - jQuery jwwUI Copyright (c) 2013-2015 www.jeeww.com. All rights reserved. 
 * Licensed under the GPL or commercial licenses 
 */
(function($) {
	function setSize(target, sizeValue) {
		var textareaboxDefs = $.data(target, "textareabox").defs;
		var textareaboxObj = $.data(target, "textareabox").textareabox;
		if (sizeValue) {
			textareaboxDefs.width = sizeValue;
		} else {
			var clientWidth = $(target).parent()._outerWidth();
			textareaboxObj._outerWidth(clientWidth - 3);
		}
		textareaboxObj.appendTo("body");
		var textareaboxTextObj = textareaboxObj.find("input.textareabox-text");
		var textareaboxIconObj = textareaboxObj.find(".textareabox-icon");
		var iconWidth = textareaboxDefs.hasIcon ? textareaboxIconObj._outerWidth() : 0;
		textareaboxObj._outerWidth(textareaboxDefs.width)._outerHeight(textareaboxDefs.height);
		textareaboxTextObj._outerWidth(textareaboxObj.width() - iconWidth);
		textareaboxTextObj.css({ height : textareaboxObj.height() + "px", lineHeight : textareaboxObj.height() + "px" });
		textareaboxIconObj._outerHeight(textareaboxObj.height());
		textareaboxObj.insertAfter(target);
	}
	;
	function createTextareaboxObj(target, defs) {
		$(target).addClass("textareabox-text");
		$(target).addClass("textareabox-f");
		var textareaboxObj = null;
		if (defs.border) {
			textareaboxObj = $("<span class=\"textareabox\" style=\"border-width:1px\"></span>").insertAfter(target);
		} else {
			textareaboxObj = $("<span class=\"textareabox\"></span>").insertAfter(target);
		}
		return { textareabox : textareaboxObj };
	}
	;
	function destroy(target) {
		var textareaboxTextObj = $.data(target, "textareabox").textareabox.find("input.textareabox-text");
		textareaboxTextObj.inputbox("destroy");
		$.data(target, "textareabox").textareabox.remove();
		$(target).remove();
	}
	;
	function bindEvents(target) {
		var textareaboxObj = $.data(target, "textareabox");
		var textareaboxDefs = textareaboxObj.defs;
		var textareaboxObjInner = $.data(target, "textareabox").textareabox;
		var textareaboxText = textareaboxObjInner.find(".textareabox-text");
		var textareaboxIcon = textareaboxObjInner.find(".textareabox-icon");
		$(document).unbind(".textareabox").bind("mousedown.textareabox", function(e) {

		});
		textareaboxObjInner.unbind(".textareabox");
		textareaboxText.unbind(".textareabox");
		textareaboxIcon.unbind(".textareabox");
		if (!textareaboxDefs.disabled) {
			textareaboxText.bind("mousedown.textareabox", function(e) {
				e.stopPropagation();
			}).bind("keydown.textareabox", function(e) {
				switch (e.keyCode) {
					case 38:
						textareaboxDefs.keyHandler.up.call(target);
						break;
					case 40:
						textareaboxDefs.keyHandler.down.call(target);
						break;
					case 13:
						e.preventDefault();
						textareaboxDefs.keyHandler.enter.call(target);
						return false;
					case 9:
					case 27:
						break;
					default:
						if (textareaboxDefs.editable) {
							if (textareaboxObj.timer) {
								clearTimeout(textareaboxObj.timer);
							}
							textareaboxObj.timer = setTimeout(function() {
								var q = textareaboxText.val();
								if (textareaboxObj.previousValue != q) {
									textareaboxObj.previousValue = q;
									textareaboxDefs.keyHandler.query.call(target, textareaboxText.val());
									validate(target, true);
								}
							}, textareaboxDefs.delay);
						}
				}
			});
			textareaboxIcon.bind("click.textareabox", function() {
				textareaboxDefs.value = textareaboxText.val();
				var name = textareaboxText.attr("name");
				textareaboxDefs.searcher.call(target, textareaboxDefs.value, name);
				textareaboxText.focus();
			}).bind("mouseenter.textareabox", function() {
				$(this).addClass("textareabox-icon-hover");
			}).bind("mouseleave.textareabox", function() {
				$(this).removeClass("textareabox-icon-hover");
			}).bind("mousedown.textareabox", function() {
			});
		}
	}
	;
	function validate(target, validateFlag) {
		var textareaboxDefs = $.data(target, "textareabox").defs;
		var textareaboxObj = $.data(target, "textareabox").textareabox.find("input.textareabox-text");
		textareaboxObj.inputbox(textareaboxDefs);
		if (validateFlag) {
			textareaboxObj.inputbox("validate");
		}
	}
	;
	function setDisabled(target, flag) {
		var textareaboxDefs = $.data(target, "textareabox").defs;
		var textareaboxObj = $.data(target, "textareabox").textareabox;
		if (flag) {
			textareaboxDefs.disabled = true;
			$(target).attr("disabled", true);
			textareaboxObj.find(".textareabox-text").attr("disabled", true);
		} else {
			textareaboxDefs.disabled = false;
			$(target).removeAttr("disabled");
			textareaboxObj.find(".textareabox-text").removeAttr("disabled");
		}
	}
	;
	function clear(target) {
		var textareaboxObj = $.data(target, "textareabox").textareabox;
		textareaboxObj.find("input.textareabox-text").val("");
	}
	;
	function getTextareaboxValue(target) {
		var textareaboxObj = $.data(target, "textareabox").textareabox;
		return textareaboxObj.find("input.textareabox-text").val();
	}
	;
	function setTextareaboxValue(target, textValue) {
		var textareaboxObj = $.data(target, "textareabox").textareabox;
		textareaboxObj.find("input.textareabox-text").val(textValue);
		validate(target, true);
		$.data(target, "textareabox").previousValue = textValue;
	}
	;
	function textareaboxOnChange(textareaboxObj) {
		var textareaboxDefs = $.data(textareaboxObj, "textareabox").defs;
		var fn = textareaboxDefs.onChange;
		textareaboxDefs.onChange = function() {
		};
		setTextareaboxValue(textareaboxObj, textareaboxDefs.value);
		textareaboxDefs.originalValue = textareaboxDefs.value;
		textareaboxDefs.onChange = fn;
	}
	;
	$.fn.textareabox = function(defs, param) {
		if (typeof defs == "string") {
			return $.fn.textareabox.methods[defs](this, param);
		}
		defs = defs || {};
		return this.each(function() {
			var textareaboxObj = $.data(this, "textareabox");
			if (textareaboxObj) {
				$.extend(textareaboxObj.defs, defs);
			} else {
				var newDefs = $.extend({}, $.fn.textareabox.defaults, $.fn.textareabox.getDefs(this), defs);
				var r = createTextareaboxObj(this, newDefs);
				textareaboxObj = $.data(this, "textareabox", { defs : newDefs, textareabox : r.textareabox,
					previousValue : null });
				$(this).removeAttr("disabled");
			}
			$("input.textareabox-text", textareaboxObj.textareabox).attr("readonly", !textareaboxObj.defs.editable);
			setDisabled(this, textareaboxObj.defs.disabled);
			setSize(this);
			bindEvents(this);
			validate(this);
			textareaboxOnChange(this);
		});
	};
	$.fn.textareabox.methods = { defs : function(jq) {
		return $.data(jq[0], "textareabox").defs;
	}, textbox : function(jq) {
		return $.data(jq[0], "textareabox").textareabox.find("input.textareabox-text");
	}, destroy : function(jq) {
		return jq.each(function() {
			destroy(this);
		});
	}, resize : function(jq, width) {
		return jq.each(function() {
			setSize(this, width);
		});
	}, disable : function(jq) {
		return jq.each(function() {
			setDisabled(this, true);
			bindEvents(this);
		});
	}, enable : function(jq) {
		return jq.each(function() {
			setDisabled(this, false);
			bindEvents(this);
		});
	}, validate : function(jq) {
		return jq.each(function() {
			validate(this, true);
		});
	}, isValid : function(jq) {
		var textareaboxTextObj = $.data(jq[0], "textareabox").textareabox.find("input.textareabox-text");
		return textareaboxTextObj.inputbox("isValid");
	}, clear : function(jq) {
		return jq.each(function() {
			clear(this);
		});
	}, reset : function(jq) {
		return jq.each(function() {
			var textareaboxDefs = $.data(this, "textareabox").defs;
			$(this).textareabox("setValue", textareaboxDefs.originalValue);
		});
	}, getValue : function(jq) {
		return getTextareaboxValue(jq[0]);
	}, setValue : function(jq, v) {
		return jq.each(function() {
			setTextareaboxValue(this, v);
		});
	} };
	$.fn.textareabox.getDefs = function(target) {
		var t = $(target);
		return $.extend({}, $.fn.inputbox.getDefs(target), $.parser.getDefs(target, [ "width", "height",
				"separator", { editable : "boolean", hasIcon : "boolean", delay : "number" } ]), {
			multiple : (t.attr("multiple") ? true : undefined), disabled : (t.attr("disabled") ? true : undefined),
			value : (t.val() || undefined), searcher : (t.attr("searcher") ? $.parser.localEval(t.attr("searcher")) : undefined) });
	};
	$.fn.textareabox.defaults = $.extend({}, $.fn.inputbox.defaults, { border : false, width : "auto", height : 60,
		multiple : false, separator : ",", editable : true, disabled : false, value : "", delay : 200,
		keyHandler : { up : function() {
		}, down : function() {
		}, enter : function() {
		}, query : function(q) {
		} }, onChange : function(_60, _61) {
		} });
})(jQuery);
