﻿/**
 * timespinner - jQuery jwwUI Copyright (c) 2013-2015 www.jeeww.com. All rights
 * reserved. Licensed under the GPL or commercial licenses
 */
(function($) {
	function create(target) {
		var defs = $.data(target, "timespinner").defs;
		$(target).addClass("timespinner-f");
		$(target).spinner(defs);
		$(target).unbind(".timespinner");
		$(target).bind("click.timespinner", function() {
			var startNum = 0;
			if (this.selectionStart != null) {
				startNum = this.selectionStart;
			} else {
				if (this.createTextRange) {
					var textRange = target.createTextRange();
					var s = document.selection.createRange();
					s.setEndPoint("StartToStart", textRange);
					startNum = s.text.length;
				}
			}
			if (startNum >= 0 && startNum <= 2) {
				defs.highlight = 0;
			} else {
				if (startNum >= 3 && startNum <= 5) {
					defs.highlight = 1;
				} else {
					if (startNum >= 6 && startNum <= 8) {
						defs.highlight = 2;
					}
				}
			}
			handelRange(target);
		}).bind("blur.timespinner", function() {
			setValue(target);
		});
	}
	;
	function handelRange(target) {
		var defs = $.data(target, "timespinner").defs;
		var startNum = 0, endNum = 0;
		if (defs.highlight == 0) {
			startNum = 0;
			endNum = 2;
		} else {
			if (defs.highlight == 1) {
				startNum = 3;
				endNum = 5;
			} else {
				if (defs.highlight == 2) {
					startNum = 6;
					endNum = 8;
				}
			}
		}
		if (target.selectionStart != null) {
			target.setSelectionRange(startNum, endNum);
		} else {
			if (target.createTextRange) {
				var textRange = target.createTextRange();
				textRange.collapse();
				textRange.moveEnd("character", endNum);
				textRange.moveStart("character", startNum);
				textRange.select();
			}
		}
		$(target).focus();
	}
	;
	function getDateByNum(target, value) {
		var defs = $.data(target, "timespinner").defs;
		if (!value) {
			return null;
		}
		var vv = value.split(defs.separator);
		for ( var i = 0; i < vv.length; i++) {
			if (isNaN(vv[i])) {
				return null;
			}
		}
		while (vv.length < 3) {
			vv.push(0);
		}
		return new Date(1900, 0, 0, vv[0], vv[1], vv[2]);
	}
	;
	function setValue(target) {
		var defs = $.data(target, "timespinner").defs;
		var value = $(target).val();
		var date = getDateByNum(target, value);
		if (!date) {
			date = getDateByNum(target, defs.value);
		}
		if (!date) {
			defs.value = "";
			$(target).val("");
			return;
		}
		var dateMin = getDateByNum(target, defs.min);
		var dateMax = getDateByNum(target, defs.max);
		if (dateMin && dateMin > date) {
			date = dateMin;
		}
		if (dateMax && dateMax < date) {
			date = dateMax;
		}
		var tt = [ getNum(date.getHours()), getNum(date.getMinutes()) ];
		if (defs.showSeconds) {
			tt.push(getNum(date.getSeconds()));
		}
		var val = tt.join(defs.separator);
		defs.value = val;
		$(target).val(val);
		function getNum(num) {
			return (num < 10 ? "0" : "") + num;
		}
		;
	}
	;
	function highlightTimespinner(target, number) {
		var defs = $.data(target, "timespinner").defs;
		var val = $(target).val();
		if (val == "") {
			val = [ 0, 0, 0 ].join(defs.separator);
		}
		var vv = val.split(defs.separator);
		for ( var i = 0; i < vv.length; i++) {
			vv[i] = parseInt(vv[i], 10);
		}
		if (number == true) {
			vv[defs.highlight] -= defs.increment;
		} else {
			vv[defs.highlight] += defs.increment;
		}
		$(target).val(vv.join(defs.separator));
		setValue(target);
		handelRange(target);
	}
	;
	$.fn.timespinner = function(defs, param) {
		if (typeof defs == "string") {
			var fun = $.fn.timespinner.methods[defs];
			if (fun) {
				return fun(this, param);
			} else {
				return this.spinner(defs, param);
			}
		}
		defs = defs || {};
		return this.each(function() {
			var timespinner = $.data(this, "timespinner");
			if (timespinner) {
				$.extend(timespinner.defs, defs);
			} else {
				$.data(this, "timespinner", {
					defs : $.extend({}, $.fn.timespinner.defaults, $.fn.timespinner.getDefs(this),
					        defs)
				});
				create(this);
			}
		});
	};
	$.fn.timespinner.methods = {
	    defs : function(jq) {
		    var defs = $.data(jq[0], "timespinner").defs;
		    return $.extend(defs, {
		        value : jq.val(),
		        originalValue : jq.spinner("defs").originalValue
		    });
	    },
	    setValue : function(jq, v) {
		    return jq.each(function() {
			    $(this).val(v);
			    setValue(this);
		    });
	    },
	    getHours : function(jq) {
		    var defs = $.data(jq[0], "timespinner").defs;
		    var vv = jq.val().split(defs.separator);
		    return parseInt(vv[0], 10);
	    },
	    getMinutes : function(jq) {
		    var defs = $.data(jq[0], "timespinner").defs;
		    var vv = jq.val().split(defs.separator);
		    return parseInt(vv[1], 10);
	    },
	    getSeconds : function(jq) {
		    var defs = $.data(jq[0], "timespinner").defs;
		    var vv = jq.val().split(defs.separator);
		    return parseInt(vv[2], 10) || 0;
	    }
	};
	$.fn.timespinner.getDefs = function(target) {
		return $.extend({}, $.fn.spinner.getDefs(target), $.parser.getDefs(target, [ "separator", {
		    showSeconds : "boolean",
		    highlight : "number"
		} ]));
	};
	$.fn.timespinner.defaults = $.extend({}, $.fn.spinner.defaults, {
	    border : false,
	    separator : ":",
	    showSeconds : false,
	    highlight : 0,
	    spin : function(number) {
		    highlightTimespinner(this, number);
	    }
	});
})(jQuery);
