/*
 * Decompiled with CFR 0.152.
 */
package org.zergle.json;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.zergle.json.JsonObject;

public final class JsonArray
extends JsonObject {
    static final JsonObject NAN = null;
    private List<JsonObject> elements = new ArrayList<JsonObject>();

    public JsonArray() {
    }

    public JsonArray(Iterable<?> it) {
        this();
        if (it != null) {
            Iterator<?> i = it.iterator();
            while (i.hasNext()) {
                this.elements.add(JsonArray.valueOf(i.next()));
            }
        }
    }

    public JsonArray(Enumeration<?> e) {
        this();
        if (e != null) {
            while (e.hasMoreElements()) {
                this.elements.add(JsonArray.valueOf(e.nextElement()));
            }
        }
    }

    public JsonArray(Iterator<?> it) {
        this();
        if (it != null) {
            while (it.hasNext()) {
                this.elements.add(JsonArray.valueOf(it.next()));
            }
        }
    }

    public JsonArray(boolean ... booleans) {
        this();
        for (int i = 0; i < booleans.length; ++i) {
            this.elements.add(JsonArray.valueOf(booleans[i]));
        }
    }

    public JsonArray(byte ... bytes) {
        this();
        for (int i = 0; i < bytes.length; ++i) {
            this.elements.add(JsonArray.valueOf(bytes[i]));
        }
    }

    public JsonArray(char ... chars) {
        this();
        for (int i = 0; i < chars.length; ++i) {
            this.elements.add(JsonArray.valueOf(chars[i]));
        }
    }

    public JsonArray(short ... shorts) {
        this();
        for (int i = 0; i < shorts.length; ++i) {
            this.elements.add(JsonArray.valueOf(shorts[i]));
        }
    }

    public JsonArray(int ... ints) {
        this();
        for (int i = 0; i < ints.length; ++i) {
            this.elements.add(JsonArray.valueOf(ints[i]));
        }
    }

    public JsonArray(long ... longs) {
        this();
        for (int i = 0; i < longs.length; ++i) {
            this.elements.add(JsonArray.valueOf(longs[i]));
        }
    }

    public JsonArray(float ... floats) {
        this();
        for (int i = 0; i < floats.length; ++i) {
            this.elements.add(JsonArray.valueOf(floats[i]));
        }
    }

    public JsonArray(double ... doubles) {
        this();
        for (int i = 0; i < doubles.length; ++i) {
            this.elements.add(JsonArray.valueOf(doubles[i]));
        }
    }

    public JsonArray(Object ... objects) {
        this();
        if (objects != null) {
            for (int i = 0; i < objects.length; ++i) {
                this.elements.add(JsonArray.valueOf(objects[i]));
            }
        }
    }

    public Collection<JsonObject> elements() {
        return this.elements;
    }

    public void add(JsonObject json) {
        this.elements.add(json);
    }

    public void remove(JsonObject json) {
        this.elements.remove(json);
    }

    public void remove(int index) throws UnsupportedOperationException, IndexOutOfBoundsException {
        this.elements.remove(index);
    }

    public JsonObject get(int index) throws IndexOutOfBoundsException {
        return this.elements.get(index);
    }

    public int size() {
        return this.elements.size();
    }

    @Override
    public String toJsonString() {
        StringBuffer buff = new StringBuffer();
        buff.append("[");
        Iterator<JsonObject> it = this.elements.iterator();
        while (it.hasNext()) {
            JsonObject json = it.next();
            buff.append(json.toJsonString());
            if (!it.hasNext()) continue;
            buff.append(", ");
        }
        return buff.append("]").toString();
    }
}

