/*
 * Decompiled with CFR 0.152.
 */
package org.zergle.json;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.zergle.json.JsonObject;

public class JsonNumber
extends JsonObject {
    public static final JsonNumber POSITIVE_INFINITY = new PositiveInfinity();
    public static final JsonNumber NEGATIVE_INFINITY = new NegativeInfinity();
    public static final JsonNumber NAN = new NotANumber();
    private Number number;

    private JsonNumber() {
    }

    public JsonNumber(Number num) {
        this.number = num == null ? (Number)0 : (Number)num;
    }

    public JsonNumber(String value) throws NumberFormatException {
        try {
            char c = value.charAt(0);
            int offset = 0;
            if (c == '-') {
                offset = 1;
                c = value.charAt(offset);
            }
            if (c == '0') {
                if (value.length() > offset + 1) {
                    c = value.charAt(offset + 1);
                    if (c == 'x' || c == 'X') {
                        value = value.substring(2);
                        this.number = new BigInteger(value, 16);
                    } else {
                        this.number = value.matches("^\\-?[0-7]+$") ? new BigInteger(value, 8) : new BigDecimal(value);
                    }
                } else {
                    this.number = 0;
                }
            } else {
                this.number = new BigDecimal(value);
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new NumberFormatException("zero length JsonNumber");
        }
    }

    public int hashCode() {
        return this.number.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof JsonNumber) {
            JsonNumber num = (JsonNumber)obj;
            return this.number.equals(num.number);
        }
        return false;
    }

    @Override
    public String toJsonString() {
        if (JsonNumber.isNaN(this)) {
            return "undefined";
        }
        return String.valueOf(this.number);
    }

    private static final class NotANumber
    extends JsonNumber {
        private NotANumber() {
        }

        @Override
        public boolean equals(Object obj) {
            return false;
        }

        @Override
        public String toJsonString() {
            return "NaN";
        }
    }

    private static final class NegativeInfinity
    extends JsonNumber {
        private NegativeInfinity() {
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof NegativeInfinity;
        }

        @Override
        public String toJsonString() {
            return "-Infinity";
        }
    }

    private static final class PositiveInfinity
    extends JsonNumber {
        private PositiveInfinity() {
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof PositiveInfinity;
        }

        @Override
        public String toJsonString() {
            return "Infinity";
        }
    }
}

