/*
 * Decompiled with CFR 0.152.
 */
package org.zergle.json;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.zergle.json.JsonArray;
import org.zergle.json.JsonBoolean;
import org.zergle.json.JsonNumber;
import org.zergle.json.JsonString;
import org.zergle.json.lex.JsonConstant;
import org.zergle.json.utils.ArrayConverter;
import org.zergle.json.utils.BooleanConverter;
import org.zergle.json.utils.CharSequenceConverter;
import org.zergle.json.utils.DateConverter;
import org.zergle.json.utils.JsonConverter;
import org.zergle.json.utils.MapConverter;
import org.zergle.json.utils.NumberConverter;
import org.zergle.json.utils.ObjectConverter;

public class JsonObject
implements JsonConstant {
    private static final String PATTERN_ID = "^[\\$_a-zA-Z][0-9a-zA-Z_\\$]*$";
    private static final String PATTERN_NUMBER = "^((\\-)?(\\d+.)?(\\d+)([eE][\\+\\-]\\d+)?)?$";
    public static final JsonObject NULL = new JsonNull();
    public static final JsonObject NAN = new NaN();
    private Map<CharSequence, JsonObject> members = new HashMap<CharSequence, JsonObject>();
    private static Map<Class<?>, JsonConverter<? extends JsonObject>> converters = new HashMap();

    public JsonObject() {
    }

    public JsonObject(Map<?, ?> map) {
        this();
        if (map != null) {
            for (Object key : map.keySet()) {
                String prop = String.valueOf(key);
                JsonObject value = JsonObject.valueOf(map.get(key));
                this.members.put(prop, value);
            }
        }
    }

    public Iterator<CharSequence> getPropertyNames() {
        return this.members.keySet().iterator();
    }

    public JsonObject get(CharSequence propertyName) {
        return this.members.get(propertyName);
    }

    public static JsonObject valueOf(boolean b) {
        return new JsonBoolean(b);
    }

    public static JsonObject valueOf(byte b) {
        return new JsonNumber(b);
    }

    public static JsonObject valueOf(short s) {
        return new JsonNumber(s);
    }

    public static JsonObject valueOf(char c) {
        return new JsonString(Character.valueOf(c));
    }

    public static JsonObject valueOf(int i) {
        return new JsonNumber(i);
    }

    public static JsonObject valueOf(long l) {
        return new JsonNumber(l);
    }

    public static JsonObject valueOf(float f) {
        return new JsonNumber(Float.valueOf(f));
    }

    public static JsonObject valueOf(double d) {
        return new JsonNumber(d);
    }

    public static JsonObject valueOf(Object object) {
        if (object == null) {
            return NULL;
        }
        Class[] classes = new Class[converters.keySet().size()];
        converters.keySet().toArray(classes);
        Class moreAccurate = null;
        for (int i = 0; i < classes.length; ++i) {
            if (!classes[i].isAssignableFrom(object.getClass())) continue;
            if (moreAccurate == null) {
                moreAccurate = classes[i];
                continue;
            }
            if (moreAccurate.isAssignableFrom(classes[i])) {
                moreAccurate = classes[i];
                continue;
            }
            if (classes[i].isInterface() && !moreAccurate.isInterface()) {
                moreAccurate = classes[i];
                continue;
            }
            if (!classes[i].isInterface() || !moreAccurate.isInterface()) continue;
            moreAccurate = classes[i].getSimpleName().compareTo(moreAccurate.getSimpleName()) > 0 ? classes[i] : moreAccurate;
        }
        return converters.get(moreAccurate).convert(object);
    }

    public static boolean isNaN(JsonObject json) {
        if (!json.equals(json)) {
            return true;
        }
        if (json instanceof JsonNumber || json instanceof JsonBoolean) {
            return false;
        }
        if (json instanceof JsonString) {
            return !((JsonString)json).match(PATTERN_NUMBER);
        }
        if (json instanceof JsonArray) {
            JsonArray ja = (JsonArray)json;
            for (JsonObject ele : ja.elements()) {
                if (!JsonObject.isNaN(ele)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean isFinite(JsonObject json) {
        return !JsonObject.isNaN(json) || json.equals(JsonNumber.POSITIVE_INFINITY) && json.equals(JsonNumber.NEGATIVE_INFINITY);
    }

    public static boolean isIdentifier(CharSequence id) {
        if (id == null) {
            return false;
        }
        String s = String.valueOf(id);
        return s.matches(PATTERN_ID) && !JsonObject.isKeyword(s);
    }

    public static final boolean isKeyword(String word) {
        if (word == null) {
            return false;
        }
        return KEYWORDS.contains(word = word.trim());
    }

    public static void register(JsonConverter<? extends JsonObject> converter) {
        if (converter != null) {
            Class<?>[] classes = converter.getAcceptTypes();
            for (int i = 0; i < classes.length; ++i) {
                converters.put(classes[i], converter);
            }
        }
    }

    public String toJsonString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        Iterator<CharSequence> iterator = this.members.keySet().iterator();
        while (iterator.hasNext()) {
            CharSequence property = iterator.next();
            if (!JsonObject.isIdentifier(property)) {
                sb.append("\"").append(property).append("\"");
            } else {
                sb.append(property);
            }
            sb.append(":");
            sb.append(String.valueOf(this.members.get(property)));
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public String toString() {
        return this.toJsonString();
    }

    static {
        JsonObject.register(new ArrayConverter());
        JsonObject.register(new BooleanConverter());
        JsonObject.register(new CharSequenceConverter());
        JsonObject.register(new DateConverter());
        JsonObject.register(new MapConverter());
        JsonObject.register(new NumberConverter());
        JsonObject.register(new ObjectConverter());
        JsonObject.register((JsonConverter<? extends JsonObject>)new JsonConverter<JsonObject>(){

            @Override
            public JsonObject convert(Object object) {
                return (JsonObject)object;
            }

            @Override
            public Class<?>[] getAcceptTypes() {
                return new Class[]{JsonObject.class};
            }
        });
    }

    private static final class NaN
    extends JsonObject {
        private NaN() {
        }

        public boolean equals(Object obj) {
            return false;
        }

        @Override
        public String toJsonString() {
            return "NaN";
        }
    }

    private static final class JsonNull
    extends JsonObject {
        private JsonNull() {
        }

        protected Object clone() {
            return this;
        }

        public boolean equals(Object obj) {
            return obj == this;
        }

        @Override
        public String toJsonString() {
            return "null";
        }
    }
}

